(*----------------------------------------------------------------------(C)-*)
(* Copyright (C) 2006-2016 Konstantin Korovin and The University of Manchester. 
   This file is part of iProver - a theorem prover for first-order logic.

   iProver is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 2 of the License, or 
   (at your option) any later version.
   iProver is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
   See the GNU General Public License for more details.
   You should have received a copy of the GNU General Public License
   along with iProver.  If not, see <http://www.gnu.org/licenses/>.         *)
(*----------------------------------------------------------------------[C]-*)






type term = Term.term

(* returns cequal if t greater or equal to s and 
   returns cequal+1 if t is strictly greater
   returns cequal-1 if these are not the case*)    

val simple_kbo : term -> term -> int 

(* first pred precedence; then simple_kbo *)
val simple_kbo_pred : term -> term -> int 



module Kbo : sig
   (** [simple_kbo t s == cequal+1] *)
   val (>) : term -> term -> bool

   (** [simple_kbo t s == cequal] *)
   val (>=) : term -> term -> bool

   (** [simple_kbo t s == cequal-1] *)
   val (>=!) : term -> term -> bool
end

module Kbo_pred : sig
   (** [simple_kbo_pred t s == cequal+1] *)
   val (>) : term -> term -> bool

   (** [simple_kbo_pred t s == cequal] *)
   val (>=) : term -> term -> bool

   (** [simple_kbo_pred t s == cequal-1] *)
   val (>=!) : term -> term -> bool
end
(* 
(** As [Kbo.(>)] *)
val (>) : term -> term -> bool

(** As [Kbo.(>=)] *)
val (>=) : term -> term -> bool

(** As [Kbo.(>=!)] *)
val (>=!) : term -> term -> bool
 *)

include module type of Kbo
