# iProver Interactive Mode (see first README.md for [iProver](https://gitlab.com/korovin/iprover))

In interactive iProver communicates with an external agent (e.g., ML-based, that can be written in any language e.g., Python) via TCP/IP sockets. External agent can be used to provide proof search guidance by either assigning scores to clauses which are used for prioritising them for next inferences or explicitly selecting the given clause for the next inferences.

Communication is bi-directional: 

1. iProver submits different messages to the agent, such as given clause, generated clauses, simplified clauses etc. 

2. The agent can guide the iProver search by different actions such as selection of the given clause; assigning scores for clauses in passive queues etc.

###  External Agent Server (EA)

An example of external agent is included in iProver distribution: called sockets_server which is mainly used for testing purposes and for showing typical communication trace between iProver and EA.


To start EA example: 

```shell
sockets_server --interactive_mode true --external_ip_address "127.0.0.1" --external_port 12345 
```

sockets_server will wait for the iProver connection (see examples below). 

See src/sockets_server.ml for the source code. 


# Installation of Test EA (sockets_server)

1. cd iprover/ && ./configure
2. make 
3. make sockets_server

To switch off/on debug output modify in src/lib.ml ```let dbg_global_flag = true```
to true/false 

```shell
make clean; make; make sockets_server
```  

# Description

## General

Communication between iProver and EA is done via TCP/IP connection, sending json messages. 
All json messages contain field "tag" which describes messages/actions. 

The EA side should match "tag" with specified values and either do   

a. an internal action,  
b. send json response,  
c. ignore, or  
d. or combination of a)-b)

Before any usage clauses are registered with EA with clause_ids using action 
"tag": "register_clauses" which is send to EA .
EA is expected to store all registered clauses in a map/dictionary or alike. 
(see src/sockets_server.ml for an OCaml example).
In all other communications only clause_ids are used. 

<details>

<summary> Example json "tag": "register_clauses" sent by iProver to EA </summary>

```json
{
  "tag": "register_clauses",
  "clauses": [
    {
      "clause": "cnf(c_83,plain,(~hates(charles,charles)),inference(superposition,[status(thm)],[c_56,c_53])).",
      "clause_id": 83,
      "clause_features": {
        "basic_clause_id": 77,
        "conj_dist": -1,
        "born": 2,
        "horn": true,
        "epr": true
      }
    },
    {
      "clause": "cnf(c_82,plain,(~hates(charles,agatha)),inference(superposition,[status(thm)],[c_55,c_53])).",
      "clause_id": 82,
      "clause_features": {
        "basic_clause_id": 76,
        "conj_dist": -1,
        "born": 2,
        "horn": true,
        "epr": true
      }
    }
  ]
}
```

Running example: Example/PUZ001-1.p

Before the first use clauses are registered with the EA by iProver sending ```"tag": "register_clauses"```
with the list of clauses, where each clause has the following fields:

1. "clause" : clause in TPTP including inference record
2. "clause_id" : id of the clause which will be used in all further communications
3. "clause_features" : a list of features that EA may find useful, but can ignore, including:

   a. "basic_clause_id": this is a clause id seen as a list of literals without the proof object.
      Note that the same clause can be generated by different components (e.g. superposition, instantiation, etc.)
      and these copies will have different clause_ids but the same basic_clause_id.      
   b. "conjecture_distance:" is proof distance from the negated conjecture, -1 if clause is not proof related to the negated conjecture.   
   c. "born": is the iteration when the clause is born in the given clause algorithm   
   d. "horn", "epr": are the corresponding syntactic properties of the clause. 

List of clause features may be extended in the future (all these features can be safely ignored by EA).

</details>


### Currently two modes are implemented:

1. The passive scores mode (PSM)
2. The given clause mode (GCM)


# The passive scores mode (PSM)

This mode is supported in iProver components: superposition/instantiation/resolution

#### PSM overview

#### a) start sockets_server in a separate terminal:

```shell
./sockets_server --interactive_mode true --external_ip_address "127.0.0.1" --external_port 12345 
```

#### b) run iProver in a separate terminal:

```shell
./iproveropt --interactive_mode true --external_ip_address "127.0.0.1" --external_port 12345 --schedule none --preprocessing_flag false --instantiation_flag true --superposition_flag true  --resolution_flag false --sup_iter_deepening 0 --comb_sup_deep_mult 0 --sup_passive_queue_type priority_queues --sup_passive_queues_freq "[1]" --sup_passive_queues "[[+external_score]]"  Examples/PUZ001-1.p
```

In this mode float number scores are assigned by EA to the passive clauses in the superposition component and 
used by iProver in superposition priority queues 
via option ```--sup_passive_queues "[[+external_score]]" ```
    
"+external_score" -- clauses with higher EA score are selected first 

"-external_score" -- clauses with lower EA score are selected first 

#### c) EA scores can be combined with other iProver queue parameters and can be added to several queues: 

```shell
./iproveropt --interactive_mode true --external_ip_address "127.0.0.1" --external_port 12345 --schedule none --preprocessing_flag false --resolution_flag false --instantiation_flag false --superposition_flag true --sup_iter_deepening 0 --comb_sup_deep_mult 0 --sup_passive_queue_type priority_queues --sup_passive_queues_freq  "[4;2;6]" --sup_passive_queues "[[+external_score;-num_symb];[+age;-num_symb];[-conj_dist;+external_score;-num_var]]" Examples/PUZ001-1.p
```
In this example there are 3 priority queues in the superposition component with specified weights and lexicographic combination of priorities. 

#### d) EA scores can be assign in different iProver components (use --sup_ for superposition options and --inst_ for instantiation options): 

```shell
./iproveropt --interactive_mode true --external_ip_address "127.0.0.1" --external_port 12345 --schedule none --preprocessing_flag false --resolution_flag false  --superposition_flag true --sup_iter_deepening 0 --comb_sup_deep_mult 0 --sup_passive_queue_type priority_queues --sup_passive_queues_freq  "[4;2;6]" --sup_passive_queues "[[+external_score;-num_symb];[+age;-num_symb];[-conj_dist;+external_score;-num_var]]" --instantiation_flag true  --sup_passive_queue_type priority_queues --inst_passive_queues_freq  "[4;1]" --inst_passive_queues "[[+external_score;-num_symb];[+age;-num_var]]" --comb_inst_mult 5 --comb_sup_mult 8 Examples/PUZ001-1.p
```

#### Priority scores mode (PSM) details
  
Typical sequence (in a loop) of communication between iProver and EA (as can be seen when run in debug mode above commands). Note that only messages with tags ending in "_req" and "server_queries_start" need response other messages can be ignored by EA. See logs/PUZ001-1.interactive.server.log and logs/PUZ001-1.interactive.iprover.log for an example of communication traces.


1. iProver register clauses

<details>
<summary> ```"tag": "register_clauses"``` </summary>

```json
{
  "tag": "register_clauses",
  "clauses": [
    {
      "clause": "cnf(c_83,plain,(~hates(charles,charles)),inference(superposition,[status(thm)],[c_56,c_53])).",
      "clause_id": 83,
      "clause_features": {
        "basic_clause_id": 77,
        "conj_dist": -1,
        "born": 2,
        "horn": true,
        "epr": true
      }
    },
    {
      "clause": "cnf(c_82,plain,(~hates(charles,agatha)),inference(superposition,[status(thm)],[c_55,c_53])).",
      "clause_id": 82,
      "clause_features": {
        "basic_clause_id": 76,
        "conj_dist": -1,
        "born": 2,
        "horn": true,
        "epr": true
      }
    }
  ]
}
```

</details> 

2. iProver requests priority scores for clauses by sending ```"tag": "scores_req"```

<details>
<summary> "tag": "scores_req" </summary>

```json
{
  "tag": "scores_req",
  "clause_ids": [ 51, 50, 49, 56, 55, 60, 58, 57, 53, 52, 59, 54 ],
  "component": "sup",
  "component_id": 1
}
```

Note several components can be run interleaving fashion, each of which run separate given clause algorithms
(but submit instances to the same SAT solver). Therefore priority scores should be relevant to the component_id.

Currently supported components are: sup, inst, res, input, proof
There could be several components of the same type.

</details>


3. iProver sends ```"tag":"server_queries_start"``` to initiate any EA server queries.

<details>
<summary> ```"tag": "server_queries_start"```  </summary>

```json
{ "tag": "server_queries_start" }
```

EA server can send queries to iProver which can help assign scores to clauses by EA. (See next for types of queries).
</details>


4. EA is expected to send any sequence of queries (which can help EA to score the clauses) of the type:

   a. ```"tag": "cls_sat_eval_gr_req"``` request to evaluate groundings of clauses in the current state of the SAT solver
   
   <details>
   <summary>  ```"tag": "cls_sat_eval_gr_req"```  </summary>

```json
   {
     "tag": "cls_sat_eval_gr_req",
     "clause_ids": [ 51, 50, 49, 56, 55, 60, 58, 57, 53, 52, 59, 54 ]
   }
```
   </details>

   a.1 - iProver responds with ```"tag": "cls_sat_eval_gr_res"``` with lists of literal truth values

  <details>
   <summary>  ```"tag": "cls_sat_eval_gr_res"```  </summary>

```json   
{
  "tag": "cls_sat_eval_gr_res",
  "cause_ids": [ 51, 50, 49, 56, 55, 60, 58, 57, 53, 52, 59, 54 ],
  "sat_lit_gr_vals": [
    [ true ],
    [ true ],
    [ true ],
    [ true ],
    [ true ],
    [ true, true ],
    [ false, true ],
    [ false, true ],
    [ false, false ],
    [ false, false ],
    [ false, true, true ],
    [ false, false, false ]
  ]
}
```

Note that in some clauses all literals are false in the current state of SAT solver.
This is because SAT solver was not called since this clause was generated. 
Next: EA SAT solver calls.

  </details>

   b. EA can request iProver to execute SAT solver:
   
   <details>
   <summary>  ```"tag": "sat_solver_exec_req"```  </summary>

```json
   { "tag": "sat_solver_exec_req" }
```

It is not recommended to call SAT solver too frequently, iProver does SAT calls anyway (based on input options).

 </details>       

    b.1  If SAT solver returns unsat then iProver sends result status in

```json
         { "tag": "sat_solver_exec_res",
           "result": "unsat"
           }
```           
    In this case the theorem is proved and iProver will also send szs result and proof (See below).
    

      b.2 If SAT solver returns sat then iProver

```json
         { "tag": "sat_solver_exec_res",
           "result": "sat"
           }
```           

     Note that clause evaluations can change after the SAT call and in particular at least one literal in each clause will be true. EA may send a. requests again.
     
   <details>
   <summary>  ```"tag": "cls_sat_eval_gr_req"```/ ```"tag": "cls_sat_eval_gr_res"```  </summary>

EA sends:   

```json
   {
     "tag": "cls_sat_eval_gr_req",
     "clause_ids": [ 51, 50, 49, 56, 55, 60, 58, 57, 53, 52, 59, 54 ]
   }
```

iProver sends:

```json
{
  "tag": "cls_sat_eval_gr_res",
  "clause_ids": [ 51, 50, 49, 56, 55, 60, 58, 57, 53, 52, 59, 54 ],
  "sat_lit_gr_vals": [
    [ true ],
    [ true ],
    [ true ],
    [ true ],
    [ true ],
    [ true, false ],
    [ false, true ],
    [ true, true ],
    [ false, true ],
    [ true, true ],
    [ false, false, true ],
    [ false, true, false ]
  ]
}
```

Note that now all clauses have at least one (grounding of the) literal true in the current state of the solver. 

  </details>

   c. To finish sequence of queries EA sends:

```json
      { "tag": "server_queries_end" }
```

  This can be sent immediately after ```"tag":"server_queries_start"``` if EA does not need any evaluations.

5. EA sends scores for clauses requested in 3.

```json
    {
   "tag": "scores_res",
   "scores": [
    0.014285714285714285, 0.014705882352941176, 0.014705882352941176,
    0.011111111111111112, 0.011363636363636364, 0.006896551724137931,
    0.010752688172043012, 0.010526315789473684, 0.01, 0.01098901098901099,
    0.009009009009009009, 0.008064516129032258
  ]
}
```

     
6. iProver sends  list of clauses added to the passive queue
 
   <details>
   <summary> ```"tag": "passive_clauses"``` </summary>

```json
{
  "tag": "passive_clauses",
  "clause_ids": [ 51, 50, 49, 56, 55, 60, 58, 57, 53, 52, 59, 54 ],
  "component": "sup",
  "component_id": 1
}
```
   </details>
   
7. iProver sends the selected given clause:
 <details>
   <summary> ```"tag": "given_clause"``` </summary>

```json
   {
    "tag": "given_clause",
    "clause_ids": [ 49 ],
    "component": "sup",
    "component_id": 1
}
```
</details>

8. iProver sends simplified clauses (which are removed from proof search in that component):

<details>
   <summary> ```"tag": "simplified_clauses"``` </summary>

```json
 {
  "tag": "simplified_clauses",
  "clause_ids": [ 60 ],
  "component": "sup",
  "component_id": 1
}
```

</details>

9. In instantiation it may happen that clauses are moved from active to passive due to SAT model change which changes the literal selection.

<details>
   <summary> ```"tag": "moved_from_active_to_passive"``` </summary>

```json
{
  "tag": "moved_from_active_to_passive",
  "clause_ids": [ 205 ],
  "component": "inst",
  "component_id": 0
}
```
</details>

10. When iProver search terminates it sends result with SZS status:

```json
{
  "tag": "szs_result_out",
  "szs_status": "% SZS status Unsatisfiable for PUZ001-1.p"
}
```

Supported SZS statuses are: Unsatisfiable, Theorem, Satisfiable, CounterSatisfiable, Uknown

If a proof is found iProver sends proof clauses to EA (ordered: premises are before conclusions).

```json
{
  "tag": "proof_out",
  "clause_ids": [
    50, 52, 53, 54, 55, 56, 57, 58, 59, 60, 62, 83, 84, 89, 112, 113, 115,
    118, 119, 120
  ],
  "component": "proof",
  "component_id": -1
}
```


##### e) iProver requests clause scoring in batches. 

The (approx) batch size can be specified by e.g. ```--sup_unprocessed_bound 1000``` for superposition component
( ```--inst_unprocessed_bound 1000``` for instantiation component).

The clauses are kept in unprocessed until the ```--sup_unprocessed_bound``` is reached or passive is empty. 
If passive is empty then iProver has to move unprocessed to passive and 
request the external_scores regardless of the batch size.
```--sup_unprocessed_bound 0``` means that batches consist of generated clauses in each given clause iteration 
       
      
# The given clause mode (GCM)
    
 In this mode EA explicitly selects the given clause (rather than just assigning scores as in 1.); 
 internal passive priority queues are ignored. 

#### a) start server in a separate terminal:

```shell
./sockets_server --interactive_mode true --external_ip_address "127.0.0.1" --external_port 12345 
```

#### b) run iProver in a separate terminal:

```shell 
./iproveropt --interactive_mode true --external_ip_address "127.0.0.1" --external_port 12345 --schedule none --preprocessing_flag false --resolution_flag false --instantiation_flag false --superposition_flag true --sup_iter_deepening 0 --sup_iter_deepening 0 --sup_passive_queue_type external_agent Examples/PUZ001-1.p
```
The main option for this mode is ```--sup_passive_queue_type external_agent```

It is possible to run instantiation component and combination of instantiation and superposition.

```shell
./iproveropt --interactive_mode true --external_ip_address "127.0.0.1" --external_port 12345 --schedule none --preprocessing_flag false --resolution_flag false --instantiation_flag true --inst_passive_queue_type external_agent --superposition_flag true --sup_iter_deepening 0  --comb_inst_mult 4 --comb_sup_mult 2 --sup_passive_queue_type external_agent Examples/PUZ001-1.p
```

#### Given clause mode details

Typical sequence (in a loop) of communication between iProver and EA are similar to PSM mode (see above).
Here we only elaborate difference

1. iProver register clauses

2. iProver sends passive clauses

3. iProver requests the given clause

```json
{
  "tag": "given_clause_req",
  "component": "sup",
  "component_id": 2
  }
```

4. iProver sends   ```json { "tag": "server_queries_start" }``` to initiate any EA server queries.

5. EA sends queries/iProver responses as in PSM 3.-4.
   Note that EA should terminate query sequence with  ```json  { "tag": "server_queries_end" }```

6. EA send given clause id to iProver

```json
{
  "tag": "given_clause_res",
  "component_id": 2,
  "passive_is_empty": false,
  "given_clause": 50
}
```

7. 1.-6. are repeated until the problem is solved or the process is terminated 

8. When the problem is solved iProver sends result with SZS status as in PSM 10. and the proof if it is found.




