# File for defining how to form a schedule consisting of heuristics and time bounds.
# When a schedule is implemented it must be added to the "schedules" dict such that
# there can be a mapping between its string and the specification
#
# The general pformat of a schedule is: shed = [[h0, 120], [h2, 300]]
# where h0, h2 are heuristics and 120, 300 is the time to run it for.
# If None is supplied as time, the heuristic runs indefinitely.



from typing import Dict, List, Tuple, Any

default = [("heur/471148", None)]  # Safe default heuristic

default_sine = [
    ("heur/471148_sine_1_1", None),
    ("heur/471148_sine_1.2_3", None),
    ("heur/471148", None),
]  # Run two sine versions and fall back to default if doesn't work

default_test = [("heur/default", 2), ("heur/default", None)]

schedule_none = [("heur/schedule_none", None)]

smt_with_sat = [("heur/smt_with_sat", None)]

default_claus_test = [("heur/default_claus_test", 2), ("heur/default_claus_test", None)]

test_parallel = [[("heur/471148", 20)], [("heur/469570", 4), ("heur/330959", 16)]]

ueq_schedule = [
    [("heur/471148", 300)],
    [
        ("heur/409472", 7),
        ("heur/397416", 30),
        ("heur/492340", 119),
        ("heur/346298", 144),
    ],
    [("heur/346304", 17), ("heur/346301", 283)],
    [("heur/397445", 1), ("heur/397453", 106), ("heur/379313", 193)],
    [("heur/330959", 5), ("heur/379314", 97), ("heur/409461", 198)],
    [
        ("heur/397448", 8),
        ("heur/421501", 9),
        ("heur/397449", 29),
        ("heur/346297", 58),
        ("heur/409477", 196),
    ],
    [("heur/492341", 300)],
    [
        ("heur/409474", 1),
        ("heur/397450", 8),
        ("heur/409466", 18),
        ("heur/457559", 24),
        ("heur/421509", 249),
    ],
]

ltb_fof_schedule = [
    [("heur/471148", 300)],
    [("heur/471148_sine_1_1", 300)],
    [("heur/381325", 1), ("heur/381332", 14), ("heur/346291", 285)],
    [
        ("heur/346295", 2),
        ("heur/379308", 14),
        ("heur/409476", 18),
        ("heur/492340", 83),
        ("heur/421509", 183),
    ],
    [
        ("heur/409474", 1),
        ("heur/397438", 3),
        ("heur/346294", 6),
        ("heur/397433", 6),
        ("heur/409466", 6),
        ("heur/379305", 8),
        ("heur/397452", 11),
        ("heur/492338", 13),
        ("heur/433536", 17),
        ("heur/397454", 18),
        ("heur/492341", 211),
    ],
    [
        ("heur/346297", 1),
        ("heur/421498", 1),
        ("heur/469572", 1),
        ("heur/379306", 2),
        ("heur/379320", 2),
        ("heur/409461", 2),
        ("heur/421501", 2),
        ("heur/346293", 3),
        ("heur/445550", 16),
        ("heur/421494", 20),
        ("heur/379314", 35),
        ("heur/492343", 72),
        ("heur/469574", 143),
    ],
    [("heur/397453", 2), ("heur/445545", 2), ("heur/330959", 296)],
    [
        ("heur/397423", 2),
        ("heur/346296", 4),
        ("heur/346305", 4),
        ("heur/397442", 4),
        ("heur/469570", 4),
        ("heur/445546", 5),
        ("heur/421528", 8),
        ("heur/381331", 10),
        ("heur/397437", 16),
        ("heur/457559", 24),
        ("heur/346301", 29),
        ("heur/379313", 46),
        ("heur/346292", 59),
        ("heur/469569", 85),
    ],
]


ltb_super_22_6C = [
    [("heur/471148", 300)],
    [("heur/471148_sine_1_1", 300)],
    [("heur/381325", 1), ("heur/469574", 9), ("heur/346292", 12)],
    [("heur/381326", 1), ("heur/381332", 2), ("heur/469568", 2), ("heur/492341", 17)],
    [("heur/346299", 1), ("heur/379313", 2), ("heur/409491", 19)],
    [("heur/346301", 1), ("heur/379311", 1), ("heur/397444", 1), ("heur/433534", 19)],
    [("heur/346293", 1), ("heur/492338", 21)],
    [("heur/381328", 2), ("heur/381333", 20)],
]

ltb_super_22_5C = [
    [("heur/471148", 300)],
    [("heur/471148_sine_1_1", 300)],
    [("heur/471148_sine_1.2_3", 300)],
    [("heur/346301", 1), ("heur/346292", 21)],
    [("heur/346293", 1), ("heur/381325", 1), ("heur/492338", 20)],
    [("heur/492341", 22)],
    [
        ("heur/379312", 1),
        ("heur/381326", 1),
        ("heur/409466", 1),
        ("heur/381328", 2),
        ("heur/433535", 2),
        ("heur/409476", 15),
    ],
    [("heur/379313", 1), ("heur/469569", 21)],
]

ltb_low_phase_v4 = [
    ("heur/280924", 12),
    ("heur/277968", 12),
    ("heur/277969", 12),
    ("heur/278164", 11),
    ("heur/278644", 11),
    ("heur/280746", 10),
    ("heur/260291", 12),
    ("heur/278359", 7),
    ("heur/258434", 4),
    ("heur/279708", 1),
    ("heur/264563", 2),
    ("heur/280340", 1),
    ("heur/259599", 1),
]

ltb_low_phase_v5 = [
    ("heur/269506", 12),
    ("heur/281151", 5),
    ("heur/266513", 11),
    ("heur/268297", 12),
    ("heur/279169", 3),
    ("heur/278555", 7),
    ("heur/278359", 8),
    ("heur/278644", 10),
    ("heur/278166", 8),
    ("heur/281331", 9),
    ("heur/277960", 5),
    ("heur/279708", 2),
    ("heur/269504", 2),
    ("heur/269566", 1),
    ("heur/265544", 1),
]

ltb_high_common = [("heur/280746", 14), ("heur/277959", 163)]

ltb_high_phase_schedule = [("heur/261846", 13), ("heur/259793", 167)]

fnt_schedule_2023 = [
    [
        ("heur/fnt_1", 300),
        ("heur/fnt_2", 300),
        ("heur/fnt_3", 300),
        ("heur/fnt_4", 300),
        ("heur/271307", 300),
        ("heur/273393", 11),
        ("heur/271303", 26),
        ("heur/269879", 39),
        ("heur/271021", 43),
        ("heur/272218", 59),
        ("heur/273030", 90),
        ("heur/270906", 110),
        ("heur/272766", 137),
    ],
]

fnt_schedule = [
  [("heur_sat/schedule_default", 300)],
  [("heur_sat/schedule_fnt", 300)],
  [("heur_sat/schedule_fnt_1", 300)],
  [("heur_sat/schedule_none_fnt_fm", 300)],
  [("heur_sat/schedule_none_fnt_fm_1", 300)],
  [("heur_sat/schedule_none_fnt_fm_2", 300)],
  [("heur_sat/schedule_none_fnt_fm_3", 300)],
  [("heur_sat/schedule_none_fnt_fm_4", 300)],
#  [("heur/schedule_none_fnt_fm_5", 300)],
]

fof_schedule = [
    [("heur/471148_flat_conj", 300)],
    [("heur/sine_sd5_st_1_5", 60),("heur/sine_sd0_st2", 240)],
    [
        ("heur/409474", 1),
        ("heur/397453", 2),
        ("heur/421501", 2),
        ("heur/445550", 16),
        ("heur/409476", 18),
        ("heur/379313", 79),
        ("heur/421509", 182),
    ],
    [("heur/469571", 1), ("heur/397438", 3), ("heur/330959", 296)],
    [
        ("heur/469570", 4),
        ("heur/397433", 6),
        ("heur/421523", 13),
        ("heur/381332", 14),
        ("heur/397437", 16),
        ("heur/421494", 20),
        ("heur/469569", 25),
        ("heur/346292", 59),
        ("heur/469574", 143),
    ],
    [("heur/346296", 4), ("heur/457559", 296)],
    [
        ("heur/381325", 1),
        ("heur/397442", 1),
        ("heur/346295", 2),
        ("heur/379306", 2),
        ("heur/379320", 2),
        ("heur/389350", 5),
        ("heur/346294", 6),
        ("heur/492343", 6),
        ("heur/397452", 11),
        ("heur/379308", 12),
        ("heur/469576", 14),
        ("heur/381331", 15),
        ("heur/397454", 17),
        ("heur/433536", 17),
        ("heur/409466", 18),
        ("heur/492338", 24),
        ("heur/346301", 29),
        ("heur/379314", 35),
        ("heur/492340", 83),
    ],
    [
        ("heur/346297", 1),
        ("heur/421498", 1),
        ("heur/445545", 2),
        ("heur/346293", 3),
        ("heur/421528", 8),
        ("heur/492341", 285),
    ],
    [("heur/397423", 2), ("heur/346305", 4), ("heur/445546", 5), ("heur/346291", 289)],
]

sup_cicm_20_train_default = [("heur/381325", 1), ("heur/389408", 19)]
sup_cicm_20_train_parallel = [[("heur/381325", 20)], [("heur/389408", 19)]]

sup_cicm_20_train_admissible = {
    "default": sup_cicm_20_train_default,
    "model": "embeddings/embedding_2021-04-26_11-32-34.log.pkl",
    "cluster_centers": [
        [
            1,
            1,
            0,
            0,
            0,
            1,
            1,
            0,
            0,
            0,
            0,
            1,
            1,
            1,
            0,
            0,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            0,
            1,
            1,
            1,
            1,
            0,
            1,
            1,
            1,
            1,
            1,
            0,
            1,
            1,
            1,
            0,
            1,
            1,
            1,
            0,
            1,
            0,
            0,
            0,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
        ],
        [
            0,
            0,
            1,
            0,
            0,
            0,
            0,
            1,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            1,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            1,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            1,
        ],
    ],
    0: [("heur/381325", 1), ("heur/383337", 2), ("heur/381333", 17)],
    1: [("heur/379319", 3), ("heur/389408", 17)],
}

test_single_core_300_super = [
    [
        ("heur/346294", 1),
        ("heur/346299", 1),
        ("heur/346301", 1),
        ("heur/379312", 1),
        ("heur/381325", 1),
        ("heur/409491", 1),
        ("heur/433536", 1),
        ("heur/346293", 2),
        ("heur/346295", 2),
        ("heur/379308", 2),
        ("heur/379311", 2),
        ("heur/381332", 2),
        ("heur/397423", 2),
        ("heur/379320", 3),
        ("heur/397453", 3),
        ("heur/379313", 5),
        ("heur/379314", 5),
        ("heur/381331", 6),
        ("heur/469568", 6),
        ("heur/469574", 7),
        ("heur/433535", 12),
        ("heur/457559", 12),
        ("heur/346292", 65),
        ("heur/471148", 157),
    ]
]

test_single_core_300_super_x2 = [
    [
        ("heur/346294", 2),
        ("heur/346299", 2),
        ("heur/346301", 2),
        ("heur/379312", 2),
        ("heur/381325", 2),
        ("heur/409491", 2),
        ("heur/433536", 2),
        ("heur/346293", 4),
        ("heur/346295", 4),
        ("heur/379308", 4),
        ("heur/379311", 4),
        ("heur/381332", 4),
        ("heur/397423", 4),
        ("heur/379320", 6),
        ("heur/397453", 6),
        ("heur/379313", 10),
        ("heur/379314", 10),
        ("heur/381331", 12),
        ("heur/469568", 12),
        ("heur/469574", 14),
        ("heur/433535", 24),
        ("heur/457559", 24),
        ("heur/346292", 130),
        ("heur/471148", 314),
    ]
]

test_single_core_300_super_x3 = [
    [
        ("heur/346294", 3),
        ("heur/346299", 3),
        ("heur/346301", 3),
        ("heur/379312", 3),
        ("heur/381325", 3),
        ("heur/409491", 3),
        ("heur/433536", 3),
        ("heur/346293", 6),
        ("heur/346295", 6),
        ("heur/379308", 6),
        ("heur/379311", 6),
        ("heur/381332", 6),
        ("heur/397423", 6),
        ("heur/379320", 9),
        ("heur/397453", 9),
        ("heur/379313", 15),
        ("heur/379314", 15),
        ("heur/381331", 18),
        ("heur/469568", 18),
        ("heur/469574", 21),
        ("heur/433535", 36),
        ("heur/457559", 36),
        ("heur/346292", 195),
        ("heur/471148", 471),
    ]
]

test_single_core_300_super_x4 = [
    [
        ("heur/346294", 4),
        ("heur/346299", 4),
        ("heur/346301", 4),
        ("heur/379312", 4),
        ("heur/381325", 4),
        ("heur/409491", 4),
        ("heur/433536", 4),
        ("heur/346293", 8),
        ("heur/346295", 8),
        ("heur/379308", 8),
        ("heur/379311", 8),
        ("heur/381332", 8),
        ("heur/397423", 8),
        ("heur/379320", 12),
        ("heur/397453", 12),
        ("heur/379313", 20),
        ("heur/379314", 20),
        ("heur/381331", 24),
        ("heur/469568", 24),
        ("heur/469574", 28),
        ("heur/433535", 48),
        ("heur/457559", 48),
        ("heur/346292", 260),
        ("heur/471148", 628),
    ]
]

test_single_core_300_mixed = [
    ("heur/346294", 1),
    ("heur/346299", 1),
    ("heur/379307", 1),
    ("heur/379312", 1),
    ("heur/381325", 1),
    ("heur/381326", 1),
    ("heur/397442", 1),
    ("heur/409466", 1),
    ("heur/409474", 1),
    ("heur/409477", 1),
    ("heur/421498", 1),
    ("heur/346293", 2),
    ("heur/346295", 2),
    ("heur/379311", 2),
    ("heur/381332", 2),
    ("heur/386344", 2),
    ("heur/379320", 3),
    ("heur/379308", 4),
    ("heur/421528", 4),
    ("heur/379313", 5),
    ("heur/379314", 5),
    ("heur/397453", 5),
    ("heur/469574", 7),
    ("heur/457559", 12),
    ("heur/433534", 20),
    ("heur/469569", 25),
    ("heur/346292", 65),
    ("heur/389408", 124),
]

test_single_core_300 = [
    ("heur/379312", 1),
    ("heur/381322", 1),
    ("heur/397442", 1),
    ("heur/397444", 1),
    ("heur/397452", 1),
    ("heur/409466", 1),
    ("heur/409482", 1),
    ("heur/433535", 1),
    ("heur/469573", 1),
    ("heur/397423", 2),
    ("heur/421511", 2),
    ("heur/469576", 2),
    ("heur/397453", 3),
    ("heur/421528", 4),
    ("heur/469570", 4),
    ("heur/381331", 5),
    ("heur/379314", 11),
    ("heur/409477", 14),
    ("heur/421523", 14),
    ("heur/397416", 17),
    ("heur/397437", 17),
    ("heur/421531", 18),
    ("heur/379313", 19),
    ("heur/457559", 19),
    ("heur/389408", 20),
    ("heur/397454", 20),
    ("heur/409476", 20),
    ("heur/421513", 20),
    ("heur/433534", 20),
    ("heur/469569", 20),
    ("heur/469574", 20),
]

test_single_core_300_admissible = {
    "default": test_single_core_300_mixed,
    "model": "embeddings/embedding_2021-05-06_18-13-03.log.pkl",
    "cluster_centers": [
        [
            0,
            0,
            1,
            0,
            0,
            0,
            0,
            0,
            0,
            1,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            1,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            1,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            1,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            1,
            0,
            0,
            0,
            1,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            1,
            1,
            1,
            1,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
        ],
        [
            1,
            0,
            0,
            0,
            1,
            1,
            1,
            1,
            0,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            0,
            1,
            1,
            1,
            1,
            1,
            1,
            0,
            1,
            1,
            0,
            1,
            1,
            0,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            0,
            0,
            0,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            0,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            0,
            1,
            0,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            0,
            1,
            0,
            0,
            1,
            1,
            1,
            0,
            0,
            0,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            0,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
        ],
    ],
    0: [
        ("heur/421514", 1),
        ("heur/433535", 1),
        ("heur/421510", 2),
        ("heur/433536", 3),
        ("heur/433541", 6),
        ("heur/397452", 7),
        ("heur/421515", 10),
        ("heur/379314", 13),
        ("heur/397451", 15),
        ("heur/397423", 16),
        ("heur/409477", 16),
        ("heur/397436", 17),
        ("heur/379313", 18),
        ("heur/409466", 18),
        ("heur/379312", 19),
        ("heur/421526", 19),
        ("heur/433537", 19),
        ("heur/389408", 20),
        ("heur/397453", 20),
        ("heur/421509", 20),
        ("heur/421513", 20),
        ("heur/433534", 20),
    ],
    1: [
        ("heur/379314", 1),
        ("heur/381322", 1),
        ("heur/397441", 1),
        ("heur/397444", 1),
        ("heur/409465", 1),
        ("heur/409474", 1),
        ("heur/409482", 1),
        ("heur/469573", 1),
        ("heur/421501", 2),
        ("heur/421511", 2),
        ("heur/397438", 3),
        ("heur/397442", 4),
        ("heur/421528", 4),
        ("heur/469570", 4),
        ("heur/469578", 5),
        ("heur/421505", 8),
        ("heur/381331", 10),
        ("heur/397429", 10),
        ("heur/397449", 14),
        ("heur/421523", 14),
        ("heur/397416", 17),
        ("heur/397437", 17),
        ("heur/409489", 19),
        ("heur/457559", 19),
        ("heur/397454", 20),
        ("heur/409476", 20),
        ("heur/409479", 20),
        ("heur/445542", 20),
        ("heur/445550", 20),
        ("heur/469569", 20),
        ("heur/469574", 20),
    ],
}

smac_sup_ueq_30_12_2022_300s = [
    ("heur/vip_21182", 1),
    ("heur/vip_24972", 1),
    ("heur/vip_35137", 1),
    ("heur/vip_7316", 1),
    ("heur/vip_7322", 1),
    ("heur/vip_10009", 2),
    ("heur/vip_15884", 2),
    ("heur/vip_21183", 2),
    ("heur/vip_7313", 2),
    ("heur/vip_23233", 3),
    ("heur/vip_11026", 4),
    ("heur/vip_24970", 4),
    ("heur/vip_27992", 6),
    ("heur/vip_32259", 7),
    ("heur/vip_14573", 8),
    ("heur/vip_26918", 8),
    ("heur/vip_11023", 10),
    ("heur/vip_21176", 14),
    ("heur/vip_6539", 17),
    ("heur/vip_11028", 33),
    ("heur/vip_14572", 46),
    ("heur/vip_5186", 52),
    ("heur/vip_34370", 75),
]

smac_sup_ueq_30_12_2022_300s_x3 = [
    ("heur/vip_21182", 3),
    ("heur/vip_24972", 3),
    ("heur/vip_35137", 3),
    ("heur/vip_7316", 3),
    ("heur/vip_7322", 3),
    ("heur/vip_10009", 6),
    ("heur/vip_15884", 6),
    ("heur/vip_21183", 6),
    ("heur/vip_7313", 6),
    ("heur/vip_23233", 9),
    ("heur/vip_11026", 12),
    ("heur/vip_24970", 12),
    ("heur/vip_27992", 18),
    ("heur/vip_32259", 21),
    ("heur/vip_14573", 24),
    ("heur/vip_26918", 24),
    ("heur/vip_11023", 30),
    ("heur/vip_21176", 42),
    ("heur/vip_6539", 51),
    ("heur/vip_11028", 99),
    ("heur/vip_14572", 138),
    ("heur/vip_5186", 156),
    ("heur/vip_34370", 225),
]

smac_sup_ueq_30_12_2022_900s = [
    ("heur/vip_24967", 1),
    ("heur/vip_7322", 1),
    ("heur/vip_10009", 2),
    ("heur/vip_21183", 2),
    ("heur/vip_11026", 4),
    ("heur/vip_9040", 5),
    ("heur/vip_11023", 6),
    ("heur/vip_32259", 7),
    ("heur/vip_24063", 8),
    ("heur/vip_21176", 10),
    ("heur/vip_12683", 15),
    ("heur/vip_24069", 15),
    ("heur/vip_35138", 23),
    ("heur/vip_24970", 37),
    ("heur/vip_31583", 42),
    ("heur/vip_10010", 43),
    ("heur/vip_14573", 44),
    ("heur/vip_8154", 54),
    ("heur/vip_15884", 57),
    ("heur/vip_7314", 57),
    ("heur/vip_3582", 62),
    ("heur/vip_6550", 62),
    ("heur/vip_23235", 75),
    ("heur/vip_11028", 85),
    ("heur/vip_9039", 86),
    ("heur/vip_5186", 97),
]

smt_4000_super_300_4 = [
    [
        ("heur/397433", 2),
        ("heur/421501", 2),
        ("heur/445545", 2),
        ("heur/381332", 4),
        ("heur/397418", 4),
        ("heur/397452", 7),
        ("heur/445550", 8),
        ("heur/346301", 12),
        ("heur/421509", 46),
        ("heur/469569", 85),
        ("heur/389408", 128),
    ],
    [
        ("heur/381325", 1),
        ("heur/409474", 1),
        ("heur/433536", 1),
        ("heur/469572", 1),
        ("heur/346293", 2),
        ("heur/346296", 3),
        ("heur/386344", 3),
        ("heur/346294", 6),
        ("heur/469576", 6),
        ("heur/469574", 23),
        ("heur/457559", 25),
        ("heur/346292", 228),
    ],
    [
        ("heur/346297", 1),
        ("heur/421498", 1),
        ("heur/433535", 1),
        ("heur/397423", 2),
        ("heur/379320", 3),
        ("heur/397438", 3),
        ("heur/397453", 4),
        ("heur/379311", 5),
        ("heur/409466", 6),
        ("heur/379308", 15),
        ("heur/379305", 16),
        ("heur/409476", 18),
        ("heur/433537", 20),
        ("heur/379313", 46),
        ("heur/346291", 61),
        ("heur/379314", 98),
    ],
    [("heur/346295", 2), ("heur/381331", 10), ("heur/471148", 288)],
]

smt_comp_2023_starexec = [
    [("heur/default", 1200)],
    [
        ("heur/vip_48773", 47),
        ("heur/vip_48371", 48),
        ("heur/vip_49664", 50),
        ("heur/vip_42940", 56),
        ("heur/vip_48777", 58),
        ("heur/vip_44054", 59),
        ("heur/vip_40063", 60),
        ("heur/vip_48776", 61),
        ("heur/vip_49662", 71),
        ("heur/vip_48772", 78),
        ("heur/vip_40941", 86),
        ("heur/vip_45882", 91),
        ("heur/vip_54235", 435),
    ],
    [
        ("heur/vip_37337", 1),
        ("heur/vip_36703", 60),
        ("heur/vip_48367", 73),
        ("heur/vip_49659", 75),
        ("heur/vip_45884", 81),
        ("heur/vip_48774", 84),
        ("heur/vip_51191", 90),
        ("heur/vip_54233", 736),
    ],
    [
        ("heur/vip_37338", 1),
        ("heur/vip_49658", 4),
        ("heur/vip_49665", 7),
        ("heur/vip_37340", 9),
        ("heur/vip_37331", 11),
        ("heur/vip_46610", 11),
        ("heur/vip_45880", 14),
        ("heur/vip_48775", 16),
        ("heur/vip_48368", 20),
        ("heur/vip_51190", 29),
        ("heur/vip_52310", 32),
        ("heur/vip_37333", 38),
        ("heur/vip_42942", 46),
        ("heur/vip_50148", 70),
        ("heur/vip_46608", 892),
    ],
]

smt_comp_2023_starexec_uf = [
    [("heur/default", 1200)],
    [
        ("heur/vip_51190", 29),
        ("heur/vip_49664", 42),
        ("heur/vip_48774", 84),
        ("heur/vip_51191", 90),
        ("heur/vip_45882", 91),
        ("heur/vip_54238", 250),
        ("heur/vip_54237", 283),
        ("heur/vip_54235", 331),
    ],
    [
        ("heur/vip_37337", 4),
        ("heur/vip_42942", 46),
        ("heur/vip_48371", 48),
        ("heur/vip_40063", 60),
        ("heur/vip_49662", 71),
        ("heur/vip_49659", 75),
        ("heur/vip_48367", 79),
        ("heur/vip_37333", 81),
        ("heur/vip_40941", 736),
    ],
    [
        ("heur/vip_37338", 1),
        ("heur/vip_37901", 1),
        ("heur/vip_37331", 11),
        ("heur/vip_46610", 11),
        ("heur/vip_45880", 14),
        ("heur/vip_48775", 16),
        ("heur/vip_48368", 20),
        ("heur/vip_52310", 27),
        ("heur/vip_49661", 42),
        ("heur/vip_44054", 59),
        ("heur/vip_48776", 61),
        ("heur/vip_50148", 70),
        ("heur/vip_37340", 99),
        ("heur/vip_54233", 768),
    ],
]

smt_comp_2023_aws = [
    [("heur/default", 1200)],
    [
        ("heur/vip_45883", 1),
        ("heur/vip_48777", 2),
        ("heur/vip_49665", 7),
        ("heur/vip_51190", 8),
        ("heur/vip_48368", 20),
        ("heur/vip_48774", 27),
        ("heur/vip_37333", 38),
        ("heur/vip_40063", 60),
        ("heur/vip_54244", 113),
        ("heur/vip_54242", 286),
        ("heur/vip_54235", 638),
    ],
    [
        ("heur/vip_46605", 1),
        ("heur/vip_48773", 1),
        ("heur/vip_52311", 1),
        ("heur/vip_54245", 1),
        ("heur/vip_46610", 5),
        ("heur/vip_37331", 11),
        ("heur/vip_45880", 14),
        ("heur/vip_49664", 41),
        ("heur/vip_48371", 48),
        ("heur/vip_44054", 59),
        ("heur/vip_48776", 61),
        ("heur/vip_50148", 70),
        ("heur/vip_49659", 75),
        ("heur/vip_45884", 81),
        ("heur/vip_40941", 86),
        ("heur/vip_51191", 90),
        ("heur/vip_46604", 92),
        ("heur/vip_46608", 93),
        ("heur/vip_54233", 370),
    ],
    [
        ("heur/vip_37338", 1),
        ("heur/vip_45882", 1),
        ("heur/vip_44056", 5),
        ("heur/vip_37337", 12),
        ("heur/vip_54246", 44),
        ("heur/vip_54241", 270),
        ("heur/vip_54240", 275),
        ("heur/vip_54239", 292),
        ("heur/vip_54243", 300),
    ],
]

smt_comp_2024_starexec = [
    [
      ("heur_smt/409474", 1),
      ("heur_smt/397453", 2),
      ("heur_smt/421501", 2),
      ("heur_smt/346297", 1),
      ("heur_smt/421498", 1),
      ("heur_smt/445545", 2),
      ("heur_smt/346293", 3),
      ("heur_smt/421528", 8),
      ("heur_smt/default", 300),
      ("heur_smt/445550", 16),
      ("heur_smt/409476", 18),
      ("heur_smt/379313", 79),
      ("heur_smt/471148_flat_conj",300),
      ('heur_smt/vip2_130041', 3),
      ('heur_smt/vip2_127629', 23),
      ('heur_smt/vip2_128132', 46),
      ('heur_smt/vip2_125011', 63),
      ('heur_smt/vip2_127453', 68),
      ('heur_smt/vip2_119167', 86),
      ('heur_smt/vip2_125004', 53),
      ('heur_smt/vip2_123414', 27),
      ('heur_smt/vip2_120533', 4),
      ('heur_smt/vip2_118404', 100),
      ("heur_smt/492341", 285),
],
    [
        ("heur_smt/vip_48773", 47),
        ("heur_smt/vip_48371", 48),
        ("heur_smt/vip_49664", 50),
        ("heur_smt/vip_42940", 56),
        ("heur_smt/vip_48777", 58),
        ("heur_smt/vip_44054", 59),
        ("heur_smt/vip_40063", 60),
        ("heur_smt/vip_48776", 61),
        ("heur_smt/vip_49662", 71),
        ("heur_smt/vip_48772", 78),
        ("heur_smt/vip_40941", 86),
        ("heur_smt/vip_45882", 91),
        ("heur_smt/vip_54235", 435),
        ("heur_smt/vip_65080", 40),
        ("heur_smt/vip_65521", 160),
        ("heur_smt/vip_66020", 200),
        ("heur_smt/vip_65511", 44),
        ("heur_smt/vip_65082", 156),
        ("heur_smt/492340", 83),
    ],
    [
        ("heur_smt/469571", 1),
        ("heur_smt/397438", 3),
        ("heur_smt/vip_37337", 1),
        ("heur_smt/346296", 4),
        ("heur_smt/vip_36703", 60),
        ("heur_smt/vip_48367", 73),
        ("heur_smt/vip_49659", 75),
        ("heur_smt/vip_45884", 81),
        ("heur_smt/vip_48774", 84),
        ("heur_smt/vip_51191", 90),
        ("heur_smt/330959", 60),
        ("heur_smt/381325", 1),
        ("heur_smt/397442", 1),
        ("heur_smt/346295", 2),
        ("heur_smt/379306", 2),
        ("heur_smt/379320", 2),
        ("heur_smt/389350", 5),
        ("heur_smt/346294", 6),
        ("heur_smt/492343", 6),
        ("heur_smt/397452", 11),
        ("heur_smt/379308", 12),
        ("heur_smt/469576", 14),
        ("heur_smt/381331", 15),
        ("heur_smt/397454", 17),
        ("heur_smt/433536", 17),
        ("heur_smt/409466", 18),
        ("heur_smt/492338", 24),
        ("heur_smt/346301", 29),
        ("heur_smt/379314", 35),
        ("heur_smt/vip_54233", 300),
        ("heur_smt/vip_65513", 23),
        ("heur_smt/vip_65089", 37),
        ("heur_smt/vip_65512", 56),
        ("heur_smt/vip_65091", 84),
        ("heur_smt/457559", 296),
    ],
    [
        ("heur_smt/397423", 2),
        ("heur_smt/346305", 4),
        ("heur_smt/445546", 5),
        ("heur_smt/vip_37338", 1),
        ("heur_smt/vip_49658", 4),
        ("heur_smt/vip_49665", 7),
        ("heur_smt/vip_37340", 9),
        ("heur_smt/vip_37331", 11),
        ("heur_smt/vip_46610", 11),
        ("heur_smt/vip_45880", 14),
        ("heur_smt/vip_48775", 16),
        ("heur_smt/vip_48368", 20),
        ("heur_smt/vip_51190", 29),
        ("heur_smt/vip_52310", 32),
        ("heur_smt/vip_37333", 38),
        ("heur_smt/vip_42942", 46),
        ("heur_smt/vip_50148", 70),
        ("heur_smt/vip_66003", 95),
        ("heur_smt/vip_65518", 105),
        ("heur_smt/vip_65520", 11),
        ("heur_smt/vip_64741", 92),
        ("heur_smt/vip_66005", 97),
        ("heur_smt/vip_46608", 300),
        ("heur_smt/vip_65097", 3),
        ("heur_smt/vip_65522", 16),
        ("heur_smt/vip_66004", 17),
        ("heur_smt/vip_66305", 42),
        ("heur_smt/vip_66019", 50),
        ("heur_smt/vip_66012", 72),
        ("heur_smt/vip_66020", 200),
        ("heur_smt/421509", 182),
    ],
]


smt_comp_2024_starexec_uf = [
    [
       ("heur_smt_sat/schedule_none_fnt_fm", 300),
       ("heur_smt_sat/schedule_none_fnt_fm_1", 300),
       ("heur_smt_sat/schedule_none_fnt_fm_2", 300),
       ("heur_smt_sat/schedule_none_fnt_fm_3", 300),
       ("heur_smt_sat/schedule_none_fnt_fm_4", 300),
],
    [
        ("heur_smt/471148_flat_conj",300),
        ("heur_smt/vip_51190", 29),
        ("heur_smt/vip_49664", 42),
        ("heur_smt/vip_48774", 84),
        ("heur_smt/vip_51191", 90),
        ("heur_smt/vip_45882", 91),
        ("heur_smt/vip_54238", 250),
        ("heur_smt/vip_54237", 283),
        ("heur_smt/vip_54235", 331),
    ],
    [
        ("heur_smt/409474", 1),
        ("heur_smt/397453", 2),
        ("heur_smt/421501", 2),
        ("heur_smt/346297", 1),
        ("heur_smt/421498", 1),
        ("heur_smt/445545", 2),
        ("heur_smt/346293", 3),
        ("heur_smt/421528", 8),
        ("heur_smt/445550", 16),
        ("heur_smt/409476", 18),
        ("heur_smt/379313", 79),
        ("heur_smt/vip_37337", 4),
        ("heur_smt/vip_42942", 46),
        ("heur_smt/vip_48371", 48),
        ("heur_smt/vip_40063", 60),
        ("heur_smt/vip_49662", 71),
        ("heur_smt/vip_49659", 75),
        ("heur_smt/vip_48367", 79),
        ("heur_smt/vip_37333", 81),
        ("heur_smt/397423", 2),
        ("heur_smt/346305", 4),
        ("heur_smt/445546", 5),
        ("heur_smt/vip_37338", 1),
        ("heur_smt/vip_49658", 4),
        ("heur_smt/vip_49665", 7),
        ("heur_smt/vip_37340", 9),
        ("heur_smt/vip_37331", 11),
        ("heur_smt/vip_46610", 11),
        ("heur_smt/vip_45880", 14),
        ("heur_smt/vip_48775", 16),
        ("heur_smt/vip_42942", 46),
        ("heur_smt/vip_65097", 3),
        ("heur_smt/vip_65522", 16),
        ("heur_smt/vip_40941", 300),
        ("heur_smt/vip_50148", 70),
        ("heur_smt/vip_66003", 95),
        ("heur_smt/vip_65518", 105),
        ("heur_smt/vip_65520", 11),
        ("heur_smt/vip_64741", 92),
        ("heur_smt/vip_66005", 97),
        ('heur/vip2_123359', 55),
    ],
    [
        ("heur_smt/vip_37338", 1),
        ("heur_smt/vip_37901", 1),
        ("heur_smt/vip_37331", 11),
        ("heur_smt/vip_46610", 11),
        ("heur_smt/vip_45880", 14),
        ("heur_smt/vip_48775", 16),
        ("heur_smt_sat/schedule_default", 300),
        ("heur_smt/vip_48368", 20),
        ("heur_smt/vip_52310", 27),
        ("heur_smt/vip_49661", 42),
        ("heur_smt/vip_44054", 59),
        ("heur_smt/vip_48776", 61),
        ("heur_smt/vip_50148", 70),
        ("heur_smt/vip_37340", 99),
        ("heur_smt/vip_54233", 300),
        ("heur_smt/vip_48775", 16),
        ("heur_smt/vip_48368", 20),
        ("heur_smt/vip_51190", 29),
        ("heur_smt/vip_52310", 32),
        ("heur_smt/vip_37333", 38),
        ("heur_smt/vip_42942", 46),
        ("heur_smt/vip_50148", 70),
        ("heur_smt/vip_66003", 95),
        ("heur_smt/vip_48368", 20),
        ("heur_smt/vip_51190", 29),
        ("heur_smt/vip_52310", 32),
        ("heur_smt/vip_37333", 38),
    ],
  ]




sat_finite_models = [
    [("heur/sat_mode_default_sched", None)],
    [("heur/sat_mode_none_sched", None)],
    [("heur/sat_mode_sched_none", None)],
]

casc_29_ueq = [  # type: ignore
    [("heur/schedule_none", None)],
    [("heur/vip_64751", 300)],
    [("heur/vip_60152", 6), ("heur/vip_55468", 15), ("heur/vip_54578", 19), ("heur/vip_64750", 260)],
    [("heur/vip_64722", 22), ("heur/vip_54575", 66), ("heur/vip_64754", 212)],
    [("heur/vip_56279", 4), ("heur/vip_60149", 12), ("heur/vip_56645", 64), ("heur/vip_64752", 220)],
    [("heur/vip_64715", 300)],
    [("heur/vip_54980", 57), ("heur/vip_64726", 243)],
    [("heur/vip_60796", 32), ("heur/vip_64730", 268)],
]

# replaced by casc_j12_ueq
casc_24_ueq_old = [
     [("heur/schedule_none_flat_conj", None)],
     [("heur/vip_64751_flat_conj", 300)],
     [("heur/vip_60152", 6), ("heur/vip_55468", 15), ("heur/vip_54578", 19), ("heur/vip_64750", 260)],
     [("heur/vip_64722", 22), ("heur/vip_54575", 66), ("heur/vip_64754", 212)],
     [("heur/vip_56279", 4), ("heur/vip_60149", 12), ("heur/vip_56645", 64), ("heur/vip_64752", 220)],
     [("heur/vip_64715", 300)],
     [("heur/vip_54980", 57), ("heur/vip_64726", 243)],
     [("heur/vip_60796", 32), ("heur/vip_64730", 268)],
 ]


casc_29_tfa = [
    [("heur/schedule_none", None)],
    [("heur/vip_66003", 95), ("heur/vip_65518", 105)],
    [("heur/vip_65520", 11), ("heur/vip_64741", 92), ("heur/vip_66005", 97)],
    [("heur/vip_65513", 23), ("heur/vip_65089", 37), ("heur/vip_65512", 56), ("heur/vip_65091", 84)],
    [
        ("heur/vip_65097", 3),
        ("heur/vip_65522", 16),
        ("heur/vip_66004", 17),
        ("heur/vip_66305", 42),
        ("heur/vip_66019", 50),
        ("heur/vip_66012", 72),
    ],
    [("heur/vip_65080", 40), ("heur/vip_65521", 160)],
    [("heur/vip_66020", 200)],
    [("heur/vip_65511", 44), ("heur/vip_65082", 156)],
]


casc_j12_ueq =[

 #   [("heur/schedule_none", None)], #KK replaced with below
    [("heur/schedule_none_flat_conj_false", None)], 
    [("heur/vip_64715", 300)],
    [('heur/vip2_130041', 3), ('heur/vip2_127629', 23), ('heur/vip2_128132', 46), ('heur/vip2_125011', 63), ('heur/vip2_127453', 68), ('heur/vip2_127598', 97)],
    [('heur/vip2_120438', 1), ('heur/vip2_128121', 10), ('heur/vip2_124991', 15), ('heur/vip2_123454', 40), ('heur/vip2_127555', 71), ('heur/vip2_120433', 72), ('heur/vip2_127705', 91)],
    [('heur/vip2_125018', 4), ('heur/vip2_123462', 8), ('heur/vip2_127587', 9), ('heur/vip2_130077', 13), ('heur/vip2_127608', 42), ('heur/vip2_124995', 44), ('heur/vip2_123488', 48), ('heur/vip2_123359', 55), ('heur/vip2_123433', 74)], [('heur/vip2_125028', 32), ('heur/vip2_123428', 37), ('heur/vip2_127670', 55), ('heur/vip2_119165', 84), ('heur/vip2_127475', 92)],
    [('heur/vip2_123496', 5), ('heur/vip2_120534', 9), ('heur/vip2_128144', 12), ('heur/vip2_128967', 20), ('heur/vip2_130035', 75), ('heur/vip2_127567', 79), ('heur/vip2_118404', 100)],
    [('heur/vip2_120533', 4), ('heur/vip2_123414', 27), ('heur/vip2_125004', 53), ('heur/vip2_130034', 58), ('heur/vip2_124996', 70), ('heur/vip2_119167', 86)]
]

epr_unsat_schedule = [
    [("heur/epr_no_sched", 200)],
    [("heur/sine_sd0_st2", 300)],
    [
        ("heur/381325", 1),
        ("heur/397442", 1),
        ("heur/346295", 2),
        ("heur/379306", 2),
        ("heur/379320", 2),
        ("heur/389350", 5),
        ("heur/346294", 6),
        ("heur/492343", 6),
        ("heur/397452", 11),
        ("heur/379308", 12),
        ("heur/469576", 14),
        ("heur/381331", 15),
        ("heur/397454", 17),
        ("heur/433536", 17),
        ("heur/409466", 18),
        ("heur/469570", 4),
        ("heur/397433", 6),
        ("heur/421523", 13),
        ("heur/381332", 14),  
        ("heur/397437", 16),   
        ("heur/421494", 20),   
        ("heur/469569", 25),   
        ("heur/346292", 59),           
        ("heur/492338", 24), 
        ("heur/346301", 29), 
        ("heur/379314", 35),
        ("heur/492340", 83),
    ],
    [   ("heur/346297", 1),
        ("heur/421498", 1),
        ("heur/445545", 2),
        ("heur/346293", 3),
        ("heur/421528", 8),
        ("heur/397423", 2), ("heur/346305", 4), ("heur/445546", 5), ("heur/469571", 1), ("heur/397438", 3), ("heur/346296", 4),  
        ("heur/409474", 1),
        ("heur/397453", 2),
        ("heur/421501", 2),
        ("heur/445550", 10),   
        ("heur/409476", 10),   
        ("heur/379313", 20),         
        ("heur/346291", 20), ("heur/457559", 20), ("heur/492341", 20),("heur/346291", 289),],
   ] 


epr_unsat_v2_schedule = [
    [("heur/sine_sd5_st_1_5", 60),("heur/sine_sd0_st2", 240)],
    [("heur/epr_no_sched", 300)],
#    [
#        ("heur/409474", 1),
#        ("heur/397453", 2),
#        ("heur/421501", 2),
#        ("heur/445550", 16),
#        ("heur/409476", 18),
#        ("heur/379313", 79),
#        ("heur/421509", 182),
#    ],
#    [("heur/469571", 1), ("heur/397438", 3), ("heur/330959", 296)],
#    [
#        ("heur/469570", 4),
#        ("heur/397433", 6),
#        ("heur/421523", 13),
#        ("heur/381332", 14),
#        ("heur/397437", 16),
#        ("heur/421494", 20),
#        ("heur/469569", 25),
#        ("heur/346292", 59),
#        ("heur/469574", 143),
#    ],
#    [("heur/346296", 4), ("heur/457559", 296)],
#    [
#        ("heur/381325", 1),
#        ("heur/397442", 1),
#        ("heur/346295", 2),
#        ("heur/379306", 2),
#        ("heur/379320", 2),
#        ("heur/389350", 5),
#        ("heur/346294", 6),
#        ("heur/492343", 6),
#        ("heur/397452", 11),
#        ("heur/379308", 12),
#        ("heur/469576", 14),
#        ("heur/381331", 15),
#        ("heur/397454", 17),
#        ("heur/433536", 17),
#        ("heur/409466", 18),
#        ("heur/492338", 24),
#        ("heur/346301", 29),
#        ("heur/379314", 35),
#        ("heur/492340", 83),
#    ],
    [
        ("heur/346297", 1),
        ("heur/421498", 1),
        ("heur/445545", 2),
        ("heur/346293", 3),
        ("heur/421528", 8),
        ("heur/492341", 285),
    ],
    [("heur/397423", 2), ("heur/346305", 4), ("heur/445546", 5), ("heur/346291", 289)],
]

epr_unsat_v3_schedule = [
    [("heur/sine_sd5_st_1_5", 60),("heur/sine_sd0_st2", 240)],
    [("heur/epr_no_sched", 300)],
    [("heur/445550", 300)],
]

default_sched_complete = [
    [("heur/default_fof", 300)],
    [("heur/inst_epr", 300)],
]

epr_sat_schedule = [
#  [("heur_sat/schedule_default", 300)],
  [("heur_sat/schedule_fnt", 300)],
  [("heur_sat/schedule_none_fnt_fm", 300)],
]

# FIXME all the ignores are not nice
# SCHEDULES: Dict[str, List[List[Tuple[str, int | float | None]]]] = { # Cannot infer types on the refs
SCHEDULES: Dict[str, List[List[Tuple[Any, Any]]]] = {  # type: ignore
    # 2024
    "fof_schedule": fof_schedule,
    "fnt_schedule": fnt_schedule,
    "ueq_schedule": casc_j12_ueq,
    "tfa_schedule": casc_29_tfa,    
#    "epr_unsat_schedule": epr_unsat_v2_schedule,
#    "epr_unsat_schedule": epr_unsat_schedule,
    "epr_unsat_schedule": epr_unsat_v3_schedule,
    "epr_sat_schedule": epr_sat_schedule,
    "default_sched_complete": default_sched_complete,
    "base": [[("heur/schedule_none", 100)]],
    # "smt_4000_super_300_4": smt_4000_super_300_4,
    "smt_comp_2023_starexec": smt_comp_2023_starexec,
    "smt_comp_2023_starexec_uf": smt_comp_2023_starexec_uf,  # FOR UF
    "smt_comp_2023_aws": smt_comp_2023_aws + smt_4000_super_300_4,
    "smt_comp_2023_aws_uf": smt_comp_2023_aws + smt_4000_super_300_4 + sat_finite_models,  # FOR UF
    "smt_comp_2024_starexec":smt_comp_2024_starexec,
    "smt_comp_2024_starexec_uf":smt_comp_2024_starexec_uf,
#    "smt_comp_2024_starexec_aws":smt_comp_2024_starexec_aws,
#    "smt_comp_2024_starexec_aws_uf":smt_comp_2024_starexec_aws_uf,
    "casc_29_ueq": casc_29_ueq,  # type: ignore
    "casc_j12_ueq": casc_j12_ueq,  # type: ignore
#    "casc_29_tfa": casc_29_tfa,  # type: ignore
}  # type: ignore
