module Algebra where

import Data.Text as T

import Term
import Signature
import SMT
import qualified Linear
import qualified LinearEncoding

data Algebra2 = Linear Linear.Algebra2

data Class = L
  deriving Eq

toClass :: Char -> Class
toClass 'l' = L
toClass c = error ("order class " ++ [c] ++ " is not supported")

geq :: Algebra2 -> Term -> Term -> Bool
geq (Linear a) = Linear.geq a

gt :: Algebra2 -> Term -> Term -> Bool
gt (Linear a) = Linear.gt a

-- for top-marking
geq' :: Algebra2 -> Term -> Term -> Bool
geq' (Linear a) = Linear.geq' a

-- for top-marking
gt' :: Algebra2 -> Term -> Term -> Bool
gt' (Linear a) = Linear.gt' a

pp :: Signature -> Algebra2 -> T.Text 
pp sig (Linear a) = Linear.pp sig a

data Encoder = Encoder {
  _side_condition :: Signature -> Formula,
  _geq :: Term -> Term -> Formula,
  _gt :: Term -> Term -> Formula,
  _geq' :: Term -> Term -> Formula, -- for top-marking
  _gt' :: Term -> Term -> Formula, -- for top-marking,
  _simple :: Signature -> Formula, -- for weak simplicity
  _no_marking :: Signature -> Formula,
  _decode :: Model -> Signature -> Algebra2
}

encoder :: Class -> Int -> Encoder
encoder L aid = Encoder {
  _side_condition = LinearEncoding.side_condition aid,
  _geq = LinearEncoding.geq aid,
  _gt = LinearEncoding.gt aid,
  _geq' = LinearEncoding.geq' aid,
  _gt' = LinearEncoding.gt' aid,
  _simple = LinearEncoding.simple aid,
  _no_marking = LinearEncoding.no_marking aid,
  _decode = decode
}
  where
    decode m sig = Linear (LinearEncoding.decode aid m sig)
