/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   main.cpp
 * Author: caof
 *
 * Created on 2016年11月1日, 上午8:47
 */

#include <cstdlib>
#include "FileOp.h"
#include "InitFunction.h"
#include "cprover.h"
#include "Formula.h"
#include "Prover.h"
#include "dataTypeDef.h"
#include "globalFunc.h"
#include "SocketOp.h"
#include "proFeature.h"
#include "preFeature2.h"
#include "AddEqnAxioms.h"
using namespace std;
class funcAddGreater{
public:
    bool operator()(const funcAdd* term1, const funcAdd* term2)
    {
        return term1->func < term2->func;
    }
};
class literalAddGreater{
public:
    bool operator()(const literalAdd* term1, const literalAdd* term2)
    {
        return term1->literal < term2->literal;
    }
};
void findFuncEquality(char* &sym,vector<funcAdd*> &funcAddEquality){
    funcAdd *funcSym = new funcAdd();
    funcSym->func = "";
    funcSym->suffix = 1;
    int iBracketNum = 0;
    while (*sym != '(') {
        funcSym->func += *sym;
        ++sym;
    }
    ++iBracketNum;
    while (iBracketNum > 0) {
        if (*sym == 'f') {
            findFuncEquality(sym, funcAddEquality);
        }
        else if (*sym == ',') {
            ++(funcSym->suffix); 
        }
        else if (*sym == ')') {
            --iBracketNum;
            if (iBracketNum == 0)
                break;
        }
        if(iBracketNum == 0){
            break;
        }
        ++sym;
    }
    funcAddEquality.push_back(funcSym);
}
//generated equality, according clause stream find the relation
void findEquality(char* &sym,vector<funcAdd*> &funcAddEquality,vector<literalAdd*> &LiteralAddEquality){
    while(1){
        if(*sym == 'p'){//find the needed add_equality 
            literalAdd *literalSym = new literalAdd();
            literalSym->literal = "";
            literalSym->suffix = 1;
            int iBracketNum = 0;
            bool proposition = false;
            bool runOneTime = true;
            while(*sym != '('){
                if(*sym == ' '){
                    ++sym;
                    continue;
                }
                if((*sym == '|') || (*sym == ')')){//especial case:( p1301 | p211(c1302) | p622(c2,c1303) | f54(c1304) != c1303 )). how to deal with?
                    literalSym->suffix = 1;
                    proposition = true;
                    break;
                }
                literalSym->literal += *sym; 
                ++sym;
                if(((*sym< '0')||(*sym >'9')) && runOneTime){//next sys of predicate term is not number 
                    proposition = true;
                    runOneTime = false;
                    break;
                }
                else if(((*sym >= '0') && (*sym <= '9'))&& runOneTime){
                    runOneTime = false;
                }
                
            }
            if(proposition){
                LiteralAddEquality.push_back(literalSym);
                continue;
            }
            ++iBracketNum;
            while(iBracketNum > 0){
                if(*sym == 'f'){
                    findFuncEquality(sym,funcAddEquality);
                }
                else if(*sym == ','){
                    ++(literalSym->suffix);
                }
                else if(*sym == ')'){
                    --iBracketNum;
                    if(iBracketNum == 0)
                        break;
                }
                ++sym;
            }
            LiteralAddEquality.push_back(literalSym);
        }
        if(*sym == 'f'){
            findFuncEquality(sym,funcAddEquality);
        }
        if(*sym == '.')
            break;
        ++sym;
    }
}
//generated equality term
string getTerm(int suffix, int size, int timeFlag){
    string res = "";
    vector<char> leftTerm;
    vector<char> rightTerm;
    for(int i=0; i<= size; ++i){
        if(i == 1)
            continue;
        leftTerm.push_back(i+'A');//get original term sort
    }
    for(int i=0; i<= size; ++i){
        if(i == 0)
            continue;
        rightTerm.push_back(i+'A');
    }
    for(int i=0; i<suffix; ++i){
        swap(leftTerm[i],leftTerm[i+1]);
        swap(rightTerm[i],rightTerm[i+1]);
    }
    if(timeFlag == 0){
        if(leftTerm.size()!=0){
            res += "(";
            for(int i=0;i<leftTerm.size();++i){
                res += leftTerm[i];
                if(i<leftTerm.size()-1){
                    res += ",";
                }
            }
            res += ")";
        }
        vector<char>().swap(leftTerm);
        vector<char>().swap(rightTerm);
        return res;
    }
    else if(timeFlag == 1){
      if(rightTerm.size()!=0){
            res += "(";
            for(int i=0;i<rightTerm.size();++i){
                res += rightTerm[i];
                if(i<rightTerm.size()-1){
                    res += ",";
                }
            }
            res += ")";
        }
        vector<char>().swap(leftTerm);
        vector<char>().swap(rightTerm);
        return res;  
    }
    vector<char>().swap(leftTerm);
    vector<char>().swap(rightTerm);
    return res;  
}
void addFunc(ofstream &ofInfoStream,funcAdd* funcSym){
    for(int i=0; i< funcSym->suffix; ++i){
        ofInfoStream << "cnf(" + funcSym->func + "_substitution_" + to_string(i+1) +",axiom," << endl;
        ofInfoStream << "    ( A != B | " + funcSym->func +getTerm(i,funcSym->suffix,0)+"= " + funcSym->func + getTerm(i,funcSym->suffix,1)+" ))." << endl;
        ofInfoStream << endl;
        StrategyParam::axiomsNum++;
    }
}
void addLiteral(ofstream &ofInfoStream,literalAdd* literalSym){
    for(int i=0; i< literalSym->suffix; ++i){
        ofInfoStream << "cnf(" + literalSym->literal + "_substitution_" + to_string(i+1) +",axiom," << endl;
        ofInfoStream << "    ( A != B | ~ " + literalSym->literal +getTerm(i,literalSym->suffix,0)+" | " + literalSym->literal + getTerm(i,literalSym->suffix,1)+" ))." << endl;
        ofInfoStream << endl;
        StrategyParam::axiomsNum++;
    }
}

//count time
double timeCount(clock_t initTime){
    clock_t endNoPair = clock();
    double time_sNoPair = (double) (endNoPair - initTime) / (double) CLOCKS_PER_SEC;
    return time_sNoPair;
}

bool OnlyRunEprover(double& executeTime) {
    bool proofFound = false;
    //E输出文件
    FileOp::OnlyRunEOutputFile = FileOp::workSpace + "/" + FileOp::judgeOriginalFileName + ".out";
    
    clock_t endTime = clock();
    StrategyParam::parseTime = (double)(endTime - StrategyParam::start) / CLOCKS_PER_SEC;  
    
    double runETime = StrategyParam::TotalRunTime - StrategyParam::parseTime - 1;
//    if (StrategyParam::ev1 == 6)
//        runETime *= 2;  //tmp
    string cmdRunE;
    //E2.5
//    if (StrategyParam::ev1 == 5)
//        cmdRunE = "timeout " + to_string((int)runETime) + " " + FileOp::appPath + "/Other/eprover --delete-bad-limit=2000000000 --definitional-cnf=24 -s --print-statistics -R --print-version --proof-object --auto-schedule --cpu-limit="
//                + to_string((int)runETime) + " " + FileOp::judgeOriginalFileFullName + " >> " + FileOp::OnlyRunEOutputFile;
//    else if (StrategyParam::ev1 == 6)
//        cmdRunE = "timeout " + to_string((int)runETime) + " " + FileOp::appPath + "/eprover --delete-bad-limit=2000000000 --definitional-cnf=24 -s --print-statistics -R --print-version --proof-object --auto-schedule --cpu-limit="
//                + to_string((int)runETime) + " " + FileOp::judgeOriginalFileFullName + " >> " + FileOp::OnlyRunEOutputFile;
    cmdRunE = "timeout " + to_string((int)runETime) + " " + FileOp::appPath + "--delete-bad-limit=2000000000 --definitional-cnf=24 -s --print-statistics -R --print-version --proof-object --auto-schedule --cpu-limit="
                + to_string((int)runETime) + " " + FileOp::judgeOriginalFileFullName + " >> " + FileOp::OnlyRunEOutputFile;
    //cout << "OnlycmdRunE: " << cmdRunE << endl;
    int resRunE = system(const_cast<char*> (cmdRunE.c_str())); 
    //打印信息
    string outMsg = "";
    proofFound = FileOp::OutputForCompetition(FileOp::OnlyRunEOutputFile, executeTime, outMsg);
    
    //若E判定成功，则创建输出文件夹,并将输出文件benchmark.out移动到该文件夹中
    if (proofFound) {
        cout << outMsg;
        string outFileName = FileOp::workSpace + "/" + FileOp::judgeOriginalFileName;
        FileOp::isExistDir(outFileName);
        //将E的输出文件.out移到刚创建的输出文件夹
        string cmdMove = "mv " + FileOp::OnlyRunEOutputFile + " " + outFileName;
        int resMove = system(const_cast<char*> (cmdMove.c_str()));
    }
    else //否则删除E输出文件.out
        remove(FileOp::OnlyRunEOutputFile.c_str());
    
    return proofFound;
}

bool RunEprover(const string& tptpShortFile, double& executeTime, int ev) {
    bool proofFound = false;
    FileOp::eOutputFile = FileOp::eOutputFile = FileOp::workSpace + "/" + FileOp::judgeOriginalFileName + ".first_out";
    
    //运行E
    string cmdRunE = "";
    double runEtime;
//    if (ev == 6)
//        runEtime = 2.0 * StrategyParam::firstRunTime; //tmp
//    else
    runEtime = StrategyParam::firstRunTime;

  
    if (StrategyParam::isInteraction) {
        cmdRunE = "timeout " + to_string((int)runEtime) + " " + FileOp::appPath + "/eprover --delete-bad-limit=2000000000 --definitional-cnf=24 -s --print-statistics -R --print-version --proof-object --auto-schedule --cpu-limit="
                + to_string((int)runEtime) + " " + tptpShortFile + " >> " + FileOp::eOutputFile;
    }
    else {
        cmdRunE = "timeout " + to_string((int)runEtime) + " " + FileOp::appPath + "/eprover --delete-bad-limit=2000000000 --definitional-cnf=24 -s --print-statistics -R --print-version --proof-object --auto-schedule --cpu-limit="
                + to_string(runEtime) + " " + FileOp::judgeOriginalFileFullName + " >> " + FileOp::eOutputFile;
    }   
   // cout << "cmdRunE:" << cmdRunE << endl;
    clock_t endTime = clock();
    StrategyParam::parseTime = (double)(endTime - StrategyParam::start) / CLOCKS_PER_SEC;
    
    int resRunE = system(const_cast<char*> (cmdRunE.c_str())); 
    //打印信息
    string outMsg = "";
    proofFound = FileOp::OutputForCompetition(FileOp::eOutputFile, executeTime, outMsg);
    //若E判定成功，则创建输出文件夹,并将输出文件.out移动到该文件夹中
    if (proofFound) {
        cout << outMsg << endl;
        string outFileName = FileOp::workSpace + "/" + FileOp::judgeOriginalFileName;
        FileOp::isExistDir(outFileName);
        //将E的输出文件.first_out移到刚创建的输出文件夹
        string cmdMove = "mv " + FileOp::eOutputFile + " " + outFileName;
        int resMove = system(const_cast<char*> (cmdMove.c_str()));
    } 
    
    return proofFound;
} 

//将fof格式转成TPTP格式
//const string& convertedFile 为转换过后的文件
void ConvertFofToTptp(const string& convertedFile) {
    //转换时间设置
    double maxConvertCNFTime = 0.0;
    if (FileOp::runMode == 0)  //CSE系统
        maxConvertCNFTime = StrategyParam::timeForceLimit;
    else if (FileOp::runMode == 4)     //CSE_E系统
        maxConvertCNFTime = StrategyParam::TotalRunTime;
    //转换命令
    string cmd = "timeout "+ to_string(maxConvertCNFTime) + " " + FileOp::appPath + "/eprover --tstp-format --cnf "
            + FileOp::judgeOriginalFileFullName + " >> " + convertedFile;
    //cout << "converFof2Tptp: " << cmd << endl;
    //转换
    int res4 = system(const_cast<char*> (cmd.c_str()));
}

//将cnf格式进行shorten
void ShortenCnfFile(const string& tptpFolder, const string& cnfFile, const string& logFile) {
    //转换时间设置
    double maxConvertShortTime = 0.0;
    if (FileOp::runMode == 0)  //CSE系统
        maxConvertShortTime = StrategyParam::timeForceLimit;
    else if (FileOp::runMode == 4)     //CSE_E系统
        maxConvertShortTime = StrategyParam::TotalRunTime;
    //转换命令
    string cmd = "timeout " + to_string(maxConvertShortTime) + " " + FileOp::appPath + "/tptp4X -tshorten -d " 
            + tptpFolder + " " + cnfFile + " >> " + logFile;
    //cout << "short cmd"<< cmd << endl;
    //转换
    int res = system(const_cast<char*> (cmd.c_str())); 
}

//添加等词公理
//const string& tptpShortFile short后的文件; const string& tptpFolde ./dist/output/tptp文件夹
bool addEqualityAxiom(const string& tptpShortFile, const string& tptpFolder) {
    string file = "";
    //1. 是否含有等词
    //判断是否含有等词，并将原始子句拷贝到benchmark.cnf文件中
    string strMsg = "";
    string strLine = "";
    bool addEqualityFlag = false;
    ifstream ifFolFileTptp(tptpShortFile);
    while (getline(ifFolFileTptp, strLine)) {
        TrimStr(strLine); //去除头尾空格
        if(strLine.find("=",0)!= -1){
           addEqualityFlag = true;
           //break;
        } 
        if (strLine == "")
            continue;
        strMsg += strLine;
        strMsg += "\n";
    }
    ifFolFileTptp.close();
      
    //2. 不含有等词 or 不处理等词，将short后文件改名
    if((!addEqualityFlag) || (!StrategyParam::equality)) {
        string nameLast = tptpFolder + "/" + FileOp::judgeOriginalFileName + "+short+noeq.tptp";
        string changeFileNameCmd = "mv " + tptpShortFile + " " + nameLast;  
        int res6 = system(const_cast<char*> (changeFileNameCmd.c_str()));
        file = nameLast;

        FileOp::AnalysisFileName(file);
        FileOp::PrintInfoForEprover(strMsg);  //将原始子句写入到.cnf中
    }
    else if(StrategyParam::equality){   //含有等词
        //add equality 添加等词
        vector<funcAdd*> funcAddEquality;
        funcAddEquality.reserve(16);
        vector<literalAdd*> LiteralAddEquality;
        LiteralAddEquality.reserve(16);
        //start parse
        ifstream ifFolFileShort(tptpShortFile);
        while(getline(ifFolFileShort, strLine)) {
            TrimStr(strLine); //去除头尾空格
            if(strLine.length() == 0 || strLine[0] == '%'|| strLine[0] == 'c') 
                continue; //空行和%--注释语句 不读取
            char* ch = const_cast<char*> (strLine.c_str()); 
            findEquality(ch,funcAddEquality,LiteralAddEquality);
        }
        ifFolFileShort.close();
        //unique
        if(funcAddEquality.size() != 0){
            for (size_t rInd = 0; rInd < funcAddEquality.size() - 1; ++rInd) {
                funcAdd* rA = funcAddEquality[rInd];
                for (size_t rIndB = rInd + 1; rIndB < funcAddEquality.size();) {
                    funcAdd* rB = funcAddEquality[rIndB];
                    if ((rA->func == rB ->func) && (rA->suffix == rB->suffix)) {
                        swap(funcAddEquality[rIndB], funcAddEquality[funcAddEquality.size() - 1]);
                        funcAddEquality.pop_back();
                    } else
                        ++rIndB;
                }
            }
        }
        if(LiteralAddEquality.size() != 0){
            for (size_t rInd = 0; rInd < LiteralAddEquality.size() - 1; ++rInd) {
                literalAdd* rA = LiteralAddEquality[rInd];
                for (size_t rIndB = rInd + 1; rIndB < LiteralAddEquality.size();) {
                    literalAdd* rB = LiteralAddEquality[rIndB];
                    if ((rA->literal == rB ->literal ) && (rA->suffix == rB->suffix)) {
                        swap(LiteralAddEquality[rIndB], LiteralAddEquality[LiteralAddEquality.size() - 1]);
                        LiteralAddEquality.pop_back();
                    } else
                        ++rIndB;
                }
            }
        }
        //generated equality  
        if (1) {
            ofstream ofInfoStreamOut(tptpShortFile, ios::app);
            ofInfoStreamOut << "cnf(reflexivity,axiom," << endl;
            ofInfoStreamOut << "    ( A = A ))." << endl;
            ofInfoStreamOut << endl;
            ofInfoStreamOut << "cnf(symmetry,axiom," << endl;
            ofInfoStreamOut << "    ( A != B | B = A ))." << endl;
            ofInfoStreamOut << endl;
            ofInfoStreamOut << "cnf(transitivity,axiom," << endl;
            ofInfoStreamOut << "    ( A != B | B != C | A = C ))." << endl;
            ofInfoStreamOut << endl;
            StrategyParam::axiomsNum = 3;   //等词公理数量加3
            if(funcAddEquality.size() != 0){
                for(int i=0; i<funcAddEquality.size(); ++i){
                    if(funcAddEquality[i]->suffix >= 23){//not add equilty 20190719
                        continue;
                    }
                    addFunc(ofInfoStreamOut,funcAddEquality[i]);
                    //ofInfoStreamOut << endl;
                }
            }
            if(LiteralAddEquality.size() != 0){
                for(int i=0; i<LiteralAddEquality.size(); ++i){
                    if(LiteralAddEquality[i]->suffix >= 23){//not add equilty 20190719
                        continue;
                    }
                    addLiteral(ofInfoStreamOut,LiteralAddEquality[i]);
                    //ofInfoStreamOut << endl;
                }
            }  
            //改名
            string nameLast = tptpFolder + "/" + FileOp::judgeOriginalFileName + "+short+eq_rstfp.tptp";
            string changeFileNameCmd = "mv " + tptpShortFile + " " + nameLast;  
            int res6 = system(const_cast<char*> (changeFileNameCmd.c_str()));

            file = nameLast;
            FileOp::AnalysisFileName(file); 
            FileOp::PrintInfoForEprover(strMsg);  //将原始子句写入到.cnf中
        }
        else {
            //generated equality
            string nameLast = tptpFolder + "/" + FileOp::judgeOriginalFileName + "+short+eq_rstfp.tptp";
            ifstream ifFolFileOut(tptpShortFile);
            ofstream ofInfoStreamOut(nameLast, ios::app);
            bool addE = true;
            while(getline(ifFolFileOut, strLine)) {
                if(strLine[0] == '%' || strLine[0] == '-'){
                    ofInfoStreamOut << strLine << endl;
                    continue;
                }
                //add equality
                if(addE){
                    ofInfoStreamOut << "cnf(reflexivity,axiom," << endl;
                    ofInfoStreamOut << "    ( A = A ))." << endl;
                    ofInfoStreamOut << endl;
                    ofInfoStreamOut << "cnf(symmetry,axiom," << endl;
                    ofInfoStreamOut << "    ( A != B | B = A ))." << endl;
                    ofInfoStreamOut << endl;
                    ofInfoStreamOut << "cnf(transitivity,axiom," << endl;
                    ofInfoStreamOut << "    ( A != B | B != C | A = C ))." << endl;
                    ofInfoStreamOut << endl;
                    StrategyParam::axiomsNum = 3;
                    if(funcAddEquality.size() != 0){
                        for(int i=0; i<funcAddEquality.size(); ++i){
                            if(funcAddEquality[i]->suffix >= 23){//not add equilty 20190719
                                continue;
                            }
                            addFunc(ofInfoStreamOut,funcAddEquality[i]);
                            //ofInfoStreamOut << endl;
                        }
                    }
                    if(LiteralAddEquality.size() != 0){
                        for(int i=0; i<LiteralAddEquality.size(); ++i){
                            if(LiteralAddEquality[i]->suffix >= 23){//not add equilty 20190719
                                continue;
                            }
                            addLiteral(ofInfoStreamOut,LiteralAddEquality[i]);
                            //ofInfoStreamOut << endl;
                        }
                    }
                    addE = false;
                }
                ofInfoStreamOut << strLine << endl;

            }
            ifFolFileOut.close();
            ofInfoStreamOut.close();
            funcAddEquality.clear();
            vector<funcAdd*>().swap(funcAddEquality);
            LiteralAddEquality.clear();
            vector<literalAdd*>().swap(LiteralAddEquality);
            remove(tptpShortFile.c_str());

            file = nameLast;
            FileOp::AnalysisFileName(file);  
            FileOp::PrintInfoForEprover(strMsg);  //将原始子句写入到.cnf中
        }
    }
    //cout << "000000000000000\n";
    return addEqualityFlag;
}

int ReadOriProblem360(const string& problemFile) {
    int runSys = 1; //1 only run E; 2 E->CSE->E; 3 CSE->E
    string strConj = "";
    string strAxiom = "";
    string problemField = "";
    ifstream fin(problemFile);
    string str = "";
    bool flag = false;
    while (getline(fin, str)) {
        if (str.find("conjecture") != string::npos) {
            int begPos = str.find_first_of(",");
            int endPos = str.find_last_of(",");
            string temp = str.substr(begPos + 1, endPos - (begPos + 1));
            if (temp == "conjecture") {
                strConj = str;
                break;
            }
        }
        else if (str.find("include(") != string::npos && !flag) {
            strAxiom = str;
            flag = true;
        }
    }

    if (strAxiom.find("include('Axioms/AGT001") != string::npos) {
        if (strConj.find("fof(query_") != string::npos) {
            int begPos = strConj.find_first_of("_");
            begPos += 1;
            int endPos = strConj.find_first_of(",");
            string temp = strConj.substr(begPos, endPos - begPos);
            int index = atoi(temp.c_str());
            if (index == 8|| index == 21)
                runSys = 3;
            else if (index == 26) {
                StrategyParam::firstRunTime = 147;
                StrategyParam::timeForceLimit = 30; 
                runSys = 2;
            }
            else if (index == 11) {
                StrategyParam::firstRunTime = 165;
                StrategyParam::timeForceLimit = 30; 
                runSys = 2;
            }
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/BIO001") != string::npos) {
        return runSys;        
    }
    
    if (strAxiom.find("include('Axioms/COM001+0.ax')") != string::npos) {
        if (strConj.find("fof('T-Weak-FreeVar-") != string::npos) {
            if (strConj.find("-abs-2',") != string::npos)
                runSys = 3;
            else 
                runSys = 1;
        }
        else if (strConj.find("fof('T-subst-") != string::npos) {
            if (strConj.find("-abs-3',") != string::npos)
                runSys = 3;
            else 
                runSys = 1;
        }
        else if (strConj.find("fof('T-Preservation-T-") != string::npos) {
            if (strConj.find("app',") != string::npos)
                runSys = 3;
            else 
                runSys = 1;
        }
        else if (strConj.find("fof('T-Progress-T-") != string::npos) {
            if (strConj.find("app',") != string::npos)
                runSys = 3;
            else 
                runSys = 1;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR001+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR002+1.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR002+2.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR002+3.ax')") != string::npos) {
        if (strConj.find("fof(query") != string::npos) {
            int begPos = strConj.find_first_of("y");
            begPos += 1;
            int endPos = strConj.find_first_of(",");
            string temp = strConj.substr(begPos, endPos - begPos);
            int index = atoi(temp.c_str());
            if (index == 186 || index == 189 || index == 199 || index == 211)
                runSys = 3;
            else 
                runSys = 1;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR002+4.ax')") != string::npos) {
        if (strConj.find("fof(query") != string::npos) {
            int begPos = strConj.find_first_of("y");
            begPos += 1;
            int endPos = strConj.find_first_of(",");
            string temp = strConj.substr(begPos, endPos - begPos);
            int index = atoi(temp.c_str());
            if (index == 226 || index == 229 || index == 236 || index == 239 || index == 240
                    || index == 245 || index == 249 || index == 258 || index == 260 || index == 261
                    || index == 265 || index == 274)
                runSys = 3;
            else 
                runSys = 1;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR002+5.ax')") != string::npos) {
        if (strConj.find("fof(query") != string::npos) {
            int begPos = strConj.find_first_of("y");
            begPos += 1;
            int endPos = strConj.find_first_of(",");
            string temp = strConj.substr(begPos, endPos - begPos);
            int index = atoi(temp.c_str());
            if (index == 290 || index == 295 || index == 302 || index == 306 || index == 308)
                runSys = 3;
            else 
                runSys = 1;
        }
        else if (strConj == "")
            runSys = 3;
        return runSys;
    }    
    
    if (strAxiom.find("include('Axioms/CSR003+0.ax')") != string::npos) {
        if (strConj.find("fof(prove_from_SUMO,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 201;
            StrategyParam::timeForceLimit = 30; 
            runSys = 2;
        } 
        return runSys;
    }  
    
    if (strAxiom.find("include('Axioms/CSR003+1.ax')") != string::npos) {
        if (strConj.find("fof(prove_from_SUMO_MILO,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 199;
            StrategyParam::timeForceLimit = 30; 
            runSys = 2;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR003+2.ax')") != string::npos) {
        if (strConj.find("fof(abe_mammal,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 16;
            StrategyParam::timeForceLimit = 44; 
            runSys = 2;
        } 
        else if (strConj.find("fof(prove_from_ALL,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 280;
            StrategyParam::timeForceLimit = 10; 
            runSys = 2;
        }        
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR004+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR006+0.ax')") != string::npos) {
        if (strConj.find("fof(antonymPattern") != string::npos) {
            int begPos = strConj.find_first_of("Pattern");
            begPos += 7;
            int endPos = strConj.find_first_of(",");
            string temp = strConj.substr(begPos, endPos - begPos);
            int index = atoi(temp.c_str());
            if (index == 10007 || (index >= 20012 && index <= 20235) || index == 30068 
                    || index == 30584 || (index >= 31444 && index <= 32292))
                runSys = 3;
        }
        else if (strConj.find("fof(negatedCommonSubclassEvent") != string::npos && strConj.find("fof(negatedCommonSubclassEvent0035,") == string::npos
                && strConj.find("fof(negatedCommonSubclassEvent0106,") == string::npos && strConj.find("fof(negatedCommonSubclassEvent0110,") == string::npos
                && strConj.find("fof(negatedCommonSubclassEvent0219,") == string::npos)
            runSys = 3;
        else if (strConj.find("negatedInstrumentRelation0342,") != string::npos)
            runSys = 3;
        else if (strConj.find("negatedMultipleMapping,") != string::npos) {
            StrategyParam::firstRunTime = 209;
            StrategyParam::timeForceLimit = 20;
            runSys = 2;
        }
        else if (strConj.find("negatedSubclassEvent0182,") != string::npos) {
            runSys = 3;
        }
        else if (strConj.find("negatedResultRelation,") != string::npos) {
            StrategyParam::firstRunTime = 200;
            StrategyParam::timeForceLimit = 23;
            runSys = 2;
        }
        else if (strConj.find("fof(agentRelation") != string::npos) {
            runSys = 3;
        } 
        else if (strConj.find("fof(instrumentRelation") != string::npos) {
            if (strConj.find("0028") != string::npos)
                runSys = 3;
        }
        else if (strConj.find("fof(multipleMapping0010,") != string::npos) {
            runSys = 3;
        } 
        else if (strConj.find("fof(resultRelation") != string::npos) {
            runSys = 3;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO004+0.ax')") != string::npos) {
        if (strConj.find("fof(corollary_2_12,conjecture") != string::npos || strConj.find("fof(theorem_3_6,conjecture") != string::npos
                || strConj.find("fof(theorem_4_6_1,conjecture") != string::npos || strConj.find("fof(theorem_4_6_2,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 50; 
            runSys = 3;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO006+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO007+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO008+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO009+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO010+0.ax')") != string::npos) {
        if (strConj.find("fof(aDISTu_") == string::npos && strConj.find("fof(aLIFTu_D") == string::npos
                && strConj.find("fof(aLIFTu_E") == string::npos && strConj.find("fof(aMATRIXu_V") == string::npos
                && strConj.find("fof(aNORMu_PASTECARTu_0u") == string::npos
                && strConj.find("fof(aNORMu_POSu_LT,") == string::npos && strConj.find("fof(aR") == string::npos
                && strConj.find("fof(aVE") == string::npos && strConj.find("fof(aSIGNu_I,conjecture") == string::npos
                && strConj.find("fof(aSPANu_SUB,") == string::npos && strConj.find("fof(aSPANu_CLAUSESu_conjunct1,") == string::npos
                && strConj.find("fof(aSPANu_NEG,") == string::npos)
            runSys = 3;
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO011+0.ax')") != string::npos) {
        if (strConj.find("fof(aSatz") != string::npos) {
            if (strConj.find("fof(aSatz4_") != string::npos
                    || strConj.find("fof(aSatz7_22") != string::npos || strConj.find("fof(aSatz9_4") != string::npos
                    || strConj.find("fof(aSatz11_7") != string::npos || strConj.find("fof(aSatz11_49b") != string::npos)
                runSys = 3;
        }
        else if (strConj.find("fof(aExtSameSide") != string::npos)
            runSys = 3;
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GRA001+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GRA007+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/HAL001+0.ax')") != string::npos) {
        if (strConj.find("fof(g_injection,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 12;
            StrategyParam::timeForceLimit = 28; 
            runSys = 2;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/ITP001/ITP001+2.ax')") != string::npos) {
        if (strConj.find("fof(conj_thm_2Earithmetic_2EMOD__2,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 12;
            StrategyParam::timeForceLimit = 28; 
            runSys = 2;
        } 
        else if (strConj.find("fof(conj_thm_2Ebitstring_2Eword__1comp__v2w,conjecture") != string::npos || strConj.find("fof(conj_thm_2Equotient__option_2EOPTION__REL__def,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 14;
            StrategyParam::timeForceLimit = 26; 
            runSys = 2;
        } 
        else if (strConj.find("fof(conj_thm_2Eextreal_2Emax__le,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 15;
            StrategyParam::timeForceLimit = 26; 
            runSys = 2;
        } 
        else if (strConj.find("fof(conj_thm_2Elebesgue_2Epos__fn__integral__cmul,conjecture") != string::npos || strConj.find("fof(conj_thm_2Ereal__topology_2ECLOSED__UNION__COMPACT__SUBSETS,conjecture") != string::npos
                || strConj.find("fof(conj_thm_2Ereal__topology_2EINDEPENDENT__STDBASIS,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 50; 
            runSys = 3;
        } 
        else if (strConj.find("fof(conj_thm_2Eoption_2EOPTION__MAP2__THM,conjecture") != string::npos || strConj.find("fof(conj_thm_2EpatternMatches_2EPMATCH__FLATTEN__FUN__PMATCH__ROW,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 12;
            StrategyParam::timeForceLimit = 28; 
            runSys = 2;
        } 
        else if (strConj.find("fof(conj_thm_2Ereal__topology_2EBOUNDED__BALL,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 162;
            StrategyParam::timeForceLimit = 18; 
            runSys = 2;
        }
        else if (strConj.find("fof(conj_thm_2Ereal_2ESUP__EPSILON,conjecture") != string::npos || strConj.find("fof(conj_thm_2Eseq_2EBOLZANO__LEMMA,conjecture") != string::npos
                || strConj.find("fof(conj_thm_2Ewords_2En2w__sub,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 18;
            StrategyParam::timeForceLimit = 22; 
            runSys = 2;
        }
        else if (strConj.find("fof(conj_thm_2Eutil__prob_2ENUM__2D__BIJ__INV,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 331;
            StrategyParam::timeForceLimit = 5; 
            runSys = 2;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/ITP001/ITP002+4.ax')") != string::npos) {
        if (strConj.find("fof(thm_2Ebinary__ieee_2Eneg__ulp,conjecture") == string::npos && strConj.find("fof(thm_2Ecomplex_2ECOMPLEX__INV__NZ,conjecture") == string::npos
                && strConj.find("fof(thm_2Ebool_2ETRUTH,conjecture") == string::npos && strConj.find("fof(thm_2Ecardinal_2ECARD__NOT__LE,conjecture") == string::npos
                && strConj.find("fof(thm_2Epred__set_2EREST__SUBSET,conjecture") == string::npos && strConj.find("fof(thm_2EquantHeuristics_2EGUESS__RULES__WEAKEN__FORALL__POINT,conjecture") == string::npos
                && strConj.find("fof(thm_2Ereal_2ESUP__EPSILON,conjecture") == string::npos
                && strConj.find("fof(thm_2Eseq_2EBOLZANO__LEMMA,conjecture") == string::npos
                && strConj.find("fof(thm_2Eutil") == string::npos
                && strConj.find("fof(thm_2Eextreal") == string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 50; 
            runSys = 3;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/KLE001+0.ax')") != string::npos) {
        if (strConj.find("fof(goals,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 268;
            StrategyParam::timeForceLimit = 25; 
            runSys = 2;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/KLE002+0.ax')") != string::npos) {
        if (strConj.find("fof(goals,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 343;
            StrategyParam::timeForceLimit = 5; 
            runSys = 2;
        } 
        else if (strConj.find("fof(a,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 226;
            StrategyParam::timeForceLimit = 13;
            runSys = 2;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/KLE004+0.ax')") != string::npos) {
        if (strConj.find("fof(goals,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 330;
            StrategyParam::timeForceLimit = 8; 
            runSys = 2;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/KRS001+0.ax')") != string::npos) {
        if (strConj.find("fof(mighta_wth_thm,conjecture") != string::npos
                || strConj.find("fof(xora_csa_thm,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 240;
            StrategyParam::timeForceLimit = 0; 
            runSys = 3;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/KRS001+1.ax')") != string::npos)
        return runSys;
    
    if (strAxiom.find("include('Axioms/LCL006+0.ax')") != string::npos) {
        if ( strConj.find("fof(principia_r4,conjecture,r4") != string::npos) {
            StrategyParam::firstRunTime = 191;
            StrategyParam::timeForceLimit = 35; 
            runSys = 2;
        } 
        else if (strConj.find("fof(principia_r5,conjecture,r5") != string::npos) {
            StrategyParam::firstRunTime = 17;
            StrategyParam::timeForceLimit = 25; 
            runSys = 2;
        }
        else if (strConj.find("fof(rosser_kn3,conjecture,kn3") != string::npos) {
            StrategyParam::firstRunTime = 294;
            StrategyParam::timeForceLimit = 10; 
            runSys = 2;
        }
        else if (strConj.find("fof(s1_0_axiom_m5,conjecture,axiom_m5") != string::npos
                || strConj.find("fof(s1_0_m6s3m9b_axiom_s3,conjecture,axiom_s3") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 50; 
            runSys = 3;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/LCL006+1.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/MED001+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/MGT001+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/NLP001+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/NUM005+0.ax')") != string::npos) {
        if (strConj.find("fof(associative_sum,conjecture") != string::npos 
                || strConj.find("fof(show_lower_boundary,conjecture") != string::npos || strConj.find("fof(show_upper_boundary,conjecture") != string::npos
                || strConj.find("fof(sum_n23_n34_n57,conjecture") != string::npos || strConj.find("fof(sum_n23_something_n34,conjecture") != string::npos
                || strConj.find("fof(sum_something_n23_n34,conjecture") != string::npos || strConj.find("fof(summ_n23_n34_something,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/NUM008+0.ax')") != string::npos) {
        if (strConj.find("fof(primeexist,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/NUM009+0.ax')") != string::npos) {
        if (strConj.find("fof(oneplustwoidthree,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/PHI002+0.ax')") != string::npos)
        return runSys;
    
    if (strAxiom.find("include('Axioms/PRD001+0.ax')") != string::npos)
        return runSys;
    
    
    if (strAxiom.find("include('Axioms/REL001+0.ax')") != string::npos) {
        if (strConj.find("fof(goals,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 294;
            StrategyParam::timeForceLimit = 10; 
            runSys = 2;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SET005+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SET006+0.ax')") != string::npos) {
        if (strConj.find("fof(set_partitions_itself,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;
        }
        else if (strConj.find("fof(thV") != string::npos) {
            if (strConj.find("1,conjecture") != string::npos || strConj.find("15,conjecture") != string::npos
                    || strConj.find("16,conjecture") != string::npos || strConj.find("21,conjecture") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(thIV") != string::npos) {
            if (strConj.find("17,conjecture") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(thIII") != string::npos) {
            if (strConj.find("02,conjecture") == string::npos && strConj.find("03,conjecture") == string::npos
                    && strConj.find("12,conjecture") == string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(thII") != string::npos) {
            if (strConj.find("03a,conjecture") == string::npos && strConj.find("05,conjecture") == string::npos
                    && strConj.find("06,conjecture") == string::npos && strConj.find("08,conjecture") == string::npos
                    && strConj.find("11,conjecture") == string::npos && strConj.find("12,conjecture") == string::npos
                    && strConj.find("13,conjecture") == string::npos && strConj.find("22,conjecture") == string::npos
                    && strConj.find("24,conjecture") == string::npos && strConj.find("25,conjecture") == string::npos
                    && strConj.find("a01,conjecture") == string::npos && strConj.find("a03,conjecture") == string::npos
                    && strConj.find("a04,conjecture") == string::npos && strConj.find("a05,conjecture") == string::npos
                    && strConj.find("a08,conjecture") == string::npos && strConj.find("a12,conjecture") == string::npos
                    && strConj.find("a13,conjecture") == string::npos && strConj.find("a14,conjecture") == string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(thI") != string::npos) {
            if (strConj.find("10,conjecture") != string::npos || strConj.find("21,conjecture") != string::npos
                    || strConj.find("25,conjecture") != string::npos || strConj.find("26,conjecture") != string::npos
                    || strConj.find("32,conjecture") != string::npos
                    || strConj.find("37,conjecture") != string::npos || strConj.find("40,conjecture") != string::npos
                    || strConj.find("49,conjecture") != string::npos) {
                runSys = 3;
            }
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SET006+3.ax')") != string::npos)
        return runSys;
    
    if (strAxiom.find("include('Axioms/SET007/SET007+0.ax')") != string::npos) {
        if (strConj.find("_autgroup,conjecture") != string::npos) {
            if (strConj.find("t12") != string::npos || strConj.find("t14") != string::npos
                    || strConj.find("t15") != string::npos || strConj.find("t3") != string::npos
                    || strConj.find("t30") != string::npos || strConj.find("t7") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_latsum_1,conjecture") != string::npos) {
            if (strConj.find("t19") != string::npos || strConj.find("t23") != string::npos
                    || strConj.find("t7") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t11") != string::npos) {
                StrategyParam::firstRunTime = 282;
                StrategyParam::timeForceLimit = 4; 
                runSys = 2;
            }
            else if (strConj.find("t20") != string::npos) {
                StrategyParam::firstRunTime = 272;
                StrategyParam::timeForceLimit = 15; 
                runSys = 2;
            }
        }
        else if (strConj.find("_tsp_2,conjecture") != string::npos) {
            if (strConj.find("t1") != string::npos ||  strConj.find("t13") != string::npos
                    || strConj.find("t30") != string::npos || strConj.find("t31") != string::npos
                    || strConj.find("t34") != string::npos || strConj.find("t35") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t24") != string::npos) {
                StrategyParam::firstRunTime = 285;
                StrategyParam::timeForceLimit = 13; 
                runSys = 2;
            }
        }
        else if (strConj.find("_waybel22,conjecture") != string::npos) {
            if (strConj.find("t1") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t6") != string::npos) {
                StrategyParam::firstRunTime = 295;
                StrategyParam::timeForceLimit = 10; 
                runSys = 2;
            }
        }
        else if (strConj.find("_latsubgr,conjecture") != string::npos) {
            if (strConj.find("t10") != string::npos || strConj.find("t13") != string::npos
                    || strConj.find("t33") != string::npos || strConj.find("t35") != string::npos
                    || strConj.find("t38") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t31") != string::npos) {
                StrategyParam::firstRunTime = 190;
                StrategyParam::timeForceLimit = 34; 
                runSys = 2;
            }
        }
        else if (strConj.find("_lopclset,conjecture") != string::npos) {
            if (strConj.find("t10") != string::npos || strConj.find("t44") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t27") != string::npos) {
                StrategyParam::firstRunTime = 285;
                StrategyParam::timeForceLimit = 15; 
                runSys = 2;
            }
        }
        else if (strConj.find("_conlat_2,conjecture") != string::npos) {
            if (strConj.find("t20") == string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_rmod_5,conjecture") != string::npos) {
            if (strConj.find("t11") != string::npos || strConj.find("t12") != string::npos
                    || strConj.find("t4") != string::npos
                    || strConj.find("t18") != string::npos || strConj.find("t2") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t14") != string::npos) {
                StrategyParam::firstRunTime = 16;
                StrategyParam::timeForceLimit = 29; 
                runSys = 2;
            }
            else if (strConj.find("t16") != string::npos) {
                StrategyParam::firstRunTime = 193;
                StrategyParam::timeForceLimit = 27; 
                runSys = 2;
            }
            else if (strConj.find("t6") != string::npos) {
                StrategyParam::firstRunTime = 130;
                StrategyParam::timeForceLimit = 29; 
                runSys = 2;
            }
        }
        else if (strConj.find("_closure3,conjecture") != string::npos) {
            if (strConj.find("t4") != string::npos || strConj.find("t5") != string::npos
                    || strConj.find("t6") != string::npos || strConj.find("t8") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t12") != string::npos) {
                StrategyParam::firstRunTime = 35;
                StrategyParam::timeForceLimit = 16; 
                runSys = 2;
            }
        }
        else if (strConj.find("_filter_2,conjecture") != string::npos) {
            if (strConj.find("t12") != string::npos || strConj.find("t16") != string::npos
                    || strConj.find("t17") != string::npos || strConj.find("t34") != string::npos
                    || strConj.find("t36") != string::npos || strConj.find("t4") != string::npos
                    || strConj.find("t40") != string::npos || strConj.find("t48") != string::npos
                    || strConj.find("t50") != string::npos || strConj.find("t52") != string::npos
                    || strConj.find("t56") != string::npos || strConj.find("t59") != string::npos
                    || strConj.find("t61") != string::npos || strConj.find("t62") != string::npos
                    || strConj.find("t65") != string::npos || strConj.find("t66") != string::npos
                    || strConj.find("t67") != string::npos || strConj.find("t77") != string::npos
                    || strConj.find("t79") != string::npos || strConj.find("t85") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t13") != string::npos || strConj.find("t26") != string::npos
                    || strConj.find("t27") != string::npos || strConj.find("t32") != string::npos
                    || strConj.find("t54") != string::npos || strConj.find("t58") != string::npos) {
                StrategyParam::firstRunTime = 17;
                StrategyParam::timeForceLimit = 26; 
                runSys = 2;
            }
            else if (strConj.find("t25") != string::npos) {
                StrategyParam::firstRunTime = 192;
                StrategyParam::timeForceLimit = 28; 
                runSys = 2;
            }
            else if (strConj.find("t31") != string::npos) {
                StrategyParam::firstRunTime = 214;
                StrategyParam::timeForceLimit = 12; 
                runSys = 2;
            }
            else if (strConj.find("t41") != string::npos) {
                StrategyParam::firstRunTime = 27;
                StrategyParam::timeForceLimit = 25; 
                runSys = 2;
            }
            else if (strConj.find("t76") != string::npos) {
                StrategyParam::firstRunTime = 270;
                StrategyParam::timeForceLimit = 16; 
                runSys = 2;
            }
            else if (strConj.find("t8") != string::npos) {
                StrategyParam::firstRunTime = 295;
                StrategyParam::timeForceLimit = 9; 
                runSys = 2;
            }
            else if (strConj.find("t35") != string::npos) {
                StrategyParam::firstRunTime = 227;
                StrategyParam::timeForceLimit = 22; 
                runSys = 2;
            }
        }
        else if (strConj.find("_relset_2,conjecture") != string::npos) {
            if (strConj.find("t40") != string::npos
                    || strConj.find("t41") != string::npos || strConj.find("t43") != string::npos
                    || strConj.find("t5") != string::npos || strConj.find("t53") != string::npos
                    || strConj.find("t55") != string::npos
                    || strConj.find("t64") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t18") != string::npos || strConj.find("t28") != string::npos) {
                StrategyParam::firstRunTime = 17;
                StrategyParam::timeForceLimit = 26; 
                runSys = 2;
            }
            else if (strConj.find("t7") != string::npos) {
                StrategyParam::firstRunTime = 350;
                StrategyParam::timeForceLimit = 3; 
                runSys = 2;
            }
            else if (strConj.find("t36") != string::npos) {
                StrategyParam::firstRunTime = 193;
                StrategyParam::timeForceLimit = 25; 
                runSys = 2;
            }
            else if (strConj.find("t65") != string::npos) {
                StrategyParam::firstRunTime = 233;
                StrategyParam::timeForceLimit = 25; 
                runSys = 2;
            }
            else if (strConj.find("t57") != string::npos) {
                StrategyParam::firstRunTime = 290;
                StrategyParam::timeForceLimit = 15; 
                runSys = 2;
            }
        }
        else if (strConj.find("_waybel34,conjecture") != string::npos) {
            if (strConj.find("t17") != string::npos || strConj.find("t20") != string::npos
                    || strConj.find("t42") != string::npos
                    || strConj.find("t43") != string::npos
                    || strConj.find("t65") != string::npos || strConj.find("t71") != string::npos
                    || strConj.find("t8") != string::npos || strConj.find("t9") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t4") != string::npos) {
                StrategyParam::firstRunTime = 304;
                StrategyParam::timeForceLimit = 6; 
                runSys = 2;
            }
            else if (strConj.find("t12") != string::npos) {
                StrategyParam::firstRunTime = 294;
                StrategyParam::timeForceLimit = 6; 
                runSys = 2;
            }
            else if (strConj.find("t26") != string::npos) {
                StrategyParam::firstRunTime = 50;
                StrategyParam::timeForceLimit = 14; 
                runSys = 2;
            }
            else if (strConj.find("t49") != string::npos) {
                StrategyParam::firstRunTime = 231;
                StrategyParam::timeForceLimit = 16; 
                runSys = 2;
            }
            else if (strConj.find("t5") != string::npos) {
                StrategyParam::firstRunTime = 303;
                StrategyParam::timeForceLimit = 6; 
                runSys = 2;
            }
        }
        else if (strConj.find("_isocat_2,conjecture") != string::npos) {
            if (strConj.find("t40") == string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(t4_yoneda_1,conjecture") != string::npos){
            runSys = 3;
        }
        else if (strConj.find("fof(t8_waybel33,conjecture") != string::npos){
            runSys = 3;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SWB001+0.ax')") != string::npos) {
        if (strConj.find("fof(conclusion_rdfbased_sem_") != string::npos) {
            if (strConj.find("fof(conclusion_rdfbased_sem_bool_") != string::npos && strConj.find("fof(conclusion_rdfbased_sem_bool_tollens,conjecture") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;            
            }
            else if (strConj.find("fof(conclusion_rdfbased_sem_chain_ext,conjecture") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_char_symmetric_ext,conjecture") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_char_transitive_ext,conjecture") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_enum_ext,conjecture") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_eqdis_disjointunion_composite,conjecture") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_inv_ext,conjecture") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_ndis_alldi") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_restrict_allvalues_cmp_") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_restrict_exactqcr_inst_obj_two,conjecture") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_restrict_maxqcr_") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_restrict_minqcr_cmp_") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_restrict_minqcr_inst_obj_one,conjecture") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_restrict_somevalues_cmp_") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_restrict_term_cardqcr,conjecture") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_restrict_term_dataqcr,conjecture") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_restrict_term_minmax") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_restrict_term_sameall,conjecture") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_restrict_term_some") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;            
            }            
        }
        else if (strConj.find("fof(testcase_conclusion_fullish_0") != string::npos) {
            if (strConj.find("fof(testcase_conclusion_fullish_01") != string::npos && strConj.find("fof(testcase_conclusion_fullish_015") == string::npos
                    && strConj.find("fof(testcase_conclusion_fullish_017") == string::npos && strConj.find("fof(testcase_conclusion_fullish_018") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;
            }
            else if (strConj.find("fof(testcase_conclusion_fullish_02") != string::npos && strConj.find("fof(testcase_conclusion_fullish_023") == string::npos
                    && strConj.find("fof(testcase_conclusion_fullish_024") == string::npos && strConj.find("fof(testcase_conclusion_fullish_026") == string::npos
                    && strConj.find("fof(testcase_conclusion_fullish_029") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;
            }
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SWC001+0.ax')") != string::npos) {
        if (strConj.find("fof(co1,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 345;
            StrategyParam::timeForceLimit = 4; 
            runSys = 2; 
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SWV003+0.ax')") != string::npos) {
        if (strConj.find("fof(gauss_init_00") != string::npos) {
            if (strConj.find("fof(gauss_init_0001,conjecture") == string::npos && strConj.find("fof(gauss_init_0005,conjecture") == string::npos 
                    && strConj.find("fof(gauss_init_0033,conjecture") == string::npos && strConj.find("fof(gauss_init_0037,conjecture") == string::npos
                    && strConj.find("fof(gauss_init_0041,conjecture") == string::npos && strConj.find("fof(gauss_init_0045,conjecture") == string::npos
                    && strConj.find("fof(gauss_init_0077,conjecture") == string::npos && strConj.find("fof(gauss_init_0081,conjecture") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;
            }
        }
        else if (strConj.find("fof(quaternion_ds1_symm_") != string::npos) {
            if (strConj.find("fof(quaternion_ds1_symm_0002,conjecture") != string::npos || strConj.find("fof(quaternion_ds1_symm_0004,conjecture") != string::npos
                    || strConj.find("fof(quaternion_ds1_symm_0008,conjecture") != string::npos || strConj.find("fof(quaternion_ds1_symm_0011,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;
            }
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SWV007+0.ax')") != string::npos) {
        if (strConj.find("fof(co3,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 12;
            StrategyParam::timeForceLimit = 28; 
            runSys = 2;            
        }
        else if (strConj.find("fof(l29_co,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;            
        }
        return runSys;
    }
     
    if (strAxiom.find("include('Axioms/SWV011+0.ax')") != string::npos) {
        if (strConj.find("fof(conj,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 267;
            StrategyParam::timeForceLimit = 20; 
            runSys = 2;            
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SWV012+0.ax')") != string::npos) {
        if (strConj.find("fof(exists1_exists2,conjecture") != string::npos
                || strConj.find("fof(or1_or2,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;            
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SYN002+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom == "") {
        if (strConj.find("fof(addAssertion,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 154;
            StrategyParam::timeForceLimit = 25; 
            runSys = 2;            
        }
        else if (strConj.find("fof(co1,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 204;
            StrategyParam::timeForceLimit = 25; 
            runSys = 2;            
        }
        else if (strConj.find("fof(conj_") != string::npos) {
            if (strConj.find("fof(conj_0,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 331;
                StrategyParam::timeForceLimit = 7; 
                runSys = 2;            
            }
            else if (strConj.find("fof(conj_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 329;
                StrategyParam::timeForceLimit = 9; 
                runSys = 2;            
            }
            else if (strConj.find("fof(conj_2,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 298;
                StrategyParam::timeForceLimit = 15; 
                runSys = 2;            
            }
            else if (strConj.find("fof(conj_3,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 346;
                StrategyParam::timeForceLimit = 3; 
                runSys = 2;            
            }
            else if (strConj.find("fof(conj_7,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 297;
                StrategyParam::timeForceLimit = 14; 
                runSys = 2;            
            }
        }
        else if (strConj.find("fof('cont(412,0)',conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;               
        }
        else if (strConj.find("fof(goal_to_be_proved,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 159;
            StrategyParam::timeForceLimit = 28; 
            runSys = 2;               
        }
        else if (strConj.find("fof(goals,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 286;
            StrategyParam::timeForceLimit = 18; 
            runSys = 2;               
        }
        else if (strConj.find("fof(goals_09,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 12;
            StrategyParam::timeForceLimit = 28; 
            runSys = 2;               
        }
        else if (strConj == "") {
            StrategyParam::firstRunTime = 198;
            StrategyParam::timeForceLimit = 22; 
            runSys = 2;             
        }
        else if (strConj.find("fof(m__,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 300;
            StrategyParam::timeForceLimit = 12; 
            runSys = 2;               
        }
        else if (strConj.find("fof('holds(") != string::npos) {
            if (strConj.find("fof('holds(3") != string::npos && strConj.find("fof('holds(307") == string::npos
                    && strConj.find("fof('holds(324") == string::npos && strConj.find("fof('holds(380") == string::npos
                    && strConj.find("fof('holds(331") == string::npos && strConj.find("fof('holds(363") == string::npos
                    && strConj.find("fof('holds(364") == string::npos && strConj.find("fof('holds(384") == string::npos
                    && strConj.find("fof('holds(379") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;     
            }
            else if (strConj.find("fof('holds(4") != string::npos && strConj.find("fof('holds(407") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;
            } 
            else if (strConj.find("fof('holds(conjunct1(") != string::npos) {
                if (strConj.find("fof('holds(conjunct1(338), 1268, 0)',conjecture") != string::npos
                        || strConj.find("fof('holds(conjunct1(conjunct2(338)), 1269, 0)',conjecture") != string::npos
                        || strConj.find("fof('holds(conjunct1(conjunct2(359)), 1319, 0)',conjecture") != string::npos) {
                    StrategyParam::firstRunTime = 0;
                    StrategyParam::timeForceLimit = 240; 
                    runSys = 3;   
                }
            }
            else if (strConj.find("fof('holds(conjunct2(") != string::npos) {
                if (strConj.find("fof('holds(conjunct2(conjunct2(266)), 1177, 0)',conjecture") == string::npos
                        && strConj.find("fof('holds(conjunct2(362), 1325, 0)',conjecture") == string::npos
                        && strConj.find("fof('holds(conjunct2(conjunct2(359)), 1320, 0)',conjecture") == string::npos) {
                    StrategyParam::firstRunTime = 0;
                    StrategyParam::timeForceLimit = 240; 
                    runSys = 3;   
                }
            }
        }
        else if (strConj.find("_wellord1,conjecture") != string::npos) {
            if (strConj.find("fof(l") != string::npos) {
                if (strConj.find("fof(l2") != string::npos || strConj.find("fof(l3") != string::npos
                        || strConj.find("fof(l4") != string::npos) {
                    StrategyParam::firstRunTime = 13;
                    StrategyParam::timeForceLimit = 27; 
                    runSys = 2;              
                }
            }
            else if (strConj.find("fof(t") != string::npos) {
                if (strConj.find("fof(t17") != string::npos
                        || strConj.find("fof(t49") != string::npos) {
                    StrategyParam::firstRunTime = 0;
                    StrategyParam::timeForceLimit = 240; 
                    runSys = 3;              
                }
                else if (strConj.find("fof(t19_wellord1,conjecture") != string::npos
                        || strConj.find("fof(t21_wellord1,conjecture") != string::npos || strConj.find("fof(t22_wellord1,conjecture") != string::npos
                        || strConj.find("fof(t24_wellord1,conjecture") != string::npos || strConj.find("fof(t25_wellord1,conjecture") != string::npos) {
                    StrategyParam::firstRunTime = 25;
                    StrategyParam::timeForceLimit = 25; 
                    runSys = 2;              
                }
                else if (strConj.find("fof(t23") != string::npos) {
                    StrategyParam::firstRunTime = 242;
                    StrategyParam::timeForceLimit = 24; 
                    runSys = 2;              
                }
            }
        }
        else if (strConj.find("_zfmisc_1,conjecture") != string::npos) {
            if (strConj.find("fof(l55_zfmisc_1,conjecture") != string::npos || strConj.find("fof(t118_zfmisc_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 13;
                StrategyParam::timeForceLimit = 27; 
                runSys = 2;   
            }
            else if (strConj.find("fof(t101_zfmisc_1,conjecture") != string::npos || strConj.find("fof(t105_zfmisc_1,conjecture") != string::npos
                    || strConj.find("fof(t118_zfmisc_1,conjecture") != string::npos || strConj.find("fof(t122_zfmisc_1,conjecture") != string::npos
                    || strConj.find("fof(t123_zfmisc_1,conjecture") != string::npos || strConj.find("fof(t125_zfmisc_1,conjecture") != string::npos
                    || strConj.find("fof(t136_zfmisc_1,conjecture") != string::npos || strConj.find("fof(t36_zfmisc_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;   
            }
        }
        else if (strConj.find("_xboole_1,conjecture") != string::npos) {
            if (strConj.find("fof(t45_xboole_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 183;
                StrategyParam::timeForceLimit = 20; 
                runSys = 2;
            }
        }
        else if (strConj.find("_funct_1,conjecture") != string::npos) {
            if (strConj.find("fof(t118_funct_1,conjecture") != string::npos || strConj.find("fof(t121_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t137_funct_1,conjecture") != string::npos || strConj.find("fof(t138_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t139_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t150_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t151_funct_1,conjecture") != string::npos || strConj.find("fof(t154_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t155_funct_1,conjecture") != string::npos || strConj.find("fof(t160_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t20_funct_1,conjecture") != string::npos || strConj.find("fof(t37_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t43_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t51_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t85_funct_1,conjecture") != string::npos || strConj.find("fof(t9_funct_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;
            }
            else if (strConj.find("fof(t145_funct_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 13;
                StrategyParam::timeForceLimit = 25; 
                runSys = 2;
            }
            else if (strConj.find("fof(t21_funct_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 105;
                StrategyParam::timeForceLimit = 5; 
                runSys = 2;
            }
            else if (strConj.find("fof(t22_funct_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 23;
                StrategyParam::timeForceLimit = 25; 
                runSys = 2;
            }
            else if (strConj.find("fof(t54_funct_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 92;
                StrategyParam::timeForceLimit = 25; 
                runSys = 2;
            }
        }
        else if (strConj.find("fof(n") != string::npos) {
            runSys = 1;
        }
        else if (strConj.find("fof(pel") != string::npos) {
            if (strConj.find("fof(pel53,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;                
            }
        }
        else if (strConj.find("fof(prove") != string::npos) {
            if (strConj.find("fof(prove_relset_1_33,conjecture") != string::npos || strConj.find("fof(prove_relset_1_35,conjecture") != string::npos
                    || strConj.find("fof(prove_th99,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;                
            }
        }
        else if (strConj.find("fof('qe(") != string::npos) {
            runSys = 1;
        }
        else if (strConj.find("fof(s1_") != string::npos) {
            if (strConj.find("fof(s1_xboole") == string::npos && strConj.find("fof(s1_funct_1__e16_22") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;                
            }
            else if (strConj.find("fof(s1_xboole") != string::npos) {
                if (strConj.find("pre_topc__1,conjecture") != string::npos) {
                    StrategyParam::firstRunTime = 12;
                    StrategyParam::timeForceLimit = 28; 
                    runSys = 2;
                }
                else if (strConj.find("wellord2") != string::npos) {
                    if (strConj.find("fof(s1_xboole_0__e10_24__wellord2__1,conjecture") != string::npos) {
                        runSys = 3;
                    }
                    else if (strConj.find("fof(s1_xboole_0__e6_22__wellord2,conjecture") != string::npos) {
                        runSys = 1;
                    }
                    else {
                        StrategyParam::firstRunTime = 12;
                        StrategyParam::timeForceLimit = 28; 
                        runSys = 2;
                    }
                }
                else if (strConj.find("waybel") != string::npos) {
                    StrategyParam::firstRunTime = 12;
                    StrategyParam::timeForceLimit = 28; 
                    runSys = 2;
                }
                else if (strConj.find("finset") != string::npos) {
                    StrategyParam::firstRunTime = 17;
                    StrategyParam::timeForceLimit = 28; 
                    runSys = 2;
                }
                else if (strConj.find("tops_2__1") != string::npos) {
                    StrategyParam::firstRunTime = 230;
                    StrategyParam::timeForceLimit = 14; 
                    runSys = 2;
                }
                else if (strConj.find("yellow19") != string::npos) {
                    StrategyParam::firstRunTime = 165;
                    StrategyParam::timeForceLimit = 28; 
                    runSys = 2;
                }
            }
        }
        else if (strConj.find("fof(s2_") != string::npos) {
            if (strConj.find("fof(s2_funct_1") != string::npos && strConj.find("tops_2") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;                  
            }
            else if (strConj.find("fof(s2_funct_1") != string::npos && strConj.find("wellord2") == string::npos) {
                runSys = 3;                  
            }
            else if (strConj.find("fof(s2_funct_1") != string::npos && strConj.find("wellord2") != string::npos) {
                StrategyParam::firstRunTime = 12;
                StrategyParam::timeForceLimit = 34; 
                runSys = 2;                   
            }
            else if (strConj.find("fof(s2_xboole_0") != string::npos) {
                StrategyParam::firstRunTime = 12;
                StrategyParam::timeForceLimit = 28; 
                runSys = 2;
            }
        }
        else if (strConj.find("fof(s3_") != string::npos) {
            if (strConj.find("fof(s3_subset_1__e1_40__pre_topc,conjecture") != string::npos || strConj.find("fof(s3_subset_1__e2_37_1_1__pre_topc,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 170;
                StrategyParam::timeForceLimit = 4; 
                runSys = 2;
            }
        } 
        else if (strConj.find("_tops_") != string::npos) {
            runSys = 1;
        }
        else if (strConj.find("fof(mv5,conjecture") != string::npos){
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;
        }
        else if (strConj.find("_autgroup,conjecture") != string::npos) {
            if (strConj.find("fof(t16") != string::npos || strConj.find("t26") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_latsum_1,conjecture") != string::npos) {
            if (strConj.find("fof(t19") != string::npos || strConj.find("t24") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_waybel22,conjecture") != string::npos) {
            runSys = 1;
        }
        else if (strConj.find("_yellow_1,conjecture") != string::npos) {
            if (strConj.find("fof(t2") != string::npos) {
                StrategyParam::firstRunTime = 12;
                StrategyParam::timeForceLimit = 24;
                runSys = 2;
            }
        }
        else if (strConj.find("_finsub_1,conjecture") != string::npos) {
            if (strConj.find("fof(t24") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_latsubgr,conjecture") != string::npos) {
            if (strConj.find("fof(t35") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_ordinal1,conjecture") != string::npos) {
            if (strConj.find("fof(t29") != string::npos
                    || strConj.find("fof(t35") != string::npos
                    || strConj.find("fof(t41") != string::npos || strConj.find("fof(t5") != string::npos
                    || strConj.find("fof(t6") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("fof(t32") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 24;
                runSys = 2;
            }
            else if (strConj.find("fof(t23") != string::npos) {
                StrategyParam::firstRunTime = 300;
                StrategyParam::timeForceLimit = 10;
                runSys = 2;
            }
        }
        else if (strConj.find("_lopclset,conjecture") != string::npos) {
            if (strConj.find("fof(t30") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_rmod_5,conjecture") != string::npos) {
            if (strConj.find("fof(t11") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_waybel_") != string::npos) {
            if (strConj.find("fof(t8_waybel_") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 24;
                runSys = 2;
            }
        }
        else if (strConj.find("_yellow19,conjecture") != string::npos) {
            if (strConj.find("fof(t18") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 24;
                runSys = 2;
            }
            else if (strConj.find("fof(t13") != string::npos || strConj.find("fof(t4") != string::npos
                    || strConj.find("fof(t9") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_relat_1,conjecture") != string::npos)  {
            if (strConj.find("fof(t115") != string::npos || strConj.find("fof(t143") != string::npos
                    || strConj.find("fof(t145") != string::npos
                    || strConj.find("fof(t178") != string::npos
                    || strConj.find("fof(t21") != string::npos || strConj.find("fof(t25") != string::npos
                    || strConj.find("fof(t44") != string::npos || strConj.find("fof(t45") != string::npos
                    || strConj.find("fof(t86") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 24;
                runSys = 2;
            }
            else if (strConj.find("fof(t117") != string::npos || strConj.find("fof(t71") != string::npos
                    || strConj.find("fof(t88") != string::npos) {
                StrategyParam::firstRunTime = 189;
                StrategyParam::timeForceLimit = 24;
                runSys = 2;
            }
            else if (strConj.find("fof(t119") != string::npos || strConj.find("fof(t140") != string::npos
                    || strConj.find("fof(t160") != string::npos
                    || strConj.find("fof(t46") != string::npos || strConj.find("fof(t47") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("fof(t146") != string::npos
                    || strConj.find("fof(t94") != string::npos) {
                StrategyParam::firstRunTime = 174;
                StrategyParam::timeForceLimit = 20;
                runSys = 2;
            }
            else if (strConj.find("fof(t37") != string::npos) {
                StrategyParam::firstRunTime = 26;
                StrategyParam::timeForceLimit = 25;
                runSys = 2;
            }
        }
        else if (strConj.find("_closure3,conjecture") != string::npos) {
            if (strConj.find("fof(t12") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_filter_2,conjecture") != string::npos) {
            if (strConj.find("fof(t2") != string::npos || strConj.find("fof(t35") != string::npos
                    || strConj.find("fof(t49") != string::npos
                    || strConj.find("fof(t52") != string::npos || strConj.find("fof(t56") != string::npos
                    || strConj.find("fof(t77") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_pre_topc,conjecture") != string::npos) {
            if (strConj.find("fof(t45") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("fof(t48") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 25;
                runSys = 2;
            }
        }
        else if (strConj.find("_relset_1,conjecture") != string::npos) {
            if (strConj.find("fof(t12") != string::npos || strConj.find("fof(t23") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 25;
                runSys = 2;
            }
        }
        else if (strConj.find("_relset_2,conjecture") != string::npos) {
            if (strConj.find("fof(t12") != string::npos || strConj.find("fof(t13") != string::npos
                    || strConj.find("fof(t14") != string::npos || strConj.find("fof(t22") != string::npos
                    || strConj.find("fof(t27") != string::npos || strConj.find("fof(t40") != string::npos
                    || strConj.find("fof(t5") != string::npos || strConj.find("fof(t8") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_waybel34,conjecture") != string::npos) {
            if (strConj.find("fof(t17") != string::npos || strConj.find("fof(t38") != string::npos
                    || strConj.find("fof(t45") != string::npos || strConj.find("fof(t46") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_finset_1,conjecture") != string::npos) {
            if (strConj.find("fof(t17") != string::npos || strConj.find("fof(t22") != string::npos
                    || strConj.find("fof(t23") != string::npos || strConj.find("fof(t31") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_yellow_0,conjecture") != string::npos) {
            if (strConj.find("fof(t15") != string::npos || strConj.find("fof(t16") != string::npos
                    || strConj.find("fof(t60") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 25;
                runSys = 2;
            }
        }
        else if (strConj.find("_yellow_6,conjecture") != string::npos) {
            if (strConj.find("fof(t21") != string::npos || strConj.find("fof(t28") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 25;
                runSys = 2;
            }
        }
        else if (strConj.find("_wellord2,conjecture") != string::npos) {
            if (strConj.find("fof(t3") != string::npos) {
                StrategyParam::firstRunTime = 162;
                StrategyParam::timeForceLimit = 28;
                runSys = 2;
            }
            else if (strConj.find("fof(t4") != string::npos) {
                StrategyParam::firstRunTime = 225;
                StrategyParam::timeForceLimit = 18;
                runSys = 2;
            }
        }
        else if (strConj.find("_orders_2,conjecture") != string::npos) {
            if (strConj.find("fof(t25") != string::npos) {
                StrategyParam::firstRunTime = 12;
                StrategyParam::timeForceLimit = 28;
                runSys = 2;
            }
        }
        else if (strConj.find("_waybel33,conjecture") != string::npos) {
            if (strConj.find("fof(t27") != string::npos || strConj.find("fof(t7") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_isocat_2,conjecture") != string::npos) {
            if ( strConj.find("fof(t43") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(tautology,conjecture") != string::npos) {
            runSys = 3;
        }
        else if (strConj.find("fof(thm_2E") != string::npos) {
            if (strConj.find("fof(thm_2Earith") != string::npos || strConj.find("fof(thm_2Equotient_") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(tlhfof") != string::npos) {
            if (strConj.find("fof(tlhfof34981,") != string::npos || strConj.find("fof(tlhfof40016,") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(main,") != string::npos) {
            StrategyParam::firstRunTime = 345;
            StrategyParam::timeForceLimit = 3;
            runSys = 2;
        }
        return runSys;
    }    
    return runSys;
}

int ReadOriProblem300(const string& problemFile) {
    int runSys = 1; //1 only run E; 2 E->CSE->E; 3 CSE->E
    string strConj = "";
    string strAxiom = "";
    string problemField = "";
    ifstream fin(problemFile);
    string str = "";
    bool flag = false;
    while (getline(fin, str)) {
        if (str.find("conjecture") != string::npos) {
            int begPos = str.find_first_of(",");
            int endPos = str.find_last_of(",");
            string temp = str.substr(begPos + 1, endPos - (begPos + 1));
            if (temp == "conjecture") {
                strConj = str;
                break;
            }
        }
        else if (str.find("include(") != string::npos && !flag) {
            strAxiom = str;
            flag = true;
        }
    }

    if (strAxiom.find("include('Axioms/AGT001") != string::npos) {
        if (strConj.find("fof(query_") != string::npos) {
            int begPos = strConj.find_first_of("_");
            begPos += 1;
            int endPos = strConj.find_first_of(",");
            string temp = strConj.substr(begPos, endPos - begPos);
            int index = atoi(temp.c_str());
            if (index == 8 || index == 11 || index == 21)
                runSys = 3;
            else if (index == 7 || index == 26) {
                StrategyParam::firstRunTime = 147;
                StrategyParam::timeForceLimit = 30; 
                runSys = 2;
            }
            else if (index == 13) {
                StrategyParam::firstRunTime = 158;
                StrategyParam::timeForceLimit = 34; 
                runSys = 2;
            }
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/BIO001") != string::npos) {
        return runSys;        
    }
    
    if (strAxiom.find("include('Axioms/COM001+0.ax')") != string::npos) {
        if (strConj.find("fof('T-Weak-FreeVar-") != string::npos) {
            if (strConj.find("-abs-2',") != string::npos)
                runSys = 3;
            else 
                runSys = 1;
        }
        else if (strConj.find("fof('T-subst-") != string::npos) {
            if (strConj.find("-abs-3',") != string::npos)
                runSys = 3;
            else 
                runSys = 1;
        }
        else if (strConj.find("fof('T-Preservation-T-") != string::npos) {
            if (strConj.find("app',") != string::npos)
                runSys = 3;
            else 
                runSys = 1;
        }
        else if (strConj.find("fof('T-Progress-T-") != string::npos) {
            if (strConj.find("app',") != string::npos)
                runSys = 3;
            else 
                runSys = 1;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR001+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR002+1.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR002+2.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR002+3.ax')") != string::npos) {
        if (strConj.find("fof(query") != string::npos) {
            int begPos = strConj.find_first_of("y");
            begPos += 1;
            int endPos = strConj.find_first_of(",");
            string temp = strConj.substr(begPos, endPos - begPos);
            int index = atoi(temp.c_str());
            if (index == 186 || index == 189 || index == 199 || index == 211)
                runSys = 3;
            else 
                runSys = 1;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR002+4.ax')") != string::npos) {
        if (strConj.find("fof(query") != string::npos) {
            int begPos = strConj.find_first_of("y");
            begPos += 1;
            int endPos = strConj.find_first_of(",");
            string temp = strConj.substr(begPos, endPos - begPos);
            int index = atoi(temp.c_str());
            if (index == 226 || index == 229 || index == 236 || index == 239 || index == 240
                    || index == 245 || index == 249 || index == 258 || index == 260 || index == 261
                    || index == 265 || index == 274)
                runSys = 3;
            else 
                runSys = 1;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR002+5.ax')") != string::npos) {
        if (strConj.find("fof(query") != string::npos) {
            int begPos = strConj.find_first_of("y");
            begPos += 1;
            int endPos = strConj.find_first_of(",");
            string temp = strConj.substr(begPos, endPos - begPos);
            int index = atoi(temp.c_str());
            if (index == 290 || index == 295 || index == 302 || index == 306 || index == 308)
                runSys = 3;
            else 
                runSys = 1;
        }
        else if (strConj == "")
            runSys = 3;
        return runSys;
    }    
    
    if (strAxiom.find("include('Axioms/CSR003+0.ax')") != string::npos) {
        if (strConj.find("fof(prove_from_SUMO,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 170;
            StrategyParam::timeForceLimit = 30; 
            runSys = 2;
        } 
        return runSys;
    }  
    
    if (strAxiom.find("include('Axioms/CSR003+1.ax')") != string::npos) {
        if (strConj.find("fof(prove_from_SUMO_MILO,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 169;
            StrategyParam::timeForceLimit = 30; 
            runSys = 2;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR003+2.ax')") != string::npos) {
        if (strConj.find("fof(abe_mammal,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 16;
            StrategyParam::timeForceLimit = 44; 
            runSys = 2;
        } 
        else if (strConj.find("fof(prove_from_ALL,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 280;
            StrategyParam::timeForceLimit = 5; 
            runSys = 2;
        }        
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR004+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR006+0.ax')") != string::npos) {
        if (strConj.find("fof(antonymPattern") != string::npos) {
            int begPos = strConj.find_first_of("Pattern");
            begPos += 7;
            int endPos = strConj.find_first_of(",");
            string temp = strConj.substr(begPos, endPos - begPos);
            int index = atoi(temp.c_str());
            if (index == 10007 || (index >= 20012 && index <= 20235) || index == 30068 
                    || index == 30584 || (index >= 31444 && index <= 32292))
                runSys = 3;
        }
        else if (strConj.find("fof(negatedCommonSubclassEvent") != string::npos && strConj.find("fof(negatedCommonSubclassEvent0035,") == string::npos)
            runSys = 3;
        else if (strConj.find("negatedInstrumentRelation0342,") != string::npos)
            runSys = 3;
        else if (strConj.find("negatedMultipleMapping,") != string::npos) {
            StrategyParam::firstRunTime = 149;
            StrategyParam::timeForceLimit = 20;
            runSys = 2;
        }
        else if (strConj.find("negatedSubclassEvent0182,") != string::npos) {
            runSys = 3;
        }
        else if (strConj.find("negatedResultRelation,") != string::npos) {
            StrategyParam::firstRunTime = 140;
            StrategyParam::timeForceLimit = 23;
            runSys = 2;
        }
        else if (strConj.find("fof(agentRelation") != string::npos) {
            runSys = 3;
        } 
        else if (strConj.find("fof(instrumentRelation") != string::npos) {
            if (strConj.find("0028") != string::npos)
                runSys = 3;
        }
        else if (strConj.find("fof(multipleMapping0010,") != string::npos) {
            runSys = 3;
        } 
        else if (strConj.find("fof(resultRelation") != string::npos) {
            runSys = 3;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO004+0.ax')") != string::npos) {
        if (strConj.find("fof(corollary_2_12,conjecture") != string::npos || strConj.find("fof(theorem_3_6,conjecture") != string::npos
                || strConj.find("fof(theorem_4_6_1,conjecture") != string::npos || strConj.find("fof(theorem_4_6_2,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 50; 
            runSys = 3;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO006+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO007+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO008+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO009+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO010+0.ax')") != string::npos) {
        if (strConj.find("fof(aDISTu_") == string::npos && strConj.find("fof(aLIFTu_D") == string::npos
                && strConj.find("fof(aLIFTu_E") == string::npos && strConj.find("fof(aMATRIXu_V") == string::npos
                && strConj.find("fof(aNORMu_PASTECARTu_0u") == string::npos
                && strConj.find("fof(aNORMu_POSu_LT,") == string::npos && strConj.find("fof(aR") == string::npos
                && strConj.find("fof(aVE") == string::npos && strConj.find("fof(aSIGNu_I,conjecture") == string::npos
                && strConj.find("fof(aSPANu_SUB,") == string::npos)
            runSys = 3;
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO011+0.ax')") != string::npos) {
        if (strConj.find("fof(aSatz") != string::npos) {
            if (strConj.find("fof(aSatz4_") != string::npos
                    || strConj.find("fof(aSatz7_22") != string::npos || strConj.find("fof(aSatz9_4") != string::npos
                    || strConj.find("fof(aSatz11_7") != string::npos || strConj.find("fof(aSatz11_49b") != string::npos)
                runSys = 3;
        }
        else if (strConj.find("fof(aExtSameSide") != string::npos)
            runSys = 3;
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GRA001+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GRA007+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/HAL001+0.ax')") != string::npos) {
        if (strConj.find("fof(g_injection,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 12;
            StrategyParam::timeForceLimit = 28; 
            runSys = 2;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/ITP001/ITP001+2.ax')") != string::npos) {
        if (strConj.find("fof(conj_thm_2Earithmetic_2EMOD__2,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 12;
            StrategyParam::timeForceLimit = 28; 
            runSys = 2;
        } 
        else if (strConj.find("fof(conj_thm_2Ebitstring_2Eword__1comp__v2w,conjecture") != string::npos || strConj.find("fof(conj_thm_2Equotient__option_2EOPTION__REL__def,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 14;
            StrategyParam::timeForceLimit = 26; 
            runSys = 2;
        } 
        else if (strConj.find("fof(conj_thm_2Eextreal_2Emax__le,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 15;
            StrategyParam::timeForceLimit = 26; 
            runSys = 2;
        } 
        else if (strConj.find("fof(conj_thm_2Elebesgue_2Epos__fn__integral__cmul,conjecture") != string::npos || strConj.find("fof(conj_thm_2Ereal__topology_2ECLOSED__UNION__COMPACT__SUBSETS,conjecture") != string::npos
                || strConj.find("fof(conj_thm_2Ereal__topology_2EINDEPENDENT__STDBASIS,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 50; 
            runSys = 3;
        } 
        else if (strConj.find("fof(conj_thm_2Eoption_2EOPTION__MAP2__THM,conjecture") != string::npos || strConj.find("fof(conj_thm_2EpatternMatches_2EPMATCH__FLATTEN__FUN__PMATCH__ROW,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 12;
            StrategyParam::timeForceLimit = 28; 
            runSys = 2;
        } 
        else if (strConj.find("fof(conj_thm_2Ereal__topology_2EBOUNDED__BALL,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 162;
            StrategyParam::timeForceLimit = 18; 
            runSys = 2;
        }
        else if (strConj.find("fof(conj_thm_2Ereal_2ESUP__EPSILON,conjecture") != string::npos || strConj.find("fof(conj_thm_2Eseq_2EBOLZANO__LEMMA,conjecture") != string::npos
                || strConj.find("fof(conj_thm_2Ewords_2En2w__sub,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 18;
            StrategyParam::timeForceLimit = 22; 
            runSys = 2;
        }
        else if (strConj.find("fof(conj_thm_2Eutil__prob_2ENUM__2D__BIJ__INV,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 279;
            StrategyParam::timeForceLimit = 5; 
            runSys = 2;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/ITP001/ITP002+4.ax')") != string::npos) {
        if (strConj.find("fof(thm_2Ebinary__ieee_2Eneg__ulp,conjecture") == string::npos && strConj.find("fof(thm_2Ecomplex_2ECOMPLEX__INV__NZ,conjecture") == string::npos
                && strConj.find("fof(thm_2Ebool_2ETRUTH,conjecture") == string::npos && strConj.find("fof(thm_2Ecardinal_2ECARD__NOT__LE,conjecture") == string::npos
                && strConj.find("fof(thm_2Epred__set_2EREST__SUBSET,conjecture") == string::npos && strConj.find("fof(thm_2EquantHeuristics_2EGUESS__RULES__WEAKEN__FORALL__POINT,conjecture") == string::npos
                && strConj.find("fof(thm_2Ereal_2ESUP__EPSILON,conjecture") == string::npos
                && strConj.find("fof(thm_2Eseq_2EBOLZANO__LEMMA,conjecture") == string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 50; 
            runSys = 3;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/KLE001+0.ax')") != string::npos) {
        if (strConj.find("fof(goals,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 237;
            StrategyParam::timeForceLimit = 15; 
            runSys = 2;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/KLE002+0.ax')") != string::npos) {
        if (strConj.find("fof(goals,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 285;
            StrategyParam::timeForceLimit = 5; 
            runSys = 2;
        } 
        else if (strConj.find("fof(a,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 196;
            StrategyParam::timeForceLimit = 13;
            runSys = 2;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/KLE004+0.ax')") != string::npos) {
        if (strConj.find("fof(goals,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 275;
            StrategyParam::timeForceLimit = 8; 
            runSys = 2;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/KRS001+0.ax')") != string::npos) {
        if (strConj.find("fof(mighta_wth_thm,conjecture") != string::npos
                || strConj.find("fof(xora_csa_thm,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 240;
            StrategyParam::timeForceLimit = 0; 
            runSys = 3;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/KRS001+1.ax')") != string::npos)
        return runSys;
    
    if (strAxiom.find("include('Axioms/LCL006+0.ax')") != string::npos) {
        if ( strConj.find("fof(principia_r4,conjecture,r4") != string::npos) {
            StrategyParam::firstRunTime = 160;
            StrategyParam::timeForceLimit = 35; 
            runSys = 2;
        } 
        else if (strConj.find("fof(principia_r5,conjecture,r5") != string::npos) {
            StrategyParam::firstRunTime = 17;
            StrategyParam::timeForceLimit = 25; 
            runSys = 2;
        }
        else if (strConj.find("fof(rosser_kn3,conjecture,kn3") != string::npos) {
            StrategyParam::firstRunTime = 246;
            StrategyParam::timeForceLimit = 10; 
            runSys = 2;
        }
        else if (strConj.find("fof(s1_0_axiom_m5,conjecture,axiom_m5") != string::npos
                || strConj.find("fof(s1_0_m6s3m9b_axiom_s3,conjecture,axiom_s3") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 50; 
            runSys = 3;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/LCL006+1.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/MED001+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/MGT001+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/NLP001+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/NUM005+0.ax')") != string::npos) {
        if (strConj.find("fof(associative_sum,conjecture") != string::npos 
                || strConj.find("fof(show_lower_boundary,conjecture") != string::npos || strConj.find("fof(show_upper_boundary,conjecture") != string::npos
                || strConj.find("fof(sum_n23_n34_n57,conjecture") != string::npos || strConj.find("fof(sum_n23_something_n34,conjecture") != string::npos
                || strConj.find("fof(sum_something_n23_n34,conjecture") != string::npos || strConj.find("fof(summ_n23_n34_something,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/NUM008+0.ax')") != string::npos) {
        if (strConj.find("fof(primeexist,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/NUM009+0.ax')") != string::npos) {
        if (strConj.find("fof(oneplustwoidthree,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/PHI002+0.ax')") != string::npos)
        return runSys;
    
    if (strAxiom.find("include('Axioms/PRD001+0.ax')") != string::npos)
        return runSys;
    
    
    if (strAxiom.find("include('Axioms/REL001+0.ax')") != string::npos) {
        if (strConj.find("fof(goals,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 226;
            StrategyParam::timeForceLimit = 10; 
            runSys = 2;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SET005+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SET006+0.ax')") != string::npos) {
        if (strConj.find("fof(set_partitions_itself,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;
        }
        else if (strConj.find("fof(thV") != string::npos) {
            if (strConj.find("1,conjecture") != string::npos || strConj.find("15,conjecture") != string::npos
                    || strConj.find("16,conjecture") != string::npos || strConj.find("21,conjecture") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(thIV") != string::npos) {
            if (strConj.find("17,conjecture") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(thIII") != string::npos) {
            if (strConj.find("02,conjecture") == string::npos && strConj.find("03,conjecture") == string::npos
                    && strConj.find("12,conjecture") == string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(thII") != string::npos) {
            if (strConj.find("03a,conjecture") == string::npos && strConj.find("05,conjecture") == string::npos
                    && strConj.find("06,conjecture") == string::npos && strConj.find("08,conjecture") == string::npos
                    && strConj.find("11,conjecture") == string::npos && strConj.find("12,conjecture") == string::npos
                    && strConj.find("13,conjecture") == string::npos && strConj.find("22,conjecture") == string::npos
                    && strConj.find("24,conjecture") == string::npos && strConj.find("25,conjecture") == string::npos
                    && strConj.find("a01,conjecture") == string::npos && strConj.find("a03,conjecture") == string::npos
                    && strConj.find("a04,conjecture") == string::npos && strConj.find("a05,conjecture") == string::npos
                    && strConj.find("a08,conjecture") == string::npos && strConj.find("a12,conjecture") == string::npos
                    && strConj.find("a13,conjecture") == string::npos && strConj.find("a14,conjecture") == string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(thI") != string::npos) {
            if (strConj.find("10,conjecture") != string::npos || strConj.find("21,conjecture") != string::npos
                    || strConj.find("25,conjecture") != string::npos || strConj.find("26,conjecture") != string::npos
                    || strConj.find("32,conjecture") != string::npos
                    || strConj.find("37,conjecture") != string::npos || strConj.find("40,conjecture") != string::npos
                    || strConj.find("49,conjecture") != string::npos) {
                runSys = 3;
            }
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SET006+3.ax')") != string::npos)
        return runSys;
    
    if (strAxiom.find("include('Axioms/SET007/SET007+0.ax')") != string::npos) {
        if (strConj.find("_autgroup,conjecture") != string::npos) {
            if (strConj.find("t12") != string::npos || strConj.find("t14") != string::npos
                    || strConj.find("t15") != string::npos || strConj.find("t3") != string::npos
                    || strConj.find("t30") != string::npos || strConj.find("t7") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_latsum_1,conjecture") != string::npos) {
            if (strConj.find("t19") != string::npos || strConj.find("t23") != string::npos
                    || strConj.find("t7") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t11") != string::npos) {
                StrategyParam::firstRunTime = 282;
                StrategyParam::timeForceLimit = 4; 
                runSys = 2;
            }
            else if (strConj.find("t20") != string::npos) {
                StrategyParam::firstRunTime = 229;
                StrategyParam::timeForceLimit = 15; 
                runSys = 2;
            }
        }
        else if (strConj.find("_tsp_2,conjecture") != string::npos) {
            if (strConj.find("t1") != string::npos ||  strConj.find("t13") != string::npos
                    || strConj.find("t30") != string::npos || strConj.find("t31") != string::npos
                    || strConj.find("t34") != string::npos || strConj.find("t35") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t24") != string::npos) {
                StrategyParam::firstRunTime = 255;
                StrategyParam::timeForceLimit = 13; 
                runSys = 2;
            }
        }
        else if (strConj.find("_waybel22,conjecture") != string::npos) {
            if (strConj.find("t1") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t6") != string::npos) {
                StrategyParam::firstRunTime = 248;
                StrategyParam::timeForceLimit = 10; 
                runSys = 2;
            }
        }
        else if (strConj.find("_latsubgr,conjecture") != string::npos) {
            if (strConj.find("t10") != string::npos || strConj.find("t13") != string::npos
                    || strConj.find("t33") != string::npos || strConj.find("t35") != string::npos
                    || strConj.find("t38") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t31") != string::npos) {
                StrategyParam::firstRunTime = 160;
                StrategyParam::timeForceLimit = 34; 
                runSys = 2;
            }
        }
        else if (strConj.find("_lopclset,conjecture") != string::npos) {
            if (strConj.find("t10") != string::npos || strConj.find("t44") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t27") != string::npos) {
                StrategyParam::firstRunTime = 240;
                StrategyParam::timeForceLimit = 20; 
                runSys = 2;
            }
        }
        else if (strConj.find("_conlat_2,conjecture") != string::npos) {
            if (strConj.find("t20") == string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_rmod_5,conjecture") != string::npos) {
            if (strConj.find("t11") != string::npos || strConj.find("t12") != string::npos
                    || strConj.find("t4") != string::npos
                    || strConj.find("t18") != string::npos || strConj.find("t2") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t14") != string::npos) {
                StrategyParam::firstRunTime = 16;
                StrategyParam::timeForceLimit = 29; 
                runSys = 2;
            }
            else if (strConj.find("t16") != string::npos) {
                StrategyParam::firstRunTime = 163;
                StrategyParam::timeForceLimit = 27; 
                runSys = 2;
            }
            else if (strConj.find("t6") != string::npos) {
                StrategyParam::firstRunTime = 130;
                StrategyParam::timeForceLimit = 29; 
                runSys = 2;
            }
        }
        else if (strConj.find("_closure3,conjecture") != string::npos) {
            if (strConj.find("t4") != string::npos || strConj.find("t5") != string::npos
                    || strConj.find("t6") != string::npos || strConj.find("t8") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t12") != string::npos) {
                StrategyParam::firstRunTime = 35;
                StrategyParam::timeForceLimit = 16; 
                runSys = 2;
            }
        }
        else if (strConj.find("_filter_2,conjecture") != string::npos) {
            if (strConj.find("t12") != string::npos || strConj.find("t16") != string::npos
                    || strConj.find("t17") != string::npos || strConj.find("t34") != string::npos
                    || strConj.find("t36") != string::npos || strConj.find("t4") != string::npos
                    || strConj.find("t40") != string::npos || strConj.find("t48") != string::npos
                    || strConj.find("t50") != string::npos || strConj.find("t52") != string::npos
                    || strConj.find("t56") != string::npos || strConj.find("t59") != string::npos
                    || strConj.find("t61") != string::npos || strConj.find("t62") != string::npos
                    || strConj.find("t65") != string::npos || strConj.find("t66") != string::npos
                    || strConj.find("t67") != string::npos || strConj.find("t77") != string::npos
                    || strConj.find("t79") != string::npos || strConj.find("t85") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t13") != string::npos || strConj.find("t26") != string::npos
                    || strConj.find("t27") != string::npos || strConj.find("t32") != string::npos
                    || strConj.find("t54") != string::npos || strConj.find("t58") != string::npos) {
                StrategyParam::firstRunTime = 17;
                StrategyParam::timeForceLimit = 26; 
                runSys = 2;
            }
            else if (strConj.find("t25") != string::npos) {
                StrategyParam::firstRunTime = 162;
                StrategyParam::timeForceLimit = 28; 
                runSys = 2;
            }
            else if (strConj.find("t31") != string::npos) {
                StrategyParam::firstRunTime = 185;
                StrategyParam::timeForceLimit = 26; 
                runSys = 2;
            }
            else if (strConj.find("t41") != string::npos) {
                StrategyParam::firstRunTime = 27;
                StrategyParam::timeForceLimit = 25; 
                runSys = 2;
            }
            else if (strConj.find("t76") != string::npos) {
                StrategyParam::firstRunTime = 227;
                StrategyParam::timeForceLimit = 16; 
                runSys = 2;
            }
            else if (strConj.find("t8") != string::npos) {
                StrategyParam::firstRunTime = 246;
                StrategyParam::timeForceLimit = 9; 
                runSys = 2;
            }
            else if (strConj.find("t35") != string::npos) {
                StrategyParam::firstRunTime = 191;
                StrategyParam::timeForceLimit = 22; 
                runSys = 2;
            }
        }
        else if (strConj.find("_relset_2,conjecture") != string::npos) {
            if (strConj.find("t33") != string::npos || strConj.find("t40") != string::npos
                    || strConj.find("t41") != string::npos || strConj.find("t43") != string::npos
                    || strConj.find("t5") != string::npos || strConj.find("t53") != string::npos
                    || strConj.find("t55") != string::npos || strConj.find("t57") != string::npos
                    || strConj.find("t64") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t18") != string::npos || strConj.find("t28") != string::npos) {
                StrategyParam::firstRunTime = 17;
                StrategyParam::timeForceLimit = 26; 
                runSys = 2;
            }
            else if (strConj.find("t7") != string::npos) {
                StrategyParam::firstRunTime = 290;
                StrategyParam::timeForceLimit = 3; 
                runSys = 2;
            }
            else if (strConj.find("t36") != string::npos) {
                StrategyParam::firstRunTime = 163;
                StrategyParam::timeForceLimit = 25; 
                runSys = 2;
            }
            else if (strConj.find("t65") != string::npos) {
                StrategyParam::firstRunTime = 203;
                StrategyParam::timeForceLimit = 25; 
                runSys = 2;
            }
        }
        else if (strConj.find("_waybel34,conjecture") != string::npos) {
            if (strConj.find("t17") != string::npos || strConj.find("t20") != string::npos
                    || strConj.find("t42") != string::npos
                    || strConj.find("t43") != string::npos
                    || strConj.find("t65") != string::npos || strConj.find("t71") != string::npos
                    || strConj.find("t8") != string::npos || strConj.find("t9") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t4") != string::npos) {
                StrategyParam::firstRunTime = 256;
                StrategyParam::timeForceLimit = 6; 
                runSys = 2;
            }
            else if (strConj.find("t12") != string::npos) {
                StrategyParam::firstRunTime = 246;
                StrategyParam::timeForceLimit = 6; 
                runSys = 2;
            }
            else if (strConj.find("t26") != string::npos) {
                StrategyParam::firstRunTime = 50;
                StrategyParam::timeForceLimit = 14; 
                runSys = 2;
            }
            else if (strConj.find("t49") != string::npos) {
                StrategyParam::firstRunTime = 231;
                StrategyParam::timeForceLimit = 16; 
                runSys = 2;
            }
            else if (strConj.find("t5") != string::npos) {
                StrategyParam::firstRunTime = 256;
                StrategyParam::timeForceLimit = 6; 
                runSys = 2;
            }
        }
        else if (strConj.find("_isocat_2,conjecture") != string::npos) {
            if (strConj.find("t40") == string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(t4_yoneda_1,conjecture") != string::npos){
            runSys = 3;
        }
        else if (strConj.find("fof(t8_waybel33,conjecture") != string::npos){
            runSys = 3;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SWB001+0.ax')") != string::npos) {
        if (strConj.find("fof(conclusion_rdfbased_sem_") != string::npos) {
            if (strConj.find("fof(conclusion_rdfbased_sem_bool_") != string::npos && strConj.find("fof(conclusion_rdfbased_sem_bool_tollens,conjecture") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;            
            }
            else if (strConj.find("fof(conclusion_rdfbased_sem_chain_ext,conjecture") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_char_symmetric_ext,conjecture") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_char_transitive_ext,conjecture") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_enum_ext,conjecture") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_eqdis_disjointunion_composite,conjecture") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_inv_ext,conjecture") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_ndis_alldi") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_restrict_allvalues_cmp_") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_restrict_exactqcr_inst_obj_two,conjecture") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_restrict_maxqcr_") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_restrict_minqcr_cmp_") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_restrict_minqcr_inst_obj_one,conjecture") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_restrict_somevalues_cmp_") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_restrict_term_cardqcr,conjecture") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_restrict_term_dataqcr,conjecture") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_restrict_term_minmax") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_restrict_term_sameall,conjecture") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_restrict_term_some") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;            
            }            
        }
        else if (strConj.find("fof(testcase_conclusion_fullish_0") != string::npos) {
            if (strConj.find("fof(testcase_conclusion_fullish_01") != string::npos && strConj.find("fof(testcase_conclusion_fullish_015") == string::npos
                    && strConj.find("fof(testcase_conclusion_fullish_017") == string::npos && strConj.find("fof(testcase_conclusion_fullish_018") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;
            }
            else if (strConj.find("fof(testcase_conclusion_fullish_02") != string::npos && strConj.find("fof(testcase_conclusion_fullish_023") == string::npos
                    && strConj.find("fof(testcase_conclusion_fullish_024") == string::npos && strConj.find("fof(testcase_conclusion_fullish_026") == string::npos
                    && strConj.find("fof(testcase_conclusion_fullish_029") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;
            }
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SWC001+0.ax')") != string::npos) {
        if (strConj.find("fof(co1,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 287;
            StrategyParam::timeForceLimit = 3; 
            runSys = 2; 
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SWV003+0.ax')") != string::npos) {
        if (strConj.find("fof(gauss_init_00") != string::npos) {
            if (strConj.find("fof(gauss_init_0001,conjecture") == string::npos && strConj.find("fof(gauss_init_0005,conjecture") == string::npos 
                    && strConj.find("fof(gauss_init_0033,conjecture") == string::npos && strConj.find("fof(gauss_init_0037,conjecture") == string::npos
                    && strConj.find("fof(gauss_init_0041,conjecture") == string::npos && strConj.find("fof(gauss_init_0045,conjecture") == string::npos
                    && strConj.find("fof(gauss_init_0077,conjecture") == string::npos && strConj.find("fof(gauss_init_0081,conjecture") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;
            }
        }
        else if (strConj.find("fof(quaternion_ds1_symm_") != string::npos) {
            if (strConj.find("fof(quaternion_ds1_symm_0002,conjecture") != string::npos || strConj.find("fof(quaternion_ds1_symm_0004,conjecture") != string::npos
                    || strConj.find("fof(quaternion_ds1_symm_0008,conjecture") != string::npos || strConj.find("fof(quaternion_ds1_symm_0011,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;
            }
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SWV007+0.ax')") != string::npos) {
        if (strConj.find("fof(co3,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 12;
            StrategyParam::timeForceLimit = 28; 
            runSys = 2;            
        }
        else if (strConj.find("fof(l29_co,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;            
        }
        return runSys;
    }
     
    if (strAxiom.find("include('Axioms/SWV011+0.ax')") != string::npos) {
        if (strConj.find("fof(conj,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 224;
            StrategyParam::timeForceLimit = 20; 
            runSys = 2;            
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SWV012+0.ax')") != string::npos) {
        if (strConj.find("fof(exists1_exists2,conjecture") != string::npos
                || strConj.find("fof(or1_or2,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;            
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SYN002+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom == "") {
        if (strConj.find("fof(addAssertion,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 154;
            StrategyParam::timeForceLimit = 25; 
            runSys = 2;            
        }
        else if (strConj.find("fof(co1,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 173;
            StrategyParam::timeForceLimit = 25; 
            runSys = 2;            
        }
        else if (strConj.find("fof(conj_") != string::npos) {
            if (strConj.find("fof(conj_0,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 276;
                StrategyParam::timeForceLimit = 7; 
                runSys = 2;            
            }
            else if (strConj.find("fof(conj_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 225;
                StrategyParam::timeForceLimit = 12; 
                runSys = 2;            
            }
            else if (strConj.find("fof(conj_2,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 225;
                StrategyParam::timeForceLimit = 20; 
                runSys = 2;            
            }
            else if (strConj.find("fof(conj_3,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 288;
                StrategyParam::timeForceLimit = 3; 
                runSys = 2;            
            }
            else if (strConj.find("fof(conj_7,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 249;
                StrategyParam::timeForceLimit = 14; 
                runSys = 2;            
            }
        }
        else if (strConj.find("fof('cont(412,0)',conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;               
        }
        else if (strConj.find("fof(goal_to_be_proved,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 159;
            StrategyParam::timeForceLimit = 28; 
            runSys = 2;               
        }
        else if (strConj.find("fof(goals,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 243;
            StrategyParam::timeForceLimit = 18; 
            runSys = 2;               
        }
        else if (strConj.find("fof(goals_09,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 12;
            StrategyParam::timeForceLimit = 28; 
            runSys = 2;               
        }
        else if (strConj == "") {
            StrategyParam::firstRunTime = 170;
            StrategyParam::timeForceLimit = 22; 
            runSys = 2;             
        }
        else if (strConj.find("fof(m__,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 256;
            StrategyParam::timeForceLimit = 12; 
            runSys = 2;               
        }
        else if (strConj.find("fof('holds(") != string::npos) {
            if (strConj.find("fof('holds(3") != string::npos && strConj.find("fof('holds(307") == string::npos
                    && strConj.find("fof('holds(324") == string::npos && strConj.find("fof('holds(380") == string::npos
                    && strConj.find("fof('holds(331") == string::npos && strConj.find("fof('holds(363") == string::npos
                    && strConj.find("fof('holds(364") == string::npos && strConj.find("fof('holds(384") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;     
            }
            else if (strConj.find("fof('holds(4") != string::npos && strConj.find("fof('holds(407") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;
            } 
            else if (strConj.find("fof('holds(conjunct1(") != string::npos) {
                if (strConj.find("fof('holds(conjunct1(338), 1268, 0)',conjecture") != string::npos
                        || strConj.find("fof('holds(conjunct1(conjunct2(338)), 1269, 0)',conjecture") != string::npos
                        || strConj.find("fof('holds(conjunct1(conjunct2(359)), 1319, 0)',conjecture") != string::npos) {
                    StrategyParam::firstRunTime = 0;
                    StrategyParam::timeForceLimit = 240; 
                    runSys = 3;   
                }
            }
            else if (strConj.find("fof('holds(conjunct2(") != string::npos) {
                if (strConj.find("fof('holds(conjunct2(conjunct2(266)), 1177, 0)',conjecture") == string::npos
                        && strConj.find("fof('holds(conjunct2(362), 1325, 0)',conjecture") == string::npos
                        && strConj.find("fof('holds(conjunct2(conjunct2(359)), 1320, 0)',conjecture") == string::npos) {
                    StrategyParam::firstRunTime = 0;
                    StrategyParam::timeForceLimit = 240; 
                    runSys = 3;   
                }
            }
        }
        else if (strConj.find("_wellord1,conjecture") != string::npos) {
            if (strConj.find("fof(l") != string::npos) {
                if (strConj.find("fof(l2") != string::npos || strConj.find("fof(l3") != string::npos
                        || strConj.find("fof(l4") != string::npos) {
                    StrategyParam::firstRunTime = 13;
                    StrategyParam::timeForceLimit = 27; 
                    runSys = 2;              
                }
            }
            else if (strConj.find("fof(t") != string::npos) {
                if (strConj.find("fof(t17") != string::npos
                        || strConj.find("fof(t49") != string::npos) {
                    StrategyParam::firstRunTime = 0;
                    StrategyParam::timeForceLimit = 240; 
                    runSys = 3;              
                }
                else if (strConj.find("fof(t19_wellord1,conjecture") != string::npos
                        || strConj.find("fof(t21_wellord1,conjecture") != string::npos || strConj.find("fof(t22_wellord1,conjecture") != string::npos
                        || strConj.find("fof(t24_wellord1,conjecture") != string::npos || strConj.find("fof(t25_wellord1,conjecture") != string::npos
                        || strConj.find("fof(t5_wellord1,conjecture") != string::npos) {
                    StrategyParam::firstRunTime = 25;
                    StrategyParam::timeForceLimit = 25; 
                    runSys = 2;              
                }
                else if (strConj.find("fof(t23") != string::npos) {
                    StrategyParam::firstRunTime = 242;
                    StrategyParam::timeForceLimit = 24; 
                    runSys = 2;              
                }
            }
        }
        else if (strConj.find("_zfmisc_1,conjecture") != string::npos) {
            if (strConj.find("fof(l55_zfmisc_1,conjecture") != string::npos || strConj.find("fof(t118_zfmisc_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 13;
                StrategyParam::timeForceLimit = 27; 
                runSys = 2;   
            }
            else if (strConj.find("fof(t101_zfmisc_1,conjecture") != string::npos || strConj.find("fof(t105_zfmisc_1,conjecture") != string::npos
                    || strConj.find("fof(t118_zfmisc_1,conjecture") != string::npos || strConj.find("fof(t122_zfmisc_1,conjecture") != string::npos
                    || strConj.find("fof(t123_zfmisc_1,conjecture") != string::npos || strConj.find("fof(t125_zfmisc_1,conjecture") != string::npos
                    || strConj.find("fof(t136_zfmisc_1,conjecture") != string::npos || strConj.find("fof(t36_zfmisc_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;   
            }
        }
        else if (strConj.find("_xboole_1,conjecture") != string::npos) {
            if (strConj.find("fof(t45_xboole_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 183;
                StrategyParam::timeForceLimit = 20; 
                runSys = 2;
            }
        }
        else if (strConj.find("_funct_1,conjecture") != string::npos) {
            if (strConj.find("fof(t118_funct_1,conjecture") != string::npos || strConj.find("fof(t121_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t137_funct_1,conjecture") != string::npos || strConj.find("fof(t138_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t139_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t150_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t151_funct_1,conjecture") != string::npos || strConj.find("fof(t154_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t155_funct_1,conjecture") != string::npos || strConj.find("fof(t160_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t20_funct_1,conjecture") != string::npos || strConj.find("fof(t37_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t43_funct_1,conjecture") != string::npos || strConj.find("fof(t48_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t51_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t85_funct_1,conjecture") != string::npos || strConj.find("fof(t9_funct_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;
            }
            else if (strConj.find("fof(t145_funct_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 13;
                StrategyParam::timeForceLimit = 25; 
                runSys = 2;
            }
            else if (strConj.find("fof(t21_funct_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 105;
                StrategyParam::timeForceLimit = 5; 
                runSys = 2;
            }
            else if (strConj.find("fof(t22_funct_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 23;
                StrategyParam::timeForceLimit = 25; 
                runSys = 2;
            }
            else if (strConj.find("fof(t54_funct_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 92;
                StrategyParam::timeForceLimit = 25; 
                runSys = 2;
            }
        }
        else if (strConj.find("fof(n") != string::npos) {
            runSys = 1;
        }
        else if (strConj.find("fof(pel") != string::npos) {
            if (strConj.find("fof(pel53,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;                
            }
        }
        else if (strConj.find("fof(prove") != string::npos) {
            if (strConj.find("fof(prove_relset_1_33,conjecture") != string::npos || strConj.find("fof(prove_relset_1_35,conjecture") != string::npos
                    || strConj.find("fof(prove_th99,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;                
            }
        }
        else if (strConj.find("fof('qe(") != string::npos) {
            if (strConj.find("fof('qe(229)',conjecture") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;                
            }
        }
        else if (strConj.find("fof(s1_") != string::npos) {
            if (strConj.find("fof(s1_xboole") == string::npos && strConj.find("fof(s1_funct_1__e16_22") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;                
            }
            else if (strConj.find("fof(s1_xboole") != string::npos) {
                if (strConj.find("pre_topc__1,conjecture") != string::npos) {
                    StrategyParam::firstRunTime = 12;
                    StrategyParam::timeForceLimit = 28; 
                    runSys = 2;
                }
                else if (strConj.find("wellord2") != string::npos) {
                    if (strConj.find("fof(s1_xboole_0__e10_24__wellord2__1,conjecture") != string::npos) {
                        runSys = 3;
                    }
                    else {
                        StrategyParam::firstRunTime = 12;
                        StrategyParam::timeForceLimit = 28; 
                        runSys = 2;
                    }
                }
                else if (strConj.find("waybel") != string::npos) {
                    StrategyParam::firstRunTime = 12;
                    StrategyParam::timeForceLimit = 28; 
                    runSys = 2;
                }
                else if (strConj.find("finset") != string::npos) {
                    StrategyParam::firstRunTime = 17;
                    StrategyParam::timeForceLimit = 28; 
                    runSys = 2;
                }
                else if (strConj.find("tops_2__1") != string::npos) {
                    StrategyParam::firstRunTime = 230;
                    StrategyParam::timeForceLimit = 14; 
                    runSys = 2;
                }
                else if (strConj.find("yellow19") != string::npos) {
                    StrategyParam::firstRunTime = 165;
                    StrategyParam::timeForceLimit = 28; 
                    runSys = 2;
                }
            }
        }
        else if (strConj.find("fof(s2_") != string::npos) {
            if (strConj.find("fof(s2_funct_1") != string::npos && strConj.find("tops_2") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;                  
            }
            else if (strConj.find("fof(s2_funct_1") != string::npos && strConj.find("wellord2") == string::npos) {
                runSys = 3;                  
            }
            else if (strConj.find("fof(s2_funct_1") != string::npos && strConj.find("wellord2") != string::npos) {
                StrategyParam::firstRunTime = 12;
                StrategyParam::timeForceLimit = 34; 
                runSys = 2;                   
            }
            else if (strConj.find("fof(s2_xboole_0") != string::npos) {
                StrategyParam::firstRunTime = 12;
                StrategyParam::timeForceLimit = 28; 
                runSys = 2;
            }
        }
        else if (strConj.find("fof(s3_") != string::npos) {
            if (strConj.find("fof(s3_subset_1__e1_40__pre_topc,conjecture") != string::npos || strConj.find("fof(s3_subset_1__e2_37_1_1__pre_topc,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 170;
                StrategyParam::timeForceLimit = 4; 
                runSys = 2;
            }
        } 
        else if (strConj.find("_tops_") != string::npos) {
            runSys = 1;
        }
        else if (strConj.find("fof(mv5,conjecture") != string::npos){
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;
        }
        else if (strConj.find("_autgroup,conjecture") != string::npos) {
            if (strConj.find("fof(t16") != string::npos || strConj.find("t26") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_latsum_1,conjecture") != string::npos) {
            if (strConj.find("fof(t19") != string::npos || strConj.find("t24") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_waybel22,conjecture") != string::npos) {
            runSys = 1;
        }
        else if (strConj.find("_yellow_1,conjecture") != string::npos) {
            if (strConj.find("fof(t2") != string::npos) {
                StrategyParam::firstRunTime = 12;
                StrategyParam::timeForceLimit = 24;
                runSys = 2;
            }
        }
        else if (strConj.find("_finsub_1,conjecture") != string::npos) {
            if (strConj.find("fof(t24") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_latsubgr,conjecture") != string::npos) {
            if (strConj.find("fof(t35") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_ordinal1,conjecture") != string::npos) {
            if (strConj.find("fof(t29") != string::npos
                    || strConj.find("fof(t35") != string::npos || strConj.find("fof(t36") != string::npos
                    || strConj.find("fof(t41") != string::npos || strConj.find("fof(t5") != string::npos
                    || strConj.find("fof(t6") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("fof(t32") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 24;
                runSys = 2;
            }
            else if (strConj.find("fof(t23") != string::npos) {
                StrategyParam::firstRunTime = 252;
                StrategyParam::timeForceLimit = 10;
                runSys = 2;
            }
        }
        else if (strConj.find("_lopclset,conjecture") != string::npos) {
            if (strConj.find("fof(t30") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_rmod_5,conjecture") != string::npos) {
            if (strConj.find("fof(t11") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_waybel_") != string::npos) {
            if (strConj.find("fof(t29_waybel_9") != string::npos || strConj.find("fof(t8_waybel_") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 24;
                runSys = 2;
            }
        }
        else if (strConj.find("_yellow19,conjecture") != string::npos) {
            if (strConj.find("fof(t18") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 24;
                runSys = 2;
            }
            else if (strConj.find("fof(t13") != string::npos || strConj.find("fof(t4") != string::npos
                    || strConj.find("fof(t9") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_relat_1,conjecture") != string::npos) {
            if (strConj.find("fof(t115") != string::npos || strConj.find("fof(t143") != string::npos
                    || strConj.find("fof(t145") != string::npos
                    || strConj.find("fof(t178") != string::npos
                    || strConj.find("fof(t21") != string::npos || strConj.find("fof(t25") != string::npos
                    || strConj.find("fof(t44") != string::npos || strConj.find("fof(t45") != string::npos
                    || strConj.find("fof(t86") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 24;
                runSys = 2;
            }
            else if (strConj.find("fof(t117") != string::npos || strConj.find("fof(t71") != string::npos
                    || strConj.find("fof(t88") != string::npos) {
                StrategyParam::firstRunTime = 159;
                StrategyParam::timeForceLimit = 24;
                runSys = 2;
            }
            else if (strConj.find("fof(t119") != string::npos || strConj.find("fof(t140") != string::npos
                    || strConj.find("fof(t160") != string::npos
                    || strConj.find("fof(t46") != string::npos || strConj.find("fof(t47") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("fof(t146") != string::npos || strConj.find("fof(t90") != string::npos
                    || strConj.find("fof(t94") != string::npos) {
                StrategyParam::firstRunTime = 174;
                StrategyParam::timeForceLimit = 20;
                runSys = 2;
            }
            else if (strConj.find("fof(t37") != string::npos) {
                StrategyParam::firstRunTime = 26;
                StrategyParam::timeForceLimit = 25;
                runSys = 2;
            }
        }
        else if (strConj.find("_closure3,conjecture") != string::npos) {
            if (strConj.find("fof(t12") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_filter_2,conjecture") != string::npos) {
            if (strConj.find("fof(t2") != string::npos || strConj.find("fof(t35") != string::npos
                    || strConj.find("fof(t49") != string::npos || strConj.find("fof(t51") != string::npos
                    || strConj.find("fof(t52") != string::npos || strConj.find("fof(t56") != string::npos
                    || strConj.find("fof(t77") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_pre_topc,conjecture") != string::npos) {
            if (strConj.find("fof(t45") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("fof(t48") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 25;
                runSys = 2;
            }
        }
        else if (strConj.find("_relset_1,conjecture") != string::npos) {
            if (strConj.find("fof(t12") != string::npos || strConj.find("fof(t23") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 25;
                runSys = 2;
            }
        }
        else if (strConj.find("_relset_2,conjecture") != string::npos) {
            if (strConj.find("fof(t12") != string::npos || strConj.find("fof(t13") != string::npos
                    || strConj.find("fof(t14") != string::npos || strConj.find("fof(t22") != string::npos
                    || strConj.find("fof(t27") != string::npos || strConj.find("fof(t40") != string::npos
                    || strConj.find("fof(t5") != string::npos || strConj.find("fof(t8") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_waybel34,conjecture") != string::npos) {
            if (strConj.find("fof(t17") != string::npos || strConj.find("fof(t38") != string::npos
                    || strConj.find("fof(t45") != string::npos || strConj.find("fof(t46") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_finset_1,conjecture") != string::npos) {
            if (strConj.find("fof(t17") != string::npos || strConj.find("fof(t22") != string::npos
                    || strConj.find("fof(t23") != string::npos || strConj.find("fof(t31") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_yellow_0,conjecture") != string::npos) {
            if (strConj.find("fof(t15") != string::npos || strConj.find("fof(t16") != string::npos
                    || strConj.find("fof(t60") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 25;
                runSys = 2;
            }
        }
        else if (strConj.find("_yellow_6,conjecture") != string::npos) {
            if (strConj.find("fof(t21") != string::npos || strConj.find("fof(t28") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 25;
                runSys = 2;
            }
        }
        else if (strConj.find("_wellord2,conjecture") != string::npos) {
            if (strConj.find("fof(t3") != string::npos) {
                StrategyParam::firstRunTime = 162;
                StrategyParam::timeForceLimit = 28;
                runSys = 2;
            }
            else if (strConj.find("fof(t4") != string::npos) {
                StrategyParam::firstRunTime = 225;
                StrategyParam::timeForceLimit = 18;
                runSys = 2;
            }
        }
        else if (strConj.find("_orders_2,conjecture") != string::npos) {
            if (strConj.find("fof(t25") != string::npos) {
                StrategyParam::firstRunTime = 12;
                StrategyParam::timeForceLimit = 28;
                runSys = 2;
            }
        }
        else if (strConj.find("_waybel33,conjecture") != string::npos) {
            if (strConj.find("fof(t27") != string::npos || strConj.find("fof(t7") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_isocat_2,conjecture") != string::npos) {
            if ( strConj.find("fof(t43") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(tautology,conjecture") != string::npos) {
            runSys = 3;
        }
        else if (strConj.find("fof(thm_2E") != string::npos) {
            if (strConj.find("fof(thm_2Earith") != string::npos || strConj.find("fof(thm_2Equotient_") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(tlhfof") != string::npos) {
            if (strConj.find("fof(tlhfof34981,") != string::npos || strConj.find("fof(tlhfof40016,") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(main,") != string::npos) {
            StrategyParam::firstRunTime = 287;
            StrategyParam::timeForceLimit = 3;
            runSys = 2;
        }
        return runSys;
    }    
    return runSys;
}

int ReadOriProblem240(const string& problemFile) {
    int runSys = 1; //1 only run E; 2 E->CSE->E; 3 CSE->E
    string strConj = "";
    string strAxiom = "";
    string problemField = "";
    ifstream fin(problemFile);
    string str = "";
    bool flag = false;
    while (getline(fin, str)) {
        if (str.find("conjecture") != string::npos) {
            int begPos = str.find_first_of(",");
            int endPos = str.find_last_of(",");
            string temp = str.substr(begPos + 1, endPos - (begPos + 1));
            if (temp == "conjecture") {
                strConj = str;
                break;
            }
        }
        else if (str.find("include(") != string::npos && !flag) {
            strAxiom = str;
            flag = true;
        }
    }

    if (strAxiom.find("include('Axioms/AGT001") != string::npos) {
        if (strConj.find("fof(query_") != string::npos) {
            int begPos = strConj.find_first_of("_");
            begPos += 1;
            int endPos = strConj.find_first_of(",");
            string temp = strConj.substr(begPos, endPos - begPos);
            int index = atoi(temp.c_str());
            if ((index >= 6 && index <= 13) || index == 18 || (index >= 20 && index <= 25))
                runSys = 3;
            else if (index == 19) {
                StrategyParam::firstRunTime = 120;
                StrategyParam::timeForceLimit = 24; 
                runSys = 2;
            }
            else if (index == 26) {
                StrategyParam::firstRunTime = 219;
                StrategyParam::timeForceLimit = 4; 
                runSys = 2;
            }
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/BIO001") != string::npos) {
        if (strConj.find("fof(ask,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 130;
            StrategyParam::timeForceLimit = 24; 
            runSys = 2;
        } 
        return runSys;        
    }
    
    if (strAxiom.find("include('Axioms/COM001+0.ax')") != string::npos) {
        if (strConj.find("fof('T-Weak-FreeVar-") != string::npos) {
            if (strConj.find("-abs-2',") != string::npos)
                runSys = 3;
            else 
                runSys = 1;
        }
        else if (strConj.find("fof('T-subst-") != string::npos) {
            if (strConj.find("-abs-3',") != string::npos)
                runSys = 3;
            else 
                runSys = 1;
        }
        else if (strConj.find("fof('T-Preservation-T-") != string::npos) {
            if (strConj.find("app',") != string::npos)
                runSys = 3;
            else 
                runSys = 1;
        }
        else if (strConj.find("fof('T-Progress-T-") != string::npos) {
            if (strConj.find("app',") != string::npos)
                runSys = 3;
            else 
                runSys = 1;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR001+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR002+1.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR002+2.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR002+3.ax')") != string::npos) {
        if (strConj.find("fof(query") != string::npos) {
            int begPos = strConj.find_first_of("y");
            begPos += 1;
            int endPos = strConj.find_first_of(",");
            string temp = strConj.substr(begPos, endPos - begPos);
            int index = atoi(temp.c_str());
            if (index == 186 || index == 189 || index == 199 || index == 211)
                runSys = 3;
            else 
                runSys = 1;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR002+4.ax')") != string::npos) {
        if (strConj.find("fof(query") != string::npos) {
            int begPos = strConj.find_first_of("y");
            begPos += 1;
            int endPos = strConj.find_first_of(",");
            string temp = strConj.substr(begPos, endPos - begPos);
            int index = atoi(temp.c_str());
            if (index == 226 || index == 229 || index == 236 || index == 239 || index == 240
                    || index == 245 || index == 249 || index == 258 || index == 260 || index == 261
                    || index == 265 || index == 274)
                runSys = 3;
            else 
                runSys = 1;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR002+5.ax')") != string::npos) {
        if (strConj.find("fof(query") != string::npos) {
            int begPos = strConj.find_first_of("y");
            begPos += 1;
            int endPos = strConj.find_first_of(",");
            string temp = strConj.substr(begPos, endPos - begPos);
            int index = atoi(temp.c_str());
            if (index == 283 || index == 290 || index == 295 || index == 302 || index == 306 || index == 308)
                runSys = 3;
            else 
                runSys = 1;
        }
        else if (strConj == "")
            runSys = 3;
        return runSys;
    }    
    
    if (strAxiom.find("include('Axioms/CSR003+0.ax')") != string::npos) {
        if (strConj.find("fof(prove_from_SUMO,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 112;
            StrategyParam::timeForceLimit = 15; 
            runSys = 2;
        } 
        return runSys;
    }  
    
    if (strAxiom.find("include('Axioms/CSR003+1.ax')") != string::npos) {
        if (strConj.find("fof(prove_from_SUMO_MILO,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 110;
            StrategyParam::timeForceLimit = 20; 
            runSys = 2;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR003+2.ax')") != string::npos) {
        if (strConj.find("fof(abe_mammal,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 16;
            StrategyParam::timeForceLimit = 44; 
            runSys = 2;
        } 
        else if (strConj == "") {
            runSys = 3;
        }
        else if (strConj.find("fof(prove_from_ALL,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 170;
            StrategyParam::timeForceLimit = 4; 
            runSys = 2;
        }        
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR004+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR006+0.ax')") != string::npos) {
        if (strConj.find("fof(antonymPattern") != string::npos) {
            int begPos = strConj.find_first_of("Pattern");
            begPos += 7;
            int endPos = strConj.find_first_of(",");
            string temp = strConj.substr(begPos, endPos - begPos);
            int index = atoi(temp.c_str());
            if (index == 10007 || (index >= 20012 && index <= 20235) || index == 30068 
                    || index == 30584 || (index >= 31444 && index <= 32292))
                runSys = 3;
        }
        else if (strConj.find("fof(negatedCommonSubclassEvent") != string::npos && strConj.find("fof(negatedCommonSubclassEvent0035,") == string::npos)
            runSys = 3;
        else if (strConj.find("negatedInstrumentRelation0342,") != string::npos)
            runSys = 3;
        else if (strConj.find("negatedMultipleMapping,") != string::npos) {
            StrategyParam::firstRunTime = 149;
            StrategyParam::timeForceLimit = 20;
            runSys = 2;
        }
        else if (strConj.find("negatedSubclassEvent0182,") != string::npos) {
            runSys = 3;
        }
        else if (strConj.find("negatedResultRelation,") != string::npos) {
            StrategyParam::firstRunTime = 140;
            StrategyParam::timeForceLimit = 23;
            runSys = 2;
        }
        else if (strConj.find("fof(agentRelation") != string::npos) {
            runSys = 3;
        } 
        else if (strConj.find("fof(instrumentRelation") != string::npos) {
            if (strConj.find("0028") != string::npos)
                runSys = 3;
        }
        else if (strConj.find("fof(multipleMapping0010,") != string::npos) {
            runSys = 3;
        } 
        else if (strConj.find("fof(resultRelation") != string::npos) {
            runSys = 3;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO004+0.ax')") != string::npos) {
        if (strConj.find("fof(corollary_2_12,conjecture") != string::npos || strConj.find("fof(theorem_3_6,conjecture") != string::npos
                || strConj.find("fof(theorem_4_6_1,conjecture") != string::npos || strConj.find("fof(theorem_4_6_2,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 50; 
            runSys = 3;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO006+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO007+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO008+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO009+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO010+0.ax')") != string::npos) {
        if (strConj.find("fof(aDISTu_") == string::npos && strConj.find("fof(aLIFTu_D") == string::npos
                && strConj.find("fof(aLIFTu_E") == string::npos && strConj.find("fof(aMATRIXu_V") == string::npos
                && strConj.find("fof(aNORMu_PASTECARTu_0u") == string::npos
                && strConj.find("fof(aNORMu_POSu_LT,") == string::npos && strConj.find("fof(aR") == string::npos
                && strConj.find("fof(aVE") == string::npos && strConj.find("fof(aSIGNu_I,conjecture") == string::npos
                && strConj.find("fof(aSPANu_SUB,") == string::npos)
            runSys = 3;
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO011+0.ax')") != string::npos) {
        if (strConj.find("fof(aSatz") != string::npos) {
            if (strConj.find("fof(aSatz4_") != string::npos
                    || strConj.find("fof(aSatz7_22") != string::npos || strConj.find("fof(aSatz9_4") != string::npos
                    || strConj.find("fof(aSatz11_7") != string::npos || strConj.find("fof(aSatz11_49b") != string::npos)
                runSys = 3;
        }
        else if (strConj.find("fof(aExtSameSide") != string::npos)
            runSys = 3;
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GRA001+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GRA007+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/HAL001+0.ax')") != string::npos) {
        if (strConj.find("fof(g_injection,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 12;
            StrategyParam::timeForceLimit = 28; 
            runSys = 2;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/ITP001/ITP001+2.ax')") != string::npos) {
        if (strConj.find("fof(conj_thm_2Earithmetic_2EMOD__2,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 12;
            StrategyParam::timeForceLimit = 28; 
            runSys = 2;
        } 
        else if (strConj.find("fof(conj_thm_2Ebitstring_2Eword__1comp__v2w,conjecture") != string::npos || strConj.find("fof(conj_thm_2Equotient__option_2EOPTION__REL__def,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 14;
            StrategyParam::timeForceLimit = 26; 
            runSys = 2;
        } 
        else if (strConj.find("fof(conj_thm_2Eextreal_2Emax__le,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 15;
            StrategyParam::timeForceLimit = 26; 
            runSys = 2;
        } 
        else if (strConj.find("fof(conj_thm_2Elebesgue_2Epos__fn__integral__cmul,conjecture") != string::npos || strConj.find("fof(conj_thm_2Ereal__topology_2ECLOSED__UNION__COMPACT__SUBSETS,conjecture") != string::npos
                || strConj.find("fof(conj_thm_2Ereal__topology_2EINDEPENDENT__STDBASIS,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 50; 
            runSys = 3;
        } 
        else if (strConj.find("fof(conj_thm_2Eoption_2EOPTION__MAP2__THM,conjecture") != string::npos || strConj.find("fof(conj_thm_2EpatternMatches_2EPMATCH__FLATTEN__FUN__PMATCH__ROW,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 12;
            StrategyParam::timeForceLimit = 28; 
            runSys = 2;
        } 
        else if (strConj.find("fof(conj_thm_2Ereal__topology_2EBOUNDED__BALL,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 162;
            StrategyParam::timeForceLimit = 18; 
            runSys = 2;
        }
        else if (strConj.find("fof(conj_thm_2Ereal_2ESUP__EPSILON,conjecture") != string::npos || strConj.find("fof(conj_thm_2Eseq_2EBOLZANO__LEMMA,conjecture") != string::npos
                || strConj.find("fof(conj_thm_2Ewords_2En2w__sub,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 18;
            StrategyParam::timeForceLimit = 22; 
            runSys = 2;
        }
        else if (strConj.find("fof(conj_thm_2Eutil__prob_2ENUM__2D__BIJ__INV,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 224;
            StrategyParam::timeForceLimit = 4; 
            runSys = 2;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/ITP001/ITP002+4.ax')") != string::npos) {
        if (strConj.find("fof(thm_2Ebool_2ETRUTH,conjecture") == string::npos && strConj.find("fof(thm_2Ecardinal_2ECARD__NOT__LE,conjecture") == string::npos
                && strConj.find("fof(thm_2Epred__set_2EREST__SUBSET,conjecture") == string::npos && strConj.find("fof(thm_2EquantHeuristics_2EGUESS__RULES__WEAKEN__FORALL__POINT,conjecture") == string::npos
                && strConj.find("fof(thm_2Ereal_2ESUP__EPSILON,conjecture") == string::npos
                && strConj.find("fof(thm_2Eseq_2EBOLZANO__LEMMA,conjecture") == string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 50; 
            runSys = 3;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/KLE001+0.ax')") != string::npos) {
        if (strConj.find("fof(goals,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 227;
            StrategyParam::timeForceLimit = 4; 
            runSys = 2;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/KLE002+0.ax')") != string::npos) {
        if (strConj.find("fof(goals,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 213;
            StrategyParam::timeForceLimit = 8; 
            runSys = 2;
        } 
        else if (strConj.find("fof(a,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 176;
            StrategyParam::timeForceLimit = 13;
            runSys = 2;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/KLE004+0.ax')") != string::npos) {
        if (strConj.find("fof(goals,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 216;
            StrategyParam::timeForceLimit = 8; 
            runSys = 2;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/KRS001+0.ax')") != string::npos) {
        if (strConj.find("fof(mighta_wth_thm,conjecture") != string::npos
                || strConj.find("fof(xora_csa_thm,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 240;
            StrategyParam::timeForceLimit = 0; 
            runSys = 3;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/KRS001+1.ax')") != string::npos)
        return runSys;
    
    if (strAxiom.find("include('Axioms/LCL006+0.ax')") != string::npos) {
        if (strConj.find("fof(hilbert_equivalence_3,conjecture,equivalence_3") != string::npos || strConj.find("fof(principia_r4,conjecture,r4") != string::npos) {
            StrategyParam::firstRunTime = 131;
            StrategyParam::timeForceLimit = 25; 
            runSys = 2;
        } 
        else if (strConj.find("fof(hilbert_modus_tollens,conjecture,modus_tollens") != string::npos || strConj.find("fof(principia_r5,conjecture,r5") != string::npos) {
            StrategyParam::firstRunTime = 17;
            StrategyParam::timeForceLimit = 25; 
            runSys = 2;
        }
        else if (strConj.find("fof(rosser_kn3,conjecture,kn3") != string::npos) {
            StrategyParam::firstRunTime = 200;
            StrategyParam::timeForceLimit = 9; 
            runSys = 2;
        }
        else if (strConj.find("fof(s1_0_axiom_m5,conjecture,axiom_m5") != string::npos
                || strConj.find("fof(s1_0_m6s3m9b_axiom_s3,conjecture,axiom_s3") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 50; 
            runSys = 3;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/LCL006+1.ax')") != string::npos) {
        if (strConj.find("fof(km5_axiom_K,conjecture,axiom_K") != string::npos) {
            StrategyParam::firstRunTime = 193;
            StrategyParam::timeForceLimit = 15; 
            runSys = 2;
        }
    }
    
    if (strAxiom.find("include('Axioms/MED001+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/MGT001+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/NLP001+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/NUM005+0.ax')") != string::npos) {
        if (strConj.find("fof(associative_sum,conjecture") != string::npos || strConj.find("fof(communative_sum_n6_n7,conjecture") != string::npos
                || strConj.find("fof(show_lower_boundary,conjecture") != string::npos || strConj.find("fof(show_upper_boundary,conjecture") != string::npos
                || strConj.find("fof(sum_n23_n34_n57,conjecture") != string::npos || strConj.find("fof(sum_n23_something_n34,conjecture") != string::npos
                || strConj.find("fof(sum_something_n23_n34,conjecture") != string::npos || strConj.find("fof(summ_n23_n34_something,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/NUM008+0.ax')") != string::npos) {
        if (strConj.find("fof(primeexist,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/NUM009+0.ax')") != string::npos) {
        if (strConj.find("fof(oneplustwoidthree,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/PHI002+0.ax')") != string::npos)
        return runSys;
    
    if (strAxiom.find("include('Axioms/PRD001+0.ax')") != string::npos)
        return runSys;
    
    
    if (strAxiom.find("include('Axioms/REL001+0.ax')") != string::npos) {
        if (strConj.find("fof(goals,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 198;
            StrategyParam::timeForceLimit = 10; 
            runSys = 2;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SET005+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SET006+0.ax')") != string::npos) {
        if (strConj.find("fof(set_partitions_itself,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;
        }
        else if (strConj.find("fof(thV") != string::npos) {
            if (strConj.find("1,conjecture") != string::npos || strConj.find("15,conjecture") != string::npos
                    || strConj.find("16,conjecture") != string::npos || strConj.find("21,conjecture") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(thIV") != string::npos) {
            if (strConj.find("17,conjecture") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(thIII") != string::npos) {
            if (strConj.find("02,conjecture") == string::npos && strConj.find("03,conjecture") == string::npos
                    && strConj.find("12,conjecture") == string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(thII") != string::npos) {
            if (strConj.find("03a,conjecture") == string::npos && strConj.find("05,conjecture") == string::npos
                    && strConj.find("06,conjecture") == string::npos && strConj.find("08,conjecture") == string::npos
                    && strConj.find("11,conjecture") == string::npos && strConj.find("12,conjecture") == string::npos
                    && strConj.find("13,conjecture") == string::npos && strConj.find("22,conjecture") == string::npos
                    && strConj.find("24,conjecture") == string::npos && strConj.find("25,conjecture") == string::npos
                    && strConj.find("a01,conjecture") == string::npos && strConj.find("a03,conjecture") == string::npos
                    && strConj.find("a04,conjecture") == string::npos && strConj.find("a05,conjecture") == string::npos
                    && strConj.find("a08,conjecture") == string::npos && strConj.find("a12,conjecture") == string::npos
                    && strConj.find("a13,conjecture") == string::npos && strConj.find("a14,conjecture") == string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(thI") != string::npos) {
            if (strConj.find("10,conjecture") != string::npos || strConj.find("21,conjecture") != string::npos
                    || strConj.find("25,conjecture") != string::npos || strConj.find("26,conjecture") != string::npos
                    || strConj.find("32,conjecture") != string::npos
                    || strConj.find("37,conjecture") != string::npos || strConj.find("40,conjecture") != string::npos
                    || strConj.find("49,conjecture") != string::npos) {
                runSys = 3;
            }
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SET006+3.ax')") != string::npos)
        return runSys;
    
    if (strAxiom.find("include('Axioms/SET007/SET007+0.ax')") != string::npos) {
        if (strConj.find("_autgroup,conjecture") != string::npos) {
            if (strConj.find("t12") != string::npos || strConj.find("t14") != string::npos
                    || strConj.find("t15") != string::npos || strConj.find("t3") != string::npos
                    || strConj.find("t30") != string::npos || strConj.find("t7") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_latsum_1,conjecture") != string::npos) {
            if (strConj.find("t19") != string::npos || strConj.find("t23") != string::npos
                    || strConj.find("t7") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t11") != string::npos) {
                StrategyParam::firstRunTime = 230;
                StrategyParam::timeForceLimit = 4; 
                runSys = 2;
            }
            else if (strConj.find("t20") != string::npos) {
                StrategyParam::firstRunTime = 185;
                StrategyParam::timeForceLimit = 15; 
                runSys = 2;
            }
        }
        else if (strConj.find("_tsp_2,conjecture") != string::npos) {
            if (strConj.find("t1") != string::npos ||  strConj.find("t13") != string::npos
                    || strConj.find("t30") != string::npos || strConj.find("t31") != string::npos
                    || strConj.find("t34") != string::npos || strConj.find("t35") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t24") != string::npos) {
                StrategyParam::firstRunTime = 208;
                StrategyParam::timeForceLimit = 10; 
                runSys = 2;
            }
        }
        else if (strConj.find("_waybel22,conjecture") != string::npos) {
            if (strConj.find("t1") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t6") != string::npos) {
                StrategyParam::firstRunTime = 200;
                StrategyParam::timeForceLimit = 9; 
                runSys = 2;
            }
        }
        else if (strConj.find("_latsubgr,conjecture") != string::npos) {
            if (strConj.find("t10") != string::npos || strConj.find("t13") != string::npos
                    || strConj.find("t33") != string::npos || strConj.find("t35") != string::npos
                    || strConj.find("t38") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t31") != string::npos) {
                StrategyParam::firstRunTime = 130;
                StrategyParam::timeForceLimit = 24; 
                runSys = 2;
            }
        }
        else if (strConj.find("_lopclset,conjecture") != string::npos) {
            if (strConj.find("t10") != string::npos || strConj.find("t44") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t27") != string::npos) {
                StrategyParam::firstRunTime = 195;
                StrategyParam::timeForceLimit = 10; 
                runSys = 2;
            }
        }
        else if (strConj.find("_conlat_2,conjecture") != string::npos) {
            if (strConj.find("t20") == string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_rmod_5,conjecture") != string::npos) {
            if (strConj.find("t11") != string::npos || strConj.find("t12") != string::npos
                    || strConj.find("t4") != string::npos
                    || strConj.find("t18") != string::npos || strConj.find("t2") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t14") != string::npos) {
                StrategyParam::firstRunTime = 16;
                StrategyParam::timeForceLimit = 29; 
                runSys = 2;
            }
            else if (strConj.find("t16") != string::npos) {
                StrategyParam::firstRunTime = 102;
                StrategyParam::timeForceLimit = 17; 
                runSys = 2;
            }
            else if (strConj.find("t6") != string::npos) {
                StrategyParam::firstRunTime = 130;
                StrategyParam::timeForceLimit = 29; 
                runSys = 2;
            }
        }
        else if (strConj.find("_closure3,conjecture") != string::npos) {
            if (strConj.find("t4") != string::npos || strConj.find("t5") != string::npos
                    || strConj.find("t6") != string::npos || strConj.find("t8") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t12") != string::npos) {
                StrategyParam::firstRunTime = 35;
                StrategyParam::timeForceLimit = 16; 
                runSys = 2;
            }
            else if (strConj.find("t7") != string::npos) {
                StrategyParam::firstRunTime = 182;
                StrategyParam::timeForceLimit = 18; 
                runSys = 2;
            }
        }
        else if (strConj.find("_filter_2,conjecture") != string::npos) {
            if (strConj.find("t12") != string::npos || strConj.find("t16") != string::npos
                    || strConj.find("t17") != string::npos || strConj.find("t34") != string::npos
                    || strConj.find("t36") != string::npos || strConj.find("t4") != string::npos
                    || strConj.find("t40") != string::npos || strConj.find("t48") != string::npos
                    || strConj.find("t50") != string::npos || strConj.find("t52") != string::npos
                    || strConj.find("t56") != string::npos || strConj.find("t59") != string::npos
                    || strConj.find("t61") != string::npos || strConj.find("t62") != string::npos
                    || strConj.find("t65") != string::npos || strConj.find("t66") != string::npos
                    || strConj.find("t67") != string::npos || strConj.find("t77") != string::npos
                    || strConj.find("t79") != string::npos || strConj.find("t85") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t13") != string::npos || strConj.find("t26") != string::npos
                    || strConj.find("t27") != string::npos || strConj.find("t32") != string::npos
                    || strConj.find("t54") != string::npos || strConj.find("t58") != string::npos) {
                StrategyParam::firstRunTime = 17;
                StrategyParam::timeForceLimit = 26; 
                runSys = 2;
            }
            else if (strConj.find("t25") != string::npos) {
                StrategyParam::firstRunTime = 132;
                StrategyParam::timeForceLimit = 28; 
                runSys = 2;
            }
            else if (strConj.find("t31") != string::npos) {
                StrategyParam::firstRunTime = 154;
                StrategyParam::timeForceLimit = 16; 
                runSys = 2;
            }
            else if (strConj.find("t41") != string::npos) {
                StrategyParam::firstRunTime = 27;
                StrategyParam::timeForceLimit = 25; 
                runSys = 2;
            }
            else if (strConj.find("t76") != string::npos) {
                StrategyParam::firstRunTime = 184;
                StrategyParam::timeForceLimit = 16; 
                runSys = 2;
            }
            else if (strConj.find("t8") != string::npos) {
                StrategyParam::firstRunTime = 200;
                StrategyParam::timeForceLimit = 5; 
                runSys = 2;
            }
            else if (strConj.find("t35") != string::npos) {
                StrategyParam::firstRunTime = 167;
                StrategyParam::timeForceLimit = 22; 
                runSys = 2;
            }
        }
        else if (strConj.find("_relset_2,conjecture") != string::npos) {
            if (strConj.find("t33") != string::npos || strConj.find("t40") != string::npos
                    || strConj.find("t41") != string::npos || strConj.find("t43") != string::npos
                    || strConj.find("t5") != string::npos || strConj.find("t53") != string::npos
                    || strConj.find("t55") != string::npos || strConj.find("t57") != string::npos
                    || strConj.find("t64") != string::npos || strConj.find("t65") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t18") != string::npos || strConj.find("t28") != string::npos) {
                StrategyParam::firstRunTime = 17;
                StrategyParam::timeForceLimit = 26; 
                runSys = 2;
            }
            else if (strConj.find("t7") != string::npos) {
                StrategyParam::firstRunTime = 171;
                StrategyParam::timeForceLimit = 3; 
                runSys = 2;
            }
            else if (strConj.find("t36") != string::npos) {
                StrategyParam::firstRunTime = 102;
                StrategyParam::timeForceLimit = 15; 
                runSys = 2;
            }
        }
        else if (strConj.find("_waybel34,conjecture") != string::npos) {
            if (strConj.find("t17") != string::npos || strConj.find("t20") != string::npos
                    || strConj.find("t42") != string::npos
                    || strConj.find("t43") != string::npos
                    || strConj.find("t65") != string::npos || strConj.find("t71") != string::npos
                    || strConj.find("t8") != string::npos || strConj.find("t9") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t4") != string::npos) {
                StrategyParam::firstRunTime = 210;
                StrategyParam::timeForceLimit = 6; 
                runSys = 2;
            }
            else if (strConj.find("t12") != string::npos) {
                StrategyParam::firstRunTime = 200;
                StrategyParam::timeForceLimit = 6; 
                runSys = 2;
            }
            else if (strConj.find("t26") != string::npos) {
                StrategyParam::firstRunTime = 50;
                StrategyParam::timeForceLimit = 14; 
                runSys = 2;
            }
            else if (strConj.find("t49") != string::npos) {
                StrategyParam::firstRunTime = 188;
                StrategyParam::timeForceLimit = 16; 
                runSys = 2;
            }
            else if (strConj.find("t5") != string::npos) {
                StrategyParam::firstRunTime = 208;
                StrategyParam::timeForceLimit = 6; 
                runSys = 2;
            }
        }
        else if (strConj.find("_isocat_2,conjecture") != string::npos) {
            if (strConj.find("t40") == string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(t4_yoneda_1,conjecture") != string::npos){
            runSys = 3;
        }
        else if (strConj.find("fof(t8_waybel33,conjecture") != string::npos){
            runSys = 3;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SWB001+0.ax')") != string::npos) {
        if (strConj.find("fof(conclusion_rdfbased_sem_") != string::npos) {
            if (strConj.find("fof(conclusion_rdfbased_sem_bool_") != string::npos && strConj.find("fof(conclusion_rdfbased_sem_bool_tollens,conjecture") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;            
            }
            else if (strConj.find("fof(conclusion_rdfbased_sem_chain_ext,conjecture") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_char_symmetric_ext,conjecture") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_char_transitive_ext,conjecture") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_enum_ext,conjecture") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_eqdis_disjointunion_composite,conjecture") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_inv_ext,conjecture") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_ndis_alldi") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_restrict_allvalues_cmp_") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_restrict_exactqcr_inst_obj_two,conjecture") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_restrict_maxqcr_") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_restrict_minqcr_cmp_") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_restrict_minqcr_inst_obj_one,conjecture") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_restrict_somevalues_cmp_") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_restrict_term_cardqcr,conjecture") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_restrict_term_dataqcr,conjecture") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_restrict_term_minmax") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_restrict_term_sameall,conjecture") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_restrict_term_some") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;            
            }            
        }
        else if (strConj.find("fof(testcase_conclusion_fullish_0") != string::npos) {
            if (strConj.find("fof(testcase_conclusion_fullish_01") != string::npos && strConj.find("fof(testcase_conclusion_fullish_015") == string::npos
                    && strConj.find("fof(testcase_conclusion_fullish_017") == string::npos && strConj.find("fof(testcase_conclusion_fullish_018") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;
            }
            else if (strConj.find("fof(testcase_conclusion_fullish_02") != string::npos && strConj.find("fof(testcase_conclusion_fullish_023") == string::npos
                    && strConj.find("fof(testcase_conclusion_fullish_024") == string::npos && strConj.find("fof(testcase_conclusion_fullish_026") == string::npos
                    && strConj.find("fof(testcase_conclusion_fullish_029") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;
            }
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SWC001+0.ax')") != string::npos) {
        if (strConj.find("fof(co1,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 230;
            StrategyParam::timeForceLimit = 3; 
            runSys = 2; 
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SWV003+0.ax')") != string::npos) {
        if (strConj.find("fof(gauss_init_00") != string::npos) {
            if (strConj.find("fof(gauss_init_0001,conjecture") == string::npos && strConj.find("fof(gauss_init_0005,conjecture") == string::npos 
                    && strConj.find("fof(gauss_init_0033,conjecture") == string::npos && strConj.find("fof(gauss_init_0037,conjecture") == string::npos
                    && strConj.find("fof(gauss_init_0041,conjecture") == string::npos && strConj.find("fof(gauss_init_0045,conjecture") == string::npos
                    && strConj.find("fof(gauss_init_0077,conjecture") == string::npos && strConj.find("fof(gauss_init_0081,conjecture") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;
            }
        }
        else if (strConj.find("fof(quaternion_ds1_symm_") != string::npos) {
            if (strConj.find("fof(quaternion_ds1_symm_0002,conjecture") != string::npos || strConj.find("fof(quaternion_ds1_symm_0004,conjecture") != string::npos
                    || strConj.find("fof(quaternion_ds1_symm_0008,conjecture") != string::npos || strConj.find("fof(quaternion_ds1_symm_0011,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;
            }
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SWV007+0.ax')") != string::npos) {
        if (strConj.find("fof(co3,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 12;
            StrategyParam::timeForceLimit = 28; 
            runSys = 2;            
        }
        else if (strConj.find("fof(l29_co,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;            
        }
        return runSys;
    }
     
    if (strAxiom.find("include('Axioms/SWV011+0.ax')") != string::npos) {
        if (strConj.find("fof(conj,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 181;
            StrategyParam::timeForceLimit = 20; 
            runSys = 2;            
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SWV012+0.ax')") != string::npos) {
        if (strConj.find("fof(exists1_exists2,conjecture") != string::npos
                || strConj.find("fof(or1_or2,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;            
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SYN002+0.ax')") != string::npos) {
        if (strConj.find("fof(ck,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 15;
            StrategyParam::timeForceLimit = 25; 
            runSys = 2;            
        }
        return runSys;
    }
    
    if (strAxiom == "") {
        if (strConj.find("fof(addAssertion,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 31;
            StrategyParam::timeForceLimit = 25; 
            runSys = 2;            
        }
        else if (strConj.find("fof(co1,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 144;
            StrategyParam::timeForceLimit = 25; 
            runSys = 2;            
        }
        else if (strConj.find("fof(conj_") != string::npos) {
            if (strConj.find("fof(conj_0,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 224;
                StrategyParam::timeForceLimit = 4; 
                runSys = 2;            
            }
            else if (strConj.find("fof(conj_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 181;
                StrategyParam::timeForceLimit = 20; 
                runSys = 2;            
            }
            else if (strConj.find("fof(conj_2,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 182;
                StrategyParam::timeForceLimit = 20; 
                runSys = 2;            
            }
            else if (strConj.find("fof(conj_7,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 202;
                StrategyParam::timeForceLimit = 4; 
                runSys = 2;            
            }
        }
        else if (strConj.find("fof('cont(412,0)',conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;               
        }
        else if (strConj.find("fof(goal_to_be_proved,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 130;
            StrategyParam::timeForceLimit = 28; 
            runSys = 2;               
        }
        else if (strConj.find("fof(goals,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 182;
            StrategyParam::timeForceLimit = 18; 
            runSys = 2;               
        }
        else if (strConj.find("fof(goals_09,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 12;
            StrategyParam::timeForceLimit = 28; 
            runSys = 2;               
        }
        else if (strConj == "") {
            StrategyParam::firstRunTime = 140;
            StrategyParam::timeForceLimit = 22; 
            runSys = 2;             
        }
        else if (strConj.find("fof(m__,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 205;
            StrategyParam::timeForceLimit = 8; 
            runSys = 2;               
        }
        else if (strConj.find("fof('holds(") != string::npos) {
            if (strConj.find("fof('holds(3") != string::npos && strConj.find("fof('holds(307") == string::npos
                    && strConj.find("fof('holds(324") == string::npos
                    && strConj.find("fof('holds(331") == string::npos && strConj.find("fof('holds(363") == string::npos
                    && strConj.find("fof('holds(364") == string::npos && strConj.find("fof('holds(384") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;     
            }
            else if (strConj.find("fof('holds(4") != string::npos && strConj.find("fof('holds(407") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;
            } 
            else if (strConj.find("fof('holds(conjunct1(") != string::npos) {
                if (strConj.find("fof('holds(conjunct1(338), 1268, 0)',conjecture") != string::npos
                        || strConj.find("fof('holds(conjunct1(conjunct2(338)), 1269, 0)',conjecture") != string::npos
                        || strConj.find("fof('holds(conjunct1(conjunct2(359)), 1319, 0)',conjecture") != string::npos
                        || strConj.find("fof('holds(conjunct1(conjunct2(375)), 1344, 0)',conjecture") != string::npos) {
                    StrategyParam::firstRunTime = 0;
                    StrategyParam::timeForceLimit = 240; 
                    runSys = 3;   
                }
            }
            else if (strConj.find("fof('holds(conjunct2(") != string::npos) {
                if (strConj.find("fof('holds(conjunct2(conjunct2(266)), 1177, 0)',conjecture") == string::npos
                        && strConj.find("fof('holds(conjunct2(362), 1325, 0)',conjecture") == string::npos
                        && strConj.find("fof('holds(conjunct2(conjunct2(359)), 1320, 0)',conjecture") == string::npos) {
                    StrategyParam::firstRunTime = 0;
                    StrategyParam::timeForceLimit = 240; 
                    runSys = 3;   
                }
            }
        }
        else if (strConj.find("_wellord1,conjecture") != string::npos) {
            if (strConj.find("fof(l") != string::npos) {
                if (strConj.find("fof(l2") != string::npos || strConj.find("fof(l3") != string::npos
                        || strConj.find("fof(l4") != string::npos) {
                    StrategyParam::firstRunTime = 13;
                    StrategyParam::timeForceLimit = 27; 
                    runSys = 2;              
                }
            }
            else if (strConj.find("fof(t") != string::npos) {
                if (strConj.find("fof(t17") != string::npos || strConj.find("fof(t23_wellord1,conjecture") != string::npos
                        || strConj.find("fof(t49") != string::npos) {
                    StrategyParam::firstRunTime = 0;
                    StrategyParam::timeForceLimit = 240; 
                    runSys = 3;              
                }
                else if (strConj.find("fof(t19_wellord1,conjecture") != string::npos
                        || strConj.find("fof(t21_wellord1,conjecture") != string::npos || strConj.find("fof(t22_wellord1,conjecture") != string::npos
                        || strConj.find("fof(t24_wellord1,conjecture") != string::npos || strConj.find("fof(t25_wellord1,conjecture") != string::npos
                        || strConj.find("fof(t5_wellord1,conjecture") != string::npos) {
                    StrategyParam::firstRunTime = 25;
                    StrategyParam::timeForceLimit = 25; 
                    runSys = 2;              
                }
            }
        }
        else if (strConj.find("_zfmisc_1,conjecture") != string::npos) {
            if (strConj.find("fof(l55_zfmisc_1,conjecture") != string::npos || strConj.find("fof(t118_zfmisc_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 13;
                StrategyParam::timeForceLimit = 27; 
                runSys = 2;   
            }
            else if (strConj.find("fof(t101_zfmisc_1,conjecture") != string::npos || strConj.find("fof(t105_zfmisc_1,conjecture") != string::npos
                    || strConj.find("fof(t118_zfmisc_1,conjecture") != string::npos || strConj.find("fof(t122_zfmisc_1,conjecture") != string::npos
                    || strConj.find("fof(t123_zfmisc_1,conjecture") != string::npos || strConj.find("fof(t125_zfmisc_1,conjecture") != string::npos
                    || strConj.find("fof(t136_zfmisc_1,conjecture") != string::npos || strConj.find("fof(t36_zfmisc_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;   
            }
        }
        else if (strConj.find("_xboole_1,conjecture") != string::npos) {
            if (strConj.find("fof(t45_xboole_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 183;
                StrategyParam::timeForceLimit = 20; 
                runSys = 2;
            }
        }
        else if (strConj.find("_funct_1,conjecture") != string::npos) {
            if (strConj.find("fof(t118_funct_1,conjecture") != string::npos || strConj.find("fof(t121_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t137_funct_1,conjecture") != string::npos || strConj.find("fof(t138_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t139_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t150_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t151_funct_1,conjecture") != string::npos || strConj.find("fof(t154_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t155_funct_1,conjecture") != string::npos || strConj.find("fof(t160_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t20_funct_1,conjecture") != string::npos || strConj.find("fof(t37_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t43_funct_1,conjecture") != string::npos || strConj.find("fof(t48_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t51_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t85_funct_1,conjecture") != string::npos || strConj.find("fof(t9_funct_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;
            }
            else if (strConj.find("fof(t145_funct_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 13;
                StrategyParam::timeForceLimit = 25; 
                runSys = 2;
            }
            else if (strConj.find("fof(t21_funct_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 105;
                StrategyParam::timeForceLimit = 5; 
                runSys = 2;
            }
            else if (strConj.find("fof(t22_funct_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 23;
                StrategyParam::timeForceLimit = 25; 
                runSys = 2;
            }
            else if (strConj.find("fof(t54_funct_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 92;
                StrategyParam::timeForceLimit = 25; 
                runSys = 2;
            }
        }
        else if (strConj.find("fof(n") != string::npos) {
            if (strConj.find("fof(nc5,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;                
            }
        }
        else if (strConj.find("fof(pel") != string::npos) {
            if (strConj.find("fof(pel53,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;                
            }
        }
        else if (strConj.find("fof(prove") != string::npos) {
            if (strConj.find("fof(prove_relset_1_33,conjecture") != string::npos || strConj.find("fof(prove_relset_1_35,conjecture") != string::npos
                    || strConj.find("fof(prove_th99,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;                
            }
        }
        else if (strConj.find("fof('qe(") != string::npos) {
            if (strConj.find("fof('qe(229)',conjecture") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;                
            }
        }
        else if (strConj.find("fof(s1_") != string::npos) {
            if (strConj.find("fof(s1_xboole") == string::npos && strConj.find("fof(s1_ordinal2") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;                
            }
            else if (strConj.find("fof(s1_xboole") != string::npos) {
                if (strConj.find("pre_topc__1,conjecture") != string::npos) {
                    StrategyParam::firstRunTime = 12;
                    StrategyParam::timeForceLimit = 28; 
                    runSys = 2;
                }
                else if (strConj.find("wellord2") != string::npos) {
                    if (strConj.find("fof(s1_xboole_0__e10_24__wellord2__1,conjecture") != string::npos) {
                        runSys = 3;
                    }
                    else {
                        StrategyParam::firstRunTime = 12;
                        StrategyParam::timeForceLimit = 28; 
                        runSys = 2;
                    }
                }
                else if (strConj.find("waybel") != string::npos) {
                    StrategyParam::firstRunTime = 12;
                    StrategyParam::timeForceLimit = 28; 
                    runSys = 2;
                }
                else if (strConj.find("finset") != string::npos) {
                    StrategyParam::firstRunTime = 17;
                    StrategyParam::timeForceLimit = 28; 
                    runSys = 2;
                }
                else if (strConj.find("tops_2__1") != string::npos) {
                    StrategyParam::firstRunTime = 186;
                    StrategyParam::timeForceLimit = 14; 
                    runSys = 2;
                }
                else if (strConj.find("yellow19") != string::npos) {
                    StrategyParam::firstRunTime = 135;
                    StrategyParam::timeForceLimit = 28; 
                    runSys = 2;
                }
            }
        }
        else if (strConj.find("fof(s2_") != string::npos) {
            if (strConj.find("fof(s2_funct_1") != string::npos && strConj.find("tops_2") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;                  
            }
            else if (strConj.find("fof(s2_funct_1") != string::npos && strConj.find("wellord2") == string::npos) {
                StrategyParam::firstRunTime = 12;
                StrategyParam::timeForceLimit = 24; 
                runSys = 2;                  
            }
            else if (strConj.find("fof(s2_xboole_0") != string::npos) {
                StrategyParam::firstRunTime = 12;
                StrategyParam::timeForceLimit = 28; 
                runSys = 2;
            }
        }
        else if (strConj.find("fof(s3_") != string::npos) {
            if (strConj.find("fof(s3_subset_1__e1_40__pre_topc,conjecture") != string::npos || strConj.find("fof(s3_subset_1__e2_37_1_1__pre_topc,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 170;
                StrategyParam::timeForceLimit = 4; 
                runSys = 2;
            }
        } 
        else if (strConj.find("_tops_") != string::npos) {
            runSys = 1;
        }
        else if (strConj.find("fof(mv5,conjecture") != string::npos){
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;
        }
        else if (strConj.find("_autgroup,conjecture") != string::npos) {
            if (strConj.find("fof(t16") != string::npos || strConj.find("t26") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_latsum_1,conjecture") != string::npos) {
            if (strConj.find("fof(t19") != string::npos || strConj.find("t24") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_waybel22,conjecture") != string::npos) {
            runSys = 1;
        }
        else if (strConj.find("_yellow_1,conjecture") != string::npos) {
            if (strConj.find("fof(t2") != string::npos) {
                StrategyParam::firstRunTime = 12;
                StrategyParam::timeForceLimit = 24;
                runSys = 2;
            }
        }
        else if (strConj.find("_finsub_1,conjecture") != string::npos) {
            if (strConj.find("fof(t24") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_latsubgr,conjecture") != string::npos) {
            if (strConj.find("fof(t35") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_ordinal1,conjecture") != string::npos) {
            if (strConj.find("fof(t29") != string::npos
                    || strConj.find("fof(t35") != string::npos || strConj.find("fof(t36") != string::npos
                    || strConj.find("fof(t41") != string::npos || strConj.find("fof(t5") != string::npos
                    || strConj.find("fof(t6") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("fof(t32") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 24;
                runSys = 2;
            }
            else if (strConj.find("fof(t23") != string::npos) {
                StrategyParam::firstRunTime = 204;
                StrategyParam::timeForceLimit = 6;
                runSys = 2;
            }
        }
        else if (strConj.find("_lopclset,conjecture") != string::npos) {
            if (strConj.find("fof(t30") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_rmod_5,conjecture") != string::npos) {
            if (strConj.find("fof(t11") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_waybel_") != string::npos) {
            if (strConj.find("fof(t29_waybel_9") != string::npos || strConj.find("fof(t8_waybel_") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 24;
                runSys = 2;
            }
        }
        else if (strConj.find("_yellow19,conjecture") != string::npos) {
            if (strConj.find("fof(t15") != string::npos || strConj.find("fof(t18") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 24;
                runSys = 2;
            }
            else if (strConj.find("fof(t13") != string::npos || strConj.find("fof(t4") != string::npos
                    || strConj.find("fof(t9") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_relat_1,conjecture") != string::npos) {
            if (strConj.find("fof(t115") != string::npos || strConj.find("fof(t143") != string::npos
                    || strConj.find("fof(t145") != string::npos
                    || strConj.find("fof(t178") != string::npos
                    || strConj.find("fof(t21") != string::npos || strConj.find("fof(t25") != string::npos
                    || strConj.find("fof(t44") != string::npos || strConj.find("fof(t45") != string::npos
                    || strConj.find("fof(t86") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 24;
                runSys = 2;
            }
            else if (strConj.find("fof(t117") != string::npos || strConj.find("fof(t71") != string::npos
                    || strConj.find("fof(t88") != string::npos) {
                StrategyParam::firstRunTime = 129;
                StrategyParam::timeForceLimit = 24;
                runSys = 2;
            }
            else if (strConj.find("fof(t119") != string::npos || strConj.find("fof(t140") != string::npos
                    || strConj.find("fof(t160") != string::npos
                    || strConj.find("fof(t46") != string::npos || strConj.find("fof(t47") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("fof(t146") != string::npos || strConj.find("fof(t90") != string::npos
                    || strConj.find("fof(t94") != string::npos) {
                StrategyParam::firstRunTime = 152;
                StrategyParam::timeForceLimit = 30;
                runSys = 2;
            }
            else if (strConj.find("fof(t37") != string::npos) {
                StrategyParam::firstRunTime = 26;
                StrategyParam::timeForceLimit = 25;
                runSys = 2;
            }
        }
        else if (strConj.find("_closure3,conjecture") != string::npos) {
            if (strConj.find("fof(t12") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_filter_2,conjecture") != string::npos) {
            if (strConj.find("fof(t2") != string::npos || strConj.find("fof(t35") != string::npos
                    || strConj.find("fof(t49") != string::npos || strConj.find("fof(t51") != string::npos
                    || strConj.find("fof(t52") != string::npos || strConj.find("fof(t56") != string::npos
                    || strConj.find("fof(t77") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_pre_topc,conjecture") != string::npos) {
            if (strConj.find("fof(t45") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("fof(t48") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 25;
                runSys = 2;
            }
        }
        else if (strConj.find("_relset_1,conjecture") != string::npos) {
            if (strConj.find("fof(t12") != string::npos || strConj.find("fof(t23") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 25;
                runSys = 2;
            }
        }
        else if (strConj.find("_relset_2,conjecture") != string::npos) {
            if (strConj.find("fof(t12") != string::npos || strConj.find("fof(t13") != string::npos
                    || strConj.find("fof(t14") != string::npos || strConj.find("fof(t22") != string::npos
                    || strConj.find("fof(t27") != string::npos || strConj.find("fof(t40") != string::npos
                    || strConj.find("fof(t5") != string::npos || strConj.find("fof(t8") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_waybel34,conjecture") != string::npos) {
            if (strConj.find("fof(t17") != string::npos || strConj.find("fof(t38") != string::npos
                    || strConj.find("fof(t45") != string::npos || strConj.find("fof(t46") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_finset_1,conjecture") != string::npos) {
            if (strConj.find("fof(t17") != string::npos || strConj.find("fof(t22") != string::npos
                    || strConj.find("fof(t23") != string::npos || strConj.find("fof(t31") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_yellow_0,conjecture") != string::npos) {
            if (strConj.find("fof(t15") != string::npos || strConj.find("fof(t16") != string::npos
                    || strConj.find("fof(t60") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 25;
                runSys = 2;
            }
        }
        else if (strConj.find("_yellow_6,conjecture") != string::npos) {
            if (strConj.find("fof(t21") != string::npos || strConj.find("fof(t28") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 25;
                runSys = 2;
            }
        }
        else if (strConj.find("_wellord2,conjecture") != string::npos) {
            if (strConj.find("fof(t3") != string::npos) {
                StrategyParam::firstRunTime = 131;
                StrategyParam::timeForceLimit = 28;
                runSys = 2;
            }
            else if (strConj.find("fof(t4") != string::npos) {
                StrategyParam::firstRunTime = 182;
                StrategyParam::timeForceLimit = 18;
                runSys = 2;
            }
        }
        else if (strConj.find("_orders_2,conjecture") != string::npos) {
            if (strConj.find("fof(t25") != string::npos) {
                StrategyParam::firstRunTime = 12;
                StrategyParam::timeForceLimit = 28;
                runSys = 2;
            }
            else if (strConj.find("fof(t26") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_waybel33,conjecture") != string::npos) {
            if (strConj.find("fof(t27") != string::npos || strConj.find("fof(t7") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_isocat_2,conjecture") != string::npos) {
            if ( strConj.find("fof(t43") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(tautology,conjecture") != string::npos) {
            runSys = 3;
        }
        else if (strConj.find("fof(thm_2E") != string::npos) {
            if (strConj.find("fof(thm_2Earith") != string::npos || strConj.find("fof(thm_2Equotient_") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(tlhfof") != string::npos) {
            if (strConj.find("fof(tlhfof34981,") != string::npos || strConj.find("fof(tlhfof40016,") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(main,") != string::npos) {
            StrategyParam::firstRunTime = 182;
            StrategyParam::timeForceLimit = 20;
            runSys = 2;
        }
        return runSys;
    } 
    return runSys;
}

int ReadOriProblem180(const string& problemFile) {
    int runSys = 1; //1 only run E; 2 E->CSE->E; 3 CSE->E
    string strConj = "";
    string strAxiom = "";
    string problemField = "";
    ifstream fin(problemFile);
    string str = "";
    bool flag = false;
    while (getline(fin, str)) {
        if (str.find("conjecture") != string::npos) {
            int begPos = str.find_first_of(",");
            int endPos = str.find_last_of(",");
            string temp = str.substr(begPos + 1, endPos - (begPos + 1));
            if (temp == "conjecture") {
                strConj = str;
                break;
            }
        }
        else if (str.find("include(") != string::npos && !flag) {
            strAxiom = str;
            flag = true;
        }
    }

    if (strAxiom.find("include('Axioms/AGT001") != string::npos) {
        if (strConj.find("fof(query_") != string::npos) {
            int begPos = strConj.find_first_of("_");
            begPos += 1;
            int endPos = strConj.find_first_of(",");
            string temp = strConj.substr(begPos, endPos - begPos);
            int index = atoi(temp.c_str());
            if ((index >= 6 && index <= 13) || (index >= 18 && index <= 26))
                runSys = 3;
            else 
                runSys = 1;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/BIO001") != string::npos) {
        if (strConj.find("fof(ask,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 60;
            StrategyParam::timeForceLimit = 24; 
            runSys = 2;
        } 
        return runSys;        
    }
    
    if (strAxiom.find("include('Axioms/COM001+0.ax')") != string::npos) {
        if (strConj.find("fof('T-Weak-FreeVar-") != string::npos) {
            if (strConj.find("-abs-2',") != string::npos)
                runSys = 3;
            else 
                runSys = 1;
        }
        else if (strConj.find("fof('T-subst-") != string::npos) {
            if (strConj.find("-abs-3',") != string::npos)
                runSys = 3;
            else 
                runSys = 1;
        }
        else if (strConj.find("fof('T-Preservation-T-") != string::npos) {
            if (strConj.find("app',") != string::npos)
                runSys = 3;
            else 
                runSys = 1;
        }
        else if (strConj.find("fof('T-Progress-T-") != string::npos) {
            if (strConj.find("app',") != string::npos)
                runSys = 3;
            else 
                runSys = 1;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR001+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR002+1.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR002+2.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR002+3.ax')") != string::npos) {
        if (strConj.find("fof(query") != string::npos) {
            int begPos = strConj.find_first_of("y");
            begPos += 1;
            int endPos = strConj.find_first_of(",");
            string temp = strConj.substr(begPos, endPos - begPos);
            int index = atoi(temp.c_str());
            if (index == 186 || index == 189 || index == 199 || index == 211)
                runSys = 3;
            else 
                runSys = 1;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR002+4.ax')") != string::npos) {
        if (strConj.find("fof(query") != string::npos) {
            int begPos = strConj.find_first_of("y");
            begPos += 1;
            int endPos = strConj.find_first_of(",");
            string temp = strConj.substr(begPos, endPos - begPos);
            int index = atoi(temp.c_str());
            if (index == 226 || index == 229 || index == 236 || index == 239 || index == 240
                    || index == 245 || index == 249 || index == 258 || index == 260 || index == 261
                    || index == 265 || index == 274)
                runSys = 3;
            else 
                runSys = 1;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR002+5.ax')") != string::npos) {
        if (strConj.find("fof(query") != string::npos) {
            int begPos = strConj.find_first_of("y");
            begPos += 1;
            int endPos = strConj.find_first_of(",");
            string temp = strConj.substr(begPos, endPos - begPos);
            int index = atoi(temp.c_str());
            if (index == 283 || index == 290 || index == 295 || index == 302 || index == 306 || index == 308)
                runSys = 3;
            else 
                runSys = 1;
        }
        else if (strConj == "")
            runSys = 3;
        return runSys;
    }    
    
    if (strAxiom.find("include('Axioms/CSR003+0.ax')") != string::npos) {
        if (strConj.find("fof(prove_from_SUMO,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 112;
            StrategyParam::timeForceLimit = 15; 
            runSys = 2;
        } 
        return runSys;
    }  
    
    if (strAxiom.find("include('Axioms/CSR003+1.ax')") != string::npos) {
        if (strConj.find("fof(prove_from_SUMO_MILO,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 110;
            StrategyParam::timeForceLimit = 20; 
            runSys = 2;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR003+2.ax')") != string::npos) {
        if (strConj.find("fof(abe_mammal,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 16;
            StrategyParam::timeForceLimit = 44; 
            runSys = 2;
        } 
        else if (strConj == "") {
            runSys = 3;
        }
        else if (strConj.find("fof(prove_from_ALL,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 170;
            StrategyParam::timeForceLimit = 4; 
            runSys = 2;
        }        
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR004+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR006+0.ax')") != string::npos) {
        if (strConj.find("fof(antonymPattern") != string::npos) {
            int begPos = strConj.find_first_of("Pattern");
            begPos += 7;
            int endPos = strConj.find_first_of(",");
            string temp = strConj.substr(begPos, endPos - begPos);
            int index = atoi(temp.c_str());
            if (index == 10007 || index == 10048 || (index >= 20012 && index <= 20235) || index == 30068 
                    || index == 30584 || (index >= 31444 && index <= 32292))
                runSys = 3;
        }
        else if (strConj.find("fof(negatedCommonSubclassEvent") != string::npos)
            runSys = 3;
        else if (strConj.find("negatedEqualEvent0006,") != string::npos
                || strConj.find("negatedInstrumentRelation0342,") != string::npos)
            runSys = 3;
        else if (strConj.find("negatedMultipleMapping,") != string::npos) {
            StrategyParam::firstRunTime = 120;
            StrategyParam::timeForceLimit = 15;
            runSys = 2;
        }
        else if (strConj.find("negatedSubclassEvent,") != string::npos && strConj.find("negatedSubclassEvent0127,") == string::npos) {
            runSys = 3;
        }
        else if (strConj.find("negatedResultRelation,") != string::npos) {
            StrategyParam::firstRunTime = 80;
            StrategyParam::timeForceLimit = 13;
            runSys = 2;
        }
        else if (strConj.find("fof(agentRelation") != string::npos) {
            runSys = 3;
        } 
        else if (strConj.find("fof(instrumentRelation") != string::npos) {
            if (strConj.find("0028") != string::npos)
                runSys = 3;
        }
        else if (strConj.find("fof(multipleMapping0010,") != string::npos) {
            runSys = 3;
        } 
        else if (strConj.find("fof(resultRelation") != string::npos) {
            runSys = 3;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO004+0.ax')") != string::npos) {
        if (strConj.find("fof(corollary_2_12,conjecture") != string::npos || strConj.find("fof(theorem_3_6,conjecture") != string::npos
                || strConj.find("fof(theorem_4_6_1,conjecture") != string::npos || strConj.find("fof(theorem_4_6_2,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 50; 
            runSys = 3;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO006+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO007+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO008+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO009+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO010+0.ax')") != string::npos) {
        if (strConj.find("fof(aDISTu_") == string::npos && strConj.find("fof(aLIFTu_D") == string::npos
                && strConj.find("fof(aLIFTu_E") == string::npos && strConj.find("fof(aNORMu_PASTECARTu_0u") == string::npos
                && strConj.find("fof(aNORMu_POSu_LT,") == string::npos && strConj.find("fof(aR") == string::npos
                && strConj.find("fof(aVE") == string::npos && strConj.find("fof(aSIGNu_I,conjecture") == string::npos)
            runSys = 3;
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO011+0.ax')") != string::npos) {
        if (strConj.find("fof(aSatz") != string::npos) {
            if (strConj.find("fof(aSatz4_") != string::npos
                    || strConj.find("fof(aSatz7_22") != string::npos || strConj.find("fof(aSatz9_4") != string::npos
                    || strConj.find("fof(aSatz11_7") != string::npos || strConj.find("fof(aSatz11_49b") != string::npos)
                runSys = 3;
        }
        else if (strConj.find("fof(aExtSameSide") != string::npos)
            runSys = 3;
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GRA001+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GRA007+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/HAL001+0.ax')") != string::npos) {
        if (strConj.find("fof(g_injection,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 12;
            StrategyParam::timeForceLimit = 28; 
            runSys = 2;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/ITP001/ITP001+2.ax')") != string::npos) {
        if (strConj.find("fof(conj_thm_2Earithmetic_2EMOD__2,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 12;
            StrategyParam::timeForceLimit = 28; 
            runSys = 2;
        } 
        else if (strConj.find("fof(conj_thm_2Ebitstring_2Eword__1comp__v2w,conjecture") != string::npos || strConj.find("fof(conj_thm_2Equotient__option_2EOPTION__REL__def,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 14;
            StrategyParam::timeForceLimit = 26; 
            runSys = 2;
        } 
        else if (strConj.find("fof(conj_thm_2Eextreal_2Emax__le,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 15;
            StrategyParam::timeForceLimit = 26; 
            runSys = 2;
        } 
        else if (strConj.find("fof(conj_thm_2Elebesgue_2Epos__fn__integral__cmul,conjecture") != string::npos || strConj.find("fof(conj_thm_2Ereal__topology_2ECLOSED__UNION__COMPACT__SUBSETS,conjecture") != string::npos
                || strConj.find("fof(conj_thm_2Ereal__topology_2EINDEPENDENT__STDBASIS,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 50; 
            runSys = 3;
        } 
        else if (strConj.find("fof(conj_thm_2Eoption_2EOPTION__MAP2__THM,conjecture") != string::npos || strConj.find("fof(conj_thm_2EpatternMatches_2EPMATCH__FLATTEN__FUN__PMATCH__ROW,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 12;
            StrategyParam::timeForceLimit = 28; 
            runSys = 2;
        } 
        else if (strConj.find("fof(conj_thm_2Ereal__topology_2EBOUNDED__BALL,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 162;
            StrategyParam::timeForceLimit = 6; 
            runSys = 2;
        }
        else if (strConj.find("fof(conj_thm_2Ereal_2ESUP__EPSILON,conjecture") != string::npos || strConj.find("fof(conj_thm_2Eseq_2EBOLZANO__LEMMA,conjecture") != string::npos
                || strConj.find("fof(conj_thm_2Ewords_2En2w__sub,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 18;
            StrategyParam::timeForceLimit = 22; 
            runSys = 2;
        }
        else if (strConj.find("fof(conj_thm_2Eutil__prob_2ENUM__2D__BIJ__INV,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 170;
            StrategyParam::timeForceLimit = 3; 
            runSys = 2;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/ITP001/ITP002+4.ax')") != string::npos) {
        if (strConj.find("fof(thm_2Ebool_2ETRUTH,conjecture") == string::npos && strConj.find("fof(thm_2Ecardinal_2ECARD__NOT__LE,conjecture") == string::npos
                && strConj.find("fof(thm_2Epred__set_2EREST__SUBSET,conjecture") == string::npos && strConj.find("fof(thm_2EquantHeuristics_2EGUESS__RULES__WEAKEN__FORALL__POINT,conjecture") == string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 50; 
            runSys = 3;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/KLE001+0.ax')") != string::npos) {
        if (strConj.find("fof(goals,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 148;
            StrategyParam::timeForceLimit = 10; 
            runSys = 2;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/KLE002+0.ax')") != string::npos) {
        if (strConj.find("fof(goals,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 162;
            StrategyParam::timeForceLimit = 6; 
            runSys = 2;
        } 
        else if (strConj.find("fof(a,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 137;
            StrategyParam::timeForceLimit = 13;
            runSys = 2;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/KLE004+0.ax')") != string::npos) {
        if (strConj.find("fof(goals,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 165;
            StrategyParam::timeForceLimit = 5; 
            runSys = 2;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/KRS001+0.ax')") != string::npos) {
        if (strConj.find("fof(mighta_wth_thm,conjecture") != string::npos || strConj.find("fof(mighta_eth_thm,conjecture") != string::npos
                || strConj.find("fof(xora_csa_thm,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 240;
            StrategyParam::timeForceLimit = 0; 
            runSys = 3;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/KRS001+1.ax')") != string::npos)
        return runSys;
    
    if (strAxiom.find("include('Axioms/LCL006+0.ax')") != string::npos) {
        if (strConj.find("fof(hilbert_and_2,conjecture,and_2") != string::npos) {
            StrategyParam::firstRunTime = 20;
            StrategyParam::timeForceLimit = 25; 
            runSys = 2;
        }
        else if (strConj.find("fof(hilbert_and_3,conjecture,and_3") != string::npos) {
            StrategyParam::firstRunTime = 100;
            StrategyParam::timeForceLimit = 15; 
            runSys = 2;
        }
        else if (strConj.find("fof(hilbert_equivalence_3,conjecture,equivalence_3") != string::npos || strConj.find("fof(principia_r4,conjecture,r4") != string::npos) {
            StrategyParam::firstRunTime = 103;
            StrategyParam::timeForceLimit = 15; 
            runSys = 2;
        } 
        else if (strConj.find("fof(hilbert_modus_tollens,conjecture,modus_tollens") != string::npos || strConj.find("fof(principia_r5,conjecture,r5") != string::npos) {
            StrategyParam::firstRunTime = 17;
            StrategyParam::timeForceLimit = 25; 
            runSys = 2;
        }
        else if (strConj.find("fof(rosser_kn3,conjecture,kn3") != string::npos) {
            StrategyParam::firstRunTime = 152;
            StrategyParam::timeForceLimit = 8; 
            runSys = 2;
        }
        else if (strConj.find("fof(s1_0_axiom_m5,conjecture,axiom_m5") != string::npos
                || strConj.find("fof(s1_0_m6s3m9b_axiom_s3,conjecture,axiom_s3") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 50; 
            runSys = 3;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/LCL006+1.ax')") != string::npos) {
        if (strConj.find("fof(km5_axiom_K,conjecture,axiom_K") != string::npos) {
            StrategyParam::firstRunTime = 105;
            StrategyParam::timeForceLimit = 15; 
            runSys = 2;
        }
    }
    
    if (strAxiom.find("include('Axioms/MED001+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/MGT001+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/NLP001+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/NUM005+0.ax')") != string::npos) {
        if (strConj.find("fof(associative_sum,conjecture") != string::npos || strConj.find("fof(communative_sum_n6_n7,conjecture") != string::npos
                || strConj.find("fof(show_lower_boundary,conjecture") != string::npos || strConj.find("fof(show_upper_boundary,conjecture") != string::npos
                || strConj.find("fof(sum_n23_n34_n57,conjecture") != string::npos || strConj.find("fof(sum_n23_something_n34,conjecture") != string::npos
                || strConj.find("fof(sum_something_n23_n34,conjecture") != string::npos || strConj.find("fof(summ_n23_n34_something,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/NUM008+0.ax')") != string::npos) {
        if (strConj.find("fof(primeexist,conjecture") != string::npos || strConj.find("fof(evengreq4,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/NUM009+0.ax')") != string::npos) {
        if (strConj.find("fof(oneplustwoidthree,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/PHI002+0.ax')") != string::npos)
        return runSys;
    
    if (strAxiom.find("include('Axioms/PRD001+0.ax')") != string::npos)
        return runSys;
    
    
    if (strAxiom.find("include('Axioms/REL001+0.ax')") != string::npos) {
        if (strConj.find("fof(goals,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 152;
            StrategyParam::timeForceLimit = 8; 
            runSys = 2;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SET005+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SET006+0.ax')") != string::npos) {
        if (strConj.find("fof(set_partitions_itself,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;
        }
        else if (strConj.find("fof(thV") != string::npos) {
            if (strConj.find("1,conjecture") != string::npos || strConj.find("15,conjecture") != string::npos
                    || strConj.find("16,conjecture") != string::npos || strConj.find("21,conjecture") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(thIV") != string::npos) {
            if (strConj.find("17,conjecture") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(thIII") != string::npos) {
            if (strConj.find("02,conjecture") == string::npos && strConj.find("03,conjecture") == string::npos
                    && strConj.find("12,conjecture") == string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(thII") != string::npos) {
            if (strConj.find("03a,conjecture") == string::npos && strConj.find("05,conjecture") == string::npos
                    && strConj.find("06,conjecture") == string::npos && strConj.find("08,conjecture") == string::npos
                    && strConj.find("11,conjecture") == string::npos && strConj.find("12,conjecture") == string::npos
                    && strConj.find("13,conjecture") == string::npos && strConj.find("22,conjecture") == string::npos
                    && strConj.find("24,conjecture") == string::npos && strConj.find("25,conjecture") == string::npos
                    && strConj.find("a01,conjecture") == string::npos && strConj.find("a03,conjecture") == string::npos
                    && strConj.find("a04,conjecture") == string::npos && strConj.find("a05,conjecture") == string::npos
                    && strConj.find("a08,conjecture") == string::npos && strConj.find("a12,conjecture") == string::npos
                    && strConj.find("a13,conjecture") == string::npos && strConj.find("a14,conjecture") == string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(thI") != string::npos) {
            if (strConj.find("10,conjecture") != string::npos || strConj.find("21,conjecture") != string::npos
                    || strConj.find("25,conjecture") != string::npos || strConj.find("26,conjecture") != string::npos
                    || strConj.find("32,conjecture") != string::npos || strConj.find("36,conjecture") != string::npos
                    || strConj.find("37,conjecture") != string::npos || strConj.find("40,conjecture") != string::npos
                    || strConj.find("49,conjecture") != string::npos) {
                runSys = 3;
            }
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SET006+3.ax')") != string::npos)
        return runSys;
    
    if (strAxiom.find("include('Axioms/SET007/SET007+0.ax')") != string::npos) {
        if (strConj.find("_autgroup,conjecture") != string::npos) {
            if (strConj.find("t12") != string::npos || strConj.find("t14") != string::npos
                    || strConj.find("t15") != string::npos || strConj.find("t3") != string::npos
                    || strConj.find("t30") != string::npos || strConj.find("t7") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_latsum_1,conjecture") != string::npos) {
            if (strConj.find("t19") != string::npos || strConj.find("t23") != string::npos
                    || strConj.find("t7") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t11") != string::npos) {
                StrategyParam::firstRunTime = 22;
                StrategyParam::timeForceLimit = 20; 
                runSys = 2;
            }
            else if (strConj.find("t20") != string::npos) {
                StrategyParam::firstRunTime = 142;
                StrategyParam::timeForceLimit = 8; 
                runSys = 2;
            }
        }
        else if (strConj.find("_tsp_2,conjecture") != string::npos) {
            if (strConj.find("t1") != string::npos ||  strConj.find("t13") != string::npos
                    || strConj.find("t30") != string::npos || strConj.find("t31") != string::npos
                    || strConj.find("t34") != string::npos || strConj.find("t35") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_waybel22,conjecture") != string::npos) {
            if (strConj.find("t1") != string::npos || strConj.find("t18") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t6") != string::npos) {
                StrategyParam::firstRunTime = 153;
                StrategyParam::timeForceLimit = 6; 
                runSys = 2;
            }
        }
        else if (strConj.find("_latsubgr,conjecture") != string::npos) {
            if (strConj.find("t10") != string::npos || strConj.find("t13") != string::npos
                    || strConj.find("t33") != string::npos || strConj.find("t35") != string::npos
                    || strConj.find("t38") != string::npos || strConj.find("t24") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t31") != string::npos) {
                StrategyParam::firstRunTime = 100;
                StrategyParam::timeForceLimit = 12; 
                runSys = 2;
            }
        }
        else if (strConj.find("_lopclset,conjecture") != string::npos) {
            if (strConj.find("t10") != string::npos || strConj.find("t44") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t27") != string::npos) {
                StrategyParam::firstRunTime = 152;
                StrategyParam::timeForceLimit = 8; 
                runSys = 2;
            }
        }
        else if (strConj.find("_conlat_2,conjecture") != string::npos) {
            if (strConj.find("t20") == string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_rmod_5,conjecture") != string::npos) {
            if (strConj.find("t11") != string::npos || strConj.find("t12") != string::npos
                    || strConj.find("t4") != string::npos || strConj.find("t6") != string::npos
                    || strConj.find("t18") != string::npos || strConj.find("t2") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t14") != string::npos) {
                StrategyParam::firstRunTime = 16;
                StrategyParam::timeForceLimit = 29; 
                runSys = 2;
            }
            else if (strConj.find("t16") != string::npos) {
                StrategyParam::firstRunTime = 102;
                StrategyParam::timeForceLimit = 17; 
                runSys = 2;
            }
        }
        else if (strConj.find("_closure3,conjecture") != string::npos) {
            if (strConj.find("t4") != string::npos || strConj.find("t5") != string::npos
                    || strConj.find("t6") != string::npos || strConj.find("t8") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t12") != string::npos) {
                StrategyParam::firstRunTime = 35;
                StrategyParam::timeForceLimit = 16; 
                runSys = 2;
            }
            else if (strConj.find("t7") != string::npos) {
                StrategyParam::firstRunTime = 40;
                StrategyParam::timeForceLimit = 13; 
                runSys = 2;
            }
        }
        else if (strConj.find("_filter_2,conjecture") != string::npos) {
            if (strConj.find("t12") != string::npos || strConj.find("t16") != string::npos
                    || strConj.find("t17") != string::npos || strConj.find("t34") != string::npos
                    || strConj.find("t36") != string::npos || strConj.find("t4") != string::npos
                    || strConj.find("t40") != string::npos || strConj.find("t48") != string::npos
                    || strConj.find("t50") != string::npos || strConj.find("t52") != string::npos
                    || strConj.find("t56") != string::npos || strConj.find("t59") != string::npos
                    || strConj.find("t61") != string::npos || strConj.find("t62") != string::npos
                    || strConj.find("t65") != string::npos || strConj.find("t66") != string::npos
                    || strConj.find("t67") != string::npos || strConj.find("t77") != string::npos
                    || strConj.find("t79") != string::npos || strConj.find("t85") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t13") != string::npos || strConj.find("t26") != string::npos
                    || strConj.find("t27") != string::npos || strConj.find("t32") != string::npos
                    || strConj.find("t54") != string::npos || strConj.find("t58") != string::npos) {
                StrategyParam::firstRunTime = 17;
                StrategyParam::timeForceLimit = 26; 
                runSys = 2;
            }
            else if (strConj.find("t25") != string::npos) {
                StrategyParam::firstRunTime = 102;
                StrategyParam::timeForceLimit = 18; 
                runSys = 2;
            }
            else if (strConj.find("t31") != string::npos) {
                StrategyParam::firstRunTime = 124;
                StrategyParam::timeForceLimit = 8; 
                runSys = 2;
            }
            else if (strConj.find("t41") != string::npos) {
                StrategyParam::firstRunTime = 27;
                StrategyParam::timeForceLimit = 25; 
                runSys = 2;
            }
            else if (strConj.find("t76") != string::npos) {
                StrategyParam::firstRunTime = 141;
                StrategyParam::timeForceLimit = 8; 
                runSys = 2;
            }
            else if (strConj.find("t8") != string::npos) {
                StrategyParam::firstRunTime = 153;
                StrategyParam::timeForceLimit = 5; 
                runSys = 2;
            }
            else if (strConj.find("t35") != string::npos) {
                StrategyParam::firstRunTime = 138;
                StrategyParam::timeForceLimit = 12; 
                runSys = 2;
            }
        }
        else if (strConj.find("_relset_2,conjecture") != string::npos) {
            if (strConj.find("t33") != string::npos || strConj.find("t40") != string::npos
                    || strConj.find("t41") != string::npos || strConj.find("t43") != string::npos
                    || strConj.find("t5") != string::npos || strConj.find("t53") != string::npos
                    || strConj.find("t55") != string::npos || strConj.find("t57") != string::npos
                    || strConj.find("t64") != string::npos || strConj.find("t65") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t18") != string::npos || strConj.find("t28") != string::npos) {
                StrategyParam::firstRunTime = 17;
                StrategyParam::timeForceLimit = 26; 
                runSys = 2;
            }
            else if (strConj.find("t7") != string::npos) {
                StrategyParam::firstRunTime = 171;
                StrategyParam::timeForceLimit = 3; 
                runSys = 2;
            }
            else if (strConj.find("t36") != string::npos) {
                StrategyParam::firstRunTime = 102;
                StrategyParam::timeForceLimit = 15; 
                runSys = 2;
            }
        }
        else if (strConj.find("_waybel34,conjecture") != string::npos) {
            if (strConj.find("t17") != string::npos || strConj.find("t20") != string::npos
                    || strConj.find("t4") != string::npos || strConj.find("t42") != string::npos
                    || strConj.find("t43") != string::npos
                    || strConj.find("t65") != string::npos || strConj.find("t71") != string::npos
                    || strConj.find("t8") != string::npos || strConj.find("t9") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t12") != string::npos) {
                StrategyParam::firstRunTime = 153;
                StrategyParam::timeForceLimit = 6; 
                runSys = 2;
            }
            else if (strConj.find("t26") != string::npos) {
                StrategyParam::firstRunTime = 50;
                StrategyParam::timeForceLimit = 14; 
                runSys = 2;
            }
            else if (strConj.find("t49") != string::npos) {
                StrategyParam::firstRunTime = 145;
                StrategyParam::timeForceLimit = 6; 
                runSys = 2;
            }
            else if (strConj.find("t57") != string::npos) {
                StrategyParam::firstRunTime = 142;
                StrategyParam::timeForceLimit = 10; 
                runSys = 2;
            }
            else if (strConj.find("t5") != string::npos) {
                StrategyParam::firstRunTime = 161;
                StrategyParam::timeForceLimit = 6; 
                runSys = 2;
            }
            else if (strConj.find("t59") != string::npos) {
                StrategyParam::firstRunTime = 148;
                StrategyParam::timeForceLimit = 9; 
                runSys = 2;
            }
            else if (strConj.find("t19") != string::npos) {
                StrategyParam::firstRunTime = 105;
                StrategyParam::timeForceLimit = 15; 
                runSys = 2;
            }
        }
        else if (strConj.find("_isocat_2,conjecture") != string::npos) {
            if (strConj.find("t40") == string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(t4_yoneda_1,conjecture") != string::npos){
            runSys = 3;
        }
        else if (strConj.find("fof(t8_waybel33,conjecture") != string::npos){
            runSys = 3;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SWB001+0.ax')") != string::npos) {
        if (strConj.find("fof(conclusion_rdfbased_sem_") != string::npos) {
            if (strConj.find("fof(conclusion_rdfbased_sem_bool_") != string::npos && strConj.find("fof(conclusion_rdfbased_sem_bool_tollens,conjecture") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;            
            }
            else if (strConj.find("fof(conclusion_rdfbased_sem_chain_ext,conjecture") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_char_symmetric_ext,conjecture") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_char_transitive_ext,conjecture") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_enum_ext,conjecture") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_eqdis_disjointunion_composite,conjecture") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_inv_ext,conjecture") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_ndis_alldi") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_restrict_allvalues_cmp_") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_restrict_exactqcr_inst_obj_two,conjecture") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_restrict_maxqcr_") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_restrict_minqcr_cmp_") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_restrict_minqcr_inst_obj_one,conjecture") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_restrict_somevalues_cmp_") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_restrict_term_cardqcr,conjecture") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_restrict_term_dataqcr,conjecture") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_restrict_term_minmax") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_restrict_term_sameall,conjecture") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_restrict_term_some") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;            
            }            
        }
        else if (strConj.find("fof(testcase_conclusion_fullish_0") != string::npos) {
            if (strConj.find("fof(testcase_conclusion_fullish_01") != string::npos && strConj.find("fof(testcase_conclusion_fullish_015") == string::npos
                    && strConj.find("fof(testcase_conclusion_fullish_017") == string::npos && strConj.find("fof(testcase_conclusion_fullish_018") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;
            }
            else if (strConj.find("fof(testcase_conclusion_fullish_02") != string::npos && strConj.find("fof(testcase_conclusion_fullish_023") == string::npos
                    && strConj.find("fof(testcase_conclusion_fullish_024") == string::npos && strConj.find("fof(testcase_conclusion_fullish_026") == string::npos
                    && strConj.find("fof(testcase_conclusion_fullish_029") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;
            }
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SWC001+0.ax')") != string::npos) {
        if (strConj.find("fof(co1,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 171;
            StrategyParam::timeForceLimit = 3; 
            runSys = 2; 
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SWV003+0.ax')") != string::npos) {
        if (strConj.find("fof(gauss_init_00") != string::npos) {
            if (strConj.find("fof(gauss_init_0001,conjecture") == string::npos && strConj.find("fof(gauss_init_0005,conjecture") == string::npos 
                    && strConj.find("fof(gauss_init_0033,conjecture") == string::npos && strConj.find("fof(gauss_init_0037,conjecture") == string::npos
                    && strConj.find("fof(gauss_init_0041,conjecture") == string::npos && strConj.find("fof(gauss_init_0045,conjecture") == string::npos
                    && strConj.find("fof(gauss_init_0077,conjecture") == string::npos && strConj.find("fof(gauss_init_0081,conjecture") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;
            }
        }
        else if (strConj.find("fof(quaternion_ds1_symm_") != string::npos) {
            if (strConj.find("fof(quaternion_ds1_symm_0002,conjecture") != string::npos || strConj.find("fof(quaternion_ds1_symm_0004,conjecture") != string::npos
                    || strConj.find("fof(quaternion_ds1_symm_0008,conjecture") != string::npos || strConj.find("fof(quaternion_ds1_symm_0011,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;
            }
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SWV007+0.ax')") != string::npos) {
        if (strConj.find("fof(co3,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 12;
            StrategyParam::timeForceLimit = 28; 
            runSys = 2;            
        }
        else if (strConj.find("fof(l29_co,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;            
        }
        return runSys;
    }
     
    if (strAxiom.find("include('Axioms/SWV011+0.ax')") != string::npos) {
        if (strConj.find("fof(conj,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 138;
            StrategyParam::timeForceLimit = 10; 
            runSys = 2;            
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SWV012+0.ax')") != string::npos) {
        if (strConj.find("fof(exists1_exists2,conjecture") != string::npos
                || strConj.find("fof(or1_or2,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;            
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SYN002+0.ax')") != string::npos) {
        if (strConj.find("fof(ck,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 15;
            StrategyParam::timeForceLimit = 25; 
            runSys = 2;            
        }
        return runSys;
    }
    
    if (strAxiom == "") {
        if (strConj.find("fof(addAssertion,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 31;
            StrategyParam::timeForceLimit = 25; 
            runSys = 2;            
        }
        else if (strConj.find("fof(co1,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 114;
            StrategyParam::timeForceLimit = 15; 
            runSys = 2;            
        }
        else if (strConj.find("fof(conj_") != string::npos) {
            if (strConj.find("fof(conj_0,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 170;
                StrategyParam::timeForceLimit = 4; 
                runSys = 2;            
            }
            else if (strConj.find("fof(conj_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 138;
                StrategyParam::timeForceLimit = 10; 
                runSys = 2;            
            }
            else if (strConj.find("fof(conj_2,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 156;
                StrategyParam::timeForceLimit = 4; 
                runSys = 2;            
            }
            else if (strConj.find("fof(conj_7,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 155;
                StrategyParam::timeForceLimit = 4; 
                runSys = 2;            
            }
        }
        else if (strConj.find("fof(conjecture,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 15;
            StrategyParam::timeForceLimit = 25; 
            runSys = 2;               
        }
        else if (strConj.find("fof('cont(412,0)',conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;               
        }
        else if (strConj.find("fof(goal_to_be_proved,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 100;
            StrategyParam::timeForceLimit = 18; 
            runSys = 2;               
        }
        else if (strConj.find("fof(goals,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 139;
            StrategyParam::timeForceLimit = 7; 
            runSys = 2;               
        }
        else if (strConj.find("fof(goals_09,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 12;
            StrategyParam::timeForceLimit = 28; 
            runSys = 2;               
        }
        else if (strConj == "") {
            StrategyParam::firstRunTime = 110;
            StrategyParam::timeForceLimit = 12; 
            runSys = 2;             
        }
        else if (strConj.find("fof('holds(") != string::npos) {
            if (strConj.find("fof('holds(3") != string::npos && strConj.find("fof('holds(307") == string::npos
                    && strConj.find("fof('holds(324") == string::npos
                    && strConj.find("fof('holds(331") == string::npos && strConj.find("fof('holds(363") == string::npos
                    && strConj.find("fof('holds(364") == string::npos && strConj.find("fof('holds(384") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;     
            }
            else if (strConj.find("fof('holds(4") != string::npos && strConj.find("fof('holds(407") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;
            } 
            else if (strConj.find("fof('holds(conjunct1(") != string::npos) {
                if (strConj.find("fof('holds(conjunct1(338), 1268, 0)',conjecture") != string::npos || strConj.find("fof('holds(conjunct1(375), 1343, 0)',conjecture") != string::npos
                        || strConj.find("fof('holds(conjunct1(conjunct2(338)), 1269, 0)',conjecture") != string::npos
                        || strConj.find("fof('holds(conjunct1(conjunct2(359)), 1319, 0)',conjecture") != string::npos
                        || strConj.find("fof('holds(conjunct1(conjunct2(375)), 1344, 0)',conjecture") != string::npos) {
                    StrategyParam::firstRunTime = 0;
                    StrategyParam::timeForceLimit = 240; 
                    runSys = 3;   
                }
            }
            else if (strConj.find("fof('holds(conjunct2(") != string::npos) {
                if (strConj.find("fof('holds(conjunct2(conjunct2(266)), 1177, 0)',conjecture") == string::npos
                        && strConj.find("fof('holds(conjunct2(362), 1325, 0)',conjecture") == string::npos
                        && strConj.find("fof('holds(conjunct2(conjunct2(359)), 1320, 0)',conjecture") == string::npos) {
                    StrategyParam::firstRunTime = 0;
                    StrategyParam::timeForceLimit = 240; 
                    runSys = 3;   
                }
            }
        }
        else if (strConj.find("_wellord1,conjecture") != string::npos) {
            if (strConj.find("fof(l") != string::npos) {
                if (strConj.find("fof(l2") != string::npos || strConj.find("fof(l3") != string::npos
                        || strConj.find("fof(l4") != string::npos) {
                    StrategyParam::firstRunTime = 13;
                    StrategyParam::timeForceLimit = 27; 
                    runSys = 2;              
                }
            }
            else if (strConj.find("fof(t") != string::npos) {
                if (strConj.find("fof(t17") != string::npos || strConj.find("fof(t23_wellord1,conjecture") != string::npos
                        || strConj.find("fof(t49") != string::npos) {
                    StrategyParam::firstRunTime = 0;
                    StrategyParam::timeForceLimit = 240; 
                    runSys = 3;              
                }
                else if (strConj.find("fof(t19_wellord1,conjecture") != string::npos
                        || strConj.find("fof(t21_wellord1,conjecture") != string::npos || strConj.find("fof(t22_wellord1,conjecture") != string::npos
                        || strConj.find("fof(t24_wellord1,conjecture") != string::npos || strConj.find("fof(t25_wellord1,conjecture") != string::npos
                        || strConj.find("fof(t5_wellord1,conjecture") != string::npos) {
                    StrategyParam::firstRunTime = 25;
                    StrategyParam::timeForceLimit = 25; 
                    runSys = 2;              
                }
            }
        }
        else if (strConj.find("_zfmisc_1,conjecture") != string::npos) {
            if (strConj.find("fof(l55_zfmisc_1,conjecture") != string::npos || strConj.find("fof(t118_zfmisc_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 13;
                StrategyParam::timeForceLimit = 27; 
                runSys = 2;   
            }
            else if (strConj.find("fof(t101_zfmisc_1,conjecture") != string::npos || strConj.find("fof(t105_zfmisc_1,conjecture") != string::npos
                    || strConj.find("fof(t118_zfmisc_1,conjecture") != string::npos || strConj.find("fof(t122_zfmisc_1,conjecture") != string::npos
                    || strConj.find("fof(t123_zfmisc_1,conjecture") != string::npos || strConj.find("fof(t125_zfmisc_1,conjecture") != string::npos
                    || strConj.find("fof(t136_zfmisc_1,conjecture") != string::npos || strConj.find("fof(t36_zfmisc_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;   
            }
        }
        else if (strConj.find("_xboole_1,conjecture") != string::npos) {
            if (strConj.find("fof(t45_xboole_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 12;
                StrategyParam::timeForceLimit = 38; 
                runSys = 2;
            }
        }
        else if (strConj.find("_funct_1,conjecture") != string::npos) {
            if (strConj.find("fof(t118_funct_1,conjecture") != string::npos || strConj.find("fof(t121_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t137_funct_1,conjecture") != string::npos || strConj.find("fof(t138_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t139_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t148_funct_1,conjecture") != string::npos || strConj.find("fof(t15_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t150_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t151_funct_1,conjecture") != string::npos || strConj.find("fof(t154_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t155_funct_1,conjecture") != string::npos || strConj.find("fof(t160_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t20_funct_1,conjecture") != string::npos || strConj.find("fof(t37_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t43_funct_1,conjecture") != string::npos || strConj.find("fof(t48_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t51_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t85_funct_1,conjecture") != string::npos || strConj.find("fof(t9_funct_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;
            }
            else if (strConj.find("fof(t145_funct_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 13;
                StrategyParam::timeForceLimit = 25; 
                runSys = 2;
            }
            else if (strConj.find("fof(t21_funct_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 105;
                StrategyParam::timeForceLimit = 5; 
                runSys = 2;
            }
            else if (strConj.find("fof(t22_funct_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 23;
                StrategyParam::timeForceLimit = 25; 
                runSys = 2;
            }
            else if (strConj.find("fof(t54_funct_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 92;
                StrategyParam::timeForceLimit = 25; 
                runSys = 2;
            }
        }
        else if (strConj.find("fof(n") != string::npos) {
            if (strConj.find("fof(nc5,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;                
            }
        }
        else if (strConj.find("fof(pel") != string::npos) {
            if (strConj.find("fof(pel53,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;                
            }
        }
        else if (strConj.find("fof(prove") != string::npos) {
            if (strConj.find("fof(prove_relset_1_33,conjecture") != string::npos || strConj.find("fof(prove_relset_1_35,conjecture") != string::npos
                    || strConj.find("fof(prove_th99,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;                
            }
        }
        else if (strConj.find("fof('qe(") != string::npos) {
            if (strConj.find("fof('qe(229)',conjecture") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;                
            }
        }
        else if (strConj.find("fof(s1_") != string::npos) {
            if (strConj.find("fof(s1_xboole") == string::npos && strConj.find("fof(s1_ordinal2") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;                
            }
            else if (strConj.find("fof(s1_xboole") != string::npos) {
                if (strConj.find("pre_topc__1,conjecture") != string::npos) {
                    StrategyParam::firstRunTime = 12;
                    StrategyParam::timeForceLimit = 28; 
                    runSys = 2;
                }
                else if (strConj.find("wellord2") != string::npos) {
                    if (strConj.find("fof(s1_xboole_0__e10_24__wellord2__1,conjecture") != string::npos) {
                        runSys = 3;
                    }
                    else {
                        StrategyParam::firstRunTime = 12;
                        StrategyParam::timeForceLimit = 28; 
                        runSys = 2;
                    }
                }
                else if (strConj.find("waybel") != string::npos) {
                    StrategyParam::firstRunTime = 12;
                    StrategyParam::timeForceLimit = 28; 
                    runSys = 2;
                }
                else if (strConj.find("finset") != string::npos) {
                    StrategyParam::firstRunTime = 17;
                    StrategyParam::timeForceLimit = 28; 
                    runSys = 2;
                }
                else if (strConj.find("tops_2__1") != string::npos) {
                    StrategyParam::firstRunTime = 143;
                    StrategyParam::timeForceLimit = 8; 
                    runSys = 2;
                }
                else if (strConj.find("yellow19") != string::npos) {
                    StrategyParam::firstRunTime = 105;
                    StrategyParam::timeForceLimit = 18; 
                    runSys = 2;
                }
            }
        }
        else if (strConj.find("fof(s2_") != string::npos) {
            if (strConj.find("fof(s2_funct_1") != string::npos && strConj.find("tops_2") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;                  
            }
            else if (strConj.find("fof(s2_funct_1") != string::npos && strConj.find("wellord2") == string::npos) {
                StrategyParam::firstRunTime = 12;
                StrategyParam::timeForceLimit = 24; 
                runSys = 2;                  
            }
            else if (strConj.find("fof(s2_xboole_0") != string::npos) {
                StrategyParam::firstRunTime = 12;
                StrategyParam::timeForceLimit = 28; 
                runSys = 2;
            }
        }
        else if (strConj.find("fof(s3_") != string::npos) {
            if (strConj.find("fof(s3_subset_1__e1_40__pre_topc,conjecture") != string::npos || strConj.find("fof(s3_subset_1__e2_37_1_1__pre_topc,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 170;
                StrategyParam::timeForceLimit = 4; 
                runSys = 2;
            }
        }
        else if (strConj.find("_tops_") != string::npos) {
            if (strConj.find("fof(t11") != string::npos || strConj.find("t55") != string::npos) {
                StrategyParam::firstRunTime = 12;
                StrategyParam::timeForceLimit = 28; 
                runSys = 2;
            }
        }
        else if (strConj.find("fof(mv5,conjecture") != string::npos){
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;
        }
        else if (strConj.find("_autgroup,conjecture") != string::npos) {
            if (strConj.find("fof(t16") != string::npos || strConj.find("t26") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_latsum_1,conjecture") != string::npos) {
            if (strConj.find("fof(t19") != string::npos || strConj.find("t24") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_waybel22,conjecture") != string::npos) {
            if (strConj.find("fof(t13") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_yellow_1,conjecture") != string::npos) {
            if (strConj.find("fof(t2") != string::npos) {
                StrategyParam::firstRunTime = 12;
                StrategyParam::timeForceLimit = 24;
                runSys = 2;
            }
        }
        else if (strConj.find("_finsub_1,conjecture") != string::npos) {
            if (strConj.find("fof(t24") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_latsubgr,conjecture") != string::npos) {
            if (strConj.find("fof(t35") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_ordinal1,conjecture") != string::npos) {
            if (strConj.find("fof(t29") != string::npos
                    || strConj.find("fof(t35") != string::npos || strConj.find("fof(t36") != string::npos
                    || strConj.find("fof(t41") != string::npos || strConj.find("fof(t5") != string::npos
                    || strConj.find("fof(t6") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("fof(t32") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 24;
                runSys = 2;
            }
            else if (strConj.find("fof(t23") != string::npos) {
                StrategyParam::firstRunTime = 157;
                StrategyParam::timeForceLimit = 4;
                runSys = 2;
            }
        }
        else if (strConj.find("_lopclset,conjecture") != string::npos) {
            if (strConj.find("fof(t30") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_rmod_5,conjecture") != string::npos) {
            if (strConj.find("fof(t11") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_waybel_") != string::npos) {
            if (strConj.find("fof(t29_waybel_9") != string::npos || strConj.find("fof(t8_waybel_") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 24;
                runSys = 2;
            }
        }
        else if (strConj.find("_yellow19,conjecture") != string::npos) {
            if (strConj.find("fof(t15") != string::npos || strConj.find("fof(t18") != string::npos
                    || strConj.find("fof(t2") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 24;
                runSys = 2;
            }
            else if (strConj.find("fof(t13") != string::npos || strConj.find("fof(t4") != string::npos
                    || strConj.find("fof(t9") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_relat_1,conjecture") != string::npos) {
            if (strConj.find("fof(t115") != string::npos || strConj.find("fof(t143") != string::npos
                    || strConj.find("fof(t145") != string::npos
                    || strConj.find("fof(t174") != string::npos || strConj.find("fof(t178") != string::npos
                    || strConj.find("fof(t21") != string::npos || strConj.find("fof(t25") != string::npos
                    || strConj.find("fof(t44") != string::npos || strConj.find("fof(t45") != string::npos
                    || strConj.find("fof(t86") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 24;
                runSys = 2;
            }
            else if (strConj.find("fof(t117") != string::npos || strConj.find("fof(t71") != string::npos
                    || strConj.find("fof(t88") != string::npos) {
                StrategyParam::firstRunTime = 100;
                StrategyParam::timeForceLimit = 14;
                runSys = 2;
            }
            else if (strConj.find("fof(t119") != string::npos || strConj.find("fof(t140") != string::npos
                    || strConj.find("fof(t160") != string::npos
                    || strConj.find("fof(t46") != string::npos || strConj.find("fof(t47") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("fof(t146") != string::npos || strConj.find("fof(t90") != string::npos
                    || strConj.find("fof(t94") != string::npos) {
                StrategyParam::firstRunTime = 112;
                StrategyParam::timeForceLimit = 10;
                runSys = 2;
            }
            else if (strConj.find("fof(t37") != string::npos) {
                StrategyParam::firstRunTime = 26;
                StrategyParam::timeForceLimit = 25;
                runSys = 2;
            }
        }
        else if (strConj.find("_closure3,conjecture") != string::npos) {
            if (strConj.find("fof(t12") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_filter_2,conjecture") != string::npos) {
            if (strConj.find("fof(t2") != string::npos || strConj.find("fof(t35") != string::npos
                    || strConj.find("fof(t49") != string::npos || strConj.find("fof(t51") != string::npos
                    || strConj.find("fof(t52") != string::npos || strConj.find("fof(t56") != string::npos
                    || strConj.find("fof(t76") != string::npos || strConj.find("fof(t77") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_pre_topc,conjecture") != string::npos) {
            if (strConj.find("fof(t45") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("fof(t48") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 25;
                runSys = 2;
            }
        }
        else if (strConj.find("_relset_1,conjecture") != string::npos) {
            if (strConj.find("fof(t12") != string::npos || strConj.find("fof(t14") != string::npos
                    || strConj.find("fof(t22") != string::npos || strConj.find("fof(t23") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 25;
                runSys = 2;
            }
        }
        else if (strConj.find("_relset_2,conjecture") != string::npos) {
            if (strConj.find("fof(t12") != string::npos || strConj.find("fof(t13") != string::npos
                    || strConj.find("fof(t14") != string::npos || strConj.find("fof(t22") != string::npos
                    || strConj.find("fof(t27") != string::npos || strConj.find("fof(t40") != string::npos
                    || strConj.find("fof(t5") != string::npos || strConj.find("fof(t8") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_waybel34,conjecture") != string::npos) {
            if (strConj.find("fof(t17") != string::npos || strConj.find("fof(t38") != string::npos
                    || strConj.find("fof(t45") != string::npos || strConj.find("fof(t46") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_finset_1,conjecture") != string::npos) {
            if (strConj.find("fof(t17") != string::npos || strConj.find("fof(t22") != string::npos
                    || strConj.find("fof(t23") != string::npos || strConj.find("fof(t31") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_yellow_0,conjecture") != string::npos) {
            if (strConj.find("fof(t15") != string::npos || strConj.find("fof(t16") != string::npos
                    || strConj.find("fof(t60") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 25;
                runSys = 2;
            }
        }
        else if (strConj.find("_yellow_6,conjecture") != string::npos) {
            if (strConj.find("fof(t21") != string::npos || strConj.find("fof(t28") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 25;
                runSys = 2;
            }
        }
        else if (strConj.find("_wellord2,conjecture") != string::npos) {
            if (strConj.find("fof(t3") != string::npos) {
                StrategyParam::firstRunTime = 101;
                StrategyParam::timeForceLimit = 18;
                runSys = 2;
            }
            else if (strConj.find("fof(t4") != string::npos) {
                StrategyParam::firstRunTime = 139;
                StrategyParam::timeForceLimit = 8;
                runSys = 2;
            }
        }
        else if (strConj.find("_orders_2,conjecture") != string::npos) {
            if (strConj.find("fof(t25") != string::npos) {
                StrategyParam::firstRunTime = 12;
                StrategyParam::timeForceLimit = 28;
                runSys = 2;
            }
            else if (strConj.find("fof(t26") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_waybel33,conjecture") != string::npos) {
            if (strConj.find("fof(t27") != string::npos || strConj.find("fof(t7") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_isocat_2,conjecture") != string::npos) {
            if (strConj.find("fof(t42") != string::npos || strConj.find("fof(t43") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(tautology,conjecture") != string::npos) {
            runSys = 3;
        }
        else if (strConj.find("fof(thm_2E") != string::npos) {
            if (strConj.find("fof(thm_2Earith") != string::npos || strConj.find("fof(thm_2Equotient_") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(tlhfof") != string::npos) {
            if (strConj.find("fof(tlhfof34981,") != string::npos || strConj.find("fof(tlhfof40016,") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(main,") != string::npos) {
            StrategyParam::firstRunTime = 139;
            StrategyParam::timeForceLimit = 10;
            runSys = 2;
        }
        return runSys;
    }       
    return runSys;
}

int ReadOriProblem120(const string& problemsFile) {
    int runSys = 1; //1 only run E; 2 E->CSE->E; 3 CSE->E
    string strConj = "";
    string strAxiom = "";
    string problemField = "";
    ifstream fin(problemsFile);
    string str = "";
    bool flag = false;
    while (getline(fin, str)) {
        if (str.find("conjecture") != string::npos) {
            int begPos = str.find_first_of(",");
            int endPos = str.find_last_of(",");
            string temp = str.substr(begPos + 1, endPos - (begPos + 1));
            if (temp == "conjecture") {
                strConj = str;
                break;
            }
        }
        else if (str.find("include(") != string::npos && !flag) {
            strAxiom = str;
            flag = true;
        }
    }

    if (strAxiom.find("include('Axioms/AGT001") != string::npos) {
        if (strConj.find("fof(query_") != string::npos) {
            int begPos = strConj.find_first_of("_");
            begPos += 1;
            int endPos = strConj.find_first_of(",");
            string temp = strConj.substr(begPos, endPos - begPos);
            int index = atoi(temp.c_str());
            if ((index >= 6 && index <= 13) || (index >= 18 && index <= 26))
                runSys = 3;
            else 
                runSys = 1;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/BIO001") != string::npos) {
        if (strConj.find("fof(ask,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 36;
            StrategyParam::timeForceLimit = 14; 
            runSys = 2;
        } 
        return runSys;        
    }
    
    if (strAxiom.find("include('Axioms/COM001+0.ax')") != string::npos) {
        if (strConj.find("fof('T-Weak-FreeVar-") != string::npos) {
            if (strConj.find("-abs-2',") != string::npos)
                runSys = 3;
            else 
                runSys = 1;
        }
        else if (strConj.find("fof('T-subst-") != string::npos) {
            if (strConj.find("-abs-3',") != string::npos)
                runSys = 3;
            else 
                runSys = 1;
        }
        else if (strConj.find("fof('T-Preservation-T-") != string::npos) {
            if (strConj.find("app',") != string::npos)
                runSys = 3;
            else 
                runSys = 1;
        }
        else if (strConj.find("fof('T-Progress-T-") != string::npos) {
            if (strConj.find("app',") != string::npos)
                runSys = 3;
            else 
                runSys = 1;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR001+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR002+1.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR002+2.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR002+3.ax')") != string::npos) {
        if (strConj.find("fof(query") != string::npos) {
            int begPos = strConj.find_first_of("y");
            begPos += 1;
            int endPos = strConj.find_first_of(",");
            string temp = strConj.substr(begPos, endPos - begPos);
            int index = atoi(temp.c_str());
            if (index == 186 || index == 189 || index == 199 || index == 211)
                runSys = 3;
            else 
                runSys = 1;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR002+4.ax')") != string::npos) {
        if (strConj.find("fof(query") != string::npos) {
            int begPos = strConj.find_first_of("y");
            begPos += 1;
            int endPos = strConj.find_first_of(",");
            string temp = strConj.substr(begPos, endPos - begPos);
            int index = atoi(temp.c_str());
            if (index == 226 || index == 229 || index == 236 || index == 239 || index == 240
                    || index == 245 || index == 249 || index == 258 || index == 260 || index == 261
                    || index == 265 || index == 274)
                runSys = 3;
            else 
                runSys = 1;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR002+5.ax')") != string::npos) {
        if (strConj.find("fof(query") != string::npos) {
            int begPos = strConj.find_first_of("y");
            begPos += 1;
            int endPos = strConj.find_first_of(",");
            string temp = strConj.substr(begPos, endPos - begPos);
            int index = atoi(temp.c_str());
            if (index == 277 || index == 283 || index == 288 || index == 290 || index == 294
                    || index == 295 || index == 302 || index == 306 || index == 308 || index == 310
                    || index == 311 || index == 316 || index == 320)
                runSys = 3;
            else 
                runSys = 1;
        }
        else if (strConj == "")
            runSys = 3;
        return runSys;
    }    
    
    if (strAxiom.find("include('Axioms/CSR003+0.ax')") != string::npos) {
        if (strConj.find("fof(prove_from_SUMO,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 82;
            StrategyParam::timeForceLimit = 15; 
            runSys = 2;
        } 
        return runSys;
    }  
    
    if (strAxiom.find("include('Axioms/CSR003+1.ax')") != string::npos) {
        if (strConj.find("fof(prove_from_SUMO_MILO,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 80;
            StrategyParam::timeForceLimit = 20; 
            runSys = 2;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR003+2.ax')") != string::npos) {
        if (strConj.find("fof(abe_mammal,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 16;
            StrategyParam::timeForceLimit = 44; 
            runSys = 2;
        } 
        else if (strConj == "") {
            runSys = 3;
        }
        else if (strConj.find("fof(prove_from_ALL,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 75;
            StrategyParam::timeForceLimit = 15; 
            runSys = 2;
        }        
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR004+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/CSR006+0.ax')") != string::npos) {
        if (strConj.find("fof(antonymPattern") != string::npos) {
            int begPos = strConj.find_first_of("Pattern");
            begPos += 7;
            int endPos = strConj.find_first_of(",");
            string temp = strConj.substr(begPos, endPos - begPos);
            int index = atoi(temp.c_str());
            if (index == 10007 || index == 10048 || (index >= 20012 && index <= 20235) || index == 20343
                    || index == 30068 || index == 30584 || (index >= 31444 && index <= 32292))
                runSys = 3;
        }
        else if (strConj.find("fof(negatedCommonSubclassEvent") != string::npos)
            runSys = 3;
        else if (strConj.find("negatedEqualEvent0006,") != string::npos
                || strConj.find("negatedInstrumentRelation0342,") != string::npos)
            runSys = 3;
        else if (strConj.find("negatedMultipleMapping,") != string::npos) {
            StrategyParam::firstRunTime = 90;
            StrategyParam::timeForceLimit = 10;
            runSys = 2;
        }
        else if (strConj.find("negatedSubclassEvent,") != string::npos && strConj.find("negatedSubclassEvent0127,") == string::npos) {
            runSys = 3;
        }
        else if (strConj.find("negatedResultRelation,") != string::npos) {
            StrategyParam::firstRunTime = 80;
            StrategyParam::timeForceLimit = 13;
            runSys = 2;
        }
        else if (strConj.find("fof(agentRelation") != string::npos) {
            runSys = 3;
        } 
        else if (strConj.find("fof(instrumentRelation") != string::npos) {
            if (strConj.find("0021") != string::npos || strConj.find("0028") != string::npos || strConj.find("0144") != string::npos)
                runSys = 3;
        }
        else if (strConj.find("fof(multipleMapping0010,") != string::npos) {
            runSys = 3;
        } 
        else if (strConj.find("fof(resultRelation") != string::npos) {
            runSys = 3;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO004+0.ax')") != string::npos) {
        if (strConj.find("fof(corollary_2_12,conjecture") != string::npos || strConj.find("fof(theorem_3_6,conjecture") != string::npos
                || strConj.find("fof(theorem_4_6_1,conjecture") != string::npos || strConj.find("fof(theorem_4_6_2,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 50; 
            runSys = 3;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO006+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO007+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO008+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO009+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO010+0.ax')") != string::npos) {
        if (strConj.find("fof(aDISTu_") == string::npos && strConj.find("fof(aLIFTu_D") == string::npos
                && strConj.find("fof(aLIFTu_E") == string::npos && strConj.find("fof(aNORMu_PASTECARTu_0u") == string::npos
                && strConj.find("fof(aNORMu_POSu_LT,") == string::npos && strConj.find("fof(aR") == string::npos
                && strConj.find("fof(aVE") == string::npos)
            runSys = 3;
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GEO011+0.ax')") != string::npos) {
        if (strConj.find("fof(aSatz") != string::npos) {
            if (strConj.find("fof(aSatz4_") != string::npos || strConj.find("fof(aSatz5_9,") != string::npos
                    || strConj.find("fof(aSatz7_22") != string::npos || strConj.find("fof(aSatz9_4") != string::npos
                    || strConj.find("fof(aSatz11_7") != string::npos || strConj.find("fof(aSatz11_49b") != string::npos)
                runSys = 3;
        }
        else if (strConj.find("fof(aExtSameSide") != string::npos || strConj.find("fof(aLemma9_13") != string::npos)
            runSys = 3;
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GRA001+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/GRA007+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/HAL001+0.ax')") != string::npos) {
        if (strConj.find("fof(g_injection,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 12;
            StrategyParam::timeForceLimit = 28; 
            runSys = 2;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/ITP001/ITP001+2.ax')") != string::npos) {
        if (strConj.find("fof(conj_thm_2Earithmetic_2EMOD__2,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 12;
            StrategyParam::timeForceLimit = 28; 
            runSys = 2;
        } 
        else if (strConj.find("fof(conj_thm_2Ebitstring_2Eword__1comp__v2w,conjecture") != string::npos || strConj.find("fof(conj_thm_2Equotient__option_2EOPTION__REL__def,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 14;
            StrategyParam::timeForceLimit = 26; 
            runSys = 2;
        } 
        else if (strConj.find("fof(conj_thm_2Eextreal_2Emax__le,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 15;
            StrategyParam::timeForceLimit = 26; 
            runSys = 2;
        } 
        else if (strConj.find("fof(conj_thm_2Elebesgue_2Epos__fn__integral__cmul,conjecture") != string::npos || strConj.find("fof(conj_thm_2Ereal__topology_2ECLOSED__UNION__COMPACT__SUBSETS,conjecture") != string::npos
                || strConj.find("fof(conj_thm_2Ereal__topology_2EINDEPENDENT__STDBASIS,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 50; 
            runSys = 3;
        } 
        else if (strConj.find("fof(conj_thm_2Eoption_2EOPTION__MAP2__THM,conjecture") != string::npos || strConj.find("fof(conj_thm_2EpatternMatches_2EPMATCH__FLATTEN__FUN__PMATCH__ROW,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 12;
            StrategyParam::timeForceLimit = 28; 
            runSys = 2;
        } 
        else if (strConj.find("fof(conj_thm_2Ereal__topology_2EBOUNDED__BALL,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 108;
            StrategyParam::timeForceLimit = 4; 
            runSys = 2;
        }
        else if (strConj.find("fof(conj_thm_2Ereal_2ESUP__EPSILON,conjecture") != string::npos || strConj.find("fof(conj_thm_2Eseq_2EBOLZANO__LEMMA,conjecture") != string::npos
                || strConj.find("fof(conj_thm_2Ewords_2En2w__sub,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 18;
            StrategyParam::timeForceLimit = 22; 
            runSys = 2;
        }
        else if (strConj.find("fof(conj_thm_2Eutil__prob_2ENUM__2D__BIJ__INV,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 111;
            StrategyParam::timeForceLimit = 3; 
            runSys = 2;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/ITP001/ITP002+4.ax')") != string::npos) {
        if (strConj.find("fof(thm_2Ebool_2ETRUTH,conjecture") == string::npos && strConj.find("fof(thm_2Ecardinal_2ECARD__NOT__LE,conjecture") == string::npos
                && strConj.find("fof(thm_2Epred__set_2EREST__SUBSET,conjecture") == string::npos && strConj.find("fof(thm_2EquantHeuristics_2EGUESS__RULES__WEAKEN__FORALL__POINT,conjecture") == string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 50; 
            runSys = 3;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/KLE001+0.ax')") != string::npos) {
        if (strConj.find("fof(goals,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 102;
            StrategyParam::timeForceLimit = 4; 
            runSys = 2;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/KLE002+0.ax')") != string::npos) {
        if (strConj.find("fof(goals,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 108;
            StrategyParam::timeForceLimit = 4; 
            runSys = 2;
        } 
        else if (strConj.find("fof(a,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 80;
            StrategyParam::timeForceLimit = 15;
            runSys = 2;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/KLE004+0.ax')") != string::npos) {
        if (strConj.find("fof(goals,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 110;
            StrategyParam::timeForceLimit = 3; 
            runSys = 2;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/KRS001+0.ax')") != string::npos) {
        if (strConj.find("fof(mighta_wth_thm,conjecture") != string::npos || strConj.find("fof(mighta_eth_thm,conjecture") != string::npos
                || strConj.find("fof(xora_csa_thm,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 240;
            StrategyParam::timeForceLimit = 0; 
            runSys = 3;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/KRS001+1.ax')") != string::npos)
        return runSys;
    
    if (strAxiom.find("include('Axioms/LCL006+0.ax')") != string::npos) {
        if (strConj.find("fof(hilbert_and_2,conjecture,and_2") != string::npos) {
            StrategyParam::firstRunTime = 20;
            StrategyParam::timeForceLimit = 25; 
            runSys = 2;
        }
        else if (strConj.find("fof(hilbert_and_3,conjecture,and_3") != string::npos) {
            StrategyParam::firstRunTime = 70;
            StrategyParam::timeForceLimit = 15; 
            runSys = 2;
        }
        else if (strConj.find("fof(hilbert_equivalence_1,conjecture,equivalence_1") != string::npos) {
            StrategyParam::firstRunTime = 20;
            StrategyParam::timeForceLimit = 20; 
            runSys = 2;
        } 
        else if (strConj.find("fof(hilbert_equivalence_2,conjecture,equivalence_2") != string::npos) {
            StrategyParam::firstRunTime = 20;
            StrategyParam::timeForceLimit = 20; 
            runSys = 2;
        } 
        else if (strConj.find("fof(hilbert_equivalence_3,conjecture,equivalence_3") != string::npos || strConj.find("fof(principia_r4,conjecture,r4") != string::npos) {
            StrategyParam::firstRunTime = 71;
            StrategyParam::timeForceLimit = 15; 
            runSys = 2;
        } 
        else if (strConj.find("fof(hilbert_modus_tollens,conjecture,modus_tollens") != string::npos || strConj.find("fof(principia_r5,conjecture,r5") != string::npos) {
            StrategyParam::firstRunTime = 17;
            StrategyParam::timeForceLimit = 25; 
            runSys = 2;
        }
        else if (strConj.find("fof(rosser_kn3,conjecture,kn3") != string::npos) {
            StrategyParam::firstRunTime = 104;
            StrategyParam::timeForceLimit = 4; 
            runSys = 2;
        }
        else if (strConj.find("fof(hilbert_or_3,conjecture,or_3") != string::npos || strConj.find("fof(s1_0_axiom_m5,conjecture,axiom_m5") != string::npos
                || strConj.find("fof(s1_0_m6s3m9b_axiom_s3,conjecture,axiom_s3") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 50; 
            runSys = 3;
        }
        else if (strConj.find("fof(principia_r3,conjecture,r3") != string::npos) {
            StrategyParam::firstRunTime = 30;
            StrategyParam::timeForceLimit = 15; 
            runSys = 2;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/LCL006+1.ax')") != string::npos) {
        if (strConj.find("fof(km5_axiom_K,conjecture,axiom_K") != string::npos) {
            StrategyParam::firstRunTime = 100;
            StrategyParam::timeForceLimit = 9; 
            runSys = 2;
        }
    }
    
    if (strAxiom.find("include('Axioms/MED001+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/MGT001+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/NLP001+0.ax')") != string::npos) {
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/NUM005+0.ax')") != string::npos) {
        if (strConj.find("fof(associative_sum,conjecture") != string::npos || strConj.find("fof(communative_sum_n6_n7,conjecture") != string::npos
                || strConj.find("fof(show_lower_boundary,conjecture") != string::npos || strConj.find("fof(show_upper_boundary,conjecture") != string::npos
                || strConj.find("fof(sum_and_difference,conjecture") != string::npos
                || strConj.find("fof(sum_n23_n34_n57,conjecture") != string::npos || strConj.find("fof(sum_n23_something_n34,conjecture") != string::npos
                || strConj.find("fof(sum_something_n23_n34,conjecture") != string::npos || strConj.find("fof(summ_n23_n34_something,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/NUM008+0.ax')") != string::npos) {
        if (strConj.find("fof(primeexist,conjecture") != string::npos || strConj.find("fof(evengreq4,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/NUM009+0.ax')") != string::npos) {
        if (strConj.find("fof(oneplustwoidthree,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/PHI002+0.ax')") != string::npos)
        return runSys;
    
    if (strAxiom.find("include('Axioms/PRD001+0.ax')") != string::npos)
        return runSys;
    
    
    if (strAxiom.find("include('Axioms/REL001+0.ax')") != string::npos) {
        if (strConj.find("fof(goals,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 105;
            StrategyParam::timeForceLimit = 4; 
            runSys = 2;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SET005+0.ax')") != string::npos) {
        if (strConj.find("fof(corollary_2_to_number_of_elements_in_class,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;
        } 
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SET006+0.ax')") != string::npos) {
        if (strConj.find("fof(set_partitions_itself,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;
        }
        else if (strConj.find("fof(thV") != string::npos) {
            if (strConj.find("1,conjecture") != string::npos || strConj.find("15,conjecture") != string::npos
                    || strConj.find("16,conjecture") != string::npos || strConj.find("21,conjecture") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(thIV") != string::npos) {
            if (strConj.find("17,conjecture") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(thIII") != string::npos) {
            if (strConj.find("02,conjecture") == string::npos && strConj.find("03,conjecture") == string::npos
                    && strConj.find("12,conjecture") == string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(thII") != string::npos) {
            if (strConj.find("03a,conjecture") == string::npos && strConj.find("05,conjecture") == string::npos
                    && strConj.find("06,conjecture") == string::npos && strConj.find("08,conjecture") == string::npos
                    && strConj.find("12,conjecture") == string::npos
                    && strConj.find("13,conjecture") == string::npos && strConj.find("22,conjecture") == string::npos
                    && strConj.find("24,conjecture") == string::npos && strConj.find("25,conjecture") == string::npos
                    && strConj.find("a01,conjecture") == string::npos && strConj.find("a03,conjecture") == string::npos
                    && strConj.find("a04,conjecture") == string::npos && strConj.find("a05,conjecture") == string::npos
                    && strConj.find("a08,conjecture") == string::npos && strConj.find("a12,conjecture") == string::npos
                    && strConj.find("a13,conjecture") == string::npos && strConj.find("a14,conjecture") == string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(thI") != string::npos) {
            if (strConj.find("09,conjecture") != string::npos
                    || strConj.find("10,conjecture") != string::npos || strConj.find("21,conjecture") != string::npos
                    || strConj.find("25,conjecture") != string::npos || strConj.find("26,conjecture") != string::npos
                    || strConj.find("32,conjecture") != string::npos || strConj.find("36,conjecture") != string::npos
                    || strConj.find("37,conjecture") != string::npos || strConj.find("40,conjecture") != string::npos
                    || strConj.find("49,conjecture") != string::npos) {
                runSys = 3;
            }
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SET006+3.ax')") != string::npos)
        return runSys;
    
    if (strAxiom.find("include('Axioms/SET007/SET007+0.ax')") != string::npos) {
        if (strConj.find("_autgroup,conjecture") != string::npos) {
            if (strConj.find("t12") != string::npos || strConj.find("t14") != string::npos
                    || strConj.find("t15") != string::npos || strConj.find("t3") != string::npos
                    || strConj.find("t30") != string::npos || strConj.find("t7") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_latsum_1,conjecture") != string::npos) {
            if (strConj.find("t19") != string::npos || strConj.find("t23") != string::npos
                    || strConj.find("t7") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t11") != string::npos) {
                StrategyParam::firstRunTime = 22;
                StrategyParam::timeForceLimit = 20; 
                runSys = 2;
            }
            else if (strConj.find("t20") != string::npos) {
                StrategyParam::firstRunTime = 100;
                StrategyParam::timeForceLimit = 6; 
                runSys = 2;
            }
        }
        else if (strConj.find("_tsp_2,conjecture") != string::npos) {
            if (strConj.find("t1") != string::npos || strConj.find("t24") != string::npos
                    || strConj.find("t13") != string::npos
                    || strConj.find("t30") != string::npos || strConj.find("t31") != string::npos
                    || strConj.find("t34") != string::npos || strConj.find("t35") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_waybel22,conjecture") != string::npos) {
            if (strConj.find("t1") != string::npos || strConj.find("t18") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t6") != string::npos) {
                StrategyParam::firstRunTime = 104;
                StrategyParam::timeForceLimit = 6; 
                runSys = 2;
            }
        }
        else if (strConj.find("_latsubgr,conjecture") != string::npos) {
            if (strConj.find("t10") != string::npos || strConj.find("t13") != string::npos
                    || strConj.find("t33") != string::npos || strConj.find("t35") != string::npos
                    || strConj.find("t38") != string::npos || strConj.find("t24") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t12") != string::npos) {
                StrategyParam::firstRunTime = 12;
                StrategyParam::timeForceLimit = 28; 
                runSys = 2;
            }
            else if (strConj.find("t31") != string::npos) {
                StrategyParam::firstRunTime = 70;
                StrategyParam::timeForceLimit = 12; 
                runSys = 2;
            }
        }
        else if (strConj.find("_lopclset,conjecture") != string::npos) {
            if (strConj.find("t10") != string::npos || strConj.find("t44") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t27") != string::npos) {
                StrategyParam::firstRunTime = 10;
                StrategyParam::timeForceLimit = 20; 
                runSys = 2;
            }
            else if (strConj.find("t19") != string::npos) {
                StrategyParam::firstRunTime = 110;
                StrategyParam::timeForceLimit = 4; 
                runSys = 2;
            }
            else if (strConj.find("t37") != string::npos) {
                StrategyParam::firstRunTime = 97;
                StrategyParam::timeForceLimit = 8; 
                runSys = 2;
            }
        }
        else if (strConj.find("_conlat_2,conjecture") != string::npos) {
            if (strConj.find("t20") == string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_rmod_5,conjecture") != string::npos) {
            if (strConj.find("t11") != string::npos || strConj.find("t12") != string::npos
                    || strConj.find("t4") != string::npos || strConj.find("t6") != string::npos
                    || strConj.find("t18") != string::npos || strConj.find("t2") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t14") != string::npos) {
                StrategyParam::firstRunTime = 16;
                StrategyParam::timeForceLimit = 29; 
                runSys = 2;
            }
            else if (strConj.find("t16") != string::npos) {
                StrategyParam::firstRunTime = 73;
                StrategyParam::timeForceLimit = 17; 
                runSys = 2;
            }
        }
        else if (strConj.find("_closure3,conjecture") != string::npos) {
            if (strConj.find("t4") != string::npos || strConj.find("t5") != string::npos
                    || strConj.find("t6") != string::npos || strConj.find("t8") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t12") != string::npos) {
                StrategyParam::firstRunTime = 25;
                StrategyParam::timeForceLimit = 16; 
                runSys = 2;
            }
            else if (strConj.find("t7") != string::npos) {
                StrategyParam::firstRunTime = 40;
                StrategyParam::timeForceLimit = 13; 
                runSys = 2;
            }
        }
        else if (strConj.find("_filter_2,conjecture") != string::npos) {
            if (strConj.find("t12") != string::npos || strConj.find("t16") != string::npos
                    || strConj.find("t17") != string::npos || strConj.find("t34") != string::npos
                    || strConj.find("t35") != string::npos
                    || strConj.find("t36") != string::npos || strConj.find("t4") != string::npos
                    || strConj.find("t40") != string::npos || strConj.find("t48") != string::npos
                    || strConj.find("t50") != string::npos || strConj.find("t52") != string::npos
                    || strConj.find("t56") != string::npos || strConj.find("t59") != string::npos
                    || strConj.find("t61") != string::npos || strConj.find("t62") != string::npos
                    || strConj.find("t65") != string::npos || strConj.find("t66") != string::npos
                    || strConj.find("t67") != string::npos || strConj.find("t77") != string::npos
                    || strConj.find("t79") != string::npos || strConj.find("t85") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t13") != string::npos || strConj.find("t26") != string::npos
                    || strConj.find("t27") != string::npos || strConj.find("t32") != string::npos
                    || strConj.find("t54") != string::npos || strConj.find("t58") != string::npos) {
                StrategyParam::firstRunTime = 17;
                StrategyParam::timeForceLimit = 26; 
                runSys = 2;
            }
            else if (strConj.find("t25") != string::npos || strConj.find("t43") != string::npos) {
                StrategyParam::firstRunTime = 72;
                StrategyParam::timeForceLimit = 18; 
                runSys = 2;
            }
            else if (strConj.find("t31") != string::npos) {
                StrategyParam::firstRunTime = 94;
                StrategyParam::timeForceLimit = 8; 
                runSys = 2;
            }
            else if (strConj.find("t39") != string::npos) {
                StrategyParam::firstRunTime = 108;
                StrategyParam::timeForceLimit = 4; 
                runSys = 2;
            }
            else if (strConj.find("t41") != string::npos) {
                StrategyParam::firstRunTime = 27;
                StrategyParam::timeForceLimit = 25; 
                runSys = 2;
            }
            else if (strConj.find("t76") != string::npos) {
                StrategyParam::firstRunTime = 98;
                StrategyParam::timeForceLimit = 8; 
                runSys = 2;
            }
            else if (strConj.find("t8") != string::npos) {
                StrategyParam::firstRunTime = 105;
                StrategyParam::timeForceLimit = 5; 
                runSys = 2;
            }
        }
        else if (strConj.find("_relset_2,conjecture") != string::npos) {
            if (strConj.find("t33") != string::npos || strConj.find("t40") != string::npos
                    || strConj.find("t41") != string::npos || strConj.find("t43") != string::npos
                    || strConj.find("t5") != string::npos || strConj.find("t53") != string::npos
                    || strConj.find("t55") != string::npos || strConj.find("t57") != string::npos
                    || strConj.find("t63") != string::npos
                    || strConj.find("t64") != string::npos || strConj.find("t65") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t18") != string::npos || strConj.find("t28") != string::npos) {
                StrategyParam::firstRunTime = 17;
                StrategyParam::timeForceLimit = 26; 
                runSys = 2;
            }
            else if (strConj.find("t7") != string::npos) {
                StrategyParam::firstRunTime = 171;
                StrategyParam::timeForceLimit = 3; 
                runSys = 2;
            }
            else if (strConj.find("t36") != string::npos) {
                StrategyParam::firstRunTime = 18;
                StrategyParam::timeForceLimit = 27; 
                runSys = 2;
            }
            else if (strConj.find("t58") != string::npos) {
                StrategyParam::firstRunTime = 75;
                StrategyParam::timeForceLimit = 15; 
                runSys = 2;
            }
        }
        else if (strConj.find("_waybel34,conjecture") != string::npos) {
            if (strConj.find("t17") != string::npos || strConj.find("t20") != string::npos
                    || strConj.find("t4") != string::npos || strConj.find("t42") != string::npos
                    || strConj.find("t43") != string::npos || strConj.find("t5") != string::npos
                    || strConj.find("t65") != string::npos || strConj.find("t71") != string::npos
                    || strConj.find("t8") != string::npos || strConj.find("t9") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("t12") != string::npos) {
                StrategyParam::firstRunTime = 104;
                StrategyParam::timeForceLimit = 6; 
                runSys = 2;
            }
            else if (strConj.find("t26") != string::npos) {
                StrategyParam::firstRunTime = 40;
                StrategyParam::timeForceLimit = 14; 
                runSys = 2;
            }
            else if (strConj.find("t49") != string::npos || strConj.find("t59") != string::npos) {
                StrategyParam::firstRunTime = 102;
                StrategyParam::timeForceLimit = 6; 
                runSys = 2;
            }
            else if (strConj.find("t57") != string::npos) {
                StrategyParam::firstRunTime = 109;
                StrategyParam::timeForceLimit = 4; 
                runSys = 2;
            }
        }
        else if (strConj.find("_isocat_2,conjecture") != string::npos) {
            if (strConj.find("t40") == string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(t4_yoneda_1,conjecture") != string::npos){
            runSys = 3;
        }
        else if (strConj.find("fof(t8_waybel33,conjecture") != string::npos){
            runSys = 3;
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SWB001+0.ax')") != string::npos) {
        if (strConj.find("fof(conclusion_rdfbased_sem_") != string::npos) {
            if (strConj.find("fof(conclusion_rdfbased_sem_bool_") != string::npos && strConj.find("fof(conclusion_rdfbased_sem_bool_tollens,conjecture") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;            
            }
            else if (strConj.find("fof(conclusion_rdfbased_sem_chain_ext,conjecture") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_char_symmetric_ext,conjecture") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_char_transitive_ext,conjecture") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_enum_ext,conjecture") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_eqdis_disjointunion_composite,conjecture") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_inv_ext,conjecture") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_ndis_alldi") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_restrict_allvalues_cmp_") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_restrict_exactqcr_inst_obj_two,conjecture") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_restrict_maxqcr_") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_restrict_minqcr_cmp_") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_restrict_minqcr_inst_obj_one,conjecture") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_restrict_somevalues_cmp_") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_restrict_term_cardqcr,conjecture") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_restrict_term_dataqcr,conjecture") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_restrict_term_minmax") != string::npos || strConj.find("fof(conclusion_rdfbased_sem_restrict_term_sameall,conjecture") != string::npos
                    || strConj.find("fof(conclusion_rdfbased_sem_restrict_term_some") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;            
            }            
        }
        else if (strConj.find("fof(testcase_conclusion_fullish_0") != string::npos) {
            if (strConj.find("fof(testcase_conclusion_fullish_01") != string::npos && strConj.find("fof(testcase_conclusion_fullish_015") == string::npos
                    && strConj.find("fof(testcase_conclusion_fullish_017") == string::npos && strConj.find("fof(testcase_conclusion_fullish_018") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;
            }
            else if (strConj.find("fof(testcase_conclusion_fullish_02") != string::npos && strConj.find("fof(testcase_conclusion_fullish_023") == string::npos
                    && strConj.find("fof(testcase_conclusion_fullish_024") == string::npos && strConj.find("fof(testcase_conclusion_fullish_026") == string::npos
                    && strConj.find("fof(testcase_conclusion_fullish_029") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;
            }
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SWC001+0.ax')") != string::npos) {
        if (strConj.find("fof(co1,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 112;
            StrategyParam::timeForceLimit = 3; 
            runSys = 2; 
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SWV003+0.ax')") != string::npos) {
        if (strConj.find("fof(gauss_init_00") != string::npos) {
            if (strConj.find("fof(gauss_init_0001,conjecture") == string::npos && strConj.find("fof(gauss_init_0005,conjecture") == string::npos 
                    && strConj.find("fof(gauss_init_0033,conjecture") == string::npos && strConj.find("fof(gauss_init_0037,conjecture") == string::npos
                    && strConj.find("fof(gauss_init_0041,conjecture") == string::npos && strConj.find("fof(gauss_init_0045,conjecture") == string::npos
                    && strConj.find("fof(gauss_init_0077,conjecture") == string::npos && strConj.find("fof(gauss_init_0081,conjecture") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;
            }
        }
        else if (strConj.find("fof(quaternion_ds1_symm_") != string::npos) {
            if (strConj.find("fof(quaternion_ds1_symm_0002,conjecture") != string::npos || strConj.find("fof(quaternion_ds1_symm_0004,conjecture") != string::npos
                    || strConj.find("fof(quaternion_ds1_symm_0008,conjecture") != string::npos || strConj.find("fof(quaternion_ds1_symm_0011,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;
            }
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SWV007+0.ax')") != string::npos) {
        if (strConj.find("fof(co3,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 12;
            StrategyParam::timeForceLimit = 28; 
            runSys = 2;            
        }
        else if (strConj.find("fof(l29_co,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;            
        }
        return runSys;
    }
     
    if (strAxiom.find("include('Axioms/SWV011+0.ax')") != string::npos) {
        if (strConj.find("fof(conj,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 96;
            StrategyParam::timeForceLimit = 5; 
            runSys = 2;            
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SWV012+0.ax')") != string::npos) {
        if (strConj.find("fof(exists1_exists2,conjecture") != string::npos
                || strConj.find("fof(or1_or2,conjecture") != string::npos || strConj.find("fof(and1_and2,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;            
        }
        return runSys;
    }
    
    if (strAxiom.find("include('Axioms/SYN002+0.ax')") != string::npos) {
        if (strConj.find("fof(ck,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 15;
            StrategyParam::timeForceLimit = 25; 
            runSys = 2;            
        }
        return runSys;
    }
    
    if (strAxiom == "") {
        if (strConj.find("fof(addAssertion,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 31;
            StrategyParam::timeForceLimit = 25; 
            runSys = 2;            
        }
        else if (strConj.find("fof(co1,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 83;
            StrategyParam::timeForceLimit = 15; 
            runSys = 2;            
        }
        else if (strConj.find("fof(conj_") != string::npos) {
            if (strConj.find("fof(conj_0,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 110;
                StrategyParam::timeForceLimit = 4; 
                runSys = 2;            
            }
            else if (strConj.find("fof(conj_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 108;
                StrategyParam::timeForceLimit = 4; 
                runSys = 2;            
            }
            else if (strConj.find("fof(conj_2,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 96;
                StrategyParam::timeForceLimit = 4; 
                runSys = 2;            
            }
            else if (strConj.find("fof(conj_3,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 30;
                StrategyParam::timeForceLimit = 25; 
                runSys = 2;            
            }
            else if (strConj.find("fof(conj_7,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 107;
                StrategyParam::timeForceLimit = 4; 
                runSys = 2;            
            }
        }
        else if (strConj.find("fof(conjecture,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 15;
            StrategyParam::timeForceLimit = 25; 
            runSys = 2;               
        }
        else if (strConj.find("fof('cont(412,0)',conjecture") != string::npos) {
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;               
        }
        else if (strConj.find("fof(goal_to_be_proved,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 69;
            StrategyParam::timeForceLimit = 18; 
            runSys = 2;               
        }
        else if (strConj.find("fof(goals,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 96;
            StrategyParam::timeForceLimit = 7; 
            runSys = 2;               
        }
        else if (strConj.find("fof(goals_09,conjecture") != string::npos || strConj.find("fof(goals_14,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 10;
            StrategyParam::timeForceLimit = 30; 
            runSys = 2;               
        }
        else if (strConj == "") {
            StrategyParam::firstRunTime = 80;
            StrategyParam::timeForceLimit = 12; 
            runSys = 2;             
        }
        else if (strConj.find("fof('holds(") != string::npos) {
            if (strConj.find("fof('holds(3") != string::npos && strConj.find("fof('holds(307") == string::npos
                    && strConj.find("fof('holds(324") == string::npos
                    && strConj.find("fof('holds(331") == string::npos
                    && strConj.find("fof('holds(364") == string::npos && strConj.find("fof('holds(384") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;     
            }
            else if (strConj.find("fof('holds(4") != string::npos && strConj.find("fof('holds(407") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;
            } 
            else if (strConj.find("fof('holds(conjunct1(") != string::npos) {
                if (strConj.find("fof('holds(conjunct1(338), 1268, 0)',conjecture") != string::npos || strConj.find("fof('holds(conjunct1(375), 1343, 0)',conjecture") != string::npos
                        || strConj.find("fof('holds(conjunct1(359), 1318, 0)',conjecture") != string::npos
                        || strConj.find("fof('holds(conjunct1(conjunct2(338)), 1269, 0)',conjecture") != string::npos
                        || strConj.find("fof('holds(conjunct1(conjunct2(359)), 1319, 0)',conjecture") != string::npos
                        || strConj.find("fof('holds(conjunct1(conjunct2(375)), 1344, 0)',conjecture") != string::npos) {
                    StrategyParam::firstRunTime = 0;
                    StrategyParam::timeForceLimit = 240; 
                    runSys = 3;   
                }
            }
            else if (strConj.find("fof('holds(conjunct2(") != string::npos) {
                if (strConj.find("fof('holds(conjunct2(conjunct2(266)), 1177, 0)',conjecture") == string::npos) {
                    StrategyParam::firstRunTime = 0;
                    StrategyParam::timeForceLimit = 240; 
                    runSys = 3;   
                }
            }
        }
        else if (strConj.find("_wellord1,conjecture") != string::npos) {
            if (strConj.find("fof(l") != string::npos) {
                if (strConj.find("fof(l2") != string::npos || strConj.find("fof(l3") != string::npos
                        || strConj.find("fof(l4") != string::npos) {
                    StrategyParam::firstRunTime = 13;
                    StrategyParam::timeForceLimit = 27; 
                    runSys = 2;              
                }
            }
            else if (strConj.find("fof(t") != string::npos) {
                if (strConj.find("fof(t17") != string::npos || strConj.find("fof(t23_wellord1,conjecture") != string::npos
                        || strConj.find("fof(t49") != string::npos) {
                    StrategyParam::firstRunTime = 0;
                    StrategyParam::timeForceLimit = 240; 
                    runSys = 3;              
                }
                else if (strConj.find("fof(t19_wellord1,conjecture") != string::npos
                        || strConj.find("fof(t21_wellord1,conjecture") != string::npos || strConj.find("fof(t22_wellord1,conjecture") != string::npos
                        || strConj.find("fof(t24_wellord1,conjecture") != string::npos || strConj.find("fof(t25_wellord1,conjecture") != string::npos
                        || strConj.find("fof(t5_wellord1,conjecture") != string::npos) {
                    StrategyParam::firstRunTime = 25;
                    StrategyParam::timeForceLimit = 25; 
                    runSys = 2;              
                }
            }
        }
        else if (strConj.find("fof(main,conjecture") != string::npos) {
            StrategyParam::firstRunTime = 110;
            StrategyParam::timeForceLimit = 4; 
            runSys = 2; 
        }
        else if (strConj.find("_zfmisc_1,conjecture") != string::npos) {
            if (strConj.find("fof(l55_zfmisc_1,conjecture") != string::npos || strConj.find("fof(t118_zfmisc_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 13;
                StrategyParam::timeForceLimit = 27; 
                runSys = 2;   
            }
            else if (strConj.find("fof(t101_zfmisc_1,conjecture") != string::npos || strConj.find("fof(t105_zfmisc_1,conjecture") != string::npos
                    || strConj.find("fof(t118_zfmisc_1,conjecture") != string::npos || strConj.find("fof(t122_zfmisc_1,conjecture") != string::npos
                    || strConj.find("fof(t126_zfmisc_1,conjecture") != string::npos
                    || strConj.find("fof(t123_zfmisc_1,conjecture") != string::npos || strConj.find("fof(t125_zfmisc_1,conjecture") != string::npos
                    || strConj.find("fof(t136_zfmisc_1,conjecture") != string::npos || strConj.find("fof(t36_zfmisc_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;   
            }
        }
        else if (strConj.find("_xboole_1,conjecture") != string::npos) {
            if (strConj.find("fof(t45_xboole_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 12;
                StrategyParam::timeForceLimit = 38; 
                runSys = 2;
            }
            else if (strConj.find("fof(t40_xboole_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 64;
                StrategyParam::timeForceLimit = 18; 
                runSys = 2;
            }
        }
        else if (strConj.find("_funct_1,conjecture") != string::npos) {
            if (strConj.find("fof(t118_funct_1,conjecture") != string::npos || strConj.find("fof(t121_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t137_funct_1,conjecture") != string::npos || strConj.find("fof(t138_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t139_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t148_funct_1,conjecture") != string::npos || strConj.find("fof(t15_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t150_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t151_funct_1,conjecture") != string::npos || strConj.find("fof(t154_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t155_funct_1,conjecture") != string::npos || strConj.find("fof(t160_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t20_funct_1,conjecture") != string::npos || strConj.find("fof(t37_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t43_funct_1,conjecture") != string::npos || strConj.find("fof(t48_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t51_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t54_funct_1,conjecture") != string::npos || strConj.find("fof(t61_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t84_funct_1,conjecture") != string::npos
                    || strConj.find("fof(t85_funct_1,conjecture") != string::npos || strConj.find("fof(t9_funct_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;
            }
            else if (strConj.find("fof(t145_funct_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 13;
                StrategyParam::timeForceLimit = 25; 
                runSys = 2;
            }
            else if (strConj.find("fof(t21_funct_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 105;
                StrategyParam::timeForceLimit = 5; 
                runSys = 2;
            }
            else if (strConj.find("fof(t22_funct_1,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 23;
                StrategyParam::timeForceLimit = 25; 
                runSys = 2;
            }
        }
        else if (strConj.find("fof(n") != string::npos) {
            if (strConj.find("fof(nc5,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;                
            }
        }
        else if (strConj.find("fof(pel") != string::npos) {
            if (strConj.find("fof(pel53,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;                
            }
        }
        else if (strConj.find("fof(prove") != string::npos) {
            if (strConj.find("fof(prove_relset_1_33,conjecture") != string::npos || strConj.find("fof(prove_relset_1_35,conjecture") != string::npos
                    || strConj.find("fof(prove_th99,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;                
            }
        }
        else if (strConj.find("fof('qe(") != string::npos) {
            if (strConj.find("fof('qe(229)',conjecture") != string::npos || strConj.find("fof('qe(352)',conjecture") != string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;                
            }
        }
        else if (strConj.find("fof(s1_") != string::npos) {
            if (strConj.find("fof(s1_xboole") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;                
            }
            else if (strConj.find("fof(s1_xboole") != string::npos) {
                if (strConj.find("pre_topc__1,conjecture") != string::npos) {
                    StrategyParam::firstRunTime = 12;
                    StrategyParam::timeForceLimit = 28; 
                    runSys = 2;
                }
                else if (strConj.find("wellord2") != string::npos) {
                    if (strConj.find("fof(s1_xboole_0__e10_24__wellord2__1,conjecture") != string::npos) {
                        runSys = 3;
                    }
                    else {
                        StrategyParam::firstRunTime = 12;
                        StrategyParam::timeForceLimit = 28; 
                        runSys = 2;
                    }
                }
                else if (strConj.find("waybel") != string::npos) {
                    StrategyParam::firstRunTime = 12;
                    StrategyParam::timeForceLimit = 28; 
                    runSys = 2;
                }
                else if (strConj.find("finset") != string::npos) {
                    StrategyParam::firstRunTime = 17;
                    StrategyParam::timeForceLimit = 28; 
                    runSys = 2;
                }
                else if (strConj.find("tops_2__1") != string::npos) {
                    StrategyParam::firstRunTime = 100;
                    StrategyParam::timeForceLimit = 8; 
                    runSys = 2;
                }
                else if (strConj.find("yellow19") != string::npos) {
                    StrategyParam::firstRunTime = 76;
                    StrategyParam::timeForceLimit = 18; 
                    runSys = 2;
                }
            }
        }
        else if (strConj.find("fof(s2_") != string::npos) {
            if (strConj.find("fof(s2_funct_1") != string::npos && strConj.find("tops_2") == string::npos) {
                StrategyParam::firstRunTime = 0;
                StrategyParam::timeForceLimit = 240; 
                runSys = 3;                  
            }
            else if (strConj.find("fof(s2_funct_1") != string::npos && strConj.find("wellord2") == string::npos) {
                StrategyParam::firstRunTime = 12;
                StrategyParam::timeForceLimit = 24; 
                runSys = 2;                  
            }
            else if (strConj.find("fof(s2_xboole_0") != string::npos) {
                StrategyParam::firstRunTime = 12;
                StrategyParam::timeForceLimit = 28; 
                runSys = 2;
            }
        }
        else if (strConj.find("fof(s3_") != string::npos) {
            if (strConj.find("fof(s3_subset_1__e1_40__pre_topc,conjecture") != string::npos || strConj.find("fof(s3_subset_1__e2_37_1_1__pre_topc,conjecture") != string::npos) {
                StrategyParam::firstRunTime = 12;
                StrategyParam::timeForceLimit = 28; 
                runSys = 2;
            }
        }
        else if (strConj.find("_tops_") != string::npos) {
            if (strConj.find("fof(t11") != string::npos || strConj.find("t55") != string::npos) {
                StrategyParam::firstRunTime = 12;
                StrategyParam::timeForceLimit = 28; 
                runSys = 2;
            }
        }
        else if (strConj.find("fof(mv5,conjecture") != string::npos){
            StrategyParam::firstRunTime = 0;
            StrategyParam::timeForceLimit = 240; 
            runSys = 3;
        }
        else if (strConj.find("_autgroup,conjecture") != string::npos) {
            if (strConj.find("fof(t16") != string::npos || strConj.find("t26") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_latsum_1,conjecture") != string::npos) {
            if (strConj.find("fof(t19") != string::npos || strConj.find("t24") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_waybel22,conjecture") != string::npos) {
            if (strConj.find("fof(t13") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_yellow_1,conjecture") != string::npos) {
            if (strConj.find("fof(t2") != string::npos) {
                StrategyParam::firstRunTime = 12;
                StrategyParam::timeForceLimit = 24;
                runSys = 2;
            }
        }
        else if (strConj.find("_finsub_1,conjecture") != string::npos) {
            if (strConj.find("fof(t24") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_latsubgr,conjecture") != string::npos) {
            if (strConj.find("fof(t35") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_ordinal1,conjecture") != string::npos) {
            if (strConj.find("fof(t29") != string::npos
                    || strConj.find("fof(t35") != string::npos || strConj.find("fof(t36") != string::npos
                    || strConj.find("fof(t41") != string::npos || strConj.find("fof(t5") != string::npos
                    || strConj.find("fof(t6") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("fof(t32") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 24;
                runSys = 2;
            }
            else if (strConj.find("fof(t23") != string::npos) {
                StrategyParam::firstRunTime = 108;
                StrategyParam::timeForceLimit = 4;
                runSys = 2;
            }
        }
        else if (strConj.find("_lopclset,conjecture") != string::npos) {
            if (strConj.find("fof(t30") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_rmod_5,conjecture") != string::npos) {
            if (strConj.find("fof(t11") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_waybel_") != string::npos) {
            if (strConj.find("fof(t29_waybel_9") != string::npos || strConj.find("fof(t8_waybel_") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 24;
                runSys = 2;
            }
        }
        else if (strConj.find("_yellow19,conjecture") != string::npos) {
            if (strConj.find("fof(t15") != string::npos || strConj.find("fof(t18") != string::npos
                    || strConj.find("fof(t2") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 24;
                runSys = 2;
            }
            else if (strConj.find("fof(t13") != string::npos || strConj.find("fof(t4") != string::npos
                    || strConj.find("fof(t9") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_relat_1,conjecture") != string::npos) {
            if (strConj.find("fof(t115") != string::npos || strConj.find("fof(t143") != string::npos
                    || strConj.find("fof(t145") != string::npos
                    || strConj.find("fof(t174") != string::npos || strConj.find("fof(t178") != string::npos
                    || strConj.find("fof(t21") != string::npos || strConj.find("fof(t25") != string::npos
                    || strConj.find("fof(t44") != string::npos || strConj.find("fof(t45") != string::npos
                    || strConj.find("fof(t86") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 24;
                runSys = 2;
            }
            else if (strConj.find("fof(t117") != string::npos || strConj.find("fof(t71") != string::npos
                    || strConj.find("fof(t88") != string::npos) {
                StrategyParam::firstRunTime = 70;
                StrategyParam::timeForceLimit = 14;
                runSys = 2;
            }
            else if (strConj.find("fof(t119") != string::npos || strConj.find("fof(t140") != string::npos
                    || strConj.find("fof(t160") != string::npos
                    || strConj.find("fof(t46") != string::npos || strConj.find("fof(t47") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("fof(t146") != string::npos || strConj.find("fof(t90") != string::npos
                    || strConj.find("fof(t94") != string::npos) {
                StrategyParam::firstRunTime = 82;
                StrategyParam::timeForceLimit = 10;
                runSys = 2;
            }
            else if (strConj.find("fof(t37") != string::npos) {
                StrategyParam::firstRunTime = 26;
                StrategyParam::timeForceLimit = 25;
                runSys = 2;
            }
        }
        else if (strConj.find("_closure3,conjecture") != string::npos) {
            if (strConj.find("fof(t12") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_filter_2,conjecture") != string::npos) {
            if (strConj.find("fof(t2") != string::npos || strConj.find("fof(t35") != string::npos
                    || strConj.find("fof(t49") != string::npos || strConj.find("fof(t51") != string::npos
                    || strConj.find("fof(t52") != string::npos || strConj.find("fof(t56") != string::npos
                    || strConj.find("fof(t76") != string::npos || strConj.find("fof(t77") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_pre_topc,conjecture") != string::npos) {
            if (strConj.find("fof(t45") != string::npos) {
                runSys = 3;
            }
            else if (strConj.find("fof(t48") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 25;
                runSys = 2;
            }
        }
        else if (strConj.find("_relset_1,conjecture") != string::npos) {
            if (strConj.find("fof(t12") != string::npos || strConj.find("fof(t14") != string::npos
                    || strConj.find("fof(t22") != string::npos || strConj.find("fof(t23") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 25;
                runSys = 2;
            }
        }
        else if (strConj.find("_relset_2,conjecture") != string::npos) {
            if (strConj.find("fof(t12") != string::npos || strConj.find("fof(t13") != string::npos
                    || strConj.find("fof(t14") != string::npos || strConj.find("fof(t22") != string::npos
                    || strConj.find("fof(t27") != string::npos || strConj.find("fof(t40") != string::npos
                    || strConj.find("fof(t43") != string::npos
                    || strConj.find("fof(t5") != string::npos || strConj.find("fof(t8") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_waybel34,conjecture") != string::npos) {
            if (strConj.find("fof(t17") != string::npos || strConj.find("fof(t38") != string::npos
                    || strConj.find("fof(t45") != string::npos || strConj.find("fof(t46") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_finset_1,conjecture") != string::npos) {
            if (strConj.find("fof(t17") != string::npos || strConj.find("fof(t22") != string::npos
                    || strConj.find("fof(t23") != string::npos || strConj.find("fof(t31") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_yellow_0,conjecture") != string::npos) {
            if (strConj.find("fof(t15") != string::npos || strConj.find("fof(t16") != string::npos
                    || strConj.find("fof(t60") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 25;
                runSys = 2;
            }
        }
        else if (strConj.find("_yellow_6,conjecture") != string::npos) {
            if (strConj.find("fof(t21") != string::npos || strConj.find("fof(t28") != string::npos) {
                StrategyParam::firstRunTime = 15;
                StrategyParam::timeForceLimit = 25;
                runSys = 2;
            }
        }
        else if (strConj.find("_wellord2,conjecture") != string::npos) {
            if (strConj.find("fof(t3") != string::npos) {
                StrategyParam::firstRunTime = 72;
                StrategyParam::timeForceLimit = 18;
                runSys = 2;
            }
            else if (strConj.find("fof(t4") != string::npos) {
                StrategyParam::firstRunTime = 96;
                StrategyParam::timeForceLimit = 8;
                runSys = 2;
            }
        }
        else if (strConj.find("_orders_2,conjecture") != string::npos) {
            if (strConj.find("fof(t25") != string::npos) {
                StrategyParam::firstRunTime = 12;
                StrategyParam::timeForceLimit = 28;
                runSys = 2;
            }
            else if (strConj.find("fof(t26") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_waybel33,conjecture") != string::npos) {
            if (strConj.find("fof(t27") != string::npos || strConj.find("fof(t7") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_isocat_2,conjecture") != string::npos) {
            if (strConj.find("fof(t41") != string::npos || strConj.find("fof(t43") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(tautology,conjecture") != string::npos) {
            runSys = 3;
        }
        else if (strConj.find("fof(thm_2E") != string::npos) {
            if (strConj.find("fof(thm_2Earith") != string::npos || strConj.find("fof(thm_2Equotient_") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("fof(tlhfof") != string::npos) {
            if (strConj.find("fof(tlhfof34981,") != string::npos || strConj.find("fof(tlhfof40016,") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_tsp_2,") != string::npos) {
            if (strConj.find("fof(t19") != string::npos || strConj.find("fof(t21") != string::npos) {
                runSys = 3;
            }
        }
        else if (strConj.find("_lattice3,") != string::npos) {
            if (strConj.find("fof(t2") != string::npos) {
                StrategyParam::firstRunTime = 12;
                StrategyParam::timeForceLimit = 28;
                runSys = 2;
            }
        }
        else if (strConj.find("fof(main,") != string::npos) {
            StrategyParam::firstRunTime = 110;
            StrategyParam::timeForceLimit = 4;
            runSys = 2;
        }
        return runSys;
    }
    return runSys;
}

extern CseSymbolMapper cseSymbolMapper;

int main(int argc, char** argv) { 
   
    StrategyParam::start = clock();//start time
//#define newTriDebug
#ifndef newTriDebug
    //runcommand: problem/path /home/ars01/Desktop/dist 300
    string filePath = argv[1];   //得到问题的绝对路径
    string workspace = argv[2]; //工作路径
    string timeForce = argv[3];  //CSE运行时间

//    string filePath = "/home/ars01/Desktop/dist/problems/AGT012+1.p";   //得到问题的绝对路径
//    string timeForce = "50";  //CSE运行时间
//    string workspace = "/home/ars01/Desktop/dist"; //工作路径
    
    string strategyMode = "1";  //策略模式：1，多策略；0，单策略
    string runMode = "0";   //0：CSE版本；4：结合E版本
    string orCompetitionVersion = "1";  //1：竞赛模式；0：机房模式
    string inferRule = "6"; //做三角形的算法版本 0-8
    string distriFirstTime = "0";   //三角形组合算法的时间分配参数
    //竞赛版本下：runMode都为偶数，即都判定单问题；orCompetitionVersion都为1; theoremFormat格式都为fof格式，即为0
    //CSE有7个实际参数；CSE_E有9个实际参数
//    string filePath = argv[1];   //得到问题的绝对路径
//    string strategyMode = argv[2];  //策略模式：1，多策略；0，单策略
//    string runMode = argv[3];   //0：CSE版本；4：结合E版本
//    string orCompetitionVersion = argv[4];  //1：竞赛模式；0：机房模式
//    string workspace = argv[5]; //工作路径
//    string inferRule = argv[6]; //做三角形的算法版本 0-8
//    string distriFirstTime = argv[7];   //三角形组合算法的时间分配参数
//    //根据系统版本，设置系统运行时间
//    string timeForce = "";
    string usedTime = "";
    string totalRunTime = "";
    //string wallclockTime = "";
//    if (runMode == "0") {   //CSE版本
//        timeForce = argv[2];  //CSE运行时间
//    }
//    else if (runMode == "4") {  //结合E版本
//        usedTime = argv[8];  //E第一段的运行时间
//        timeForce = argv[9]; //CSE运行时间
//        totalRunTime = argv[10];  //系统总的CPU运行时间
//        //wallclockTime = argv[11];   //wallclock time
//    }
#else
    //string filePath = "/home/swjtu/Desktop/dist/problems/COM008+1.p";   //得到问题的绝对路径
    //string filePath = "/home/swjtu/Desktop/dist/problems/TOP048+1.p";   //得到问题的绝对路径
    string filePath = "/home/ars01/Desktop/dist/output/GRP194+1.cnf";   //得到问题的绝对路径
    //string filePath = "/home/swjtu/Desktop/dist/problems/MED007+1.p";   //得到问题的绝对路径
    //string filePath = "/home/swjtu/Desktop/dist/problems/KRS251+1.p";   //得到问题的绝对路径
    string strategyMode = "1";  //策略模式：1，多策略；0，单策略
    string runMode = "0";   //0：CSE版本；4：结合E版本
    string orCompetitionVersion = "1";  //1：竞赛模式；0：机房模式
    string workspace = "/home/ars01/Desktop/dist"; //工作路径
    string inferRule = "6"; //做三角形的算法版本 0-8
    string distriFirstTime = "0";   //三角形组合算法的时间分配参数
    //根据系统版本，设置系统运行时间
    string timeForce = "";
    string usedTime = "";
    string totalRunTime = "";    
    if (runMode == "0") {   //CSE版本
        timeForce = "300";  //CSE运行时间
    }
    else if (runMode == "4") {  //结合E版本
        usedTime = "5";  //E第一段的运行时间
        timeForce = "5"; //CSE运行时间
        totalRunTime = "15";  //系统总的运行时间
    }  
#endif 
    //cout << "filePath=" << filePath << "\nworkspace=" << workspace << "\ntime=" << timeForce << endl;
    StrategyParam::isInteraction = false;
    StrategyParam::equality = true;    // not add equality axioms
    bool convertFail = false;
    bool shortenFail = false;
    bool firstESuccess = false;
    
    FileOp::appPath = workspace;
    if (orCompetitionVersion == "1")
        StrategyParam::orForCompition = true;   //竞赛模式
    else
        StrategyParam::orForCompition = false;  //机房模式
    StrategyParam::problemDiv = 0;  //1： 判定不可满足性； 0： 判定可满足性问题
    FileOp::strategyMode = atoi(strategyMode.c_str());
    FileOp::runMode = atoi(runMode.c_str());
    
    //根据系统版本，设置系统运行时间
    //CSE组合版本时间分配参数设置
    StrategyParam::firstCseRunMode = atoi(inferRule.c_str());
    if (StrategyParam::firstCseRunMode == 2 || StrategyParam::firstCseRunMode == 3 || StrategyParam::firstCseRunMode == 8) //CSE为组合模式（时间分配）
        StrategyParam::distriTime = stod(distriFirstTime) / 60; 
    else
        StrategyParam::distriTime = 0;  
    //系统时间参数设置
    if (FileOp::runMode == 0) { //CSE系统
        StrategyParam::timeForceLimit = stod(timeForce);
    } 
    else if (FileOp::runMode == 4) {    //CSE_E系统
        StrategyParam::firstRunTime = stod(usedTime);
        StrategyParam::timeForceLimit = stod(timeForce);
        StrategyParam::TotalRunTime = stod(totalRunTime);
    }
    
    //time setting
    int firstParam = 0, goalCount = 0, axiomsCount = 0, clausesCount = 0, ev1 = 6, ev2 = 0;
    int infereMode = 0, secondParam = 0;
    string goalFirst = "", axiomsFirst = ""; 
    
    int tempMode = 0;   //1 Only E; 2 CSE->E; 3 E->CSE->E; 
    if (FileOp::runMode == 4) {
        if (StrategyParam::TotalRunTime >= 300) {
            //tempMode = ReadOriProblem360(filePath);
            //time_Parameter_360(filePath, firstParam, goalFirst, axiomsFirst, goalCount, axiomsCount, clausesCount, ev1);
            tempMode = 2;
        }
        else if (StrategyParam::TotalRunTime > 240 && StrategyParam::TotalRunTime <= 300) {
            //tempMode = ReadOriProblem300(filePath);
            time_Parameter_300(filePath, firstParam, goalFirst, axiomsFirst, goalCount, axiomsCount, clausesCount, ev1);
        }
        else if (StrategyParam::TotalRunTime > 180 && StrategyParam::TotalRunTime <= 240) {
            //tempMode = ReadOriProblem240(filePath);
            time_Parameter_240(filePath, firstParam, goalFirst, axiomsFirst, goalCount, axiomsCount, clausesCount, ev1);
        }
        else if (StrategyParam::TotalRunTime > 120 && StrategyParam::TotalRunTime <= 180) {
            //tempMode = ReadOriProblem180(filePath);
            time_Parameter_180(filePath, firstParam, goalFirst, axiomsFirst, goalCount, axiomsCount, clausesCount, ev1);
        }
        else if (StrategyParam::TotalRunTime <= 120) {
            //tempMode = ReadOriProblem120(filePath);
            time_Parameter_120(filePath, firstParam, goalFirst, axiomsFirst, goalCount, axiomsCount, clausesCount, ev1);
        }
//        cout << "goalFirst: " << goalFirst << endl;
//        cout << "axiomFirst: " << axiomsFirst << endl;
//        cout << "firstParam: " << firstParam << endl;
//        cout << "goalCount = " << goalCount << "; axiomsCOunt = " << axiomsCount << "; clausesCount = " << clausesCount << endl;
//        cout << "****" << endl;        
        if (firstParam == StrategyParam::TotalRunTime) {
            tempMode = 1;   //run Only E
            StrategyParam::firstRunTime = StrategyParam::TotalRunTime;
        }
        else {
            if (ev1 == 5){
                tempMode == 3;  //E->CSE->E
                StrategyParam::firstRunTime = firstParam;
                StrategyParam::timeForceLimit = StrategyParam::TotalRunTime * 0.03;
            }
            else {
                if (StrategyParam::TotalRunTime >= 300) {
                    //tempMode = ReadOriProblem360(filePath);
                    //second_Time_Parameter_300(goalFirst, axiomsFirst, goalCount, axiomsCount, clausesCount, firstParam, secondParam, ev1, ev2, infereMode);
                }
                else if (StrategyParam::TotalRunTime > 240 && StrategyParam::TotalRunTime <= 300) {
                    //tempMode = ReadOriProblem300(filePath);
                    second_Time_Parameter_300(goalFirst, axiomsFirst, goalCount, axiomsCount, clausesCount, firstParam, secondParam, ev1, ev2, infereMode);
                }
                else if (StrategyParam::TotalRunTime > 180 && StrategyParam::TotalRunTime <= 240) {
                    //tempMode = ReadOriProblem240(filePath);
                    second_Time_Parameter_240(goalFirst, axiomsFirst, goalCount, axiomsCount, clausesCount, firstParam, secondParam, ev1, ev2, infereMode);
                }
                else if (StrategyParam::TotalRunTime > 120 && StrategyParam::TotalRunTime <= 180) {
                    //tempMode = ReadOriProblem180(filePath);
                    second_Time_Parameter_180(goalFirst, axiomsFirst, goalCount, axiomsCount, clausesCount, firstParam, secondParam, ev1, ev2, infereMode);
                }
                else if (StrategyParam::TotalRunTime <= 120) {
                    //tempMode = ReadOriProblem120(filePath);
                    second_Time_Parameter_120(goalFirst, axiomsFirst, goalCount, axiomsCount, clausesCount, firstParam, secondParam, ev1, ev2, infereMode);
                }
//                cout << "firstParam=" << firstParam << "; secondParam=" << secondParam << "; infereMode=" << infereMode << endl;
//                cout << "goalFirst: " << goalFirst << endl;
//                cout << "axiomFirst: " << axiomsFirst << endl;
//                cout << "goalCount = " << goalCount << "; axiomsCOunt = " << axiomsCount << "; clausesCount = " << clausesCount << endl;
//                cout << "****" << endl;
                if (firstParam == 360) {
                    tempMode = 1;   //Only E
                    StrategyParam::firstRunTime = StrategyParam::TotalRunTime;
                }
                else if (firstParam == 0) {
                    StrategyParam::firstRunTime = 0;
                    StrategyParam::timeForceLimit = (double)secondParam;
                    if (StrategyParam::timeForceLimit == 0)
                        StrategyParam::timeForceLimit = StrategyParam::TotalRunTime * 0.2;
                    tempMode = 2;   //CSE->E
                }
                else {
                    StrategyParam::firstRunTime = firstParam;
                    if (secondParam == 0)
                        StrategyParam::timeForceLimit = StrategyParam::TotalRunTime * 0.03;
                    tempMode = 3;   //E->CSE->E
                }
            }
        }
        
       
        
        StrategyParam::ev1 = ev1;
        StrategyParam::ev2 = ev2;
        if (StrategyParam::ev1 == 0)
            StrategyParam::ev1 = 6;
        if (StrategyParam::ev2 == 0)
            StrategyParam::ev2 = 5;
            
        if (infereMode == 6)
            StrategyParam::firstCseRunMode = infereMode;
        else if (infereMode == 7)
            StrategyParam::firstCseRunMode = infereMode;
            
    }
//    cout << "tempMode: " << tempMode << endl;
//    cout << "totalRunTime: " << StrategyParam::TotalRunTime << endl;
//    cout << "firstTime: " << StrategyParam::firstRunTime << endl;
//    cout << "cseTime: " << StrategyParam::timeForceLimit << endl;
//    cout << "infereMode:" << StrategyParam::firstCseRunMode << endl;
    

    //设置格式转换的timeout时间
    double maxConvertCNFTime = 0.0;
    double maxConvertShortTime = 0.0;
    if (FileOp::runMode == 0) { //CSE系统
        maxConvertCNFTime = StrategyParam::timeForceLimit;
        maxConvertShortTime = StrategyParam::timeForceLimit;
    } 
    else if (FileOp::runMode == 4) {    //CSE_E系统
        maxConvertCNFTime = StrategyParam::TotalRunTime;
        maxConvertShortTime = StrategyParam::TotalRunTime;
    }
    
    //初始化相关路径信息
    FileOp::workSpace = FileOp::appPath + "/output";  // 保存 ./dist/output
    
    //创建./dist/output文件夹
    bool workspaceExist = FileOp::isExistDir(FileOp::workSpace);  // ./dist/output
    
    //创建./dist/output/unsat文件夹
//    string saveWorkPath = FileOp::workSpace + "/unsat";   // ./dist/output/unsat
//    FileOp::isExistDir(saveWorkPath);
    
    //记录HOME变量和strategy文件夹路径（./dist/strategy）
    FileOp::getTopPath(true); 
    
    //记录./dist/output/tptp文件夹路径和./dist/output/tptp/log.txt文件路径
    string tptpFolder = FileOp::workSpace + "/tptp"; //记录./dist/output/tptp文件夹路径
    string logFile = FileOp::workSpace + "/tptp/log.txt";   //记录./dist/output/tptp/log.txt文件路径
    //创建./dist/output/tptp文件夹，并若存在，则删除文件夹中所有文件
   
    bool res = FileOp::isExistDir(tptpFolder);
 
    if (res) 
        FileOp::delAllFilesComplete(tptpFolder);
    if (StrategyParam::orForCompition == false)
        FileOp::clearRes(); //清空proofRes文件，并重新创建
    
    //初始化问题名称并保存
    FileOp::judgeOriginalFileFullName = filePath;   //保存原始问题的绝对路径 ./dist/problems/benchmark.p
    
    size_t pos = filePath.find_last_of('/');
    string fileName = filePath.substr(pos + 1);//判断文件名
    size_t posEnd = fileName.find_last_of('.');
    FileOp::judgeOriginalFileName = fileName.substr(0,posEnd);  //保存原始问题名称, 即 benchmark
    
    string suffix = fileName.substr(posEnd + 1);    //判断文件的格式
    
    //cout << "start to proof: " << FileOp::judgeOriginalFileName << endl;
    
    
    
    //Only E
    if (tempMode == 1 && FileOp::runMode == 4) {
        cout << "Only E" << endl;
        //直接使用E判定问题
        double executeTime = 0.0;
        if (OnlyRunEprover(executeTime)) {  //E判定成功
            if (StrategyParam::orForCompition == false) {   //机房模式 在proofStatistics.txt打印信息
                string msg = to_string(executeTime);
                FileOp::PrintStatisticsMsg(msg);
            }
        }
        else {  //E判定失败
            if (StrategyParam::orForCompition == false) {   //机房模式 在proofStatistics.txt打印信息
                string msg = "TMO‑Non";
                FileOp::PrintStatisticsMsg(msg);
            }
            cout << "TMO‑Non" << endl;
        } 
        return 0;
    }    
    else if (tempMode == 3 && FileOp::runMode == 4 && StrategyParam::isInteraction == false) {   //E->CSE->E
        cout << "E CSE E" << endl;
        //若为CSE_E系统，第一次运行E
        if (FileOp::runMode == 4 && StrategyParam::firstRunTime != 0) {
            double executeTime = 0.0;
            //cout << StrategyParam::firstRunTime<< "***\n";
            if (RunEprover(FileOp::judgeOriginalFileFullName, executeTime, StrategyParam::ev1)) {  //E判定成功
                if (StrategyParam::orForCompition == false) {   //机房模式 在proofStatistics.txt打印信息
                    string msg = to_string(executeTime);
                    FileOp::PrintStatisticsMsg(msg);
                }
                //成功后删除tptp文件，即./dist/output/tptp/benchmark.tptp
                //remove(tptpShortFile.c_str());
                firstESuccess = true;
            }
            StrategyParam::start = clock();
            //删除log.txt文件
            //remove(logFile.c_str());
        }
        //若E判定成功，则推出系统
        if (firstESuccess)
            return 0;        
    }
    
  
    
    //格式处理
    if (suffix == "p" || suffix == "P"|| suffix == "tptp"|| suffix == "TPTP" || suffix == "cnf") {
        //后缀.p与.P为fof格式（即TPTP上原始问题格式），需要利用E转成tptp格式（即CNF格式）
        string cnfFile = "";    //记录cnf格式的文件路径
        if (suffix == "p" || suffix == "P") {
            cnfFile = FileOp::workSpace + "/" + FileOp::judgeOriginalFileName + ".p";   //保存./dist/output/benchmark.p
            ConvertFofToTptp(cnfFile);
        }
        else
            cnfFile = filePath; //problems中原始问题本身就为cnf格式
     
        
        //检查转换是否成功
        if (FileOp::isFileEmpty(cnfFile)) { //为空文件
            if (FileOp::runMode == 0) { //CSE系统
                if (StrategyParam::orForCompition == false) {
                    cout << "CNF convert failed!" << endl;
                    string msg = "UNK‑Non";
                    FileOp::PrintStatisticsMsg(msg);
                }
                cout << "UNK‑Non" << endl;
            }
            else if (FileOp::runMode == 4) {    //CSE_E系统
                //直接使用E判定问题
                double executeTime = 0.0;
                if (OnlyRunEprover(executeTime)) {  //E判定成功
                    if (StrategyParam::orForCompition == false) {   //机房模式 在proofStatistics.txt打印信息
                        string msg = to_string(executeTime);
                        FileOp::PrintStatisticsMsg(msg);
                    }
                }
                else {  //E判定失败
                    if (StrategyParam::orForCompition == false) {   //机房模式 在proofStatistics.txt打印信息
                        string msg = "TMO‑Non";
                        FileOp::PrintStatisticsMsg(msg);
                    }
                    cout << "TMO‑Non E judge fail" << endl;
                }
            }
            //删除cnf文件，即./dist/output/benchmark.p
            //remove(cnfFile.c_str());
            convertFail = true;
        }
        //若cnf格式转换失败，则退出系统
        if (convertFail) 
            return 0;
        
        
        string tptpShortFile = tptpFolder + "/" + FileOp::judgeOriginalFileName + ".tptp";
        //20250611 记录CNF转CSE格式后的文件
        string cseFile = FileOp::workSpace + "/" + FileOp::judgeOriginalFileName + ".cse";
        string cnf_str = "";
        if (convert_cnf_to_cse(cnfFile, cseFile, cseSymbolMapper, cnf_str, StrategyParam::goalClaId)) {
            //cout << "# 转换成功完成！" << endl;
        } else {
            cerr << "# 转换过程中出现错误！" << endl;
            return 1;
        }
        
        //remove(cnfFile.c_str());    //删除cnf格式文件
       
      
        //若为CSE_E系统，第一次运行E
        if (FileOp::runMode == 4 && StrategyParam::firstRunTime != 0 && StrategyParam::isInteraction) {
            double executeTime = 0.0;
            
            if (RunEprover(tptpShortFile, executeTime, StrategyParam::ev1)) {  //E判定成功
                if (StrategyParam::orForCompition == false) {   //机房模式 在proofStatistics.txt打印信息
                    string msg = to_string(executeTime);
                    FileOp::PrintStatisticsMsg(msg);
                }
                //成功后删除tptp文件，即./dist/output/tptp/benchmark.tptp
                //remove(tptpShortFile.c_str());
                firstESuccess = true;
            }
            StrategyParam::start = clock();
            //删除log.txt文件
            //remove(logFile.c_str());
        }
        //若E判定成功，则推出系统
        if (firstESuccess)
            return 0;
       
        //添加等词公理
        string file = convert_cnf_manual(cseFile);
        FileOp::AnalysisFileName(file);  
        FileOp::PrintInfoForEprover(cnf_str);  //将原始子句写入到.cnf中
    }
    

    //20210521 将第一段E执行后的输出文件.first_out移到问题输出文件夹
    if (FileOp::runMode == 4 && StrategyParam::firstRunTime != 0) {
        string cmdMove = "mv " + FileOp::eOutputFile + " " + FileOp::g_OutputPath;
        int resMove = system(const_cast<char*> (cmdMove.c_str())); 
        FileOp::eOutputFile = FileOp::g_OutputPath + "/" + FileOp::judgeOriginalFileName + ".first_out";
    }  
    
    //读取文件预处理，生成预处理文件
//    if (1) {           
//        pid_t pid;
//        pid = fork();
//        if(pid == 0) {
//            Formula fol;
//            INT32 startId = InitFunction::StrToAny("-1");
//            if (startId == -1)//预处理
//                cprover::PreProcess(fol);
//            string sPreprocess = fol.GetFormulaInfo();
//            sPreprocess += "\n" + fol.ToString(false);
//            FileOp::WritePreFile(sPreprocess);
////            //for competition
////            if (FileOp::runMode == 4) {   //对于结合E系统，将预处理过后的子句输出到.res
////                string str = "";
////                str += fol.competInitClauseSet();
////                FileOp::prinfPreResForE(str); //输出所有的子句到.res
////            }
//            fol.DelSet();
//            exit(0);
//        }
//        else if(pid >0)
//        {
//            waitpid(pid,NULL,0);
//        }    
//    }  
    
    
    //进行问题判定
    RESULT s;
    if(StrategyParam::orForCompition){
        s = Prover::prover();
    }
    else {
        pid_t child;
        child = fork();
        if (child == 0) {
            s = Prover::prover();
            exit(0);
        } 
        else if (child > 0) {
            waitpid(child, NULL, 0);
        }
    } 
    
    if (s == READERR) { 
        if (FileOp::runMode == 0) {
            if (StrategyParam::orForCompition == false) {
                string msg = "UNK‑Non";
                FileOp::PrintStatisticsMsg(msg);
            } 
            //删除相关文件和文件夹
            FileOp::delAllFilesComplete(FileOp::g_OutputPath);
            rmdir(FileOp::g_OutputPath.c_str());             
        }
        else if (FileOp::runMode == 4) {
            //运行E
            string cnfFile = FileOp::judgeOriginalFileFullName;
            double realRunTime = 0.0;
            double secondETime = StrategyParam::TotalRunTime - StrategyParam::parseTime - StrategyParam::firstRunTime - StrategyParam::preTime;
            
            if (FileOp::SecondRunEprover(secondETime, cnfFile)) {   //E判定成功
                string outMsg = "";
                bool isProof = false;
                //首先打印版本信息
                outMsg += "% Version  : CSG_E---1.0\n";
                outMsg += "% Problem  : " + FileOp::judgeOriginalFileName + ".p\n";
                //读取输出文件
                ifstream ifOutputFile(FileOp::eSecondOutputFile);

                string strLine = "";
                while (getline(ifOutputFile, strLine)) {
                    if (strLine.find("#", 0) != string::npos) {
                        if (strLine.find("Proof found!", 0) != string::npos) {
                            outMsg += "% Proof found\n";
                            isProof = true;
                        }
                        else if (isProof && strLine.find("SZS status Theorem", 0) != string::npos) { 
                            outMsg += "% SZS status Theorem for " + FileOp::judgeOriginalFileName + ".p\n";
                        }
                        else if (isProof && strLine.find("SZS output start CNFRefutation", 0) != string::npos) {
                            outMsg += "% SZS output start Proof\n";
                        }
                        else if (isProof && strLine.find("SZS output end CNFRefutation", 0) != string::npos) {
                            outMsg += "% SZS output end Proof\n";
                        }
                        else if (isProof && strLine.find("Total time", 0) != string::npos) {
                            //记录E耗费时间
                            int beginPos = strLine.find(":");
                            int endPos = strLine.find("s");
                            string tempTime = strLine.substr(beginPos + 2, (endPos - 1) - (beginPos + 2));
                            realRunTime = stod(tempTime);
                            //计算系统总时间
                            realRunTime += StrategyParam::parseTime + StrategyParam::firstRunTime + StrategyParam::preTime;
                            //打印时间信息
                            //cout << "% Total time : " << executeTime << " s" << endl;
                            outMsg += "% Total time : " + to_string(realRunTime) + " s\n";
                            //fout << "% Total time : " << executeTime << " s" << endl;
                        }
                    }
                    else if (isProof) {
                        //cout << strLine << endl;
                        outMsg += strLine + "\n";
                        //fout << strLine << endl;
                    } 
                }
                ifOutputFile.close();            
                //打印统计信息
                if (isProof && StrategyParam::orForCompition == false) {
                    string msg = to_string(realRunTime);
                    FileOp::PrintStatisticsMsg(msg);
                }
                else if (isProof == false && StrategyParam::orForCompition == false) {
                    string msg = "TMO‑Non";
                    FileOp::PrintStatisticsMsg(msg);
                }
            }
            else {
                cout << "CSG_E is exited by timeout" << endl;
                if (StrategyParam::orForCompition == false) {
                    string msg = "TMO‑Non";
                    FileOp::PrintStatisticsMsg(msg);
                }   
                FileOp::delAllFilesComplete(FileOp::g_OutputPath);
                rmdir(FileOp::g_OutputPath.c_str());
            }            
        }
    }
    
    return 0;
}

