/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   globalFunc.h
 * Author: sjg
 *
 * Created on 2016年11月7日, 下午5:24
 */

#ifndef GLOBALFUNC_H
#define GLOBALFUNC_H
#include <fstream>
#include <iostream>
#include <sys/stat.h>
#include <sys/types.h>
#include<cstdlib>
#include<unistd.h>
//#include <linux/kernel.h>
//#include <linux/unistd.h>
#include<sys/wait.h>
//#include<sys/sysinfo.h>
#include <unistd.h>
#include <errno.h>
#include <dirent.h>
#include <ctime>
#include<cstring>
#include<vector>
#include<set>
#include<map>
#include<assert.h>
#include <algorithm>
#include <unordered_map>
#include "dataTypeDef.h"
using namespace std;
typedef struct addLiteralEquality{
    string literal;
    int suffix;
}literalAdd;
typedef struct addfuncEquality{
    string func;
    int suffix;
}funcAdd;
//去除字符前后空格
inline void TrimStr(string& s)
{
    if (s.empty())
        return;
    s.erase(0, s.find_first_not_of(" "));
    s.erase(s.find_last_not_of(" ") + 1);
}
inline UINT32 BKDRHash(UINT32 hash, int termCode) {
    //UINT32 seed=31;
    /*UINT32 hash=0;*/
    //termCode=termCode&0x7FFFFFFF; //转换为正数
    hash = hash * 31 + termCode;
    return hash & 0x7FFFFFFF; //转换为正数
}

//查找子字符串
inline int FindSubStr(string& str, string& subStr)
{
    int pos = -1;
    size_t strLen = str.size(), subStrLen = subStr.size();
    if (strLen < subStrLen)
        return -1;
    while (pos++<strLen) {
        bool flag = false;
        if (str[pos] == subStr[0]) {
            flag = true;
            for (size_t k = 1; k < subStrLen; k++) {
                if (str[pos + k] != subStr[k]) {
                    flag = false;
                    break;
                }
            }
        }
        if (flag && (str[pos + subStrLen] == ')' || str[pos + subStrLen] == ',')) {
            return pos;
        }
    }
    return -1;
}
//分割字符串
inline vector<string> Split_c(const string& s, const char delim)
{
    size_t last = 0;
    size_t index = s.find_first_of(delim, last);
    vector<string> ret;
    while (index != string::npos) {
        ret.push_back(s.substr(last, index - last));
        last = index + 1;
        index = s.find_first_of(delim, last);
    }
    if (index - last > 0)
        ret.push_back(s.substr(last, index - last));
    return ret;
}
//分割字符串 
inline vector<string> Split_s(const string& s, const string& delim)
{
    size_t last = 0;
    size_t index = s.find_first_of(delim, last);
    vector<string> ret;
    while (index != string::npos) {
        ret.push_back(s.substr(last, index - last));
        last = index + 1;
        index = s.find_first_of(delim, last);
    }
    if (index - last > 0)
        ret.push_back(s.substr(last, index - last));
    return ret;
}

//返回谓词符号以及第一个括号所在位置
inline string GetPred(const string& pred, size_t& i)
{
    size_t predSize = pred.size();
    assert(predSize != 0);
    //if(predSize==0)return nullptr;		
    i = pred.find_first_of('(');
    assert(i != 0);
    assert(i != string::npos);
    return pred.substr(0, i);
}

//分离谓词符号和括号中内容
inline void SplitSymbol(const string &pred, string &symbol, string &strContent)
{
    size_t pos = 0;
    symbol = GetPred(pred, pos);
    strContent = pred.substr(pos + 1, pred.length() - pos - 2); //抽取内容
}
//判定是否为基文字-是否包含'x'
inline bool IsBaseLits(vector<string>& vectStrLits)
{
    bool isBase = true;
    for (string &str : vectStrLits) {
        if (str.find('x') != string::npos) {
            isBase = false;
            break;
        }
    }
    return isBase;
}
inline void stringAddOne(string & str)
{
    for(int i=0; i<str.length(); ++i){
        str.at(i) = str.at(i) +1;
    }
}


inline void stringPlusOne(string & str)
{
    for(int i=0; i<str.length(); ++i){
        str.at(i) = str.at(i) - 1;
    }
}

// --- CSE 符号映射器类 ---
// 负责从 FOF/CNF 符号到 CSE 符号的映射。
class CseSymbolMapper {
private:
    int predicate_counter = 1; // CSE 谓词计数器 (P1, P2, ...)
    int function_counter = 1;  // CSE 函数计数器 (f1, f2, ...)
    int constant_counter = 1;  // CSE 常量计数器 (a1, a2, ...)

    // 内部存储映射关系的数据结构
    std::unordered_map<std::string, std::string> predicate_map; // CNF 谓词 -> CSE 谓词
    std::unordered_map<std::string, std::string> function_map;  // CNF 函数 -> CSE 函数
    std::unordered_map<std::string, std::string> constant_map;  // CNF 常量 -> CSE 常量

    // 内部辅助函数，用于查找或创建映射
    std::string get_mapping(const std::string& cnf_symbol,
                            std::unordered_map<std::string, std::string>& map,
                            const std::string& prefix,
                            int& counter);

public:
    // 初始化映射器
    CseSymbolMapper();

    // 获取或创建 CSE 谓词符号 ('P' 前缀，等号特殊映射为 'E')。
    std::string get_predicate_mapping(const std::string& cnf_symbol);

    // 获取或创建 CSE 函数符号 ('f' 前缀)。
    std::string get_function_mapping(const std::string& cnf_symbol);

    // 获取或创建 CSE 常量符号 ('a' 前缀)。
    std::string get_constant_mapping(const std::string& cnf_symbol);

    // --- 获取映射关系的访问器函数 ---
    // 获取 CNF 谓词到 CSE 谓词的映射表 (常量引用)。
    const std::unordered_map<std::string, std::string>& getPredicateMap() const;
    // 获取 CNF 函数到 CSE 函数的映射表 (常量引用)。
    const std::unordered_map<std::string, std::string>& getFunctionMap() const;
    // 获取 CNF 常量到 CSE 常量的映射表 (常量引用)。
    const std::unordered_map<std::string, std::string>& getConstantMap() const;

    // --- 获取反向映射关系的函数 ---
    // 获取 CSE 谓词到 CNF 谓词的反向映射表。
    std::unordered_map<std::string, std::string> getReversePredicateMap() const;
    // 获取 CSE 函数到 CNF 函数的反向映射表。
    std::unordered_map<std::string, std::string> getReverseFunctionMap() const;
    // 获取 CSE 常量到 CNF 常量的反向映射表。
    std::unordered_map<std::string, std::string> getReverseConstantMap() const;
};

/**
 * 处理单个CNF语句块
 *
 * 该函数处理单个完整的CNF语句，执行符号还原、
 * 格式转换和变量重命名等操作，将其从CSE格式还原为原始格式。
 *
 * 处理步骤：
 * 1. 验证CNF语句格式：必须以"cnf("开头，以")."结尾
 * 2. 解析CNF语句的三个部分：ID、类型、公式体
 * 3. 标准化ID格式：纯数字ID添加"i_0_"前缀
 * 4. 统一类型字段为"plain"
 * 5. 还原公式体中的符号和变量
 * 6. 转换等式表达式为中缀形式
 * 7. 为公式体添加外层括号
 */
std::string process_single_cnf_block(const std::string& cnf_block,
                                     const CseSymbolMapper& mapper,
                                     const std::vector<unsigned int>& goalIds);

// 将单个CSE格式的子句转换为CNF格式的子句
std::string convert_single_cse_clause_to_cnf(const std::string& cse_line,
                                             const CseSymbolMapper& mapper,
                                             const std::vector<unsigned int>& goalIds);

// --- CNF 转换为 CSE 的函数 ---
// 此函数负责将 CNF 文件转换为 CSE 格式文件，并使用 CseSymbolMapper 映射表。
// 参数:
//   input_cnf_path: 输入的 CNF 文件路径。
//   output_cse_path: 输出的 CSE 文件路径。
//   mapper: 一个 CseSymbolMapper 对象的引用，用于存储和管理符号映射。
// 返回值:
//   如果转换成功，返回 true；否则返回 false。
bool convert_cnf_to_cse(const std::string& input_cnf_path,
                        const std::string& output_cse_path,
                        CseSymbolMapper& mapper,
                        std::string& cnf_str,
                        std::vector<unsigned int>& goalIds);

// --- CSE 还原为原始格式的函数 ---
// 此函数负责将 CSE 格式的文件还原为原始的CNF格式
// 参数:
//   input_cse_cnf_path: 输入的 CSE 格式 CNF 文件路径
//   output_original_path: 输出的原始格式文件路径
//   mapper: 包含符号映射关系的 CseSymbolMapper 对象
// 返回值:
//   如果还原成功，返回 true；否则返回 false
bool convert_cse_to_cnf(const std::string& input_cse_cnf_path,
                             const std::string& output_original_path,
                             const CseSymbolMapper& mapper,
                             const std::vector<unsigned int>& goalIds);

#endif /* GLOBALFUNC_H */

