/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   dataTypeDef.h
 * Author: sjg
 *
 * Created on 2016年11月7日, 下午4:48
 */

#ifndef DATATYPEDEF_H
#define DATATYPEDEF_H
//数据类型重命名
typedef signed char         INT8, *PINT8;
typedef signed short        INT16, *PINT16;
typedef signed int          INT32, *PINT32;
typedef unsigned char       UINT8, *PUINT8;
typedef unsigned short      UINT16, *PUINT16;
typedef unsigned int        UINT32, *PUINT32;
typedef unsigned long int UINT64,*PULONG64;
//项属性
enum
{
	TCon = 0,
	TFunc = 1,	//函数
	TPred = 2,	//正谓词项 	 
	TEqn = 3,//等词项	 
	TNegEqn = 4, //负等词项 3+4=7
	TNegPred = 5,//负谓词项  2+5=7

	TPairPred=7
};
//typedef NULL nullptr;
//定义读取文件的类型 
enum FILETYPE{TPTP,FOF,MYDefine};
//枚举定义返回类型
//返回：100 不可满足;  101 可满足;  102 不可判定;103 无子句参与归结 200 错误起步ID; 201创建网络连接错误;  202 后台输出目录错误; 203 程序调用错误,
//-101 文件格式错误
enum RESULT
{
    READERR = -101, READOK, UNSAT = 100, SAT, UNKNOWN, NOCLAUSE = 0, ERR_STARTID = 200, ERR_NET, ERR_OUTFOLDER, ERR_INVOKE, UnknownFile,
    MOREFUNC/*函数复合层过多*/, MORELIT/*剩余文字过多*/, NOLEFTLIT/*没有剩余文字*/, SingleLit, TAUTOLOGY/*R为恒真*/, EqnTautology, RSubsump/*R包含冗余*/, RULEOK/*规则检查通过*/, NOMGU/*合一失败*/
    ,Succes,fail
};
#define Set1stTProp(va,prop)(va=(va)|(prop<<24))  //设置第一个项的属性
#define Del1stTProp(va,prop)(va=(va)&(prop<<24))  //删除第一个项的属性
#define Query1stTProp(va,prop)(((va>>24)&prop)==(prop))  //查询第一个项的属性
#define QueryCodeProp(va,prop)((va&prop)==(prop))  //查询项编码的属性
#define Get1stTermID(va)(va&0xFFFFFF)    //设置第一个项的ID
#define GetCodeProp(va)(va>>24)      // 得到编码的属性状态 0-常元 1-变元 2-全局索引元 3-非基项索引

#define EncodeVar(row,col) ((row<<8|col)|0x80000000) //对变元编码 1识别位 23位表示行 8位表示列.
#define EncodeCon(va)(va=(va)|(TCon<<24))  //对常元项编码	  
#define EncodeLitCode(row,col) (row<<8|col)  //对文字编码	  

#define IsVar(va)(va->iTermCode<0)      //判断是否为变元，检查首位是否是1
#define GetVarRow(va)((va<<1)>>9)
#define GetClaId(va) ((va<<1)>>9)
#define GetVarId(va)(va&0xFF)
#define IsCon(va)((va>>28)==1)

#define GetCodeId(va)(va&0xFFFFFF)     //得到编码的ID

//回退类型 NOBACK-不回退,CHGLIT-改变归结文字,chgnext-改变被归结文字
enum BACKTYPE{ NOBACK, CHGLIT, CHGNEXT };
//
// The following types are guaranteed to be signed and 32 bits wide.
//
typedef signed int LONG32, *PLONG32;
// The following types are guaranteed to be unsigned and 32 bits wide.
typedef unsigned int ULONG32, *PULONG32;

typedef unsigned long DWORD;

#define MAXUINT8    ((UINT8)~((UINT8)0))
#define MAXINT8     ((INT8)(MAXUINT8 >> 1))
#define MININT8     ((INT8)~MAXINT8)

#define MAXUINT16   ((UINT16)~((UINT16)0))
#define MAXINT16    ((INT16)(MAXUINT16 >> 1))
#define MININT16    ((INT16)~MAXINT16)

#define MAXUINT32   ((UINT32)~((UINT32)0))
#define MAXINT32    ((INT32)(MAXUINT32 >> 1))
#define MININT32    ((INT32)~MAXINT32)

#define MAXUINT64   ((UINT64)~((UINT64)0))
#define MAXINT64    ((INT64)(MAXUINT64 >> 1))
#define MININT64    ((INT64)~MAXINT64)

#define MAXULONG32  ((ULONG32)~((ULONG32)0))
#define MAXLONG32   ((LONG32)(MAXULONG32 >> 1))
#define MINLONG32   ((LONG32)~MAXLONG32)

#define MAXULONG64  ((ULONG64)~((ULONG64)0))
#define MAXLONG64   ((LONG64)(MAXULONG64 >> 1))
#define MINLONG64   ((LONG64)~MAXLONG64)

#define MAXULONGLONG ((ULONGLONG)~((ULONGLONG)0))
#define MINLONGLONG ((LONGLONG)~MAXLONGLONG)

#define MAXSIZE_T   ((SIZE_T)~((SIZE_T)0))
#define MAXSSIZE_T  ((SSIZE_T)(MAXSIZE_T >> 1))
#define MINSSIZE_T  ((SSIZE_T)~MAXSSIZE_T)

#define MAXUINT     ((UINT)~((UINT)0))
#define MAXINT      ((INT)(MAXUINT >> 1))
#define MININT      ((INT)~MAXINT)

#define MAXDWORD32  ((DWORD32)~((DWORD32)0))
#define MAXDWORD64  ((DWORD64)~((DWORD64)0))


typedef enum {
    noState,//初始状态
    noused,//未使用子句
    used,//已使用子句
    noPiredSingle,//没有互补对单元子句
    PiredSingle,//有互补对单元子句
    CopyTemp,//拷贝的子句
} ClaState;
typedef enum {
    noSt,
    isCon,
    isShareVar,
    isSingleVar,
} termState;

//
/*演绎过后，三角形份的四种情形*/
enum FORMTRI {
    FLATNOLIT/*平顶，三角形上方没有文字*/, FLATHAVELIT/*平顶，三角形上方有文字*/, SPIRENOLIT/*尖顶，三角形上方没有文字*/, SPIREHAVELIT/*尖顶，三角形上方有文字*/
};

#define P_SPLIT_CAHR '+'  //分隔符
#define Id_SPLIT_CAHR ' '  //分隔符
#define litWeight 5 //当新子句文字与目标子句不能互补对时,初始文字目标距离
#define litSize 8
#endif /* DATATYPEDEF_H */

