/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   Unify.h
 * Author: sjg
 *
 * Created on 2016年11月27日, 上午9:34
 */

#ifndef UNIFY_H
#define UNIFY_H
#include "FileOp.h"
#include "Term.h"
#include "Clause.h"
#include "Literal.h"
#include "StrategyParam.h"
#include "dataTypeDef.h"
#include "globalFunc.h"
#include "Formula.h"
class Unify {
public:
    vector<Term*> vVarBindT; //变元绑定列表
    vector<Literal*>*vOutTri; //存放演绎文字
    vector<Literal*>* vOnlyOutTri; //存放单纯的对角线文字
    UINT32 singleClaNum; //记录单文字子句的大小
    vector<Literal*>*vNewR; //存放剩余文字	

    vector<Literal*>*vOnlyOutDect; //记录演绎路径，单元子句
    
    vector<Literal*>* vOnlyDectNum; //记录本次演绎的互补对单元子句
    vector<Clause*>* saveCopyCla; 
    set<UINT32>* hasCpUintClaId; //记录已经拷贝的单元子句
    /***********************************************
    /*构造\析构函数
    /***********************************************/
    Unify(UINT32 _singleClaNum, vector<Literal*>* _vOnlyOutTri, vector<Literal*>*_vOutTri, vector<Literal*>*_vNewR,vector<Literal*>*_vOnlyOutDect,vector<Literal*>* _vOnlyDectNum,vector<Clause*>* _saveCopyCla,set<UINT32>* _hasCpUintClaId) : singleClaNum(_singleClaNum), vOnlyOutTri(_vOnlyOutTri), vOutTri(_vOutTri), vNewR(_vNewR) ,vOnlyOutDect(_vOnlyOutDect),vOnlyDectNum(_vOnlyDectNum),saveCopyCla(_saveCopyCla),hasCpUintClaId(_hasCpUintClaId){
    }

    Unify();
    Unify(const Unify& orig);
    virtual ~Unify();

    /***********************************************
        /*方法 函数
        /***********************************************/
    //获取变元替换

    inline Term* GetBindingT(Term* t) {
        while (t->vBinding)
            t = t->vBinding;
        return t;
    }
    //冲突检查
    bool OccurCheck(Term* tVar, Term* tChg, vector<Term*>& varChgOnce);
    bool OccurCheckModul(Term* tVar, Term* tChg, vector<Term*>& varChgOnce);
    //合一算法
    bool TermMgu(Term* termA, Term* termB, vector<Term*>& varChgOnce);
    bool pairFuncTermMgu(Term* termA, Term* termB, vector<Term*>& varChgOnce);
    
    bool LitMgu(Literal* litA, Literal* litB, vector<Term*>& varChgOnce);
    bool LitMguBak(Literal* litA, Literal* litB, vector<Term*>& varChgOnce);
    //检查varLit 是否可以找到一个替换与conLit 相同	  varBind - Term* 数组用来存储变元的绑定
    bool Match(Literal* conLit, Literal* varLit, Term** varBind, vector<UINT32>&ChgVarId);
    bool RMatch(Literal* conLit, Literal* varLit);
    bool isRedundancy(Clause* cla);
    RESULT Issyn(Literal* litA, Literal* candLit);
    RESULT IssynLR(Literal* litA, Literal* candLit);
    RESULT IssynLRLimit(Literal* litA, Literal* candLit);
    RESULT Issyn_find(Literal* litA, Literal* candLit,UINT16 &leftLit);
    //检查等词是否恒真
    bool CheckEqn(Term*t1, Term* t2);
    bool CheckEqnR(Term*t1, Term* t2);
    bool CheckPairEqn(Term*t1, Term* t2);
    RESULT RuleCheck(Literal* queryLit, Literal& candLit, vector<Literal*> &vLeftLit);
    RESULT RuleCheckLR(Literal* queryLit, Literal& candLit, vector<Literal*> &vLeftLit);
    RESULT RuleCheckLRLimit(Literal* queryLit, Literal& candLit, vector<Literal*> &vLeftLit);
    RESULT RuleCheck_find(Literal* queryLit, Literal& candLit, vector<Literal*> &vLeftLit);
    bool CheckMaxFuncLayer(const Literal& lit, UINT32& litVarCount);
    void ClearVarBind(vector<Term*>& chgVarT);

    //检查是否存在一个文字能通过替换与conLit相同
    bool RSubsumption(Literal* conLit);

    void countVTerm(Term* term,UINT32 &count);
    //根据OldTerm
    Term* GetNewTerm(Term* oldT, Clause* newCla);
    Term* GetCopyTerm(Term* oldT, Clause* newCla);
    RESULT Issyn_two(Formula& fol, Literal* litA, Literal* candLit);
    RESULT Issyn_Findtwo(Formula& fol,Literal* litA, Literal* candLit,UINT16& tempLit);
    RESULT RuleCheck_two(Formula& fol, Literal* queryLit, Literal& candLit);
    RESULT RuleCheck_FindTwo(Formula& fol,Literal* queryLit, Literal& candLit,vector<Literal*>& vLeftLitAll) ;
    //20170901 以下用于等词处理
    bool TermMguEqn(Term* termA, Term* termB, vector<Term*>& varChgOnce, vector<Term*>& varChgOnceEqn);
    bool pairFuncTermMguEqn(Term* termA, Term* termB, vector<Term*>& varChgOnce,  vector<Term*>& varChgOnceEqn);
    bool litASmallLitB(Term* termA, Term* termB, vector<Term*>& varChgOnce);
    Term* GetNewTermSuper(Term* oldT, Clause* newCla);
    Clause* copyUintCla(Formula& fol, Clause* orgUnitCla, UINT32& uNewClaID);//拷贝单元子句
    /**********************************************
     *输出
     **********************************************/
    //将替换后的文字项输出为字符串

    void WriteTriPath(Literal* lit) {
        //20170822 add
        if(!(lit->claPtr->isUse))
            lit->claPtr->isUse = true;
        
        if (StrategyParam::orForCompition == false) {
            string str;
            str = "[C" + to_string(lit->Row()) + "_" + to_string(lit->Col()) + "]";
            TermToString(lit->subTerm, str);  
            //lit->subTerm->Print();
            FileOp::WriteTriPath(str);
            //cout<<str<<endl;
        }
    }
    
    //将替换后的文字项输出为字符串

    void WriteCopyPath(Literal* lit) {
        //20170822 add
        if(!(lit->claPtr->isUse))
            lit->claPtr->isUse = true;
        //
        string str;
       // if (1 == lit->claPtr->uLitNum)
            //str = "[C" + to_string(lit->Row()) + "]";
        //else
        if (!StrategyParam::orForCompition) {
            str = "[C" + to_string(lit->Row()) + "_" + to_string(lit->Col()) + "]";
            CopyTermToString(lit->subTerm, str);  
            //lit->subTerm->Print();
            FileOp::WriteTriPath(str);
            //cout<<str<<endl;
        }
    }
    //参数1：谓词项指针  参数2：字符串对象

    void TermToOutString(Term* term, string& str) {
        //cout<<"debug"<<endl;
        //Term* term = GetBindingT(termOri);
        if (term->iTermCode < 0) {
            if (term->vBinding == nullptr)//不存在替换项
                str += "x" + to_string((term->iTermCode >> 8) & 0x7FFFFF) + to_string(term->iTermCode & 0xFF);
            else {
                //cout << "debug" << endl;
                const UINT32 uId = GetCodeId(term->vBinding->iTermCode);
                INT32 iCodeProp = GetCodeProp(term->vBinding->iTermCode);
                switch (iCodeProp) {
                    case TCon:
                        str += "a" + (uId == 0 ? "" : to_string(uId));
                        break;
                    case TPred:
                        str += "P" + (uId == 0 ? "" : to_string(uId)) + "(";
                        break;
                    case TNegPred:
                        str += "~P" + (uId == 0 ? "" : to_string(uId)) + "(";
                        break;
                    case TEqn:
                        str += "E" + (uId == 0 ? "" : to_string(uId)) + "(";
                        break;
                    case TNegEqn:
                        str += "~E" + (uId == 0 ? "" : to_string(uId)) + "(";
                        break;
                    case TFunc:
                        str += "f" + (uId == 0 ? "" : to_string(uId)) + "(";
                        term = term->vBinding;
                        break;
                }

            }
        } else {
            const UINT32 uId = GetCodeId(term->iTermCode);
            INT32 iCodeProp = GetCodeProp(term->iTermCode);
            switch (iCodeProp) {
                case TCon:
                    str += "a" + (uId == 0 ? "" : to_string(uId));
                    break;
                case TPred:
                    str += "P" + (uId == 0 ? "" : to_string(uId)) + "(";
                    break;
                case TNegPred:
                    str += "~P" + (uId == 0 ? "" : to_string(uId)) + "(";
                    break;
                case TEqn:
                    str += "E" + (uId == 0 ? "" : to_string(uId)) + "(";
                    break;
                case TNegEqn:
                    str += "~E" + (uId == 0 ? "" : to_string(uId)) + "(";
                    break;
                case TFunc:
                    str += "f" + (uId == 0 ? "" : to_string(uId)) + "(";
                    break;
            }
        }
        for (UINT16 i = 0; i < term->uSubTermNum; ++i) {
            TermToString(term->subTermPtr[i], str);
            if (i < term->uSubTermNum - 1)
                str += ",";
            else
                str += ")";
        }

        //if (0 < term->uSubTermNum)
        //str = str.erase(str.length() - 1) + ")"; //删除最后一个"，"

    }

    void TermToString(Term* term, string& str) {
        term = GetBindingT(term);
        if (term->iTermCode < 0)
            str += "x" + to_string((term->iTermCode >> 8) & 0x7FFFFF) + to_string(term->iTermCode & 0xFF);
        else {
            const UINT32 uId = GetCodeId(term->iTermCode);
            INT32 iCodeProp = GetCodeProp(term->iTermCode);
            switch (iCodeProp) {
                case TCon:
                    str += "a" + (uId == 0 ? "" : to_string(uId));
                    break;
                case TPred:
                    str += "P" + (uId == 0 ? "" : to_string(uId)) + "(";
                    break;
                case TNegPred:
                    str += "~P" + (uId == 0 ? "" : to_string(uId)) + "(";
                    break;
                case TEqn:
                    str += "E" + (uId == 0 ? "" : to_string(uId)) + "(";
                    break;
                case TNegEqn:
                    str += "~E" + (uId == 0 ? "" : to_string(uId)) + "(";
                    break;
                case TFunc:
                    str += "f" + (uId == 0 ? "" : to_string(uId)) + "(";
                    break;
            }
        }
        for (UINT16 i = 0; i < term->uSubTermNum; ++i) {
            TermToString(term->subTermPtr[i], str);
            if (i < term->uSubTermNum - 1)
                str += ",";
            else
                str += ")";
        }

        //if (0 < term->uSubTermNum)
        //str = str.erase(str.length() - 1) + ")"; //删除最后一个"，"

    }
    
    void CopyTermToString(Term* term, string& str) {
        //term = GetBindingT(term);
        if (term->iTermCode < 0)
            str += "x" + to_string((term->iTermCode >> 8) & 0x7FFFFF) + to_string(term->iTermCode & 0xFF);
        else {
            const UINT32 uId = GetCodeId(term->iTermCode);
            INT32 iCodeProp = GetCodeProp(term->iTermCode);
            switch (iCodeProp) {
                case TCon:
                    str += "a" + (uId == 0 ? "" : to_string(uId));
                    break;
                case TPred:
                    str += "P" + (uId == 0 ? "" : to_string(uId)) + "(";
                    break;
                case TNegPred:
                    str += "~P" + (uId == 0 ? "" : to_string(uId)) + "(";
                    break;
                case TEqn:
                    str += "E" + (uId == 0 ? "" : to_string(uId)) + "(";
                    break;
                case TNegEqn:
                    str += "~E" + (uId == 0 ? "" : to_string(uId)) + "(";
                    break;
                case TFunc:
                    str += "f" + (uId == 0 ? "" : to_string(uId)) + "(";
                    break;
            }
        }
        for (UINT16 i = 0; i < term->uSubTermNum; ++i) {
            CopyTermToString(term->subTermPtr[i], str);
            if (i < term->uSubTermNum - 1)
                str += ",";
            else
                str += ")";
        }

        //if (0 < term->uSubTermNum)
        //str = str.erase(str.length() - 1) + ")"; //删除最后一个"，"

    }
private:

};

#endif /* UNIFY_H */

