/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   Unify.cpp
 * Author: sjg
 * 
 * Created on 2016年11月27日, 上午9:34
 */

#include "Unify.h"
#include "Formula.h"
#include "RedundancyOp.h"
extern map<INT32, vector<INT32>> validPathOut;
Unify::Unify() {
}

Unify::Unify(const Unify& orig) {
}

Unify::~Unify() {
}

//冲突检查

bool Unify::OccurCheck(Term* tVar, Term* tChg, vector<Term*>& varChgOnce) {
    assert(tVar->iTermCode < 0);

    if (tVar == tChg) //两个变元相同不做替换
    {
        assert(tChg->iTermCode < 0);
        return true;
    }
    
    
    if (tChg->uVarCount > 0) //只有非基项函数才进行冲突检查（排除 常元、变元、共享基项）
    {
        Term* t = tChg;
        Term* subT;
        vector<Term*> stack;
        stack.reserve(8);
        do {
            for (UINT8 i = 0; i < t->uSubTermNum; ++i) {
                subT = GetBindingT(t->subTermPtr[i]);
                if (tVar == subT) //变元:获取它的替换项并检查冲突
                {
                    assert(subT->iTermCode < 0);
                    return false;
                }
                if (subT->uSubTermNum > 0 && 0 < subT->uVarCount) {
                    stack.push_back(subT);
                }
            }
            if (stack.empty())
                break;
            t = stack.back();
            stack.pop_back();
        } while (1);
    }
    tVar->vBinding = tChg;
    varChgOnce.push_back(tVar);
    //测试cout << "替换输出"; tVar->Print(); cout << ":"; tChg->Print(); cout << endl;
    return true;

}
bool Unify::OccurCheckModul(Term* tVar, Term* tChg, vector<Term*>& varChgOnce) {
    assert(tVar->iTermCode < 0);

    if (tVar == tChg) //两个变元相同不做替换
    {
        assert(tChg->iTermCode < 0);
        return true;
    }
    if(tChg->isFuncTerm() || tChg->isConTerm()){
        return false;
    }

//    if (tChg->uVarCount > 0) //只有非基项函数才进行冲突检查（排除 常元、变元、共享基项）
//    {
//        Term* t = tChg;
//        Term* subT;
//        vector<Term*> stack;
//        stack.reserve(8);
//        do {
//            for (UINT8 i = 0; i < t->uSubTermNum; ++i) {
//                subT = GetBindingT(t->subTermPtr[i]);
//                if (tVar == subT) //变元:获取它的替换项并检查冲突
//                {
//                    assert(subT->iTermCode < 0);
//                    return false;
//                }
//                if (subT->uSubTermNum > 0 && 0 < subT->uVarCount) {
//                    stack.push_back(subT);
//                }
//            }
//            if (stack.empty())
//                break;
//            t = stack.back();
//            stack.pop_back();
//        } while (1);
//    }
    tVar->vBinding = tChg;
    varChgOnce.push_back(tVar);
    //测试cout << "替换输出"; tVar->Print(); cout << ":"; tChg->Print(); cout << endl;
    return true;

}

//20170812 增加项合一的情况
//termA termB 检查合一的两个项，varChgOnce改变的变元项 
//注:不能两个同时为函数项,两个都为函数项时,单独处理
bool Unify::TermMgu(Term* termA, Term* termB, vector<Term*>& varChgOnce) {
    //定义堆栈用于存储 函数项
//    Term* termA = litA->subTerm;
//    Term* termB = litB->subTerm;
    if (termA == termB)
        return true;

    //cout << "termB:"; termB->Print(); cout << "= ";
    Term* tA;
    Term* tB;

    tA = GetBindingT(termA);
    tB = GetBindingT(termB);
    if (tA == tB) {
        return true;
    }
    if (IsVar(tA)) {
        //cout << "tA:"; tA->Print(); cout << "->"; tB->Print();  cout << endl;
        if (!OccurCheck(tA, tB, varChgOnce))
            return false;
        else
            return true;
    } else if (IsVar(tB)) {
        //cout << "tB:"; tB->Print(); cout << "->"; tA->Print(); cout << endl;
        if (!OccurCheck(tB, tA, varChgOnce))
            return false;
        else
            return true;
    } else if (tA->uVarCount > 0)//非基函数项
    {
        assert(tA->uSubTermNum > 0);

        if (tB->uSubTermNum > 0) //为函数项 非基函数项或共享基函数项
        {
            if (tA->iTermCode != tB->iTermCode) return false;
        } else
            return false;
    } else if (tB->uVarCount > 0)//非基函数项
    {
        assert(tB->uSubTermNum > 0);
        if (tA->uSubTermNum > 0) //为函数项 非基函数项或共享基函数项
        {
            if (tA->iTermCode != tB->iTermCode) return false;
        } else
            return false;
    } else if (tA != tB) {
        assert(tA->uVarCount == 0 && tB->uVarCount == 0);
        return false;
    }
    //如果两个都是函数项的情况
    return false;
}

bool Unify::pairFuncTermMgu(Term* termA, Term* termB, vector<Term*>& varChgOnce) {
    //定义堆栈用于存储 函数项
    if (termA == termB)
        return true;

    //cout << "termB:"; termB->Print(); cout << "= ";
    vector<Term*> stactTerm;
    Term* tA;
    Term* tB;
    UINT8 i;//UINT8
    do {
        if ((termA->uSubTermNum != termB->uSubTermNum) || (termA->iTermCode != termB->iTermCode)) 
            return false;
        i = 0;
        while (i < termA->uSubTermNum) 
        {
            tA = GetBindingT(termA->subTermPtr[i]);
            tB = GetBindingT(termB->subTermPtr[i]);
            if (tA == tB) {
                ++i;
                continue;
            }
            if (IsVar(tA)) {
                //cout << "tA:"; tA->Print(); cout << "->"; tB->Print();  cout << endl;
                if (!OccurCheck(tA, tB, varChgOnce))
                    return false;
            } 
            else if (IsVar(tB)) {
                //cout << "tB:"; tB->Print(); cout << "->"; tA->Print(); cout << endl;
                if (!OccurCheck(tB, tA, varChgOnce))
                    return false;
            }
            else if (tA->uVarCount > 0)//非基函数项
            {
                assert(tA->uSubTermNum > 0);

                if (tB->uSubTermNum > 0) //为函数项 非基函数项或共享基函数项
                {
                    if (tA->iTermCode != tB->iTermCode) return false;
                    stactTerm.push_back(tA);
                    stactTerm.push_back(tB);
                } else
                    return false;
            } 
            else if (tB->uVarCount > 0)//非基函数项
            {
                assert(tB->uSubTermNum > 0);
                if (tA->uSubTermNum > 0) //为函数项 非基函数项或共享基函数项
                {
                    if (tA->iTermCode != tB->iTermCode) return false;
                    stactTerm.push_back(tA);
                    stactTerm.push_back(tB);
                } else
                    return false;
            } 
            else if (tA != tB) {
                assert(tA->uVarCount == 0 && tB->uVarCount == 0);
                return false;
            }
            ++i;
        }
        if (stactTerm.empty())break;
        termB = stactTerm.back();
        stactTerm.pop_back();
        termA = stactTerm.back();
        stactTerm.pop_back();
        assert(termA->iTermCode == termB->iTermCode);
    } while (1);
    return true;
}
//20171102
//litA litB 检查合一的两个文字，varChgOnce改变的变元项 

bool Unify::LitMguBak(Literal* litA, Literal* litB, vector<Term*>& varChgOnce) {
    //定义堆栈用于存储 函数项
    Term* termA = litA->subTerm;
    Term* termB = litB->subTerm;
    if (termA == termB)
        return true;

    //cout << "termB:"; termB->Print(); cout << "= ";
    vector<Term*> stactTerm;
    Term* tA;
    Term* tB;
    UINT8 i;//UINT8
    do {
        if (termA->uSubTermNum != termB->uSubTermNum) 
            return false;
        i = 0;
        while (i < termA->uSubTermNum) 
        {
            tA = GetBindingT(termA->subTermPtr[i]);
            tB = GetBindingT(termB->subTermPtr[i]);
            if (tA == tB) {
                ++i;
                continue;
            }
            if (IsVar(tA)) {
                //cout << "tA:"; tA->Print(); cout << "->"; tB->Print();  cout << endl;
                if (!OccurCheck(tA, tB, varChgOnce))
                    return false;
            } 
            else if (IsVar(tB)) {
                //cout << "tB:"; tB->Print(); cout << "->"; tA->Print(); cout << endl;
                if (!OccurCheck(tB, tA, varChgOnce))
                    return false;
            }
            else if (tA->uVarCount > 0)//非基函数项
            {
                assert(tA->uSubTermNum > 0);

                if (tB->uSubTermNum > 0) //为函数项 非基函数项或共享基函数项
                {
                    if (tA->iTermCode != tB->iTermCode) return false;
                    stactTerm.push_back(tA);
                    stactTerm.push_back(tB);
                } else
                    return false;
            } 
            else if (tB->uVarCount > 0)//非基函数项
            {
                assert(tB->uSubTermNum > 0);
                if (tA->uSubTermNum > 0) //为函数项 非基函数项或共享基函数项
                {
                    if (tA->iTermCode != tB->iTermCode) return false;
                    stactTerm.push_back(tA);
                    stactTerm.push_back(tB);
                } else
                    return false;
            } 
            else if (tA != tB) {
                assert(tA->uVarCount == 0 && tB->uVarCount == 0);
                return false;
            }
            ++i;
        }
        if (stactTerm.empty())break;
        termB = stactTerm.back();
        stactTerm.pop_back();
        termA = stactTerm.back();
        stactTerm.pop_back();
        assert(termA->iTermCode == termB->iTermCode);


    } while (1);
    return true;
}
//20170812

//合一算法  不检查谓词符号是否 互补或一致 由调用方法确定
//litA litB 检查合一的两个文字，varChgOnce改变的变元项 

bool Unify::LitMgu(Literal* litA, Literal* litB, vector<Term*>& varChgOnce) {
    //定义堆栈用于存储 函数项
    Term* termA = litA->subTerm;
    Term* termB = litB->subTerm;
    if (termA == termB)
        return true;
    
//    bool litAFlagUint = false;
//    bool litBFlagUint = false;
    
    //cout << "termB:"; termB->Print(); cout << "= ";
    vector<Term*> stactTerm;
    Term* tA;
    Term* tB;
    UINT8 i;//UINT8
    do {
        if (termA->uSubTermNum != termB->uSubTermNum) 
            return false;
        i = 0;
        while (i < termA->uSubTermNum) 
        {
            tA = GetBindingT(termA->subTermPtr[i]);
            tB = GetBindingT(termB->subTermPtr[i]);
            if (tA == tB) {
                ++i;
                continue;
            }
            if (IsVar(tA)) {
                //cout << "tA:"; tA->Print(); cout << "->"; tB->Print();  cout << endl;
                if (!OccurCheck(tA, tB, varChgOnce))
                    return false;
            } 
            else if (IsVar(tB)) {
                //cout << "tB:"; tB->Print(); cout << "->"; tA->Print(); cout << endl;
                if (!OccurCheck(tB, tA, varChgOnce))
                    return false;
            }
            else if (tA->uVarCount > 0)//非基函数项
            {
                assert(tA->uSubTermNum > 0);

                if (tB->uSubTermNum > 0) //为函数项 非基函数项或共享基函数项
                {
                    if (tA->iTermCode != tB->iTermCode) return false;
                    stactTerm.push_back(tA);
                    stactTerm.push_back(tB);
                } else
                    return false;
            } 
            else if (tB->uVarCount > 0)//非基函数项
            {
                assert(tB->uSubTermNum > 0);
                if (tA->uSubTermNum > 0) //为函数项 非基函数项或共享基函数项
                {
                    if (tA->iTermCode != tB->iTermCode) return false;
                    stactTerm.push_back(tA);
                    stactTerm.push_back(tB);
                } else
                    return false;
            } 
            else if (tA != tB) {
                assert(tA->uVarCount == 0 && tB->uVarCount == 0);
                return false;
            }
            ++i;
        }
        if (stactTerm.empty())break;
        termB = stactTerm.back();
        stactTerm.pop_back();
        termA = stactTerm.back();
        stactTerm.pop_back();
        assert(termA->iTermCode == termB->iTermCode);


    } while (1);
    return true;
}

//算法思路：若查找子句能通过候选子句通过替换变成子集形式，在查找子句为冗余子句，且不考虑查找子句替换为候选子句
//参数1：检查子句的第一个文字指针；参数2：被测的子句的第一个文字指针；参数3:被测子句含变元个数的项指针数组；参数4：整形vector，记录被改变的变元项
//检查varLit 是否可以找到一个替换与conLit 相同	  chgVarT - 记录被改变的变元项
//参数1：查找子句的文字 参数2：候选子句的文字 参数3 存放候选子句的变元替换项的指针数组 参数4：整形数组，记录候选文字中变元的替换项列号
bool Unify::Match(Literal* conLit, Literal* varLit, Term** varBind, vector<UINT32>&ChgVarId) {
    //if (conLit->subTerm == varLit->subTerm) return true;
    //if (varLit->subTerm->uMaxVarId == 0) return false; //不包含变元则为基函数项，即varLit是基项，但conLit是非基项

    if (conLit->subTerm->iTermCode != varLit->subTerm->iTermCode)//谓词不相等
        return false;
    //堆栈记录非共享变元项
    vector<Term*> stactTerm;
    UINT8 i;
    //若conLit==varLit，要么是同一个子句中文字项，要么是共享基函数项
    Term* conTerm = conLit->subTerm; //查找子句的文字谓词项
    Term* varTerm = varLit->subTerm; //候选子句的文字谓词项
    UINT32 uVarClaId = varLit->claPtr->uClaId; //候选子句的编号
    Term* varT;
    Term* conT;
    UINT32 varId;
    //检查:遍历IchgCode 所代表的项；常元或共享项 直接替换varLst[i]
    do {
        i = 0;
        while (i < varTerm->uSubTermNum)//依次取候选子句的第一个文字的项
        {
            varT = varTerm->subTermPtr[i]; //依次取候选子句的文字的各个项
            conT = conTerm->subTermPtr[i]; ////依次取查找子句的文字的各个项
            
            //debug
//            if(conLit->claPtr->uClaId == 28 && varLit->claPtr->uClaId == 26){
//                conT->Print();
//                varT->Print();
//            }
            
            if (IsVar(varT) && GetVarRow(varT->iTermCode) == uVarClaId)//因为变元做了重新命名，所有在不同子句不存在相同的变元项，若候选子句对应文字对应的项是变元
            {
                varId = GetVarId(varT->iTermCode) - 1; //候选子句文字的项是变元列号-1，用于记录变元替换
                if (varBind[varId]) //文字中已有相同变元有绑定，则直接按绑定的项替换
                {
                    varT = varBind[varId]; //若取候子句变元项被替换，则需要全部替换
                } else//变元无绑定
                {
                    varBind[varId] = conT; //记录取候子句文字中变元项对应的替换项
                    ChgVarId.push_back(varId); //记录取候子句文字替换的变元
                    ++i;
                    continue;
                }
            }

            if (varT == conT)//若项相同
            {
                ++i;
                continue;
            }

            if (varT->uSubTermNum > 0 && varT->uVarCount > 0) //varT为非共享变元项压栈，候选子句的文字对应项为带变元函数项
            {
                if (0 == conT->uSubTermNum) //非函数项
                    return false;
                stactTerm.push_back(varT); //函数项入栈
                stactTerm.push_back(conT); //检查项入栈
            } else
                return false;
            ++i;
        }
        if (stactTerm.empty())break;
        conTerm = stactTerm.back();
        stactTerm.pop_back();
        varTerm = stactTerm.back();
        stactTerm.pop_back();
        if (conTerm->iTermCode != varTerm->iTermCode) {
            return false;
        }
    } while (1);
    return true;
}
//检查是否存在一个文字能通过替换与conLit相同
bool Unify::RMatch(Literal* conLit, Literal* varLit) {
    if (conLit->subTerm == varLit->subTerm) return true;

    if (varLit->subTerm->uMaxVarId == 0) return false; //不包含变元则为基函数项


    if (conLit->subTerm->iTermCode != varLit->subTerm->iTermCode)
        return false;
    //堆栈记录非共享变元项
    vector<Term*> stactTerm;
    UINT8 i;
    //若conLit==varLit，要么是同一个子句中文字项，要么是共享基函数项
    Term* conTerm = conLit->subTerm;
    Term* varTerm = varLit->subTerm;
    UINT32 uVarClaId = varLit->claPtr->uClaId;
    UINT32 varId;
    Term** varBind = new Term*[varTerm->uMaxVarId]; //初始化一个变量替换数组		
    memset(varBind, 0, sizeof (Term*)*(varTerm->uMaxVarId)); //所有指针设置为null 

    //检查:遍历IchgCode 所代表的项；常元或共享项 直接替换varLst[i]
    do {
        i = 0;
        while (i < varTerm->uSubTermNum) {
            Term* varT = varTerm->subTermPtr[i];
            Term* conT = GetBindingT(conTerm->subTermPtr[i]);

            //varT->Print(); cout << endl; conT->Print(); cout << endl;
            if (IsVar(varT) && GetVarRow(varT->iTermCode) == uVarClaId) {
                varId = GetVarId(varT->iTermCode) - 1;
                if (varBind[varId]) //变元有绑定
                {
                    varT = varBind[varId];
                } else//变元无绑定
                {
                    varBind[varId] = conT;
                    ++i;
                    continue;
                }
            }
            if (varT->uVarCount > 0 && varT->uSubTermNum > 0) //varT为非共享变元项压栈
            {
                if (0 == conT->uSubTermNum) //非函数项
                {
                    delete[]varBind;
                    return false;
                }
                stactTerm.push_back(varT);
                stactTerm.push_back(conT);
            } else if (varT != conT) {
                delete[]varBind;
                return false;
            }
            ++i;
        }
        if (stactTerm.empty())break;
        conTerm = stactTerm.back();
        stactTerm.pop_back();
        varTerm = stactTerm.back();
        stactTerm.pop_back();
        if (conLit->subTerm == varLit->subTerm) return true;
        if (varLit->subTerm->uMaxVarId == 0) return false; //不包含变元则为基函数项
        if (conTerm->iTermCode != varTerm->iTermCode) {
            delete[]varBind;
            //assert(conLit->subTerm->uSubTermNum != varLit->subTerm->uSubTermNum);
            return false;
        }
    } while (1);
    delete[]varBind;
    return true;
}
//20171102 拷贝单元子句
Clause* Unify::copyUintCla(Formula& fol, Clause* orgUnitCla, UINT32& uNewClaID) {
    if(orgUnitCla->uLitNum != 1)
        return nullptr;
    Clause* cla = nullptr;
    if (orgUnitCla->topCopyCla == nullptr)
        cla = orgUnitCla;
    else
        cla = orgUnitCla->topCopyCla;
    if (1) {
        Clause* newClause = new Clause(uNewClaID, 0);
        size_t uRsize = cla->uLitNum;
        newClause->LitPtr = new Literal*[uRsize];
        //Literal* realCopyTo = nullptr;
        for (UINT16 i = 0; i < cla->uLitNum; ++i) {
            Term* litSubT = GetCopyTerm(cla->LitPtr[i]->subTerm, newClause); //参数1：文字谓词项，参数2：新子句指针
//            if (TNegEqn == GetCodeProp(litSubT->iTermCode)
//                    && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {
//                /*
//                delete(litSubT);*/
//                //--uRsize;
//                //delete(newCla->LitPtr[]);
//                continue;
//            }
            if (newClause->uFuncDepth < litSubT->uLevel)newClause->uFuncDepth = litSubT->uLevel;
            newClause->uVarCount += litSubT->uVarCount;
            //添加到文字		
            newClause->LitPtr[newClause->uLitNum] = new Literal(litSubT, EncodeLitCode(uNewClaID, newClause->uLitNum + 1), newClause, nullptr);
            newClause->LitPtr[newClause->uLitNum]->parentLitPtr = cla->LitPtr[i]; //母式文字，有R产生

            //newCla->LitPtr[newCla->uLitNum]->goalDeepth = vInsertNewR[i]->goalDeepth;
            //20171020 计算演绎深度
            newClause ->deduceDeepth = cla->deduceDeepth;
            newClause->LitPtr[newClause->uLitNum]->goalDeepth = cla->LitPtr[i]->goalDeepth;
//            if (cla->LitPtr[i] == copyTo) {//找到被拷贝子句的演绎文字
//                realCopyTo = newClause->LitPtr[newClause->uLitNum];
//            }
            //cout<<to_string(newCla->uClaId)  + "]" <<"[" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitRow()) + "_" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitCol()) + "]" << newCla->LitPtr[newCla->uLitNum]->subTerm->ToString()<<endl;  
            ++(newClause->uLitNum);
        }
//        if (newClause->uLitNum == 0 && StrategyParam::orForCompition == false) {
//            cout << "error" << endl;
//        }
        newClause->clast = CopyTemp;
        newClause->copyFrom = nullptr;
        newClause->copyTo = nullptr;
        uNewClaID++; //通过归结式记录
        //输出演绎路径
        //FileOp::CreateRunInfoFile(cla->uClaId / 25);
        if (!StrategyParam::orForCompition)
            *FileOp::ofRealInfoOut << "编号为" + to_string(cla->uClaId) + "子句拷贝新子句" << endl;
        for (UINT32 k = 0; k < cla->uLitNum; k++) {
            WriteCopyPath(cla->LitPtr[k]);
        }
        if (!StrategyParam::orForCompition)
            FileOp::WriteR(newClause);
        if (/*StrategyParam::orForCompition*/true) {
            string rStr = "";
            newClause->toString(rStr);
            validPathOut[uNewClaID - 1].push_back(cla->uClaId);
//            int begPos = rStr.find_first_of("[") + 1;
//            int endPos = rStr.find_first_of("]");
//            string rId = rStr.substr(begPos, endPos - begPos);
//            string rContext = rStr.substr(rStr.find_first_of("]") + 1);
//            string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n" + "   inference(rename_variables,[]," + "[" + to_string(cla->uClaId) +"]" + ")).";
//            *FileOp::ofOutput << out << endl;
            
            string cnf_str = newClause->ToStringWithSemantics(rStr);
            size_t pos = cnf_str.find_last_of(')');
            string cnf_str_sub = cnf_str.substr(0, pos);
            string out = cnf_str_sub + ", inference(rename_variables,[],[i_0_" + to_string(cla->uClaId) + "]" + ")).";
            *FileOp::ofOutput << out << endl;
        }
        if (!StrategyParam::orForCompition) {
            string vaildInf = "|[Y]";
            FileOp::RInvaildInfoOut(vaildInf, cla->uClaId / 25);
        }
        fol.InsertCla(newClause);
        if (StrategyParam::useSaturate)
            fol.setDeductCla.insert(newClause);
        else
            fol.setCla.insert(newClause);
        if (find(saveCopyCla->begin(), saveCopyCla->end(), newClause) == saveCopyCla->end()) {
            saveCopyCla->push_back(newClause);
        }
        newClause->topCopyCla = cla;
        //将拷贝的子句插入到主对角线上
        vector<Literal*>::iterator insertInd= find(vOnlyOutTri->begin(),vOnlyOutTri->end(),orgUnitCla->LitPtr[0]);
        vOnlyOutTri->insert(insertInd+1,newClause->LitPtr[0]);
        vector<Literal*>::iterator insertIndOut= find(vOutTri->begin(),vOutTri->end(),orgUnitCla->LitPtr[0]);
        vOutTri->insert(insertIndOut+1,newClause->LitPtr[0]);
        return newClause;
    }
}

//20170210 函数用于遍历查找最优的候选子句使用
RESULT Unify::Issyn_find(Literal* litA, Literal* candLit,UINT16 &leftLit) {
    //20170210 当为遍历候选子句集时，此时需要清空上次候选子句合一时的替换项 理清候选顺序
    //if(!vVarBindT.empty())
        //ClearVarBind(vVarBindT);
    //20170210 继续存储本次合一替换项
    vVarBindT.clear();
    //vOnlyOutDect->clear();//没有找到合一，此处应清空
    //单次合一的变元替换项
    vector<Term*> varChgOnce;
    RESULT res = NOMGU;
    if (!LitMgu(litA, candLit, varChgOnce)) {
        ClearVarBind(varChgOnce);
        vector<Term*>().swap(varChgOnce);
        return res;//不能合一，返回
    }
    if(isRedundancy(candLit->claPtr)){
        ClearVarBind(varChgOnce);
        vector<Term*>().swap(varChgOnce);
        return res;//不能合一，返回
    }
    //合一成功
    //测试 合一后替换输出
    //cout<<"111***:"<<candLit->claPtr->uClaId<<endl;
    /*for (auto&t : varChgOnce)
    {
    cout << "规则检查前合一情况： "; t->Print(); cout << "->"; GetBindingT(t)->Print(); cout << endl;
    }*/
    /*规则检查*/
    vector<Literal*> vLeftLit;
    res = RuleCheck_find(litA, *candLit, vLeftLit);
    //if(vLeftLit.size() == 0 && vNewR->size())
   // {
     //   return UNSAT;
    //}
    if (res != RULEOK) {
        /*合一失败 清除所有替换*/
        if (!varChgOnce.empty())
            ClearVarBind(varChgOnce);
        ClearVarBind(vVarBindT);
        return res;
    }
    //cout<<"111***:"<<candLit->claPtr->uClaId<<endl;
    if (!varChgOnce.empty()){
        vVarBindT.insert(vVarBindT.end(), varChgOnce.begin(), varChgOnce.end());
        varChgOnce.clear();
    }
    //for(auto &termP: vVarBindT)
    //{
      //  *FileOp::ofRealInfoOut<<"替换文字"<<(termP->ToStringBind())<<endl;
    //}
    //cout<<vVarBindT.size()<<endl;
    //测试 规则检查后替换输出
    /*for (auto&t : vVarBindT)
    {
    cout << "规则检查后合一情况： "; t->Print(); cout << "->"; GetBindingT(t)->Print(); cout << endl;
    }*/
    leftLit = vLeftLit.size();
     if(!vVarBindT.empty())
        ClearVarBind(vVarBindT);
    
    return res;

}
//20170910 判断子句是否是恒真式
bool Unify::isRedundancy(Clause* cla) {
    vector<string> strLit;
    strLit.reserve(6);
    string str;
    for (int m = 0; m < cla->uLitNum; ++m) {
        str = "";
        TermToString(cla->LitPtr[m]->subTerm, str);
        strLit.push_back(str);
        if(cla->LitPtr[m]->subTerm->isPosEqnTerm()){
            string strLeft = "";
            TermToString(cla->LitPtr[m]->subTerm->subTermPtr[0], strLeft);
            string strRight = "";
            TermToString(cla->LitPtr[m]->subTerm->subTermPtr[1], strRight);
            if(strLeft == strRight)
                return true;
        }
        
    }
    if (strLit.size() > 1) {//需要判断是否时恒真式
        if (RedundancyOp::CheckTautology(strLit)) {
            strLit.clear();
            vector<string>().swap(strLit);
            return true;
        }
    }
    return false;
}

//对两个文字进行协调检查 
//核心：合一算法，参数1：主动归结文字指针；参数2：被动归结文字指针
RESULT Unify::Issyn(Literal* litA, Literal* candLit) {
    vVarBindT.clear();
    vOnlyOutDect->clear();//没有找到合一，此处应清空
    vOnlyDectNum->clear();//互补对单元子句清空
   
    
    //单次合一的变元替换项
    vector<Term*> varChgOnce;
    varChgOnce.reserve(8);
    RESULT res = NOMGU;
    if (!LitMgu(litA, candLit, varChgOnce)) {
        ClearVarBind(varChgOnce);
        vector<Term*>().swap(varChgOnce);
        return res;//不能合一，返回
    }
    if(isRedundancy(candLit->claPtr)){
        ClearVarBind(varChgOnce);
        vector<Term*>().swap(varChgOnce);
        return res;//不能合一，返回
    }
    //20170910 判断candLit对应的子句是否是恒真式
    
    //合一成功
    //测试 合一后替换输出
    //cout<<"111***:"<<candLit->claPtr->uClaId<<endl;
    /*for (auto&t : varChgOnce)
    {
    cout << "规则检查前合一情况： "; t->Print(); cout << "->"; GetBindingT(t)->Print(); cout << endl;
    }*/
    /*规则检查*/
    vector<Literal*> vLeftLit;
    res = RuleCheck(litA, *candLit, vLeftLit);
    //if(vLeftLit.size() == 0 && vNewR->size())
   // {
     //   return UNSAT;
    //}
    if (res != RULEOK) {
        /*合一失败 清除所有替换*/
        if (!varChgOnce.empty()){
            ClearVarBind(varChgOnce);
            vector<Term*>().swap(varChgOnce);
        }
        ClearVarBind(vVarBindT);
        return res;
    }
    //cout<<"111***:"<<candLit->claPtr->uClaId<<endl;
    if (!varChgOnce.empty())
        vVarBindT.insert(vVarBindT.end(), varChgOnce.begin(), varChgOnce.end());
    //for(auto &termP: vVarBindT)
    //{
      //  *FileOp::ofRealInfoOut<<"替换文字"<<(termP->ToStringBind())<<endl;
    //}
    //cout<<vVarBindT.size()<<endl;
    //测试 规则检查后替换输出
    /*for (auto&t : vVarBindT)
    {
    cout << "规则检查后合一情况： "; t->Print(); cout << "->"; GetBindingT(t)->Print(); cout << endl;
    }*/
    return res;

}

//20170915 从左到右的合一检查
//对两个文字进行协调检查 
//核心：合一算法，参数1：主动归结文字指针；参数2：被动归结文字指针
RESULT Unify::IssynLR(Literal* litA, Literal* candLit) {
    vVarBindT.clear();
    vOnlyOutDect->clear();//没有找到合一，此处应清空
    vOnlyDectNum->clear();//互补对单元子句清空
   
    
    //单次合一的变元替换项
    vector<Term*> varChgOnce;
    varChgOnce.reserve(8);
    RESULT res = NOMGU;
    if (!LitMgu(litA, candLit, varChgOnce)) {
        ClearVarBind(varChgOnce);
        vector<Term*>().swap(varChgOnce);
        return res;//不能合一，返回
    }
    if(isRedundancy(litA->claPtr)){
        ClearVarBind(varChgOnce);
        vector<Term*>().swap(varChgOnce);
        return res;//不能合一，返回
    }
    //合一成功
    //测试 合一后替换输出
    //cout<<"111***:"<<candLit->claPtr->uClaId<<endl;
    /*for (auto&t : varChgOnce)
    {
    cout << "规则检查前合一情况： "; t->Print(); cout << "->"; GetBindingT(t)->Print(); cout << endl;
    }*/
    /*规则检查*/
    vector<Literal*> vLeftLit;
    res = RuleCheckLR(litA, *candLit, vLeftLit);
    //if(vLeftLit.size() == 0 && vNewR->size())
   // {
     //   return UNSAT;
    //}
    if (res != RULEOK) {
        /*合一失败 清除所有替换*/
        if (!varChgOnce.empty()){
            ClearVarBind(varChgOnce);
            vector<Term*>().swap(varChgOnce);
        }
        ClearVarBind(vVarBindT);
        return res;
    }
    //cout<<"111***:"<<candLit->claPtr->uClaId<<endl;
    if (!varChgOnce.empty())
        vVarBindT.insert(vVarBindT.end(), varChgOnce.begin(), varChgOnce.end());
    //for(auto &termP: vVarBindT)
    //{
      //  *FileOp::ofRealInfoOut<<"替换文字"<<(termP->ToStringBind())<<endl;
    //}
    //cout<<vVarBindT.size()<<endl;
    //测试 规则检查后替换输出
    /*for (auto&t : vVarBindT)
    {
    cout << "规则检查后合一情况： "; t->Print(); cout << "->"; GetBindingT(t)->Print(); cout << endl;
    }*/
    return res;

}

//20210416 limitRule
RESULT Unify::IssynLRLimit(Literal* litA, Literal* candLit) {
    vVarBindT.clear();
    vOnlyOutDect->clear();//没有找到合一，此处应清空
    vOnlyDectNum->clear();//互补对单元子句清空
   
    
    //单次合一的变元替换项
    vector<Term*> varChgOnce;
    varChgOnce.reserve(8);
    RESULT res = NOMGU;
    if (!LitMgu(litA, candLit, varChgOnce)) {
        ClearVarBind(varChgOnce);
        vector<Term*>().swap(varChgOnce);
        return res;//不能合一，返回
    }
    if(isRedundancy(litA->claPtr)){
        ClearVarBind(varChgOnce);
        vector<Term*>().swap(varChgOnce);
        return res;//不能合一，返回
    }
    //合一成功
    //测试 合一后替换输出
    //cout<<"111***:"<<candLit->claPtr->uClaId<<endl;
    /*for (auto&t : varChgOnce)
    {
    cout << "规则检查前合一情况： "; t->Print(); cout << "->"; GetBindingT(t)->Print(); cout << endl;
    }*/
    /*规则检查*/
    vector<Literal*> vLeftLit;
    res = RuleCheckLRLimit(litA, *candLit, vLeftLit);
    //if(vLeftLit.size() == 0 && vNewR->size())
   // {
     //   return UNSAT;
    //}
    if (res != RULEOK) {
        /*合一失败 清除所有替换*/
        if (!varChgOnce.empty()){
            ClearVarBind(varChgOnce);
            vector<Term*>().swap(varChgOnce);
        }
        ClearVarBind(vVarBindT);
        return res;
    }
    //cout<<"111***:"<<candLit->claPtr->uClaId<<endl;
    if (!varChgOnce.empty())
        vVarBindT.insert(vVarBindT.end(), varChgOnce.begin(), varChgOnce.end());
    //for(auto &termP: vVarBindT)
    //{
      //  *FileOp::ofRealInfoOut<<"替换文字"<<(termP->ToStringBind())<<endl;
    //}
    //cout<<vVarBindT.size()<<endl;
    //测试 规则检查后替换输出
    /*for (auto&t : vVarBindT)
    {
    cout << "规则检查后合一情况： "; t->Print(); cout << "->"; GetBindingT(t)->Print(); cout << endl;
    }*/
    return res;

}
//检查两个TERM 是否相同（包含了其中的变元替换）

bool Unify::CheckEqn(Term*t1, Term* t2) {

    t1 = GetBindingT(t1);
    t2 = GetBindingT(t2);
    if (t1 == t2)return true;

    if (t1->iTermCode != t2->iTermCode || t1->uSubTermNum != t2->uSubTermNum) return false;
    Term* subT1;
    Term* subT2;
    vector<Term*> stackT;
    do {

        for (UINT8 i = 0; i < t1->uSubTermNum; ++i) {
            subT1 = GetBindingT(t1->subTermPtr[i]);
            subT2 = GetBindingT(t2->subTermPtr[i]);
            if (subT1->iTermCode != subT2->iTermCode)
                return false;

            if (subT1 == subT2)
                continue;
             if((subT1 ->uVarCount == 0) && (subT2->uVarCount == 0)){
                return false;
            }
            if (subT1->uSubTermNum > 0 && subT2->uSubTermNum > 0) {
                assert(subT1->iTermCode == subT2->iTermCode);
                stackT.push_back(subT1);
                stackT.push_back(subT2);
            } else
                return false;
        }
        if (stackT.empty())break;
        t2 = stackT.back();
        stackT.pop_back();
        t1 = stackT.back();
        stackT.pop_back();

    } while (1);
    return true;
}

//检查两个谓词项是否是互补对
bool Unify::CheckPairEqn(Term*t1, Term* t2) {

    t1 = GetBindingT(t1);
    t2 = GetBindingT(t2);
    //if (t1 == t2)return true;
    INT32 iTermCodeA = t1->iTermCode;
    INT32 iTermCodeB = t2->iTermCode;
    if (TPairPred == GetCodeProp(iTermCodeA) + GetCodeProp(iTermCodeB) && GetCodeId(iTermCodeA) == GetCodeId(iTermCodeB)){
        ;
    }
    else 
        return false;
    if (t1->uSubTermNum != t2->uSubTermNum) return false;
    Term* subT1;
    Term* subT2;
    vector<Term*> stackT;
    do {

        for (UINT8 i = 0; i < t1->uSubTermNum; ++i) {
            subT1 = GetBindingT(t1->subTermPtr[i]);
            subT2 = GetBindingT(t2->subTermPtr[i]);
            if (subT1->iTermCode != subT2->iTermCode)
                return false;

            if (subT1 == subT2)
                continue;
            if((subT1 ->uVarCount == 0) && (subT2->uVarCount == 0)){
                return false;
            }
            if (subT1->uSubTermNum > 0 && subT2->uSubTermNum > 0) {
                assert(subT1->iTermCode == subT2->iTermCode);
                stackT.push_back(subT1);
                stackT.push_back(subT2);
            } else
                return false;
        }
        if (stackT.empty())break;
        t2 = stackT.back();
        stackT.pop_back();
        t1 = stackT.back();
        stackT.pop_back();

    } while (1);
    return true;
}

//判断归结式与最后的中间归结式是否一致,因为变元命名规则不一样,因此需要做处理来比较相等
bool Unify::CheckEqnR(Term*t1, Term* t2) {

    t1 = GetBindingT(t1);
    t2 = GetBindingT(t2);
    if (t1 == t2)return true;

    if (t1->iTermCode != t2->iTermCode || t1->uSubTermNum != t2->uSubTermNum) return false;
    Term* subT1;
    Term* subT2;
    vector<Term*> stackT;
    do {

        for (UINT8 i = 0; i < t1->uSubTermNum; ++i) {
            subT1 = GetBindingT(t1->subTermPtr[i]);
            subT2 = GetBindingT(t2->subTermPtr[i]);
            if ((subT1->iTermCode < 0) && (subT2->iTermCode < 0)) {
                if((subT1->iTermCode & 0xFF) == (subT2->iTermCode & 0xFF)){
                    continue;
                }
            } 
            else if (subT1->iTermCode != subT2->iTermCode)
                return false;

            if (subT1 == subT2)
                continue;
             if((subT1 ->uVarCount == 0) && (subT2->uVarCount == 0)){
                return false;
            }
            if (subT1->uSubTermNum > 0 && subT2->uSubTermNum > 0) {
                assert(subT1->iTermCode == subT2->iTermCode);
                stackT.push_back(subT1);
                stackT.push_back(subT2);
            } else
                return false;
        }
        if (stackT.empty())break;
        t2 = stackT.back();
        stackT.pop_back();
        t1 = stackT.back();
        stackT.pop_back();

    } while (1);
    return true;
}



//20170210 函数用于遍历子句集查找最优候选子句时使用
RESULT Unify::RuleCheck_find(Literal* queryLit, Literal& candLit, vector<Literal*> &vLeftLit) {//参数1：主动归结文字指针；参数2：被动归结文字指针
    //vOnlyOutDect->clear();//20170112 记录主动归结文字，以备规则检查步合要求时，清除用
    Clause *candClaPtr = candLit.claPtr;//被动子句指针
    
    vLeftLit.reserve(candClaPtr->uLitNum);//被动子句文字个数大小
    vector<Term*> chgVarT;//储存替换变元项
    chgVarT.reserve(16);
    bool isUnify;
    Clause* actClaue = queryLit->claPtr;//主动子句指针
    
    //判断合一之后是否超出综合函数复杂度
    if((candClaPtr->compFuncDeepthCla() > StrategyParam::funcFixDeepth) || (actClaue->compFuncDeepthCla() > StrategyParam::funcFixDeepth))
        return fail;

    
    vector<Literal*> vEnqLit;//存放等词文字
    UINT32 queryLitPredCode = queryLit->subTerm->iTermCode;//得到主动文字的谓词项编号
    //处理被动归结子句中的剩余文字
    //1、检查与queryLit合一相同（换下一个可归结文字）
    //2、与vOutTir中对角线文字是否与归结文字合一相同（换下一个可归结文字）
    //3、检查与vnewR 
    //		3.1 是否 合一互补（恒真换下一个文字）
    //		3.2 是否 合一相等（合并）
    //4、函数嵌套是否超过限制(换下一个可归结文字)			注：起步子句剩余文字也需要检查
    //5、基文字检查是否与单文子包含冗余(换下一个可归结文字)	注：起步子句剩余文字也需要检查，P(x)->P(b)
    for (UINT16 i = 0; i < candClaPtr->uLitNum; ++i) {
        Literal* postlit = candClaPtr->LitPtr[i];
        postlit->isDel = 1;//考虑下一次三角形如何变换，是否需要重新初始化20170101
        postlit->isDrop= 0;
        if (postlit == &candLit) {
            postlit->isDrop = 1;
            continue;
        }
        UINT32 ucandlitPredCode = postlit->subTerm->iTermCode;
        isUnify = false;
        ClearVarBind(chgVarT);
        /*
        //0、检查与candLit合一相同
         if (ucandlitPredCode == candLit.subTerm->iTermCode && LitMgu(postlit, &candLit, chgVarT)) {
              isUnify = true;
         }
         if (isUnify)
            continue;
        ClearVarBind(chgVarT);
        */
        //1、检查与queryLit合一相同（换下一个可归结文字）
        //20171029
        //if (ucandlitPredCode == queryLitPredCode && LitMgu(postlit, queryLit, chgVarT)) { 
        if (ucandlitPredCode == queryLitPredCode && CheckEqn(postlit->subTerm, queryLit->subTerm)) {
            //此处处理形如E(x1,x3)+~E(x1,x2)+~E(x2,x3)
            //20170114
            bool unfyEqn = true;
            for (UINT16 tmp = 0; tmp < candClaPtr->uLitNum; tmp++) {
                Literal* posTmp = candClaPtr->LitPtr[tmp];
                if (TNegEqn == GetCodeProp(posTmp->subTerm->iTermCode)) //负文字等词检查是否恒真
                {
                    if (CheckEqn(posTmp->subTerm->subTermPtr[0], posTmp->subTerm->subTermPtr[1])) {
                        //cout<<eqnLit->claPtr->uClaId<<endl;
                        unfyEqn = false;
                        break;
                    }
                }
            }
            //20170114
            ClearVarBind(chgVarT);
            if(unfyEqn)//20170114增加判断
                return TAUTOLOGY;
        }
        ClearVarBind(chgVarT); //不成功删除 变元替换
        //cout<<"111***:"<<candLit.claPtr->uClaId<<endl;
        //20170213检查是否与候选文字可以合并，一定要合并
        //20171029
        //if(ucandlitPredCode == candLit.subTerm->iTermCode && LitMgu(postlit, &candLit, chgVarT))
       if(ucandlitPredCode == candLit.subTerm->iTermCode && ((candLit.subTerm->hasVarOrBindVar() == false) ||(postlit->subTerm->hasVarOrBindVar() == false) ) &&LitMgu(postlit, &candLit, chgVarT))     
        {
            postlit->isDrop = 1;
            vVarBindT.insert(vVarBindT.end(), chgVarT.begin(), chgVarT.end());
            chgVarT.clear();
            continue;
        }
        ClearVarBind(chgVarT); //不成功删除 变元替换
        
         /*检查是否与剩余文字相同*/
        //3、检查被动归结子句的剩余文字之间是否有相同和互补情况 
        for (UINT16 j = i + 1; j < candClaPtr->uLitNum; ++j) {
            Literal* postlitB = candClaPtr->LitPtr[j];
            if (postlitB == &candLit) continue;
            //是否与自己的剩余文字相同 （删除）
            if (ucandlitPredCode == postlitB->subTerm->iTermCode) {
                if (CheckEqn(postlit->subTerm, postlitB->subTerm)) {
                    isUnify = true;
                    break;
                }
            }                //是否与自己的剩余文字互补恒真 （换子句）
            else if (postlit->isPairPred(postlitB)) {
                if (CheckEqn(postlit->subTerm, postlitB->subTerm)) {
                    return TAUTOLOGY;
                }
            }
        }
        if (isUnify)
            continue;
        ClearVarBind(chgVarT);
        
        
        //2.是否与对角线单文字存在合一互补对
        for(auto& clap:(*vOnlyOutTri))
        {
            //20171107 过滤已被拷贝的单元子句
            if((clap->claPtr->uLitNum == 1) && (hasCpUintClaId->find(clap->claPtr->uClaId) != hasCpUintClaId->end())){
                continue;
            }
            if (postlit->isPairPred(clap) && LitMgu(postlit, clap, chgVarT)) {
                //if(!clap->claPtr->isSDeduct)
                    //vOnlyOutDect->push_back(clap);//20170112 记录主动归结文字，以备规则检查不合要求时，清除用
                //clap->claPtr->isSDeduct = true;//20170106 互补文字需要加入演绎路径
                postlit->isDrop = 1;
                vVarBindT.insert(vVarBindT.end(), chgVarT.begin(), chgVarT.end());
                chgVarT.clear();
                isUnify = true;
                break;
            }
            ClearVarBind(chgVarT); //不成功删除 变元替换 20170112
        }
        if(isUnify)
            continue;
        ClearVarBind(chgVarT);
        
       
        //4、检查vnewR中的文字是否与剩余文字相同，相同则删除原有剩余文字
        //检查与前面句剩余文字是否相同\互补--因为 主动归结子句的剩余文字已经放入vNewR中因此直接检查是否与 vNewR中的文字相同或互补即可。
//        for (size_t j = 0; j < vNewR->size(); ++j) {
//            if (ucandlitPredCode == vNewR->at(j)->subTerm->iTermCode)//相同谓词
//            {
//                if (CheckEqn(postlit->subTerm, vNewR->at(j)->subTerm))//与剩余文字相同（合并）				
//                {
//                    //isUnify = true;  //删除剩余文字集中的文字
//                    vNewR->erase(vNewR->begin() + j);
//                    break;
//                }
//            } 
//            else if (postlit->isPairPred(vNewR->at(j))) {
//                if (CheckEqn(postlit->subTerm, vNewR->at(j)->subTerm))//恒真，返回重选被动归结子句
//                {
//                    return TAUTOLOGY;
//                }
//            }
//        }
        UINT32 litVarCount = 0;
        if (!CheckMaxFuncLayer(*postlit, litVarCount)) {
            //函数复合层超过限制，规则检查失败 恢复替换并且换子句 
            //string sMsg = to_string(postlit->Row()) + "_" + to_string(postlit->Col()) + "函数层超过限制";
            //FileOp::LogOut(sMsg);
            //cout<<"函数嵌套超出限制\n";
            return MOREFUNC;
        }
        //20171127 仔细考虑
        if (postlit->subTerm->uMaxVarId > 0 && 0 == litVarCount && RSubsumption(postlit)) //变成常元项 需要检查冗余 和单文字子句检查 
        {
            return RSubsump;
        }
        //将等词放入列表最后来检查
        if (postlit->subTerm->isEqnTerm())
            vEnqLit.push_back(postlit);
        postlit->isDel = 0;
        //cout<<"debug"<<endl;
        vLeftLit.push_back(postlit);
    }

    //检查剩余文字+前面的R是否超过文字限制；
//    if (vLeftLit.size() + vNewR->size() > StrategyParam::R_MAX_NUM + 1)
//        return MORELIT;
    //20170829 动态调整文字数 使得文字数最大的文字能够使用起来,但是必须停止三角形的构建
    
    if (!((candLit.claPtr->uLitNum == StrategyParam::R_INIT_MAX_NUM) && candLit.claPtr->isGoal)) {
        if (vLeftLit.size() + vNewR->size() > StrategyParam::R_MAX_NUM + 1)
            return MORELIT;
    }

    //添加等词恒真规则 
    if (!vEnqLit.empty()) {
        for (auto&eqnLit : vEnqLit) {
            if (TEqn == GetCodeProp(eqnLit->subTerm->iTermCode)) //正文字等词检查是否恒真
            {
                if (CheckEqn(eqnLit->subTerm->subTermPtr[0], eqnLit->subTerm->subTermPtr[1]))
                {   
                    //cout<<eqnLit->claPtr->uClaId<<endl;
                    return EqnTautology;
                }
            }
        }
    }
    //candLit.isDrop = 1;
    return RULEOK;
}

//参数1：主动归结文字指针；参数2：被动归结文字指针
/*规则检查 ，对被动归结子句中剩余文字1、对角线互补；2、第一条对角线元素是否和该轮前面保留的R相等
输出：违反规则返回--false; 规则检查通过返回--ture; */
//主动文字指针，被动文字对象
RESULT Unify::RuleCheck(Literal* queryLit, Literal& candLit, vector<Literal*> &vLeftLit) {//参数1：主动归结文字指针；参数2：被动归结文字指针
    
    vOnlyOutDect->clear();//20170112 记录主动归结文字，以备规则检查步合要求时，清除用
    vOnlyDectNum->clear();//互补对单元子句清空
    
    Clause *candClaPtr = candLit.claPtr;//被动子句指针
    
    vLeftLit.reserve(candClaPtr->uLitNum);//被动子句文字个数大小
    vector<Term*> chgVarT;//储存替换变元项
    chgVarT.reserve(16);
    bool isUnify;
    Clause* actClaue = queryLit->claPtr;//主动子句指针
    //判断合一之后是否超出综合函数复杂度
    if((candClaPtr->compFuncDeepthCla() > StrategyParam::funcFixDeepth) || (actClaue->compFuncDeepthCla() > StrategyParam::funcFixDeepth))
        return fail;
   
    vector<Literal*> vEnqLit;//存放等词文字
    UINT32 queryLitPredCode = queryLit->subTerm->iTermCode;//得到主动文字的谓词项编号
    //处理被动归结子句中的剩余文字
    //1、检查与queryLit合一相同（换下一个可归结文字）
    //2、与vOutTir中对角线文字是否与归结文字合一相同（换下一个可归结文字）
    //3、检查与vnewR 
    //		3.1 是否 合一互补（恒真换下一个文字）
    //		3.2 是否 合一相等（合并）
    //4、函数嵌套是否超过限制(换下一个可归结文字)			注：起步子句剩余文字也需要检查
    //5、基文字检查是否与单文子包含冗余(换下一个可归结文字)	注：起步子句剩余文字也需要检查，P(x)->P(b)
    for (UINT16 i = 0; i < candClaPtr->uLitNum; ++i) {
        Literal* postlit = candClaPtr->LitPtr[i];
        postlit->isDel = 1;//考虑下一次三角形如何变换，是否需要重新初始化20170101
        postlit->isDrop= 0;
        if (postlit == &candLit) {
            postlit->isDrop = 1;
            continue;
        }
        UINT32 ucandlitPredCode = postlit->subTerm->iTermCode;
        isUnify = false;
        ClearVarBind(chgVarT);
        /*
        //0、检查与candLit合一相同
         if (ucandlitPredCode == candLit.subTerm->iTermCode && LitMgu(postlit, &candLit, chgVarT)) {
              isUnify = true;
         }
         if (isUnify)
            continue;
        ClearVarBind(chgVarT);
        */
        //1、检查与queryLit合一相同（换下一个可归结文字）
       //20171029
        //if (ucandlitPredCode == queryLitPredCode && LitMgu(postlit, queryLit, chgVarT)) {
        if (ucandlitPredCode == queryLitPredCode && CheckEqn(postlit->subTerm, queryLit->subTerm)) {
            //此处处理形如E(x1,x3)+~E(x1,x2)+~E(x2,x3)
            //20170114
            bool unfyEqn = true;
            for (UINT16 tmp = 0; tmp < candClaPtr->uLitNum; tmp++) {
                Literal* posTmp = candClaPtr->LitPtr[tmp];
                if ((TNegEqn == GetCodeProp(posTmp->subTerm->iTermCode))) //正文字等词检查是否恒真
                {
                    if (CheckEqn(posTmp->subTerm->subTermPtr[0], posTmp->subTerm->subTermPtr[1])) {
                        //cout<<eqnLit->claPtr->uClaId<<endl;
                        unfyEqn = false;
                        break;
                    }
                }
            }
            //20170114
            ClearVarBind(chgVarT);
            if(unfyEqn)//20170114增加判断
                return TAUTOLOGY;
        }
        ClearVarBind(chgVarT); //不成功删除 变元替换
        //cout<<"111***:"<<candLit.claPtr->uClaId<<endl;
        
        //20170213检查是否与候选文字可以合并，一定要合并
        //20171029
        //if(ucandlitPredCode == candLit.subTerm->iTermCode && LitMgu(postlit, &candLit, chgVarT))
        if(ucandlitPredCode == candLit.subTerm->iTermCode && ((candLit.subTerm->hasVarOrBindVar() == false) ||(postlit->subTerm->hasVarOrBindVar() == false)) &&LitMgu(postlit, &candLit, chgVarT)) 
        {
            postlit->isDrop = 1;
            vVarBindT.insert(vVarBindT.end(), chgVarT.begin(), chgVarT.end());
            chgVarT.clear();
            continue;
        }
        ClearVarBind(chgVarT); //不成功删除 变元替换
        
        /*检查是否与剩余文字相同*/
        //3、检查被动归结子句的剩余文字之间是否有相同和互补情况 
        //20170305 idea 是否考虑合一相同
        for (UINT16 j = i + 1; j < candClaPtr->uLitNum; ++j) {
            Literal* postlitB = candClaPtr->LitPtr[j];
            if (postlitB == &candLit) continue;
            //是否与自己的剩余文字相同 （删除）
            if (ucandlitPredCode == postlitB->subTerm->iTermCode) {
                if (CheckEqn(postlit->subTerm, postlitB->subTerm)) {
                    isUnify = true;
                    break;
                }
            }                //是否与自己的剩余文字互补恒真 （换子句）
            else if (postlit->isPairPred(postlitB)) {
                if (CheckEqn(postlit->subTerm, postlitB->subTerm)) {
                    return TAUTOLOGY;
                }
            }
        }
        if (isUnify)
            continue;
        ClearVarBind(chgVarT);
        
        //2.是否与对角线单文字存在合一互补对 20170826  此处如何挑选互补对的单元子句,挑选不好会造成子句恒真式,造成子句不能使用,这是路径无法规划好的主要原因
        for(auto& clap:(*vOnlyOutTri))
        {
            //20171107 过滤已被拷贝的单元子句
            if((clap->claPtr->uLitNum == 1) && (hasCpUintClaId->find(clap->claPtr->uClaId) != hasCpUintClaId->end())){
                continue;
            }
            if (postlit->isPairPred(clap) && LitMgu(postlit, clap, chgVarT)) {
                //20170215
                vOnlyDectNum->push_back(clap);
                //20170215
                if(!clap->claPtr->isSDeduct)
                    vOnlyOutDect->push_back(clap);//20170112 记录主动归结文字，以备规则检查不合要求时，清除用
                clap->claPtr->isSDeduct = true;//20170106 互补文字需要加入演绎路径
                postlit->isDrop = 1;
                vVarBindT.insert(vVarBindT.end(), chgVarT.begin(), chgVarT.end());
                chgVarT.clear();
                isUnify = true;
                break;
            }
            ClearVarBind(chgVarT); //不成功删除 变元替换 20170112
        }
        if(isUnify)
            continue;
        ClearVarBind(chgVarT);
        
        
        //4、检查vnewR中的文字是否与剩余文字相同，相同则删除原有剩余文字
        //检查与前面句剩余文字是否相同\互补--因为 主动归结子句的剩余文字已经放入vNewR中因此直接检查是否与 vNewR中的文字相同或互补即可。
//        for (size_t j = 0; j < vNewR->size(); ++j) {
//            if (ucandlitPredCode == vNewR->at(j)->subTerm->iTermCode)//相同谓词
//            {
//                if (CheckEqn(postlit->subTerm, vNewR->at(j)->subTerm))//与剩余文字相同（合并）				
//                {
//                    //isUnify = true;  //删除剩余文字集中的文字
//                    vNewR->erase(vNewR->begin() + j);
//                    break;
//                }
//            } 
//            else if (postlit->isPairPred(vNewR->at(j))) {
//                if (CheckEqn(postlit->subTerm, vNewR->at(j)->subTerm))//恒真，返回重选被动归结子句
//                {
//                    return TAUTOLOGY;
//                }
//            }
//        }
        UINT32 litVarCount = 0;
        if (!CheckMaxFuncLayer(*postlit, litVarCount)) {
            //函数复合层超过限制，规则检查失败 恢复替换并且换子句 
            //string sMsg = to_string(postlit->Row()) + "_" + to_string(postlit->Col()) + "函数层超过限制";
            //FileOp::LogOut(sMsg);
            //cout<<"函数嵌套超出限制\n";
            return MOREFUNC;
        }
        if (postlit->subTerm->uMaxVarId > 0 && 0 == litVarCount && RSubsumption(postlit)) //变成常元项 需要检查冗余 和单文字子句检查 
        {
            return RSubsump;
        }
        //将等词放入列表最后来检查
        if (postlit->subTerm->isEqnTerm())
            vEnqLit.push_back(postlit);
        postlit->isDel = 0;
        //cout<<"debug"<<endl;
        vLeftLit.push_back(postlit);
    }

    //检查剩余文字+前面的R是否超过文字限制；
    //20170829 动态调整文字数 使得文字数最大的文字能够使用起来,但是必须停止三角形的构建
    if(!((candLit.claPtr->uLitNum == StrategyParam::R_INIT_MAX_NUM) && candLit.claPtr->isGoal)){
        if (vLeftLit.size() + vNewR->size() > StrategyParam::R_MAX_NUM + 1)
            return MORELIT;
    }
//    if (vLeftLit.size() + vNewR->size() > StrategyParam::R_MAX_NUM + 1)
//        return MORELIT;
    //20170829 end
    //添加等词恒真规则 
    if (!vEnqLit.empty()) {
        for (auto&eqnLit : vEnqLit) {
            if (TEqn == GetCodeProp(eqnLit->subTerm->iTermCode)) //正文字等词检查是否恒真
            {
                if (CheckEqn(eqnLit->subTerm->subTermPtr[0], eqnLit->subTerm->subTermPtr[1]))
                {   
                    //cout<<eqnLit->claPtr->uClaId<<endl;
                    return EqnTautology;
                }
            }
        }
    }
    //candLit.isDrop = 1;
    return RULEOK;
}

//20170915 从左到右演绎规则检查
//主动文字指针，被动文字对象
RESULT Unify::RuleCheckLR(Literal* queryLit, Literal& candLit, vector<Literal*> &vLeftLit) {//参数1：主动归结文字指针；参数2：被动归结文字指针
    
    vOnlyOutDect->clear();//20170112 记录主动归结文字，以备规则检查步合要求时，清除用
    vOnlyDectNum->clear();//互补对单元子句清空
    
    Clause *candClaPtr = queryLit->claPtr;//被动子句指针
    
    vLeftLit.reserve(candClaPtr->uLitNum);//被动子句文字个数大小
    vector<Term*> chgVarT;//储存替换变元项
    chgVarT.reserve(16);
    bool isUnify;
    Clause* actClaue = candLit.claPtr;//主动子句指针
    //判断合一之后是否超出综合函数复杂度
    if((candClaPtr->compFuncDeepthCla() > StrategyParam::funcFixDeepth) || (actClaue->compFuncDeepthCla() > StrategyParam::funcFixDeepth))
        return fail;
   
    vector<Literal*> vEnqLit;//存放等词文字
    UINT32 queryLitPredCode = candLit.subTerm->iTermCode;//得到主动文字的谓词项编号
    //处理被动归结子句中的剩余文字
    //1、检查与queryLit合一相同（换下一个可归结文字）
    //2、与vOutTir中对角线文字是否与归结文字合一相同（换下一个可归结文字）
    //3、检查与vnewR 
    //		3.1 是否 合一互补（恒真换下一个文字）
    //		3.2 是否 合一相等（合并）
    //4、函数嵌套是否超过限制(换下一个可归结文字)			注：起步子句剩余文字也需要检查
    //5、基文字检查是否与单文子包含冗余(换下一个可归结文字)	注：起步子句剩余文字也需要检查，P(x)->P(b)
    for (UINT16 i = 0; i < candClaPtr->uLitNum; ++i) {
        Literal* postlit = candClaPtr->LitPtr[i];
        postlit->isDel = 1;//考虑下一次三角形如何变换，是否需要重新初始化20170101
        postlit->isDrop= 0;
        if (postlit == queryLit) {
            postlit->isDrop = 1;
            continue;
        }
        UINT32 ucandlitPredCode = postlit->subTerm->iTermCode;
        isUnify = false;
        ClearVarBind(chgVarT);
        /*
        //0、检查与candLit合一相同
         if (ucandlitPredCode == candLit.subTerm->iTermCode && LitMgu(postlit, &candLit, chgVarT)) {
              isUnify = true;
         }
         if (isUnify)
            continue;
        ClearVarBind(chgVarT);
        */
        //1、检查与queryLit合一相同（换下一个可归结文字）
        //20171029
        //if (ucandlitPredCode == queryLitPredCode && LitMgu(postlit, &candLit, chgVarT)) {
           if (ucandlitPredCode == queryLitPredCode && CheckEqn(postlit->subTerm, candLit.subTerm)) { 
            //此处处理形如E(x1,x3)+~E(x1,x2)+~E(x2,x3)
            //20170114
            bool unfyEqn = true;
            for (UINT16 tmp = 0; tmp < candClaPtr->uLitNum; tmp++) {
                Literal* posTmp = candClaPtr->LitPtr[tmp];
                if ((TNegEqn == GetCodeProp(posTmp->subTerm->iTermCode))) //正文字等词检查是否恒真
                {
                    if (CheckEqn(posTmp->subTerm->subTermPtr[0], posTmp->subTerm->subTermPtr[1])) {
                        //cout<<eqnLit->claPtr->uClaId<<endl;
                        unfyEqn = false;
                        break;
                    }
                }
            }
            //20170114
            ClearVarBind(chgVarT);
            if(unfyEqn)//20170114增加判断
                return TAUTOLOGY;
        }
        ClearVarBind(chgVarT); //不成功删除 变元替换
        //cout<<"111***:"<<candLit.claPtr->uClaId<<endl;
        //20171029
        //20170213检查是否与候选文字可以合并，一定要合并
        //if(ucandlitPredCode == queryLit->subTerm->iTermCode && LitMgu(postlit, queryLit, chgVarT))
        if(ucandlitPredCode == queryLit->subTerm->iTermCode && (queryLit->subTerm->hasVarOrBindVar() == false) && LitMgu(postlit, queryLit, chgVarT))
        {
            postlit->isDrop = 1;
            vVarBindT.insert(vVarBindT.end(), chgVarT.begin(), chgVarT.end());
            chgVarT.clear();
            continue;
        }
        ClearVarBind(chgVarT); //不成功删除 变元替换
        
        /*检查是否与剩余文字相同*/
        //3、检查被动归结子句的剩余文字之间是否有相同和互补情况 
        //20170305 idea 是否考虑合一相同
        for (UINT16 j = i + 1; j < candClaPtr->uLitNum; ++j) {
            Literal* postlitB = candClaPtr->LitPtr[j];
            if (postlitB == queryLit) continue;
            //是否与自己的剩余文字相同 （删除）
            if (ucandlitPredCode == postlitB->subTerm->iTermCode) {
                if (CheckEqn(postlit->subTerm, postlitB->subTerm)) {
                    isUnify = true;
                    break;
                }
            }                //是否与自己的剩余文字互补恒真 （换子句）
            else if (postlit->isPairPred(postlitB)) {
                if (CheckEqn(postlit->subTerm, postlitB->subTerm)) {
                    return TAUTOLOGY;
                }
            }
        }
        if (isUnify)
            continue;
        ClearVarBind(chgVarT);
        
        //2.是否与对角线单文字存在合一互补对 20170826  此处如何挑选互补对的单元子句,挑选不好会造成子句恒真式,造成子句不能使用,这是路径无法规划好的主要原因
        for(auto& clap:(*vOnlyOutTri))
        {
            //20171107 过滤已被拷贝的单元子句
            if((clap->claPtr->uLitNum == 1) && (hasCpUintClaId->find(clap->claPtr->uClaId) != hasCpUintClaId->end()))
                continue;
            if (postlit->isPairPred(clap) && LitMgu(postlit, clap, chgVarT)) {
                //20170215
                vOnlyDectNum->push_back(clap);
                //20170215
                if(!clap->claPtr->isSDeduct)
                    vOnlyOutDect->push_back(clap);//20170112 记录主动归结文字，以备规则检查不合要求时，清除用
                clap->claPtr->isSDeduct = true;//20170106 互补文字需要加入演绎路径
                postlit->isDrop = 1;
                vVarBindT.insert(vVarBindT.end(), chgVarT.begin(), chgVarT.end());
                chgVarT.clear();
                isUnify = true;
                break;
            }
            ClearVarBind(chgVarT); //不成功删除 变元替换 20170112
        }
        if(isUnify)
            continue;
        ClearVarBind(chgVarT);
        UINT32 litVarCount = 0;
        if (!CheckMaxFuncLayer(*postlit, litVarCount)) {
            //函数复合层超过限制，规则检查失败 恢复替换并且换子句 
            //string sMsg = to_string(postlit->Row()) + "_" + to_string(postlit->Col()) + "函数层超过限制";
            //FileOp::LogOut(sMsg);
            //cout<<"函数嵌套超出限制\n";
            return MOREFUNC;
        }
        if (postlit->subTerm->uMaxVarId > 0 && 0 == litVarCount && RSubsumption(postlit)) //变成常元项 需要检查冗余 和单文字子句检查 
        {
            return RSubsump;
        }
        //将等词放入列表最后来检查
        if (postlit->subTerm->isEqnTerm())
            vEnqLit.push_back(postlit);
        postlit->isDel = 0;
        //cout<<"debug"<<endl;
        vLeftLit.push_back(postlit);
    }

    //检查剩余文字+前面的R是否超过文字限制；
    //20170829 动态调整文字数 使得文字数最大的文字能够使用起来,但是必须停止三角形的构建
    if(!((queryLit->claPtr->uLitNum == StrategyParam::R_INIT_MAX_NUM) && queryLit->claPtr->isGoal)){
        if (vLeftLit.size() + vNewR->size() > StrategyParam::R_MAX_NUM + 1)
            return MORELIT;
    }
//    if (vLeftLit.size() + vNewR->size() > StrategyParam::R_MAX_NUM + 1)
//        return MORELIT;
    //20170829 end
    //添加等词恒真规则 
    if (!vEnqLit.empty()) {
        for (auto&eqnLit : vEnqLit) {
            if (TEqn == GetCodeProp(eqnLit->subTerm->iTermCode)) //正文字等词检查是否恒真
            {
                if (CheckEqn(eqnLit->subTerm->subTermPtr[0], eqnLit->subTerm->subTermPtr[1]))
                {   
                    //cout<<eqnLit->claPtr->uClaId<<endl;
                    return EqnTautology;
                }
            }
        }
    }
    //candLit.isDrop = 1;
    return RULEOK;
}

//20210416 limitRule
RESULT Unify::RuleCheckLRLimit(Literal* queryLit, Literal& candLit, vector<Literal*> &vLeftLit) {//参数1：主动归结文字指针；参数2：被动归结文字指针
    
    vOnlyOutDect->clear();//20170112 记录主动归结文字，以备规则检查步合要求时，清除用
    vOnlyDectNum->clear();//互补对单元子句清空
    
    Clause *candClaPtr = queryLit->claPtr;//被动子句指针
    
    vLeftLit.reserve(candClaPtr->uLitNum);//被动子句文字个数大小
    vector<Term*> chgVarT;//储存替换变元项
    chgVarT.reserve(16);
    bool isUnify;
    Clause* actClaue = candLit.claPtr;//主动子句指针
    //判断合一之后是否超出综合函数复杂度
    
   
    vector<Literal*> vEnqLit;//存放等词文字
    UINT32 queryLitPredCode = candLit.subTerm->iTermCode;//得到主动文字的谓词项编号
    //处理被动归结子句中的剩余文字
    //1、检查与queryLit合一相同（换下一个可归结文字）
    //2、与vOutTir中对角线文字是否与归结文字合一相同（换下一个可归结文字）
    //3、检查与vnewR 
    //		3.1 是否 合一互补（恒真换下一个文字）
    //		3.2 是否 合一相等（合并）
    //4、函数嵌套是否超过限制(换下一个可归结文字)			注：起步子句剩余文字也需要检查
    //5、基文字检查是否与单文子包含冗余(换下一个可归结文字)	注：起步子句剩余文字也需要检查，P(x)->P(b)
    for (UINT16 i = 0; i < candClaPtr->uLitNum; ++i) {
        Literal* postlit = candClaPtr->LitPtr[i];
        postlit->isDel = 1;//考虑下一次三角形如何变换，是否需要重新初始化20170101
        postlit->isDrop= 0;
        if (postlit == queryLit) {
            postlit->isDrop = 1;
            continue;
        }
        UINT32 ucandlitPredCode = postlit->subTerm->iTermCode;
        isUnify = false;
        ClearVarBind(chgVarT);
        /*
        //0、检查与candLit合一相同
         if (ucandlitPredCode == candLit.subTerm->iTermCode && LitMgu(postlit, &candLit, chgVarT)) {
              isUnify = true;
         }
         if (isUnify)
            continue;
        ClearVarBind(chgVarT);
        */
        //1、检查与queryLit合一相同（换下一个可归结文字）
        //20171029
        //if (ucandlitPredCode == queryLitPredCode && LitMgu(postlit, &candLit, chgVarT)) {
           if (ucandlitPredCode == queryLitPredCode && CheckEqn(postlit->subTerm, candLit.subTerm)) { 
            //此处处理形如E(x1,x3)+~E(x1,x2)+~E(x2,x3)
            //20170114
            bool unfyEqn = true;
            for (UINT16 tmp = 0; tmp < candClaPtr->uLitNum; tmp++) {
                Literal* posTmp = candClaPtr->LitPtr[tmp];
                if ((TNegEqn == GetCodeProp(posTmp->subTerm->iTermCode))) //正文字等词检查是否恒真
                {
                    if (CheckEqn(posTmp->subTerm->subTermPtr[0], posTmp->subTerm->subTermPtr[1])) {
                        //cout<<eqnLit->claPtr->uClaId<<endl;
                        unfyEqn = false;
                        break;
                    }
                }
            }
            //20170114
            ClearVarBind(chgVarT);
            if(unfyEqn)//20170114增加判断
                return TAUTOLOGY;
        }
        ClearVarBind(chgVarT); //不成功删除 变元替换
        //cout<<"111***:"<<candLit.claPtr->uClaId<<endl;
        //20171029
        //20170213检查是否与候选文字可以合并，一定要合并
        //if(ucandlitPredCode == queryLit->subTerm->iTermCode && LitMgu(postlit, queryLit, chgVarT))
        if(ucandlitPredCode == queryLit->subTerm->iTermCode && (queryLit->subTerm->hasVarOrBindVar() == false) && LitMgu(postlit, queryLit, chgVarT))
        {
            postlit->isDrop = 1;
            vVarBindT.insert(vVarBindT.end(), chgVarT.begin(), chgVarT.end());
            chgVarT.clear();
            continue;
        }
        ClearVarBind(chgVarT); //不成功删除 变元替换
        
        /*检查是否与剩余文字相同*/
        //3、检查被动归结子句的剩余文字之间是否有相同和互补情况 
        //20170305 idea 是否考虑合一相同
        for (UINT16 j = i + 1; j < candClaPtr->uLitNum; ++j) {
            Literal* postlitB = candClaPtr->LitPtr[j];
            if (postlitB == queryLit) continue;
            //是否与自己的剩余文字相同 （删除）
            if (ucandlitPredCode == postlitB->subTerm->iTermCode) {
                if (CheckEqn(postlit->subTerm, postlitB->subTerm)) {
                    isUnify = true;
                    break;
                }
            }                //是否与自己的剩余文字互补恒真 （换子句）
            else if (postlit->isPairPred(postlitB)) {
                if (CheckEqn(postlit->subTerm, postlitB->subTerm)) {
                    return TAUTOLOGY;
                }
            }
        }
        if (isUnify)
            continue;
        ClearVarBind(chgVarT);
        
        //2.是否与对角线单文字存在合一互补对 20170826  此处如何挑选互补对的单元子句,挑选不好会造成子句恒真式,造成子句不能使用,这是路径无法规划好的主要原因
        for(auto& clap:(*vOnlyOutTri))
        {
            //20171107 过滤已被拷贝的单元子句
            if((clap->claPtr->uLitNum == 1) && (hasCpUintClaId->find(clap->claPtr->uClaId) != hasCpUintClaId->end())){
                continue;
            }
            if (postlit->isPairPred(clap) && LitMgu(postlit, clap, chgVarT)) {
                //20170215
                vOnlyDectNum->push_back(clap);
                //20170215
                if(!clap->claPtr->isSDeduct)
                    vOnlyOutDect->push_back(clap);//20170112 记录主动归结文字，以备规则检查不合要求时，清除用
                clap->claPtr->isSDeduct = true;//20170106 互补文字需要加入演绎路径
                postlit->isDrop = 1;
                vVarBindT.insert(vVarBindT.end(), chgVarT.begin(), chgVarT.end());
                chgVarT.clear();
                isUnify = true;
                break;
            }
            ClearVarBind(chgVarT); //不成功删除 变元替换 20170112
        }
        if(isUnify)
            continue;
        ClearVarBind(chgVarT);
        UINT32 litVarCount = 0;
        if (!CheckMaxFuncLayer(*postlit, litVarCount)) {
            //函数复合层超过限制，规则检查失败 恢复替换并且换子句 
            //string sMsg = to_string(postlit->Row()) + "_" + to_string(postlit->Col()) + "函数层超过限制";
            //FileOp::LogOut(sMsg);
            //cout<<"函数嵌套超出限制\n";
            return MOREFUNC;
        }
        if (postlit->subTerm->uMaxVarId > 0 && 0 == litVarCount && RSubsumption(postlit)) //变成常元项 需要检查冗余 和单文字子句检查 
        {
            return RSubsump;
        }
        //将等词放入列表最后来检查
        if (postlit->subTerm->isEqnTerm())
            vEnqLit.push_back(postlit);
        postlit->isDel = 0;
        //cout<<"debug"<<endl;
        vLeftLit.push_back(postlit);
    }

    //检查剩余文字+前面的R是否超过文字限制；
    //20170829 动态调整文字数 使得文字数最大的文字能够使用起来,但是必须停止三角形的构建
    if(!((queryLit->claPtr->uLitNum == StrategyParam::R_INIT_MAX_NUM) && queryLit->claPtr->isGoal)){
        if (vLeftLit.size() + vNewR->size() > StrategyParam::R_MAX_NUM + 1)
            return MORELIT;
    }
//    if (vLeftLit.size() + vNewR->size() > StrategyParam::R_MAX_NUM + 1)
//        return MORELIT;
    //20170829 end
    //添加等词恒真规则 
    if (!vEnqLit.empty()) {
        for (auto&eqnLit : vEnqLit) {
            if (TEqn == GetCodeProp(eqnLit->subTerm->iTermCode)) //正文字等词检查是否恒真
            {
                if (CheckEqn(eqnLit->subTerm->subTermPtr[0], eqnLit->subTerm->subTermPtr[1]))
                {   
                    //cout<<eqnLit->claPtr->uClaId<<endl;
                    return EqnTautology;
                }
            }
        }
    }
    if((candClaPtr->compFuncDeepthCla() > StrategyParam::funcFixDeepth) || (actClaue->compFuncDeepthCla() > StrategyParam::funcFixDeepth))
        return fail;
    //candLit.isDrop = 1;
    return RULEOK;
}

struct tmpLayer {

    tmpLayer(UINT32 _uLayer, Term* _varBind) : uLayer(_uLayer), term(_varBind) {
    };
    UINT8 uLayer;
    Term* term;
};
//检查文字的函数复合 层数

bool Unify::CheckMaxFuncLayer(const Literal& lit, UINT32&litVarCount) {
    string str;
    //TermToString(lit.subTerm, str);
    //cout << str << endl;
    vector<tmpLayer*> stackCode;
    stackCode.reserve(16);
    Term* term = lit.subTerm;
    Term* tmpTerm;
    UINT8 uLayer = 1;
    while (1) {
        for (UINT8 i = 0; i < term->uSubTermNum; ++i) {
            tmpTerm = GetBindingT(term->subTermPtr[i]);
            if (tmpTerm->iTermCode < 0) //变元
                ++litVarCount;
            else if (tmpTerm->uSubTermNum > 0) //函数
            {
                if (++uLayer > StrategyParam::R_MAX_FUNCLAYER)
                    return false;
                if (tmpTerm->uVarCount == 0)//共享基函数项
                {
                    if (uLayer + tmpTerm->uLevel > StrategyParam::R_MAX_FUNCLAYER)
                        return false;
                } else//非基函数项
                {
                    if (tmpTerm->uLevel > StrategyParam::R_MAX_FUNCLAYER)
                        return false;
                    stackCode.push_back(new tmpLayer(uLayer, tmpTerm));
                }
            }
        }
        if (stackCode.empty())break;
        tmpLayer* temp = stackCode.back();

        uLayer = temp->uLayer;
        term = temp->term;
        delete(temp);
        stackCode.pop_back();
    }
    return true;
}
//清除变元替换 

void Unify::ClearVarBind(vector<Term*>& chgVarT) {
    if (chgVarT.empty())return;
    /*Concurrency::parallel_*/
    for_each(chgVarT.begin(), chgVarT.end(), []
            (Term * t) {
        t->vBinding = nullptr; });
    chgVarT.clear();
}

//检查是否存在一个文字能通过替换与conLit相同

bool Unify::RSubsumption(Literal* conLit) {
    //得到 候选文字
    vector<Literal*>*vCandLit = conLit->getPredLst();
    for (auto&varLit : *vCandLit) {
        if (varLit == conLit || 1 < varLit->claPtr->uLitNum || conLit->subTerm->uSubTermNum != varLit->subTerm->uSubTermNum)
            continue;
        if (RMatch(conLit, varLit))
            return true;
    }
    return false;
}

extern set<HashNode*, HashNodeCmpByCode> g_HashTree;
//oldT 谓词项
Term* Unify::GetNewTerm(Term* oldT, Clause* newCla) {
    if (oldT->uVarCount == 0) //说明本身oldT就为共享基函数 直接返回
        return oldT;

    Term* newT = new Term(oldT->iTermCode);
    newT->subTermPtr = new Term*[oldT->uSubTermNum];
    newT->uSubTermNum = oldT->uSubTermNum;
    Term* oldSubT;
    for (UINT8 i = 0; i < oldT->uSubTermNum; ++i) {
        //oldT->subTermPtr[i]->Print(); cout << endl;
        oldSubT = GetBindingT(oldT->subTermPtr[i]); //得到项的绑定
        //oldSubT->Print(); cout << endl;
        if (oldSubT->iTermCode < 0) //变元
        {

            UINT16 uTmpMaxVarId;
            newT->subTermPtr[i] = newCla->VBInsert(oldSubT->iTermCode, uTmpMaxVarId);
            newT->subTermPtr[i]->uVarCount = 1;
            if (uTmpMaxVarId > 0)
                newT->uMaxVarId = uTmpMaxVarId;
            ++newT->uVarCount;

        } else if (0 == oldSubT->uVarCount) //比较项为基函数项（常元或共享基函数项）  一定是存储在g_hashTree中的。
        {
            newT->subTermPtr[i] = oldSubT;
            if (oldSubT->uSubTermNum > 0) {
                newT->uLevel = newT->subTermPtr[i]->uLevel + 1; //函数嵌套层
                newT->fSteadyValue += newT->subTermPtr[i]->fSteadyValue * 0.5f; //稳定度	
            } else
                ++(newT->fSteadyValue); //稳定度计算
        } else //函数项
        {
            assert(oldSubT->uSubTermNum > 0);

            newT->subTermPtr[i] = GetNewTerm(oldSubT, newCla);
            newT->uLevel = newT->subTermPtr[i]->uLevel + 1; //函数嵌套层
            newT->fSteadyValue += newT->subTermPtr[i]->fSteadyValue * 0.5f; //稳定度	
            newT->uVarCount += newT->subTermPtr[i]->uVarCount; //变元数

            if (newT->uMaxVarId < newT->subTermPtr[i]->uMaxVarId)
                newT->uMaxVarId = newT->subTermPtr[i]->uMaxVarId;
        }
    }

    //注:若该函数本身为共享基函数，则不会进入这个方法调用因此 这里肯定是非基函数
    //A、若没有变元则说明通过替换变为了共享基函数
    //B、有变元则插入到子句的共享非基函数hashtree中

    if (newT->uVarCount > 0)//非基函数项
        newT = newCla->InsertVarFuncTerm(newT); //插入非基函数项			
    else
        newT = HashTree::InsertHashTree(newT, g_HashTree); //插入基函数项		
    assert(newT->uSubTermNum > 0);

    newT->fSteadyValue /= (1.0f * newT->uSubTermNum);
    return newT;

}
//拷贝项,用于子句拷贝
Term* Unify::GetCopyTerm(Term* oldT, Clause* newCla) {

    if (oldT->uVarCount == 0) //说明本身oldT就为共享基函数 直接返回
        return oldT;

    Term* newT = new Term(oldT->iTermCode);
    newT->subTermPtr = new Term*[oldT->uSubTermNum];
    newT->uSubTermNum = oldT->uSubTermNum;
    Term* oldSubT;
    for (UINT8 i = 0; i < oldT->uSubTermNum; ++i) {
        //oldT->subTermPtr[i]->Print(); cout << endl;
        oldSubT = oldT->subTermPtr[i]; //得到项的绑定	
        //oldSubT->Print(); cout << endl;
        if (oldSubT->iTermCode < 0) //变元
        {

            UINT16 uTmpMaxVarId;
            newT->subTermPtr[i] = newCla->VBInsert(oldSubT->iTermCode, uTmpMaxVarId);
            newT->subTermPtr[i]->uVarCount = 1;

            if (uTmpMaxVarId > 0)
                newT->uMaxVarId = uTmpMaxVarId;
            ++newT->uVarCount;

        } else if (0 == oldSubT->uVarCount) //比较项为基函数项（常元或共享基函数项）  一定是存储在g_hashTree中的。
        {
            newT->subTermPtr[i] = oldSubT;
            if (oldSubT->uSubTermNum > 0) {
                newT->uLevel = newT->subTermPtr[i]->uLevel + 1; //函数嵌套层
                newT->fSteadyValue += newT->subTermPtr[i]->fSteadyValue * 0.5f; //稳定度	
            } else
                ++(newT->fSteadyValue); //稳定度计算
        } else //函数项
        {
            assert(oldSubT->uSubTermNum > 0);

            newT->subTermPtr[i] = GetCopyTerm(oldSubT, newCla);
            newT->uLevel = newT->subTermPtr[i]->uLevel + 1; //函数嵌套层
            newT->fSteadyValue += newT->subTermPtr[i]->fSteadyValue * 0.5f; //稳定度	
            newT->uVarCount += newT->subTermPtr[i]->uVarCount; //变元数

            if (newT->uMaxVarId < newT->subTermPtr[i]->uMaxVarId)
                newT->uMaxVarId = newT->subTermPtr[i]->uMaxVarId;
        }
    }

    //注:若该函数本身为共享基函数，则不会进入这个方法调用因此 这里肯定是非基函数
    //A、若没有变元则说明通过替换变为了共享基函数
    //B、有变元则插入到子句的共享非基函数hashtree中

    if (newT->uVarCount > 0)//非基函数项
        newT = newCla->InsertVarFuncTerm(newT); //插入非基函数项			
    else
        newT = HashTree::InsertHashTree(newT, g_HashTree); //插入基函数项		
    assert(newT->uSubTermNum > 0);

    newT->fSteadyValue /= (1.0f * newT->uSubTermNum);
    return newT;

}

void Unify::countVTerm(Term* term,UINT32 &count)
{ 
    term= GetBindingT(term);
    if (term->iTermCode < 0){
        count++;
    }
    for (UINT8 i = 0; i < term->uSubTermNum; ++i)
        countVTerm(term->subTermPtr[i],count);

    return ;
}
//核心：合一算法，参数1：主动归结文字指针；参数2：被动归结文字指针
//对两个文字进行协调检查 

RESULT Unify::Issyn_two(Formula& fol,Literal* litA, Literal* candLit) {
    vVarBindT.clear();
    vOnlyOutDect->clear();
    vOnlyDectNum->clear();
    //单次合一的变元替换项
    vector<Term*> varChgOnce;
    RESULT res = NOMGU;
    if (!LitMgu(litA, candLit, varChgOnce))//参数1：主动归结文字指针；参数2：被动归结文字指针；参数3：变元替换项vector<Term*>
    {
        ClearVarBind(varChgOnce);
        vector<Term*>().swap(varChgOnce);
        return res;
    }
    if(isRedundancy(litA->claPtr) ||isRedundancy(candLit->claPtr)){
        ClearVarBind(varChgOnce);
        vector<Term*>().swap(varChgOnce);
        return res;//不能合一，返回
    }
    //合一成功
    //测试 合一后替换输出

    /*for (auto&t : varChgOnce)
    {
    cout << "规则检查前合一情况： "; t->Print(); cout << "->"; GetBindingT(t)->Print(); cout << endl;
    }*/
    /*规则检查*/
    res = RuleCheck_two(fol,litA, *candLit); //规则检查：参数1：主动归结文字指针；参数2：被动归结文字

    if (res != RULEOK/*&&res != SingleLit*/) {
        /*合一失败 清除所有替换*/
        if (!varChgOnce.empty())
            ClearVarBind(varChgOnce);
        ClearVarBind(vVarBindT);
        return res;
    }
    if (!varChgOnce.empty())
        vVarBindT.insert(vVarBindT.end(), varChgOnce.begin(), varChgOnce.end());
    //测试 规则检查后替换输出
    /*for (auto&t : vVarBindT)
    {
    cout << "规则检查后合一情况： "; t->Print(); cout << "->"; GetBindingT(t)->Print(); cout << endl;
    }*/
    //备注：若合一成功，处理完主动非单元子句和互补对的单元子句
    return res;

}

//检查非单元子句归结的剩余文字,合一检查
RESULT Unify::Issyn_Findtwo(Formula& fol,Literal* litA, Literal* candLit,UINT16& tempLit) {
    vVarBindT.clear();

    //单次合一的变元替换项
    vector<Term*> varChgOnce;
    RESULT res = NOMGU;
    if (!LitMgu(litA, candLit, varChgOnce))//参数1：主动归结文字指针；参数2：被动归结文字指针；参数3：变元替换项vector<Term*>
    {
        ClearVarBind(varChgOnce);
        vector<Term*>().swap(varChgOnce);
        return res;
    }
     if(isRedundancy(litA->claPtr) ||isRedundancy(candLit->claPtr)){
        ClearVarBind(varChgOnce);
        vector<Term*>().swap(varChgOnce);
        return res;//不能合一，返回
    }
    //合一成功
    //测试 合一后替换输出

    /*for (auto&t : varChgOnce)
    {
    cout << "规则检查前合一情况： "; t->Print(); cout << "->"; GetBindingT(t)->Print(); cout << endl;
    }*/
    /*规则检查*/
    vector<Literal*> vLeftLit;
    res = RuleCheck_FindTwo(fol,litA, *candLit, vLeftLit); //规则检查：参数1：主动归结文字指针；参数2：被动归结文字

    if (res != RULEOK/*&&res != SingleLit*/) {
        /*合一失败 清除所有替换*/
        if (!varChgOnce.empty())
            ClearVarBind(varChgOnce);
        ClearVarBind(vVarBindT);
        return res;
    }
    if (!varChgOnce.empty()){
        vVarBindT.insert(vVarBindT.end(), varChgOnce.begin(), varChgOnce.end());
        varChgOnce.clear();
    }
    //得到结果,清空变元绑定
    tempLit = vLeftLit.size();
     if(!vVarBindT.empty())
        ClearVarBind(vVarBindT);
    //记得要清空R
    vNewR->clear();
    //测试 规则检查后替换输出
    /*for (auto&t : vVarBindT)
    {
    cout << "规则检查后合一情况： "; t->Print(); cout << "->"; GetBindingT(t)->Print(); cout << endl;
    }*/
    //备注：若合一成功，处理完主动非单元子句和互补对的单元子句
    return res;

}
//规则检查：参数1：主动归结文字指针；参数2：被动归结文字

/*规则检查 ，对被动归结子句中剩余文字1、对角线互补；2、第一条对角线元素是否和该轮前面保留的R相等
输出：违反规则返回--false; 规则检查通过返回--ture; */

RESULT Unify::RuleCheck_two(Formula& fol,Literal* queryLit, Literal& candLit) {
    vOnlyOutDect->clear();
    vOnlyDectNum->clear();
    Clause *candClaPtr = candLit.claPtr; //得到被动归结子句
    vector<Literal*>vLeftLit;//保存侯选子句剩余文字
    vLeftLit.reserve(candClaPtr->uLitNum); //定义被动子句文字个数大小的vector
    vector<Term*> chgVarT;
    chgVarT.reserve(16);
    bool isUnify;
    Clause* actClaue = queryLit->claPtr; //得到主动归结子句
    
     if((candClaPtr->compFuncDeepthCla() > StrategyParam::funcFixDeepth) || (actClaue->compFuncDeepthCla() > StrategyParam::funcFixDeepth))
        return fail;
    
    vector<Literal*> vEnqLit;

    //处理主动归结子句中的剩余文字
    //1、若为起步子句
    //	1.1 检查剩余文字是否与归结文字合一相同（删除）
    //	1.2 检查剩余文字之间是否可以合一相同（合并）	
    //	1.3 检查函数嵌套是否超过限制 & 若为基文字则检查包含冗余；
    //	1.4 添加到vNewR
    //2、不为起步子句 将未删除的剩余文字添加到VnewR
    //3、判定vNewR中文字个数是否超过限制，根据情况停止△归结或选择其他归结文字 注：选其他归结文字主要是为了避免起步文字个数超过限制，但一般这种情况不会出现

    UINT32 queryLitPredCode = queryLit->subTerm->iTermCode;
    //1、若为起步子句，只执行一次
    //此为非单元子句的起步子句，将满足条件的文字放入三角形下方，可以互补对的单元子句放入三角形右边，且记录演绎路径
    //2 落入三角形上方的文字idel属性为0
    //R 归结式为处理，将若上三角形上方的文字归入到R归结式
    if (vOutTri->empty()) {
        for (UINT16 i = 0; i < actClaue->uLitNum; ++i) {       
            Literal* actLeftLit = actClaue->LitPtr[i]; //得到主动归结子句文字
            actLeftLit->isDel = 1;//为1表示可以删除，为0表示应放入归结式中
            if (queryLit == actLeftLit) continue; //子句中已归结文字跳出，queryLit需放入三角形对角线中
            isUnify = false; //合并判断标识
            //1.1 检查剩余文字是否与归结文字合一相同（删除），有合并一定要合并
            //20171029
            //if (actLeftLit->subTerm->iTermCode == queryLitPredCode && LitMgu(actLeftLit, queryLit, chgVarT)) {
            if (actLeftLit->subTerm->iTermCode == queryLitPredCode &&(queryLit->subTerm->hasVarOrBindVar() == false)&& LitMgu(actLeftLit, queryLit, chgVarT)) {
                vVarBindT.insert(vVarBindT.end(), chgVarT.begin(), chgVarT.end());
                chgVarT.clear();
                continue;
            }
            ClearVarBind(chgVarT);
            //1.2 20170913检查是否与归结文字是否相同,相同则表示时恒真式
            //20171029
            //if(actLeftLit->subTerm->iTermCode == candLit.subTerm->iTermCode &&LitMgu(actLeftLit, &candLit, chgVarT)) {
            if(actLeftLit->subTerm->iTermCode == candLit.subTerm->iTermCode &&CheckEqn(actLeftLit->subTerm, candLit.subTerm)) {
                ClearVarBind(chgVarT);
                return TAUTOLOGY;
            }
             ClearVarBind(chgVarT); //不成功删除 变元替换    
            //1.3 检查剩余文字之间是否相同（合并）
            for (UINT16 uCol = i + 1; uCol < actClaue->uLitNum; ++uCol) {
                Literal* actLeftLitB = actClaue->LitPtr[uCol];
                if(actLeftLitB == queryLit)
                    continue;
                if (actLeftLit->subTerm->iTermCode == actLeftLitB->subTerm->iTermCode
                        && CheckEqn(actLeftLit->subTerm, actLeftLitB->subTerm)) //相同删除
                {
                    isUnify = true;
                    break;
                }
                else if(actLeftLitB->isPairPred(actLeftLit)){
                    if(CheckEqn(actLeftLitB->subTerm,actLeftLit->subTerm)){
                        return TAUTOLOGY;
                    }
                }
            }
            if (isUnify)
                continue;
            ClearVarBind(chgVarT);    
            
            //1.4是否与对角线单文字存在合一互补对，若有多个互补对怎么办。目前做法:根据单元子句排序
            if(vOnlyOutTri->size() == 0){
                for (auto& clapCla : fol.setSingleCla) {
                    Literal* clap = clapCla->LitPtr[0];
                    if (actLeftLit->isPairPred(clap) && LitMgu(actLeftLit, clap, chgVarT)) {
                        vOnlyDectNum->push_back(clap);
                        if (!clap->claPtr->isSDeduct)
                            vOnlyOutDect->push_back(clap); //20170112 记录每次被候选子句拉下的单元子句，以备规则检查不合要求时，清除用
                        clap->claPtr->isSDeduct = true; //20170106 互补文字需要加入演绎路径
                        //第一次添加演绎路径
                        //vOutTri->push_back(clap);//添加演绎路径
                        vVarBindT.insert(vVarBindT.end(), chgVarT.begin(), chgVarT.end());
                        chgVarT.clear();
                        isUnify = true;
                        break;
                    }
                    ClearVarBind(chgVarT); //不成功删除 变元替换 20170112
                }
            }
            else{
                for (auto& clap : (*vOnlyOutTri)) {
                    if (actLeftLit->isPairPred(clap) && LitMgu(actLeftLit, clap, chgVarT)) {
                        vOnlyDectNum->push_back(clap);
                        if (!clap->claPtr->isSDeduct)
                            vOnlyOutDect->push_back(clap); //20170112 记录每次被候选子句拉下的单元子句，以备规则检查不合要求时，清除用
                        clap->claPtr->isSDeduct = true; //20170106 互补文字需要加入演绎路径
                        //第一次添加演绎路径
                        //vOutTri->push_back(clap);//添加演绎路径
                        vVarBindT.insert(vVarBindT.end(), chgVarT.begin(), chgVarT.end());
                        chgVarT.clear();
                        isUnify = true;
                        break;
                    }
                    ClearVarBind(chgVarT); //不成功删除 变元替换 20170112
                }
            }
            
            if (isUnify)
                continue;
            ClearVarBind(chgVarT);
            //1.5 检查函数嵌套是否超过限制 & 若为基文字则检查包含冗余；
            UINT32 uVarCount = 0;
            if (!CheckMaxFuncLayer(*actLeftLit, uVarCount))
                return MOREFUNC;
            if (actLeftLit->subTerm->uMaxVarId > 0 && 0 == uVarCount && RSubsumption(actLeftLit))
                return RSubsump;
            //将等词放入列表最后来检查
            if (actLeftLit->subTerm->isEqnTerm())
                vEnqLit.push_back(actLeftLit);
            //1.5检查与vNewR中的文字是否相同（不合一）
            if (!vNewR->empty()) {
                for (auto&r : *vNewR) {
                    if (r->subTerm->iTermCode == actLeftLit->subTerm->iTermCode && CheckEqn(r->subTerm, actLeftLit->subTerm)) {
                        isUnify = true;
                        break;
                    }
                }
            }
            if (isUnify) continue;
            //将主动归结文字加入到R中
            actLeftLit->isDel = 0;
            vNewR->push_back(actLeftLit);
        }
        //此时起步非单元子句下拉的互补对单元子句放入到演绎路径，起步子句剩余文字放入到R中
    }  //else//2、不为起步子句
//    {
//        for (UINT32 i = 0; i < actClaue->uLitNum; ++i) {
//            Literal* actLeftLit = actClaue->LitPtr[i];
//            if (actLeftLit->isDel || queryLit == actLeftLit)
//                continue;
//            //将等词放入列表最后来检查
//            if (actLeftLit->subTerm->isEqnTerm())
//                vEnqLit.push_back(actLeftLit);
//            vNewR->push_back(actLeftLit);
//        }
//
//    }


    //处理被动归结子句中的剩余文字
    //1、检查与queryLit合一相同（换下一个可归结文字）
    //2、与vOutTir中对角线文字是否与归结文字合一相同（换下一个可归结文字）
    //3、检查与vnewR 
    //		3.1 是否 合一互补（恒真换下一个文字）
    //		3.2 是否 合一相等（合并）
    //4、函数嵌套是否超过限制(换下一个可归结文字)			注：起步子句剩余文字也需要检查
    //5、基文字检查是否与单文子包含冗余(换下一个可归结文字)	注：起步子句剩余文字也需要检查，P(x)->P(b)
    
    //此为候选子句，将落入三角形上方的文字idel属性为0，
    //可以互补对的单元子句放入三角形右边，且记录演绎路径
    //2 落入三角形上方的文字idel属性为0
    
    for (UINT16 i = 0; i < candClaPtr->uLitNum; ++i) {
        Literal* postlit = candClaPtr->LitPtr[i];
        postlit->isDel = 1;
        if (postlit == &candLit) continue;
        UINT32 ucandlitPredCode = postlit->subTerm->iTermCode;
        isUnify = false;
        ClearVarBind(chgVarT);
        //2.1检查与queryLit合一相同（换下一个可归结文字）
        //20171029
        //if (ucandlitPredCode == queryLitPredCode && LitMgu(postlit, queryLit, chgVarT)) {
        if (ucandlitPredCode == queryLitPredCode && CheckEqn(postlit->subTerm, queryLit->subTerm)) {
            ClearVarBind(chgVarT);
            return TAUTOLOGY;
        }
        ClearVarBind(chgVarT); //不成功删除 变元替换

        //2.2是否与被动归结文字合一相同(合并) 同子句中是否相同（合并） 等完成△统一检查
        //20171029
        //if (ucandlitPredCode == candLit.subTerm->iTermCode && LitMgu(postlit, &candLit, chgVarT))
        if (ucandlitPredCode == candLit.subTerm->iTermCode && (candLit.subTerm->hasVarOrBindVar() == false) && LitMgu(postlit, &candLit, chgVarT))
        {
        	vVarBindT.insert(vVarBindT.end(), chgVarT.begin(), chgVarT.end());
        	chgVarT.clear();
        	continue;
        }
        ClearVarBind(chgVarT);//不成功删除 变元替换

        /*检查是否与剩余文字相同*/
        //2.3 检查被动归结子句的剩余文字之间是否有相同和互补情况 
        for (UINT16 j = i + 1; j < candClaPtr->uLitNum; ++j) {
            Literal* postlitB = candClaPtr->LitPtr[j];
            if (postlitB == &candLit) continue;
            //是否与自己的剩余文字相同 （删除）
            if (ucandlitPredCode == postlitB->subTerm->iTermCode) {
                if (CheckEqn(postlit->subTerm, postlitB->subTerm)) {
                    isUnify = true;
                    break;
                }
            }                //是否与自己的剩余文字互补恒真 （换子句）
            else if (postlit->isPairPred(postlitB)) {
                if (CheckEqn(postlit->subTerm, postlitB->subTerm)) {
                    return TAUTOLOGY;
                }
            }

        }
        if (isUnify)
            continue;
        ClearVarBind(chgVarT);
        //2、与vOutTir中对角线文字是否合一相同（换下一个可归结文字）
        
//        for (size_t j = 0; j < vOutTri->size(); j += 2) {
//            if (ucandlitPredCode == vOutTri->at(j)->subTerm->iTermCode)//相同谓词
//            {
//                if (LitMgu(postlit, vOutTri->at(j), chgVarT)) //与对角线文字相同，返回重选被动归结子句
//                {
//                    ClearVarBind(chgVarT);
//                    return TAUTOLOGY;
//                }
//            } else if (postlit->isPairPred(vOutTri->at(j))) {
//
//                if (LitMgu(postlit, vOutTri->at(j), chgVarT)) //与对角线文字互补 该文字放到下方
//                {
//                    //互补成功,添加到整体变元替换列表
//                    isUnify = true;
//                    vVarBindT.insert(vVarBindT.end(), chgVarT.begin(), chgVarT.end());
//                    chgVarT.clear();
//                    break;
//                }
//                //不成功删除 变元替换
//                ClearVarBind(chgVarT);
//            }
//
//        }
//        if (isUnify) continue;
        //2.4 是否与对角线单文字存在合一互补对
        if(vOnlyOutTri->size() == 0){
            for (auto& clapCla : fol.setSingleCla) {
                Literal* clap = clapCla->LitPtr[0];
                if (postlit->isPairPred(clap) && LitMgu(postlit, clap, chgVarT)) {
                    vOnlyDectNum->push_back(clap);
                    if (!clap->claPtr->isSDeduct)
                        vOnlyOutDect->push_back(clap); //20170112 记录每次被候选子句拉下的单元子句，以备规则检查不合要求时，清除用
                    clap->claPtr->isSDeduct = true; //20170106 互补文字需要加入演绎路径
                    //vOutTri->push_back(clap);//添加演绎路径
                    //postlit->isDrop = 1;
                    vVarBindT.insert(vVarBindT.end(), chgVarT.begin(), chgVarT.end());
                    chgVarT.clear();
                    isUnify = true;
                    break;
                }
                ClearVarBind(chgVarT); //不成功删除 变元替换 20170112
            }
        }
        else{
            for (auto& clap : (*vOnlyOutTri)) {
                if (postlit->isPairPred(clap) && LitMgu(postlit, clap, chgVarT)) {
                    vOnlyDectNum->push_back(clap);
                    if (!clap->claPtr->isSDeduct)
                        vOnlyOutDect->push_back(clap); //20170112 记录每次被候选子句拉下的单元子句，以备规则检查不合要求时，清除用
                    clap->claPtr->isSDeduct = true; //20170106 互补文字需要加入演绎路径
                    //vOutTri->push_back(clap);//添加演绎路径
                    //postlit->isDrop = 1;
                    vVarBindT.insert(vVarBindT.end(), chgVarT.begin(), chgVarT.end());
                    chgVarT.clear();
                    isUnify = true;
                    break;
                }
                ClearVarBind(chgVarT); //不成功删除 变元替换 20170112
            }
        }
        
        if(isUnify)
            continue;
        ClearVarBind(chgVarT);
        //3、检查vnewR中的文字是否与剩余文字相同，相同则删除原有剩余文字
        //检查与前面句剩余文字是否相同\互补--因为 主动归结子句的剩余文字已经放入vNewR中因此直接检查是否与 vNewR中的文字相同或互补即可。
        for (size_t j = 0; j < vNewR->size(); ++j) {
            if (ucandlitPredCode == vNewR->at(j)->subTerm->iTermCode)//相同谓词
            {
                if (CheckEqn(postlit->subTerm, vNewR->at(j)->subTerm))//与剩余文字相同（合并）				
                {
                    //isUnify = true;  //删除剩余文字集中的文字
                    vNewR->erase(vNewR->begin() + j);
                    break;
                }
            } else if (postlit->isPairPred(vNewR->at(j))) {
                if (CheckEqn(postlit->subTerm, vNewR->at(j)->subTerm))//恒真，返回重选被动归结子句
                {
                    return TAUTOLOGY;
                }

            }

        }

        /*if (isUnify)
                continue;*/
        UINT32 litVarCount = 0;
        if (!CheckMaxFuncLayer(*postlit, litVarCount)) {
            //函数复合层超过限制，规则检查失败 恢复替换并且换子句 
            string sMsg = to_string(postlit->Row()) + "_" + to_string(postlit->Col()) + "函数层超过限制";
            FileOp::LogOut(sMsg);
            return MOREFUNC;
        }
        if (postlit->subTerm->uMaxVarId > 0 && 0 == litVarCount && RSubsumption(postlit)) //变成常元项 需要检查冗余 和单文字子句检查 
        {
            return RSubsump;
        }
        //将等词放入列表最后来检查
        if (postlit->subTerm->isEqnTerm())
            vEnqLit.push_back(postlit);
        postlit->isDel = 0;
        vLeftLit.push_back(postlit);
    }

    //检查剩余文字+前面的R是否超过文字限制；
    if((queryLit->claPtr->goaldeepth == 0) || (candLit.claPtr->goaldeepth == 0)){
        ;
    }
    else {
        if (vLeftLit.size() + vNewR->size() > StrategyParam::R_MAX_NUM_NOPAIR)
            return MORELIT;
    }
    

    //添加等词恒真规则 
    if (!vEnqLit.empty()) {
        for (auto&eqnLit : vEnqLit) {
            if (TEqn == GetCodeProp(eqnLit->subTerm->iTermCode)) //正文字等词检查是否恒真
            {
                if (CheckEqn(eqnLit->subTerm->subTermPtr[0], eqnLit->subTerm->subTermPtr[1]))
                    return EqnTautology;
            }

        }
    }

    return RULEOK;
}

//20170916 非单元子句规则检查后的剩余文字
RESULT Unify::RuleCheck_FindTwo(Formula& fol,Literal* queryLit, Literal& candLit,vector<Literal*>& vLeftLitAll) {
    vOnlyOutDect->clear();
    Clause *candClaPtr = candLit.claPtr; //得到被动归结子句
    vector<Literal*>vLeftLit;//保存侯选子句剩余文字
    vLeftLit.reserve(candClaPtr->uLitNum); //定义被动子句文字个数大小的vector
    vector<Term*> chgVarT;
    chgVarT.reserve(16);
    bool isUnify;
    Clause* actClaue = queryLit->claPtr; //得到主动归结子句
    
     if((candClaPtr->compFuncDeepthCla() > StrategyParam::funcFixDeepth) || (actClaue->compFuncDeepthCla() > StrategyParam::funcFixDeepth))
        return fail;
    
    vector<Literal*> vEnqLit;

    //处理主动归结子句中的剩余文字
    //1、若为起步子句
    //	1.1 检查剩余文字是否与归结文字合一相同（删除）
    //	1.2 检查剩余文字之间是否可以合一相同（合并）	
    //	1.3 检查函数嵌套是否超过限制 & 若为基文字则检查包含冗余；
    //	1.4 添加到vNewR
    //2、不为起步子句 将未删除的剩余文字添加到VnewR
    //3、判定vNewR中文字个数是否超过限制，根据情况停止△归结或选择其他归结文字 注：选其他归结文字主要是为了避免起步文字个数超过限制，但一般这种情况不会出现

    UINT32 queryLitPredCode = queryLit->subTerm->iTermCode;
    //1、若为起步子句，只执行一次
    //此为非单元子句的起步子句，将满足条件的文字放入三角形下方，可以互补对的单元子句放入三角形右边，且记录演绎路径
    //2 落入三角形上方的文字idel属性为0
    //R 归结式为处理，将若上三角形上方的文字归入到R归结式
    if (vOutTri->empty()) {
        for (UINT16 i = 0; i < actClaue->uLitNum; ++i) {       
            Literal* actLeftLit = actClaue->LitPtr[i]; //得到主动归结子句文字
            actLeftLit->isDel = 1;//为1表示可以删除，为0表示应放入归结式中
            if (queryLit == actLeftLit) continue; //子句中已归结文字跳出，queryLit需放入三角形对角线中
            isUnify = false; //合并判断标识
            //1.1 检查剩余文字是否与归结文字合一相同（删除），有合并一定要合并
            //20171029 含有变元则需要考虑
            //if (actLeftLit->subTerm->iTermCode == queryLitPredCode && LitMgu(actLeftLit, queryLit, chgVarT)) {
            if (actLeftLit->subTerm->iTermCode == queryLitPredCode && (queryLit->subTerm->hasVarOrBindVar() == false) && LitMgu(actLeftLit, queryLit, chgVarT)) {
                vVarBindT.insert(vVarBindT.end(), chgVarT.begin(), chgVarT.end());
                chgVarT.clear();
                continue;
            }
            ClearVarBind(chgVarT);
            //1.2 20170913检查是否与归结文字是否相同,相同则表示时恒真式
            //20171029
            //if(actLeftLit->subTerm->iTermCode == candLit.subTerm->iTermCode &&LitMgu(actLeftLit, &candLit, chgVarT)) {
             if(actLeftLit->subTerm->iTermCode == candLit.subTerm->iTermCode &&CheckEqn(actLeftLit->subTerm, candLit.subTerm)) { 
                ClearVarBind(chgVarT);
                return TAUTOLOGY;
            }
             ClearVarBind(chgVarT); //不成功删除 变元替换    
            //1.3 检查剩余文字之间是否相同（合并）
            for (UINT16 uCol = i + 1; uCol < actClaue->uLitNum; ++uCol) {
                Literal* actLeftLitB = actClaue->LitPtr[uCol];
                if(actLeftLitB == queryLit)
                    continue;
                if (actLeftLit->subTerm->iTermCode == actLeftLitB->subTerm->iTermCode
                        && CheckEqn(actLeftLit->subTerm, actLeftLitB->subTerm)) //相同删除
                {
                    isUnify = true;
                    break;
                }
                else if(actLeftLitB->isPairPred(actLeftLit)){
                    if(CheckEqn(actLeftLitB->subTerm,actLeftLit->subTerm)){
                        return TAUTOLOGY;
                    }
                }
            }
            if (isUnify)
                continue;
            ClearVarBind(chgVarT);    
            
            //1.4是否与对角线单文字存在合一互补对，若有多个互补对怎么办。目前做法:根据单元子句排序
            if(vOnlyOutTri->size() == 0){
                for (auto& clapCla : fol.setSingleCla) {
                    Literal* clap = clapCla->LitPtr[0];
                    if (actLeftLit->isPairPred(clap) && LitMgu(actLeftLit, clap, chgVarT)) {
//                        if (!clap->claPtr->isSDeduct)
//                            vOnlyOutDect->push_back(clap); //20170112 记录每次被候选子句拉下的单元子句，以备规则检查不合要求时，清除用
//                        clap->claPtr->isSDeduct = true; //20170106 互补文字需要加入演绎路径
                        //第一次添加演绎路径
                        //vOutTri->push_back(clap);//添加演绎路径
                        vVarBindT.insert(vVarBindT.end(), chgVarT.begin(), chgVarT.end());
                        chgVarT.clear();
                        isUnify = true;
                        break;
                    }
                    ClearVarBind(chgVarT); //不成功删除 变元替换 20170112
                }
            }
            else{
                for (auto& clap : (*vOnlyOutTri)) {
                    if (actLeftLit->isPairPred(clap) && LitMgu(actLeftLit, clap, chgVarT)) {
//                        if (!clap->claPtr->isSDeduct)
//                            vOnlyOutDect->push_back(clap); //20170112 记录每次被候选子句拉下的单元子句，以备规则检查不合要求时，清除用
//                        clap->claPtr->isSDeduct = true; //20170106 互补文字需要加入演绎路径
                        //第一次添加演绎路径
                        //vOutTri->push_back(clap);//添加演绎路径
                        vVarBindT.insert(vVarBindT.end(), chgVarT.begin(), chgVarT.end());
                        chgVarT.clear();
                        isUnify = true;
                        break;
                    }
                    ClearVarBind(chgVarT); //不成功删除 变元替换 20170112
                }
            }
            
            if (isUnify)
                continue;
            ClearVarBind(chgVarT);
            //1.5 检查函数嵌套是否超过限制 & 若为基文字则检查包含冗余；
            UINT32 uVarCount = 0;
            if (!CheckMaxFuncLayer(*actLeftLit, uVarCount))
                return MOREFUNC;
            if (actLeftLit->subTerm->uMaxVarId > 0 && 0 == uVarCount && RSubsumption(actLeftLit))
                return RSubsump;
            //将等词放入列表最后来检查
            if (actLeftLit->subTerm->isEqnTerm())
                vEnqLit.push_back(actLeftLit);
            //1.5检查与vNewR中的文字是否相同（不合一）
            if (!vNewR->empty()) {
                for (auto&r : *vNewR) {
                    if (r->subTerm->iTermCode == actLeftLit->subTerm->iTermCode && CheckEqn(r->subTerm, actLeftLit->subTerm)) {
                        isUnify = true;
                        break;
                    }
                }
            }
            if (isUnify) continue;
            //将主动归结文字加入到R中
            actLeftLit->isDel = 0;
            vNewR->push_back(actLeftLit);
            vLeftLitAll.push_back(actLeftLit);
        }
        //此时起步非单元子句下拉的互补对单元子句放入到演绎路径，起步子句剩余文字放入到R中
    }  //else//2、不为起步子句
//    {
//        for (UINT32 i = 0; i < actClaue->uLitNum; ++i) {
//            Literal* actLeftLit = actClaue->LitPtr[i];
//            if (actLeftLit->isDel || queryLit == actLeftLit)
//                continue;
//            //将等词放入列表最后来检查
//            if (actLeftLit->subTerm->isEqnTerm())
//                vEnqLit.push_back(actLeftLit);
//            vNewR->push_back(actLeftLit);
//        }
//
//    }


    //处理被动归结子句中的剩余文字
    //1、检查与queryLit合一相同（换下一个可归结文字）
    //2、与vOutTir中对角线文字是否与归结文字合一相同（换下一个可归结文字）
    //3、检查与vnewR 
    //		3.1 是否 合一互补（恒真换下一个文字）
    //		3.2 是否 合一相等（合并）
    //4、函数嵌套是否超过限制(换下一个可归结文字)			注：起步子句剩余文字也需要检查
    //5、基文字检查是否与单文子包含冗余(换下一个可归结文字)	注：起步子句剩余文字也需要检查，P(x)->P(b)
    
    //此为候选子句，将落入三角形上方的文字idel属性为0，
    //可以互补对的单元子句放入三角形右边，且记录演绎路径
    //2 落入三角形上方的文字idel属性为0
    
    for (UINT16 i = 0; i < candClaPtr->uLitNum; ++i) {
        Literal* postlit = candClaPtr->LitPtr[i];
        postlit->isDel = 1;
        if (postlit == &candLit) continue;
        UINT32 ucandlitPredCode = postlit->subTerm->iTermCode;
        isUnify = false;
        ClearVarBind(chgVarT);
        //2.1检查与queryLit合一相同（换下一个可归结文字）
        //20171029
        //if (ucandlitPredCode == queryLitPredCode && LitMgu(postlit, queryLit, chgVarT)) {
        if (ucandlitPredCode == queryLitPredCode && CheckEqn(postlit->subTerm, queryLit->subTerm)) {
            ClearVarBind(chgVarT);
            return TAUTOLOGY;
        }
        ClearVarBind(chgVarT); //不成功删除 变元替换

        //2.2是否与被动归结文字合一相同(合并) 同子句中是否相同（合并） 等完成△统一检查
        //20171029
        //if (ucandlitPredCode == candLit.subTerm->iTermCode && LitMgu(postlit, &candLit, chgVarT))
        if (ucandlitPredCode == candLit.subTerm->iTermCode && (candLit.subTerm->hasVarOrBindVar() == false) && LitMgu(postlit, &candLit, chgVarT))
        {
        	vVarBindT.insert(vVarBindT.end(), chgVarT.begin(), chgVarT.end());
        	chgVarT.clear();
        	continue;
        }
        ClearVarBind(chgVarT);//不成功删除 变元替换

        /*检查是否与剩余文字相同*/
        //2.3 检查被动归结子句的剩余文字之间是否有相同和互补情况 
        for (UINT16 j = i + 1; j < candClaPtr->uLitNum; ++j) {
            Literal* postlitB = candClaPtr->LitPtr[j];
            if (postlitB == &candLit) continue;
            //是否与自己的剩余文字相同 （删除）
            if (ucandlitPredCode == postlitB->subTerm->iTermCode) {
                if (CheckEqn(postlit->subTerm, postlitB->subTerm)) {
                    isUnify = true;
                    break;
                }
            }                //是否与自己的剩余文字互补恒真 （换子句）
            else if (postlit->isPairPred(postlitB)) {
                if (CheckEqn(postlit->subTerm, postlitB->subTerm)) {
                    return TAUTOLOGY;
                }
            }

        }
        if (isUnify)
            continue;
        ClearVarBind(chgVarT);
        //2、与vOutTir中对角线文字是否合一相同（换下一个可归结文字）
        
//        for (size_t j = 0; j < vOutTri->size(); j += 2) {
//            if (ucandlitPredCode == vOutTri->at(j)->subTerm->iTermCode)//相同谓词
//            {
//                if (LitMgu(postlit, vOutTri->at(j), chgVarT)) //与对角线文字相同，返回重选被动归结子句
//                {
//                    ClearVarBind(chgVarT);
//                    return TAUTOLOGY;
//                }
//            } else if (postlit->isPairPred(vOutTri->at(j))) {
//
//                if (LitMgu(postlit, vOutTri->at(j), chgVarT)) //与对角线文字互补 该文字放到下方
//                {
//                    //互补成功,添加到整体变元替换列表
//                    isUnify = true;
//                    vVarBindT.insert(vVarBindT.end(), chgVarT.begin(), chgVarT.end());
//                    chgVarT.clear();
//                    break;
//                }
//                //不成功删除 变元替换
//                ClearVarBind(chgVarT);
//            }
//
//        }
//        if (isUnify) continue;
        //2.4 是否与对角线单文字存在合一互补对
        if(vOnlyOutTri->size() == 0){
            for (auto& clapCla : fol.setSingleCla) {
                Literal* clap = clapCla->LitPtr[0];
                if (postlit->isPairPred(clap) && LitMgu(postlit, clap, chgVarT)) {
//                    if (!clap->claPtr->isSDeduct)
//                        vOnlyOutDect->push_back(clap); //20170112 记录每次被候选子句拉下的单元子句，以备规则检查不合要求时，清除用
//                    clap->claPtr->isSDeduct = true; //20170106 互补文字需要加入演绎路径
                    //vOutTri->push_back(clap);//添加演绎路径
                    //postlit->isDrop = 1;
                    vVarBindT.insert(vVarBindT.end(), chgVarT.begin(), chgVarT.end());
                    chgVarT.clear();
                    isUnify = true;
                    break;
                }
                ClearVarBind(chgVarT); //不成功删除 变元替换 20170112
            }
        }
        else{
            for (auto& clap : (*vOnlyOutTri)) {
                if (postlit->isPairPred(clap) && LitMgu(postlit, clap, chgVarT)) {
//                    if (!clap->claPtr->isSDeduct)
//                        vOnlyOutDect->push_back(clap); //20170112 记录每次被候选子句拉下的单元子句，以备规则检查不合要求时，清除用
//                    clap->claPtr->isSDeduct = true; //20170106 互补文字需要加入演绎路径
                    //vOutTri->push_back(clap);//添加演绎路径
                    //postlit->isDrop = 1;
                    vVarBindT.insert(vVarBindT.end(), chgVarT.begin(), chgVarT.end());
                    chgVarT.clear();
                    isUnify = true;
                    break;
                }
                ClearVarBind(chgVarT); //不成功删除 变元替换 20170112
            }
        }
        
        if(isUnify)
            continue;
        ClearVarBind(chgVarT);
        //3、检查vnewR中的文字是否与剩余文字相同，相同则删除原有剩余文字
        //检查与前面句剩余文字是否相同\互补--因为 主动归结子句的剩余文字已经放入vNewR中因此直接检查是否与 vNewR中的文字相同或互补即可。
        for (size_t j = 0; j < vNewR->size(); ++j) {
            if (ucandlitPredCode == vNewR->at(j)->subTerm->iTermCode)//相同谓词
            {
                if (CheckEqn(postlit->subTerm, vNewR->at(j)->subTerm))//与剩余文字相同（合并）				
                {
                    //isUnify = true;  //删除剩余文字集中的文字
                    vNewR->erase(vNewR->begin() + j);
                    break;
                }
            } else if (postlit->isPairPred(vNewR->at(j))) {
                if (CheckEqn(postlit->subTerm, vNewR->at(j)->subTerm))//恒真，返回重选被动归结子句
                {
                    return TAUTOLOGY;
                }

            }

        }

        /*if (isUnify)
                continue;*/
        UINT32 litVarCount = 0;
        if (!CheckMaxFuncLayer(*postlit, litVarCount)) {
            //函数复合层超过限制，规则检查失败 恢复替换并且换子句 
            string sMsg = to_string(postlit->Row()) + "_" + to_string(postlit->Col()) + "函数层超过限制";
            FileOp::LogOut(sMsg);
            return MOREFUNC;
        }
        if (postlit->subTerm->uMaxVarId > 0 && 0 == litVarCount && RSubsumption(postlit)) //变成常元项 需要检查冗余 和单文字子句检查 
        {
            return RSubsump;
        }
        //将等词放入列表最后来检查
        if (postlit->subTerm->isEqnTerm())
            vEnqLit.push_back(postlit);
        postlit->isDel = 0;
        vLeftLit.push_back(postlit);
        vLeftLitAll.push_back(postlit);
    }

    //检查剩余文字+前面的R是否超过文字限制；
    if (vLeftLit.size() + vNewR->size() > StrategyParam::R_MAX_NUM_NOPAIR)
        return MORELIT;

    //添加等词恒真规则 
    if (!vEnqLit.empty()) {
        for (auto&eqnLit : vEnqLit) {
            if (TEqn == GetCodeProp(eqnLit->subTerm->iTermCode)) //正文字等词检查是否恒真
            {
                if (CheckEqn(eqnLit->subTerm->subTermPtr[0], eqnLit->subTerm->subTermPtr[1]))
                    return EqnTautology;
            }

        }
    }

    return RULEOK;
}
//20170901 以下用于等词处理
//1.单项项合一
//注:不能两个同时为函数项,两个都为函数项时,单独处理
//20170902 特别注意:等词项的替换项需要及时清除,只保留调解项的替换项
bool Unify::TermMguEqn(Term* termA, Term* termB, vector<Term*>& varChgOnce, vector<Term*>& varChgOnceEqn) {
    //定义堆栈用于存储 函数项
//    Term* termA = litA->subTerm;
//    Term* termB = litB->subTerm;
    if (termA == termB)
        return true;

    //cout << "termB:"; termB->Print(); cout << "= ";
    Term* tA;
    Term* tB;

    tA = GetBindingT(termA);
    tB = GetBindingT(termB);
    if (tA == tB) {
        return true;
    }
    if (IsVar(tA)) {
        //cout << "tA:"; tA->Print(); cout << "->"; tB->Print();  cout << endl;
        if (!OccurCheck(tA, tB, varChgOnce))
            return false;
        else
            return true;
    } else if (IsVar(tB)) {
        //cout << "tB:"; tB->Print(); cout << "->"; tA->Print(); cout << endl;
        if (!OccurCheck(tB, tA, varChgOnceEqn))
            return false;
        else
            return true;
    } else if (tA->uVarCount > 0)//非基函数项
    {
        assert(tA->uSubTermNum > 0);

        if (tB->uSubTermNum > 0) //为函数项 非基函数项或共享基函数项
        {
            if (tA->iTermCode != tB->iTermCode) return false;
        } else
            return false;
    } else if (tB->uVarCount > 0)//非基函数项
    {
        assert(tB->uSubTermNum > 0);
        if (tA->uSubTermNum > 0) //为函数项 非基函数项或共享基函数项
        {
            if (tA->iTermCode != tB->iTermCode) return false;
        } else
            return false;
    } else if (tA != tB) {
        assert(tA->uVarCount == 0 && tB->uVarCount == 0);
        return false;
    }
    //如果两个都是函数项的情况
    return false;
}
//20171028 比较文字项的包含关系,比较方法:如果文字p1可以单向合一为另一个文字p2.则表示p1包含p2,如p1=p(x) p2=p(a)
bool Unify::litASmallLitB(Term* termA, Term* termB, vector<Term*>& varChgOnce) {
    //定义堆栈用于存储 函数项
    if (termA == termB)
        return true;
    
    //cout << "termB:"; termB->Print(); cout << "= ";
    vector<Term*> stactTerm;
    Term* tA;
    Term* tB;
    UINT8 i;//UINT8
    do {
        if (termA->uSubTermNum != termB->uSubTermNum) 
            return false;
        i = 0;
        while (i < termA->uSubTermNum) 
        {
            tA = GetBindingT(termA->subTermPtr[i]);
            tB = GetBindingT(termB->subTermPtr[i]);
            if (tA == tB) {
                ++i;
                continue;
            }
            if (IsVar(tA)) {
                //cout << "tA:"; tA->Print(); cout << "->"; tB->Print();  cout << endl;
                if (!OccurCheckModul(tA, tB, varChgOnce))//20170923 不允许变元项替换成常元项或函数项,只能做单项替换
                    return false;
            } 
            else if (IsVar(tB)) {
                //cout << "tB:"; tB->Print(); cout << "->"; tA->Print(); cout << endl;
                if (!OccurCheck(tB, tA, varChgOnce))
                    return false;
            }
            else if (tA->uVarCount > 0)//非基函数项
            {
                assert(tA->uSubTermNum > 0);

                if (tB->uSubTermNum > 0) //为函数项 非基函数项或共享基函数项
                {
                    if (tA->iTermCode != tB->iTermCode) return false;
                    stactTerm.push_back(tA);
                    stactTerm.push_back(tB);
                } else
                    return false;
            } 
            else if (tB->uVarCount > 0)//非基函数项
            {
                assert(tB->uSubTermNum > 0);
                if (tA->uSubTermNum > 0) //为函数项 非基函数项或共享基函数项
                {
                    if (tA->iTermCode != tB->iTermCode) return false;
                    stactTerm.push_back(tA);
                    stactTerm.push_back(tB);
                } else
                    return false;
            } 
            else if (tA != tB) {
                assert(tA->uVarCount == 0 && tB->uVarCount == 0);
                return false;
            }
            ++i;
        }
        if (stactTerm.empty())break;
        termB = stactTerm.back();
        stactTerm.pop_back();
        termA = stactTerm.back();
        stactTerm.pop_back();
        assert(termA->iTermCode == termB->iTermCode);
    } while (1);
    return true;
}

//2.单项项合一
//20170902 特别注意:等词项的替换项需要及时清除,只保留调解项的替换项 termA不能变元替换成其它项  termB为等词项 只能是termB做变元替换
bool Unify::pairFuncTermMguEqn(Term* termA, Term* termB, vector<Term*>& varChgOnce, vector<Term*>& varChgOnceEqn) {
    //定义堆栈用于存储 函数项
    if (termA == termB)
        return true;
    
    //cout << "termB:"; termB->Print(); cout << "= ";
    vector<Term*> stactTerm;
    Term* tA;
    Term* tB;
    UINT8 i;//UINT8
    do {
        if (termA->uSubTermNum != termB->uSubTermNum) 
            return false;
        i = 0;
        while (i < termA->uSubTermNum) 
        {
            tA = GetBindingT(termA->subTermPtr[i]);
            tB = GetBindingT(termB->subTermPtr[i]);
            if (tA == tB) {
                ++i;
                continue;
            }
            if (IsVar(tA)) {
                //cout << "tA:"; tA->Print(); cout << "->"; tB->Print();  cout << endl;
                if (!OccurCheckModul(tA, tB, varChgOnce))//20170923 不允许变元项替换成常元项或函数项,只能做单项替换
                    return false;
            } 
            else if (IsVar(tB)) {
                //cout << "tB:"; tB->Print(); cout << "->"; tA->Print(); cout << endl;
                if (!OccurCheck(tB, tA, varChgOnceEqn))
                    return false;
            }
            else if (tA->uVarCount > 0)//非基函数项
            {
                assert(tA->uSubTermNum > 0);

                if (tB->uSubTermNum > 0) //为函数项 非基函数项或共享基函数项
                {
                    if (tA->iTermCode != tB->iTermCode) return false;
                    stactTerm.push_back(tA);
                    stactTerm.push_back(tB);
                } else
                    return false;
            } 
            else if (tB->uVarCount > 0)//非基函数项
            {
                assert(tB->uSubTermNum > 0);
                if (tA->uSubTermNum > 0) //为函数项 非基函数项或共享基函数项
                {
                    if (tA->iTermCode != tB->iTermCode) return false;
                    stactTerm.push_back(tA);
                    stactTerm.push_back(tB);
                } else
                    return false;
            } 
            else if (tA != tB) {
                assert(tA->uVarCount == 0 && tB->uVarCount == 0);
                return false;
            }
            ++i;
        }
        if (stactTerm.empty())break;
        termB = stactTerm.back();
        stactTerm.pop_back();
        termA = stactTerm.back();
        stactTerm.pop_back();
        assert(termA->iTermCode == termB->iTermCode);
    } while (1);
    return true;
}

//20170901 以下用于等词处理,调解后生成新的子句
//oldT 谓词项
Term* Unify::GetNewTermSuper(Term* oldT, Clause* newCla) {
//    if(newCla->uClaId == 34){
//        //oldT->Print();
//        cout<<"cf-debug"<<endl;
//    }
    if ((oldT->uVarCount == 0) && !(oldT->IsExistNoVarBind())) //说明本身oldT就为共享基函数 直接返回
        return oldT;
    Term* newT = new Term(oldT->iTermCode);
    newT->subTermPtr = new Term*[oldT->uSubTermNum];
    newT->uSubTermNum = oldT->uSubTermNum;
    Term* oldSubT;
    for (UINT8 i = 0; i < oldT->uSubTermNum; ++i) {
        //oldT->subTermPtr[i]->Print(); cout << endl;
        oldSubT = GetBindingT(oldT->subTermPtr[i]); //得到项的绑定	
        //oldSubT->Print(); cout << endl;
        if (oldSubT->iTermCode < 0) //变元
        {

            UINT16 uTmpMaxVarId;
            newT->subTermPtr[i] = newCla->VBInsert(oldSubT->iTermCode, uTmpMaxVarId);
            newT->subTermPtr[i]->uVarCount = 1;

            if (uTmpMaxVarId > 0)
                newT->uMaxVarId = uTmpMaxVarId;
            ++newT->uVarCount;

        } else if ((0 == oldSubT->uVarCount) && !(oldSubT->IsExistNoVarBind())) //比较项为基函数项（常元或共享基函数项）  一定是存储在g_hashTree中的。
        {
            newT->subTermPtr[i] = oldSubT;
            if (oldSubT->uSubTermNum > 0) {
                newT->uLevel = newT->subTermPtr[i]->uLevel + 1; //函数嵌套层
                newT->fSteadyValue += newT->subTermPtr[i]->fSteadyValue * 0.5f; //稳定度	
            } else
                ++(newT->fSteadyValue); //稳定度计算
        } else //函数项
        {
            assert(oldSubT->uSubTermNum > 0);

            newT->subTermPtr[i] = GetNewTermSuper(oldSubT, newCla);
            newT->uLevel = newT->subTermPtr[i]->uLevel + 1; //函数嵌套层
            newT->fSteadyValue += newT->subTermPtr[i]->fSteadyValue * 0.5f; //稳定度	
            newT->uVarCount += newT->subTermPtr[i]->uVarCount; //变元数

            if (newT->uMaxVarId < newT->subTermPtr[i]->uMaxVarId)
                newT->uMaxVarId = newT->subTermPtr[i]->uMaxVarId;
        }
    }

    //注:若该函数本身为共享基函数，则不会进入这个方法调用因此 这里肯定是非基函数
    //A、若没有变元则说明通过替换变为了共享基函数
    //B、有变元则插入到子句的共享非基函数hashtree中

    if (newT->uVarCount > 0)//非基函数项
        newT = newCla->InsertVarFuncTerm(newT); //插入非基函数项			
    else
        newT = HashTree::InsertHashTree(newT, g_HashTree); //插入基函数项		
    assert(newT->uSubTermNum > 0);

    newT->fSteadyValue /= (1.0f * newT->uSubTermNum);
    return newT;

}