/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   TriAlg.h
 * Author: sjg
 *
 * Created on 2016年11月30日, 下午4:13
 */

#ifndef TRIALG_H
#define TRIALG_H
#include "Clause.h"
#include "Literal.h"
#include "Term.h"
#include "SortRule.h"
#include "Unify.h"
#include "dataTypeDef.h"
#include "globalFunc.h"
#include "Formula.h"
#include "Subsumption.h"
class TriAlg {
public:
    /****Liu****/
    Unify unify;
    Clause* newCla;
    
    vector<Literal*> vOnlyOutTri;//存放实际摆放的对角线文字
    vector<Literal*> vNewR; //存放剩余文字--不做任何合并以便回退路径的正确
    vector<Clause*> vNewClas;   //restore the newly generated clauses
    vector<Clause*> candClas;    //the clause set of the candidate clauses
    
    set<Clause*> setCpClas; //restore the copy clauses
    
    RESULT DoTri_Goal(Formula& fol, UINT32 &newClaId);
    /***********/
    /************************************************************************/
    /* 输出                                                                  */
    /************************************************************************/
    vector<Literal*> vOutTri; //存放构建三角形过程中的演绎文字
    
    vector<Literal*> vOnlyOutTriCmp;//存放单纯的对角线文字  //只存放主界线上的单元子句
    
    set<UINT32> setRedundClaId; //记录导致冗余的子句，在路径回退的时候不在与之归结
    set<UINT32> processedBinaryClaId;   //Liu 记录已经处理过的二元子句Id
    
    
    vector<Literal*> setRealRedundClaId; //记录导致冗余的子句，在路径回退的时候不在与之归结
    set<UINT32> ResClaID; //已经归结过的子句ID，不再比较；
    vector<Clause*> saveCopyCla; //存储拷贝已经归结过的子句；
    vector<Clause*>ResClaPtr; //已经归结过的子句指针，用于清除涉及到的文字项变元binding。NOTE：这里需要再仔细考虑下，优化点
    vector<UINT32> StactID; //堆栈-记录每次被归结的文字所在集合的序号，用于回退
    vector<UINT16> vComparePos; //记录合一的位置，以便回退
    
    
    UINT32 singleClaNum;//记录单文字子句的大小
    
    vector<Literal*> vOnlyOutDect;//存放已归结的对角线文字
    vector<Literal*> vOnlyDectNum; //记录本次演绎的互补对单元子句个数
    set <Clause* >::iterator setClaIt;//指向单文字子句集合
     set<UINT32> noCmpCla;//用于记录无互补对单元子句编号
     set<UINT32> setDuctCla;//记录已归结子句,类似activity做法，注意在一定条件下需要还原原始子句集
     
     //map<UINT32,UINT32> singlePair;//20170210  用于计算单文字子句有多少个互补子句
     bool flagT;//20170210 用于控制计算单文字子句的初始轮数 //为true，表示需要初始化迭代次数，false已经初始化完毕，不再初始化
     UINT32 startCluId;//记录三角形构建的起始子句编号
     bool allNoPair;//20170214 用于判断是否全部的主对角线文字都没有找到满足条件的归结子句
     vector<Literal*> claPair;//20170216 用于记录子句三角形演绎归结的所有单元子句
     Literal* firstR;//20170216 用于记录三角形演绎第一次出现剩余R时的主对角线文字
     clock_t start;//用于设定时间
     UINT16 total_Loop;//用于记录起步子句构建的三角形总个数
     set<UINT32> hasCpUintClaId; //记录已经拷贝的单元子句
      //以下用于等词处理
    vector<Term*> varBindTerm;//存放等词处理的替换项
    //TriAlg();
    TriAlg(const TriAlg& orig);
    virtual ~TriAlg();
    TriAlg() 
    {
        unify.vOutTri = &vOutTri; 
        unify.vNewR = &vNewR; 
        unify.vOnlyOutTri = &vOnlyOutTri;
        unify.singleClaNum = singleClaNum;
        unify.vOnlyOutDect = &vOnlyOutDect;
        unify.vOnlyDectNum = &vOnlyDectNum;
        unify.saveCopyCla = &saveCopyCla;
        unify.hasCpUintClaId = &hasCpUintClaId;
        flagT = false;
        allNoPair = false;
        firstR = nullptr;
        total_Loop = 0;
    }
    /**********************************************************/
    //生成三角形 - 记录路径
    UINT8 GenerateTriByRecodePath(Formula& fol,Clause* givenCla, UINT32 &newClaId, BACKTYPE _backType,vector<Clause*> &chgCla,UINT16& loop_Num);
    UINT8 GenerateTriByRecodePathLR(Formula& fol, vector<Clause*>& candidateClaSet, UINT32 &newClaId, BACKTYPE _backType, vector<Clause*> &chgCla,UINT16& loop_Num);//从左到右构建三角形
    UINT8 GenerateTriByRecodePathLRCancelLimit(Formula& fol, vector<Clause*>& candidateClaSet, UINT32 &newClaId, BACKTYPE _backType, vector<Clause*> &chgCla,UINT16& loop_Num);//从左到右构建三角形
    UINT8 GenerateTriByRecodePathLRCombined(Formula& fol, vector<Clause*>& candidateClaSet, UINT32 &newClaId, BACKTYPE _backType, vector<Clause*> &chgCla, UINT16& loop_Num);
    UINT8 GenerateTriByRecodePathLRCombined2(Formula& fol, vector<Clause*>& candidateClaSet, UINT32 &newClaId, BACKTYPE _backType, vector<Clause*> &chgCla, UINT16& loop_Num);
    UINT8 GenerateTriByRecodePathLROptimalProofSearch(Formula& fol, vector<Clause*>& candidateClaSet, UINT32 &newClaId, BACKTYPE _backType, vector<Clause*> &chgCla,UINT16& loop_Num);//从左到右构建三角形
    //Liu
    UINT8 GenerateTriByRecodePathLRFullUseBinaryClause(Formula& fol, vector<Clause*>& candidateClaSet, UINT32 &newClaId, BACKTYPE _backType, vector<Clause*> &chgCla);
    
    bool hasUintClaUnify(Formula& fol, Clause* givenCla);
    //Liu
    UINT16 BinaryClaDeduction(Formula& fol, vector<Clause*>& candidateClaSet_binary, UINT32& newClaId, vector<Clause*>& chgCla, const UINT32& firstIndex, const UINT32& lastIndex);
    UINT16 NotBinaryClaDeduction(Formula& fol, vector<Clause*>& candidateClaSet_notBinary, vector<Clause*>& candidateClaSet_binary, UINT32& newClaId, vector<Clause*>& chgCla, UINT32& firstIndex, UINT32& lastIndex);
    UINT16 NotBinaryClaDeduction2(Formula& fol, vector<Clause*>& candidateClaSet_notBinary, vector<Clause*>& candidateClaSet_binary, UINT32& newClaId, vector<Clause*>& chgCla, UINT32& firstIndex, UINT32& lastIndex);
    UINT16 NotBinaryClaDeduction3(Formula& fol, vector<Clause*>& candidateClaSet_notBinary, UINT32& newClaId, vector<Clause*>& chgCla);
    UINT16 SecondFormTriProcess(Formula& fol, UINT32& newClaId, Clause* givenCla);
    UINT16 ThirdFormTriProcess(Formula& fol, UINT32& newClaId, Literal* lit);
    UINT16 FourthFormTriProcess(Formula& fol, UINT32& newClaId, vector<Literal*>& vInsertNewR, vector<Clause*>& discardClas);
    UINT16 ProduceAndProcessR(Formula& fol, UINT32& newClaId, bool isFlat);
    UINT16 ProduceNewClause(Formula& fol, vector<Literal*>& vLit, const UINT32& newClaId);
    void PathBack(const int lastvOutTriSize, const int lastRSize, const int lastMainLits);
    void PrintTriAndOutputR(const UINT32& startClaId);
    void PrintTriAndOutputR(const UINT32& startClaId, vector<Clause*>& discardClas);
    void LitRedunduntInR(vector<Literal*>& vLitR, vector<Clause*>& discardClas, bool isFlat);
    void DeleteRepeatingLitFromVector(vector<Literal*>& vLits);
    
    
    bool claHasPureLit(Formula& fol, Clause* givenCla);
    bool hasUnifGoalCla(Formula& fol, Clause* givenCla);
    bool hasUnifGoalLit(Formula& fol, Literal* lit);
    UINT32 realUnifyCounts(Formula& fol, Clause* givenCla);
    UINT16 resRandomNumber(UINT16 totalNum);//生成随机数
    Clause* copyCla(Formula& fol, Clause* cla, UINT32& uNewClaID,Literal* copyFrom, Literal* copyTo);//拷贝子句
    void delSaveCopyCla(Formula& fol);//删除拷贝的子句
    int copyClaCopyTimes(Clause* cla);//计算子句拷贝了多少次
    //清除路径
    void BackPathClear();
    //Clause* BackPath(BACKTYPE _backType);
    //void stackVarChgPopBack();
    //输出三角形 演绎路径
   UINT8 GenerateTriByRecodePathNoUnit(Formula& fol, Clause* givenCla, UINT32 &newClaId, BACKTYPE _backType, vector<Clause*> &chgCla);
   //20171025 以下用于判断等词调解后的冗余
   bool judgeDemodRedundent(Formula& fol,Clause* cla,UINT32& uNewClaID);
   int demodulatorLitSaturate(Formula& fol,Literal* lit,vector<Clause*>* eqnLit);
   int demodulatorTermSaturate(Formula& fol,Term* term,vector<Clause*>* eqnLit);
   string PrintCompetitionOut(UINT32 rId);
   string PrintCompetitionOut_eFormat(UINT32 rId);
    UINT32 PrintTriPath() {
        UINT32 realStartId = 0;
        bool flag = true;//用于记录第一个三角形输出的子句编号
        for (auto& pathLit : vOutTri)//输出到演绎结果中
        {
            if(flag){
                flag = false;
                realStartId = pathLit->claPtr->uClaId;
            }
            //cout<<"vOutTri="<<vOutTri.size()<<endl;
            //cout<<pathLit->subTerm->ToString()<<endl;
             if(pathLit->claPtr->isSDeduct)
             {
                 //pathLit->claPtr->Print();
                 //cout<<pathLit->subTerm->ToString()<<endl;
                 //unify.WriteTriPath(pathLit);
                 
              /*  if(row != pathLit->Row())
                    *FileOp::ofRealInfoOut<<endl;
                else
                    *FileOp::ofRealInfoOut<<"+";
                if(pathLit ->claPtr ->uLitNum == 1)
                    *FileOp::ofRealInfoOut <<"[C"  + to_string(pathLit -> claPtr ->uClaId)  + "]"<< pathLit->subTerm->ToStringBind();  
                else
                    *FileOp::ofRealInfoOut <<"[C" + to_string(pathLit->Row()) + "_"+ to_string(pathLit->Col())+"]" << pathLit->subTerm->ToStringBind();  
                 //cout <<"[C" + to_string(pathLit->Row()) + "_"+ to_string(pathLit->Col())+"]" << pathLit->subTerm->ToStringBind()<<endl;  
                //cout<<"中间单文字子句1[C" + to_string(clap->uClaId)  + "]" << clap->LitPtr[0]->subTerm->ToString()<<endl;  
                row = pathLit->Row();
                */
                 
                 //输出到演绎结果中	
                 if(!(pathLit->claPtr->isUse))
                    pathLit->claPtr->isUse = true;
                 //输出到演绎结果中
                unify.WriteTriPath(pathLit);
             }
                  //row = pathLit->Row();
        }
        //*FileOp::ofRealInfoOut<<endl;
        return realStartId;
    }
    
    
    
    void PrintTriTwoPath() {
        INT32 row = -1;
        for (auto& pathLit : vOutTri)//输出到演绎结果中
        {
            //cout<<"vOutTri="<<vOutTri.size()<<endl;
            //cout<<pathLit->subTerm->ToString()<<endl;
             if(pathLit->claPtr->isSDeduct)
             {
                 //pathLit->claPtr->Print();
                 //cout<<pathLit->subTerm->ToString()<<endl;
                 //unify.WriteTriPath(pathLit);
                 
              /*  if(row != pathLit->Row())
                    *FileOp::ofRealInfoOut<<endl;
                else
                    *FileOp::ofRealInfoOut<<"+";
                if(pathLit ->claPtr ->uLitNum == 1)
                    *FileOp::ofRealInfoOut <<"[C"  + to_string(pathLit -> claPtr ->uClaId)  + "]"<< pathLit->subTerm->ToStringBind();  
                else
                    *FileOp::ofRealInfoOut <<"[C" + to_string(pathLit->Row()) + "_"+ to_string(pathLit->Col())+"]" << pathLit->subTerm->ToStringBind();  
                 //cout <<"[C" + to_string(pathLit->Row()) + "_"+ to_string(pathLit->Col())+"]" << pathLit->subTerm->ToStringBind()<<endl;  
                //cout<<"中间单文字子句1[C" + to_string(clap->uClaId)  + "]" << clap->LitPtr[0]->subTerm->ToString()<<endl;  
                row = pathLit->Row();
                */
                 
                 //输出到演绎结果中	
//                 if(!(pathLit->claPtr->isUse))
//                    pathLit->claPtr->isUse = true;
                 //输出到演绎结果中
                unify.WriteTriPath(pathLit);
             }
                  //row = pathLit->Row();
        }
        //*FileOp::ofRealInfoOut<<endl;
    }
private:
    //重走类型,NEXT_ASSIGN-指定下轮归结文字，NEXT_AVOID下轮归结避免的文字
    //enum REPATH_TYPE{ NEXT_NONE, NEXT_ASSIGN, NEXT_AVOID };
    //参与归结的子句位置 FIRST--第一个子句,MID中间过程的子句,LAST--最后一个子句

    enum RESCLAPOS {
        FIRST, MID, LAST
    };
    //记录路径--使用堆栈，记录每次归结后变元项的替换情况
    vector<vector<Term*>> stackVarChg;


    /************************************************************************/
    /* 输入                                                                  */
    /************************************************************************/
    //Formula* formula;

    /************************************************************************/
    /* 重走路径以及归结过程中需要的参数                                            */
    /************************************************************************/
    Literal* PreResLit; //上一轮归结过的文字	
    Literal* pNextAssignLit; //重走路径后强行选定的文字
    UINT8 uNextAssiLitCol; //下次归结指派文字迭代器
    UINT32 uNextAvodLitCol; //下次归结避免归结文字迭代器
    //重走路径后不能作为匹配的文字
    Literal* pNextAvoidLit;
    //REPATH_TYPE repathType;//重走路径的类型
    
    FORMTRI formTri;    //三角形的形状
    bool globalDeduct;  //整个三角形的是否有子句参与演绎
    
    //LiuDebug
    bool firstRun = true;
    bool isFull = false;
};

#endif /* TRIALG_H */

