/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   TriAlg.cpp
 * Author: sjg
 * 
 * Created on 2016年11月30日, 下午4:13
 */

#include "TriAlg.h"
#include "Formula.h"
#include "dataTypeDef.h"

map<INT32, vector<INT32>> validPathOut;
TriAlg::TriAlg(const TriAlg& orig) {
}

TriAlg::~TriAlg() {
}
//判断子句是否有单元子句可以合一

bool TriAlg::hasUintClaUnify(Formula& fol, Clause* givenCla) {
    UINT32 lens = vOnlyOutTri.size();
    if ((lens == 0) || (fol.setSingleCla.size() == 0)) {
        return false;
    } else {
        for (UINT16 ActLitInd = 0; ActLitInd < givenCla->uLitNum; ++ActLitInd) {
            Literal* QLit = givenCla->LitPtr[ActLitInd];
            vector<Term*> chgVarT;
            chgVarT.reserve(6);
            for (auto& aClap : fol.setSingleCla) {
                //20170215 需要好好思考判断，单元子句组合问题
                if (QLit->isPairPred(aClap->LitPtr[0]) && unify.LitMgu(QLit, aClap->LitPtr[0], chgVarT)) {
                    unify.ClearVarBind(chgVarT);
                    return true;
                } else {
                    unify.ClearVarBind(chgVarT);
                }
            }
            unify.ClearVarBind(chgVarT);
            vector<Term*>().swap(chgVarT);
        }
        return false;
    }
}

//output competition deductive path

string TriAlg::PrintCompetitionOut(UINT32 rId) {
    string out = "";
    set<UINT32> claId;
    for (auto& pathLit : vOutTri)//输出到演绎结果中
    {
        Clause* cla = pathLit->claPtr;
        if (cla->isSDeduct) {
            if (claId.find(cla->uClaId) == claId.end()) {
                claId.insert(cla->uClaId);
                validPathOut[rId].push_back(cla->uClaId);
            } else
                continue;
            out += to_string(cla->uClaId) + ",";
        }
    }
    size_t pos = out.find_last_of(",");
    out = out.substr(0, pos);
    claId.clear();
    return out;
}

string TriAlg::PrintCompetitionOut_eFormat(UINT32 rId) {
    string out = "";
    set<UINT32> claId;
    for (auto& pathLit : vOutTri)//输出到演绎结果中
    {
        Clause* cla = pathLit->claPtr;
        if (cla->isSDeduct) {
            if (claId.find(cla->uClaId) == claId.end()) {
                claId.insert(cla->uClaId);
                validPathOut[rId].push_back(cla->uClaId);
            } else
                continue;
            out += "c_0_" + to_string(cla->uClaId) + ",";
        }
    }
    size_t pos = out.find_last_of(",");
    out = out.substr(0, pos);
    claId.clear();
    return out;
}

//判断子句是否含有纯文字

bool TriAlg::claHasPureLit(Formula& fol, Clause* givenCla) {
    if (StrategyParam::delPureCla == false)
        return false;
    vector<Literal*>* vCandLit;
    Clause* candClaP = nullptr;
    Literal* candLitP = nullptr;
    vector<Term*> chgVarTemp;
    chgVarTemp.reserve(6);
    bool resFlag = true;
    for (UINT16 ActLitInd = 0; ActLitInd < givenCla->uLitNum; ++ActLitInd) {
        resFlag = true;
        Literal* QLit = givenCla->LitPtr[ActLitInd];
        //        //如果是等词,则要跳过
        //        if(QLit->subTerm->isEqnTerm()){
        //            continue;
        //        }
        vCandLit = QLit->getPairPredLst();
        for (UINT32 pasLitInd = 0; pasLitInd < UINT32(vCandLit->size()); ++pasLitInd)//依次找到
        {
            candLitP = vCandLit->at(pasLitInd);
            if (unify.LitMgu(QLit, candLitP, chgVarTemp)) {
                unify.ClearVarBind(chgVarTemp);
                vector<Term*>().swap(chgVarTemp);
                resFlag = false;
                break;
            } else
                unify.ClearVarBind(chgVarTemp);
        }
        if (resFlag) {//含有纯文字
            return true;
        }
    }
    unify.ClearVarBind(chgVarTemp);
    vector<Term*>().swap(chgVarTemp);
    return false;
}




//20160916 判断子句能否与目标子句互补对

bool TriAlg::hasUnifGoalCla(Formula& fol, Clause* givenCla) {
    vector<Literal*>* vCandLit;
    Clause* candClaP = nullptr;
    Literal* candLitP = nullptr;
    vector<Term*> chgVarTemp;
    chgVarTemp.reserve(6);
    bool resFlag = false;
    for (UINT16 ActLitInd = 0; ActLitInd < givenCla->uLitNum; ++ActLitInd) {
        Literal* QLit = givenCla->LitPtr[ActLitInd];
        vCandLit = QLit->getPairPredLst();
        for (UINT32 pasLitInd = 0; pasLitInd < UINT32(vCandLit->size()); ++pasLitInd)//依次找到
        {
            candLitP = vCandLit->at(pasLitInd);
            if (!candLitP->claPtr->isGoal)
                continue;
            if (unify.LitMgu(QLit, candLitP, chgVarTemp)) {
                unify.ClearVarBind(chgVarTemp);
                vector<Term*>().swap(chgVarTemp);
                resFlag = true;
                break;
            } else
                unify.ClearVarBind(chgVarTemp);
        }
        if (resFlag)
            break;
    }
    unify.ClearVarBind(chgVarTemp);
    vector<Term*>().swap(chgVarTemp);
    return resFlag;
}
//20160916 判断子句能否与目标子句互补对

bool TriAlg::hasUnifGoalLit(Formula& fol, Literal* lit) {
    Clause* candClaP = nullptr;
    Literal* candLitP = nullptr;
    vector<Term*> chgVarTemp;
    chgVarTemp.reserve(6);
    bool resFlag = false;
    Literal* QLit = lit;
    for (auto &aClp : fol.saveGoalClaSet) {
        for (UINT32 pasLitInd = 0; pasLitInd < aClp->uLitNum; ++pasLitInd)//依次找到
        {
            candLitP = aClp->LitPtr[pasLitInd];
            if (QLit->isPairPred(candLitP) && unify.LitMgu(QLit, candLitP, chgVarTemp)) {
                unify.ClearVarBind(chgVarTemp);
                vector<Term*>().swap(chgVarTemp);
                resFlag = true;
                break;
            } else
                unify.ClearVarBind(chgVarTemp);
        }
        if (resFlag)
            break;
    }
    unify.ClearVarBind(chgVarTemp);
    vector<Term*>().swap(chgVarTemp);
    return resFlag;
}
//得到子句可以互补合一的总个数

UINT32 TriAlg::realUnifyCounts(Formula& fol, Clause* givenCla) {
    UINT32 count = 0;
    vector<Literal*>* vCandLit;
    Clause* candClaP = nullptr;
    Literal* candLitP = nullptr;
    vector<Term*> chgVarTemp;
    chgVarTemp.reserve(6);
    for (UINT16 ActLitInd = 0; ActLitInd < givenCla->uLitNum; ++ActLitInd) {
        Literal* QLit = givenCla->LitPtr[ActLitInd];
        //        //如果是等词,则要跳过
        //        if(QLit->subTerm->isEqnTerm()){
        //            continue;
        //        }
        vCandLit = QLit->getPairPredLst();

        for (UINT32 pasLitInd = 0; pasLitInd < UINT32(vCandLit->size()); ++pasLitInd)//依次找到
        {
            candLitP = vCandLit->at(pasLitInd);
            //            if(StrategyParam::useSaturate){
            //                if(fol.setDeductCla.find(candLitP->claPtr) != fol.setDeductCla.end())
            //                    continue;
            //            }
            if (unify.LitMgu(QLit, candLitP, chgVarTemp)) {
                unify.ClearVarBind(chgVarTemp);
                ++count;
                continue;
            } else
                unify.ClearVarBind(chgVarTemp);
        }
    }
    unify.ClearVarBind(chgVarTemp);
    vector<Term*>().swap(chgVarTemp);
    return count;
}
//清除路径

void TriAlg::BackPathClear() {
    if (stackVarChg.empty())
        return;
    //concurrency::parallel_for_each(stackVarChg.begin(), stackVarChg.end(), [](vector<varBindPtr>& termLst)
    for (auto&termLst : stackVarChg)// .begin(), stackVarChg.end(), [](vector<varBindPtr>& termLst)
    {
        if (!termLst.empty()) {
            unify.ClearVarBind(termLst);
        }
    }
    vector<vector < Term*>>().swap(stackVarChg);

}

UINT16 TriAlg::resRandomNumber(UINT16 totalNum) {
    return (rand() % totalNum) + 1;
}

void TriAlg::delSaveCopyCla(Formula& fol) {
    if (saveCopyCla.size() == 0)
        return;
    for (UINT32 m = 0; m < saveCopyCla.size(); ++m) {
        //        if(saveCopyCla[m]->uClaId == 3034)
        //            cout<<"cf-debug"<<endl;
        if (StrategyParam::useSaturate) {
            set<Clause*>::iterator claP_it = fol.setDeductCla.find(saveCopyCla[m]);
            if (claP_it != fol.setDeductCla.end())
                fol.setDeductCla.erase(claP_it);
            //        set<Clause*>::iterator claP_itOrg = fol.setCla.find(saveCopyCla[m]);
            //        if (claP_itOrg != fol.setCla.end())
            //            fol.setCla.erase(claP_itOrg);
            //        set<Clause*>::iterator claP_itNoUint = fol.noPairSingleCla.find(saveCopyCla[m]);
            //        if (claP_itNoUint != fol.noPairSingleCla.end())
            //            fol.noPairSingleCla.erase(claP_itNoUint);
            //         set<Clause*> ::iterator delItEqn = fol.eqnDemod.find(saveCopyCla[m]);
            //        if (delItEqn != fol.eqnDemod.end()) {
            //            fol.eqnDemod.erase(delItEqn);
            //        }

        } else {
            set<Clause*>::iterator claP_it = fol.setCla.find(saveCopyCla[m]);
            if (claP_it != fol.setCla.end())
                fol.setCla.erase(claP_it);
        }
        saveCopyCla[m]->DelLits(true);
        delete(saveCopyCla[m]);
    }
    saveCopyCla.clear();
}
//计算子句已拷贝了多少次

int TriAlg::copyClaCopyTimes(Clause* cla) {
    if (saveCopyCla.size() == 0)
        return 0;
    int countTimes = 0;
    for (UINT32 m = 0; m < saveCopyCla.size(); ++m) {
        if (saveCopyCla[m]->topCopyCla == cla) {
            ++countTimes;
        }
    }
    return countTimes;
}
//拷贝子句,使得子句在当前的三角形演绎下可以重复使用

Clause* TriAlg::copyCla(Formula& fol, Clause* cla, UINT32& uNewClaID, Literal* copyFrom, Literal* copyTo) {
    Clause* newClause = new Clause(uNewClaID, 0);
    size_t uRsize = cla->uLitNum;
    newClause->LitPtr = new Literal*[uRsize];
    Literal* realCopyTo = copyTo;
    for (UINT16 i = 0; i < cla->uLitNum; ++i) {
        Term* litSubT = unify.GetCopyTerm(cla->LitPtr[i]->subTerm, newClause); //参数1：文字谓词项，参数2：新子句指针
//        if (TNegEqn == GetCodeProp(litSubT->iTermCode)
//                && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {
//            /*
//            delete(litSubT);*/
//            --uRsize;
//            //delete(newCla->LitPtr[]);
//            continue;
//        }
        if (newClause->uFuncDepth < litSubT->uLevel)newClause->uFuncDepth = litSubT->uLevel;
        newClause->uVarCount += litSubT->uVarCount;
        //添加到文字		
        newClause->LitPtr[newClause->uLitNum] = new Literal(litSubT, EncodeLitCode(uNewClaID, newClause->uLitNum + 1), newClause, nullptr);
        newClause->LitPtr[newClause->uLitNum]->parentLitPtr = cla->LitPtr[i]; //母式文字，有R产生

        //newCla->LitPtr[newCla->uLitNum]->goalDeepth = vInsertNewR[i]->goalDeepth;
        //20171020 计算演绎深度
        newClause ->deduceDeepth = cla->deduceDeepth;
        newClause->LitPtr[newClause->uLitNum]->goalDeepth = cla->LitPtr[i]->goalDeepth;
        //        if(cla->LitPtr[i] == copyTo){//找到被拷贝子句的演绎文字
        //            realCopyTo =newClause->LitPtr[newClause->uLitNum];
        //        }   
        //cout<<to_string(newCla->uClaId)  + "]" <<"[" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitRow()) + "_" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitCol()) + "]" << newCla->LitPtr[newCla->uLitNum]->subTerm->ToString()<<endl;  
        ++(newClause->uLitNum);
    }
    newClause->clast = CopyTemp;
    newClause->copyFrom = copyFrom;
    newClause->copyTo = realCopyTo;
    uNewClaID++; //通过归结式记录
    //输出演绎路径
    //FileOp::CreateRunInfoFile(cla->uClaId / 25);
    if (!StrategyParam::orForCompition)
        *FileOp::ofRealInfoOut << "编号为" + to_string(cla->uClaId) + "子句拷贝新子句" << endl;
    for (UINT32 k = 0; k < cla->uLitNum; k++) {
        unify.WriteCopyPath(cla->LitPtr[k]);
    }
    if(/*StrategyParam::orForCompition*/true) {
        
        string rStr = "";
        newClause->toString(rStr);
        validPathOut[uNewClaID - 1].push_back(cla->uClaId);
//        int begPos = rStr.find_first_of("[") + 1;
//        int endPos = rStr.find_first_of("]");
//        string rId = rStr.substr(begPos, endPos - begPos);
//        string rContext = rStr.substr(rStr.find_first_of("]") + 1);
//        string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n" + "   inference(rename_variables,[]," + "[" + to_string(cla->uClaId) +"]" + ")).";
//        *FileOp::ofOutput << out << endl;
        
        string cnf_str = newClause->ToStringWithSemantics(rStr);
        size_t pos = cnf_str.find_last_of(')');
        string cnf_str_sub = cnf_str.substr(0, pos);
        string out = cnf_str_sub + ", inference(rename_variables,[],[c_0_" + to_string(cla->uClaId) + "]" + ")).";
        *FileOp::ofOutput << out << endl;
    }
    if (!StrategyParam::orForCompition) {
        FileOp::WriteR(newClause);
        string vaildInf = "|[Y]";
        FileOp::RInvaildInfoOut(vaildInf, cla->uClaId / 25);
    }
    fol.InsertCla(newClause);
    if (StrategyParam::useSaturate)
        fol.setDeductCla.insert(newClause);
    else
        fol.setCla.insert(newClause);
    if (find(saveCopyCla.begin(), saveCopyCla.end(), newClause) == saveCopyCla.end()) {
        saveCopyCla.push_back(newClause);
    }
    return newClause;
}


//参数1：起步子句；参数2：新子句的编号；参数3：不回退

UINT8 TriAlg::GenerateTriByRecodePath(Formula& fol, Clause* givenCla, UINT32 &newClaId, BACKTYPE _backType, vector<Clause*> &chgCla, UINT16& loop_Num) {
    if (_backType == NOBACK)//清除变量
    {
        assert(!(givenCla == nullptr));
        //初始化		
        PreResLit = nullptr; //上轮找到的合一文字
        setRedundClaId.clear();
        hasCpUintClaId.clear();
        setRealRedundClaId.clear();
        setRealRedundClaId.reserve(8);
        vector<Literal*>().swap(vNewR);
        vNewR.reserve(8);
        vector<UINT16>().swap(vComparePos);
        ResClaID.clear();
        ResClaID.insert(givenCla->uClaId); //记录第一个归结子句编号
        vector<Clause*>().swap(ResClaPtr);
        ResClaPtr.push_back(givenCla); //记录第一个归结子句指针
        BackPathClear(); //重要：清除路径以及上轮归结中变元的绑定 
        //stackVarChg.reserve(16);
        //noCmpCla.clear();
        stackVarChg.reserve(100);
    }
    RESULT unifResult; //是否合一
    bool isDeduct = false; //是否发生过归结
    Clause* candClaP = nullptr; // 被动归结子句（候选子句）
    Literal* candLitP = nullptr; //被动归结文字（候选文字）
    vector<Literal*>* vCandLit; //取相同文字的map集合
    INT32 cDeepth = 0; //演绎深度
    UINT32 cWidth = 0; //演绎宽度
    UINT8 count = 0;
    Literal * lastTrip = nullptr;
    bool findOnlyOut = false; //用于控制子句的文字三角形摆放
    bool first_RLit = true; //记录第一次剩余的R
    Clause* first_Given = givenCla;
    bool midGenR = false;
    //20171229
    bool oneRunFlag = true;
    bool twoRunFlag = true;
    bool genUintRFirst = true;
    bool genUintRSecond = true;
    //20170821 针对构建三角形过程中出现的冗余子句,其权重修改为加随机数,这样可以使得下次做的三角形不一样.
    if (StrategyParam::useRandrom)
        srand((unsigned int) time(nullptr));
    while (1) {
        // if (1) {    
        cWidth = 0;
        UINT16 ActLitInd = 0;
        //        string str;
        //        givenCla->toString(str);
        //        cout <<"起步子句:" <<str << endl;
        for (; ActLitInd < givenCla->uLitNum; ++ActLitInd) {
            if (givenCla->uLitNum > 1) {
                if (find(vOnlyOutTri.begin(), vOnlyOutTri.end(), givenCla->LitPtr[ActLitInd]) == vOnlyOutTri.end()) {
                    continue;
                }
            }
            if ((givenCla->uLitNum == 1) &&(hasCpUintClaId.find(givenCla->uClaId) != hasCpUintClaId.end())) {//已经被拷贝的子句不再使用
                continue;
            }
            Literal* QLit = givenCla->LitPtr[ActLitInd];
            //根据文字互补谓词项对应的互补文字得到候选文字
            vCandLit = QLit->getPairPredLst();
            //记录在子句集没有互补对的单文字子句(限制为起步子句)下次三角形构建时将其删除 20170824 仔细考虑
            if ((vCandLit->size() == 0) && (givenCla->uLitNum == 1)&&(cDeepth == 0)) {
                if (noCmpCla.find(givenCla->uClaId) == noCmpCla.end())
                    noCmpCla.insert(givenCla->uClaId);
                allNoPair = true;
                return 11;
            }
            if (StrategyParam::unitSortRule == 3) {//目标子句
                stable_sort(vCandLit->begin(), vCandLit->end(), SortRule::PoslitCmpGoalDeepth);
            } else if (StrategyParam::unitSortRule == 8) {//最优排序
                stable_sort(vCandLit->begin(), vCandLit->end(), SortRule::PoslitCmpPrior);
            } else//PoslitCmpPrior
                if (_backType == NOBACK)
                stable_sort(vCandLit->begin(), vCandLit->end(), SortRule::PoslitCmp); //被动文字按子句个数进行排序  此处考虑用随机策略 //20170216
            //20171127 优化点:落实到文字上
            //stable_sort(vCandLit->begin(), vCandLit->end(), SortRule::PoslitCmpLarge); //被动文字按子句个数进行排序  此处考虑用随机策略
            //此处考虑加大宽度，即同一子句可以左多个合一子句
            INT32 pasLitInd = 0;
            //按照顺序进行匹配查找
            UINT16 minLit = 5000; //20170210 用于计算候选子句剩余文字最少
            UINT16 tempLit = 0; //20170210 用于计算候选子句剩余文字最少
            INT32 tempInd = -1;
//#define cprover_fast1
#ifndef cprover_fast1
            bool find_Flag = true; //用于判断是否在遍历候选子句
#else
            bool find_Flag = false; //用于判断是否在遍历候选子句
#endif
            //            if ((givenCla->uClaId == 1) && (cDeepth == 0)) {
            //                cout << "cf-debug" << endl;
            //            }
            setRealRedundClaId.clear();

            for (; pasLitInd < UINT32(vCandLit->size()); ++pasLitInd)//依次找到
            {
                //                if(newClaId == 1282){
                //                    cout<<"cf-debug"<<endl;
                //                }
                //cout<<"找归结子句:"<<pasLitInd<<endl;
                candLitP = vCandLit->at(pasLitInd); //候选被动归结文字
                candClaP = candLitP->claPtr; // 被动归结子句（候选子句）
                //20171020 加入演绎深度限制
                //                if (candClaP->deduceDeepth > StrategyParam::deduceDepth) {
                //                    if ((pasLitInd == UINT32(vCandLit->size()) - 1) && (tempInd != -1))//遍历完成
                //                    {
                //                        pasLitInd = tempInd - 1;
                //                        find_Flag = false;
                //                        continue;
                //                    } 
                //                    continue;
                //                }
                if (0) {//用于重复使用子句无法跳出的情况
                    clock_t end_out = clock();
                    double time_out = (double) (end_out - StrategyParam::start) / (double) CLOCKS_PER_SEC;
                    if (time_out > StrategyParam::timeLimit * 60)//200   3  1分钟 15  5分钟   30  15分钟  end:300
                    {
                        break;
                    }
                }
                if (StrategyParam::useSaturate) {
                    if (fol.setDeductCla.find(candClaP) == fol.setDeductCla.end()) {
                        //不在演绎列表里
                        //20171019
                        if ((pasLitInd == UINT32(vCandLit->size()) - 1) && (tempInd != -1))//遍历完成
                        {
                            pasLitInd = tempInd - 1;
                            find_Flag = false;
                            continue;
                        }
                        continue;
                    }
                }
                //候选为单文字子句不在这里处理
                if ((candClaP->uLitNum == 1)) {
                    if ((pasLitInd == UINT32(vCandLit->size()) - 1) && (tempInd != -1))//遍历完成
                    {
                        pasLitInd = tempInd - 1;
                        find_Flag = false;
                        continue;
                    }
                    continue;
                }
                //已归结的子句在本次三角形中不再使用
                //StrategyParam::reUseClause  
                //if (!StrategyParam::reUseClause) {
                if (setRedundClaId.find(candClaP->uClaId) != setRedundClaId.end()) {
                    if ((pasLitInd == UINT32(vCandLit->size()) - 1) && (tempInd != -1))//遍历完成
                    {
                        pasLitInd = tempInd - 1;
                        find_Flag = false;
                        continue;
                    }
                    continue;
                }
                //20170827 setRealRedundClaId
                //                if (setRealRedundClaId.find(candClaP->uClaId) != setRealRedundClaId.end())
                //                    continue;
                //发生冗余的子句不再使用
                if (find(setRealRedundClaId.begin(), setRealRedundClaId.end(), candLitP) != setRealRedundClaId.end()) {
                    if ((pasLitInd == UINT32(vCandLit->size()) - 1) && (tempInd != -1))//遍历完成
                    {
                        pasLitInd = tempInd - 1;
                        find_Flag = false;
                        continue;
                    }
                    continue;
                }
                //不在选取activity子句中的子句进行归结setDuctCla 20170113

                //                if (setDuctCla.find(candClaP->uClaId) != setDuctCla.end())
                //                    continue;

                /*同一子句中文字不进行比较;文字条件限制; -- 这里允许自归结 同一个子句在一个三角形中最多2次参与归结*/
                if (candClaP->uClaId == QLit->Row() || ResClaID.find(candClaP->uClaId) != ResClaID.end()) {
                    if ((pasLitInd == UINT32(vCandLit->size()) - 1) && (tempInd != -1))//遍历完成
                    {
                        pasLitInd = tempInd - 1;
                        find_Flag = false;
                        continue;
                    }
                    continue;
                }
                //20171022 增加拷贝子句重复演绎限制
                if ((candClaP->clast == CopyTemp) && (candClaP->copyFrom == QLit) && unify.CheckEqnR(candClaP->copyTo->subTerm, candLitP->subTerm)) {
                    if ((pasLitInd == UINT32(vCandLit->size()) - 1) && (tempInd != -1))//遍历完成
                    {
                        pasLitInd = tempInd - 1;
                        find_Flag = false;
                        continue;
                    }
                    continue;
                }
                //20170827 限制子句中文字数个数
                //                if (vNewR.size() + givenCla->uLitNum + candClaP->uLitNum - 2 > StrategyParam::R_MAX_NUM)
                //                    continue;

                //不允许跟上一轮母式进行归结  20171127 完全放开限制
                //                if ((candLitP->parentLitPtr && candLitP->parentLitPtr->claPtr == givenCla) || (QLit->parentLitPtr && QLit->parentLitPtr->claPtr == candClaP)){
                //                     if ((pasLitInd == UINT32(vCandLit->size()) - 1) && (tempInd != -1))//遍历完成
                //                    {
                //                        pasLitInd = tempInd - 1;
                //                        find_Flag = false;
                //                        continue;
                //                    } 
                //                    continue;
                //                }
                //核心：合一算法，参数1：主动归结文字指针；参数2：被动归结文字指针
                //string strcand;
                 //candClaP->toString(strcand);
                //  cout << "互补子句"<<strcand << endl;
                //20170210 扩展三角形算法2 需要遍历所有候选子句集挑选最有候选子句集，因此需要用到循环
                //20170211 思考将候选子句结合所有的单元子句来确定，主要确定能够得出结论的子句
                if (find_Flag)//注意:遍历候选子句切换到实际构建三角形时需要将遍历的合一清除，需要考虑特殊清空无效的合一
                { //注意:还需考虑从实际构建三角形切换到遍历候选子句的清空，需要考虑是否将有效合一给清除了
                    //20180909 增加目标子句的归结 放松限制
                    INT32 tempRsize = StrategyParam::R_MAX_NUM;
                    if (candLitP->claPtr->isGoal && (StrategyParam::R_MAX_NUM < candLitP->claPtr->uLitNum)) {
                        StrategyParam::R_MAX_NUM = vNewR.size() + candLitP->claPtr->uLitNum;
                    }
                    unifResult = unify.Issyn_find(QLit, candLitP, tempLit); //新版本改成只剩1个文字
                    StrategyParam::R_MAX_NUM = tempRsize;
                    if (unifResult == RULEOK) {
                        //此时需要判断候选子句的剩余文字
                        if (tempLit < minLit) {
                            minLit = tempLit; //更新最小值
                            tempInd = pasLitInd; //保存下标值
                            //20170809
                            if ((minLit == 0)) {
                                pasLitInd = tempInd - 1;
                                find_Flag = false;
                            }
                            //
                            if (pasLitInd == UINT32(vCandLit->size()) - 1)//遍历完成
                            {
                                pasLitInd = tempInd - 1;
                                find_Flag = false;
                                continue;
                            }
                            continue;
                        }
                        //若找到1个只剩1个文字的候选子句，此时应该马上将他进行演绎
                        //                        if((minLit == 0)||(minLit == 1)){
                        //                            pasLitInd = tempInd - 1;
                        //                            find_Flag = false;
                        //                            continue;
                        //                        }
                        if (pasLitInd == UINT32(vCandLit->size()) - 1)//遍历完成
                        {
                            pasLitInd = tempInd - 1;
                            find_Flag = false;
                            continue;
                        } else { //20170826 新增
                            //                            if (pasLitInd == UINT32(vCandLit->size()) - 1)//遍历完成
                            //                            {
                            //                                pasLitInd = tempInd - 1;
                            //                                find_Flag = false;
                            //                                continue;
                            //                            } 
                            continue;
                        }
                    } else {//如果不存在互补对子句时
                        //当遍历完了整个候选子句集时，恢复下标
                        if (pasLitInd == UINT32(vCandLit->size()) - 1)//遍历完成
                        {
                            if (tempInd == -1) {
                                break;
                            } else {
                                pasLitInd = tempInd - 1;
                                find_Flag = false;
                            }
                        }
                        continue;
                    }
                }
                //20171229 此处加入若单元子句起步有剩余文字时,则跳过该单元子句;需要处理的有:1 该单元子句是否已经使用 2 将该单元子句放入单元子句列表的后面
//#define cprover_fast2
#ifndef cprover_fast2
                if (1229) {
                    if (!find_Flag && (minLit > 1) && genUintRFirst) {
                        break;
                    }
                }
                if(20180914){
                    if (!find_Flag && (minLit > 2) && (!genUintRFirst) && genUintRSecond) {
                        break;
                    }
                }
#endif
                //20171229 end
                //加入徐老师的建议 刚开始只做剩余文字为1
                if (StrategyParam::genLitClause && 0) {
                    if (loop_Num != 0) {
                        if (minLit > 1 && total_Loop / loop_Num < 2) {
                            break;
                        }
                    }
                }

                //
                //继续构建三角形
                //                if(candLitP->claPtr->uClaId == 38){
                //                    cout<<"cf-debug"<<endl;
                //                }
                //20180909 增加目标子句的归结 放松限制
                INT32 tempRsize = StrategyParam::R_MAX_NUM;
                if (candLitP->claPtr->isGoal && (StrategyParam::R_MAX_NUM < candLitP->claPtr->uLitNum)) {
                    StrategyParam::R_MAX_NUM = vNewR.size() + candLitP->claPtr->uLitNum;
                }
                unifResult = unify.Issyn(QLit, candLitP); //是否找到合一文字
                StrategyParam::R_MAX_NUM = tempRsize;
                //20170909 将限制还原
                //20170215  根据归结子句的互补文字，当有剩余文字既要放入主对角线，又要放入R中 此时的顺序如何选择 这里和文字的稳定排序有关
                if (unifResult == RULEOK) {
                    //cout << "找到合一" << endl;
                    //                    string strcand;
                    //                   candClaP->toString(strcand);
                    //                   cout << "归结文字"<<strcand << endl;
                    //vComparePos.push_back(pasLitInd); //记录被动归结文字的合一的位子
                    //20170210 stackVarChg用于保存构建三角形过程中所有的替换项
                    //20170818 记录演绎前的归结式文字个数
                    int lastRSize = vNewR.size();
                    int lastvOutTriSize = vOutTri.size();
                    stackVarChg.push_back(unify.vVarBindT); //添加到替换堆栈中	 //版本2需要重点考虑	 
                    //20170224对候选子句进行排序
                    //候选子句文字策略
                    //0:归结次数>稳定度 1:无(由原始顺序为准) 2:稳定度>归结次数
                    stable_sort(candClaP->LitPtr, candClaP->LitPtr + candClaP->uLitNum, SortRule::ActlitCmp);
                    findOnlyOut = true;
                    UINT16 sumDrop = 0;
                    vector<Literal*> leftLiter; //20170305 用于保存剩余文字，以便选择最优的文字放入三角形中
                    for (UINT16 m = 0; m < candClaP->uLitNum; m++) {
                        if (candClaP->LitPtr[m]->isDrop)//互补文字
                        {
                            sumDrop++;
                            vOutTri.push_back(candClaP->LitPtr[m]);
                            //cout<<"三角形下方文字"<<"[C" + to_string(candClaP->LitPtr[m]->Row()) + "_" + to_string(candClaP->LitPtr[m]->Col()) + "]"<<(candClaP->LitPtr[m]->subTerm->ToStringBind())<<endl;
                            continue;
                        }
                        //20170305 idea 有效解决冗余:优先选择与单元子句一样的文字(合一)，另外考虑徐老师讲的同一子句可以合并的文字一定要合并
                        leftLiter.push_back(candClaP->LitPtr[m]);
                    }
                    if (!leftLiter.empty()) {
                        //查找是否有可以和单元子句合一相同的文字
                        vector<Term*> chgTempT; //储存替换变元项
                        for (UINT16 m = 0; m < leftLiter.size(); m++) {
                            bool findRes = false;
                            for (auto& clap : vOnlyOutTri) {
                                if (leftLiter[m]->isEqPred(clap) && unify.LitMgu(leftLiter[m], clap, chgTempT)) {
                                    swap(leftLiter[m], leftLiter[0]);
                                    unify.ClearVarBind(chgTempT);
                                    findRes = true;
                                    break;
                                } else
                                    unify.ClearVarBind(chgTempT);
                            }
                            if (findRes)
                                break;
                        }
                        unify.ClearVarBind(chgTempT);
                        for (UINT16 m = 0; m < leftLiter.size(); m++) {
                            /*
                            if (!candClaP->LitPtr[m]->isDel && findOnlyOut) {//被选归结子句剩下的文字,其中第一个放在对角线上,其余放入R中
                                lastTrip = candClaP->LitPtr[m]; //记录三角形对角线演绎最后一个文字，下一次演绎需要放入三角形中
                                vOutTri.push_back(candClaP->LitPtr[m]);
                                vOnlyOutTri.push_back(candClaP->LitPtr[m]);
                                findOnlyOut = false;
                                //cout<<"三角形顶点"<<(candClaP->LitPtr[m]->subTerm->ToString())<<endl;
                            } else if (!candClaP->LitPtr[m]->isDel &&!findOnlyOut) {//放入R中
                                count++;
                                vOutTri.push_back(candClaP->LitPtr[m]);
                                vNewR.push_back(candClaP->LitPtr[m]);
                                //cout<<"R的大小:"<<vNewR.size()<<endl;
                                //20170216
                                if (first_RLit) {
                                    firstR = vOnlyOutTri.back();
                                    first_RLit = false;
                                }

                            }
                             */
                            if (!leftLiter[m]->isDel && findOnlyOut) {//被选归结子句剩下的文字,其中第一个放在对角线上,其余放入R中
                                lastTrip = leftLiter[m]; //记录三角形对角线演绎最后一个文字，下一次演绎需要放入三角形中
                                vOutTri.push_back(leftLiter[m]);
                                vOnlyOutTri.push_back(leftLiter[m]);
                                findOnlyOut = false;
                            } else if (!leftLiter[m]->isDel &&!findOnlyOut) {//放入R中
                                count++;
                                vOutTri.push_back(leftLiter[m]);
                                vNewR.push_back(leftLiter[m]);
                                //20170216
                                if (first_RLit) {
                                    firstR = vOnlyOutTri.back();
                                    first_RLit = false;
                                }

                            }
                        }
                    }
                    //判断是否全部放入三角形中
                    if (findOnlyOut && count == 0 && vNewR.size() == 0) {
                        newCla = nullptr;
                        givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                        candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                        if(!StrategyParam::orForCompition && (StrategyParam::problemDiv == 0))
                            cout << "得出结论:不可满足" << endl;
                        return true;
                    }
                    //三角形上方不剩文字，即归结出来单文字if (find(vOnlyOutTri.begin(), vOnlyOutTri.end(),givenCla->LitPtr[ActLitInd]) == vOnlyOutTri.end())
                    //中间归结式生成 static bool midR;//中间归结式生成 //true 中间归结式生成 false 中间归结式不生成
                    //&&!findOnlyOut && StrategyParam::midR
                    if (count == 0 && vNewR.size() == 0 && !findOnlyOut && StrategyParam::midR) {
                        //新建子句,生成单文字子句,最后加入到单文字子句列表中
                        Literal* tempptr = vOnlyOutTri.back();
                        bool flagT = true;
                        //如果时纯文字或单文字已存在
                        if ((tempptr->getPairPredLst()->empty()) || (find(vOnlyOutTriCmp.begin(), vOnlyOutTriCmp.end(), tempptr) != vOnlyOutTriCmp.end())) {
                            flagT = false;
                        }
                        if (flagT) {
                            vector<Literal*> vInsertNewR;
                            vInsertNewR.reserve(6);
                            vInsertNewR.push_back(vOnlyOutTri.back());
                            newCla = nullptr;
                            if (!vInsertNewR.empty()) {
                                //查看是否冗余20170101
                                newCla = new Clause(newClaId, 0);
                                newCla->isAxtom = true;
                                size_t uRsize = vInsertNewR.size();
                                //文字排序
//                                if (uRsize > 1) {
//                                    if (StrategyParam::unitSortRule == 3) {
//                                        stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmpGoalDeepth);
//                                    } else
//                                        stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmp);
//                                }
                                if (uRsize > 1)
                                    stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmp);
                                newCla->LitPtr = new Literal*[uRsize];
                                for (UINT16 i = 0; i < vInsertNewR.size(); ++i) {
                                    Term* litSubT = unify.GetNewTerm(vInsertNewR[i]->subTerm, newCla); //参数1：文字谓词项，参数2：新子句指针
                                    if (TNegEqn == GetCodeProp(litSubT->iTermCode)
                                            && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {
                                        /*
                                        delete(litSubT);*/--uRsize;
                                        //delete(newCla->LitPtr[]);
                                        continue;
                                    }
                                    if (newCla->uFuncDepth < litSubT->uLevel)newCla->uFuncDepth = litSubT->uLevel;
                                    newCla->uVarCount += litSubT->uVarCount;
                                    //添加到文字		
                                    newCla->LitPtr[newCla->uLitNum] = new Literal(litSubT, EncodeLitCode(newClaId, newCla->uLitNum + 1), newCla, nullptr);
                                    newCla->LitPtr[newCla->uLitNum]->parentLitPtr = vInsertNewR[i]; //母式文字，有R产生

                                    //newCla->LitPtr[newCla->uLitNum]->goalDeepth = vInsertNewR[i]->goalDeepth;
                                    //20171020 计算演绎深度
                                    if (newCla ->deduceDeepth < (vInsertNewR[i]->claPtr->deduceDeepth + 1)) {
                                        newCla ->deduceDeepth = vInsertNewR[i]->claPtr->deduceDeepth + 1;
                                    }
                                    if (vInsertNewR[i]->claPtr->isAxtom && newCla->isAxtom)
                                        newCla->isAxtom = true;
                                    else
                                        newCla->isAxtom = false;
                                    if (hasUnifGoalLit(fol, newCla->LitPtr[newCla->uLitNum])) {
                                        newCla->LitPtr[newCla->uLitNum]->goalDeepth = 1;
                                        if (newCla->goaldeepth > 1)
                                            newCla->goaldeepth = 1;
                                    } else {
                                        newCla->LitPtr[newCla->uLitNum]->goalDeepth = vInsertNewR[i]->goalDeepth;
                                        if (newCla->goaldeepth > vInsertNewR[i]->goalDeepth)
                                            newCla->goaldeepth = vInsertNewR[i]->goalDeepth;
                                    }
                                    //cout<<to_string(newCla->uClaId)  + "]" <<"[" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitRow()) + "_" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitCol()) + "]" << newCla->LitPtr[newCla->uLitNum]->subTerm->ToString()<<endl;  
                                    ++(newCla->uLitNum);
                                }
                                //20171020 对子句的含等词的文字进行项序处理
                                if (StrategyParam::termRewriting != 2) {
                                    newCla->directEqn();
                                }
                                //cout<<newCla->LitPtr[0]->subTerm->ToStringBind()<<endl;
                                if (uRsize != 0) {
                                    //20171026 增加生成的中间归结式子句复杂度限制
                                    if (newCla->compFuncDeepthCla() > StrategyParam::funcFixDeepth) {
                                        newCla->DelLits(false);
                                        delete(newCla);
                                        //清除变元合一绑定
                                        if (!unify.vVarBindT.empty())
                                            unify.ClearVarBind(unify.vVarBindT);
                                        //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                        if (!vOnlyOutDect.empty()) {
                                            UINT32 dlen = vOnlyOutDect.size();
                                            for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                                vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                            }
                                        }
                                        //还原vOutTri  vOnlyOutTri
                                        vOnlyOutTri.pop_back();
                                        vOutTri.pop_back();
                                        for (UINT16 m = 0; m < sumDrop; m++) {
                                            vOutTri.pop_back();
                                        }
                                        vInsertNewR.clear();
                                        vector<Literal*>().swap(vInsertNewR);
                                        //20170220 增加候选子句冗余权重
                                        //candClaP->reduntTimes++;
                                        //20170828
                                        pasLitInd = -1;
                                        //20170830 恢复初始遍历值
                                        if (1) {
                                            find_Flag = true;
                                            tempInd = -1;
                                            minLit = 5000;
                                        }
                                        setRealRedundClaId.push_back(candLitP);
                                        //end
                                        continue;
                                    }
                                    //20170213 start 此处判断是否冗余，若生成的单文字子句冗余，说明此子句在构建三角形过程起到了反作用，应该将其删除
                                    //且将候选子句重新选择，直到生成的是单元子句且不是冗余的为止
                                    //中间归结式冗余判断 midRJudge
                                    //true 中间归结式冗余判断 false 中间归结式冗余不判断
                                    //                                    if (claHasPureLit(fol, newCla)) {
                                    //                                        //cout<<"R无效"<<endl;
                                    //                                        newCla->DelLits(false);
                                    //                                        delete(newCla);
                                    //                                        //清除变元合一绑定
                                    //                                        if (!unify.vVarBindT.empty())
                                    //                                            unify.ClearVarBind(unify.vVarBindT);
                                    //                                        //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                    //                                        if (!vOnlyOutDect.empty()) {
                                    //                                            UINT32 dlen = vOnlyOutDect.size();
                                    //                                            for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                    //                                                vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                    //                                            }
                                    //                                        }
                                    //                                        //还原vOutTri  vOnlyOutTri
                                    //                                        vOnlyOutTri.pop_back();
                                    //                                        vOutTri.pop_back();
                                    //                                        for (UINT16 m = 0; m < sumDrop; m++) {
                                    //                                            vOutTri.pop_back();
                                    //                                        }
                                    //                                        vInsertNewR.clear();
                                    //                                        vector<Literal*>().swap(vInsertNewR);
                                    //                                        //20170220 增加候选子句冗余权重
                                    //                                        candClaP->reduntTimes++;
                                    //                                        //20170828
                                    //                                        pasLitInd = -1;
                                    //                                        //20170830 恢复初始遍历值
                                    //                                        if (1) {
                                    //                                            find_Flag = true;
                                    //                                            tempInd = -1;
                                    //                                            minLit = 128;
                                    //                                        }
                                    //                                        setRealRedundClaId.push_back(candLitP);
                                    //                                        //end
                                    //                                        continue;
                                    //                                    }
                                    if (StrategyParam::midRJudge) {
                                        vector<UINT32>invaildLitId; //
                                        invaildLitId.reserve(6);
                                        string rundMsg; //冗余信息
                                        Subsumption subsump; //(MOSTRIGHT)
                                        //参数1 被测的子句指针 参数2 整形数组 参数3 字符串 记录冗余信息
                                        bool isRundacyR = false;
                                        isRundacyR = subsump.GenCla(fol, newCla, invaildLitId, rundMsg);
                                        if (isRundacyR) {
                                            //cout<<"R无效"<<endl;
                                            newCla->DelLits(false);
                                            delete(newCla);
                                            //清除变元合一绑定
                                            if (!unify.vVarBindT.empty())
                                                unify.ClearVarBind(unify.vVarBindT);
                                            //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                            if (!vOnlyOutDect.empty()) {
                                                UINT32 dlen = vOnlyOutDect.size();
                                                for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                                    vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                                }
                                            }
                                            //还原vOutTri  vOnlyOutTri
                                            vOnlyOutTri.pop_back();
                                            vOutTri.pop_back();
                                            for (UINT16 m = 0; m < sumDrop; m++) {
                                                vOutTri.pop_back();
                                            }
                                            vInsertNewR.clear();
                                            vector<Literal*>().swap(vInsertNewR);
                                            //20170220 增加候选子句冗余权重
                                            candClaP->reduntTimes++;
                                            //20170828
                                            pasLitInd = -1;
                                            //20170830 恢复初始遍历值
                                            if (1) {
                                                find_Flag = true;
                                                tempInd = -1;
                                                minLit = 5000;
                                            }
                                            setRealRedundClaId.push_back(candLitP);
                                            //end
                                            continue;
                                        } else {
                                            FileOp::CreateRunInfoFile(FileOp::runFileId);
                                            chgCla.push_back(newCla);
                                            //20170602 新增输出小三角形路径
                                            if (StrategyParam::divideTri) {
                                                *FileOp::ofRealInfoOut << "从编号为" + to_string(first_Given->uClaId) + "子句开始构建三角形" << endl;
                                                if (givenCla->uLitNum == 1) {
                                                    givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                                                }
                                                candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                                                //输出演绎路径					 
                                                PrintTriPath();
                                                //20171025
                                                //                                                fol.InsertCla(newCla);
                                                //                                                fol.setCla.insert(newCla);
                                                midGenR = true;
                                                FileOp::WriteR(newCla);
                                                *FileOp::ofRealInfoOut << "|[Y]" << endl;
                                                fol.InsertCla(newCla);
                                                fol.setCla.insert(newCla);
                                                if(/*StrategyParam::orForCompition*/true) {
                                                    newCla->addRForCompetiton();
                                                    
                                                    string rStr = "";
                                                    newCla->toString(rStr);
                                                    string outclauses = PrintCompetitionOut(newClaId);
                                                    int begPos = rStr.find_first_of("[") + 1;
                                                    int endPos = rStr.find_first_of("]");
                                                    string rId = rStr.substr(begPos, endPos - begPos);
                                                    string rContext = rStr.substr(rStr.find_first_of("]") + 1);
                                                    string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n"; 
                                                    out += "   inference(scs_inference,[],[" + outclauses +"]" + ")).";
                                                    *FileOp::ofOutput << out << endl;
                                                }

                                            }
                                        }
                                    } else {
                                        FileOp::CreateRunInfoFile(FileOp::runFileId);
                                        chgCla.push_back(newCla);
                                        //20170602 新增输出小三角形路径
                                        if (StrategyParam::divideTri) {
                                            *FileOp::ofRealInfoOut << "从编号为" + to_string(first_Given->uClaId) + "子句开始构建三角形" << endl;
                                            if (givenCla->uLitNum == 1) {
                                                givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                                            }
                                            candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                                            //输出演绎路径					 
                                            PrintTriPath();
                                            //20171025
                                            //                                            fol.InsertCla(newCla);
                                            //                                            fol.setCla.insert(newCla);
                                            midGenR = true;
                                            //20171020 对子句的含等词的文字进行项序处理
                                            //                                            if (StrategyParam::termRewriting != 2) {
                                            //                                                newCla->directEqn();
                                            //                                            }

                                            FileOp::WriteR(newCla);
                                            *FileOp::ofRealInfoOut << "|[Y]" << endl;
                                            fol.InsertCla(newCla);
                                            fol.setCla.insert(newCla);
                                            if (/*StrategyParam::orForCompition*/true) {
                                                newCla->addRForCompetiton();
                                                
                                                string rStr = "";
                                                newCla->toString(rStr);
                                                string outClauses = PrintCompetitionOut(newClaId);
                                                int begPos = rStr.find_first_of("[") + 1;
                                                int endPos = rStr.find_first_of("]");
                                                string rId = rStr.substr(begPos, endPos - begPos);
                                                string rContext = rStr.substr(rStr.find_first_of("]") + 1);
                                                string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n" + "   inference(scs_inference,[]," + "[" + outClauses +"]" + ")).";
                                                
                                                *FileOp::ofOutput << out << endl;
                                            }
                                        }
                                    }
                                }
                                //string str;
                                //newCla->toString(str);
                                //cout<<"插入中间演绎的单文字子句:" <<str << endl;
                                fol.initGenerateClaAttr(newCla);
                                newClaId++;
                            }
                            vInsertNewR.clear();
                            vector<Literal*>().swap(vInsertNewR);
                        } else {
                            //清除变元合一绑定
                            if (!unify.vVarBindT.empty())
                                unify.ClearVarBind(unify.vVarBindT);
                            //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                            if (!vOnlyOutDect.empty()) {
                                UINT32 dlen = vOnlyOutDect.size();
                                for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                    vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                }
                            }
                            //还原vOutTri  vOnlyOutTri
                            vOnlyOutTri.pop_back();
                            vOutTri.pop_back();
                            for (UINT16 m = 0; m < sumDrop; m++) {
                                vOutTri.pop_back();
                            }
                            candClaP->reduntTimes++;
                            //20170828
                            pasLitInd = -1;
                            //20170830 恢复初始遍历值
                            if (1) {
                                find_Flag = true;
                                tempInd = -1;
                                minLit = 5000;
                            }
                            setRealRedundClaId.push_back(candLitP);
                            //end
                            continue;
                        }
                    }//20170816 保存生成的非单元子句
                    else if (count > 0 && vNewR.size() > 0 && !findOnlyOut && StrategyParam::midR) {
                        //新建子句,生成单文字子句,最后加入到单文字子句列表中
                        //Literal* tempptr = vOnlyOutTri.back();
                        bool flagT = true;
                        //如果时纯文字或单文字已存在
                        //                         if((tempptr->getPairPredLst()->empty()) ||(find(vOnlyOutTriCmp.begin(), vOnlyOutTriCmp.end(),tempptr) != vOnlyOutTriCmp.end()))
                        //                        {
                        //                            flagT = false;
                        //                        }
                        vector<Literal*> vInsertNewR;
                        vInsertNewR.reserve(6);
                        vInsertNewR.push_back(vOnlyOutTri.back());
                        for (int i = 0; i < vNewR.size(); i++) {
                            vInsertNewR.push_back(vNewR[i]);
                        }
                        
                         // 此处判断是否有冗余的R 文字,即由该子句对角线文字没有互补对的文字存在与矛盾体中
                         vector<Clause*> discardClas;
                        discardClas.reserve(8);
                        if(StrategyParam::litRundent){
                            for(int i=0; i < vInsertNewR.size(); ++i){
                                UINT16 countPair = 0;
                                Clause *findCla = vInsertNewR[i]->claPtr;
                                if(findCla == vOutTri.back()->claPtr)
                                    continue;
                                for(int j = 0; j < findCla->uLitNum; ++j){
                                    if(find(vOnlyOutTri.begin(),vOnlyOutTri.end(),findCla->LitPtr[j]) != vOnlyOutTri.end()){//找到对角线文字,查看互补对
                                        for(int k=0; k < vOutTri.size(); ++k){
                                            if((findCla->LitPtr[j]->isPairPred(vOutTri[k])) && (unify.CheckPairEqn(findCla->LitPtr[j]->subTerm, vOutTri[k]->subTerm))){
                                                ++countPair;
                                                break;
                                            }
                                        }                                       
                                    }
                                }
                                if(countPair == 0){//表示对角线没有互补对
                                    if(find(discardClas.begin(),discardClas.end(),vInsertNewR[i]->claPtr) == discardClas.end()){
                                        discardClas.push_back(vInsertNewR[i]->claPtr);
                                    }
                                    swap(vInsertNewR[i],vInsertNewR[vInsertNewR.size()-1]);
                                    vInsertNewR.pop_back();
                                    --i;
                                }
                            }
                        }                                           
                        //end
                        
                        
                        //                        vInsertNewR.push_back(vOnlyOutTri.back());//R文字已全部收集好
                        //                        //检查是否可以合并
                        //
                        for (size_t rInd = 0; rInd < vInsertNewR.size() - 1; ++rInd) {
                            Literal* rA = vInsertNewR[rInd];
                            for (size_t rIndB = rInd + 1; rIndB < vInsertNewR.size();) {
                                Literal* rB = vInsertNewR[rIndB];
                                if (rA->subTerm->iTermCode == rB->subTerm->iTermCode && unify.CheckEqn(rA->subTerm, rB->subTerm)) {
                                    swap(vInsertNewR[rIndB], vInsertNewR[vInsertNewR.size() - 1]);
                                    vInsertNewR.pop_back();
                                } else
                                    ++rIndB;
                            }
                        }
                        if (vInsertNewR.size() > StrategyParam::midR)
                            flagT = false;
                        if (flagT) {

                            newCla = nullptr;
                            if (!vInsertNewR.empty()) {
                                //查看是否冗余20170101
                                newCla = new Clause(newClaId, 0);
                                newCla->isAxtom = true;
                                size_t uRsize = vInsertNewR.size();
                                //文字排序
//                                if (uRsize > 1)
//                                    if (StrategyParam::unitSortRule == 3) {
//                                        stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmpGoalDeepth);
//                                    } else
//                                        stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmp);
                                if (uRsize > 1)
                                    stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmp);
                                newCla->LitPtr = new Literal*[uRsize];
                                for (UINT16 i = 0; i < vInsertNewR.size(); ++i) {
                                    Term* litSubT = unify.GetNewTerm(vInsertNewR[i]->subTerm, newCla); //参数1：文字谓词项，参数2：新子句指针
                                    if (TNegEqn == GetCodeProp(litSubT->iTermCode)
                                            && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {
                                        /*
                                        delete(litSubT);*/--uRsize;
                                        //delete(newCla->LitPtr[]);
                                        continue;
                                    }
                                    if (newCla->uFuncDepth < litSubT->uLevel)newCla->uFuncDepth = litSubT->uLevel;
                                    newCla->uVarCount += litSubT->uVarCount;
                                    //添加到文字		
                                    newCla->LitPtr[newCla->uLitNum] = new Literal(litSubT, EncodeLitCode(newClaId, newCla->uLitNum + 1), newCla, nullptr);
                                    newCla->LitPtr[newCla->uLitNum]->parentLitPtr = vInsertNewR[i]; //母式文字，有R产生
                                    //newCla->LitPtr[newCla->uLitNum]->goalDeepth = vInsertNewR[i]->goalDeepth;
                                    //20171020 计算演绎深度
                                    if (newCla ->deduceDeepth < (vInsertNewR[i]->claPtr->deduceDeepth + 1)) {
                                        newCla ->deduceDeepth = vInsertNewR[i]->claPtr->deduceDeepth + 1;
                                    }
                                    if (vInsertNewR[i]->claPtr->isAxtom && newCla->isAxtom)
                                        newCla->isAxtom = true;
                                    else
                                        newCla->isAxtom = false;
                                    if (hasUnifGoalLit(fol, newCla->LitPtr[newCla->uLitNum])) {
                                        newCla->LitPtr[newCla->uLitNum]->goalDeepth = 1;
                                        if (newCla->goaldeepth > 1)
                                            newCla->goaldeepth = 1;
                                    } else {
                                        newCla->LitPtr[newCla->uLitNum]->goalDeepth = vInsertNewR[i]->goalDeepth;
                                        if (newCla->goaldeepth > vInsertNewR[i]->goalDeepth)
                                            newCla->goaldeepth = vInsertNewR[i]->goalDeepth;
                                    }
                                    //cout<<to_string(newCla->uClaId)  + "]" <<"[" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitRow()) + "_" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitCol()) + "]" << newCla->LitPtr[newCla->uLitNum]->subTerm->ToString()<<endl;  
                                    ++(newCla->uLitNum);
                                }
                                //20171020 对子句的含等词的文字进行项序处理
                                if (StrategyParam::termRewriting != 2) {
                                    newCla->directEqn();
                                }
                                //cout<<newCla->LitPtr[0]->subTerm->ToStringBind()<<endl;
                                if (uRsize != 0) {
                                    //20171026 增加生成的中间归结式子句复杂度限制
                                    if (newCla->compFuncDeepthCla() > StrategyParam::funcFixDeepth) {
                                        newCla->DelLits(false);
                                        delete(newCla);
                                        //20170818 需要还原vNewR 此次演绎改变了什么 
                                        //清除变元合一绑定
                                        if (!unify.vVarBindT.empty())
                                            unify.ClearVarBind(unify.vVarBindT);
                                        //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                        if (!vOnlyOutDect.empty()) {
                                            UINT32 dlen = vOnlyOutDect.size();
                                            for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                                vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                            }
                                        }
                                        //还原vOutTri  vOnlyOutTri
                                        vOnlyOutTri.pop_back();
                                        /*
                                         * int lastRSize = vNewR.size();
                                            int lastvOutTriSize = vOutTri.size();
                                         */
                                        int incOutTriSize = vOutTri.size() - lastvOutTriSize;
                                        for (UINT16 m = 0; m < incOutTriSize; m++) {
                                            vOutTri.pop_back();
                                        }
                                        //还原归结式
                                        int incRSize = vNewR.size() - lastRSize;
                                        for (UINT16 m = 0; m < incRSize; m++) {
                                            count--;
                                            vNewR.pop_back();
                                        }
                                        vInsertNewR.clear();
                                        vector<Literal*>().swap(vInsertNewR);
                                        //20170220 增加候选子句冗余权重
                                        //candClaP->reduntTimes++;
                                        //20170828
                                        pasLitInd = -1;
                                        //20170830 恢复初始遍历值
                                        if (1) {
                                            find_Flag = true;
                                            tempInd = -1;
                                            minLit = 5000;
                                        }
                                        setRealRedundClaId.push_back(candLitP);
                                        //end
                                        continue;
                                    }
                                    //20170213 start 此处判断是否冗余，若生成的单文字子句冗余，说明此子句在构建三角形过程起到了反作用，应该将其删除
                                    //且将候选子句重新选择，直到生成的是单元子句且不是冗余的为止
                                    //中间归结式冗余判断 midRJudge
                                    //true 中间归结式冗余判断 false 中间归结式冗余不判断
                                    //                                    if (claHasPureLit(fol, newCla)) {
                                    //                                        //cout<<"R无效"<<endl;
                                    //                                        newCla->DelLits(false);
                                    //                                        delete(newCla);
                                    //                                        //20170818 需要还原vNewR 此次演绎改变了什么 
                                    //                                        //清除变元合一绑定
                                    //                                        if (!unify.vVarBindT.empty())
                                    //                                            unify.ClearVarBind(unify.vVarBindT);
                                    //                                        //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                    //                                        if (!vOnlyOutDect.empty()) {
                                    //                                            UINT32 dlen = vOnlyOutDect.size();
                                    //                                            for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                    //                                                vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                    //                                            }
                                    //                                        }
                                    //                                        //还原vOutTri  vOnlyOutTri
                                    //                                        vOnlyOutTri.pop_back();
                                    //                                        /*
                                    //                                         * int lastRSize = vNewR.size();
                                    //                                            int lastvOutTriSize = vOutTri.size();
                                    //                                         */
                                    //                                        int incOutTriSize = vOutTri.size() - lastvOutTriSize;
                                    //                                        for (UINT16 m = 0; m < incOutTriSize; m++) {
                                    //                                            vOutTri.pop_back();
                                    //                                        }
                                    //                                        //还原归结式
                                    //                                        int incRSize = vNewR.size() - lastRSize;
                                    //                                        for (UINT16 m = 0; m < incRSize; m++) {
                                    //                                            count--;
                                    //                                            vNewR.pop_back();
                                    //                                        }
                                    //                                        vInsertNewR.clear();
                                    //                                        vector<Literal*>().swap(vInsertNewR);
                                    //                                        //20170220 增加候选子句冗余权重
                                    //                                        candClaP->reduntTimes++;
                                    //                                        //20170828
                                    //                                        pasLitInd = -1;
                                    //                                        //20170830 恢复初始遍历值
                                    //                                        if (1) {
                                    //                                            find_Flag = true;
                                    //                                            tempInd = -1;
                                    //                                            minLit = 128;
                                    //                                        }
                                    //                                        setRealRedundClaId.push_back(candLitP);
                                    //                                        //end
                                    //                                        continue;
                                    //                                    }
                                    if (StrategyParam::midRJudge) {
                                        vector<UINT32>invaildLitId; //
                                        invaildLitId.reserve(6);
                                        string rundMsg; //冗余信息
                                        Subsumption subsump; //(MOSTRIGHT)
                                        //参数1 被测的子句指针 参数2 整形数组 参数3 字符串 记录冗余信息
                                        bool isRundacyR = false;
                                        isRundacyR = subsump.GenCla(fol, newCla, invaildLitId, rundMsg);
                                        if (isRundacyR) {
                                            //cout<<"R无效"<<endl;
                                            newCla->DelLits(false);
                                            delete(newCla);
                                            //20170818 需要还原vNewR 此次演绎改变了什么 
                                            //清除变元合一绑定
                                            if (!unify.vVarBindT.empty())
                                                unify.ClearVarBind(unify.vVarBindT);
                                            //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                            if (!vOnlyOutDect.empty()) {
                                                UINT32 dlen = vOnlyOutDect.size();
                                                for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                                    vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                                }
                                            }
                                            //还原vOutTri  vOnlyOutTri
                                            vOnlyOutTri.pop_back();
                                            /*
                                             * int lastRSize = vNewR.size();
                                                int lastvOutTriSize = vOutTri.size();
                                             */
                                            int incOutTriSize = vOutTri.size() - lastvOutTriSize;
                                            for (UINT16 m = 0; m < incOutTriSize; m++) {
                                                vOutTri.pop_back();
                                            }
                                            //还原归结式
                                            int incRSize = vNewR.size() - lastRSize;
                                            for (UINT16 m = 0; m < incRSize; m++) {
                                                count--;
                                                vNewR.pop_back();
                                            }
                                            vInsertNewR.clear();
                                            vector<Literal*>().swap(vInsertNewR);
                                            //20170220 增加候选子句冗余权重
                                            candClaP->reduntTimes++;
                                            //20170828
                                            pasLitInd = -1;
                                            //20170830 恢复初始遍历值
                                            if (1) {
                                                find_Flag = true;
                                                tempInd = -1;
                                                minLit = 5000;
                                            }
                                            setRealRedundClaId.push_back(candLitP);
                                            //end
                                            continue;
                                        } else {
                                            FileOp::CreateRunInfoFile(FileOp::runFileId);
                                            chgCla.push_back(newCla);
                                            //20170602 新增输出小三角形路径
                                            if (StrategyParam::divideTri) {
                                                *FileOp::ofRealInfoOut << "从编号为" + to_string(first_Given->uClaId) + "子句开始构建三角形" << endl;
                                                if (givenCla->uLitNum == 1) {
                                                    givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                                                }
                                                candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                                                //输出演绎路径
                                                 if(discardClas.empty() == false){
                                                    for(int aa= 0; aa<discardClas.size(); ++aa){
                                                        discardClas[aa]->isSDeduct = false;
                                                    }
                                                }
                                                PrintTriPath();
                                                 if(discardClas.empty() == false){
                                                    for(int aa= 0; aa<discardClas.size(); ++aa){
                                                        discardClas[aa]->isSDeduct = true;
                                                    }
                                                }
                                                vector<Clause*>().swap(discardClas);
                                                //20171025
                                                //                                                fol.InsertCla(newCla);
                                                //                                                fol.setCla.insert(newCla);
                                                midGenR = true;
                                                FileOp::WriteR(newCla);
                                                *FileOp::ofRealInfoOut << "|[Y]" << endl;
                                                fol.InsertCla(newCla);
                                                fol.setCla.insert(newCla);
                                                if(/*StrategyParam::orForCompition*/true){
                                                    newCla->addRForCompetiton();
                                                    
                                                    string rStr = "";
                                                    newCla->toString(rStr);
                                                    string outClauses = PrintCompetitionOut(newClaId);
                                                    int begPos = rStr.find_first_of("[") + 1;
                                                    int endPos = rStr.find_first_of("]");
                                                    string rId = rStr.substr(begPos, endPos - begPos);
                                                    string rContext = rStr.substr(rStr.find_first_of("]") + 1);
                                                    string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n" + "   inference(scs_inference,[]," + "[" + outClauses +"]" + ")).";
                                                    *FileOp::ofOutput << out << endl;
                                                }
                                            }
                                        }
                                    } else {
                                        FileOp::CreateRunInfoFile(FileOp::runFileId);
                                        chgCla.push_back(newCla);
                                        //20170602 新增输出小三角形路径
                                        if (StrategyParam::divideTri) {
                                            *FileOp::ofRealInfoOut << "从编号为" + to_string(first_Given->uClaId) + "子句开始构建三角形" << endl;
                                            if (givenCla->uLitNum == 1) {
                                                givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                                            }
                                            candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                                            //输出演绎路径
                                            if (discardClas.empty() == false) {
                                                for (int aa = 0; aa < discardClas.size(); ++aa) {
                                                    discardClas[aa]->isSDeduct = false;
                                                }
                                            }
                                            PrintTriPath();
                                            if (discardClas.empty() == false) {
                                                for (int aa = 0; aa < discardClas.size(); ++aa) {
                                                    discardClas[aa]->isSDeduct = true;
                                                }
                                            }
                                            vector<Clause*>().swap(discardClas);
                                            //20171025
                                            //                                            fol.InsertCla(newCla);
                                            //                                            fol.setCla.insert(newCla);
                                            midGenR = true;
                                            //20171020 对子句的含等词的文字进行项序处理
                                            //                                            if (StrategyParam::termRewriting != 2) {
                                            //                                                newCla->directEqn();
                                            //                                            }
                                            FileOp::WriteR(newCla);
                                            *FileOp::ofRealInfoOut << "|[Y]" << endl;
                                            fol.InsertCla(newCla);
                                            fol.setCla.insert(newCla);
                                            if (/*StrategyParam::orForCompition*/true) {
                                                newCla->addRForCompetiton();
                                                
                                                string rStr = "";
                                                newCla->toString(rStr);
                                                string outClauses = PrintCompetitionOut(newClaId);
                                                int begPos = rStr.find_first_of("[") + 1;
                                                int endPos = rStr.find_first_of("]");
                                                string rId = rStr.substr(begPos, endPos - begPos);
                                                string rContext = rStr.substr(rStr.find_first_of("]") + 1);
                                                string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n" + "   inference(scs_inference,[]," + "[" + outClauses +"]" + ")).";
                                                *FileOp::ofOutput << out << endl;
                                            }
                                        }
                                    }
                                }
                                //string str;
                                //newCla->toString(str);
                                //cout<<"插入中间演绎的单文字子句:" <<str << endl;
                                fol.initGenerateClaAttr(newCla);
                                newClaId++;
                            }

                        }
                        vInsertNewR.clear();
                        vector<Literal*>().swap(vInsertNewR);
                    }
                    //20170816 若生成的时两个文字的子句也保留下来
                    //                    if (count == 1 && vNewR.size() == 1 &&!findOnlyOut && StrategyParam::midR){
                    //                        //Literal* tempptr = vOnlyOutTri.back();
                    //                        vector<Literal*> vInsertNewR;
                    //                        vInsertNewR.reserve(6);
                    //                        for(int i=0;i<vNewR.size();i++){
                    //                            vInsertNewR.push_back(vNewR[i]);
                    //                        }
                    //                        vInsertNewR.push_back(vOnlyOutTri.back());//R文字已全部收集好
                    //                        //检查是否可以合并
                    //
                    //                        for (size_t rInd = 0; rInd < vInsertNewR.size() - 1; ++rInd) {
                    //                            Literal* rA = vInsertNewR[rInd];
                    //                            for (size_t rIndB = rInd + 1; rIndB < vInsertNewR.size();) {
                    //                                Literal* rB = vInsertNewR[rIndB];
                    //                                if (rA->subTerm->iTermCode == rB->subTerm->iTermCode && unify.CheckEqn(rA->subTerm, rB->subTerm)) {
                    //                                    swap(vInsertNewR[rIndB], vInsertNewR[vInsertNewR.size() - 1]);
                    //                                    vInsertNewR.pop_back();
                    //                                } else
                    //                                    ++rIndB;
                    //                            }
                    //                        }
                    //                         
                    //                        newCla = nullptr;
                    //                        newCla = new Clause(newClaId, 0);
                    //                        size_t uRsize = vInsertNewR.size();
                    //                        //文字排序
                    //                        if (uRsize > 1)
                    //                            stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmp);
                    //                        newCla->LitPtr = new Literal*[uRsize];
                    //                        for (UINT8 i = 0; i < vInsertNewR.size(); ++i) {
                    //                            Term* litSubT = unify.GetNewTerm(vInsertNewR[i]->subTerm, newCla); //参数1：文字谓词项，参数2：新子句指针
                    //                            if (TNegEqn == GetCodeProp(litSubT->iTermCode)
                    //                                    && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {
                    //                                /*
                    //                                delete(litSubT);*/--uRsize;
                    //                                //delete(newCla->LitPtr[]);
                    //                                continue;
                    //                            }
                    //                            if (newCla->uFuncDepth < litSubT->uLevel)newCla->uFuncDepth = litSubT->uLevel;
                    //                            newCla->uVarCount += litSubT->uVarCount;
                    //                            //添加到文字		
                    //                            newCla->LitPtr[newCla->uLitNum] = new Literal(litSubT, EncodeLitCode(newClaId, newCla->uLitNum + 1), newCla, nullptr);
                    //                            newCla->LitPtr[newCla->uLitNum]->parentLitPtr = vInsertNewR[i]; //母式文字，有R产生
                    //                            //cout<<to_string(newCla->uClaId)  + "]" <<"[" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitRow()) + "_" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitCol()) + "]" << newCla->LitPtr[newCla->uLitNum]->subTerm->ToString()<<endl;  
                    //                            ++(newCla->uLitNum);
                    //                        }
                    //                        if (uRsize != 0) {
                    //                            chgCla.push_back(newCla);
                    //                            //20170602 新增输出小三角形路径
                    //                            if (StrategyParam::divideTri) {
                    //                                *FileOp::ofRealInfoOut << "从编号为" + to_string(first_Given->uClaId) + "子句开始构建三角形" << endl;
                    //                                if (givenCla->uLitNum == 1) {
                    //                                    givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                    //                                }
                    //                                candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                    //                                //输出演绎路径					 
                    //                                PrintTriPath();
                    //                                FileOp::WriteR(newCla);
                    //                                *FileOp::ofRealInfoOut << "|[Y]" << endl;
                    //                            }
                    //                        }
                    //                        newClaId++;
                    //                        vInsertNewR.clear();
                    //                        vector<Literal*>().swap(vInsertNewR);
                    //                    }


                    //20170816 end
                    //20170215 保存每次子句演绎的互补对单元子句
                    claPair.clear();
                    claPair.push_back(QLit);
                    //20170215需要为参与本单元的三角形演绎单元子句设置权重
                    if (!vOnlyDectNum.empty()) {
                        for (UINT8 nm = 0; nm < vOnlyDectNum.size(); nm++) {
                            claPair.push_back(vOnlyDectNum[nm]);
                            if (vOnlyDectNum[nm]->claPtr->uLitNum == 1)
                                vOnlyDectNum[nm]->claPtr->adeductNum++; //单元子句权重加1
                        }
                    }
                    if (givenCla->uLitNum == 1) {
                        givenCla->adeductNum++; //主动归结次数+1
                        givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                    }
                    candLitP->sDuct++; //候选文字权重加一 须重新文字排序
                    if ((StrategyParam::widthDeep != 0) &&(StrategyParam::widthDeep != 1))
                        candClaP->pdeductNum++; //被动归结次数+1
                    else
                        candClaP->pdeductNum += resRandomNumber(total_Loop);
                    candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                    setRedundClaId.insert(candClaP->uClaId); //用于本次三角形不在使用已经归结过的子句
                    //20171022 拷贝已使用的子句,以达到重复使用子句的目的,拷贝条件是:上次生成了中间归结式,否则会因为拷贝的子句文字数过多,导致最终的归结式冗余
                    //20171102 拷贝单元子句
                    if (StrategyParam::useCpUintCla) {
                        if ((givenCla->uLitNum == 1) && givenCla->HasTermBind()) {
                            //拷贝新的子句来使用
                            unify.copyUintCla(fol, givenCla, newClaId);
                            hasCpUintClaId.insert(givenCla->uClaId);
                        }
                        if (vOnlyDectNum.size() > 0) {
                            for (UINT16 s = 0; s < vOnlyDectNum.size(); ++s) {
                                if ((vOnlyDectNum[s]->claPtr->uLitNum == 1) && vOnlyDectNum[s]->claPtr->HasTermBind()) {
                                    //拷贝新的子句来使用
                                    unify.copyUintCla(fol, vOnlyDectNum[s]->claPtr, newClaId);
                                    hasCpUintClaId.insert(vOnlyDectNum[s]->claPtr->uClaId);
                                }
                            }
                        }
                    }
                    if (midGenR && (StrategyParam::claReUseTimes != 0)&&(candClaP->HasTermBind())) {//2020:repaired
                        Clause* cpClaTmp = nullptr;
                        if (candClaP->topCopyCla == nullptr)
                            cpClaTmp = candClaP;
                        else
                            cpClaTmp = candClaP->topCopyCla;
                        if (copyClaCopyTimes(cpClaTmp) <= StrategyParam::claReUseTimes) {
                            Clause* cyCla = copyCla(fol, cpClaTmp, newClaId, QLit, candLitP);
                            cyCla->topCopyCla = cpClaTmp;
                        }
                        midGenR = false;
                    }
                    //20171022 end
                    if (RULEOK == unifResult) {
                        isDeduct = true;
                    }
                    //20170828 增加R文字数限制,即当vNewR.size() 大于文字数限制 则要退出
                    //20170215 子句全部落入三角形下方 需要结束三角形演绎 并判断是否能得出结论
                    if (findOnlyOut && (vNewR.size() != 0))
                        break;
                    //20170828 增加R文字数限制,即当vNewR.size() 大于文字数限制 则要退出
                    if ((vNewR.size() >= StrategyParam::R_MAX_NUM) || ((StrategyParam::R_INIT_MAX_NUM == candClaP->uLitNum)&&(candClaP->uLitNum > 10))) {
                        break;
                    }
                    //end
                    if ((givenCla->uLitNum == 1) &&(hasCpUintClaId.find(givenCla->uClaId) != hasCpUintClaId.end())) {
                        break;
                    }
                    //0:深度优先 1:宽深结合 2:宽度优先 控制三角形参与演绎的子句最大数为100
//                    if (setRedundClaId.size() > 100) {
//                        break;
//                    }
                    if (StrategyParam::widthDeep == 0) {
                        //20170830 恢复初始遍历值
                        if (1) {
                            pasLitInd = -1;
                            find_Flag = true;
                            tempInd = -1;
                            minLit = 5000;
                        }
                        continue;
                    } else if (StrategyParam::widthDeep == 1) {
                        ++cWidth;
                        if (StrategyParam::deducWidth == cWidth) {
                            break;
                        } else {
                            //20170830 恢复初始遍历值
                            if (1) {
                                pasLitInd = -1;
                                find_Flag = true;
                                tempInd = -1;
                                minLit = 5000;
                            }
                            continue; //20170113将break改成continue,深度优先
                        }
                    } else
                        break;
                } else {
                    //清除合一规则检查失败时，被置为isSdeduct为true的子句
                    if (!vOnlyOutDect.empty()) {
                        UINT32 dlen = vOnlyOutDect.size();
                        for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                            vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                        }
                    }
                }
            }//20170210 候选子句外循环  找互补对外循环体
            //只找到一次候选文字，不管有没有都退出，后期可以把深入做大
            //break;
        }//20170210 主动子句外循环
        //R超过了文字数个数限制  20170216 此处需要多加考虑
        //20170915 屏蔽
        //        if (RULEOK == MORELIT) { 
        //            if (isDeduct) {
        //                 break; //三角形结束
        //            }
        //        }
        //20170828 增加R文字数限制,即当vNewR.size() 大于文字数限制 则要退出
        if ((vNewR.size() >= StrategyParam::R_MAX_NUM) || (isDeduct && (StrategyParam::R_INIT_MAX_NUM == candClaP->uLitNum)&&(candClaP->uLitNum > 10))) {
            break;
        }
        //end
        //继续下一个合一配对
        ResClaID.insert(givenCla->uClaId);
        ResClaPtr.push_back(givenCla);
//#define cprover_fast3
#ifndef cprover_fast3
        if (20180101) {
            if (((cDeepth == (vOnlyOutTri.size() - 1)) || (cDeepth == StrategyParam::deductDeep)) && oneRunFlag) {
                cDeepth = -1;
                oneRunFlag = false;
                genUintRFirst = false;
                ResClaID.clear();
                vector<Clause*>().swap(ResClaPtr);
            }
            //20180914
            else if (((cDeepth == (vOnlyOutTri.size() - 1)) || (cDeepth == StrategyParam::deductDeep)) && !oneRunFlag && !genUintRFirst && twoRunFlag){
                cDeepth = -1;
                twoRunFlag = false;
                genUintRSecond = false;
                ResClaID.clear();
                vector<Clause*>().swap(ResClaPtr);
            }
        }
#endif
        cDeepth++;
        //20171125 如果起步子句不能构成三角形,则需要退出,提高效率
        if (!isDeduct && (cDeepth == 1)) {
            allNoPair = true;
            return 211;
        }
        //为-1时，系统自动处理；为大于0时设置值有效；
        if (cDeepth == StrategyParam::deductDeep) {
            if (isDeduct) {
                break;
            } else {//所有的单元子句都找不到互补对有效子句
                allNoPair = true;
                return 222;
            }
        }
        if (cDeepth == vOnlyOutTri.size()) {
            if (isDeduct) {
                break;
            } else {//所有的单元子句都找不到互补对有效子句
                allNoPair = true;
                return 22;
            }
        }
        clock_t end = clock();
        double time_s = (double) (end - StrategyParam::start) / (double) CLOCKS_PER_SEC;
        StrategyParam::timeLimit = StrategyParam::firstTimeLimit;
        if (time_s > StrategyParam::timeLimit * 60)//200   3  1分钟 15  5分钟   30  15分钟  end:300
        {
            if (isDeduct) {
                break;
            } else {//所有的单元子句都找不到互补对有效子句
                allNoPair = true;
                return 22;
            }
        }
        //考虑情况：配对子句已全部落入三角形内，但是之前有R剩余，此时停止构建三角形
        if ((findOnlyOut && (vNewR.size() != 0)) || cDeepth == vOnlyOutTri.size()) {
            if (findOnlyOut && (vNewR.size() != 0)) {
                //cout << "找到所有互补对单R不为空" << endl;
                if (!claPair.empty()) {
                    UINT32 lengthA = -2;
                    vector <Literal*>::iterator ie;
                    for (UINT8 lab = 0; lab < claPair.size(); lab++) {
                        ie = find(vOnlyOutTri.begin(), vOnlyOutTri.end(), claPair[lab]);
                        if (distance(vOnlyOutTri.begin(), ie) > lengthA)
                            lengthA = distance(vOnlyOutTri.begin(), ie);
                    }
                    ie = find(vOnlyOutTri.begin(), vOnlyOutTri.end(), firstR);
                    if (distance(vOnlyOutTri.begin(), ie) > lengthA) {
                        newCla = nullptr;
                        if(!StrategyParam::orForCompition && (StrategyParam::problemDiv == 0))
                            cout << "得出结论:不可满足" << endl;
                        return true;
                    }
                }
            }
            break;
        }

        givenCla = vOnlyOutTri[cDeepth]->claPtr;
        //        while (cDeepth< fol.setSingleCla.size() && fol.setCla.find(givenCla) == fol.setCla.end())
        //                    givenCla = vOnlyOutTri[++cDeepth]->claPtr;
        //string str;
        //givenCla->toString(str);
        //cout << str << endl;
    }//20170210 构建三角形结束外循环
    //生成新子句(R) 并输出演绎结果中
    newCla = nullptr;
    //20170215 用于判断最后的收尾归结子句全部落在三角形内的情况 但R不为空 
    assert(!(findOnlyOut && (vNewR.size() == 0)));
    if (!findOnlyOut) //20170215 end
    {
        vNewR.push_back(vOnlyOutTri.back());
        //vOnlyOutTri.pop_back();
    }
    //20170214 若所有的主对角线文字都没有找到满足条件互补的子句，则不输出R
    if ((vNewR.size() == 1)&&(chgCla.size() == 0)&&(find(vOnlyOutTriCmp.begin(), vOnlyOutTriCmp.end(), vNewR[0]) != vOnlyOutTriCmp.end())) {
        allNoPair = true;
        return 22;
    }
    
    // 此处判断是否有冗余的R 文字,即由该子句对角线文字没有互补对的文字存在与矛盾体中
    if (StrategyParam::litRundent) {
        for (int i = 0; i < vNewR.size(); ++i) {
            UINT16 countPair = 0;
            Clause *findCla = vNewR[i]->claPtr;
            if(findCla == vOutTri.back()->claPtr)
                continue;
            for (int j = 0; j < findCla->uLitNum; ++j) {
                if (find(vOnlyOutTri.begin(), vOnlyOutTri.end(), findCla->LitPtr[j]) != vOnlyOutTri.end()) {//找到对角线文字,查看互补对
                    for (int k = 0; k < vOutTri.size(); ++k) {
                        if ((findCla->LitPtr[j]->isPairPred(vOutTri[k])) && (unify.CheckPairEqn(findCla->LitPtr[j]->subTerm, vOutTri[k]->subTerm))) {
                            ++countPair;
                            break;
                        }
                    }
                }
            }
            if (countPair == 0) {//表示对角线没有互补对
                vNewR[i]->claPtr->isSDeduct = false;
                swap(vNewR[i], vNewR[vNewR.size() - 1]);
                vNewR.pop_back();
                --i;
                
            }
        }
    }
    
    //检查R是否有相同的合并
    for (size_t rInd = 0; rInd < vNewR.size() - 1; ++rInd) {
        Literal* rA = vNewR[rInd];
        for (size_t rIndB = rInd + 1; rIndB < vNewR.size();) {
            Literal* rB = vNewR[rIndB];
            if (rA->subTerm->iTermCode == rB->subTerm->iTermCode && unify.CheckEqn(rA->subTerm, rB->subTerm)) {
                swap(vNewR[rIndB], vNewR[vNewR.size() - 1]);
                vNewR.pop_back();
            } else
                ++rIndB;
        }
    }
    assert(vNewR.size() != 0); //20170211 考虑是否此处有R为0
    newCla = new Clause(newClaId, 0);
    newCla->isAxtom = true;
    size_t uRsize = vNewR.size();
    //文字排序
    if (uRsize > 1)
        stable_sort(vNewR.begin(), vNewR.end(), SortRule::LitCmp);
    newCla->LitPtr = new Literal*[uRsize];
    for (UINT16 i = 0; i < vNewR.size(); ++i) {
        Term* litSubT = unify.GetNewTerm(vNewR[i]->subTerm, newCla); //参数1：文字谓词项，参数2：新子句指针
        if (TNegEqn == GetCodeProp(litSubT->iTermCode)
                && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {//出现有剩余文字仍为不可满足的清空，需要考虑这种清空 20170108
            /*
            delete(litSubT);*/--uRsize;
            //delete(newCla->LitPtr[]);
            continue;
        }
        if (newCla->uFuncDepth < litSubT->uLevel)newCla->uFuncDepth = litSubT->uLevel;
        newCla->uVarCount += litSubT->uVarCount;
        //添加到文字		
        newCla->LitPtr[newCla->uLitNum] = new Literal(litSubT, EncodeLitCode(newClaId, newCla->uLitNum + 1), newCla, nullptr);
        newCla->LitPtr[newCla->uLitNum]->parentLitPtr = vNewR[i]; //母式文字，有R产生
        //newCla->LitPtr[newCla->uLitNum]->goalDeepth = vNewR[i]->goalDeepth;
        //20171020 计算演绎深度
        if (newCla ->deduceDeepth < (vNewR[i]->claPtr->deduceDeepth + 1)) {
            newCla ->deduceDeepth = vNewR[i]->claPtr->deduceDeepth + 1;
        }
        if (vNewR[i]->claPtr->isAxtom && newCla->isAxtom)
            newCla->isAxtom = true;
        else
            newCla->isAxtom = false;
        if (hasUnifGoalLit(fol, newCla->LitPtr[newCla->uLitNum])) {
            newCla->LitPtr[newCla->uLitNum]->goalDeepth = 1;
            if (newCla->goaldeepth > 1)
                newCla->goaldeepth = 1;
        } else {
            newCla->LitPtr[newCla->uLitNum]->goalDeepth = vNewR[i]->goalDeepth;
            if (newCla->goaldeepth > vNewR[i]->goalDeepth)
                newCla->goaldeepth = vNewR[i]->goalDeepth;
        }
        ++(newCla->uLitNum);
    }
    fol.initGenerateClaAttr(newCla);
    newClaId++;
    //string str;
    //newCla->toString(str);
    //cout<<"R:" << str << endl;
    return 221;
}
//201709015 从左到右构建三角形 optimal
//home/ars01/Desktop/cprover_frame/cprover_frame/build/classes/cprover_priority /home/ars01/Desktop/problems1 0 0 5 0 /home/ars01
//priorDeductionPath:
UINT8 TriAlg::GenerateTriByRecodePathLROptimalProofSearch(Formula& fol, vector<Clause*>& candidateClaSet, UINT32 &newClaId, BACKTYPE _backType, vector<Clause*> &chgCla, UINT16& loop_Num) {
    if (_backType == NOBACK)//清除变量
    {
        //assert(!(givenCla == nullptr));
        //初始化		
        PreResLit = nullptr; //上轮找到的合一文字
        setRedundClaId.clear(); //记录参与演绎的子句
        setRealRedundClaId.clear(); //记录冗余的子句
        hasCpUintClaId.clear();
        setRealRedundClaId.reserve(8);
        vector<Literal*>().swap(vNewR);
        vNewR.reserve(8);
        vector<UINT16>().swap(vComparePos);
        ResClaID.clear();
        //ResClaID.insert(givenCla->uClaId); //记录第一个归结子句编号
        vector<Clause*>().swap(ResClaPtr);
        //ResClaPtr.push_back(givenCla); //记录第一个归结子句指针
        BackPathClear(); //重要：清除路径以及上轮归结中变元的绑定 
        //stackVarChg.reserve(16);
        //noCmpCla.clear();
        stackVarChg.reserve(100);
    }
    bool creatFlag = true;
    Clause* givenCla = nullptr;
    RESULT unifResult; //是否合一
    bool isDeduct = false; //是否发生过归结
    bool isGloDeduct = false; //是否发生过归结
    Clause* candClaP = nullptr; // 被动归结子句（候选子句）
    Literal* candLitP = nullptr; //被动归结文字（候选文字）
    vector<Literal*>* vCandLit = &vOnlyOutTri; //取相同文字的map集合
    INT32 cDeepth = 0; //演绎深度
    UINT8 count = 0;
    Literal * lastTrip = nullptr;
    bool findOnlyOut = false; //用于控制子句的文字三角形摆放
    bool first_RLit = true; //记录第一次剩余的R
    Clause* lastDeductCla = nullptr;
    Clause* first_Given = candidateClaSet[0];
    bool midGenR = false; //用于限制只有在生成了中间归结式的过程中拷贝演绎子句,否则R文字数会很大
    bool oneRunFlag = true;
    bool twoRunFlag = true;
    bool genUintRFirst = true;
    bool genUintRSecond = true;
    //20170821 针对构建三角形过程中出现的冗余子句,其权重修改为加随机数,这样可以使得下次做的三角形不一样.
    if (StrategyParam::useRandrom)
        srand((unsigned int) time(nullptr));
//    if (1) {
//        cout << "start " << endl;
//        for (int i = 0; i < candidateClaSet.size(); i++) {
//            cout << "C_" << candidateClaSet[i]->uClaId << "的权重: " << candidateClaSet[i]->pdeductNum << endl;
//        }
//    }
    //cout << "三角形主界线文字数: " << vOnlyOutTri.size() << endl;
    while (1) {
        givenCla = candidateClaSet[cDeepth];
        
        stable_sort(givenCla->LitPtr, givenCla->LitPtr + givenCla->uLitNum, SortRule::ActlitCmp);
      
        UINT16 ActLitInd = 0;
        //        string str;
        //        givenCla->toString(str);
        //        cout <<"起步子句:" <<str << endl;
        for (; ActLitInd < givenCla->uLitNum; ++ActLitInd) {
            isDeduct = false;
            Literal* QLit = givenCla->LitPtr[ActLitInd];
            //根据文字互补谓词项对应的互补文字得到候选文字
            //            vCandLitAll = QLit->getPairPredLst();
            //            //提取单元子句序列
            //            if(vCandLitAll->size() == 0)
            //                continue;
            //            for(UINT32 i=0; i< vCandLitAll->size(); ++i){
            //                if(vCandLitAll->at(i)->claPtr->uLitNum == 1){
            //                    vCandLit.push_back(vCandLitAll->at(i));
            //                }
            //            }
            //            stable_sort(vCandLit.begin(), vCandLit.end(), SortRule::claSingCmp);

            //stable_sort(vCandLit->begin(), vCandLit->end(), SortRule::PoslitCmpLarge); //被动文字按子句个数进行排序  此处考虑用随机策略
            //此处考虑加大宽度，即同一子句可以左多个合一子句
            if (setRedundClaId.find(givenCla->uClaId) != setRedundClaId.end())
                continue;
            UINT32 pasLitInd = 0;
            setRealRedundClaId.clear(); //演绎文字出现冗余
            for (; pasLitInd < UINT32(vCandLit->size()); ++pasLitInd)//依次找到
            {
                //cout<<"找归结子句:"<<pasLitInd<<endl;
                candLitP = vCandLit->at(pasLitInd); //候选被动归结文字
                if (0) {//用于重复使用子句无法跳出的情况
                    clock_t end_out = clock();
                    double time_out = (double) (end_out - StrategyParam::start) / (double) CLOCKS_PER_SEC;
                    if (time_out > StrategyParam::timeLimit * 60)//200   3  1分钟 15  5分钟   30  15分钟  end:300
                    {
                        break;
                    }
                }
                if (QLit->isPairPred(candLitP) == false) {
                    continue;
                }
                candClaP = candLitP->claPtr; // 被动归结子句（候选子句）
                //20171022 增加拷贝子句的演绎限制
                if ((candClaP->uLitNum == 1) &&(hasCpUintClaId.find(candClaP->uClaId) != hasCpUintClaId.end())) {//单元子句已经被拷贝了
                    continue;
                }
                if ((givenCla->clast == CopyTemp) &&(givenCla->copyFrom == candLitP) && unify.CheckEqnR(givenCla->copyTo->subTerm, QLit->subTerm)) {//已拷贝的子句
                    continue;
                }

                //20170827 限制子句中文字数个数
                //                if (vNewR.size() + givenCla->uLitNum + candClaP->uLitNum - 2 > StrategyParam::R_MAX_NUM)
                //                    continue;

                //不允许跟上一轮母式进行归结  
                //                if ((candLitP->parentLitPtr && candLitP->parentLitPtr->claPtr == givenCla) || (QLit->parentLitPtr && QLit->parentLitPtr->claPtr == candClaP)){
                //                    continue;
                //                }
                //核心：合一算法，参数1：主动归结文字指针；参数2：被动归结文字指针
                //20180909 增加目标子句的归结 放松限制
                INT32 tempRsize = StrategyParam::R_MAX_NUM;
                if (candLitP->claPtr->isGoal && (StrategyParam::R_MAX_NUM < candLitP->claPtr->uLitNum)) {
                    StrategyParam::R_MAX_NUM = vNewR.size() + candLitP->claPtr->uLitNum;
                }
                unifResult = unify.IssynLR(QLit, candLitP); //是否找到合一文字
                StrategyParam::R_MAX_NUM = tempRsize;
                               
                //20170909 将限制还原
                //20170215  根据归结子句的互补文字，当有剩余文字既要放入主对角线，又要放入R中 此时的顺序如何选择 这里和文字的稳定排序有关
                if (unifResult == RULEOK) {
                    //                    if(creatFlag){
                    //                        FileOp::CreateRunInfoFile(candidateClaSet[cDeepth]->uClaId / 25);
                    //                        creatFlag = false;
                    //                    }
                    //20170210 stackVarChg用于保存构建三角形过程中所有的替换项
                    //20170818 记录演绎前的归结式文字个数
                    int lastRSize = vNewR.size();
                    int lastvOutTriSize = vOutTri.size();
                    stackVarChg.push_back(unify.vVarBindT); //添加到替换堆栈中	 //版本2需要重点考虑
                    //20170224对候选子句进行排序
                    //候选子句文字策略
                    //0:归结次数>稳定度 1:无(由原始顺序为准) 2:稳定度>归结次数
                    findOnlyOut = true;
                    UINT16 sumDrop = 0;
                    vector<Literal*> leftLiter; //20170305 用于保存剩余文字，以便选择最优的文字放入三角形中
                    for (UINT16 m = 0; m < givenCla->uLitNum; m++) {
                        if (givenCla->LitPtr[m]->isDrop)//互补文字
                        {
                            sumDrop++;
                            vOutTri.push_back(givenCla->LitPtr[m]);
                            //cout<<"三角形下方文字"<<"[C" + to_string(candClaP->LitPtr[m]->Row()) + "_" + to_string(candClaP->LitPtr[m]->Col()) + "]"<<(candClaP->LitPtr[m]->subTerm->ToStringBind())<<endl;
                            continue;
                        }
                        //20170305 idea 有效解决冗余:优先选择与单元子句一样的文字(合一)，另外考虑徐老师讲的同一子句可以合并的文字一定要合并
                        leftLiter.push_back(givenCla->LitPtr[m]);
                    }
                    if (!leftLiter.empty()) {
                        //查找是否有可以和单元子句合一相同的文字
                        vector<Term*> chgTempT; //储存替换变元项
                        for (UINT16 m = 0; m < leftLiter.size(); m++) {
                            bool findRes = false;
                            for (auto& clap : vOnlyOutTri) {
                                if (leftLiter[m]->isEqPred(clap) && unify.LitMgu(leftLiter[m], clap, chgTempT)) {
                                    swap(leftLiter[m], leftLiter[0]);
                                    unify.ClearVarBind(chgTempT);
                                    findRes = true;
                                    break;
                                } else
                                    unify.ClearVarBind(chgTempT);
                            }
                            if (findRes)
                                break;
                        }
                        unify.ClearVarBind(chgTempT);
                        for (UINT16 m = 0; m < leftLiter.size(); m++) {
                            if (!leftLiter[m]->isDel && findOnlyOut) {//被选归结子句剩下的文字,其中第一个放在对角线上,其余放入R中
                                lastTrip = leftLiter[m]; //记录三角形对角线演绎最后一个文字，下一次演绎需要放入三角形中
                                vOutTri.push_back(leftLiter[m]);
                                vOnlyOutTri.push_back(leftLiter[m]);
                                findOnlyOut = false;
                            } else if (!leftLiter[m]->isDel &&!findOnlyOut) {//放入R中
                                count++;
                                vOutTri.push_back(leftLiter[m]);
                                vNewR.push_back(leftLiter[m]);
                                //20170216
                                if (first_RLit) {
                                    firstR = vOnlyOutTri.back();
                                    first_RLit = false;
                                }

                            }
                        }
                    }
                    //判断是否全部放入三角形中
                    if (findOnlyOut && count == 0 && vNewR.size() == 0) {
                        newCla = nullptr;
                        givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                        candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                        if(!StrategyParam::orForCompition && (StrategyParam::problemDiv == 0))
                            cout << "得出结论:不可满足" << endl;
                        return true;
                    }
                    //20171229 此处若有剩余文字时,需要跳过该候选子句；需要做如下处理: 1.将该子句与后面的子句交换
//#define cprover_fast4
#ifndef cprover_fast4
                    if (1229) {
                        if ((vNewR.size() > 0) && genUintRFirst) {//需要回退
                            //清除变元合一绑定
                            if (!unify.vVarBindT.empty())
                                unify.ClearVarBind(unify.vVarBindT);
                            //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                            if (!vOnlyOutDect.empty()) {
                                UINT32 dlen = vOnlyOutDect.size();
                                for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                    vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                }
                            }
                            //还原vOutTri  vOnlyOutTri
                            vOnlyOutTri.pop_back();
                            int incOutTriSize = vOutTri.size() - lastvOutTriSize;
                            for (UINT16 m = 0; m < incOutTriSize; m++) {
                                vOutTri.pop_back();
                            }
                            //还原归结式
                            int incRSize = vNewR.size() - lastRSize;
                            for (UINT16 m = 0; m < incRSize; m++) {
                                count--;
                                vNewR.pop_back();
                            }
                            continue;
                        }
                        //20180914
                        else if ((vNewR.size() > 1) && (!genUintRFirst) && genUintRSecond) {//需要回退
                            //清除变元合一绑定
                            if (!unify.vVarBindT.empty())
                                unify.ClearVarBind(unify.vVarBindT);
                            //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                            if (!vOnlyOutDect.empty()) {
                                UINT32 dlen = vOnlyOutDect.size();
                                for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                    vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                }
                            }
                            //还原vOutTri  vOnlyOutTri
                            vOnlyOutTri.pop_back();
                            int incOutTriSize = vOutTri.size() - lastvOutTriSize;
                            for (UINT16 m = 0; m < incOutTriSize; m++) {
                                vOutTri.pop_back();
                            }
                            //还原归结式
                            int incRSize = vNewR.size() - lastRSize;
                            for (UINT16 m = 0; m < incRSize; m++) {
                                count--;
                                vNewR.pop_back();
                            }
                            continue;
                        }
                    }
#endif
                    //20171229 end
                    //三角形上方不剩文字，即归结出来单文字if (find(vOnlyOutTri.begin(), vOnlyOutTri.end(),givenCla->LitPtr[ActLitInd]) == vOnlyOutTri.end())
                    //中间归结式生成 static bool midR;//中间归结式生成 //true 中间归结式生成 false 中间归结式不生成
                    if (count == 0 && vNewR.size() == 0 && !findOnlyOut && StrategyParam::midR) {
                        //新建子句,生成单文字子句,最后加入到单文字子句列表中
//                        if ((newClaId == 1017) &&(vOnlyOutTri.back()->claPtr->uClaId == 11)) {
//                            cout << "debug" << endl;
//                        }
                        Literal* tempptr = vOnlyOutTri.back();
                        bool flagT = true;
                        //如果时纯文字或单文字已存在
                        if ((tempptr->getPairPredLst()->empty()) || (find(vOnlyOutTriCmp.begin(), vOnlyOutTriCmp.end(), tempptr) != vOnlyOutTriCmp.end())) {
                            flagT = false;
                        }
                        if (flagT) {
                            vector<Literal*> vInsertNewR;
                            vInsertNewR.reserve(6);
                            vInsertNewR.push_back(vOnlyOutTri.back());
                            newCla = nullptr;
                            if (!vInsertNewR.empty()) {
                                //查看是否冗余20170101
                                newCla = new Clause(newClaId, 0);
                                newCla->isAxtom = true;
                                size_t uRsize = vInsertNewR.size();
                                //文字排序
//                                if (uRsize > 1) {
//                                    if (StrategyParam::unitSortRule == 3) {
//                                        stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmpGoalDeepth);
//                                    } else
//                                        stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmp);
//                                }
                                if (uRsize > 1)
                                    stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmp);
                                newCla->LitPtr = new Literal*[uRsize];
                                for (UINT16 i = 0; i < vInsertNewR.size(); ++i) {
                                    Term* litSubT = unify.GetNewTerm(vInsertNewR[i]->subTerm, newCla); //参数1：文字谓词项，参数2：新子句指针
                                    if (TNegEqn == GetCodeProp(litSubT->iTermCode)
                                            && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {
                                        /*
                                        delete(litSubT);*/--uRsize;
                                        //delete(newCla->LitPtr[]);
                                        continue;
                                    }
                                    if (newCla->uFuncDepth < litSubT->uLevel)newCla->uFuncDepth = litSubT->uLevel;
                                    newCla->uVarCount += litSubT->uVarCount;
                                    //添加到文字	
                                    newCla->LitPtr[newCla->uLitNum] = new Literal(litSubT, EncodeLitCode(newClaId, newCla->uLitNum + 1), newCla, nullptr);
                                    newCla->LitPtr[newCla->uLitNum]->parentLitPtr = vInsertNewR[i]; //母式文字，有R产生
                                    //newCla->LitPtr[newCla->uLitNum]->goalDeepth = vInsertNewR[i]->goalDeepth;
                                    //20171020 计算演绎深度
                                    if (newCla ->deduceDeepth < (vInsertNewR[i]->claPtr->deduceDeepth + 1)) {
                                        newCla ->deduceDeepth = vInsertNewR[i]->claPtr->deduceDeepth + 1;
                                    }
                                    if (vInsertNewR[i]->claPtr->isAxtom && newCla->isAxtom)
                                        newCla->isAxtom = true;
                                    else
                                        newCla->isAxtom = false;
                                    if (hasUnifGoalLit(fol, newCla->LitPtr[newCla->uLitNum])) {
                                        newCla->LitPtr[newCla->uLitNum]->goalDeepth = 1;
                                        if (newCla->goaldeepth > 1)
                                            newCla->goaldeepth = 1;
                                    } else {
                                        newCla->LitPtr[newCla->uLitNum]->goalDeepth = vInsertNewR[i]->goalDeepth;
                                        if (newCla->goaldeepth > vInsertNewR[i]->goalDeepth)
                                            newCla->goaldeepth = vInsertNewR[i]->goalDeepth;
                                    }
                                    //cout<<to_string(newCla->uClaId)  + "]" <<"[" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitRow()) + "_" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitCol()) + "]" << newCla->LitPtr[newCla->uLitNum]->subTerm->ToString()<<endl;  
                                    ++(newCla->uLitNum);
                                }
                                //20171020 对子句的含等词的文字进行项序处理
                                if (StrategyParam::termRewriting != 2) {
                                    newCla->directEqn();
                                }
                                //cout<<newCla->LitPtr[0]->subTerm->ToStringBind()<<endl;
                                if (uRsize != 0) {
                                    //20171026 增加归结式复杂度判断
                                    if (newCla->compFuncDeepthCla() > StrategyParam::funcFixDeepth) {
                                        //cout<<"R无效"<<endl;
                                        newCla->DelLits(false);
                                        delete(newCla);
                                        //清除变元合一绑定
                                        if (!unify.vVarBindT.empty())
                                            unify.ClearVarBind(unify.vVarBindT);
                                        //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                        if (!vOnlyOutDect.empty()) {
                                            UINT32 dlen = vOnlyOutDect.size();
                                            for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                                vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                            }
                                        }
                                        //还原vOutTri  vOnlyOutTri
                                        vOnlyOutTri.pop_back();
                                        vOutTri.pop_back();
                                        for (UINT16 m = 0; m < sumDrop; m++) {
                                            vOutTri.pop_back();
                                        }
                                        vInsertNewR.clear();
                                        vector<Literal*>().swap(vInsertNewR);
                                        //20170220 增加候选子句冗余权重
                                        //givenCla->reduntTimes++;
                                        continue;
                                    }
                                    //true 中间归结式冗余判断 false 中间归结式冗余不判断
                                    //                                    if (claHasPureLit(fol, newCla)) {
                                    //                                        //cout<<"R无效"<<endl;
                                    //                                        newCla->DelLits(false);
                                    //                                        delete(newCla);
                                    //                                        //清除变元合一绑定
                                    //                                        if (!unify.vVarBindT.empty())
                                    //                                            unify.ClearVarBind(unify.vVarBindT);
                                    //                                        //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                    //                                        if (!vOnlyOutDect.empty()) {
                                    //                                            UINT32 dlen = vOnlyOutDect.size();
                                    //                                            for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                    //                                                vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                    //                                            }
                                    //                                        }
                                    //                                        //还原vOutTri  vOnlyOutTri
                                    //                                        vOnlyOutTri.pop_back();
                                    //                                        vOutTri.pop_back();
                                    //                                        for (UINT16 m = 0; m < sumDrop; m++) {
                                    //                                            vOutTri.pop_back();
                                    //                                        }
                                    //                                        vInsertNewR.clear();
                                    //                                        vector<Literal*>().swap(vInsertNewR);
                                    //                                        //20170220 增加候选子句冗余权重
                                    //                                        givenCla->reduntTimes++;
                                    //                                        continue;
                                    //                                    }
                                    if (StrategyParam::midRJudge) {
                                        vector<UINT32>invaildLitId; //
                                        invaildLitId.reserve(6);
                                        string rundMsg; //冗余信息
                                        Subsumption subsump; //(MOSTRIGHT)
                                        //参数1 被测的子句指针 参数2 整形数组 参数3 字符串 记录冗余信息
                                        bool isRundacyR = false;
                                        isRundacyR = subsump.GenCla(fol, newCla, invaildLitId, rundMsg);
                                        if (isRundacyR) {
                                            //cout<<"R无效"<<endl;
                                            newCla->DelLits(false);
                                            delete(newCla);
                                            //清除变元合一绑定
                                            if (!unify.vVarBindT.empty())
                                                unify.ClearVarBind(unify.vVarBindT);
                                            //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                            if (!vOnlyOutDect.empty()) {
                                                UINT32 dlen = vOnlyOutDect.size();
                                                for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                                    vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                                }
                                            }
                                            //还原vOutTri  vOnlyOutTri
                                            vOnlyOutTri.pop_back();
                                            vOutTri.pop_back();
                                            for (UINT16 m = 0; m < sumDrop; m++) {
                                                vOutTri.pop_back();
                                            }
                                            vInsertNewR.clear();
                                            vector<Literal*>().swap(vInsertNewR);
                                            //20170220 增加候选子句冗余权重
                                            givenCla->reduntTimes++;
                                            continue;
                                        } else {
                                            if (!StrategyParam::orForCompition)
                                                FileOp::CreateRunInfoFile(FileOp::runFileId);
                                            chgCla.push_back(newCla);
                                            //20170602 新增输出小三角形路径
                                            if (StrategyParam::divideTri) {
                                                if (!StrategyParam::orForCompition)
                                                    *FileOp::ofRealInfoOut << "从编号为" + to_string(candClaP->uClaId) + "子句开始构建三角形" << endl;
                                                
                                                if (candClaP->uLitNum == 1) {
                                                    candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                                                }
                                                givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                                                //输出演绎路径
                                                PrintTriPath();
                                                //20171020 对子句的含等词的文字进行项序处理
                                                //                                                if (StrategyParam::termRewriting != 2) {
                                                //                                                    newCla->directEqn();
                                                //                                                }
                                                if (!StrategyParam::orForCompition) {
                                                    FileOp::WriteR(newCla);
                                                    *FileOp::ofRealInfoOut << "|[Y]" << endl;
                                                }
                                                //20171024 将中间归结式加入子句集,可以用来减少冗余子句的生成
                                                fol.InsertCla(newCla);
                                                fol.setCla.insert(newCla);
                                                midGenR = true;
                                                if (/*StrategyParam::orForCompition*/true) {
                                                    if (FileOp::runMode != 0)
                                                        newCla->addRForCompetiton();
                                                    
                                                    string rStr = "";
                                                    newCla->toString(rStr);
                                                    string outClauses = PrintCompetitionOut(newClaId);
                                                    int begPos = rStr.find_first_of("[") + 1;
                                                    int endPos = rStr.find_first_of("]");
                                                    string rId = rStr.substr(begPos, endPos - begPos);
                                                    string rContext = rStr.substr(rStr.find_first_of("]") + 1);
                                                    string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n" + "   inference(scs_inference,[]," + "[" + outClauses +"]" + ")).";
                                                     
                                                    *FileOp::ofOutput << out << endl;
                                                }
                                                //20171024
                                            }
                                        }
                                    } else {
                                        if (!StrategyParam::orForCompition)
                                            FileOp::CreateRunInfoFile(FileOp::runFileId);
                                        chgCla.push_back(newCla);
                                        //20170602 新增输出小三角形路径
                                        if (StrategyParam::divideTri) {
                                            if (!StrategyParam::orForCompition)
                                                *FileOp::ofRealInfoOut << "从编号为" + to_string(candClaP->uClaId) + "子句开始构建三角形" << endl;
                                            if (candClaP->uLitNum == 1) {
                                                candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                                            }
                                            givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                                            //输出演绎路径					 
                                            PrintTriPath();
                                            if (!StrategyParam::orForCompition) {
                                                FileOp::WriteR(newCla);
                                                *FileOp::ofRealInfoOut << "|[Y]" << endl;
                                            }
                                            //20171024 将中间归结式加入子句集,可以用来减少冗余子句的生成
                                            fol.InsertCla(newCla);
                                            fol.setCla.insert(newCla);
                                            midGenR = true;
                                            if (/*StrategyParam::orForCompition*/true) {
                                                if (FileOp::runMode != 0)
                                                    newCla->addRForCompetiton();
                                                
                                                string rStr = "";
                                                newCla->toString(rStr);
                                                string outClauses = PrintCompetitionOut(newClaId);
                                                int begPos = rStr.find_first_of("[") + 1;
                                                int endPos = rStr.find_first_of("]");
                                                string rId = rStr.substr(begPos, endPos - begPos);
                                                string rContext = rStr.substr(rStr.find_first_of("]") + 1);
                                                string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n" + "   inference(scs_inference,[]," + "[" + outClauses +"]" + ")).";
               
                                                *FileOp::ofOutput << out << endl;
                                            }
                                            //20171024
                                        }
                                    }
                                    fol.initGenerateClaAttr(newCla);
                                }
                                else {
                                    newCla->DelLits(false);
                                    delete(newCla);                                    
                                }
                                //string str;
                                //newCla->toString(str);
                                //cout<<"插入中间演绎的单文字子句:" <<str << endl;
                                
                                newClaId++;
                            }
                            vInsertNewR.clear();
                            vector<Literal*>().swap(vInsertNewR);
                        } else {//说明该路径不应该搜索
                            //清除变元合一绑定
                            if (!unify.vVarBindT.empty())
                                unify.ClearVarBind(unify.vVarBindT);
                            //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                            if (!vOnlyOutDect.empty()) {
                                UINT32 dlen = vOnlyOutDect.size();
                                for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                    vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                }
                            }
                            //还原vOutTri  vOnlyOutTri
                            vOnlyOutTri.pop_back();
                            vOutTri.pop_back();
                            for (UINT16 m = 0; m < sumDrop; m++) {
                                vOutTri.pop_back();
                            }
                            givenCla->reduntTimes++;
                        }
                    }//20170816 保存生成的非单元子句
                    else if (count > 0 && vNewR.size() > 0 && !findOnlyOut && StrategyParam::midR) {
                        //新建子句,生成单文字子句,最后加入到单文字子句列表中
                        //Literal* tempptr = vOnlyOutTri.back(); 
                        bool flagT = true;
                        vector<Literal*> vInsertNewR;
                        vInsertNewR.reserve(6);
                        vInsertNewR.push_back(vOnlyOutTri.back());
                        
                        for (int i = 0; i < vNewR.size(); i++) {
                            vInsertNewR.push_back(vNewR[i]);
                        }
                        
                        // 此处判断是否有冗余的R 文字,即由该子句对角线文字没有互补对的文字存在与矛盾体中
                        vector<Clause*> discardClas;
                        discardClas.reserve(8);
                        if(StrategyParam::litRundent){
//                            if((newClaId == 1017) &&(vOnlyOutTri.back()->claPtr->uClaId == 11)){
//                                cout<<"debug"<<endl;
//                            }
                            for(int i=0; i < vInsertNewR.size(); ++i){
                                UINT16 countPair = 0;
                                Clause *findCla = vInsertNewR[i]->claPtr;
                                if(findCla == vOutTri.back()->claPtr)
                                    continue;
                                for(int j = 0; j < findCla->uLitNum; ++j){
                                    if(find(vOnlyOutTri.begin(),vOnlyOutTri.end(),findCla->LitPtr[j]) != vOnlyOutTri.end()){//找到对角线文字,查看互补对
                                        for(int k=0; k < vOutTri.size(); ++k){
//                                             if ((findCla->uClaId == 32)&&(vOutTri[k]->claPtr->uClaId == 11)) {
//                                                cout << vOutTri[k]->subTerm->ToStringBind() <<endl;
//                                                cout << findCla->LitPtr[j]->subTerm->ToStringBind() <<endl; 
//                                            }
                                            if((findCla->LitPtr[j]->isPairPred(vOutTri[k])) && (unify.CheckPairEqn(findCla->LitPtr[j]->subTerm, vOutTri[k]->subTerm))){
                                                ++countPair;
                                                break;
                                            }
                                        }                                       
                                    }
                                }
                                if(countPair == 0){//表示对角线没有互补对
                                    if(find(discardClas.begin(),discardClas.end(),vInsertNewR[i]->claPtr) == discardClas.end()){
                                        discardClas.push_back(vInsertNewR[i]->claPtr);
                                    }
                                    swap(vInsertNewR[i],vInsertNewR[vInsertNewR.size()-1]);
                                    vInsertNewR.pop_back();
                                    --i;
                                }
                            }
                        }                                           
                        //end
                        
                        for (size_t rInd = 0; rInd < vInsertNewR.size() - 1; ++rInd) {
                            Literal* rA = vInsertNewR[rInd];
                            for (size_t rIndB = rInd + 1; rIndB < vInsertNewR.size();) {
                                Literal* rB = vInsertNewR[rIndB];
                                if (rA->subTerm->iTermCode == rB->subTerm->iTermCode && unify.CheckEqn(rA->subTerm, rB->subTerm)) {
                                    swap(vInsertNewR[rIndB], vInsertNewR[vInsertNewR.size() - 1]);
                                    vInsertNewR.pop_back();
                                } else
                                    ++rIndB;
                            }
                        }
                        if (vInsertNewR.size() > StrategyParam::midR)
                            flagT = false;
                        if (flagT) {
                            newCla = nullptr;
                            if (!vInsertNewR.empty()) {
                                //查看是否冗余20170101
                                newCla = new Clause(newClaId, 0);
                                newCla->isAxtom = true;
                                size_t uRsize = vInsertNewR.size();
                                //文字排序
//                                if (uRsize > 1)
//                                    if (StrategyParam::unitSortRule == 3) {
//                                        stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmpGoalDeepth);
//                                    } else
//                                        stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmp);
                                if (uRsize > 1)
                                    stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmp);
                                newCla->LitPtr = new Literal*[uRsize];
                                for (UINT16 i = 0; i < vInsertNewR.size(); ++i) {
                                    Term* litSubT = unify.GetNewTerm(vInsertNewR[i]->subTerm, newCla); //参数1：文字谓词项，参数2：新子句指针
                                    if (TNegEqn == GetCodeProp(litSubT->iTermCode)
                                            && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {
                                        /*
                                        delete(litSubT);*/--uRsize;
                                        //delete(newCla->LitPtr[]);
                                        continue;
                                    }
                                    if (newCla->uFuncDepth < litSubT->uLevel)newCla->uFuncDepth = litSubT->uLevel;
                                    newCla->uVarCount += litSubT->uVarCount;
                                    //添加到文字		
                                    newCla->LitPtr[newCla->uLitNum] = new Literal(litSubT, EncodeLitCode(newClaId, newCla->uLitNum + 1), newCla, nullptr);
                                    newCla->LitPtr[newCla->uLitNum]->parentLitPtr = vInsertNewR[i]; //母式文字，有R产生
                                    //newCla->LitPtr[newCla->uLitNum]->goalDeepth = vInsertNewR[i]->goalDeepth;
                                    //20171020 计算演绎深度
                                    if (newCla ->deduceDeepth < (vInsertNewR[i]->claPtr->deduceDeepth + 1)) {
                                        newCla ->deduceDeepth = vInsertNewR[i]->claPtr->deduceDeepth + 1;
                                    }
                                    if (vInsertNewR[i]->claPtr->isAxtom && newCla->isAxtom)
                                        newCla->isAxtom = true;
                                    else
                                        newCla->isAxtom = false;
                                    if (hasUnifGoalLit(fol, newCla->LitPtr[newCla->uLitNum])) {
                                        newCla->LitPtr[newCla->uLitNum]->goalDeepth = 1;
                                        if (newCla->goaldeepth > 1)
                                            newCla->goaldeepth = 1;
                                    } else {
                                        newCla->LitPtr[newCla->uLitNum]->goalDeepth = vInsertNewR[i]->goalDeepth;
                                        if (newCla->goaldeepth > vInsertNewR[i]->goalDeepth)
                                            newCla->goaldeepth = vInsertNewR[i]->goalDeepth;
                                    }
                                    //cout<<to_string(newCla->uClaId)  + "]" <<"[" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitRow()) + "_" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitCol()) + "]" << newCla->LitPtr[newCla->uLitNum]->subTerm->ToString()<<endl;  
                                    ++(newCla->uLitNum);
                                }
                                //20171020 对子句的含等词的文字进行项序处理
                                if (StrategyParam::termRewriting != 2) {
                                    newCla->directEqn();
                                }
                                //cout<<newCla->LitPtr[0]->subTerm->ToStringBind()<<endl;
                                if (uRsize != 0) {
                                    //20171026 增加归结式复杂度判断
                                    if (newCla->compFuncDeepthCla() > StrategyParam::funcFixDeepth) {
                                        //cout<<"R无效"<<endl;
                                        newCla->DelLits(false);
                                        delete(newCla);
                                        //20170818 需要还原vNewR 此次演绎改变了什么 
                                        //清除变元合一绑定
                                        if (!unify.vVarBindT.empty())
                                            unify.ClearVarBind(unify.vVarBindT);
                                        //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                        if (!vOnlyOutDect.empty()) {
                                            UINT32 dlen = vOnlyOutDect.size();
                                            for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                                vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                            }
                                        }
                                        //还原vOutTri  vOnlyOutTri
                                        vOnlyOutTri.pop_back();
                                        int incOutTriSize = vOutTri.size() - lastvOutTriSize;
                                        for (UINT16 m = 0; m < incOutTriSize; m++) {
                                            vOutTri.pop_back();
                                        }
                                        //还原归结式
                                        int incRSize = vNewR.size() - lastRSize;
                                        for (UINT16 m = 0; m < incRSize; m++) {
                                            count--;
                                            vNewR.pop_back();
                                        }
                                        vInsertNewR.clear();
                                        vector<Literal*>().swap(vInsertNewR);
                                        //20170220 增加候选子句冗余权重
                                        //candClaP->reduntTimes++;
                                        continue;
                                    }
                                    //true 中间归结式冗余判断 false 中间归结式冗余不判断
                                    //                                    if (claHasPureLit(fol, newCla)) {
                                    //                                        //cout<<"R无效"<<endl;
                                    //                                        newCla->DelLits(false);
                                    //                                        delete(newCla);
                                    //                                        //20170818 需要还原vNewR 此次演绎改变了什么 
                                    //                                        //清除变元合一绑定
                                    //                                        if (!unify.vVarBindT.empty())
                                    //                                            unify.ClearVarBind(unify.vVarBindT);
                                    //                                        //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                    //                                        if (!vOnlyOutDect.empty()) {
                                    //                                            UINT32 dlen = vOnlyOutDect.size();
                                    //                                            for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                    //                                                vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                    //                                            }
                                    //                                        }
                                    //                                        //还原vOutTri  vOnlyOutTri
                                    //                                        vOnlyOutTri.pop_back();
                                    //                                        int incOutTriSize = vOutTri.size() - lastvOutTriSize;
                                    //                                        for (UINT16 m = 0; m < incOutTriSize; m++) {
                                    //                                            vOutTri.pop_back();
                                    //                                        }
                                    //                                        //还原归结式
                                    //                                        int incRSize = vNewR.size() - lastRSize;
                                    //                                        for (UINT16 m = 0; m < incRSize; m++) {
                                    //                                            count--;
                                    //                                            vNewR.pop_back();
                                    //                                        }
                                    //                                        vInsertNewR.clear();
                                    //                                        vector<Literal*>().swap(vInsertNewR);
                                    //                                        //20170220 增加候选子句冗余权重
                                    //                                        candClaP->reduntTimes++;
                                    //                                        continue;
                                    //                                    }
                                    if (StrategyParam::midRJudge) {
                                        vector<UINT32>invaildLitId; //
                                        invaildLitId.reserve(6);
                                        string rundMsg; //冗余信息
                                        Subsumption subsump; //(MOSTRIGHT)
                                        //参数1 被测的子句指针 参数2 整形数组 参数3 字符串 记录冗余信息
                                        bool isRundacyR = false;
                                        isRundacyR = subsump.GenCla(fol, newCla, invaildLitId, rundMsg);
                                        if (isRundacyR) {
                                            //cout<<"R无效"<<endl;
                                            newCla->DelLits(false);
                                            delete(newCla);
                                            //20170818 需要还原vNewR 此次演绎改变了什么 
                                            //清除变元合一绑定
                                            if (!unify.vVarBindT.empty())
                                                unify.ClearVarBind(unify.vVarBindT);
                                            //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                            if (!vOnlyOutDect.empty()) {
                                                UINT32 dlen = vOnlyOutDect.size();
                                                for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                                    vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                                }
                                            }
                                            //还原vOutTri  vOnlyOutTri
                                            vOnlyOutTri.pop_back();
                                            int incOutTriSize = vOutTri.size() - lastvOutTriSize;
                                            for (UINT16 m = 0; m < incOutTriSize; m++) {
                                                vOutTri.pop_back();
                                            }
                                            //还原归结式
                                            int incRSize = vNewR.size() - lastRSize;
                                            for (UINT16 m = 0; m < incRSize; m++) {
                                                count--;
                                                vNewR.pop_back();
                                            }
                                            vInsertNewR.clear();
                                            vector<Literal*>().swap(vInsertNewR);
                                            //20170220 增加候选子句冗余权重
                                            candClaP->reduntTimes++;
                                            continue;
                                        } else {
                                            if (!StrategyParam::orForCompition)
                                                FileOp::CreateRunInfoFile(FileOp::runFileId);
                                            chgCla.push_back(newCla);
                                            //20170602 新增输出小三角形路径
                                            if (StrategyParam::divideTri) {
                                                if (!StrategyParam::orForCompition)
                                                    *FileOp::ofRealInfoOut << "从编号为" + to_string(candClaP->uClaId) + "子句开始构建三角形" << endl;
                                                if (candClaP->uLitNum == 1) {
                                                    candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                                                }
                                                givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                                                //输出演绎路径
                                                if(discardClas.empty() == false){
                                                    for(int aa= 0; aa<discardClas.size(); ++aa){
                                                        discardClas[aa]->isSDeduct = false;
                                                    }
                                                }
                                                PrintTriPath();
                                                if(discardClas.empty() == false){
                                                    for(int aa= 0; aa<discardClas.size(); ++aa){
                                                        discardClas[aa]->isSDeduct = true;
                                                    }
                                                }
                                                vector<Clause*>().swap(discardClas);
                                                if (!StrategyParam::orForCompition) {
                                                    FileOp::WriteR(newCla);
                                                    *FileOp::ofRealInfoOut << "|[Y]" << endl;
                                                }
                                                //20171024 将中间归结式加入子句集,可以用来减少冗余子句的生成
                                                fol.InsertCla(newCla);
                                                fol.setCla.insert(newCla);
                                                midGenR = true;
                                                if (/*StrategyParam::orForCompition*/true) {
                                                    if (FileOp::runMode != 0)
                                                        newCla->addRForCompetiton();
                                                    
                                                    string rStr = "";
                                                    newCla->toString(rStr);
                                                    string outClauses = PrintCompetitionOut(newClaId);
                                                    int begPos = rStr.find_first_of("[") + 1;
                                                    int endPos = rStr.find_first_of("]");
                                                    string rId = rStr.substr(begPos, endPos - begPos);
                                                    string rContext = rStr.substr(rStr.find_first_of("]") + 1);
                                                    string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n" + "   inference(scs_inference,[]," + "[" + outClauses +"]" + ")).";
                                                    *FileOp::ofOutput << out << endl;
                                                }
                                                //20171024
                                            }
                                        }
                                    } else {
                                        if (!StrategyParam::orForCompition)
                                            FileOp::CreateRunInfoFile(FileOp::runFileId);
                                        chgCla.push_back(newCla);
                                        //20170602 新增输出小三角形路径
                                        if (StrategyParam::divideTri) {
                                            if (!StrategyParam::orForCompition)
                                                *FileOp::ofRealInfoOut << "从编号为" + to_string(candClaP->uClaId) + "子句开始构建三角形" << endl;
                                            if (candClaP->uLitNum == 1) {
                                                candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                                            }
                                            givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                                            //输出演绎路径	
                                            if(discardClas.empty() == false){
                                                    for(int aa= 0; aa<discardClas.size(); ++aa){
                                                        discardClas[aa]->isSDeduct = false;
                                                    }
                                                }
                                            PrintTriPath();
                                            if(discardClas.empty() == false){
                                                    for(int aa= 0; aa<discardClas.size(); ++aa){
                                                        discardClas[aa]->isSDeduct = true;
                                                    }
                                                }
                                            vector<Clause*>().swap(discardClas);
                                            //20171020 对子句的含等词的文字进行项序处理
                                            //                                            if (StrategyParam::termRewriting != 2) {
                                            //                                                newCla->directEqn();
                                            //                                            }
                                            if (!StrategyParam::orForCompition) {
                                                FileOp::WriteR(newCla);
                                                *FileOp::ofRealInfoOut << "|[Y]" << endl;
                                            }
                                            //20171024 将中间归结式加入子句集,可以用来减少冗余子句的生成
                                            fol.InsertCla(newCla);
                                            fol.setCla.insert(newCla);
                                            midGenR = true;
                                            if (/*StrategyParam::orForCompition*/true) {
                                                if (FileOp::runMode != 0)
                                                    newCla->addRForCompetiton();
                                                
                                                string rStr = "";
                                                newCla->toString(rStr);
                                                string outClauses = PrintCompetitionOut(newClaId);
                                                int begPos = rStr.find_first_of("[") + 1;
                                                int endPos = rStr.find_first_of("]");
                                                string rId = rStr.substr(begPos, endPos - begPos);
                                                string rContext = rStr.substr(rStr.find_first_of("]") + 1);
                                                string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n" + "   inference(scs_inference,[]," + "[" + outClauses +"]" + ")).";
                                                *FileOp::ofOutput << out << endl;
                                            }
                                            //20171024
                                        }
                                    }
                                    fol.initGenerateClaAttr(newCla);
                                }
                                else {
                                    newCla->DelLits(false);
                                    delete(newCla);                                    
                                }
                                //string str;
                                //newCla->toString(str);
                                //cout<<"插入中间演绎的单文字子句:" <<str << endl;
                                
                                newClaId++;
                            }

                        }
                        vInsertNewR.clear();
                        vector<Literal*>().swap(vInsertNewR);
                    }
                    //20170215 保存每次子句演绎的互补对单元子句
                    claPair.clear();
                    claPair.push_back(QLit);
                    //20170215需要为参与本单元的三角形演绎单元子句设置权重
                    if (!vOnlyDectNum.empty()) {
                        for (UINT8 nm = 0; nm < vOnlyDectNum.size(); nm++) {
                            claPair.push_back(vOnlyDectNum[nm]);
                            if (vOnlyDectNum[nm]->claPtr->uLitNum == 1)
                                vOnlyDectNum[nm]->claPtr->adeductNum++; //单元子句权重加1
                        }
                    }
                    if (candClaP->uLitNum == 1) {
                        candClaP->adeductNum++; //主动归结次数+1
                        candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                    }
                    QLit->sDuct++; //候选文字权重加一 须重新文字排序
                    //2020:repaired
                    if (givenCla->isAxtom == false) {//2020:have repaired
                        givenCla->pdeductNum += 1/*resRandomNumber(total_Loop)*/;
//                        if (givenCla->clast == CopyTemp)
//                            givenCla->topCopyCla->pdeductNum += 1;
//                        else
//                            givenCla->pdeductNum += 1;
                    }
                    else {
                        givenCla->pdeductNum += 5/*resRandomNumber(total_Loop)+ total_Loop/2*/;//add: + total_Loop/2
//                        if (givenCla->clast == CopyTemp)
//                            givenCla->topCopyCla->pdeductNum += 5;
//                        else
//                            givenCla->pdeductNum += 5;                   
                    }
                    //givenCla->pdeductNum += resRandomNumber(total_Loop); //total_Loop 怎么得到
                    givenCla->isSDeduct = true; //在构建三角形过程中参与归结

                    //20171022 拷贝已使用的子句,以达到重复使用子句的目的
                    //如果演绎的不是上次拷贝的子句,则需要将其删除
                    //                    if((lastDeductCla != nullptr) &&(givenCla != lastDeductCla)){//说明拷贝的子句没有用上
                    //                        //在演绎子句列表中清除lastDeductCla
                    //                        vector<Clause*>::iterator delInd = find(candidateClaSet.begin(),candidateClaSet.end(),lastDeductCla);
                    //                        candidateClaSet.erase(delInd);
                    //                        //在拷贝的子句列表中清除lastDeductCla
                    //                        lastDeductCla->DelLits(false);
                    //                        delete(lastDeductCla);
                    //                    }
                    if (StrategyParam::useCpUintCla || true) {//拷贝单元子句
                        if ((candClaP->uLitNum == 1) && candClaP->HasTermBind()) {
                            //拷贝新的子句来使用
                            unify.copyUintCla(fol, candClaP, newClaId);
                            hasCpUintClaId.insert(candClaP->uClaId);
                        }
                        if (vOnlyDectNum.size() > 0) {
                            for (UINT16 s = 0; s < vOnlyDectNum.size(); ++s) {
                                if ((vOnlyDectNum[s]->claPtr->uLitNum == 1) && vOnlyDectNum[s]->claPtr->HasTermBind()) {
                                    //拷贝新的子句来使用
                                    unify.copyUintCla(fol, vOnlyDectNum[s]->claPtr, newClaId);
                                    hasCpUintClaId.insert(vOnlyDectNum[s]->claPtr->uClaId);
                                }
                            }
                        }
                    }
                    if (midGenR && (StrategyParam::claReUseTimes != 0) && (givenCla->HasTermBind())) {//2020:repaired
                        Clause* cpClaTmp = nullptr;
                        if (givenCla->topCopyCla == nullptr)
                            cpClaTmp = givenCla;
                        else
                            cpClaTmp = givenCla->topCopyCla;
                        if (copyClaCopyTimes(cpClaTmp) < StrategyParam::claReUseTimes) {
                            Clause* cyCla = copyCla(fol, cpClaTmp, newClaId, candLitP, QLit);
                            cyCla->topCopyCla = cpClaTmp;
                            lastDeductCla = cyCla;
                            //插入到演绎子句列表中
                            vector<Clause*>::iterator insertInd = find(candidateClaSet.begin(), candidateClaSet.end(), givenCla);
                            candidateClaSet.insert(insertInd + 1, cyCla);
                            midGenR = false;
                        }

                    }
                    //20171022 end

                    setRedundClaId.insert(givenCla->uClaId); //用于本次三角形不在使用已经归结过的子句
                    if (RULEOK == unifResult) {
                        isDeduct = true;
                        isGloDeduct = true;
                    }
                    //20170828 增加R文字数限制,即当vNewR.size() 大于文字数限制 则要退出
                    //20170215 子句全部落入三角形下方 需要结束三角形演绎 并判断是否能得出结论
                    if (findOnlyOut && (vNewR.size() != 0))
                        break;
                    //20170828 增加R文字数限制,即当vNewR.size() 大于文字数限制 则要退出
                    if ((vNewR.size() >= StrategyParam::R_MAX_NUM) || ((StrategyParam::R_INIT_MAX_NUM == givenCla->uLitNum)&&(givenCla->uLitNum > 10))) {
                        break;
                    }
                    //end
                    //0:深度优先 1:宽深结合 2:宽度优先
                    if (StrategyParam::widthDeep == 0) {
                        break;
                    } else if (StrategyParam::widthDeep == 1) {
                        break;
                    } else
                        break;
                } else {
                    //清除合一规则检查失败时，被置为isSdeduct为true的子句
                    if (!vOnlyOutDect.empty()) {
                        UINT32 dlen = vOnlyOutDect.size();
                        for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                            vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                        }
                    }
                }
            }//20170210 候选子句外循环  找互补对外循环体
            //20171026 应该要遍历所有的文字
            if (isDeduct)
                break;
            //只找到一次候选文字，不管有没有都退出，后期可以把深入做大
            //break;
        }//20170210 主动子句外循环
        //20170828 增加R文字数限制,即当vNewR.size() 大于文字数限制 则要退出
        if ((vNewR.size() >= StrategyParam::R_MAX_NUM) || (isDeduct && (StrategyParam::R_INIT_MAX_NUM == candClaP->uLitNum)&&(candClaP->uLitNum > 10))) {
            break;
        }
        //end
        //继续下一个合一配对
        ResClaID.insert(givenCla->uClaId);
        ResClaPtr.push_back(givenCla);
//#define cprover_fast5
#ifndef cprover_fast5
        if (20180101) {
            if (((cDeepth == (candidateClaSet.size() - 1)) || (cDeepth == StrategyParam::deductDeep)) && oneRunFlag) {
                cDeepth = -1;
                oneRunFlag = false;
                genUintRFirst = false;
            }
            //20180914
            else if (((cDeepth == (candidateClaSet.size() - 1)) || (cDeepth == StrategyParam::deductDeep)) && !oneRunFlag && !genUintRFirst && twoRunFlag) {
                cDeepth = -1;
                twoRunFlag = false;
                genUintRSecond = false;
            }
        }
#endif
        cDeepth++;
        //为-1时，系统自动处理；为大于0时设置值有效；
        if (cDeepth == StrategyParam::deductDeep) {
            if (isGloDeduct) {
                break;
            } else {
                allNoPair = true;
                return 222;
            }
        }
        if (cDeepth == candidateClaSet.size()) {
            if (isGloDeduct) {
                break;
            } else {//所有的单元子句都找不到互补对有效子句
                allNoPair = true;
                return 22;
            }
        }
        //控制三角形演绎子句的总长度
//        if (setRedundClaId.size() > 160) {
//            if (isGloDeduct) {
//                break;
//            } else {//所有的单元子句都找不到互补对有效子句
//                allNoPair = true;
//                return 22;
//            }
//        }
        clock_t end = clock();
        double time_s = (double) (end - StrategyParam::start) / (double) CLOCKS_PER_SEC;
        if (time_s > StrategyParam::firstTimeLimit * 60)//200   3  1分钟 15  5分钟   30  15分钟  end:300
        {
            if (isGloDeduct) {
                break;
            } else {//所有的单元子句都找不到互补对有效子句
                allNoPair = true;
                return 22;
            }
        }
        //考虑情况：配对子句已全部落入三角形内，但是之前有R剩余，此时停止构建三角形
        //       if ((findOnlyOut && (vNewR.size() != 0)) || cDeepth == vOnlyOutTri.size()) {
        //           if (findOnlyOut && (vNewR.size() != 0)) {
        //                //cout << "找到所有互补对单R不为空" << endl;
        //                if (!claPair.empty()) {
        //                    UINT32 lengthA = -2;
        //                    vector <Literal*>::iterator ie;
        //                    for (UINT8 lab = 0; lab < claPair.size(); lab++) {
        //                        ie = find(vOnlyOutTri.begin(), vOnlyOutTri.end(), claPair[lab]);
        //                        if (distance(vOnlyOutTri.begin(), ie) > lengthA)
        //                            lengthA = distance(vOnlyOutTri.begin(), ie);
        //                    }
        //                    ie = find(vOnlyOutTri.begin(), vOnlyOutTri.end(), firstR);
        //                    if (distance(vOnlyOutTri.begin(), ie) > lengthA) {
        //                        newCla = nullptr;
        //                        cout << "得出结论:不可满足" << endl;
        //                        return true;
        //                    }
        //                }
        //            }
        //             break;
        //        }
        givenCla = candidateClaSet[cDeepth];
        //string str;
        //givenCla->toString(str);
        //cout << str << endl;
    }//20170210 构建三角形结束外循环
    
//    if (1) {
//        cout << "end " << endl;
//        for (int i = 0; i < candidateClaSet.size(); i++) {
//            cout << "C_" << candidateClaSet[i]->uClaId << "的权重: " << candidateClaSet[i]->pdeductNum;
//            if (candidateClaSet[i]->clast == CopyTemp)
//                cout << " (为 C_" << candidateClaSet[i]->topCopyCla->uClaId << "的拷贝子句，实际为C_" << candidateClaSet[i]->topCopyCla->uClaId << "的重复使用，权重: " << candidateClaSet[i]->topCopyCla->pdeductNum;
//            cout << endl;
//        }
//    }
    //生成新子句(R) 并输出演绎结果中
    newCla = nullptr;
    //20170215 用于判断最后的收尾归结子句全部落在三角形内的情况 但R不为空 
    assert(!(findOnlyOut && (vNewR.size() == 0)));
    if (!findOnlyOut) //20170215 end
    {
        vNewR.push_back(vOnlyOutTri.back());
        //vOnlyOutTri.pop_back();
    }
    //20170214 若所有的主对角线文字都没有找到满足条件互补的子句，则不输出R
    if ((vNewR.size() == 1)&&(chgCla.size() == 0)&&(find(vOnlyOutTriCmp.begin(), vOnlyOutTriCmp.end(), vNewR[0]) != vOnlyOutTriCmp.end())) {
        allNoPair = true;
        return 22;
    }
    
      // 此处判断是否有冗余的R 文字,即由该子句对角线文字没有互补对的文字存在与矛盾体中
    if (StrategyParam::litRundent) {
        for (int i = 0; i < vNewR.size(); ++i) {
            UINT16 countPair = 0;
            Clause *findCla = vNewR[i]->claPtr;
            if(findCla == vOutTri.back()->claPtr)
                continue;
            for (int j = 0; j < findCla->uLitNum; ++j) {
                if (find(vOnlyOutTri.begin(), vOnlyOutTri.end(), findCla->LitPtr[j]) != vOnlyOutTri.end()) {//找到对角线文字,查看互补对
                    for (int k = 0; k < vOutTri.size(); ++k) {
                        if ((findCla->LitPtr[j]->isPairPred(vOutTri[k])) && (unify.CheckPairEqn(findCla->LitPtr[j]->subTerm, vOutTri[k]->subTerm))) {
                            ++countPair;
                            break;
                        }
                    }
                }
            }
            if (countPair == 0) {//表示对角线没有互补对
                vNewR[i]->claPtr->isSDeduct = false;
                swap(vNewR[i], vNewR[vNewR.size() - 1]);
                vNewR.pop_back();
                --i;
                
            }
        }
    }
    
    //检查R是否有相同的合并
    for (size_t rInd = 0; rInd < vNewR.size() - 1; ++rInd) {
        Literal* rA = vNewR[rInd];
        for (size_t rIndB = rInd + 1; rIndB < vNewR.size();) {
            Literal* rB = vNewR[rIndB];
            if (rA->subTerm->iTermCode == rB->subTerm->iTermCode && unify.CheckEqn(rA->subTerm, rB->subTerm)) {
                swap(vNewR[rIndB], vNewR[vNewR.size() - 1]);
                vNewR.pop_back();
            } else
                ++rIndB;
        }
    }

  
    
    assert(vNewR.size() != 0); //20170211 考虑是否此处有R为0
    newCla = new Clause(newClaId, 0);
    newCla->isAxtom = true;
    size_t uRsize = vNewR.size();
    //文字排序
    if (uRsize > 1)
        stable_sort(vNewR.begin(), vNewR.end(), SortRule::LitCmp);
    newCla->LitPtr = new Literal*[uRsize];
    for (UINT16 i = 0; i < vNewR.size(); ++i) {
        Term* litSubT = unify.GetNewTerm(vNewR[i]->subTerm, newCla); //参数1：文字谓词项，参数2：新子句指针
//        if (TNegEqn == GetCodeProp(litSubT->iTermCode)
//                && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {//出现有剩余文字仍为不可满足的清空，需要考虑这种清空 20170108
//            /*
//            delete(litSubT);*/
//            --uRsize;
//            //delete(newCla->LitPtr[]);
//            continue;
//        }
        if (newCla->uFuncDepth < litSubT->uLevel)newCla->uFuncDepth = litSubT->uLevel;
        newCla->uVarCount += litSubT->uVarCount;
        //添加到文字		
        newCla->LitPtr[newCla->uLitNum] = new Literal(litSubT, EncodeLitCode(newClaId, newCla->uLitNum + 1), newCla, nullptr);
        newCla->LitPtr[newCla->uLitNum]->parentLitPtr = vNewR[i]; //母式文字，有R产生
        //newCla->LitPtr[newCla->uLitNum]->goalDeepth = vNewR[i]->goalDeepth;
        //20171020 计算演绎深度
        if (newCla ->deduceDeepth < (vNewR[i]->claPtr->deduceDeepth + 1)) {
            newCla ->deduceDeepth = vNewR[i]->claPtr->deduceDeepth + 1;
        }
        if (vNewR[i]->claPtr->isAxtom && newCla->isAxtom)
            newCla->isAxtom = true;
        else
            newCla->isAxtom = false;
        if (hasUnifGoalLit(fol, newCla->LitPtr[newCla->uLitNum])) {
            newCla->LitPtr[newCla->uLitNum]->goalDeepth = 1;
            if (newCla->goaldeepth > 1)
                newCla->goaldeepth = 1;
        } else {
            newCla->LitPtr[newCla->uLitNum]->goalDeepth = vNewR[i]->goalDeepth;
            if (newCla->goaldeepth > vNewR[i]->goalDeepth)
                newCla->goaldeepth = vNewR[i]->goalDeepth;
        }
        ++(newCla->uLitNum);
    }
    fol.initGenerateClaAttr(newCla);
    newClaId++;
    //string str;
    //newCla->toString(str);
    //cout<<"R:" << str << endl;
    return 221;
}

//201709015 从左到右构建三角形

UINT8 TriAlg::GenerateTriByRecodePathLR(Formula& fol, vector<Clause*>& candidateClaSet, UINT32 &newClaId, BACKTYPE _backType, vector<Clause*> &chgCla, UINT16& loop_Num) {
    if (_backType == NOBACK)//清除变量
    {
        //assert(!(givenCla == nullptr));
        //初始化		
        PreResLit = nullptr; //上轮找到的合一文字
        setRedundClaId.clear(); //记录参与演绎的子句
        setRealRedundClaId.clear(); //记录冗余的子句
        hasCpUintClaId.clear();
        setRealRedundClaId.reserve(8);
        vector<Literal*>().swap(vNewR);
        vNewR.reserve(8);
        vector<UINT16>().swap(vComparePos);
        ResClaID.clear();
        //ResClaID.insert(givenCla->uClaId); //记录第一个归结子句编号
        vector<Clause*>().swap(ResClaPtr);
        //ResClaPtr.push_back(givenCla); //记录第一个归结子句指针
        BackPathClear(); //重要：清除路径以及上轮归结中变元的绑定 
        //stackVarChg.reserve(16);
        //noCmpCla.clear();
        stackVarChg.reserve(100);
    }
    bool creatFlag = true;
    Clause* givenCla = nullptr;
    RESULT unifResult; //是否合一
    bool isDeduct = false; //是否发生过归结
    bool isGloDeduct = false; //是否发生过归结
    Clause* candClaP = nullptr; // 被动归结子句（候选子句）
    Literal* candLitP = nullptr; //被动归结文字（候选文字）
    vector<Literal*>* vCandLit = &vOnlyOutTri; //取相同文字的map集合
    INT32 cDeepth = 0; //演绎深度
    UINT8 count = 0;
    Literal * lastTrip = nullptr;
    bool findOnlyOut = false; //用于控制子句的文字三角形摆放
    bool first_RLit = true; //记录第一次剩余的R
    Clause* lastDeductCla = nullptr;
    Clause* first_Given = candidateClaSet[0];
    bool midGenR = false; //用于限制只有在生成了中间归结式的过程中拷贝演绎子句,否则R文字数会很大
    bool oneRunFlag = true;
    bool twoRunFlag = true;
    bool genUintRFirst = true;
    bool genUintRSecond = true;
    UINT32 lastMainDiagonalInd = 0;
    //20170821 针对构建三角形过程中出现的冗余子句,其权重修改为加随机数,这样可以使得下次做的三角形不一样.
    if (StrategyParam::useRandrom)
        srand((unsigned int) time(nullptr));
    while (1) {
        if(1){//just for timeout
            clock_t end_control = clock();
            double time_control = (double) (end_control - StrategyParam::start) / (double) CLOCKS_PER_SEC;
            if (time_control > StrategyParam::firstTimeLimit * 60)//200   3  1分钟 15  5分钟   30  15分钟  end:300
            {
                if (isGloDeduct) {
                    break;
                } else {//所有的单元子句都找不到互补对有效子句
                    allNoPair = true;
                    return 22;
                }
            }
        }
        givenCla = candidateClaSet[cDeepth];
        if(givenCla->clast != CopyTemp)
            stable_sort(givenCla->LitPtr, givenCla->LitPtr + givenCla->uLitNum, SortRule::ActlitCmp);
        UINT16 ActLitInd = 0;
        //        string str;
        //        givenCla->toString(str);
        //        cout <<"起步子句:" <<str << endl;
        for (; ActLitInd < givenCla->uLitNum; ++ActLitInd) {//ActLitInd = ActLitInd + givenCla->uLitNum
            isDeduct = false;
            Literal* QLit = givenCla->LitPtr[ActLitInd];
            //根据文字互补谓词项对应的互补文字得到候选文字
            //            vCandLitAll = QLit->getPairPredLst();
            //            //提取单元子句序列
            //            if(vCandLitAll->size() == 0)
            //                continue;
            //            for(UINT32 i=0; i< vCandLitAll->size(); ++i){
            //                if(vCandLitAll->at(i)->claPtr->uLitNum == 1){
            //                    vCandLit.push_back(vCandLitAll->at(i));
            //                }
            //            }
            //            stable_sort(vCandLit.begin(), vCandLit.end(), SortRule::claSingCmp);

            //stable_sort(vCandLit->begin(), vCandLit->end(), SortRule::PoslitCmpLarge); //被动文字按子句个数进行排序  此处考虑用随机策略
            //此处考虑加大宽度，即同一子句可以左多个合一子句
            if (setRedundClaId.find(givenCla->uClaId) != setRedundClaId.end())
                continue;
            UINT32 pasLitInd = 0;
            setRealRedundClaId.clear(); //演绎文字出现冗余
            for (; pasLitInd < UINT32(vCandLit->size()); ++pasLitInd)//依次找到
            {
                //cout<<"找归结子句:"<<pasLitInd<<endl;
                if((givenCla->clast == CopyTemp) && (lastMainDiagonalInd <= pasLitInd)){
                    continue;
                }
                lastMainDiagonalInd = pasLitInd;
                candLitP = vCandLit->at(pasLitInd); //候选被动归结文字
                if (0) {//用于重复使用子句无法跳出的情况
                    clock_t end_out = clock();
                    double time_out = (double) (end_out - StrategyParam::start) / (double) CLOCKS_PER_SEC;
                    if (time_out > StrategyParam::timeLimit * 60)//200   3  1分钟 15  5分钟   30  15分钟  end:300
                    {
                        break;
                    }
                }
                if (QLit->isPairPred(candLitP) == false) {
                    continue;
                }
                candClaP = candLitP->claPtr; // 被动归结子句（候选子句）
                //20171022 增加拷贝子句的演绎限制
                if ((candClaP->uLitNum == 1) &&(hasCpUintClaId.find(candClaP->uClaId) != hasCpUintClaId.end())) {//单元子句已经被拷贝了
                    continue;
                }
                if ((givenCla->clast == CopyTemp) &&(givenCla->copyFrom == candLitP) && unify.CheckEqnR(givenCla->copyTo->subTerm, QLit->subTerm)) {//已拷贝的子句
                    continue;
                }

                //20170827 限制子句中文字数个数
                //                if (vNewR.size() + givenCla->uLitNum + candClaP->uLitNum - 2 > StrategyParam::R_MAX_NUM)
                //                    continue;

                //不允许跟上一轮母式进行归结  
                //                if ((candLitP->parentLitPtr && candLitP->parentLitPtr->claPtr == givenCla) || (QLit->parentLitPtr && QLit->parentLitPtr->claPtr == candClaP)){
                //                    continue;
                //                }
                //核心：合一算法，参数1：主动归结文字指针；参数2：被动归结文字指针
                //20180909 增加目标子句的归结 放松限制
                INT32 tempRsize = StrategyParam::R_MAX_NUM;
                if (candLitP->claPtr->isGoal && (StrategyParam::R_MAX_NUM < candLitP->claPtr->uLitNum)) {
                    StrategyParam::R_MAX_NUM = vNewR.size() + candLitP->claPtr->uLitNum;
                }
                unifResult = unify.IssynLR(QLit, candLitP); //是否找到合一文字
                StrategyParam::R_MAX_NUM = tempRsize;
                //20170909 将限制还原
                //20170215  根据归结子句的互补文字，当有剩余文字既要放入主对角线，又要放入R中 此时的顺序如何选择 这里和文字的稳定排序有关
                if (unifResult == RULEOK) {
                    //                    if(creatFlag){
                    //                        FileOp::CreateRunInfoFile(candidateClaSet[cDeepth]->uClaId / 25);
                    //                        creatFlag = false;
                    //                    }
                    //20170210 stackVarChg用于保存构建三角形过程中所有的替换项
                    //20170818 记录演绎前的归结式文字个数
                    int lastRSize = vNewR.size();
                    int lastvOutTriSize = vOutTri.size();
                    stackVarChg.push_back(unify.vVarBindT); //添加到替换堆栈中	 //版本2需要重点考虑	 
                    //20170224对候选子句进行排序
                    //候选子句文字策略
                    //0:归结次数>稳定度 1:无(由原始顺序为准) 2:稳定度>归结次数
                    findOnlyOut = true;
                    UINT16 sumDrop = 0;
                    vector<Literal*> leftLiter; //20170305 用于保存剩余文字，以便选择最优的文字放入三角形中
                    for (UINT16 m = 0; m < givenCla->uLitNum; m++) {
                        if (givenCla->LitPtr[m]->isDrop)//互补文字
                        {
                            sumDrop++;
                            vOutTri.push_back(givenCla->LitPtr[m]);
                            //cout<<"三角形下方文字"<<"[C" + to_string(candClaP->LitPtr[m]->Row()) + "_" + to_string(candClaP->LitPtr[m]->Col()) + "]"<<(candClaP->LitPtr[m]->subTerm->ToStringBind())<<endl;
                            continue;
                        }
                        //20170305 idea 有效解决冗余:优先选择与单元子句一样的文字(合一)，另外考虑徐老师讲的同一子句可以合并的文字一定要合并
                        leftLiter.push_back(givenCla->LitPtr[m]);
                    }
                    if (!leftLiter.empty()) {
                        //查找是否有可以和单元子句合一相同的文字
                        vector<Term*> chgTempT; //储存替换变元项
                        for (UINT16 m = 0; m < leftLiter.size(); m++) {
                            bool findRes = false;
                            for (auto& clap : vOnlyOutTri) {
                                if (leftLiter[m]->isEqPred(clap) && unify.LitMgu(leftLiter[m], clap, chgTempT)) {
                                    swap(leftLiter[m], leftLiter[0]);
                                    unify.ClearVarBind(chgTempT);
                                    findRes = true;
                                    break;
                                } else
                                    unify.ClearVarBind(chgTempT);
                            }
                            if (findRes)
                                break;
                        }
                        unify.ClearVarBind(chgTempT);
                        for (UINT16 m = 0; m < leftLiter.size(); m++) {
                            if (!leftLiter[m]->isDel && findOnlyOut) {//被选归结子句剩下的文字,其中第一个放在对角线上,其余放入R中
                                lastTrip = leftLiter[m]; //记录三角形对角线演绎最后一个文字，下一次演绎需要放入三角形中
                                vOutTri.push_back(leftLiter[m]);
                                vOnlyOutTri.push_back(leftLiter[m]);
                                findOnlyOut = false;
                            } else if (!leftLiter[m]->isDel &&!findOnlyOut) {//放入R中
                                count++;
                                vOutTri.push_back(leftLiter[m]);
                                vNewR.push_back(leftLiter[m]);
                                //20170216
                                if (first_RLit) {
                                    firstR = vOnlyOutTri.back();
                                    first_RLit = false;
                                }

                            }
                        }
                    }
                    //判断是否全部放入三角形中
                    if (findOnlyOut && count == 0 && vNewR.size() == 0) {
                        newCla = nullptr;
                        givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                        candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                        if(!StrategyParam::orForCompition && (StrategyParam::problemDiv == 0))
                            cout << "得出结论:不可满足" << endl;
                        return true;
                    }
                    //20171229 此处若有剩余文字时,需要跳过该候选子句；需要做如下处理: 1.将该子句与后面的子句交换
//#define cprover_fast4
#ifndef cprover_fast4
                    if (1229) {
                        if ((vNewR.size() > 0) && genUintRFirst) {//需要回退
                            //清除变元合一绑定
                            if (!unify.vVarBindT.empty())
                                unify.ClearVarBind(unify.vVarBindT);
                            //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                            if (!vOnlyOutDect.empty()) {
                                UINT32 dlen = vOnlyOutDect.size();
                                for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                    vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                }
                            }
                            //还原vOutTri  vOnlyOutTri
                            vOnlyOutTri.pop_back();
                            int incOutTriSize = vOutTri.size() - lastvOutTriSize;
                            for (UINT16 m = 0; m < incOutTriSize; m++) {
                                vOutTri.pop_back();
                            }
                            //还原归结式
                            int incRSize = vNewR.size() - lastRSize;
                            for (UINT16 m = 0; m < incRSize; m++) {
                                count--;
                                vNewR.pop_back();
                            }
                            continue;
                        }
                        //20180914
                        else if ((vNewR.size() > 1) && (!genUintRFirst) && genUintRSecond) {//需要回退
                            //清除变元合一绑定
                            if (!unify.vVarBindT.empty())
                                unify.ClearVarBind(unify.vVarBindT);
                            //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                            if (!vOnlyOutDect.empty()) {
                                UINT32 dlen = vOnlyOutDect.size();
                                for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                    vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                }
                            }
                            //还原vOutTri  vOnlyOutTri
                            vOnlyOutTri.pop_back();
                            int incOutTriSize = vOutTri.size() - lastvOutTriSize;
                            for (UINT16 m = 0; m < incOutTriSize; m++) {
                                vOutTri.pop_back();
                            }
                            //还原归结式
                            int incRSize = vNewR.size() - lastRSize;
                            for (UINT16 m = 0; m < incRSize; m++) {
                                count--;
                                vNewR.pop_back();
                            }
                            continue;
                        }
                    }
#endif
                    //20171229 end
                    //三角形上方不剩文字，即归结出来单文字if (find(vOnlyOutTri.begin(), vOnlyOutTri.end(),givenCla->LitPtr[ActLitInd]) == vOnlyOutTri.end())
                    //中间归结式生成 static bool midR;//中间归结式生成 //true 中间归结式生成 false 中间归结式不生成
                    if (count == 0 && vNewR.size() == 0 && !findOnlyOut && StrategyParam::midR) {
                        //新建子句,生成单文字子句,最后加入到单文字子句列表中
//                        if ((newClaId == 1017) &&(vOnlyOutTri.back()->claPtr->uClaId == 11)) {
//                            cout << "debug" << endl;
//                        }
                        Literal* tempptr = vOnlyOutTri.back();
                        bool flagT = true;
                        //如果时纯文字或单文字已存在
                        if ((tempptr->getPairPredLst()->empty()) || (find(vOnlyOutTriCmp.begin(), vOnlyOutTriCmp.end(), tempptr) != vOnlyOutTriCmp.end())) {
                            flagT = false;
                        }
                        if (flagT) {
                            vector<Literal*> vInsertNewR;
                            vInsertNewR.reserve(6);
                            vInsertNewR.push_back(vOnlyOutTri.back());
                            newCla = nullptr;
                            if (!vInsertNewR.empty()) {
                                //查看是否冗余20170101
                                newCla = new Clause(newClaId, 0);
                                newCla->isAxtom = true;
                                size_t uRsize = vInsertNewR.size();
                                //文字排序
//                                if (uRsize > 1) {
//                                    if (StrategyParam::unitSortRule == 3) {
//                                        stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmpGoalDeepth);
//                                    } else
//                                        stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmp);
//                                }
                                if (uRsize > 1)
                                    stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmp);
                                newCla->LitPtr = new Literal*[uRsize];
                                for (UINT16 i = 0; i < vInsertNewR.size(); ++i) {
                                    Term* litSubT = unify.GetNewTerm(vInsertNewR[i]->subTerm, newCla); //参数1：文字谓词项，参数2：新子句指针
                                    if (TNegEqn == GetCodeProp(litSubT->iTermCode)
                                            && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {
                                        /*
                                        delete(litSubT);*/--uRsize;
                                        //delete(newCla->LitPtr[]);
                                        continue;
                                    }
                                    if (newCla->uFuncDepth < litSubT->uLevel)newCla->uFuncDepth = litSubT->uLevel;
                                    newCla->uVarCount += litSubT->uVarCount;
                                    //添加到文字		
                                    newCla->LitPtr[newCla->uLitNum] = new Literal(litSubT, EncodeLitCode(newClaId, newCla->uLitNum + 1), newCla, nullptr);
                                    newCla->LitPtr[newCla->uLitNum]->parentLitPtr = vInsertNewR[i]; //母式文字，有R产生
                                    //newCla->LitPtr[newCla->uLitNum]->goalDeepth = vInsertNewR[i]->goalDeepth;
                                    //20171020 计算演绎深度
                                    if (newCla ->deduceDeepth < (vInsertNewR[i]->claPtr->deduceDeepth + 1)) {
                                        newCla ->deduceDeepth = vInsertNewR[i]->claPtr->deduceDeepth + 1;
                                    }
                                    if (vInsertNewR[i]->claPtr->isAxtom && newCla->isAxtom)
                                        newCla->isAxtom = true;
                                    else
                                        newCla->isAxtom = false;
                                    if (hasUnifGoalLit(fol, newCla->LitPtr[newCla->uLitNum])) {
                                        newCla->LitPtr[newCla->uLitNum]->goalDeepth = 1;
                                        if (newCla->goaldeepth > 1)
                                            newCla->goaldeepth = 1;
                                    } else {
                                        newCla->LitPtr[newCla->uLitNum]->goalDeepth = vInsertNewR[i]->goalDeepth;
                                        if (newCla->goaldeepth > vInsertNewR[i]->goalDeepth)
                                            newCla->goaldeepth = vInsertNewR[i]->goalDeepth;
                                    }
                                    //cout<<to_string(newCla->uClaId)  + "]" <<"[" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitRow()) + "_" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitCol()) + "]" << newCla->LitPtr[newCla->uLitNum]->subTerm->ToString()<<endl;  
                                    ++(newCla->uLitNum);
                                }

                                //cout<<newCla->LitPtr[0]->subTerm->ToStringBind()<<endl;
                                if (uRsize != 0) {
                                    //20171020 对子句的含等词的文字进行项序处理
                                    if (StrategyParam::termRewriting != 2) {
                                        newCla->directEqn();
                                    }
                                    //20171026 增加归结式复杂度判断
                                    if (newCla->compFuncDeepthCla() > StrategyParam::funcFixDeepth) {
                                        //cout<<"R无效"<<endl;
                                        newCla->DelLits(false);
                                        delete(newCla);
                                        //清除变元合一绑定
                                        if (!unify.vVarBindT.empty())
                                            unify.ClearVarBind(unify.vVarBindT);
                                        //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                        if (!vOnlyOutDect.empty()) {
                                            UINT32 dlen = vOnlyOutDect.size();
                                            for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                                vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                            }
                                        }
                                        //还原vOutTri  vOnlyOutTri
                                        vOnlyOutTri.pop_back();
                                        vOutTri.pop_back();
                                        for (UINT16 m = 0; m < sumDrop; m++) {
                                            vOutTri.pop_back();
                                        }
                                        vInsertNewR.clear();
                                        vector<Literal*>().swap(vInsertNewR);
                                        //20170220 增加候选子句冗余权重
                                        //givenCla->reduntTimes++;
                                        continue;
                                    }
                                    //true 中间归结式冗余判断 false 中间归结式冗余不判断
                                    //                                    if (claHasPureLit(fol, newCla)) {
                                    //                                        //cout<<"R无效"<<endl;
                                    //                                        newCla->DelLits(false);
                                    //                                        delete(newCla);
                                    //                                        //清除变元合一绑定
                                    //                                        if (!unify.vVarBindT.empty())
                                    //                                            unify.ClearVarBind(unify.vVarBindT);
                                    //                                        //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                    //                                        if (!vOnlyOutDect.empty()) {
                                    //                                            UINT32 dlen = vOnlyOutDect.size();
                                    //                                            for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                    //                                                vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                    //                                            }
                                    //                                        }
                                    //                                        //还原vOutTri  vOnlyOutTri
                                    //                                        vOnlyOutTri.pop_back();
                                    //                                        vOutTri.pop_back();
                                    //                                        for (UINT16 m = 0; m < sumDrop; m++) {
                                    //                                            vOutTri.pop_back();
                                    //                                        }
                                    //                                        vInsertNewR.clear();
                                    //                                        vector<Literal*>().swap(vInsertNewR);
                                    //                                        //20170220 增加候选子句冗余权重
                                    //                                        givenCla->reduntTimes++;
                                    //                                        continue;
                                    //                                    }
                                    if (StrategyParam::midRJudge) {
                                        vector<UINT32>invaildLitId; //
                                        invaildLitId.reserve(6);
                                        string rundMsg; //冗余信息
                                        Subsumption subsump; //(MOSTRIGHT)
                                        //参数1 被测的子句指针 参数2 整形数组 参数3 字符串 记录冗余信息
                                        bool isRundacyR = false;
                                        isRundacyR = subsump.GenCla(fol, newCla, invaildLitId, rundMsg);
                                        if (isRundacyR) {
                                            //cout<<"R无效"<<endl;
                                            newCla->DelLits(false);
                                            delete(newCla);
                                            //清除变元合一绑定
                                            if (!unify.vVarBindT.empty())
                                                unify.ClearVarBind(unify.vVarBindT);
                                            //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                            if (!vOnlyOutDect.empty()) {
                                                UINT32 dlen = vOnlyOutDect.size();
                                                for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                                    vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                                }
                                            }
                                            //还原vOutTri  vOnlyOutTri
                                            vOnlyOutTri.pop_back();
                                            vOutTri.pop_back();
                                            for (UINT16 m = 0; m < sumDrop; m++) {
                                                vOutTri.pop_back();
                                            }
                                            vInsertNewR.clear();
                                            vector<Literal*>().swap(vInsertNewR);
                                            //20170220 增加候选子句冗余权重
                                            givenCla->reduntTimes++;
                                            continue;
                                        } else {
                                            if (!StrategyParam::orForCompition)
                                                FileOp::CreateRunInfoFile(FileOp::runFileId);
                                            chgCla.push_back(newCla);
                                            //20170602 新增输出小三角形路径
                                            if (StrategyParam::divideTri) {
                                                if (!StrategyParam::orForCompition)
                                                    *FileOp::ofRealInfoOut << "从编号为" + to_string(candClaP->uClaId) + "子句开始构建三角形" << endl;
                                                if (candClaP->uLitNum == 1) {
                                                    candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                                                }
                                                givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                                                //输出演绎路径					 
                                                PrintTriPath();
                                                //20171020 对子句的含等词的文字进行项序处理
                                                //                                                if (StrategyParam::termRewriting != 2) {
                                                //                                                    newCla->directEqn();
                                                //                                                }
                                                if (!StrategyParam::orForCompition) {
                                                    FileOp::WriteR(newCla);
                                                    *FileOp::ofRealInfoOut << "|[Y]" << endl;
                                                }
                                                //20171024 将中间归结式加入子句集,可以用来减少冗余子句的生成
                                                fol.InsertCla(newCla);
                                                fol.setCla.insert(newCla);
                                                midGenR = true;
                                                if (/*StrategyParam::orForCompition*/true) {
                                                    if (FileOp::runMode != 0)
                                                        newCla->addRForCompetiton();
                                                    string rStr = "";
                                                    newCla->toString(rStr);
                                                    string outClauses = PrintCompetitionOut(newClaId);
                                                    int begPos = rStr.find_first_of("[") + 1;
                                                    int endPos = rStr.find_first_of("]");
                                                    string rId = rStr.substr(begPos, endPos - begPos);
                                                    string rContext = rStr.substr(rStr.find_first_of("]") + 1);
                                                    string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n" + "   inference(scs_inference,[]," + "[" + outClauses +"]" + ")).";
                                                     
                                                    *FileOp::ofOutput << out << endl;
                                                }
                                                //20171024
                                            }
                                        }
                                    } else {
                                        if (!StrategyParam::orForCompition)
                                            FileOp::CreateRunInfoFile(FileOp::runFileId);
                                        chgCla.push_back(newCla);
                                        //20170602 新增输出小三角形路径
                                        if (StrategyParam::divideTri) {
                                            if (!StrategyParam::orForCompition)
                                                *FileOp::ofRealInfoOut << "从编号为" + to_string(candClaP->uClaId) + "子句开始构建三角形" << endl;
                                            if (candClaP->uLitNum == 1) {
                                                candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                                            }
                                            givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                                            //输出演绎路径					 
                                            PrintTriPath();
                                            if (!StrategyParam::orForCompition) {
                                                FileOp::WriteR(newCla);
                                                *FileOp::ofRealInfoOut << "|[Y]" << endl;
                                            }
                                            //20171024 将中间归结式加入子句集,可以用来减少冗余子句的生成
                                            fol.InsertCla(newCla);
                                            fol.setCla.insert(newCla);
                                            midGenR = true;
                                            if (/*StrategyParam::orForCompition*/true) {
                                                if (FileOp::runMode != 0)
                                                    newCla->addRForCompetiton();
                                                
                                                string rStr = "";
                                                newCla->toString(rStr);
                                                string outClauses = PrintCompetitionOut(newClaId);
                                                int begPos = rStr.find_first_of("[") + 1;
                                                int endPos = rStr.find_first_of("]");
                                                string rId = rStr.substr(begPos, endPos - begPos);
                                                string rContext = rStr.substr(rStr.find_first_of("]") + 1);
                                                string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n" + "   inference(scs_inference,[]," + "[" + outClauses +"]" + ")).";
               
                                                *FileOp::ofOutput << out << endl;
                                            }
                                            //20171024
                                        }
                                    }
                                    fol.initGenerateClaAttr(newCla);
                                }
                                else {
                                    newCla->DelLits(false);
                                    delete(newCla);
                                }                                
                                //string str;
                                //newCla->toString(str);
                                //cout<<"插入中间演绎的单文字子句:" <<str << endl;
                                
                                newClaId++;
                            }
                            vInsertNewR.clear();
                            vector<Literal*>().swap(vInsertNewR);
                        } else {//说明该路径不应该搜索
                            //清除变元合一绑定
                            if (!unify.vVarBindT.empty())
                                unify.ClearVarBind(unify.vVarBindT);
                            //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                            if (!vOnlyOutDect.empty()) {
                                UINT32 dlen = vOnlyOutDect.size();
                                for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                    vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                }
                            }
                            //还原vOutTri  vOnlyOutTri
                            vOnlyOutTri.pop_back();
                            vOutTri.pop_back();
                            for (UINT16 m = 0; m < sumDrop; m++) {
                                vOutTri.pop_back();
                            }
                            givenCla->reduntTimes++;
                        }
                    }//20170816 保存生成的非单元子句
                    else if (count > 0 && vNewR.size() > 0 && !findOnlyOut && StrategyParam::midR) {
                        
                        //新建子句,生成单文字子句,最后加入到单文字子句列表中
                        //Literal* tempptr = vOnlyOutTri.back(); 
                        bool flagT = true;
                        vector<Literal*> vInsertNewR;
                        vInsertNewR.reserve(6);
                        vInsertNewR.push_back(vOnlyOutTri.back());
                        
                        for (int i = 0; i < vNewR.size(); i++) {
                            vInsertNewR.push_back(vNewR[i]);
                        }
                        
                        // 此处判断是否有冗余的R 文字,即由该子句对角线文字没有互补对的文字存在与矛盾体中
                        vector<Clause*> discardClas;
                        discardClas.reserve(8);
                        if(StrategyParam::litRundent){
//                            if((newClaId == 1017) &&(vOnlyOutTri.back()->claPtr->uClaId == 11)){
//                                cout<<"debug"<<endl;
//                            }
                            for(int i=0; i < vInsertNewR.size(); ++i){
                                UINT16 countPair = 0;
                                Clause *findCla = vInsertNewR[i]->claPtr;
                                if(findCla == vOutTri.back()->claPtr)
                                    continue;
                                for(int j = 0; j < findCla->uLitNum; ++j){
                                    if(find(vOnlyOutTri.begin(),vOnlyOutTri.end(),findCla->LitPtr[j]) != vOnlyOutTri.end()){//找到对角线文字,查看互补对
                                        for(int k=0; k < vOutTri.size(); ++k){
//                                             if ((findCla->uClaId == 32)&&(vOutTri[k]->claPtr->uClaId == 11)) {
//                                                cout << vOutTri[k]->subTerm->ToStringBind() <<endl;
//                                                cout << findCla->LitPtr[j]->subTerm->ToStringBind() <<endl; 
//                                            }
                                            if((findCla->LitPtr[j]->isPairPred(vOutTri[k])) && (unify.CheckPairEqn(findCla->LitPtr[j]->subTerm, vOutTri[k]->subTerm))){
                                                ++countPair;
                                                break;
                                            }
                                        }                                       
                                    }
                                }
                                if(countPair == 0){//表示对角线没有互补对
                                    if(find(discardClas.begin(),discardClas.end(),vInsertNewR[i]->claPtr) == discardClas.end()){
                                        discardClas.push_back(vInsertNewR[i]->claPtr);
                                    }
                                    swap(vInsertNewR[i],vInsertNewR[vInsertNewR.size()-1]);
                                    vInsertNewR.pop_back();
                                    --i;
                                }
                            }
                        }                                           
                        //end
                        
                        for (size_t rInd = 0; rInd < vInsertNewR.size() - 1; ++rInd) {
                            Literal* rA = vInsertNewR[rInd];
                            for (size_t rIndB = rInd + 1; rIndB < vInsertNewR.size();) {
                                Literal* rB = vInsertNewR[rIndB];
                                if (rA->subTerm->iTermCode == rB->subTerm->iTermCode && unify.CheckEqn(rA->subTerm, rB->subTerm)) {
                                    swap(vInsertNewR[rIndB], vInsertNewR[vInsertNewR.size() - 1]);
                                    vInsertNewR.pop_back();
                                } else
                                    ++rIndB;
                            }
                        }
                        if (vInsertNewR.size() > StrategyParam::midR)
                            flagT = false;
                        if (flagT) {
                            newCla = nullptr;
                            if (!vInsertNewR.empty()) {
                                //查看是否冗余20170101
                                newCla = new Clause(newClaId, 0);
                                newCla->isAxtom = true;
                                size_t uRsize = vInsertNewR.size();
                                //文字排序
//                                if (uRsize > 1)
//                                    if (StrategyParam::unitSortRule == 3) {
//                                        stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmpGoalDeepth);
//                                    } else
//                                        stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmp);
                                if (uRsize > 1)
                                    stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmp);
                                newCla->LitPtr = new Literal*[uRsize];
                                for (UINT16 i = 0; i < vInsertNewR.size(); ++i) {
                                    Term* litSubT = unify.GetNewTerm(vInsertNewR[i]->subTerm, newCla); //参数1：文字谓词项，参数2：新子句指针
                                    if (TNegEqn == GetCodeProp(litSubT->iTermCode)
                                            && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {
                                        /*
                                        delete(litSubT);*/--uRsize;
                                        //delete(newCla->LitPtr[]);
                                        continue;
                                    }
                                    if (newCla->uFuncDepth < litSubT->uLevel)newCla->uFuncDepth = litSubT->uLevel;
                                    newCla->uVarCount += litSubT->uVarCount;
                                    //添加到文字		
                                    newCla->LitPtr[newCla->uLitNum] = new Literal(litSubT, EncodeLitCode(newClaId, newCla->uLitNum + 1), newCla, nullptr);
                                    newCla->LitPtr[newCla->uLitNum]->parentLitPtr = vInsertNewR[i]; //母式文字，有R产生
                                    //newCla->LitPtr[newCla->uLitNum]->goalDeepth = vInsertNewR[i]->goalDeepth;
                                    //20171020 计算演绎深度
                                    if (newCla ->deduceDeepth < (vInsertNewR[i]->claPtr->deduceDeepth + 1)) {
                                        newCla ->deduceDeepth = vInsertNewR[i]->claPtr->deduceDeepth + 1;
                                    }
                                    if (vInsertNewR[i]->claPtr->isAxtom && newCla->isAxtom)
                                        newCla->isAxtom = true;
                                    else
                                        newCla->isAxtom = false;
                                    if (hasUnifGoalLit(fol, newCla->LitPtr[newCla->uLitNum])) {
                                        newCla->LitPtr[newCla->uLitNum]->goalDeepth = 1;
                                        if (newCla->goaldeepth > 1)
                                            newCla->goaldeepth = 1;
                                    } else {
                                        newCla->LitPtr[newCla->uLitNum]->goalDeepth = vInsertNewR[i]->goalDeepth;
                                        if (newCla->goaldeepth > vInsertNewR[i]->goalDeepth)
                                            newCla->goaldeepth = vInsertNewR[i]->goalDeepth;
                                    }
                                    //cout<<to_string(newCla->uClaId)  + "]" <<"[" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitRow()) + "_" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitCol()) + "]" << newCla->LitPtr[newCla->uLitNum]->subTerm->ToString()<<endl;  
                                    ++(newCla->uLitNum);
                                }
                                
                                //cout<<newCla->LitPtr[0]->subTerm->ToStringBind()<<endl;
                                if (uRsize != 0) {
                                    //20171020 对子句的含等词的文字进行项序处理
                                    if (StrategyParam::termRewriting != 2) {
                                        newCla->directEqn();
                                    }
                                    //20171026 增加归结式复杂度判断
                                    if (newCla->compFuncDeepthCla() > StrategyParam::funcFixDeepth) {
                                        //cout<<"R无效"<<endl;
                                        newCla->DelLits(false);
                                        delete(newCla);
                                        //20170818 需要还原vNewR 此次演绎改变了什么 
                                        //清除变元合一绑定
                                        if (!unify.vVarBindT.empty())
                                            unify.ClearVarBind(unify.vVarBindT);
                                        //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                        if (!vOnlyOutDect.empty()) {
                                            UINT32 dlen = vOnlyOutDect.size();
                                            for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                                vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                            }
                                        }
                                        //还原vOutTri  vOnlyOutTri
                                        vOnlyOutTri.pop_back();
                                        int incOutTriSize = vOutTri.size() - lastvOutTriSize;
                                        for (UINT16 m = 0; m < incOutTriSize; m++) {
                                            vOutTri.pop_back();
                                        }
                                        //还原归结式
                                        int incRSize = vNewR.size() - lastRSize;
                                        for (UINT16 m = 0; m < incRSize; m++) {
                                            count--;
                                            vNewR.pop_back();
                                        }
                                        vInsertNewR.clear();
                                        vector<Literal*>().swap(vInsertNewR);
                                        //20170220 增加候选子句冗余权重
                                        //candClaP->reduntTimes++;
                                        continue;
                                    }
                                    //true 中间归结式冗余判断 false 中间归结式冗余不判断
                                    //                                    if (claHasPureLit(fol, newCla)) {
                                    //                                        //cout<<"R无效"<<endl;
                                    //                                        newCla->DelLits(false);
                                    //                                        delete(newCla);
                                    //                                        //20170818 需要还原vNewR 此次演绎改变了什么 
                                    //                                        //清除变元合一绑定
                                    //                                        if (!unify.vVarBindT.empty())
                                    //                                            unify.ClearVarBind(unify.vVarBindT);
                                    //                                        //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                    //                                        if (!vOnlyOutDect.empty()) {
                                    //                                            UINT32 dlen = vOnlyOutDect.size();
                                    //                                            for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                    //                                                vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                    //                                            }
                                    //                                        }
                                    //                                        //还原vOutTri  vOnlyOutTri
                                    //                                        vOnlyOutTri.pop_back();
                                    //                                        int incOutTriSize = vOutTri.size() - lastvOutTriSize;
                                    //                                        for (UINT16 m = 0; m < incOutTriSize; m++) {
                                    //                                            vOutTri.pop_back();
                                    //                                        }
                                    //                                        //还原归结式
                                    //                                        int incRSize = vNewR.size() - lastRSize;
                                    //                                        for (UINT16 m = 0; m < incRSize; m++) {
                                    //                                            count--;
                                    //                                            vNewR.pop_back();
                                    //                                        }
                                    //                                        vInsertNewR.clear();
                                    //                                        vector<Literal*>().swap(vInsertNewR);
                                    //                                        //20170220 增加候选子句冗余权重
                                    //                                        candClaP->reduntTimes++;
                                    //                                        continue;
                                    //                                    }
                                    if (StrategyParam::midRJudge) {
                                        vector<UINT32>invaildLitId; //
                                        invaildLitId.reserve(6);
                                        string rundMsg; //冗余信息
                                        Subsumption subsump; //(MOSTRIGHT)
                                        //参数1 被测的子句指针 参数2 整形数组 参数3 字符串 记录冗余信息
                                        bool isRundacyR = false;
                                        isRundacyR = subsump.GenCla(fol, newCla, invaildLitId, rundMsg);
                                        if (isRundacyR) {
                                            //cout<<"R无效"<<endl;
                                            newCla->DelLits(false);
                                            delete(newCla);
                                            //20170818 需要还原vNewR 此次演绎改变了什么 
                                            //清除变元合一绑定
                                            if (!unify.vVarBindT.empty())
                                                unify.ClearVarBind(unify.vVarBindT);
                                            //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                            if (!vOnlyOutDect.empty()) {
                                                UINT32 dlen = vOnlyOutDect.size();
                                                for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                                    vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                                }
                                            }
                                            //还原vOutTri  vOnlyOutTri
                                            vOnlyOutTri.pop_back();
                                            int incOutTriSize = vOutTri.size() - lastvOutTriSize;
                                            for (UINT16 m = 0; m < incOutTriSize; m++) {
                                                vOutTri.pop_back();
                                            }
                                            //还原归结式
                                            int incRSize = vNewR.size() - lastRSize;
                                            for (UINT16 m = 0; m < incRSize; m++) {
                                                count--;
                                                vNewR.pop_back();
                                            }
                                            vInsertNewR.clear();
                                            vector<Literal*>().swap(vInsertNewR);
                                            //20170220 增加候选子句冗余权重
                                            candClaP->reduntTimes++;
                                            continue;
                                        } else {
                                            if (!StrategyParam::orForCompition)
                                                FileOp::CreateRunInfoFile(FileOp::runFileId);
                                            chgCla.push_back(newCla);
                                            //20170602 新增输出小三角形路径
                                            if (StrategyParam::divideTri) {
                                                if (!StrategyParam::orForCompition)
                                                    *FileOp::ofRealInfoOut << "从编号为" + to_string(candClaP->uClaId) + "子句开始构建三角形" << endl;
                                                if (candClaP->uLitNum == 1) {
                                                    candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                                                }
                                                givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                                                //输出演绎路径
                                                if(discardClas.empty() == false){
                                                    for(int aa= 0; aa<discardClas.size(); ++aa){
                                                        discardClas[aa]->isSDeduct = false;
                                                    }
                                                }
                                                PrintTriPath();
                                                if(discardClas.empty() == false){
                                                    for(int aa= 0; aa<discardClas.size(); ++aa){
                                                        discardClas[aa]->isSDeduct = true;
                                                    }
                                                }
                                                vector<Clause*>().swap(discardClas);
                                                if (!StrategyParam::orForCompition) {
                                                    FileOp::WriteR(newCla);
                                                    *FileOp::ofRealInfoOut << "|[Y]" << endl;
                                                }
                                                //20171024 将中间归结式加入子句集,可以用来减少冗余子句的生成
                                                fol.InsertCla(newCla);
                                                fol.setCla.insert(newCla);
                                                midGenR = true;
                                                if (/*StrategyParam::orForCompition*/true) {
                                                    if (FileOp::runMode != 0)
                                                        newCla->addRForCompetiton();
                                                    
                                                    string rStr = "";
                                                    newCla->toString(rStr);
                                                    string outClauses = PrintCompetitionOut(newClaId);
                                                    int begPos = rStr.find_first_of("[") + 1;
                                                    int endPos = rStr.find_first_of("]");
                                                    string rId = rStr.substr(begPos, endPos - begPos);
                                                    string rContext = rStr.substr(rStr.find_first_of("]") + 1);
                                                    string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n" + "   inference(scs_inference,[]," + "[" + outClauses +"]" + ")).";
                                                    *FileOp::ofOutput << out << endl;
                                                }
                                                //20171024
                                            }
                                        }
                                    } else {
                                        if (!StrategyParam::orForCompition)
                                            FileOp::CreateRunInfoFile(FileOp::runFileId);
                                        chgCla.push_back(newCla);
                                        //20170602 新增输出小三角形路径
                                        if (StrategyParam::divideTri) {
                                            if (!StrategyParam::orForCompition)
                                                *FileOp::ofRealInfoOut << "从编号为" + to_string(candClaP->uClaId) + "子句开始构建三角形" << endl;
                                            if (candClaP->uLitNum == 1) {
                                                candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                                            }
                                            givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                                            //输出演绎路径	
                                            if(discardClas.empty() == false){
                                                    for(int aa= 0; aa<discardClas.size(); ++aa){
                                                        discardClas[aa]->isSDeduct = false;
                                                    }
                                                }
                                            PrintTriPath();
                                            if(discardClas.empty() == false){
                                                    for(int aa= 0; aa<discardClas.size(); ++aa){
                                                        discardClas[aa]->isSDeduct = true;
                                                    }
                                                }
                                            vector<Clause*>().swap(discardClas);
                                            //20171020 对子句的含等词的文字进行项序处理
                                            //                                            if (StrategyParam::termRewriting != 2) {
                                            //                                                newCla->directEqn();
                                            //                                            }
                                            if (!StrategyParam::orForCompition) {
                                                FileOp::WriteR(newCla);
                                                *FileOp::ofRealInfoOut << "|[Y]" << endl;
                                            }
                                            //20171024 将中间归结式加入子句集,可以用来减少冗余子句的生成
                                            fol.InsertCla(newCla);
                                            fol.setCla.insert(newCla);
                                            midGenR = true;
                                            if (/*StrategyParam::orForCompition*/true) {
                                                if (FileOp::runMode != 0)
                                                    newCla->addRForCompetiton();
                                                
                                                string rStr = "";
                                                newCla->toString(rStr);
                                                string outClauses = PrintCompetitionOut(newClaId);
                                                int begPos = rStr.find_first_of("[") + 1;
                                                int endPos = rStr.find_first_of("]");
                                                string rId = rStr.substr(begPos, endPos - begPos);
                                                string rContext = rStr.substr(rStr.find_first_of("]") + 1);
                                                string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n" + "   inference(scs_inference,[]," + "[" + outClauses +"]" + ")).";
                                                *FileOp::ofOutput << out << endl;
                                            }
                                            //20171024
                                        }
                                    }
                                    fol.initGenerateClaAttr(newCla);
                                }
                                else {
                                    newCla->DelLits(false);
                                    delete(newCla);                                   
                                }
                                //string str;
                                //newCla->toString(str);
                                //cout<<"插入中间演绎的单文字子句:" <<str << endl;
                                
                                newClaId++;
                            }

                        }
                        vInsertNewR.clear();
                        vector<Literal*>().swap(vInsertNewR);
                    }
                    //20170215 保存每次子句演绎的互补对单元子句
                    claPair.clear();
                    claPair.push_back(QLit);
                    //20170215需要为参与本单元的三角形演绎单元子句设置权重
                    if (!vOnlyDectNum.empty()) {
                        for (UINT8 nm = 0; nm < vOnlyDectNum.size(); nm++) {
                            claPair.push_back(vOnlyDectNum[nm]);
                            if (vOnlyDectNum[nm]->claPtr->uLitNum == 1)
                                vOnlyDectNum[nm]->claPtr->adeductNum++; //单元子句权重加1
                        }
                    }
                    if (candClaP->uLitNum == 1) {
                        candClaP->adeductNum++; //主动归结次数+1
                        candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                    }
                    
                    QLit->sDuct = QLit->sDuct + 10; //候选文字权重加一 须重新文字排序 first-> QLit->sDuct++
                    if(QLit->sDuct == 10000)
                        QLit->sDuct = 0;
                    //2020:repaired
                    if(givenCla->isAxtom == false)
                        givenCla->pdeductNum += 1/*resRandomNumber(total_Loop)*/; //total_Loop 怎么得到
                    else{
                        if(StrategyParam::equalityUsedFrq == 0)
                            givenCla->pdeductNum += 3/*resRandomNumber(total_Loop) + total_Loop/2*/; //total_Loop 怎么得到
                        else if(StrategyParam::equalityUsedFrq == 1)
                            givenCla->pdeductNum += resRandomNumber(total_Loop) + total_Loop/50; //total_Loop 怎么得到
                        else if(StrategyParam::equalityUsedFrq == 2)
                            givenCla->pdeductNum += resRandomNumber(total_Loop); //total_Loop 怎么得到
                    }
                    givenCla->isSDeduct = true; //在构建三角形过程中参与归结

                    //20171022 拷贝已使用的子句,以达到重复使用子句的目的
                    //如果演绎的不是上次拷贝的子句,则需要将其删除
                    //                    if((lastDeductCla != nullptr) &&(givenCla != lastDeductCla)){//说明拷贝的子句没有用上
                    //                        //在演绎子句列表中清除lastDeductCla
                    //                        vector<Clause*>::iterator delInd = find(candidateClaSet.begin(),candidateClaSet.end(),lastDeductCla);
                    //                        candidateClaSet.erase(delInd);
                    //                        //在拷贝的子句列表中清除lastDeductCla
                    //                        lastDeductCla->DelLits(false);
                    //                        delete(lastDeductCla);
                    //                    }
                    //if (StrategyParam::useCpUintCla) {//拷贝单元子句
                    if (1) {//拷贝单元子句
                        if ((candClaP->uLitNum == 1) && candClaP->HasTermBind()) {
                            //拷贝新的子句来使用
                            unify.copyUintCla(fol, candClaP, newClaId);
                            hasCpUintClaId.insert(candClaP->uClaId);
                        }
                        if (vOnlyDectNum.size() > 0) {
                            for (UINT16 s = 0; s < vOnlyDectNum.size(); ++s) {
                                if ((vOnlyDectNum[s]->claPtr->uLitNum == 1) && vOnlyDectNum[s]->claPtr->HasTermBind()) {
                                    //拷贝新的子句来使用
                                    unify.copyUintCla(fol, vOnlyDectNum[s]->claPtr, newClaId);
                                    hasCpUintClaId.insert(vOnlyDectNum[s]->claPtr->uClaId);
                                }
                            }
                        }
                    }
                    
                    //if (midGenR && (StrategyParam::claReUseTimes != 0) && (givenCla->HasTermBind())) {
                    if (midGenR && (givenCla->HasTermBind())&& (givenCla->isAxtom == false)) {//2020:repaired
                        Clause* cpClaTmp = nullptr;
                        if (givenCla->topCopyCla == nullptr)
                            cpClaTmp = givenCla;
                        else
                            cpClaTmp = givenCla->topCopyCla;
                        //if (copyClaCopyTimes(cpClaTmp) < StrategyParam::claReUseTimes) {
                        if (1) {
                            Clause* cyCla = copyCla(fol, cpClaTmp, newClaId, candLitP, QLit);
                            cyCla->topCopyCla = cpClaTmp;
                            lastDeductCla = cyCla;
                            //插入到演绎子句列表中
                            vector<Clause*>::iterator insertInd = find(candidateClaSet.begin(), candidateClaSet.end(), givenCla);
                            candidateClaSet.insert(insertInd + 1, cyCla);
                            midGenR = false;
                        }

                    }
                    
                    //20171022 end

                    setRedundClaId.insert(givenCla->uClaId); //用于本次三角形不在使用已经归结过的子句
                    if (RULEOK == unifResult) {
                        isDeduct = true;
                        isGloDeduct = true;
                    }
                    //20170828 增加R文字数限制,即当vNewR.size() 大于文字数限制 则要退出
                    //20170215 子句全部落入三角形下方 需要结束三角形演绎 并判断是否能得出结论
                    if (findOnlyOut && (vNewR.size() != 0))
                        break;
                    //20170828 增加R文字数限制,即当vNewR.size() 大于文字数限制 则要退出
                    if ((vNewR.size() >= StrategyParam::R_MAX_NUM) || ((StrategyParam::R_INIT_MAX_NUM == givenCla->uLitNum)&&(givenCla->uLitNum > 10))) {
                        break;
                    }
                    //end
                    //0:深度优先 1:宽深结合 2:宽度优先
                    if (StrategyParam::widthDeep == 0) {
                        break;
                    } else if (StrategyParam::widthDeep == 1) {
                        break;
                    } else
                        break;
                } else {
                    //清除合一规则检查失败时，被置为isSdeduct为true的子句
                    if (!vOnlyOutDect.empty()) {
                        UINT32 dlen = vOnlyOutDect.size();
                        for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                            vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                        }
                    }
                }
            }//20170210 候选子句外循环  找互补对外循环体
            //20171026 应该要遍历所有的文字
            if (isDeduct)
                break;
            else{//20190516 add
                if((FileOp::strategyMode == 3) || (FileOp::strategyMode == 4)){
                    ;
                }
                else{
                    ActLitInd = ActLitInd + givenCla->uLitNum;
                }
                QLit->sDuct++; //候选文字权重加一 须重新文字排序 first-> QLit->sDuct++
                if(QLit->sDuct == 1000)//2020:repaired
                    QLit->sDuct = 0;
            }
            //只找到一次候选文字，不管有没有都退出，后期可以把深入做大
            //break;
        }//20170210 主动子句外循环
        //20170828 增加R文字数限制,即当vNewR.size() 大于文字数限制 则要退出
        if ((vNewR.size() >= StrategyParam::R_MAX_NUM) || (isDeduct && (StrategyParam::R_INIT_MAX_NUM == candClaP->uLitNum)&&(candClaP->uLitNum > 10))) {
            break;
        }
        //end
        //继续下一个合一配对
        ResClaID.insert(givenCla->uClaId);
        ResClaPtr.push_back(givenCla);
//#define cprover_fast5
#ifndef cprover_fast5
        if (20180101) {
            if (((cDeepth == (candidateClaSet.size() - 1)) || (cDeepth == StrategyParam::deductDeep)) && oneRunFlag) {
                cDeepth = -1;
                oneRunFlag = false;
                genUintRFirst = false;
            }
            //20180914
            else if (((cDeepth == (candidateClaSet.size() - 1)) || (cDeepth == StrategyParam::deductDeep)) && !oneRunFlag && !genUintRFirst && twoRunFlag) {
                cDeepth = -1;
                twoRunFlag = false;
                genUintRSecond = false;
            }
        }
#endif
        cDeepth++;
        //为-1时，系统自动处理；为大于0时设置值有效；
        if (cDeepth == StrategyParam::deductDeep) {
            if (isGloDeduct) {
                break;
            } else {
                allNoPair = true;
                return 222;
            }
        }
        if (cDeepth == candidateClaSet.size()) {
            if (isGloDeduct) {
                break;
            } else {//所有的单元子句都找不到互补对有效子句
                allNoPair = true;
                return 22;
            }
        }
        //控制三角形演绎子句的总长度
//        if (setRedundClaId.size() > 160) {
//            if (isGloDeduct) {
//                break;
//            } else {//所有的单元子句都找不到互补对有效子句
//                allNoPair = true;
//                return 22;
//            }
//        }
        clock_t end = clock();
        double time_s = (double) (end - StrategyParam::start) / (double) CLOCKS_PER_SEC;
        if (time_s > StrategyParam::firstTimeLimit * 60)//200   3  1分钟 15  5分钟   30  15分钟  end:300
        {
            if (isGloDeduct) {
                break;
            } else {//所有的单元子句都找不到互补对有效子句
                allNoPair = true;
                return 22;
            }
        }
        //考虑情况：配对子句已全部落入三角形内，但是之前有R剩余，此时停止构建三角形
        //       if ((findOnlyOut && (vNewR.size() != 0)) || cDeepth == vOnlyOutTri.size()) {
        //           if (findOnlyOut && (vNewR.size() != 0)) {
        //                //cout << "找到所有互补对单R不为空" << endl;
        //                if (!claPair.empty()) {
        //                    UINT32 lengthA = -2;
        //                    vector <Literal*>::iterator ie;
        //                    for (UINT8 lab = 0; lab < claPair.size(); lab++) {
        //                        ie = find(vOnlyOutTri.begin(), vOnlyOutTri.end(), claPair[lab]);
        //                        if (distance(vOnlyOutTri.begin(), ie) > lengthA)
        //                            lengthA = distance(vOnlyOutTri.begin(), ie);
        //                    }
        //                    ie = find(vOnlyOutTri.begin(), vOnlyOutTri.end(), firstR);
        //                    if (distance(vOnlyOutTri.begin(), ie) > lengthA) {
        //                        newCla = nullptr;
        //                        cout << "得出结论:不可满足" << endl;
        //                        return true;
        //                    }
        //                }
        //            }
        //             break;
        //        }
        givenCla = candidateClaSet[cDeepth];
        //string str;
        //givenCla->toString(str);
        //cout << str << endl;
    }//20170210 构建三角形结束外循环
    //生成新子句(R) 并输出演绎结果中
    newCla = nullptr;
    //20170215 用于判断最后的收尾归结子句全部落在三角形内的情况 但R不为空 
    assert(!(findOnlyOut && (vNewR.size() == 0)));
    if (!findOnlyOut) //20170215 end
    {
        vNewR.push_back(vOnlyOutTri.back());
        //vOnlyOutTri.pop_back();
    }
    //20170214 若所有的主对角线文字都没有找到满足条件互补的子句，则不输出R
    if ((vNewR.size() == 1)&&(chgCla.size() == 0)&&(find(vOnlyOutTriCmp.begin(), vOnlyOutTriCmp.end(), vNewR[0]) != vOnlyOutTriCmp.end())) {
        allNoPair = true;
        return 22;
    }
    
      // 此处判断是否有冗余的R 文字,即由该子句对角线文字没有互补对的文字存在与矛盾体中
    if (StrategyParam::litRundent) {
        for (int i = 0; i < vNewR.size(); ++i) {
            UINT16 countPair = 0;
            Clause *findCla = vNewR[i]->claPtr;
            if(findCla == vOutTri.back()->claPtr)
                continue;
            for (int j = 0; j < findCla->uLitNum; ++j) {
                if (find(vOnlyOutTri.begin(), vOnlyOutTri.end(), findCla->LitPtr[j]) != vOnlyOutTri.end()) {//找到对角线文字,查看互补对
                    for (int k = 0; k < vOutTri.size(); ++k) {
                        if ((findCla->LitPtr[j]->isPairPred(vOutTri[k])) && (unify.CheckPairEqn(findCla->LitPtr[j]->subTerm, vOutTri[k]->subTerm))) {
                            ++countPair;
                            break;
                        }
                    }
                }
            }
            if (countPair == 0) {//表示对角线没有互补对
                vNewR[i]->claPtr->isSDeduct = false;
                swap(vNewR[i], vNewR[vNewR.size() - 1]);
                vNewR.pop_back();
                --i;
                
            }
        }
    }
    
    //检查R是否有相同的合并
    for (size_t rInd = 0; rInd < vNewR.size() - 1; ++rInd) {
        Literal* rA = vNewR[rInd];
        for (size_t rIndB = rInd + 1; rIndB < vNewR.size();) {
            Literal* rB = vNewR[rIndB];
            if (rA->subTerm->iTermCode == rB->subTerm->iTermCode && unify.CheckEqn(rA->subTerm, rB->subTerm)) {
                swap(vNewR[rIndB], vNewR[vNewR.size() - 1]);
                vNewR.pop_back();
            } else
                ++rIndB;
        }
    }

  
    
    assert(vNewR.size() != 0); //20170211 考虑是否此处有R为0
    newCla = new Clause(newClaId, 0);
    newCla->isAxtom = true;
    size_t uRsize = vNewR.size();
    //文字排序
    if (uRsize > 1)
        stable_sort(vNewR.begin(), vNewR.end(), SortRule::LitCmp);
    newCla->LitPtr = new Literal*[uRsize];
    for (UINT16 i = 0; i < vNewR.size(); ++i) {
        Term* litSubT = unify.GetNewTerm(vNewR[i]->subTerm, newCla); //参数1：文字谓词项，参数2：新子句指针
//        if (TNegEqn == GetCodeProp(litSubT->iTermCode)
//                && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {//出现有剩余文字仍为不可满足的清空，需要考虑这种清空 20170108
//            /*
//            delete(litSubT);*/
//            --uRsize;
//            //delete(newCla->LitPtr[]);
//            continue;
//        }
        if (newCla->uFuncDepth < litSubT->uLevel)newCla->uFuncDepth = litSubT->uLevel;
        newCla->uVarCount += litSubT->uVarCount;
        //添加到文字		
        newCla->LitPtr[newCla->uLitNum] = new Literal(litSubT, EncodeLitCode(newClaId, newCla->uLitNum + 1), newCla, nullptr);
        newCla->LitPtr[newCla->uLitNum]->parentLitPtr = vNewR[i]; //母式文字，有R产生
        //newCla->LitPtr[newCla->uLitNum]->goalDeepth = vNewR[i]->goalDeepth;
        //20171020 计算演绎深度
        if (newCla ->deduceDeepth < (vNewR[i]->claPtr->deduceDeepth + 1)) {
            newCla ->deduceDeepth = vNewR[i]->claPtr->deduceDeepth + 1;
        }
        if (vNewR[i]->claPtr->isAxtom && newCla->isAxtom)
            newCla->isAxtom = true;
        else
            newCla->isAxtom = false;
        if (hasUnifGoalLit(fol, newCla->LitPtr[newCla->uLitNum])) {
            newCla->LitPtr[newCla->uLitNum]->goalDeepth = 1;
            if (newCla->goaldeepth > 1)
                newCla->goaldeepth = 1;
        } else {
            newCla->LitPtr[newCla->uLitNum]->goalDeepth = vNewR[i]->goalDeepth;
            if (newCla->goaldeepth > vNewR[i]->goalDeepth)
                newCla->goaldeepth = vNewR[i]->goalDeepth;
        }
        ++(newCla->uLitNum);
    }
    fol.initGenerateClaAttr(newCla);
    newClaId++;
    //string str;
    //newCla->toString(str);
    //cout<<"R:" << str << endl;
    return 221;
}

//CSE 1.4 20210416
UINT8 TriAlg::GenerateTriByRecodePathLRCancelLimit(Formula& fol, vector<Clause*>& candidateClaSet, UINT32 &newClaId, BACKTYPE _backType, vector<Clause*> &chgCla, UINT16& loop_Num) {
    if (_backType == NOBACK)//清除变量
    {
        //assert(!(givenCla == nullptr));
        //初始化		
        PreResLit = nullptr; //上轮找到的合一文字
        setRedundClaId.clear(); //记录参与演绎的子句
        setRealRedundClaId.clear(); //记录冗余的子句
        hasCpUintClaId.clear();
        setRealRedundClaId.reserve(8);
        vector<Literal*>().swap(vNewR);
        vNewR.reserve(8);
        vector<UINT16>().swap(vComparePos);
        ResClaID.clear();
        //ResClaID.insert(givenCla->uClaId); //记录第一个归结子句编号
        vector<Clause*>().swap(ResClaPtr);
        //ResClaPtr.push_back(givenCla); //记录第一个归结子句指针
        BackPathClear(); //重要：清除路径以及上轮归结中变元的绑定 
        //stackVarChg.reserve(16);
        //noCmpCla.clear();
        stackVarChg.reserve(100);
    }
    bool creatFlag = true;
    Clause* givenCla = nullptr;
    RESULT unifResult; //是否合一
    bool isDeduct = false; //是否发生过归结
    bool isGloDeduct = false; //是否发生过归结
    Clause* candClaP = nullptr; // 被动归结子句（候选子句）
    Literal* candLitP = nullptr; //被动归结文字（候选文字）
    vector<Literal*>* vCandLit = &vOnlyOutTri; //取相同文字的map集合
    INT32 cDeepth = 0; //演绎深度
    UINT8 count = 0;
    Literal * lastTrip = nullptr;
    bool findOnlyOut = false; //用于控制子句的文字三角形摆放
    bool first_RLit = true; //记录第一次剩余的R
    Clause* lastDeductCla = nullptr;
    Clause* first_Given = candidateClaSet[0];
    bool midGenR = false; //用于限制只有在生成了中间归结式的过程中拷贝演绎子句,否则R文字数会很大
    bool oneRunFlag = true;
    bool twoRunFlag = true;
    bool genUintRFirst = true;
    bool genUintRSecond = true;
    UINT32 lastMainDiagonalInd = 0;
    //20170821 针对构建三角形过程中出现的冗余子句,其权重修改为加随机数,这样可以使得下次做的三角形不一样.
    if (StrategyParam::useRandrom)
        srand((unsigned int) time(nullptr));
    while (1) {
        if(1){//just for timeout
            clock_t end_control = clock();
            double time_control = (double) (end_control - start) / (double) CLOCKS_PER_SEC;
            StrategyParam::timeLimit = StrategyParam::firstTimeLimit;
            if (time_control > StrategyParam::timeLimit * 60)//200   3  1分钟 15  5分钟   30  15分钟  end:300
            {
                if (isGloDeduct) {
                    break;
                } else {//所有的单元子句都找不到互补对有效子句
                    allNoPair = true;
                    return 22;
                }
            }
        }
        givenCla = candidateClaSet[cDeepth];
        if(givenCla->clast != CopyTemp)
            stable_sort(givenCla->LitPtr, givenCla->LitPtr + givenCla->uLitNum, SortRule::ActlitCmp);
        UINT16 ActLitInd = 0;
        //        string str;
        //        givenCla->toString(str);
        //        cout <<"起步子句:" <<str << endl;
        for (; ActLitInd < givenCla->uLitNum; ++ActLitInd) {//ActLitInd = ActLitInd + givenCla->uLitNum
            isDeduct = false;
            Literal* QLit = givenCla->LitPtr[ActLitInd];
            //根据文字互补谓词项对应的互补文字得到候选文字
            //            vCandLitAll = QLit->getPairPredLst();
            //            //提取单元子句序列
            //            if(vCandLitAll->size() == 0)
            //                continue;
            //            for(UINT32 i=0; i< vCandLitAll->size(); ++i){
            //                if(vCandLitAll->at(i)->claPtr->uLitNum == 1){
            //                    vCandLit.push_back(vCandLitAll->at(i));
            //                }
            //            }
            //            stable_sort(vCandLit.begin(), vCandLit.end(), SortRule::claSingCmp);

            //stable_sort(vCandLit->begin(), vCandLit->end(), SortRule::PoslitCmpLarge); //被动文字按子句个数进行排序  此处考虑用随机策略
            //此处考虑加大宽度，即同一子句可以左多个合一子句
            if (setRedundClaId.find(givenCla->uClaId) != setRedundClaId.end())
                continue;
            UINT32 pasLitInd = 0;
            setRealRedundClaId.clear(); //演绎文字出现冗余
            for (; pasLitInd < UINT32(vCandLit->size()); ++pasLitInd)//依次找到
            {
                //cout<<"找归结子句:"<<pasLitInd<<endl;
                if((givenCla->clast == CopyTemp) && (lastMainDiagonalInd <= pasLitInd)){
                    continue;
                }
                lastMainDiagonalInd = pasLitInd;
                candLitP = vCandLit->at(pasLitInd); //候选被动归结文字
                if (1) {//用于重复使用子句无法跳出的情况
                    clock_t end_out = clock();
                    double time_out = (double) (end_out - start) / (double) CLOCKS_PER_SEC;
                    if (time_out > StrategyParam::timeLimit * 60)//200   3  1分钟 15  5分钟   30  15分钟  end:300
                    {
                        break;
                    }
                }
                if (QLit->isPairPred(candLitP) == false) {
                    continue;
                }
                candClaP = candLitP->claPtr; // 被动归结子句（候选子句）
                //20171022 增加拷贝子句的演绎限制
                if ((candClaP->uLitNum == 1) &&(hasCpUintClaId.find(candClaP->uClaId) != hasCpUintClaId.end())) {//单元子句已经被拷贝了
                    continue;
                }
                if ((givenCla->clast == CopyTemp) &&(givenCla->copyFrom == candLitP) && unify.CheckEqnR(givenCla->copyTo->subTerm, QLit->subTerm)) {//已拷贝的子句
                    continue;
                }

                //20170827 限制子句中文字数个数
                //                if (vNewR.size() + givenCla->uLitNum + candClaP->uLitNum - 2 > StrategyParam::R_MAX_NUM)
                //                    continue;

                //不允许跟上一轮母式进行归结  
                //                if ((candLitP->parentLitPtr && candLitP->parentLitPtr->claPtr == givenCla) || (QLit->parentLitPtr && QLit->parentLitPtr->claPtr == candClaP)){
                //                    continue;
                //                }
                //核心：合一算法，参数1：主动归结文字指针；参数2：被动归结文字指针
                //20180909 增加目标子句的归结 放松限制
                INT32 tempRsize = StrategyParam::R_MAX_NUM;
                if (candLitP->claPtr->isGoal && (StrategyParam::R_MAX_NUM < candLitP->claPtr->uLitNum)) {
                    StrategyParam::R_MAX_NUM = vNewR.size() + candLitP->claPtr->uLitNum;
                }
                unifResult = unify.IssynLRLimit(QLit, candLitP); //是否找到合一文字
                StrategyParam::R_MAX_NUM = tempRsize;
                //20170909 将限制还原
                //20170215  根据归结子句的互补文字，当有剩余文字既要放入主对角线，又要放入R中 此时的顺序如何选择 这里和文字的稳定排序有关
                if (unifResult == RULEOK) {
                    //                    if(creatFlag){
                    //                        FileOp::CreateRunInfoFile(candidateClaSet[cDeepth]->uClaId / 25);
                    //                        creatFlag = false;
                    //                    }
                    //20170210 stackVarChg用于保存构建三角形过程中所有的替换项
                    //20170818 记录演绎前的归结式文字个数
                    int lastRSize = vNewR.size();
                    int lastvOutTriSize = vOutTri.size();
                    stackVarChg.push_back(unify.vVarBindT); //添加到替换堆栈中	 //版本2需要重点考虑	 
                    //20170224对候选子句进行排序
                    //候选子句文字策略
                    //0:归结次数>稳定度 1:无(由原始顺序为准) 2:稳定度>归结次数
                    findOnlyOut = true;
                    UINT16 sumDrop = 0;
                    vector<Literal*> leftLiter; //20170305 用于保存剩余文字，以便选择最优的文字放入三角形中
                    for (UINT16 m = 0; m < givenCla->uLitNum; m++) {
                        if (givenCla->LitPtr[m]->isDrop)//互补文字
                        {
                            sumDrop++;
                            vOutTri.push_back(givenCla->LitPtr[m]);
                            //cout<<"三角形下方文字"<<"[C" + to_string(candClaP->LitPtr[m]->Row()) + "_" + to_string(candClaP->LitPtr[m]->Col()) + "]"<<(candClaP->LitPtr[m]->subTerm->ToStringBind())<<endl;
                            continue;
                        }
                        //20170305 idea 有效解决冗余:优先选择与单元子句一样的文字(合一)，另外考虑徐老师讲的同一子句可以合并的文字一定要合并
                        leftLiter.push_back(givenCla->LitPtr[m]);
                    }
                    if (!leftLiter.empty()) {
                        //查找是否有可以和单元子句合一相同的文字
                        vector<Term*> chgTempT; //储存替换变元项
                        for (UINT16 m = 0; m < leftLiter.size(); m++) {
                            bool findRes = false;
                            for (auto& clap : vOnlyOutTri) {
                                if (leftLiter[m]->isEqPred(clap) && unify.LitMgu(leftLiter[m], clap, chgTempT)) {
                                    swap(leftLiter[m], leftLiter[0]);
                                    unify.ClearVarBind(chgTempT);
                                    findRes = true;
                                    break;
                                } else
                                    unify.ClearVarBind(chgTempT);
                            }
                            if (findRes)
                                break;
                        }
                        unify.ClearVarBind(chgTempT);
                        for (UINT16 m = 0; m < leftLiter.size(); m++) {
                            if (!leftLiter[m]->isDel && findOnlyOut) {//被选归结子句剩下的文字,其中第一个放在对角线上,其余放入R中
                                lastTrip = leftLiter[m]; //记录三角形对角线演绎最后一个文字，下一次演绎需要放入三角形中
                                vOutTri.push_back(leftLiter[m]);
                                vOnlyOutTri.push_back(leftLiter[m]);
                                findOnlyOut = false;
                            } else if (!leftLiter[m]->isDel &&!findOnlyOut) {//放入R中
                                count++;
                                vOutTri.push_back(leftLiter[m]);
                                vNewR.push_back(leftLiter[m]);
                                //20170216
                                if (first_RLit) {
                                    firstR = vOnlyOutTri.back();
                                    first_RLit = false;
                                }

                            }
                        }
                    }
                    //判断是否全部放入三角形中
                    if (findOnlyOut && count == 0 && vNewR.size() == 0) {
                        newCla = nullptr;
                        givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                        candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                        if(!StrategyParam::orForCompition && (StrategyParam::problemDiv == 0))
                            cout << "得出结论:不可满足" << endl;
                        return true;
                    }
                    //20171229 此处若有剩余文字时,需要跳过该候选子句；需要做如下处理: 1.将该子句与后面的子句交换
//#define cprover_fast4
#ifndef cprover_fast4
                    if (1229) {
                        if ((vNewR.size() > 0) && genUintRFirst) {//需要回退
                            //清除变元合一绑定
                            if (!unify.vVarBindT.empty())
                                unify.ClearVarBind(unify.vVarBindT);
                            //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                            if (!vOnlyOutDect.empty()) {
                                UINT32 dlen = vOnlyOutDect.size();
                                for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                    vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                }
                            }
                            //还原vOutTri  vOnlyOutTri
                            vOnlyOutTri.pop_back();
                            int incOutTriSize = vOutTri.size() - lastvOutTriSize;
                            for (UINT16 m = 0; m < incOutTriSize; m++) {
                                vOutTri.pop_back();
                            }
                            //还原归结式
                            int incRSize = vNewR.size() - lastRSize;
                            for (UINT16 m = 0; m < incRSize; m++) {
                                count--;
                                vNewR.pop_back();
                            }
                            continue;
                        }
                        //20180914
                        else if ((vNewR.size() > 1) && (!genUintRFirst) && genUintRSecond) {//需要回退
                            //清除变元合一绑定
                            if (!unify.vVarBindT.empty())
                                unify.ClearVarBind(unify.vVarBindT);
                            //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                            if (!vOnlyOutDect.empty()) {
                                UINT32 dlen = vOnlyOutDect.size();
                                for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                    vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                }
                            }
                            //还原vOutTri  vOnlyOutTri
                            vOnlyOutTri.pop_back();
                            int incOutTriSize = vOutTri.size() - lastvOutTriSize;
                            for (UINT16 m = 0; m < incOutTriSize; m++) {
                                vOutTri.pop_back();
                            }
                            //还原归结式
                            int incRSize = vNewR.size() - lastRSize;
                            for (UINT16 m = 0; m < incRSize; m++) {
                                count--;
                                vNewR.pop_back();
                            }
                            continue;
                        }
                    }
#endif
                    //20171229 end
                    //三角形上方不剩文字，即归结出来单文字if (find(vOnlyOutTri.begin(), vOnlyOutTri.end(),givenCla->LitPtr[ActLitInd]) == vOnlyOutTri.end())
                    //中间归结式生成 static bool midR;//中间归结式生成 //true 中间归结式生成 false 中间归结式不生成
                    if (count == 0 && vNewR.size() == 0 && !findOnlyOut && StrategyParam::midR) {
                        //新建子句,生成单文字子句,最后加入到单文字子句列表中
//                        if ((newClaId == 1017) &&(vOnlyOutTri.back()->claPtr->uClaId == 11)) {
//                            cout << "debug" << endl;
//                        }
                        Literal* tempptr = vOnlyOutTri.back();
                        bool flagT = true;
                        //如果时纯文字或单文字已存在
                        if ((tempptr->getPairPredLst()->empty()) || (find(vOnlyOutTriCmp.begin(), vOnlyOutTriCmp.end(), tempptr) != vOnlyOutTriCmp.end())) {
                            flagT = false;
                        }
                        if (flagT) {
                            vector<Literal*> vInsertNewR;
                            vInsertNewR.reserve(6);
                            vInsertNewR.push_back(vOnlyOutTri.back());
                            newCla = nullptr;
                            if (!vInsertNewR.empty()) {
                                //查看是否冗余20170101
                                newCla = new Clause(newClaId, 0);
                                newCla->isAxtom = true;
                                size_t uRsize = vInsertNewR.size();
                                //文字排序
//                                if (uRsize > 1) {
//                                    if (StrategyParam::unitSortRule == 3) {
//                                        stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmpGoalDeepth);
//                                    } else
//                                        stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmp);
//                                }
                                if (uRsize > 1)
                                    stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmp);
                                newCla->LitPtr = new Literal*[uRsize];
                                for (UINT16 i = 0; i < vInsertNewR.size(); ++i) {
                                    Term* litSubT = unify.GetNewTerm(vInsertNewR[i]->subTerm, newCla); //参数1：文字谓词项，参数2：新子句指针
                                    if (TNegEqn == GetCodeProp(litSubT->iTermCode)
                                            && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {
                                        /*
                                        delete(litSubT);*/--uRsize;
                                        //delete(newCla->LitPtr[]);
                                        continue;
                                    }
                                    if (newCla->uFuncDepth < litSubT->uLevel)newCla->uFuncDepth = litSubT->uLevel;
                                    newCla->uVarCount += litSubT->uVarCount;
                                    //添加到文字		
                                    newCla->LitPtr[newCla->uLitNum] = new Literal(litSubT, EncodeLitCode(newClaId, newCla->uLitNum + 1), newCla, nullptr);
                                    newCla->LitPtr[newCla->uLitNum]->parentLitPtr = vInsertNewR[i]; //母式文字，有R产生
                                    //newCla->LitPtr[newCla->uLitNum]->goalDeepth = vInsertNewR[i]->goalDeepth;
                                    //20171020 计算演绎深度
                                    if (newCla ->deduceDeepth < (vInsertNewR[i]->claPtr->deduceDeepth + 1)) {
                                        newCla ->deduceDeepth = vInsertNewR[i]->claPtr->deduceDeepth + 1;
                                    }
                                    if (vInsertNewR[i]->claPtr->isAxtom && newCla->isAxtom)
                                        newCla->isAxtom = true;
                                    else
                                        newCla->isAxtom = false;
                                    if (hasUnifGoalLit(fol, newCla->LitPtr[newCla->uLitNum])) {
                                        newCla->LitPtr[newCla->uLitNum]->goalDeepth = 1;
                                        if (newCla->goaldeepth > 1)
                                            newCla->goaldeepth = 1;
                                    } else {
                                        newCla->LitPtr[newCla->uLitNum]->goalDeepth = vInsertNewR[i]->goalDeepth;
                                        if (newCla->goaldeepth > vInsertNewR[i]->goalDeepth)
                                            newCla->goaldeepth = vInsertNewR[i]->goalDeepth;
                                    }
                                    //cout<<to_string(newCla->uClaId)  + "]" <<"[" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitRow()) + "_" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitCol()) + "]" << newCla->LitPtr[newCla->uLitNum]->subTerm->ToString()<<endl;  
                                    ++(newCla->uLitNum);
                                }
                                //20171020 对子句的含等词的文字进行项序处理
                                if (StrategyParam::termRewriting != 2) {
                                    newCla->directEqn();
                                }
                                //cout<<newCla->LitPtr[0]->subTerm->ToStringBind()<<endl;
                                if (uRsize != 0) {
                                    //20171026 增加归结式复杂度判断
                                    if (newCla->compFuncDeepthCla() > StrategyParam::funcFixDeepth) {
                                        //cout<<"R无效"<<endl;
                                        newCla->DelLits(false);
                                        delete(newCla);
                                        //清除变元合一绑定
                                        if (!unify.vVarBindT.empty())
                                            unify.ClearVarBind(unify.vVarBindT);
                                        //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                        if (!vOnlyOutDect.empty()) {
                                            UINT32 dlen = vOnlyOutDect.size();
                                            for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                                vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                            }
                                        }
                                        //还原vOutTri  vOnlyOutTri
                                        vOnlyOutTri.pop_back();
                                        vOutTri.pop_back();
                                        for (UINT16 m = 0; m < sumDrop; m++) {
                                            vOutTri.pop_back();
                                        }
                                        vInsertNewR.clear();
                                        vector<Literal*>().swap(vInsertNewR);
                                        //20170220 增加候选子句冗余权重
                                        //givenCla->reduntTimes++;
                                        continue;
                                    }
                                    //true 中间归结式冗余判断 false 中间归结式冗余不判断
                                    //                                    if (claHasPureLit(fol, newCla)) {
                                    //                                        //cout<<"R无效"<<endl;
                                    //                                        newCla->DelLits(false);
                                    //                                        delete(newCla);
                                    //                                        //清除变元合一绑定
                                    //                                        if (!unify.vVarBindT.empty())
                                    //                                            unify.ClearVarBind(unify.vVarBindT);
                                    //                                        //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                    //                                        if (!vOnlyOutDect.empty()) {
                                    //                                            UINT32 dlen = vOnlyOutDect.size();
                                    //                                            for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                    //                                                vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                    //                                            }
                                    //                                        }
                                    //                                        //还原vOutTri  vOnlyOutTri
                                    //                                        vOnlyOutTri.pop_back();
                                    //                                        vOutTri.pop_back();
                                    //                                        for (UINT16 m = 0; m < sumDrop; m++) {
                                    //                                            vOutTri.pop_back();
                                    //                                        }
                                    //                                        vInsertNewR.clear();
                                    //                                        vector<Literal*>().swap(vInsertNewR);
                                    //                                        //20170220 增加候选子句冗余权重
                                    //                                        givenCla->reduntTimes++;
                                    //                                        continue;
                                    //                                    }
                                    if (StrategyParam::midRJudge) {
                                        vector<UINT32>invaildLitId; //
                                        invaildLitId.reserve(6);
                                        string rundMsg; //冗余信息
                                        Subsumption subsump; //(MOSTRIGHT)
                                        //参数1 被测的子句指针 参数2 整形数组 参数3 字符串 记录冗余信息
                                        bool isRundacyR = false;
                                        isRundacyR = subsump.GenCla(fol, newCla, invaildLitId, rundMsg);
                                        if (isRundacyR) {
                                            //cout<<"R无效"<<endl;
                                            newCla->DelLits(false);
                                            delete(newCla);
                                            //清除变元合一绑定
                                            if (!unify.vVarBindT.empty())
                                                unify.ClearVarBind(unify.vVarBindT);
                                            //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                            if (!vOnlyOutDect.empty()) {
                                                UINT32 dlen = vOnlyOutDect.size();
                                                for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                                    vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                                }
                                            }
                                            //还原vOutTri  vOnlyOutTri
                                            vOnlyOutTri.pop_back();
                                            vOutTri.pop_back();
                                            for (UINT16 m = 0; m < sumDrop; m++) {
                                                vOutTri.pop_back();
                                            }
                                            vInsertNewR.clear();
                                            vector<Literal*>().swap(vInsertNewR);
                                            //20170220 增加候选子句冗余权重
                                            givenCla->reduntTimes++;
                                            continue;
                                        } else {
                                            FileOp::CreateRunInfoFile(FileOp::runFileId);
                                            chgCla.push_back(newCla);
                                            //20170602 新增输出小三角形路径
                                            if (StrategyParam::divideTri) {
                                                *FileOp::ofRealInfoOut << "从编号为" + to_string(candClaP->uClaId) + "子句开始构建三角形" << endl;
                                                if (candClaP->uLitNum == 1) {
                                                    candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                                                }
                                                givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                                                //输出演绎路径					 
                                                PrintTriPath();
                                                //20171020 对子句的含等词的文字进行项序处理
                                                //                                                if (StrategyParam::termRewriting != 2) {
                                                //                                                    newCla->directEqn();
                                                //                                                }
                                                FileOp::WriteR(newCla);
                                                *FileOp::ofRealInfoOut << "|[Y]" << endl;
                                                //20171024 将中间归结式加入子句集,可以用来减少冗余子句的生成
                                                fol.InsertCla(newCla);
                                                fol.setCla.insert(newCla);
                                                midGenR = true;
                                                if (/*StrategyParam::orForCompition*/true) {
                                                    newCla->addRForCompetiton();
                                                    
                                                    string rStr = "";
                                                    newCla->toString(rStr);
//                                                    string outClauses = PrintCompetitionOut(newClaId);
//                                                    int begPos = rStr.find_first_of("[") + 1;
//                                                    int endPos = rStr.find_first_of("]");
//                                                    string rId = rStr.substr(begPos, endPos - begPos);
//                                                    string rContext = rStr.substr(rStr.find_first_of("]") + 1);
//                                                    string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n" + "   inference(scs_inference,[]," + "[" + outClauses +"]" + ")).";
//                                                    
                                                    string cnf_str = newCla->ToStringWithSemantics(rStr);
                                                    string ruleClas = PrintCompetitionOut_eFormat(newClaId);
                                                    size_t pos = cnf_str.find_last_of(')');
                                                    string cnf_str_sub = cnf_str.substr(0, pos);
                                                    string out = cnf_str_sub + ", inference(scs_inference,[],[" + ruleClas + "]" + ")).";
                                                    //cout << out << endl;
                                                    *FileOp::ofOutput << out << endl;
                                                }
                                                //20171024
                                            }
                                        }
                                    } else {
                                        FileOp::CreateRunInfoFile(FileOp::runFileId);
                                        chgCla.push_back(newCla);
                                        //20170602 新增输出小三角形路径
                                        if (StrategyParam::divideTri) {
                                            *FileOp::ofRealInfoOut << "从编号为" + to_string(candClaP->uClaId) + "子句开始构建三角形" << endl;
                                            if (candClaP->uLitNum == 1) {
                                                candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                                            }
                                            givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                                            //输出演绎路径					 
                                            PrintTriPath();

                                            FileOp::WriteR(newCla);
                                            *FileOp::ofRealInfoOut << "|[Y]" << endl;
                                            //20171024 将中间归结式加入子句集,可以用来减少冗余子句的生成
                                            fol.InsertCla(newCla);
                                            fol.setCla.insert(newCla);
                                            midGenR = true;
                                            if (/*StrategyParam::orForCompition*/true) {
                                               newCla->addRForCompetiton();
                                                    
                                                    string rStr = "";
                                                    newCla->toString(rStr);
//                                                    string outClauses = PrintCompetitionOut(newClaId);
//                                                    int begPos = rStr.find_first_of("[") + 1;
//                                                    int endPos = rStr.find_first_of("]");
//                                                    string rId = rStr.substr(begPos, endPos - begPos);
//                                                    string rContext = rStr.substr(rStr.find_first_of("]") + 1);
//                                                    string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n" + "   inference(scs_inference,[]," + "[" + outClauses +"]" + ")).";
//                                                    
                                                    string cnf_str = newCla->ToStringWithSemantics(rStr);
                                                    string ruleClas = PrintCompetitionOut_eFormat(newClaId);
                                                    size_t pos = cnf_str.find_last_of(')');
                                                    string cnf_str_sub = cnf_str.substr(0, pos);
                                                    string out = cnf_str_sub + ", inference(scs_inference,[],[" + ruleClas + "]" + ")).";
                                                    
                                                    *FileOp::ofOutput << out << endl;
                                            }
                                            //20171024
                                        }
                                    }
                                }
                                //string str;
                                //newCla->toString(str);
                                //cout<<"插入中间演绎的单文字子句:" <<str << endl;
                                fol.initGenerateClaAttr(newCla);
                                newClaId++;
                            }
                            vInsertNewR.clear();
                            vector<Literal*>().swap(vInsertNewR);
                        } else {//说明该路径不应该搜索
                            //清除变元合一绑定
                            if (!unify.vVarBindT.empty())
                                unify.ClearVarBind(unify.vVarBindT);
                            //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                            if (!vOnlyOutDect.empty()) {
                                UINT32 dlen = vOnlyOutDect.size();
                                for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                    vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                }
                            }
                            //还原vOutTri  vOnlyOutTri
                            vOnlyOutTri.pop_back();
                            vOutTri.pop_back();
                            for (UINT16 m = 0; m < sumDrop; m++) {
                                vOutTri.pop_back();
                            }
                            givenCla->reduntTimes++;
                        }
                    }//20170816 保存生成的非单元子句
                    else if (count > 0 && vNewR.size() > 0 && !findOnlyOut && StrategyParam::midR) {
                        //新建子句,生成单文字子句,最后加入到单文字子句列表中
                        //Literal* tempptr = vOnlyOutTri.back(); 
                        bool flagT = true;
                        vector<Literal*> vInsertNewR;
                        vInsertNewR.reserve(6);
                        vInsertNewR.push_back(vOnlyOutTri.back());
                        
                        for (int i = 0; i < vNewR.size(); i++) {
                            vInsertNewR.push_back(vNewR[i]);
                        }
                        
                        // 此处判断是否有冗余的R 文字,即由该子句对角线文字没有互补对的文字存在与矛盾体中
                        vector<Clause*> discardClas;
                        discardClas.reserve(8);
                        if(StrategyParam::litRundent){
//                            if((newClaId == 1017) &&(vOnlyOutTri.back()->claPtr->uClaId == 11)){
//                                cout<<"debug"<<endl;
//                            }
                            for(int i=0; i < vInsertNewR.size(); ++i){
                                UINT16 countPair = 0;
                                Clause *findCla = vInsertNewR[i]->claPtr;
                                if(findCla == vOutTri.back()->claPtr)
                                    continue;
                                for(int j = 0; j < findCla->uLitNum; ++j){
                                    if(find(vOnlyOutTri.begin(),vOnlyOutTri.end(),findCla->LitPtr[j]) != vOnlyOutTri.end()){//找到对角线文字,查看互补对
                                        for(int k=0; k < vOutTri.size(); ++k){
//                                             if ((findCla->uClaId == 32)&&(vOutTri[k]->claPtr->uClaId == 11)) {
//                                                cout << vOutTri[k]->subTerm->ToStringBind() <<endl;
//                                                cout << findCla->LitPtr[j]->subTerm->ToStringBind() <<endl; 
//                                            }
                                            if((findCla->LitPtr[j]->isPairPred(vOutTri[k])) && (unify.CheckPairEqn(findCla->LitPtr[j]->subTerm, vOutTri[k]->subTerm))){
                                                ++countPair;
                                                break;
                                            }
                                        }                                       
                                    }
                                }
                                if(countPair == 0){//表示对角线没有互补对
                                    if(find(discardClas.begin(),discardClas.end(),vInsertNewR[i]->claPtr) == discardClas.end()){
                                        discardClas.push_back(vInsertNewR[i]->claPtr);
                                    }
                                    swap(vInsertNewR[i],vInsertNewR[vInsertNewR.size()-1]);
                                    vInsertNewR.pop_back();
                                    --i;
                                }
                            }
                        }                                           
                        //end
                        
                        for (size_t rInd = 0; rInd < vInsertNewR.size() - 1; ++rInd) {
                            Literal* rA = vInsertNewR[rInd];
                            for (size_t rIndB = rInd + 1; rIndB < vInsertNewR.size();) {
                                Literal* rB = vInsertNewR[rIndB];
                                if (rA->subTerm->iTermCode == rB->subTerm->iTermCode && unify.CheckEqn(rA->subTerm, rB->subTerm)) {
                                    swap(vInsertNewR[rIndB], vInsertNewR[vInsertNewR.size() - 1]);
                                    vInsertNewR.pop_back();
                                } else
                                    ++rIndB;
                            }
                        }
                        if (vInsertNewR.size() > StrategyParam::midR)
                            flagT = false;
                        if (flagT) {
                            newCla = nullptr;
                            if (!vInsertNewR.empty()) {
                                //查看是否冗余20170101
                                newCla = new Clause(newClaId, 0);
                                newCla->isAxtom = true;
                                size_t uRsize = vInsertNewR.size();
                                //文字排序
//                                if (uRsize > 1)
//                                    if (StrategyParam::unitSortRule == 3) {
//                                        stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmpGoalDeepth);
//                                    } else
//                                        stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmp);
                                if (uRsize > 1)
                                    stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmp);
                                newCla->LitPtr = new Literal*[uRsize];
                                for (UINT16 i = 0; i < vInsertNewR.size(); ++i) {
                                    Term* litSubT = unify.GetNewTerm(vInsertNewR[i]->subTerm, newCla); //参数1：文字谓词项，参数2：新子句指针
                                    if (TNegEqn == GetCodeProp(litSubT->iTermCode)
                                            && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {
                                        /*
                                        delete(litSubT);*/--uRsize;
                                        //delete(newCla->LitPtr[]);
                                        continue;
                                    }
                                    if (newCla->uFuncDepth < litSubT->uLevel)newCla->uFuncDepth = litSubT->uLevel;
                                    newCla->uVarCount += litSubT->uVarCount;
                                    //添加到文字		
                                    newCla->LitPtr[newCla->uLitNum] = new Literal(litSubT, EncodeLitCode(newClaId, newCla->uLitNum + 1), newCla, nullptr);
                                    newCla->LitPtr[newCla->uLitNum]->parentLitPtr = vInsertNewR[i]; //母式文字，有R产生
                                    //newCla->LitPtr[newCla->uLitNum]->goalDeepth = vInsertNewR[i]->goalDeepth;
                                    //20171020 计算演绎深度
                                    if (newCla ->deduceDeepth < (vInsertNewR[i]->claPtr->deduceDeepth + 1)) {
                                        newCla ->deduceDeepth = vInsertNewR[i]->claPtr->deduceDeepth + 1;
                                    }
                                    if (vInsertNewR[i]->claPtr->isAxtom && newCla->isAxtom)
                                        newCla->isAxtom = true;
                                    else
                                        newCla->isAxtom = false;
                                    if (hasUnifGoalLit(fol, newCla->LitPtr[newCla->uLitNum])) {
                                        newCla->LitPtr[newCla->uLitNum]->goalDeepth = 1;
                                        if (newCla->goaldeepth > 1)
                                            newCla->goaldeepth = 1;
                                    } else {
                                        newCla->LitPtr[newCla->uLitNum]->goalDeepth = vInsertNewR[i]->goalDeepth;
                                        if (newCla->goaldeepth > vInsertNewR[i]->goalDeepth)
                                            newCla->goaldeepth = vInsertNewR[i]->goalDeepth;
                                    }
                                    //cout<<to_string(newCla->uClaId)  + "]" <<"[" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitRow()) + "_" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitCol()) + "]" << newCla->LitPtr[newCla->uLitNum]->subTerm->ToString()<<endl;  
                                    ++(newCla->uLitNum);
                                }
                                //20171020 对子句的含等词的文字进行项序处理
                                if (StrategyParam::termRewriting != 2) {
                                    newCla->directEqn();
                                }
                                //cout<<newCla->LitPtr[0]->subTerm->ToStringBind()<<endl;
                                if (uRsize != 0) {
                                    //20171026 增加归结式复杂度判断
                                    if (newCla->compFuncDeepthCla() > StrategyParam::funcFixDeepth) {
                                        //cout<<"R无效"<<endl;
                                        newCla->DelLits(false);
                                        delete(newCla);
                                        //20170818 需要还原vNewR 此次演绎改变了什么 
                                        //清除变元合一绑定
                                        if (!unify.vVarBindT.empty())
                                            unify.ClearVarBind(unify.vVarBindT);
                                        //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                        if (!vOnlyOutDect.empty()) {
                                            UINT32 dlen = vOnlyOutDect.size();
                                            for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                                vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                            }
                                        }
                                        //还原vOutTri  vOnlyOutTri
                                        vOnlyOutTri.pop_back();
                                        int incOutTriSize = vOutTri.size() - lastvOutTriSize;
                                        for (UINT16 m = 0; m < incOutTriSize; m++) {
                                            vOutTri.pop_back();
                                        }
                                        //还原归结式
                                        int incRSize = vNewR.size() - lastRSize;
                                        for (UINT16 m = 0; m < incRSize; m++) {
                                            count--;
                                            vNewR.pop_back();
                                        }
                                        vInsertNewR.clear();
                                        vector<Literal*>().swap(vInsertNewR);
                                        //20170220 增加候选子句冗余权重
                                        //candClaP->reduntTimes++;
                                        continue;
                                    }
                                    //true 中间归结式冗余判断 false 中间归结式冗余不判断
                                    //                                    if (claHasPureLit(fol, newCla)) {
                                    //                                        //cout<<"R无效"<<endl;
                                    //                                        newCla->DelLits(false);
                                    //                                        delete(newCla);
                                    //                                        //20170818 需要还原vNewR 此次演绎改变了什么 
                                    //                                        //清除变元合一绑定
                                    //                                        if (!unify.vVarBindT.empty())
                                    //                                            unify.ClearVarBind(unify.vVarBindT);
                                    //                                        //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                    //                                        if (!vOnlyOutDect.empty()) {
                                    //                                            UINT32 dlen = vOnlyOutDect.size();
                                    //                                            for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                    //                                                vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                    //                                            }
                                    //                                        }
                                    //                                        //还原vOutTri  vOnlyOutTri
                                    //                                        vOnlyOutTri.pop_back();
                                    //                                        int incOutTriSize = vOutTri.size() - lastvOutTriSize;
                                    //                                        for (UINT16 m = 0; m < incOutTriSize; m++) {
                                    //                                            vOutTri.pop_back();
                                    //                                        }
                                    //                                        //还原归结式
                                    //                                        int incRSize = vNewR.size() - lastRSize;
                                    //                                        for (UINT16 m = 0; m < incRSize; m++) {
                                    //                                            count--;
                                    //                                            vNewR.pop_back();
                                    //                                        }
                                    //                                        vInsertNewR.clear();
                                    //                                        vector<Literal*>().swap(vInsertNewR);
                                    //                                        //20170220 增加候选子句冗余权重
                                    //                                        candClaP->reduntTimes++;
                                    //                                        continue;
                                    //                                    }
                                    if (StrategyParam::midRJudge) {
                                        vector<UINT32>invaildLitId; //
                                        invaildLitId.reserve(6);
                                        string rundMsg; //冗余信息
                                        Subsumption subsump; //(MOSTRIGHT)
                                        //参数1 被测的子句指针 参数2 整形数组 参数3 字符串 记录冗余信息
                                        bool isRundacyR = false;
                                        isRundacyR = subsump.GenCla(fol, newCla, invaildLitId, rundMsg);
                                        if (isRundacyR) {
                                            //cout<<"R无效"<<endl;
                                            newCla->DelLits(false);
                                            delete(newCla);
                                            //20170818 需要还原vNewR 此次演绎改变了什么 
                                            //清除变元合一绑定
                                            if (!unify.vVarBindT.empty())
                                                unify.ClearVarBind(unify.vVarBindT);
                                            //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                            if (!vOnlyOutDect.empty()) {
                                                UINT32 dlen = vOnlyOutDect.size();
                                                for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                                    vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                                }
                                            }
                                            //还原vOutTri  vOnlyOutTri
                                            vOnlyOutTri.pop_back();
                                            int incOutTriSize = vOutTri.size() - lastvOutTriSize;
                                            for (UINT16 m = 0; m < incOutTriSize; m++) {
                                                vOutTri.pop_back();
                                            }
                                            //还原归结式
                                            int incRSize = vNewR.size() - lastRSize;
                                            for (UINT16 m = 0; m < incRSize; m++) {
                                                count--;
                                                vNewR.pop_back();
                                            }
                                            vInsertNewR.clear();
                                            vector<Literal*>().swap(vInsertNewR);
                                            //20170220 增加候选子句冗余权重
                                            candClaP->reduntTimes++;
                                            continue;
                                        } else {
                                            FileOp::CreateRunInfoFile(FileOp::runFileId);
                                            chgCla.push_back(newCla);
                                            //20170602 新增输出小三角形路径
                                            if (StrategyParam::divideTri) {
                                                *FileOp::ofRealInfoOut << "从编号为" + to_string(candClaP->uClaId) + "子句开始构建三角形" << endl;
                                                if (candClaP->uLitNum == 1) {
                                                    candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                                                }
                                                givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                                                //输出演绎路径
                                                if(discardClas.empty() == false){
                                                    for(int aa= 0; aa<discardClas.size(); ++aa){
                                                        discardClas[aa]->isSDeduct = false;
                                                    }
                                                }
                                                PrintTriPath();
                                                if(discardClas.empty() == false){
                                                    for(int aa= 0; aa<discardClas.size(); ++aa){
                                                        discardClas[aa]->isSDeduct = true;
                                                    }
                                                }
                                                vector<Clause*>().swap(discardClas);
                                                FileOp::WriteR(newCla);
                                                *FileOp::ofRealInfoOut << "|[Y]" << endl;
                                                //20171024 将中间归结式加入子句集,可以用来减少冗余子句的生成
                                                fol.InsertCla(newCla);
                                                fol.setCla.insert(newCla);
                                                midGenR = true;
                                                if (/*StrategyParam::orForCompition*/true) {
                                                    newCla->addRForCompetiton();
                                                    
                                                    string rStr = "";
                                                    newCla->toString(rStr);
//                                                    string outClauses = PrintCompetitionOut(newClaId);
//                                                    int begPos = rStr.find_first_of("[") + 1;
//                                                    int endPos = rStr.find_first_of("]");
//                                                    string rId = rStr.substr(begPos, endPos - begPos);
//                                                    string rContext = rStr.substr(rStr.find_first_of("]") + 1);
//                                                    string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n" + "   inference(scs_inference,[]," + "[" + outClauses +"]" + ")).";
//                                                    
                                                    string cnf_str = newCla->ToStringWithSemantics(rStr);
                                                    string ruleClas = PrintCompetitionOut_eFormat(newClaId);
                                                    size_t pos = cnf_str.find_last_of(')');
                                                    string cnf_str_sub = cnf_str.substr(0, pos);
                                                    string out = cnf_str_sub + ", inference(scs_inference,[],[" + ruleClas + "]" + ")).";
                                                    
                                                    *FileOp::ofOutput << out << endl;
                                                }
                                                //20171024
                                            }
                                        }
                                    } else {
                                        FileOp::CreateRunInfoFile(FileOp::runFileId);
                                        chgCla.push_back(newCla);
                                        //20170602 新增输出小三角形路径
                                        if (StrategyParam::divideTri) {
                                            *FileOp::ofRealInfoOut << "从编号为" + to_string(candClaP->uClaId) + "子句开始构建三角形" << endl;
                                            if (candClaP->uLitNum == 1) {
                                                candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                                            }
                                            givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                                            //输出演绎路径	
                                            if(discardClas.empty() == false){
                                                    for(int aa= 0; aa<discardClas.size(); ++aa){
                                                        discardClas[aa]->isSDeduct = false;
                                                    }
                                                }
                                            PrintTriPath();
                                            if(discardClas.empty() == false){
                                                    for(int aa= 0; aa<discardClas.size(); ++aa){
                                                        discardClas[aa]->isSDeduct = true;
                                                    }
                                                }
                                            vector<Clause*>().swap(discardClas);
                                            //20171020 对子句的含等词的文字进行项序处理
                                            //                                            if (StrategyParam::termRewriting != 2) {
                                            //                                                newCla->directEqn();
                                            //                                            }
                                            FileOp::WriteR(newCla);
                                            *FileOp::ofRealInfoOut << "|[Y]" << endl;
                                            //20171024 将中间归结式加入子句集,可以用来减少冗余子句的生成
                                            fol.InsertCla(newCla);
                                            fol.setCla.insert(newCla);
                                            midGenR = true;
                                            if (/*StrategyParam::orForCompition*/true) {
                                                newCla->addRForCompetiton();
                                                    
                                                    string rStr = "";
                                                    newCla->toString(rStr);
//                                                    string outClauses = PrintCompetitionOut(newClaId);
//                                                    int begPos = rStr.find_first_of("[") + 1;
//                                                    int endPos = rStr.find_first_of("]");
//                                                    string rId = rStr.substr(begPos, endPos - begPos);
//                                                    string rContext = rStr.substr(rStr.find_first_of("]") + 1);
//                                                    string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n" + "   inference(scs_inference,[]," + "[" + outClauses +"]" + ")).";
//                                                    
                                                    string cnf_str = newCla->ToStringWithSemantics(rStr);
                                                    string ruleClas = PrintCompetitionOut_eFormat(newClaId);
                                                    size_t pos = cnf_str.find_last_of(')');
                                                    string cnf_str_sub = cnf_str.substr(0, pos);
                                                    string out = cnf_str_sub + ", inference(scs_inference,[],[" + ruleClas + "]" + ")).";
                                                    
                                                    *FileOp::ofOutput << out << endl;
                                            }
                                            //20171024
                                        }
                                    }
                                }
                                //string str;
                                //newCla->toString(str);
                                //cout<<"插入中间演绎的单文字子句:" <<str << endl;
                                fol.initGenerateClaAttr(newCla);
                                newClaId++;
                            }

                        }
                        vInsertNewR.clear();
                        vector<Literal*>().swap(vInsertNewR);
                    }
                    //20170215 保存每次子句演绎的互补对单元子句
                    claPair.clear();
                    claPair.push_back(QLit);
                    //20170215需要为参与本单元的三角形演绎单元子句设置权重
                    if (!vOnlyDectNum.empty()) {
                        for (UINT8 nm = 0; nm < vOnlyDectNum.size(); nm++) {
                            claPair.push_back(vOnlyDectNum[nm]);
                            if (vOnlyDectNum[nm]->claPtr->uLitNum == 1)
                                vOnlyDectNum[nm]->claPtr->adeductNum++; //单元子句权重加1
                        }
                    }
                    if (candClaP->uLitNum == 1) {
                        candClaP->adeductNum++; //主动归结次数+1
                        candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                    }
                    
                    QLit->sDuct = QLit->sDuct + 10; //候选文字权重加一 须重新文字排序 first-> QLit->sDuct++
                    if(QLit->sDuct == 10000)
                        QLit->sDuct = 0;
                    //2020:repaired
                    if(givenCla->isAxtom == false)
                        givenCla->pdeductNum += 1/*resRandomNumber(total_Loop)*/; //total_Loop 怎么得到
                    else{
                        if(StrategyParam::equalityUsedFrq == 0)
                            givenCla->pdeductNum += 3/*resRandomNumber(total_Loop) + total_Loop/2*/; //total_Loop 怎么得到
                        else if(StrategyParam::equalityUsedFrq == 1)
                            givenCla->pdeductNum += resRandomNumber(total_Loop) + total_Loop/50; //total_Loop 怎么得到
                        else if(StrategyParam::equalityUsedFrq == 2)
                            givenCla->pdeductNum += resRandomNumber(total_Loop); //total_Loop 怎么得到
                    }
                    givenCla->isSDeduct = true; //在构建三角形过程中参与归结

                    //20171022 拷贝已使用的子句,以达到重复使用子句的目的
                    //如果演绎的不是上次拷贝的子句,则需要将其删除
                    //                    if((lastDeductCla != nullptr) &&(givenCla != lastDeductCla)){//说明拷贝的子句没有用上
                    //                        //在演绎子句列表中清除lastDeductCla
                    //                        vector<Clause*>::iterator delInd = find(candidateClaSet.begin(),candidateClaSet.end(),lastDeductCla);
                    //                        candidateClaSet.erase(delInd);
                    //                        //在拷贝的子句列表中清除lastDeductCla
                    //                        lastDeductCla->DelLits(false);
                    //                        delete(lastDeductCla);
                    //                    }
                    //if (StrategyParam::useCpUintCla) {//拷贝单元子句
                    if (1) {//拷贝单元子句
                        if ((candClaP->uLitNum == 1) && candClaP->HasTermBind()) {
                            //拷贝新的子句来使用
                            unify.copyUintCla(fol, candClaP, newClaId);
                            hasCpUintClaId.insert(candClaP->uClaId);
                        }
                        if (vOnlyDectNum.size() > 0) {
                            for (UINT16 s = 0; s < vOnlyDectNum.size(); ++s) {
                                if ((vOnlyDectNum[s]->claPtr->uLitNum == 1) && vOnlyDectNum[s]->claPtr->HasTermBind()) {
                                    //拷贝新的子句来使用
                                    unify.copyUintCla(fol, vOnlyDectNum[s]->claPtr, newClaId);
                                    hasCpUintClaId.insert(vOnlyDectNum[s]->claPtr->uClaId);
                                }
                            }
                        }
                    }
                    
                    //if (midGenR && (StrategyParam::claReUseTimes != 0) && (givenCla->HasTermBind())) {
                    if (midGenR && (givenCla->HasTermBind())&& (givenCla->isAxtom == false)) {//2020:repaired
                        Clause* cpClaTmp = nullptr;
                        if (givenCla->topCopyCla == nullptr)
                            cpClaTmp = givenCla;
                        else
                            cpClaTmp = givenCla->topCopyCla;
                        //if (copyClaCopyTimes(cpClaTmp) < StrategyParam::claReUseTimes) {
                        if (1) {
                            Clause* cyCla = copyCla(fol, cpClaTmp, newClaId, candLitP, QLit);
                            cyCla->topCopyCla = cpClaTmp;
                            lastDeductCla = cyCla;
                            //插入到演绎子句列表中
                            vector<Clause*>::iterator insertInd = find(candidateClaSet.begin(), candidateClaSet.end(), givenCla);
                            candidateClaSet.insert(insertInd + 1, cyCla);
                            midGenR = false;
                        }

                    }

                    //20171022 end

                    setRedundClaId.insert(givenCla->uClaId); //用于本次三角形不在使用已经归结过的子句
                    if (RULEOK == unifResult) {
                        isDeduct = true;
                        isGloDeduct = true;
                    }
                    //20170828 增加R文字数限制,即当vNewR.size() 大于文字数限制 则要退出
                    //20170215 子句全部落入三角形下方 需要结束三角形演绎 并判断是否能得出结论
                    if (findOnlyOut && (vNewR.size() != 0))
                        break;
                    //20170828 增加R文字数限制,即当vNewR.size() 大于文字数限制 则要退出
                    if ((vNewR.size() >= StrategyParam::R_MAX_NUM) || ((StrategyParam::R_INIT_MAX_NUM == givenCla->uLitNum)&&(givenCla->uLitNum > 10))) {
                        break;
                    }
                    //end
                    //0:深度优先 1:宽深结合 2:宽度优先
                    if (StrategyParam::widthDeep == 0) {
                        break;
                    } else if (StrategyParam::widthDeep == 1) {
                        break;
                    } else
                        break;
                } else {
                    //清除合一规则检查失败时，被置为isSdeduct为true的子句
                    if (!vOnlyOutDect.empty()) {
                        UINT32 dlen = vOnlyOutDect.size();
                        for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                            vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                        }
                    }
                }
            }//20170210 候选子句外循环  找互补对外循环体
            //20171026 应该要遍历所有的文字
            if (isDeduct)
                break;
            else{//20190516 add
                if((FileOp::strategyMode == 3) || (FileOp::strategyMode == 4)){
                    ;
                }
                else{
                    ActLitInd = ActLitInd + givenCla->uLitNum;
                }
                QLit->sDuct++; //候选文字权重加一 须重新文字排序 first-> QLit->sDuct++
                if(QLit->sDuct == 1000)//2020:repaired
                    QLit->sDuct = 0;
            }
            //只找到一次候选文字，不管有没有都退出，后期可以把深入做大
            //break;
        }//20170210 主动子句外循环
        //20170828 增加R文字数限制,即当vNewR.size() 大于文字数限制 则要退出
        if ((vNewR.size() >= StrategyParam::R_MAX_NUM) || (isDeduct && (StrategyParam::R_INIT_MAX_NUM == candClaP->uLitNum)&&(candClaP->uLitNum > 10))) {
            break;
        }
        //end
        //继续下一个合一配对
        ResClaID.insert(givenCla->uClaId);
        ResClaPtr.push_back(givenCla);
//#define cprover_fast5
#ifndef cprover_fast5
        if (20180101) {
            if (((cDeepth == (candidateClaSet.size() - 1)) || (cDeepth == StrategyParam::deductDeep)) && oneRunFlag) {
                cDeepth = -1;
                oneRunFlag = false;
                genUintRFirst = false;
            }
            //20180914
            else if (((cDeepth == (candidateClaSet.size() - 1)) || (cDeepth == StrategyParam::deductDeep)) && !oneRunFlag && !genUintRFirst && twoRunFlag) {
                cDeepth = -1;
                twoRunFlag = false;
                genUintRSecond = false;
            }
        }
#endif
        cDeepth++;
        //为-1时，系统自动处理；为大于0时设置值有效；
        if (cDeepth == StrategyParam::deductDeep) {
            if (isGloDeduct) {
                break;
            } else {
                allNoPair = true;
                return 222;
            }
        }
        if (cDeepth == candidateClaSet.size()) {
            if (isGloDeduct) {
                break;
            } else {//所有的单元子句都找不到互补对有效子句
                allNoPair = true;
                return 22;
            }
        }
        //控制三角形演绎子句的总长度
//        if (setRedundClaId.size() > 160) {
//            if (isGloDeduct) {
//                break;
//            } else {//所有的单元子句都找不到互补对有效子句
//                allNoPair = true;
//                return 22;
//            }
//        }
        clock_t end = clock();
        double time_s = (double) (end - start) / (double) CLOCKS_PER_SEC;
        StrategyParam::timeLimit = StrategyParam::firstTimeLimit;
        if (time_s > StrategyParam::timeLimit * 60)//200   3  1分钟 15  5分钟   30  15分钟  end:300
        {
            if (isGloDeduct) {
                break;
            } else {//所有的单元子句都找不到互补对有效子句
                allNoPair = true;
                return 22;
            }
        }
        //考虑情况：配对子句已全部落入三角形内，但是之前有R剩余，此时停止构建三角形
        //       if ((findOnlyOut && (vNewR.size() != 0)) || cDeepth == vOnlyOutTri.size()) {
        //           if (findOnlyOut && (vNewR.size() != 0)) {
        //                //cout << "找到所有互补对单R不为空" << endl;
        //                if (!claPair.empty()) {
        //                    UINT32 lengthA = -2;
        //                    vector <Literal*>::iterator ie;
        //                    for (UINT8 lab = 0; lab < claPair.size(); lab++) {
        //                        ie = find(vOnlyOutTri.begin(), vOnlyOutTri.end(), claPair[lab]);
        //                        if (distance(vOnlyOutTri.begin(), ie) > lengthA)
        //                            lengthA = distance(vOnlyOutTri.begin(), ie);
        //                    }
        //                    ie = find(vOnlyOutTri.begin(), vOnlyOutTri.end(), firstR);
        //                    if (distance(vOnlyOutTri.begin(), ie) > lengthA) {
        //                        newCla = nullptr;
        //                        cout << "得出结论:不可满足" << endl;
        //                        return true;
        //                    }
        //                }
        //            }
        //             break;
        //        }
        givenCla = candidateClaSet[cDeepth];
        //string str;
        //givenCla->toString(str);
        //cout << str << endl;
    }//20170210 构建三角形结束外循环
    //生成新子句(R) 并输出演绎结果中
    newCla = nullptr;
    //20170215 用于判断最后的收尾归结子句全部落在三角形内的情况 但R不为空 
    assert(!(findOnlyOut && (vNewR.size() == 0)));
    if (!findOnlyOut) //20170215 end
    {
        vNewR.push_back(vOnlyOutTri.back());
        //vOnlyOutTri.pop_back();
    }
    //20170214 若所有的主对角线文字都没有找到满足条件互补的子句，则不输出R
    if ((vNewR.size() == 1)&&(chgCla.size() == 0)&&(find(vOnlyOutTriCmp.begin(), vOnlyOutTriCmp.end(), vNewR[0]) != vOnlyOutTriCmp.end())) {
        allNoPair = true;
        return 22;
    }
    
      // 此处判断是否有冗余的R 文字,即由该子句对角线文字没有互补对的文字存在与矛盾体中
    if (StrategyParam::litRundent) {
        for (int i = 0; i < vNewR.size(); ++i) {
            UINT16 countPair = 0;
            Clause *findCla = vNewR[i]->claPtr;
            if(findCla == vOutTri.back()->claPtr)
                continue;
            for (int j = 0; j < findCla->uLitNum; ++j) {
                if (find(vOnlyOutTri.begin(), vOnlyOutTri.end(), findCla->LitPtr[j]) != vOnlyOutTri.end()) {//找到对角线文字,查看互补对
                    for (int k = 0; k < vOutTri.size(); ++k) {
                        if ((findCla->LitPtr[j]->isPairPred(vOutTri[k])) && (unify.CheckPairEqn(findCla->LitPtr[j]->subTerm, vOutTri[k]->subTerm))) {
                            ++countPair;
                            break;
                        }
                    }
                }
            }
            if (countPair == 0) {//表示对角线没有互补对
                vNewR[i]->claPtr->isSDeduct = false;
                swap(vNewR[i], vNewR[vNewR.size() - 1]);
                vNewR.pop_back();
                --i;
                
            }
        }
    }
    
    //检查R是否有相同的合并
    for (size_t rInd = 0; rInd < vNewR.size() - 1; ++rInd) {
        Literal* rA = vNewR[rInd];
        for (size_t rIndB = rInd + 1; rIndB < vNewR.size();) {
            Literal* rB = vNewR[rIndB];
            if (rA->subTerm->iTermCode == rB->subTerm->iTermCode && unify.CheckEqn(rA->subTerm, rB->subTerm)) {
                swap(vNewR[rIndB], vNewR[vNewR.size() - 1]);
                vNewR.pop_back();
            } else
                ++rIndB;
        }
    }

  
    
    assert(vNewR.size() != 0); //20170211 考虑是否此处有R为0
    newCla = new Clause(newClaId, 0);
    newCla->isAxtom = true;
    size_t uRsize = vNewR.size();
    //文字排序
    if (uRsize > 1)
        stable_sort(vNewR.begin(), vNewR.end(), SortRule::LitCmp);
    newCla->LitPtr = new Literal*[uRsize];
    for (UINT16 i = 0; i < vNewR.size(); ++i) {
        Term* litSubT = unify.GetNewTerm(vNewR[i]->subTerm, newCla); //参数1：文字谓词项，参数2：新子句指针
        if (TNegEqn == GetCodeProp(litSubT->iTermCode)
                && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {//出现有剩余文字仍为不可满足的清空，需要考虑这种清空 20170108
            /*
            delete(litSubT);*/--uRsize;
            //delete(newCla->LitPtr[]);
            continue;
        }
        if (newCla->uFuncDepth < litSubT->uLevel)newCla->uFuncDepth = litSubT->uLevel;
        newCla->uVarCount += litSubT->uVarCount;
        //添加到文字		
        newCla->LitPtr[newCla->uLitNum] = new Literal(litSubT, EncodeLitCode(newClaId, newCla->uLitNum + 1), newCla, nullptr);
        newCla->LitPtr[newCla->uLitNum]->parentLitPtr = vNewR[i]; //母式文字，有R产生
        //newCla->LitPtr[newCla->uLitNum]->goalDeepth = vNewR[i]->goalDeepth;
        //20171020 计算演绎深度
        if (newCla ->deduceDeepth < (vNewR[i]->claPtr->deduceDeepth + 1)) {
            newCla ->deduceDeepth = vNewR[i]->claPtr->deduceDeepth + 1;
        }
        if (vNewR[i]->claPtr->isAxtom && newCla->isAxtom)
            newCla->isAxtom = true;
        else
            newCla->isAxtom = false;
        if (hasUnifGoalLit(fol, newCla->LitPtr[newCla->uLitNum])) {
            newCla->LitPtr[newCla->uLitNum]->goalDeepth = 1;
            if (newCla->goaldeepth > 1)
                newCla->goaldeepth = 1;
        } else {
            newCla->LitPtr[newCla->uLitNum]->goalDeepth = vNewR[i]->goalDeepth;
            if (newCla->goaldeepth > vNewR[i]->goalDeepth)
                newCla->goaldeepth = vNewR[i]->goalDeepth;
        }
        ++(newCla->uLitNum);
    }
    fol.initGenerateClaAttr(newCla);
    newClaId++;
    //string str;
    //newCla->toString(str);
    //cout<<"R:" << str << endl;
    return 221;
}
//201709015 从左到右构建三角形

UINT8 TriAlg::GenerateTriByRecodePathLRCombined(Formula& fol, vector<Clause*>& candidateClaSet, UINT32 &newClaId, BACKTYPE _backType, vector<Clause*> &chgCla, UINT16& loop_Num) {
    if (_backType == NOBACK)//清除变量
    {
        //assert(!(givenCla == nullptr));
        //初始化		
        PreResLit = nullptr; //上轮找到的合一文字
        setRedundClaId.clear(); //记录参与演绎的子句
        setRealRedundClaId.clear(); //记录冗余的子句
        hasCpUintClaId.clear();
        setRealRedundClaId.reserve(8);
        vector<Literal*>().swap(vNewR);
        vNewR.reserve(8);
        vector<UINT16>().swap(vComparePos);
        ResClaID.clear();
        //ResClaID.insert(givenCla->uClaId); //记录第一个归结子句编号
        vector<Clause*>().swap(ResClaPtr);
        //ResClaPtr.push_back(givenCla); //记录第一个归结子句指针
        BackPathClear(); //重要：清除路径以及上轮归结中变元的绑定 
        //stackVarChg.reserve(16);
        //noCmpCla.clear();
        stackVarChg.reserve(100);
    }
    bool creatFlag = true;
    Clause* givenCla = nullptr;
    RESULT unifResult; //是否合一
    bool isDeduct = false; //是否发生过归结
    bool isGloDeduct = false; //是否发生过归结
    Clause* candClaP = nullptr; // 被动归结子句（候选子句）
    Literal* candLitP = nullptr; //被动归结文字（候选文字）
    vector<Literal*>* vCandLit = &vOnlyOutTri; //取相同文字的map集合
    INT32 cDeepth = 0; //演绎深度
    INT32 cLongth = 0;
    UINT8 count = 0;
    Literal * lastTrip = nullptr;
    bool findOnlyOut = false; //用于控制子句的文字三角形摆放
    bool first_RLit = true; //记录第一次剩余的R
    Clause* lastDeductCla = nullptr;
    Clause* first_Given = candidateClaSet[0];
    bool midGenR = false; //用于限制只有在生成了中间归结式的过程中拷贝演绎子句,否则R文字数会很大
    bool oneRunFlag = true;
    bool twoRunFlag = true;
    bool genUintRFirst = true;
    bool genUintRSecond = true;
    UINT32 lastMainDiagonalInd = 0;
    
    vector<Clause*> chooseClaSet;
    chooseClaSet.reserve(16);
    //20170821 针对构建三角形过程中出现的冗余子句,其权重修改为加随机数,这样可以使得下次做的三角形不一样.
    if (StrategyParam::useRandrom)
        srand((unsigned int) time(nullptr));
    int eRun = 0;
    bool combineFlag = true;
    int sCount = 0;
    while (1) {
        if(1)
        {
            clock_t end_control = clock();
            double time_control = (double) (end_control - StrategyParam::start) / (double) CLOCKS_PER_SEC;
            StrategyParam::timeLimit = StrategyParam::firstTimeLimit;
            if (time_control > StrategyParam::timeLimit * 60)//200   3  1分钟 15  5分钟   30  15分钟  end:300
            {
                if (isGloDeduct) {
                    break;
                } else {//所有的单元子句都找不到互补对有效子句
                    allNoPair = true;
                    return 22;
                }
            }
        }
        if (combineFlag) {
            if ((cLongth == 0) || (cDeepth == chooseClaSet.size()) || (chooseClaSet.size() == 0)) {
                if (1) {//just for timeout
                    clock_t end_control = clock();
                    double time_control = (double) (end_control - StrategyParam::start) / (double) CLOCKS_PER_SEC;
                    StrategyParam::timeLimit = StrategyParam::firstTimeLimit;
                    if (time_control > StrategyParam::timeLimit * 60)//200   3  1分钟 15  5分钟   30  15分钟  end:300
                    {
                        if (isGloDeduct) {
                            break;
                        } else {//所有的单元子句都找不到互补对有效子句
                            allNoPair = true;
                            return 22;
                        }
                    }
                    else if(time_control > StrategyParam::timeLimit * 30)
                    {
                        combineFlag = false;
                        cLongth = 0;
                        continue;
                    }
                }
                givenCla = candidateClaSet[cLongth];

                //        string str;
                //        givenCla->toString(str);
                //        cout <<"起步子句:" <<str << endl;
                //1.将主对角线子句和所选的子句，封装成TPTP格式,
                fol.combinedClaSet.clear();
                if (combineFlag) {

                    if (vOutTri.size() > 0) {
                        for (UINT16 m = 0; m < vOutTri.size(); m++) {
                            if (fol.combinedClaSet.find(vOutTri[m]->claPtr) != fol.combinedClaSet.end()) {
                                continue;
                            } else
                                fol.combinedClaSet.insert(vOutTri[m]->claPtr);
                        }

                    }
                    fol.combinedClaSet.insert(givenCla);
                    //输出子句格式
                    string str = "";
                    str = fol.ToCombinedString();
                    FileOp::PrintInfoCombinedClas(str); //输出所有的单元子句到.erspre
                    //得到结合证明器识别的格式
                    FileOp::convertCombinedClaFormat();

                }
                //2.调用E运行，并解析输出文件，得到新生成的子句
                if (combineFlag) {
                    string cmd = FileOp::homePath + "/Desktop/dist/eprover " + " --delete-bad-limit=2000000000 --definitional-cnf=24 -s --full-deriv --tstp-format --print-statistics -R --print-version --proof-object --auto-schedule --cpu-limit=1 ";
                    string strInfoPath = FileOp::g_OutputPath + "/" + FileOp::JudgeFileFullNameNoExt + ".combinedResForRun";
                    string strInfoPathOut = FileOp::g_OutputPath + "/" + FileOp::JudgeFileFullNameNoExt + ".combinedResRunOut";
                    cmd = cmd + strInfoPath + " >> " + strInfoPathOut;
                    int res4 = system(const_cast<char*> (cmd.c_str()));
                }
                //3.解析得到新生成的子句到CSE.若是单元子句，加入到主对角线，否则加入到候选子句集
                if (combineFlag) {
                    //读取文件，返回子句
                    string strClause = "";
                    Clause* comCla = nullptr;
                    string strInfoPath = FileOp::g_OutputPath + "/" + FileOp::JudgeFileFullNameNoExt + ".combinedResRunOut";
                    ifstream ifFolFile(strInfoPath);
                    
                    while (getline(ifFolFile, strClause)) {
                        string realLine = strClause;
                        if ((strClause.find("cnf", 0) != string::npos) && (strClause.find("inference", 0) != string::npos)) {
                            sCount++;
                            //cout<<strClause<<endl;
                            size_t index = strClause.find("plain");
                            //cout<<index<<endl;
                            strClause = strClause.substr(index + 6);
                            index = strClause.find("inference");
                            strClause = strClause.substr(0, index - 2);
                            //cout<<strClause<<endl;
                            //strClause = strClause.substr(strClause.find_first_of("plain") + 6,strClause.find_first_of("inference") - 2 - (strClause.find_first_of("plain") + 6));
                            comCla = fol.ReadTPTPClause(strClause, newClaId);
                            if(!comCla)
                                continue;
                            if((comCla->uLitNum) == 0){
                                newClaId--;
                                comCla->DelLits(true);
                                delete(comCla);
                                continue;
                            }

                            if ((comCla->uLitNum) != 0) {
                                if(comCla->compFuncDeepthCla() > StrategyParam::funcFixDeepth)
                                {
                                    newClaId--;
                                    comCla->DelLits(true);
                                    delete(comCla);
                                    continue;
                                }
                                vector<UINT32>invaildLitId; //
                                invaildLitId.reserve(6);
                                string rundMsg; //冗余信息
                                Subsumption subsump; //(MOSTRIGHT)
                                //参数1 被测的子句指针 参数2 整形数组 参数3 字符串 记录冗余信息
                                bool isRundacyR = false;
                                isRundacyR = subsump.GenCla(fol, comCla, invaildLitId, rundMsg);
                                if (isRundacyR) {
                                    newClaId--;
                                    comCla->DelLits(true);
                                    delete(comCla);
                                    continue;
                                } else {

                                    fol.setCla.insert(comCla);
                                    if (comCla->uLitNum > 1) {
                                        chooseClaSet.push_back(comCla);
//                                        string str;
//                                        comCla->toString(str);
//                                        cout << str << endl;
                                    }
                                }
                            }
                        } else if ((realLine.find("Proof found!", 0) != string::npos)) {
                            newCla = nullptr;
                            vNewR.clear();
                            if (!StrategyParam::orForCompition && (StrategyParam::problemDiv == 0))
                                cout << "得出结论:不可满足" << endl;
                            return true;
                        }
                    }
                    //clear output by E
                    remove(strInfoPath.c_str());
                    if(sCount > 3)
                    {
                        combineFlag = false;
                        cLongth = 0;
                        continue;
                    }
                }
                ++cLongth;
                if (candidateClaSet.size() == cLongth) 
                {
                    combineFlag = false;
                    cLongth = 0;
                    continue;
                }
            }
            if ((chooseClaSet.size() == 0) || (cDeepth == chooseClaSet.size())) {
                continue;
            } else if (cLongth == candidateClaSet.size()) {
                combineFlag = false;
                cLongth = 0;
                continue;
            }
            //4.将候选子句与现有构建的三角形继续演绎
            if (cDeepth < chooseClaSet.size()) {
                givenCla = chooseClaSet[cDeepth];
            }
        }
        else{
            givenCla = candidateClaSet[cLongth];
        }
        if(givenCla->clast != CopyTemp)
            stable_sort(givenCla->LitPtr, givenCla->LitPtr + givenCla->uLitNum, SortRule::ActlitCmp);
        UINT16 ActLitInd = 0;
        for (; ActLitInd < givenCla->uLitNum; ++ActLitInd) {//ActLitInd = ActLitInd + givenCla->uLitNum
            isDeduct = false;
            Literal* QLit = givenCla->LitPtr[ActLitInd];
            //根据文字互补谓词项对应的互补文字得到候选文字
            //            vCandLitAll = QLit->getPairPredLst();
            //            //提取单元子句序列
            //            if(vCandLitAll->size() == 0)
            //                continue;
            //            for(UINT32 i=0; i< vCandLitAll->size(); ++i){
            //                if(vCandLitAll->at(i)->claPtr->uLitNum == 1){
            //                    vCandLit.push_back(vCandLitAll->at(i));
            //                }
            //            }
            //            stable_sort(vCandLit.begin(), vCandLit.end(), SortRule::claSingCmp);

            //stable_sort(vCandLit->begin(), vCandLit->end(), SortRule::PoslitCmpLarge); //被动文字按子句个数进行排序  此处考虑用随机策略
            //此处考虑加大宽度，即同一子句可以左多个合一子句
            if (setRedundClaId.find(givenCla->uClaId) != setRedundClaId.end())
                continue;
            
            UINT32 pasLitInd = 0;
            setRealRedundClaId.clear(); //演绎文字出现冗余
            for (; pasLitInd < UINT32(vCandLit->size()); ++pasLitInd)//依次找到
            {
                //cout<<"找归结子句:"<<pasLitInd<<endl;
                if((givenCla->clast == CopyTemp) && (lastMainDiagonalInd <= pasLitInd)){
                    continue;
                }
                lastMainDiagonalInd = pasLitInd;
                candLitP = vCandLit->at(pasLitInd); //候选被动归结文字
                if (1) {//用于重复使用子句无法跳出的情况
                    clock_t end_out = clock();
                    double time_out = (double) (end_out - StrategyParam::start) / (double) CLOCKS_PER_SEC;
                    if (time_out > StrategyParam::timeLimit * 60)//200   3  1分钟 15  5分钟   30  15分钟  end:300
                    {
                        break;
                    }
                }
                if (QLit->isPairPred(candLitP) == false) {
                    continue;
                }
                candClaP = candLitP->claPtr; // 被动归结子句（候选子句）
                //20171022 增加拷贝子句的演绎限制
                if ((candClaP->uLitNum == 1) &&(hasCpUintClaId.find(candClaP->uClaId) != hasCpUintClaId.end())) {//单元子句已经被拷贝了
                    continue;
                }
                if ((givenCla->clast == CopyTemp) &&(givenCla->copyFrom == candLitP) && unify.CheckEqnR(givenCla->copyTo->subTerm, QLit->subTerm)) {//已拷贝的子句
                    continue;
                }

                //20170827 限制子句中文字数个数
                //                if (vNewR.size() + givenCla->uLitNum + candClaP->uLitNum - 2 > StrategyParam::R_MAX_NUM)
                //                    continue;

                //不允许跟上一轮母式进行归结  
                //                if ((candLitP->parentLitPtr && candLitP->parentLitPtr->claPtr == givenCla) || (QLit->parentLitPtr && QLit->parentLitPtr->claPtr == candClaP)){
                //                    continue;
                //                }
                //核心：合一算法，参数1：主动归结文字指针；参数2：被动归结文字指针
                //20180909 增加目标子句的归结 放松限制
                INT32 tempRsize = StrategyParam::R_MAX_NUM;
                if (candLitP->claPtr->isGoal && (StrategyParam::R_MAX_NUM < candLitP->claPtr->uLitNum)) {
                    StrategyParam::R_MAX_NUM = vNewR.size() + candLitP->claPtr->uLitNum;
                }
                unifResult = unify.IssynLR(QLit, candLitP); //是否找到合一文字
                StrategyParam::R_MAX_NUM = tempRsize;
                //20170909 将限制还原
                //20170215  根据归结子句的互补文字，当有剩余文字既要放入主对角线，又要放入R中 此时的顺序如何选择 这里和文字的稳定排序有关
                if (unifResult == RULEOK) {
                    //                    if(creatFlag){
                    //                        FileOp::CreateRunInfoFile(candidateClaSet[cDeepth]->uClaId / 25);
                    //                        creatFlag = false;
                    //                    }
                    //20170210 stackVarChg用于保存构建三角形过程中所有的替换项
                    //20170818 记录演绎前的归结式文字个数
                    int lastRSize = vNewR.size();
                    int lastvOutTriSize = vOutTri.size();
                    stackVarChg.push_back(unify.vVarBindT); //添加到替换堆栈中	 //版本2需要重点考虑	 
                    //20170224对候选子句进行排序
                    //候选子句文字策略
                    //0:归结次数>稳定度 1:无(由原始顺序为准) 2:稳定度>归结次数
                    findOnlyOut = true;
                    UINT16 sumDrop = 0;
                    vector<Literal*> leftLiter; //20170305 用于保存剩余文字，以便选择最优的文字放入三角形中
                    for (UINT16 m = 0; m < givenCla->uLitNum; m++) {
                        if (givenCla->LitPtr[m]->isDrop)//互补文字
                        {
                            sumDrop++;
                            vOutTri.push_back(givenCla->LitPtr[m]);
                            //cout<<"三角形下方文字"<<"[C" + to_string(candClaP->LitPtr[m]->Row()) + "_" + to_string(candClaP->LitPtr[m]->Col()) + "]"<<(candClaP->LitPtr[m]->subTerm->ToStringBind())<<endl;
                            continue;
                        }
                        //20170305 idea 有效解决冗余:优先选择与单元子句一样的文字(合一)，另外考虑徐老师讲的同一子句可以合并的文字一定要合并
                        leftLiter.push_back(givenCla->LitPtr[m]);
                    }
                    if (!leftLiter.empty()) {
                        //查找是否有可以和单元子句合一相同的文字
                        vector<Term*> chgTempT; //储存替换变元项
                        for (UINT16 m = 0; m < leftLiter.size(); m++) {
                            bool findRes = false;
                            for (auto& clap : vOnlyOutTri) {
                                if (leftLiter[m]->isEqPred(clap) && unify.LitMgu(leftLiter[m], clap, chgTempT)) {
                                    swap(leftLiter[m], leftLiter[0]);
                                    unify.ClearVarBind(chgTempT);
                                    findRes = true;
                                    break;
                                } else
                                    unify.ClearVarBind(chgTempT);
                            }
                            if (findRes)
                                break;
                        }
                        unify.ClearVarBind(chgTempT);
                        for (UINT16 m = 0; m < leftLiter.size(); m++) {
                            if (!leftLiter[m]->isDel && findOnlyOut) {//被选归结子句剩下的文字,其中第一个放在对角线上,其余放入R中
                                lastTrip = leftLiter[m]; //记录三角形对角线演绎最后一个文字，下一次演绎需要放入三角形中
                                vOutTri.push_back(leftLiter[m]);
                                vOnlyOutTri.push_back(leftLiter[m]);
                                findOnlyOut = false;
                            } else if (!leftLiter[m]->isDel &&!findOnlyOut) {//放入R中
                                count++;
                                vOutTri.push_back(leftLiter[m]);
                                vNewR.push_back(leftLiter[m]);
                                //20170216
                                if (first_RLit) {
                                    firstR = vOnlyOutTri.back();
                                    first_RLit = false;
                                }

                            }
                        }
                    }
                    //判断是否全部放入三角形中
                    if (findOnlyOut && count == 0 && vNewR.size() == 0) {
                        newCla = nullptr;
                        givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                        candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                        if(!StrategyParam::orForCompition && (StrategyParam::problemDiv == 0))
                            cout << "得出结论:不可满足" << endl;
                        return true;
                    }
                    //20171229 此处若有剩余文字时,需要跳过该候选子句；需要做如下处理: 1.将该子句与后面的子句交换
//#define cprover_fast4
#ifndef cprover_fast4
                    if (1229) {
                        if ((vNewR.size() > 0) && genUintRFirst) {//需要回退
                            //清除变元合一绑定
                            if (!unify.vVarBindT.empty())
                                unify.ClearVarBind(unify.vVarBindT);
                            //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                            if (!vOnlyOutDect.empty()) {
                                UINT32 dlen = vOnlyOutDect.size();
                                for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                    vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                }
                            }
                            //还原vOutTri  vOnlyOutTri
                            vOnlyOutTri.pop_back();
                            int incOutTriSize = vOutTri.size() - lastvOutTriSize;
                            for (UINT16 m = 0; m < incOutTriSize; m++) {
                                vOutTri.pop_back();
                            }
                            //还原归结式
                            int incRSize = vNewR.size() - lastRSize;
                            for (UINT16 m = 0; m < incRSize; m++) {
                                count--;
                                vNewR.pop_back();
                            }
                            continue;
                        }
                        //20180914
                        else if ((vNewR.size() > 1) && (!genUintRFirst) && genUintRSecond) {//需要回退
                            //清除变元合一绑定
                            if (!unify.vVarBindT.empty())
                                unify.ClearVarBind(unify.vVarBindT);
                            //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                            if (!vOnlyOutDect.empty()) {
                                UINT32 dlen = vOnlyOutDect.size();
                                for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                    vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                }
                            }
                            //还原vOutTri  vOnlyOutTri
                            vOnlyOutTri.pop_back();
                            int incOutTriSize = vOutTri.size() - lastvOutTriSize;
                            for (UINT16 m = 0; m < incOutTriSize; m++) {
                                vOutTri.pop_back();
                            }
                            //还原归结式
                            int incRSize = vNewR.size() - lastRSize;
                            for (UINT16 m = 0; m < incRSize; m++) {
                                count--;
                                vNewR.pop_back();
                            }
                            continue;
                        }
                    }
#endif
                    //20171229 end
                    //三角形上方不剩文字，即归结出来单文字if (find(vOnlyOutTri.begin(), vOnlyOutTri.end(),givenCla->LitPtr[ActLitInd]) == vOnlyOutTri.end())
                    //中间归结式生成 static bool midR;//中间归结式生成 //true 中间归结式生成 false 中间归结式不生成
                    if (count == 0 && vNewR.size() == 0 && !findOnlyOut && StrategyParam::midR) {
                        //新建子句,生成单文字子句,最后加入到单文字子句列表中
//                        if ((newClaId == 1017) &&(vOnlyOutTri.back()->claPtr->uClaId == 11)) {
//                            cout << "debug" << endl;
//                        }
                        Literal* tempptr = vOnlyOutTri.back();
                        bool flagT = true;
                        //如果时纯文字或单文字已存在
                        if ((tempptr->getPairPredLst()->empty()) || (find(vOnlyOutTriCmp.begin(), vOnlyOutTriCmp.end(), tempptr) != vOnlyOutTriCmp.end())) {
                            flagT = false;
                        }
                        if (flagT) {
                            vector<Literal*> vInsertNewR;
                            vInsertNewR.reserve(6);
                            vInsertNewR.push_back(vOnlyOutTri.back());
                            newCla = nullptr;
                            if (!vInsertNewR.empty()) {
                                //查看是否冗余20170101
                                newCla = new Clause(newClaId, 0);
                                newCla->isAxtom = true;
                                size_t uRsize = vInsertNewR.size();
                                //文字排序
//                                if (uRsize > 1) {
//                                    if (StrategyParam::unitSortRule == 3) {
//                                        stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmpGoalDeepth);
//                                    } else
//                                        stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmp);
//                                }
                                if (uRsize > 1)
                                    stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmp);
                                newCla->LitPtr = new Literal*[uRsize];
                                for (UINT16 i = 0; i < vInsertNewR.size(); ++i) {
                                    Term* litSubT = unify.GetNewTerm(vInsertNewR[i]->subTerm, newCla); //参数1：文字谓词项，参数2：新子句指针
                                    if (TNegEqn == GetCodeProp(litSubT->iTermCode)
                                            && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {
                                        /*
                                        delete(litSubT);*/--uRsize;
                                        //delete(newCla->LitPtr[]);
                                        continue;
                                    }
                                    if (newCla->uFuncDepth < litSubT->uLevel)newCla->uFuncDepth = litSubT->uLevel;
                                    newCla->uVarCount += litSubT->uVarCount;
                                    //添加到文字		
                                    newCla->LitPtr[newCla->uLitNum] = new Literal(litSubT, EncodeLitCode(newClaId, newCla->uLitNum + 1), newCla, nullptr);
                                    newCla->LitPtr[newCla->uLitNum]->parentLitPtr = vInsertNewR[i]; //母式文字，有R产生
                                    //newCla->LitPtr[newCla->uLitNum]->goalDeepth = vInsertNewR[i]->goalDeepth;
                                    //20171020 计算演绎深度
                                    if (newCla ->deduceDeepth < (vInsertNewR[i]->claPtr->deduceDeepth + 1)) {
                                        newCla ->deduceDeepth = vInsertNewR[i]->claPtr->deduceDeepth + 1;
                                    }
                                    if (vInsertNewR[i]->claPtr->isAxtom && newCla->isAxtom)
                                        newCla->isAxtom = true;
                                    else
                                        newCla->isAxtom = false;
                                    if (hasUnifGoalLit(fol, newCla->LitPtr[newCla->uLitNum])) {
                                        newCla->LitPtr[newCla->uLitNum]->goalDeepth = 1;
                                        if (newCla->goaldeepth > 1)
                                            newCla->goaldeepth = 1;
                                    } else {
                                        newCla->LitPtr[newCla->uLitNum]->goalDeepth = vInsertNewR[i]->goalDeepth;
                                        if (newCla->goaldeepth > vInsertNewR[i]->goalDeepth)
                                            newCla->goaldeepth = vInsertNewR[i]->goalDeepth;
                                    }
                                    //cout<<to_string(newCla->uClaId)  + "]" <<"[" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitRow()) + "_" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitCol()) + "]" << newCla->LitPtr[newCla->uLitNum]->subTerm->ToString()<<endl;  
                                    ++(newCla->uLitNum);
                                }
                                //20171020 对子句的含等词的文字进行项序处理
                                if (StrategyParam::termRewriting != 2) {
                                    newCla->directEqn();
                                }
                                //cout<<newCla->LitPtr[0]->subTerm->ToStringBind()<<endl;
                                if (uRsize != 0) {
                                    //20171026 增加归结式复杂度判断
                                    if (newCla->compFuncDeepthCla() > StrategyParam::funcFixDeepth) {
                                        //cout<<"R无效"<<endl;
                                        newCla->DelLits(false);
                                        delete(newCla);
                                        //清除变元合一绑定
                                        if (!unify.vVarBindT.empty())
                                            unify.ClearVarBind(unify.vVarBindT);
                                        //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                        if (!vOnlyOutDect.empty()) {
                                            UINT32 dlen = vOnlyOutDect.size();
                                            for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                                vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                            }
                                        }
                                        //还原vOutTri  vOnlyOutTri
                                        vOnlyOutTri.pop_back();
                                        vOutTri.pop_back();
                                        for (UINT16 m = 0; m < sumDrop; m++) {
                                            vOutTri.pop_back();
                                        }
                                        vInsertNewR.clear();
                                        vector<Literal*>().swap(vInsertNewR);
                                        //20170220 增加候选子句冗余权重
                                        //givenCla->reduntTimes++;
                                        continue;
                                    }
                                    //true 中间归结式冗余判断 false 中间归结式冗余不判断
                                    //                                    if (claHasPureLit(fol, newCla)) {
                                    //                                        //cout<<"R无效"<<endl;
                                    //                                        newCla->DelLits(false);
                                    //                                        delete(newCla);
                                    //                                        //清除变元合一绑定
                                    //                                        if (!unify.vVarBindT.empty())
                                    //                                            unify.ClearVarBind(unify.vVarBindT);
                                    //                                        //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                    //                                        if (!vOnlyOutDect.empty()) {
                                    //                                            UINT32 dlen = vOnlyOutDect.size();
                                    //                                            for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                    //                                                vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                    //                                            }
                                    //                                        }
                                    //                                        //还原vOutTri  vOnlyOutTri
                                    //                                        vOnlyOutTri.pop_back();
                                    //                                        vOutTri.pop_back();
                                    //                                        for (UINT16 m = 0; m < sumDrop; m++) {
                                    //                                            vOutTri.pop_back();
                                    //                                        }
                                    //                                        vInsertNewR.clear();
                                    //                                        vector<Literal*>().swap(vInsertNewR);
                                    //                                        //20170220 增加候选子句冗余权重
                                    //                                        givenCla->reduntTimes++;
                                    //                                        continue;
                                    //                                    }
                                    if (StrategyParam::midRJudge) {
                                        vector<UINT32>invaildLitId; //
                                        invaildLitId.reserve(6);
                                        string rundMsg; //冗余信息
                                        Subsumption subsump; //(MOSTRIGHT)
                                        //参数1 被测的子句指针 参数2 整形数组 参数3 字符串 记录冗余信息
                                        bool isRundacyR = false;
                                        isRundacyR = subsump.GenCla(fol, newCla, invaildLitId, rundMsg);
                                        if (isRundacyR) {
                                            //cout<<"R无效"<<endl;
                                            newCla->DelLits(false);
                                            delete(newCla);
                                            //清除变元合一绑定
                                            if (!unify.vVarBindT.empty())
                                                unify.ClearVarBind(unify.vVarBindT);
                                            //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                            if (!vOnlyOutDect.empty()) {
                                                UINT32 dlen = vOnlyOutDect.size();
                                                for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                                    vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                                }
                                            }
                                            //还原vOutTri  vOnlyOutTri
                                            vOnlyOutTri.pop_back();
                                            vOutTri.pop_back();
                                            for (UINT16 m = 0; m < sumDrop; m++) {
                                                vOutTri.pop_back();
                                            }
                                            vInsertNewR.clear();
                                            vector<Literal*>().swap(vInsertNewR);
                                            //20170220 增加候选子句冗余权重
                                            givenCla->reduntTimes++;
                                            continue;
                                        } else {
                                            FileOp::CreateRunInfoFile(FileOp::runFileId);
                                            chgCla.push_back(newCla);
                                            //20170602 新增输出小三角形路径
                                            if (StrategyParam::divideTri) {
                                                *FileOp::ofRealInfoOut << "从编号为" + to_string(candClaP->uClaId) + "子句开始构建三角形" << endl;
                                                if (candClaP->uLitNum == 1) {
                                                    candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                                                }
                                                givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                                                //输出演绎路径					 
                                                PrintTriPath();
                                                //20171020 对子句的含等词的文字进行项序处理
                                                //                                                if (StrategyParam::termRewriting != 2) {
                                                //                                                    newCla->directEqn();
                                                //                                                }
                                                FileOp::WriteR(newCla);
                                                *FileOp::ofRealInfoOut << "|[Y]" << endl;
                                                //20171024 将中间归结式加入子句集,可以用来减少冗余子句的生成
                                                fol.InsertCla(newCla);
                                                fol.setCla.insert(newCla);
                                                midGenR = true;
                                                if (/*StrategyParam::orForCompition*/true) {
                                                    newCla->addRForCompetiton();
                                                    
                                                    string rStr = "";
                                                    newCla->toString(rStr);
                                                    string outClauses = PrintCompetitionOut(newClaId);
                                                    int begPos = rStr.find_first_of("[") + 1;
                                                    int endPos = rStr.find_first_of("]");
                                                    string rId = rStr.substr(begPos, endPos - begPos);
                                                    string rContext = rStr.substr(rStr.find_first_of("]") + 1);
                                                    string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n" + "   inference(scs_inference,[]," + "[" + outClauses +"]" + ")).";
                                                     
                                                    *FileOp::ofOutput << out << endl;
                                                }
                                                //20171024
                                            }
                                        }
                                    } else {
                                        FileOp::CreateRunInfoFile(FileOp::runFileId);
                                        chgCla.push_back(newCla);
                                        //20170602 新增输出小三角形路径
                                        if (StrategyParam::divideTri) {
                                            *FileOp::ofRealInfoOut << "从编号为" + to_string(candClaP->uClaId) + "子句开始构建三角形" << endl;
                                            if (candClaP->uLitNum == 1) {
                                                candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                                            }
                                            givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                                            //输出演绎路径					 
                                            PrintTriPath();

                                            FileOp::WriteR(newCla);
                                            *FileOp::ofRealInfoOut << "|[Y]" << endl;
                                            //20171024 将中间归结式加入子句集,可以用来减少冗余子句的生成
                                            fol.InsertCla(newCla);
                                            fol.setCla.insert(newCla);
                                            midGenR = true;
                                            if (/*StrategyParam::orForCompition*/true) {
                                                newCla->addRForCompetiton();
                                                
                                                string rStr = "";
                                                newCla->toString(rStr);
                                                string outClauses = PrintCompetitionOut(newClaId);
                                                int begPos = rStr.find_first_of("[") + 1;
                                                int endPos = rStr.find_first_of("]");
                                                string rId = rStr.substr(begPos, endPos - begPos);
                                                string rContext = rStr.substr(rStr.find_first_of("]") + 1);
                                                string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n" + "   inference(scs_inference,[]," + "[" + outClauses +"]" + ")).";
               
                                                *FileOp::ofOutput << out << endl;
                                            }
                                            //20171024
                                        }
                                    }
                                }
                                //string str;
                                //newCla->toString(str);
                                //cout<<"插入中间演绎的单文字子句:" <<str << endl;
                                fol.initGenerateClaAttr(newCla);
                                newClaId++;
                            }
                            vInsertNewR.clear();
                            vector<Literal*>().swap(vInsertNewR);
                        } else {//说明该路径不应该搜索
                            //清除变元合一绑定
                            if (!unify.vVarBindT.empty())
                                unify.ClearVarBind(unify.vVarBindT);
                            //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                            if (!vOnlyOutDect.empty()) {
                                UINT32 dlen = vOnlyOutDect.size();
                                for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                    vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                }
                            }
                            //还原vOutTri  vOnlyOutTri
                            vOnlyOutTri.pop_back();
                            vOutTri.pop_back();
                            for (UINT16 m = 0; m < sumDrop; m++) {
                                vOutTri.pop_back();
                            }
                            givenCla->reduntTimes++;
                        }
                    }//20170816 保存生成的非单元子句
                    else if (count > 0 && vNewR.size() > 0 && !findOnlyOut && StrategyParam::midR) {
                        //新建子句,生成单文字子句,最后加入到单文字子句列表中
                        //Literal* tempptr = vOnlyOutTri.back(); 
                        bool flagT = true;
                        vector<Literal*> vInsertNewR;
                        vInsertNewR.reserve(6);
                        vInsertNewR.push_back(vOnlyOutTri.back());
                        
                        for (int i = 0; i < vNewR.size(); i++) {
                            vInsertNewR.push_back(vNewR[i]);
                        }
                        
                        // 此处判断是否有冗余的R 文字,即由该子句对角线文字没有互补对的文字存在与矛盾体中
                        vector<Clause*> discardClas;
                        discardClas.reserve(8);
                        if(StrategyParam::litRundent){
//                            if((newClaId == 1017) &&(vOnlyOutTri.back()->claPtr->uClaId == 11)){
//                                cout<<"debug"<<endl;
//                            }
                            for(int i=0; i < vInsertNewR.size(); ++i){
                                UINT16 countPair = 0;
                                Clause *findCla = vInsertNewR[i]->claPtr;
                                if(findCla == vOutTri.back()->claPtr)
                                    continue;
                                for(int j = 0; j < findCla->uLitNum; ++j){
                                    if(find(vOnlyOutTri.begin(),vOnlyOutTri.end(),findCla->LitPtr[j]) != vOnlyOutTri.end()){//找到对角线文字,查看互补对
                                        for(int k=0; k < vOutTri.size(); ++k){
//                                             if ((findCla->uClaId == 32)&&(vOutTri[k]->claPtr->uClaId == 11)) {
//                                                cout << vOutTri[k]->subTerm->ToStringBind() <<endl;
//                                                cout << findCla->LitPtr[j]->subTerm->ToStringBind() <<endl; 
//                                            }
                                            if((findCla->LitPtr[j]->isPairPred(vOutTri[k])) && (unify.CheckPairEqn(findCla->LitPtr[j]->subTerm, vOutTri[k]->subTerm))){
                                                ++countPair;
                                                break;
                                            }
                                        }                                       
                                    }
                                }
                                if(countPair == 0){//表示对角线没有互补对
                                    if(find(discardClas.begin(),discardClas.end(),vInsertNewR[i]->claPtr) == discardClas.end()){
                                        discardClas.push_back(vInsertNewR[i]->claPtr);
                                    }
                                    swap(vInsertNewR[i],vInsertNewR[vInsertNewR.size()-1]);
                                    vInsertNewR.pop_back();
                                    --i;
                                }
                            }
                        }                                           
                        //end
                        
                        for (size_t rInd = 0; rInd < vInsertNewR.size() - 1; ++rInd) {
                            Literal* rA = vInsertNewR[rInd];
                            for (size_t rIndB = rInd + 1; rIndB < vInsertNewR.size();) {
                                Literal* rB = vInsertNewR[rIndB];
                                if (rA->subTerm->iTermCode == rB->subTerm->iTermCode && unify.CheckEqn(rA->subTerm, rB->subTerm)) {
                                    swap(vInsertNewR[rIndB], vInsertNewR[vInsertNewR.size() - 1]);
                                    vInsertNewR.pop_back();
                                } else
                                    ++rIndB;
                            }
                        }
                        if (vInsertNewR.size() > StrategyParam::midR)
                            flagT = false;
                        if (flagT) {
                            newCla = nullptr;
                            if (!vInsertNewR.empty()) {
                                //查看是否冗余20170101
                                newCla = new Clause(newClaId, 0);
                                newCla->isAxtom = true;
                                size_t uRsize = vInsertNewR.size();
//                                cout<<"uRsize:"<<uRsize<<"  "<<"newClaId:"<< newClaId <<endl;
//                                if((uRsize == 2) && (newClaId == 7689)){
//                                    cout<<"debug"<<endl;
//                                }
                                //文字排序
//                                if (uRsize > 1)
//                                    if (StrategyParam::unitSortRule == 3) {
//                                        stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmpGoalDeepth);
//                                    } else
//                                        stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmp);
                                if (uRsize > 1)
                                    stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmp);
                                newCla->LitPtr = new Literal*[uRsize];
                                for (UINT16 i = 0; i < vInsertNewR.size(); ++i) {
                                    Term* litSubT = unify.GetNewTerm(vInsertNewR[i]->subTerm, newCla); //参数1：文字谓词项，参数2：新子句指针
                                    if (TNegEqn == GetCodeProp(litSubT->iTermCode)
                                            && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {
                                        /*
                                        delete(litSubT);*/--uRsize;
                                        //delete(newCla->LitPtr[]);
                                        continue;
                                    }
                                    if (newCla->uFuncDepth < litSubT->uLevel)newCla->uFuncDepth = litSubT->uLevel;
                                    newCla->uVarCount += litSubT->uVarCount;
                                    //添加到文字		
                                    newCla->LitPtr[newCla->uLitNum] = new Literal(litSubT, EncodeLitCode(newClaId, newCla->uLitNum + 1), newCla, nullptr);
                                    newCla->LitPtr[newCla->uLitNum]->parentLitPtr = vInsertNewR[i]; //母式文字，有R产生
                                    //newCla->LitPtr[newCla->uLitNum]->goalDeepth = vInsertNewR[i]->goalDeepth;
                                    //20171020 计算演绎深度
                                    if (newCla ->deduceDeepth < (vInsertNewR[i]->claPtr->deduceDeepth + 1)) {
                                        newCla ->deduceDeepth = vInsertNewR[i]->claPtr->deduceDeepth + 1;
                                    }
                                    if (vInsertNewR[i]->claPtr->isAxtom && newCla->isAxtom)
                                        newCla->isAxtom = true;
                                    else
                                        newCla->isAxtom = false;
                                    if (hasUnifGoalLit(fol, newCla->LitPtr[newCla->uLitNum])) {
                                        newCla->LitPtr[newCla->uLitNum]->goalDeepth = 1;
                                        if (newCla->goaldeepth > 1)
                                            newCla->goaldeepth = 1;
                                    } else {
                                        newCla->LitPtr[newCla->uLitNum]->goalDeepth = vInsertNewR[i]->goalDeepth;
                                        if (newCla->goaldeepth > vInsertNewR[i]->goalDeepth)
                                            newCla->goaldeepth = vInsertNewR[i]->goalDeepth;
                                    }
                                    //cout<<to_string(newCla->uClaId)  + "]" <<"[" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitRow()) + "_" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitCol()) + "]" << newCla->LitPtr[newCla->uLitNum]->subTerm->ToString()<<endl;  
                                    ++(newCla->uLitNum);
                                }
//                                 if (newCla->uLitNum == 0) {
//                                    cout << "error" << endl;
//                                }
                                //20171020 对子句的含等词的文字进行项序处理
                                if (StrategyParam::termRewriting != 2) {
                                    newCla->directEqn();
                                }
                                //cout<<newCla->LitPtr[0]->subTerm->ToStringBind()<<endl;
                                if (uRsize != 0) {
                                    //20171026 增加归结式复杂度判断
                                    if (newCla->compFuncDeepthCla() > StrategyParam::funcFixDeepth) {
                                        //cout<<"R无效"<<endl;
                                        newCla->DelLits(false);
                                        delete(newCla);
                                        //20170818 需要还原vNewR 此次演绎改变了什么 
                                        //清除变元合一绑定
                                        if (!unify.vVarBindT.empty())
                                            unify.ClearVarBind(unify.vVarBindT);
                                        //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                        if (!vOnlyOutDect.empty()) {
                                            UINT32 dlen = vOnlyOutDect.size();
                                            for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                                vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                            }
                                        }
                                        //还原vOutTri  vOnlyOutTri
                                        vOnlyOutTri.pop_back();
                                        int incOutTriSize = vOutTri.size() - lastvOutTriSize;
                                        for (UINT16 m = 0; m < incOutTriSize; m++) {
                                            vOutTri.pop_back();
                                        }
                                        //还原归结式
                                        int incRSize = vNewR.size() - lastRSize;
                                        for (UINT16 m = 0; m < incRSize; m++) {
                                            count--;
                                            vNewR.pop_back();
                                        }
                                        vInsertNewR.clear();
                                        vector<Literal*>().swap(vInsertNewR);
                                        //20170220 增加候选子句冗余权重
                                        //candClaP->reduntTimes++;
                                        continue;
                                    }
                                    //true 中间归结式冗余判断 false 中间归结式冗余不判断
                                    //                                    if (claHasPureLit(fol, newCla)) {
                                    //                                        //cout<<"R无效"<<endl;
                                    //                                        newCla->DelLits(false);
                                    //                                        delete(newCla);
                                    //                                        //20170818 需要还原vNewR 此次演绎改变了什么 
                                    //                                        //清除变元合一绑定
                                    //                                        if (!unify.vVarBindT.empty())
                                    //                                            unify.ClearVarBind(unify.vVarBindT);
                                    //                                        //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                    //                                        if (!vOnlyOutDect.empty()) {
                                    //                                            UINT32 dlen = vOnlyOutDect.size();
                                    //                                            for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                    //                                                vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                    //                                            }
                                    //                                        }
                                    //                                        //还原vOutTri  vOnlyOutTri
                                    //                                        vOnlyOutTri.pop_back();
                                    //                                        int incOutTriSize = vOutTri.size() - lastvOutTriSize;
                                    //                                        for (UINT16 m = 0; m < incOutTriSize; m++) {
                                    //                                            vOutTri.pop_back();
                                    //                                        }
                                    //                                        //还原归结式
                                    //                                        int incRSize = vNewR.size() - lastRSize;
                                    //                                        for (UINT16 m = 0; m < incRSize; m++) {
                                    //                                            count--;
                                    //                                            vNewR.pop_back();
                                    //                                        }
                                    //                                        vInsertNewR.clear();
                                    //                                        vector<Literal*>().swap(vInsertNewR);
                                    //                                        //20170220 增加候选子句冗余权重
                                    //                                        candClaP->reduntTimes++;
                                    //                                        continue;
                                    //                                    }
                                    if (StrategyParam::midRJudge) {
                                        vector<UINT32>invaildLitId; //
                                        invaildLitId.reserve(6);
                                        string rundMsg; //冗余信息
                                        Subsumption subsump; //(MOSTRIGHT)
                                        //参数1 被测的子句指针 参数2 整形数组 参数3 字符串 记录冗余信息
                                        bool isRundacyR = false;
                                        isRundacyR = subsump.GenCla(fol, newCla, invaildLitId, rundMsg);
                                        if (isRundacyR) {
                                            //cout<<"R无效"<<endl;
                                            newCla->DelLits(false);
                                            delete(newCla);
                                            //20170818 需要还原vNewR 此次演绎改变了什么 
                                            //清除变元合一绑定
                                            if (!unify.vVarBindT.empty())
                                                unify.ClearVarBind(unify.vVarBindT);
                                            //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                            if (!vOnlyOutDect.empty()) {
                                                UINT32 dlen = vOnlyOutDect.size();
                                                for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                                    vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                                }
                                            }
                                            //还原vOutTri  vOnlyOutTri
                                            vOnlyOutTri.pop_back();
                                            int incOutTriSize = vOutTri.size() - lastvOutTriSize;
                                            for (UINT16 m = 0; m < incOutTriSize; m++) {
                                                vOutTri.pop_back();
                                            }
                                            //还原归结式
                                            int incRSize = vNewR.size() - lastRSize;
                                            for (UINT16 m = 0; m < incRSize; m++) {
                                                count--;
                                                vNewR.pop_back();
                                            }
                                            vInsertNewR.clear();
                                            vector<Literal*>().swap(vInsertNewR);
                                            //20170220 增加候选子句冗余权重
                                            candClaP->reduntTimes++;
                                            continue;
                                        } else {
                                            FileOp::CreateRunInfoFile(FileOp::runFileId);
                                            chgCla.push_back(newCla);
                                            //20170602 新增输出小三角形路径
                                            if (StrategyParam::divideTri) {
                                                *FileOp::ofRealInfoOut << "从编号为" + to_string(candClaP->uClaId) + "子句开始构建三角形" << endl;
                                                if (candClaP->uLitNum == 1) {
                                                    candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                                                }
                                                givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                                                //输出演绎路径
                                                if(discardClas.empty() == false){
                                                    for(int aa= 0; aa<discardClas.size(); ++aa){
                                                        discardClas[aa]->isSDeduct = false;
                                                    }
                                                }
                                                PrintTriPath();
                                                if(discardClas.empty() == false){
                                                    for(int aa= 0; aa<discardClas.size(); ++aa){
                                                        discardClas[aa]->isSDeduct = true;
                                                    }
                                                }
                                                vector<Clause*>().swap(discardClas);
                                                FileOp::WriteR(newCla);
                                                *FileOp::ofRealInfoOut << "|[Y]" << endl;
                                                //20171024 将中间归结式加入子句集,可以用来减少冗余子句的生成
                                                fol.InsertCla(newCla);
                                                fol.setCla.insert(newCla);
                                                midGenR = true;
                                                if (/*StrategyParam::orForCompition*/true) {
                                                    newCla->addRForCompetiton();
                                                    
                                                    string rStr = "";
                                                    newCla->toString(rStr);
                                                    string outClauses = PrintCompetitionOut(newClaId);
                                                    int begPos = rStr.find_first_of("[") + 1;
                                                    int endPos = rStr.find_first_of("]");
                                                    string rId = rStr.substr(begPos, endPos - begPos);
                                                    string rContext = rStr.substr(rStr.find_first_of("]") + 1);
                                                    string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n" + "   inference(scs_inference,[]," + "[" + outClauses +"]" + ")).";
                                                    *FileOp::ofOutput << out << endl;
                                                }
                                                //20171024
                                            }
                                        }
                                    } else {
                                        FileOp::CreateRunInfoFile(FileOp::runFileId);
                                        chgCla.push_back(newCla);
                                        //20170602 新增输出小三角形路径
                                        if (StrategyParam::divideTri) {
                                            *FileOp::ofRealInfoOut << "从编号为" + to_string(candClaP->uClaId) + "子句开始构建三角形" << endl;
                                            if (candClaP->uLitNum == 1) {
                                                candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                                            }
                                            givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                                            //输出演绎路径	
                                            if(discardClas.empty() == false){
                                                    for(int aa= 0; aa<discardClas.size(); ++aa){
                                                        discardClas[aa]->isSDeduct = false;
                                                    }
                                                }
                                            PrintTriPath();
                                            if(discardClas.empty() == false){
                                                    for(int aa= 0; aa<discardClas.size(); ++aa){
                                                        discardClas[aa]->isSDeduct = true;
                                                    }
                                                }
                                            vector<Clause*>().swap(discardClas);
                                            //20171020 对子句的含等词的文字进行项序处理
                                            //                                            if (StrategyParam::termRewriting != 2) {
                                            //                                                newCla->directEqn();
                                            //                                            }
                                            FileOp::WriteR(newCla);
                                            *FileOp::ofRealInfoOut << "|[Y]" << endl;
                                            //20171024 将中间归结式加入子句集,可以用来减少冗余子句的生成
                                            fol.InsertCla(newCla);
                                            fol.setCla.insert(newCla);
                                            midGenR = true;
                                            if (/*StrategyParam::orForCompition*/true) {
                                                newCla->addRForCompetiton();
                                                
                                                string rStr = "";
                                                newCla->toString(rStr);
                                                string outClauses = PrintCompetitionOut(newClaId);
                                                int begPos = rStr.find_first_of("[") + 1;
                                                int endPos = rStr.find_first_of("]");
                                                string rId = rStr.substr(begPos, endPos - begPos);
                                                string rContext = rStr.substr(rStr.find_first_of("]") + 1);
                                                string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n" + "   inference(scs_inference,[]," + "[" + outClauses +"]" + ")).";
                                                *FileOp::ofOutput << out << endl;
                                            }
                                            //20171024
                                        }
                                    }
                                }
                                //string str;
                                //newCla->toString(str);
                                //cout<<"插入中间演绎的单文字子句:" <<str << endl;
                                fol.initGenerateClaAttr(newCla);
                                newClaId++;
                            }

                        }
                        vInsertNewR.clear();
                        vector<Literal*>().swap(vInsertNewR);
                    }
                    //20170215 保存每次子句演绎的互补对单元子句
                    claPair.clear();
                    claPair.push_back(QLit);
                    //20170215需要为参与本单元的三角形演绎单元子句设置权重
                    if (!vOnlyDectNum.empty()) {
                        for (UINT8 nm = 0; nm < vOnlyDectNum.size(); nm++) {
                            claPair.push_back(vOnlyDectNum[nm]);
                            if (vOnlyDectNum[nm]->claPtr->uLitNum == 1)
                                vOnlyDectNum[nm]->claPtr->adeductNum++; //单元子句权重加1
                        }
                    }
                    if (candClaP->uLitNum == 1) {
                        candClaP->adeductNum++; //主动归结次数+1
                        candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                    }
                    
                    QLit->sDuct = QLit->sDuct + 10; //候选文字权重加一 须重新文字排序 first-> QLit->sDuct++
                    if(QLit->sDuct == 10000)
                        QLit->sDuct = 0;
                    //2020:repaired
                    if(givenCla->isAxtom == false)
                        givenCla->pdeductNum += 1/*resRandomNumber(total_Loop)*/; //total_Loop 怎么得到
                    else{
                        if(StrategyParam::equalityUsedFrq == 0)
                            givenCla->pdeductNum += 5/*resRandomNumber(total_Loop) + total_Loop/2*/; //total_Loop 怎么得到
                        else if(StrategyParam::equalityUsedFrq == 1)
                            givenCla->pdeductNum += resRandomNumber(total_Loop) + total_Loop/50; //total_Loop 怎么得到
                        else if(StrategyParam::equalityUsedFrq == 2)
                            givenCla->pdeductNum += resRandomNumber(total_Loop); //total_Loop 怎么得到
                    }
                    givenCla->isSDeduct = true; //在构建三角形过程中参与归结
//                    if(newCla->uLitNum == 0){
//                        cout<<"error"<<endl;
//                    }
                    //20171022 拷贝已使用的子句,以达到重复使用子句的目的
                    //如果演绎的不是上次拷贝的子句,则需要将其删除
                    //                    if((lastDeductCla != nullptr) &&(givenCla != lastDeductCla)){//说明拷贝的子句没有用上
                    //                        //在演绎子句列表中清除lastDeductCla
                    //                        vector<Clause*>::iterator delInd = find(candidateClaSet.begin(),candidateClaSet.end(),lastDeductCla);
                    //                        candidateClaSet.erase(delInd);
                    //                        //在拷贝的子句列表中清除lastDeductCla
                    //                        lastDeductCla->DelLits(false);
                    //                        delete(lastDeductCla);
                    //                    }
                    //if (StrategyParam::useCpUintCla) {//拷贝单元子句
                    if (1) {//拷贝单元子句
                        if ((candClaP->uLitNum == 1) && candClaP->HasTermBind()) {
                            //拷贝新的子句来使用
                            unify.copyUintCla(fol, candClaP, newClaId);
                            hasCpUintClaId.insert(candClaP->uClaId);
                        }
                        if (vOnlyDectNum.size() > 0) {
                            for (UINT16 s = 0; s < vOnlyDectNum.size(); ++s) {
                                if ((vOnlyDectNum[s]->claPtr->uLitNum == 1) && vOnlyDectNum[s]->claPtr->HasTermBind()) {
                                    //拷贝新的子句来使用
                                    unify.copyUintCla(fol, vOnlyDectNum[s]->claPtr, newClaId);
                                    hasCpUintClaId.insert(vOnlyDectNum[s]->claPtr->uClaId);
                                }
                            }
                        }
                    }
                    
                    //if (midGenR && (StrategyParam::claReUseTimes != 0) && (givenCla->HasTermBind())) {
                    if (midGenR && (givenCla->HasTermBind())&& (givenCla->isAxtom == false)) {//2020:repaired
                        Clause* cpClaTmp = nullptr;
                        if (givenCla->topCopyCla == nullptr)
                            cpClaTmp = givenCla;
                        else
                            cpClaTmp = givenCla->topCopyCla;
                        //if (copyClaCopyTimes(cpClaTmp) < StrategyParam::claReUseTimes) {
                        if (1) {
                            Clause* cyCla = copyCla(fol, cpClaTmp, newClaId, candLitP, QLit);
                            cyCla->topCopyCla = cpClaTmp;
                            lastDeductCla = cyCla;
                            //插入到演绎子句列表中
                            if (!combineFlag) {
                                vector<Clause*>::iterator insertInd = find(candidateClaSet.begin(), candidateClaSet.end(), givenCla);
                                candidateClaSet.insert(insertInd + 1, cyCla);
                                midGenR = false;
                            }                                //插入到演绎子句列表中
                            else {
                                vector<Clause*>::iterator insertInd = find(chooseClaSet.begin(), chooseClaSet.end(), givenCla);
                                chooseClaSet.insert(insertInd + 1, cyCla);
                                midGenR = false;
                            }
                        }

                    }

                    //20171022 end

                    setRedundClaId.insert(givenCla->uClaId); //用于本次三角形不在使用已经归结过的子句
                    if (RULEOK == unifResult) {
                        isDeduct = true;
                        isGloDeduct = true;
                    }
                    //20170828 增加R文字数限制,即当vNewR.size() 大于文字数限制 则要退出
                    //20170215 子句全部落入三角形下方 需要结束三角形演绎 并判断是否能得出结论
                    if (findOnlyOut && (vNewR.size() != 0))
                        break;
                    //20170828 增加R文字数限制,即当vNewR.size() 大于文字数限制 则要退出
                    if ((vNewR.size() >= StrategyParam::R_MAX_NUM) || ((StrategyParam::R_INIT_MAX_NUM == givenCla->uLitNum)&&(givenCla->uLitNum > 10))) {
                        break;
                    }
                    //end
                    //0:深度优先 1:宽深结合 2:宽度优先
                    if (StrategyParam::widthDeep == 0) {
                        break;
                    } else if (StrategyParam::widthDeep == 1) {
                        break;
                    } else
                        break;
                } else {
                    //清除合一规则检查失败时，被置为isSdeduct为true的子句
                    if (!vOnlyOutDect.empty()) {
                        UINT32 dlen = vOnlyOutDect.size();
                        for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                            vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                        }
                    }
                }
            }//20170210 候选子句外循环  找互补对外循环体
            //20171026 应该要遍历所有的文字
            if (isDeduct)
                break;
            else{//20190516 add
                if((FileOp::strategyMode == 3) || (FileOp::strategyMode == 4)){
                    ;
                }
                else{
                    ActLitInd = ActLitInd + givenCla->uLitNum;
                }
                QLit->sDuct++; //候选文字权重加一 须重新文字排序 first-> QLit->sDuct++
                if(QLit->sDuct == 10000)//2020:repaired
                    QLit->sDuct = 0;
            }
            //只找到一次候选文字，不管有没有都退出，后期可以把深入做大
            //break;
        }//20170210 主动子句外循环
        //20170828 增加R文字数限制,即当vNewR.size() 大于文字数限制 则要退出
        if ((vNewR.size() >= StrategyParam::R_MAX_NUM) || (isDeduct && (StrategyParam::R_INIT_MAX_NUM == candClaP->uLitNum)&&(candClaP->uLitNum > 10))) {
            break;
        }
        //end
        //继续下一个合一配对
        ResClaID.insert(givenCla->uClaId);
        ResClaPtr.push_back(givenCla);
//#define cprover_fast5
#ifndef cprover_fast5
        if (combineFlag) {
            if (20180101) {
                if (((cDeepth == (chooseClaSet.size() - 1)) || (cDeepth == StrategyParam::deductDeep)) && oneRunFlag) {
                    cDeepth = -1;
                    oneRunFlag = false;
                    genUintRFirst = false;
                }                    //20180914
                else if (((cDeepth == (chooseClaSet.size() - 1)) || (cDeepth == StrategyParam::deductDeep)) && !oneRunFlag && !genUintRFirst && twoRunFlag) {
                    cDeepth = -1;
                    twoRunFlag = false;
                    genUintRSecond = false;
                }
            }
#endif
            cDeepth++;
            if (cDeepth >= chooseClaSet.size()) {
                cDeepth = chooseClaSet.size();
                cLongth++;
            }
            //为-1时，系统自动处理；为大于0时设置值有效；
            if (cDeepth == StrategyParam::deductDeep) {
                if (isGloDeduct) {
                    break;
                } else {
                    allNoPair = true;
                    return 222;
                }
            }
            if ((cDeepth == chooseClaSet.size()) && (cLongth == candidateClaSet.size())) {
                if (isGloDeduct) {
                    break;
                } else {//所有的单元子句都找不到互补对有效子句
                    allNoPair = true;
                    return 22;
                }
            }
            //控制三角形演绎子句的总长度
            //        if (setRedundClaId.size() > 160) {
            //            if (isGloDeduct) {
            //                break;
            //            } else {//所有的单元子句都找不到互补对有效子句
            //                allNoPair = true;
            //                return 22;
            //            }
            //        }
            clock_t end = clock();
            double time_s = (double) (end - StrategyParam::start) / (double) CLOCKS_PER_SEC;
            StrategyParam::timeLimit = StrategyParam::firstTimeLimit;
            if (time_s > StrategyParam::timeLimit * 60)//200   3  1分钟 15  5分钟   30  15分钟  end:300
            {
                if (isGloDeduct) {
                    break;
                } else {//所有的单元子句都找不到互补对有效子句
                    allNoPair = true;
                    return 22;
                }
            }
            //考虑情况：配对子句已全部落入三角形内，但是之前有R剩余，此时停止构建三角形
            //       if ((findOnlyOut && (vNewR.size() != 0)) || cDeepth == vOnlyOutTri.size()) {
            //           if (findOnlyOut && (vNewR.size() != 0)) {
            //                //cout << "找到所有互补对单R不为空" << endl;
            //                if (!claPair.empty()) {
            //                    UINT32 lengthA = -2;
            //                    vector <Literal*>::iterator ie;
            //                    for (UINT8 lab = 0; lab < claPair.size(); lab++) {
            //                        ie = find(vOnlyOutTri.begin(), vOnlyOutTri.end(), claPair[lab]);
            //                        if (distance(vOnlyOutTri.begin(), ie) > lengthA)
            //                            lengthA = distance(vOnlyOutTri.begin(), ie);
            //                    }
            //                    ie = find(vOnlyOutTri.begin(), vOnlyOutTri.end(), firstR);
            //                    if (distance(vOnlyOutTri.begin(), ie) > lengthA) {
            //                        newCla = nullptr;
            //                        cout << "得出结论:不可满足" << endl;
            //                        return true;
            //                    }
            //                }
            //            }
            //             break;
            //        }
            givenCla = chooseClaSet[cDeepth];
        } else {
            if (20180101) {
                if (((cLongth == (candidateClaSet.size() - 1)) || (cLongth == StrategyParam::deductDeep)) && oneRunFlag) {
                    cLongth = -1;
                    oneRunFlag = false;
                    genUintRFirst = false;
                }                    //20180914
                else if (((cLongth == (candidateClaSet.size() - 1)) || (cLongth == StrategyParam::deductDeep)) && !oneRunFlag && !genUintRFirst && twoRunFlag) {
                    cLongth = -1;
                    twoRunFlag = false;
                    genUintRSecond = false;
                }
            }

            cLongth++;
            //为-1时，系统自动处理；为大于0时设置值有效；
            if (cLongth == StrategyParam::deductDeep) {
                if (isGloDeduct) {
                    break;
                } else {
                    allNoPair = true;
                    return 222;
                }
            }
            if (cLongth == candidateClaSet.size()) {
                if (isGloDeduct) {
                    break;
                } else {//所有的单元子句都找不到互补对有效子句
                    allNoPair = true;
                    return 22;
                }
            }
            //控制三角形演绎子句的总长度
            //        if (setRedundClaId.size() > 160) {
            //            if (isGloDeduct) {
            //                break;
            //            } else {//所有的单元子句都找不到互补对有效子句
            //                allNoPair = true;
            //                return 22;
            //            }
            //        }
            clock_t end = clock();
            double time_s = (double) (end - StrategyParam::start) / (double) CLOCKS_PER_SEC;
            StrategyParam::timeLimit = StrategyParam::firstTimeLimit;
            if (time_s > StrategyParam::timeLimit * 60)//200   3  1分钟 15  5分钟   30  15分钟  end:300
            {
                if (isGloDeduct) {
                    break;
                } else {//所有的单元子句都找不到互补对有效子句
                    allNoPair = true;
                    return 22;
                }
            }
            givenCla = candidateClaSet[cLongth];
        }
        //string str;
        //givenCla->toString(str);
        //cout << str << endl;
    }//20170210 构建三角形结束外循环
    //生成新子句(R) 并输出演绎结果中
    newCla = nullptr;
    //20170215 用于判断最后的收尾归结子句全部落在三角形内的情况 但R不为空 
    assert(!(findOnlyOut && (vNewR.size() == 0)));
    if (!findOnlyOut) //20170215 end
    {
        vNewR.push_back(vOnlyOutTri.back());
        //vOnlyOutTri.pop_back();
    }
    //20170214 若所有的主对角线文字都没有找到满足条件互补的子句，则不输出R
    if ((vNewR.size() == 1)&&(chgCla.size() == 0)&&(find(vOnlyOutTriCmp.begin(), vOnlyOutTriCmp.end(), vNewR[0]) != vOnlyOutTriCmp.end())) {
        allNoPair = true;
        return 22;
    }
    
      // 此处判断是否有冗余的R 文字,即由该子句对角线文字没有互补对的文字存在与矛盾体中
    if (StrategyParam::litRundent) {
        for (int i = 0; i < vNewR.size(); ++i) {
            UINT16 countPair = 0;
            Clause *findCla = vNewR[i]->claPtr;
            if(findCla == vOutTri.back()->claPtr)
                continue;
            for (int j = 0; j < findCla->uLitNum; ++j) {
                if (find(vOnlyOutTri.begin(), vOnlyOutTri.end(), findCla->LitPtr[j]) != vOnlyOutTri.end()) {//找到对角线文字,查看互补对
                    for (int k = 0; k < vOutTri.size(); ++k) {
                        if ((findCla->LitPtr[j]->isPairPred(vOutTri[k])) && (unify.CheckPairEqn(findCla->LitPtr[j]->subTerm, vOutTri[k]->subTerm))) {
                            ++countPair;
                            break;
                        }
                    }
                }
            }
            if (countPair == 0) {//表示对角线没有互补对
                vNewR[i]->claPtr->isSDeduct = false;
                swap(vNewR[i], vNewR[vNewR.size() - 1]);
                vNewR.pop_back();
                --i;
                
            }
        }
    }
    
    //检查R是否有相同的合并
    for (size_t rInd = 0; rInd < vNewR.size() - 1; ++rInd) {
        Literal* rA = vNewR[rInd];
        for (size_t rIndB = rInd + 1; rIndB < vNewR.size();) {
            Literal* rB = vNewR[rIndB];
            if (rA->subTerm->iTermCode == rB->subTerm->iTermCode && unify.CheckEqn(rA->subTerm, rB->subTerm)) {
                swap(vNewR[rIndB], vNewR[vNewR.size() - 1]);
                vNewR.pop_back();
            } else
                ++rIndB;
        }
    }

  
    
    assert(vNewR.size() != 0); //20170211 考虑是否此处有R为0
    newCla = new Clause(newClaId, 0);
    newCla->isAxtom = true;
    size_t uRsize = vNewR.size();
    //文字排序
    if (uRsize > 1)
        stable_sort(vNewR.begin(), vNewR.end(), SortRule::LitCmp);
    newCla->LitPtr = new Literal*[uRsize];
    for (UINT16 i = 0; i < vNewR.size(); ++i) {
        Term* litSubT = unify.GetNewTerm(vNewR[i]->subTerm, newCla); //参数1：文字谓词项，参数2：新子句指针
        if (TNegEqn == GetCodeProp(litSubT->iTermCode)
                && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {//出现有剩余文字仍为不可满足的清空，需要考虑这种清空 20170108
            /*
            delete(litSubT);*/--uRsize;
            //delete(newCla->LitPtr[]);
            continue;
        }
        if (newCla->uFuncDepth < litSubT->uLevel)newCla->uFuncDepth = litSubT->uLevel;
        newCla->uVarCount += litSubT->uVarCount;
        //添加到文字		
        newCla->LitPtr[newCla->uLitNum] = new Literal(litSubT, EncodeLitCode(newClaId, newCla->uLitNum + 1), newCla, nullptr);
        newCla->LitPtr[newCla->uLitNum]->parentLitPtr = vNewR[i]; //母式文字，有R产生
        //newCla->LitPtr[newCla->uLitNum]->goalDeepth = vNewR[i]->goalDeepth;
        //20171020 计算演绎深度
        if (newCla ->deduceDeepth < (vNewR[i]->claPtr->deduceDeepth + 1)) {
            newCla ->deduceDeepth = vNewR[i]->claPtr->deduceDeepth + 1;
        }
        if (vNewR[i]->claPtr->isAxtom && newCla->isAxtom)
            newCla->isAxtom = true;
        else
            newCla->isAxtom = false;
        if (hasUnifGoalLit(fol, newCla->LitPtr[newCla->uLitNum])) {
            newCla->LitPtr[newCla->uLitNum]->goalDeepth = 1;
            if (newCla->goaldeepth > 1)
                newCla->goaldeepth = 1;
        } else {
            newCla->LitPtr[newCla->uLitNum]->goalDeepth = vNewR[i]->goalDeepth;
            if (newCla->goaldeepth > vNewR[i]->goalDeepth)
                newCla->goaldeepth = vNewR[i]->goalDeepth;
        }
        ++(newCla->uLitNum);
    }
    fol.initGenerateClaAttr(newCla);
    newClaId++;
    //string str;
    //newCla->toString(str);
    //cout<<"R:" << str << endl;
    return 221;
}

//the second framework of combined system
UINT8 TriAlg::GenerateTriByRecodePathLRCombined2(Formula& fol, vector<Clause*>& candidateClaSet, UINT32 &newClaId, BACKTYPE _backType, vector<Clause*> &chgCla, UINT16& loop_Num) {
    if (_backType == NOBACK)//清除变量
    {
        //assert(!(givenCla == nullptr));
        //初始化		
        PreResLit = nullptr; //上轮找到的合一文字
        setRedundClaId.clear(); //记录参与演绎的子句
        setRealRedundClaId.clear(); //记录冗余的子句
        hasCpUintClaId.clear();
        setRealRedundClaId.reserve(8);
        vector<Literal*>().swap(vNewR);
        vNewR.reserve(8);
        vector<UINT16>().swap(vComparePos);
        ResClaID.clear();
        //ResClaID.insert(givenCla->uClaId); //记录第一个归结子句编号
        vector<Clause*>().swap(ResClaPtr);
        //ResClaPtr.push_back(givenCla); //记录第一个归结子句指针
        BackPathClear(); //重要：清除路径以及上轮归结中变元的绑定 
        //stackVarChg.reserve(16);
        //noCmpCla.clear();
        stackVarChg.reserve(100);
    }
    bool creatFlag = true;
    Clause* givenCla = nullptr;
    RESULT unifResult; //是否合一
    bool isDeduct = false; //是否发生过归结
    bool isGloDeduct = false; //是否发生过归结
    Clause* candClaP = nullptr; // 被动归结子句（候选子句）
    Literal* candLitP = nullptr; //被动归结文字（候选文字）
    vector<Literal*>* vCandLit = &vOnlyOutTri; //取相同文字的map集合
    INT32 cDeepth = 0; //演绎深度
    INT32 cLongth = 0;
    UINT8 count = 0;
    Literal * lastTrip = nullptr;
    bool findOnlyOut = false; //用于控制子句的文字三角形摆放
    bool first_RLit = true; //记录第一次剩余的R
    Clause* lastDeductCla = nullptr;
    Clause* first_Given = candidateClaSet[0];
    bool midGenR = false; //用于限制只有在生成了中间归结式的过程中拷贝演绎子句,否则R文字数会很大
    bool oneRunFlag = true;
    bool twoRunFlag = true;
    bool genUintRFirst = true;
    bool genUintRSecond = true;
    UINT32 lastMainDiagonalInd = 0;
    
    vector<Clause*> chooseClaSet;
    chooseClaSet.reserve(16);
    //20170821 针对构建三角形过程中出现的冗余子句,其权重修改为加随机数,这样可以使得下次做的三角形不一样.
    if (StrategyParam::useRandrom)
        srand((unsigned int) time(nullptr));
    int eRun = 0;
    bool combineFlag = true;
    while (1) {
        givenCla = candidateClaSet[cLongth];     
        if(givenCla->clast != CopyTemp)
            stable_sort(givenCla->LitPtr, givenCla->LitPtr + givenCla->uLitNum, SortRule::ActlitCmp);
        UINT16 ActLitInd = 0;
        for (; ActLitInd < givenCla->uLitNum; ++ActLitInd) {//ActLitInd = ActLitInd + givenCla->uLitNum
            isDeduct = false;
            Literal* QLit = givenCla->LitPtr[ActLitInd];
            //根据文字互补谓词项对应的互补文字得到候选文字
            //            vCandLitAll = QLit->getPairPredLst();
            //            //提取单元子句序列
            //            if(vCandLitAll->size() == 0)
            //                continue;
            //            for(UINT32 i=0; i< vCandLitAll->size(); ++i){
            //                if(vCandLitAll->at(i)->claPtr->uLitNum == 1){
            //                    vCandLit.push_back(vCandLitAll->at(i));
            //                }
            //            }
            //            stable_sort(vCandLit.begin(), vCandLit.end(), SortRule::claSingCmp);

            //stable_sort(vCandLit->begin(), vCandLit->end(), SortRule::PoslitCmpLarge); //被动文字按子句个数进行排序  此处考虑用随机策略
            //此处考虑加大宽度，即同一子句可以左多个合一子句
            if (setRedundClaId.find(givenCla->uClaId) != setRedundClaId.end())
                continue;
            
            UINT32 pasLitInd = 0;
            setRealRedundClaId.clear(); //演绎文字出现冗余
            for (; pasLitInd < UINT32(vCandLit->size()); ++pasLitInd)//依次找到
            {
                //cout<<"找归结子句:"<<pasLitInd<<endl;
                if((givenCla->clast == CopyTemp) && (lastMainDiagonalInd <= pasLitInd)){
                    continue;
                }
                lastMainDiagonalInd = pasLitInd;
                candLitP = vCandLit->at(pasLitInd); //候选被动归结文字
                if (1) {//用于重复使用子句无法跳出的情况
                    clock_t end_out = clock();
                    double time_out = (double) (end_out - StrategyParam::start) / (double) CLOCKS_PER_SEC;
                    if (time_out > StrategyParam::timeLimit * 60)//200   3  1分钟 15  5分钟   30  15分钟  end:300
                    {
                        break;
                    }
                }
                if (QLit->isPairPred(candLitP) == false) {
                    continue;
                }
                candClaP = candLitP->claPtr; // 被动归结子句（候选子句）
                //20171022 增加拷贝子句的演绎限制
                if ((candClaP->uLitNum == 1) &&(hasCpUintClaId.find(candClaP->uClaId) != hasCpUintClaId.end())) {//单元子句已经被拷贝了
                    continue;
                }
                if ((givenCla->clast == CopyTemp) &&(givenCla->copyFrom == candLitP) && unify.CheckEqnR(givenCla->copyTo->subTerm, QLit->subTerm)) {//已拷贝的子句
                    continue;
                }

                //20170827 限制子句中文字数个数
                //                if (vNewR.size() + givenCla->uLitNum + candClaP->uLitNum - 2 > StrategyParam::R_MAX_NUM)
                //                    continue;

                //不允许跟上一轮母式进行归结  
                //                if ((candLitP->parentLitPtr && candLitP->parentLitPtr->claPtr == givenCla) || (QLit->parentLitPtr && QLit->parentLitPtr->claPtr == candClaP)){
                //                    continue;
                //                }
                //核心：合一算法，参数1：主动归结文字指针；参数2：被动归结文字指针
                //20180909 增加目标子句的归结 放松限制
                INT32 tempRsize = StrategyParam::R_MAX_NUM;
                if (candLitP->claPtr->isGoal && (StrategyParam::R_MAX_NUM < candLitP->claPtr->uLitNum)) {
                    StrategyParam::R_MAX_NUM = vNewR.size() + candLitP->claPtr->uLitNum;
                }
                unifResult = unify.IssynLR(QLit, candLitP); //是否找到合一文字
                StrategyParam::R_MAX_NUM = tempRsize;
                //20170909 将限制还原
                //20170215  根据归结子句的互补文字，当有剩余文字既要放入主对角线，又要放入R中 此时的顺序如何选择 这里和文字的稳定排序有关
                if (unifResult == RULEOK) {
                    //                    if(creatFlag){
                    //                        FileOp::CreateRunInfoFile(candidateClaSet[cDeepth]->uClaId / 25);
                    //                        creatFlag = false;
                    //                    }
                    //20170210 stackVarChg用于保存构建三角形过程中所有的替换项
                    //20170818 记录演绎前的归结式文字个数
                    int lastRSize = vNewR.size();
                    int lastvOutTriSize = vOutTri.size();
                    stackVarChg.push_back(unify.vVarBindT); //添加到替换堆栈中	 //版本2需要重点考虑	 
                    //20170224对候选子句进行排序
                    //候选子句文字策略
                    //0:归结次数>稳定度 1:无(由原始顺序为准) 2:稳定度>归结次数
                    findOnlyOut = true;
                    UINT16 sumDrop = 0;
                    vector<Literal*> leftLiter; //20170305 用于保存剩余文字，以便选择最优的文字放入三角形中
                    for (UINT16 m = 0; m < givenCla->uLitNum; m++) {
                        if (givenCla->LitPtr[m]->isDrop)//互补文字
                        {
                            sumDrop++;
                            vOutTri.push_back(givenCla->LitPtr[m]);
                            //cout<<"三角形下方文字"<<"[C" + to_string(candClaP->LitPtr[m]->Row()) + "_" + to_string(candClaP->LitPtr[m]->Col()) + "]"<<(candClaP->LitPtr[m]->subTerm->ToStringBind())<<endl;
                            continue;
                        }
                        //20170305 idea 有效解决冗余:优先选择与单元子句一样的文字(合一)，另外考虑徐老师讲的同一子句可以合并的文字一定要合并
                        leftLiter.push_back(givenCla->LitPtr[m]);
                    }
                    if (!leftLiter.empty()) {
                        //查找是否有可以和单元子句合一相同的文字
                        vector<Term*> chgTempT; //储存替换变元项
                        for (UINT16 m = 0; m < leftLiter.size(); m++) {
                            bool findRes = false;
                            for (auto& clap : vOnlyOutTri) {
                                if (leftLiter[m]->isEqPred(clap) && unify.LitMgu(leftLiter[m], clap, chgTempT)) {
                                    swap(leftLiter[m], leftLiter[0]);
                                    unify.ClearVarBind(chgTempT);
                                    findRes = true;
                                    break;
                                } else
                                    unify.ClearVarBind(chgTempT);
                            }
                            if (findRes)
                                break;
                        }
                        unify.ClearVarBind(chgTempT);
                        for (UINT16 m = 0; m < leftLiter.size(); m++) {
                            if (!leftLiter[m]->isDel && findOnlyOut) {//被选归结子句剩下的文字,其中第一个放在对角线上,其余放入R中
                                lastTrip = leftLiter[m]; //记录三角形对角线演绎最后一个文字，下一次演绎需要放入三角形中
                                vOutTri.push_back(leftLiter[m]);
                                vOnlyOutTri.push_back(leftLiter[m]);
                                findOnlyOut = false;
                            } else if (!leftLiter[m]->isDel &&!findOnlyOut) {//放入R中
                                count++;
                                vOutTri.push_back(leftLiter[m]);
                                vNewR.push_back(leftLiter[m]);
                                //20170216
                                if (first_RLit) {
                                    firstR = vOnlyOutTri.back();
                                    first_RLit = false;
                                }

                            }
                        }
                    }
                    //判断是否全部放入三角形中
                    if (findOnlyOut && count == 0 && vNewR.size() == 0) {
                        newCla = nullptr;
                        givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                        candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                        if(!StrategyParam::orForCompition && (StrategyParam::problemDiv == 0))
                            cout << "得出结论:不可满足" << endl;
                        return true;
                    }
                    //20171229 此处若有剩余文字时,需要跳过该候选子句；需要做如下处理: 1.将该子句与后面的子句交换
//#define cprover_fast4
#ifndef cprover_fast4
                    if (1229) {
                        if ((vNewR.size() > 0) && genUintRFirst) {//需要回退
                            //清除变元合一绑定
                            if (!unify.vVarBindT.empty())
                                unify.ClearVarBind(unify.vVarBindT);
                            //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                            if (!vOnlyOutDect.empty()) {
                                UINT32 dlen = vOnlyOutDect.size();
                                for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                    vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                }
                            }
                            //还原vOutTri  vOnlyOutTri
                            vOnlyOutTri.pop_back();
                            int incOutTriSize = vOutTri.size() - lastvOutTriSize;
                            for (UINT16 m = 0; m < incOutTriSize; m++) {
                                vOutTri.pop_back();
                            }
                            //还原归结式
                            int incRSize = vNewR.size() - lastRSize;
                            for (UINT16 m = 0; m < incRSize; m++) {
                                count--;
                                vNewR.pop_back();
                            }
                            continue;
                        }
                        //20180914
                        else if ((vNewR.size() > 1) && (!genUintRFirst) && genUintRSecond) {//需要回退
                            //清除变元合一绑定
                            if (!unify.vVarBindT.empty())
                                unify.ClearVarBind(unify.vVarBindT);
                            //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                            if (!vOnlyOutDect.empty()) {
                                UINT32 dlen = vOnlyOutDect.size();
                                for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                    vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                }
                            }
                            //还原vOutTri  vOnlyOutTri
                            vOnlyOutTri.pop_back();
                            int incOutTriSize = vOutTri.size() - lastvOutTriSize;
                            for (UINT16 m = 0; m < incOutTriSize; m++) {
                                vOutTri.pop_back();
                            }
                            //还原归结式
                            int incRSize = vNewR.size() - lastRSize;
                            for (UINT16 m = 0; m < incRSize; m++) {
                                count--;
                                vNewR.pop_back();
                            }
                            continue;
                        }
                    }
#endif
                    //20171229 end
                    //三角形上方不剩文字，即归结出来单文字if (find(vOnlyOutTri.begin(), vOnlyOutTri.end(),givenCla->LitPtr[ActLitInd]) == vOnlyOutTri.end())
                    //中间归结式生成 static bool midR;//中间归结式生成 //true 中间归结式生成 false 中间归结式不生成
                    if (count == 0 && vNewR.size() == 0 && !findOnlyOut && StrategyParam::midR) {
                        //新建子句,生成单文字子句,最后加入到单文字子句列表中
//                        if ((newClaId == 1017) &&(vOnlyOutTri.back()->claPtr->uClaId == 11)) {
//                            cout << "debug" << endl;
//                        }
                        Literal* tempptr = vOnlyOutTri.back();
                        bool flagT = true;
                        //如果时纯文字或单文字已存在
                        if ((tempptr->getPairPredLst()->empty()) || (find(vOnlyOutTriCmp.begin(), vOnlyOutTriCmp.end(), tempptr) != vOnlyOutTriCmp.end())) {
                            flagT = false;
                        }
                        if (flagT) {
                            vector<Literal*> vInsertNewR;
                            vInsertNewR.reserve(6);
                            vInsertNewR.push_back(vOnlyOutTri.back());
                            newCla = nullptr;
                            if (!vInsertNewR.empty()) {
                                //查看是否冗余20170101
                                newCla = new Clause(newClaId, 0);
                                newCla->isAxtom = true;
                                size_t uRsize = vInsertNewR.size();
                                //文字排序
//                                if (uRsize > 1) {
//                                    if (StrategyParam::unitSortRule == 3) {
//                                        stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmpGoalDeepth);
//                                    } else
//                                        stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmp);
//                                }
                                if (uRsize > 1)
                                    stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmp);
                                newCla->LitPtr = new Literal*[uRsize];
                                for (UINT16 i = 0; i < vInsertNewR.size(); ++i) {
                                    Term* litSubT = unify.GetNewTerm(vInsertNewR[i]->subTerm, newCla); //参数1：文字谓词项，参数2：新子句指针
                                    if (TNegEqn == GetCodeProp(litSubT->iTermCode)
                                            && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {
                                        /*
                                        delete(litSubT);*/--uRsize;
                                        //delete(newCla->LitPtr[]);
                                        continue;
                                    }
                                    if (newCla->uFuncDepth < litSubT->uLevel)newCla->uFuncDepth = litSubT->uLevel;
                                    newCla->uVarCount += litSubT->uVarCount;
                                    //添加到文字		
                                    newCla->LitPtr[newCla->uLitNum] = new Literal(litSubT, EncodeLitCode(newClaId, newCla->uLitNum + 1), newCla, nullptr);
                                    newCla->LitPtr[newCla->uLitNum]->parentLitPtr = vInsertNewR[i]; //母式文字，有R产生
                                    //newCla->LitPtr[newCla->uLitNum]->goalDeepth = vInsertNewR[i]->goalDeepth;
                                    //20171020 计算演绎深度
                                    if (newCla ->deduceDeepth < (vInsertNewR[i]->claPtr->deduceDeepth + 1)) {
                                        newCla ->deduceDeepth = vInsertNewR[i]->claPtr->deduceDeepth + 1;
                                    }
                                    if (vInsertNewR[i]->claPtr->isAxtom && newCla->isAxtom)
                                        newCla->isAxtom = true;
                                    else
                                        newCla->isAxtom = false;
                                    if (hasUnifGoalLit(fol, newCla->LitPtr[newCla->uLitNum])) {
                                        newCla->LitPtr[newCla->uLitNum]->goalDeepth = 1;
                                        if (newCla->goaldeepth > 1)
                                            newCla->goaldeepth = 1;
                                    } else {
                                        newCla->LitPtr[newCla->uLitNum]->goalDeepth = vInsertNewR[i]->goalDeepth;
                                        if (newCla->goaldeepth > vInsertNewR[i]->goalDeepth)
                                            newCla->goaldeepth = vInsertNewR[i]->goalDeepth;
                                    }
                                    //cout<<to_string(newCla->uClaId)  + "]" <<"[" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitRow()) + "_" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitCol()) + "]" << newCla->LitPtr[newCla->uLitNum]->subTerm->ToString()<<endl;  
                                    ++(newCla->uLitNum);
                                }
                                //20171020 对子句的含等词的文字进行项序处理
                                if (StrategyParam::termRewriting != 2) {
                                    newCla->directEqn();
                                }
                                //cout<<newCla->LitPtr[0]->subTerm->ToStringBind()<<endl;
                                if (uRsize != 0) {
                                    //20171026 增加归结式复杂度判断
                                    if (newCla->compFuncDeepthCla() > StrategyParam::funcFixDeepth) {
                                        //cout<<"R无效"<<endl;
                                        newCla->DelLits(false);
                                        delete(newCla);
                                        //清除变元合一绑定
                                        if (!unify.vVarBindT.empty())
                                            unify.ClearVarBind(unify.vVarBindT);
                                        //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                        if (!vOnlyOutDect.empty()) {
                                            UINT32 dlen = vOnlyOutDect.size();
                                            for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                                vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                            }
                                        }
                                        //还原vOutTri  vOnlyOutTri
                                        vOnlyOutTri.pop_back();
                                        vOutTri.pop_back();
                                        for (UINT16 m = 0; m < sumDrop; m++) {
                                            vOutTri.pop_back();
                                        }
                                        vInsertNewR.clear();
                                        vector<Literal*>().swap(vInsertNewR);
                                        //20170220 增加候选子句冗余权重
                                        //givenCla->reduntTimes++;
                                        continue;
                                    }
                                    //true 中间归结式冗余判断 false 中间归结式冗余不判断
                                    //                                    if (claHasPureLit(fol, newCla)) {
                                    //                                        //cout<<"R无效"<<endl;
                                    //                                        newCla->DelLits(false);
                                    //                                        delete(newCla);
                                    //                                        //清除变元合一绑定
                                    //                                        if (!unify.vVarBindT.empty())
                                    //                                            unify.ClearVarBind(unify.vVarBindT);
                                    //                                        //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                    //                                        if (!vOnlyOutDect.empty()) {
                                    //                                            UINT32 dlen = vOnlyOutDect.size();
                                    //                                            for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                    //                                                vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                    //                                            }
                                    //                                        }
                                    //                                        //还原vOutTri  vOnlyOutTri
                                    //                                        vOnlyOutTri.pop_back();
                                    //                                        vOutTri.pop_back();
                                    //                                        for (UINT16 m = 0; m < sumDrop; m++) {
                                    //                                            vOutTri.pop_back();
                                    //                                        }
                                    //                                        vInsertNewR.clear();
                                    //                                        vector<Literal*>().swap(vInsertNewR);
                                    //                                        //20170220 增加候选子句冗余权重
                                    //                                        givenCla->reduntTimes++;
                                    //                                        continue;
                                    //                                    }
                                    if (StrategyParam::midRJudge) {
                                        vector<UINT32>invaildLitId; //
                                        invaildLitId.reserve(6);
                                        string rundMsg; //冗余信息
                                        Subsumption subsump; //(MOSTRIGHT)
                                        //参数1 被测的子句指针 参数2 整形数组 参数3 字符串 记录冗余信息
                                        bool isRundacyR = false;
                                        isRundacyR = subsump.GenCla(fol, newCla, invaildLitId, rundMsg);
                                        if (isRundacyR) {
                                            //cout<<"R无效"<<endl;
                                            newCla->DelLits(false);
                                            delete(newCla);
                                            //清除变元合一绑定
                                            if (!unify.vVarBindT.empty())
                                                unify.ClearVarBind(unify.vVarBindT);
                                            //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                            if (!vOnlyOutDect.empty()) {
                                                UINT32 dlen = vOnlyOutDect.size();
                                                for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                                    vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                                }
                                            }
                                            //还原vOutTri  vOnlyOutTri
                                            vOnlyOutTri.pop_back();
                                            vOutTri.pop_back();
                                            for (UINT16 m = 0; m < sumDrop; m++) {
                                                vOutTri.pop_back();
                                            }
                                            vInsertNewR.clear();
                                            vector<Literal*>().swap(vInsertNewR);
                                            //20170220 增加候选子句冗余权重
                                            givenCla->reduntTimes++;
                                            continue;
                                        } else {
                                            FileOp::CreateRunInfoFile(FileOp::runFileId);
                                            chgCla.push_back(newCla);
                                            //20170602 新增输出小三角形路径
                                            if (StrategyParam::divideTri) {
                                                *FileOp::ofRealInfoOut << "从编号为" + to_string(candClaP->uClaId) + "子句开始构建三角形" << endl;
                                                if (candClaP->uLitNum == 1) {
                                                    candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                                                }
                                                givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                                                //输出演绎路径					 
                                                PrintTriPath();
                                                //20171020 对子句的含等词的文字进行项序处理
                                                //                                                if (StrategyParam::termRewriting != 2) {
                                                //                                                    newCla->directEqn();
                                                //                                                }
                                                FileOp::WriteR(newCla);
                                                *FileOp::ofRealInfoOut << "|[Y]" << endl;
                                                //20171024 将中间归结式加入子句集,可以用来减少冗余子句的生成
                                                fol.InsertCla(newCla);
                                                fol.setCla.insert(newCla);
                                                midGenR = true;
                                                if (/*StrategyParam::orForCompition*/true) {
                                                    newCla->addRForCompetiton();
                                                    
                                                    string rStr = "";
                                                    newCla->toString(rStr);
                                                    string outClauses = PrintCompetitionOut(newClaId);
                                                    int begPos = rStr.find_first_of("[") + 1;
                                                    int endPos = rStr.find_first_of("]");
                                                    string rId = rStr.substr(begPos, endPos - begPos);
                                                    string rContext = rStr.substr(rStr.find_first_of("]") + 1);
                                                    string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n" + "   inference(scs_inference,[]," + "[" + outClauses +"]" + ")).";
                                                     
                                                    *FileOp::ofOutput << out << endl;
                                                }
                                                //20171024
                                            }
                                        }
                                    } else {
                                        FileOp::CreateRunInfoFile(FileOp::runFileId);
                                        chgCla.push_back(newCla);
                                        //20170602 新增输出小三角形路径
                                        if (StrategyParam::divideTri) {
                                            *FileOp::ofRealInfoOut << "从编号为" + to_string(candClaP->uClaId) + "子句开始构建三角形" << endl;
                                            if (candClaP->uLitNum == 1) {
                                                candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                                            }
                                            givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                                            //输出演绎路径					 
                                            PrintTriPath();

                                            FileOp::WriteR(newCla);
                                            *FileOp::ofRealInfoOut << "|[Y]" << endl;
                                            //20171024 将中间归结式加入子句集,可以用来减少冗余子句的生成
                                            fol.InsertCla(newCla);
                                            fol.setCla.insert(newCla);
                                            midGenR = true;
                                            if (/*StrategyParam::orForCompition*/true) {
                                                newCla->addRForCompetiton();
                                                
                                                string rStr = "";
                                                newCla->toString(rStr);
                                                string outClauses = PrintCompetitionOut(newClaId);
                                                int begPos = rStr.find_first_of("[") + 1;
                                                int endPos = rStr.find_first_of("]");
                                                string rId = rStr.substr(begPos, endPos - begPos);
                                                string rContext = rStr.substr(rStr.find_first_of("]") + 1);
                                                string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n" + "   inference(scs_inference,[]," + "[" + outClauses +"]" + ")).";
               
                                                *FileOp::ofOutput << out << endl;
                                            }
                                            //20171024
                                        }
                                    }
                                }
                                //string str;
                                //newCla->toString(str);
                                //cout<<"插入中间演绎的单文字子句:" <<str << endl;
                                fol.initGenerateClaAttr(newCla);
                                newClaId++;
                            }
                            vInsertNewR.clear();
                            vector<Literal*>().swap(vInsertNewR);
                        } else {//说明该路径不应该搜索
                            //清除变元合一绑定
                            if (!unify.vVarBindT.empty())
                                unify.ClearVarBind(unify.vVarBindT);
                            //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                            if (!vOnlyOutDect.empty()) {
                                UINT32 dlen = vOnlyOutDect.size();
                                for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                    vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                }
                            }
                            //还原vOutTri  vOnlyOutTri
                            vOnlyOutTri.pop_back();
                            vOutTri.pop_back();
                            for (UINT16 m = 0; m < sumDrop; m++) {
                                vOutTri.pop_back();
                            }
                            givenCla->reduntTimes++;
                        }
                    }//20170816 保存生成的非单元子句
                    else if (count > 0 && vNewR.size() > 0 && !findOnlyOut && StrategyParam::midR) {
                        //新建子句,生成单文字子句,最后加入到单文字子句列表中
                        //Literal* tempptr = vOnlyOutTri.back(); 
                        bool flagT = true;
                        vector<Literal*> vInsertNewR;
                        vInsertNewR.reserve(6);
                        vInsertNewR.push_back(vOnlyOutTri.back());
                        
                        for (int i = 0; i < vNewR.size(); i++) {
                            vInsertNewR.push_back(vNewR[i]);
                        }
                        
                        // 此处判断是否有冗余的R 文字,即由该子句对角线文字没有互补对的文字存在与矛盾体中
                        vector<Clause*> discardClas;
                        discardClas.reserve(8);
                        if(StrategyParam::litRundent){
//                            if((newClaId == 1017) &&(vOnlyOutTri.back()->claPtr->uClaId == 11)){
//                                cout<<"debug"<<endl;
//                            }
                            for(int i=0; i < vInsertNewR.size(); ++i){
                                UINT16 countPair = 0;
                                Clause *findCla = vInsertNewR[i]->claPtr;
                                if(findCla == vOutTri.back()->claPtr)
                                    continue;
                                for(int j = 0; j < findCla->uLitNum; ++j){
                                    if(find(vOnlyOutTri.begin(),vOnlyOutTri.end(),findCla->LitPtr[j]) != vOnlyOutTri.end()){//找到对角线文字,查看互补对
                                        for(int k=0; k < vOutTri.size(); ++k){
//                                             if ((findCla->uClaId == 32)&&(vOutTri[k]->claPtr->uClaId == 11)) {
//                                                cout << vOutTri[k]->subTerm->ToStringBind() <<endl;
//                                                cout << findCla->LitPtr[j]->subTerm->ToStringBind() <<endl; 
//                                            }
                                            if((findCla->LitPtr[j]->isPairPred(vOutTri[k])) && (unify.CheckPairEqn(findCla->LitPtr[j]->subTerm, vOutTri[k]->subTerm))){
                                                ++countPair;
                                                break;
                                            }
                                        }                                       
                                    }
                                }
                                if(countPair == 0){//表示对角线没有互补对
                                    if(find(discardClas.begin(),discardClas.end(),vInsertNewR[i]->claPtr) == discardClas.end()){
                                        discardClas.push_back(vInsertNewR[i]->claPtr);
                                    }
                                    swap(vInsertNewR[i],vInsertNewR[vInsertNewR.size()-1]);
                                    vInsertNewR.pop_back();
                                    --i;
                                }
                            }
                        }                                           
                        //end
                        
                        for (size_t rInd = 0; rInd < vInsertNewR.size() - 1; ++rInd) {
                            Literal* rA = vInsertNewR[rInd];
                            for (size_t rIndB = rInd + 1; rIndB < vInsertNewR.size();) {
                                Literal* rB = vInsertNewR[rIndB];
                                if (rA->subTerm->iTermCode == rB->subTerm->iTermCode && unify.CheckEqn(rA->subTerm, rB->subTerm)) {
                                    swap(vInsertNewR[rIndB], vInsertNewR[vInsertNewR.size() - 1]);
                                    vInsertNewR.pop_back();
                                } else
                                    ++rIndB;
                            }
                        }
                        if (vInsertNewR.size() > StrategyParam::midR)
                            flagT = false;
                        if (flagT) {
                            newCla = nullptr;
                            if (!vInsertNewR.empty()) {
                                //查看是否冗余20170101
                                newCla = new Clause(newClaId, 0);
                                newCla->isAxtom = true;
                                size_t uRsize = vInsertNewR.size();
//                                cout<<"uRsize:"<<uRsize<<"  "<<"newClaId:"<< newClaId <<endl;
//                                if((uRsize == 2) && (newClaId == 7689)){
//                                    cout<<"debug"<<endl;
//                                }
                                //文字排序
//                                if (uRsize > 1)
//                                    if (StrategyParam::unitSortRule == 3) {
//                                        stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmpGoalDeepth);
//                                    } else
//                                        stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmp);
                                if (uRsize > 1)
                                    stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmp);
                                newCla->LitPtr = new Literal*[uRsize];
                                for (UINT16 i = 0; i < vInsertNewR.size(); ++i) {
                                    Term* litSubT = unify.GetNewTerm(vInsertNewR[i]->subTerm, newCla); //参数1：文字谓词项，参数2：新子句指针
                                    if (TNegEqn == GetCodeProp(litSubT->iTermCode)
                                            && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {
                                        /*
                                        delete(litSubT);*/--uRsize;
                                        //delete(newCla->LitPtr[]);
                                        continue;
                                    }
                                    if (newCla->uFuncDepth < litSubT->uLevel)newCla->uFuncDepth = litSubT->uLevel;
                                    newCla->uVarCount += litSubT->uVarCount;
                                    //添加到文字		
                                    newCla->LitPtr[newCla->uLitNum] = new Literal(litSubT, EncodeLitCode(newClaId, newCla->uLitNum + 1), newCla, nullptr);
                                    newCla->LitPtr[newCla->uLitNum]->parentLitPtr = vInsertNewR[i]; //母式文字，有R产生
                                    //newCla->LitPtr[newCla->uLitNum]->goalDeepth = vInsertNewR[i]->goalDeepth;
                                    //20171020 计算演绎深度
                                    if (newCla ->deduceDeepth < (vInsertNewR[i]->claPtr->deduceDeepth + 1)) {
                                        newCla ->deduceDeepth = vInsertNewR[i]->claPtr->deduceDeepth + 1;
                                    }
                                    if (vInsertNewR[i]->claPtr->isAxtom && newCla->isAxtom)
                                        newCla->isAxtom = true;
                                    else
                                        newCla->isAxtom = false;
                                    if (hasUnifGoalLit(fol, newCla->LitPtr[newCla->uLitNum])) {
                                        newCla->LitPtr[newCla->uLitNum]->goalDeepth = 1;
                                        if (newCla->goaldeepth > 1)
                                            newCla->goaldeepth = 1;
                                    } else {
                                        newCla->LitPtr[newCla->uLitNum]->goalDeepth = vInsertNewR[i]->goalDeepth;
                                        if (newCla->goaldeepth > vInsertNewR[i]->goalDeepth)
                                            newCla->goaldeepth = vInsertNewR[i]->goalDeepth;
                                    }
                                    //cout<<to_string(newCla->uClaId)  + "]" <<"[" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitRow()) + "_" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitCol()) + "]" << newCla->LitPtr[newCla->uLitNum]->subTerm->ToString()<<endl;  
                                    ++(newCla->uLitNum);
                                }
//                                 if (newCla->uLitNum == 0) {
//                                    cout << "error" << endl;
//                                }
                                //20171020 对子句的含等词的文字进行项序处理
                                if (StrategyParam::termRewriting != 2) {
                                    newCla->directEqn();
                                }
                                //cout<<newCla->LitPtr[0]->subTerm->ToStringBind()<<endl;
                                if (uRsize != 0) {
                                    //20171026 增加归结式复杂度判断
                                    if (newCla->compFuncDeepthCla() > StrategyParam::funcFixDeepth) {
                                        //cout<<"R无效"<<endl;
                                        newCla->DelLits(false);
                                        delete(newCla);
                                        //20170818 需要还原vNewR 此次演绎改变了什么 
                                        //清除变元合一绑定
                                        if (!unify.vVarBindT.empty())
                                            unify.ClearVarBind(unify.vVarBindT);
                                        //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                        if (!vOnlyOutDect.empty()) {
                                            UINT32 dlen = vOnlyOutDect.size();
                                            for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                                vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                            }
                                        }
                                        //还原vOutTri  vOnlyOutTri
                                        vOnlyOutTri.pop_back();
                                        int incOutTriSize = vOutTri.size() - lastvOutTriSize;
                                        for (UINT16 m = 0; m < incOutTriSize; m++) {
                                            vOutTri.pop_back();
                                        }
                                        //还原归结式
                                        int incRSize = vNewR.size() - lastRSize;
                                        for (UINT16 m = 0; m < incRSize; m++) {
                                            count--;
                                            vNewR.pop_back();
                                        }
                                        vInsertNewR.clear();
                                        vector<Literal*>().swap(vInsertNewR);
                                        //20170220 增加候选子句冗余权重
                                        //candClaP->reduntTimes++;
                                        continue;
                                    }
                                    //true 中间归结式冗余判断 false 中间归结式冗余不判断
                                    //                                    if (claHasPureLit(fol, newCla)) {
                                    //                                        //cout<<"R无效"<<endl;
                                    //                                        newCla->DelLits(false);
                                    //                                        delete(newCla);
                                    //                                        //20170818 需要还原vNewR 此次演绎改变了什么 
                                    //                                        //清除变元合一绑定
                                    //                                        if (!unify.vVarBindT.empty())
                                    //                                            unify.ClearVarBind(unify.vVarBindT);
                                    //                                        //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                    //                                        if (!vOnlyOutDect.empty()) {
                                    //                                            UINT32 dlen = vOnlyOutDect.size();
                                    //                                            for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                    //                                                vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                    //                                            }
                                    //                                        }
                                    //                                        //还原vOutTri  vOnlyOutTri
                                    //                                        vOnlyOutTri.pop_back();
                                    //                                        int incOutTriSize = vOutTri.size() - lastvOutTriSize;
                                    //                                        for (UINT16 m = 0; m < incOutTriSize; m++) {
                                    //                                            vOutTri.pop_back();
                                    //                                        }
                                    //                                        //还原归结式
                                    //                                        int incRSize = vNewR.size() - lastRSize;
                                    //                                        for (UINT16 m = 0; m < incRSize; m++) {
                                    //                                            count--;
                                    //                                            vNewR.pop_back();
                                    //                                        }
                                    //                                        vInsertNewR.clear();
                                    //                                        vector<Literal*>().swap(vInsertNewR);
                                    //                                        //20170220 增加候选子句冗余权重
                                    //                                        candClaP->reduntTimes++;
                                    //                                        continue;
                                    //                                    }
                                    if (StrategyParam::midRJudge) {
                                        vector<UINT32>invaildLitId; //
                                        invaildLitId.reserve(6);
                                        string rundMsg; //冗余信息
                                        Subsumption subsump; //(MOSTRIGHT)
                                        //参数1 被测的子句指针 参数2 整形数组 参数3 字符串 记录冗余信息
                                        bool isRundacyR = false;
                                        isRundacyR = subsump.GenCla(fol, newCla, invaildLitId, rundMsg);
                                        if (isRundacyR) {
                                            //cout<<"R无效"<<endl;
                                            newCla->DelLits(false);
                                            delete(newCla);
                                            //20170818 需要还原vNewR 此次演绎改变了什么 
                                            //清除变元合一绑定
                                            if (!unify.vVarBindT.empty())
                                                unify.ClearVarBind(unify.vVarBindT);
                                            //还原被该子句下拉的单元子句，继续找下一个互补对的候选子句
                                            if (!vOnlyOutDect.empty()) {
                                                UINT32 dlen = vOnlyOutDect.size();
                                                for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                                    vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                                }
                                            }
                                            //还原vOutTri  vOnlyOutTri
                                            vOnlyOutTri.pop_back();
                                            int incOutTriSize = vOutTri.size() - lastvOutTriSize;
                                            for (UINT16 m = 0; m < incOutTriSize; m++) {
                                                vOutTri.pop_back();
                                            }
                                            //还原归结式
                                            int incRSize = vNewR.size() - lastRSize;
                                            for (UINT16 m = 0; m < incRSize; m++) {
                                                count--;
                                                vNewR.pop_back();
                                            }
                                            vInsertNewR.clear();
                                            vector<Literal*>().swap(vInsertNewR);
                                            //20170220 增加候选子句冗余权重
                                            candClaP->reduntTimes++;
                                            continue;
                                        } else {
                                            FileOp::CreateRunInfoFile(FileOp::runFileId);
                                            chgCla.push_back(newCla);
                                            //20170602 新增输出小三角形路径
                                            if (StrategyParam::divideTri) {
                                                *FileOp::ofRealInfoOut << "从编号为" + to_string(candClaP->uClaId) + "子句开始构建三角形" << endl;
                                                if (candClaP->uLitNum == 1) {
                                                    candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                                                }
                                                givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                                                //输出演绎路径
                                                if(discardClas.empty() == false){
                                                    for(int aa= 0; aa<discardClas.size(); ++aa){
                                                        discardClas[aa]->isSDeduct = false;
                                                    }
                                                }
                                                PrintTriPath();
                                                if(discardClas.empty() == false){
                                                    for(int aa= 0; aa<discardClas.size(); ++aa){
                                                        discardClas[aa]->isSDeduct = true;
                                                    }
                                                }
                                                vector<Clause*>().swap(discardClas);
                                                FileOp::WriteR(newCla);
                                                *FileOp::ofRealInfoOut << "|[Y]" << endl;
                                                //20171024 将中间归结式加入子句集,可以用来减少冗余子句的生成
                                                fol.InsertCla(newCla);
                                                fol.setCla.insert(newCla);
                                                midGenR = true;
                                                if (/*StrategyParam::orForCompition*/true) {
                                                    newCla->addRForCompetiton();
                                                    
                                                    string rStr = "";
                                                    newCla->toString(rStr);
                                                    string outClauses = PrintCompetitionOut(newClaId);
                                                    int begPos = rStr.find_first_of("[") + 1;
                                                    int endPos = rStr.find_first_of("]");
                                                    string rId = rStr.substr(begPos, endPos - begPos);
                                                    string rContext = rStr.substr(rStr.find_first_of("]") + 1);
                                                    string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n" + "   inference(scs_inference,[]," + "[" + outClauses +"]" + ")).";
                                                    *FileOp::ofOutput << out << endl;
                                                }
                                                //20171024
                                            }
                                        }
                                    } else {
                                        FileOp::CreateRunInfoFile(FileOp::runFileId);
                                        chgCla.push_back(newCla);
                                        //20170602 新增输出小三角形路径
                                        if (StrategyParam::divideTri) {
                                            *FileOp::ofRealInfoOut << "从编号为" + to_string(candClaP->uClaId) + "子句开始构建三角形" << endl;
                                            if (candClaP->uLitNum == 1) {
                                                candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                                            }
                                            givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                                            //输出演绎路径	
                                            if(discardClas.empty() == false){
                                                    for(int aa= 0; aa<discardClas.size(); ++aa){
                                                        discardClas[aa]->isSDeduct = false;
                                                    }
                                                }
                                            PrintTriPath();
                                            if(discardClas.empty() == false){
                                                    for(int aa= 0; aa<discardClas.size(); ++aa){
                                                        discardClas[aa]->isSDeduct = true;
                                                    }
                                                }
                                            vector<Clause*>().swap(discardClas);
                                            //20171020 对子句的含等词的文字进行项序处理
                                            //                                            if (StrategyParam::termRewriting != 2) {
                                            //                                                newCla->directEqn();
                                            //                                            }
                                            FileOp::WriteR(newCla);
                                            *FileOp::ofRealInfoOut << "|[Y]" << endl;
                                            //20171024 将中间归结式加入子句集,可以用来减少冗余子句的生成
                                            fol.InsertCla(newCla);
                                            fol.setCla.insert(newCla);
                                            midGenR = true;
                                            if (/*StrategyParam::orForCompition*/true) {
                                                newCla->addRForCompetiton();
                                                
                                                string rStr = "";
                                                newCla->toString(rStr);
                                                string outClauses = PrintCompetitionOut(newClaId);
                                                int begPos = rStr.find_first_of("[") + 1;
                                                int endPos = rStr.find_first_of("]");
                                                string rId = rStr.substr(begPos, endPos - begPos);
                                                string rContext = rStr.substr(rStr.find_first_of("]") + 1);
                                                string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n" + "   inference(scs_inference,[]," + "[" + outClauses +"]" + ")).";
                                                *FileOp::ofOutput << out << endl;
                                            }
                                            //20171024
                                        }
                                    }
                                }
                                //string str;
                                //newCla->toString(str);
                                //cout<<"插入中间演绎的单文字子句:" <<str << endl;
                                fol.initGenerateClaAttr(newCla);
                                newClaId++;
                            }

                        }
                        vInsertNewR.clear();
                        vector<Literal*>().swap(vInsertNewR);
                    }
                    //20170215 保存每次子句演绎的互补对单元子句
                    claPair.clear();
                    claPair.push_back(QLit);
                    //20170215需要为参与本单元的三角形演绎单元子句设置权重
                    if (!vOnlyDectNum.empty()) {
                        for (UINT8 nm = 0; nm < vOnlyDectNum.size(); nm++) {
                            claPair.push_back(vOnlyDectNum[nm]);
                            if (vOnlyDectNum[nm]->claPtr->uLitNum == 1)
                                vOnlyDectNum[nm]->claPtr->adeductNum++; //单元子句权重加1
                        }
                    }
                    if (candClaP->uLitNum == 1) {
                        candClaP->adeductNum++; //主动归结次数+1
                        candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                    }
                    
                    QLit->sDuct = QLit->sDuct + 10; //候选文字权重加一 须重新文字排序 first-> QLit->sDuct++
                    if(QLit->sDuct == 10000)
                        QLit->sDuct = 0;
                    //2020:repaired
                    if(givenCla->isAxtom == false)
                        givenCla->pdeductNum += 1/*resRandomNumber(total_Loop)*/; //total_Loop 怎么得到
                    else{
                        if(StrategyParam::equalityUsedFrq == 0)
                            givenCla->pdeductNum += 5/*resRandomNumber(total_Loop) + total_Loop/2*/; //total_Loop 怎么得到
                        else if(StrategyParam::equalityUsedFrq == 1)
                            givenCla->pdeductNum += resRandomNumber(total_Loop) + total_Loop/50; //total_Loop 怎么得到
                        else if(StrategyParam::equalityUsedFrq == 2)
                            givenCla->pdeductNum += resRandomNumber(total_Loop); //total_Loop 怎么得到
                    }
                    givenCla->isSDeduct = true; //在构建三角形过程中参与归结
//                    if(newCla->uLitNum == 0){
//                        cout<<"error"<<endl;
//                    }
                    //20171022 拷贝已使用的子句,以达到重复使用子句的目的
                    //如果演绎的不是上次拷贝的子句,则需要将其删除
                    //                    if((lastDeductCla != nullptr) &&(givenCla != lastDeductCla)){//说明拷贝的子句没有用上
                    //                        //在演绎子句列表中清除lastDeductCla
                    //                        vector<Clause*>::iterator delInd = find(candidateClaSet.begin(),candidateClaSet.end(),lastDeductCla);
                    //                        candidateClaSet.erase(delInd);
                    //                        //在拷贝的子句列表中清除lastDeductCla
                    //                        lastDeductCla->DelLits(false);
                    //                        delete(lastDeductCla);
                    //                    }
                    //if (StrategyParam::useCpUintCla) {//拷贝单元子句
                    if (1) {//拷贝单元子句
                        if ((candClaP->uLitNum == 1) && candClaP->HasTermBind()) {
                            //拷贝新的子句来使用
                            unify.copyUintCla(fol, candClaP, newClaId);
                            hasCpUintClaId.insert(candClaP->uClaId);
                        }
                        if (vOnlyDectNum.size() > 0) {
                            for (UINT16 s = 0; s < vOnlyDectNum.size(); ++s) {
                                if ((vOnlyDectNum[s]->claPtr->uLitNum == 1) && vOnlyDectNum[s]->claPtr->HasTermBind()) {
                                    //拷贝新的子句来使用
                                    unify.copyUintCla(fol, vOnlyDectNum[s]->claPtr, newClaId);
                                    hasCpUintClaId.insert(vOnlyDectNum[s]->claPtr->uClaId);
                                }
                            }
                        }
                    }
                    
                    //if (midGenR && (StrategyParam::claReUseTimes != 0) && (givenCla->HasTermBind())) {
                    if (midGenR && (givenCla->HasTermBind())&& (givenCla->isAxtom == false)) {//2020:repaired
                        Clause* cpClaTmp = nullptr;
                        if (givenCla->topCopyCla == nullptr)
                            cpClaTmp = givenCla;
                        else
                            cpClaTmp = givenCla->topCopyCla;
                        //if (copyClaCopyTimes(cpClaTmp) < StrategyParam::claReUseTimes) {
                        if (1) {
                            Clause* cyCla = copyCla(fol, cpClaTmp, newClaId, candLitP, QLit);
                            cyCla->topCopyCla = cpClaTmp;
                            lastDeductCla = cyCla;
                            //插入到演绎子句列表中
                            
                            vector<Clause*>::iterator insertInd = find(candidateClaSet.begin(), candidateClaSet.end(), givenCla);
                            candidateClaSet.insert(insertInd + 1, cyCla);
                            midGenR = false;
                            
                        }

                    }

                    //20171022 end

                    setRedundClaId.insert(givenCla->uClaId); //用于本次三角形不在使用已经归结过的子句
                    
                    //here start to use E to combined
                    if(1){
                        if (1) {
                            clock_t end_control = clock();
                            double time_control = (double) (end_control - StrategyParam::start) / (double) CLOCKS_PER_SEC;
                            StrategyParam::timeLimit = StrategyParam::firstTimeLimit;
                            if (time_control > StrategyParam::timeLimit * 60)//200   3  1分钟 15  5分钟   30  15分钟  end:300
                            {
                                if (isGloDeduct) {
                                    break;
                                } else {//所有的单元子句都找不到互补对有效子句
                                    allNoPair = true;
                                    return 22;
                                }
                            }
                        }
                        if (combineFlag) {
                            if (1) {
                                if (1) {//just for timeout
                                    clock_t end_control = clock();
                                    double time_control = (double) (end_control - StrategyParam::start) / (double) CLOCKS_PER_SEC;
                                    StrategyParam::timeLimit = StrategyParam::firstTimeLimit;
                                    if (time_control > StrategyParam::timeLimit * 60)//200   3  1分钟 15  5分钟   30  15分钟  end:300
                                    {
                                        if (isGloDeduct) {
                                            break;
                                        } else {//所有的单元子句都找不到互补对有效子句
                                            allNoPair = true;
                                            return 22;
                                        }
                                    } else if (time_control > StrategyParam::timeLimit * 30) {
                                        combineFlag = false;
                                        cLongth = 0;
                                        continue;
                                    }
                                }
                                fol.combinedClaSet.clear();
                                if (combineFlag) {

                                    if (vOutTri.size() > 0) {
                                        for (UINT16 m = 0; m < vOutTri.size(); m++) {
                                            if (fol.combinedClaSet.find(vOutTri[m]->claPtr) != fol.combinedClaSet.end()) {
                                                continue;
                                            } else
                                                fol.combinedClaSet.insert(vOutTri[m]->claPtr);
                                        }

                                    }
                                    fol.combinedClaSet.insert(givenCla);
                                    //输出子句格式
                                    string str = "";
                                    str = fol.ToCombinedString();
                                    FileOp::PrintInfoCombinedClas(str); //输出所有的单元子句到.erspre
                                    //得到结合证明器识别的格式
                                    FileOp::convertCombinedClaFormat();

                                }
                                //2.调用E运行，并解析输出文件，得到新生成的子句
                                if (combineFlag) {
                                    string cmd = FileOp::homePath + "/Desktop/dist/eprover " + " --delete-bad-limit=2000000000 --definitional-cnf=24 -s --full-deriv --tstp-format --print-statistics -R --print-version --proof-object --auto-schedule --cpu-limit=1 ";
                                    string strInfoPath = FileOp::g_OutputPath + "/" + FileOp::JudgeFileFullNameNoExt + ".combinedResForRun";
                                    string strInfoPathOut = FileOp::g_OutputPath + "/" + FileOp::JudgeFileFullNameNoExt + ".combinedResRunOut";
                                    cmd = cmd + strInfoPath + " >> " + strInfoPathOut;
                                    int res4 = system(const_cast<char*> (cmd.c_str()));
                                }
                                //3.解析得到新生成的子句到CSE.若是单元子句，加入到主对角线，否则加入到候选子句集
                                if (combineFlag) {
                                    //读取文件，返回子句
                                    string strClause = "";
                                    Clause* comCla = nullptr;
                                    string strInfoPath = FileOp::g_OutputPath + "/" + FileOp::JudgeFileFullNameNoExt + ".combinedResRunOut";
                                    ifstream ifFolFile(strInfoPath);
                                    int sCount = 0;
                                    while (getline(ifFolFile, strClause)) {
                                        string realLine = strClause;
                                        if ((strClause.find("cnf", 0) != string::npos) && (strClause.find("inference", 0) != string::npos)) {
                                            sCount++;
                                            //cout<<strClause<<endl;
                                            size_t index = strClause.find("plain");
                                            //cout<<index<<endl;
                                            strClause = strClause.substr(index + 6);
                                            index = strClause.find("inference");
                                            strClause = strClause.substr(0, index - 2);
                                            //cout<<strClause<<endl;
                                            //strClause = strClause.substr(strClause.find_first_of("plain") + 6,strClause.find_first_of("inference") - 2 - (strClause.find_first_of("plain") + 6));
                                            comCla = fol.ReadTPTPClause(strClause, newClaId);
                                            if(!comCla){
                                                continue;
                                            }
                                            if ((comCla->uLitNum) == 0) {
                                                newClaId--;
                                                comCla->DelLits(true);
                                                delete(comCla);
                                                continue;
                                            }

                                            if ((comCla->uLitNum) != 0) {
                                                if (comCla->compFuncDeepthCla() > StrategyParam::funcFixDeepth) {
                                                    newClaId--;
                                                    comCla->DelLits(true);
                                                    delete(comCla);
                                                    continue;
                                                }
                                                vector<UINT32>invaildLitId; //
                                                invaildLitId.reserve(6);
                                                string rundMsg; //冗余信息
                                                Subsumption subsump; //(MOSTRIGHT)
                                                //参数1 被测的子句指针 参数2 整形数组 参数3 字符串 记录冗余信息
                                                bool isRundacyR = false;
                                                isRundacyR = subsump.GenCla(fol, comCla, invaildLitId, rundMsg);
                                                if (isRundacyR) {
                                                    newClaId--;
                                                    comCla->DelLits(true);
                                                    delete(comCla);
                                                    continue;
                                                } else {

                                                    fol.setCla.insert(comCla);
                                                    if (comCla->uLitNum > 1) {
                                                        vector<Clause*>::iterator insertInd = find(candidateClaSet.begin(), candidateClaSet.end(), givenCla);
                                                        candidateClaSet.insert(insertInd + 1, comCla);
                                                    }
//                                                    string str;
//                                                    comCla->toString(str);
//                                                    cout << str << endl;
                                                }
                                            }
                                        } else if ((realLine.find("Proof found!", 0) != string::npos)) {
                                            newCla = nullptr;
                                            vNewR.clear();
                                            if (!StrategyParam::orForCompition && (StrategyParam::problemDiv == 0))
                                                cout << "得出结论:不可满足" << endl;
                                            return true;
                                        }
                                    }
                                    if(sCount == 0)
                                        combineFlag = false;
                                    //clear output by E
                                    remove(strInfoPath.c_str());
                                    
                                }
                            }                          
                        }                                                                       
                    }
                    
                    
                    if (RULEOK == unifResult) {
                        isDeduct = true;
                        isGloDeduct = true;
                    }
                    //20170828 增加R文字数限制,即当vNewR.size() 大于文字数限制 则要退出
                    //20170215 子句全部落入三角形下方 需要结束三角形演绎 并判断是否能得出结论
                    if (findOnlyOut && (vNewR.size() != 0))
                        break;
                    //20170828 增加R文字数限制,即当vNewR.size() 大于文字数限制 则要退出
                    if ((vNewR.size() >= StrategyParam::R_MAX_NUM) || ((StrategyParam::R_INIT_MAX_NUM == givenCla->uLitNum)&&(givenCla->uLitNum > 10))) {
                        break;
                    }
                    //end
                    //0:深度优先 1:宽深结合 2:宽度优先
                    if (StrategyParam::widthDeep == 0) {
                        break;
                    } else if (StrategyParam::widthDeep == 1) {
                        break;
                    } else
                        break;
                } else {
                    //清除合一规则检查失败时，被置为isSdeduct为true的子句
                    if (!vOnlyOutDect.empty()) {
                        UINT32 dlen = vOnlyOutDect.size();
                        for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                            vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                        }
                    }
                }
            }//20170210 候选子句外循环  找互补对外循环体
            //20171026 应该要遍历所有的文字
            if (isDeduct)
                break;
            else{//20190516 add
                if((FileOp::strategyMode == 3) || (FileOp::strategyMode == 4)){
                    ;
                }
                else{
                    ActLitInd = ActLitInd + givenCla->uLitNum;
                }
                QLit->sDuct++; //候选文字权重加一 须重新文字排序 first-> QLit->sDuct++
                if(QLit->sDuct == 10000)//2020:repaired
                    QLit->sDuct = 0;
            }
            //只找到一次候选文字，不管有没有都退出，后期可以把深入做大
            //break;
        }//20170210 主动子句外循环
        //20170828 增加R文字数限制,即当vNewR.size() 大于文字数限制 则要退出
        if ((vNewR.size() >= StrategyParam::R_MAX_NUM) || (isDeduct && (StrategyParam::R_INIT_MAX_NUM == candClaP->uLitNum)&&(candClaP->uLitNum > 10))) {
            break;
        }
        //end
        //继续下一个合一配对
        ResClaID.insert(givenCla->uClaId);
        ResClaPtr.push_back(givenCla);
//#define cprover_fast5
#ifndef cprover_fast5
        if (0) {
            if (20180101) {
                if (((cDeepth == (chooseClaSet.size() - 1)) || (cDeepth == StrategyParam::deductDeep)) && oneRunFlag) {
                    cDeepth = -1;
                    oneRunFlag = false;
                    genUintRFirst = false;
                }                    //20180914
                else if (((cDeepth == (chooseClaSet.size() - 1)) || (cDeepth == StrategyParam::deductDeep)) && !oneRunFlag && !genUintRFirst && twoRunFlag) {
                    cDeepth = -1;
                    twoRunFlag = false;
                    genUintRSecond = false;
                }
            }
#endif
            cDeepth++;
            if (cDeepth >= chooseClaSet.size()) {
                cDeepth = chooseClaSet.size();
                cLongth++;
            }
            //为-1时，系统自动处理；为大于0时设置值有效；
            if (cDeepth == StrategyParam::deductDeep) {
                if (isGloDeduct) {
                    break;
                } else {
                    allNoPair = true;
                    return 222;
                }
            }
            if ((cDeepth == chooseClaSet.size()) && (cLongth == candidateClaSet.size())) {
                if (isGloDeduct) {
                    break;
                } else {//所有的单元子句都找不到互补对有效子句
                    allNoPair = true;
                    return 22;
                }
            }
            //控制三角形演绎子句的总长度
            //        if (setRedundClaId.size() > 160) {
            //            if (isGloDeduct) {
            //                break;
            //            } else {//所有的单元子句都找不到互补对有效子句
            //                allNoPair = true;
            //                return 22;
            //            }
            //        }
            clock_t end = clock();
            double time_s = (double) (end - StrategyParam::start) / (double) CLOCKS_PER_SEC;
            StrategyParam::timeLimit = StrategyParam::firstTimeLimit;
            if (time_s > StrategyParam::timeLimit * 60)//200   3  1分钟 15  5分钟   30  15分钟  end:300
            {
                if (isGloDeduct) {
                    break;
                } else {//所有的单元子句都找不到互补对有效子句
                    allNoPair = true;
                    return 22;
                }
            }
            //考虑情况：配对子句已全部落入三角形内，但是之前有R剩余，此时停止构建三角形
            //       if ((findOnlyOut && (vNewR.size() != 0)) || cDeepth == vOnlyOutTri.size()) {
            //           if (findOnlyOut && (vNewR.size() != 0)) {
            //                //cout << "找到所有互补对单R不为空" << endl;
            //                if (!claPair.empty()) {
            //                    UINT32 lengthA = -2;
            //                    vector <Literal*>::iterator ie;
            //                    for (UINT8 lab = 0; lab < claPair.size(); lab++) {
            //                        ie = find(vOnlyOutTri.begin(), vOnlyOutTri.end(), claPair[lab]);
            //                        if (distance(vOnlyOutTri.begin(), ie) > lengthA)
            //                            lengthA = distance(vOnlyOutTri.begin(), ie);
            //                    }
            //                    ie = find(vOnlyOutTri.begin(), vOnlyOutTri.end(), firstR);
            //                    if (distance(vOnlyOutTri.begin(), ie) > lengthA) {
            //                        newCla = nullptr;
            //                        cout << "得出结论:不可满足" << endl;
            //                        return true;
            //                    }
            //                }
            //            }
            //             break;
            //        }
            givenCla = chooseClaSet[cDeepth];
        } else {
            if (20180101) {
                if (((cLongth == (candidateClaSet.size() - 1)) || (cLongth == StrategyParam::deductDeep)) && oneRunFlag) {
                    cLongth = -1;
                    oneRunFlag = false;
                    genUintRFirst = false;
                }                    //20180914
                else if (((cLongth == (candidateClaSet.size() - 1)) || (cLongth == StrategyParam::deductDeep)) && !oneRunFlag && !genUintRFirst && twoRunFlag) {
                    cLongth = -1;
                    twoRunFlag = false;
                    genUintRSecond = false;
                }
            }

            cLongth++;
            //为-1时，系统自动处理；为大于0时设置值有效；
            if (cLongth == StrategyParam::deductDeep) {
                if (isGloDeduct) {
                    break;
                } else {
                    allNoPair = true;
                    return 222;
                }
            }
            if (cLongth == candidateClaSet.size()) {
                if (isGloDeduct) {
                    break;
                } else {//所有的单元子句都找不到互补对有效子句
                    allNoPair = true;
                    return 22;
                }
            }
            //控制三角形演绎子句的总长度
            //        if (setRedundClaId.size() > 160) {
            //            if (isGloDeduct) {
            //                break;
            //            } else {//所有的单元子句都找不到互补对有效子句
            //                allNoPair = true;
            //                return 22;
            //            }
            //        }
            clock_t end = clock();
            double time_s = (double) (end - StrategyParam::start) / (double) CLOCKS_PER_SEC;
            StrategyParam::timeLimit = StrategyParam::firstTimeLimit;
            if (time_s > StrategyParam::timeLimit * 60)//200   3  1分钟 15  5分钟   30  15分钟  end:300
            {
                if (isGloDeduct) {
                    break;
                } else {//所有的单元子句都找不到互补对有效子句
                    allNoPair = true;
                    return 22;
                }
            }
            givenCla = candidateClaSet[cLongth];
        }
        //string str;
        //givenCla->toString(str);
        //cout << str << endl;
    }//20170210 构建三角形结束外循环
    //生成新子句(R) 并输出演绎结果中
    newCla = nullptr;
    //20170215 用于判断最后的收尾归结子句全部落在三角形内的情况 但R不为空 
    assert(!(findOnlyOut && (vNewR.size() == 0)));
    if (!findOnlyOut) //20170215 end
    {
        vNewR.push_back(vOnlyOutTri.back());
        //vOnlyOutTri.pop_back();
    }
    //20170214 若所有的主对角线文字都没有找到满足条件互补的子句，则不输出R
    if ((vNewR.size() == 1)&&(chgCla.size() == 0)&&(find(vOnlyOutTriCmp.begin(), vOnlyOutTriCmp.end(), vNewR[0]) != vOnlyOutTriCmp.end())) {
        allNoPair = true;
        return 22;
    }
    
      // 此处判断是否有冗余的R 文字,即由该子句对角线文字没有互补对的文字存在与矛盾体中
    if (StrategyParam::litRundent) {
        for (int i = 0; i < vNewR.size(); ++i) {
            UINT16 countPair = 0;
            Clause *findCla = vNewR[i]->claPtr;
            if(findCla == vOutTri.back()->claPtr)
                continue;
            for (int j = 0; j < findCla->uLitNum; ++j) {
                if (find(vOnlyOutTri.begin(), vOnlyOutTri.end(), findCla->LitPtr[j]) != vOnlyOutTri.end()) {//找到对角线文字,查看互补对
                    for (int k = 0; k < vOutTri.size(); ++k) {
                        if ((findCla->LitPtr[j]->isPairPred(vOutTri[k])) && (unify.CheckPairEqn(findCla->LitPtr[j]->subTerm, vOutTri[k]->subTerm))) {
                            ++countPair;
                            break;
                        }
                    }
                }
            }
            if (countPair == 0) {//表示对角线没有互补对
                vNewR[i]->claPtr->isSDeduct = false;
                swap(vNewR[i], vNewR[vNewR.size() - 1]);
                vNewR.pop_back();
                --i;
                
            }
        }
    }
    
    //检查R是否有相同的合并
    for (size_t rInd = 0; rInd < vNewR.size() - 1; ++rInd) {
        Literal* rA = vNewR[rInd];
        for (size_t rIndB = rInd + 1; rIndB < vNewR.size();) {
            Literal* rB = vNewR[rIndB];
            if (rA->subTerm->iTermCode == rB->subTerm->iTermCode && unify.CheckEqn(rA->subTerm, rB->subTerm)) {
                swap(vNewR[rIndB], vNewR[vNewR.size() - 1]);
                vNewR.pop_back();
            } else
                ++rIndB;
        }
    }

  
    
    assert(vNewR.size() != 0); //20170211 考虑是否此处有R为0
    newCla = new Clause(newClaId, 0);
    newCla->isAxtom = true;
    size_t uRsize = vNewR.size();
    //文字排序
    if (uRsize > 1)
        stable_sort(vNewR.begin(), vNewR.end(), SortRule::LitCmp);
    newCla->LitPtr = new Literal*[uRsize];
    for (UINT16 i = 0; i < vNewR.size(); ++i) {
        Term* litSubT = unify.GetNewTerm(vNewR[i]->subTerm, newCla); //参数1：文字谓词项，参数2：新子句指针
        if (TNegEqn == GetCodeProp(litSubT->iTermCode)
                && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {//出现有剩余文字仍为不可满足的清空，需要考虑这种清空 20170108
            /*
            delete(litSubT);*/--uRsize;
            //delete(newCla->LitPtr[]);
            continue;
        }
        if (newCla->uFuncDepth < litSubT->uLevel)newCla->uFuncDepth = litSubT->uLevel;
        newCla->uVarCount += litSubT->uVarCount;
        //添加到文字		
        newCla->LitPtr[newCla->uLitNum] = new Literal(litSubT, EncodeLitCode(newClaId, newCla->uLitNum + 1), newCla, nullptr);
        newCla->LitPtr[newCla->uLitNum]->parentLitPtr = vNewR[i]; //母式文字，有R产生
        //newCla->LitPtr[newCla->uLitNum]->goalDeepth = vNewR[i]->goalDeepth;
        //20171020 计算演绎深度
        if (newCla ->deduceDeepth < (vNewR[i]->claPtr->deduceDeepth + 1)) {
            newCla ->deduceDeepth = vNewR[i]->claPtr->deduceDeepth + 1;
        }
        if (vNewR[i]->claPtr->isAxtom && newCla->isAxtom)
            newCla->isAxtom = true;
        else
            newCla->isAxtom = false;
        if (hasUnifGoalLit(fol, newCla->LitPtr[newCla->uLitNum])) {
            newCla->LitPtr[newCla->uLitNum]->goalDeepth = 1;
            if (newCla->goaldeepth > 1)
                newCla->goaldeepth = 1;
        } else {
            newCla->LitPtr[newCla->uLitNum]->goalDeepth = vNewR[i]->goalDeepth;
            if (newCla->goaldeepth > vNewR[i]->goalDeepth)
                newCla->goaldeepth = vNewR[i]->goalDeepth;
        }
        ++(newCla->uLitNum);
    }
    fol.initGenerateClaAttr(newCla);
    newClaId++;
    //string str;
    //newCla->toString(str);
    //cout<<"R:" << str << endl;
    return 221;
}

//增加非单元子句起步演绎，主要用于很久为用到的子句参与归结

UINT8 TriAlg::GenerateTriByRecodePathNoUnit(Formula& fol, Clause* givenCla, UINT32 &newClaId, BACKTYPE _backType, vector<Clause*> &chgCla) {
    if (_backType == NOBACK)//清除变量
    {
        assert(!(givenCla == nullptr));
        PreResLit = nullptr; //上轮找到的合一文字
        setRedundClaId.clear();
        //vOnlyDectNum.clear();
        vector<Literal*>().swap(vNewR);
        vNewR.reserve(8);
        vector<UINT16>().swap(vComparePos);
        ResClaID.clear();
        //ResClaID.insert(givenCla->uClaId); //记录第一个归结子句编号
        vector<Clause*>().swap(ResClaPtr);
        //ResClaPtr.push_back(givenCla); //记录第一个归结子句指针
        BackPathClear(); //重要：清除路径以及上轮归结中变元的绑定 
        stackVarChg.reserve(100);
    }
    //    if(givenCla == (Clause*)0x6b7770){
    //        string str;
    //        givenCla->toString(str);
    //        cout <<"起步子句:" <<str << endl;
    //    }
    RESULT unifResult; //是否合一
    bool isDeduct = false; //是否发生过归结
    Clause* candClaP = nullptr; // 被动归结子句（候选子句）
    Literal* candLitP = nullptr; //被动归结文字（候选文字）
    vector<Literal*>* vCandLit; //取相同文字的map集合
    UINT32 c = 0;
    UINT8 count = 0;
    bool findOnlyOut = false; //用于控制子句的文字三角形摆放
    //20170215 保存每次子句演绎的互补对单元子句
    claPair.clear();
    //设置停止三角形构建标志
    bool breakT = false;
    if (1) {
        UINT16 ActLitInd = 0;
        //非单元子句起步
        stable_sort(givenCla->LitPtr, givenCla->LitPtr + givenCla->uLitNum, SortRule::ActlitCmpTwo);
        for (; ActLitInd < givenCla->uLitNum; ++ActLitInd) {

            Literal* QLit = givenCla->LitPtr[ActLitInd];
            //根据文字互补谓词项对应的互补文字得到候选文字
            vCandLit = QLit->getPairPredLst();
            //没有互补对文字时重选，此时需要更换放入三角形中的文字，若没有可更换的文字，结束三角形演绎
            if (vCandLit->size() == 0) {
                continue;
            }
            if (_backType == NOBACK)
                stable_sort(vCandLit->begin(), vCandLit->end(), SortRule::claTwoCmp); //20170824 claTwoCmp->PoslitCmp//被动文字按子句个数进行排序  此处考虑用随机策略 //20170216
            INT32 pasLitInd = 0;
            bool find_Flag = true; //用于判断是否在遍历候选子句
            UINT16 tempLit = 0; //20170210 用于计算候选子句剩余文字最少
            UINT16 minLit = 128; //20170210 用于计算候选子句剩余文字最少
            INT32 tempInd = -1;
            setRedundClaId.clear();
            for (; pasLitInd < UINT32(vCandLit->size()); ++pasLitInd)//依次找到
            {
                candLitP = vCandLit->at(pasLitInd); //候选被动归结文字
                candClaP = candLitP->claPtr; // 被动归结子句（候选子句）
                //20171020 加入演绎深度限制
                //                if (candClaP->deduceDeepth > StrategyParam::deduceDepth) {
                //                    if ((pasLitInd == UINT32(vCandLit->size()) - 1) && (tempInd != -1))//遍历完成
                //                    {
                //                        pasLitInd = tempInd - 1;
                //                        find_Flag = false;
                //                        continue;
                //                    }
                //                    continue;
                //                }
                if (StrategyParam::useSaturate) {
                    if (fol.setDeductCla.find(candClaP) == fol.setDeductCla.end()) {
                        //不在演绎列表里
                        if ((pasLitInd == UINT32(vCandLit->size()) - 1) && (tempInd != -1))//遍历完成
                        {
                            pasLitInd = tempInd - 1;
                            find_Flag = false;
                            continue;
                        }
                        continue;
                    }
                }
                //单元子句不在此处理
                if ((candClaP->uLitNum == 1)) {
                    if ((pasLitInd == UINT32(vCandLit->size()) - 1) && (tempInd != -1))//遍历完成
                    {
                        pasLitInd = tempInd - 1;
                        find_Flag = false;
                        continue;
                    }
                    continue;
                }
                //发生冗余的子句在本次三角形中不再使用
                if (setRedundClaId.find(candLitP->uLitCode) != setRedundClaId.end()) {
                    if ((pasLitInd == UINT32(vCandLit->size()) - 1) && (tempInd != -1))//遍历完成
                    {
                        pasLitInd = tempInd - 1;
                        find_Flag = false;
                        continue;
                    }
                    continue;
                }
                /*同一子句中文字不进行比较;文字条件限制; -- 这里允许自归结 同一个子句在一个三角形中最多2次参与归结*/
                if (candClaP->uClaId == QLit->Row() || ResClaID.find(candClaP->uClaId) != ResClaID.end()) {
                    if ((pasLitInd == UINT32(vCandLit->size()) - 1) && (tempInd != -1))//遍历完成
                    {
                        pasLitInd = tempInd - 1;
                        find_Flag = false;
                        continue;
                    }
                    continue;
                }
                //限制子句中文字数个数
                //                if (vNewR.size() + givenCla->uLitNum + candClaP->uLitNum - 2 > StrategyParam::R_MAX_NUM)
                //                    continue;
                //不允许跟上一轮母式进行归结  
                if ((candLitP->parentLitPtr && candLitP->parentLitPtr->claPtr == givenCla) || (QLit->parentLitPtr && QLit->parentLitPtr->claPtr == candClaP)) {
                    if ((pasLitInd == UINT32(vCandLit->size()) - 1) && (tempInd != -1))//遍历完成
                    {
                        pasLitInd = tempInd - 1;
                        find_Flag = false;
                        continue;
                    }
                    continue;
                }
                if (find_Flag)//注意:遍历候选子句切换到实际构建三角形时需要将遍历的合一清除，需要考虑特殊清空无效的合一
                { //注意:还需考虑从实际构建三角形切换到遍历候选子句的清空，需要考虑是否将有效合一给清除了
                    //查看能否生成单元子句
                    unifResult = unify.Issyn_Findtwo(fol, QLit, candLitP, tempLit);
                    if (unifResult == RULEOK) {
                        //此时需要判断候选子句的剩余文字
                        if (tempLit == 1) {
                            --pasLitInd; //保存下标值
                            find_Flag = false;
                            continue;
                        } else if (tempLit < minLit) {
                            minLit = tempLit;
                            tempInd = pasLitInd;
                            if (pasLitInd == UINT32(vCandLit->size()) - 1)//遍历完成
                            {
                                pasLitInd = tempInd - 1;
                                find_Flag = false;
                            }
                            continue;
                        } else {
                            if (pasLitInd == UINT32(vCandLit->size()) - 1)//遍历完成
                            {
                                if (tempInd == -1) {//表示没有找到合适的二元演绎,退出
                                    break;
                                } else {
                                    pasLitInd = tempInd - 1;
                                    find_Flag = false;
                                }
                            }
                            continue;
                        }
                    } else {//如果不存在互补对子句时
                        //当遍历完了整个候选子句集时，恢复下标
                        if (pasLitInd == UINT32(vCandLit->size()) - 1)//遍历完成
                        {
                            if (tempInd == -1) {//表示没有找到合适的二元演绎,退出
                                break;
                            } else {
                                pasLitInd = tempInd - 1;
                                find_Flag = false;
                            }
                        }
                        continue;
                    }
                }
                unifResult = unify.Issyn_two(fol, QLit, candLitP); //是否找到合一文字
                if (unifResult == RULEOK) {//输出路径由vOnlyOutTri标志为归结和vOutTri两部分组成
                    stackVarChg.push_back(unify.vVarBindT); //添加到替换堆栈中	 //版本2需要重点考虑
                    //此处需处理的时起步子句，处理主动归结子句: 主对角线文字  R  演绎路径（由互补对单元子句和参与归结子句构成，三角形构建完时生成）
                    //处理单文字子句的演绎路径
                    if (!vOnlyOutDect.empty()) {
                        UINT32 dlen = vOnlyOutDect.size();
                        for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                            vOutTri.push_back(vOnlyOutDect[size_d]);
                        }
                    }
                    if (ResClaID.empty()) {
                        for (UINT16 i = 0; i < givenCla->uLitNum; ++i) {
                            Literal* givenLit = givenCla->LitPtr[i];

                            vOutTri.push_back(givenLit);
                            if (givenLit == QLit) {
                                //此时为主对角线文字，加入到vOnlyOutTri
                                //vOnlyOutTri.push_back(QLit);
                                //保存构建三角形的所有主对角线文字
                                claPair.push_back(QLit);
                                continue;
                            }
                        }
                    }
                    //stackVarChg.push_back(unify.vVarBindT); //添加到替换堆栈中	 //版本2需要重点考虑
                    //0:归结次数>稳定度 1:无(由原始顺序为准) 2:稳定度>归结次数
                    stable_sort(candClaP->LitPtr, candClaP->LitPtr + candClaP->uLitNum, SortRule::ActlitCmp);
                    UINT8 sumDrop = 0;
                    findOnlyOut = true;
                    vector<Literal*> leftLiter; //20170305 用于保存剩余文字，以便选择最优的文字放入三角形中
                    for (UINT16 m = 0; m < candClaP->uLitNum; m++) {
                        if (candClaP->LitPtr[m]->isDel)//互补文字
                        {
                            sumDrop++;
                            vOutTri.push_back(candClaP->LitPtr[m]);
                            continue;
                        }
                        //20170305 idea 有效解决冗余:优先选择与单元子句一样的文字(合一)，另外考虑徐老师讲的同一子句可以合并的文字一定要合并
                        leftLiter.push_back(candClaP->LitPtr[m]);
                    }

                    if (!leftLiter.empty()) {
                        for (UINT16 m = 0; m < leftLiter.size(); m++) {
                            //处理候选子句的剩余文字，需要选择放入三角形主对角线上和三角形上方R
                            if (!leftLiter[m]->isDel && findOnlyOut) {//被选归结子句剩下的文字,其中第一个放在对角线上,其余放入R中
                                vOutTri.push_back(leftLiter[m]);
                                //vOnlyOutTri.push_back(leftLiter[m]);
                                vNewR.push_back(leftLiter[m]);
                                findOnlyOut = false;
                                //cout<<"三角形顶点"<<(candClaP->LitPtr[m]->subTerm->ToString())<<endl;
                            } else if (!leftLiter[m]->isDel &&!findOnlyOut) {//放入R中
                                count++;
                                vOutTri.push_back(leftLiter[m]);
                                vNewR.push_back(leftLiter[m]);

                            }
                        }
                    }
                    //20170305 end
                    //判断是否全部放入三角形中
                    if (vNewR.size() == 0) {
                        newCla = nullptr;
                        givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                        candClaP->isSDeduct = true; //在构建三角形过程中参与归结
                        if(!StrategyParam::orForCompition && (StrategyParam::problemDiv == 0))
                            cout << "得出结论:不可满足" << endl;
                        return true;
                    }
                    //20170908 此时判断冗余
                    if (1) {
                        //生成新子句(R) 
                        newCla = nullptr;
                        //20170215 用于判断最后的收尾归结子句全部落在三角形内的情况 但R不为空 
                        assert(vNewR.size() != 0);
                        //20170214 若所有的主对角线文字都没有找到满足条件互补的子句，则不输出R

                        for (size_t rInd = 0; rInd < vNewR.size() - 1; ++rInd) {
                            Literal* rA = vNewR[rInd];
                            for (size_t rIndB = rInd + 1; rIndB < vNewR.size();) {
                                Literal* rB = vNewR[rIndB];
                                if (rA->subTerm->iTermCode == rB->subTerm->iTermCode && unify.CheckEqn(rA->subTerm, rB->subTerm)) {
                                    swap(vNewR[rIndB], vNewR[vNewR.size() - 1]);
                                    vNewR.pop_back();
                                } else
                                    ++rIndB;
                            }
                        }
                        assert(vNewR.size() != 0); //20170211 考虑是否此处有R为0
                        newCla = new Clause(newClaId, 0);
                        newCla->isAxtom = true;
                        size_t uRsize = vNewR.size();
                        //文字排序
                        if (uRsize > 1)
                            stable_sort(vNewR.begin(), vNewR.end(), SortRule::LitCmp);
                        newCla->LitPtr = new Literal*[uRsize];
                        for (UINT16 i = 0; i < vNewR.size(); ++i) {

                            Term* litSubT = unify.GetNewTerm(vNewR[i]->subTerm, newCla); //参数1：文字谓词项，参数2：新子句指针
                            if (TNegEqn == GetCodeProp(litSubT->iTermCode)
                                    && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {//出现有剩余文字仍为不可满足的清空，需要考虑这种清空 20170108
                                /*
                                delete(litSubT);*/--uRsize;
                                //delete(newCla->LitPtr[]);
                                continue;
                            }

                            if (newCla->uFuncDepth < litSubT->uLevel)newCla->uFuncDepth = litSubT->uLevel;
                            newCla->uVarCount += litSubT->uVarCount;
                            //添加到文字		
                            newCla->LitPtr[newCla->uLitNum] = new Literal(litSubT, EncodeLitCode(newClaId, newCla->uLitNum + 1), newCla, nullptr);
                            newCla->LitPtr[newCla->uLitNum]->parentLitPtr = vNewR[i]; //母式文字，有R产生
                            //newCla->LitPtr[newCla->uLitNum]->goalDeepth = vNewR[i]->goalDeepth;
                            //20171020 计算演绎深度
                            if (newCla ->deduceDeepth < (vNewR[i]->claPtr->deduceDeepth + 1)) {
                                newCla ->deduceDeepth = vNewR[i]->claPtr->deduceDeepth + 1;
                            }
                            if (vNewR[i]->claPtr->isAxtom && newCla->isAxtom)
                                newCla->isAxtom = true;
                            else
                                newCla->isAxtom = false;
                            if (hasUnifGoalLit(fol, newCla->LitPtr[newCla->uLitNum])) {
                                newCla->LitPtr[newCla->uLitNum]->goalDeepth = 1;
                                if (newCla->goaldeepth > 1)
                                    newCla->goaldeepth = 1;
                            } else {
                                newCla->LitPtr[newCla->uLitNum]->goalDeepth = vNewR[i]->goalDeepth;
                                if (newCla->goaldeepth > vNewR[i]->goalDeepth)
                                    newCla->goaldeepth = vNewR[i]->goalDeepth;
                            }
                            ++(newCla->uLitNum);
                        }
                        //++newClaId;
                        //20171020 对子句的含等词的文字进行项序处理
                        if (StrategyParam::termRewriting != 2) {
                            newCla->directEqn();
                        }
                        //                        if (claHasPureLit(fol, newCla)) {
                        //                            newCla->DelLits(false);
                        //                            delete(newCla);
                        //                            //还原
                        //                            vOutTri.clear();
                        //                            //vOnlyOutTri.clear();
                        //                            vNewR.clear();
                        //                            claPair.clear();
                        //                            if (!vOnlyOutDect.empty()) {
                        //                                UINT32 dlen = vOnlyOutDect.size();
                        //                                for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                        //                                    vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                        //                                }
                        //                            }
                        //                            BackPathClear(); 
                        //                            continue;
                        //                        }
                        //判断冗余
                        vector<UINT32>invaildLitId; //
                        string rundMsg; //冗余信息
                        Subsumption subsump; //(MOSTRIGHT)
                        //参数1 被测的子句指针 参数2 整形数组 参数3 字符串 记录冗余信息
                        bool isRundacyR = subsump.GenCla(fol, newCla, invaildLitId, rundMsg);
                        if (isRundacyR) {
                            newCla->DelLits(false);
                            delete(newCla);
                            //还原
                            vOutTri.clear();
                            //vOnlyOutTri.clear();
                            vNewR.clear();
                            claPair.clear();
                            if (!vOnlyOutDect.empty()) {
                                UINT32 dlen = vOnlyOutDect.size();
                                for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                    vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                                }
                            }
                            BackPathClear();
                            tempInd = -1;
                            find_Flag = true;
                            tempLit = 0;
                            minLit = 128;
                            //if (ActLitInd == givenCla->uLitNum - 1)
                            setRedundClaId.insert(candLitP->uLitCode); //用于本次三角形不在使用已经归结过的子句
                            continue;
                        } else {
                            ++newClaId;
                            fol.initGenerateClaAttr(newCla);
                            //20170215需要为参与本单元的三角形演绎单元子句设置权重
                            if (!vOnlyDectNum.empty()) {
                                for (UINT8 nm = 0; nm < vOnlyDectNum.size(); nm++) {
                                    claPair.push_back(vOnlyDectNum[nm]);
                                    if (vOnlyDectNum[nm]->claPtr->uLitNum == 1)
                                        vOnlyDectNum[nm]->claPtr->adeductNum++; //单元子句权重加1
                                }
                            }
                            givenCla->noUnitDeductTimes++; //主动归结次数+1
                            if (givenCla->noUnitDeductTimes == 5000)
                                givenCla->noUnitDeductTimes = 0;
                            QLit->uActive++;
                            if (QLit->uActive == 1000)
                                QLit->uActive = 0;
                            givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                            candLitP->sDuct++; //候选文字权重加一 须重新文字排序
                            candClaP->noUnitDeductTimes++; //被动归结次数+1
                            if (candClaP->noUnitDeductTimes == 5000)
                                candClaP->noUnitDeductTimes = 0;
                            candClaP->isSDeduct = true; //在构建三角形过程中参与归结

                            if (RULEOK == unifResult) {
                                isDeduct = true;
                            }
                            breakT = true;
                            break;
                        }
                    }
                } else {
                    //清除合一规则检查失败时，被置为isSdeduct为true的子句
                    if (!vOnlyOutDect.empty()) {
                        UINT32 dlen = vOnlyOutDect.size();
                        for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                            vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                        }
                    }
                }
            }//20170210 候选子句外循环  找互补对外循环体
            if (breakT)
                break;
        }//20170210 主动子句外循环
        ResClaID.insert(givenCla->uClaId);
        ResClaPtr.push_back(givenCla);
        //        givenCla = vOnlyOutTri[c]->claPtr;
    }//20170210 构建三角形结束外循环
    if (!breakT) {
        allNoPair = true;
        return 33;
    }
    //    //生成新子句(R) 并输出演绎结果中
    //    newCla = nullptr;
    //    //20170215 用于判断最后的收尾归结子句全部落在三角形内的情况 但R不为空 
    //    assert(vNewR.size() != 0);
    //    //20170214 若所有的主对角线文字都没有找到满足条件互补的子句，则不输出R
    //   
    //    for (size_t rInd = 0; rInd < vNewR.size() - 1; ++rInd) {
    //        Literal* rA = vNewR[rInd];
    //        for (size_t rIndB = rInd + 1; rIndB < vNewR.size();) {
    //            Literal* rB = vNewR[rIndB];
    //            if (rA->subTerm->iTermCode == rB->subTerm->iTermCode && unify.CheckEqn(rA->subTerm, rB->subTerm)) {
    //                swap(vNewR[rIndB], vNewR[vNewR.size() - 1]);
    //                vNewR.pop_back();
    //            } else
    //                ++rIndB;
    //        }
    //    }
    //    assert(vNewR.size() != 0);//20170211 考虑是否此处有R为0
    //    newCla = new Clause(newClaId, 0);
    //    size_t uRsize = vNewR.size();
    //    //文字排序
    //    if (uRsize > 1)
    //        stable_sort(vNewR.begin(), vNewR.end(), SortRule::LitCmp);
    //    newCla->LitPtr = new Literal*[uRsize];
    //    for (UINT16 i = 0; i < vNewR.size(); ++i) {
    //
    //        Term* litSubT = unify.GetNewTerm(vNewR[i]->subTerm, newCla); //参数1：文字谓词项，参数2：新子句指针
    //        if (TNegEqn == GetCodeProp(litSubT->iTermCode)
    //                && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {//出现有剩余文字仍为不可满足的清空，需要考虑这种清空 20170108
    //            /*
    //            delete(litSubT);*/
    //--uRsize;
    //            //delete(newCla->LitPtr[]);
    //            continue;
    //        }
    //
    //        if (newCla->uFuncDepth < litSubT->uLevel)newCla->uFuncDepth = litSubT->uLevel;
    //        newCla->uVarCount += litSubT->uVarCount;
    //        //添加到文字		
    //        newCla->LitPtr[newCla->uLitNum] = new Literal(litSubT, EncodeLitCode(newClaId, newCla->uLitNum + 1), newCla, nullptr);
    //        newCla->LitPtr[newCla->uLitNum]->parentLitPtr = vNewR[i]; //母式文字，有R产生
    //        newCla->LitPtr[newCla->uLitNum]->goalDeepth = vNewR[i]->goalDeepth;
    //        ++(newCla->uLitNum);
    //    }
    //    newClaId++;
    //    //string str;
    //   //newCla->toString(str);
    //    //cout<<"R:" << str << endl;
    return 44;
}

bool TriAlg::judgeDemodRedundent(Formula& fol, Clause* cla, UINT32& uNewClaID) {//preGenCla 记录新生成的子句
    if (StrategyParam::termReRedund == false) {
        return false;
    }
    if (fol.eqnDemod.size() == 0)
        return false;
    if (fol.eqnDemod.find(cla) != fol.eqnDemod.end())
        return false;
    bool flag = false;
    varBindTerm.clear(); //保存每个子句在调解过程中的替换项
    vector<Clause*> eqnLit; //记录调解的等词单元子句
    eqnLit.reserve(2);
    for (UINT32 i = 0; i < cla->uLitNum; ++i) {
        //若策略要求：等词项重写，而该文字为非等词，则continue
        if ((StrategyParam::termRewriting == 0)&&(cla->LitPtr[i]->subTerm->isPLitTerm()))
            continue;
        if (demodulatorLitSaturate(fol, cla->LitPtr[i], &eqnLit)) {
            flag = true;
        }
    }
    //如果子句有项进行了调解,则要进行下一步的处理:1. 生成新子句 2. 清除绑定的替换项 3. 删除原始子句
    if (!flag) {
        unify.ClearVarBind(varBindTerm);
        return false; //子句不能调解
    } else {
        //1.生成新子句
        vector<Literal*> vInsertNewR;
        vInsertNewR.reserve(6);
        for (UINT32 i = 0; i < cla->uLitNum; ++i)
            vInsertNewR.push_back(cla->LitPtr[i]);
        for (size_t rInd = 0; rInd < vInsertNewR.size() - 1; ++rInd) {
            Literal* rA = vInsertNewR[rInd];
            for (size_t rIndB = rInd + 1; rIndB < vInsertNewR.size();) {
                Literal* rB = vInsertNewR[rIndB];
                if (rA->subTerm->iTermCode == rB->subTerm->iTermCode && unify.CheckEqn(rA->subTerm, rB->subTerm)) {
                    swap(vInsertNewR[rIndB], vInsertNewR[vInsertNewR.size() - 1]);
                    vInsertNewR.pop_back();
                } else
                    ++rIndB;
            }
        }
        Clause* newClaTmp = nullptr;
        if (!vInsertNewR.empty()) {
            //查看是否冗余20170101
            newClaTmp = new Clause(uNewClaID, 0);
            size_t uRsize = vInsertNewR.size();
            //文字排序
            if (uRsize > 1)
                stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmp);
            newClaTmp->LitPtr = new Literal*[uRsize];
            for (UINT16 i = 0; i < vInsertNewR.size(); ++i) {
                Term* litSubT = unify.GetNewTermSuper(vInsertNewR[i]->subTerm, newClaTmp); //参数1：文字谓词项，参数2：新子句指针
                if (TNegEqn == GetCodeProp(litSubT->iTermCode)
                        && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {
                    /*
                    delete(litSubT);*/--uRsize;
                    //delete(newCla->LitPtr[]);
                    continue;
                }
                if (newClaTmp->uFuncDepth < litSubT->uLevel)newClaTmp->uFuncDepth = litSubT->uLevel;
                newClaTmp->uVarCount += litSubT->uVarCount;
                //添加到文字		
                newClaTmp->LitPtr[newClaTmp->uLitNum] = new Literal(litSubT, EncodeLitCode(uNewClaID, newClaTmp->uLitNum + 1), newClaTmp, nullptr);
                newClaTmp->LitPtr[newClaTmp->uLitNum]->parentLitPtr = vInsertNewR[i]; //母式文字，有R产生
                //newCla->LitPtr[newCla->uLitNum]->goalDeepth = vInsertNewR[i]->goalDeepth;       
                //cout<<to_string(newCla->uClaId)  + "]" <<"[" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitRow()) + "_" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitCol()) + "]" << newCla->LitPtr[newCla->uLitNum]->subTerm->ToString()<<endl;  
                ++(newClaTmp->uLitNum);
            }
            if (uRsize == 0) {
                newClaTmp->DelLits(false);
                delete(newClaTmp);
                return false;                
            }
            ++uNewClaID;
            //20171020 对子句的含等词的文字进行项序处理
            if (StrategyParam::termRewriting != 2) {
                newClaTmp->directEqn();
            }
            vector<UINT32>invaildLitId; //
            string rundMsg; //冗余信息
            Subsumption subsump; //(MOSTRIGHT)
            //参数1 被测的子句指针 参数2 整形数组 参数3 字符串 记录冗余信息
            bool isRundacyR = subsump.GenCla(fol, newClaTmp, invaildLitId, rundMsg);
            unify.ClearVarBind(varBindTerm);
            newClaTmp->DelLits(false);
            delete(newClaTmp);
            vInsertNewR.clear();
            vector<Literal*>().swap(vInsertNewR);
            //FileOp::RInvaildInfoOut(rundMsg, StartId);
            if (isRundacyR) {
                return true; //调解后子句变成冗余,原始的子句也得删除
            }
            return false; //子句可以调解,并生成了新子句
        }
    }
    return false;
}

//文字的项，若满足一定条件能与满足重写的等词单元子句的左项合一，则该文字的项被满足重写的等词单元子句的右项替换
int TriAlg::demodulatorLitSaturate(Formula& fol, Literal* lit, vector<Clause*>* eqnLit) {
    bool flag = false;
    //    UINT8 funCount = 0;
    //    for(UINT32 i=0; i< lit->subTerm->uSubTermNum; ++i) {//谓词项去掉 变元项去掉
    //        //Term* termBind = triAlg.unify.GetBindingT(termVec[i]);
    //        Term* demodTerm = lit->subTerm->subTermPtr[i];
    //        demodulatorTermSaturate(fol, triAlg,demodTerm, uNewClaID, eqnLit);
    //    }
    vector<Term*> termVec;
    termVec.reserve(6);
    lit->subTerm->recordTerm(&termVec); //记录文字的每个项
    assert(termVec.size() > 0);
    UINT8 funCount = 0;
    for (UINT32 i = 1; i < termVec.size(); ++i) {//谓词项去掉 变元项去掉
        //Term* termBind = triAlg.unify.GetBindingT(termVec[i]);
        if (termVec[i]->isVar())//变元项
            continue;
        else if (termVec[i]->vBinding) {
            if (termVec[i]->isFuncTerm()) {
                funCount = termVec[i]->uSubTermNum;
            }
        } else if (termVec[i]->isFuncTerm()) {//函数项
            if (demodulatorTermSaturate(fol, termVec[i], eqnLit)) {
                flag = true;
                funCount = termVec[i]->uSubTermNum;
            }
        } else {//常元项
            continue;
        }
        if (funCount != 0) {
            i += funCount;
            funCount = 0;
        }
    }
    if (flag)
        return 1;
    else
        return 0;
}

int TriAlg::demodulatorTermSaturate(Formula& fol, Term* term, vector<Clause*>* eqnLit) {
    bool flag = false;

    vector<Term*> chgVarT;
    vector<Term*> chgVarTEqn;
    chgVarT.reserve(6);
    chgVarTEqn.reserve(6);
    vector<Literal*> vSimplyNewR;
    vSimplyNewR.reserve(6);
    //1.计算项的个数
    UINT32 termCount = 0;
    UINT32 varTermCount = 0;
    term->countTerm(termCount);
    term->countVarTerm(varTermCount);
    //20171022 计算非重复变元项的个数
    vector<INT32> saveTerm;
    saveTerm.reserve(6);
    UINT32 varUqTermCount = 0;
    term->countUqVarTerm(varUqTermCount, saveTerm);
    saveTerm.clear();
    vector<INT32>().swap(saveTerm);

    if ((termCount == 1))//变元或常元不做替换
        return 0;
    set<Clause*>::iterator claP_it = fol.eqnDemod.begin();
    for (; claP_it != fol.eqnDemod.end();) {
        if ((*claP_it)->LitPtr == nullptr) {
            ++claP_it;
            continue;
        }
        Term* demodulGoal = (*claP_it)->LitPtr[0]->subTerm->subTermPtr[0]; //查看这两个项能否合一
        //        demodulGoal->Print();
        //        cout<<endl;
        //        cout<<"------------"<<endl;
        //        term->Print();
        //        cout<<endl;
        UINT32 termGoalCount = 0;
        UINT32 varTermGoalCount = 0;
        demodulGoal->countTerm(termGoalCount);
        demodulGoal->countVarTerm(varTermGoalCount);

        //20171022 计算非重复变元项的个数
        vector<INT32> saveDemodulGoal;
        saveDemodulGoal.reserve(6);
        UINT32 varUqDemodulGoalCount = 0;
        demodulGoal->countUqVarTerm(varUqDemodulGoalCount, saveDemodulGoal);
        saveDemodulGoal.clear();
        vector<INT32>().swap(saveDemodulGoal);
        //当替换的非重复变元项不一致时,不重写
        //        if(varUqTermCount != varUqDemodulGoalCount){
        //            ++claP_it;
        //            continue;
        //        }
        //20171020 这个是关键,必须要保证项重写的合理性  demodulGoal
        if ((term->isFuncTerm()) &&(demodulGoal->isFuncTerm()) && (term->iTermCode != demodulGoal->iTermCode)) {
            ++claP_it;
            continue;
        }
        if (termCount < termGoalCount) {
            ++claP_it;
            continue;
        }
        //        if((varTermCount != varTermGoalCount)){
        //            ++claP_it;
        //            continue;
        //        }
        //        if((term->IsShareVarLit()&&demodulGoal->IsSingleVarLit()) ||(demodulGoal->IsShareVarLit()&&term->IsSingleVarLit())){
        //            ++claP_it;
        //            continue;
        //        }
        bool demod = true;
        if (varTermCount == 0) {
            demod = true;
        } else if (varUqTermCount > varUqDemodulGoalCount) {
            demod = false;
        }
        //此时可以确定都是函数项
        //比较调解的两个项是否结构相同
        if (demod && term->similarTerm(demodulGoal)) {
            if (unify.pairFuncTermMguEqn(term, demodulGoal, chgVarT, chgVarTEqn)) {
                if (unify.GetBindingT(demodulGoal) == ((*claP_it)->LitPtr[0]->subTerm->subTermPtr[1])) {
                    unify.ClearVarBind(chgVarT);
                    unify.ClearVarBind(chgVarTEqn);
                } else {
                    if (find(eqnLit->begin(), eqnLit->end(), *claP_it) == eqnLit->end())
                        eqnLit->push_back(*claP_it);
                    //triAlg.unify.ClearVarBind(chgVarTEqn);
                    varBindTerm.insert(varBindTerm.end(), chgVarT.begin(), chgVarT.end());
                    varBindTerm.insert(varBindTerm.end(), chgVarTEqn.begin(), chgVarTEqn.end());
                    chgVarT.clear();
                    chgVarTEqn.clear();
                    term->vBinding = (*claP_it)->LitPtr[0]->subTerm->subTermPtr[1];
                    varBindTerm.push_back(term);
                    flag = true;
                    break;
                }
            } else {
                unify.ClearVarBind(chgVarT);
                unify.ClearVarBind(chgVarTEqn);
            }
        }
        ++claP_it;
    }
    if (flag)
        return 1;
    else
        return 0;
}

/*-------------
 * 生成新子句，并初始化新子句的部分属性：函数深度，变元个数，演绎深度，目标子句距离，文字个数
 * fol 子句集；vLit 生成新子句的文字来源集合；newClaId 新子句的Id
 * return 新生成子句的文字数
 -------------*/
UINT16 TriAlg::ProduceNewClause(Formula& fol, vector<Literal*>& vLit, const UINT32& newClaId) {
    newCla = nullptr;
    newCla = new Clause(newClaId, 0);
    
    UINT16 uRsize = vLit.size();
    
    newCla->isAxtom = true;
    
    if (uRsize > 1)
        stable_sort(vLit.begin(), vLit.end(), SortRule::LitCmp);
    
    newCla->LitPtr = new Literal*[uRsize];
    for (UINT16 i = 0; i < uRsize; i++) {
        Term* litSubT = unify.GetNewTerm(vLit[i]->subTerm, newCla);
        if (TNegEqn == GetCodeProp(litSubT->iTermCode) && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {
            --uRsize;
            delete(litSubT);
            continue;
        }
        if (newCla->uFuncDepth < litSubT->uLevel)
            newCla->uFuncDepth = litSubT->uLevel;
        newCla->uVarCount += litSubT->uVarCount;
        
        newCla->LitPtr[newCla->uLitNum] = new Literal(litSubT, EncodeLitCode(newClaId, newCla->uLitNum + 1), newCla, nullptr);
        newCla->LitPtr[newCla->uLitNum]->parentLitPtr = vLit[i];
        
        if (newCla->deduceDeepth < (vLit[i]->claPtr->deduceDeepth + 1))
            newCla->deduceDeepth = vLit[i]->claPtr->deduceDeepth + 1;
        if (vLit[i]->claPtr->isAxtom && newCla->isAxtom)
            newCla->isAxtom = true;
        else
            newCla->isAxtom = false;
        if (hasUnifGoalLit(fol, newCla->LitPtr[newCla->uLitNum])) {
            newCla->LitPtr[newCla->uLitNum]->goalDeepth = 1;
            if (newCla->goaldeepth > 1)
                newCla->goaldeepth = 1;
        }
        else {
            newCla->LitPtr[newCla->uLitNum]->goalDeepth = vLit[i]->goalDeepth;
            if (newCla->goaldeepth > vLit[i]->goalDeepth)
                newCla->goaldeepth = vLit[i]->goalDeepth;
        }
        ++(newCla->uLitNum);
    }
    
    return uRsize;
}

/*-----------
 * 一次演绎的路径回退：清除此次演绎涉及的变元替换，还原此次演绎涉及的主界线文字演绎状态isSDeduct，还原主界线，还原三角形，还原R文字
 * lastvOutTriSize 往前一次演绎的三角形文字数； lastRSize 往前一次演绎的R文字数；lastMainLits 往前一次演绎的主界线文字数
 -----------*/
void TriAlg::PathBack(const int lastvOutTriSize, const int lastRSize, const int lastMainLits) {
    //清除givenCla子句参与演绎涉及的变元替换
    if (!unify.vVarBindT.empty())
        unify.ClearVarBind(unify.vVarBindT);    
    
    //还原参与主界线文字的演绎状态isSDeduct
    if (!vOnlyOutDect.empty()) {
        UINT32 dlen = vOnlyOutDect.size();
        for (UINT32 m = 0; m < dlen; m++) {
            vOnlyOutDect[m]->claPtr->isSDeduct = false;
        }
    }
    
    //还原主界线
    int incMainLits = vOnlyOutTri.size() - lastMainLits;
    if (incMainLits > 0)
        vOnlyOutTri.pop_back();
    
    //还原三角形
    int incOutTriSize = vOutTri.size() - lastvOutTriSize;
    for (UINT16 m = 0; m < incOutTriSize; m++) {
        vOutTri.pop_back();
    }
    
    //还原R文字，即清除此次演绎产生的R文字
    int incRSize = vNewR.size() - lastRSize;
    for (UINT16 m = 0; m < incRSize; m++) {
        vNewR.pop_back();
    }
}

/*-------------
 * 打印三角形路径和R，输出R（三角形为形状3时使用）
 * startClaId 三角形当前演绎中的主界线咬钩文字所在子句ID
 -------------*/
void TriAlg::PrintTriAndOutputR(const UINT32& startClaId) {
    if (!StrategyParam::orForCompition)
        FileOp::CreateRunInfoFile(FileOp::runFileId);
    if (StrategyParam::divideTri) {
        if (!StrategyParam::orForCompition)
            *FileOp::ofRealInfoOut << "从编号为" + to_string(startClaId) + "子句开始构建三角形" << endl;
        //输出演绎路径					 
        PrintTriPath();
        if (!StrategyParam::orForCompition) {
            FileOp::WriteR(newCla);
            *FileOp::ofRealInfoOut << "|[Y]" << endl;
        }
    }
    if (/*StrategyParam::orForCompition*/true) {
        if (FileOp::runMode != 0)
            newCla->addRForCompetiton();

        string rStr = "";
        newCla->toString(rStr);
        string outClauses = PrintCompetitionOut(newCla->uClaId);
        int begPos = rStr.find_first_of("[") + 1;
        int endPos = rStr.find_first_of("]");
        string rId = rStr.substr(begPos, endPos - begPos);
        string rContext = rStr.substr(rStr.find_first_of("]") + 1);
        string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n" + "   inference(scs_inference,[]," + "[" + outClauses +"]" + ")).";

        *FileOp::ofOutput << out << endl;
    }   
}

/*-------------
 * 打印三角形路径和R，输出R（三角形为形状4时使用）
 * startClaId 三角形当前演绎中的主界线咬钩文字所在子句ID；discardClas 保存打印小三角形时候多余的子句
 -------------*/
void TriAlg::PrintTriAndOutputR(const UINT32& startClaId, vector<Clause*>& discardClas) {
    if (!StrategyParam::orForCompition)
        FileOp::CreateRunInfoFile(FileOp::runFileId);
    if (StrategyParam::divideTri) {
        if (!StrategyParam::orForCompition)
            *FileOp::ofRealInfoOut << "从编号为" + to_string(startClaId) + "子句开始构建三角形" << endl;
        //输出演绎路径
        if (discardClas.empty() == false) {
            for (int i = 0; i < discardClas.size(); i++) {
                discardClas[i]->isSDeduct = false;
            }
        }
        PrintTriPath();
        if (discardClas.empty() == false) {
            for (int i = 0; i < discardClas.size(); i++) {
                discardClas[i]->isSDeduct = true;
            }
        }    
        if (!StrategyParam::orForCompition) {
            FileOp::WriteR(newCla);
            *FileOp::ofRealInfoOut << "|[Y]" << endl;
        }
    }
    if (/*StrategyParam::orForCompition*/true) {
        if (FileOp::runMode != 0)
            newCla->addRForCompetiton();

        string rStr = "";
        newCla->toString(rStr);
        string outClauses = PrintCompetitionOut(newCla->uClaId);
        int begPos = rStr.find_first_of("[") + 1;
        int endPos = rStr.find_first_of("]");
        string rId = rStr.substr(begPos, endPos - begPos);
        string rContext = rStr.substr(rStr.find_first_of("]") + 1);
        string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n" + "   inference(scs_inference,[]," + "[" + outClauses +"]" + ")).";

        *FileOp::ofOutput << out << endl;
    }     
}

/*-------------
 * R文字冗余检查
 * 删除R中多余文字L，多余文字L满足的条件：
 * L所在的子句C，找到C中主界线文字LL；若LL在目前的三角形中没有下拉文字，则说明文字L在R中多余；否则不是多余文字。
 * 并将多余文字所在的子句C保存在数组discardClas中，以便后输出路径时使用。
 * vLitR 存储R中的文字； discardClas 保存R中多余文字所在的子句； isFlat 三角形是否是平顶（true 是；false 不是） 
 * 调用该函数，必须保证vLitR不为空，discardClas为空
 -------------*/
void TriAlg::LitRedunduntInR(vector<Literal*>& vLitR, vector<Clause*>& discardClas, bool isFlat) {
    for (int i = 0; i < vLitR.size(); ++i) {
        UINT16 countPair = 0;
        Clause *findCla = vLitR[i]->claPtr;
        if(findCla == vOutTri.back()->claPtr && !isFlat)
            continue;
        for (int j = 0; j < findCla->uLitNum; ++j) {
            if (find(vOnlyOutTri.begin(), vOnlyOutTri.end(), findCla->LitPtr[j]) != vOnlyOutTri.end()) {//找到对角线文字,查看互补对
                for (int k = 0; k < vOutTri.size(); ++k) {
                    if ((findCla->LitPtr[j]->isPairPred(vOutTri[k])) && (unify.CheckPairEqn(findCla->LitPtr[j]->subTerm, vOutTri[k]->subTerm))) {
                        ++countPair;
                        break;
                    }
                }
            }
        }
        if (countPair == 0) {//表示对角线没有互补对
            vLitR[i]->claPtr->isSDeduct = false;
            swap(vLitR[i], vLitR[vLitR.size() - 1]);
            vLitR.pop_back();
            --i;
        }
    }
    
//    for (int i = 0; i < vLitR.size(); i++) {
//        int index = -1;
//        bool havePair = false; 
//        Clause* findCla = vLitR[i]->claPtr;
//        Literal* mainLit = nullptr;
//        //若三角形为尖顶，则主界线最后一个文字必须保留，不能被删除
//        if (!isFlat && findCla == vOutTri.back()->claPtr)
//            continue;
//        //寻找findCla子句的主界线文字
//        for (int j = 0; j < findCla->uLitNum; j++) {
//            if (find(vOnlyOutTri.begin(), vOnlyOutTri.end(), findCla->LitPtr[j]) != vOnlyOutTri.end()) {
//                index = j;
//                break;  //找到主界线文字，break出去
//            }
//        }
//        mainLit = findCla->LitPtr[index];
//        //在三角形中确定主界线文字mainLit是否起到了下拉作用
//        for (UINT16 k = 0; k < vOutTri.size(); k++) {
//            if (mainLit->isPairPred(vOutTri[k]) && unify.CheckEqn(mainLit->subTerm, vOutTri[k]->subTerm)) {
//                havePair = true;    //起到了下拉作用，break出去
//                break;
//            }
//        }
//        //若没有起到下来作用，则从R中删除文字vLitR[i]，并保存文字vLitR[i]所在子句
//        if (!havePair) {
//            //保存多余文字vLitR[i]所在子句
//            if (find(discardClas.begin(), discardClas.end(), vLitR[i]->claPtr) == discardClas.end())
//                discardClas.push_back(vLitR[i]->claPtr);
//            //从R中删除文字vLitR[i]
//            swap(vLitR[i], vLitR[vLitR.size() - 1]);
//            vLitR.pop_back();
//            --i;
//        }
//    }
}

/*-----------
 * 从数组vLits中删除重复的文字
 * vLits 保存文字的数组
 -----------*/
void TriAlg::DeleteRepeatingLitFromVector(vector<Literal*>& vLits) {
    for (size_t i = 0; i < vLits.size() - 1; i++) {
        Literal* litA = vLits[i];
        for (size_t j = i + 1; j < vLits.size();) {
            Literal* litB = vLits[j];
            if (litA->subTerm->iTermCode == litB->subTerm->iTermCode && unify.CheckEqn(litA->subTerm, litB->subTerm)) {
                swap(vLits[j], vLits[vLits.size() - 1]);
                vLits.pop_back();
            } 
            else
                ++j;
        }
    }
}

/*----------
 * 三角形为形状2的演绎子句的剩余文字处理：1 R冗余文字检查；2 R重复文字检查；3 R文字数检查；4 R复杂度检查；5 R包含冗余性检查；路径的回退 和 输出R和路径 不在本函数处理
 * 形状2，已经生成了标准矛盾体，需要生成R。
 * fol 子句集； newClaId 新子句Id; givenCla 为演绎子句
 * 返回：0 正常退出；1 R文字数超限； 2 R的复杂度超限； 3 R为包含冗余； 5 R为新子句
 -----------*/
UINT16 TriAlg::SecondFormTriProcess(Formula& fol, UINT32& newClaId, Clause* givenCla) {
    UINT16 uRsize = 0;
    //保存中间式的文字
    vector<Literal*> vInsertNewR;
    vInsertNewR.reserve(8);
    
    //保存中间式R的冗余(多余)文字
    vector<Clause*> discardClas;
    discardClas.reserve(8);
    
    //将三角形上方文字放入vInsertNewR
    for (int i = 0; i < vNewR.size(); i++) {
        vInsertNewR.push_back(vNewR[i]);
    }
    
    /*step1 R中文字冗余检查*/
    if (StrategyParam::litRundent)
        LitRedunduntInR(vInsertNewR, discardClas, true);
    
    /*step2 R中重复文字检查*/
    DeleteRepeatingLitFromVector(vInsertNewR);
    
    /*step3 R中文字数的检查*/
    if ((vNewR.size() >= StrategyParam::R_MAX_NUM) || ((StrategyParam::R_INIT_MAX_NUM == givenCla->uLitNum)&&(givenCla->uLitNum > 10))) {
        vInsertNewR.clear();
        vector<Literal*>().swap(vInsertNewR);
        return 1;  //R中文字数超过限制
    }
    
    /*step4 生成新子句*/
    uRsize = ProduceNewClause(fol, vInsertNewR, newClaId);
    
    //若新生成的中间式子句含有等词，则进行项序处理
    if (StrategyParam::termRewriting != 2)
        newCla->directEqn();       
    
    if (uRsize == 0) {
        vInsertNewR.clear();
        vector<Literal*>().swap(vInsertNewR);
        delete(newCla);
        return 0;   //正常退出本函数
    }
    
    /*step5 R的复杂度判断*/
    if (newCla->compFuncDeepthCla() > StrategyParam::funcFixDeepth) {
        vInsertNewR.clear();
        vector<Literal*>().swap(vInsertNewR);
        newCla->DelLits(false);
        delete(newCla);         
        return 2;   //R的复杂度超过限制
    }           
    
    /*step6 R的包含冗余性检查*/
    if (StrategyParam::midRJudge) {
        vector<UINT32> invaildLitId;
        invaildLitId.reserve(6);
        string rundMsg;
        Subsumption subsump;
        bool isRundacyR = subsump.GenCla(fol, newCla, invaildLitId, rundMsg);
        if (isRundacyR) {
            vInsertNewR.clear();
            vector<Literal*>().swap(vInsertNewR);
            newCla->DelLits(false);
            delete(newCla); 
            return 3;   //R为包含冗余                                        
        }
    }   
    
    return 5;   //R为新子句
}

/*----------
 * 三角形为形状3的演绎子句的剩余文字处理：1 确定主界线文字；2 R复杂度检查；3 R包含冗余性检查；路径的回退 和 输出R和路径 不在本函数处理
 * fol 子句集； newClaId 新子句Id； lit 主界线最新的文字
 * 返回：0 正常退出；4 生成的主界线文字为纯文字 or 与已存在的主界线文字相同 2 R的复杂度超限； 3 R为包含冗余； 5 R为新子句
 -----------*/
UINT16 TriAlg::ThirdFormTriProcess(Formula& fol, UINT32& newClaId, Literal* lit) {
    UINT16 uRsize = 0;
    //保存中间式的文字
    vector<Literal*> vInsertNewR;
    vInsertNewR.reserve(8);
    
    /*step1 确定主界线文字，并检查该文字是否是纯文字 or 与主界线已有的文字相同*/
    if (lit->getPairPredLst()->empty() || (find(vOnlyOutTri.begin(), vOnlyOutTri.end(), lit) != vOnlyOutTri.end())) {  
        return 4;   //lit文字是纯文字
    }
    for (int i = 0; i < vOnlyOutTri.size(); i++) {
        Literal* mainLit = vOnlyOutTri[i];
        if (lit->isEqPred(mainLit) && unify.CheckEqnR(lit->subTerm, mainLit->subTerm))
            return 4;   //lit文字与主界线已有的文字相同 包括 P1(x11,x12)与P1(x21,x22)为相同（变元都没有替换）
    }
    vOnlyOutTri.push_back(lit);
    
    //不要求生成中间式，则退出函数
    if (StrategyParam::midNum == 0) {
        vInsertNewR.clear();
        vector<Literal*>().swap(vInsertNewR);
        return 0;   //不要求生成中间式，则退出函数
    }
    
    /*step2 更新三角形vOutTri的文字*/
    vOutTri.push_back(lit);
    
    /*step3 生成新子句*/
    vInsertNewR.push_back(lit);
    uRsize = ProduceNewClause(fol, vInsertNewR, newClaId);
    
    //若新生成的中间式子句含有等词，则进行项序处理
    if (StrategyParam::termRewriting != 2)
        newCla->directEqn();   
    
    if (uRsize == 0) {
        vInsertNewR.clear();
        vector<Literal*>().swap(vInsertNewR);
        delete(newCla);
        return 0;   //正常退出本函数
    }
    
    /*step4 R的复杂度判断*/
    if (newCla->compFuncDeepthCla() > StrategyParam::funcFixDeepth) {
        vInsertNewR.clear();
        vector<Literal*>().swap(vInsertNewR);
        newCla->DelLits(false);
        delete(newCla);       
        return 2;   //R的复杂度超过限制
    }           
    
    /*step5 R的包含冗余性检查*/
    if (StrategyParam::midRJudge) {
        vector<UINT32> invaildLitId;
        invaildLitId.reserve(6);
        string rundMsg;
        Subsumption subsump;
        bool isRundacyR = subsump.GenCla(fol, newCla, invaildLitId, rundMsg);
        if (isRundacyR) {
            vInsertNewR.clear();
            vector<Literal*>().swap(vInsertNewR);
            newCla->DelLits(false);
            delete(newCla); 
            return 3;   //R为包含冗余                                        
        }
    } 
    
    vInsertNewR.clear();
    vector<Literal*>().swap(vInsertNewR);
    
    return 5;   //R为新子句
}

/*----------
 * 三角形为形状4的演绎子句的剩余文字处理：1 确定主界线文字；2 R冗余文字检查；3 R文字数检查；4 R复杂度检查；5 R包含冗余性检查；路径的回退 和 输出R和路径 不在本函数处理
 * fol 子句集； newClaId 新子句Id； vInsertNewR 中间式的文字；discardClas 保存打印小三角形时候多余的子句
 * 返回：0 正常退出； 1 R文字数超限； 2 R的复杂度超限； 3 R为包含冗余； 4 生成的主界线文字为纯文字 or 与已存在的主界线文字相同； 5 R为新子句
 -----------*/
UINT16 TriAlg::FourthFormTriProcess(Formula& fol, UINT32& newClaId, vector<Literal*>& vInsertNewR, vector<Clause*>& discardClas) {
    UINT16 uRsize = 0;
    
    vector<Literal*> vTempLits;
    vTempLits.reserve(8);
    
    /*step1 确定主界线文字，并检查该文字是否是纯文字 or 与主界线已有的文字相同*/
    // <editor-fold defaultstate="collapsed" desc="确定主界线文字">
    //确定主界线文字和将givenCla子句中文字加入到三角形中
    bool tempFlag = false;
    for (UINT16 m = 0; m < vInsertNewR.size(); m++) {
        bool flag = false;
        for (auto& mainLit : vOnlyOutTri) {
            //不是纯文字 or 不与主界线已有的文字相同
            if (unify.CheckEqnR(vInsertNewR[m]->subTerm, mainLit->subTerm) == false && vInsertNewR[m]->getPairPredLst()->empty() == false) {
                swap(vInsertNewR[m], vInsertNewR[0]);
                flag = true;
                break;
            }
        }
        if (flag) {
            tempFlag = true;
            break;
        }
    }
    if (tempFlag == false)
        return 4;
    vOnlyOutTri.push_back(vInsertNewR[0]);  //确定主界线
    
    // </editor-fold>
    
    /*step2 更新三角形vOutTri的文字*/
    for (UINT16 m = 0; m < vInsertNewR.size(); m++) {
        vOutTri.push_back(vInsertNewR[m]);
        if (m != 0)
            vTempLits .push_back(vInsertNewR[m]);
    }
    
    //不要求生成中间式，则退出函数
    if (StrategyParam::midNum == 0) {
        vInsertNewR.clear();
        vector<Literal*>().swap(vInsertNewR);
        return 0;   //不要求生成中间式，则退出函数
    } 
    
    //此次演绎产生的剩余文字数超过限制
    if (vInsertNewR.size() > StrategyParam::midNum) {
        return 1;  //此次演绎产生的剩余文字数超过限制
    }
    
    /*step3 将上一个演绎时三角形上方文字放入vInsertNewR*/
    for (int i = 0; i < vNewR.size(); i++) {
        vInsertNewR.push_back(vNewR[i]);
    }
    
    /*step4 R中文字冗余检查*/
    if (StrategyParam::litRundent)
        LitRedunduntInR(vInsertNewR, discardClas, false);
    
    /*step5 R中重复文字检查*/
    DeleteRepeatingLitFromVector(vInsertNewR);
    
    /*step6 R中文字数的检查*/
    if (vInsertNewR.size() > StrategyParam::R_MAX_NUM) {
        return 1;  //R中文字数超过限制
    }
    
    /*step7 生成新子句*/
    uRsize = ProduceNewClause(fol, vInsertNewR, newClaId);
    
    //若新生成的中间式子句含有等词，则进行项序处理
    if (StrategyParam::termRewriting != 2)
        newCla->directEqn();
    
    if (uRsize == 0) {
        delete(newCla);
        return 0;   //正常退出本函数
    }
    
    /*step8 R的复杂度判断*/
    if (newCla->compFuncDeepthCla() > StrategyParam::funcFixDeepth) {
        newCla->DelLits(false);
        delete(newCla);
        return 2;   //R的复杂度超过限制
    }           
    
    /*step9 R的包含冗余性检查*/
    if (StrategyParam::midRJudge) {
        vector<UINT32> invaildLitId;
        invaildLitId.reserve(6);
        string rundMsg;
        Subsumption subsump;
        bool isRundacyR = subsump.GenCla(fol, newCla, invaildLitId, rundMsg);
        if (isRundacyR) {
            newCla->DelLits(false);
            delete(newCla); 
            return 3;   //R为包含冗余                                        
        }
    }
    
    /*step10 更新vNewR的文字*/
    for (UINT16 m = 0; m < vTempLits.size(); m++) {
        vNewR.push_back(vTempLits[m]);
    }
    
    return 5;   //R为新子句    
}

/*---------
 * 生成三角形的矛盾他分离式（即R）
 * fol 子句集； newClaId 新子句Id； isFlat 是否时平顶：false不是，true是
 * 返回：0 正常退出； 6 产生R
 ---------*/
UINT16 TriAlg::ProduceAndProcessR(Formula& fol, UINT32& newClaId, bool isFlat) {
    UINT16 uRsize = 0;
//    if (true) {
//        string str = "/home/ars01/Desktop/dist/aaa";
//        ofstream fout(str.c_str(), ios::app);
//        fout << "$$ vNewR.size() = " << vNewR.size() << endl;
//        fout.close();
//    }
    //保存中间式R的冗余(多余)文字
    vector<Clause*> discardClas;
    discardClas.reserve(8);
    
    /*step1 R中文字冗余检查*/
    if (StrategyParam::litRundent)
        LitRedunduntInR(vNewR, discardClas, isFlat);
    
    /*step2 R中重复文字检查*/
    DeleteRepeatingLitFromVector(vNewR);
    
    /*step3 生成新子句*/
    uRsize = ProduceNewClause(fol, vNewR, newClaId);
//    if (true) {
//        string str = "/home/ars01/Desktop/dist/aaa";
//        ofstream fout(str.c_str(), ios::app);
//        fout << "$$^^^ vNewR.size() = " << vNewR.size() << endl;
//        fout.close();
//    }
//    //若新生成的中间式子句含有等词，则进行项序处理
//    if (StrategyParam::termRewriting != 2)
//        newCla->directEqn();
    
    if (uRsize == 0) {
        delete(newCla);
        return 0;   //正常退出本函数
    }  
    
    fol.initGenerateClaAttr(newCla);
    newClaId++;
    
    return 6;   //R为新子句       
}

/*------------
 * 二元子句集中子句参与演绎
 * fol 子句集；candidateClaSet_binary 二元子句集；newlaId 新子句Id；firstIndex 要检查的主界线第一个文字在vOnlyOutTri中的下标；lastIndex 要检查的主界线最后一个文字在vOnlyOutTri中的下标
 * return： 1 演绎结果UNSAT；0 有子句参与三角形演绎;2 candidateClaSet_binary集合中没有一个子句参与三角形演绎；3 达到R文字数限制；4 没有一个子句参与三角形演绎，并且time-out；5 有子句参与三角形演绎，但time-out
 ------------*/
UINT16 TriAlg::BinaryClaDeduction(Formula& fol, vector<Clause*>& candidateClaSet_binary, UINT32& newClaId, vector<Clause*>& chgCla, const UINT32& firstIndex, const UINT32& lastIndex) {
    // <editor-fold defaultstate="collapsed" desc="定义以及初始化所需的变量">
    UINT16 resDeduct = 11; //记录二元子句集参与演绎的结果

    bool isDeduct = false;  //是否主动子句（即givenCla）能参与到演绎中来：false 不能；true 能
    bool isGloDeduct = false;   //是否整个三角形演绎中都没有子句参与演绎：false 是；true 否
    bool midGenR = false;   //是否产生了中间式：false 没有；true 有
        
    Clause* givenCla = nullptr; //主动子句（我形象称为钓竿子句），为候选子句中的子句
    Clause* candClaP = nullptr;  //被动子句（我形象称为咬钩子句），为主界线文字所在的子句
    
    Literal* QLit = nullptr;    //主动子句中的文字（我形象称为鱼钩文字），为givenCla中的文字
    Literal* candLitP = nullptr;    //被动子句中的文字（我形象称为咬钩文字），为candClaP中的文字
    
    vector<Literal*>* vCandLit = &vOnlyOutTri;  //保存主界线文字的集合（我形象称为鱼群文字集合）
    
    UINT32 cDeepth = 0; //candidateClaSet_binary集合中的下标
    
    RESULT unifResult = NOMGU;  //合一是否成功结果
    // </editor-fold>
    
    /*----------
     * 遍历一次二元子句集candidateClaSet_binary
     * （主界线寻找范围为[firstIndex, lastIndex]）
     * 退出本次while循环的条件：
     * 1 完成一次遍历二元子句集candidateClaSet_binary;
     * 2 达到运行时间限制
     * 3 得到UNSAT结论
     -----------*/
    int num = 0;
    while (true) {
        /*--------------------------------------
         * 一次while循环就是判断子句givenCla能否参与到演绎中来。
         * 先判断能否参与到演绎中来：
         * 若能：则检查R的冗余性并生成中间式；然后拷贝givenCla子句形成新子句插入到candidateClaSet_binary集合，拷贝参与演绎的主界线单元子句到主界线vOnlyOutTri文字集合中
         * 若不能，则更换下一个givenCla进行下一次循环判定；
         ---------------------------------------*/
        givenCla = candidateClaSet_binary[cDeepth]; //给givenCla赋值
        
        //对givenCla中文字进行排序
        stable_sort(givenCla->LitPtr, givenCla->LitPtr + givenCla->uLitNum, SortRule::ActlitCmp);
       
        /*--------------------------
         * 判断givenCla子句是否参与到演绎中来的方法：
         * 在要检查的主界线文字中去寻找givenCla中文字的互补对（即被主界线文字下来），
         * 若是剩余文字和产生的R符合演绎要求，则可确定该givenCla子句参与到演绎中来了；
         * 否则givenCla子句就不能参与到演绎中来。
         * 
         * 本次while循环中，符合演绎的要求为：
         * 1 givenCla演绎，最多产生阈值限制个数剩余文字（即演绎产生的主界线文字）
         * 2 givenCla演绎产生的中间式的复杂度小于阈值参数
         * 3 givenCla演绎产生主界线文字不能是纯文字
         * 4 givenCla演绎产生主界线文字不能与已存在的主界线文字相同
         ---------------------------*/
       
        /*若想重复使用子句，则通过拷贝该子句来获得新子句（拥有新的子句ID）插入到candidateClaSet_binary集合中来使用，这样就可以实现一个子句只能参与一次演绎*/
        //判断givenCla子句是否参与到演绎中来，首先givenCla得满足条件：不能是已经参与过演绎的子句
        if (processedBinaryClaId.find(givenCla->uClaId) == processedBinaryClaId.end()) {
            //遍历givenCla中文字QLit
            for (UINT16 ActLitInd = 0; ActLitInd < givenCla->uLitNum; ActLitInd++) {
                isDeduct = false;    //givenCla子句初始设置为：不能参与到演绎中来
                QLit = givenCla->LitPtr[ActLitInd]; //赋值鱼钩文字QLit
                /*----------------
                 * 通过QLit去主界线找互补对：
                 * 找到，则 进行规则检查 -> 进行R的检查判断 -> 生成中间式 -> givenCla子句参与到演绎中来了
                 ----------------*/
                for (UINT32 pasLitInd = firstIndex; pasLitInd <= lastIndex; pasLitInd++) {
                    candLitP = vCandLit->at(pasLitInd); //赋值咬钩文字
                    candClaP = candLitP->claPtr;    //得到咬钩文字所在的咬钩子句
                    
                    //检查鱼钩文字QLit与咬钩文字candLitP是否谓词互补：不是则continue换下一个咬钩文字
                    // <editor-fold defaultstate="collapsed" desc="步骤1：检查candLitP是否符合条件">
                    if (QLit->isPairPred(candLitP) == false)                  
                        continue;
                   
                    //检查鱼钩文字QLit所在子句candClaP是否是主界线上已经被拷贝过的单元子句：是则continue换下一个咬钩文字
                    if ((candClaP->uLitNum == 1) && (hasCpUintClaId.find(candClaP->uClaId) != hasCpUintClaId.end()))
                        continue;
                    //检查givenCla子句是否是拷贝子句且copyFrom为candLitP, copyTo是否与QLit相同：是则continue换下一个咬钩文字
                    if ((givenCla->clast == CopyTemp) && (givenCla->copyFrom == candLitP) && (unify.CheckEqnR(givenCla->copyTo->subTerm, QLit->subTerm))) 
                        continue;
                    // </editor-fold>
                    
                    //检查鱼钩文字QLit与咬钩文字candLitP是否能合一，若能是否通过规则检查，若通过则unifResult = RULEOK
                    // <editor-fold defaultstate="collapsed" desc="步骤2：鱼钩文字QLit与咬钩文字candLitP 合一判断与规则检查">
                    INT32 tempRsize = StrategyParam::R_MAX_NUM;
                    if (candLitP->claPtr->isGoal && (StrategyParam::R_MAX_NUM < candLitP->claPtr->uLitNum)) {
                        StrategyParam::R_MAX_NUM = vNewR.size() + candLitP->claPtr->uLitNum;
                    }                    
                    unifResult = unify.IssynLR(QLit, candLitP);
                    StrategyParam::R_MAX_NUM = tempRsize;
                    // </editor-fold>
                    
                    //鱼钩文字QLit与咬钩文字candLitP不能能合一 或 能合一但没通过规则检查
                    // <editor-fold defaultstate="collapsed" desc="步骤3.1：不能合一或规则不通过，进行以下处理，然后continue 更换下一个咬钩文字candLitP（转到步骤1）">
                    if (unifResult != RULEOK) {
                        if (!vOnlyOutDect.empty()) {
                            UINT32 dlen = vOnlyOutDect.size();
                            for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                            }
                        } 
                        continue;
                    }
                    // </editor-fold>
                    
                    //鱼钩文字QLit与咬钩文字candLitP能合一且通过规则检查(即unifResult = RULEOK)
                    // <editor-fold defaultstate="collapsed" desc="步骤3.2：对此次演绎，更新三角形，主界线，R，并生成中间式">
                    int lastvOutTriSize = vOutTri.size();   //上一次演绎的三角形中文字数
                    int lastRSize = vNewR.size();   //上一次演绎的R中文字数
                    int lastMainLits = vOnlyOutTri.size();  //上一次演绎的主界线文字数

                    UINT16 sumDrop = 0; //统计givenCla子句在此次演绎中演绎文字数（即下拉文字数）

                    vector<Literal*> vLeftLits; //保存givenCla子句在此次演绎中未参与演绎的文字（即剩余文字）
                    vLeftLits.reserve(8);
                    
                    //将此次演绎涉及的变元替换添加到三角形演绎的替换集合中
                    stackVarChg.push_back(unify.vVarBindT);

                    /*givenCla子句中文字放入三角形vOutTri的顺序是：先 下来文字； 然后 主界线文字； 最后二次剩余文字（即主界线以外的剩余文字）*/
                    //统计givenCla子句在此次演绎中：下拉的文字（并加入到三角形vOutTri中）；剩余的文字（放入数组vLeftLits）
                    for (UINT16 m = 0; m < givenCla->uLitNum; m++) {
                        if (givenCla->LitPtr[m]->isDrop) {
                            sumDrop++;
                            vOutTri.push_back(givenCla->LitPtr[m]);
                            continue;
                        }
                        vLeftLits.push_back(givenCla->LitPtr[m]);
                    }
                    
                    /*确定三角形演绎后的形状，然后对演绎子句givenCla剩余文字的操作*/
                    // <editor-fold defaultstate="collapsed" desc="确定三角形演绎后的形状，然后对演绎子句givenCla剩余文字的操作">
                    //形状1：平顶，三角形上方没有文字
                    if (vLeftLits.size() == 0 && vNewR.size() == 0) {
                        formTri = FLATNOLIT;
                    }
                    //形状2：平顶，三角形上方有文字
                    else if (vLeftLits.size() == 0 && vNewR.size() != 0) {  
                        formTri = FLATHAVELIT;
                    }
                    //形状3：尖顶，三角形上方没有文字（即此次演绎子句产生了1个剩余文字）
                    else if (vLeftLits.size() == 1 && vNewR.size() == 0) {
                        formTri = SPIRENOLIT;
                    }
                    //形状4：尖顶，三角形上方有文字（包括此次演绎子句产生了至少两个文字）
                    else if (vLeftLits.size() != 0) {
                        formTri = SPIREHAVELIT;
                    }
                    // </editor-fold>
                    
                    /*根据三角形形状，分类处理*/
                    // <editor-fold defaultstate="collapsed" desc="根据三角形形状，分类处理">
                    //为形状1：平顶，三角形上方没有文字，则UNSAT
                    if (formTri == FLATNOLIT) {
                        newCla = nullptr;
                        givenCla->isSDeduct = true;
                        candClaP->isSDeduct = true;
                        return 1;
                    }
                    //为形状2：平顶，三角形上方有文字。即演绎出标准矛盾体，暂时不做处理。考虑这个演绎出标准矛盾体的givenCla的权重增大
                    else if (formTri == FLATHAVELIT) {
                        
                        //暂时不处理
                    }
                    //为形状3：尖顶，三角形上方没有文字 
                    else if (formTri == SPIRENOLIT) {
                        UINT8 deductRes = 10;
                        //三角形为形状3的剩余文字处理：1 确定主界线文字；2 R冗余文字检查；3 R文字数检查；4 R复杂度检查；5 R包含冗余性检查
                        deductRes = ThirdFormTriProcess(fol, newClaId, vLeftLits[0]);
                        
                        //当中间式为：复杂度超限 or 包含冗余 or （生成的主界线文字为纯文字 or 与已存在的主界线文字相同），则回退路径
                        if (deductRes == 2 || deductRes == 3 || deductRes == 4) {
                            //路径回退
                            PathBack(lastvOutTriSize, lastRSize, lastMainLits);
                            
                            if (deductRes == 3 || deductRes == 4)
                                givenCla->reduntTimes++;    //更新冗余权重
                            
                            vLeftLits.clear();
                            vector<Literal*>().swap(vLeftLits);
                            continue;
                        }
                        //生成中间式，输出R和路径
                        else if (deductRes == 5) {
                            //修改givenCla子句和candClaP子句的演绎状态为true
                            // <editor-fold defaultstate="collapsed" desc="修改givenCla子句和candClaP子句的演绎状态为true">
                            if (candClaP->uLitNum == 1) 
                                candClaP->isSDeduct = true; //在构建三角形过程中参与归结 
                            givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                            // </editor-fold>
                            
                            //打印三角形路径和R，输出R
                            PrintTriAndOutputR(candClaP->uClaId);

                            //初始化新生成的中间式其他子句属性，并新生成的中间式加入到子句集fol中
                            // <editor-fold defaultstate="collapsed" desc="初始化新生成的中间式其他子句属性，并新生成的中间式加入到子句集fol中">
                            chgCla.push_back(newCla);
                            fol.InsertCla(newCla);
                            fol.setCla.insert(newCla);
                            fol.initGenerateClaAttr(newCla);
                            // </editor-fold>
                            
                            midGenR = true;
                            newClaId++;
                        }                        
                    }
                    //为形状4：尖顶，三角形上方有文字（包括此次演绎子句产生了至少两个文字）
                    else if (formTri == SPIREHAVELIT) {
                        vector<Clause*> discardClas;
                        discardClas.reserve(8);
                        
                        UINT8 deductRes = 10;
                        //三角形为形状4的剩余文字处理：1 确定主界线文字；2 R冗余文字检查；3 R文字数检查；4 R复杂度检查；5 R包含冗余性检查
                        deductRes = FourthFormTriProcess(fol, newClaId, vLeftLits, discardClas);
                        
                        //当中间式为：文字数超限 or 复杂度超限 or 包含冗余，则回退路径 or （生成的主界线文字为纯文字 or 与已存在的主界线文字相同），则回退路径
                        if (deductRes == 1 || deductRes == 2 || deductRes == 3 || deductRes == 4) {
                            //没有主界线的路径回退
                            PathBack(lastvOutTriSize, lastRSize, lastMainLits);
                            
                            if (deductRes == 3)
                                givenCla->reduntTimes++;    //更新冗余权重
                            
                            vLeftLits.clear();
                            vector<Literal*>().swap(vLeftLits);
                            
                            discardClas.clear();
                            vector<Clause*>().swap(discardClas);
                            
                            continue;
                        }
                        //生成中间式，输出R和路径
                        else if (deductRes == 5) {
                            //修改givenCla子句和candClaP子句的演绎状态为true
                            // <editor-fold defaultstate="collapsed" desc="修改givenCla子句和candClaP子句的演绎状态为true">
                            if (candClaP->uLitNum == 1) 
                                candClaP->isSDeduct = true; //在构建三角形过程中参与归结 
                            givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                            // </editor-fold>
                            
                            //打印三角形路径和R，输出R
                            PrintTriAndOutputR(candClaP->uClaId, discardClas);

                            //初始化新生成的中间式其他子句属性，并新生成的中间式加入到子句集fol中
                            // <editor-fold defaultstate="collapsed" desc="初始化新生成的中间式其他子句属性，并新生成的中间式加入到子句集fol中">
                            chgCla.push_back(newCla);
                            fol.InsertCla(newCla);
                            fol.setCla.insert(newCla);
                            fol.initGenerateClaAttr(newCla);
                            // </editor-fold>

                            midGenR = true;
                            newClaId++;
                            
                            discardClas.clear();
                            vector<Clause*>().swap(discardClas);
                        }                         
                    }
                    // </editor-fold>
                    vLeftLits.clear();
                    vector<Literal*>().swap(vLeftLits);
                    // </editor-fold>
                    //cout << givenCla->uLitNum << "  " << sumDrop << " (剩余文字" << givenCla->uLitNum - sumDrop << ", R中文字数" << vNewR.size() << ")    " << StrategyParam::midNum << endl; 
                    //givenCla演绎完成，更新此次演绎涉及的权重
                    // <editor-fold defaultstate="collapsed" desc="步骤4：givenCla演绎完成，更新此次演绎涉及的权重">
                    //参与此次演绎的主界线的单元子句主动演绎权重+1(注意只有种子子句才能更新权重）
                    if (!vOnlyDectNum.empty()) {
                        for (UINT8 m = 0; m < vOnlyDectNum.size(); m++) {
                            if (vOnlyDectNum[m]->claPtr->uLitNum == 1) {
                                if (vOnlyDectNum[m]->claPtr->clast == CopyTemp) 
                                    vOnlyDectNum[m]->claPtr->topCopyCla->adeductNum++;
                                vOnlyDectNum[m]->claPtr->adeductNum++;
                            } 
                        }
                    }
                    if (candClaP->uLitNum == 1) {
                        if (candClaP->clast == CopyTemp)
                            candClaP->topCopyCla->adeductNum++;
                        candClaP->adeductNum++;                        
                    }
                    
                    //givenCla子句中的鱼钩文字QLit演绎权重+1
                    QLit->sDuct++;
                    
                    //givenCla子句被动演绎权重增加
                    if (givenCla->clast == CopyTemp) {
                        if (givenCla->isAxtom = false)
                            givenCla->topCopyCla->pdeductNum += 1;
                        else
                            givenCla->topCopyCla->pdeductNum += 3;
                    }
                    if (givenCla->isAxtom = false)
                        givenCla->pdeductNum += 1;
                    else
                        givenCla->pdeductNum += 3;  
                    
                    //改变givenCla与candClaP的演绎状态为true
                    givenCla->isSDeduct = true;
                    candClaP->isSDeduct = true;
                    // </editor-fold>
                    
                    //拷贝此次演绎涉及的相关子句
                    // <editor-fold defaultstate="collapsed" desc="步骤5：拷贝此次演绎涉及的相关子句">
                    //拷贝单元子句
                    if (StrategyParam::useCpUintCla || true) {
                        if ((candClaP->uLitNum == 1) && candClaP->HasTermBind()) {	
                            //拷贝新的子句来使用
                            unify.copyUintCla(fol, candClaP, newClaId);	//* 拷贝的单元子句要插入到了主界线上（在它父子句的后面）
                            hasCpUintClaId.insert(candClaP->uClaId);
                        }
                        if (vOnlyDectNum.size() > 0) {
                            for (UINT16 s = 0; s < vOnlyDectNum.size(); ++s) {
                                if ((vOnlyDectNum[s]->claPtr->uLitNum == 1) && vOnlyDectNum[s]->claPtr->HasTermBind()) {
                                    //拷贝新的子句来使用
                                    unify.copyUintCla(fol, vOnlyDectNum[s]->claPtr, newClaId);
                                    hasCpUintClaId.insert(vOnlyDectNum[s]->claPtr->uClaId);
                                }
                            }
                        }
                    }
                    
                    //拷贝givenCla子句
                    if (midGenR && (StrategyParam::claReUseTimes != 0) && givenCla->isAxtom == false) {//2020:repaired
                        Clause* cpClaTmp = nullptr;
                        if (givenCla->topCopyCla == nullptr)
                            cpClaTmp = givenCla;
                        else
                            cpClaTmp = givenCla->topCopyCla;
                        Clause* cyCla = copyCla(fol, cpClaTmp, newClaId, candLitP, QLit);	//* 拷贝子句是放入到了fol.setCla的
                        cyCla->topCopyCla = cpClaTmp;
                        //插入到演绎子句列表中
                        vector<Clause*>::iterator insertInd = find(candidateClaSet_binary.begin(), candidateClaSet_binary.end(), givenCla);
                        candidateClaSet_binary.emplace(insertInd + 1, cyCla);	//*拷贝子句放在candidateClaSet的位置在它的父子句的后面，使得下一次的演绎又是givenCla的拷贝子句（相当于重复使用该子句）
                        midGenR = false;
                    }  
                    
                    //givenCla加入到已经演绎过的子句集合中
                    processedBinaryClaId.insert(givenCla->uClaId);
                    // </editor-fold>
                    
                    //更改此次演绎和有子句参与到三角形演绎来的成功标志
                    // <editor-fold defaultstate="collapsed" desc="步骤6：更改此次演绎和有子句参与到三角形演绎来的成功标志">
                    isDeduct = true;    //此次演绎成功
                    isGloDeduct = true; //有二元子句参与到三角形演绎来
                    globalDeduct = true;    //有子句参与到三角形演绎来
                    // </editor-fold>
                    //cout << givenCla->uClaId << "(" << givenCla->uLitNum << "); " << candClaP->uClaId << endl;
                    //givenCla子句成功演绎,break
                    break;
                }
                
                //givenCla子句成功参与到演绎中来
                if (isDeduct)
                    break;
            }
        }
        //运行时间检查
        // <editor-fold defaultstate="collapsed" desc="运行时间检查">
        clock_t end = clock();
        double time_s = (double)(end - StrategyParam::start) / (double)CLOCKS_PER_SEC;
        if (time_s > StrategyParam::firstTimeLimit * 60) {
            if (globalDeduct) {
                resDeduct = 5; //有子句参与三角形演绎，但time-out
                break;
            }
            else {
                resDeduct = 4;   //达到时间限制时，没有一个子句能参与到三角形演绎中来，退出本函数
                break;
            }
        }
        // </editor-fold>  
        
        //R文字数的检查
        if ((vNewR.size() >= StrategyParam::R_MAX_NUM) || (isDeduct && (StrategyParam::R_INIT_MAX_NUM == candClaP->uLitNum)&&(candClaP->uLitNum > 10))) {
            resDeduct = 3;
            break;
        }
        
        //检查遍历是否完成
        if (cDeepth == candidateClaSet_binary.size() - 1) { 
            //若遍历中，二元子句集合candidateClaSet_binary中没有一个子句参与到演绎中去
            if (!isGloDeduct) {
                resDeduct = 2; 
            }
            else 
                resDeduct = 0;
            break;
        }
        //更新下标：遍历二元子句集合candidateClaSet_binary的下一个子句
        cDeepth++;
    } 
    
    return resDeduct;
}

UINT16 TriAlg::NotBinaryClaDeduction(Formula& fol, vector<Clause*>& candidateClaSet_notBinary, vector<Clause*>& candidateClaSet_binary, UINT32& newClaId, vector<Clause*>& chgCla, UINT32& firstIndex, UINT32& lastIndex) {
    // <editor-fold defaultstate="collapsed" desc="定义以及初始化所需的变量">
    UINT16 resDeduct = 100; //记录非二元子句集参与演绎的结果
    UINT16 resBinary = 100; //记录二元子句集参与演绎的结果

    bool isDeduct = false;  //是否主动子句（即givenCla）能参与到演绎中来：false 不能；true 能
    bool isGloDeduct = false;   //是否整个三角形演绎中都没有子句参与演绎：false 是；true 否
    bool midGenR = false;   //是否产生了中间式：false 没有；true 有
        
    Clause* givenCla = nullptr; //主动子句（我形象称为钓竿子句），为候选子句中的子句
    Clause* candClaP = nullptr;  //被动子句（我形象称为咬钩子句），为主界线文字所在的子句
    
    Literal* QLit = nullptr;    //主动子句中的文字（我形象称为鱼钩文字），为givenCla中的文字
    Literal* candLitP = nullptr;    //被动子句中的文字（我形象称为咬钩文字），为candClaP中的文字
    
    vector<Literal*>* vCandLit = &vOnlyOutTri;  //保存主界线文字的集合（我形象称为鱼群文字集合）
    
    UINT32 cDeepth = 0; //candidateClaSet_notBinary集合中的下标
    
    RESULT unifResult = NOMGU;  //合一是否成功结果
    
    //种子子句充分使用完毕后，再次使用二元子句集所需要的变量
    vector<UINT32> vNotBinaryId;    //保存原始非二元子句集（candidateClaSet_notBinary）中子句的ID
    vNotBinaryId.reserve(16);
    for (INT32 m = 0; m < candidateClaSet_notBinary.size(); m++) {
        vNotBinaryId.push_back(candidateClaSet_notBinary[m]->uClaId);
    }
    UINT32 nextId = 0;  //记录vNotBinaryId中的元素
    UINT32 fullUse_Index = 1;   //nextId在vNotBinaryId中下标
    
    bool overFull = false;  //用于标记是否遍历到vNotBinaryId的最后一个元素：false 不是；true 是    
    bool addMain = false;   //一个子句参与演绎是否新增主界线文字：false 没有；true 有
    // </editor-fold>
    /*----------
     * 遍历一次非二元子句集candidateClaSet_notBinary
     * （主界线寻找范围为[firstIndex, lastIndex]）
     * 退出本次while循环的条件：
     * 1 完成一次遍历二元子句集candidateClaSet_notBinary(一个种子子句完全参与演绎后，需要再次使用二元子句集中子句参与演绎）;
     * 2 达到运行时间限制
     * 3 得到UNSAT结论
     -----------*/
    while (true) {
        /*--------------------------------------
         * 一次while循环就是判断子句givenCla能否参与到演绎中来。
         * 先判断能否参与到演绎中来：
         * 若能：则检查R的冗余性并生成中间式；然后拷贝givenCla子句形成新子句插入到candidateClaSet_notBinary集合，拷贝参与演绎的主界线单元子句到主界线vOnlyOutTri文字集合中
         * 若不能，则更换下一个givenCla进行下一次循环判定；
         ---------------------------------------*/
        givenCla = candidateClaSet_notBinary[cDeepth]; //给givenCla赋值
        
        if (fullUse_Index == vNotBinaryId.size()) {
            overFull = true;
        }
        else {
            nextId = vNotBinaryId[fullUse_Index];
        }        
        
        //对givenCla中文字进行排序
        stable_sort(givenCla->LitPtr, givenCla->LitPtr + givenCla->uLitNum, SortRule::ActlitCmp);
       
        /*若想重复使用子句，则通过拷贝该子句来获得新子句（拥有新的子句ID）插入到candidateClaSet_binary集合中来使用，这样就可以实现一个子句只能参与一次演绎*/
        //判断givenCla子句是否参与到演绎中来，首先givenCla得满足条件：不能是已经参与过演绎的子句
        if (setRedundClaId.find(givenCla->uClaId) == setRedundClaId.end()) {
            //遍历givenCla中文字QLit
            for (UINT16 ActLitInd = 0; ActLitInd < givenCla->uLitNum; ActLitInd++) {
                isDeduct = false;    //givenCla子句初始设置为：不能参与到演绎中来
                QLit = givenCla->LitPtr[ActLitInd]; //赋值鱼钩文字QLit
                /*----------------
                 * 通过QLit去主界线找互补对：
                 * 找到，则 进行规则检查 -> 进行R的检查判断 -> 生成中间式 -> givenCla子句参与到演绎中来了
                 ----------------*/
                for (UINT32 pasLitInd = 0; pasLitInd < UINT32(vCandLit->size()); pasLitInd++) {
                    candLitP = vCandLit->at(pasLitInd); //赋值咬钩文字
                    candClaP = candLitP->claPtr;    //得到咬钩文字所在的咬钩子句
                    
                    //检查鱼钩文字QLit与咬钩文字candLitP是否谓词互补：不是则continue换下一个咬钩文字
                    // <editor-fold defaultstate="collapsed" desc="步骤1：检查candLitP是否符合条件">
                    if (!QLit->isPairPred(candLitP))                  
                        continue;
                   
                    //检查鱼钩文字QLit所在子句candClaP是否是主界线上已经被拷贝过的单元子句：是则continue换下一个咬钩文字
                    if ((candClaP->uLitNum == 1) && (hasCpUintClaId.find(candClaP->uClaId) != hasCpUintClaId.end()))
                        continue;
                    //检查givenCla子句是否是拷贝子句且copyFrom为candLitP, copyTo是否与QLit相同：是则continue换下一个咬钩文字
                    if ((givenCla->clast == CopyTemp) && (givenCla->copyFrom == candLitP) && (unify.CheckEqnR(givenCla->copyTo->subTerm, QLit->subTerm))) 
                        continue;
                    // </editor-fold>
                    
                    //检查鱼钩文字QLit与咬钩文字candLitP是否能合一，若能是否通过规则检查，若通过则unifResult = RULEOK
                    // <editor-fold defaultstate="collapsed" desc="步骤2：鱼钩文字QLit与咬钩文字candLitP 合一判断与规则检查">
                    INT32 tempRsize = StrategyParam::R_MAX_NUM;
                    if (candLitP->claPtr->isGoal && (StrategyParam::R_MAX_NUM < candLitP->claPtr->uLitNum)) {
                        StrategyParam::R_MAX_NUM = vNewR.size() + candLitP->claPtr->uLitNum;
                    }                    
                    unifResult = unify.IssynLR(QLit, candLitP);
                    StrategyParam::R_MAX_NUM = tempRsize;
                    // </editor-fold>
                    
                    //鱼钩文字QLit与咬钩文字candLitP不能能合一 或 能合一但没通过规则检查
                    // <editor-fold defaultstate="collapsed" desc="步骤3.1：不能合一或规则不通过，进行以下处理，然后continue 更换下一个咬钩文字candLitP（转到步骤1）">
                    if (unifResult != RULEOK) {
                        if (!vOnlyOutDect.empty()) {
                            UINT32 dlen = vOnlyOutDect.size();
                            for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                            }
                        } 
                        continue;
                    }
                    // </editor-fold>
                    
                    //鱼钩文字QLit与咬钩文字candLitP能合一且通过规则检查(即unifResult = RULEOK)
                    // <editor-fold defaultstate="collapsed" desc="步骤3.2：对此次演绎，更新三角形，主界线，R，并生成中间式">
                    int lastvOutTriSize = vOutTri.size();   //上一次演绎的三角形中文字数
                    int lastRSize = vNewR.size();   //上一次演绎的R中文字数
                    int lastMainLits = vOnlyOutTri.size();  //上一次演绎的主界线文字数

                    UINT16 sumDrop = 0; //统计givenCla子句在此次演绎中演绎文字数（即下拉文字数）

                    vector<Literal*> vLeftLits; //保存givenCla子句在此次演绎中未参与演绎的文字（即剩余文字）
                    vLeftLits.reserve(8);
                    
                    //将此次演绎涉及的变元替换添加到三角形演绎的替换集合中
                    stackVarChg.push_back(unify.vVarBindT);
                    
                    /*givenCla子句中文字放入三角形vOutTri的顺序是：先 下来文字； 然后 主界线文字； 最后二次剩余文字（即主界线以外的剩余文字）*/
                    //统计givenCla子句在此次演绎中：下拉的文字（并加入到三角形vOutTri中）；剩余的文字（放入数组vLeftLits）
                    for (UINT16 m = 0; m < givenCla->uLitNum; m++) {
                        if (givenCla->LitPtr[m]->isDrop) {
                            sumDrop++;
                            vOutTri.push_back(givenCla->LitPtr[m]);
                            continue;
                        }
                        vLeftLits.push_back(givenCla->LitPtr[m]);
                    }
                    
                    /*确定三角形演绎后的形状，然后对演绎子句givenCla剩余文字的操作*/
                    // <editor-fold defaultstate="collapsed" desc="确定三角形演绎后的形状，然后对演绎子句givenCla剩余文字的操作">
                    //形状1：平顶，三角形上方没有文字
                    if (vLeftLits.size() == 0 && vNewR.size() == 0) {
                        formTri = FLATNOLIT;
                    }
                    //形状2：平顶，三角形上方有文字
                    else if (vLeftLits.size() == 0 && vNewR.size() != 0) {  
                        formTri = FLATHAVELIT;
                    }
                    //形状3：尖顶，三角形上方没有文字（即此次演绎子句产生了1个剩余文字）
                    else if (vLeftLits.size() == 1 && vNewR.size() == 0) {
                        formTri = SPIRENOLIT;
                    }
                    //形状4：尖顶，三角形上方有文字（包括此次演绎子句产生了至少两个文字）
                    else if (vLeftLits.size() != 0) {
                        formTri = SPIREHAVELIT;
                    }
                    // </editor-fold>
                    
                    /*根据三角形形状，分类处理*/
                    // <editor-fold defaultstate="collapsed" desc="根据三角形形状，分类处理">
                    //为形状1：平顶，三角形上方没有文字，则UNSAT
                    if (formTri == FLATNOLIT) {
                        newCla = nullptr;
                        givenCla->isSDeduct = true;
                        candClaP->isSDeduct = true;
                        return 1;
                    }
                    //为形状2：平顶，三角形上方有文字。即演绎出标准矛盾体，暂时不做处理。考虑这个演绎出标准矛盾体的givenCla的权重增大
                    else if (formTri == FLATHAVELIT) {
                        
                        //暂时不处理
                    }
                    //为形状3：尖顶，三角形上方没有文字 
                    else if (formTri == SPIRENOLIT) {
                        UINT8 deductRes = 10;
                        //三角形为形状3的剩余文字处理：1 确定主界线文字；2 R冗余文字检查；3 R文字数检查；4 R复杂度检查；5 R包含冗余性检查
                        deductRes = ThirdFormTriProcess(fol, newClaId, vLeftLits[0]);
                        
                        //当中间式为：复杂度超限 or 包含冗余 or （生成的主界线文字为纯文字 or 与已存在的主界线文字相同），则回退路径
                        if (deductRes == 2 || deductRes == 3 || deductRes == 4) {
                            //路径回退
                            PathBack(lastvOutTriSize, lastRSize, lastMainLits);
                            
                            if (deductRes == 3 || deductRes == 4)
                                givenCla->reduntTimes++;    //更新冗余权重
                            
                            vLeftLits.clear();
                            vector<Literal*>().swap(vLeftLits);
                            continue;
                        }
                        //生成中间式，输出R和路径
                        else if (deductRes == 5) {
                            //修改givenCla子句和candClaP子句的演绎状态为true
                            // <editor-fold defaultstate="collapsed" desc="修改givenCla子句和candClaP子句的演绎状态为true">
                            if (candClaP->uLitNum == 1) 
                                candClaP->isSDeduct = true; //在构建三角形过程中参与归结 
                            givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                            // </editor-fold>
                            
                            //打印三角形路径和R，输出R
                            PrintTriAndOutputR(candClaP->uClaId);

                            //初始化新生成的中间式其他子句属性，并新生成的中间式加入到子句集fol中
                            // <editor-fold defaultstate="collapsed" desc="初始化新生成的中间式其他子句属性，并新生成的中间式加入到子句集fol中">
                            chgCla.push_back(newCla);
                            fol.InsertCla(newCla);
                            fol.setCla.insert(newCla);
                            fol.initGenerateClaAttr(newCla);
                            // </editor-fold>
                            
                            midGenR = true;
                            newClaId++;
                        }                        
                    }
                    //为形状4：尖顶，三角形上方有文字（包括此次演绎子句产生了至少两个文字）
                    else if (formTri == SPIREHAVELIT) {
                        vector<Clause*> discardClas;
                        discardClas.reserve(8);
                        
                        UINT8 deductRes = 10;
                        //三角形为形状4的剩余文字处理：1 确定主界线文字；2 R冗余文字检查；3 R文字数检查；4 R复杂度检查；5 R包含冗余性检查
                        deductRes = FourthFormTriProcess(fol, newClaId, vLeftLits, discardClas);
                        
                        //当中间式为：文字数超限 or 复杂度超限 or 包含冗余，则回退路径 or （生成的主界线文字为纯文字 or 与已存在的主界线文字相同），则回退路径
                        if (deductRes == 1 || deductRes == 2 || deductRes == 3 || deductRes == 4) {
                            //没有主界线的路径回退
                            PathBack(lastvOutTriSize, lastRSize, lastMainLits);
                            
                            if (deductRes == 3)
                                givenCla->reduntTimes++;    //更新冗余权重
                            
                            vLeftLits.clear();
                            vector<Literal*>().swap(vLeftLits);
                            
                            discardClas.clear();
                            vector<Clause*>().swap(discardClas);
                            
                            continue;
                        }
                        //生成中间式，输出R和路径
                        else if (deductRes == 5) {
                            //修改givenCla子句和candClaP子句的演绎状态为true
                            // <editor-fold defaultstate="collapsed" desc="修改givenCla子句和candClaP子句的演绎状态为true">
                            if (candClaP->uLitNum == 1) 
                                candClaP->isSDeduct = true; //在构建三角形过程中参与归结 
                            givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                            // </editor-fold>
                            
                            //打印三角形路径和R，输出R
                            PrintTriAndOutputR(candClaP->uClaId, discardClas);

                            //初始化新生成的中间式其他子句属性，并新生成的中间式加入到子句集fol中
                            // <editor-fold defaultstate="collapsed" desc="初始化新生成的中间式其他子句属性，并新生成的中间式加入到子句集fol中">
                            chgCla.push_back(newCla);
                            fol.InsertCla(newCla);
                            fol.setCla.insert(newCla);
                            fol.initGenerateClaAttr(newCla);
                            // </editor-fold>

                            midGenR = true;
                            newClaId++;
                            
                            discardClas.clear();
                            vector<Clause*>().swap(discardClas);
                        }                         
                    }
                    // </editor-fold>
                    vLeftLits.clear();
                    vector<Literal*>().swap(vLeftLits);
                    // </editor-fold>
                    //cout << "C" << givenCla->uClaId << " 文字数" << givenCla->uLitNum << "  下拉文字数" << sumDrop << " (剩余文字" << givenCla->uLitNum - sumDrop << ", R中文字数" << vNewR.size() << ")    " << StrategyParam::midNum << endl; 
                   
                    
                    //givenCla演绎完成，更新此次演绎涉及的权重
                    // <editor-fold defaultstate="collapsed" desc="步骤4：givenCla演绎完成，更新此次演绎涉及的权重">
                    //参与此次演绎的主界线的单元子句主动演绎权重+1
                    if (!vOnlyDectNum.empty()) {
                        for (UINT8 m = 0; m < vOnlyDectNum.size(); m++) {
                            if (vOnlyDectNum[m]->claPtr->uLitNum == 1) {
                                if (vOnlyDectNum[m]->claPtr->clast == CopyTemp)
                                    vOnlyDectNum[m]->claPtr->topCopyCla->adeductNum++;
                                vOnlyDectNum[m]->claPtr->adeductNum++;
                            } 
                        }
                    }
                    if (candClaP->uLitNum == 1) {
                        if (candClaP->clast == CopyTemp)
                            candClaP->topCopyCla->adeductNum++;
                        candClaP->adeductNum++;                        
                    }
                    
                    //givenCla子句中的鱼钩文字QLit演绎权重+1
                    QLit->sDuct++;
                    
                    //givenCla子句被动演绎权重增加
                    if (givenCla->clast == CopyTemp) {
                        if (givenCla->isAxtom = false)
                            givenCla->topCopyCla->pdeductNum += 1;
                        else
                            givenCla->topCopyCla->pdeductNum += 3;
                    }
                    if (givenCla->isAxtom = false)
                        givenCla->pdeductNum += 1;
                    else
                        givenCla->pdeductNum += 3;  
                    
                    //改变givenCla与candClaP的演绎状态为true
                    givenCla->isSDeduct = true;
                    candClaP->isSDeduct = true;
                    // </editor-fold>
                    
                    //拷贝此次演绎涉及的相关子句
                    // <editor-fold defaultstate="collapsed" desc="步骤5：拷贝此次演绎涉及的相关子句">
                    //拷贝单元子句
                    if (StrategyParam::useCpUintCla || true) {
                        if ((candClaP->uLitNum == 1) && candClaP->HasTermBind()) {	
                            //拷贝新的子句来使用
                            unify.copyUintCla(fol, candClaP, newClaId);	//* 拷贝的单元子句要插入到了主界线上（在它父子句的后面）
                            hasCpUintClaId.insert(candClaP->uClaId);
                        }
                        if (vOnlyDectNum.size() > 0) {
                            for (UINT16 s = 0; s < vOnlyDectNum.size(); ++s) {
                                if ((vOnlyDectNum[s]->claPtr->uLitNum == 1) && vOnlyDectNum[s]->claPtr->HasTermBind()) {
                                    //拷贝新的子句来使用
                                    unify.copyUintCla(fol, vOnlyDectNum[s]->claPtr, newClaId);
                                    hasCpUintClaId.insert(vOnlyDectNum[s]->claPtr->uClaId);
                                }
                            }
                        }
                    }
                    //拷贝givenCla子句
                    if (midGenR && (StrategyParam::claReUseTimes != 0) && givenCla->isAxtom == false) {
                        Clause* cpClaTmp = nullptr;
                        if (givenCla->topCopyCla == nullptr)
                            cpClaTmp = givenCla;
                        else
                            cpClaTmp = givenCla->topCopyCla;
                        Clause* cyCla = copyCla(fol, cpClaTmp, newClaId, candLitP, QLit);	//* 拷贝子句是放入到了fol.setCla的
                        cyCla->topCopyCla = cpClaTmp;
                        //插入到演绎子句列表中
                        vector<Clause*>::iterator insertInd = find(candidateClaSet_notBinary.begin(), candidateClaSet_notBinary.end(), givenCla);
                        candidateClaSet_notBinary.emplace(insertInd + 1, cyCla);	//*拷贝子句放在candidateClaSet的位置在它的父子句的后面，使得下一次的演绎又是givenCla的拷贝子句（相当于重复使用该子句）
                        midGenR = false;
                    }  
                    
                    //givenCla加入到已经演绎过的子句集合中
                    setRedundClaId.insert(givenCla->uClaId);
                    // </editor-fold>
                    
                    //更改此次演绎和有子句参与到三角形演绎来的成功标志
                    // <editor-fold defaultstate="collapsed" desc="步骤6：更改此次演绎和有子句参与到三角形演绎来的成功标志">
                    isDeduct = true;    //此次演绎成功
                    isGloDeduct = true; //有非二元子句参与到三角形演绎来
                    globalDeduct = true;    //有子句参与到三角形演绎来
                    // </editor-fold>
                    
                    //givenCla子句成功演绎,break
                    break;
                }
                
                //givenCla子句成功参与到演绎中来
                if (isDeduct)
                    break;
            }
        }
        
        //检查一个种子子句是否充分使用完毕。若是则再次使用二元子句集参与演绎
        if (!overFull) {
            if (candidateClaSet_notBinary[cDeepth + 1]->uClaId == nextId) {
                if (vOnlyOutTri.size() - 1 > lastIndex) {   //产生了新的主界线文字
                    //cout << "种子子句C" << candidateClaSet_notBinary[cDeepth + 1]->uClaId << "演绎前的主界线文字数： " << vOnlyOutTri.size() << "；演绎前搜寻范围为[" << firstIndex << ", " << lastIndex << "]" << endl;
                    int temp = vOnlyOutTri.size();
                    //更新[firstIndex, lastIndex]范围
                    firstIndex = lastIndex + 1;
                    lastIndex = UINT32(vCandLit->size() - 1);
                    //cout << "种子子句C" << candidateClaSet_notBinary[cDeepth]->uClaId << "演绎前的主界线文字数： " << vOnlyOutTri.size() << "；演绎前搜寻范围为[" << firstIndex << ", " << lastIndex << "]" << endl;
                    
                    while (true) {
                        resBinary = BinaryClaDeduction(fol, candidateClaSet_binary, newClaId, chgCla, firstIndex, lastIndex);
                        //处理二元子句集演绎结果
                        if (resBinary == 1)    //得到UNSAT结果
                            return 1;
                        else if (resBinary == 0) {  //主界线有新增文字
                            firstIndex = lastIndex + 1;
                            lastIndex = UINT32(vOnlyOutTri.size() - 1);
                        } 
                        else if (resBinary == 2) {    //没有二元子句能够参与到演绎中去, break
                            break;    
                        }  
                        else if (resBinary == 3 || resBinary == 4 || resBinary == 5) {    //达到R文字数的限制 or timeout且没有子句参与演绎 or timeout且有子句参与演绎
                            return resBinary;
                        } 
                    }
                }
                fullUse_Index++;
            }
        }        
        
        //运行时间检查
        // <editor-fold defaultstate="collapsed" desc="运行时间检查">
        clock_t end = clock();
        double time_s = (double)(end - StrategyParam::start) / (double)CLOCKS_PER_SEC;
        if (time_s > StrategyParam::firstTimeLimit * 60) {
            if (globalDeduct) {
                resDeduct = 5; //有子句参与三角形演绎，但time-out
                break;
            }
            else {
                resDeduct = 4;   //达到时间限制时，没有一个子句能参与到三角形演绎中来
                break;
            }
        }
        // </editor-fold>  
        
        //R文字数的检查
        if ((vNewR.size() >= StrategyParam::R_MAX_NUM) || (isDeduct && (StrategyParam::R_INIT_MAX_NUM == candClaP->uLitNum)&&(candClaP->uLitNum > 10))) {
            resDeduct = 3;
            break;
        }
        
        //检查遍历是否完成
        if (cDeepth == candidateClaSet_notBinary.size() - 1) { 
            if (vOnlyOutTri.size() - 1 > lastIndex) {   
                //更新[firstIndex, lastIndex]范围
                firstIndex = lastIndex + 1;
                lastIndex = UINT32(vCandLit->size() - 1);
                while (true) {
                    resBinary = BinaryClaDeduction(fol, candidateClaSet_binary, newClaId, chgCla, firstIndex, lastIndex);
                    //处理二元子句集演绎结果
                    if (resBinary == 1)    //得到UNSAT结果
                        return 1;
                    else if (resBinary == 0) {  //主界线有新增文字
                        firstIndex = lastIndex + 1;
                        lastIndex = UINT32(vOnlyOutTri.size() - 1);
                    } 
                    else if (resBinary == 2) {    //没有二元子句能够参与到演绎中去, break
                        break;    
                    }  
                    else if (resBinary == 3 || resBinary == 4 || resBinary == 5) {    //达到R文字数的限制 or timeout且没有子句参与演绎 or timeout且有子句参与演绎
                        return resBinary;
                    }
                }
            }            
            
            //若遍历中，非二元子句集合candidateClaSet_notBinary中没有一个子句参与到演绎中去
            if (!isGloDeduct) {
                resDeduct = 2; 
            }
            else 
                resDeduct = 0;
            break;
        }
        
        //更新下标：遍历二元子句集合candidateClaSet_binary的下一个子句
        cDeepth++;
    } 
    
    return resDeduct;    
}

UINT16 TriAlg::NotBinaryClaDeduction2(Formula& fol, vector<Clause*>& candidateClaSet_notBinary, vector<Clause*>& candidateClaSet_binary, UINT32& newClaId, vector<Clause*>& chgCla, UINT32& firstIndex, UINT32& lastIndex) {
    // <editor-fold defaultstate="collapsed" desc="定义以及初始化所需的变量">
    UINT16 resDeduct = 100; //记录非二元子句集参与演绎的结果
    UINT16 resBinary = 100; //记录二元子句集参与演绎的结果

    bool isDeduct = false;  //是否主动子句（即givenCla）能参与到演绎中来：false 不能；true 能
    bool isGloDeduct = false;   //是否整个三角形演绎中都没有子句参与演绎：false 是；true 否
    bool midGenR = false;   //是否产生了中间式：false 没有；true 有
    bool isFirst = true;
    int tempSize = vOnlyOutTri.size();
        
    Clause* givenCla = nullptr; //主动子句（我形象称为钓竿子句），为候选子句中的子句
    Clause* candClaP = nullptr;  //被动子句（我形象称为咬钩子句），为主界线文字所在的子句
    
    Literal* QLit = nullptr;    //主动子句中的文字（我形象称为鱼钩文字），为givenCla中的文字
    Literal* candLitP = nullptr;    //被动子句中的文字（我形象称为咬钩文字），为candClaP中的文字
    
    vector<Literal*>* vCandLit = &vOnlyOutTri;  //保存主界线文字的集合（我形象称为鱼群文字集合）
    
    UINT32 cDeepth = 0; //candidateClaSet_notBinary集合中的下标
    
    RESULT unifResult = NOMGU;  //合一是否成功结果
    
    //种子子句充分使用完毕后，再次使用二元子句集所需要的变量
    vector<UINT32> vNotBinaryId;    //保存原始非二元子句集（candidateClaSet_notBinary）中子句的ID
    vNotBinaryId.reserve(16);
    for (INT32 m = 0; m < candidateClaSet_notBinary.size(); m++) {
        vNotBinaryId.push_back(candidateClaSet_notBinary[m]->uClaId);
    }
    UINT32 nextId = 0;  //记录vNotBinaryId中的元素
    UINT32 fullUse_Index = 1;   //nextId在vNotBinaryId中下标
    
    bool overFull = false;  //用于标记是否遍历到vNotBinaryId的最后一个元素：false 不是；true 是    
    bool addMain = false;   //一个子句参与演绎是否新增主界线文字：false 没有；true 有
    // </editor-fold>
    /*----------
     * 遍历一次非二元子句集candidateClaSet_notBinary
     * （主界线寻找范围为[firstIndex, lastIndex]）
     * 退出本次while循环的条件：
     * 1 完成一次遍历二元子句集candidateClaSet_notBinary(一个种子子句完全参与演绎后，需要再次使用二元子句集中子句参与演绎）;
     * 2 达到运行时间限制
     * 3 得到UNSAT结论
     -----------*/
    int num = 0;
    bool flag = true;
    while (true) {
        /*--------------------------------------
         * 一次while循环就是判断子句givenCla能否参与到演绎中来。
         * 先判断能否参与到演绎中来：
         * 若能：则检查R的冗余性并生成中间式；然后拷贝givenCla子句形成新子句插入到candidateClaSet_notBinary集合，拷贝参与演绎的主界线单元子句到主界线vOnlyOutTri文字集合中
         * 若不能，则更换下一个givenCla进行下一次循环判定；
         ---------------------------------------*/
        givenCla = candidateClaSet_notBinary[cDeepth]; //给givenCla赋值
        
        if (fullUse_Index == vNotBinaryId.size()) {
            overFull = true;
        }
        else {
            //if (givenCla->uClaId == 258) 
                //cout << "258" << endl;
            nextId = vNotBinaryId[fullUse_Index];
            if (flag) {
                //cout << "种子子句C" << vNotBinaryId[fullUse_Index - 1] << "演绎前主界线文字数：" << vOnlyOutTri.size() << endl;
                num = vOnlyOutTri.size();
                flag = false;
            }
        }        
        
        //对givenCla中文字进行排序
        stable_sort(givenCla->LitPtr, givenCla->LitPtr + givenCla->uLitNum, SortRule::ActlitCmp);
       
        /*若想重复使用子句，则通过拷贝该子句来获得新子句（拥有新的子句ID）插入到candidateClaSet_binary集合中来使用，这样就可以实现一个子句只能参与一次演绎*/
        //判断givenCla子句是否参与到演绎中来，首先givenCla得满足条件：不能是已经参与过演绎的子句
        if (setRedundClaId.find(givenCla->uClaId) == setRedundClaId.end()) {
            //遍历givenCla中文字QLit
            for (UINT16 ActLitInd = 0; ActLitInd < givenCla->uLitNum; ActLitInd++) {
                isDeduct = false;    //givenCla子句初始设置为：不能参与到演绎中来
                QLit = givenCla->LitPtr[ActLitInd]; //赋值鱼钩文字QLit
                /*----------------
                 * 通过QLit去主界线找互补对：
                 * 找到，则 进行规则检查 -> 进行R的检查判断 -> 生成中间式 -> givenCla子句参与到演绎中来了
                 ----------------*/
                for (UINT32 pasLitInd = 0; pasLitInd < UINT32(vCandLit->size()); pasLitInd++) {
                    candLitP = vCandLit->at(pasLitInd); //赋值咬钩文字
                    candClaP = candLitP->claPtr;    //得到咬钩文字所在的咬钩子句
                    
                    //检查鱼钩文字QLit与咬钩文字candLitP是否谓词互补：不是则continue换下一个咬钩文字
                    // <editor-fold defaultstate="collapsed" desc="步骤1：检查candLitP是否符合条件">
                    if (!QLit->isPairPred(candLitP))                  
                        continue;
                   
                    //检查鱼钩文字QLit所在子句candClaP是否是主界线上已经被拷贝过的单元子句：是则continue换下一个咬钩文字
                    if ((candClaP->uLitNum == 1) && (hasCpUintClaId.find(candClaP->uClaId) != hasCpUintClaId.end()))
                        continue;
                    //检查givenCla子句是否是拷贝子句且copyFrom为candLitP, copyTo是否与QLit相同：是则continue换下一个咬钩文字
                    if ((givenCla->clast == CopyTemp) && (givenCla->copyFrom == candLitP) && (unify.CheckEqnR(givenCla->copyTo->subTerm, QLit->subTerm))) 
                        continue;
                    // </editor-fold>
                    
                    //检查鱼钩文字QLit与咬钩文字candLitP是否能合一，若能是否通过规则检查，若通过则unifResult = RULEOK
                    // <editor-fold defaultstate="collapsed" desc="步骤2：鱼钩文字QLit与咬钩文字candLitP 合一判断与规则检查">
                    INT32 tempRsize = StrategyParam::R_MAX_NUM;
                    if (candLitP->claPtr->isGoal && (StrategyParam::R_MAX_NUM < candLitP->claPtr->uLitNum)) {
                        StrategyParam::R_MAX_NUM = vNewR.size() + candLitP->claPtr->uLitNum;
                    }                    
                    unifResult = unify.IssynLR(QLit, candLitP);
                    StrategyParam::R_MAX_NUM = tempRsize;
                    // </editor-fold>
                    
                    //鱼钩文字QLit与咬钩文字candLitP不能能合一 或 能合一但没通过规则检查
                    // <editor-fold defaultstate="collapsed" desc="步骤3.1：不能合一或规则不通过，进行以下处理，然后continue 更换下一个咬钩文字candLitP（转到步骤1）">
                    if (unifResult != RULEOK) {
                        if (!vOnlyOutDect.empty()) {
                            UINT32 dlen = vOnlyOutDect.size();
                            for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                            }
                        } 
                        continue;
                    }
                    // </editor-fold>
                    
                    //鱼钩文字QLit与咬钩文字candLitP能合一且通过规则检查(即unifResult = RULEOK)
                    // <editor-fold defaultstate="collapsed" desc="步骤3.2：对此次演绎，更新三角形，主界线，R，并生成中间式">
                    int lastvOutTriSize = vOutTri.size();   //上一次演绎的三角形中文字数
                    int lastRSize = vNewR.size();   //上一次演绎的R中文字数
                    int lastMainLits = vOnlyOutTri.size();  //上一次演绎的主界线文字数

                    UINT16 sumDrop = 0; //统计givenCla子句在此次演绎中演绎文字数（即下拉文字数）

                    vector<Literal*> vLeftLits; //保存givenCla子句在此次演绎中未参与演绎的文字（即剩余文字）
                    vLeftLits.reserve(8);
                    
                    //将此次演绎涉及的变元替换添加到三角形演绎的替换集合中
                    stackVarChg.push_back(unify.vVarBindT);
                    
                    /*givenCla子句中文字放入三角形vOutTri的顺序是：先 下来文字； 然后 主界线文字； 最后二次剩余文字（即主界线以外的剩余文字）*/
                    //统计givenCla子句在此次演绎中：下拉的文字（并加入到三角形vOutTri中）；剩余的文字（放入数组vLeftLits）
                    for (UINT16 m = 0; m < givenCla->uLitNum; m++) {
                        if (givenCla->LitPtr[m]->isDrop) {
                            sumDrop++;
                            vOutTri.push_back(givenCla->LitPtr[m]);
                            continue;
                        }
                        vLeftLits.push_back(givenCla->LitPtr[m]);
                    }
                    
                    /*确定三角形演绎后的形状，然后对演绎子句givenCla剩余文字的操作*/
                    // <editor-fold defaultstate="collapsed" desc="确定三角形演绎后的形状，然后对演绎子句givenCla剩余文字的操作">
                    //形状1：平顶，三角形上方没有文字
                    if (vLeftLits.size() == 0 && vNewR.size() == 0) {
                        formTri = FLATNOLIT;
                    }
                    //形状2：平顶，三角形上方有文字
                    else if (vLeftLits.size() == 0 && vNewR.size() != 0) {  
                        formTri = FLATHAVELIT;
                    }
                    //形状3：尖顶，三角形上方没有文字（即此次演绎子句产生了1个剩余文字）
                    else if (vLeftLits.size() == 1 && vNewR.size() == 0) {
                        formTri = SPIRENOLIT;
                    }
                    //形状4：尖顶，三角形上方有文字（包括此次演绎子句产生了至少两个文字）
                    else if (vLeftLits.size() != 0) {
                        formTri = SPIREHAVELIT;
                    }
                    // </editor-fold>
                    
                    /*根据三角形形状，分类处理*/
                    // <editor-fold defaultstate="collapsed" desc="根据三角形形状，分类处理">
                    //为形状1：平顶，三角形上方没有文字，则UNSAT
                    if (formTri == FLATNOLIT) {
                        newCla = nullptr;
                        givenCla->isSDeduct = true;
                        candClaP->isSDeduct = true;
                        return 1;
                    }
                    //为形状2：平顶，三角形上方有文字。即演绎出标准矛盾体，暂时不做处理。考虑这个演绎出标准矛盾体的givenCla的权重增大
                    else if (formTri == FLATHAVELIT) {
                        
                        //暂时不处理
                    }
                    //为形状3：尖顶，三角形上方没有文字 
                    else if (formTri == SPIRENOLIT) {
                        UINT16 deductRes = 10;
                        //三角形为形状3的剩余文字处理：1 确定主界线文字；2 R冗余文字检查；3 R文字数检查；4 R复杂度检查；5 R包含冗余性检查
                        deductRes = ThirdFormTriProcess(fol, newClaId, vLeftLits[0]);
                        
                        //当中间式为：复杂度超限 or 包含冗余 or （生成的主界线文字为纯文字 or 与已存在的主界线文字相同），则回退路径
                        if (deductRes == 2 || deductRes == 3 || deductRes == 4) {
                            //路径回退
                            PathBack(lastvOutTriSize, lastRSize, lastMainLits);
                            
                            if (deductRes == 3 || deductRes == 4)
                                givenCla->reduntTimes++;    //更新冗余权重
                            
                            vLeftLits.clear();
                            vector<Literal*>().swap(vLeftLits);
                            continue;
                        }
                        //生成中间式，输出R和路径
                        else if (deductRes == 5) {
                            //修改givenCla子句和candClaP子句的演绎状态为true
                            // <editor-fold defaultstate="collapsed" desc="修改givenCla子句和candClaP子句的演绎状态为true">
                            if (candClaP->uLitNum == 1) 
                                candClaP->isSDeduct = true; //在构建三角形过程中参与归结 
                            givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                            // </editor-fold>
                            
                            //打印三角形路径和R，输出R
                            PrintTriAndOutputR(candClaP->uClaId);

                            //初始化新生成的中间式其他子句属性，并新生成的中间式加入到子句集fol中
                            // <editor-fold defaultstate="collapsed" desc="初始化新生成的中间式其他子句属性，并新生成的中间式加入到子句集fol中">
                            chgCla.push_back(newCla);
                            fol.InsertCla(newCla);
                            fol.setCla.insert(newCla);
                            fol.initGenerateClaAttr(newCla);
                            // </editor-fold>
                            
                            midGenR = true;
                            newClaId++;
                        }                        
                    }
                    //为形状4：尖顶，三角形上方有文字（包括此次演绎子句产生了至少两个文字）
                    else if (formTri == SPIREHAVELIT) {
                        vector<Clause*> discardClas;
                        discardClas.reserve(8);
                        
                        UINT16 deductRes = 10;
                        //三角形为形状4的剩余文字处理：1 确定主界线文字；2 R冗余文字检查；3 R文字数检查；4 R复杂度检查；5 R包含冗余性检查
                        deductRes = FourthFormTriProcess(fol, newClaId, vLeftLits, discardClas);
                        
                        //当中间式为：文字数超限 or 复杂度超限 or 包含冗余，则回退路径 or （生成的主界线文字为纯文字 or 与已存在的主界线文字相同），则回退路径
                        if (deductRes == 1 || deductRes == 2 || deductRes == 3 || deductRes == 4) {
                            //没有主界线的路径回退
                            PathBack(lastvOutTriSize, lastRSize, lastMainLits);
                            
                            if (deductRes == 3)
                                givenCla->reduntTimes++;    //更新冗余权重
                            
                            vLeftLits.clear();
                            vector<Literal*>().swap(vLeftLits);
                            
                            discardClas.clear();
                            vector<Clause*>().swap(discardClas);
                            
                            continue;
                        }
                        //生成中间式，输出R和路径
                        else if (deductRes == 5) {
                            //修改givenCla子句和candClaP子句的演绎状态为true
                            // <editor-fold defaultstate="collapsed" desc="修改givenCla子句和candClaP子句的演绎状态为true">
                            if (candClaP->uLitNum == 1) 
                                candClaP->isSDeduct = true; //在构建三角形过程中参与归结 
                            givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                            // </editor-fold>
                            
                            //打印三角形路径和R，输出R
                            PrintTriAndOutputR(candClaP->uClaId, discardClas);

                            //初始化新生成的中间式其他子句属性，并新生成的中间式加入到子句集fol中
                            // <editor-fold defaultstate="collapsed" desc="初始化新生成的中间式其他子句属性，并新生成的中间式加入到子句集fol中">
                            chgCla.push_back(newCla);
                            fol.InsertCla(newCla);
                            fol.setCla.insert(newCla);
                            fol.initGenerateClaAttr(newCla);
                            // </editor-fold>

                            midGenR = true;
                            newClaId++;
                            
                            discardClas.clear();
                            vector<Clause*>().swap(discardClas);
                        }                         
                    }
                    // </editor-fold>
                    vLeftLits.clear();
                    vector<Literal*>().swap(vLeftLits);
                    // </editor-fold>
                    //cout << "C" << givenCla->uClaId << " 文字数" << givenCla->uLitNum << "  下拉文字数" << sumDrop << " (剩余文字" << givenCla->uLitNum - sumDrop << ", R中文字数" << vNewR.size() << ")    " << StrategyParam::midNum << endl; 
//                    if (true) {
//                        string str = "/home/ars01/Desktop/dist/aaa";
//                        ofstream fout(str.c_str(), ios::app);
//                        if (formTri == FLATNOLIT)
//                            fout << "FLATNOLIT" << endl;
//                        else if (formTri == FLATHAVELIT)
//                            fout << "FLATHAVELIT" << endl;
//                        else if (formTri == SPIRENOLIT)
//                            fout << "SPIRENOLIT" << endl;
//                        else if (formTri == SPIREHAVELIT)
//                            fout << "SPIREHAVELIT" << endl;
//                        fout << "total Num: " << givenCla->uLitNum << "; drop Num: " << sumDrop << "; left Num: " << vLeftLits.size() << endl; 
//                        fout << "vNewR.size() = " << vNewR.size() << endl;
//                        fout.close();
//                    }  
                        
                    //givenCla演绎完成，更新此次演绎涉及的权重
                    // <editor-fold defaultstate="collapsed" desc="步骤4：givenCla演绎完成，更新此次演绎涉及的权重">
                    //参与此次演绎的主界线的单元子句主动演绎权重+1
                    if (!vOnlyDectNum.empty()) {
                        for (UINT8 m = 0; m < vOnlyDectNum.size(); m++) {
                            if (vOnlyDectNum[m]->claPtr->uLitNum == 1) {
                                if (vOnlyDectNum[m]->claPtr->clast == CopyTemp)
                                    vOnlyDectNum[m]->claPtr->topCopyCla->adeductNum++;
                                vOnlyDectNum[m]->claPtr->adeductNum++;
                            } 
                        }
                    }
                    if (candClaP->uLitNum == 1) {
                        if (candClaP->clast == CopyTemp)
                            candClaP->topCopyCla->adeductNum++;
                        candClaP->adeductNum++;                        
                    }
                    
                    //givenCla子句中的鱼钩文字QLit演绎权重+1
                    QLit->sDuct++;
                    
                    //givenCla子句被动演绎权重增加
                    if (givenCla->clast == CopyTemp) {
                        if (givenCla->isAxtom = false)
                            givenCla->topCopyCla->pdeductNum += 1;
                        else
                            givenCla->topCopyCla->pdeductNum += 3;
                    }
                    if (givenCla->isAxtom = false)
                        givenCla->pdeductNum += 1;
                    else
                        givenCla->pdeductNum += 3;  
                    
                    //改变givenCla与candClaP的演绎状态为true
                    givenCla->isSDeduct = true;
                    candClaP->isSDeduct = true;
                    // </editor-fold>
                    
                    //拷贝此次演绎涉及的相关子句
                    // <editor-fold defaultstate="collapsed" desc="步骤5：拷贝此次演绎涉及的相关子句">
                    //拷贝单元子句
                    if (StrategyParam::useCpUintCla) {
                        if ((candClaP->uLitNum == 1) && candClaP->HasTermBind()) {	
                            //拷贝新的子句来使用
                            unify.copyUintCla(fol, candClaP, newClaId);	//* 拷贝的单元子句要插入到了主界线上（在它父子句的后面）
                            hasCpUintClaId.insert(candClaP->uClaId);
                        }
                        if (vOnlyDectNum.size() > 0) {
                            for (UINT16 s = 0; s < vOnlyDectNum.size(); ++s) {
                                if ((vOnlyDectNum[s]->claPtr->uLitNum == 1) && vOnlyDectNum[s]->claPtr->HasTermBind()) {
                                    //拷贝新的子句来使用
                                    unify.copyUintCla(fol, vOnlyDectNum[s]->claPtr, newClaId);
                                    hasCpUintClaId.insert(vOnlyDectNum[s]->claPtr->uClaId);
                                }
                            }
                        }
                    }
                    //拷贝givenCla子句
                    if (midGenR && (StrategyParam::claReUseTimes != 0) && givenCla->isAxtom == false) {
                        Clause* cpClaTmp = nullptr;
                        if (givenCla->topCopyCla == nullptr)
                            cpClaTmp = givenCla;
                        else
                            cpClaTmp = givenCla->topCopyCla;
                        Clause* cyCla = copyCla(fol, cpClaTmp, newClaId, candLitP, QLit);	//* 拷贝子句是放入到了fol.setCla的
                        cyCla->topCopyCla = cpClaTmp;
                        //插入到演绎子句列表中
                        vector<Clause*>::iterator insertInd = find(candidateClaSet_notBinary.begin(), candidateClaSet_notBinary.end(), givenCla);
                        candidateClaSet_notBinary.emplace(insertInd + 1, cyCla);	//*拷贝子句放在candidateClaSet的位置在它的父子句的后面，使得下一次的演绎又是givenCla的拷贝子句（相当于重复使用该子句）
                        midGenR = false;
                    }  
                    //cout << givenCla->uClaId << "(" << givenCla->uLitNum << "); " << candClaP->uClaId << endl;
                    //givenCla加入到已经演绎过的子句集合中
                    setRedundClaId.insert(givenCla->uClaId);
                    // </editor-fold>
                    
                    //更改此次演绎和有子句参与到三角形演绎来的成功标志
                    // <editor-fold defaultstate="collapsed" desc="步骤6：更改此次演绎和有子句参与到三角形演绎来的成功标志">
                    isDeduct = true;    //此次演绎成功
                    isGloDeduct = true; //有非二元子句参与到三角形演绎来
                    globalDeduct = true;    //有子句参与到三角形演绎来
                    // </editor-fold>
                    //givenCla子句成功演绎,break
                    break;
                }
                
                //givenCla子句成功参与到演绎中来
                if (isDeduct)
                    break;
            }
        }
        
        //检查一个种子子句是否充分使用完毕。若是则再次使用二元子句集参与演绎
        if (!overFull) {
            if (candidateClaSet_notBinary[cDeepth + 1]->uClaId == nextId) {
                flag = true;
                //cout << "种子子句C" << vNotBinaryId[fullUse_Index - 1] << "演绎后主界线文字数：" << vOnlyOutTri.size() << " (增加了" << vOnlyOutTri.size() - num << endl;
                if (isFirst && vOnlyOutTri.size() > tempSize) {
                    isFirst = false;
                    firstIndex = lastIndex + 1;
                    lastIndex = UINT32(vCandLit->size() - 1);
                    //cout << "遍历二元子句集前：主界线查找范围[" << firstIndex << ", " << lastIndex << "]" << endl;
                    int temp = vOnlyOutTri.size();
                    resBinary = BinaryClaDeduction(fol, candidateClaSet_binary, newClaId, chgCla, firstIndex, lastIndex);
                    //处理二元子句集演绎结果
                    if (resBinary == 1)    //得到UNSAT结果
                        return 1;  
                    else if (resBinary == 3 || resBinary == 4 || resBinary == 5) {    //达到R文字数的限制 or timeout且没有子句参与演绎 or timeout且有子句参与演绎
                        return resBinary;
                    }                         
                    //cout << "遍历二元子句集后：主界线增加了" << vOnlyOutTri.size() - temp << endl;
                }
                else if (vOnlyOutTri.size() - 1 > lastIndex && !isFirst) {   //产生了新的主界线文字 int temp = vOnlyOutTri.size();
                    //更新[firstIndex, lastIndex]范围
                    firstIndex = lastIndex + 1;
                    lastIndex = UINT32(vCandLit->size() - 1);
                    //cout << "遍历二元子句集前：主界线查找范围[" << firstIndex << ", " << lastIndex << "]" << endl;
                    int temp = vOnlyOutTri.size();
                    resBinary = BinaryClaDeduction(fol, candidateClaSet_binary, newClaId, chgCla, firstIndex, lastIndex);
                    //处理二元子句集演绎结果
                    if (resBinary == 1)    //得到UNSAT结果
                        return 1;  
                    else if (resBinary == 3 || resBinary == 4 || resBinary == 5) {    //达到R文字数的限制 or timeout且没有子句参与演绎 or timeout且有子句参与演绎
                        return resBinary;
                    }                         
                    
                    //cout << "遍历二元子句集后：主界线增加了" << vOnlyOutTri.size() - temp << endl;
                }
                fullUse_Index++;
            }
        }        
        
        //运行时间检查
        // <editor-fold defaultstate="collapsed" desc="运行时间检查">
        clock_t end = clock();
        double time_s = (double)(end - StrategyParam::start) / (double)CLOCKS_PER_SEC;
        if (time_s > StrategyParam::firstTimeLimit * 60) {
            if (globalDeduct) {
                resDeduct = 5; //有子句参与三角形演绎，但time-out
                break;
            }
            else {
                resDeduct = 4;   //达到时间限制时，没有一个子句能参与到三角形演绎中来
                break;
            }
        }
        // </editor-fold>  
        
        //R文字数的检查
        if ((vNewR.size() >= StrategyParam::R_MAX_NUM) || (isDeduct && (StrategyParam::R_INIT_MAX_NUM == candClaP->uLitNum)&&(candClaP->uLitNum > 10))) {
            resDeduct = 3;
            break;
        }
        
        //检查遍历是否完成
        if (cDeepth == candidateClaSet_notBinary.size() - 1) { 
            if (vOnlyOutTri.size() - 1 > lastIndex && !isFirst) {   //产生了新的主界线文字
                //cout << "种子子句C" << candidateClaSet_notBinary[cDeepth + 1]->uClaId << "演绎前的主界线文字数： " << vOnlyOutTri.size() << "；演绎前搜寻范围为[" << firstIndex << ", " << lastIndex << "]" << endl;
                int temp = vOnlyOutTri.size();
                //更新[firstIndex, lastIndex]范围
                firstIndex = lastIndex + 1;
                lastIndex = UINT32(vCandLit->size() - 1);
                //cout << "遍历二元子句集前：主界线查找范围[" << firstIndex << ", " << lastIndex << "]" << endl;

                resBinary = BinaryClaDeduction(fol, candidateClaSet_binary, newClaId, chgCla, firstIndex, lastIndex);
                //处理二元子句集演绎结果
                if (resBinary == 1)    //得到UNSAT结果
                    return 1;  
                else if (resBinary == 3 || resBinary == 4 || resBinary == 5) {    //达到R文字数的限制 or timeout且没有子句参与演绎 or timeout且有子句参与演绎
                    return resBinary;
                }                         

                //cout << "遍历二元子句集后：主界线增加了" << vOnlyOutTri.size() - temp << endl;
            }            
            
            //若遍历中，非二元子句集合candidateClaSet_notBinary中没有一个子句参与到演绎中去
            if (!isGloDeduct) {
                resDeduct = 2; 
            }
            else 
                resDeduct = 0;
            break;
        }
        
        //更新下标：遍历二元子句集合candidateClaSet_binary的下一个子句
        cDeepth++;
    } 
    
    return resDeduct;    
}

UINT16 TriAlg::NotBinaryClaDeduction3(Formula& fol, vector<Clause*>& candidateClaSet_notBinary, UINT32& newClaId, vector<Clause*>& chgCla) {

    // <editor-fold defaultstate="collapsed" desc="定义以及初始化所需的变量">
    UINT16 resDeduct = 100; //记录非二元子句集参与演绎的结果
    UINT16 resBinary = 100; //记录二元子句集参与演绎的结果

    bool isDeduct = false;  //是否主动子句（即givenCla）能参与到演绎中来：false 不能；true 能
    bool isGloDeduct = false;   //是否整个三角形演绎中都没有子句参与演绎：false 是；true 否
    bool midGenR = false;   //是否产生了中间式：false 没有；true 有
    bool isFirst = true;
    int tempSize = vOnlyOutTri.size();
        
    Clause* givenCla = nullptr; //主动子句（我形象称为钓竿子句），为候选子句中的子句
    Clause* candClaP = nullptr;  //被动子句（我形象称为咬钩子句），为主界线文字所在的子句
    
    Literal* QLit = nullptr;    //主动子句中的文字（我形象称为鱼钩文字），为givenCla中的文字
    Literal* candLitP = nullptr;    //被动子句中的文字（我形象称为咬钩文字），为candClaP中的文字
    
    vector<Literal*>* vCandLit = &vOnlyOutTri;  //保存主界线文字的集合（我形象称为鱼群文字集合）
    
    UINT32 cDeepth = 0; //candidateClaSet_notBinary集合中的下标
    
    RESULT unifResult = NOMGU;  //合一是否成功结果
    // </editor-fold>
    /*----------
     * 遍历一次非二元子句集candidateClaSet_notBinary
     * （主界线寻找范围为[firstIndex, lastIndex]）
     * 退出本次while循环的条件：
     * 1 完成一次遍历二元子句集candidateClaSet_notBinary(一个种子子句完全参与演绎后，需要再次使用二元子句集中子句参与演绎）;
     * 2 达到运行时间限制
     * 3 得到UNSAT结论
     -----------*/
    while (true) {
        /*--------------------------------------
         * 一次while循环就是判断子句givenCla能否参与到演绎中来。
         * 先判断能否参与到演绎中来：
         * 若能：则检查R的冗余性并生成中间式；然后拷贝givenCla子句形成新子句插入到candidateClaSet_notBinary集合，拷贝参与演绎的主界线单元子句到主界线vOnlyOutTri文字集合中
         * 若不能，则更换下一个givenCla进行下一次循环判定；
         ---------------------------------------*/
        givenCla = candidateClaSet_notBinary[cDeepth]; //给givenCla赋值      
        
        //对givenCla中文字进行排序
        stable_sort(givenCla->LitPtr, givenCla->LitPtr + givenCla->uLitNum, SortRule::ActlitCmp);
       
        /*若想重复使用子句，则通过拷贝该子句来获得新子句（拥有新的子句ID）插入到candidateClaSet_binary集合中来使用，这样就可以实现一个子句只能参与一次演绎*/
        //判断givenCla子句是否参与到演绎中来，首先givenCla得满足条件：不能是已经参与过演绎的子句
        if (setRedundClaId.find(givenCla->uClaId) == setRedundClaId.end()) {
            //遍历givenCla中文字QLit
            for (UINT16 ActLitInd = 0; ActLitInd < givenCla->uLitNum; ActLitInd++) {
                isDeduct = false;    //givenCla子句初始设置为：不能参与到演绎中来
                QLit = givenCla->LitPtr[ActLitInd]; //赋值鱼钩文字QLit
                /*----------------
                 * 通过QLit去主界线找互补对：
                 * 找到，则 进行规则检查 -> 进行R的检查判断 -> 生成中间式 -> givenCla子句参与到演绎中来了
                 ----------------*/
                for (UINT32 pasLitInd = 0; pasLitInd < UINT32(vCandLit->size()); pasLitInd++) {
                    candLitP = vCandLit->at(pasLitInd); //赋值咬钩文字
                    candClaP = candLitP->claPtr;    //得到咬钩文字所在的咬钩子句
                        
                    //检查鱼钩文字QLit与咬钩文字candLitP是否谓词互补：不是则continue换下一个咬钩文字
                    // <editor-fold defaultstate="collapsed" desc="步骤1：检查candLitP是否符合条件">
                    if (!QLit->isPairPred(candLitP))                  
                        continue;
                   
                    //检查鱼钩文字QLit所在子句candClaP是否是主界线上已经被拷贝过的单元子句：是则continue换下一个咬钩文字
                    if ((candClaP->uLitNum == 1) && (hasCpUintClaId.find(candClaP->uClaId) != hasCpUintClaId.end()))
                        continue;
                    //检查givenCla子句是否是拷贝子句且copyFrom为candLitP, copyTo是否与QLit相同：是则continue换下一个咬钩文字
                    if ((givenCla->clast == CopyTemp) && (givenCla->copyFrom == candLitP) && (unify.CheckEqnR(givenCla->copyTo->subTerm, QLit->subTerm))) 
                        continue;
                    // </editor-fold>
                    
                    //检查鱼钩文字QLit与咬钩文字candLitP是否能合一，若能是否通过规则检查，若通过则unifResult = RULEOK
                    // <editor-fold defaultstate="collapsed" desc="步骤2：鱼钩文字QLit与咬钩文字candLitP 合一判断与规则检查">
                    INT32 tempRsize = StrategyParam::R_MAX_NUM;
                    if (candLitP->claPtr->isGoal && (StrategyParam::R_MAX_NUM < candLitP->claPtr->uLitNum)) {
                        StrategyParam::R_MAX_NUM = vNewR.size() + candLitP->claPtr->uLitNum;
                    }                    
                    unifResult = unify.IssynLR(QLit, candLitP);
                    StrategyParam::R_MAX_NUM = tempRsize;
                    // </editor-fold>
                    
                    //鱼钩文字QLit与咬钩文字candLitP不能能合一 或 能合一但没通过规则检查
                    // <editor-fold defaultstate="collapsed" desc="步骤3.1：不能合一或规则不通过，进行以下处理，然后continue 更换下一个咬钩文字candLitP（转到步骤1）">
                    if (unifResult != RULEOK) {
                        if (!vOnlyOutDect.empty()) {
                            UINT32 dlen = vOnlyOutDect.size();
                            for (UINT32 size_d = 0; size_d < dlen; size_d++) {
                                vOnlyOutDect[size_d]->claPtr->isSDeduct = false;
                            }
                        } 
                        continue;
                    }
                    // </editor-fold>
                                      
                    //鱼钩文字QLit与咬钩文字candLitP能合一且通过规则检查(即unifResult = RULEOK)
                    // <editor-fold defaultstate="collapsed" desc="步骤3.2：对此次演绎，更新三角形，主界线，R，并生成中间式">
                    int lastvOutTriSize = vOutTri.size();   //上一次演绎的三角形中文字数
                    int lastRSize = vNewR.size();   //上一次演绎的R中文字数
                    int lastMainLits = vOnlyOutTri.size();  //上一次演绎的主界线文字数

                    UINT16 sumDrop = 0; //统计givenCla子句在此次演绎中演绎文字数（即下拉文字数）

                    vector<Literal*> vLeftLits; //保存givenCla子句在此次演绎中未参与演绎的文字（即剩余文字）
                    vLeftLits.reserve(8);
                    
                    //将此次演绎涉及的变元替换添加到三角形演绎的替换集合中
                    stackVarChg.push_back(unify.vVarBindT);
                    
                    /*givenCla子句中文字放入三角形vOutTri的顺序是：先 下来文字； 然后 主界线文字； 最后二次剩余文字（即主界线以外的剩余文字）*/
                    //统计givenCla子句在此次演绎中：下拉的文字（并加入到三角形vOutTri中）；剩余的文字（放入数组vLeftLits）
                    for (UINT16 m = 0; m < givenCla->uLitNum; m++) {
                        if (givenCla->LitPtr[m]->isDrop) {
                            sumDrop++;
                            vOutTri.push_back(givenCla->LitPtr[m]);
                            continue;
                        }
                        vLeftLits.push_back(givenCla->LitPtr[m]);
                    }
                    
                    /*确定三角形演绎后的形状，然后对演绎子句givenCla剩余文字的操作*/
                    // <editor-fold defaultstate="collapsed" desc="确定三角形演绎后的形状，然后对演绎子句givenCla剩余文字的操作">
                    //形状1：平顶，三角形上方没有文字
                    if (vLeftLits.size() == 0 && vNewR.size() == 0) {
                        formTri = FLATNOLIT;
                    }
                    //形状2：平顶，三角形上方有文字
                    else if (vLeftLits.size() == 0 && vNewR.size() != 0) {  
                        formTri = FLATHAVELIT;
                    }
                    //形状3：尖顶，三角形上方没有文字（即此次演绎子句产生了1个剩余文字）
                    else if (vLeftLits.size() == 1 && vNewR.size() == 0) {
                        formTri = SPIRENOLIT;
                    }
                    //形状4：尖顶，三角形上方有文字（包括此次演绎子句产生了至少两个文字）
                    else if (vLeftLits.size() != 0) {
                        formTri = SPIREHAVELIT;
                    }
                    // </editor-fold>
//                    if (true) {
//                        string str = "/home/ars01/Desktop/dist/aaa";
//                        ofstream fout(str.c_str(), ios::app);
//                        if (formTri == FLATNOLIT)
//                            fout << "FLATNOLIT" << endl;
//                        else if (formTri == FLATHAVELIT)
//                            fout << "FLATHAVELIT" << endl;
//                        else if (formTri == SPIRENOLIT)
//                            fout << "SPIRENOLIT" << endl;
//                        else if (formTri == SPIREHAVELIT)
//                            fout << "SPIREHAVELIT" << endl;
//                        fout << "total Num: " << givenCla->uLitNum << "; drop Num: " << sumDrop << "; left Num: " << vLeftLits.size() << endl; 
//                        fout << "vNewR.size() = " << vNewR.size() << endl;
//                        fout.close();
//                    }
                    /*根据三角形形状，分类处理*/
                    // <editor-fold defaultstate="collapsed" desc="根据三角形形状，分类处理">
                    //为形状1：平顶，三角形上方没有文字，则UNSAT
                    if (formTri == FLATNOLIT) {
//                        if (true) {
//                            string str = "/home/ars01/Desktop/dist/aaa";
//                            ofstream fout(str.c_str(), ios::app);
//                            fout << "UNSAT" << endl;
//                            fout << "total Num: " << givenCla->uLitNum << "; drop Num: " << sumDrop << "; left Num: " << vLeftLits.size() << endl; 
//                            fout.close();
//                        }
                        newCla = nullptr;
                        givenCla->isSDeduct = true;
                        candClaP->isSDeduct = true;
                        return 1;
                    }
                    //为形状2：平顶，三角形上方有文字。即演绎出标准矛盾体，暂时不做处理。考虑这个演绎出标准矛盾体的givenCla的权重增大
                    else if (formTri == FLATHAVELIT) {
                        
                        //暂时不处理
                    }
                    //为形状3：尖顶，三角形上方没有文字 
                    else if (formTri == SPIRENOLIT) {
                        UINT16 deductRes = 10;
                        //三角形为形状3的剩余文字处理：1 确定主界线文字；2 R冗余文字检查；3 R文字数检查；4 R复杂度检查；5 R包含冗余性检查
                        deductRes = ThirdFormTriProcess(fol, newClaId, vLeftLits[0]);
                        //当中间式为：复杂度超限 or 包含冗余 or （生成的主界线文字为纯文字 or 与已存在的主界线文字相同），则回退路径
                        if (deductRes == 2 || deductRes == 3 || deductRes == 4) {
//                            if (true) {
//                                string str = "/home/ars01/Desktop/dist/aaa";
//                                ofstream fout(str.c_str(), ios::app);
//                                fout << "back" << endl;
//                                fout.close();
//                            }
                            //路径回退
                            PathBack(lastvOutTriSize, lastRSize, lastMainLits);
                            
                            if (deductRes == 3 || deductRes == 4)
                                givenCla->reduntTimes++;    //更新冗余权重
                            
                            vLeftLits.clear();
                            vector<Literal*>().swap(vLeftLits);
                            continue;
                        }
                        //生成中间式，输出R和路径
                        else if (deductRes == 5) {
//                            if (true) {
//                                string str = "/home/ars01/Desktop/dist/aaa";
//                                ofstream fout(str.c_str(), ios::app);
//                                fout << "produce; vNewR.size()" << vNewR.size() << endl;
//                                fout.close();
//                            }
                            //修改givenCla子句和candClaP子句的演绎状态为true
                            // <editor-fold defaultstate="collapsed" desc="修改givenCla子句和candClaP子句的演绎状态为true">
                            if (candClaP->uLitNum == 1) 
                                candClaP->isSDeduct = true; //在构建三角形过程中参与归结 
                            givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                            // </editor-fold>
                            
                            //打印三角形路径和R，输出R
                            PrintTriAndOutputR(candClaP->uClaId);

                            //初始化新生成的中间式其他子句属性，并新生成的中间式加入到子句集fol中
                            // <editor-fold defaultstate="collapsed" desc="初始化新生成的中间式其他子句属性，并新生成的中间式加入到子句集fol中">
                            chgCla.push_back(newCla);
                            fol.InsertCla(newCla);
                            fol.setCla.insert(newCla);
                            fol.initGenerateClaAttr(newCla);
                            // </editor-fold>
                            
                            midGenR = true;
                            newClaId++;
                        }                        
                    }
                    //为形状4：尖顶，三角形上方有文字（包括此次演绎子句产生了至少两个文字）
                    else if (formTri == SPIREHAVELIT) {
                        vector<Clause*> discardClas;
                        discardClas.reserve(8);
                        
                        UINT16 deductRes = 10;
                        //三角形为形状4的剩余文字处理：1 确定主界线文字；2 R冗余文字检查；3 R文字数检查；4 R复杂度检查；5 R包含冗余性检查
                        deductRes = FourthFormTriProcess(fol, newClaId, vLeftLits, discardClas);
                        
                        //当中间式为：文字数超限 or 复杂度超限 or 包含冗余，则回退路径 or （生成的主界线文字为纯文字 or 与已存在的主界线文字相同），则回退路径
                        if (deductRes == 1 || deductRes == 2 || deductRes == 3 || deductRes == 4) {
//                            if (true) {
//                                string str = "/home/ars01/Desktop/dist/aaa";
//                                ofstream fout(str.c_str(), ios::app);
//                                fout << "back" << endl;
//                                fout.close();
//                            }
                            //没有主界线的路径回退
                            PathBack(lastvOutTriSize, lastRSize, lastMainLits);
                            
                            if (deductRes == 3)
                                givenCla->reduntTimes++;    //更新冗余权重
                            
                            vLeftLits.clear();
                            vector<Literal*>().swap(vLeftLits);
                            
                            discardClas.clear();
                            vector<Clause*>().swap(discardClas);
                            
                            continue;
                        }
                        //生成中间式，输出R和路径
                        else if (deductRes == 5) {
//                            if (true) {
//                                string str = "/home/ars01/Desktop/dist/aaa";
//                                ofstream fout(str.c_str(), ios::app);
//                                fout << "produce; vNewR.size()" << vNewR.size() << endl;
//                                fout.close();
//                            }
                            //修改givenCla子句和candClaP子句的演绎状态为true
                            // <editor-fold defaultstate="collapsed" desc="修改givenCla子句和candClaP子句的演绎状态为true">
                            if (candClaP->uLitNum == 1) 
                                candClaP->isSDeduct = true; //在构建三角形过程中参与归结 
                            givenCla->isSDeduct = true; //在构建三角形过程中参与归结
                            // </editor-fold>
                            
                            //打印三角形路径和R，输出R
                            PrintTriAndOutputR(candClaP->uClaId, discardClas);

                            //初始化新生成的中间式其他子句属性，并新生成的中间式加入到子句集fol中
                            // <editor-fold defaultstate="collapsed" desc="初始化新生成的中间式其他子句属性，并新生成的中间式加入到子句集fol中">
                            chgCla.push_back(newCla);
                            fol.InsertCla(newCla);
                            fol.setCla.insert(newCla);
                            fol.initGenerateClaAttr(newCla);
                            // </editor-fold>

                            midGenR = true;
                            newClaId++;
                            
                            discardClas.clear();
                            vector<Clause*>().swap(discardClas);
                        }                         
                    }
                    // </editor-fold>
                    int temp = vLeftLits.size();
                    vLeftLits.clear();
                    vector<Literal*>().swap(vLeftLits);
                    // </editor-fold>
                    //cout << "C" << givenCla->uClaId << " 文字数" << givenCla->uLitNum << "  下拉文字数" << sumDrop << " (剩余文字" << givenCla->uLitNum - sumDrop << ", R中文字数" << vNewR.size() << ")    " << StrategyParam::midNum << endl; 
//                    if (true) {
//                        string str = "/home/ars01/Desktop/dist/aaa";
//                        ofstream fout(str.c_str(), ios::app);
//                        if (formTri == FLATNOLIT)
//                            fout << "FLATNOLIT" << endl;
//                        else if (formTri == FLATHAVELIT)
//                            fout << "FLATHAVELIT" << endl;
//                        else if (formTri == SPIRENOLIT)
//                            fout << "SPIRENOLIT" << endl;
//                        else if (formTri == SPIREHAVELIT)
//                            fout << "SPIREHAVELIT" << endl;
//                        fout << "total Num: " << givenCla->uLitNum << "; drop Num: " << sumDrop << "; left Num: " << temp << endl; 
//                        fout << "vNewR.size() = " << vNewR.size() << endl;
//                        fout << "given->uClaId: " << givenCla->uClaId << "; cand->uClaId: " << candClaP->uClaId << endl;
//                        fout.close();
//                    }    
                    //givenCla演绎完成，更新此次演绎涉及的权重
                    // <editor-fold defaultstate="collapsed" desc="步骤4：givenCla演绎完成，更新此次演绎涉及的权重">
                    //参与此次演绎的主界线的单元子句主动演绎权重+1
                    if (!vOnlyDectNum.empty()) {
                        for (UINT8 m = 0; m < vOnlyDectNum.size(); m++) {
                            if (vOnlyDectNum[m]->claPtr->uLitNum == 1) {
                                if (vOnlyDectNum[m]->claPtr->clast == CopyTemp)
                                    vOnlyDectNum[m]->claPtr->topCopyCla->adeductNum++;
                                vOnlyDectNum[m]->claPtr->adeductNum++;
                            } 
                        }
                    }
                    if (candClaP->uLitNum == 1) {
                        if (candClaP->clast == CopyTemp)
                            candClaP->topCopyCla->adeductNum++;
                        candClaP->adeductNum++;                        
                    }
                    
                    //givenCla子句中的鱼钩文字QLit演绎权重+1
                    QLit->sDuct++;
                    
                    //givenCla子句被动演绎权重增加
                    if (givenCla->clast == CopyTemp) {
                        if (givenCla->isAxtom = false)
                            givenCla->topCopyCla->pdeductNum += 1;
                        else
                            givenCla->topCopyCla->pdeductNum += 3;
                    }
                    if (givenCla->isAxtom = false)
                        givenCla->pdeductNum += 1;
                    else
                        givenCla->pdeductNum += 3;  
                    
                    //改变givenCla与candClaP的演绎状态为true
                    givenCla->isSDeduct = true;
                    candClaP->isSDeduct = true;
                    // </editor-fold>
                    
                    //拷贝此次演绎涉及的相关子句
                    // <editor-fold defaultstate="collapsed" desc="步骤5：拷贝此次演绎涉及的相关子句">
                    //拷贝单元子句
                    if (StrategyParam::useCpUintCla) {
                        if ((candClaP->uLitNum == 1) && candClaP->HasTermBind()) {	
                            //拷贝新的子句来使用
                            unify.copyUintCla(fol, candClaP, newClaId);	//* 拷贝的单元子句要插入到了主界线上（在它父子句的后面）
                            hasCpUintClaId.insert(candClaP->uClaId);
                        }
                        if (vOnlyDectNum.size() > 0) {
                            for (UINT16 s = 0; s < vOnlyDectNum.size(); ++s) {
                                if ((vOnlyDectNum[s]->claPtr->uLitNum == 1) && vOnlyDectNum[s]->claPtr->HasTermBind()) {
                                    //拷贝新的子句来使用
                                    unify.copyUintCla(fol, vOnlyDectNum[s]->claPtr, newClaId);
                                    hasCpUintClaId.insert(vOnlyDectNum[s]->claPtr->uClaId);
                                }
                            }
                        }
                    }
                    //拷贝givenCla子句
                    if (midGenR && (StrategyParam::claReUseTimes != 0) && givenCla->isAxtom == false) {
                        Clause* cpClaTmp = nullptr;
                        if (givenCla->topCopyCla == nullptr)
                            cpClaTmp = givenCla;
                        else
                            cpClaTmp = givenCla->topCopyCla;
                        if (copyClaCopyTimes(cpClaTmp) < StrategyParam::claReUseTimes) {
                            Clause* cyCla = copyCla(fol, cpClaTmp, newClaId, candLitP, QLit);	//* 拷贝子句是放入到了fol.setCla的
                            cyCla->topCopyCla = cpClaTmp;
                            //插入到演绎子句列表中
                            vector<Clause*>::iterator insertInd = find(candidateClaSet_notBinary.begin(), candidateClaSet_notBinary.end(), givenCla);
                            candidateClaSet_notBinary.emplace(insertInd + 1, cyCla);	//*拷贝子句放在candidateClaSet的位置在它的父子句的后面，使得下一次的演绎又是givenCla的拷贝子句（相当于重复使用该子句）
                            midGenR = false;
                        }
                    }  
                    //cout << givenCla->uClaId << "(" << givenCla->uLitNum << "); " << candClaP->uClaId << endl;
                    //givenCla加入到已经演绎过的子句集合中
                    setRedundClaId.insert(givenCla->uClaId);
                    // </editor-fold>
                    
                    //更改此次演绎和有子句参与到三角形演绎来的成功标志
                    // <editor-fold defaultstate="collapsed" desc="步骤6：更改此次演绎和有子句参与到三角形演绎来的成功标志">
                    isDeduct = true;    //此次演绎成功
                    isGloDeduct = true; //有非二元子句参与到三角形演绎来
                    globalDeduct = true;    //有子句参与到三角形演绎来
                    // </editor-fold>
                    //givenCla子句成功演绎,break
                    break;
                }
                
                //givenCla子句成功参与到演绎中来
                if (isDeduct)
                    break;
            }
        }        
        
        //运行时间检查
        // <editor-fold defaultstate="collapsed" desc="运行时间检查">
        clock_t end = clock();
        double time_s = (double)(end - StrategyParam::start) / (double)CLOCKS_PER_SEC;
        if (time_s > StrategyParam::firstTimeLimit * 60) {
            if (globalDeduct) {
                resDeduct = 5; //有子句参与三角形演绎，但time-out
                break;
            }
            else {
                resDeduct = 4;   //达到时间限制时，没有一个子句能参与到三角形演绎中来
                break;
            }
        }
        // </editor-fold>  
        
        //R文字数的检查
        if ((vNewR.size() >= StrategyParam::R_MAX_NUM) || (isDeduct && (StrategyParam::R_INIT_MAX_NUM == candClaP->uLitNum)&&(candClaP->uLitNum > 10))) {
//            if (true) {
//                string str = "/home/ars01/Desktop/dist/aaa";
//                ofstream fout(str.c_str(), ios::app);
//                fout << "%%%%%% vNewR.size() = " << vNewR.size() << endl;
//                fout.close();
//            }
            resDeduct = 3;
            break;
        }
        
        //检查遍历是否完成
        if (cDeepth == candidateClaSet_notBinary.size() - 1) { 
            //若遍历中，非二元子句集合candidateClaSet_notBinary中没有一个子句参与到演绎中去
            if (!isGloDeduct) {
                resDeduct = 2; 
            }
            else 
                resDeduct = 0;
            break;
        }
        
        //更新下标：遍历二元子句集合candidateClaSet_binary的下一个子句
        cDeepth++;
    } 
    
    return resDeduct; 
}

UINT8 TriAlg::GenerateTriByRecodePathLRFullUseBinaryClause(Formula& fol, vector<Clause*>& candidateClaSet, UINT32 &newClaId, BACKTYPE _backType, vector<Clause*> &chgCla) {
//    if (true) {
//        string str = "/home/ars01/Desktop/dist/aaa";
//        ofstream fout(str.c_str(), ios::app);
//        fout << "***********************" << endl;
//        fout.close();
//    }
    //将候选子句集candidateClaSet分成两个集合：candidateClaSet_binary(二元子句集合); candidateClaSet_notBinary(非二元子句集合)
    // <editor-fold defaultstate="collapsed" desc="将候选子句集candidateClaSet分成两个集合：candidateClaSet_binary(二元子句集合); candidateClaSet_notBinary(非二元子句集合)">
    vector<Clause*> candidateClaSet_binary;
    candidateClaSet_binary.reserve(16);
    vector<Clause*> candidateClaSet_notBinary;
    candidateClaSet_notBinary.reserve(16);
    
    for (INT32 m = 0; m < candidateClaSet.size(); m++) {
        Clause* cla = candidateClaSet[m];
        if (cla->uLitNum == 2)
            candidateClaSet_binary.push_back(cla);
        else
            candidateClaSet_notBinary.push_back(cla);
    }
    // </editor-fold>
//    if (firstRun) {
//        int total = candidateClaSet.size();
//        int binary = candidateClaSet_binary.size();
//        int notbinary =candidateClaSet_notBinary.size();
//        FileOp::CreateDebugOutFile();
//        *FileOp::ofDebugOut << FileOp::judgeOriginalFileName << " 共有 " << total << " 个子句（其中二元子句 " << binary << " 个， 非二元子句 " << notbinary << " 个）";
//    }
    //重置相关集合
    if (_backType == NOBACK) {
        processedBinaryClaId.clear();   //记录已经处理过的二元子句Id
        setRedundClaId.clear(); //保存已经参与演绎的子句的集合
        hasCpUintClaId.clear(); //保存主界线上已经被拷贝了单元子句的集合
        vector<Literal*>().swap(vNewR);
        vNewR.reserve(8);   //保存R的文字集合
        //清楚上一个三角形的变元替换
        BackPathClear();    
        stackVarChg.reserve(100);   //保存此次三角形演绎的变元替换
    }
    
    //定义以及初始化所需的变量
    // <editor-fold defaultstate="collapsed" desc="定义以及初始化所需的变量">
    
    UINT16 resBinary = 100;  //保存二元子句集参与演绎的结果
    UINT16 resNotBinary = 100;  //保存非二元字句集参与演绎的结果
    
    //[firstIndex, lastIndex] 为遍历二元子句集合 寻找主界线文字的范围
    UINT32 firstIndex = 0;  //保存要检查的主界线第一个文字在vOnlyOutTri中的下标
    UINT32 lastIndex = UINT32(vOnlyOutTri.size() - 1);   //保存要检查的主界线最后一个文字在vOnlyOutTri中的下标
    
    globalDeduct = false;
    // </editor-fold>
    
    //先二元子句充分使用
    // <editor-fold defaultstate="collapsed" desc="二元子句集充分参与演绎，直到不能产生新的主界线文字">
    StrategyParam::midNum == 1;   //一个子句演绎最多产生1个剩余文字
    while (true) {
        resBinary = BinaryClaDeduction(fol, candidateClaSet_binary, newClaId, chgCla, firstIndex, lastIndex); 
        //处理二元子句集演绎结果
        if (resBinary == 1) {   //得到UNSAT结果
            //cout << "第一次充分使用二元 UNSAT" << endl;
            if(!StrategyParam::orForCompition && (StrategyParam::problemDiv == 0))
                cout << "得出结论:不可满足" << endl;
            return true;
        }
        else if (resBinary == 0) {  //主界线有新增文字
            firstIndex = lastIndex + 1;
            lastIndex = UINT32(vOnlyOutTri.size() - 1);
        } 
        else if (resBinary == 2) {    //没有子句能够参与到演绎中去, break
            break;    
        }  
        else if (resBinary == 3 || resBinary == 5) {    //达到R文字数的限制 或timeout（有子句参与演绎）
            UINT16 tempRes = 0;
            if (formTri = SPIREHAVELIT) {
                vNewR.push_back(vOnlyOutTri.back());
                tempRes = ProduceAndProcessR(fol, newClaId, false);
            }
            else if (formTri = FLATNOLIT)
                tempRes = ProduceAndProcessR(fol, newClaId, true);

            fol.initGenerateClaAttr(newCla);
            newClaId++;

            return 221;
        } 
        else if (resBinary == 4) {
            allNoPair = true;
            return 22;  //timeout且没有子句参与演绎
        }
    }
    // </editor-fold> 
    
//    if (true) {
//        clock_t end = clock();
//        double time_s = (double) (end - StrategyParam::start) / (double) CLOCKS_PER_SEC;
//        cout << "第一次充分使用二元子句 时间: " << time_s << "s" << endl;
//    }
    
    //将非二元子句充分使用两次，没遍历完成1次后充分使用二元子句
    StrategyParam::midNum = 0;
    for (StrategyParam::midNum = 1; StrategyParam::midNum <= 2; StrategyParam::midNum++) {
        resNotBinary = NotBinaryClaDeduction3(fol, candidateClaSet_notBinary, newClaId, chgCla);
        //处理非二元子句集演绎结果 
        if (resNotBinary == 1) {   //得到UNSAT结果
            //cout << "第" << StrategyParam::midNum << "次遍历非二元 UNSAT" << endl;
            if(!StrategyParam::orForCompition && (StrategyParam::problemDiv == 0))
                cout << "得出结论:不可满足" << endl;
            return true;
        }
        else if (resNotBinary == 0) {  //主界线有新增文字
            firstIndex = lastIndex + 1;
            lastIndex = UINT32(vOnlyOutTri.size() - 1);
            // <editor-fold defaultstate="collapsed" desc="再次二元子句集充分参与演绎，直到不能产生新的主界线文字">
            while (true) {
                resBinary = BinaryClaDeduction(fol, candidateClaSet_binary, newClaId, chgCla, firstIndex, lastIndex); 
                //处理二元子句集演绎结果
                if (resBinary == 1) {   //得到UNSAT结果
                    //cout << "充分使用二元 UNSAT" << endl;
                    if(!StrategyParam::orForCompition && (StrategyParam::problemDiv == 0))
                        cout << "得出结论:不可满足" << endl;
                    return true;
                }
                else if (resBinary == 0) {  //主界线有新增文字
                    firstIndex = lastIndex + 1;
                    lastIndex = UINT32(vOnlyOutTri.size() - 1);
                } 
                else if (resBinary == 2) {    //没有子句能够参与到演绎中去, break
                    break;    
                }  
                else if (resBinary == 3 || resBinary == 5) {    //达到R文字数的限制 或timeout（有子句参与演绎）
                    UINT16 tempRes = 0;
                    if (true) {
                        string str = "/home/ars01/Desktop/dist/aaa";
                        ofstream fout(str.c_str(), ios::app);
                        fout << "$$$$ vNewR.size() = " << vNewR.size() << endl;
                        fout.close();
                    }
                    if (formTri = SPIREHAVELIT) {
                        vNewR.push_back(vOnlyOutTri.back());
                        tempRes = ProduceAndProcessR(fol, newClaId, false);
                    }
                    else if (formTri = FLATNOLIT)
                        tempRes = ProduceAndProcessR(fol, newClaId, true);

                    fol.initGenerateClaAttr(newCla);
                    newClaId++;
                    if (true) {
                        string str = "/home/ars01/Desktop/dist/aaa";
                        ofstream fout(str.c_str(), ios::app);
                        fout << "vNewR.size() = " << vNewR.size() << "(" << newCla->uLitNum << ")" << endl;
                        fout.close();
                    }
                    return 221;
                } 
                else if (resBinary == 4) {
                    allNoPair = true;
                    return 22;  //timeout且没有子句参与演绎
                }
            }
            // </editor-fold> 
        } 
        else if (resNotBinary == 2) {    //没有子句能够参与到演绎中去, break
            continue;    
        }  
        else if (resNotBinary == 3 || resNotBinary == 4 || resNotBinary == 5) {    //达到R文字数的限制 or timeout（没有子句参与演绎） or timeout（有子句参与演绎）
            break;
        }  
    }
    //前两次非二元子句遍历结果处理
    if (resNotBinary == 3 || resNotBinary == 5) {
        
        UINT16 tempRes = 0;
        if (formTri = SPIREHAVELIT) {
            vNewR.push_back(vOnlyOutTri.back());
            tempRes = ProduceAndProcessR(fol, newClaId, false);
        }
        else if (formTri = FLATNOLIT)
            tempRes = ProduceAndProcessR(fol, newClaId, true);

        fol.initGenerateClaAttr(newCla);
        newClaId++; 
//        if (true) {
//            string str = "/home/ars01/Desktop/dist/aaa";
//            ofstream fout(str.c_str(), ios::app);
//            fout << "vNewR.size() = " << vNewR.size() << "(" << newCla->uLitNum << ")" << endl;
//            fout.close();
//        }        
        resNotBinary = 221;
        return 221;
    }
    else if (resNotBinary == 4) {
        resNotBinary = 22;
        allNoPair = true;
        return 22;
    }
    
    //第三次遍历非二元子句，剩余文字条件不做限制
    StrategyParam::midNum = StrategyParam::midR;
    resNotBinary = NotBinaryClaDeduction3(fol, candidateClaSet_notBinary, newClaId, chgCla);
    //处理非二元子句集演绎结果 
    if (resNotBinary == 1) {   //得到UNSAT结果
        //cout << "第3次遍历非二元 UNSAT" << endl;
        if(!StrategyParam::orForCompition && (StrategyParam::problemDiv == 0))
            cout << "得出结论:不可满足" << endl;
        return true;
    }
    else if (resNotBinary == 0) {  //主界线有新增文字
        firstIndex = lastIndex + 1;
        lastIndex = UINT32(vOnlyOutTri.size() - 1);
        // <editor-fold defaultstate="collapsed" desc="再次二元子句集充分参与演绎，直到不能产生新的主界线文字">
        while (true) {
            resBinary = BinaryClaDeduction(fol, candidateClaSet_binary, newClaId, chgCla, firstIndex, lastIndex); 
            //处理二元子句集演绎结果
            if (resBinary == 1) {   //得到UNSAT结果
                if(!StrategyParam::orForCompition && (StrategyParam::problemDiv == 0))
                    cout << "得出结论:不可满足" << endl;
                return true;
            }
            else if (resBinary == 0) {  //主界线有新增文字
                firstIndex = lastIndex + 1;
                lastIndex = UINT32(vOnlyOutTri.size() - 1);
            } 
            else if (resBinary == 2) {    //没有子句能够参与到演绎中去, break
                resNotBinary = 2;
                break;    
            }  
            else if (resBinary == 3 || resBinary == 5) {    //达到R文字数的限制 或timeout（有子句参与演绎）
                UINT16 tempRes = 0;
                if (formTri = SPIREHAVELIT) {
                    vNewR.push_back(vOnlyOutTri.back());
                    tempRes = ProduceAndProcessR(fol, newClaId, false);
                }
                else if (formTri = FLATNOLIT)
                    tempRes = ProduceAndProcessR(fol, newClaId, true);

                fol.initGenerateClaAttr(newCla);
                newClaId++;
//                if (true) {
//                    string str = "/home/ars01/Desktop/dist/aaa";
//                    ofstream fout(str.c_str(), ios::app);
//                    fout << "vNewR.size() = " << vNewR.size() << "(" << newCla->uLitNum << ")" << endl;
//                    fout.close();
//                }
                return 221;
            } 
            else if (resBinary == 4) {
                allNoPair = true;
                return 22;  //timeout且没有子句参与演绎
            }
        }
        // </editor-fold> 
    }  
    
    if (resNotBinary == 3 || resNotBinary == 5) {
        UINT16 tempRes = 0;
        if (formTri = SPIREHAVELIT) {
            vNewR.push_back(vOnlyOutTri.back());
            tempRes = ProduceAndProcessR(fol, newClaId, false);
        }
        else if (formTri = FLATNOLIT)
            tempRes = ProduceAndProcessR(fol, newClaId, true);

        fol.initGenerateClaAttr(newCla);
        newClaId++; 
//        if (true) {
//            string str = "/home/ars01/Desktop/dist/aaa";
//            ofstream fout(str.c_str(), ios::app);
//            fout << "vNewR.size() = " << vNewR.size() << "(" << newCla->uLitNum << ")" << endl;
//            fout.close();
//        }
        resNotBinary = 221;
    }
    else if (resNotBinary == 4 || resNotBinary == 2) {
        resNotBinary = 22;
        allNoPair = true;
    }
    
    candidateClaSet_binary.clear();
    vector<Clause*>().swap(candidateClaSet_binary);
    
    candidateClaSet_notBinary.clear();
    vector<Clause*>().swap(candidateClaSet_notBinary);    
    
    return resNotBinary;
}

/*******2020.4.2 Liu*******/
RESULT TriAlg::DoTri_Goal(Formula& fol, UINT32& newClaId) {
    RESULT finalRes = RESULT::UNKNOWN;
    
    return finalRes;
}