/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   Term.h
 * Author: sjg
 *
 * Created on 2016年11月18日, 上午11:29
 */

#ifndef TERM_H
#define TERM_H
#include "dataTypeDef.h"
#include "globalFunc.h"
#include <stdlib.h>

class Term {
public:
    //项编码: 23表示行，8位表示列；其他8位表示属性f P ~P E ~E 24位表示编码
    INT32 iTermCode;
    Term** subTermPtr;
    Term* vBinding; //变元替换项		 
    float fSteadyValue; //项的稳定度 = (常元个数+0.5*子函数稳定度)/项的总数 如盘p(a1,f1(x1)) = 1/2=0.5;  p(a1,f1(a1)) = (1+0.5*(1/1))/2=0.75; p(a1,a2)=2/2=1
    UINT8 uSubTermNum; //子项个数最多不超过2^8=256 	  0表示a x
    UINT8 uLevel; //复合层次p(f(a)) 谓词p的层数为1,f的层数为0
    UINT8 uMaxVarId; //最大的变元编号,x1,x2,x2,x3计为3
    UINT16 uVarCount; //变元计数,x1,x1计为2
    termState termSt;
    //以下用于刻画项的属性
    UINT32 groundTermCount;//统计基项在子句集中含有的个数
    //是否是 不带任何项 的谓词
    bool isWithouSubTerm;
    //构造/析构函数 ============================================
    Term(): iTermCode(0), subTermPtr(nullptr), vBinding(nullptr), fSteadyValue(0.0f), uSubTermNum(0), uLevel(0), uMaxVarId(0), uVarCount(0),termSt(noSt),groundTermCount(0){
        isWithouSubTerm = false;
    }
    //构造函数 子项个数，以及子项内容
    Term(INT32 _iTermCode);
    //Term();
//    Term(const Term& orig);
    virtual ~Term();
    /**********************************************
     * 方法函数
     **********************************************/
    //变元的关联度
    inline bool isVar(){
        if(iTermCode<0)
            return true;
        else
            return false;
    }
    inline bool isConTerm(){//常元项
        if((uSubTermNum == 0) && (uVarCount == 0))
            return true;
        else
            return false;
    }
    inline float RelationValue() {
        return uMaxVarId / (uVarCount * 0.1f);
    }
    //判断同子句中项是否相等（均为指针比较）
    bool EqualInSameCla(const Term* t);
    //判断不同子句中项是否相等（非基共享项不是指针比较）
    bool EqualNoSameCla(const Term* t);

    inline bool isEqnTerm() {
        UINT32 uCodeProp = GetCodeProp(iTermCode);
        return (TEqn == uCodeProp || TNegEqn == uCodeProp);
    }
    inline bool isPLitTerm(){
         UINT32 uCodeProp = GetCodeProp(iTermCode);
        return (TPred == uCodeProp || TNegPred == uCodeProp);
    }
    inline bool isNegLit(){
        UINT32 uCodeProp = GetCodeProp(iTermCode);
        return (TNegEqn == uCodeProp || TNegPred == uCodeProp);
    }
     inline bool isPosEqnTerm() {
        UINT32 uCodeProp = GetCodeProp(iTermCode);
        return (TEqn == uCodeProp);
    }
     //负等词项
     inline bool isNegEqnTerm() {
        UINT32 uCodeProp = GetCodeProp(iTermCode);
        return (TNegEqn == uCodeProp);
    }
     //函数项
     inline bool isFuncTerm() {//是函数项
        UINT32 uCodeProp = GetCodeProp(iTermCode);
        return (TFunc == uCodeProp);
    }
      inline bool isPredTerm() {//是谓词项
        UINT32 uCodeProp = GetCodeProp(iTermCode);
        return ((TEqn == uCodeProp) ||(TNegEqn == uCodeProp) ||(TPred == uCodeProp) ||(TNegPred == uCodeProp) );
    }
    //判断文字项是否含有共享变元
//     inline bool hasShareVar(){
//         if(uVarCount>uMaxVarId)
//             return true;
//         else
//             return false;
//     }
     inline Term* GetBindingT() {
         Term* t = this;
        while (t->vBinding)
            t = t->vBinding;
        return t;
    }
    /**********************************************
     *输出
     **********************************************/
    //输出 项中的内容
    void Print();
    //计算谓词项的函数复杂度，即将所有的函数项层数相加
    void compFuncDeepth(int& count);
    //返回项内容
    string ToString();
    string ToStringBind();
    //string ToStringWithSemantics(const CseSymbolMapper& mapper);
    //void countVTerm(UINT32 &count);
    bool IsExistBind();
    bool IsExistNoVarBind();
    bool IsGroundLit();//基项的判断
    bool IsSingleVarLit();//含独立变元的项判断,也可能含共享变元
    bool IsShareVarLit();//含共享变元的项判断
    //20170901 以下用于等词处理
    void countTerm(UINT32& TermCount);
    void countTermE(UINT32& TermCount,UINT8 funCoff, UINT8 varCoff);
    void countVarTerm(UINT32& TermCount);
    void recordTerm(vector<Term*>* termVec);
    bool similarTerm(Term* term);
    void termNum(int* number);
    bool suitSuper();
    //记录项中含有不重复变元的个数
    void countUqVarTerm(UINT32& TermCount, vector<INT32>& save);
    bool hasVarOrBindVar();
};



class VarTermCmp : greater<Term*> {
public:
    bool operator()(const Term* t1, const Term* t2) const {
        return t1->iTermCode < t2->iTermCode;
    }
};

#endif /* TERM_H */

