/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   Term.cpp
 * Author: sjg
 * 
 * Created on 2016年11月18日, 上午11:29
 */

#include "Term.h"
#include "StrategyParam.h"
#include "HashNode.h"
set<HashNode*, HashNodeCmpByCode> g_HashTree;//存放基项,如a1,f(a1),p(a1)
//Term::Term() {
//}
Term::Term(INT32 _iTermCode) : iTermCode(_iTermCode), subTermPtr(nullptr), vBinding(nullptr), fSteadyValue(0.0f), uSubTermNum(0), uLevel(0), uMaxVarId(0), uVarCount(0),termSt(noSt),groundTermCount(0){
    isWithouSubTerm = false;
}
//Term::Term(const Term& orig) {
//}

Term::~Term() {
}

//同一个子句中项的相等比较
bool Term::EqualInSameCla(const Term* t)
{
    if (uSubTermNum != t->uSubTermNum || iTermCode != t->iTermCode) return false;
    for (UINT8 i = 0; i < uSubTermNum; ++i) {
        if (subTermPtr[i] != t->subTermPtr[i])
            return false;
    }
    return true;
}
//判断不同子句中项是否相等（非基共享项不是指针比较）
bool Term::EqualNoSameCla(const Term* t)
{
    if (uSubTermNum != t->uSubTermNum || iTermCode != t->iTermCode) return false;
    vector<Term*>stactTerm;
    do {
        Term*t1;
        Term* t2;
        for (UINT8 i = 0; i < uSubTermNum; ++i) {
            t1 = subTermPtr[i];
            t2 = t->subTermPtr[i];
            if (t1 == t2) //共享基函数项
                continue;
            if (t1->uSubTermNum == 0 && t2->uSubTermNum == 0) //变元/常元
            {
                if (t1->iTermCode != t2->iTermCode) return false;
            } else//非共享基函数项
            {
                stactTerm.push_back(t1);
                stactTerm.push_back(t2);
            }
        }
        if (stactTerm.empty()) break;
        t2 = stactTerm.back();
        stactTerm.pop_back();
        t1 = stactTerm.back();
        stactTerm.pop_back();
        if (t1->uSubTermNum != t2->uSubTermNum || t1->iTermCode != t2->iTermCode) return false;
    } while (1);
    return true;
}

void Term::Print()
{
	 
    if (iTermCode < 0)
        cout << "x" << ((iTermCode >> 8) & 0x7FFFFF) << (iTermCode & 0xFF);
    else {
        const UINT32 uId = GetCodeId(iTermCode);
        INT32 iCodeProp = GetCodeProp(iTermCode);
        switch (iCodeProp) {
            case TCon:
                cout << "a";
                if (uId == 0) cout << "";
                cout << uId;
                break;
            case TPred:
                cout << "P" + (uId == 0 ? "" : to_string(uId));
                this->isWithouSubTerm ? cout << "" : cout << "(";
                break;
            case TNegPred:
                cout << "~P" + (uId == 0 ? "" : to_string(uId));
                this->isWithouSubTerm ? cout << "" : cout << "(";
                break;
            case TEqn:
                cout << "E" + (uId == 0 ? "" : to_string(uId)) + "(";
                break;
            case TNegEqn:
                cout << "~E" + (uId == 0 ? "" : to_string(uId)) + "(";
                break;
            case TFunc:
                cout << "f" + (uId == 0 ? "" : to_string(uId)) + "(";
                break;
        }
    }
    for (UINT8 i = 0; i < uSubTermNum; ++i) {
        subTermPtr[i]->Print();
        if (i < uSubTermNum - 1)
            cout << ",";
        else
            cout << ")";
    }
}
void Term::compFuncDeepth(int& count) {//compFuncDeepth计算项的复杂度(含替换项)
    if (iTermCode < 0) {
        Term* tepLast = nullptr;
        Term* tepT = vBinding;
        while (tepT) {
            tepLast = tepT;
            tepT = tepT->vBinding;
        }
        if(tepLast)
            tepLast->compFuncDeepth(count);
    }
    else {
        INT32 iCodeProp = GetCodeProp(iTermCode);
        if (iCodeProp == TFunc)
            count += uLevel;
    }
    for (UINT8 i = 0; i < uSubTermNum; ++i)
        subTermPtr[i]->compFuncDeepth(count);
}

//返回项内容

string Term::ToString()
{
    string sTerm = "";
    if (iTermCode < 0)
        sTerm += "x" + to_string((iTermCode >> 8) & 0x7FFFFF) + to_string(iTermCode & 0xFF);
    else {
        const UINT32 uId = GetCodeId(iTermCode);
        INT32 iCodeProp = GetCodeProp(iTermCode);
        switch (iCodeProp) {
            case TCon:
                sTerm += "a" + (uId == 0 ? "" : to_string(uId));
                break;
            case TPred:
                sTerm += "P" + (uId == 0 ? "" : to_string(uId));
                sTerm += this->isWithouSubTerm ? "" : "(";
                break;
            case TNegPred:
                sTerm += "~P" + (uId == 0 ? "" : to_string(uId));
                sTerm += this->isWithouSubTerm ? "" : "(";
                break;
            case TEqn:
                sTerm += "E" + (uId == 0 ? "" : to_string(uId)) + "(";
                break;
            case TNegEqn:
                sTerm += "~E" + (uId == 0 ? "" : to_string(uId)) + "(";
                break;
            case TFunc:
                sTerm += "f" + (uId == 0 ? "" : to_string(uId)) + "(";
                break;
        }
    }
    for (UINT8 i = 0; i < uSubTermNum; ++i)
        sTerm += subTermPtr[i]->ToString() + ",";
    if (0 < uSubTermNum)
        sTerm = sTerm.erase(sTerm.length() - 1) + ")"; //删除最后一个"，"
    return sTerm;
}

//返回项内容,并输出替换项

string Term::ToStringBind()
{ 
    string sTerm = "";
    if (iTermCode < 0){
        sTerm += "x" + to_string((iTermCode >> 8) & 0x7FFFFF) + to_string(iTermCode & 0xFF);
        if(this->vBinding)
        {
            sTerm += "\\";
            //cout<<"debug"<<endl;
            sTerm +=this->vBinding->ToStringBind();
        }
    }
    else {
        const UINT32 uId = GetCodeId(iTermCode);
        INT32 iCodeProp = GetCodeProp(iTermCode);
        switch (iCodeProp) {
            case TCon:
                sTerm += "a" + (uId == 0 ? "" : to_string(uId));
                break;
            case TPred:
                sTerm += "~P" + (uId == 0 ? "" : to_string(uId));
                sTerm += this->isWithouSubTerm ? "" : "(";
                break;
            case TNegPred:
                sTerm += "~P" + (uId == 0 ? "" : to_string(uId));
                sTerm += this->isWithouSubTerm ? "" : "(";
                break;
            case TEqn:
                sTerm += "E" + (uId == 0 ? "" : to_string(uId)) + "(";
                break;
            case TNegEqn:
                sTerm += "~E" + (uId == 0 ? "" : to_string(uId)) + "(";
                break;
            case TFunc:
                sTerm += "f" + (uId == 0 ? "" : to_string(uId)) + "(";
                break;
        }
    }
    for (UINT8 i = 0; i < uSubTermNum; ++i)
        sTerm += subTermPtr[i]->ToStringBind() + ",";
    if (0 < uSubTermNum)
        sTerm = sTerm.erase(sTerm.length() - 1) + ")"; //删除最后一个"，"
    return sTerm;
}

//string Term::ToStringWithSemantics(const CseSymbolMapper& mapper) {
//    string sTerm = "";
//    if (iTermCode < 0)
//        sTerm += "X" + to_string(iTermCode & 0xFF);
//    else {
//        const UINT32 uId = GetCodeId(iTermCode);
//        INT32 iCodeProp = GetCodeProp(iTermCode);
//        string term_str;
//        string semantics_str;
//        unordered_map<std::string, std::string> reverse_map;
//        
//        switch (iCodeProp) {
//            case TCon:
//                term_str = "a" + (uId == 0 ? "" : to_string(uId));
//                reverse_map = mapper.getReverseConstantMap();
//                for (const auto& p : reverse_map) {
//                    if (p.first == term_str) semantics_str = p.first;
//                }
//                sTerm += semantics_str;
//                break;
//            case TPred:
//                term_str = "P" + (uId == 0 ? "" : to_string(uId));
//                reverse_map = mapper.getReversePredicateMap();
//                for (const auto& p : reverse_map) {
//                    if (p.first == term_str) semantics_str = p.first;
//                }
//                sTerm += semantics_str;
//                sTerm += this->isWithouSubTerm ? "" : "(";
//                break;
//            case TNegPred:
//                sTerm += "~";
//                term_str = "P" + (uId == 0 ? "" : to_string(uId));
//                reverse_map = mapper.getReversePredicateMap();
//                for (const auto& p : reverse_map) {
//                    if (p.first == term_str) semantics_str = p.first;
//                }
//                sTerm += semantics_str;
//                sTerm += this->isWithouSubTerm ? "" : "(";
//                break;
//            case TEqn:
//                sTerm += "E" + (uId == 0 ? "" : to_string(uId)) + "(";
//                break;
//            case TNegEqn:
//                sTerm += "~E" + (uId == 0 ? "" : to_string(uId)) + "(";
//                break;
//            case TFunc:
//                sTerm += "f" + (uId == 0 ? "" : to_string(uId)) + "(";
//                break;
//        }
//    }
//    for (UINT8 i = 0; i < uSubTermNum; ++i)
//        sTerm += subTermPtr[i]->ToString() + ",";
//    if (0 < uSubTermNum)
//        sTerm = sTerm.erase(sTerm.length() - 1) + ")"; //删除最后一个"，"
//    return sTerm;
//}

//判断项是否含有替换项
bool Term::IsExistBind()
{ 
    if (iTermCode < 0){
        if(vBinding)
        {
           return true;
        }
    }
    for (UINT8 i = 0; i < uSubTermNum; ++i){
        if(subTermPtr[i]->IsExistBind())
            return true;
    }
    return false;
}//IsSingleVarLit
//判断项是否含有替换项
bool Term::IsExistNoVarBind()
{ 

    if (vBinding) {
        return true;
    }

    for (UINT8 i = 0; i < uSubTermNum; ++i) {
        if (subTermPtr[i]->IsExistNoVarBind())
            return true;
    }
    return false;
}
//判断谓词项是基项
bool Term::IsGroundLit()
{ 
    if (iTermCode < 0){
           return false;
    }
    for (UINT8 i = 0; i < uSubTermNum; ++i){
        if(!subTermPtr[i]->IsGroundLit())
            return false;
    }
    return true;
}//
//判断谓词项含独立变元(不能保证只含有独立变元的文字)
bool Term::IsSingleVarLit()
{ 
    if (iTermCode < 0){
        if((termSt != isShareVar) && (termSt == isSingleVar))
        {
           return true;
        }
    }
    for (UINT8 i = 0; i < uSubTermNum; ++i){
        if(subTermPtr[i]->IsSingleVarLit())
            return true;
    }
    return false;
}//
//判断谓词项含有共享变元
bool Term::IsShareVarLit()
{ 
    if (iTermCode < 0){
        if(termSt == isShareVar)
        {
           return true;
        }
    }
    for (UINT8 i = 0; i < uSubTermNum; ++i){
        if(subTermPtr[i]->IsShareVarLit())
            return true;
    }
    return false;
}//
//20170901 以下用于等词处理
void Term::countTerm(UINT32& TermCount)
{
    if (iTermCode < 0)
        ++TermCount;
    else {
        const UINT32 uId = GetCodeId(iTermCode);
        INT32 iCodeProp = GetCodeProp(iTermCode);
        switch (iCodeProp) {
            case TCon:
                ++TermCount;
                break;
            case TPred:
                ++TermCount;
                break;
            case TNegPred:
                ++TermCount;
                break;
            case TEqn:
                ++TermCount;
                break;
            case TNegEqn:
                ++TermCount;
                break;
            case TFunc:
                ++TermCount;
                break;
        }
    }
    for (UINT8 i = 0; i < uSubTermNum; ++i)
        subTermPtr[i]->countTerm(TermCount);
    return;
}
//20170916 参考E的项的记数
void Term::countTermE(UINT32& TermCount,UINT8 funCoff, UINT8 varCoff)
{
    if (iTermCode < 0)
        TermCount = TermCount + varCoff ;
    else {
        //const UINT32 uId = GetCodeId(iTermCode);
        INT32 iCodeProp = GetCodeProp(iTermCode);
        switch (iCodeProp) {
            case TCon:
                TermCount = TermCount + funCoff ;
                break;
            case TPred:
                break;
            case TNegPred:
                break;
            case TEqn:
                break;
            case TNegEqn:
                break;
            case TFunc:
                TermCount = TermCount + funCoff ;
                break;
        }
    }
    for (UINT8 i = 0; i < uSubTermNum; ++i)
        subTermPtr[i]->countTermE(TermCount,funCoff,varCoff);
    return;
}
//记录项中含有变元的个数
void Term::countVarTerm(UINT32& TermCount)
{
    if (iTermCode < 0)
        ++TermCount;
    for (UINT8 i = 0; i < uSubTermNum; ++i)
        subTermPtr[i]->countTerm(TermCount);
    return;
}
//记录项中含有不重复变元的个数
void Term::countUqVarTerm(UINT32& TermCount, vector<INT32>& save)
{
    if (iTermCode < 0){
        //判断变元是否已经存在
        bool insertFlag = true;
        if(find(save.begin(), save.end(), iTermCode) != save.end()){//存在
            insertFlag = false;
        }
        if(insertFlag){
            ++TermCount;
            save.push_back(iTermCode);
        }
    }
    for (UINT8 i = 0; i < uSubTermNum; ++i)
        subTermPtr[i]->countUqVarTerm(TermCount, save);
    return;
}
//记录文字的各个项
void Term::recordTerm(vector<Term*>* termVec)
{
    if (iTermCode < 0)
        termVec->push_back(this);
    else {
        const UINT32 uId = GetCodeId(iTermCode);
        INT32 iCodeProp = GetCodeProp(iTermCode);
        switch (iCodeProp) {
            case TCon:
                termVec->push_back(this);
                break;
            case TPred:
                termVec->push_back(this);
                break;
            case TNegPred:
                termVec->push_back(this);
                break;
            case TEqn:
                termVec->push_back(this);
                break;
            case TNegEqn:
                termVec->push_back(this);
                break;
            case TFunc:
                termVec->push_back(this);
                break;
        }
    }
    for (UINT8 i = 0; i < uSubTermNum; ++i)
        subTermPtr[i]->recordTerm(termVec);
    return;
}
static UINT8 m=0;
bool Term::similarTerm(Term* term)
{
    int Number[1000] = {0} ;
    int termNumber[1000] = {0};
    m=0;
    termNum(Number);
    m=0;
    term->termNum(termNumber);
    int length1 = 0;
    int length2 = 0;
    for(int i=0 ; i< 255; ++i){
        if(Number[i] != 0)
            ++length1;
    }
    for(int i=0 ; i< 255; ++i){
        if(termNumber[i] != 0)
            ++length2;
    }
    if(length1 != length2)
        return false;
    else
    {
        for(UINT8 i=0; i< 255; ++i){
            if(Number[i] != termNumber[i])
                return false;
        }
    }
    return true;
}
void Term::termNum(int* number)
{
    INT32 iCodeProp = GetCodeProp(iTermCode);
//    if(iCodeProp == TFunc){
//        ++m;
//    }
    if(iCodeProp == TFunc)
        number[m++] = uSubTermNum;
    else if(iTermCode<0)
        number[m++] = 0;
    else
        number[m++] = 0;
    for (UINT8 i = 0; i < uSubTermNum; ++i){
        //if(GetCodeProp(subTermPtr[i]->iTermCode) == TFunc)
            subTermPtr[i]->termNum(number);
    }
    return;
}
//判断子句是否符合等词处理
bool Term::suitSuper(){
    if(GetCodeProp(iTermCode) != TEqn){
        return false;
    }
    UINT32 leftTermSum = 0;
    subTermPtr[0]->countTermE(leftTermSum,1,1);
    UINT32 rightTermSum = 0;
    subTermPtr[1]->countTermE(rightTermSum,1,1);
    if((rightTermSum<=StrategyParam::termRewritingSize)&&(leftTermSum>rightTermSum))
        return true;
    else
        return false;
}
//判断谓词项是否存在变元(替换项后)
bool Term::hasVarOrBindVar()
{ 
    if (iTermCode < 0){
        Term* t = GetBindingT();
        if(t->iTermCode < 0)
            return true;
    }
    for (UINT8 i = 0; i < uSubTermNum; ++i){
        if(subTermPtr[i]->hasVarOrBindVar())
            return true;
    }
    return false;
}