/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   Subsumption.h
 * Author: sjg
 *
 * Created on 2016年11月27日, 上午9:31
 */

#ifndef SUBSUMPTION_H
#define SUBSUMPTION_H
#include "Unify.h"
#include "Term.h"
#include "Clause.h"
#include "Literal.h"
#include "globalFunc.h"
#include "dataTypeDef.h"
class Subsumption {
public:
    Subsumption();
    Subsumption(const Subsumption& orig);
    virtual ~Subsumption();
    //读入文件时对其进行恒真 检查
    static bool CheckTautology(vector<string>& vectLit);
    //包含冗余处理

    bool GenCla(Clause* queryCla, UINT32& uClaCode) {
        set<INT32> vFindedClaID; //已经检测过的子句不再检测
        vector<UINT32> vInvaildClaId;
        for (UINT16 ind = 0; ind < queryCla->uLitNum; ++ind) {
            Literal*qLit = queryCla->LitPtr[ind]; //依次取到文字指针
            vector<Literal*>*vCandLits = qLit->getPredLst(); //取到存放map中对应n元谓词的文字指针的vector

            for (auto& candLitPtr : *vCandLits)//依次取到vector中每一个文字指针
            {
                Clause* candCla = candLitPtr->claPtr; //依次取到vector中每一个子句指针
                INT32 candRow = candCla->uClaId; //依次取到vector中每一个子句编号
                if (candRow == queryCla->uClaId) continue; //若是子句本身则跳出继续
                if (candCla->uLitNum > queryCla->uLitNum) continue; //若找到的子句含的文字数大于本身文字个数，跳出继续
                if (vFindedClaID.find(candRow) != vFindedClaID.end())
                    continue; //若找到的子句已经检测过，在跳出继续
                vFindedClaID.insert(candRow); //找到的子句加入到已检测子句集合中
                if (ConClaIncludeVarCla(queryCla, candCla, vInvaildClaId))//参数1：检查的子句指针；参数2：查找的子句指针；参数3：无效的子句集合
                {
                    uClaCode = candRow;
                    /*string out = "# R无效，包含C:" + to_string(candRow);
                    FileOp::LogOut(out);*/
                    return true;
                }
            }
        }
        return false;
    }
    //包含冗余处理	  vInvaildClaId R中导致包含冗余文字所在子句编号
    //参数1 被测的子句指针 参数2 整形数组 参数3 字符串 记录冗余信息
    bool GenCla(Formula& fol, Clause* queryCla, vector<UINT32>&vInvaildClaId, string& rundacyMsg) {
        set<INT32> vFindedClaID; //已经检测过的子句不再检测
        if(queryCla->uLitNum >= 50){
            rundacyMsg = "|[无效]文字数超过限定大小;";
            return true;
        }
        for (UINT16 ind = 0; ind < queryCla->uLitNum; ++ind) {
            Literal*qLit = queryCla->LitPtr[ind];//依次得到被测子句的各个文字
            vector<Literal*>*vCandLits = qLit->getPredLst();//得到谓词相同的的文字集合
            vInvaildClaId.reserve(8);
            rundacyMsg = "|[Y]";
            for (auto& candLitPtr : *vCandLits) {//一次取到谓词相同的的文字
                Clause* candCla = candLitPtr->claPtr;//取到待比较的子句
                INT32 candRow = candCla->uClaId;//取到待比较的子句编号
                if (candRow == queryCla->uClaId) continue;//待比较的子句编号与被测子句编号相同，则继续下一轮
                if (candCla->uLitNum > queryCla->uLitNum) continue;//待比较的子句文字个数大于被测子句文字个数，则继续下一轮
                if (vFindedClaID.find(candRow) != vFindedClaID.end())//待比较的子句已经被比较过，则继续下一轮
                    continue;
                vFindedClaID.insert(candRow);//加入待比较的子句编号，表示已经比较过
                if (ConClaIncludeVarCla(queryCla, candCla, vInvaildClaId)) {//参数1 被测子句 参数2 待比较子句 参数3 整形数组，冗余的子句集合
                    rundacyMsg = "|[无效]包含C_" + to_string(candRow) + ":导致冗余的文字";
                    for (auto&id : vInvaildClaId) {
                        rundacyMsg += to_string(GetClaId(id)) + "_" + to_string(GetVarId(id)) + ";";
                        //20170919 增大导致冗余的子句权重
                        addWeight(fol,id);
                    }
                    return true;
                }
            }
        }
        return false;
    }
    void addWeight(Formula& fol,UINT32 id) {
        if (StrategyParam::useSaturate) {
            for (auto& aClp : fol.setDeductCla) {
                if (aClp->uClaId == id) {
                    if (aClp->uLitNum == 1)
                        aClp->adeductNum += 2;
                    else
                        aClp->reduntTimes += 50;
                }
            }
        } else {
            for (auto& aClp : fol.setDeductCla) {
                if (aClp->uClaId == id) {
                    if (aClp->uLitNum == 1)
                        aClp->adeductNum += 2;
                    else
                        aClp->reduntTimes += 50;
                }
            }
        }
    }
   //参数:标准子句  找出的冗余子句
    void InstCla(Clause&queryCla, set<Clause*>&vRundacyClas) {
        //得到候选比较文字		
        //取交集
        for (UINT16 i = 0; i < queryCla.uLitNum; ++i) {//依次取到候选子句的每个文字
            for (auto&candLitP : *queryCla.LitPtr[i]->getPredLst()) {//依次取到候选子句各个文字的其它相同谓词的文字
                //cout<<"匹配的相同谓词项:"<<(*queryCla.LitPtr[i]->getPredLst()).size()<<endl;
                Clause* conCla = candLitP->claPtr;//依次得到每一个查找的子句
                //string str;
                //conCla->toString(str);
                //cout <<"匹配的子句:" <<str << endl;
                if (conCla == &queryCla || conCla->uLitNum < queryCla.uLitNum || vRundacyClas.find(conCla) != vRundacyClas.end())//如果查找的子句与候选的子句为同一个子句或查找的子句文字个数与候选的子句文字个数小，该子句已作为过候选子句
                    continue;
                if (ConClaIncludeVarCla(conCla, &queryCla))//参数1：查找的子句，参数2：候选的子句
                {
                    //cout<<"冗余的子句编号:"<<conCla->uClaId<<endl;
                    vRundacyClas.insert(conCla);
                }
            }
        }
    }

    //定向冗余判断，删除指定的冗余子句
    //参数:标准子句  找出的冗余子句
    void InstClaDirect(Clause&queryCla,Clause& cla_Del, set<Clause*>&vRundacyClas) {
        //得到候选比较文字		
        //取交集
        for (UINT16 i = 0; i < queryCla.uLitNum; ++i) {//依次取到候选子句的每个文字
            //for (auto&candLitP : *queryCla.LitPtr[i]->getPredLst()) {//依次取到候选子句各个文字的其它相同谓词的文字
                //cout<<"匹配的相同谓词项:"<<(*queryCla.LitPtr[i]->getPredLst()).size()<<endl;
                Clause* conCla = &cla_Del;//candLitP->claPtr;//依次得到每一个查找的子句
                //string str;
                //conCla->toString(str);
                //cout <<"匹配的子句:" <<str << endl;
                if (conCla == &queryCla || conCla->uLitNum < queryCla.uLitNum || vRundacyClas.find(conCla) != vRundacyClas.end())//如果查找的子句与候选的子句为同一个子句或查找的子句文字个数与候选的子句文字个数小，该子句已作为过候选子句
                    continue;
                if (ConClaIncludeVarCla(conCla, &queryCla))//参数1：查找的子句，参数2：候选的子句
                {
                    //cout<<"冗余的子句编号:"<<conCla->uClaId<<endl;
                    vRundacyClas.insert(conCla);
                }
            //}
        }
    }
    
    //参数1：检查的子句指针；参数2：查找的子句指针；参数3：冗余的子句集合
//参数1 被测子句 参数2 待比较子句 参数3 整形数组，冗余的子句集合
    bool ConClaIncludeVarCla(Clause* conCla, Clause* varCla, vector<UINT32>& vInvaildClaId) {
        //定义堆栈:一个存放回退变元指针，一个存放回退变元替换--切记这里对应的为可变子句的文字
        //debug
//        if(conCla->uClaId == 28 && varCla->uClaId == 26){
//            //输出子句
//            conCla->Print();
//            varCla->Print();
//        }
        
        vector<vector < UINT32>> staVarChgTs;
        vector<UINT32> staLitsPairId;
        UINT16 varLitInd = 0, conLitInd = 0;
        Unify unify;
        Term** varBind = nullptr;
        if (varCla->MaxVarId() > 0)//查找的子句含有变元
        {
            varBind = new Term*[varCla->MaxVarId()]; //初始化一个变量替换数组		
            memset(varBind, 0, sizeof (Term*)*(varCla->MaxVarId())); //所有指针设置为null
        }
        while (1) {
            bool isFind = false;
            while (conLitInd != conCla->uLitNum)//检查的子句文字个数不为0
            {
                isFind = false;
                vector<UINT32>chgVarT;

                /*if (conCla->uClaId == 3 && varCla->uClaId == 1)
                        cout << "debug"<<endl;*/
                //匹配成功，找到没有替换或通过替换成相同的文字
                if (unify.Match(conCla->LitPtr[conLitInd], varCla->LitPtr[varLitInd], varBind, chgVarT))
                    //参数1：检查子句的第一个文字指针；参数2：被测的子句的第一个文字指针；参数3:被测子句含变元个数的项指针数组；参数4：整形vector，记录被改变的变元项
                {

                    isFind = true;
                    staLitsPairId.push_back(varLitInd); //记录被测文字的序号
                    staLitsPairId.push_back(conLitInd); //记录检查文字的序号
                    staVarChgTs.push_back(chgVarT); //记录被测子句文字替换的变元 vector
                    vInvaildClaId.push_back(conCla->LitPtr[conLitInd]->ParentLitCode()); //添加导致冗余的子句文字
                    //第一个文字找到匹配，则查找后一个文字的匹配//都查找完毕则退出	
                    if (++varLitInd == varCla->uLitNum)
                        break;
                    conLitInd = 0; //	   
                }                    //匹配失败，还原变元替换项
                else {
                    if (!chgVarT.empty()) {
                        for (auto&ind : chgVarT)
                            varBind[ind] = nullptr;
                        /*Concurrency::parallel_for_each(chgVarT.begin(), chgVarT.end(), []
                                (Term* t){  	t->vBinding = nullptr;  });*/
                    }
                    ++conLitInd;
                }
            }
            //isFind==true;--所有变元子句文字都找到匹配项。isFind=false; 说明没有该文字在当前替换下没有找到匹配，需要回退
            if (isFind) {
                if (!staVarChgTs.empty()) {
                    /*for (auto&vt : staVarChgTs)
                    {
                    for (auto&t : vt)
                    t->vBinding = nullptr;
                    vector<Term*>().swap(vt);
                    }*/

                    /*Concurrency::parallel_for_each(staVarChgTs.begin(), staVarChgTs.end(), [&varBind]
                            (vector<Term*>&vt)
                            {
                            Concurrency::parallel_for_each(vt.begin(), vt.end(), [&varBind]
                            (UINT32 ind){varBind[ind] = nullptr; });
                            });*/

                    for (auto& vt : staVarChgTs) {
                        for (auto& ind : vt) {
                            varBind[ind] = nullptr;
                        }
                    }
                    staVarChgTs.clear();
                }
                if (varBind)
                    delete[]varBind;
                return true;
            }
            //回退   
            if (staVarChgTs.empty()) {
                if (varBind)
                    delete[]varBind;
                return false;
            }
            conLitInd = staLitsPairId.back();
            staLitsPairId.pop_back();
            ++conLitInd;
            varLitInd = staLitsPairId.back();
            staLitsPairId.pop_back();

            vector<UINT32 >&changeVarTMP = staVarChgTs.back();
            //还原变元替换项
            if (!changeVarTMP.empty()) {
                for (auto&ind : changeVarTMP) {
                    varBind[ind] = nullptr;
                }
                /*Concurrency::parallel_for_each(changeVarTMP.begin(), changeVarTMP.end(), [&varBind]
                        (UINT32 ind){varBind[ind] = nullptr;  });*/
                /*for (auto&t : changeVarTMP)
                        t->vBinding = nullptr;*/
            }

            staVarChgTs.pop_back();
            vInvaildClaId.pop_back();
        }

    }
    //参数1：查找的子句，参数2：候选的子句
    bool ConClaIncludeVarCla(Clause* conCla, Clause* varCla) {
        //定义堆栈:一个存放回退变元指针，一个存放回退变元替换--切记这里对应的为可变子句的文字
        vector<vector < UINT32>> staVarChgTs;
        vector<UINT32> staLitsPairId;//记录候选子句与查找子句相配对的编号
        UINT16 varLitInd = 0, conLitInd = 0;
        Unify unify;

        Term** varBind = nullptr;
        if (varCla->MaxVarId() > 0) {//如果候选的子句存在变元
            varBind = new Term*[varCla->MaxVarId()]; //初始化一个变量替换数组		
            memset(varBind, 0, sizeof (Term*)*(varCla->MaxVarId())); //所有指针设置为null
        }
        while (1) {
            bool isFind = false;
            while (conLitInd != conCla->uLitNum) {//依次选到每一个查找子句的文字
                isFind = false;
                vector<UINT32>chgVarT;

                /*if (conCla->uClaId == 3 && varCla->uClaId == 1)
                        cout << "debug"<<endl;*/
                //匹配成功
                //参数1：查找子句的文字 参数2：候选子句的文字 参数3 存放候选子句的变元替换项的指针数组 参数4：整形数组，记录候选文字中变元的替换项列号
                if (unify.Match(conCla->LitPtr[conLitInd], varCla->LitPtr[varLitInd], varBind, chgVarT)) {
                    
                    isFind = true;
                    staLitsPairId.push_back(varLitInd);//记录候选子句配对的文字编号
                    staLitsPairId.push_back(conLitInd);//记录查找子句配对的文字编号
                    staVarChgTs.push_back(chgVarT);//记录候选文字中已配对成功变元的替换项列号
                    //第一个文字找到匹配，则查找后一个文字的匹配//都查找完毕则退出	
                    if (++varLitInd == varCla->uLitNum)
                        break;
                    conLitInd = 0; //	   
                }                    //匹配失败，还原变元替换项
                else {
                    if (!chgVarT.empty()) {//记录候选文字中已配对成功变元的替换项列号
                        for (auto&ind : chgVarT)
                            varBind[ind] = nullptr;
                        /*Concurrency::parallel_for_each(chgVarT.begin(), chgVarT.end(), [&varBind]
                                (UINT32 ind){varBind[ind] = nullptr;  });*/
                    }
                    ++conLitInd;
                }
            }
            //isFind==true;--所有变元子句文字都找到匹配项。isFind=false; 说明没有该文字在当前替换下没有找到匹配，需要回退
            if (isFind) {
                if (!staVarChgTs.empty()) {//记录候选文字中已配对成功变元的替换项列号
                    for (auto&vt : staVarChgTs) {
                        for (auto&ind : vt)
                            varBind[ind] = nullptr;
                        vector<UINT32>().swap(vt);
                    }

                    /*Concurrency::parallel_for_each(staVarChgTs.begin(), staVarChgTs.end(), [&varBind]
                            (vector<Term*>&vt)
                            {
                            /*Concurrency::parallel_for_each(vt.begin(), vt.end(), [&varBind]
                            (UINT32 ind){varBind[ind] = nullptr; });
                            });
                            staVarChgTs.clear(); */
                }
                if (varBind) delete[]varBind;
                return true;
            }
            //回退   
            if (staVarChgTs.empty()) {//记录候选文字中已配对成功变元的替换项列号
                if (varBind) delete[]varBind;
                return false;
            }
            conLitInd = staLitsPairId.back();
            staLitsPairId.pop_back();
            ++conLitInd;//依次选到每一个查找子句的文字项+1
            varLitInd = staLitsPairId.back();
            staLitsPairId.pop_back();

            vector<UINT32 >&changeVarTMP = staVarChgTs.back();//记录候选文字中已配对成功变元的替换项列号
            //还原变元替换项
            if (!changeVarTMP.empty()) {
                /*Concurrency::parallel_for_each(changeVarTMP.begin(), changeVarTMP.end(), [&varBind]
                        (UINT32 ind){varBind[ind] = nullptr;  });*/
                for (auto&ind : changeVarTMP)
                    varBind[ind] = nullptr;
            }
            staVarChgTs.pop_back();
        }
    }
private:

};

#endif /* SUBSUMPTION_H */

