/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   SortRule.h
 * Author: sjg
 *
 * Created on 2016年11月18日, 下午7:52
 */

#ifndef SORTRULE_H
#define SORTRULE_H
#include "StrategyParam.h"
#include"dataTypeDef.h"
#include"HashNode.h"
#include "Literal.h"
#include "Clause.h"
#include"globalFunc.h"
class SortRule {
public:
    //排序规则-- hashNode根据 hashCode 大小进行排序

    inline static bool CmpHashNode(const HashNode& hashNodeA, const HashNode& hashNodeB) {
        return hashNodeA.uHashCode < hashNodeB.uHashCode;
    }

    //子句排序规则
    inline static bool SingleClaCmp(const Clause* c1, const Clause* c2) {
        if(c1->uLitNum != 1 || c2 ->uLitNum != 1)
            return c1->uLitNum < c2->uLitNum;
        else
            return c1->adeductNum < c2->adeductNum;
    }
    inline static bool noPairClaCmp(const Clause* c1, const Clause* c2) {
        int lenA = c1->termCount11;
        int lenB = c2 ->termCount11;
        if (c1->hasUsed() == c2->hasUsed())
            if (c1->uLitNum == c2->uLitNum)
                return lenA < lenB;
            else
                return c1->uLitNum < c2->uLitNum;
        else
            return c1->hasUsed() < c2->hasUsed();
    }
    inline static bool singleResetId(const Literal* c1, const Literal* c2) {
        return c1->claPtr->uClaId < c2->claPtr->uClaId;
    }
    inline static bool ClaCmp(const Clause* c1, const Clause* c2) {
        /*
         * 0, "NS(子句冗余次数最少>子句文字数>子句稳定度>主动归结次数最少)"
         * 1, "SN(子句冗余次数最少>子句稳定度>子句文字数>主动归结次数最少)"
         */
        if (c1->Priority != c2->Priority)
            return c1->Priority > c2->Priority;
        ////子句文字数>子句稳定度
        if (StrategyParam::SEL_STARTLit_STRATEGY == 0) {
            if (c1->uLitNum == c2->uLitNum) {
                if (c1->uFuncDepth != c2->uFuncDepth) return c1->uFuncDepth < c2->uFuncDepth;
                    return (c1->MaxVarId() / (1.0 * c1->uVarCount)) < (c2->MaxVarId() / (1.0 * c2->uVarCount));
            }
            return c1->uLitNum < c2->uLitNum;
        } else {

            if (c1->uFuncDepth != c2->uFuncDepth) return c1->uFuncDepth < c2->uFuncDepth;
            double dSteadyA = c1->MaxVarId() / (1.0 * c1->uVarCount);
            double dSteadyB = c2->MaxVarId() / (1.0 * c2->uVarCount);
            if (dSteadyA != dSteadyB) return dSteadyA < dSteadyB;
            return c1->uLitNum < c2->uLitNum;
        }
    }
    /************************************************************************/
    /*主动归结文字排序（排序的文字在同一个子句中） --1.主动归结次数最少，2.文字稳定度最大  */

    /************************************************************************/
    inline static bool ActlitCmpTwo( Literal* litA,  Literal* litB){
        /*-1, "无(以同子句中输入文字顺序为准)"
        0, "A_TS(主动归结次数最少>文字稳定度)"
        1, "A_ST(文字稳定度>主动归结次数最少)"*/
        if (litA->uActive == litB->uActive)
            return 1 == TermSteadyCmp(litA->subTerm, litB->subTerm, 0);
        return litA->uActive < litB->uActive;
    }
    inline static bool ActlitCmp( Literal* litA,  Literal* litB) {
        /*-1, "无(以同子句中输入文字顺序为准)"
        0, "A_TS(主动归结次数最少>文字稳定度)"
        1, "A_ST(文字稳定度>主动归结次数最少)"*/
        /*
        switch (StrategyParam::SEL_ACTLIT_STRATEGY) {
            case -1:
                return true;
            case 0:
                if (litA->uActive == litB->uActive)
                    return 1 == TermSteadyCmp(litA->subTerm, litB->subTerm, StrategyParam::SEL_ACTLIT_STEADY);
                return litA->uActive < litB->uActive;
            case 1:
                int iCmpLitSteady = TermSteadyCmp(litA->subTerm, litB->subTerm, StrategyParam::SEL_ACTLIT_STEADY);
                if (iCmpLitSteady == 0)
                    return litA->uActive < litB->uActive;
                return iCmpLitSteady == 1;
        }
        return true;
        */
       //20170224候选子句文字策略
       //0:归结次数>稳定度 1:无(由原始顺序为准) 2:稳定度>归结次数
        switch (StrategyParam::candLiteral) {
            case 0:
                if (litA->sDuct == litB->sDuct) {
                    if (litA->subTerm->fSteadyValue == litB->subTerm->fSteadyValue) {
                        return litA->RelationValue() < litB->RelationValue();
                    } else {
                        switch (StrategyParam::candLiteralSteady)//0:由低到高 1:无(由输入顺序为准) 2:由高到低
                        {
                            case 0:
                                return litA->subTerm->fSteadyValue < litB->subTerm->fSteadyValue;
                            case 1:
                                return true;
                            case 2:
                                return litA->subTerm->fSteadyValue > litB->subTerm->fSteadyValue;
                        }
                    }
                } else {
                    switch (StrategyParam::candLiteralDeductTimes)//0:由低到高 1:无(由输入顺序为准) 2:由高到低
                    {
                        case 0:
                            return litA->sDuct < litB->sDuct;
                        case 1:
                            return true;
                        case 2:
                            return litA->sDuct > litB->sDuct;
                    }
                }
            case 1:
                return true;
            case 2:
                if (litA->subTerm->fSteadyValue == litB->subTerm->fSteadyValue) {
                    if (litA->sDuct == litB->sDuct) {
                        return litA->RelationValue() < litB->RelationValue();
                    } else {
                        switch (StrategyParam::candLiteralDeductTimes)//0:由低到高 1:无(由输入顺序为准) 2:由高到低
                        {
                            case 0:
                                return litA->sDuct < litB->sDuct;
                            case 1:
                                return true;
                            case 2:
                                return litA->sDuct > litB->sDuct;
                        }

                    }
                } else {
                    switch (StrategyParam::candLiteralSteady)//0:由低到高 1:无(由输入顺序为准) 2:由高到低
                    {
                        case 0:
                            return litA->subTerm->fSteadyValue < litB->subTerm->fSteadyValue;
                        case 1:
                            return true;
                        case 2:
                            return litA->subTerm->fSteadyValue > litB->subTerm->fSteadyValue;
                    }
                }
        }
        return true;
    }
    /*********************************/
    //对角线单元子句文字排序规则

    static bool claSingCmp(const Literal*litA, const Literal*litB) {
        //srand(unsigned(time(NULL)));
        /*
        Clause* c1 = litA->claPtr;
        Clause* c2 = litB->claPtr;
        if (c1->adeductNum == c2->adeductNum) {
            if (c1->MaxVarId() == c2->MaxVarId()) {
                if (c1->uFuncDepth == c2->uFuncDepth)
                    //return int(rand()) % 2 != int(rand()) % 2; //20170108  100
                    return c1->uClaId < c2->uClaId;
                return c1->uFuncDepth < c2->uFuncDepth;
            }
            return c1->MaxVarId() < c2->MaxVarId();
        }
        return c1->adeductNum < c2->adeductNum;
        */
        //20170220
        Clause* c1 = litA->claPtr;
        Clause* c2 = litB->claPtr;
        switch (StrategyParam::unitChoose) {
            case 0://0:归结次数>冗余次数>稳定度>函数嵌套层
                if (c1->adeductNum == c2->adeductNum) {
                    if (c1->reduntTimes == c2->reduntTimes) {
                        if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                            if (c1->uFuncDepth == c2->uFuncDepth) {
                                return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                            } else {
                                switch (StrategyParam::unitFuncLayer) {
                                    case 0://0:由高到低
                                        return c1->uFuncDepth > c2->uFuncDepth;
                                    case 1://无(由输入顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->uFuncDepth < c2->uFuncDepth;
                                }
                            }
                        } else {
                            switch (StrategyParam::unitSteady) {
                                case 0://0:由高到低
                                    return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                case 1://1:无(由原始顺序为准)
                                    return true;
                                case 2://2:由低到高
                                    return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                            }
                        }
                    } else {
                        switch (StrategyParam::unitRedunt) {
                            case 0://0:由低到高
                                return c1->reduntTimes < c2->reduntTimes;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->reduntTimes > c2->reduntTimes;
                        }
                    }
                } else {
                    switch (StrategyParam::unitDeduct) {
                        case 0://0:由低到高
                            return c1->adeductNum < c2->adeductNum;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->adeductNum > c2->adeductNum;
                    }
                }
            case 1://1:冗余次数>归结次数>稳定度>函数嵌套层
                if (c1->reduntTimes == c2->reduntTimes) {
                    if (c1->adeductNum == c2->adeductNum) {
                        if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                            if (c1->uFuncDepth == c2->uFuncDepth) {
                                return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                            } else {
                                switch (StrategyParam::unitFuncLayer) {
                                    case 0://0:由高到低
                                        return c1->uFuncDepth > c2->uFuncDepth;
                                    case 1://无(由输入顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->uFuncDepth < c2->uFuncDepth;
                                }
                            }
                        } else {
                            switch (StrategyParam::unitSteady) {
                                case 0://0:由高到低
                                    return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                case 1://1:无(由原始顺序为准)
                                    return true;
                                case 2://2:由低到高
                                    return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                            }
                        }
                    } else {
                        switch (StrategyParam::unitDeduct) {
                            case 0://0:由低到高
                                return c1->adeductNum < c2->adeductNum;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->adeductNum > c2->adeductNum;
                        }
                    }
                } else {
                    switch (StrategyParam::unitRedunt) {
                        case 0://0:由低到高
                            return c1->reduntTimes < c2->reduntTimes;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->reduntTimes > c2->reduntTimes;
                    }
                }
            case 2://2:归结次数>冗余次数>函数嵌套层>稳定度
                if (c1->adeductNum == c2->adeductNum) {
                    if (c1->reduntTimes == c2->reduntTimes) {
                        if (c1->uFuncDepth == c2->uFuncDepth) {
                            if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                                return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                            } else {
                                switch (StrategyParam::unitSteady) {
                                    case 0://0:由高到低
                                        return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                    case 1://1:无(由原始顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                                }
                            }
                        } else {
                            switch (StrategyParam::unitFuncLayer) {
                                case 0://0:由高到低
                                    return c1->uFuncDepth > c2->uFuncDepth;
                                case 1://无(由输入顺序为准)
                                    return true;
                                case 2://2:由低到高
                                    return c1->uFuncDepth < c2->uFuncDepth;
                            }
                        }
                    } else {
                        switch (StrategyParam::unitRedunt) {
                            case 0://0:由低到高
                                return c1->reduntTimes < c2->reduntTimes;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->reduntTimes > c2->reduntTimes;
                        }
                    }
                } else {
                    switch (StrategyParam::unitDeduct) {
                        case 0://0:由低到高
                            return c1->adeductNum < c2->adeductNum;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->adeductNum > c2->adeductNum;
                    }
                }
            case 3://3:冗余次数>归结次数>函数嵌套层>稳定度
                if (c1->reduntTimes == c2->reduntTimes) {
                    if (c1->adeductNum == c2->adeductNum) {
                        if (c1->uFuncDepth == c2->uFuncDepth) {
                            if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                                return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                            } else {

                                switch (StrategyParam::unitSteady) {
                                    case 0://0:由高到低
                                        return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                    case 1://1:无(由原始顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                                }
                            }
                        } else {
                            switch (StrategyParam::unitFuncLayer) {
                                case 0://0:由高到低
                                    return c1->uFuncDepth > c2->uFuncDepth;
                                case 1://无(由输入顺序为准)
                                    return true;
                                case 2://2:由低到高
                                    return c1->uFuncDepth < c2->uFuncDepth;
                            }
                        }
                    } else {
                        switch (StrategyParam::unitDeduct) {
                            case 0://0:由低到高
                                return c1->adeductNum < c2->adeductNum;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->adeductNum > c2->adeductNum;
                        }
                    }
                } else {
                    switch (StrategyParam::unitRedunt) {
                        case 0://0:由低到高
                            return c1->reduntTimes < c2->reduntTimes;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->reduntTimes > c2->reduntTimes;
                    }
                }
            case 4://4:无(由原始顺序为准)
                return true;
        }
    }
    //按单元子句文字含互补文字从大到小排序
    static bool claSingCmpPairSizeDec(const Literal*litA, const Literal*litB) {
        //srand(unsigned(time(NULL)));
        /*
        Clause* c1 = litA->claPtr;
        Clause* c2 = litB->claPtr;
        if (c1->adeductNum == c2->adeductNum) {
            if (c1->MaxVarId() == c2->MaxVarId()) {
                if (c1->uFuncDepth == c2->uFuncDepth)
                    //return int(rand()) % 2 != int(rand()) % 2; //20170108  100
                    return c1->uClaId < c2->uClaId;
                return c1->uFuncDepth < c2->uFuncDepth;
            }
            return c1->MaxVarId() < c2->MaxVarId();
        }
        return c1->adeductNum < c2->adeductNum;
        */
        //20170220
        Clause* c1 = litA->claPtr;
        Clause* c2 = litB->claPtr;
        switch (StrategyParam::unitChoose) {
            case 0://0:归结次数>冗余次数>稳定度>函数嵌套层
                if (c1->adeductNum == c2->adeductNum) {
                    if (c1->reduntTimes == c2->reduntTimes) {
                        if (c1->LitPtr[0]->pairLitSize()== c2->LitPtr[0]->pairLitSize()) {
                            if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                                if (c1->uFuncDepth == c2->uFuncDepth) {
                                    return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                                } else {
                                    switch (StrategyParam::unitFuncLayer) {
                                        case 0://0:由高到低
                                            return c1->uFuncDepth > c2->uFuncDepth;
                                        case 1://无(由输入顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return c1->uFuncDepth < c2->uFuncDepth;
                                    }
                                }
                            } else {
                                switch (StrategyParam::unitSteady) {
                                    case 0://0:由高到低
                                        return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                    case 1://1:无(由原始顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                                }
                            }
                        } else {
                            return c1->LitPtr[0]->pairLitSize() > c2->LitPtr[0]->pairLitSize();
                        }
                    } else {
                        switch (StrategyParam::unitRedunt) {
                            case 0://0:由低到高
                                return c1->reduntTimes < c2->reduntTimes;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->reduntTimes > c2->reduntTimes;
                        }
                    }
                } else {
                    switch (StrategyParam::unitDeduct) {
                        case 0://0:由低到高
                            return c1->adeductNum < c2->adeductNum;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->adeductNum > c2->adeductNum;
                    }
                }
            case 1://1:冗余次数>归结次数>稳定度>函数嵌套层
                if (c1->reduntTimes == c2->reduntTimes) {
                    if (c1->adeductNum == c2->adeductNum) {
                        if (c1->LitPtr[0]->pairLitSize() == c2->LitPtr[0]->pairLitSize()) {
                            if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                                if (c1->uFuncDepth == c2->uFuncDepth) {
                                    return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                                } else {
                                    switch (StrategyParam::unitFuncLayer) {
                                        case 0://0:由高到低
                                            return c1->uFuncDepth > c2->uFuncDepth;
                                        case 1://无(由输入顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return c1->uFuncDepth < c2->uFuncDepth;
                                    }
                                }
                            } else {
                                switch (StrategyParam::unitSteady) {
                                    case 0://0:由高到低
                                        return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                    case 1://1:无(由原始顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                                }
                            }
                        } else {
                            return c1->LitPtr[0]->pairLitSize() > c2->LitPtr[0]->pairLitSize();
                        }
                    } else {
                        switch (StrategyParam::unitDeduct) {
                            case 0://0:由低到高
                                return c1->adeductNum < c2->adeductNum;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->adeductNum > c2->adeductNum;
                        }
                    }
                } else {
                    switch (StrategyParam::unitRedunt) {
                        case 0://0:由低到高
                            return c1->reduntTimes < c2->reduntTimes;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->reduntTimes > c2->reduntTimes;
                    }
                }
            case 2://2:归结次数>冗余次数>函数嵌套层>稳定度
                if (c1->adeductNum == c2->adeductNum) {
                    if (c1->reduntTimes == c2->reduntTimes) {
                        if (c1->LitPtr[0]->pairLitSize() == c2->LitPtr[0]->pairLitSize()) {
                            if (c1->uFuncDepth == c2->uFuncDepth) {
                                if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                                    return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                                } else {
                                    switch (StrategyParam::unitSteady) {
                                        case 0://0:由高到低
                                            return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                        case 1://1:无(由原始顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                                    }
                                }
                            } else {
                                switch (StrategyParam::unitFuncLayer) {
                                    case 0://0:由高到低
                                        return c1->uFuncDepth > c2->uFuncDepth;
                                    case 1://无(由输入顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->uFuncDepth < c2->uFuncDepth;
                                }
                            }
                        } else {
                            return c1->LitPtr[0]->pairLitSize() > c2->LitPtr[0]->pairLitSize();
                        }
                    } else {
                        switch (StrategyParam::unitRedunt) {
                            case 0://0:由低到高
                                return c1->reduntTimes < c2->reduntTimes;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->reduntTimes > c2->reduntTimes;
                        }
                    }
                } else {
                    switch (StrategyParam::unitDeduct) {
                        case 0://0:由低到高
                            return c1->adeductNum < c2->adeductNum;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->adeductNum > c2->adeductNum;
                    }
                }
            case 3://3:冗余次数>归结次数>函数嵌套层>稳定度
                if (c1->reduntTimes == c2->reduntTimes) {
                    if (c1->adeductNum == c2->adeductNum) {
                        if (c1->LitPtr[0]->pairLitSize() == c2->LitPtr[0]->pairLitSize()) {
                            if (c1->uFuncDepth == c2->uFuncDepth) {
                                if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                                    return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                                } else {

                                    switch (StrategyParam::unitSteady) {
                                        case 0://0:由高到低
                                            return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                        case 1://1:无(由原始顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                                    }
                                }
                            } else {
                                switch (StrategyParam::unitFuncLayer) {
                                    case 0://0:由高到低
                                        return c1->uFuncDepth > c2->uFuncDepth;
                                    case 1://无(由输入顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->uFuncDepth < c2->uFuncDepth;
                                }
                            }
                        } else {
                            return c1->LitPtr[0]->pairLitSize() > c2->LitPtr[0]->pairLitSize();
                        }
                    } else {
                        switch (StrategyParam::unitDeduct) {
                            case 0://0:由低到高
                                return c1->adeductNum < c2->adeductNum;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->adeductNum > c2->adeductNum;
                        }
                    }
                } else {
                    switch (StrategyParam::unitRedunt) {
                        case 0://0:由低到高
                            return c1->reduntTimes < c2->reduntTimes;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->reduntTimes > c2->reduntTimes;
                    }
                }
            case 4://4:无(由原始顺序为准)
                return true;
        }
    }
    //按单元子句含变元个数从小到大
    static bool claSingCmpVarSzie(const Literal*litA, const Literal*litB) {
        
        //20170220
        Clause* c1 = litA->claPtr;
        Clause* c2 = litB->claPtr;
        switch (StrategyParam::unitChoose) {
            case 0://0:归结次数>冗余次数>稳定度>函数嵌套层
                if (c1->adeductNum == c2->adeductNum) {
                    if (c1->reduntTimes == c2->reduntTimes) {
                        if (c1->uVarCount== c2->uVarCount) {
                            if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                                if (c1->uFuncDepth == c2->uFuncDepth) {
                                    return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                                } else {
                                    switch (StrategyParam::unitFuncLayer) {
                                        case 0://0:由高到低
                                            return c1->uFuncDepth > c2->uFuncDepth;
                                        case 1://无(由输入顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return c1->uFuncDepth < c2->uFuncDepth;
                                    }
                                }
                            } else {
                                switch (StrategyParam::unitSteady) {
                                    case 0://0:由高到低
                                        return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                    case 1://1:无(由原始顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                                }
                            }
                        } else {
                            return c1->uVarCount < c2->uVarCount;
                        }
                    } else {
                        switch (StrategyParam::unitRedunt) {
                            case 0://0:由低到高
                                return c1->reduntTimes < c2->reduntTimes;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->reduntTimes > c2->reduntTimes;
                        }
                    }
                } else {
                    switch (StrategyParam::unitDeduct) {
                        case 0://0:由低到高
                            return c1->adeductNum < c2->adeductNum;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->adeductNum > c2->adeductNum;
                    }
                }
            case 1://1:冗余次数>归结次数>稳定度>函数嵌套层
                if (c1->reduntTimes == c2->reduntTimes) {
                    if (c1->adeductNum == c2->adeductNum) {
                        if (c1->uVarCount == c2->uVarCount) {
                            if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                                if (c1->uFuncDepth == c2->uFuncDepth) {
                                    return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                                } else {
                                    switch (StrategyParam::unitFuncLayer) {
                                        case 0://0:由高到低
                                            return c1->uFuncDepth > c2->uFuncDepth;
                                        case 1://无(由输入顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return c1->uFuncDepth < c2->uFuncDepth;
                                    }
                                }
                            } else {
                                switch (StrategyParam::unitSteady) {
                                    case 0://0:由高到低
                                        return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                    case 1://1:无(由原始顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                                }
                            }
                        } else {
                            return c1->uVarCount < c2->uVarCount;
                        }
                    } else {
                        switch (StrategyParam::unitDeduct) {
                            case 0://0:由低到高
                                return c1->adeductNum < c2->adeductNum;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->adeductNum > c2->adeductNum;
                        }
                    }
                } else {
                    switch (StrategyParam::unitRedunt) {
                        case 0://0:由低到高
                            return c1->reduntTimes < c2->reduntTimes;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->reduntTimes > c2->reduntTimes;
                    }
                }
            case 2://2:归结次数>冗余次数>函数嵌套层>稳定度
                if (c1->adeductNum == c2->adeductNum) {
                    if (c1->reduntTimes == c2->reduntTimes) {
                        if (c1->uVarCount == c2->uVarCount) {
                            if (c1->uFuncDepth == c2->uFuncDepth) {
                                if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                                    return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                                } else {
                                    switch (StrategyParam::unitSteady) {
                                        case 0://0:由高到低
                                            return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                        case 1://1:无(由原始顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                                    }
                                }
                            } else {
                                switch (StrategyParam::unitFuncLayer) {
                                    case 0://0:由高到低
                                        return c1->uFuncDepth > c2->uFuncDepth;
                                    case 1://无(由输入顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->uFuncDepth < c2->uFuncDepth;
                                }
                            }
                        } else {
                            return c1->uVarCount < c2->uVarCount;
                        }
                    } else {
                        switch (StrategyParam::unitRedunt) {
                            case 0://0:由低到高
                                return c1->reduntTimes < c2->reduntTimes;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->reduntTimes > c2->reduntTimes;
                        }
                    }
                } else {
                    switch (StrategyParam::unitDeduct) {
                        case 0://0:由低到高
                            return c1->adeductNum < c2->adeductNum;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->adeductNum > c2->adeductNum;
                    }
                }
            case 3://3:冗余次数>归结次数>函数嵌套层>稳定度
                if (c1->reduntTimes == c2->reduntTimes) {
                    if (c1->adeductNum == c2->adeductNum) {
                        if (c1->uVarCount == c2->uVarCount) {
                            if (c1->uFuncDepth == c2->uFuncDepth) {
                                if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                                    return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                                } else {

                                    switch (StrategyParam::unitSteady) {
                                        case 0://0:由高到低
                                            return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                        case 1://1:无(由原始顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                                    }
                                }
                            } else {
                                switch (StrategyParam::unitFuncLayer) {
                                    case 0://0:由高到低
                                        return c1->uFuncDepth > c2->uFuncDepth;
                                    case 1://无(由输入顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->uFuncDepth < c2->uFuncDepth;
                                }
                            }
                        } else {
                            return c1->uVarCount < c2->uVarCount;
                        }
                    } else {
                        switch (StrategyParam::unitDeduct) {
                            case 0://0:由低到高
                                return c1->adeductNum < c2->adeductNum;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->adeductNum > c2->adeductNum;
                        }
                    }
                } else {
                    switch (StrategyParam::unitRedunt) {
                        case 0://0:由低到高
                            return c1->reduntTimes < c2->reduntTimes;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->reduntTimes > c2->reduntTimes;
                    }
                }
            case 4://4:无(由原始顺序为准)
                return true;
        }
    }
    //归结式优先
    static bool claSingCmpGenCla(const Literal*litA, const Literal*litB) {
        
        //20170220
        Clause* c1 = litA->claPtr;
        Clause* c2 = litB->claPtr;
        switch (StrategyParam::unitChoose) {
            case 0://0:归结次数>冗余次数>稳定度>函数嵌套层
                if (c1->adeductNum == c2->adeductNum) {
                    if (c1->reduntTimes == c2->reduntTimes) {
                        return c1->uClaId > c2->uClaId;
                    } else {
                        switch (StrategyParam::unitRedunt) {
                            case 0://0:由低到高
                                return c1->reduntTimes < c2->reduntTimes;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->reduntTimes > c2->reduntTimes;
                        }
                    }
                } else {
                    switch (StrategyParam::unitDeduct) {
                        case 0://0:由低到高
                            return c1->adeductNum < c2->adeductNum;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->adeductNum > c2->adeductNum;
                    }
                }
            case 1://1:冗余次数>归结次数>稳定度>函数嵌套层
                if (c1->reduntTimes == c2->reduntTimes) {
                    if (c1->adeductNum == c2->adeductNum) {
                        return c1->uClaId > c2->uClaId;
                    } else {
                        switch (StrategyParam::unitDeduct) {
                            case 0://0:由低到高
                                return c1->adeductNum < c2->adeductNum;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->adeductNum > c2->adeductNum;
                        }
                    }
                } else {
                    switch (StrategyParam::unitRedunt) {
                        case 0://0:由低到高
                            return c1->reduntTimes < c2->reduntTimes;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->reduntTimes > c2->reduntTimes;
                    }
                }
            case 2://2:归结次数>冗余次数>函数嵌套层>稳定度
                if (c1->adeductNum == c2->adeductNum) {
                    if (c1->reduntTimes == c2->reduntTimes) {
                         return c1->uClaId > c2->uClaId;            
                    } else {
                        switch (StrategyParam::unitRedunt) {
                            case 0://0:由低到高
                                return c1->reduntTimes < c2->reduntTimes;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->reduntTimes > c2->reduntTimes;
                        }
                    }
                } else {
                    switch (StrategyParam::unitDeduct) {
                        case 0://0:由低到高
                            return c1->adeductNum < c2->adeductNum;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->adeductNum > c2->adeductNum;
                    }
                }
            case 3://3:冗余次数>归结次数>函数嵌套层>稳定度
                if (c1->reduntTimes == c2->reduntTimes) {
                    if (c1->adeductNum == c2->adeductNum) {
                        return c1->uClaId > c2->uClaId;
                    } else {
                        switch (StrategyParam::unitDeduct) {
                            case 0://0:由低到高
                                return c1->adeductNum < c2->adeductNum;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->adeductNum > c2->adeductNum;
                        }
                    }
                } else {
                    switch (StrategyParam::unitRedunt) {
                        case 0://0:由低到高
                            return c1->reduntTimes < c2->reduntTimes;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->reduntTimes > c2->reduntTimes;
                    }
                }
            case 4://4:无(由原始顺序为准)
                return true;
        }
    }
    //按单元子句含变元个数从大到小
    static bool claSingCmpVarSzieDec(const Literal*litA, const Literal*litB) {
        
        //20170220
        Clause* c1 = litA->claPtr;
        Clause* c2 = litB->claPtr;
        switch (StrategyParam::unitChoose) {
            case 0://0:归结次数>冗余次数>稳定度>函数嵌套层
                if (c1->adeductNum == c2->adeductNum) {
                    if (c1->reduntTimes == c2->reduntTimes) {
                        if (c1->uVarCount== c2->uVarCount) {
                            if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                                if (c1->uFuncDepth == c2->uFuncDepth) {
                                    return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                                } else {
                                    switch (StrategyParam::unitFuncLayer) {
                                        case 0://0:由高到低
                                            return c1->uFuncDepth > c2->uFuncDepth;
                                        case 1://无(由输入顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return c1->uFuncDepth < c2->uFuncDepth;
                                    }
                                }
                            } else {
                                switch (StrategyParam::unitSteady) {
                                    case 0://0:由高到低
                                        return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                    case 1://1:无(由原始顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                                }
                            }
                        } else {
                            return c1->uVarCount > c2->uVarCount;
                        }
                    } else {
                        switch (StrategyParam::unitRedunt) {
                            case 0://0:由低到高
                                return c1->reduntTimes < c2->reduntTimes;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->reduntTimes > c2->reduntTimes;
                        }
                    }
                } else {
                    switch (StrategyParam::unitDeduct) {
                        case 0://0:由低到高
                            return c1->adeductNum < c2->adeductNum;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->adeductNum > c2->adeductNum;
                    }
                }
            case 1://1:冗余次数>归结次数>稳定度>函数嵌套层
                if (c1->reduntTimes == c2->reduntTimes) {
                    if (c1->adeductNum == c2->adeductNum) {
                        if (c1->uVarCount == c2->uVarCount) {
                            if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                                if (c1->uFuncDepth == c2->uFuncDepth) {
                                    return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                                } else {
                                    switch (StrategyParam::unitFuncLayer) {
                                        case 0://0:由高到低
                                            return c1->uFuncDepth > c2->uFuncDepth;
                                        case 1://无(由输入顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return c1->uFuncDepth < c2->uFuncDepth;
                                    }
                                }
                            } else {
                                switch (StrategyParam::unitSteady) {
                                    case 0://0:由高到低
                                        return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                    case 1://1:无(由原始顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                                }
                            }
                        } else {
                            return c1->uVarCount > c2->uVarCount;
                        }
                    } else {
                        switch (StrategyParam::unitDeduct) {
                            case 0://0:由低到高
                                return c1->adeductNum < c2->adeductNum;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->adeductNum > c2->adeductNum;
                        }
                    }
                } else {
                    switch (StrategyParam::unitRedunt) {
                        case 0://0:由低到高
                            return c1->reduntTimes < c2->reduntTimes;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->reduntTimes > c2->reduntTimes;
                    }
                }
            case 2://2:归结次数>冗余次数>函数嵌套层>稳定度
                if (c1->adeductNum == c2->adeductNum) {
                    if (c1->reduntTimes == c2->reduntTimes) {
                        if (c1->uVarCount == c2->uVarCount) {
                            if (c1->uFuncDepth == c2->uFuncDepth) {
                                if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                                    return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                                } else {
                                    switch (StrategyParam::unitSteady) {
                                        case 0://0:由高到低
                                            return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                        case 1://1:无(由原始顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                                    }
                                }
                            } else {
                                switch (StrategyParam::unitFuncLayer) {
                                    case 0://0:由高到低
                                        return c1->uFuncDepth > c2->uFuncDepth;
                                    case 1://无(由输入顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->uFuncDepth < c2->uFuncDepth;
                                }
                            }
                        } else {
                            return c1->uVarCount > c2->uVarCount;
                        }
                    } else {
                        switch (StrategyParam::unitRedunt) {
                            case 0://0:由低到高
                                return c1->reduntTimes < c2->reduntTimes;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->reduntTimes > c2->reduntTimes;
                        }
                    }
                } else {
                    switch (StrategyParam::unitDeduct) {
                        case 0://0:由低到高
                            return c1->adeductNum < c2->adeductNum;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->adeductNum > c2->adeductNum;
                    }
                }
            case 3://3:冗余次数>归结次数>函数嵌套层>稳定度
                if (c1->reduntTimes == c2->reduntTimes) {
                    if (c1->adeductNum == c2->adeductNum) {
                        if (c1->uVarCount == c2->uVarCount) {
                            if (c1->uFuncDepth == c2->uFuncDepth) {
                                if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                                    return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                                } else {

                                    switch (StrategyParam::unitSteady) {
                                        case 0://0:由高到低
                                            return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                        case 1://1:无(由原始顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                                    }
                                }
                            } else {
                                switch (StrategyParam::unitFuncLayer) {
                                    case 0://0:由高到低
                                        return c1->uFuncDepth > c2->uFuncDepth;
                                    case 1://无(由输入顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->uFuncDepth < c2->uFuncDepth;
                                }
                            }
                        } else {
                            return c1->uVarCount > c2->uVarCount;
                        }
                    } else {
                        switch (StrategyParam::unitDeduct) {
                            case 0://0:由低到高
                                return c1->adeductNum < c2->adeductNum;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->adeductNum > c2->adeductNum;
                        }
                    }
                } else {
                    switch (StrategyParam::unitRedunt) {
                        case 0://0:由低到高
                            return c1->reduntTimes < c2->reduntTimes;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->reduntTimes > c2->reduntTimes;
                    }
                }
            case 4://4:无(由原始顺序为准)
                return true;
        }
    }
    //按单元子句文字含互补文字大小排序
    static bool claSingCmpPairSizeInc(const Literal*litA, const Literal*litB) {
        //srand(unsigned(time(NULL)));
        /*
        Clause* c1 = litA->claPtr;
        Clause* c2 = litB->claPtr;
        if (c1->adeductNum == c2->adeductNum) {
            if (c1->MaxVarId() == c2->MaxVarId()) {
                if (c1->uFuncDepth == c2->uFuncDepth)
                    //return int(rand()) % 2 != int(rand()) % 2; //20170108  100
                    return c1->uClaId < c2->uClaId;
                return c1->uFuncDepth < c2->uFuncDepth;
            }
            return c1->MaxVarId() < c2->MaxVarId();
        }
        return c1->adeductNum < c2->adeductNum;
        */
        //20170220
        Clause* c1 = litA->claPtr;
        Clause* c2 = litB->claPtr;
        switch (StrategyParam::unitChoose) {
            case 0://0:归结次数>冗余次数>稳定度>函数嵌套层
                if (c1->adeductNum == c2->adeductNum) {
                    if (c1->reduntTimes == c2->reduntTimes) {
                        if (c1->LitPtr[0]->pairLitSize()== c2->LitPtr[0]->pairLitSize()) {
                            if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                                if (c1->uFuncDepth == c2->uFuncDepth) {
                                    return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                                } else {
                                    switch (StrategyParam::unitFuncLayer) {
                                        case 0://0:由高到低
                                            return c1->uFuncDepth > c2->uFuncDepth;
                                        case 1://无(由输入顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return c1->uFuncDepth < c2->uFuncDepth;
                                    }
                                }
                            } else {
                                switch (StrategyParam::unitSteady) {
                                    case 0://0:由高到低
                                        return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                    case 1://1:无(由原始顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                                }
                            }
                        } else {
                            return c1->LitPtr[0]->pairLitSize() < c2->LitPtr[0]->pairLitSize();
                        }
                    } else {
                        switch (StrategyParam::unitRedunt) {
                            case 0://0:由低到高
                                return c1->reduntTimes < c2->reduntTimes;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->reduntTimes > c2->reduntTimes;
                        }
                    }
                } else {
                    switch (StrategyParam::unitDeduct) {
                        case 0://0:由低到高
                            return c1->adeductNum < c2->adeductNum;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->adeductNum > c2->adeductNum;
                    }
                }
            case 1://1:冗余次数>归结次数>稳定度>函数嵌套层
                if (c1->reduntTimes == c2->reduntTimes) {
                    if (c1->adeductNum == c2->adeductNum) {
                        if (c1->LitPtr[0]->pairLitSize() == c2->LitPtr[0]->pairLitSize()) {
                            if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                                if (c1->uFuncDepth == c2->uFuncDepth) {
                                    return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                                } else {
                                    switch (StrategyParam::unitFuncLayer) {
                                        case 0://0:由高到低
                                            return c1->uFuncDepth > c2->uFuncDepth;
                                        case 1://无(由输入顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return c1->uFuncDepth < c2->uFuncDepth;
                                    }
                                }
                            } else {
                                switch (StrategyParam::unitSteady) {
                                    case 0://0:由高到低
                                        return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                    case 1://1:无(由原始顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                                }
                            }
                        } else {
                            return c1->LitPtr[0]->pairLitSize() < c2->LitPtr[0]->pairLitSize();
                        }
                    } else {
                        switch (StrategyParam::unitDeduct) {
                            case 0://0:由低到高
                                return c1->adeductNum < c2->adeductNum;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->adeductNum > c2->adeductNum;
                        }
                    }
                } else {
                    switch (StrategyParam::unitRedunt) {
                        case 0://0:由低到高
                            return c1->reduntTimes < c2->reduntTimes;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->reduntTimes > c2->reduntTimes;
                    }
                }
            case 2://2:归结次数>冗余次数>函数嵌套层>稳定度
                if (c1->adeductNum == c2->adeductNum) {
                    if (c1->reduntTimes == c2->reduntTimes) {
                        if (c1->LitPtr[0]->pairLitSize() == c2->LitPtr[0]->pairLitSize()) {
                            if (c1->uFuncDepth == c2->uFuncDepth) {
                                if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                                    return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                                } else {
                                    switch (StrategyParam::unitSteady) {
                                        case 0://0:由高到低
                                            return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                        case 1://1:无(由原始顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                                    }
                                }
                            } else {
                                switch (StrategyParam::unitFuncLayer) {
                                    case 0://0:由高到低
                                        return c1->uFuncDepth > c2->uFuncDepth;
                                    case 1://无(由输入顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->uFuncDepth < c2->uFuncDepth;
                                }
                            }
                        } else {
                            return c1->LitPtr[0]->pairLitSize() < c2->LitPtr[0]->pairLitSize();
                        }
                    } else {
                        switch (StrategyParam::unitRedunt) {
                            case 0://0:由低到高
                                return c1->reduntTimes < c2->reduntTimes;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->reduntTimes > c2->reduntTimes;
                        }
                    }
                } else {
                    switch (StrategyParam::unitDeduct) {
                        case 0://0:由低到高
                            return c1->adeductNum < c2->adeductNum;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->adeductNum > c2->adeductNum;
                    }
                }
            case 3://3:冗余次数>归结次数>函数嵌套层>稳定度
                if (c1->reduntTimes == c2->reduntTimes) {
                    if (c1->adeductNum == c2->adeductNum) {
                        if (c1->LitPtr[0]->pairLitSize() == c2->LitPtr[0]->pairLitSize()) {
                            if (c1->uFuncDepth == c2->uFuncDepth) {
                                if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                                    return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                                } else {

                                    switch (StrategyParam::unitSteady) {
                                        case 0://0:由高到低
                                            return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                        case 1://1:无(由原始顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                                    }
                                }
                            } else {
                                switch (StrategyParam::unitFuncLayer) {
                                    case 0://0:由高到低
                                        return c1->uFuncDepth > c2->uFuncDepth;
                                    case 1://无(由输入顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->uFuncDepth < c2->uFuncDepth;
                                }
                            }
                        } else {
                            return c1->LitPtr[0]->pairLitSize() < c2->LitPtr[0]->pairLitSize();
                        }
                    } else {
                        switch (StrategyParam::unitDeduct) {
                            case 0://0:由低到高
                                return c1->adeductNum < c2->adeductNum;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->adeductNum > c2->adeductNum;
                        }
                    }
                } else {
                    switch (StrategyParam::unitRedunt) {
                        case 0://0:由低到高
                            return c1->reduntTimes < c2->reduntTimes;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->reduntTimes > c2->reduntTimes;
                    }
                }
            case 4://4:无(由原始顺序为准)
                return true;
        }
    }
    //子句函数复杂度排序,过滤嵌套层和稳定度
    static bool claSingCmpComplex(const Literal*litA, const Literal*litB) {
        //srand(unsigned(time(NULL)));
        /*
        Clause* c1 = litA->claPtr;
        Clause* c2 = litB->claPtr;
        if (c1->adeductNum == c2->adeductNum) {
            if (c1->MaxVarId() == c2->MaxVarId()) {
                if (c1->uFuncDepth == c2->uFuncDepth)
                    //return int(rand()) % 2 != int(rand()) % 2; //20170108  100
                    return c1->uClaId < c2->uClaId;
                return c1->uFuncDepth < c2->uFuncDepth;
            }
            return c1->MaxVarId() < c2->MaxVarId();
        }
        return c1->adeductNum < c2->adeductNum;
        */
        //20170220
        Clause* c1 = litA->claPtr;
        Clause* c2 = litB->claPtr;
        switch (StrategyParam::unitChoose) {
            case 0://0:归结次数>冗余次数>稳定度>函数嵌套层
                if (c1->adeductNum == c2->adeductNum) {
                    if (c1->reduntTimes == c2->reduntTimes) {
                        if (c1->compFuncDeepthCla() == c2->compFuncDeepthCla()) {
                            if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                                if (c1->uFuncDepth == c2->uFuncDepth) {
                                    return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                                } else {
                                    switch (StrategyParam::unitFuncLayer) {
                                        case 0://0:由高到低
                                            return c1->uFuncDepth > c2->uFuncDepth;
                                        case 1://无(由输入顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return c1->uFuncDepth < c2->uFuncDepth;
                                    }
                                }
                            } else {
                                switch (StrategyParam::unitSteady) {
                                    case 0://0:由高到低
                                        return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                    case 1://1:无(由原始顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                                }
                            }
                        } else {
                            return c1->compFuncDeepthCla() < c2->compFuncDeepthCla();
                        }
                    } else {
                        switch (StrategyParam::unitRedunt) {
                            case 0://0:由低到高
                                return c1->reduntTimes < c2->reduntTimes;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->reduntTimes > c2->reduntTimes;
                        }
                    }
                } else {
                    switch (StrategyParam::unitDeduct) {
                        case 0://0:由低到高
                            return c1->adeductNum < c2->adeductNum;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->adeductNum > c2->adeductNum;
                    }
                }
            case 1://1:冗余次数>归结次数>稳定度>函数嵌套层
                if (c1->reduntTimes == c2->reduntTimes) {
                    if (c1->adeductNum == c2->adeductNum) {
                        if (c1->compFuncDeepthCla() == c2->compFuncDeepthCla()) {
                            if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                                if (c1->uFuncDepth == c2->uFuncDepth) {
                                    return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                                } else {
                                    switch (StrategyParam::unitFuncLayer) {
                                        case 0://0:由高到低
                                            return c1->uFuncDepth > c2->uFuncDepth;
                                        case 1://无(由输入顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return c1->uFuncDepth < c2->uFuncDepth;
                                    }
                                }
                            } else {
                                switch (StrategyParam::unitSteady) {
                                    case 0://0:由高到低
                                        return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                    case 1://1:无(由原始顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                                }
                            }
                        } else {
                            return c1->compFuncDeepthCla() < c2->compFuncDeepthCla();
                        }
                    } else {
                        switch (StrategyParam::unitDeduct) {
                            case 0://0:由低到高
                                return c1->adeductNum < c2->adeductNum;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->adeductNum > c2->adeductNum;
                        }
                    }
                } else {
                    switch (StrategyParam::unitRedunt) {
                        case 0://0:由低到高
                            return c1->reduntTimes < c2->reduntTimes;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->reduntTimes > c2->reduntTimes;
                    }
                }
            case 2://2:归结次数>冗余次数>函数嵌套层>稳定度
                if (c1->adeductNum == c2->adeductNum) {
                    if (c1->reduntTimes == c2->reduntTimes) {
                        if (c1->compFuncDeepthCla() == c2->compFuncDeepthCla()) {
                            if (c1->uFuncDepth == c2->uFuncDepth) {
                                if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                                    return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                                } else {
                                    switch (StrategyParam::unitSteady) {
                                        case 0://0:由高到低
                                            return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                        case 1://1:无(由原始顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                                    }
                                }
                            } else {
                                switch (StrategyParam::unitFuncLayer) {
                                    case 0://0:由高到低
                                        return c1->uFuncDepth > c2->uFuncDepth;
                                    case 1://无(由输入顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->uFuncDepth < c2->uFuncDepth;
                                }
                            }
                        } else {
                            return c1->compFuncDeepthCla() < c2->compFuncDeepthCla();
                        }
                    } else {
                        switch (StrategyParam::unitRedunt) {
                            case 0://0:由低到高
                                return c1->reduntTimes < c2->reduntTimes;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->reduntTimes > c2->reduntTimes;
                        }
                    }
                } else {
                    switch (StrategyParam::unitDeduct) {
                        case 0://0:由低到高
                            return c1->adeductNum < c2->adeductNum;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->adeductNum > c2->adeductNum;
                    }
                }
            case 3://3:冗余次数>归结次数>函数嵌套层>稳定度
                if (c1->reduntTimes == c2->reduntTimes) {
                    if (c1->adeductNum == c2->adeductNum) {
                        if (c1->compFuncDeepthCla() == c2->compFuncDeepthCla()) {
                            if (c1->uFuncDepth == c2->uFuncDepth) {
                                if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                                    return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                                } else {

                                    switch (StrategyParam::unitSteady) {
                                        case 0://0:由高到低
                                            return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                        case 1://1:无(由原始顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                                    }
                                }
                            } else {
                                switch (StrategyParam::unitFuncLayer) {
                                    case 0://0:由高到低
                                        return c1->uFuncDepth > c2->uFuncDepth;
                                    case 1://无(由输入顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->uFuncDepth < c2->uFuncDepth;
                                }
                            }
                        } else {
                            return c1->compFuncDeepthCla() < c2->compFuncDeepthCla();
                        }
                    } else {
                        switch (StrategyParam::unitDeduct) {
                            case 0://0:由低到高
                                return c1->adeductNum < c2->adeductNum;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->adeductNum > c2->adeductNum;
                        }
                    }
                } else {
                    switch (StrategyParam::unitRedunt) {
                        case 0://0:由低到高
                            return c1->reduntTimes < c2->reduntTimes;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->reduntTimes > c2->reduntTimes;
                    }
                }
            case 4://4:无(由原始顺序为准)
                return true;
        }
    }
    
    //目标子句排序,过滤嵌套层和稳定度
    static bool claSingCmpGoal(const Literal*litA, const Literal*litB) {
        //srand(unsigned(time(NULL)));
        /*
        Clause* c1 = litA->claPtr;
        Clause* c2 = litB->claPtr;
        if (c1->adeductNum == c2->adeductNum) {
            if (c1->MaxVarId() == c2->MaxVarId()) {
                if (c1->uFuncDepth == c2->uFuncDepth)
                    //return int(rand()) % 2 != int(rand()) % 2; //20170108  100
                    return c1->uClaId < c2->uClaId;
                return c1->uFuncDepth < c2->uFuncDepth;
            }
            return c1->MaxVarId() < c2->MaxVarId();
        }
        return c1->adeductNum < c2->adeductNum;
        */
        //20170220
        Clause* c1 = litA->claPtr;
        Clause* c2 = litB->claPtr;
        switch (StrategyParam::unitChoose) {
            case 0://0:归结次数>冗余次数>稳定度>函数嵌套层
                if (c1->adeductNum == c2->adeductNum) {
                    if (c1->reduntTimes == c2->reduntTimes) {
                        if (c1->LitPtr[0]->IsNeLit() == c2->LitPtr[0]->IsNeLit()) {
                            if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                                if (c1->uFuncDepth == c2->uFuncDepth) {
                                    return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                                } else {
                                    switch (StrategyParam::unitFuncLayer) {
                                        case 0://0:由高到低
                                            return c1->uFuncDepth > c2->uFuncDepth;
                                        case 1://无(由输入顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return c1->uFuncDepth < c2->uFuncDepth;
                                    }
                                }
                            } else {
                                switch (StrategyParam::unitSteady) {
                                    case 0://0:由高到低
                                        return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                    case 1://1:无(由原始顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                                }
                            }
                        } else {
                            return c1->LitPtr[0]->IsNeLit() < c2->LitPtr[0]->IsNeLit();
                        }
                    } else {
                        switch (StrategyParam::unitRedunt) {
                            case 0://0:由低到高
                                return c1->reduntTimes < c2->reduntTimes;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->reduntTimes > c2->reduntTimes;
                        }
                    }
                } else {
                    switch (StrategyParam::unitDeduct) {
                        case 0://0:由低到高
                            return c1->adeductNum < c2->adeductNum;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->adeductNum > c2->adeductNum;
                    }
                }
            case 1://1:冗余次数>归结次数>稳定度>函数嵌套层
                if (c1->reduntTimes == c2->reduntTimes) {
                    if (c1->adeductNum == c2->adeductNum) {
                        if (c1->LitPtr[0]->IsNeLit() == c2->LitPtr[0]->IsNeLit()) {
                            if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                                if (c1->uFuncDepth == c2->uFuncDepth) {
                                    return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                                } else {
                                    switch (StrategyParam::unitFuncLayer) {
                                        case 0://0:由高到低
                                            return c1->uFuncDepth > c2->uFuncDepth;
                                        case 1://无(由输入顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return c1->uFuncDepth < c2->uFuncDepth;
                                    }
                                }
                            } else {
                                switch (StrategyParam::unitSteady) {
                                    case 0://0:由高到低
                                        return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                    case 1://1:无(由原始顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                                }
                            }
                        } else {
                            return c1->LitPtr[0]->IsNeLit() < c2->LitPtr[0]->IsNeLit();
                        }
                    } else {
                        switch (StrategyParam::unitDeduct) {
                            case 0://0:由低到高
                                return c1->adeductNum < c2->adeductNum;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->adeductNum > c2->adeductNum;
                        }
                    }
                } else {
                    switch (StrategyParam::unitRedunt) {
                        case 0://0:由低到高
                            return c1->reduntTimes < c2->reduntTimes;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->reduntTimes > c2->reduntTimes;
                    }
                }
            case 2://2:归结次数>冗余次数>函数嵌套层>稳定度
                if (c1->adeductNum == c2->adeductNum) {
                    if (c1->reduntTimes == c2->reduntTimes) {
                        if (c1->LitPtr[0]->IsNeLit() == c2->LitPtr[0]->IsNeLit()) {
                            if (c1->uFuncDepth == c2->uFuncDepth) {
                                if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                                    return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                                } else {
                                    switch (StrategyParam::unitSteady) {
                                        case 0://0:由高到低
                                            return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                        case 1://1:无(由原始顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                                    }
                                }
                            } else {
                                switch (StrategyParam::unitFuncLayer) {
                                    case 0://0:由高到低
                                        return c1->uFuncDepth > c2->uFuncDepth;
                                    case 1://无(由输入顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->uFuncDepth < c2->uFuncDepth;
                                }
                            }
                        } else {
                            return c1->LitPtr[0]->IsNeLit() < c2->LitPtr[0]->IsNeLit();
                        }
                    } else {
                        switch (StrategyParam::unitRedunt) {
                            case 0://0:由低到高
                                return c1->reduntTimes < c2->reduntTimes;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->reduntTimes > c2->reduntTimes;
                        }
                    }
                } else {
                    switch (StrategyParam::unitDeduct) {
                        case 0://0:由低到高
                            return c1->adeductNum < c2->adeductNum;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->adeductNum > c2->adeductNum;
                    }
                }
            case 3://3:冗余次数>归结次数>函数嵌套层>稳定度
                if (c1->reduntTimes == c2->reduntTimes) {
                    if (c1->adeductNum == c2->adeductNum) {
                        if (c1->LitPtr[0]->IsNeLit() == c2->LitPtr[0]->IsNeLit()) {
                            if (c1->uFuncDepth == c2->uFuncDepth) {
                                if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                                    return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                                } else {

                                    switch (StrategyParam::unitSteady) {
                                        case 0://0:由高到低
                                            return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                        case 1://1:无(由原始顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                                    }
                                }
                            } else {
                                switch (StrategyParam::unitFuncLayer) {
                                    case 0://0:由高到低
                                        return c1->uFuncDepth > c2->uFuncDepth;
                                    case 1://无(由输入顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->uFuncDepth < c2->uFuncDepth;
                                }
                            }
                        } else {
                            return c1->LitPtr[0]->IsNeLit() < c2->LitPtr[0]->IsNeLit();
                        }
                    } else {
                        switch (StrategyParam::unitDeduct) {
                            case 0://0:由低到高
                                return c1->adeductNum < c2->adeductNum;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->adeductNum > c2->adeductNum;
                        }
                    }
                } else {
                    switch (StrategyParam::unitRedunt) {
                        case 0://0:由低到高
                            return c1->reduntTimes < c2->reduntTimes;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->reduntTimes > c2->reduntTimes;
                    }
                }
            case 4://4:无(由原始顺序为准)
                return true;
        }
    }
    
    static bool claSingGenCmp(const Literal*litA, const Literal*litB) {
        Clause* c1 = litA->claPtr;
        Clause* c2 = litB->claPtr;
        switch (StrategyParam::unitChoose) {
            case 0://0:归结次数>冗余次数>稳定度>函数嵌套层
                if (c1->compFuncDeepthCla() == c2->compFuncDeepthCla()) {
                    if (c1->adeductNum == c2->adeductNum) {
                        if (c1->reduntTimes == c2->reduntTimes) {
                            if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                                if (c1->uFuncDepth == c2->uFuncDepth) {
                                    return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                                } else {
                                    switch (StrategyParam::unitFuncLayer) {
                                        case 0://0:由高到低
                                            return c1->uFuncDepth > c2->uFuncDepth;
                                        case 1://无(由输入顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return c1->uFuncDepth < c2->uFuncDepth;
                                    }
                                }
                            } else {
                                switch (StrategyParam::unitSteady) {
                                    case 0://0:由高到低
                                        return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                    case 1://1:无(由原始顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                                }
                            }
                        } else {
                            switch (StrategyParam::unitRedunt) {
                                case 0://0:由低到高
                                    return c1->reduntTimes < c2->reduntTimes;
                                case 1://1:无(由输入顺序为准)
                                    return true;
                                case 2://2:由高到低
                                    return c1->reduntTimes > c2->reduntTimes;
                            }
                        }
                    } else {
                        switch (StrategyParam::unitDeduct) {
                            case 0://0:由低到高
                                return c1->adeductNum < c2->adeductNum;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->adeductNum > c2->adeductNum;
                        }
                    }
                }
                else
                    return c1->compFuncDeepthCla() < c2->compFuncDeepthCla();
                
            case 1://1:冗余次数>归结次数>稳定度>函数嵌套层
                 if(c1->compFuncDeepthCla() == c2->compFuncDeepthCla())
{
                    if (c1->reduntTimes == c2->reduntTimes) {
                        if (c1->adeductNum == c2->adeductNum) {
                            if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                                if (c1->uFuncDepth == c2->uFuncDepth) {
                                    return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                                } else {
                                    switch (StrategyParam::unitFuncLayer) {
                                        case 0://0:由高到低
                                            return c1->uFuncDepth > c2->uFuncDepth;
                                        case 1://无(由输入顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return c1->uFuncDepth < c2->uFuncDepth;
                                    }
                                }
                            } else {
                                switch (StrategyParam::unitSteady) {
                                    case 0://0:由高到低
                                        return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                    case 1://1:无(由原始顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                                }
                            }
                        } else {
                            switch (StrategyParam::unitDeduct) {
                                case 0://0:由低到高
                                    return c1->adeductNum < c2->adeductNum;
                                case 1://1:无(由输入顺序为准)
                                    return true;
                                case 2://2:由高到低
                                    return c1->adeductNum > c2->adeductNum;
                            }
                        }
                    } else {
                        switch (StrategyParam::unitRedunt) {
                            case 0://0:由低到高
                                return c1->reduntTimes < c2->reduntTimes;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->reduntTimes > c2->reduntTimes;
                        }
                    }
                }
                else
                    return c1->compFuncDeepthCla() < c2->compFuncDeepthCla();
               
            case 2://2:归结次数>冗余次数>函数嵌套层>稳定度
                 if (c1->compFuncDeepthCla() == c2->compFuncDeepthCla()) {
                    if (c1->adeductNum == c2->adeductNum) {
                        if (c1->reduntTimes == c2->reduntTimes) {
                            if (c1->uFuncDepth == c2->uFuncDepth) {
                                if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                                    return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                                } else {
                                    switch (StrategyParam::unitSteady) {
                                        case 0://0:由高到低
                                            return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                        case 1://1:无(由原始顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                                    }
                                }
                            } else {
                                switch (StrategyParam::unitFuncLayer) {
                                    case 0://0:由高到低
                                        return c1->uFuncDepth > c2->uFuncDepth;
                                    case 1://无(由输入顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->uFuncDepth < c2->uFuncDepth;
                                }
                            }
                        } else {
                            switch (StrategyParam::unitRedunt) {
                                case 0://0:由低到高
                                    return c1->reduntTimes < c2->reduntTimes;
                                case 1://1:无(由输入顺序为准)
                                    return true;
                                case 2://2:由高到低
                                    return c1->reduntTimes > c2->reduntTimes;
                            }
                        }
                    } else {
                        switch (StrategyParam::unitDeduct) {
                            case 0://0:由低到高
                                return c1->adeductNum < c2->adeductNum;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->adeductNum > c2->adeductNum;
                        }
                    }
                }
                else
                    return c1->compFuncDeepthCla() < c2->compFuncDeepthCla();
                
            case 3://3:冗余次数>归结次数>函数嵌套层>稳定度
                if (c1->compFuncDeepthCla() == c2->compFuncDeepthCla()) {
                    if (c1->reduntTimes == c2->reduntTimes) {
                        if (c1->adeductNum == c2->adeductNum) {
                            if (c1->uFuncDepth == c2->uFuncDepth) {
                                if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                                    return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                                } else {

                                    switch (StrategyParam::unitSteady) {
                                        case 0://0:由高到低
                                            return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                        case 1://1:无(由原始顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                                    }
                                }
                            } else {
                                switch (StrategyParam::unitFuncLayer) {
                                    case 0://0:由高到低
                                        return c1->uFuncDepth > c2->uFuncDepth;
                                    case 1://无(由输入顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->uFuncDepth < c2->uFuncDepth;
                                }
                            }
                        } else {
                            switch (StrategyParam::unitDeduct) {
                                case 0://0:由低到高
                                    return c1->adeductNum < c2->adeductNum;
                                case 1://1:无(由输入顺序为准)
                                    return true;
                                case 2://2:由高到低
                                    return c1->adeductNum > c2->adeductNum;
                            }
                        }
                    } else {
                        switch (StrategyParam::unitRedunt) {
                            case 0://0:由低到高
                                return c1->reduntTimes < c2->reduntTimes;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->reduntTimes > c2->reduntTimes;
                        }
                    }
                }
                else
                    return c1->compFuncDeepthCla() < c2->compFuncDeepthCla();
                
            case 4://4:无(由原始顺序为准)
                return true;
        }
    }
    //目标子句优先
        static bool claSingGenCmpNeg(const Literal*litA, const Literal*litB) {
        Clause* c1 = litA->claPtr;
        Clause* c2 = litB->claPtr;
        switch (StrategyParam::unitChoose) {
            case 0://0:归结次数>冗余次数>稳定度>函数嵌套层
                if (c1->LitPtr[0]->goalDeepth == c2->LitPtr[0]->goalDeepth) {
                    if (c1->adeductNum == c2->adeductNum) {
                        if (c1->reduntTimes == c2->reduntTimes) {
                            if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                                if (c1->uFuncDepth == c2->uFuncDepth) {
                                    return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                                } else {
                                    switch (StrategyParam::unitFuncLayer) {
                                        case 0://0:由高到低
                                            return c1->uFuncDepth > c2->uFuncDepth;
                                        case 1://无(由输入顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return c1->uFuncDepth < c2->uFuncDepth;
                                    }
                                }
                            } else {
                                switch (StrategyParam::unitSteady) {
                                    case 0://0:由高到低
                                        return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                    case 1://1:无(由原始顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                                }
                            }
                        } else {
                            switch (StrategyParam::unitRedunt) {
                                case 0://0:由低到高
                                    return c1->reduntTimes < c2->reduntTimes;
                                case 1://1:无(由输入顺序为准)
                                    return true;
                                case 2://2:由高到低
                                    return c1->reduntTimes > c2->reduntTimes;
                            }
                        }
                    } else {
                        switch (StrategyParam::unitDeduct) {
                            case 0://0:由低到高
                                return c1->adeductNum < c2->adeductNum;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->adeductNum > c2->adeductNum;
                        }
                    }
                }
                else
                    return c1->LitPtr[0]->goalDeepth < c2->LitPtr[0]->goalDeepth;
                
            case 1://1:冗余次数>归结次数>稳定度>函数嵌套层
                 if(c1->LitPtr[0]->goalDeepth == c2->LitPtr[0]->goalDeepth)
{
                    if (c1->reduntTimes == c2->reduntTimes) {
                        if (c1->adeductNum == c2->adeductNum) {
                            if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                                if (c1->uFuncDepth == c2->uFuncDepth) {
                                    return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                                } else {
                                    switch (StrategyParam::unitFuncLayer) {
                                        case 0://0:由高到低
                                            return c1->uFuncDepth > c2->uFuncDepth;
                                        case 1://无(由输入顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return c1->uFuncDepth < c2->uFuncDepth;
                                    }
                                }
                            } else {
                                switch (StrategyParam::unitSteady) {
                                    case 0://0:由高到低
                                        return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                    case 1://1:无(由原始顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                                }
                            }
                        } else {
                            switch (StrategyParam::unitDeduct) {
                                case 0://0:由低到高
                                    return c1->adeductNum < c2->adeductNum;
                                case 1://1:无(由输入顺序为准)
                                    return true;
                                case 2://2:由高到低
                                    return c1->adeductNum > c2->adeductNum;
                            }
                        }
                    } else {
                        switch (StrategyParam::unitRedunt) {
                            case 0://0:由低到高
                                return c1->reduntTimes < c2->reduntTimes;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->reduntTimes > c2->reduntTimes;
                        }
                    }
                }
                else
                    return c1->LitPtr[0]->goalDeepth < c2->LitPtr[0]->goalDeepth;
               
            case 2://2:归结次数>冗余次数>函数嵌套层>稳定度
                 if (c1->LitPtr[0]->goalDeepth == c2->LitPtr[0]->goalDeepth) {
                    if (c1->adeductNum == c2->adeductNum) {
                        if (c1->reduntTimes == c2->reduntTimes) {
                            if (c1->uFuncDepth == c2->uFuncDepth) {
                                if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                                    return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                                } else {
                                    switch (StrategyParam::unitSteady) {
                                        case 0://0:由高到低
                                            return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                        case 1://1:无(由原始顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                                    }
                                }
                            } else {
                                switch (StrategyParam::unitFuncLayer) {
                                    case 0://0:由高到低
                                        return c1->uFuncDepth > c2->uFuncDepth;
                                    case 1://无(由输入顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->uFuncDepth < c2->uFuncDepth;
                                }
                            }
                        } else {
                            switch (StrategyParam::unitRedunt) {
                                case 0://0:由低到高
                                    return c1->reduntTimes < c2->reduntTimes;
                                case 1://1:无(由输入顺序为准)
                                    return true;
                                case 2://2:由高到低
                                    return c1->reduntTimes > c2->reduntTimes;
                            }
                        }
                    } else {
                        switch (StrategyParam::unitDeduct) {
                            case 0://0:由低到高
                                return c1->adeductNum < c2->adeductNum;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->adeductNum > c2->adeductNum;
                        }
                    }
                }
                else
                    return c1->LitPtr[0]->goalDeepth < c2->LitPtr[0]->goalDeepth;
                
            case 3://3:冗余次数>归结次数>函数嵌套层>稳定度
                if (c1->LitPtr[0]->goalDeepth == c2->LitPtr[0]->goalDeepth) {
                    if (c1->reduntTimes == c2->reduntTimes) {
                        if (c1->adeductNum == c2->adeductNum) {
                            if (c1->uFuncDepth == c2->uFuncDepth) {
                                if (c1->LitPtr[0]->subTerm->fSteadyValue == c2->LitPtr[0]->subTerm->fSteadyValue) {
                                    return c1->LitPtr[0]->subTerm->RelationValue() < c2->LitPtr[0]->subTerm->RelationValue();
                                } else {

                                    switch (StrategyParam::unitSteady) {
                                        case 0://0:由高到低
                                            return c1->LitPtr[0]->subTerm->fSteadyValue > c2->LitPtr[0]->subTerm->fSteadyValue;
                                        case 1://1:无(由原始顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return c1->LitPtr[0]->subTerm->fSteadyValue < c2->LitPtr[0]->subTerm->fSteadyValue;
                                    }
                                }
                            } else {
                                switch (StrategyParam::unitFuncLayer) {
                                    case 0://0:由高到低
                                        return c1->uFuncDepth > c2->uFuncDepth;
                                    case 1://无(由输入顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return c1->uFuncDepth < c2->uFuncDepth;
                                }
                            }
                        } else {
                            switch (StrategyParam::unitDeduct) {
                                case 0://0:由低到高
                                    return c1->adeductNum < c2->adeductNum;
                                case 1://1:无(由输入顺序为准)
                                    return true;
                                case 2://2:由高到低
                                    return c1->adeductNum > c2->adeductNum;
                            }
                        }
                    } else {
                        switch (StrategyParam::unitRedunt) {
                            case 0://0:由低到高
                                return c1->reduntTimes < c2->reduntTimes;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->reduntTimes > c2->reduntTimes;
                        }
                    }
                }
                else
                    return c1->LitPtr[0]->goalDeepth < c2->LitPtr[0]->goalDeepth;
                
            case 4://4:无(由原始顺序为准)
                return true;
        }
    }
    //单元子句归结策略
    static int unitDeduct(const Literal*litA, const Literal*litB)
    {
        
    }
    static bool claSingCmpRand(const Literal*litA, const Literal*litB) {
        //srand(unsigned(time(NULL)));
        Clause* c1 = litA->claPtr;
        Clause* c2 = litB->claPtr;
        if (c1->adeductNum == c2->adeductNum) {
            if (c1->MaxVarId() == c2->MaxVarId()) {
                if (c1->uFuncDepth == c2->uFuncDepth)
                    //return int(rand()) % 2 != int(rand()) % 2; //20170108  100
                    return c1->uClaId > c2->uClaId;
                return c1->uFuncDepth < c2->uFuncDepth;
            }
            return c1->MaxVarId() < c2->MaxVarId();
        }
        return c1->adeductNum < c2->adeductNum;
    }
    
    /************************************************************************/
    /*被动归结文字排序（排序的文字在同一个谓词对应的文字列表中）						*/
    static bool PoslitCmpLarge(const Literal*litA, const Literal*litB) {
        //srand(unsigned(time(NULL)));
        UINT16 iClaASize = UINT16(litA->claPtr->uLitNum);//文字个数A
        UINT16 iClaBSize = UINT16(litB->claPtr->uLitNum);//文字个数B
        UINT32 iClaANum = litA->claPtr->pdeductNum;//归结次数A
        UINT32 iClaBNum = litB->claPtr->pdeductNum;//归结次数B
        if(iClaANum == iClaBNum)
            //return int(rand())%2 != int(rand())%2;//20170108  100
            return iClaASize<iClaBSize;
        else
            return iClaANum < iClaBNum;
    }
    
    /*被动归结文字排序（排序的文字在同一个谓词对应的文字列表中）						*/
    static bool PoslitCmpLargeRand(const Literal*litA, const Literal*litB) {
        //srand(unsigned(time(NULL)));
        UINT16 iClaASize = UINT16(litA->claPtr->uLitNum);
        UINT16 iClaBSize = UINT16(litB->claPtr->uLitNum);
        UINT32 iClaANum = litA->claPtr->pdeductNum;
        UINT32 iClaBNum = litB->claPtr->pdeductNum;
        if(iClaANum >10 && iClaBNum>10)
            return int(rand())%2 != int(rand())%2;//20170108  100
        else if( iClaANum >0 || iClaBNum>0)
            return iClaANum<iClaBNum;
        else
            return iClaASize<iClaBSize;
    }
    //20170915 从左到右候选子句排序规则
       /*1.所在子句冗余次数最少;2.被动归结次数B;3.所在子句文字数N少;4.文字稳定度SP最大
    /************************************************************************/
    static bool PoslitCmpLR(const Clause* c1, const Clause* c2) {
        switch (StrategyParam::candChoose) {
            case 0://0:归结次数>冗余次数>文字数>稳定度
                if (c1->uLitNum == c2->uLitNum) {
                    if (c1->pdeductNum== c2->pdeductNum) {
                         if (c1->reduntTimes  == c2->reduntTimes)
                        {
                             return c1->uVarCount < c2->uVarCount;
                        } else {
                            switch (StrategyParam::candRedunt) {
                                case 0://0:由低到高
                                    return c1->reduntTimes < c2->reduntTimes;
                                case 1://1:无(由输入顺序为准)
                                    return true;
                                case 2://2:由高到低
                                    return c1->reduntTimes > c2->reduntTimes;
                            }    
                        }
                    } else {
                        switch (StrategyParam::candDeduct) {
                            case 0://0:由低到高
                                return c1->pdeductNum < c2->pdeductNum;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->pdeductNum > c2->pdeductNum;
                        }
                    }
                } else {
                    return c1->uLitNum < c2->uLitNum;
                }
            case 1://1:冗余次数>归结次数>文字数>稳定度
                if (c1->uLitNum == c2->uLitNum) {
                    if (c1->reduntTimes == c2->reduntTimes) {
                        if (c1->pdeductNum == c2->pdeductNum) {
                            return c1->uVarCount < c2->uVarCount;
                        } else {
                            switch (StrategyParam::candDeduct) {
                                case 0://0:由低到高
                                    return c1->pdeductNum < c2->pdeductNum;
                                case 1://1:无(由输入顺序为准)
                                    return true;
                                case 2://2:由高到低
                                    return c1->pdeductNum > c2->pdeductNum;
                            }
                        }
                    } else {
                        switch (StrategyParam::candRedunt) {
                            case 0://0:由低到高
                                return c1->reduntTimes < c2->reduntTimes;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->reduntTimes > c2->reduntTimes;
                        }
                    }
                } else {
                    return c1->uLitNum < c2->uLitNum;
                }    
            case 2://2:归结次数>冗余次数>稳定度>文字数
                if (c1->uLitNum == c2->uLitNum) {
                    if (c1->pdeductNum== c2->pdeductNum) {
                         if (c1->reduntTimes  == c2->reduntTimes)
                        {
                             return c1->uFuncDepth < c2->uFuncDepth;
                        } else {
                            switch (StrategyParam::candRedunt) {
                                case 0://0:由低到高
                                    return c1->reduntTimes < c2->reduntTimes;
                                case 1://1:无(由输入顺序为准)
                                    return true;
                                case 2://2:由高到低
                                    return c1->reduntTimes > c2->reduntTimes;
                            }    
                        }
                    } else {
                        switch (StrategyParam::candDeduct) {
                            case 0://0:由低到高
                                return c1->pdeductNum < c2->pdeductNum;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->pdeductNum > c2->pdeductNum;
                        }
                    }
                } else {
                    return c1->uLitNum < c2->uLitNum;
                }
            case 3://3:冗余次数>归结次数>稳定度>文字数
              if (c1->uLitNum == c2->uLitNum) {
                    if (c1->reduntTimes == c2->reduntTimes) {
                        if (c1->pdeductNum == c2->pdeductNum) {
                            return c1->uFuncDepth < c2->uFuncDepth;
                        } else {
                            switch (StrategyParam::candDeduct) {
                                case 0://0:由低到高
                                    return c1->pdeductNum < c2->pdeductNum;
                                case 1://1:无(由输入顺序为准)
                                    return true;
                                case 2://2:由高到低
                                    return c1->pdeductNum > c2->pdeductNum;
                            }
                        }
                    } else {
                        switch (StrategyParam::candRedunt) {
                            case 0://0:由低到高
                                return c1->reduntTimes < c2->reduntTimes;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->reduntTimes > c2->reduntTimes;
                        }
                    }
                } else {
                    return c1->uLitNum < c2->uLitNum;
                }    
            case 4://4:无(由原始顺序为准)
                return true;
        }
    }
    /*1.所在子句冗余次数最少;2.被动归结次数B;3.所在子句文字数N少;4.文字稳定度SP最大
    /************************************************************************/
    static bool PoslitCmp(const Literal*litA, const Literal*litB) {
        /*0, "P_NS(子句冗余次数最少>被动归结次数最少>子句文字数>文字稳定度)"*/
        /*1, "P_SN(子句冗余次数最少>被动归结次数最少>文字稳定度>子句文字数)"*/
       /*
        //子句冗余次数
        if (litA->claPtr->Priority != litB->claPtr->Priority)
            return litA->claPtr->Priority > litB->claPtr->Priority;
        //文字被动归结次数
        if (litA->uPassive != litB->uPassive)
            return litA->uPassive < litB->uPassive;
        //文字数和稳定度
        int iLitSteady = TermSteadyCmp(litA->subTerm, litB->subTerm, StrategyParam::SEL_POSLIT_STEADY);
        int iClaASize = int(litA->claPtr->uLitNum);
        int iClaBSize = int(litB->claPtr->uLitNum);
        if (StrategyParam::SEL_POSLIT_STRATEGY == 0) {
            //子句文字数>文字稳定度
            if (iClaASize != iClaBSize) {
                switch (StrategyParam::SEL_POSLIT_NUMLIT) {
                        //-1, "无(以输入顺序为准 0, "文字数由少到多" 1, "文字数由多到少"
                    case -1:return true;
                    case 0: return iClaASize<iClaBSize;
                    case 1: return iClaASize>iClaBSize;
                }
            }
            return 1 == iLitSteady;
        }
        //文字稳定度>子句文字数
        if (iLitSteady == 0) {
            switch (StrategyParam::SEL_POSLIT_NUMLIT) {
                    //-1, "无(以输入顺序为准 0, "文字数由少到多" 1, "文字数由多到少"
                case -1:return true;
                case 0: return iClaASize<iClaBSize;
                case 1: return iClaASize>iClaBSize;
            }
        }
        return 1 == iLitSteady;
        */
         /*0, "P_NS(子句权重最少>被动归结次数最少>子句文字数>文字稳定度)"*/
        /*1, "P_SN(子句权重最少>被动归结次数最少>文字稳定度>子句文字数)"*/
       
        //权重最少
        /*
        if (litA->claPtr->pdeductNum != litB->claPtr->pdeductNum)
            return litA->claPtr->pdeductNum < litB->claPtr->pdeductNum;
        //文字被动归结次数
        //if (litA->uPassive != litB->uPassive)
           // return litA->uPassive < litB->uPassive;
        //文字数和稳定度
        int iLitSteady = TermSteadyCmp(litA->subTerm, litB->subTerm, StrategyParam::SEL_POSLIT_STEADY);
        int iClaASize = int(litA->claPtr->uLitNum);
        int iClaBSize = int(litB->claPtr->uLitNum);
        if (StrategyParam::SEL_POSLIT_STRATEGY == 0) {
            //子句文字数>文字稳定度
            if (iClaASize != iClaBSize) {
                switch (StrategyParam::SEL_POSLIT_NUMLIT) {
                        //-1, "无(以输入顺序为准 0, "文字数由少到多" 1, "文字数由多到少"
                    case -1:return true;
                    case 0: return iClaASize<iClaBSize;
                    case 1: return iClaASize>iClaBSize;
                }
            }
            return 1 == iLitSteady;
        }
        //文字稳定度>子句文字数
        if (iLitSteady == 0) {
            switch (StrategyParam::SEL_POSLIT_NUMLIT) {
                    //-1, "无(以输入顺序为准 0, "文字数由少到多" 1, "文字数由多到少"
                case -1:return true;
                case 0: return iClaASize<iClaBSize;
                case 1: return iClaASize>iClaBSize;
            }
        }
        return 1 == iLitSteady;
        */
        //20170220 候选子句排序策略
        Clause* c1 = litA->claPtr;
        Clause* c2 = litB->claPtr;
        switch (StrategyParam::candChoose) {
            case 0://0:归结次数>冗余次数>文字数>稳定度
                if (litA->sDuct == litB->sDuct) {
                    if (c1->pdeductNum == c2->pdeductNum) {
                        if (c1->reduntTimes == c2->reduntTimes) {
                            if (c1->uLitNum == c2->uLitNum) {
                                if (litA->subTerm->fSteadyValue == litB->subTerm->fSteadyValue) {
                                    return litA->subTerm->RelationValue() < litB->subTerm->RelationValue();
                                } else {
                                    switch (StrategyParam::candSteady) {
                                        case 0://0:由高到低
                                            return litA->subTerm->fSteadyValue > litB->subTerm->fSteadyValue;
                                        case 1://无(由输入顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return litA->subTerm->fSteadyValue < litB->subTerm->fSteadyValue;
                                    }
                                }
                            } else {
                                switch (StrategyParam::candClause) {
                                    case 0://0:由小到大
                                        return c1->uLitNum < c2->uLitNum;
                                    case 1://1:无(由输入顺序为准)
                                        return true;
                                    case 2://2:由大到小
                                        return c1->uLitNum > c2->uLitNum;
                                }
                            }
                        } else {
                            switch (StrategyParam::candRedunt) {
                                case 0://0:由低到高
                                    return c1->reduntTimes < c2->reduntTimes;
                                case 1://1:无(由输入顺序为准)
                                    return true;
                                case 2://2:由高到低
                                    return c1->reduntTimes > c2->reduntTimes;
                            }
                        }
                    } else {
                        switch (StrategyParam::candDeduct) {
                            case 0://0:由低到高
                                return c1->pdeductNum < c2->pdeductNum;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->pdeductNum > c2->pdeductNum;
                        }
                    }
                } else {
                    return litA->sDuct < litB->sDuct;
                }
            case 1://1:冗余次数>归结次数>文字数>稳定度
                if (litA->sDuct == litB->sDuct) {
                    if (c1->reduntTimes == c2->reduntTimes) {
                        if (c1->pdeductNum == c2->pdeductNum) {
                            if (c1->uLitNum == c2->uLitNum) {
                                if (litA->subTerm->fSteadyValue == litB->subTerm->fSteadyValue) {
                                    return litA->subTerm->RelationValue() < litB->subTerm->RelationValue();
                                } else {
                                    switch (StrategyParam::candSteady) {
                                        case 0://0:由高到低
                                            return litA->subTerm->fSteadyValue > litB->subTerm->fSteadyValue;
                                        case 1://无(由输入顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return litA->subTerm->fSteadyValue < litB->subTerm->fSteadyValue;
                                    }
                                }
                            } else {
                                switch (StrategyParam::candClause) {
                                    case 0://0:由小到大
                                        return c1->uLitNum < c2->uLitNum;
                                    case 1://1:无(由输入顺序为准)
                                        return true;
                                    case 2://2:由大到小
                                        return c1->uLitNum > c2->uLitNum;
                                }
                            }
                        } else {
                            switch (StrategyParam::candDeduct) {
                                case 0://0:由低到高
                                    return c1->pdeductNum < c2->pdeductNum;
                                case 1://1:无(由输入顺序为准)
                                    return true;
                                case 2://2:由高到低
                                    return c1->pdeductNum > c2->pdeductNum;
                            }
                        }
                    } else {
                        switch (StrategyParam::candRedunt) {
                            case 0://0:由低到高
                                return c1->reduntTimes < c2->reduntTimes;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->reduntTimes > c2->reduntTimes;
                        }
                    }
                } else {
                    return litA->sDuct < litB->sDuct;
                }

            case 2://2:归结次数>冗余次数>稳定度>文字数
                if (litA->sDuct == litB->sDuct) {
                    if (c1->pdeductNum == c2->pdeductNum) {
                        if (c1->reduntTimes == c2->reduntTimes) {
                            if (litA->subTerm->fSteadyValue == litB->subTerm->fSteadyValue) {
                                if (c1->uLitNum == c2->uLitNum) {
                                    return litA->subTerm->RelationValue() < litB->subTerm->RelationValue();
                                } else {
                                    switch (StrategyParam::candClause) {
                                        case 0://0:由小到大
                                            return c1->uLitNum < c2->uLitNum;
                                        case 1://1:无(由输入顺序为准)
                                            return true;
                                        case 2://2:由大到小
                                            return c1->uLitNum > c2->uLitNum;
                                    }

                                }
                            } else {
                                switch (StrategyParam::candSteady) {
                                    case 0://0:由高到低
                                        return litA->subTerm->fSteadyValue > litB->subTerm->fSteadyValue;
                                    case 1://无(由输入顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return litA->subTerm->fSteadyValue < litB->subTerm->fSteadyValue;
                                }
                            }
                        } else {
                            switch (StrategyParam::candRedunt) {
                                case 0://0:由低到高
                                    return c1->reduntTimes < c2->reduntTimes;
                                case 1://1:无(由输入顺序为准)
                                    return true;
                                case 2://2:由高到低
                                    return c1->reduntTimes > c2->reduntTimes;
                            }
                        }
                    } else {
                        switch (StrategyParam::candDeduct) {
                            case 0://0:由低到高
                                return c1->pdeductNum < c2->pdeductNum;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->pdeductNum > c2->pdeductNum;
                        }
                    }
                } else {
                    return litA->sDuct < litB->sDuct;
                }

            case 3://3:冗余次数>归结次数>稳定度>文字数
                if (litA->sDuct == litB->sDuct) {
                    if (c1->reduntTimes == c2->reduntTimes) {
                        if (c1->pdeductNum == c2->pdeductNum) {
                            if (litA->subTerm->fSteadyValue == litB->subTerm->fSteadyValue) {
                                if (c1->uLitNum == c2->uLitNum) {
                                    return litA->subTerm->RelationValue() < litB->subTerm->RelationValue();
                                } else {
                                    switch (StrategyParam::candClause) {
                                        case 0://0:由小到大
                                            return c1->uLitNum < c2->uLitNum;
                                        case 1://1:无(由输入顺序为准)
                                            return true;
                                        case 2://2:由大到小
                                            return c1->uLitNum > c2->uLitNum;
                                    }

                                }
                            } else {
                                switch (StrategyParam::candSteady) {
                                    case 0://0:由高到低
                                        return litA->subTerm->fSteadyValue > litB->subTerm->fSteadyValue;
                                    case 1://无(由输入顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return litA->subTerm->fSteadyValue < litB->subTerm->fSteadyValue;
                                }
                            }
                        } else {
                            switch (StrategyParam::candDeduct) {
                                case 0://0:由低到高
                                    return c1->pdeductNum < c2->pdeductNum;
                                case 1://1:无(由输入顺序为准)
                                    return true;
                                case 2://2:由高到低
                                    return c1->pdeductNum > c2->pdeductNum;
                            }
                        }
                    } else {
                        switch (StrategyParam::candRedunt) {
                            case 0://0:由低到高
                                return c1->reduntTimes < c2->reduntTimes;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->reduntTimes > c2->reduntTimes;
                        }
                    }
                } else {
                    return litA->sDuct < litB->sDuct;
                }
            case 4://4:无(由原始顺序为准)
                return true;
        }
    }
    //20180120 从左到右最优排序
    static bool PoslitCmpPriorLR(const Clause* c1, const Clause* c2) {
        //20170220 候选子句排序策略
        switch (StrategyParam::candChoose) {
            case 0://0:归结次数>冗余次数>文字数>稳定度
                if (c1->uLitNum == c2->uLitNum) {
                    if (c1->pdeductNum == c2->pdeductNum) {
                        if (c1->reduntTimes == c2->reduntTimes) {
                            if (c1->uLitNum == c2->uLitNum) {
                                if (StrategyParam::unitSortRule == 3) {
                                    return c1->goaldeepth < c2->goaldeepth;
                                } else if (StrategyParam::unitSortRule == 4) {
                                    return c1->maxPairPred < c2->maxPairPred;
                                } else if (StrategyParam::unitSortRule == 5) {
                                    return c1->maxPairPred > c2->maxPairPred;
                                } else if (StrategyParam::unitSortRule == 6) {
                                    return c1->uVarCount < c2->uVarCount;
                                } else if (StrategyParam::unitSortRule == 7) {
                                    return c1->uVarCount > c2->uVarCount;
                                } else if (StrategyParam::unitSortRule == 8) {
                                    return c1->uClaId > c2->uClaId;
                                } else
                                    return c1->termCount21 < c2->termCount21;
                            } else {
                                switch (StrategyParam::candClause) {
                                    case 0://0:由小到大
                                        return c1->uLitNum < c2->uLitNum;
                                    case 1://1:无(由输入顺序为准)
                                        return true;
                                    case 2://2:由大到小
                                        return c1->uLitNum > c2->uLitNum;
                                }
                            }
                        } else {
                            switch (StrategyParam::candRedunt) {
                                case 0://0:由低到高
                                    return c1->reduntTimes < c2->reduntTimes;
                                case 1://1:无(由输入顺序为准)
                                    return true;
                                case 2://2:由高到低
                                    return c1->reduntTimes > c2->reduntTimes;
                            }
                        }
                    } else {
                        switch (StrategyParam::candDeduct) {
                            case 0://0:由低到高
                                return c1->pdeductNum < c2->pdeductNum;
                            case 1://1:无(由输入顺序为准)
                                return c1->uClaId < c2->uClaId;
                            case 2://2:由高到低
                                return c1->pdeductNum > c2->pdeductNum;
                        }
                    }
                } else {
                    return c1->uLitNum < c2->uLitNum;
                }
            case 1://1:冗余次数>归结次数>文字数>稳定度
                if (c1->uLitNum == c2->uLitNum) {
                    if (c1->reduntTimes == c2->reduntTimes) {
                        if (c1->pdeductNum == c2->pdeductNum) {
                            if (c1->uLitNum == c2->uLitNum) {
                                if (StrategyParam::unitSortRule == 3) {
                                    return c1->goaldeepth < c2->goaldeepth;
                                } else if (StrategyParam::unitSortRule == 4) {
                                    return c1->maxPairPred < c2->maxPairPred;
                                } else if (StrategyParam::unitSortRule == 5) {
                                    return c1->maxPairPred > c2->maxPairPred;
                                } else if (StrategyParam::unitSortRule == 6) {
                                    return c1->uVarCount < c2->uVarCount;
                                } else if (StrategyParam::unitSortRule == 7) {
                                    return c1->uVarCount > c2->uVarCount;
                                } else if (StrategyParam::unitSortRule == 8) {
                                    return c1->uClaId > c2->uClaId;
                                } else
                                    return c1->termCount21 < c2->termCount21;
                            } else {
                                switch (StrategyParam::candClause) {
                                    case 0://0:由小到大
                                        return c1->uLitNum < c2->uLitNum;
                                    case 1://1:无(由输入顺序为准)
                                        return true;
                                    case 2://2:由大到小
                                        return c1->uLitNum > c2->uLitNum;
                                }
                            }
                        } else {
                            switch (StrategyParam::candDeduct) {
                                case 0://0:由低到高
                                    return c1->pdeductNum < c2->pdeductNum;
                                case 1://1:无(由输入顺序为准)
                                    return true;
                                case 2://2:由高到低
                                    return c1->pdeductNum > c2->pdeductNum;
                            }
                        }
                    } else {
                        switch (StrategyParam::candRedunt) {
                            case 0://0:由低到高
                                return c1->reduntTimes < c2->reduntTimes;
                            case 1://1:无(由输入顺序为准)
                                return c1->uClaId < c2->uClaId;
                            case 2://2:由高到低
                                return c1->reduntTimes > c2->reduntTimes;
                        }
                    }
                } else {
                    return c1->uLitNum < c2->uLitNum;
                }

            case 2://2:归结次数>冗余次数>稳定度>文字数
                if (c1->uLitNum == c2->uLitNum) {
                    if (c1->pdeductNum == c2->pdeductNum) {
                        if (c1->reduntTimes == c2->reduntTimes) {
                            if (StrategyParam::unitSortRule == 3) {
                                return c1->goaldeepth < c2->goaldeepth;
                            } else if (StrategyParam::unitSortRule == 4) {
                                return c1->maxPairPred < c2->maxPairPred;
                            } else if (StrategyParam::unitSortRule == 5) {
                                return c1->maxPairPred > c2->maxPairPred;
                            } else if (StrategyParam::unitSortRule == 6) {
                                return c1->uVarCount < c2->uVarCount;
                            } else if (StrategyParam::unitSortRule == 7) {
                                return c1->uVarCount > c2->uVarCount;
                            } else if (StrategyParam::unitSortRule == 8) {
                                return c1->uClaId > c2->uClaId;
                            } else
                                return c1->termCount21 < c2->termCount21;
                        } else {
                            switch (StrategyParam::candRedunt) {
                                case 0://0:由低到高
                                    return c1->reduntTimes < c2->reduntTimes;
                                case 1://1:无(由输入顺序为准)
                                    return true;
                                case 2://2:由高到低
                                    return c1->reduntTimes > c2->reduntTimes;
                            }
                        }
                    } else {
                        switch (StrategyParam::candDeduct) {
                            case 0://0:由低到高
                                return c1->pdeductNum < c2->pdeductNum;
                            case 1://1:无(由输入顺序为准)
                                return c1->uClaId < c2->uClaId;
                            case 2://2:由高到低
                                return c1->pdeductNum > c2->pdeductNum;
                        }
                    }
                } else {
                    return c1->uLitNum < c2->uLitNum;
                }

            case 3://3:冗余次数>归结次数>稳定度>文字数
                if (c1->uLitNum == c2->uLitNum) {
                    if (c1->reduntTimes == c2->reduntTimes) {
                        if (c1->pdeductNum == c2->pdeductNum) {
                            if (StrategyParam::unitSortRule == 3) {
                                return c1->goaldeepth < c2->goaldeepth;
                            } else if (StrategyParam::unitSortRule == 4) {
                                return c1->maxPairPred < c2->maxPairPred;
                            } else if (StrategyParam::unitSortRule == 5) {
                                return c1->maxPairPred > c2->maxPairPred;
                            } else if (StrategyParam::unitSortRule == 6) {
                                return c1->uVarCount < c2->uVarCount;
                            } else if (StrategyParam::unitSortRule == 7) {
                                return c1->uVarCount > c2->uVarCount;
                            } else if (StrategyParam::unitSortRule == 8) {
                                return c1->uClaId > c2->uClaId;
                            } else
                                return c1->termCount21 < c2->termCount21;
                        } else {
                            switch (StrategyParam::candDeduct) {
                                case 0://0:由低到高
                                    return c1->pdeductNum < c2->pdeductNum;
                                case 1://1:无(由输入顺序为准)
                                    return true;
                                case 2://2:由高到低
                                    return c1->pdeductNum > c2->pdeductNum;
                            }
                        }
                    } else {
                        switch (StrategyParam::candRedunt) {
                            case 0://0:由低到高
                                return c1->reduntTimes < c2->reduntTimes;
                            case 1://1:无(由输入顺序为准)
                                return c1->uClaId < c2->uClaId;
                            case 2://2:由高到低
                                return c1->reduntTimes > c2->reduntTimes;
                        }
                    }
                } else {
                    return c1->uLitNum < c2->uLitNum;
                }
            case 4://4:无(由原始顺序为准)
                return true;
        }
    }
    //20180120 最优排序
    static bool PoslitCmpPrior(const Literal*litA, const Literal*litB) {
        //20170220 候选子句排序策略
        Clause* c1 = litA->claPtr;
        Clause* c2 = litB->claPtr;
        switch (StrategyParam::candChoose) {
            case 0://0:归结次数>冗余次数>文字数>稳定度
                if (c1->uLitNum == c2->uLitNum) {
                    if (c1->pdeductNum == c2->pdeductNum) {
                        if (c1->reduntTimes == c2->reduntTimes) {
                            if (c1->uLitNum == c2->uLitNum) {
                                if (litA->subTerm->fSteadyValue == litB->subTerm->fSteadyValue) {
                                    return litA->subTerm->RelationValue() < litB->subTerm->RelationValue();
                                } else {
                                    switch (StrategyParam::candSteady) {
                                        case 0://0:由高到低
                                            return litA->subTerm->fSteadyValue > litB->subTerm->fSteadyValue;
                                        case 1://无(由输入顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return litA->subTerm->fSteadyValue < litB->subTerm->fSteadyValue;
                                    }
                                }
                            } else {
                                switch (StrategyParam::candClause) {
                                    case 0://0:由小到大
                                        return c1->uLitNum < c2->uLitNum;
                                    case 1://1:无(由输入顺序为准)
                                        return true;
                                    case 2://2:由大到小
                                        return c1->uLitNum > c2->uLitNum;
                                }
                            }
                        } else {
                            switch (StrategyParam::candRedunt) {
                                case 0://0:由低到高
                                    return c1->reduntTimes < c2->reduntTimes;
                                case 1://1:无(由输入顺序为准)
                                    return true;
                                case 2://2:由高到低
                                    return c1->reduntTimes > c2->reduntTimes;
                            }
                        }
                    } else {
                        switch (StrategyParam::candDeduct) {
                            case 0://0:由低到高
                                return c1->pdeductNum < c2->pdeductNum;
                            case 1://1:无(由输入顺序为准)
                                return c1->uClaId > c2->uClaId;
                            case 2://2:由高到低
                                return c1->pdeductNum > c2->pdeductNum;
                        }
                    }
                } else {
                    return c1->uLitNum < c2->uLitNum;
                }
            case 1://1:冗余次数>归结次数>文字数>稳定度
                if (c1->uLitNum == c2->uLitNum) {
                    if (c1->reduntTimes == c2->reduntTimes) {
                        if (c1->pdeductNum == c2->pdeductNum) {
                            if (c1->uLitNum == c2->uLitNum) {
                                if (litA->subTerm->fSteadyValue == litB->subTerm->fSteadyValue) {
                                    return litA->subTerm->RelationValue() < litB->subTerm->RelationValue();
                                } else {
                                    switch (StrategyParam::candSteady) {
                                        case 0://0:由高到低
                                            return litA->subTerm->fSteadyValue > litB->subTerm->fSteadyValue;
                                        case 1://无(由输入顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return litA->subTerm->fSteadyValue < litB->subTerm->fSteadyValue;
                                    }
                                }
                            } else {
                                switch (StrategyParam::candClause) {
                                    case 0://0:由小到大
                                        return c1->uLitNum < c2->uLitNum;
                                    case 1://1:无(由输入顺序为准)
                                        return true;
                                    case 2://2:由大到小
                                        return c1->uLitNum > c2->uLitNum;
                                }
                            }
                        } else {
                            switch (StrategyParam::candDeduct) {
                                case 0://0:由低到高
                                    return c1->pdeductNum < c2->pdeductNum;
                                case 1://1:无(由输入顺序为准)
                                    return true;
                                case 2://2:由高到低
                                    return c1->pdeductNum > c2->pdeductNum;
                            }
                        }
                    } else {
                        switch (StrategyParam::candRedunt) {
                            case 0://0:由低到高
                                return c1->reduntTimes < c2->reduntTimes;
                            case 1://1:无(由输入顺序为准)
                                return c1->uClaId > c2->uClaId;
                            case 2://2:由高到低
                                return c1->reduntTimes > c2->reduntTimes;
                        }
                    }
                } else {
                    return c1->uLitNum < c2->uLitNum;
                }

            case 2://2:归结次数>冗余次数>稳定度>文字数
                if (c1->uLitNum == c2->uLitNum) {
                    if (c1->pdeductNum == c2->pdeductNum) {
                        if (c1->reduntTimes == c2->reduntTimes) {
                            if (litA->subTerm->fSteadyValue == litB->subTerm->fSteadyValue) {
                                if (c1->uLitNum == c2->uLitNum) {
                                    return litA->subTerm->RelationValue() < litB->subTerm->RelationValue();
                                } else {
                                    switch (StrategyParam::candClause) {
                                        case 0://0:由小到大
                                            return c1->uLitNum < c2->uLitNum;
                                        case 1://1:无(由输入顺序为准)
                                            return true;
                                        case 2://2:由大到小
                                            return c1->uLitNum > c2->uLitNum;
                                    }

                                }
                            } else {
                                switch (StrategyParam::candSteady) {
                                    case 0://0:由高到低
                                        return litA->subTerm->fSteadyValue > litB->subTerm->fSteadyValue;
                                    case 1://无(由输入顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return litA->subTerm->fSteadyValue < litB->subTerm->fSteadyValue;
                                }
                            }
                        } else {
                            switch (StrategyParam::candRedunt) {
                                case 0://0:由低到高
                                    return c1->reduntTimes < c2->reduntTimes;
                                case 1://1:无(由输入顺序为准)
                                    return true;
                                case 2://2:由高到低
                                    return c1->reduntTimes > c2->reduntTimes;
                            }
                        }
                    } else {
                        switch (StrategyParam::candDeduct) {
                            case 0://0:由低到高
                                return c1->pdeductNum < c2->pdeductNum;
                            case 1://1:无(由输入顺序为准)
                                return c1->uClaId > c2->uClaId;
                            case 2://2:由高到低
                                return c1->pdeductNum > c2->pdeductNum;
                        }
                    }
                } else {
                    return c1->uLitNum < c2->uLitNum;
                }

            case 3://3:冗余次数>归结次数>稳定度>文字数
                if (c1->uLitNum == c2->uLitNum) {
                    if (c1->reduntTimes == c2->reduntTimes) {
                        if (c1->pdeductNum == c2->pdeductNum) {
                            if (litA->subTerm->fSteadyValue == litB->subTerm->fSteadyValue) {
                                if (c1->uLitNum == c2->uLitNum) {
                                    return litA->subTerm->RelationValue() < litB->subTerm->RelationValue();
                                } else {
                                    switch (StrategyParam::candClause) {
                                        case 0://0:由小到大
                                            return c1->uLitNum < c2->uLitNum;
                                        case 1://1:无(由输入顺序为准)
                                            return true;
                                        case 2://2:由大到小
                                            return c1->uLitNum > c2->uLitNum;
                                    }

                                }
                            } else {
                                switch (StrategyParam::candSteady) {
                                    case 0://0:由高到低
                                        return litA->subTerm->fSteadyValue > litB->subTerm->fSteadyValue;
                                    case 1://无(由输入顺序为准)
                                        return true;
                                    case 2://2:由低到高
                                        return litA->subTerm->fSteadyValue < litB->subTerm->fSteadyValue;
                                }
                            }
                        } else {
                            switch (StrategyParam::candDeduct) {
                                case 0://0:由低到高
                                    return c1->pdeductNum < c2->pdeductNum;
                                case 1://1:无(由输入顺序为准)
                                    return true;
                                case 2://2:由高到低
                                    return c1->pdeductNum > c2->pdeductNum;
                            }
                        }
                    } else {
                        switch (StrategyParam::candRedunt) {
                            case 0://0:由低到高
                                return c1->reduntTimes < c2->reduntTimes;
                            case 1://1:无(由输入顺序为准)
                                return c1->uClaId > c2->uClaId;
                            case 2://2:由高到低
                                return c1->reduntTimes > c2->reduntTimes;
                        }
                    }
                } else {
                    return c1->uLitNum < c2->uLitNum;
                }
            case 4://4:无(由原始顺序为准)
                return true;
        }
    }
    //20180120 
    //20171026 用于从左到右演绎排序
    static bool PoslitCmpProRL(const Clause* c1, const Clause* c2) {
        switch (StrategyParam::candChoose) {
            case 0://0:归结次数>冗余次数>文字数>稳定度
                if (c1->pdeductNum == c2->pdeductNum) {
                    if (c1->reduntTimes == c2->reduntTimes) {
                        if (c1->uLitNum == c2->uLitNum) {
                            return c1->hasUsed() <= c2->hasUsed();
                        } else {
                            return c1->uLitNum < c2->uLitNum;
                        }
                    } else {
                        switch (StrategyParam::candRedunt) {
                            case 0://0:由低到高
                                return c1->reduntTimes < c2->reduntTimes;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->reduntTimes > c2->reduntTimes;
                        }
                    }
                } else {
                    switch (StrategyParam::candDeduct) {
                        case 0://0:由低到高
                            return c1->pdeductNum < c2->pdeductNum;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->pdeductNum > c2->pdeductNum;
                    }
                }
            case 1://1:冗余次数>归结次数>文字数>稳定度
                if (c1->reduntTimes == c2->reduntTimes) {
                    if (c1->pdeductNum == c2->pdeductNum) {
                        if (c1->uLitNum == c2->uLitNum) {
                            return c1->hasUsed() <= c2->hasUsed();
                        } else {
                            return c1->uLitNum < c2->uLitNum;
                        }
                    } else {
                        switch (StrategyParam::candDeduct) {
                            case 0://0:由低到高
                                return c1->pdeductNum < c2->pdeductNum;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->pdeductNum > c2->pdeductNum;
                        }
                    }
                } else {
                    switch (StrategyParam::candRedunt) {
                        case 0://0:由低到高
                            return c1->reduntTimes < c2->reduntTimes;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->reduntTimes > c2->reduntTimes;
                    }
                }

            case 2://2:归结次数>冗余次数>稳定度>文字数
                if (c1->pdeductNum == c2->pdeductNum) {
                    if (c1->reduntTimes == c2->reduntTimes) {
                        if (c1->uLitNum == c2->uLitNum) {
                            return c1->hasUsed() <= c2->hasUsed();
                        } else {
                            return c1->uLitNum < c2->uLitNum;
                        }

                    } else {
                        switch (StrategyParam::candRedunt) {
                            case 0://0:由低到高
                                return c1->reduntTimes < c2->reduntTimes;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->reduntTimes > c2->reduntTimes;
                        }
                    }
                } else {
                    switch (StrategyParam::candDeduct) {
                        case 0://0:由低到高
                            return c1->pdeductNum < c2->pdeductNum;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->pdeductNum > c2->pdeductNum;
                    }
                }

            case 3://3:冗余次数>归结次数>稳定度>文字数
                if (c1->reduntTimes == c2->reduntTimes) {
                    if (c1->pdeductNum == c2->pdeductNum) {
                        if (c1->uLitNum == c2->uLitNum) {
                            return c1->hasUsed() <= c2->hasUsed();
                        } else {
                            return c1->uLitNum < c2->uLitNum;
                        }

                    } else {
                        switch (StrategyParam::candDeduct) {
                            case 0://0:由低到高
                                return c1->pdeductNum < c2->pdeductNum;
                            case 1://1:无(由输入顺序为准)
                                return true;
                            case 2://2:由高到低
                                return c1->pdeductNum > c2->pdeductNum;
                        }
                    }
                } else {
                    switch (StrategyParam::candRedunt) {
                        case 0://0:由低到高
                            return c1->reduntTimes < c2->reduntTimes;
                        case 1://1:无(由输入顺序为准)
                            return true;
                        case 2://2:由高到低
                            return c1->reduntTimes > c2->reduntTimes;
                    }
                }
            case 4://4:无(由原始顺序为准)
                return true;
        }
    }
    //20170908 目标子句的候选子句排序
    static bool PoslitCmpGoalDeepth(const Literal*litA, const Literal*litB) {
        /*0, "P_NS(子句冗余次数最少>被动归结次数最少>子句文字数>文字稳定度)"*/
        /*1, "P_SN(子句冗余次数最少>被动归结次数最少>文字稳定度>子句文字数)"*/
       /*
        //子句冗余次数
        if (litA->claPtr->Priority != litB->claPtr->Priority)
            return litA->claPtr->Priority > litB->claPtr->Priority;
        //文字被动归结次数
        if (litA->uPassive != litB->uPassive)
            return litA->uPassive < litB->uPassive;
        //文字数和稳定度
        int iLitSteady = TermSteadyCmp(litA->subTerm, litB->subTerm, StrategyParam::SEL_POSLIT_STEADY);
        int iClaASize = int(litA->claPtr->uLitNum);
        int iClaBSize = int(litB->claPtr->uLitNum);
        if (StrategyParam::SEL_POSLIT_STRATEGY == 0) {
            //子句文字数>文字稳定度
            if (iClaASize != iClaBSize) {
                switch (StrategyParam::SEL_POSLIT_NUMLIT) {
                        //-1, "无(以输入顺序为准 0, "文字数由少到多" 1, "文字数由多到少"
                    case -1:return true;
                    case 0: return iClaASize<iClaBSize;
                    case 1: return iClaASize>iClaBSize;
                }
            }
            return 1 == iLitSteady;
        }
        //文字稳定度>子句文字数
        if (iLitSteady == 0) {
            switch (StrategyParam::SEL_POSLIT_NUMLIT) {
                    //-1, "无(以输入顺序为准 0, "文字数由少到多" 1, "文字数由多到少"
                case -1:return true;
                case 0: return iClaASize<iClaBSize;
                case 1: return iClaASize>iClaBSize;
            }
        }
        return 1 == iLitSteady;
        */
         /*0, "P_NS(子句权重最少>被动归结次数最少>子句文字数>文字稳定度)"*/
        /*1, "P_SN(子句权重最少>被动归结次数最少>文字稳定度>子句文字数)"*/
       
        //权重最少
        /*
        if (litA->claPtr->pdeductNum != litB->claPtr->pdeductNum)
            return litA->claPtr->pdeductNum < litB->claPtr->pdeductNum;
        //文字被动归结次数
        //if (litA->uPassive != litB->uPassive)
           // return litA->uPassive < litB->uPassive;
        //文字数和稳定度
        int iLitSteady = TermSteadyCmp(litA->subTerm, litB->subTerm, StrategyParam::SEL_POSLIT_STEADY);
        int iClaASize = int(litA->claPtr->uLitNum);
        int iClaBSize = int(litB->claPtr->uLitNum);
        if (StrategyParam::SEL_POSLIT_STRATEGY == 0) {
            //子句文字数>文字稳定度
            if (iClaASize != iClaBSize) {
                switch (StrategyParam::SEL_POSLIT_NUMLIT) {
                        //-1, "无(以输入顺序为准 0, "文字数由少到多" 1, "文字数由多到少"
                    case -1:return true;
                    case 0: return iClaASize<iClaBSize;
                    case 1: return iClaASize>iClaBSize;
                }
            }
            return 1 == iLitSteady;
        }
        //文字稳定度>子句文字数
        if (iLitSteady == 0) {
            switch (StrategyParam::SEL_POSLIT_NUMLIT) {
                    //-1, "无(以输入顺序为准 0, "文字数由少到多" 1, "文字数由多到少"
                case -1:return true;
                case 0: return iClaASize<iClaBSize;
                case 1: return iClaASize>iClaBSize;
            }
        }
        return 1 == iLitSteady;
        */
        //20170220 候选子句排序策略
        Clause* c1 = litA->claPtr;
        Clause* c2 = litB->claPtr;
        switch (StrategyParam::candChoose) {
            case 0://0:归结次数>冗余次数>文字数>稳定度
                if (litA->sDuct == litB->sDuct) {
                    if (litA->goalDeepth == litB->goalDeepth) {
                        if (c1->pdeductNum == c2->pdeductNum) {
                            if (c1->reduntTimes == c2->reduntTimes) {
                                if (c1->uLitNum == c2->uLitNum) {
                                    if (litA->subTerm->fSteadyValue == litB->subTerm->fSteadyValue) {
                                        return litA->subTerm->RelationValue() < litB->subTerm->RelationValue();
                                    } else {
                                        switch (StrategyParam::candSteady) {
                                            case 0://0:由高到低
                                                return litA->subTerm->fSteadyValue > litB->subTerm->fSteadyValue;
                                            case 1://无(由输入顺序为准)
                                                return true;
                                            case 2://2:由低到高
                                                return litA->subTerm->fSteadyValue < litB->subTerm->fSteadyValue;
                                        }
                                    }
                                } else {
                                    switch (StrategyParam::candClause) {
                                        case 0://0:由小到大
                                            return c1->uLitNum < c2->uLitNum;
                                        case 1://1:无(由输入顺序为准)
                                            return true;
                                        case 2://2:由大到小
                                            return c1->uLitNum > c2->uLitNum;
                                    }
                                }
                            } else {
                                switch (StrategyParam::candRedunt) {
                                    case 0://0:由低到高
                                        return c1->reduntTimes < c2->reduntTimes;
                                    case 1://1:无(由输入顺序为准)
                                        return true;
                                    case 2://2:由高到低
                                        return c1->reduntTimes > c2->reduntTimes;
                                }
                            }
                        } else {
                            switch (StrategyParam::candDeduct) {
                                case 0://0:由低到高
                                    return c1->pdeductNum < c2->pdeductNum;
                                case 1://1:无(由输入顺序为准)
                                    return true;
                                case 2://2:由高到低
                                    return c1->pdeductNum > c2->pdeductNum;
                            }
                        }
                    } else {
                        return litA->goalDeepth < litB->goalDeepth;
                    }
                } else {
                    return litA->sDuct < litB->sDuct;
                }

            case 1://1:冗余次数>归结次数>文字数>稳定度
                if (litA->sDuct == litB->sDuct) {
                    if (litA->goalDeepth == litB->goalDeepth) {
                        if (c1->reduntTimes == c2->reduntTimes) {
                            if (c1->pdeductNum == c2->pdeductNum) {
                                if (c1->uLitNum == c2->uLitNum) {
                                    if (litA->subTerm->fSteadyValue == litB->subTerm->fSteadyValue) {
                                        return litA->subTerm->RelationValue() < litB->subTerm->RelationValue();
                                    } else {
                                        switch (StrategyParam::candSteady) {
                                            case 0://0:由高到低
                                                return litA->subTerm->fSteadyValue > litB->subTerm->fSteadyValue;
                                            case 1://无(由输入顺序为准)
                                                return true;
                                            case 2://2:由低到高
                                                return litA->subTerm->fSteadyValue < litB->subTerm->fSteadyValue;
                                        }
                                    }
                                } else {
                                    switch (StrategyParam::candClause) {
                                        case 0://0:由小到大
                                            return c1->uLitNum < c2->uLitNum;
                                        case 1://1:无(由输入顺序为准)
                                            return true;
                                        case 2://2:由大到小
                                            return c1->uLitNum > c2->uLitNum;
                                    }
                                }
                            } else {
                                switch (StrategyParam::candDeduct) {
                                    case 0://0:由低到高
                                        return c1->pdeductNum < c2->pdeductNum;
                                    case 1://1:无(由输入顺序为准)
                                        return true;
                                    case 2://2:由高到低
                                        return c1->pdeductNum > c2->pdeductNum;
                                }
                            }
                        } else {
                            switch (StrategyParam::candRedunt) {
                                case 0://0:由低到高
                                    return c1->reduntTimes < c2->reduntTimes;
                                case 1://1:无(由输入顺序为准)
                                    return true;
                                case 2://2:由高到低
                                    return c1->reduntTimes > c2->reduntTimes;
                            }
                        }
                    } else {
                        return litA->goalDeepth < litB->goalDeepth;
                    }
                } else {
                    return litA->sDuct < litB->sDuct;
                }

            case 2://2:归结次数>冗余次数>稳定度>文字数
                if (litA->sDuct == litB->sDuct) {
                    if (litA->goalDeepth == litB->goalDeepth) {
                        if (c1->pdeductNum == c2->pdeductNum) {
                            if (c1->reduntTimes == c2->reduntTimes) {
                                if (litA->subTerm->fSteadyValue == litB->subTerm->fSteadyValue) {
                                    if (c1->uLitNum == c2->uLitNum) {
                                        return litA->subTerm->RelationValue() < litB->subTerm->RelationValue();
                                    } else {
                                        switch (StrategyParam::candClause) {
                                            case 0://0:由小到大
                                                return c1->uLitNum < c2->uLitNum;
                                            case 1://1:无(由输入顺序为准)
                                                return true;
                                            case 2://2:由大到小
                                                return c1->uLitNum > c2->uLitNum;
                                        }

                                    }
                                } else {
                                    switch (StrategyParam::candSteady) {
                                        case 0://0:由高到低
                                            return litA->subTerm->fSteadyValue > litB->subTerm->fSteadyValue;
                                        case 1://无(由输入顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return litA->subTerm->fSteadyValue < litB->subTerm->fSteadyValue;
                                    }
                                }
                            } else {
                                switch (StrategyParam::candRedunt) {
                                    case 0://0:由低到高
                                        return c1->reduntTimes < c2->reduntTimes;
                                    case 1://1:无(由输入顺序为准)
                                        return true;
                                    case 2://2:由高到低
                                        return c1->reduntTimes > c2->reduntTimes;
                                }
                            }
                        } else {
                            switch (StrategyParam::candDeduct) {
                                case 0://0:由低到高
                                    return c1->pdeductNum < c2->pdeductNum;
                                case 1://1:无(由输入顺序为准)
                                    return true;
                                case 2://2:由高到低
                                    return c1->pdeductNum > c2->pdeductNum;
                            }
                        }
                    } else {
                        return litA->goalDeepth < litB->goalDeepth;
                    }
                } else {
                    return litA->sDuct < litB->sDuct;
                }
            case 3://3:冗余次数>归结次数>稳定度>文字数
                if (litA->sDuct == litB->sDuct) {
                    if (litA->goalDeepth == litB->goalDeepth) {
                        if (c1->reduntTimes == c2->reduntTimes) {
                            if (c1->pdeductNum == c2->pdeductNum) {
                                if (litA->subTerm->fSteadyValue == litB->subTerm->fSteadyValue) {
                                    if (c1->uLitNum == c2->uLitNum) {
                                        return litA->subTerm->RelationValue() < litB->subTerm->RelationValue();
                                    } else {
                                        switch (StrategyParam::candClause) {
                                            case 0://0:由小到大
                                                return c1->uLitNum < c2->uLitNum;
                                            case 1://1:无(由输入顺序为准)
                                                return true;
                                            case 2://2:由大到小
                                                return c1->uLitNum > c2->uLitNum;
                                        }

                                    }
                                } else {
                                    switch (StrategyParam::candSteady) {
                                        case 0://0:由高到低
                                            return litA->subTerm->fSteadyValue > litB->subTerm->fSteadyValue;
                                        case 1://无(由输入顺序为准)
                                            return true;
                                        case 2://2:由低到高
                                            return litA->subTerm->fSteadyValue < litB->subTerm->fSteadyValue;
                                    }
                                }
                            } else {
                                switch (StrategyParam::candDeduct) {
                                    case 0://0:由低到高
                                        return c1->pdeductNum < c2->pdeductNum;
                                    case 1://1:无(由输入顺序为准)
                                        return true;
                                    case 2://2:由高到低
                                        return c1->pdeductNum > c2->pdeductNum;
                                }
                            }
                        } else {
                            switch (StrategyParam::candRedunt) {
                                case 0://0:由低到高
                                    return c1->reduntTimes < c2->reduntTimes;
                                case 1://1:无(由输入顺序为准)
                                    return true;
                                case 2://2:由高到低
                                    return c1->reduntTimes > c2->reduntTimes;
                            }
                        }
                    } else {
                        return litA->goalDeepth < litB->goalDeepth;
                    }
                } else {
                    return litA->sDuct < litB->sDuct;
                }
            case 4://4:无(由原始顺序为准)
                return true;
        }
    }
    
    
    
    //文字排序

    inline static bool LitPtrCmp(const Literal* litA, const Literal* litB) {
        //所在子句短
        Clause* c1 = litA->claPtr;
        Clause* c2 = litB->claPtr;
        if (c1->uLitNum == c2->uLitNum) {
            return (litA->subTerm->uMaxVarId / double(litA->subTerm->uSubTermNum)) < litB->subTerm->uMaxVarId / double(litB->subTerm->uSubTermNum);
            //return c1->uMaxVarId<c2->uMaxVarId;

        }
        return c1->uLitNum < c2->uLitNum;

    }
    inline static bool claTwoCmp(const Literal* litA, const Literal* litB) {
        //所在子句短
        Clause* c1 = litA->claPtr;
        Clause* c2 = litB->claPtr;
        if (c1->uLitNum == c2->uLitNum) {//noUnitDeductTimes
            //return (litA->subTerm->uMaxVarId / double(litA->subTerm->uSubTermNum)) < litB->subTerm->uMaxVarId / double(litB->subTerm->uSubTermNum);
            if(c1->noUnitDeductTimes == c2->noUnitDeductTimes)
                return c1->uClaId < c2->uClaId ;
            else
                return c1->noUnitDeductTimes < c2->noUnitDeductTimes;

        }
        return c1->uLitNum < c2->uLitNum;

    }
    inline static bool claTwoCmp_last(const Literal* litA, const Literal* litB) {
        //所在子句短
        Clause* c1 = litA->claPtr;
        Clause* c2 = litB->claPtr;
        if (c1->noUnitDeductTimes == c2->noUnitDeductTimes) {//noUnitDeductTimes
            //return (litA->subTerm->uMaxVarId / double(litA->subTerm->uSubTermNum)) < litB->subTerm->uMaxVarId / double(litB->subTerm->uSubTermNum);
            if(c1->uLitNum == c2->uLitNum)
                return c1->uVarCount < c2->uVarCount ;
            else
                return c1->uLitNum < c2->uLitNum;

        }
        return c1->noUnitDeductTimes < c2->noUnitDeductTimes;

    }
    inline static bool LitCmp(const Literal* litA, const Literal* litB) {

        return 1 == TermSteadyCmp(litA->subTerm, litB->subTerm, 0);

    }
    inline static bool LitCmpGoalDeepth(const Literal* litA, const Literal* litB) {

        return 1 == TermSteadyCmpGoalDeepth(litA, litB, 0);

    }
    inline static bool LitCmpDuct(const Literal* litA, const Literal* litB) {
        if (litA->sDuct == litB->sDuct)

            return 1 == TermSteadyCmp(litA->subTerm, litB->subTerm, 0);
        else
            return litA->sDuct < litB->sDuct;

    }
    /************************************************************************/
    /*    文字稳定度比较规则  相同返回 0；LitA>LitB 返回1 否则返回-1                */

    /************************************************************************/
    static int TermSteadyCmp(Term* litA, Term* litB, int iCmpType) {
        //-1, "无(以输入顺序为准)") 	0, "综合稳定度X-由高到低"	1, "综合稳定度X-由低到高"
        //注：稳定度：函数复合层，变元个数与项个数比值；   关联度--最大变元与变元个数比值越小越大。
        //	if (litA.SP == litB.SP&&litA.RP == litB.RP) return 0;
        switch (iCmpType) {
            case -1:
                return 0;
            case 0:
                
                if (litA->fSteadyValue != litB->fSteadyValue)
                    return litA->fSteadyValue < litB->fSteadyValue ? 1 : -1;
                return litA->RelationValue() < litB->RelationValue() ? 1 : -1;
                
            case 1:
                if (litA->fSteadyValue != litB->fSteadyValue)
                    return litA->fSteadyValue > litB->fSteadyValue ? 1 : -1;
                return litA->RelationValue() > litB->RelationValue() ? 1 : -1;
        }
        return 0;
    }
     static int TermSteadyCmpGoalDeepth(const Literal* litA, const Literal* litB, int iCmpType) {
        //-1, "无(以输入顺序为准)") 	0, "综合稳定度X-由高到低"	1, "综合稳定度X-由低到高"
        //注：稳定度：函数复合层，变元个数与项个数比值；   关联度--最大变元与变元个数比值越小越大。
        //	if (litA.SP == litB.SP&&litA.RP == litB.RP) return 0;
        switch (iCmpType) {
            case -1:
                return 0;
            case 0:
                if(litA->goalDeepth == litB->goalDeepth){
                if (litA->subTerm->fSteadyValue != litB->subTerm->fSteadyValue)
                    return litA->subTerm->fSteadyValue < litB->subTerm->fSteadyValue ? 1 : -1;
                return litA->subTerm->RelationValue() < litB->subTerm->RelationValue() ? 1 : -1;
                }
                else{
                    return litA->goalDeepth < litB->goalDeepth;
                }
            case 1:
                if (litA->subTerm->fSteadyValue != litB->subTerm->fSteadyValue)
                    return litA->subTerm->fSteadyValue > litB->subTerm->fSteadyValue ? 1 : -1;
                return litA->subTerm->RelationValue() > litB->subTerm->RelationValue() ? 1 : -1;
        }
        return 0;
    }
//     inline static bool funcEqualityCmp(const funcAdd* term1,const funcAdd* term2){
//         return term1->func < term2->func;
//     }
//     inline static bool literalEqualityCmp(const literalAdd term1,const literalAdd term2){
//         return term1.literal < term2.literal;
//     }
    SortRule();
    SortRule(const SortRule& orig);
    virtual ~SortRule();
private:

};

#endif /* SORTRULE_H */

