/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   Resolution.h
 * Author: sjg
 *
 * Created on 2016年11月29日, 下午2:34
 */

#ifndef RESOLUTION_H
#define RESOLUTION_H
#include "Formula.h"
#include "Subsumption.h"
#include "TriAlg.h"
#include "dataTypeDef.h"
#include "globalFunc.h"
class Resolution {
public:
    Resolution();
    Resolution(const Resolution& orig);
    /************************************************************************/

    /* 构造函数                                                               
    /************************************************************************/
    /*Resolution(INT32 startId = -1) : StartId(startId) {
    }*/

    ~Resolution() {
    };

    /************************************************************************
    /*	基础算法-记录归结路径：
    /*	选择起步子句：A、用户指定起步子句，B、从排序后的第一个子句起步
    /*	构建三角形-->如果出现冗余，则直接对记录的路径进行出栈操作，不再进行重走路径
    /************************************************************************/
    int demodulatorClaSet(Formula& fol,TriAlg& triAlg,UINT32& uNewClaID,vector<Clause*>* preGenCla,UINT32 simplyIdStart,UINT32 simplyIdEnd);
    int demodulatorCla(Formula& fol,TriAlg& triAlg,Clause* cla,UINT32& uNewClaID,vector<Clause*>* preGenCla);
    int demodulatorClaSaturate(Formula& fol,TriAlg& triAlg,Clause* cla,UINT32& uNewClaID,vector<Clause*>* preGenCla);
    int demodulatorLit(Formula& fol,TriAlg& triAlg,Literal* lit,UINT32& uNewClaID,vector<Clause*>* eqnLit);
    int demodulatorLitSaturate(Formula& fol,TriAlg& triAlg,Literal* lit,UINT32& uNewClaID,vector<Clause*>* eqnLit);
    int demodulatorTerm(Formula& fol,TriAlg& triAlg,Term* term,UINT32& uNewClaID,vector<Clause*>* eqnLit);
    int demodulatorTermSaturate(Formula& fol,TriAlg& triAlg,Term* term,UINT32& uNewClaID,vector<Clause*>* eqnLit);
    int negEqnRes(Formula& fol,TriAlg& triAlg,Clause* cla,UINT32& uNewClaID,vector<Clause*>* preGenCla,bool fileNameFlag);
    int factorRes(Formula& fol,TriAlg& triAlg,Clause* cla,UINT32& uNewClaID,vector<Clause*>* preGenCla,bool& resDelFlag, bool fileNameFlag);
    RESULT BaseAlgByRecodePath(Formula &fol, UINT64 &triTotalTimes);
    RESULT InsertSingleSet(Formula& fol,TriAlg& triAlg,int& maxUintID);
    RESULT InsertSingleSetSaturate(Formula& fol, TriAlg& triAlg);
    RESULT InsertSingleCla(Formula& fol, Clause* clap);
    void shiftSingleCla(vector<Literal*>& orgSingleCla, UINT32 N);
    RESULT InsertOutTri(TriAlg& triAlg, Formula& fol, UINT16& loop, bool chooseTri);
    RESULT InsertOutTriLR(TriAlg& triAlg, Formula& fol, UINT16& loop, bool chooseTri);
    RESULT BaseAlgByRecodePathSaturate(Formula& fol, UINT64 &triTotalTimes); //水平浸透构建三角形
    void insertNoPairCla(Formula& fol, Clause* cla);//子句插入到非单元子句集合
    double timeConsume(TriAlg& triAlg);
    //锁归结消除子句方法
    bool lockResSimlify(Formula& fol,TriAlg& triAlg,Clause* cla,UINT32& uNewClaID);
    bool lockResSimlifyNew(Formula& fol,TriAlg& triAlg,Clause* cla,UINT32& uNewClaID);
    int JudgeLockResSimlify(Formula& fol,TriAlg& triAlg,Literal* QLit,Literal* candLitp,vector<Literal*>& candLitPVec,UINT32& uNewClaID,UINT8 lockType,vector<Term*>& VarVec);
    int JudgeLockResSimlifyNew(Formula& fol,TriAlg& triAlg,Literal* QLit,Literal* candLitp,vector<Literal*>& candLitPVec,UINT32& uNewClaID,UINT8 lockType,vector<Term*>& VarVec);
    //RESULT InsertSingleSetUse(Formula& fol);
private:
    //clock_t start;//用于设定时间
    UINT32 runNum;
    //起步子句编号
    INT32 StartId;
    UINT32 shift;
    UINT32 ringCount;   //迭代轮数
    Clause* startClause;
    UINT8 triAlgTimes;//三角形与二元归结的比例
    bool difficulty;//评估问题的难度
    UINT32 noPairInd;//非单元子句下标
    Clause* noPairCla;//非单元子句
    //以下用于等词处理
    vector<Term*> varBindTerm;
    //以下用于锁归结约简
    vector<Literal*> lockLitVec;
    vector<Clause*> lockClaVec;
};

#endif /* RESOLUTION_H */

