/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   Resolution.cpp
 * Author: sjg
 * 
 * Created on 2016年11月29日, 下午2:34
 */

#include "Resolution.h"
#include "Literal.h"
#include "RedundancyOp.h"
#include "StrategyParam.h"
extern map<INT32, vector<INT32>> validPathOut;
Resolution::Resolution() {
    runNum = 0;
    StartId = 0;
    shift = 0;
    ringCount =0;
    startClause = nullptr;
    varBindTerm.clear();
    varBindTerm.reserve(8);
    lockLitVec.clear();
    lockLitVec.reserve(6);
    lockClaVec.clear();
    lockClaVec.reserve(6);
    triAlgTimes = 16;
    difficulty = false;
    noPairInd = 0;
    noPairCla = nullptr;
}

Resolution::Resolution(const Resolution& orig) {
}

//Resolution::~Resolution() {
//}
//初始化单文字子句集
RESULT Resolution::InsertSingleSet(Formula& fol,TriAlg& triAlg,int& maxUintID)
{
    maxUintID = 0;
    if(fol.setCla.size()<1)
    {
        //cout<<"empty set"<<endl;
        return fail;
    }
    //20170217  增加对等词子句的处理

    for(auto& clapE:fol.setEnq)
    {
        clapE->isSDeduct = false;//子句参与归结清空
        assert(clapE!=NULL);
//        if(clapE->uLitNum ==1)
//        {
//            if( triAlg.noCmpCla.find(clapE->uClaId) == triAlg.noCmpCla.end())//noCmpCla用于保存没有互补对的单文字子句
//                fol.setSingleCla.insert(clapE);    
//        }
    }
    for(auto& clap:fol.setCla)
{
//        if(clap->uClaId == 16)
//            cout<<"cf-debug"<<endl;
//        if (clap->uClaId > fol.uOrigClaSize) {
//            string str;
//            clap->toString(str);
//            cout << "子句:" << str << endl;
//            cout <<clap->compFuncDeepthCla()<< endl;
//            if(clap->compFuncDeepthCla()>StrategyParam::funcFixDeepth)
//                cout<<"cf-debug"<<endl;
//        }
        //cout<<clap->uFuncDepth<<endl; 
        clap->isSDeduct = false;//子句参与归结清空
        assert(clap!=NULL);
//        if(clap->deduceDeepth > StrategyParam::deduceDepth)
//            continue;
        if(clap->uLitNum ==1)
        {
//             string str;
//            clap->toString(str);
//            cout << "起步子句:" << str << endl;
            if ((triAlg.noCmpCla.find(clap->uClaId) == triAlg.noCmpCla.end()) && (clap->compFuncDeepthCla() <= StrategyParam::funcFixDeepth)) {//noCmpCla用于保存没有互补对的单文字子句
                fol.setSingleCla.insert(clap);
                if(maxUintID < clap->uClaId)
                    maxUintID = clap->uClaId;
                //++maxUintID;
            }
//            if (clap->uClaId == 16)
//                cout << "cf-debug" << endl;
            //cout<<(int)(clap->LitPtr[0]->subTerm->uSubTermNum)<<endl;//查看子句项的个数
        }
    }
    return Succes;
}

RESULT Resolution::InsertSingleSetSaturate(Formula& fol,TriAlg& triAlg)
{
    for (auto& clap : fol.setDeductCla) {
        clap->isSDeduct = false; //子句参与归结清空
        assert(clap != NULL);
        if (clap->uLitNum == 1) {
            if ((triAlg.noCmpCla.find(clap->uClaId) == triAlg.noCmpCla.end()) && (clap->compFuncDeepthCla() <= StrategyParam::funcFixDeepth)) {//noCmpCla用于保存没有互补对的单文字子句
                fol.setSingleCla.insert(clap);
            }
        }
    }
    return Succes;
}
//加入三角形算法中
/*RESULT Resolution::InsertSingleSetUse(Formula& fol)
{
    if(fol.setCla.size()<1)
    {
        cout<<"empty set"<<endl;
        return fail;
    }

    for(auto& clap:fol.setCla)
    {
        clap->isSDeduct = false;
        if(clap->uLitNum ==1)
        {
            fol.setSingleCla.insert(clap);
            //clap->Print();
            //cout<<"中间单文字子句1[C" + to_string(clap->uClaId)  + "]" <<"[" + to_string(clap->LitPtr[0]->ParentLitRow()) + "_" + to_string(clap->LitPtr[0]->ParentLitCol()) + "]" << clap->LitPtr[0]->subTerm->ToString()<<endl;  
        }
    }
    //if(fol.setSingleCla.size() > 1)
        //stable_sort(fol.setSingleCla.begin(), fol.setSingleCla.end(), SortRule::SingleClaCmp);
    //cout<<"单文字子句："<<fol.setSingleCla.size()<<endl;
    /*set<Clause*>::iterator it= fol.setSingleCla.begin();
    for(;it!=fol.setSingleCla.end();it++)
    {
        (*it)->Print();
    }
    for(auto& clap:fol.setSingleCla)
    {

            clap->Print();
      
    }*/
 //   return Succes;
//}*/


//当R为单文字子句，需要加入到单文字子句集中
RESULT Resolution::InsertSingleCla(Formula& fol,Clause* cla)
{
    for(auto& clap:fol.setSingleCla)
    {
        if(clap == cla)
        {
            return fail;
        }
    }
    fol.setSingleCla.insert(cla);
    return Succes;
}

//将单文字子句循环右移动N次
//20170519 将单元子句改成调换，将第0个元素和第N个元素调换 StrategyParam::unitClaUpdate 0 1 2
void Resolution::shiftSingleCla(vector<Literal*>& orgSingleCla,UINT32 N)
{
    UINT32 size_Tri = orgSingleCla.size();
    if(size_Tri < 2 || N< 1)
        return ;
    if(StrategyParam::unitClaUpdate == 0){//循环方式
        if (N % size_Tri == 0) {   
            Literal* litT = orgSingleCla[0];
            for (UINT32 i = 0; i < size_Tri - 1; i++) {
                orgSingleCla[i] = orgSingleCla[i + 1];
            }
            orgSingleCla[size_Tri - 1] = litT;            
        }
        else {
            UINT32 moves = N % size_Tri;
            vector<Literal*> tempV;
            for (UINT32 i = 0; i < moves; i++)
                tempV.push_back(orgSingleCla[i]);
            for (UINT32 j = 0; j < size_Tri - moves; j++)
                orgSingleCla[j] = orgSingleCla[moves + j];
            for (UINT32 k = 0; k < moves; k++)
                orgSingleCla[size_Tri - moves + k] = tempV[k];
        }
    }
    else if(StrategyParam::unitClaUpdate == 1) {//直接交换方式
        Literal* litT = orgSingleCla[0];
        orgSingleCla[0] = orgSingleCla[N];
        orgSingleCla[N] = litT;
    }
    else{
        //1.先与末尾交换
        Literal* litT = orgSingleCla[0];
        orgSingleCla[0] = orgSingleCla[size_Tri-1];
        orgSingleCla[size_Tri-1] = litT;
        //2. 在与N子句交换
        litT = orgSingleCla[0];
        orgSingleCla[0] = orgSingleCla[N];
        orgSingleCla[N] = litT;
    }
}
//添加单元子句到对角线和归结演绎路径 此处需要修改 20180411
RESULT Resolution::InsertOutTri(TriAlg& triAlg,Formula& fol,UINT16& loop,bool chooseTri)
{
    string str;
   // cout<<setSinleUse.size()<<endl;
    vector<Literal*> singleUintLit;
    singleUintLit.reserve(16);
    for(auto& clap:fol.setSingleCla)
    //for(auto& clap:setSinleUse)
    {
        if(clap->uLitNum > 1)
            return fail;
        //clap->isSDeduct = false;//对角线子句初始化未归结
        //triAlg.vOnlyOutTri.push_back(clap->LitPtr[0]);
        //triAlg.vOutTri.push_back(clap->LitPtr[0]);
//        string str;
//        clap->toString(str);
//        cout << "起步子句:" << str << endl;
        if(clap->isGoal)
            triAlg.vOnlyOutTriCmp.push_back(clap->LitPtr[0]);
        else
            singleUintLit.push_back(clap->LitPtr[0]);
//        if(clap->LitPtr[0]->subTerm->isNegEqnTerm())
//            swap(triAlg.vOnlyOutTriCmp[0],triAlg.vOnlyOutTriCmp[triAlg.vOnlyOutTriCmp.size()-1]);
        //clap->toString(str);
        //*FileOp::ofRealInfoOut << str << endl;  
    }
    //20170909 将不是目标子句的单元子句加入列表中
    if(singleUintLit.size() > 0){
        for(UINT32 id = 0; id < singleUintLit.size(); ++ id){
            triAlg.vOnlyOutTriCmp.push_back(singleUintLit[id]);
        }
    }
    singleUintLit.clear();
    vector<Literal*>().swap(singleUintLit);
    //cout<<triAlg.vOnlyOutTri.size()<<" "<<triAlg.vOutTri.size()<<endl;
   /* if( triAlg.vOnlyOutTriCmp.size() > 1)
    {
        if(1)//int(rand()) % 2 != int(rand()) % 2)
            stable_sort(triAlg.vOnlyOutTriCmp.begin(), triAlg.vOnlyOutTriCmp.end(), SortRule::claSingCmp);
        else
            stable_sort(triAlg.vOnlyOutTriCmp.begin(), triAlg.vOnlyOutTriCmp.end(), SortRule::claSingCmpRand);
    }*/  
    
    //20170112 使对角线单文字子句能够排序,即选择的策略不一样。
    UINT32 size_Tri = triAlg.vOnlyOutTriCmp.size();//当前单元子句的大小
    //cout<<triAlg.vOnlyOutTriCmp.size()<<endl;
    //20170210 计算每个单文字子句有多少个互补的子句，用于计算构建多少个三角形，且只计算1次
//      for (int i = 0; i < triAlg.vOnlyOutTriCmp.size(); ++i) {
//        cout << triAlg.vOnlyOutTriCmp[i]->claPtr->uClaId << " ";
//    }
//    cout << endl;
    if (shift >= size_Tri){//20170710 ==改成>=  StrategyParam::iterRing
            shift = 0;
            ringCount++;
            if(ringCount %3)
                triAlg.noCmpCla.clear();
            if(ringCount == StrategyParam::iterRing/100){
                StrategyParam::R_MAX_NUM += 1;
                StrategyParam::R_MAX_FUNCLAYER += 1;
            }
            else if(ringCount == StrategyParam::iterRing/50){
                //StrategyParam::R_MAX_NUM += 1;
                StrategyParam::R_MAX_FUNCLAYER += 1;
            }
            else if(ringCount == StrategyParam::iterRing/25){
                StrategyParam::R_MAX_NUM += 1;
                StrategyParam::R_MAX_FUNCLAYER += 1;
            }
            else if(ringCount == StrategyParam::iterRing/10){
                //StrategyParam::R_MAX_NUM += 1;
                StrategyParam::R_MAX_FUNCLAYER += 1;
            }
            else if(ringCount == StrategyParam::iterRing/5){
                StrategyParam::R_MAX_NUM += 1;
                StrategyParam::R_MAX_FUNCLAYER += 1;
            }
            else if(ringCount == StrategyParam::iterRing/2){
                //StrategyParam::R_MAX_NUM += 1;
                StrategyParam::R_MAX_FUNCLAYER += 1;
            }
    }
    
//    for(int i=0;i<triAlg.vOnlyOutTriCmp.size();++i){
//       cout<<triAlg.vOnlyOutTriCmp[i]->claPtr->uClaId<<" ";
//   }
//   cout<<endl;
//    string str1;
//        triAlg.vOnlyOutTriCmp[0]->claPtr->toString(str1);
//        cout << "起步子句:" << str1 << endl;
    //20170215 end
    
    //1.判断loop的值,迭代是否完成
    if(loop == 0) { 
        //20170210 当所有候选子句全部参与归结时，应该清除候选子句p被动归结权重
        //20170515 将已归结完的单元子句设置成伪纯子句
        //20170830 big modify 将迭代过的起步子句加入到已归结中,试试看效果?
        if(0 &&startClause && StrategyParam::singleUseUintCla){
            if(triAlg.noCmpCla.find(startClause->uClaId) == triAlg.noCmpCla.end())
                    triAlg.noCmpCla.insert(startClause->uClaId);
        }
        shift++;
        if (shift >= size_Tri)//20170710 ==改成>=
            shift = 0;
        triAlg.flagT = true;
         //20170209此处考虑单文字子句的排放顺序
        //stable_sort(triAlg.vOnlyOutTriCmp.begin(),triAlg.vOnlyOutTriCmp.end(),SortRule::claSingCmp);
        //triAlg.setDuctCla.clear();
        
    }
    //2.得到起步子句
    UINT32 conClaPair = 0;
    UINT32 countUnit = 0;
    do{
        shiftSingleCla(triAlg.vOnlyOutTriCmp, shift);
        if(triAlg.vOnlyOutTriCmp[0]->isConLit() &&triAlg.flagT){
            conClaPair = triAlg.realUnifyCounts(fol, triAlg.vOnlyOutTriCmp[0]->claPtr);
            if (conClaPair == 0) {
                if(triAlg.noCmpCla.find(triAlg.vOnlyOutTriCmp[0]->claPtr->uClaId) == triAlg.noCmpCla.end())
                    triAlg.noCmpCla.insert(triAlg.vOnlyOutTriCmp[0]->claPtr->uClaId);
                stable_sort(triAlg.vOnlyOutTriCmp.begin() , triAlg.vOnlyOutTriCmp.end(), SortRule::singleResetId); //单元子句排序
                ++shift;
                ++countUnit;
                if (shift >= size_Tri){//20170710 ==改成>=
                    shift = 0;
                    if(countUnit == size_Tri)
                    {//表示找不到满足条件的单元子句
                        break;
                    }
                }
            }
        }
    }while(triAlg.vOnlyOutTriCmp[0]->isConLit() && (conClaPair == 0) &&triAlg.flagT);
    //3.记录起步子句
    startClause = triAlg.vOnlyOutTriCmp[0]->claPtr;
    //4.初始化本次或下次迭代
    if(triAlg.flagT)
    {
        //表示第一次迭代完成
        for (UINT32 i = 0; i < triAlg.vOnlyOutTriCmp.size(); ++i) {
            //triAlg.vOnlyOutTriCmp[0]->claPtr->isPureCla = true;
            //
            UINT32 len = triAlg.vOnlyOutTriCmp[i]->getPairPredLst()->size();
            Literal* candLitP;
            Clause* candClaP;
            vector<Literal*>* vCandLit = triAlg.vOnlyOutTriCmp[i]->getPairPredLst();
            for (UINT32 pasLitInd = 0; pasLitInd < len; ++pasLitInd)//依次找到
            {
                //cout<<"找归结子句:"<<pasLitInd<<endl;
                candLitP = vCandLit->at(pasLitInd); //候选被动归结文字
                candLitP->sDuct = candLitP->sDuct%56;//0;
                candClaP = candLitP->claPtr; // 被动归结子句（候选子句）
                candClaP->pdeductNum = candClaP->pdeductNum%36;//0; //candClaP->pdeductNum/len;  //20170216   0
            }
        }
        //迭代次数 iterTimes
        //为-1时，系统自动处理；为大于0时设置值有效；
        if(StrategyParam::iterTimes == -1){
            if(triAlg.vOnlyOutTriCmp[0]->isConLit())
                loop = conClaPair;
            else
                loop = triAlg.vOnlyOutTriCmp[0]->getPairPredLst()->size();
            triAlg.total_Loop = loop;
            
//            if(loop == 0){
//                cout<<"cf_debug"<<endl;
//            }
        }//*size_Tri;20170807 此处的权重需要重点考虑vOnlyOutTriCmp[0]是否有问题
        else{
            loop = StrategyParam::iterTimes;
            triAlg.total_Loop = loop;
        }
        triAlg.flagT = false;
        //20170826 恢复初始的归结式文字和嵌套层数
//        StrategyParam::R_MAX_FUNCLAYER = StrategyParam::R_MAX_FUNCLAYER_TMP;
//        StrategyParam::R_MAX_NUM = StrategyParam::R_MAX_NUM_TMP;
    }
   //20170215 根据单元子句集的权重进行排序
//   for(int i=0;i<triAlg.vOnlyOutTriCmp.size();++i){
//       cout<<triAlg.vOnlyOutTriCmp[i]->claPtr->uClaId<<" ";
//   }
//   cout<<endl;
   //将单元子句分成两段，原始子句优先 将loop拆成多少份来进行排序,保证每组都固定一个顺序
    if ((triAlg.vOnlyOutTriCmp.size() > 2)) {
        if(StrategyParam::useSaturate){
            stable_sort(triAlg.vOnlyOutTriCmp.begin()+1, triAlg.vOnlyOutTriCmp.end(), SortRule::claSingCmp);
        }
        else{
            if (StrategyParam::unitSortRule == 0) {
                if(fol.uOrigClaSingleSize == 0){
                    stable_sort(triAlg.vOnlyOutTriCmp.begin() + 1, triAlg.vOnlyOutTriCmp.begin() + triAlg.vOnlyOutTriCmp.size(), SortRule::claSingCmp); //单元子句排序
                }
                else
                    stable_sort(triAlg.vOnlyOutTriCmp.begin() + 1, triAlg.vOnlyOutTriCmp.begin() + fol.uOrigClaSingleSize, SortRule::claSingCmp); //单元子句排序
            } else if (StrategyParam::unitSortRule == 1) {
                if(fol.uOrigClaSingleSize == 0){
                    stable_sort(triAlg.vOnlyOutTriCmp.begin() + 1, triAlg.vOnlyOutTriCmp.begin() + triAlg.vOnlyOutTriCmp.size(), SortRule::claSingCmp); //单元子句排序
                }
                else
                    stable_sort(triAlg.vOnlyOutTriCmp.begin() + 1, triAlg.vOnlyOutTriCmp.begin() + fol.uOrigClaSingleSize, SortRule::claSingCmp); //单元子句排序
                if (triAlg.vOnlyOutTriCmp.size() > fol.uOrigClaSingleSize)
                    stable_sort(triAlg.vOnlyOutTriCmp.begin() + fol.uOrigClaSingleSize, triAlg.vOnlyOutTriCmp.end(), SortRule::claSingCmp); //单元子句排序 20170816  claSingGenCmp->claSingCmp
            } else if (StrategyParam::unitSortRule == 2) {
                stable_sort(triAlg.vOnlyOutTriCmp.begin() + 1, triAlg.vOnlyOutTriCmp.end(), SortRule::claSingCmpComplex); //单元子句排序  20170816  claSingGenCmp->claSingCmpComplex
            } else  if (StrategyParam::unitSortRule == 3){
                stable_sort(triAlg.vOnlyOutTriCmp.begin() + 1, triAlg.vOnlyOutTriCmp.end(), SortRule::claSingGenCmpNeg); //目标子句排序  20170816  claSingGenCmpNeg->claSingCmpGoal
            }else if (StrategyParam::unitSortRule == 4) {
                stable_sort(triAlg.vOnlyOutTriCmp.begin() + 1, triAlg.vOnlyOutTriCmp.end(), SortRule::claSingCmpPairSizeInc); //单元子句排序  20170816  claSingGenCmp->claSingCmpComplex
            }else if (StrategyParam::unitSortRule == 5) {
                stable_sort(triAlg.vOnlyOutTriCmp.begin() + 1, triAlg.vOnlyOutTriCmp.end(), SortRule::claSingCmpPairSizeDec); //单元子句排序  20170816  claSingGenCmp->claSingCmpComplex claSingCmpVarSzie
            }else if (StrategyParam::unitSortRule == 6) {
                stable_sort(triAlg.vOnlyOutTriCmp.begin() + 1, triAlg.vOnlyOutTriCmp.end(), SortRule::claSingCmpVarSzie); //单元子句排序  20170816  claSingGenCmp->claSingCmpComplex claSingCmpVarSzie
            }else if (StrategyParam::unitSortRule == 7) {
                stable_sort(triAlg.vOnlyOutTriCmp.begin() + 1, triAlg.vOnlyOutTriCmp.end(), SortRule::claSingCmpVarSzieDec); //单元子句排序  20170816  claSingGenCmp->claSingCmpComplex claSingCmpVarSzie
            }
            else if (StrategyParam::unitSortRule == 8) {
                stable_sort(triAlg.vOnlyOutTriCmp.begin() + 1, triAlg.vOnlyOutTriCmp.end(), SortRule::claSingCmpGenCla); //单元子句排序  20170816  claSingGenCmp->claSingCmpComplex claSingCmpVarSzie
            }
        }
        
//        //stable_sort(triAlg.vOnlyOutTriCmp.begin() + 1, triAlg.vOnlyOutTriCmp.end(), SortRule::claSingCmp);//单元子句排序
//        clock_t end = clock();
//        double time_s = (double) (end - start) / (double) CLOCKS_PER_SEC;
//        //时间限制 单位:分钟
//        if (time_s < StrategyParam::timeLimit * 50)//200   3  1分钟 15  5分钟   30  15分钟  end:300
//        {
//             stable_sort(triAlg.vOnlyOutTriCmp.begin() + 1, triAlg.vOnlyOutTriCmp.begin() + fol.uOrigClaSingleSize, SortRule::claSingCmp); //单元子句排序
//            if (triAlg.vOnlyOutTriCmp.size() > fol.uOrigClaSingleSize)
//                stable_sort(triAlg.vOnlyOutTriCmp.begin() + fol.uOrigClaSingleSize, triAlg.vOnlyOutTriCmp.end(), SortRule::claSingGenCmp); //单元子句排序
//        }
//        else
//            stable_sort(triAlg.vOnlyOutTriCmp.begin() + 1, triAlg.vOnlyOutTriCmp.end(), SortRule::claSingGenCmp); //单元子句排序
    }
    
    //cout<<"开始的单文字子句个数:"<<size_Tri<<endl;
    //调换顺序
   if(chooseTri)//两种三角形方法协调
        loop--;
    //shiftSingleCla(triAlg.vOnlyOutTriCmp, shift);
    
    
    //20170215  单元子句集主动归结权重清零 自行设定条件
    if (StrategyParam::unitDeductTimesUpdate == 0) {//20170224单元子句归结次数更新策略
        //0:系统自动处理 1:迭代1次更新 2:迭代完成更新
        //3:轮数1次更新 4:轮数完成更新

        for (UINT32 k = 0; k < size_Tri; k++) {
            //20170224 单元子句归结次数最大值策略
            if (StrategyParam::unitDeductTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
            {
                if (triAlg.vOnlyOutTriCmp[k]->claPtr->adeductNum > StrategyParam::unitDeductTimes) {
                    triAlg.vOnlyOutTriCmp[k]->claPtr->adeductNum = 0;
                }
            }
            if (loop == 0) {
                triAlg.vOnlyOutTriCmp[k]->claPtr->adeductNum = (triAlg.vOnlyOutTriCmp[k]->claPtr->adeductNum * 2) % StrategyParam::iterTimes;//20170823 size_Tri;//20170807 0;//triAlg.vOnlyOutTriCmp[k]->claPtr->adeductNum / size_Tri; //20170216  50
            }
        }
    }
    else if(StrategyParam::unitDeductTimesUpdate == 1)
    {
        for (UINT32 k = 0; k < size_Tri; k++) {
                //20170224 单元子句归结次数最大值策略
                if (StrategyParam::unitDeductTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
                {
                    if (triAlg.vOnlyOutTriCmp[k]->claPtr->adeductNum > StrategyParam::unitDeductTimes) {
                        triAlg.vOnlyOutTriCmp[k]->claPtr->adeductNum = 0;
                    }
                }
                 if (loop == 0)
                    triAlg.vOnlyOutTriCmp[k]->claPtr->adeductNum =  (triAlg.vOnlyOutTriCmp[k]->claPtr->adeductNum * 3) % StrategyParam::iterTimes;//20170823 size_Tri;//20170807 triAlg.vOnlyOutTriCmp[k]->claPtr->adeductNum / size_Tri; //20170216  50
            }
    }
    else
    {
        for (UINT32 k = 0; k < size_Tri; k++) {
                //20170224 单元子句归结次数最大值策略
                if (StrategyParam::unitDeductTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
                {
                    if (triAlg.vOnlyOutTriCmp[k]->claPtr->adeductNum > StrategyParam::unitDeductTimes) {
                        triAlg.vOnlyOutTriCmp[k]->claPtr->adeductNum = 0;
                    }
                }
                 if ((shift >= size_Tri -1) && (loop == 0))//20170807 = ==
                    triAlg.vOnlyOutTriCmp[k]->claPtr->adeductNum = (triAlg.vOnlyOutTriCmp[k]->claPtr->adeductNum) % StrategyParam::iterTimes; //20170216  50
            }
    }
    //20170215
    //20170215  单元子句集主动归结权重清零 自行设定条件
    //单元子句冗余次数最大值策略
    //为-1时，系统自动处理；为大于0时设置值有效；
    if (StrategyParam::unitReduntTimesUpdate == 0) {//20170224单元子句归结次数更新策略
        //0:系统自动处理 1:迭代1次更新 2:迭代完成更新
        //3:轮数1次更新 4:轮数完成更新

        for (UINT32 k = 0; k < size_Tri; k++) {
            //20170224 单元子句归结次数最大值策略
            if (StrategyParam::unitReduntTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
            {
                if (triAlg.vOnlyOutTriCmp[k]->claPtr->reduntTimes > StrategyParam::unitReduntTimes) {
                    triAlg.vOnlyOutTriCmp[k]->claPtr->reduntTimes = 0;
                }
            }
            if (loop==0) {
                triAlg.vOnlyOutTriCmp[k]->claPtr->reduntTimes = triAlg.vOnlyOutTriCmp[k]->claPtr->reduntTimes % 200;//20170823 size_Tri; //20170807 0;//triAlg.vOnlyOutTriCmp[k]->claPtr->reduntTimes / size_Tri; //20170216  50
            }
        }
    }
    else if(StrategyParam::unitReduntTimesUpdate == 1)
    {
        for (UINT32 k = 0; k < size_Tri; k++) {
                //20170224 单元子句归结次数最大值策略
                if (StrategyParam::unitReduntTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
                {
                    if (triAlg.vOnlyOutTriCmp[k]->claPtr->reduntTimes > StrategyParam::unitReduntTimes) {
                        triAlg.vOnlyOutTriCmp[k]->claPtr->reduntTimes = 0;
                    }
                }
                 if (loop == 0)
                    triAlg.vOnlyOutTriCmp[k]->claPtr->reduntTimes = triAlg.vOnlyOutTriCmp[k]->claPtr->reduntTimes % 300;//20170823size_Tri; //20170807 triAlg.vOnlyOutTriCmp[k]->claPtr->reduntTimes / size_Tri; //20170216  50
            }
    }
    else
    {
        for (UINT32 k = 0; k < size_Tri; k++) {
                //20170224 单元子句归结次数最大值策略
                if (StrategyParam::unitReduntTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
                {
                    if (triAlg.vOnlyOutTriCmp[k]->claPtr->reduntTimes > StrategyParam::unitReduntTimes) {
                        triAlg.vOnlyOutTriCmp[k]->claPtr->reduntTimes = 0;
                    }
                }
                 if ((shift >= size_Tri -1) && (loop == 0))
                    triAlg.vOnlyOutTriCmp[k]->claPtr->reduntTimes = triAlg.vOnlyOutTriCmp[k]->claPtr->reduntTimes / 500; //20170216  50
            }
    }
    //20170209 //候选子句归结次数最大值策略
    if (StrategyParam::candDeductTimesUpdate == 0) {//20170224
        //0:系统自动处理 1:迭代1次更新 2:迭代完成更新
        //3:轮数1次更新 4:轮数完成更新
        for (auto& clapE : fol.setEnq) {
            //20170224 单元子句归结次数最大值策略
            if (StrategyParam::candDeductTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
            {
                if (clapE->pdeductNum > StrategyParam::unitDeductTimes) {
                    clapE->pdeductNum = 0;
                }
            }
            if (loop == 0 ) {
                clapE->pdeductNum = (clapE->pdeductNum*2)%StrategyParam::iterTimes;//0;//clapE->pdeductNum / size_Tri; //20170216  50
            }
        }
        for (auto& clapE : fol.setCla) {
            //20170224 单元子句归结次数最大值策略
            if (StrategyParam::candDeductTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
            {
                if (clapE->pdeductNum > StrategyParam::unitDeductTimes) {
                    clapE->pdeductNum = 0;
                }
            }
            //20170807
//            if (loop % size_Tri) {
//                clapE->pdeductNum = clapE->pdeductNum / size_Tri; //20170216  50
//            }
            if (loop ==0 ) {
                clapE->pdeductNum = (clapE->pdeductNum*2)%StrategyParam::iterTimes;//0; //20170807
            }
        }
    }
    else if (StrategyParam::candDeductTimesUpdate == 1) {//20170224
        //0:系统自动处理 1:迭代1次更新 2:迭代完成更新
        //3:轮数1次更新 4:轮数完成更新
        for (auto& clapE : fol.setEnq) {
            //20170224 单元子句归结次数最大值策略
            if (StrategyParam::candDeductTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
            {
                if (clapE->pdeductNum > StrategyParam::unitDeductTimes) {
                    clapE->pdeductNum = 0;
                }
            }
            if (loop == 0) {
                clapE->pdeductNum = (clapE->pdeductNum*6)%StrategyParam::iterTimes;//0; //20170807 clapE->pdeductNum / size_Tri; //20170216  50
            }
        }
        for (auto& clapE : fol.setCla) {
            //20170224 单元子句归结次数最大值策略
            if (StrategyParam::candDeductTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
            {
                if (clapE->pdeductNum > StrategyParam::unitDeductTimes) {
                    clapE->pdeductNum = 0;
                }
            }
            if (loop == 0) {
                clapE->pdeductNum = (clapE->pdeductNum*6)%StrategyParam::iterTimes;//0; //20170807 clapE->pdeductNum / size_Tri; //20170216  50
            }
        }
    }
    else
     {//20170224
        //0:系统自动处理 1:迭代1次更新 2:迭代完成更新
        //3:轮数1次更新 4:轮数完成更新
        for (auto& clapE : fol.setEnq) {
            //20170224 单元子句归结次数最大值策略
            if (StrategyParam::candDeductTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
            {
                if (clapE->pdeductNum > StrategyParam::unitDeductTimes) {
                    clapE->pdeductNum = 0;
                }
            }
            if ((shift >= size_Tri -1) && (loop == 0)) {
                clapE->pdeductNum = clapE->pdeductNum %StrategyParam::iterTimes; //20170216  50
            }
        }
        for (auto& clapE : fol.setCla) {
            //20170224 单元子句归结次数最大值策略
            if (StrategyParam::candDeductTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
            {
                if (clapE->pdeductNum > StrategyParam::unitDeductTimes) {
                    clapE->pdeductNum = 0;
                }
            }
            if ((shift >= size_Tri -1) && (loop == 0))  {
                clapE->pdeductNum = clapE->pdeductNum%StrategyParam::iterTimes; //20170216  50
            }
        }
    }
    //候选子句冗余次数最大值策略
    //为-1时，系统自动处理；为大于0时设置值有效；
     if (StrategyParam::candReduntTimesUpdate == 0) {//20170224
        //0:系统自动处理 1:迭代1次更新 2:迭代完成更新
        //3:轮数1次更新 4:轮数完成更新
        for (auto& clapE : fol.setEnq) {
            //20170224 单元子句归结次数最大值策略
            if (StrategyParam::candReduntTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
            {
                if (clapE->reduntTimes > StrategyParam::candReduntTimes) {
                    clapE->reduntTimes = 0;
                }
            }
            if (loop == 0) {
                clapE->reduntTimes = clapE->reduntTimes%50;//0;//clapE->reduntTimes / size_Tri; //20170216  50
            }
        }
        for (auto& clapE : fol.setCla) {
            //20170224 单元子句归结次数最大值策略
            if (StrategyParam::candReduntTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
            {
                if (clapE->reduntTimes > StrategyParam::candReduntTimes) {
                    clapE->reduntTimes = 0;
                }
            }
            //20170807
//            if (loop % size_Tri) {
//                clapE->reduntTimes = clapE->reduntTimes / size_Tri; //20170216  50
//            }
             if (loop ==0 ) {
                clapE->reduntTimes =clapE->reduntTimes%50;//0; //20170807
            }
        }
    }
     else if (StrategyParam::candReduntTimesUpdate == 1) {//20170224
        //0:系统自动处理 1:迭代1次更新 2:迭代完成更新
        //3:轮数1次更新 4:轮数完成更新
        for (auto& clapE : fol.setEnq) {
            //20170224 单元子句归结次数最大值策略
            if (StrategyParam::candReduntTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
            {
                if (clapE->reduntTimes > StrategyParam::candReduntTimes) {
                    clapE->reduntTimes = 0;
                }
            }
            if (loop == 0) {
                clapE->reduntTimes = clapE->reduntTimes%25;//0; //20170807 clapE->reduntTimes / size_Tri; //20170216  50
            }
        }
        for (auto& clapE : fol.setCla) {
            //20170224 单元子句归结次数最大值策略
            if (StrategyParam::candReduntTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
            {
                if (clapE->reduntTimes > StrategyParam::candReduntTimes) {
                    clapE->reduntTimes = 0;
                }
            }
            if (loop == 0) {
                clapE->reduntTimes = clapE->reduntTimes%25;//0; //20170807 clapE->reduntTimes / size_Tri; //20170216  50
            }
        }
    }
    else
    {
        for (auto& clapE : fol.setEnq) {
            //20170224 单元子句归结次数最大值策略
            if (StrategyParam::candReduntTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
            {
                if (clapE->reduntTimes > StrategyParam::candReduntTimes) {
                    clapE->reduntTimes = 0;
                }
            }
            if ((shift >= size_Tri -1) && (loop ==0)) {
                clapE->reduntTimes = clapE->reduntTimes %100; //20170216  50
            }
        }
        for (auto& clapE : fol.setCla) {
            //20170224 单元子句归结次数最大值策略
            if (StrategyParam::candReduntTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
            {
                if (clapE->reduntTimes > StrategyParam::candReduntTimes) {
                    clapE->reduntTimes = 0;
                }
            }
            if ((shift >= size_Tri -1) && (loop == 0)) {
                clapE->reduntTimes = clapE->reduntTimes %100; //20170216  50
            }
        }
    }
    for (UINT32 k = 0; k < size_Tri; k++) {
        //E(X1,X1)不添加到vOnlyOutTri进行演绎
//        if (TEqn == GetCodeProp(triAlg.vOnlyOutTriCmp[k]->subTerm->iTermCode)) //正文字等词检查是否恒真
//        {
//            if (triAlg.unify.CheckEqn(triAlg.vOnlyOutTriCmp[k]->subTerm->subTermPtr[0], triAlg.vOnlyOutTriCmp[k]->subTerm->subTermPtr[1]) && triAlg.vOnlyOutTriCmp[k]->subTerm->subTermPtr[0]->isVar()) {
//                continue;
//            }
//        }
        triAlg.vOnlyOutTri.push_back(triAlg.vOnlyOutTriCmp[k]);
        triAlg.vOutTri.push_back(triAlg.vOnlyOutTriCmp[k]);
    }
    return Succes;
}

//20170915 用于从左到右构建三角形
RESULT Resolution::InsertOutTriLR(TriAlg& triAlg,Formula& fol,UINT16& loop,bool chooseTri)
{
    string str;
   // cout<<setSinleUse.size()<<endl;
    vector<Literal*> singleUintLit;
    singleUintLit.reserve(16);
    for(auto& clap:fol.setSingleCla)
    //for(auto& clap:setSinleUse)
    {
        if(clap->uLitNum > 1)
            return fail;
        //clap->isSDeduct = false;//对角线子句初始化未归结
        //triAlg.vOnlyOutTri.push_back(clap->LitPtr[0]);
        //triAlg.vOutTri.push_back(clap->LitPtr[0]);
//        string str;
//        clap->toString(str);
//        cout << "起步子句:" << str << endl;
        if(clap->isGoal)
            triAlg.vOnlyOutTriCmp.push_back(clap->LitPtr[0]);
        else
            singleUintLit.push_back(clap->LitPtr[0]);
//        if(clap->LitPtr[0]->subTerm->isNegEqnTerm())
//            swap(triAlg.vOnlyOutTriCmp[0],triAlg.vOnlyOutTriCmp[triAlg.vOnlyOutTriCmp.size()-1]);
        //clap->toString(str);
        //*FileOp::ofRealInfoOut << str << endl;  
    }
    //20170909 将不是目标子句的单元子句加入列表中
    if(singleUintLit.size() > 0){
        for(UINT32 id = 0; id < singleUintLit.size(); ++ id){
            triAlg.vOnlyOutTriCmp.push_back(singleUintLit[id]);
        }
    }
    singleUintLit.clear();
    vector<Literal*>().swap(singleUintLit);
    //cout<<triAlg.vOnlyOutTri.size()<<" "<<triAlg.vOutTri.size()<<endl;
   /* if( triAlg.vOnlyOutTriCmp.size() > 1)
    {
        if(1)//int(rand()) % 2 != int(rand()) % 2)
            stable_sort(triAlg.vOnlyOutTriCmp.begin(), triAlg.vOnlyOutTriCmp.end(), SortRule::claSingCmp);
        else
            stable_sort(triAlg.vOnlyOutTriCmp.begin(), triAlg.vOnlyOutTriCmp.end(), SortRule::claSingCmpRand);
    }*/  
    
    //20170112 使对角线单文字子句能够排序,即选择的策略不一样。
    UINT32 size_Tri = triAlg.vOnlyOutTriCmp.size();//当前单元子句的大小
    //cout<<triAlg.vOnlyOutTriCmp.size()<<endl;
    //20170210 计算每个单文字子句有多少个互补的子句，用于计算构建多少个三角形，且只计算1次
//      for (int i = 0; i < triAlg.vOnlyOutTriCmp.size(); ++i) {
//        cout << triAlg.vOnlyOutTriCmp[i]->claPtr->uClaId << " ";
//    }
//    cout << endl;
    
    //每次shift更新（即++，或归零）都要确定起步子句C，初始化下次迭代的loop，然后以C作为起步子句构建三角形数需要达到loop个来完成1次迭代，完成后才能再次更新shift
    //当shift增加到单元子句数量(即每个单元子句都迭代了1次），即完成了1轮迭代
    //1次迭代 = （以子句C起步）loop个三角形的构建；1次迭代完成后，需要准备下次迭代：更新shift++，初始化下次迭代的loop值
    //1轮迭代 = size_Tri(单元子句个数）次迭代 = size_Tri * loop 个三角形的构建；1轮迭代完成后，需要准备下轮迭代：shift归零
    //注意：策略中的“迭代次数”不等于上面的迭代次数，策略中的“迭代次数”就是上面所说的loop（1次迭代构建的三角形个数）
    if (shift >= size_Tri){//20170710 ==改成>=  StrategyParam::iterRing
            shift = 0;
            ringCount++;
            if(ringCount % 3)
                triAlg.noCmpCla.clear();
            if(ringCount == StrategyParam::iterRing/100){
                StrategyParam::R_MAX_NUM += 1;
                StrategyParam::R_MAX_FUNCLAYER += 1;
            }
            else if(ringCount == StrategyParam::iterRing/50){
                //StrategyParam::R_MAX_NUM += 1;
                StrategyParam::R_MAX_FUNCLAYER += 1;
            }
            else if(ringCount == StrategyParam::iterRing/25){
                StrategyParam::R_MAX_NUM += 1;
                StrategyParam::R_MAX_FUNCLAYER += 1;
            }
            else if(ringCount == StrategyParam::iterRing/10){
                //StrategyParam::R_MAX_NUM += 1;
                StrategyParam::R_MAX_FUNCLAYER += 1;
            }
            else if(ringCount == StrategyParam::iterRing/5){
                StrategyParam::R_MAX_NUM += 1;
                StrategyParam::R_MAX_FUNCLAYER += 1;
            }
            else if(ringCount == StrategyParam::iterRing/2){
                //StrategyParam::R_MAX_NUM += 1;
                StrategyParam::R_MAX_FUNCLAYER += 1;
            }
    }
    
//    for(int i=0;i<triAlg.vOnlyOutTriCmp.size();++i){
//       cout<<triAlg.vOnlyOutTriCmp[i]->claPtr->uClaId<<" ";
//   }
//   cout<<endl;
//    string str1;
//        triAlg.vOnlyOutTriCmp[0]->claPtr->toString(str1);
//        cout << "起步子句:" << str1 << endl;
    //20170215 end
    
    //1.判断loop的值,迭代是否完成
    if(loop == 0) { 
        //20170210 当所有候选子句全部参与归结时，应该清除候选子句p被动归结权重
        //20170515 将已归结完的单元子句设置成伪纯子句
        //20170830 big modify 将迭代过的起步子句加入到已归结中,试试看效果?
//        if(0 &&startClause && StrategyParam::singleUseUintCla){
//            if(triAlg.noCmpCla.find(startClause->uClaId) == triAlg.noCmpCla.end())
//                    triAlg.noCmpCla.insert(startClause->uClaId);
//        }
        shift++;
        if (shift >= size_Tri)//20170710 ==改成>=
            shift = 0;
        triAlg.flagT = true;
         //20170209此处考虑单文字子句的排放顺序
        //stable_sort(triAlg.vOnlyOutTriCmp.begin(),triAlg.vOnlyOutTriCmp.end(),SortRule::claSingCmp);
        //triAlg.setDuctCla.clear();
        
    }
    //2.得到起步子句
    UINT32 conClaPair = 0;
    UINT32 countUnit = 0;
    do{
        shiftSingleCla(triAlg.vOnlyOutTriCmp, shift);
        if(triAlg.vOnlyOutTriCmp[0]->isConLit() &&triAlg.flagT){
            conClaPair = triAlg.realUnifyCounts(fol, triAlg.vOnlyOutTriCmp[0]->claPtr); //得到vOnlyOutTriCmp[0]所在单元子句合一互补的子句数
            if (conClaPair == 0) {
                if(triAlg.noCmpCla.find(triAlg.vOnlyOutTriCmp[0]->claPtr->uClaId) == triAlg.noCmpCla.end())
                    triAlg.noCmpCla.insert(triAlg.vOnlyOutTriCmp[0]->claPtr->uClaId);
                stable_sort(triAlg.vOnlyOutTriCmp.begin() , triAlg.vOnlyOutTriCmp.end(), SortRule::singleResetId); //单元子句排序
                ++shift;
                ++countUnit;
                if (shift >= size_Tri){//20170710 ==改成>=
                    shift = 0;
                    if(countUnit == size_Tri)
                    {//表示找不到满足条件的单元子句
                        break;
                    }
                }
            }
        }
    }while(triAlg.vOnlyOutTriCmp[0]->isConLit() && (conClaPair == 0) &&triAlg.flagT);
    //3.记录起步子句
    startClause = triAlg.vOnlyOutTriCmp[0]->claPtr;
    //4.初始化本次或下次迭代
    if(triAlg.flagT)
    {
        //表示第一次迭代完成
//        for (UINT32 i = 0; i < triAlg.vOnlyOutTriCmp.size(); ++i) {
//            //triAlg.vOnlyOutTriCmp[0]->claPtr->isPureCla = true;
//            //
//            UINT32 len = triAlg.vOnlyOutTriCmp[i]->getPairPredLst()->size();
//            Literal* candLitP;
//            Clause* candClaP;
//            vector<Literal*>* vCandLit = triAlg.vOnlyOutTriCmp[i]->getPairPredLst();
//            for (UINT32 pasLitInd = 0; pasLitInd < len; ++pasLitInd)//依次找到
//            {
//                //cout<<"找归结子句:"<<pasLitInd<<endl;
//                candLitP = vCandLit->at(pasLitInd); //候选被动归结文字
//                candLitP->sDuct = 0;
//                candClaP = candLitP->claPtr; // 被动归结子句（候选子句）
//                candClaP->pdeductNum = 0; //candClaP->pdeductNum/len;  //20170216   0
//            }
//        }
        //迭代次数 iterTimes
        //为-1时，系统自动处理；为大于0时设置值有效；
        if(StrategyParam::iterTimes == -1){
            if(triAlg.vOnlyOutTriCmp[0]->isConLit())
                loop = conClaPair;
            else
                loop = triAlg.vOnlyOutTriCmp[0]->getPairPredLst()->size();
            triAlg.total_Loop = loop;
            
//            if(loop == 0){
//                cout<<"cf_debug"<<endl;
//            }
        }//*size_Tri;20170807 此处的权重需要重点考虑vOnlyOutTriCmp[0]是否有问题
        else{
            loop = StrategyParam::iterTimes;
            triAlg.total_Loop = loop;
        }
        triAlg.flagT = false;
        //20170826 恢复初始的归结式文字和嵌套层数
//        StrategyParam::R_MAX_FUNCLAYER = StrategyParam::R_MAX_FUNCLAYER_TMP;
//        StrategyParam::R_MAX_NUM = StrategyParam::R_MAX_NUM_TMP;
    }
   //20170215 根据单元子句集的权重进行排序
//   for(int i=0;i<triAlg.vOnlyOutTriCmp.size();++i){
//       cout<<triAlg.vOnlyOutTriCmp[i]->claPtr->uClaId<<" ";
//   }
//   cout<<endl;
   //将单元子句分成两段，原始子句优先
    if ((triAlg.vOnlyOutTriCmp.size() > 2)) {
         if(StrategyParam::useSaturate){
            stable_sort(triAlg.vOnlyOutTriCmp.begin()+1, triAlg.vOnlyOutTriCmp.end(), SortRule::claSingCmp);
        }
         else{
             //问题待修复Liu: 单元子句的排序规则完全是一样的，(claSingCmpcla, SingCmpComplex, claSingGenCmpNeg, ...等都是相同的规则)
             if (StrategyParam::unitSortRule == 0) {
                stable_sort(triAlg.vOnlyOutTriCmp.begin() + 1, triAlg.vOnlyOutTriCmp.begin() + fol.uOrigClaSingleSize, SortRule::claSingCmp); //单元子句排序
            } else if (StrategyParam::unitSortRule == 1) {
                stable_sort(triAlg.vOnlyOutTriCmp.begin() + 1, triAlg.vOnlyOutTriCmp.begin() + fol.uOrigClaSingleSize, SortRule::claSingCmp); //单元子句排序
                if (triAlg.vOnlyOutTriCmp.size() > fol.uOrigClaSingleSize)
                    stable_sort(triAlg.vOnlyOutTriCmp.begin() + fol.uOrigClaSingleSize, triAlg.vOnlyOutTriCmp.end(), SortRule::claSingCmp); //单元子句排序 20170816  claSingGenCmp->claSingCmp
            } else if (StrategyParam::unitSortRule == 2) {
                stable_sort(triAlg.vOnlyOutTriCmp.begin() + 1, triAlg.vOnlyOutTriCmp.end(), SortRule::claSingCmpComplex); //单元子句排序  20170816  claSingGenCmp->claSingCmpComplex
            } else if (StrategyParam::unitSortRule == 3){
                stable_sort(triAlg.vOnlyOutTriCmp.begin() + 1, triAlg.vOnlyOutTriCmp.end(), SortRule::claSingGenCmpNeg); //目标子句排序  20170816  claSingGenCmpNeg->claSingCmpGoal
            }else if (StrategyParam::unitSortRule == 4) {
                stable_sort(triAlg.vOnlyOutTriCmp.begin() + 1, triAlg.vOnlyOutTriCmp.end(), SortRule::claSingCmpPairSizeInc); //单元子句排序  20170816  claSingGenCmp->claSingCmpComplex
            }else if (StrategyParam::unitSortRule == 5) {
                stable_sort(triAlg.vOnlyOutTriCmp.begin() + 1, triAlg.vOnlyOutTriCmp.end(), SortRule::claSingCmpPairSizeDec); //单元子句排序  20170816  claSingGenCmp->claSingCmpComplex
            }else if (StrategyParam::unitSortRule == 6) {
                stable_sort(triAlg.vOnlyOutTriCmp.begin() + 1, triAlg.vOnlyOutTriCmp.end(), SortRule::claSingCmpVarSzie); //单元子句排序  20170816  claSingGenCmp->claSingCmpComplex claSingCmpVarSzie
            }else if (StrategyParam::unitSortRule == 7) {
                stable_sort(triAlg.vOnlyOutTriCmp.begin() + 1, triAlg.vOnlyOutTriCmp.end(), SortRule::claSingCmpVarSzieDec); //单元子句排序  20170816  claSingGenCmp->claSingCmpComplex claSingCmpVarSzie
            }
            else if (StrategyParam::unitSortRule == 8) {
                stable_sort(triAlg.vOnlyOutTriCmp.begin() + 1, triAlg.vOnlyOutTriCmp.end(), SortRule::claSingCmpGenCla); //单元子句排序  20170816  claSingGenCmp->claSingCmpComplex claSingCmpVarSzie
            }
         }
        
//        //stable_sort(triAlg.vOnlyOutTriCmp.begin() + 1, triAlg.vOnlyOutTriCmp.end(), SortRule::claSingCmp);//单元子句排序
//        clock_t end = clock();
//        double time_s = (double) (end - start) / (double) CLOCKS_PER_SEC;
//        //时间限制 单位:分钟
//        if (time_s < StrategyParam::timeLimit * 50)//200   3  1分钟 15  5分钟   30  15分钟  end:300
//        {
//             stable_sort(triAlg.vOnlyOutTriCmp.begin() + 1, triAlg.vOnlyOutTriCmp.begin() + fol.uOrigClaSingleSize, SortRule::claSingCmp); //单元子句排序
//            if (triAlg.vOnlyOutTriCmp.size() > fol.uOrigClaSingleSize)
//                stable_sort(triAlg.vOnlyOutTriCmp.begin() + fol.uOrigClaSingleSize, triAlg.vOnlyOutTriCmp.end(), SortRule::claSingGenCmp); //单元子句排序
//        }
//        else
//            stable_sort(triAlg.vOnlyOutTriCmp.begin() + 1, triAlg.vOnlyOutTriCmp.end(), SortRule::claSingGenCmp); //单元子句排序
    }
    
    //cout<<"开始的单文字子句个数:"<<size_Tri<<endl;
    //调换顺序
   if(chooseTri)//两种三角形方法协调
        loop--;
    //shiftSingleCla(triAlg.vOnlyOutTriCmp, shift);
    
    //20170215  单元子句集主动归结权重清零 自行设定条件
    if (StrategyParam::unitDeductTimesUpdate == 0) {//20170224单元子句归结次数更新策略
        //0:系统自动处理 1:迭代1次更新 2:迭代完成更新
        //3:轮数1次更新 4:轮数完成更新

        for (UINT32 k = 0; k < size_Tri; k++) {
            //20170224 单元子句归结次数最大值策略
            if (StrategyParam::unitDeductTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
            {
                if (triAlg.vOnlyOutTriCmp[k]->claPtr->adeductNum > StrategyParam::unitDeductTimes) {
                    triAlg.vOnlyOutTriCmp[k]->claPtr->adeductNum = 0;
                }
            }
            if (loop == 0) {
                triAlg.vOnlyOutTriCmp[k]->claPtr->adeductNum = triAlg.vOnlyOutTriCmp[k]->claPtr->adeductNum % 500;//255;//20170823 size_Tri;//20170807 0;//triAlg.vOnlyOutTriCmp[k]->claPtr->adeductNum / size_Tri; //20170216  50
            }
        }
    }
    else if(StrategyParam::unitDeductTimesUpdate == 1)
    {
        for (UINT32 k = 0; k < size_Tri; k++) {
            //20170224 单元子句归结次数最大值策略
            if (StrategyParam::unitDeductTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
            {
                if (triAlg.vOnlyOutTriCmp[k]->claPtr->adeductNum > StrategyParam::unitDeductTimes) {
                    triAlg.vOnlyOutTriCmp[k]->claPtr->adeductNum = 0;
                }
            }
            if (loop == 0) {  //起步子句C作为起步子句构建三角形个数达到loop个，更新单元子句归结次数
                triAlg.vOnlyOutTriCmp[k]->claPtr->adeductNum =  triAlg.vOnlyOutTriCmp[k]->claPtr->adeductNum % 500;//255;//20170823 size_Tri;//20170807 triAlg.vOnlyOutTriCmp[k]->claPtr->adeductNum / size_Tri; //20170216  50
            }
        }
    }
    else
    {
        for (UINT32 k = 0; k < size_Tri; k++) {
            //20170224 单元子句归结次数最大值策略
            if (StrategyParam::unitDeductTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
            {
                if (triAlg.vOnlyOutTriCmp[k]->claPtr->adeductNum > StrategyParam::unitDeductTimes) {
                    triAlg.vOnlyOutTriCmp[k]->claPtr->adeductNum = 0;
                }
            }
            //所有单元子句都作为起步子句C作为起步子句构建三角形个数达到loop个，更新单元子句归结次数
            if ((shift >= size_Tri -1) && (loop == 0))//20170807 = ==
                    triAlg.vOnlyOutTriCmp[k]->claPtr->adeductNum = triAlg.vOnlyOutTriCmp[k]->claPtr->adeductNum / size_Tri;//zheng / size_Tri; //20170216  50
        }
    }
    //20170215
    //20170215  单元子句集主动归结权重清零 自行设定条件
    //单元子句冗余次数最大值策略
    //为-1时，系统自动处理；为大于0时设置值有效；
    if (StrategyParam::unitReduntTimesUpdate == 0) {//20170224单元子句归结次数更新策略
        //0:系统自动处理 1:迭代1次更新 2:迭代完成更新
        //3:轮数1次更新 4:轮数完成更新

        for (UINT32 k = 0; k < size_Tri; k++) {
            //20170224 单元子句归结次数最大值策略
            if (StrategyParam::unitReduntTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
            {
                if (triAlg.vOnlyOutTriCmp[k]->claPtr->reduntTimes > StrategyParam::unitReduntTimes) {
                    triAlg.vOnlyOutTriCmp[k]->claPtr->reduntTimes = 0;
                }
            }
            if (loop==0) {
                triAlg.vOnlyOutTriCmp[k]->claPtr->reduntTimes = triAlg.vOnlyOutTriCmp[k]->claPtr->reduntTimes % 500;//100;//20170823 size_Tri; //20170807 0;//triAlg.vOnlyOutTriCmp[k]->claPtr->reduntTimes / size_Tri; //20170216  50
            }
        }
    }
    else if(StrategyParam::unitReduntTimesUpdate == 1)
    {
        for (UINT32 k = 0; k < size_Tri; k++) {
                //20170224 单元子句归结次数最大值策略
                if (StrategyParam::unitReduntTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
                {
                    if (triAlg.vOnlyOutTriCmp[k]->claPtr->reduntTimes > StrategyParam::unitReduntTimes) {
                        triAlg.vOnlyOutTriCmp[k]->claPtr->reduntTimes = 0;
                    }
                }
                 if (loop == 0)
                    triAlg.vOnlyOutTriCmp[k]->claPtr->reduntTimes = triAlg.vOnlyOutTriCmp[k]->claPtr->reduntTimes % 500;//100;//20170823size_Tri; //20170807 triAlg.vOnlyOutTriCmp[k]->claPtr->reduntTimes / size_Tri; //20170216  50
            }
    }
    else
    {
        for (UINT32 k = 0; k < size_Tri; k++) {
                //20170224 单元子句归结次数最大值策略
                if (StrategyParam::unitReduntTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
                {
                    if (triAlg.vOnlyOutTriCmp[k]->claPtr->reduntTimes > StrategyParam::unitReduntTimes) {
                        triAlg.vOnlyOutTriCmp[k]->claPtr->reduntTimes = 0;
                    }
                }
                 if ((shift >= size_Tri -1) && (loop == 0))
                    triAlg.vOnlyOutTriCmp[k]->claPtr->reduntTimes = triAlg.vOnlyOutTriCmp[k]->claPtr->reduntTimes / size_Tri; //20170216  50
            }
    }
    //20170209 //候选子句归结次数最大值策略
    if (StrategyParam::candDeductTimesUpdate == 0) {//20170224
        //0:系统自动处理 1:迭代1次更新 2:迭代完成更新
        //3:轮数1次更新 4:轮数完成更新
        for (auto& clapE : fol.setEnq) {
            //20170224 单元子句归结次数最大值策略
            if (StrategyParam::candDeductTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
            {
                if (clapE->pdeductNum > StrategyParam::unitDeductTimes) {
                    clapE->pdeductNum = 0;
                }
            }
            if (loop == 0 ) {
                clapE->pdeductNum = clapE->pdeductNum % 500;//0;//clapE->pdeductNum / size_Tri; //20170216  50
            }
        }
        for (auto& clapE : fol.setCla) {
            //20170224 单元子句归结次数最大值策略
            if (StrategyParam::candDeductTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
            {
                if (clapE->pdeductNum > StrategyParam::unitDeductTimes) {
                    clapE->pdeductNum = 0;
                }
            }
            //20170807
//            if (loop % size_Tri) {
//                clapE->pdeductNum = clapE->pdeductNum / size_Tri; //20170216  50
//            }
            if (loop ==0 ) {
                clapE->pdeductNum = clapE->pdeductNum % 500;//0; //20170807
            }
        }
    }
    else if (StrategyParam::candDeductTimesUpdate == 1) {//20170224
        //0:系统自动处理 1:迭代1次更新 2:迭代完成更新
        //3:轮数1次更新 4:轮数完成更新
        for (auto& clapE : fol.setEnq) {
            //20170224 单元子句归结次数最大值策略
            if (StrategyParam::candDeductTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
            {
                if (clapE->pdeductNum > StrategyParam::unitDeductTimes) {
                    clapE->pdeductNum = 0;
                }
            }
            if (loop == 0) {
                clapE->pdeductNum = clapE->pdeductNum % 500;//0; //20170807 clapE->pdeductNum / size_Tri; //20170216  50
            }
        }
        for (auto& clapE : fol.setCla) {
            //20170224 单元子句归结次数最大值策略
            if (StrategyParam::candDeductTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
            {
                if (clapE->pdeductNum > StrategyParam::unitDeductTimes) {
                    clapE->pdeductNum = 0;
                }
            }
            if (loop == 0) {
                clapE->pdeductNum = clapE->pdeductNum % 500;//0; //20170807 clapE->pdeductNum / size_Tri; //20170216  50
            }
        }
    }
    else
     {//20170224
        //0:系统自动处理 1:迭代1次更新 2:迭代完成更新
        //3:轮数1次更新 4:轮数完成更新
        for (auto& clapE : fol.setEnq) {
            //20170224 单元子句归结次数最大值策略
            if (StrategyParam::candDeductTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
            {
                if (clapE->pdeductNum > StrategyParam::unitDeductTimes) {
                    clapE->pdeductNum = 0;
                }
            }
            if ((shift >= size_Tri -1) && (loop == 0)) {
                clapE->pdeductNum = clapE->pdeductNum / size_Tri; //20170216  50
            }
        }
        for (auto& clapE : fol.setCla) {
            //20170224 单元子句归结次数最大值策略
            if (StrategyParam::candDeductTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
            {
                if (clapE->pdeductNum > StrategyParam::unitDeductTimes) {
                    clapE->pdeductNum = 0;
                }
            }
            if ((shift >= size_Tri -1) && (loop == 0))  {
                clapE->pdeductNum = clapE->pdeductNum / size_Tri; //20170216  50
            }
        }
    }
    //候选子句冗余次数最大值策略
    //为-1时，系统自动处理；为大于0时设置值有效；
     if (StrategyParam::candReduntTimesUpdate == 0) {//20170224
        //0:系统自动处理 1:迭代1次更新 2:迭代完成更新
        //3:轮数1次更新 4:轮数完成更新
        for (auto& clapE : fol.setEnq) {
            //20170224 单元子句归结次数最大值策略
            if (StrategyParam::candReduntTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
            {
                if (clapE->reduntTimes > StrategyParam::candReduntTimes) {
                    clapE->reduntTimes = 0;
                }
            }
            if (loop == 0) {
                clapE->reduntTimes = clapE->reduntTimes % 500;//0;//clapE->reduntTimes / size_Tri; //20170216  50
            }
        }
        for (auto& clapE : fol.setCla) {
            //20170224 单元子句归结次数最大值策略
            if (StrategyParam::candReduntTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
            {
                if (clapE->reduntTimes > StrategyParam::candReduntTimes) {
                    clapE->reduntTimes = 0;
                }
            }
            //20170807
//            if (loop % size_Tri) {
//                clapE->reduntTimes = clapE->reduntTimes / size_Tri; //20170216  50
//            }
             if (loop ==0 ) {
                clapE->reduntTimes =clapE->reduntTimes % 500;//0; //20170807
            }
        }
    }
     else if (StrategyParam::candReduntTimesUpdate == 1) {//20170224
        //0:系统自动处理 1:迭代1次更新 2:迭代完成更新
        //3:轮数1次更新 4:轮数完成更新
        for (auto& clapE : fol.setEnq) {
            //20170224 单元子句归结次数最大值策略
            if (StrategyParam::candReduntTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
            {
                if (clapE->reduntTimes > StrategyParam::candReduntTimes) {
                    clapE->reduntTimes = 0;
                }
            }
            if (loop == 0) {
                clapE->reduntTimes = clapE->reduntTimes % 500;//0; //20170807 clapE->reduntTimes / size_Tri; //20170216  50
            }
        }
        for (auto& clapE : fol.setCla) {
            //20170224 单元子句归结次数最大值策略
            if (StrategyParam::candReduntTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
            {
                if (clapE->reduntTimes > StrategyParam::candReduntTimes) {
                    clapE->reduntTimes = 0;
                }
            }
            if (loop == 0) {
                clapE->reduntTimes = clapE->reduntTimes % 500;//0; //20170807 clapE->reduntTimes / size_Tri; //20170216  50
            }
        }
    }
    else
    {
        for (auto& clapE : fol.setEnq) {
            //20170224 单元子句归结次数最大值策略
            if (StrategyParam::candReduntTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
            {
                if (clapE->reduntTimes > StrategyParam::candReduntTimes) {
                    clapE->reduntTimes = 0;
                }
            }
            if ((shift >= size_Tri -1) && (loop ==0)) {
                clapE->reduntTimes = clapE->reduntTimes / size_Tri; //20170216  50
            }
        }
        for (auto& clapE : fol.setCla) {
            //20170224 单元子句归结次数最大值策略
            if (StrategyParam::candReduntTimes > 0)//为-1时，系统自动处理；为大于0时设置值有效；
            {
                if (clapE->reduntTimes > StrategyParam::candReduntTimes) {
                    clapE->reduntTimes = 0;
                }
            }
            if ((shift >= size_Tri -1) && (loop == 0)) {
                clapE->reduntTimes = clapE->reduntTimes / size_Tri; //20170216  50
            }
        }
    }
    for (UINT32 k = 0; k < size_Tri; k++) {
        //E(X1,X1)不添加到vOnlyOutTri进行演绎
//        if (TEqn == GetCodeProp(triAlg.vOnlyOutTriCmp[k]->subTerm->iTermCode)) //正文字等词检查是否恒真
//        {
//            if (triAlg.unify.CheckEqn(triAlg.vOnlyOutTriCmp[k]->subTerm->subTermPtr[0], triAlg.vOnlyOutTriCmp[k]->subTerm->subTermPtr[1]) && triAlg.vOnlyOutTriCmp[k]->subTerm->subTermPtr[0]->isVar()) {
//                continue;
//            }
//        }
        triAlg.vOnlyOutTri.push_back(triAlg.vOnlyOutTriCmp[k]);
        triAlg.vOutTri.push_back(triAlg.vOnlyOutTriCmp[k]);
    }
    return Succes;
}
//锁归结判断
int Resolution::JudgeLockResSimlifyNew(Formula& fol,TriAlg& triAlg,Literal* QLit,Literal* candLitp,vector<Literal*>& candLitPVec,UINT32& uNewClaID,UINT8 lockType,vector<Term*>& VarVec){
    Clause* actCla = QLit->claPtr;
    Clause* passiveCLa = candLitp->claPtr;
    vector<Literal*> vSimplyNewR;//保存R的文字
    for(UINT16 i=0; i< actCla->uLitNum ; ++i){
        if(actCla->LitPtr[i] != QLit){
            vSimplyNewR.push_back(actCla->LitPtr[i]);
        }
    }
    for(UINT16 i=0; i< passiveCLa->uLitNum ; ++i){
        if(find(candLitPVec.begin(), candLitPVec.end(), passiveCLa->LitPtr[i]) == candLitPVec.end()){
            vSimplyNewR.push_back(passiveCLa->LitPtr[i]);
        }
    }
    //合并重复文字
    if(vSimplyNewR.size() != 0) {
        for (size_t rInd = 0; rInd < vSimplyNewR.size() - 1; ++rInd) {
            Literal* rA = vSimplyNewR[rInd];
            for (size_t rIndB = rInd + 1; rIndB < vSimplyNewR.size();) {
                Literal* rB = vSimplyNewR[rIndB];
                if (rA->subTerm->iTermCode == rB->subTerm->iTermCode && triAlg.unify.CheckEqn(rA->subTerm, rB->subTerm)) {
                    swap(vSimplyNewR[rIndB], vSimplyNewR[vSimplyNewR.size() - 1]);
                    vSimplyNewR.pop_back();
                } else
                    ++rIndB;
            }
        }
    }
    
    //得到剩余文字
    //生成归结式
    Clause* newCla = nullptr;
    newCla = new Clause(uNewClaID, 0);
    size_t uRsize = vSimplyNewR.size();
    //文字排序
    if (uRsize > 1)
        stable_sort(vSimplyNewR.begin(), vSimplyNewR.end(), SortRule::LitCmp);
    newCla->LitPtr = new Literal*[uRsize];
    for (UINT16 i = 0; i < vSimplyNewR.size(); ++i) {
        Term* litSubT = triAlg.unify.GetNewTerm(vSimplyNewR[i]->subTerm, newCla); //参数1：文字谓词项，参数2：新子句指针
        if (TNegEqn == GetCodeProp(litSubT->iTermCode)
                && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {
            /*
            delete(litSubT);*/--uRsize;
            //delete(newCla->LitPtr[]);
            continue;
        }
        if (newCla->uFuncDepth < litSubT->uLevel)
            newCla->uFuncDepth = litSubT->uLevel;
        newCla->uVarCount += litSubT->uVarCount;
        //添加到文字		
        newCla->LitPtr[newCla->uLitNum] = new Literal(litSubT, EncodeLitCode(uNewClaID, newCla->uLitNum + 1), newCla, nullptr);
        newCla->LitPtr[newCla->uLitNum]->parentLitPtr = vSimplyNewR[i]; //母式文字，有R产生
        //triAlg.newCla->LitPtr[triAlg.newCla->uLitNum]->goalDeepth = vSimplyNewR[i]->goalDeepth;
        //cout<<to_string(newCla->uClaId)  + "]" <<"[" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitRow()) + "_" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitCol()) + "]" << newCla->LitPtr[newCla->uLitNum]->subTerm->ToString()<<endl;  
        ++(newCla->uLitNum);
    }
    
    if(triAlg.unify.isRedundancy(newCla)) {
        newCla->DelLits(false);
        delete(newCla);
        return 1;//锁子句
    }
    if(lockType == 1){
        newCla->DelLits(false);
        delete(newCla);
        return 0;//锁子句
    }
    vector<UINT32>invaildLitId; //
    string rundMsg; //冗余信息
    Subsumption subsump; //(MOSTRIGHT)
    //参数1 被测的子句指针 参数2 整形数组 参数3 字符串 记录冗余信息
    bool isRundacyR = subsump.GenCla(fol, newCla, invaildLitId, rundMsg);
    if (isRundacyR) {
        newCla->DelLits(false);
        delete(newCla);
        return 2;//锁+包含
    }
     if(lockType == 2){
        newCla->DelLits(false);
        delete(newCla);
        return 0;//锁子句
    }
    //继续判断 不对称文字
    if(1){
        vector<Literal*>* vCandSameLit;//存放相同谓词文字列表
        vector<Term*> chgVarTVec;//存放所有的合一项
        vector<Term*> chgVarT;
        for(UINT16 i=0; i< newCla->uLitNum; ++i){
            Literal* noPair = newCla->LitPtr[i];
            vCandSameLit = noPair->getPredLst();//找到相同谓词的文字列表
            Literal* candSameLit = nullptr;
            Clause* candSameCla = nullptr;
            UINT32 pasLitInd = 0;
            for (; pasLitInd < UINT32(vCandSameLit->size()); ++pasLitInd) {//依次找到
                candSameLit = vCandSameLit->at(pasLitInd); //谓词互补对文字
                candSameCla = candSameLit->claPtr; // 谓词互补对文字对应的子句
                //判断隐藏文字的候选子句进行限定:如文字数
                if(candSameCla->uLitNum > 2)
                    continue;
                vector<Literal*> candLeftLitVec;//存放候选子句剩余的文字,需要只剩下1个文字
                candLeftLitVec.reserve(2);
                if (triAlg.unify.litASmallLitB(noPair->subTerm, candSameLit->subTerm, chgVarT)) {//例如QLit = p1(a), candLitP=p1(x)
                    chgVarTVec.insert(chgVarTVec.end(), chgVarT.begin(), chgVarT.end());
                    chgVarT.clear();
                    //需要继续判断是否在子句中含有相同的文字
                    for (UINT16 m = 0; m < candSameCla->uLitNum; ++m) {
                        if(candSameLit != candSameCla->LitPtr[m]){
                            continue;
                        }
                        //继续看是否有相同的文字
                        bool leftFlag = true;
                        for(UINT16 n=0; n<newCla->uLitNum;++n) {
                            if (newCla->LitPtr[n]->isEqPred(candSameCla->LitPtr[m]) && triAlg.unify.litASmallLitB(newCla->LitPtr[n]->subTerm, candSameCla->LitPtr[m]->subTerm, chgVarT)) {
                                chgVarTVec.insert(chgVarTVec.end(), chgVarT.begin(), chgVarT.end());
                                chgVarT.clear();
                                leftFlag = false;
                                break;
                            } else
                                triAlg.unify.ClearVarBind(chgVarT);
                        }
                        if(leftFlag)
                            candLeftLitVec.push_back(candSameCla->LitPtr[m]);//候选子句剩余的文字
                    }
                    if(candLeftLitVec.size() == 0){//找不到相同文字: 此处归类到纯文字,返回0,继续判断下一个纯文字
                        triAlg.unify.ClearVarBind(chgVarTVec);
                        candLeftLitVec.clear();
                        newCla->DelLits(false);
                        delete(newCla);
                        //生成需要的子句
                        return 0;//
                    }
                    else if (lockType == 3) {
                        triAlg.unify.ClearVarBind(chgVarTVec);
                        candLeftLitVec.clear();
                        newCla->DelLits(false);
                        delete(newCla);
                        return 0; //锁子句
                    }
                    else if (candLeftLitVec.size() == 1) {
                        //得到互补文字
                        uNewClaID++;
                        Clause* newClaPair = nullptr;
                        if(1){
                            newClaPair = new Clause(uNewClaID, 0);
                            size_t uRsize = candLeftLitVec.size();
                            //文字排序
                            if (uRsize > 1)
                                stable_sort(candLeftLitVec.begin(), candLeftLitVec.end(), SortRule::LitCmp);
                            newClaPair->LitPtr = new Literal*[uRsize];
                            for (UINT16 i = 0; i < candLeftLitVec.size(); ++i) {
                                Term* litSubT = triAlg.unify.GetNewTerm(candLeftLitVec[i]->subTerm, newClaPair); //参数1：文字谓词项，参数2：新子句指针
                                if (TNegEqn == GetCodeProp(litSubT->iTermCode)
                                        && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {
                                    /*
                                    delete(litSubT);*/--uRsize;
                                    //delete(newCla->LitPtr[]);
                                    continue;
                                }
                                if (newClaPair->uFuncDepth < litSubT->uLevel)
                                    newClaPair->uFuncDepth = litSubT->uLevel;
                                newClaPair->uVarCount += litSubT->uVarCount;
                                //添加到文字		
                                newClaPair->LitPtr[newClaPair->uLitNum] = new Literal(litSubT, EncodeLitCode(uNewClaID, newClaPair->uLitNum + 1), newClaPair, nullptr);
                                newClaPair->LitPtr[newClaPair->uLitNum]->parentLitPtr = candLeftLitVec[i]; //母式文字，有R产生
                                //triAlg.newCla->LitPtr[triAlg.newCla->uLitNum]->goalDeepth = vSimplyNewR[i]->goalDeepth;
                                //cout<<to_string(newCla->uClaId)  + "]" <<"[" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitRow()) + "_" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitCol()) + "]" << newCla->LitPtr[newCla->uLitNum]->subTerm->ToString()<<endl;  
                                ++(newClaPair->uLitNum);
                            }
                            //对文字取反
                            UINT32 uPredProp = GetCodeProp(newClaPair->LitPtr[0]->subTerm->iTermCode);
                            INT32 iPredCode = Get1stTermID(newClaPair->LitPtr[0]->subTerm->iTermCode);
                            if (uPredProp == TNegPred) {
                                newClaPair->LitPtr[0]->subTerm->iTermCode = Set1stTProp(iPredCode, TPred);
                            } else if (uPredProp == TPred) {
                                newClaPair->LitPtr[0]->subTerm->iTermCode = Set1stTProp(iPredCode, TNegPred);
                            } else if (uPredProp == TNegEqn) {
                                newClaPair->LitPtr[0]->subTerm->iTermCode = Set1stTProp(iPredCode, TEqn);
                            } else if (uPredProp == TEqn) {
                                newClaPair->LitPtr[0]->subTerm->iTermCode = Set1stTProp(iPredCode, TNegEqn);
                            }
                            //得到文字
                            for (UINT16 n = 0; n < newCla->uLitNum; ++n) {
                                candLeftLitVec.push_back(newCla->LitPtr[n]);
                            }
                        }
                        //得到最后的子句
                        uNewClaID++;
                        Clause* newClaEnd = nullptr;
                        if(1){
                            newClaEnd = new Clause(uNewClaID, 0);
                            size_t uRsize = candLeftLitVec.size();
                            //文字排序
                            if (uRsize > 1)
                                stable_sort(candLeftLitVec.begin(), candLeftLitVec.end(), SortRule::LitCmp);
                            newClaEnd->LitPtr = new Literal*[uRsize];
                            for (UINT16 i = 0; i < candLeftLitVec.size(); ++i) {
                                Term* litSubT = triAlg.unify.GetNewTerm(candLeftLitVec[i]->subTerm, newClaEnd); //参数1：文字谓词项，参数2：新子句指针
                                if (TNegEqn == GetCodeProp(litSubT->iTermCode)
                                        && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {
                                    /*
                                    delete(litSubT);*/--uRsize;
                                    //delete(newCla->LitPtr[]);
                                    continue;
                                }
                                if (newClaEnd->uFuncDepth < litSubT->uLevel)
                                    newClaEnd->uFuncDepth = litSubT->uLevel;
                                newClaEnd->uVarCount += litSubT->uVarCount;
                                //添加到文字		
                                newClaEnd->LitPtr[newClaEnd->uLitNum] = new Literal(litSubT, EncodeLitCode(uNewClaID, newClaEnd->uLitNum + 1), newClaEnd, nullptr);
                                newClaEnd->LitPtr[newClaEnd->uLitNum]->parentLitPtr = candLeftLitVec[i]; //母式文字，有R产生
                                //triAlg.newCla->LitPtr[triAlg.newCla->uLitNum]->goalDeepth = vSimplyNewR[i]->goalDeepth;
                                //cout<<to_string(newCla->uClaId)  + "]" <<"[" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitRow()) + "_" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitCol()) + "]" << newCla->LitPtr[newCla->uLitNum]->subTerm->ToString()<<endl;  
                                ++(newClaEnd->uLitNum);
                            }
                            if (triAlg.unify.isRedundancy(newClaEnd)) {
                                triAlg.unify.ClearVarBind(chgVarTVec);
                                newClaEnd->DelLits(false);
                                delete(newClaEnd);
                                uNewClaID--;
                                newClaPair->DelLits(false);
                                delete(newClaPair);
                                uNewClaID--;
                                newCla->DelLits(false);
                                delete(newCla);
                                return 4; //锁+不对称文字+恒真
                            }
                            if(lockType == 4){
                                triAlg.unify.ClearVarBind(chgVarTVec);
                                newClaEnd->DelLits(false);
                                delete(newClaEnd);
                                uNewClaID--;
                                newClaPair->DelLits(false);
                                delete(newClaPair);
                                uNewClaID--;
                                newCla->DelLits(false);
                                delete(newCla);
                                return 0; //锁+不对称文字+恒真
                            }
                            vector<UINT32>invaildLitId; //
                            string rundMsg; //冗余信息
                            Subsumption subsump; //(MOSTRIGHT)
                            //参数1 被测的子句指针 参数2 整形数组 参数3 字符串 记录冗余信息
                            bool isRundacyR = subsump.GenCla(fol, newClaEnd, invaildLitId, rundMsg);
                            if (isRundacyR) {
                                triAlg.unify.ClearVarBind(chgVarTVec);
                                newClaEnd->DelLits(false);
                                delete(newClaEnd);
                                uNewClaID--;
                                newClaPair->DelLits(false);
                                delete(newClaPair);
                                uNewClaID--;
                                newCla->DelLits(false);
                                delete(newCla);
                                return 5; //锁+不对称文字+包含
                            }
                        }
                        triAlg.unify.ClearVarBind(chgVarTVec);
                        newClaEnd->DelLits(false);
                        delete(newClaEnd);
                        uNewClaID--;
                        newClaPair->DelLits(false);
                        delete(newClaPair);
                        uNewClaID--;
                    }
                    else{//没有找到,继续查找
                        triAlg.unify.ClearVarBind(chgVarTVec);
                    }
                }
                else{
                    triAlg.unify.ClearVarBind(chgVarT);
                }
            }
            //第一个文字判断结束
        }
        triAlg.unify.ClearVarBind(chgVarT);
    }
    //删除子句并退出
    newCla->DelLits(false);
    delete(newCla);
    return 0;
}
//正常值:返回值0 锁子句:返回值1  锁加包含冗余:返回值2
int Resolution::JudgeLockResSimlify(Formula& fol,TriAlg& triAlg,Literal* QLit,Literal* candLitp,vector<Literal*>& candLitPVec,UINT32& uNewClaID,UINT8 lockType,vector<Term*>& VarVec){
    Clause* actCla = QLit->claPtr;
    Clause* passiveCLa = candLitp->claPtr;
    vector<Literal*> vSimplyNewR;//保存R的文字
    for(UINT16 i=0; i< actCla->uLitNum ; ++i){
        if(actCla->LitPtr[i] != QLit){
            vSimplyNewR.push_back(actCla->LitPtr[i]);
        }
    }
    for(UINT16 i=0; i< passiveCLa->uLitNum ; ++i){
        if(find(candLitPVec.begin(), candLitPVec.end(), passiveCLa->LitPtr[i]) == candLitPVec.end()){
            vSimplyNewR.push_back(passiveCLa->LitPtr[i]);
        }
    }
    //合并重复文字
    if(vSimplyNewR.size() != 0) {
        for (size_t rInd = 0; rInd < vSimplyNewR.size() - 1; ++rInd) {
            Literal* rA = vSimplyNewR[rInd];
            for (size_t rIndB = rInd + 1; rIndB < vSimplyNewR.size();) {
                Literal* rB = vSimplyNewR[rIndB];
                if (rA->subTerm->iTermCode == rB->subTerm->iTermCode && triAlg.unify.CheckEqn(rA->subTerm, rB->subTerm)) {
                    swap(vSimplyNewR[rIndB], vSimplyNewR[vSimplyNewR.size() - 1]);
                    vSimplyNewR.pop_back();
                } else
                    ++rIndB;
            }
        }
    }
    
    //得到剩余文字
    //生成归结式
    Clause* newCla = nullptr;
    newCla = new Clause(uNewClaID, 0);
    size_t uRsize = vSimplyNewR.size();
    //文字排序
    if (uRsize > 1)
        stable_sort(vSimplyNewR.begin(), vSimplyNewR.end(), SortRule::LitCmp);
    newCla->LitPtr = new Literal*[uRsize];
    for (UINT16 i = 0; i < vSimplyNewR.size(); ++i) {
        Term* litSubT = triAlg.unify.GetNewTerm(vSimplyNewR[i]->subTerm, newCla); //参数1：文字谓词项，参数2：新子句指针
        if (TNegEqn == GetCodeProp(litSubT->iTermCode)
                && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {
            /*
            delete(litSubT);*/--uRsize;
            //delete(newCla->LitPtr[]);
            continue;
        }
        if (newCla->uFuncDepth < litSubT->uLevel)
            newCla->uFuncDepth = litSubT->uLevel;
        newCla->uVarCount += litSubT->uVarCount;
        //添加到文字		
        newCla->LitPtr[newCla->uLitNum] = new Literal(litSubT, EncodeLitCode(uNewClaID, newCla->uLitNum + 1), newCla, nullptr);
        newCla->LitPtr[newCla->uLitNum]->parentLitPtr = vSimplyNewR[i]; //母式文字，有R产生
        //triAlg.newCla->LitPtr[triAlg.newCla->uLitNum]->goalDeepth = vSimplyNewR[i]->goalDeepth;
        //cout<<to_string(newCla->uClaId)  + "]" <<"[" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitRow()) + "_" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitCol()) + "]" << newCla->LitPtr[newCla->uLitNum]->subTerm->ToString()<<endl;  
        ++(newCla->uLitNum);
    }
    
    if(triAlg.unify.isRedundancy(newCla)) {
        newCla->DelLits(false);
        delete(newCla);
        return 1;//锁子句
    }
    if(lockType == 1){
        newCla->DelLits(false);
        delete(newCla);
        return 0;//锁子句
    }
    vector<UINT32>invaildLitId; //
    string rundMsg; //冗余信息
    Subsumption subsump; //(MOSTRIGHT)
    //参数1 被测的子句指针 参数2 整形数组 参数3 字符串 记录冗余信息
    bool isRundacyR = subsump.GenCla(fol, newCla, invaildLitId, rundMsg);
    if (isRundacyR) {
        newCla->DelLits(false);
        delete(newCla);
        return 2;//锁+包含
    }
     if(lockType == 2){
        newCla->DelLits(false);
        delete(newCla);
        return 0;//锁子句
    }
    //继续判断 不对称文字
    if(1){
        vector<Literal*>* vCandSameLit;//存放相同谓词文字列表
        vector<Term*> chgVarTVec;//存放所有的合一项
        vector<Term*> chgVarT;
        for(UINT16 i=0; i< newCla->uLitNum; ++i){
            Literal* noPair = newCla->LitPtr[i];
            vCandSameLit = noPair->getPredLst();//找到相同谓词的文字列表
            Literal* candSameLit = nullptr;
            Clause* candSameCla = nullptr;
            UINT32 pasLitInd = 0;
            for (; pasLitInd < UINT32(vCandSameLit->size()); ++pasLitInd) {//依次找到
                candSameLit = vCandSameLit->at(pasLitInd); //谓词互补对文字
                candSameCla = candSameLit->claPtr; // 谓词互补对文字对应的子句
                
                vector<Literal*> candLeftLitVec;//存放候选子句剩余的文字,需要只剩下1个文字
                candLeftLitVec.reserve(2);
                if (triAlg.unify.litASmallLitB(noPair->subTerm, candSameLit->subTerm, chgVarT)) {//例如QLit = p1(a), candLitP=p1(x)
                    chgVarTVec.insert(chgVarTVec.end(), chgVarT.begin(), chgVarT.end());
                    chgVarT.clear();
                    //需要继续判断是否在子句中含有相同的文字
                    for (UINT16 m = 0; m < candSameCla->uLitNum; ++m) {
                        if(candSameLit != candSameCla->LitPtr[m]){
                            continue;
                        }
                        //继续看是否有相同的文字
                        bool leftFlag = true;
                        for(UINT16 n=0; n<newCla->uLitNum;++n) {
                            if (newCla->LitPtr[n]->isEqPred(candSameCla->LitPtr[m]) && triAlg.unify.litASmallLitB(newCla->LitPtr[n]->subTerm, candSameCla->LitPtr[m]->subTerm, chgVarT)) {
                                chgVarTVec.insert(chgVarTVec.end(), chgVarT.begin(), chgVarT.end());
                                chgVarT.clear();
                                leftFlag = false;
                                break;
                            } else
                                triAlg.unify.ClearVarBind(chgVarT);
                        }
                        if(leftFlag)
                            candLeftLitVec.push_back(candSameCla->LitPtr[m]);//候选子句剩余的文字
                    }
                    if(candLeftLitVec.size() == 0){//找到了不对称文字
                        triAlg.unify.ClearVarBind(chgVarTVec);
                        candLeftLitVec.clear();
                        newCla->DelLits(false);
                        delete(newCla);
                        //生成需要的子句
                        return 3;//锁+包含
                    }
                    else if (lockType == 3) {
                        triAlg.unify.ClearVarBind(chgVarTVec);
                        candLeftLitVec.clear();
                        newCla->DelLits(false);
                        delete(newCla);
                        return 0; //锁子句
                    }
                    else if (candLeftLitVec.size() == 1) {
                        //得到互补文字
                        uNewClaID++;
                        Clause* newClaPair = nullptr;
                        if(1){
                            newClaPair = new Clause(uNewClaID, 0);
                            size_t uRsize = candLeftLitVec.size();
                            //文字排序
                            if (uRsize > 1)
                                stable_sort(candLeftLitVec.begin(), candLeftLitVec.end(), SortRule::LitCmp);
                            newClaPair->LitPtr = new Literal*[uRsize];
                            for (UINT16 i = 0; i < candLeftLitVec.size(); ++i) {
                                Term* litSubT = triAlg.unify.GetNewTerm(candLeftLitVec[i]->subTerm, newClaPair); //参数1：文字谓词项，参数2：新子句指针
                                if (TNegEqn == GetCodeProp(litSubT->iTermCode)
                                        && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {
                                    /*
                                    delete(litSubT);*/--uRsize;
                                    //delete(newCla->LitPtr[]);
                                    continue;
                                }
                                if (newClaPair->uFuncDepth < litSubT->uLevel)
                                    newClaPair->uFuncDepth = litSubT->uLevel;
                                newClaPair->uVarCount += litSubT->uVarCount;
                                //添加到文字		
                                newClaPair->LitPtr[newClaPair->uLitNum] = new Literal(litSubT, EncodeLitCode(uNewClaID, newClaPair->uLitNum + 1), newClaPair, nullptr);
                                newClaPair->LitPtr[newClaPair->uLitNum]->parentLitPtr = candLeftLitVec[i]; //母式文字，有R产生
                                //triAlg.newCla->LitPtr[triAlg.newCla->uLitNum]->goalDeepth = vSimplyNewR[i]->goalDeepth;
                                //cout<<to_string(newCla->uClaId)  + "]" <<"[" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitRow()) + "_" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitCol()) + "]" << newCla->LitPtr[newCla->uLitNum]->subTerm->ToString()<<endl;  
                                ++(newClaPair->uLitNum);
                            }
                            //对文字取反
                            UINT32 uPredProp = GetCodeProp(newClaPair->LitPtr[0]->subTerm->iTermCode);
                            INT32 iPredCode = Get1stTermID(newClaPair->LitPtr[0]->subTerm->iTermCode);
                            if (uPredProp == TNegPred) {
                                newClaPair->LitPtr[0]->subTerm->iTermCode = Set1stTProp(iPredCode, TPred);
                            } else if (uPredProp == TPred) {
                                newClaPair->LitPtr[0]->subTerm->iTermCode = Set1stTProp(iPredCode, TNegPred);
                            } else if (uPredProp == TNegEqn) {
                                newClaPair->LitPtr[0]->subTerm->iTermCode = Set1stTProp(iPredCode, TEqn);
                            } else if (uPredProp == TEqn) {
                                newClaPair->LitPtr[0]->subTerm->iTermCode = Set1stTProp(iPredCode, TNegEqn);
                            }
                            //得到文字
                            for (UINT16 n = 0; n < newCla->uLitNum; ++n) {
                                candLeftLitVec.push_back(newCla->LitPtr[n]);
                            }
                        }
                        //得到最后的子句
                        uNewClaID++;
                        Clause* newClaEnd = nullptr;
                        if(1){
                            newClaEnd = new Clause(uNewClaID, 0);
                            size_t uRsize = candLeftLitVec.size();
                            //文字排序
                            if (uRsize > 1)
                                stable_sort(candLeftLitVec.begin(), candLeftLitVec.end(), SortRule::LitCmp);
                            newClaEnd->LitPtr = new Literal*[uRsize];
                            for (UINT16 i = 0; i < candLeftLitVec.size(); ++i) {
                                Term* litSubT = triAlg.unify.GetNewTerm(candLeftLitVec[i]->subTerm, newClaEnd); //参数1：文字谓词项，参数2：新子句指针
                                if (TNegEqn == GetCodeProp(litSubT->iTermCode)
                                        && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {
                                    /*
                                    delete(litSubT);*/--uRsize;
                                    //delete(newCla->LitPtr[]);
                                    continue;
                                }
                                if (newClaEnd->uFuncDepth < litSubT->uLevel)
                                    newClaEnd->uFuncDepth = litSubT->uLevel;
                                newClaEnd->uVarCount += litSubT->uVarCount;
                                //添加到文字		
                                newClaEnd->LitPtr[newClaEnd->uLitNum] = new Literal(litSubT, EncodeLitCode(uNewClaID, newClaEnd->uLitNum + 1), newClaEnd, nullptr);
                                newClaEnd->LitPtr[newClaEnd->uLitNum]->parentLitPtr = candLeftLitVec[i]; //母式文字，有R产生
                                //triAlg.newCla->LitPtr[triAlg.newCla->uLitNum]->goalDeepth = vSimplyNewR[i]->goalDeepth;
                                //cout<<to_string(newCla->uClaId)  + "]" <<"[" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitRow()) + "_" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitCol()) + "]" << newCla->LitPtr[newCla->uLitNum]->subTerm->ToString()<<endl;  
                                ++(newClaEnd->uLitNum);
                            }
                            if (triAlg.unify.isRedundancy(newClaEnd)) {
                                triAlg.unify.ClearVarBind(chgVarTVec);
                                newClaEnd->DelLits(false);
                                delete(newClaEnd);
                                uNewClaID--;
                                newClaPair->DelLits(false);
                                delete(newClaPair);
                                uNewClaID--;
                                newCla->DelLits(false);
                                delete(newCla);
                                return 4; //锁+不对称文字+恒真
                            }
                            if(lockType == 4){
                                triAlg.unify.ClearVarBind(chgVarTVec);
                                newClaEnd->DelLits(false);
                                delete(newClaEnd);
                                uNewClaID--;
                                newClaPair->DelLits(false);
                                delete(newClaPair);
                                uNewClaID--;
                                newCla->DelLits(false);
                                delete(newCla);
                                return 0; //锁+不对称文字+恒真
                            }
                            vector<UINT32>invaildLitId; //
                            string rundMsg; //冗余信息
                            Subsumption subsump; //(MOSTRIGHT)
                            //参数1 被测的子句指针 参数2 整形数组 参数3 字符串 记录冗余信息
                            bool isRundacyR = subsump.GenCla(fol, newClaEnd, invaildLitId, rundMsg);
                            if (isRundacyR) {
                                triAlg.unify.ClearVarBind(chgVarTVec);
                                newClaEnd->DelLits(false);
                                delete(newClaEnd);
                                uNewClaID--;
                                newClaPair->DelLits(false);
                                delete(newClaPair);
                                uNewClaID--;
                                newCla->DelLits(false);
                                delete(newCla);
                                return 5; //锁+不对称文字+包含
                            }
                        }
                        triAlg.unify.ClearVarBind(chgVarTVec);
                        newClaEnd->DelLits(false);
                        delete(newClaEnd);
                        uNewClaID--;
                        newClaPair->DelLits(false);
                        delete(newClaPair);
                        uNewClaID--;
                    }
                    else{//没有找到,继续查找
                        triAlg.unify.ClearVarBind(chgVarTVec);
                    }
                }
                else{
                    triAlg.unify.ClearVarBind(chgVarT);
                }
            }
            //第一个文字判断结束
        }
        triAlg.unify.ClearVarBind(chgVarT);
    }
    //删除子句并退出
    newCla->DelLits(false);
    delete(newCla);
    return 0;
}
//锁归结消除子句方法
//锁归结消除子句方法
bool Resolution::lockResSimlifyNew(Formula& fol,TriAlg& triAlg,Clause* cla,UINT32& uNewClaID){
    vector<Literal*>* vCandLit;//存放互补文字列表
    
    Clause* candClaP = nullptr;
    Literal* candLitP = nullptr;
    vector<Literal*> candLitPVec;//保存总的互补对候选文字
    candLitPVec.reserve(2);
    vector<Term*> chgVarT;//存放每个合一过程中的替换项
    vector<Term*> chgVarTVec;//存放所有的合一项
    bool perFlag = true;
    bool pureLit = true;
    for(UINT16 i=0; i< cla->uLitNum ; ++i){
        //依次用每个文字去判断是否是锁子句
        perFlag = true;
        pureLit = true;
        Literal* QLit = cla->LitPtr[i];
        
        //the added conditions
        if(QLit->isOnlyOneAppeared() == false){
            continue;
        }
        vCandLit = QLit->getPairPredLst();
        UINT32 pasLitInd = 0;
        for (; pasLitInd < UINT32(vCandLit->size()); ++pasLitInd) {//依次找到
            candLitP = vCandLit->at(pasLitInd); //谓词互补对文字
            candClaP = candLitP->claPtr; // 谓词互补对文字对应的子句
            if (triAlg.unify.LitMgu(QLit, candLitP, chgVarT)) {
                pureLit = false;
                //找到合一的项,继续查找直到没有互补对文字
                chgVarTVec.insert(chgVarTVec.end(), chgVarT.begin(), chgVarT.end());
                candLitPVec.push_back(candLitP);
                chgVarT.clear();
                //需要继续判断是否在子句中含有互补对文字
                for (UINT16 m = 0; m < candClaP->uLitNum; ++m) {
                    if (find(candLitPVec.begin(), candLitPVec.end(), candClaP->LitPtr[m]) != candLitPVec.end()) {//已判断
                        continue;
                    }
                    //1.归结式不含互补对,则肯定该文字不能锁
                    //2.被锁定的其它文字含有互补对
//                    if(QLit->claPtr->uClaId == 51){
//                        candClaP->LitPtr[m]->subTerm->Print();
//                        cout<<endl;
//                    }
                    if (QLit->isPairPred(candClaP->LitPtr[m]) && triAlg.unify.LitMgu(QLit, candClaP->LitPtr[m], chgVarT)) {
                        
                        chgVarTVec.insert(chgVarTVec.end(), chgVarT.begin(), chgVarT.end());
                        candLitPVec.push_back(candClaP->LitPtr[m]);
                        chgVarT.clear();
                    } else
                        triAlg.unify.ClearVarBind(chgVarT);
                }
                chgVarT.clear();
                int res = JudgeLockResSimlifyNew(fol, triAlg, QLit, candLitP, candLitPVec, uNewClaID,StrategyParam::lockType,chgVarTVec);
                if ( res== 0) {                                                                                 //表示正常返回
                    triAlg.unify.ClearVarBind(chgVarTVec);
                    perFlag = false;
                    break;//该文字不是锁子句文字
                }
                else{
                    candLitPVec.clear();
                    triAlg.unify.ClearVarBind(chgVarTVec);
                    continue;
                }
            }
            else{
                triAlg.unify.ClearVarBind(chgVarT);
            }
        }
        if(pureLit){//出现纯文字
            candLitPVec.clear();
            triAlg.unify.ClearVarBind(chgVarTVec);
            lockLitVec.push_back(QLit);
            lockClaVec.push_back(cla);
            return true;
        }
        //该文字所有的都找完,如果perFlag为false,则不为锁文字;如果是true则为对应的锁文字
        if(perFlag){//为锁文字,否则继续判断
            candLitPVec.clear();
            triAlg.unify.ClearVarBind(chgVarTVec);
            lockLitVec.push_back(QLit);
            lockClaVec.push_back(cla);
            return false;
        }
        else{
            triAlg.unify.ClearVarBind(chgVarTVec);
            candLitPVec.clear();
        }
    }
    return false;
}
bool Resolution::lockResSimlify(Formula& fol,TriAlg& triAlg,Clause* cla,UINT32& uNewClaID){
    vector<Literal*>* vCandLit;//存放互补文字列表
    
    Clause* candClaP = nullptr;
    Literal* candLitP = nullptr;
    vector<Literal*> candLitPVec;//保存总的互补对候选文字
    candLitPVec.reserve(2);
    vector<Term*> chgVarT;//存放每个合一过程中的替换项
    vector<Term*> chgVarTVec;//存放所有的合一项
    bool perFlag = true;
    for(UINT16 i=0; i< cla->uLitNum ; ++i){
        //依次用每个文字去判断是否是锁子句
        perFlag = true;
        Literal* QLit = cla->LitPtr[i];
        vCandLit = QLit->getPairPredLst();
        UINT32 pasLitInd = 0;
        for (; pasLitInd < UINT32(vCandLit->size()); ++pasLitInd) {//依次找到
            candLitP = vCandLit->at(pasLitInd); //谓词互补对文字
            candClaP = candLitP->claPtr; // 谓词互补对文字对应的子句
            if (triAlg.unify.LitMgu(QLit, candLitP, chgVarT)) {
                //找到合一的项,继续查找直到没有互补对文字
                chgVarTVec.insert(chgVarTVec.end(), chgVarT.begin(), chgVarT.end());
                candLitPVec.push_back(candLitP);
                chgVarT.clear();
                //需要继续判断是否在子句中含有互补对文字
                for (UINT16 m = 0; m < candClaP->uLitNum; ++m) {
                    if (find(candLitPVec.begin(), candLitPVec.end(), candClaP->LitPtr[m]) != candLitPVec.end()) {//已判断
                        continue;
                    }
                    //1.归结式不含互补对,则肯定该文字不能锁
                    //2.被锁定的其它文字含有互补对
//                    if(QLit->claPtr->uClaId == 51){
//                        candClaP->LitPtr[m]->subTerm->Print();
//                        cout<<endl;
//                    }
                    if (QLit->isPairPred(candClaP->LitPtr[m]) && triAlg.unify.LitMgu(QLit, candClaP->LitPtr[m], chgVarT)) {
                        
                        chgVarTVec.insert(chgVarTVec.end(), chgVarT.begin(), chgVarT.end());
                        candLitPVec.push_back(candClaP->LitPtr[m]);
                        chgVarT.clear();
                    } else
                        triAlg.unify.ClearVarBind(chgVarT);
                }
                chgVarT.clear();
                int res = JudgeLockResSimlify(fol, triAlg, QLit, candLitP, candLitPVec, uNewClaID,StrategyParam::lockType,chgVarTVec);
                if ( res== 0) {                                                                                 //表示正常返回
                    triAlg.unify.ClearVarBind(chgVarTVec);
                    perFlag = false;
                    break;//该文字不是锁子句文字
                }
                else{
                    candLitPVec.clear();
                    triAlg.unify.ClearVarBind(chgVarTVec);
                    continue;
                }
            }
            else{
                triAlg.unify.ClearVarBind(chgVarT);
            }
        }
        
        //该文字所有的都找完,如果perFlag为false,则不为锁文字;如果是true则为对应的锁文字
        if(perFlag){//为锁文字,否则继续判断
            candLitPVec.clear();
            triAlg.unify.ClearVarBind(chgVarTVec);
            lockLitVec.push_back(QLit);
            lockClaVec.push_back(cla);
            return true;
        }
        else{
            triAlg.unify.ClearVarBind(chgVarTVec);
            candLitPVec.clear();
        }
    }
    return false;
}
//判断子句是否满足因子归结的条件,满足则需要合并文字
int Resolution::factorRes(Formula& fol,TriAlg& triAlg,Clause* cla,UINT32& uNewClaID,vector<Clause*>* preGenCla,bool& resDelFlag, bool fileNameFlag){
    if(cla->hasSamePredict() == false){
        resDelFlag = false;
        return 0;
    }
    else{
        vector<Term*> chgVarT; 
        chgVarT.reserve(6);
        vector<Literal*> vSimplyNewR;
        vSimplyNewR.reserve(6);
        vector<Term*> varBindT; //变元绑定列表
        varBindT.reserve(6);
//        vector<int> litSubs;//记录参与因子归结的文字下标,用于判断是否含有共享变元
//        litSubs.reserve(6);
        bool flag = false;//标记是否有能够合一合并的文字
        //1.遍历子句的各个文字
        for(int i=0;i<cla->uLitNum-1;++i){
            for(int j=i+1;j<cla->uLitNum;++j){
                //2.查看是否可以合一 triAlg.vOnlyOutTri[i]->isPairPred(triAlg.vOnlyOutTri[j]) && triAlg.unify.LitMgu(triAlg.vOnlyOutTri[i], triAlg.vOnlyOutTri[j], chgVarT)
                if(cla->LitPtr[i]->isEqPred(cla->LitPtr[j]) && ((cla->LitPtr[i]->noExistShareVar() && cla->LitPtr[j]->isConLit()) || (cla->LitPtr[i]->isConLit() && cla->LitPtr[j]->noExistShareVar()))){
                    if(triAlg.unify.LitMgu(cla->LitPtr[i],cla->LitPtr[j],chgVarT)){
                        flag = true;
                        varBindT.insert(varBindT.end(), chgVarT.begin(), chgVarT.end());
                        chgVarT.clear();
                    }
                    else{
                        triAlg.unify.ClearVarBind(chgVarT);
                    }
                }
                else{
                    continue;
                }
            }
        }
        if(flag){
            //2.得到归结式所需的文字
            for (int i = 0; i < cla->uLitNum; ++i) {
                vSimplyNewR.push_back(cla->LitPtr[i]);
            }
            //3.归结式合并相同的文字 
            for (size_t rInd = 0; rInd < vSimplyNewR.size() - 1; ++rInd) {
                Literal* rA = vSimplyNewR[rInd];
                for (size_t rIndB = rInd + 1; rIndB < vSimplyNewR.size();) {
                    Literal* rB = vSimplyNewR[rIndB];
                    if (rA->subTerm->iTermCode == rB->subTerm->iTermCode && triAlg.unify.CheckEqn(rA->subTerm, rB->subTerm)) {
                        swap(vSimplyNewR[rIndB], vSimplyNewR[vSimplyNewR.size() - 1]);
                        vSimplyNewR.pop_back();
                    } else
                        ++rIndB;
                }
            }
            //4.检查归结式是否是恒真式
            vector<string> strLit;
            strLit.reserve(6);
            string str;
            if (vSimplyNewR.size() > 1) {
                for (int m = 0; m < vSimplyNewR.size(); ++m) {
                    str = "";
                    triAlg.unify.TermToString(vSimplyNewR[m]->subTerm, str);
                    strLit.push_back(str);
                }
            }
            if (strLit.size() > 1) {//需要判断是否时恒真式
                if (RedundancyOp::CheckTautology(strLit)) {
                    triAlg.unify.ClearVarBind(varBindT);
                    vSimplyNewR.clear();
                    vector<Literal*>().swap(vSimplyNewR);
                    strLit.clear();
                    vector<string>().swap(strLit);
                    resDelFlag = false;
                    return 1;
                }
            }
            //.5 生成归结式R
            triAlg.newCla = nullptr;
            triAlg.newCla = new Clause(uNewClaID, 0);
            triAlg.newCla->isAxtom = true;
            size_t uRsize = vSimplyNewR.size();
            //文字排序
            if (uRsize > 1)
                stable_sort(vSimplyNewR.begin(), vSimplyNewR.end(), SortRule::LitCmp);
            triAlg.newCla->LitPtr = new Literal*[uRsize];
            for (UINT16 i = 0; i < vSimplyNewR.size(); ++i) {
                Term* litSubT = triAlg.unify.GetNewTerm(vSimplyNewR[i]->subTerm, triAlg.newCla); //参数1：文字谓词项，参数2：新子句指针
                if (TNegEqn == GetCodeProp(litSubT->iTermCode)
                        && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {
                    /*
                    delete(litSubT);*/--uRsize;
                    //delete(newCla->LitPtr[]);
                    continue;
                }
                if (triAlg.newCla->uFuncDepth < litSubT->uLevel)
                    triAlg.newCla->uFuncDepth = litSubT->uLevel;
                triAlg.newCla->uVarCount += litSubT->uVarCount;
                //添加到文字		
                triAlg.newCla->LitPtr[triAlg.newCla->uLitNum] = new Literal(litSubT, EncodeLitCode(uNewClaID, triAlg.newCla->uLitNum + 1), triAlg.newCla, nullptr);
                triAlg.newCla->LitPtr[triAlg.newCla->uLitNum]->parentLitPtr = vSimplyNewR[i]; //母式文字，有R产生
                //triAlg.newCla->LitPtr[triAlg.newCla->uLitNum]->goalDeepth = vSimplyNewR[i]->goalDeepth;
                //20171020 计算演绎深度
                if(triAlg.newCla ->deduceDeepth < (vSimplyNewR[i]->claPtr->deduceDeepth + 1)){
                    triAlg.newCla ->deduceDeepth = vSimplyNewR[i]->claPtr->deduceDeepth + 1;
                }
                 if (vSimplyNewR[i]->claPtr->isAxtom && triAlg.newCla->isAxtom)
                    triAlg.newCla->isAxtom = true;
                else
                    triAlg.newCla->isAxtom = false;
                if(triAlg.hasUnifGoalLit(fol,triAlg.newCla->LitPtr[triAlg.newCla->uLitNum])){
                    triAlg.newCla->LitPtr[triAlg.newCla->uLitNum]->goalDeepth = 1;
                    if(triAlg.newCla->goaldeepth > 1)
                        triAlg.newCla->goaldeepth = 1;
                }
                else{
                    triAlg.newCla->LitPtr[triAlg.newCla->uLitNum]->goalDeepth = vSimplyNewR[i]->goalDeepth;
                      if(triAlg.newCla->goaldeepth > vSimplyNewR[i]->goalDeepth)
                        triAlg.newCla->goaldeepth = vSimplyNewR[i]->goalDeepth;
                }
                //cout<<to_string(newCla->uClaId)  + "]" <<"[" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitRow()) + "_" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitCol()) + "]" << newCla->LitPtr[newCla->uLitNum]->subTerm->ToString()<<endl;  
                ++(triAlg.newCla->uLitNum);
            }
            //Liu Bug修复
            if (uRsize == 0) {
                triAlg.newCla->DelLits(false);
                delete(triAlg.newCla);
                return 0;
            }            
//            triAlg.newCla->goaldeepth = triAlg.newCla->LitPtr[0]->goalDeepth;
//            for(UINT16 a=0; a<triAlg.newCla->uLitNum; ++a){
//                
//            }
            fol.initGenerateClaAttr(triAlg.newCla);
            uNewClaID++; //通过归结式记录
            //3. 记录演绎路径
            if (StrategyParam::orForCompition == false) {
                if(fileNameFlag == true)
                    FileOp::CreateRunInfoFilePre(20000);
                else
                    FileOp::CreateRunInfoFile(20000);
                *FileOp::ofRealInfoOut << "从编号为" + to_string(cla->uClaId) + "子句开始进行因子归结演绎" << endl;
            }
            for (UINT32 k = 0; k < cla->uLitNum; k++) {
                triAlg.unify.WriteTriPath(cla->LitPtr[k]);
            }
            if(/*StrategyParam::orForCompition*/true) {
                if (FileOp::runMode != 0)
                    triAlg.newCla->addRForCompetiton(); //新子句打印到.res文件中,这有结合版本才有此操作
                
                //打印标准输出到.out
                string rStr = "";
                triAlg.newCla->toString(rStr);
                validPathOut[uNewClaID - 1].push_back(cla->uClaId);
                //string out = "cnf(" + to_string(uNewClaID - 1) + ",plain,\n" + "   factoring_inference("+ to_string(cla->uClaId) +")).";
//                int begPos = rStr.find_first_of("[") + 1;
//                int endPos = rStr.find_first_of("]");
//                string rId = rStr.substr(begPos, endPos - begPos);
//                string rContext = rStr.substr(rStr.find_first_of("]") + 1);
//                string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n"+"   inference(factoring_inference"+ "," + "[],"+ "["+to_string(cla->uClaId) +"]"+")).";
//                
                string cnf_str = triAlg.newCla->ToStringWithSemantics(rStr);
                size_t pos = cnf_str.find_last_of(')');
                string cnf_str_sub = cnf_str.substr(0, pos);
                string out = cnf_str_sub + ", nference(factoring_inference,[],[" + to_string(cla->uClaId) + "]" + ")).";
                
                *FileOp::ofOutput << out << endl;
            }
            Clause* newCla = triAlg.newCla;
            //20171020 对子句的含等词的文字进行项序处理
            if (StrategyParam::termRewriting != 2) {
                newCla->directEqn();
            }
            //打印路径
            if (StrategyParam::orForCompition == false)
                FileOp::WriteR(newCla);
            //20170902 生成了归结式立刻清除变元替换项
            //triAlg.unify.ClearVarBind(varBindT);
            vector<UINT32>invaildLitId; //
            string rundMsg; //冗余信息
            Subsumption subsump; //(MOSTRIGHT)
            //参数1 被测的子句指针 参数2 整形数组 参数3 字符串 记录冗余信息
            bool isRundacyR = subsump.GenCla(fol,newCla, invaildLitId, rundMsg);
            if (StrategyParam::orForCompition == false)
                FileOp::RInvaildInfoOut(rundMsg, StartId);
            if (isRundacyR) {
                newCla->DelLits(false);
                delete(newCla);
                triAlg.unify.ClearVarBind(varBindT);
                vSimplyNewR.clear();
                vector<Literal*>().swap(vSimplyNewR);
                resDelFlag = false;
                return 0;
            } else {
                //fol.BackwardSubsump(*newCla); //向后冗余
                preGenCla->push_back(newCla);
                //统一收集后再做冗余处理
                if (newCla->uLitNum == 1)
                    if (StrategyParam::R_Weight == -1)
                        newCla->adeductNum = 0; //权重设置
                    else
                        newCla->adeductNum = StrategyParam::R_Weight;
                else if (StrategyParam::R_Weight == -1)
                        newCla->pdeductNum = 0; //20170217 end//权重设置
                else
                    newCla->pdeductNum = StrategyParam::R_Weight; //20170217 end//权重设置
                fol.InsertCla(newCla);
                fol.setCla.insert(newCla);
                if (StrategyParam::termRewriting != 2){
                    fol.judgeInsertSuper(newCla);
                }
                //20170903 若是正等词单元子句需要加入等词处理中
                //insertNoPairCla(fol, newCla);
                triAlg.unify.ClearVarBind(varBindT);
                vSimplyNewR.clear();
                vector<Literal*>().swap(vSimplyNewR);
                resDelFlag = true;
                return 2;
            }       
        }
        else{//有谓词相同的文字,但是不能合一
            triAlg.unify.ClearVarBind(varBindT);
            resDelFlag = false;
            return 0;
        }
    }
}
//判断子句是否满足等词归结的条件
//返回值说明: 0 负等词不能合一 cla子句不做处理
//1 负等词可以合一 合一后为恒真式
//2 负等词可以合一 合一后生成新子句
int Resolution::negEqnRes(Formula& fol,TriAlg& triAlg,Clause* cla,UINT32& uNewClaID,vector<Clause*>* preGenCla,bool fileNameFlag){
    if(cla->hasOnlyNegEqn()){
        //1.判断项负等词项是否能够合一
        vector<Term*> chgVarT; 
        chgVarT.reserve(6);
        bool flag = false;//判断是否可以进行等词归结
        vector<Literal*> vSimplyNewR;
        vSimplyNewR.reserve(6);
        for(int i=0;i<cla->uLitNum;++i){
            Term* term = cla->LitPtr[i]->subTerm;
            if(term->isNegEqnTerm()){//找到非等词项
                if(term->subTermPtr[0]->isFuncTerm() &&term->subTermPtr[1]->isFuncTerm()){//非等词项都是函数项是,用函数项合一
                    if(triAlg.unify.pairFuncTermMgu(term->subTermPtr[0],term->subTermPtr[1] , chgVarT)){
                        //2 生成R
                        flag = true;
                    }
                    else{
                        triAlg.unify.ClearVarBind(chgVarT);
                        vSimplyNewR.clear();
                        vector<Literal*>().swap(vSimplyNewR);
                        return 0;
                    }
                }
                else{
                    if(triAlg.unify.TermMgu(term->subTermPtr[0],term->subTermPtr[1] , chgVarT)){
                        //2 生成R
                        flag = true;
                    }
                    else{
                        triAlg.unify.ClearVarBind(chgVarT);
                        vSimplyNewR.clear();
                        vector<Literal*>().swap(vSimplyNewR);
                        return 0;
                    }
                }
            }
            vSimplyNewR.push_back(cla->LitPtr[i]);
        }
        if (flag) {
            //1.检查R是否是恒真式 (vSimplyNewR[m]->isPairPred(vSimplyNewR[n]) && triAlg.unify.LitMgu(vSimplyNewR[m], vSimplyNewR[n], chgVarT)
            vector<string> strLit;
            string str;
            if(vSimplyNewR.size()>1) {
                for (int m = 0; m < vSimplyNewR.size(); ++m) {
                    str = "";
                    triAlg.unify.TermToString(vSimplyNewR[m]->subTerm, str);
                    strLit.push_back(str);
                }
            }
            if(strLit.size()>1){//需要判断是否时恒真式
                if(RedundancyOp::CheckTautology(strLit)){
                    triAlg.unify.ClearVarBind(chgVarT);
                     vSimplyNewR.clear();
                    vector<Literal*>().swap(vSimplyNewR);
                    return 1;
                }
            }
            //2生成归结式
            triAlg.newCla = nullptr;
            triAlg.newCla = new Clause(uNewClaID, 0);
            triAlg.newCla->isAxtom = true;
            size_t uRsize = vSimplyNewR.size();
            //文字排序
            if (uRsize > 1)
                stable_sort(vSimplyNewR.begin(), vSimplyNewR.end(), SortRule::LitCmp);
            triAlg.newCla->LitPtr = new Literal*[uRsize];
            for (UINT16 i = 0; i < vSimplyNewR.size(); ++i) {
                Term* litSubT = triAlg.unify.GetNewTerm(vSimplyNewR[i]->subTerm, triAlg.newCla); //参数1：文字谓词项，参数2：新子句指针
                if (TNegEqn == GetCodeProp(litSubT->iTermCode)
                        && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {
                    /*
                    delete(litSubT);*/--uRsize;
                    //delete(newCla->LitPtr[]);
                    continue;
                }
                if (triAlg.newCla->uFuncDepth < litSubT->uLevel)
                    triAlg.newCla->uFuncDepth = litSubT->uLevel;
                triAlg.newCla->uVarCount += litSubT->uVarCount;
                //添加到文字		
                triAlg.newCla->LitPtr[triAlg.newCla->uLitNum] = new Literal(litSubT, EncodeLitCode(uNewClaID, triAlg.newCla->uLitNum + 1), triAlg.newCla, nullptr);
                triAlg.newCla->LitPtr[triAlg.newCla->uLitNum]->parentLitPtr = vSimplyNewR[i]; //母式文字，有R产生
                //triAlg.newCla->LitPtr[triAlg.newCla->uLitNum]->goalDeepth = vSimplyNewR[i]->goalDeepth;
                //20171020 计算演绎深度
                if(triAlg.newCla ->deduceDeepth < (vSimplyNewR[i]->claPtr->deduceDeepth + 1)){
                    triAlg.newCla ->deduceDeepth = vSimplyNewR[i]->claPtr->deduceDeepth + 1;
                }
                 if (vSimplyNewR[i]->claPtr->isAxtom && triAlg.newCla->isAxtom)
                    triAlg.newCla->isAxtom = true;
                else
                    triAlg.newCla->isAxtom = false;
                if(triAlg.hasUnifGoalLit(fol,triAlg.newCla->LitPtr[triAlg.newCla->uLitNum])){
                    triAlg.newCla->LitPtr[triAlg.newCla->uLitNum]->goalDeepth = 1;
                    if(triAlg.newCla->goaldeepth > 1)
                        triAlg.newCla->goaldeepth = 1;
                }
                else{
                    triAlg.newCla->LitPtr[triAlg.newCla->uLitNum]->goalDeepth = vSimplyNewR[i]->goalDeepth;
                      if(triAlg.newCla->goaldeepth > vSimplyNewR[i]->goalDeepth)
                        triAlg.newCla->goaldeepth = vSimplyNewR[i]->goalDeepth;
                }
                //cout<<to_string(newCla->uClaId)  + "]" <<"[" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitRow()) + "_" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitCol()) + "]" << newCla->LitPtr[newCla->uLitNum]->subTerm->ToString()<<endl;  
                ++(triAlg.newCla->uLitNum);
            }
            //Liu Bug修复
            if (uRsize == 0) {
                triAlg.newCla->DelLits(false);
                delete(triAlg.newCla);
                return 0;
            }            
            fol.initGenerateClaAttr(triAlg.newCla);
            uNewClaID++;//通过归结式记录
            //3. 记录演绎路径
            if (!StrategyParam::orForCompition) {
                if(fileNameFlag)
                    FileOp::CreateRunInfoFilePre(30000);
                else
                    FileOp::CreateRunInfoFile(30000);
                *FileOp::ofRealInfoOut << "从编号为" + to_string(cla->uClaId) + "子句开始进行等词归结演绎" << endl;
            }
            for (UINT32 k = 0; k < vSimplyNewR.size(); k++) {
                triAlg.unify.WriteTriPath(vSimplyNewR[k]);
            }
            if (/*StrategyParam::orForCompition*/true) {
                triAlg.newCla->addRForCompetiton();
                
                string rStr = "";
                triAlg.newCla->toString(rStr);
                validPathOut[uNewClaID - 1].push_back(cla->uClaId);
//                int begPos = rStr.find_first_of("[") + 1;
//                int endPos = rStr.find_first_of("]");
//                string rId = rStr.substr(begPos, endPos - begPos);
//                string rContext = rStr.substr(rStr.find_first_of("]") + 1);
//                string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n"+ "   inference(equality_inference,[]," + "["+to_string(cla->uClaId) +"]"+ ")).";
//                
                string cnf_str = triAlg.newCla->ToStringWithSemantics(rStr);
                size_t pos = cnf_str.find_last_of(')');
                string cnf_str_sub = cnf_str.substr(0, pos);
                string out = cnf_str_sub + ", inference(equality_inference,[],[" + to_string(cla->uClaId) + "]" + ")).";
                
                *FileOp::ofOutput << out << endl;
            }

            Clause* newCla = triAlg.newCla;
            //20171020 对子句的含等词的文字进行项序处理
            if (StrategyParam::termRewriting != 2){
                    newCla->directEqn();
            }
            if (!StrategyParam::orForCompition)
                FileOp::WriteR(newCla);
            vector<UINT32>invaildLitId;//
            string rundMsg; //冗余信息
            Subsumption subsump; //(MOSTRIGHT)
            //参数1 被测的子句指针 参数2 整形数组 参数3 字符串 记录冗余信息
            bool isRundacyR = subsump.GenCla(fol,newCla, invaildLitId, rundMsg);
            if (!StrategyParam::orForCompition)
                FileOp::RInvaildInfoOut(rundMsg, StartId);
            if (isRundacyR) {
                newCla->DelLits(false);
                delete(newCla);
                triAlg.unify.ClearVarBind(chgVarT);
                vSimplyNewR.clear();
                vector<Literal*>().swap(vSimplyNewR);
                return 1;
            } else {
                //fol.BackwardSubsump(*newCla); //向后冗余
                preGenCla->push_back(newCla);
                //统一收集后再做冗余处理
                if (newCla->uLitNum == 1)
                    if (StrategyParam::R_Weight == -1)
                        newCla->adeductNum = 0; //权重设置
                    else
                        newCla->adeductNum = StrategyParam::R_Weight;
                else
                    if (StrategyParam::R_Weight == -1)
                    newCla->pdeductNum = 0; //20170217 end//权重设置
                else
                    newCla->pdeductNum = StrategyParam::R_Weight; //20170217 end//权重设置
                fol.InsertCla(newCla);
//                if(StrategyParam::useSaturate)
//                    fol.setDeductCla.insert(newCla);
//                else
                    fol.setCla.insert(newCla);
                
                if (StrategyParam::termRewriting != 2)
                    fol.judgeInsertSuper(newCla);
               
                //insertNoPairCla(fol, newCla);
            }
            triAlg.unify.ClearVarBind(chgVarT);
            vSimplyNewR.clear();
            vector<Literal*>().swap(vSimplyNewR);
            return 2;
        }
    }
    else
        return 0;
    
} 
//20170901 以下基于等词项的调解
//对子句集进行调解
int Resolution::demodulatorClaSet(Formula& fol,TriAlg& triAlg,UINT32& uNewClaID,vector<Clause*>* preGenCla,UINT32 simplyIdStart,UINT32 simplyIdEnd){
    if(fol.eqnDemod.size() == 0){
        return 0;
    }
    set<Clause*>::iterator claP_it = fol.setCla.begin();
//    UINT32 size = fol.setCla.size();
//    UINT32 count = 0;
    for (; claP_it != fol.setCla.end();) {
         if(((*claP_it)->uClaId <= simplyIdEnd) && ((*claP_it)->uClaId >= simplyIdStart)) {
            if ((*claP_it)->isUintEqn()) {
                ++claP_it;
                continue;
            }

            int res = demodulatorCla(fol, triAlg, *claP_it, uNewClaID, preGenCla);
            set<Clause*> ::iterator delIt = fol.setOriClas.find(*claP_it);
            if (delIt != fol.setOriClas.end()) {
                fol.setOriClas.erase(delIt);
            }
            set<Clause*> ::iterator delItNoPair = fol.noPairSingleCla.find(*claP_it);
            if (delItNoPair != fol.noPairSingleCla.end()) {
                fol.noPairSingleCla.erase(delItNoPair);
            }
            string out = "#子句编号[" + to_string((*claP_it)->uClaId) + "]被调解后删除";
            FileOp::LogOut(out);
            (*claP_it)->DelLits();
            delete((*claP_it));
            claP_it = fol.setCla.erase(claP_it);
         }
         else
             ++claP_it;
//        ++count;
//        if(count > size){
//            break;
//        }
//        if((*claP_it)->uVarCount > 0){
//            ++claP_it;
//            continue;
//        }
        
//        if( res == 0){//子句没有调解项
//            ++claP_it;
//            continue;
//        }
//        else if( res == 1){//子句可以调解,调解后成为冗余子句,原子句删除
//            set<Clause*> ::iterator delIt = fol.setOriClas.find(*claP_it);
//            if (delIt != fol.setOriClas.end()) {
//                fol.setOriClas.erase(delIt);
//            }
//            set<Clause*> ::iterator delItNoPair = fol.noPairSingleCla.find(*claP_it);
//            if (delItNoPair != fol.noPairSingleCla.end()) {
//                fol.noPairSingleCla.erase(delItNoPair);
//            }
//            string out = "#子句编号[" + to_string((*claP_it)->uClaId) + "]被调解后删除";
//            FileOp::LogOut(out);
//            (*claP_it)->DelLits();
//            delete((*claP_it));
//            claP_it = fol.setCla.erase(claP_it);
//        }
//        else if(res == 2){//子句可以调解,调解后生成新子句,原子句删除,如果含有变元怎么办?
//            set<Clause*> ::iterator delIt = fol.setOriClas.find(*claP_it);
//            if (delIt != fol.setOriClas.end()) {
//                fol.setOriClas.erase(delIt);
//            }
//            set<Clause*> ::iterator delItNoPair = fol.noPairSingleCla.find(*claP_it);
//            if (delItNoPair != fol.noPairSingleCla.end()) {
//                fol.noPairSingleCla.erase(delItNoPair);
//            }
//            string out = "#子句编号[" + to_string((*claP_it)->uClaId) + "]被调解后删除";
//            FileOp::LogOut(out);
//            (*claP_it)->DelLits();
//            delete((*claP_it));
//            claP_it = fol.setCla.erase(claP_it);
//        }
    }
    return 1;
}
//对子句进行调解,此时若有调解产生,则要生成新的子句
int Resolution::demodulatorCla(Formula& fol,TriAlg& triAlg,Clause* cla,UINT32& uNewClaID,vector<Clause*>* preGenCla){//preGenCla 记录新生成的子句
    bool flag = false;
    varBindTerm.clear();//保存每个子句在调解过程中的替换项
    vector<Clause*> eqnLit;//记录调解的等词单元子句
    eqnLit.reserve(2);
    for(UINT32 i=0; i<cla->uLitNum; ++i){
        if(cla->LitPtr[i]->subTerm->isEqnTerm() == false){
            continue;
        }
        if(cla->LitPtr[i]->isConLit() == false){
            continue;
        }
        if(demodulatorLit(fol, triAlg,cla->LitPtr[i], uNewClaID, &eqnLit)){
            flag = true;
        }
    }
    //如果子句有项进行了调解,则要进行下一步的处理:1. 生成新子句 2. 清除绑定的替换项 3. 删除原始子句
    if (!flag){
        triAlg.unify.ClearVarBind(varBindTerm);
        return 0;//子句不能调解
    }
    else {
        //1.生成新子句
        vector<Literal*> vInsertNewR;
        vInsertNewR.reserve(6);
        for (UINT32 i = 0; i < cla->uLitNum; ++i)
            vInsertNewR.push_back(cla->LitPtr[i]);
        for (size_t rInd = 0; rInd < vInsertNewR.size() - 1; ++rInd) {
            Literal* rA = vInsertNewR[rInd];
            for (size_t rIndB = rInd + 1; rIndB < vInsertNewR.size();) {
                Literal* rB = vInsertNewR[rIndB];
                if (rA->subTerm->iTermCode == rB->subTerm->iTermCode && triAlg.unify.CheckEqn(rA->subTerm, rB->subTerm)) {
                    swap(vInsertNewR[rIndB], vInsertNewR[vInsertNewR.size() - 1]);
                    vInsertNewR.pop_back();
                } else
                    ++rIndB;
            }
        }
        Clause* newCla = nullptr;
        if (!vInsertNewR.empty()) {
            //查看是否冗余20170101
            newCla = new Clause(uNewClaID, 0);
            newCla->isAxtom = true;
            size_t uRsize = vInsertNewR.size();
            //文字排序
            if (uRsize > 1)
                stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmp);
            newCla->LitPtr = new Literal*[uRsize];
            for (UINT16 i = 0; i < vInsertNewR.size(); ++i) {
                Term* litSubT = triAlg.unify.GetNewTermSuper(vInsertNewR[i]->subTerm, newCla); //参数1：文字谓词项，参数2：新子句指针
                if (TNegEqn == GetCodeProp(litSubT->iTermCode)
                        && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {
                    /*
                    delete(litSubT);*/--uRsize;
                    //delete(newCla->LitPtr[]);
                    continue;
                }
                if (newCla->uFuncDepth < litSubT->uLevel)newCla->uFuncDepth = litSubT->uLevel;
                newCla->uVarCount += litSubT->uVarCount;
                //添加到文字		
                newCla->LitPtr[newCla->uLitNum] = new Literal(litSubT, EncodeLitCode(uNewClaID, newCla->uLitNum + 1), newCla, nullptr);
                newCla->LitPtr[newCla->uLitNum]->parentLitPtr = vInsertNewR[i]; //母式文字，有R产生
                //newCla->LitPtr[newCla->uLitNum]->goalDeepth = vInsertNewR[i]->goalDeepth;
                //20171020 计算演绎深度
                if(newCla ->deduceDeepth < (vInsertNewR[i]->claPtr->deduceDeepth + 1)){
                    newCla ->deduceDeepth = vInsertNewR[i]->claPtr->deduceDeepth + 1;
                }
                if (vInsertNewR[i]->claPtr->isAxtom && newCla->isAxtom)
                    newCla->isAxtom = true;
                else
                    newCla->isAxtom = false;
                if (triAlg.hasUnifGoalLit(fol, newCla->LitPtr[newCla->uLitNum])) {
                    newCla->LitPtr[newCla->uLitNum]->goalDeepth = 1;
                    if (newCla->goaldeepth > 1)
                        newCla->goaldeepth = 1;
                } else {
                    newCla->LitPtr[newCla->uLitNum]->goalDeepth = vInsertNewR[i]->goalDeepth;
                    if (newCla->goaldeepth > vInsertNewR[i]->goalDeepth)
                        newCla->goaldeepth = vInsertNewR[i]->goalDeepth;
                }
                //cout<<to_string(newCla->uClaId)  + "]" <<"[" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitRow()) + "_" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitCol()) + "]" << newCla->LitPtr[newCla->uLitNum]->subTerm->ToString()<<endl;  
                ++(newCla->uLitNum);
            }
             //Liu Bug修复
            if (uRsize == 0) {
                newCla->DelLits(false);
                delete(newCla);
                return 0;
            }           
            fol.initGenerateClaAttr(newCla);
            ++uNewClaID;
             //20171020 对子句的含等词的文字进行项序处理
            if (StrategyParam::termRewriting != 2) {
                newCla->directEqn();
            }
            
            //triAlg.unify.ClearVarBind(varBindTerm);//20170902 生成了新子句应该立刻清除项的替换项
//            if(triAlg.claHasPureLit(fol,newCla)){
//                newCla->DelLits(false);
//                delete(newCla);
//                triAlg.unify.ClearVarBind(varBindTerm);
//                vInsertNewR.clear();
//                vector<Literal*>().swap(vInsertNewR);
//                return 1;//调解后子句变成冗余,原始的子句也得删除
//            }
            vector<UINT32>invaildLitId;//
            string rundMsg; //冗余信息
            Subsumption subsump; //(MOSTRIGHT)
            //参数1 被测的子句指针 参数2 整形数组 参数3 字符串 记录冗余信息
            bool isRundacyR = subsump.GenCla(fol,newCla, invaildLitId, rundMsg);
            //FileOp::RInvaildInfoOut(rundMsg, StartId);
            if (isRundacyR) {
                newCla->DelLits(false);
                delete(newCla);
                triAlg.unify.ClearVarBind(varBindTerm);
                vInsertNewR.clear();
                vector<Literal*>().swap(vInsertNewR);
                return 1;//调解后子句变成冗余,原始的子句也得删除
            } else {
                //2. 记录演绎路径
                FileOp::CreateRunInfoFilePre(10000);
                *FileOp::ofRealInfoOut << "从编号为" + to_string(cla->uClaId) + "子句开始构建三角形" << endl;
                for (UINT8 k = 0; k < eqnLit.size(); ++k) {
                    triAlg.unify.WriteTriPath(eqnLit[k]->LitPtr[0]);
                }
                for (UINT32 i = 0; i < cla->uLitNum; ++i) {
                    triAlg.unify.WriteTriPath(cla->LitPtr[i]);
                }
                if (StrategyParam::orForCompition) {
                    newCla->addRForCompetiton();
                    
                    string rStr = "";
                    newCla->toString(rStr);
                    
                    string outClauses = "";
                    for (UINT8 k = 0; k < eqnLit.size(); ++k){
                        outClauses += "c_0_" + to_string(eqnLit[k]->uClaId) + ",";
                        validPathOut[uNewClaID - 1].push_back(eqnLit[k]->uClaId);
                    }
                    outClauses += to_string(cla->uClaId);
                    validPathOut[uNewClaID - 1].push_back(cla->uClaId);
//                    int begPos = rStr.find_first_of("[") + 1;
//                    int endPos = rStr.find_first_of("]");
//                    string rId = rStr.substr(begPos, endPos - begPos);
//                    string rContext = rStr.substr(rStr.find_first_of("]") + 1);
//                    string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n" + "   inference(rewriting,[]," + "[" + outClauses +"]" + ")).";
//                   
                    string cnf_str = newCla->ToStringWithSemantics(rStr);
                    size_t pos = cnf_str.find_last_of(')');
                    string cnf_str_sub = cnf_str.substr(0, pos);
                    string out = cnf_str_sub + ", inference(rewriting,[],[" + outClauses + "]" + ")).";
                    
                    *FileOp::ofOutput << out << endl;
                }
                FileOp::WriteR(newCla);
                rundMsg = "|[Y]";
                FileOp::RInvaildInfoOut(rundMsg, StartId);
                //fol.BackwardSubsump(*newCla); //向后冗余
                preGenCla->push_back(newCla);
                //统一收集后再做冗余处理
                if (newCla->uLitNum == 1)
                    if (StrategyParam::R_Weight == -1)
                        newCla->adeductNum = 0; //权重设置
                    else
                        newCla->adeductNum = StrategyParam::R_Weight;
                else
                    if (StrategyParam::R_Weight == -1)
                       newCla->pdeductNum = 0; //20170217 end//权重设置
                   else
                       newCla->pdeductNum = StrategyParam::R_Weight; //20170217 end//权重设置
                fol.InsertCla(newCla);
                fol.setCla.insert(newCla);
                if (StrategyParam::termRewriting != 2)
                    fol.judgeInsertSuper(newCla);
            }
            //3.清除替换项
            triAlg.unify.ClearVarBind(varBindTerm);
            vInsertNewR.clear();
            vector<Literal*>().swap(vInsertNewR);
            return 2;//子句可以调解,并生成了新子句
        }
    }
    
}
//专用于带浸透的等词处理
int Resolution::demodulatorClaSaturate(Formula& fol,TriAlg& triAlg,Clause* cla,UINT32& uNewClaID,vector<Clause*>* preGenCla){//preGenCla 记录新生成的子句
    bool flag = false;
    varBindTerm.clear();//保存每个子句在调解过程中的替换项
    vector<Clause*> eqnLit;//记录调解的等词单元子句
    eqnLit.reserve(2);
    for(UINT32 i=0; i<cla->uLitNum; ++i){
        
        if((StrategyParam::termRewriting == 0)&&(cla->LitPtr[i]->subTerm->isPLitTerm()))
            continue;
        if(demodulatorLitSaturate(fol, triAlg,cla->LitPtr[i], uNewClaID, &eqnLit)){
            flag = true;
        }
    }
    //如果子句有项进行了调解,则要进行下一步的处理:1. 生成新子句 2. 清除绑定的替换项 3. 删除原始子句
    if (!flag){
        triAlg.unify.ClearVarBind(varBindTerm);
        return 0;//子句不能调解
    }
    else {
        //1.生成新子句
        vector<Literal*> vInsertNewR;
        vInsertNewR.reserve(6);
        for (UINT32 i = 0; i < cla->uLitNum; ++i)
            vInsertNewR.push_back(cla->LitPtr[i]);
        for (size_t rInd = 0; rInd < vInsertNewR.size() - 1; ++rInd) {
            Literal* rA = vInsertNewR[rInd];
            for (size_t rIndB = rInd + 1; rIndB < vInsertNewR.size();) {
                Literal* rB = vInsertNewR[rIndB];
                if (rA->subTerm->iTermCode == rB->subTerm->iTermCode && triAlg.unify.CheckEqn(rA->subTerm, rB->subTerm)) {
                    swap(vInsertNewR[rIndB], vInsertNewR[vInsertNewR.size() - 1]);
                    vInsertNewR.pop_back();
                } else
                    ++rIndB;
            }
        }
        Clause* newCla = nullptr;
        if (!vInsertNewR.empty()) {
            //查看是否冗余20170101
            newCla = new Clause(uNewClaID, 0);
            newCla->isAxtom = true;
            size_t uRsize = vInsertNewR.size();
            //文字排序
            if (uRsize > 1)
                stable_sort(vInsertNewR.begin(), vInsertNewR.end(), SortRule::LitCmp);
            newCla->LitPtr = new Literal*[uRsize];
            for (UINT16 i = 0; i < vInsertNewR.size(); ++i) {
                Term* litSubT = triAlg.unify.GetNewTermSuper(vInsertNewR[i]->subTerm, newCla); //参数1：文字谓词项，参数2：新子句指针
                if (TNegEqn == GetCodeProp(litSubT->iTermCode)
                        && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {
                    /*
                    delete(litSubT);*/--uRsize;
                    //delete(newCla->LitPtr[]);
                    continue;
                }
                if (newCla->uFuncDepth < litSubT->uLevel)newCla->uFuncDepth = litSubT->uLevel;
                newCla->uVarCount += litSubT->uVarCount;
                //添加到文字		
                newCla->LitPtr[newCla->uLitNum] = new Literal(litSubT, EncodeLitCode(uNewClaID, newCla->uLitNum + 1), newCla, nullptr);
                newCla->LitPtr[newCla->uLitNum]->parentLitPtr = vInsertNewR[i]; //母式文字，有R产生
                //newCla->LitPtr[newCla->uLitNum]->goalDeepth = vInsertNewR[i]->goalDeepth;
                //20171020 计算演绎深度
                if(newCla ->deduceDeepth < (vInsertNewR[i]->claPtr->deduceDeepth + 1)){
                    newCla ->deduceDeepth = vInsertNewR[i]->claPtr->deduceDeepth + 1;
                }
                if (vInsertNewR[i]->claPtr->isAxtom && newCla->isAxtom)
                    newCla->isAxtom = true;
                else
                    newCla->isAxtom = false;
                if (triAlg.hasUnifGoalLit(fol, newCla->LitPtr[newCla->uLitNum])) {
                    newCla->LitPtr[newCla->uLitNum]->goalDeepth = 1;
                    if (newCla->goaldeepth > 1)
                        newCla->goaldeepth = 1;
                } else {
                    newCla->LitPtr[newCla->uLitNum]->goalDeepth = vInsertNewR[i]->goalDeepth;
                    if (newCla->goaldeepth > vInsertNewR[i]->goalDeepth)
                        newCla->goaldeepth = vInsertNewR[i]->goalDeepth;
                }
                //cout<<to_string(newCla->uClaId)  + "]" <<"[" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitRow()) + "_" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitCol()) + "]" << newCla->LitPtr[newCla->uLitNum]->subTerm->ToString()<<endl;  
                ++(newCla->uLitNum);
            }
             //Liu Bug修复
            if (uRsize == 0) {
                newCla->DelLits(false);
                delete(newCla);
                return 0;
            } 
            fol.initGenerateClaAttr(newCla);
            ++uNewClaID;
             //20171020 对子句的含等词的文字进行项序处理
            if (StrategyParam::termRewriting != 2) {
                newCla->directEqn();
            }
            
            //triAlg.unify.ClearVarBind(varBindTerm);//20170902 生成了新子句应该立刻清除项的替换项
//            if(triAlg.claHasPureLit(fol,newCla)){
//                newCla->DelLits(false);
//                delete(newCla);
//                triAlg.unify.ClearVarBind(varBindTerm);
//                vInsertNewR.clear();
//                vector<Literal*>().swap(vInsertNewR);
//                return 1;//调解后子句变成冗余,原始的子句也得删除
//            }
            vector<UINT32>invaildLitId;//
            string rundMsg; //冗余信息
            Subsumption subsump; //(MOSTRIGHT)
            //参数1 被测的子句指针 参数2 整形数组 参数3 字符串 记录冗余信息
            bool isRundacyR = subsump.GenCla(fol,newCla, invaildLitId, rundMsg);
            //FileOp::RInvaildInfoOut(rundMsg, StartId);
            if (isRundacyR) {
//                FileOp::CreateRunInfoFilePre(10000);
//                //FileOp::CreateRunInfoFile(cla->uClaId / 1000);
//                *FileOp::ofRealInfoOut << "从编号为" + to_string(cla->uClaId) + "子句开始进行项调解" << endl;
//                for (UINT8 k = 0; k < eqnLit.size(); ++k) {
//                    triAlg.unify.WriteTriPath(eqnLit[k]->LitPtr[0]);
//                }
//                for (UINT32 i = 0; i < cla->uLitNum; ++i) {
//                    triAlg.unify.WriteTriPath(cla->LitPtr[i]);
//                }
//                FileOp::WriteR(newCla);
//                //rundMsg = "|[Y]";
//                FileOp::RInvaildInfoOut(rundMsg, StartId);
                
//                FileOp::CreateRunInfoFilePre(10000);
//                string logMsg = to_string(newCla->uClaId) + rundMsg;
//                FileOp::RInvaildInfoOutPath(logMsg, StartId);
                newCla->DelLits(false);
                delete(newCla);
                triAlg.unify.ClearVarBind(varBindTerm);
                vInsertNewR.clear();
                vector<Literal*>().swap(vInsertNewR);
                return 1;//调解后子句变成冗余,原始的子句也得删除
            } else {
                //2. 记录演绎路径
                if (!StrategyParam::orForCompition) {
                    FileOp::CreateRunInfoFilePre(10000);
                    //FileOp::CreateRunInfoFile(cla->uClaId / 1000);
                    *FileOp::ofRealInfoOut << "从编号为" + to_string(cla->uClaId) + "子句开始进行项调解" << endl;
                }
                for (UINT8 k = 0; k < eqnLit.size(); ++k) {
                    triAlg.unify.WriteTriPath(eqnLit[k]->LitPtr[0]);
                }
                for (UINT32 i = 0; i < cla->uLitNum; ++i) {
                    triAlg.unify.WriteTriPath(cla->LitPtr[i]);
                }
                if (/*StrategyParam::orForCompition*/true) {
                    if (FileOp::runMode != 0)
                        newCla->addRForCompetiton();
                    
                    string rStr = "";
                    newCla->toString(rStr);
                    string outClauses = "";
                    for (UINT8 k = 0; k < eqnLit.size(); ++k){
                        outClauses += "c_0_" + to_string(eqnLit[k]->uClaId) + ",";
                        validPathOut[uNewClaID - 1].push_back(eqnLit[k]->uClaId);
                    }
                    outClauses += to_string(cla->uClaId);
                    validPathOut[uNewClaID - 1].push_back(cla->uClaId);
                    //string out = "cnf(" + to_string(uNewClaID - 1) + ",plain,\n" + "   rewriting(" + outClauses + ")).";
//                    int begPos = rStr.find_first_of("[") + 1;
//                    int endPos = rStr.find_first_of("]");
//                    string rId = rStr.substr(begPos, endPos - begPos);
//                    string rContext = rStr.substr(rStr.find_first_of("]") + 1);
//                    string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n" + "   inference(rewriting,[]," + "[" + outClauses +"]" + ")).";
//                    
                    string cnf_str = newCla->ToStringWithSemantics(rStr);
                    size_t pos = cnf_str.find_last_of(')');
                    string cnf_str_sub = cnf_str.substr(0, pos);
                    string out = cnf_str_sub + ", inference(rewriting,[],[" + outClauses + "]" + ")).";
                    
                    *FileOp::ofOutput << out << endl;
                }
                if (!StrategyParam::orForCompition) {
                    FileOp::WriteR(newCla);
                    rundMsg = "|[Y]";
                    FileOp::RInvaildInfoOut(rundMsg, StartId);
                }
                //fol.BackwardSubsump(*newCla); //向后冗余
                preGenCla->push_back(newCla);
                //统一收集后再做冗余处理
                if (newCla->uLitNum == 1)
                    if (StrategyParam::R_Weight == -1)
                        newCla->adeductNum = 0; //权重设置
                    else
                        newCla->adeductNum = StrategyParam::R_Weight;
                else
                    if (StrategyParam::R_Weight == -1)
                       newCla->pdeductNum = 0; //20170217 end//权重设置
                   else
                       newCla->pdeductNum = StrategyParam::R_Weight; //20170217 end//权重设置
                fol.InsertCla(newCla);
//                if(StrategyParam::useSaturate)
//                    fol.setDeductCla.insert(newCla);
//                else
                    fol.setCla.insert(newCla);
                if (StrategyParam::termRewriting != 2)
                    fol.judgeInsertSuper(newCla);
            }
            //3.清除替换项
            triAlg.unify.ClearVarBind(varBindTerm);
            vInsertNewR.clear();
            vector<Literal*>().swap(vInsertNewR);
            return 2;//子句可以调解,并生成了新子句
        }
    }
    
}
//对文字进行调解
int Resolution::demodulatorLit(Formula& fol,TriAlg& triAlg,Literal* lit,UINT32& uNewClaID,vector<Clause*>* eqnLit){
    bool flag = false;
    vector<Term*> termVec;
    termVec.reserve(6);
    lit->subTerm->recordTerm(&termVec);//记录文字的每个项
    set<Clause*>::iterator claP_it = fol.eqnDemod.begin();
    assert(termVec.size() >0);
    UINT8 funCount = 0;
    for(UINT32 i=1; i< termVec.size(); ++i) {//谓词项去掉 变元项去掉
        //Term* termBind = triAlg.unify.GetBindingT(termVec[i]);
        if(termVec[i]->isVar())//变元项
            continue;
        else if(termVec[i]->vBinding){
            if(termVec[i]->isFuncTerm()){
                funCount = termVec[i]->uSubTermNum;
            }
        }
        else if(termVec[i]->isFuncTerm()){//函数项
            if(demodulatorTerm(fol, triAlg,termVec[i], uNewClaID, eqnLit)){
                flag = true;
                funCount = termVec[i]->uSubTermNum;
            }
        }
        else{//常元项
            if(demodulatorTerm(fol, triAlg,termVec[i], uNewClaID, eqnLit)){
                flag = true;
            }
        }
        if(funCount != 0){
            i += funCount;
            funCount = 0;
        }
    }
    if(flag)
        return 1;
    else
        return 0;
}

int Resolution::demodulatorLitSaturate(Formula& fol,TriAlg& triAlg,Literal* lit,UINT32& uNewClaID,vector<Clause*>* eqnLit){
    bool flag = false;
//    UINT8 funCount = 0;
//    for(UINT32 i=0; i< lit->subTerm->uSubTermNum; ++i) {//谓词项去掉 变元项去掉
//        //Term* termBind = triAlg.unify.GetBindingT(termVec[i]);
//        Term* demodTerm = lit->subTerm->subTermPtr[i];
//        demodulatorTermSaturate(fol, triAlg,demodTerm, uNewClaID, eqnLit);
//    }
    vector<Term*> termVec;
    termVec.reserve(6);
    lit->subTerm->recordTerm(&termVec);//记录文字的每个项
    assert(termVec.size() >0);
    UINT8 funCount = 0;
    for(UINT32 i=1; i< termVec.size(); ++i) {//谓词项去掉 变元项去掉
        //Term* termBind = triAlg.unify.GetBindingT(termVec[i]);
        if(termVec[i]->isVar())//变元项
            continue;
        else if(termVec[i]->vBinding){
            if(termVec[i]->isFuncTerm()){
                funCount = termVec[i]->uSubTermNum;
            }
        }
        else if(termVec[i]->isFuncTerm()){//函数项
            if(demodulatorTermSaturate(fol, triAlg,termVec[i], uNewClaID, eqnLit)){
                flag = true;
                funCount = termVec[i]->uSubTermNum;
            }
        }
        else{//常元项
            continue;
        }
        if(funCount != 0){
            i += funCount;
            funCount = 0;
        }
    }
    if(flag)
        return 1;
    else
        return 0;
}
//对项进行调解,规定必须是常元替换常元,或函数项替换函数项
//重点:什么样的项可以进行调解,必须形式一样.
//1.项的个数1项,子项的个数也一样
int Resolution::demodulatorTerm(Formula& fol,TriAlg& triAlg,Term* term,UINT32& uNewClaID,vector<Clause*>* eqnLit){
    bool flag = false;
    
    vector<Term*> chgVarT;
    vector<Term*> chgVarTEqn;
    chgVarT.reserve(6);
    chgVarTEqn.reserve(6);
    vector<Literal*> vSimplyNewR;
    vSimplyNewR.reserve(6);
    UINT32 termCount = 0;
    UINT32 demodulCount = 0;
    term->countTerm(termCount);
    if(term->isFuncTerm()){//如果调解的是函数项
        set<Clause*>::iterator claP_it = fol.eqnDemod.begin();
        for (; claP_it != fol.eqnDemod.end();) {
            Term* demodulGoal = (*claP_it)->LitPtr[0]->subTerm->subTermPtr[0];
            demodulCount = 0;
            demodulGoal->countTerm(demodulCount);
            if(demodulGoal->isVar()){//目标项是变元,直接合一
                if(triAlg.unify.TermMguEqn(term,demodulGoal,chgVarT,chgVarTEqn)) {
                    if (triAlg.unify.GetBindingT(demodulGoal) == ((*claP_it)->LitPtr[0]->subTerm->subTermPtr[1])) {
                        triAlg.unify.ClearVarBind(chgVarT);
                        triAlg.unify.ClearVarBind(chgVarTEqn);
                    }
                    else
                    {
                        if (find(eqnLit->begin(), eqnLit->end(), *claP_it) == eqnLit->end())
                            eqnLit->push_back(*claP_it);
                        //triAlg.unify.ClearVarBind(chgVarTEqn);
                        varBindTerm.insert(varBindTerm.end(), chgVarT.begin(), chgVarT.end());
                        varBindTerm.insert(varBindTerm.end(), chgVarTEqn.begin(), chgVarTEqn.end());
                        chgVarT.clear();
                        term->vBinding = (*claP_it)->LitPtr[0]->subTerm->subTermPtr[1];
                        varBindTerm.push_back(term);
                        flag = true;
                        break;
                    }
                }
                else{
                    triAlg.unify.ClearVarBind(chgVarT);
                    triAlg.unify.ClearVarBind(chgVarTEqn);
                }
            }
            else if((term->iTermCode == demodulGoal->iTermCode) &&(termCount == demodulCount ) && term->similarTerm(demodulGoal)){//目标项函数项
                if(triAlg.unify.pairFuncTermMguEqn(term,demodulGoal,chgVarT,chgVarTEqn)) {
                    if (triAlg.unify.GetBindingT(demodulGoal) == ((*claP_it)->LitPtr[0]->subTerm->subTermPtr[1])) {
                        triAlg.unify.ClearVarBind(chgVarT);
                        triAlg.unify.ClearVarBind(chgVarTEqn);
                    } else {
                        if (find(eqnLit->begin(), eqnLit->end(), *claP_it) == eqnLit->end())
                            eqnLit->push_back(*claP_it);
                        //triAlg.unify.ClearVarBind(chgVarTEqn);
                        varBindTerm.insert(varBindTerm.end(), chgVarT.begin(), chgVarT.end());
                        varBindTerm.insert(varBindTerm.end(), chgVarTEqn.begin(), chgVarTEqn.end());
                        chgVarT.clear();
                        term->vBinding = (*claP_it)->LitPtr[0]->subTerm->subTermPtr[1];
                        varBindTerm.push_back(term);
                        flag = true;
                        break;
                    }
                } 
                else{
                    triAlg.unify.ClearVarBind(chgVarT);
                    triAlg.unify.ClearVarBind(chgVarTEqn);
                }
            }
            ++claP_it;
        }
    }
    else{
        set<Clause*>::iterator claP_it = fol.eqnDemod.begin();
        for (; claP_it != fol.eqnDemod.end();) {
            Term* demodulGoal = (*claP_it)->LitPtr[0]->subTerm->subTermPtr[0];
            if(demodulGoal->isVar()){//目标项是变元,直接合一
                if(triAlg.unify.TermMguEqn(term,demodulGoal,chgVarT,chgVarTEqn)) {
                    if (triAlg.unify.GetBindingT(demodulGoal) == ((*claP_it)->LitPtr[0]->subTerm->subTermPtr[1])) {
                        triAlg.unify.ClearVarBind(chgVarT);
                        triAlg.unify.ClearVarBind(chgVarTEqn);
                    } else {
                        if (find(eqnLit->begin(), eqnLit->end(), *claP_it) == eqnLit->end())
                            eqnLit->push_back(*claP_it);
                        //triAlg.unify.ClearVarBind(chgVarTEqn);
                        varBindTerm.insert(varBindTerm.end(), chgVarT.begin(), chgVarT.end());
                        varBindTerm.insert(varBindTerm.end(), chgVarTEqn.begin(), chgVarTEqn.end());
                        chgVarT.clear();
                        term->vBinding = (*claP_it)->LitPtr[0]->subTerm->subTermPtr[1];
                        varBindTerm.push_back(term);
                        flag = true;
                        break;
                    }
                }
                else{
                    triAlg.unify.ClearVarBind(chgVarT);
                    triAlg.unify.ClearVarBind(chgVarTEqn);
                }
            }
            else if((term->iTermCode == demodulGoal->iTermCode)  &&(termCount == demodulCount )&& term->similarTerm(demodulGoal)){//目标项函数项
                if(triAlg.unify.TermMguEqn(term,demodulGoal,chgVarT,chgVarTEqn)) {
                    if (triAlg.unify.GetBindingT(demodulGoal) == ((*claP_it)->LitPtr[0]->subTerm->subTermPtr[1])) {
                        triAlg.unify.ClearVarBind(chgVarT);
                        triAlg.unify.ClearVarBind(chgVarTEqn);
                    } else {
                        if (find(eqnLit->begin(), eqnLit->end(), *claP_it) == eqnLit->end())
                            eqnLit->push_back(*claP_it);
                        //triAlg.unify.ClearVarBind(chgVarTEqn);
                        varBindTerm.insert(varBindTerm.end(), chgVarT.begin(), chgVarT.end());
                        varBindTerm.insert(varBindTerm.end(), chgVarTEqn.begin(), chgVarTEqn.end());
                        chgVarT.clear();
                        term->vBinding = (*claP_it)->LitPtr[0]->subTerm->subTermPtr[1];
                        varBindTerm.push_back(term);
                        flag = true;
                        break;
                    }
                }  
                else{
                    triAlg.unify.ClearVarBind(chgVarT);
                    triAlg.unify.ClearVarBind(chgVarTEqn);
                }
            }
            ++claP_it;
        }
    }
    if(flag)
        return 1;
    else
        return 0;
}

int Resolution::demodulatorTermSaturate(Formula& fol,TriAlg& triAlg,Term* term,UINT32& uNewClaID,vector<Clause*>* eqnLit){
    bool flag = false;
    
    vector<Term*> chgVarT;
    vector<Term*> chgVarTEqn;
    chgVarT.reserve(6);
    chgVarTEqn.reserve(6);
    vector<Literal*> vSimplyNewR;
    vSimplyNewR.reserve(6);
    //1.计算项的个数
    UINT32 termCount = 0;
    UINT32 varTermCount = 0;
    term->countTerm(termCount);
    term->countVarTerm(varTermCount);
    //20171022 计算非重复变元项的个数
    vector<INT32> saveTerm;
    saveTerm.reserve(6);
    UINT32 varUqTermCount = 0;
    term->countUqVarTerm(varUqTermCount,saveTerm);
    saveTerm.clear();
    vector<INT32>().swap(saveTerm);
    
    if((termCount == 1))//变元或常元不做替换
        return 0;
    set<Clause*>::iterator claP_it = fol.eqnDemod.begin();
    for (; claP_it != fol.eqnDemod.end();) {
        if((*claP_it)->LitPtr == nullptr){
             ++claP_it;
            continue;
        }
        Term* demodulGoal = (*claP_it)->LitPtr[0]->subTerm->subTermPtr[0];//查看这两个项能否合一
//        demodulGoal->Print();
//        cout<<endl;
//        cout<<"------------"<<endl;
//        term->Print();
//        cout<<endl;
        UINT32 termGoalCount = 0;
        UINT32 varTermGoalCount = 0;
        demodulGoal->countTerm(termGoalCount);
        demodulGoal->countVarTerm(varTermGoalCount);

        //20171022 计算非重复变元项的个数
        vector<INT32> saveDemodulGoal;
        saveDemodulGoal.reserve(6);
        UINT32 varUqDemodulGoalCount = 0;
        demodulGoal->countUqVarTerm(varUqDemodulGoalCount, saveDemodulGoal);
        saveDemodulGoal.clear();
        vector<INT32>().swap(saveDemodulGoal);
        //当替换的非重复变元项不一致时,不重写
//        if(varUqTermCount != varUqDemodulGoalCount){
//            ++claP_it;
//            continue;
//        }
        //20171020 这个是关键,必须要保证项重写的合理性  demodulGoal
        if((term->isFuncTerm()) &&(demodulGoal->isFuncTerm()) && (term->iTermCode != demodulGoal->iTermCode))
        {
            ++claP_it;
            continue;
        }     
        if(termCount < termGoalCount)
        {
            ++claP_it;
            continue;
        }
//        if((varTermCount != varTermGoalCount)){
//            ++claP_it;
//            continue;
//        }
//        if((term->IsShareVarLit()&&demodulGoal->IsSingleVarLit()) ||(demodulGoal->IsShareVarLit()&&term->IsSingleVarLit())){
//            ++claP_it;
//            continue;
//        }
        bool demod = true;
        if(varTermCount == 0){
            demod = true;
        }
        else if(varUqTermCount > varUqDemodulGoalCount){
            demod = false;
        }
        //此时可以确定都是函数项
        //比较调解的两个项是否结构相同
        if (demod && term->similarTerm(demodulGoal)) {
            if (triAlg.unify.pairFuncTermMguEqn(term, demodulGoal, chgVarT, chgVarTEqn)) {
                if (triAlg.unify.GetBindingT(demodulGoal) == ((*claP_it)->LitPtr[0]->subTerm->subTermPtr[1])) {
                    triAlg.unify.ClearVarBind(chgVarT);
                    triAlg.unify.ClearVarBind(chgVarTEqn);
                } else {
                    if (find(eqnLit->begin(), eqnLit->end(), *claP_it) == eqnLit->end())
                        eqnLit->push_back(*claP_it);
                    //triAlg.unify.ClearVarBind(chgVarTEqn);
                    varBindTerm.insert(varBindTerm.end(), chgVarT.begin(), chgVarT.end());
                    varBindTerm.insert(varBindTerm.end(), chgVarTEqn.begin(), chgVarTEqn.end());
                    chgVarT.clear();
                    chgVarTEqn.clear();
                    term->vBinding = (*claP_it)->LitPtr[0]->subTerm->subTermPtr[1];
                    varBindTerm.push_back(term);
                    flag = true;
                    break;
                }
            }
            else {
                triAlg.unify.ClearVarBind(chgVarT);
                triAlg.unify.ClearVarBind(chgVarTEqn);
            }
        }
        ++claP_it;
    }  
    if(flag)
        return 1;
    else
        return 0;
}
double Resolution::timeConsume(TriAlg& triAlg){
    clock_t endNoPair = clock();
    double time_sNoPair = (double) (endNoPair - triAlg.start) / (double) CLOCKS_PER_SEC;
    return time_sNoPair;
}


RESULT Resolution::BaseAlgByRecodePath(Formula& fol, UINT64 &triTotalTimes) {
    // <editor-fold defaultstate="collapsed" desc="初始化所需的变量">
    shift = 0;
    TriAlg triAlg; 
    //UINT32 uNewClaID = fol.uOrigClaSize + 1;//新产生的归结式R子句编号
    UINT32 uNewClaID = StrategyParam::maxOriClauseId + 1;   //20210601 
    triAlg.singleClaNum = fol.uOrigClaSize;//目前没有用上
    triAlg.flagT = true;

    BACKTYPE backType = NOBACK;
    //记录预处理生成的子句
    vector<Clause*> preGenCla;
    preGenCla.reserve(6);
    //记录生成的子句
    vector<Clause*> chgCla;
    chgCla.reserve(6);
    triAlg.start = StrategyParam::start;//clock(); modify 20190716  very impartant
    Clause* givenClaP = nullptr;
    //下面两个容器用于目标子句约简
    vector<Literal*> unifyLit;//记录与目标子句合一相关的文字
    unifyLit.reserve(16);
    set<UINT32> saveClaId;//保存的留下来的子句ID
    // </editor-fold>

    //20210521 将第一段E运行的输出文件中的演绎子句转成CSE子句输入格式
    // <editor-fold defaultstate="collapsed" desc="将第一段E运行的输出文件中的演绎子句转成CSE子句输入格式">
    if (FileOp::runMode == 4 && StrategyParam::firstRunTime != 0 && StrategyParam::isInteraction) {
        //调试信息，将E演绎出的子句打印到预处理文件中
//#define Debug
#ifdef Debug
        ofstream foutPreFile(FileOp::g_PreFileFullName, ios::app);
        foutPreFile << "Eprover第一段执行演绎得到的子句: " << endl;
#endif
        ifstream finEoutFile(FileOp::eOutputFile);
        string strClause = "";
        Clause* comCla = nullptr;
        int lines = 0;
        while (getline(finEoutFile, strClause)) {
            lines++;
            if ((strClause.find("cnf", 0) != string::npos) && (strClause.find("inference", 0) != string::npos)) {
                size_t begin = strClause.find_first_of("(");
                size_t end = strClause.find_first_of(",");
                string strId = strClause.substr(begin + 1, end - begin - 1);
                //cout<<strClause<<endl;
                size_t index = strClause.find("plain");
                //cout<<index<<endl;
                strClause = strClause.substr(index + 6);
                index = strClause.find("inference");
                strClause = strClause.substr(0, index - 2);
                //cout<<"*:" << strClause<<endl;
                //strClause = strClause.substr(strClause.find_first_of("plain") + 6,strClause.find_first_of("inference") - 2 - (strClause.find_first_of("plain") + 6));
                comCla = fol.ReadTPTPClause(strClause, uNewClaID);
                if(!comCla)
                    continue;
                if((comCla->uLitNum) == 0){
                    uNewClaID--;
                    comCla->DelLits(true);
                    delete(comCla);
                    continue;
                }

                if ((comCla->uLitNum) != 0) {
                    if(comCla->compFuncDeepthCla() > StrategyParam::funcFixDeepth) {
                        uNewClaID--;
                        comCla->DelLits(true);
                        delete(comCla);
                        continue;
                    }
                    vector<UINT32>invaildLitId; 
                    invaildLitId.reserve(6);
                    string rundMsg; //冗余信息
                    Subsumption subsump; //(MOSTRIGHT)
                    //参数1 被测的子句指针 参数2 整形数组 参数3 字符串 记录冗余信息
                    bool isRundacyR = false;
                    isRundacyR = subsump.GenCla(fol, comCla, invaildLitId, rundMsg);
                    if (isRundacyR) {
                        uNewClaID--;
                        comCla->DelLits(true);
                        delete(comCla);
                        continue;
                    } else {
                        string str = "";
                        fol.setCla.insert(comCla);
                        //将E演绎的子句打印到.res文件（用于第二次调用E的输入文件）
                        if (FileOp::runMode != 0) {
                            comCla->toPureString(str);
                            str += "\n";
                            FileOp::prinfPreResForE(str);
                        }
                        if (lines > FileOp::maxIndex)
                            FileOp::maxIndex = lines;
                        FileOp::idMap.insert(pair<Clause*, string>(comCla, strId));
#ifdef Debug
                        foutPreFile << str << endl;
#endif
                    }
                }
            }
        }
#ifdef Debug
        foutPreFile.close();
#endif
        finEoutFile.close();
    }
    // </editor-fold>

    // <editor-fold defaultstate="collapsed" desc="预处理1：纯文字规则">
    //1. 过滤带纯文字的子句
    if (StrategyParam::delPureCla && StrategyParam::problemDifficult && !StrategyParam::preprocess) {
        //子句集中删除带纯文字的子句（非等词公理子句），并将不是带纯文字的子句中的目标子句记录下来
        set<Clause*>::iterator claP_it = fol.setCla.begin();
        for (; claP_it != fol.setCla.end();) {
            if (triAlg.claHasPureLit(fol, (*claP_it))) {
                //先删除原始子句集
                set<Clause*> ::iterator delIt = fol.setOriClas.find(*claP_it);
                if (delIt != fol.setOriClas.end()) {
                    fol.setOriClas.erase(delIt);
                }
                if (StrategyParam::orForCompition == false) {
                    string out = "#子句编号[" + to_string((*claP_it)->uClaId) + "]含纯文字被删除";
                    FileOp::LogOut(out);    //输出冗余信息到.log文件
                }
                (*claP_it)->DelLits();
                delete((*claP_it));
                claP_it = fol.setCla.erase(claP_it);
            } 
            else{
                if((*claP_it)->isGoal){
                    //时目标子句,则存入unifyLit中
                    for(int i=0;i<(*claP_it)->uLitNum;++i){
                        unifyLit.push_back((*claP_it)->LitPtr[i]);
                    }
                    saveClaId.insert((*claP_it)->uClaId);   
                    fol.saveGoalClaSet.insert(*claP_it);
                    //20170926 加入到列表中   
                    //insertNoPairCla(fol, *claP_it);
                }
                ++claP_it;
            }
        }
    }
    else if(StrategyParam::problemDifficult){//不做纯文字规则,则得到目标子句
        set<Clause*>::iterator claP_it = fol.setCla.begin();
        for (; claP_it != fol.setCla.end();) {
            if ((*claP_it)->isGoal) {
                //时目标子句,则存入unifyLit中
                for (int i = 0; i < (*claP_it)->uLitNum; ++i) {
                    unifyLit.push_back((*claP_it)->LitPtr[i]);
                }
                saveClaId.insert((*claP_it)->uClaId);
                fol.saveGoalClaSet.insert(*claP_it);
                //insertNoPairCla(fol, *claP_it);
            }
            ++claP_it;
        }
    }
    // </editor-fold>
    
    // <editor-fold defaultstate="collapsed" desc="预处理2：目标子句距离约简处理">
    //2. 目标子句过滤子句集 考虑加上距离的概念
    if(StrategyParam::goalCla && StrategyParam::problemDifficult && (unifyLit.size()>0)){
        if(StrategyParam::preprocess){
            StrategyParam::start = clock();//start count time
        }
        vector<Literal*>* vCandLit;
        Literal* candLitP = nullptr;
        Clause* candClaP = nullptr;
        vector<Term*> chgVarTemp;
        chgVarTemp.reserve(6);
        int length = unifyLit.size();
        bool flag = true;
        int resLen = 0;
        int reslength = 0;
        for(int i = 0; i < unifyLit.size(); ++i) {        
            unifyLit[i]->goalDeepth = reslength;
            if(unifyLit[i]->claPtr->goaldeepth > reslength){//以文字项最小的目标距离为主 
                unifyLit[i]->claPtr->goaldeepth = reslength;
            }
            if(flag){
                flag = false;
                resLen = unifyLit.size();
            }
            if(i == resLen){//距离为1
                ++reslength;
                resLen = unifyLit.size();
                //当到达归结距离时
                 if(reslength == StrategyParam::goalDeepth){
                     break;
                 }
            }
            if(saveClaId.size() == (fol.setCla.size() + fol.setEnq.size())){
                break;
            }
            vCandLit = unifyLit[i]->getPairPredLst();
            for (UINT32 pasLitInd = 0; pasLitInd < UINT32(vCandLit->size()); ++pasLitInd)//依次找到
            {
                candLitP = vCandLit->at(pasLitInd);
                candClaP = candLitP->claPtr;
                //若互补对的子句已经查找出,则应该跳过
                if (saveClaId.find(candClaP->uClaId) != saveClaId.end())
                    continue;
                if (triAlg.unify.LitMgu(unifyLit[i], candLitP, chgVarTemp)) {
                    triAlg.unify.ClearVarBind(chgVarTemp);
                    //需要将互补对的文字对应的子句所有的文字压入unifyLit中                  
                    for(int m=0;m<candClaP->uLitNum;++m){
                        if(find(unifyLit.begin(),unifyLit.end(),candClaP->LitPtr[m]) ==unifyLit.end()){
                            unifyLit.push_back(candClaP->LitPtr[m]);
                        }
                    }
                    //将对应的互补对子句ID插入到set集合中
                    if (saveClaId.find(candClaP->uClaId) == saveClaId.end())
                        saveClaId.insert(candClaP->uClaId);
                }
                else
                    triAlg.unify.ClearVarBind(chgVarTemp);
            }
            triAlg.unify.ClearVarBind(chgVarTemp);
        }
        //清空unifyLit集合
        triAlg.unify.ClearVarBind(chgVarTemp);
        vector<Term*>().swap(chgVarTemp);
        unifyLit.clear();
        vector<Literal*>().swap(unifyLit);
        set<Clause*>::iterator claP_it = fol.setCla.begin();
        for (; claP_it != fol.setCla.end();) {
            //1.判断是否要过滤,有将该子句删除
            if(saveClaId.find((*claP_it)->uClaId) == saveClaId.end()){
                //先删除原始子句集
                set<Clause*> ::iterator delIt = fol.setOriClas.find(*claP_it);
                if (delIt != fol.setOriClas.end()) {
                    fol.setOriClas.erase(delIt);
                }
                if (StrategyParam::orForCompition == false) {
                    string out = "#子句编号[" + to_string((*claP_it)->uClaId) + "]目标子句约简被删除";
                    FileOp::LogOut(out);
                }
                (*claP_it)->DelLits();
                delete((*claP_it));
                claP_it = fol.setCla.erase(claP_it);
            }
            else{
                 //20170919 加入到等词中 如果是单元子句正等词 且左边项和右边项个数不相同并且只含有1个项
                if (StrategyParam::termRewriting != 2) {
                    if (((*claP_it)->isUintEqn()) && ((*claP_it)->LitPtr[0]->subTerm->suitSuper())) {
                        (*claP_it)->demodulator = true;
                        fol.eqnDemod.insert(*claP_it); //原始子句有适合调解的正等词单元子句
                    }
                }               
                ++claP_it;
            }
        }
        set<Clause*>::iterator claPE_it = fol.setEnq.begin();
        for (; claPE_it != fol.setEnq.end();) {
            //1.判断是否要过滤,有将该子句删除
            if (saveClaId.find((*claPE_it)->uClaId) == saveClaId.end()) {
                //先删除原始子句集
                set<Clause*> ::iterator delIt = fol.setOriClas.find(*claPE_it);
                if (delIt != fol.setOriClas.end()) {
                    fol.setOriClas.erase(delIt);
                }
                if (StrategyParam::orForCompition == false) {
                    string out = "#子句编号[" + to_string((*claPE_it)->uClaId) + "]目标子句约简被删除";
                    FileOp::LogOut(out);
                }
                (*claPE_it)->DelLits();
                delete((*claPE_it));
                claPE_it = fol.setEnq.erase(claPE_it);
            } else{
                //20170919 加入到等词中 如果是单元子句正等词 且左边项和右边项个数不相同并且只含有1个项
                if (StrategyParam::termRewriting != 2) {
                    if (((*claPE_it)->isUintEqn()) && ((*claPE_it)->LitPtr[0]->subTerm->suitSuper())) {
                        (*claPE_it)->demodulator = true;
                        fol.eqnDemod.insert(*claPE_it); //原始子句有适合调解的正等词单元子句
                    }
                } 
                ++claPE_it;
            }
        }           
    }
    saveClaId.clear();
    // </editor-fold>
    
    // <editor-fold defaultstate="collapsed" desc="若为只做预处理，则输出预处理结果，然后退出本函数">
    //只做预处理
    if(StrategyParam::preprocess){
        clock_t endNoPair = clock();
        double time_sNoPair = (double) (endNoPair - StrategyParam::start) / (double) CLOCKS_PER_SEC;
        //double time_s = (double) (end - StrategyParam::start) / (double) CLOCKS_PER_SEC;
        if (time_sNoPair > StrategyParam::timeLimit * 60)//200   3  1分钟 15  5分钟   30  15分钟  end:300
        {
            //20171022 将三角形演绎过程中复制的子句全部删除
            FileOp::outReleaseOf();
            //20170315 输出最后的单元子句 方便程序完善
            string str = "";
            fol.uOrigClaSingleSize = 0;
            str += fol.ToSingleString();
            FileOp::PrintINFOEndRSinglePre(str); //输出所有的单元子句到.erspre
//            str = "";
//            str += fol.ToUnUseString();
//            FileOp::PrintINFONoUsePre(str); //输出所有的未使用子句到.nousepre
            FileOp::LogOut("超出时间" + to_string(StrategyParam::timeLimit) + "分钟限制,预处理失败！");
//            if (!StrategyParam::orForCompition)
//                cout << "无法判定" << endl;
//            else
//                cout << "TMO-Non" << endl;
            return UNKNOWN;
        }
        else{
            //20171022 将三角形演绎过程中复制的子句全部删除
            FileOp::outReleaseOf();
            //20170315 输出最后的单元子句 方便程序完善
            string str = "";
            fol.uOrigClaSingleSize = 0;
            str += fol.ToSingleString();
            FileOp::PrintINFOEndRSinglePre(str); //输出所有的单元子句到.erspre
//            str = "";
//            str += fol.ToUnUseString();
//            FileOp::PrintINFONoUsePre(str); //输出所有的未使用子句到.nousepre
            FileOp::LogOut("使用时间" + to_string(time_sNoPair) + "秒,预处理成功！");
//            if (!StrategyParam::orForCompition)
//                cout << "无法判定" << endl;
//            else
//                cout << "TMO-Non" << endl;
            return UNKNOWN;
        }
    }
    // </editor-fold>
    
    // <editor-fold defaultstate="collapsed" desc="初始化构建三角形所需的变量">
    //预处理完成
    //20170812
    //将单文字子句集合放入三角形中
    UINT16 loop = 10;
    bool chooseTri = true;//用于选择三角形的构建类型
     //对函数复杂度、共享变元进行预处理
     //第一次针对原始子句集处理的开关
    bool firstSwitch = true;
    int maxUintClaId = 0;//上一次最大的单元子句编号
    int maxUnitId = 0;//本次最大的单元子句编号
    bool readStrategySwitch1 = true;
    bool readStrategySwitch2 = true;
    bool readStrategySwitch3 = true;
    bool readStrategySwitch4 = true;
    UINT32 simplyIdStart = 0;
    UINT32 simplyIdEnd = uNewClaID - 1;
     //UINT32 noPairIt = 0;//用于非单元子句归结时的迭代
    bool insertNoUseCla = true;
     //20170819 标志是否没有单元子句,没有单元子句需要进入到非单元子句归结
     //int allNoPairCount = 0;//用于监控allNoPair出现的次数，若选取的单元子句都无法进行有效的三角形构建，则此时需要进入非单元子句进行演绎
    //triAlg.start = clock(); 
    bool readSecondStrategy = true; 
    bool readThirdStrategy = true; 
    // </editor-fold>
    
    // <editor-fold defaultstate="collapsed" desc="循环构建三角形">
    while(1) {
        
        // <editor-fold defaultstate="collapsed" desc="清除上一个三角形相关信息（路径，拷贝子句等）">
        triAlg.vOnlyOutTri.clear();
        triAlg.vOutTri.clear();
        triAlg.vOnlyOutTriCmp.clear();
        //triAlg.saveCopyCla.clear();
        //20171022 将三角形演绎过程中复制的子句全部删除
        triAlg.delSaveCopyCla(fol);
        triAlg.BackPathClear();
        
        fol.setSingleCla.clear();   //记录单文字子句集合
        fol.combinedClaSet.clear(); //用于融合系统
        //fol.resetNoPairClaSet(difficulty);//非单元子句演绎集合
        simplyIdEnd= uNewClaID - 1;
        // </editor-fold>
        
        // <editor-fold defaultstate="collapsed" desc="根据运行时间，变动函数复杂度">
        //函数复杂度的变化
        if((FileOp::strategyMode != 3)&&(FileOp::strategyMode != 4)) {//2020:have repaired 
            if (((double) (clock() - StrategyParam::start) / (double) CLOCKS_PER_SEC) < StrategyParam::timeLimit *12) {//60
                //[0, 1/5): 复杂度阈值 = 原始最大复杂度 + 1
                StrategyParam::funcFixDeepth = StrategyParam::funcOrgFixDeepthMax + 1;
            } 
            else if (((double) (clock() - StrategyParam::start) / (double) CLOCKS_PER_SEC) < StrategyParam::timeLimit *24) {//60
                //[1/5, 2/5): 复杂度阈值 = 原始最大复杂度*2 + 原始次大复杂度
                StrategyParam::funcFixDeepth = StrategyParam::funcOrgFixDeepthMax *2 + StrategyParam::funcOrgFixDeepthLessMax;
            } 
            else if (((double) (clock() - StrategyParam::start) / (double) CLOCKS_PER_SEC) < StrategyParam::timeLimit *36) {//60
                //[2/5, 3/5): 复杂度阈值 = 原始最大复杂度*2 + 10
                StrategyParam::funcFixDeepth = StrategyParam::funcOrgFixDeepthMax *2 + 10;
            } 
            else if (((double) (clock() - StrategyParam::start) / (double) CLOCKS_PER_SEC) < StrategyParam::timeLimit *48) {//60
                //[3/5, 4/5): 复杂度阈值 = 原始最大复杂度*3
                StrategyParam::funcFixDeepth = StrategyParam::funcOrgFixDeepthMax * 3;
            } 
            else {
                //[4/5, 1): 复杂度阈值 = 100
                StrategyParam::funcFixDeepth = 100;
            }
        }
        // </editor-fold>
        
        // <editor-fold defaultstate="collapsed" desc="若为多策略模式，根据时间变动策略">
           //more strategies 1
        if(StrategyParam::findStr == false){
            if((FileOp::strategyMode == 1) && 1){
                //StrategyParam::deductDeep = 26;
                int timeUsed = (int)timeConsume(triAlg);    //这里的时间单位为：秒
                if(timeUsed > (StrategyParam::timeLimitStrategies * 12)){
                    if(timeUsed < (StrategyParam::timeLimitStrategies * 24)){
                        //(1/5, 2/5) 使用第二个策略
                        if (readSecondStrategy) {
                            FileOp::readBatchStrategy(FileOp::StrategyfileName[1]);
                            shift = 0;
                            if (StrategyParam::noUnitRes == false) {
                                chooseTri = true;
                            }
                            StrategyParam::timeLimit = StrategyParam::timeLimitStrategies;
                            readSecondStrategy = false;
                        }

                    }
                    else if(timeUsed < (StrategyParam::timeLimitStrategies * 36)){
                        //[2/5, 3/5) 使用第三个策略
                        if (readThirdStrategy) {
                            FileOp::readBatchStrategy(FileOp::StrategyfileName[2]);
                            shift = 0;
                            if (StrategyParam::noUnitRes == false) {
                                chooseTri = true;
                            }
                            StrategyParam::timeLimit = StrategyParam::timeLimitStrategies;
                            readThirdStrategy = false;
                        }

                    }
                    else if ((timeUsed > 1) && (timeUsed % 5 == 0)) {
                        //[3/5, 1) 每隔5的倍数时间，更换一个策略
                        if ((timeUsed / 5) < 150){
                            if(timeUsed / 5 >= FileOp::StrategyfileName.size())
                                FileOp::readBatchStrategy(FileOp::StrategyfileName[FileOp::StrategyfileName.size()-1]);
                            else
                                FileOp::readBatchStrategy(FileOp::StrategyfileName[timeUsed / 5]);
                        }
                        else
                            FileOp::readBatchStrategy(FileOp::StrategyfileName[0]);
                        shift = 0;
                        if (StrategyParam::noUnitRes == false) {
                            chooseTri = true;
                        }
                        StrategyParam::timeLimit = StrategyParam::timeLimitStrategies;
                    }
                }                     
            }
        }
        // </editor-fold>
        
        // <editor-fold defaultstate="collapsed" desc="预处理1(构建1个三角形前的)：检查新生成子句的冗余性（调解冗余，纯文字）">
        //20171029 处理新生成的子句,判断是否是冗余的
        if((StrategyParam::delPureCla || StrategyParam::termReRedund) && StrategyParam::problemDifficult){//纯文字子句约简与调解冗余,现去掉纯文字子句约简
            set<Clause*>::iterator claP_it = fol.setCla.begin();
            for (; claP_it != fol.setCla.end();) {
                //20171029 判断新生成的子句是否是调解恒真和纯文字子句
                if ((*claP_it)->uClaId >= simplyIdStart && (*claP_it)->uClaId <= simplyIdEnd) {
                    bool flag = false;
                    if (firstSwitch) {  //第一次处理，因为带纯文字冗余处理已经处理过了，这里就不再重复处理
                        if (triAlg.judgeDemodRedundent(fol, (*claP_it), uNewClaID)) 
                            flag = true;
                    }
                    else {
                        if (triAlg.claHasPureLit(fol, (*claP_it)) || triAlg.judgeDemodRedundent(fol, (*claP_it), uNewClaID))
                            flag = true;
                    }                    
                    if (flag) {
                        set<Clause*> ::iterator delIt = fol.setOriClas.find(*claP_it);
                        if (delIt != fol.setOriClas.end()) {
                            fol.setOriClas.erase(delIt);
                        }
                        set<Clause*> ::iterator delItNoPair = fol.noPairSingleCla.find(*claP_it);
                        if (delItNoPair != fol.noPairSingleCla.end()) {
                            fol.noPairSingleCla.erase(delItNoPair);
                        }
                        set<Clause*> ::iterator delItEqnDemod = fol.eqnDemod.find(*claP_it);
                        if (delItEqnDemod != fol.eqnDemod.end()) {
                            fol.eqnDemod.erase(delItEqnDemod);
                        }
                        set<Clause*> ::iterator delItGoal = fol.saveGoalClaSet.find(*claP_it);
                        if (delItGoal != fol.saveGoalClaSet.end()) {
                            fol.saveGoalClaSet.erase(delItGoal);
                        }
                        if (StrategyParam::orForCompition == false) {
                            string out = "#子句编号[" + to_string((*claP_it)->uClaId) + "]冗余被删除";
                            FileOp::LogOut(out);
                        }
                        (*claP_it)->DelLits();
                        delete((*claP_it));
                        claP_it = fol.setCla.erase(claP_it);
                        continue;
                    }
                }
                ++claP_it;
            }  
        }
        // </editor-fold>
        
        // <editor-fold defaultstate="collapsed" desc="预处理2(构建1个三角形前的)：因子归结">
        //20170908进行预处理
        //1.因子归结 生成新子句
        preGenCla.clear();
        if (StrategyParam::factorRes && StrategyParam::problemDifficult) {
            set<Clause*>::iterator claP_it = fol.setCla.begin();
            for (; claP_it != fol.setCla.end();) {
                if(((*claP_it)->uClaId <= simplyIdEnd) && ((*claP_it)->uClaId >= simplyIdStart)){
                    bool delFlag = true;
                    int res = factorRes(fol, triAlg, (*claP_it), uNewClaID, &preGenCla, delFlag, false);
                    if (delFlag) {//因子归结:两个合一文字1个为常元,一个不含共享变元
                        set<Clause*> ::iterator delIt = fol.setOriClas.find(*claP_it);
                        if (delIt != fol.setOriClas.end()) {
                            fol.setOriClas.erase(delIt);
                        }
                        set<Clause*> ::iterator delItNoPair = fol.noPairSingleCla.find(*claP_it);
                        if (delItNoPair != fol.noPairSingleCla.end()) {
                            fol.noPairSingleCla.erase(delItNoPair);
                        }
                        set<Clause*> ::iterator delItEqnDemod = fol.eqnDemod.find(*claP_it);
                        if (delItEqnDemod != fol.eqnDemod.end()) {
                            fol.eqnDemod.erase(delItEqnDemod);
                        }
                        set<Clause*> ::iterator delItGoal = fol.saveGoalClaSet.find(*claP_it);
                        if (delItGoal != fol.saveGoalClaSet.end()) {
                            fol.saveGoalClaSet.erase(delItGoal);
                        }
                        if (StrategyParam::orForCompition == false) {
                            string out = "#子句编号[" + to_string((*claP_it)->uClaId) + "]被因子归结删除";
                            FileOp::LogOut(out);
                        }
                        (*claP_it)->DelLits();
                        delete((*claP_it));
                        claP_it = fol.setCla.erase(claP_it);
                    } else
                        ++claP_it;
                }
                else
                   ++claP_it; 
            }
        }
        //处理预处理新生成的子句,向后约简
        if (preGenCla.size() > 0) {
            for (int i = 0; i < preGenCla.size(); ++i) {
                fol.BackwardSubsump(*preGenCla[i]); //向后冗余
            }
        }
        //清空新生成的子句指针集合
        preGenCla.clear();
        // </editor-fold>
        
        // <editor-fold defaultstate="collapsed" desc="预处理3(构建1个三角形前的)：等词归结">
        //2.等词归结
        if (StrategyParam::eqnRes && StrategyParam::problemDifficult) {
            set<Clause*>::iterator claP_it = fol.setCla.begin();
            for (; claP_it != fol.setCla.end();) {
                if (((*claP_it)->uClaId <= simplyIdEnd) && ((*claP_it)->uClaId >= simplyIdStart)) {
                    int res = negEqnRes(fol, triAlg, (*claP_it), uNewClaID, &preGenCla,false);
                    ++claP_it;
                } else
                    ++claP_it;
            }
        }
        //处理预处理新生成的子句,向后约简
        if (preGenCla.size() > 0) {
            for (int i = 0; i < preGenCla.size(); ++i) {
                fol.BackwardSubsump(*preGenCla[i]); //向后冗余
            }
        }
        //清空新生成的子句指针集合
        preGenCla.clear();  
        // </editor-fold>
        
        // <editor-fold defaultstate="collapsed" desc="预处理4(构建1个三角形前的)：调解处理">
        //20170901 此处加入调解处理,简化原始子句集
        if(StrategyParam::termRewriting != 2) {
            set<Clause*>::iterator claP_it = fol.setCla.begin();
            for (; claP_it != fol.setCla.end();) {
                if(/*((*claP_it)->uClaId <= simplyIdEnd) && */((*claP_it)->uClaId >= simplyIdStart))
                {
                    if(fol.eqnDemod.find(*claP_it)!=fol.eqnDemod.end()){//注意不能自己和自己调解
                        ++claP_it;
                        continue;
                    }
                    int res =demodulatorClaSaturate(fol,triAlg,(*claP_it),uNewClaID,&preGenCla);
                    if((res==1) || (res==2)){
                        vector<Clause*>::iterator delVec = find(preGenCla.begin(),preGenCla.end(),(*claP_it));
                        if( delVec!= preGenCla.end()){
                            swap((*delVec),(*(preGenCla.end() -1)));
                            preGenCla.pop_back();
                        }
                        set<Clause*> ::iterator delIt = fol.setOriClas.find(*claP_it);
                        if (delIt != fol.setOriClas.end()) {
                            fol.setOriClas.erase(delIt);
                        }
                        set<Clause*> ::iterator delItNoPair = fol.noPairSingleCla.find(*claP_it);
                        if (delItNoPair != fol.noPairSingleCla.end()) {
                            fol.noPairSingleCla.erase(delItNoPair);
                        }
                        set<Clause*> ::iterator delItEqnDemod = fol.eqnDemod.find(*claP_it);
                        if (delItEqnDemod != fol.eqnDemod.end()) {
                            fol.eqnDemod.erase(delItEqnDemod);
                        }
                        set<Clause*> ::iterator delItGoal = fol.saveGoalClaSet.find(*claP_it);
                        if (delItGoal != fol.saveGoalClaSet.end()) {
                            fol.saveGoalClaSet.erase(delItGoal);
                        }
                        if (!StrategyParam::orForCompition) {
                            string out = "#子句编号[" + to_string((*claP_it)->uClaId) + "]被单元等词子句重写删除";
                            FileOp::LogOut(out);
                        }
                        (*claP_it)->DelLits();
                        delete((*claP_it));
                        claP_it = fol.setCla.erase(claP_it);
                    }
                    else 
                        ++claP_it;
                }
                else
                    ++claP_it;
            }
            
            //demodulatorClaSet(fol, triAlg, uNewClaID, &preGenCla, simplyIdStart, simplyIdEnd);
            //处理预处理新生成的子句,向后约简
            if (preGenCla.size() > 0) {
                for (int i = 0; i < preGenCla.size(); ++i) {
                    if (preGenCla[i]->LitPtr)
                        fol.BackwardSubsump(*preGenCla[i]); //向后冗余
                }
            }
            preGenCla.clear();
        }
        // </editor-fold>
        
        // <editor-fold defaultstate="collapsed" desc="单元子句的更新，单元子句处理，单元子句添加到主界线（起步子句的确立）">
        //初始化记录原始子句(setCla)中的单元子句个数
        if (firstSwitch){
            fol.resetSingleClaNum();    //记录原始子句(setCla)中的单元子句个数
        }
        
        //maxUintClaId上次单元子句的最大ID  maxUnitId本次单元子句的最大ID
        maxUintClaId = maxUnitId; 
        InsertSingleSet(fol,triAlg,maxUnitId);//maxUnitId变大,则表示生成了新单元子句
        
        //判断可满足性
        if ((fol.setOriClas.size() < 2) && (fol.setCla.size() < 2)) {
            //简单判断可满足
            if (!StrategyParam::orForCompition) {
                FileOp::LogOut("得出结论:可满足！");
                cout<< "得出结论:可满足"<<endl;
            }
            return SAT;
        }
        
//        if(fol.setSingleCla.size() == 0){
//            StrategyParam::noUnitRes = true;
//        }
        
        if (fol.setSingleCla.size() > 0) {
            StrategyParam::noUnitRes = false;   //没有单元子句的标志设置为false
            //先放单文字子句到三角形
            StrategyParam::deductMode = 1;
            if(!StrategyParam::deductMode)
                InsertOutTri(triAlg, fol, loop, chooseTri); //添加单元子句到对角线
            else{
                InsertOutTriLR(triAlg, fol, loop, chooseTri); //添加单元子句到对角线
            }
            //已第一个单文字子句起步
            givenClaP = triAlg.vOnlyOutTri[0]->claPtr;
            //        string str;
            //        givenClaP->toString(str);
            //        cout << "起步子句:" << str << endl;
            StartId = triAlg.vOnlyOutTri[0]->claPtr->uClaId;
            triAlg.startCluId = StartId;
            //FileOp::CreateRunInfoFile(triAlg.vOnlyOutTri[0]->claPtr->uClaId);
            //判断对角线元素是否存在互补合一子句
            vector<Term*> chgVarT;
            chgVarT.reserve(6);
            UINT32 lens = triAlg.vOnlyOutTri.size();

            //cout<<lens<<endl;
            //判断是否有互补对的单元子句
            if (firstSwitch) {
                for (UINT32 i = 0; i < lens - 1; i++) {
                    for (UINT32 j = i + 1; j < lens; j++) {
                        if (triAlg.vOnlyOutTri[i]->isPairPred(triAlg.vOnlyOutTri[j]) && triAlg.unify.LitMgu(triAlg.vOnlyOutTri[i], triAlg.vOnlyOutTri[j], chgVarT)) {
                            //triAlg.unify.vVarBindT.insert(triAlg.unify.vVarBindT.end(),chgVarT.begin(),chgVarT.end());
                            //单文字子句集合中存在互补对，需要将结果写入后台
                            string str;
                            //*FileOp::ofRealInfoOut << "互补对单文字子句" << endl;   
                            //*FileOp::ofRealInfoOut <<"[C" + to_string(triAlg.vOnlyOutTri[i]->Row()) + "]" << triAlg.vOnlyOutTri[i]->subTerm->ToString()<<endl;
                            if (!StrategyParam::orForCompition) {
                                FileOp::CreateRunInfoFile(FileOp::runFileId);
                                *FileOp::ofRealInfoOut << "从编号为" + to_string(triAlg.vOnlyOutTri[i]->claPtr->uClaId) + "子句开始构建三角形" << endl;
                            }
                            triAlg.unify.WriteTriPath(triAlg.vOnlyOutTri[i]);
                            //sleep(1);
                            //"[C" + to_string(lit->Row()) + "_" + to_string(lit->Col()) + "]"
                            //*FileOp::ofRealInfoOut <<"[C" + to_string(triAlg.vOnlyOutTri[j]->Row()) + "]" << triAlg.vOnlyOutTri[j]->subTerm->ToString()<<endl;     
                            triAlg.unify.WriteTriPath(triAlg.vOnlyOutTri[j]);
                            //sleep(1);
                            if (!StrategyParam::orForCompition) {
                                *FileOp::ofRealInfoOut << "R:空子句" << endl;
                                FileOp::LogOut("# ==子句" + to_string(triAlg.vOnlyOutTri[i]->claPtr->uClaId) + "起步，结论正确(UNSAT)！");
                            }
                            if(!StrategyParam::orForCompition && (StrategyParam::problemDiv == 0))
                            cout << "得出结论:不可满足" << endl;
                            
                            if(/*StrategyParam::orForCompition*/true) {
                                validPathOut[0].push_back(triAlg.vOnlyOutTri[i]->claPtr->uClaId);
                                validPathOut[0].push_back(triAlg.vOnlyOutTri[j]->claPtr->uClaId);
                                string out = "cnf(c_0_" + to_string(uNewClaID) + ",plain," + " ($false),";
                                out +=" inference(scs_inference,[],[" + to_string(triAlg.vOnlyOutTri[i]->claPtr->uClaId) + "," + to_string(triAlg.vOnlyOutTri[j]->claPtr->uClaId) +"]" + "),\n" + "   ['proof']"+ ").";
                                *FileOp::ofOutput << out << endl;
                            }

                            return UNSAT;
                        }
                        triAlg.unify.ClearVarBind(chgVarT);
                    }
                }
                triAlg.unify.ClearVarBind(chgVarT);
                for (int k = 0; k < fol.setSingleEnq.size(); ++k) {
                    for (int i = 0; i < lens; ++i) {
                        if (triAlg.vOnlyOutTri[i]->isPairPred(fol.setSingleEnq[k]) && triAlg.unify.LitMgu(triAlg.vOnlyOutTri[i], fol.setSingleEnq[k], chgVarT)) {
                            if (!StrategyParam::orForCompition) {
                                FileOp::CreateRunInfoFile(FileOp::runFileId);
                                *FileOp::ofRealInfoOut << "从编号为" + to_string(triAlg.vOnlyOutTri[i]->claPtr->uClaId) + "子句开始构建三角形" << endl;
                            }
                            triAlg.unify.WriteTriPath(triAlg.vOnlyOutTri[i]);
                            //sleep(1);
                            //"[C" + to_string(lit->Row()) + "_" + to_string(lit->Col()) + "]"
                            //*FileOp::ofRealInfoOut <<"[C" + to_string(triAlg.vOnlyOutTri[j]->Row()) + "]" << triAlg.vOnlyOutTri[j]->subTerm->ToString()<<endl;     
                            triAlg.unify.WriteTriPath(fol.setSingleEnq[k]);
                            //sleep(1);
                            if (!StrategyParam::orForCompition) {
                                *FileOp::ofRealInfoOut << "R:空子句" << endl;
                                FileOp::LogOut("# ==子句" + to_string(triAlg.vOnlyOutTri[i]->claPtr->uClaId) + "起步，结论正确(UNSAT)！");
                            }
                            if(!StrategyParam::orForCompition && (StrategyParam::problemDiv == 0)) 
                                cout << "得出结论:不可满足" << endl;
                            if(/*StrategyParam::orForCompition*/true) {
                                validPathOut[0].push_back(triAlg.vOnlyOutTri[i]->claPtr->uClaId);
                                validPathOut[0].push_back(fol.setSingleEnq[k]->claPtr->uClaId);
//                                string out = "cnf($" + to_string(uNewClaID) + ",plain,\n" + "   ($false),\n";
//                                out += "   inference(scs_inference,[],[" + to_string(triAlg.vOnlyOutTri[i]->claPtr->uClaId) + "," + to_string(fol.setSingleEnq[k]->claPtr->uClaId) +"]" + ")," + " ['proof']" + ").";
//                                *FileOp::ofOutput << out << endl;
                                
                                string out = "cnf(c_0_" + to_string(uNewClaID) + ",plain," + " ($false),";
                                out +=" inference(scs_inference,[],[c_0+" + to_string(triAlg.vOnlyOutTri[i]->claPtr->uClaId) + ", c_0_" + to_string(fol.setSingleEnq[k]->claPtr->uClaId) +"]" + ")," + " ['proof']"+ ").";
                                *FileOp::ofOutput << out << endl;
                            }
                            return UNSAT;
                        }
                        triAlg.unify.ClearVarBind(chgVarT);
                    }
                }
                triAlg.unify.ClearVarBind(chgVarT);
            } 
            else if (maxUintClaId != maxUnitId) {//之前已经判断过的单元子句不再判断,此时已经有新的单元子句生成
                for (UINT32 i = 0; i < lens; i++) {
                    if (triAlg.vOnlyOutTri[i]->claPtr->uClaId < maxUintClaId)
                        continue;
                    triAlg.unify.ClearVarBind(chgVarT);
                    for (UINT32 j = 0; j < lens; j++) {
                        if (i == j)
                            continue;
                        if (triAlg.vOnlyOutTri[i]->isPairPred(triAlg.vOnlyOutTri[j]) && triAlg.unify.LitMgu(triAlg.vOnlyOutTri[i], triAlg.vOnlyOutTri[j], chgVarT)) {
                            //triAlg.unify.vVarBindT.insert(triAlg.unify.vVarBindT.end(),chgVarT.begin(),chgVarT.end());
                            //单文字子句集合中存在互补对，需要将结果写入后台
                            //*FileOp::ofRealInfoOut << "互补对单文字子句" << endl;   
                            //*FileOp::ofRealInfoOut <<"[C" + to_string(triAlg.vOnlyOutTri[i]->Row()) + "]" << triAlg.vOnlyOutTri[i]->subTerm->ToString()<<endl;
                            if (!StrategyParam::orForCompition) {
                                FileOp::CreateRunInfoFile(FileOp::runFileId);
                                *FileOp::ofRealInfoOut << "从编号为" + to_string(triAlg.vOnlyOutTri[i]->claPtr->uClaId) + "子句开始构建三角形" << endl;
                            }
                            triAlg.unify.WriteTriPath(triAlg.vOnlyOutTri[i]);
                            //sleep(1);
                            //"[C" + to_string(lit->Row()) + "_" + to_string(lit->Col()) + "]"
                            //*FileOp::ofRealInfoOut <<"[C" + to_string(triAlg.vOnlyOutTri[j]->Row()) + "]" << triAlg.vOnlyOutTri[j]->subTerm->ToString()<<endl;     
                            triAlg.unify.WriteTriPath(triAlg.vOnlyOutTri[j]);
                            //sleep(1);
                            if (!StrategyParam::orForCompition) {
                                *FileOp::ofRealInfoOut << "R:空子句" << endl;
                                FileOp::LogOut("# ==子句" + to_string(triAlg.vOnlyOutTri[i]->claPtr->uClaId) + "起步，结论正确(UNSAT)！");
                            }
                            if(!StrategyParam::orForCompition && (StrategyParam::problemDiv == 0))
                                cout << "得出结论:不可满足" << endl;
                            if(/*StrategyParam::orForCompition*/true) {
                                validPathOut[0].push_back(triAlg.vOnlyOutTri[i]->claPtr->uClaId);
                                validPathOut[0].push_back(triAlg.vOnlyOutTri[j]->claPtr->uClaId);
//                                string out = "cnf($" + to_string(uNewClaID) + ",plain,\n" + "   ($false),\n";
//                                out +="   inference(scs_inference,[],[" + to_string(triAlg.vOnlyOutTri[i]->claPtr->uClaId) + "," + to_string(triAlg.vOnlyOutTri[j]->claPtr->uClaId) +"]" + "),\n" + "   ['proof']"+ ").";
//                                *FileOp::ofOutput << out << endl;
                                
                                string out = "cnf(c_0_" + to_string(uNewClaID) + ",plain," + " ($false),";
                                out +=" inference(scs_inference,[],[c_0+" + to_string(triAlg.vOnlyOutTri[i]->claPtr->uClaId) + ", c_0_" + to_string(triAlg.vOnlyOutTri[j]->claPtr->uClaId) +"]" + ")," + " ['proof']"+ ").";
                                *FileOp::ofOutput << out << endl;
                            }
                            return UNSAT;
                        }
                        triAlg.unify.ClearVarBind(chgVarT);
                    }
                    triAlg.unify.ClearVarBind(chgVarT);
                    for (int k = 0; k < fol.setSingleEnq.size(); ++k) {
                        if (triAlg.vOnlyOutTri[i]->isPairPred(fol.setSingleEnq[k]) && triAlg.unify.LitMgu(triAlg.vOnlyOutTri[i], fol.setSingleEnq[k], chgVarT)) {
                            if (!StrategyParam::orForCompition) {
                                FileOp::CreateRunInfoFile(FileOp::runFileId);
                                *FileOp::ofRealInfoOut << "从编号为" + to_string(triAlg.vOnlyOutTri[i]->claPtr->uClaId) + "子句开始构建三角形" << endl;
                            }
                            triAlg.unify.WriteTriPath(triAlg.vOnlyOutTri[i]);
                            //sleep(1);
                            //"[C" + to_string(lit->Row()) + "_" + to_string(lit->Col()) + "]"
                            //*FileOp::ofRealInfoOut <<"[C" + to_string(triAlg.vOnlyOutTri[j]->Row()) + "]" << triAlg.vOnlyOutTri[j]->subTerm->ToString()<<endl;     
                            triAlg.unify.WriteTriPath(fol.setSingleEnq[k]);
                            //sleep(1);
                            if (!StrategyParam::orForCompition) {
                                *FileOp::ofRealInfoOut << "R:空子句" << endl;
                                FileOp::LogOut("# ==子句" + to_string(triAlg.vOnlyOutTri[i]->claPtr->uClaId) + "起步，结论正确(UNSAT)！");
                            }
                            if(!StrategyParam::orForCompition && (StrategyParam::problemDiv == 0))
                                cout << "得出结论:不可满足" << endl;
                            if(/*StrategyParam::orForCompition*/true) {
                                validPathOut[0].push_back(triAlg.vOnlyOutTri[i]->claPtr->uClaId);
                                validPathOut[0].push_back(fol.setSingleEnq[k]->claPtr->uClaId);
//                                string out = "cnf($" + to_string(uNewClaID) + ",plain,\n" + "   ($false),\n";
//                                out += "   inference(scs_inference,[],[" + to_string(triAlg.vOnlyOutTri[i]->claPtr->uClaId) + "," + to_string(fol.setSingleEnq[k]->claPtr->uClaId) +"]" + "),\n" + "   ['proof']"+ ").";
//                                *FileOp::ofOutput << out << endl;
                                
                                string out = "cnf(c_0_" + to_string(uNewClaID) + ",plain," + " ($false),";
                                out +=" inference(scs_inference,[],[c_0+" + to_string(triAlg.vOnlyOutTri[i]->claPtr->uClaId) + ", c_0_" + to_string(fol.setSingleEnq[k]->claPtr->uClaId) +"]" + ")," + " ['proof']"+ ").";
                                *FileOp::ofOutput << out << endl;
                            }
                            return UNSAT;
                        }
                        triAlg.unify.ClearVarBind(chgVarT);
                    }
                    triAlg.unify.ClearVarBind(chgVarT);
                }
            }
            triAlg.unify.ClearVarBind(chgVarT);
            //20170213 此处增加通过扩展三角形能够得出结论的情况，并可以对原始子句进行约减
            chgVarT.clear();
            //初始化非单元子句列表
            //20170528 逆向做法只左1次，只针对原始子句，初始化原始fol.noPairSingleCla，相对于watchlist
            //用主界线的文字（此时只是单元子句）依次将非单元子句下拉，一个文字都不能被下拉的子句，则加入fol.noPairSingleCla；若有全部被下拉的子句，则UNSAT
            if (firstSwitch && StrategyParam::problemDifficult) {//针对子句集大时，应该忽略 20201228
                for (auto& aClap : fol.setCla) {//逆向做法
                    if ((aClap->uLitNum == 1)) {
                        continue;
                    }
                    vector<Term*> varBindT; //变元绑定列表
                    varBindT.reserve(6);
                    UINT16 pairCount = 0; //用于统计可以找到单元子句互补的文字个数20170213
                    vector<Literal*> isOutPut; //存放得出结论时的输出路径
                    isOutPut.reserve(6);
                    if (/*StrategyParam::noUnitRes*/true) {
                        for (UINT16 ActLitInd = 0; ActLitInd < aClap->uLitNum; ++ActLitInd) {
                            Literal* QLit = aClap->LitPtr[ActLitInd];
                            for (UINT32 i = 0; i < lens; ++i) {
                                //20170215 需要好好思考判断，单元子句组合问题
                                if (QLit->isPairPred(triAlg.vOnlyOutTri[i]) && triAlg.unify.LitMgu(QLit, triAlg.vOnlyOutTri[i], chgVarT)) {
                                    aClap->clast = PiredSingle; //存在单元子句
                                    varBindT.insert(varBindT.end(), chgVarT.begin(), chgVarT.end());
                                    chgVarT.clear();
                                    pairCount++;
                                    isOutPut.push_back(triAlg.vOnlyOutTri[i]); //保存演绎路径
                                    break;
                                } else
                                    triAlg.unify.ClearVarBind(chgVarT);
                            }
                        }
                        if (pairCount == aClap->uLitNum) {//得出结论
                            if (!StrategyParam::orForCompition) {
                                FileOp::CreateRunInfoFile(FileOp::runFileId);
                                *FileOp::ofRealInfoOut << "从编号为" + to_string(aClap->uClaId) + "子句开始构建三角形" << endl;
                            }
                            for (UINT16 ActLitInd = 0; ActLitInd < aClap->uLitNum; ++ActLitInd) {
                                isOutPut.push_back(aClap->LitPtr[ActLitInd]);
                            }
                            for (UINT32 k = 0; k < isOutPut.size(); k++) {
                                triAlg.unify.WriteTriPath(isOutPut[k]);
                            }
                            if (!StrategyParam::orForCompition) {
                                *FileOp::ofRealInfoOut << "R:空子句" << endl;
                                FileOp::LogOut("# ==子句" + to_string(aClap->uClaId) + "起步，结论正确(UNSAT)！");
                            }
                            if(!StrategyParam::orForCompition && (StrategyParam::problemDiv == 0))
                                cout << "得出结论:不可满足" << endl;
                            if (/*StrategyParam::orForCompition*/true) {
                                
                                string outClauses = "";
                                for (UINT8 k = 0; k < isOutPut.size(); ++k) {
                                    //outClauses += to_string(isOutPut[k]-> claPtr->uClaId) + ",";
                                    if(find(validPathOut[0].begin(),validPathOut[0].end(),isOutPut[k]-> claPtr->uClaId) == validPathOut[0].end()){
                                        validPathOut[0].push_back(isOutPut[k]-> claPtr->uClaId);
                                        outClauses += "c_0_" + to_string(isOutPut[k]-> claPtr->uClaId) + ",";
                                    }
                                }
                                //outClauses += to_string(aClap->uClaId);
                                if(find(validPathOut[0].begin(),validPathOut[0].end(),aClap->uClaId) == validPathOut[0].end()){
                                    validPathOut[0].push_back(aClap->uClaId);
                                    outClauses += "c_0_" + to_string(aClap->uClaId);
                                }
                                if(outClauses[outClauses.size() -1] == ','){
                                    outClauses.erase(outClauses.size() -1, 1);
                                }
                                //string out = "cnf($" + to_string(uNewClaID) + ",plain,\n"+ "   ($false),\n"+"   inference(scs_inference,[]," + "[" + outClauses +"]" + "),\n" + "   ['proof']" + ").";
                                
                                string out = "cnf(c_0_" + to_string(uNewClaID) + ", plain,"+ " ($false),"+" inference(scs_inference,[]," + "[" + outClauses +"]" + ")," + " ['proof']" + ").";
                                
                                *FileOp::ofOutput << out << endl;
                            }

                            return UNSAT;
                        } else if (pairCount == 0) {
                            aClap->clast = noPiredSingle; //此时子句没有互补对的单元子句 noPairSingleCla暂时没有
                            if (fol.noPairSingleCla.find(aClap) == fol.noPairSingleCla.end()) {
                                fol.noPairSingleCla.insert(aClap);
                            }
                        }
                        triAlg.unify.ClearVarBind(varBindT);
                        triAlg.unify.ClearVarBind(chgVarT);
                    }
                    vector<Term*>().swap(varBindT); //modify 20170705
                    vector<Literal*>().swap(isOutPut); //modify 20170705
                }
                triAlg.unify.ClearVarBind(chgVarT);
                //firstSwitch = false;
            }
            chgVarT.clear();

            //end
            //约简处理：跟命题逻辑的单文字规则类似，用主界线文字去下拉非单元子句C的独立文字，若该独立文字能够被下拉，则子句C被约简出新子句（即C剩余部分）
            //记录可以冗余约简的子句
            vector<Clause*> simplfyCla; //保存约简的归结式R  
            simplfyCla.reserve(6);
            vector<Clause*> simplfyClaDel; //保存将简化的子句
            simplfyClaDel.reserve(6);
            triAlg.unify.ClearVarBind(chgVarT);
            //下面判断是否可以约简
            //simplyIdEnd= uNewClaID -1;
            //if(StrategyParam::noUnitSimplify &&((double) (clock() - triAlg.start) / (double) CLOCKS_PER_SEC)>=30 &&(int)((double) (clock() - triAlg.start) / (double) CLOCKS_PER_SEC)%30) {//20170529 改成不等于零等做出例子
            if (StrategyParam::noUnitSimplify && StrategyParam::problemDifficult /*&& (triTotalTimes %16 == 0)*/) {// &&(((int)((double) (clock() - triAlg.start) / (double) CLOCKS_PER_SEC)%10 == 0) || firstSwitch)) {//modify 20170705 
                for (auto& aClap : fol.setCla) {//逆向做法
                    if (!firstSwitch && ((aClap->uClaId <= simplyIdEnd) && (aClap->uClaId >= simplyIdStart))) {
                        continue;
                    }
                    if ((aClap->uLitNum == 1))
                        continue;
                    vector<Term*> varBindT; //变元绑定列表
                    varBindT.reserve(6);
                    UINT8 pairCount = 0; //用于统计可以找到单元子句互补的文字个数20170213
                    vector<Literal*> isOutPut; //存放得出结论时的输出路径
                    isOutPut.reserve(6);
                    //标记子句是否含有不带共享变元的文字
                    bool noShareVar = false;
                    isOutPut.clear();
                    chgVarT.clear();
                    //对子句进行约减，判断是否存在非共享变元项文字可以互补对
                    if (/*aClap->hasConLit()*/true) {
                        //                    string str;
                        //                    aClap->toString(str);
                        //                    cout << "起步子句:" << str << endl;
                        bool simplyOut = false;
                        vector<Literal*> vSimplyNewR;
                        vSimplyNewR.reserve(6);
                        for (UINT16 ActLitInd = 0; ActLitInd < aClap->uLitNum; ++ActLitInd) {
                            Literal* QLit = aClap->LitPtr[ActLitInd];
                            QLit->isDel = 0;
                            if (QLit->subTerm->IsShareVarLit())
                                continue;
                            else {
                                for (UINT32 i = 0; i < lens; ++i) {
                                    if (QLit->isPairPred(triAlg.vOnlyOutTri[i]) && triAlg.unify.LitMgu(QLit, triAlg.vOnlyOutTri[i], chgVarT)) {
                                        QLit->isDel = 1;
                                        varBindT.insert(varBindT.end(), chgVarT.begin(), chgVarT.end());
                                        chgVarT.clear();
                                        isOutPut.push_back(triAlg.vOnlyOutTri[i]);
                                        simplyOut = true;
                                        break;
                                    } else
                                        triAlg.unify.ClearVarBind(chgVarT);
                                }
                            }
                        }
                        if (simplyOut) {
                            //找到可以约减的R保存归结式，得到新子句，定向向后约减
                            for (UINT16 ActLitInd = 0; ActLitInd < aClap->uLitNum; ++ActLitInd) {
                                Literal* QLit = aClap->LitPtr[ActLitInd];
                                isOutPut.push_back(QLit);
                                if (!QLit->isDel)
                                    vSimplyNewR.push_back(QLit);
                            }
                            //输出演绎路径 检查这个的R生成情况，是否有漏文字的情况
                            if (!StrategyParam::orForCompition) {
                                FileOp::CreateRunInfoFile(FileOp::runFileId);
                                *FileOp::ofRealInfoOut << "从编号为" + to_string(aClap->uClaId) + "子句开始构建三角形" << endl;
                            }
                            for (UINT32 k = 0; k < isOutPut.size(); k++) {
                                triAlg.unify.WriteTriPath(isOutPut[k]);
                            }
                            //                        if(uNewClaID == 86)
                            //                            cout<<"cf_debug"<<endl;
                            //生成归结式
                            triAlg.newCla = nullptr;
                            triAlg.newCla = new Clause(uNewClaID, 0);
                            triAlg.newCla->isAxtom = true;
                            size_t uRsize = vSimplyNewR.size();
                            //文字排序
                            if (uRsize > 1)
                                stable_sort(vSimplyNewR.begin(), vSimplyNewR.end(), SortRule::LitCmp);
                            triAlg.newCla->LitPtr = new Literal*[uRsize];
                            for (UINT16 i = 0; i < vSimplyNewR.size(); ++i) {
                                Term* litSubT = triAlg.unify.GetNewTerm(vSimplyNewR[i]->subTerm, triAlg.newCla); //参数1：文字谓词项，参数2：新子句指针
                                if (TNegEqn == GetCodeProp(litSubT->iTermCode)
                                        && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {
                                    /*
                                    delete(litSubT);*/--uRsize;
                                    //delete(newCla->LitPtr[]);
                                    continue;
                                }
                                if (triAlg.newCla->uFuncDepth < litSubT->uLevel)
                                    triAlg.newCla->uFuncDepth = litSubT->uLevel;
                                triAlg.newCla->uVarCount += litSubT->uVarCount;
                                //添加到文字		
                                triAlg.newCla->LitPtr[triAlg.newCla->uLitNum] = new Literal(litSubT, EncodeLitCode(uNewClaID, triAlg.newCla->uLitNum + 1), triAlg.newCla, nullptr);
                                triAlg.newCla->LitPtr[triAlg.newCla->uLitNum]->parentLitPtr = vSimplyNewR[i]; //母式文字，有R产生
                                //triAlg.newCla->LitPtr[triAlg.newCla->uLitNum]->goalDeepth = vSimplyNewR[i]->goalDeepth;
                                //20171020 计算演绎深度
                                if (triAlg.newCla ->deduceDeepth < (vSimplyNewR[i]->claPtr->deduceDeepth + 1)) {
                                    triAlg.newCla ->deduceDeepth = vSimplyNewR[i]->claPtr->deduceDeepth + 1;
                                }
                                if (vSimplyNewR[i]->claPtr->isAxtom && triAlg.newCla->isAxtom)
                                    triAlg.newCla->isAxtom = true;
                                else
                                    triAlg.newCla->isAxtom = false;
                                 if (triAlg.hasUnifGoalLit(fol, triAlg.newCla->LitPtr[triAlg.newCla->uLitNum])) {
                                    triAlg.newCla->LitPtr[triAlg.newCla->uLitNum]->goalDeepth = 1;
                                    if (triAlg.newCla->goaldeepth > 1)
                                        triAlg.newCla->goaldeepth = 1;
                                } else {
                                    triAlg.newCla->LitPtr[triAlg.newCla->uLitNum]->goalDeepth = vSimplyNewR[i]->goalDeepth;
                                    if (triAlg.newCla->goaldeepth > vSimplyNewR[i]->goalDeepth)
                                        triAlg.newCla->goaldeepth = vSimplyNewR[i]->goalDeepth;
                                }
                                //cout<<to_string(newCla->uClaId)  + "]" <<"[" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitRow()) + "_" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitCol()) + "]" << newCla->LitPtr[newCla->uLitNum]->subTerm->ToString()<<endl;  
                                ++(triAlg.newCla->uLitNum);
                            }
                            if (uRsize != 0) {
                                fol.initGenerateClaAttr(triAlg.newCla);
                                uNewClaID++;
                                Clause* newCla = triAlg.newCla;
                                //20171020 对子句的含等词的文字进行项序处理
                                if (StrategyParam::termRewriting != 2) {
                                    newCla->directEqn();
                                }
                                if (!StrategyParam::orForCompition)
                                    FileOp::WriteR(newCla);

                                if (/*StrategyParam::orForCompition*/true) {
                                    newCla->addRForCompetiton();

                                    string rStr = "";
                                    newCla->toString(rStr);
                                    string outClauses = "";
                                    for (UINT8 k = 0; k < isOutPut.size(); ++k) {
                                        //outClauses += to_string(isOutPut[k]-> claPtr->uClaId) + ",";
                                        if(find(validPathOut[uNewClaID-1].begin(),validPathOut[uNewClaID-1].end(),isOutPut[k]-> claPtr->uClaId) == validPathOut[uNewClaID-1].end()){
                                            validPathOut[uNewClaID-1].push_back(isOutPut[k]-> claPtr->uClaId);
                                            outClauses += "c_0_" + to_string(isOutPut[k]-> claPtr->uClaId) + ",";
                                        }
                                    }
                                    //outClauses += to_string(aClap->uClaId);
                                    if(find(validPathOut[uNewClaID-1].begin(),validPathOut[uNewClaID-1].end(),aClap->uClaId) == validPathOut[uNewClaID-1].end()){
                                        validPathOut[uNewClaID-1].push_back(aClap->uClaId);
                                        outClauses += "c_0_" + to_string(aClap->uClaId);
                                    }
                                    if(outClauses[outClauses.size() -1] == ','){
                                        outClauses.erase(outClauses.size() -1, 1);
                                    }
                                    //string out = "cnf(" + to_string(uNewClaID) + ",plain,\n" + "   scs_inference(" + outClauses + ")).";
//                                    int begPos = rStr.find_first_of("[") + 1;
//                                    int endPos = rStr.find_first_of("]");
//                                    string rId = rStr.substr(begPos, endPos - begPos);
//                                    string rContext = rStr.substr(rStr.find_first_of("]") + 1);
//                                    string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n" + "   inference(scs_inference,[]," + "[" + outClauses +"]"+ ")).";
//                                    *FileOp::ofOutput << out << endl;
                                    
                                    string cnf_str = newCla->ToStringWithSemantics(rStr);
                                    size_t pos = cnf_str.find_last_of(')');
                                    string cnf_str_sub = cnf_str.substr(0, pos);
                                    string out = cnf_str_sub + ", inference(scs_inference,[],[" + outClauses + "]" + ")).";
                                    *FileOp::ofOutput << out << endl;
                                }
                                
                                //insertNoPairCla(fol, newCla);
                                if (!StrategyParam::orForCompition) {
                                    string vaildInf = "|[Y]";
                                    FileOp::RInvaildInfoOut(vaildInf, StartId);
                                }
                                ++triTotalTimes; //20170808 此处也应该为构建三角形
                                simplfyCla.push_back(newCla); //归结式入栈
                                simplfyClaDel.push_back(aClap); //约简的子句入栈
                                if (newCla->uLitNum == 1)
                                    if (StrategyParam::R_Weight == -1)
                                        newCla->adeductNum = 0; //权重设置
                                    else
                                        newCla->adeductNum = StrategyParam::R_Weight;
                                else
                                    if (StrategyParam::R_Weight == -1)
                                    newCla->pdeductNum = 0; //20170217 end//权重设置
                                else
                                    newCla->pdeductNum = StrategyParam::R_Weight; //20170217 end//权重设置
                            }
                            else {
                                triAlg.newCla->DelLits(false);
                                delete(triAlg.newCla);
                            }                            
                        }
                        vSimplyNewR.clear();
                        vector<Literal*>().swap(vSimplyNewR);
                    }
                    triAlg.unify.ClearVarBind(varBindT);
                    vector<Term*>().swap(varBindT);
                    isOutPut.clear();
                    vector<Literal*>().swap(isOutPut);
                    triAlg.unify.ClearVarBind(chgVarT);
                    chgVarT.clear();
                }
                //            if(triTotalTimes == 156){
                //                cout<<"cf_debug"<<endl;
                //            }
                //对约简的simplfyCla中子句进行约简处理
                if (!simplfyCla.empty()) {
                    for (int m = 0; m < simplfyCla.size(); ++m) {
                        //20170531 将此处改成定向冗余
                        fol.BackwardSubsumpDirect(*(simplfyCla[m]), *(simplfyClaDel[m])); //向后冗余
                        fol.InsertCla(simplfyCla[m]);
                        fol.setCla.insert(simplfyCla[m]);
                        if (StrategyParam::termRewriting != 2)
                            fol.judgeInsertSuper(simplfyCla[m]);
                    }
                    simplfyCla.clear();
                    vector<Clause*>().swap(simplfyCla);
                    simplfyClaDel.clear();
                    vector<Clause*>().swap(simplfyClaDel);
                }
            }
            //simplyIdStart= uNewClaID -1;
            triAlg.unify.ClearVarBind(chgVarT);
            //清空chgVarT
            chgVarT.clear();
            vector<Term*>().swap(chgVarT);
            if (!givenClaP)
                continue;
        }
        else {
            StrategyParam::noUnitRes = true;    //没有单元子句的标志为true
            chooseTri = false;
            givenClaP = nullptr;
            //将所有非单元子句加入到fol.noPairSingleCla中
            if(fol.setSingleCla.size() == 0 && !firstSwitch){
                //将没有使用的子句加入到noPairSingleCla
                for (auto& aClap : fol.setCla){
                    if(aClap->uLitNum == 1 || ((aClap->uClaId <= simplyIdEnd) && (aClap->uClaId >= simplyIdStart))){
                        continue;
                    }
                    insertNoPairCla(fol, aClap);
                }
            }
        }
        chgCla.clear();   
        //如果没有满足条件的givenClaP非单元子句，即为空
        // </editor-fold>
        
        triAlg.allNoPair = false;
        simplyIdStart = simplyIdEnd+1;
        firstSwitch = false;//第一次处理结束 add:20170705  
        
        // <editor-fold defaultstate="collapsed" desc="构建1个三角形">
        UINT8 resolutionRes = 0;
        if(chooseTri) {//考虑好流程
            StrategyParam::cseRunMode = StrategyParam::firstCseRunMode;
            
            StrategyParam::deductMode = 1;
            if(!StrategyParam::deductMode){//20170915 从右到左构建三角形
                if (!StrategyParam::orForCompition)
                    FileOp::CreateRunInfoFile(FileOp::runFileId);
                resolutionRes = triAlg.GenerateTriByRecodePath(fol,&*givenClaP, uNewClaID, backType,chgCla,loop); //参数1：起步子句；参数2：新子句的编号；参数3：不回退
            }
            else{//20170915 从左到右构建三角形
                if (!StrategyParam::orForCompition)
                    FileOp::CreateRunInfoFile(FileOp::runFileId);
                //将子句集选取放入候选子句集中
                vector<Clause*> candidateClaSet;
                candidateClaSet.reserve(16);
                for (auto& aClap : fol.setCla) {
                    if(aClap->uLitNum != 1){
                        candidateClaSet.push_back(aClap);
                    }
                }
                for (auto& aClap : fol.setEnq){
                    if(aClap->uLitNum != 1){
                        candidateClaSet.push_back(aClap);
                    }
                }
                //排序
                //cout << "cseRunMode: " << StrategyParam::cseRunMode << endl;
                if((StrategyParam::unitSortRule == 0) || (StrategyParam::unitSortRule == 1)){
                    stable_sort(candidateClaSet.begin(), candidateClaSet.end(), SortRule::PoslitCmpProRL);
                    //stable_sort(candidateClaSet.begin(), candidateClaSet.end(), SortRule::PoslitCmpPriorLR);
                }
                else
                    stable_sort(candidateClaSet.begin(), candidateClaSet.end(), SortRule::PoslitCmpPriorLR);
                    //stable_sort(candidateClaSet.begin(), candidateClaSet.end(), SortRule::PoslitCmpProRL);//PoslitCmpLR PoslitCmpPriorLR
                if(StrategyParam::cseRunMode == 0){
                    resolutionRes = triAlg.GenerateTriByRecodePathLROptimalProofSearch(fol,candidateClaSet, uNewClaID, backType,chgCla,loop);
                }
                else if(StrategyParam::cseRunMode == 1){
                    resolutionRes = triAlg.GenerateTriByRecodePathLR(fol,candidateClaSet, uNewClaID, backType,chgCla,loop);//fullUseOf
                }
                else if(StrategyParam::cseRunMode == 2){
                    if (((double) (clock() - StrategyParam::start) / (double) CLOCKS_PER_SEC) < StrategyParam::distriTime * 12) {//60
                        resolutionRes = triAlg.GenerateTriByRecodePathLROptimalProofSearch(fol, candidateClaSet, uNewClaID, backType, chgCla, loop);
                    }
                    else
                        resolutionRes = triAlg.GenerateTriByRecodePathLR(fol,candidateClaSet, uNewClaID, backType,chgCla,loop);//fullUseOf
                }
                else if((StrategyParam::cseRunMode == 3)){
                    if (((double) (clock() - StrategyParam::start) / (double) CLOCKS_PER_SEC) < StrategyParam::distriTime * 12) {//60
                        resolutionRes = triAlg.GenerateTriByRecodePathLR(fol,candidateClaSet, uNewClaID, backType,chgCla,loop);//fullUseOf
                    }
                    else
                        resolutionRes = triAlg.GenerateTriByRecodePathLROptimalProofSearch(fol, candidateClaSet, uNewClaID, backType, chgCla, loop);
                }
                else if(StrategyParam::cseRunMode == 4){
                    resolutionRes = triAlg.GenerateTriByRecodePathLRCombined(fol,candidateClaSet, uNewClaID, backType,chgCla,loop);//fullUseOf
                }
                else if(StrategyParam::cseRunMode == 5){
                    resolutionRes = triAlg.GenerateTriByRecodePathLRCombined2(fol,candidateClaSet, uNewClaID, backType,chgCla,loop);//fullUseOf
                }
                else if(StrategyParam::cseRunMode == 6){//CSE1.4
                    resolutionRes = triAlg.GenerateTriByRecodePathLRCancelLimit(fol,candidateClaSet, uNewClaID, backType,chgCla,loop);//fullUseOf
                }
                else if (StrategyParam::cseRunMode == 7) { //Liu充分使用二元子句
                    resolutionRes = triAlg.GenerateTriByRecodePathLRFullUseBinaryClause(fol, candidateClaSet, uNewClaID, backType, chgCla);
                }
                else if (StrategyParam::cseRunMode == 10) {
                    RESULT res = triAlg.DoTri_Goal(fol, uNewClaID);
                }
                //return UNKNOWN;
                //resolutionRes = triAlg.GenerateTriByRecodePathLR(fol,candidateClaSet, uNewClaID, backType,chgCla,loop); //参数1：起步子句；参数2：新子句的编号；参数3：不回退
                candidateClaSet.clear();
                vector<Clause*>().swap(candidateClaSet);
            }
            ++triTotalTimes;
            if(fol.noPairSingleCla.size()>0 &&StrategyParam::noUnitRes &&(triTotalTimes%triAlgTimes == 0))//20170816 增加比例做三角形的比例  &&(triTotalTimes%6 == 0)
                chooseTri = false;
        }
        else if(StrategyParam::noUnitRes && !chooseTri){
            //set<Clause*>::iterator setClaIt = fol.setOriClas.begin();
            givenClaP = nullptr;
            vector<Clause*> claNoPairVec;
            claNoPairVec.reserve(8);
            if((fol.noPairSingleCla.size()>0) || insertNoUseCla){
                if (insertNoUseCla/* &&(time_sPair > (StrategyParam::timeLimit-1) * 60)*/)//200   3  1分钟 15  5分钟   30  15分钟  end:300
                {
                    for(auto& claP :fol.setCla){
                        //if(!claP->isUse)
                            insertNoPairCla(fol, claP);//fol.noPairSingleCla.insert(claP);
                    }
                    //20190516 add
                    for(auto& claP :fol.setEnq){
                        //if(!claP->isUse)
                            insertNoPairCla(fol, claP);//fol.noPairSingleCla.insert(claP);
                    }
                    insertNoUseCla = false;
                }
                //选择主动归结次数最少的子句进行归结
                //20170816 对子句进行排序 按文字数
                for (auto& claP : fol.noPairSingleCla) {
                     //20171020 加入演绎深度限制
//                    if (claP->deduceDeepth > StrategyParam::deduceDepth) {
//                        continue;
//                    }
//                    if(claP->isUse && !difficulty ){
//                        set<Clause*> ::iterator delItNoPair = fol.noPairSingleCla.find(claP);
//                        if (delItNoPair != fol.noPairSingleCla.end()) {
//                            fol.noPairSingleCla.erase(delItNoPair);
//                        }
//                        continue;
//                    }
                    //20170711 增加过滤fol.noPairSingleCla中含有单元子句的异常清空
                    if(claP->uLitNum == 1){
                        continue;
                    }
                    claNoPairVec.push_back(claP);
                }
                if((fol.noPairSingleCla.size() == 0) ||(claNoPairVec.size() == 0)){
                    chooseTri = true;
                    continue;
                }
                if(claNoPairVec.size() != 0){
                    stable_sort(claNoPairVec.begin(), claNoPairVec.end(), SortRule::noPairClaCmp);
                }
                if(claNoPairVec.size()>= noPairInd+1){
                    for(UINT32 m=0; m<=noPairInd;++m){
                        if(claNoPairVec[m]->noPairResFiFg == false){//如果在序号的前面存在新未归结完的子句(肯定文字个数要少)
                            //交换 
                            swap(claNoPairVec[m],claNoPairVec[noPairInd]);
                            break;
                        }
                    }
                }
                
                if (noPairInd >= claNoPairVec.size())
                    noPairInd = 0;
                givenClaP = claNoPairVec[noPairInd];
                UINT32 countSize = 0;
                while(givenClaP->uLitNum >= litSize){//设定一个长度,非单元子句起步子句文字数不能大于16
                    ++noPairCla;
                    if (noPairInd >= claNoPairVec.size())
                        noPairInd = 0;
                     givenClaP = claNoPairVec[noPairInd];
                    ++countSize;
                    if(countSize == claNoPairVec.size())
                        break;
                }
                noPairCla = givenClaP;
            }
            
            if (givenClaP) {//找到文字最少的子句
                triAlg.vOutTri.clear();
                if (!StrategyParam::orForCompition)
                    FileOp::CreateRunInfoFile(FileOp::runFileId);
//                if (givenClaP->uClaId == 322) {
//                    string str;
//                    givenClaP->toString(str);
//                    cout << "起步子句:" << str << endl;
//                }
//                string str;
//                givenClaP->toString(str);
//                cout << "起步子句:" << str << endl;
                resolutionRes = triAlg.GenerateTriByRecodePathNoUnit(fol, &*givenClaP, uNewClaID, backType, chgCla); //参数1：起步子句；参数2：新子句的编号；参数3：不回退
                ++triTotalTimes;
            }
            chooseTri = true;
            claNoPairVec.clear();
            vector<Clause*>().swap(claNoPairVec);
        }
        // </editor-fold>
        
        // <editor-fold defaultstate="collapsed" desc="三角形构建完成后结果的处理1：没有满足条件的起步子句的情况，处理完后continue">
        //如果没有满足条件的givenClaP非单元子句，即为空
        if (!givenClaP){
            ++StrategyParam::noUintCla;
            if(StrategyParam::noUintCla > 8)
                StrategyParam::noUintCla = 0;
            continue;
        }
        // </editor-fold>
       
        // <editor-fold defaultstate="collapsed" desc="三角形构建完成后结果的处理2：triAlg.allNoPair == true 的情况，处理完后continue">
        //20170214 若所有的主对角线文字都没有找到满足条件互补的子句，则不输出R  注意if条件
        if(triAlg.allNoPair) {
            //20170220 增加子句冗余次数权重
            //20170824 所有的单元子句都没有互补对,则需要降低归结式的限制
            if(resolutionRes == 33){//二元归结没有互补对,表示起步子句已经用完
                if (!StrategyParam::orForCompition)
                    FileOp::delCreateRunInfoFile(FileOp::runFileId);
//                givenClaP->noUnitDeductTimes += 10;
//                if (givenClaP->noUnitDeductTimes == 1000)
//                    givenClaP->noUnitDeductTimes = 0;
//                //1.20170912 加入迭代次数
//                //标记是否修改过
//                if(noPairIt < noPairInd){//说明修改过
//                    noPairIt = noPairInd;
//                }
//                else//没有修改过
//                    ++noPairIt;
                for (auto& claP : fol.noPairSingleCla) {
                    claP->noUnitDeductTimes = 0;
                }
                givenClaP->noPairResFiFg = true;
                ++noPairInd;
            }
            else if((resolutionRes == 22) ||(resolutionRes == 222) ){//单元子句构建三角形全部冗余 
                if (!StrategyParam::orForCompition)
                    FileOp::delCreateRunInfoFile(FileOp::runFileId);
                triAlgTimes = 1;
                if(fol.noPairSingleCla.size() == 0){
                    fol.initNoPairCla();
                }
                //chooseTri = false;
                //difficulty = true;
                StrategyParam::noUnitRes = true;
                if((FileOp::strategyMode != 3)&&(FileOp::strategyMode != 4))
                    ++StrategyParam::R_MAX_FUNCLAYER;
                if(StrategyParam::R_MAX_FUNCLAYER == 21)
                    StrategyParam::R_MAX_FUNCLAYER = StrategyParam::R_MAX_FUNCLAYER_TMP;
                else if(StrategyParam::R_MAX_FUNCLAYER > 100)
                    StrategyParam::R_MAX_FUNCLAYER = 16;
                //必须设置一个限制
                if(StrategyParam::R_MAX_FUNCLAYER == (StrategyParam::R_INIT_MAX_FUNCLAYER*2 +1)){
                    StrategyParam::R_MAX_FUNCLAYER = StrategyParam::R_MAX_FUNCLAYER_TMP;
                }
                if((FileOp::strategyMode != 3)&&(FileOp::strategyMode != 4))
                    ++StrategyParam::R_MAX_NUM;
                if(StrategyParam::R_MAX_NUM == StrategyParam::R_INIT_MAX_NUM){
                    StrategyParam::R_MAX_NUM = StrategyParam::R_MAX_NUM_TMP;
                }
                else if(StrategyParam::R_MAX_NUM > 50){
                    StrategyParam::R_MAX_NUM = 16;
                }
            }
            else if(resolutionRes == 211){
                loop = 0;
            }
            //triAlg.vOnlyOutTri[0]->claPtr->reduntTimes++;//(int)((double) (clock() - start) / (double) CLOCKS_PER_SEC)%30
            long leftMem = FileOp::getMem();
            if (leftMem < StrategyParam::memLimit && StrategyParam::orForCompition == false) {
                chgCla.clear();
                vector<Clause*>().swap(chgCla);
                preGenCla.clear();
                vector<Clause*>().swap(preGenCla);
                FileOp::LogOut("内存超出限制,无法判定！剩余内存:" + to_string(leftMem));
                string fileMemOut = FileOp::g_OutputPath + "/"  + "memleft.log";
                string cmdMem = "ps -aux | sort -k4nr | head -10 >> " + fileMemOut;
                int res = system(const_cast<char*> (cmdMem.c_str()));
                if (!StrategyParam::orForCompition)
                    cout << "无法判定,内存超出限制" << endl;
                else
                    cout << "TMO-Non" << endl;
                
                //20171022 将三角形演绎过程中复制的子句全部删除
                triAlg.delSaveCopyCla(fol);
                FileOp::outReleaseOf();
                //20170315 输出最后的单元子句 方便程序完善
//                string str = "";
//                if (!StrategyParam::orForCompition && (FileOp::runMode != 0) && (FileOp::runMode != 1)) {
//                    fol.uOrigClaSingleSize = 0;
//                    str += fol.ToSingleString();
//                    FileOp::PrintINFOEndRSinglePre(str); //输出所有的单元子句到.erspre
//                }
                
                
                //cout << "内存不足,无法判定(请查看电脑运行情况)" << endl;
                return UNKNOWN;
            }
            clock_t endNoPair = clock();
            double time_sNoPair = (double) (endNoPair - StrategyParam::start) / (double) CLOCKS_PER_SEC;
//            if(time_sNoPair > StrategyParam::timeLimit *45){
//                cout<<"cf-debug"<<endl;
//            }
//            if(time_sNoPair > StrategyParam::timeLimit *11){
//                cout<<"cf-debug"<<endl;
//            }
            //时间限制 单位:分钟
//            double breakTimeA = 0.0;
//            if((FileOp::runMode != 0 )&&(FileOp::runMode != 1)){
//                breakTimeA = StrategyParam::timeForceLimit - 10;
//            }
//            else if((FileOp::runMode == 0 )||(FileOp::runMode == 1)){
//                breakTimeA = StrategyParam::timeForceLimit - 10;
//            }
            if (time_sNoPair > StrategyParam::firstTimeLimit *60/*breakTimeAStrategyParam::timeForceLimitStrategyParam::timeLimit *60*/) {//200   3  1分钟 15  5分钟   30  15分钟  end:300
                //20171022 将三角形演绎过程中复制的子句全部删除
                triAlg.delSaveCopyCla(fol);
                FileOp::outReleaseOf();
                //20170315 输出最后的单元子句 方便程序完善
//                string str = "";
//                if (!StrategyParam::orForCompition && (FileOp::runMode != 0) && (FileOp::runMode != 1)) {
//                    fol.uOrigClaSingleSize = 0;
//                    str += fol.ToSingleString();
//                    FileOp::PrintINFOEndRSinglePre(str); //输出所有的单元子句到.erspre
//                }
                
//                if(!StrategyParam::orForCompition) {
//                    string str = "";
//                    str += fol.ToUnUseString();
//                    FileOp::PrintINFONoUsePre(str); //输出所有的未使用子句到.nousepre
//                    FileOp::LogOut("超出时间" + to_string(StrategyParam::timeLimit) +"分钟限制,无法判定！");
//                }
                
                if ((!StrategyParam::orForCompition) && FileOp::runMode == 0)
                    cout << "CSE 无法判定" << endl;
//                else 
//                    cout << "TMO-Non" << endl;
                chgCla.clear();
                vector<Clause*>().swap(chgCla);
                preGenCla.clear();
                vector<Clause*>().swap(preGenCla);
                return UNKNOWN;
            }
            if (StrategyParam::genLitClause && (loop > 0) && (triAlg.total_Loop / loop < 2) && StrategyParam::orForCompition == false) {
                --loop;
            }
            else if (((fol.noPairSingleCla.size()>0) &&StrategyParam::noUnitRes &&!chooseTri )||(chooseTri &&(!StrategyParam::noUnitRes || (fol.noPairSingleCla.size() == 0)) )) { //modify 20170705
//                shift++; //说明起步子句不合适做三角形，跳出迭代选取下一个单元子句构建三角形
//                triAlg.flagT = true;
                loop = 0;
            }
            FileOp::outReleaseOf();
            continue;
        }
        // </editor-fold>
        
        // <editor-fold defaultstate="collapsed" desc="三角形构建完成后结果的处理3：三角形生成的R与中间归结式相同时的过滤处理">
        Clause* newCla = triAlg.newCla;
        //增加当归结式R与中间归结式相同时的过滤处理
        bool rFilter = false;
        if((chgCla.size() == 0) || (triAlg.vNewR.empty() || triAlg.newCla->uLitNum == 0)){
            rFilter = false;
        }
        else{
            UINT32 midLens = chgCla.size();
            if(chgCla[midLens-1]->uLitNum != newCla->uLitNum){
                rFilter = false;
            }
            else{
                UINT32 countRSize = 0;
                for(UINT32 pos=0; pos < newCla->uLitNum; ++pos){
                    Literal* litR = newCla->LitPtr[pos];
                    Literal* midR = chgCla[midLens-1]->LitPtr[pos];
                    if(litR->isEqPred(midR) && triAlg.unify.CheckEqnR(litR->subTerm,midR->subTerm)){
                        ++countRSize;
                        continue;
                    }
                    else
                        rFilter = false;
                }
                if(countRSize == newCla->uLitNum)
                    rFilter = true;
            }
        }
        if(!rFilter) {
            //输出演绎路径	
            if (resolutionRes == 44){
                if (!StrategyParam::orForCompition) 
                    *FileOp::ofRealInfoOut << "从编号为" + to_string(givenClaP->uClaId) + "子句开始非单元子句演绎" << endl;
                triAlg.PrintTriTwoPath();
            }
            else{
                if (!StrategyParam::orForCompition)
                    *FileOp::ofRealInfoOut << "从编号为" + to_string(givenClaP->uClaId) + "子句开始构建三角形" << endl;
                //difficulty = false;
                triAlgTimes = 16;
                UINT32 realStartId = triAlg.PrintTriPath();
                //当起步子句不是三角形演绎的第一个子句,需要强行更换起步子句
                if(realStartId != givenClaP->uClaId){
                    loop = 1;
                }
            }
            //此处需要做冗余处理

            //        if(newCla->uClaId == 310){
            //            cout<<"cf-debug"<<endl;
            //        }
            /*判定不可满足*/
            if (triAlg.vNewR.empty() || triAlg.newCla->uLitNum == 0) {
                if (!StrategyParam::orForCompition) {
                    FileOp::WriteR(nullptr);
                    FileOp::LogOut("# ==子句" + to_string(givenClaP->uClaId) + "起步，结论正确(UNSAT)！");
                }
                chgCla.clear();
                vector<Clause*>().swap(chgCla);
                preGenCla.clear();
                vector<Clause*>().swap(preGenCla);
                if (/*StrategyParam::orForCompition*/true) {
                    
                    string outClauses = triAlg.PrintCompetitionOut_eFormat(0);
                    string out = "cnf(c_0_" + to_string(uNewClaID) + ", plain,"+ " ($false),"+" inference(scs_inference,[]," + "[" + outClauses +"]" + ")," + "   ['proof']"+ ").";
                   
                    *FileOp::ofOutput << out << endl;
                }
                return UNSAT;
            }
            
            //20171020 对子句的含等词的文字进行项序处理
            if (StrategyParam::termRewriting != 2){
                    newCla->directEqn();
            }
            if (!StrategyParam::orForCompition)
                FileOp::WriteR(newCla);
           
            //20170903 增加清空变元替换项,三角形构建完成应该立刻清空,否则影响前后冗余处理
            triAlg.BackPathClear();
            UINT16 rLen = newCla->uLitNum;
            vector<UINT32>invaildLitId; //
            string rundMsg; //冗余信息
            Subsumption subsump; //(MOSTRIGHT)
            //参数1 被测的子句指针 参数2 整形数组 参数3 字符串 记录冗余信息
            bool isRundacyR = subsump.GenCla(fol,newCla, invaildLitId, rundMsg);
            //        if(newCla->uClaId == 310){
            //            cout<<rundMsg<<endl;
            //        }
            bool RFactorFlag = false;
            if (!StrategyParam::orForCompition)
                FileOp::RInvaildInfoOut(rundMsg, StartId);

            if (isRundacyR) {
                newCla->DelLits(false);
                delete(newCla);
            } else {
                if (/*StrategyParam::orForCompition*/true) {
                    newCla->addRForCompetiton();
                    
                    string rStr = "";
                    newCla->toString(rStr);
                    
                    string cnf_str = newCla->ToStringWithSemantics(rStr);
                    string ruleClas = triAlg.PrintCompetitionOut_eFormat(uNewClaID - 1);
                    size_t pos = cnf_str.find_last_of(')');
                    string cnf_str_sub = cnf_str.substr(0, pos);
                    string out = cnf_str_sub + ", inference(scs_inference,[],[" + ruleClas + "]" + ")).";
                    *FileOp::ofOutput << out << endl;
                }
                bool resFlag = true;
//                if (triAlg.claHasPureLit(fol, newCla)) {
//                    newCla->DelLits(false);
//                    delete(newCla);
//                    resFlag = false;
//                }
                if (resFlag) {
                    //fol.BackwardSubsump(*newCla); //向后冗余
                    fol.BackwardSubsumpClaSet(*newCla,chgCla,false); //向后冗余
                    if (newCla->uLitNum == 1)
                        if (StrategyParam::R_Weight == -1)
                            newCla->adeductNum = 0; //权重设置
                        else
                            newCla->adeductNum = StrategyParam::R_Weight;
                    else
                        if (StrategyParam::R_Weight == -1)
                        newCla->pdeductNum = 0; //20170217 end//权重设置
                    else
                        newCla->pdeductNum = StrategyParam::R_Weight; //20170217 end//权重设置
                    fol.InsertCla(newCla);
                    fol.setCla.insert(newCla);
                    if (StrategyParam::termRewriting != 2)
                        fol.judgeInsertSuper(newCla);
                    //20170903 若是正等词单元子句需要加入等词处理中
                    if (1) {//20170903 没有单元子句互补对,需要添加到集合中
//                        if ((newCla->uLitNum > 1) && (newCla->goaldeepth == 0)) {
//                            if (fol.noPairSingleCla.find(newCla) == fol.noPairSingleCla.end()) {
//                                fol.noPairSingleCla.insert(newCla);
//                            }
//                        }
                        insertNoPairCla(fol, newCla);
                    }
                }
            }
        }//需要过滤
        else {
            newCla->DelLits(false);
            delete(newCla);
            --uNewClaID;
        }
        // </editor-fold>
        
        // <editor-fold defaultstate="collapsed" desc="三角形构建完成后结果的处理4：中间式的处理，处理完后continue">
        //20170213 生成的单文字子句已经判断了冗余，所以这个部分只需判断最后1个单文字子句即可
        //20170816 新增了保存2个文字的中间子句
        for(int m=0;m<chgCla.size();m++)
        {
//            if(chgCla[m]->uLitNum == 0){
//                cout<<"debug1"<<endl;
//            }
            if (1) {
                //20170602 新增小三角形判断输出
                if (!StrategyParam::orForCompition) {
                    if (!StrategyParam::divideTri) {
                        *FileOp::ofRealInfoOut << "R[" + to_string(chgCla[m]->uClaId) + "]" << "[" + to_string(chgCla[m]->LitPtr[0]->ParentLitRow()) + "_" + to_string(chgCla[m]->LitPtr[0]->ParentLitCol()) + "]" << chgCla[m]->LitPtr[0]->subTerm->ToString();
                        *FileOp::ofRealInfoOut << "|[Y]" << endl;
                    }
                }
                bool resFlag = true;
                if(resFlag) 
                {
//                    if(1){
//                        set<Clause*>::iterator claP_it = fol.setCla.find(chgCla[m]);
//                        if (claP_it != fol.setCla.end())
//                            continue;
//                    }
                    //fol.BackwardSubsump(*chgCla[m]); //向后冗余 参数：子句对象//BackwardSubsumpClaSet
                    fol.BackwardSubsumpClaSet(*chgCla[m],chgCla,true); //向后冗余 参数：子句对象
                    //20170225 设置权重
                    if (chgCla[m]->uLitNum == 1) {
                        if (StrategyParam::R_Weight == -1)
                            chgCla[m]->adeductNum = 0;
                        else
                            chgCla[m]->adeductNum = StrategyParam::R_Weight;
                    } else {
                        if (StrategyParam::R_Weight == -1)
                            chgCla[m]->pdeductNum = 0;
                        else
                            chgCla[m]->pdeductNum = StrategyParam::R_Weight;
                    }
//                    fol.InsertCla(chgCla[m]);
//                    fol.setCla.insert(chgCla[m]);
                    if (StrategyParam::termRewriting != 2)
                        fol.judgeInsertSuper(chgCla[m]);
                    //20170903 若是正等词单元子句需要加入等词处理中
                    if (1){//20170903 没有单元子句互补对,需要添加到集合中
                        insertNoPairCla(fol, chgCla[m]);
                    }
                }
                
                continue;
            }
        }
        // </editor-fold>
        
        // <editor-fold defaultstate="collapsed" desc="三角形构建完成后结果的处理5：内存检查">
        long leftMem = FileOp::getMem();
        if(leftMem<StrategyParam::memLimit && StrategyParam::orForCompition == false)
        {
            chgCla.clear();
            vector<Clause*>().swap(chgCla);
            preGenCla.clear();
            vector<Clause*>().swap(preGenCla);
            FileOp::LogOut("内存超出限制,无法判定！剩余内存:" + to_string(leftMem));
            string fileMemOut = FileOp::g_OutputPath + "/" + "memleft.log";
            string cmdMem = "ps -aux | sort -k4nr | head -10 >> " + fileMemOut;
            int res = system(const_cast<char*> (cmdMem.c_str()));
            if (!StrategyParam::orForCompition)
                cout << "无法判定,内存超出限制" << endl;
            else
                cout << "TMO-Non" << endl;
            
            //20171022 将三角形演绎过程中复制的子句全部删除
                triAlg.delSaveCopyCla(fol);
                FileOp::outReleaseOf();
                //20170315 输出最后的单元子句 方便程序完善
//                string str = "";
//                if (!StrategyParam::orForCompition && (FileOp::runMode != 0) && (FileOp::runMode != 1)) {
//                    fol.uOrigClaSingleSize = 0;
//                    str += fol.ToSingleString();
//                    FileOp::PrintINFOEndRSinglePre(str); //输出所有的单元子句到.erspre
//                }
            
            //cout<< "内存不足,无法判定(请查看电脑运行情况)"<<endl;
            return UNKNOWN;
        }
        // </editor-fold>
        
        // <editor-fold defaultstate="collapsed" desc="三角形构建完成后结果的处理6：时间检查">
        clock_t end = clock();
        double time_s = (double)(end - StrategyParam::start)/(double)CLOCKS_PER_SEC;
        
//        double breakTimeB = 0.0;
//        if ((FileOp::runMode != 0)&&(FileOp::runMode != 1)) {
//            breakTimeB = StrategyParam::timeForceLimit - 10;
//        } else if ((FileOp::runMode == 0) || (FileOp::runMode == 1)) {
//            breakTimeB = StrategyParam::timeForceLimit - 10;
//        }
        
        //cout << triTotalTimes << ": " << time_s << "s" << endl; //LiuDebug
         
        if(time_s > StrategyParam::firstTimeLimit *60/*breakTimeBStrategyParam::timeForceLimitStrategyParam::timeLimit *60*/)//200   3  1分钟 15  5分钟   30  15分钟  end:300
        {
            //20171022 将三角形演绎过程中复制的子句全部删除
            triAlg.delSaveCopyCla(fol);
            FileOp::outReleaseOf();
            //20170315 输出最后的单元子句 方便程序完善
            
//            string str = "";
//            if (!StrategyParam::orForCompition && (FileOp::runMode != 0)&&(FileOp::runMode != 1)) {
//                fol.uOrigClaSingleSize = 0;
//                str += fol.ToSingleString();
//                FileOp::PrintINFOEndRSinglePre(str); //输出所有的单元子句到.erspre
//            }
            
//            if(!StrategyParam::orForCompition) {
//                str = "";
//                str += fol.ToUnUseString();
//                FileOp::PrintINFONoUsePre(str); //输出所有的未使用子句到.nousepre
//                FileOp::LogOut("超出时间"+ to_string(StrategyParam::timeLimit) +"分钟限制,无法判定！");
//            }
            
            if ((!StrategyParam::orForCompition) && FileOp::runMode == 0)
                cout << "CSE 无法判定" << endl;
//            else
//                cout << "TMO-Non" << endl;
            chgCla.clear();
            vector<Clause*>().swap(chgCla);
            preGenCla.clear();
            vector<Clause*>().swap(preGenCla);
            return UNKNOWN;
        }
        // </editor-fold>
    }
    // </editor-fold>
    
    return UNKNOWN;
}

void Resolution::insertNoPairCla(Formula& fol, Clause* cla){
    UINT16 ulitN = cla->uLitNum;
    if(ulitN == 1)
        return;
    switch(StrategyParam::noUintCla){
        case 0:
            if (ulitN == 2) {
                if (fol.noPairSingleCla.find(cla) == fol.noPairSingleCla.end()) {
                    fol.noPairSingleCla.insert(cla);
                }
            }
            break;
        case 1:
            if (ulitN <= 3) {
                if (fol.noPairSingleCla.find(cla) == fol.noPairSingleCla.end()) {
                    fol.noPairSingleCla.insert(cla);
                }
            }
            break;
          case 2:
            if (ulitN <= 4) {
                if (fol.noPairSingleCla.find(cla) == fol.noPairSingleCla.end()) {
                    fol.noPairSingleCla.insert(cla);
                }
            }
            break;
          case 3:
            if (ulitN <= 5) {
                if (fol.noPairSingleCla.find(cla) == fol.noPairSingleCla.end()) {
                    fol.noPairSingleCla.insert(cla);
                }
            }
            break;
          case 4:
            if ((ulitN == 2) || cla->isGoal) {
                if (fol.noPairSingleCla.find(cla) == fol.noPairSingleCla.end()) {
                    fol.noPairSingleCla.insert(cla);
                }
            }
            break;
          case 5:
            if ((ulitN <= 3) || cla->isGoal ) {
                if (fol.noPairSingleCla.find(cla) == fol.noPairSingleCla.end()) {
                    fol.noPairSingleCla.insert(cla);
                }
            }
            break;
          case 6:
            if ((ulitN <= 4) || cla->isGoal) {
                if (fol.noPairSingleCla.find(cla) == fol.noPairSingleCla.end()) {
                    fol.noPairSingleCla.insert(cla);
                }
            }
            break;
          case 7:
            if ((ulitN <= 5) || cla->isGoal) {
                if (fol.noPairSingleCla.find(cla) == fol.noPairSingleCla.end()) {
                    fol.noPairSingleCla.insert(cla);
                }
            }
            break;
          case 8:
            if (1) {
                if (fol.noPairSingleCla.find(cla) == fol.noPairSingleCla.end()) {
                    fol.noPairSingleCla.insert(cla);
                }
            }
            break;
    }
}
 RESULT Resolution::BaseAlgByRecodePathSaturate(Formula& fol, UINT64 &triTotalTimes)
{
     shift = 0;
    TriAlg triAlg; 
    UINT32 uNewClaID = fol.uOrigClaSize + 1;//新产生的归结式R子句编号
     triAlg.singleClaNum = fol.uOrigClaSize;
     triAlg.flagT = true;
    string str="";
//    str+=fol.ToSingleString();
//    FileOp::PrintINFORSinglePre(str);//输出原始单元子句到.rspre
    BACKTYPE backType = NOBACK;
    //记录预处理生成的子句
    vector<Clause*> preGenCla;
    preGenCla.reserve(6);
    //记录生成的单文字子句
    vector<Clause*> chgCla;
    chgCla.reserve(6);
    triAlg.start = clock();
    Clause* givenClaP = nullptr;
    //UINT8 rundCount = 0;//记录连续出现冗余的次数
    //20170815 考虑加入预处理 1. 纯文字的子句过滤 2. 目标子句  3. 提取目标子句可以归结的子句集
    //以下预处理与合一有关
    vector<Literal*> unifyLit;//记录与目标子句合一相关的文字
    unifyLit.reserve(16);
    set<UINT32> saveClaId;//保存的留下来的子句ID
    //0. 锁子句与不对称文字进行子句约简
   //0. 锁子句与不对称文字进行子句约简
    if(StrategyParam::lockType != 0){
        set<Clause*>::iterator claP_it = fol.setCla.begin();
        string lockOutTotal;
        for (; claP_it != fol.setCla.end();) {
            
            if (((double) (clock() - StrategyParam::start) / (double) CLOCKS_PER_SEC) > 40) {
                break;
            }
            bool pureLit = lockResSimlifyNew(fol, triAlg, *claP_it, uNewClaID);
            string lockOut;
            if((lockClaVec.size())>0 &&(fol.setOriClas.size() >1)){
                if(pureLit)
                    lockOut = "纯文字;";
                else {
                    if (StrategyParam::lockType == 1)
                        lockOut = "锁子句处理;";
                    else if (StrategyParam::lockType == 2)
                        lockOut = "锁+包含处理;";
                    else if (StrategyParam::lockType == 3)
                        lockOut = "锁+包含2处理;";
                    else if (StrategyParam::lockType == 4)
                        lockOut = "锁+不对称文字+恒真子句处理;";
                    else if (StrategyParam::lockType == 5)
                        lockOut = "锁+不对称文字+包含子句处理;";
                }
                lockOut = lockOut + "子句编号为:";
                for (int m = 0; m < lockClaVec.size(); ++m) {
                    lockOut = lockOut + to_string(lockClaVec[m]->uClaId) + "\n";
                    //删除子句
                    //先删除原始子句集
                    set<Clause*> ::iterator delIt = fol.setOriClas.find(lockClaVec[m]);
                    if (delIt != fol.setOriClas.end()) {
                        fol.setOriClas.erase(delIt);
                    }

                    (lockClaVec[m])->DelLits();
                    delete(lockClaVec[m]);
                    claP_it = fol.setCla.erase(claP_it);
                    
                    string out = "#子句编号[" + to_string(lockClaVec[m]->uClaId) + "]为锁子句被删除";
                    FileOp::LogOut(out);
                }
                lockClaVec.clear();
                lockOutTotal += lockOut;
            }
            else
                ++claP_it;
            //cout<<"锁子句个数:"<<lockClaVec.size()<<endl;
            
        }
        *FileOp::ofJudgeAllFileResult << FileOp::JudgeFileName << lockOutTotal << endl;
    }
    //1. 过滤带纯文字的子句
    if (StrategyParam::delPureCla) {
        set<Clause*>::iterator claP_it = fol.setCla.begin();
        for (; claP_it != fol.setCla.end();) {
            if (triAlg.claHasPureLit(fol, (*claP_it))) {
                //先删除原始子句集
                set<Clause*> ::iterator delIt = fol.setOriClas.find(*claP_it);
                if (delIt != fol.setOriClas.end()) {
                    fol.setOriClas.erase(delIt);
                }
                string out = "#子句编号[" + to_string((*claP_it)->uClaId) + "]含纯文字被删除";
                FileOp::LogOut(out);
                (*claP_it)->DelLits();
                delete((*claP_it));
                claP_it = fol.setCla.erase(claP_it);
            } 
            else{
                if((*claP_it)->isGoal){
                    //时目标子句,则存入unifyLit中
                    for(int i=0;i<(*claP_it)->uLitNum;++i){
                        unifyLit.push_back((*claP_it)->LitPtr[i]);
                    }
                    saveClaId.insert((*claP_it)->uClaId);
                    fol.saveGoalClaSet.insert(*claP_it);
                    //20170926 加入到列表中
                    if ((*claP_it)->uLitNum > 1) {
//                        if (fol.noPairSingleCla.find(*claP_it) == fol.noPairSingleCla.end()) {
//                            fol.noPairSingleCla.insert(*claP_it);
//                        }
                        insertNoPairCla(fol, *claP_it);
                    }             
                }
                ++claP_it;
            }
        }
        set<Clause*>::iterator claPE_it = fol.setEnq.begin();
        for (; claPE_it != fol.setEnq.end();) {
            if (triAlg.claHasPureLit(fol, (*claPE_it))) {
                //先删除原始子句集
                set<Clause*> ::iterator delIt = fol.setOriClas.find(*claPE_it);
                if (delIt != fol.setOriClas.end()) {
                    fol.setOriClas.erase(delIt);
                }
                
                string out = "#子句编号[" + to_string((*claPE_it)->uClaId) + "]含纯文字被删除";
                FileOp::LogOut(out);
                (*claPE_it)->DelLits();
                delete((*claPE_it));
                claPE_it = fol.setEnq.erase(claPE_it);
            } 
            else
                ++claPE_it;
        }
    }
    else{//不做纯文字规则,则得到目标子句
        set<Clause*>::iterator claP_it = fol.setCla.begin();
        for (; claP_it != fol.setCla.end();) {
            if ((*claP_it)->isGoal) {
                //时目标子句,则存入unifyLit中
                for (int i = 0; i < (*claP_it)->uLitNum; ++i) {
                    unifyLit.push_back((*claP_it)->LitPtr[i]);
                }
                saveClaId.insert((*claP_it)->uClaId);
                fol.saveGoalClaSet.insert(*claP_it);
                insertNoPairCla(fol, *claP_it);
            }
            ++claP_it;
        }
    }
    //2. 目标子句过滤子句集 考虑加上距离的概念
    if(StrategyParam::goalCla && (unifyLit.size()>0)){
        vector<Literal*>* vCandLit;
        Literal* candLitP = nullptr;
        Clause* candClaP = nullptr;
        vector<Term*> chgVarTemp;
        chgVarTemp.reserve(6);
        int length = unifyLit.size();
        bool flag = true;
        int resLen = 0;
        int reslength = 0;
        for(int i=0;i<unifyLit.size();++i){
//         
            unifyLit[i]->goalDeepth = reslength;
            if(unifyLit[i]->claPtr->goaldeepth > reslength){
                unifyLit[i]->claPtr->goaldeepth = reslength;
            }
            if(flag){
                flag = false;
                resLen = unifyLit.size();
            }
            if(i == (resLen -1)){//距离为1
                ++reslength;
                resLen = unifyLit.size();
                //当到达归结距离时
                 if(reslength == StrategyParam::goalDeepth){
                     break;
                 }
            }
            if(saveClaId.size() == (fol.setCla.size() + fol.setEnq.size())){
                break;
            }
            vCandLit = unifyLit[i]->getPairPredLst();
            for (UINT32 pasLitInd = 0; pasLitInd < UINT32(vCandLit->size()); ++pasLitInd)//依次找到
            {
                candLitP = vCandLit->at(pasLitInd);
                candClaP = candLitP->claPtr;
                //若互补对的子句已经查找出,则应该跳过
                if (saveClaId.find(candClaP->uClaId) != saveClaId.end())
                    continue;
                if (triAlg.unify.LitMgu(unifyLit[i], candLitP, chgVarTemp)) {
                    triAlg.unify.ClearVarBind(chgVarTemp);
                    //需要将互补对的文字对应的子句所有的文字压入unifyLit中                  
                    for(int m=0;m<candClaP->uLitNum;++m){
                        if(find(unifyLit.begin(),unifyLit.end(),candClaP->LitPtr[m]) ==unifyLit.end()){
                            unifyLit.push_back(candClaP->LitPtr[m]);
                        }
                    }
                    //将对应的互补对子句ID插入到set集合中
                    if (saveClaId.find(candClaP->uClaId) == saveClaId.end())
                        saveClaId.insert(candClaP->uClaId);
                }
                else
                    triAlg.unify.ClearVarBind(chgVarTemp);
            }
            triAlg.unify.ClearVarBind(chgVarTemp);
        }
        //清空unifyLit集合
        triAlg.unify.ClearVarBind(chgVarTemp);
        vector<Term*>().swap(chgVarTemp);
        unifyLit.clear();
        vector<Literal*>().swap(unifyLit);
        set<Clause*>::iterator claP_it = fol.setCla.begin();
        for (; claP_it != fol.setCla.end();) {
            //1.判断是否要过滤,有将该子句删除
            if(saveClaId.find((*claP_it)->uClaId) == saveClaId.end()){
                //先删除原始子句集
                set<Clause*> ::iterator delIt = fol.setOriClas.find(*claP_it);
                if (delIt != fol.setOriClas.end()) {
                    fol.setOriClas.erase(delIt);
                }
                string out = "#子句编号[" + to_string((*claP_it)->uClaId) + "]目标子句约简被删除";
                FileOp::LogOut(out);
                (*claP_it)->DelLits();
                delete((*claP_it));
                claP_it = fol.setCla.erase(claP_it);
            }
            else{
                //20171020 将剩余的子句演绎深度赋值
                (*claP_it)->deduceDeepth = 0;
                //20170919 加入到等词中 如果是单元子句正等词 且左边项和右边项个数不相同并且只含有1个项
//                if(((*claP_it)->isUintEqn()) && ((*claP_it)->LitPtr[0]->subTerm->suitSuper())){
//                    (*claP_it)->demodulator = true;
//                    fol.eqnDemod.insert(*claP_it);//原始子句有适合调解的正等词单元子句
//                }
                ++claP_it;
            }
        }
        set<Clause*>::iterator claPE_it = fol.setEnq.begin();
        for (; claPE_it != fol.setEnq.end();) {
            //1.判断是否要过滤,有将该子句删除
            if (saveClaId.find((*claPE_it)->uClaId) == saveClaId.end()) {
                //先删除原始子句集
                set<Clause*> ::iterator delIt = fol.setOriClas.find(*claPE_it);
                if (delIt != fol.setOriClas.end()) {
                    fol.setOriClas.erase(delIt);
                }

                string out = "#子句编号[" + to_string((*claPE_it)->uClaId) + "]目标子句约简被删除";
                FileOp::LogOut(out);
                (*claPE_it)->DelLits();
                delete((*claPE_it));
                claPE_it = fol.setEnq.erase(claPE_it);
            } else{
                //20171020 将剩余的子句演绎深度赋值
                (*claPE_it)->deduceDeepth = 0;
//                if(((*claPE_it)->isUintEqn()) && ((*claPE_it)->LitPtr[0]->subTerm->suitSuper())){
//                    (*claPE_it)->demodulator = true;
//                    fol.eqnDemod.insert(*claPE_it);//原始子句有适合调解的正等词单元子句
//                }
                ++claPE_it;
            }
        }           
    }
    //cout<<(double)(clock() - triAlg.start)/(double)CLOCKS_PER_SEC<<endl;
    saveClaId.clear();
    
    //只做预处理
    if(StrategyParam::preprocess){
        clock_t endNoPair = clock();
        double time_sNoPair = (double) (endNoPair - StrategyParam::start) / (double) CLOCKS_PER_SEC;
        if (time_sNoPair > StrategyParam::timeLimit *60)//200   3  1分钟 15  5分钟   30  15分钟  end:300
            {
                //20171022 将三角形演绎过程中复制的子句全部删除
                FileOp::outReleaseOf();
                //20170315 输出最后的单元子句 方便程序完善
                string str = "";
                fol.uOrigClaSingleSize = 0;
                str += fol.ToSingleString();
                FileOp::PrintINFOEndRSinglePre(str); //输出所有的单元子句到.erspre
                str = "";
                str += fol.ToUnUseString();
                FileOp::PrintINFONoUsePre(str); //输出所有的未使用子句到.nousepre
                FileOp::LogOut("超出时间" + to_string(StrategyParam::timeLimit) +"分钟限制,无法判定！");
                if (!StrategyParam::orForCompition)
                    cout << "无法判定" << endl;
                else
                    cout << "TMO-Non" << endl;
                return UNKNOWN;
            }
    }
    
//    str="";
//    str+=fol.ToSingleAfterString();//此处添加等词集合
//    FileOp::PrintINFORSinglePreAfter(str);//输出原始单元子句到.rspre
//    
//    string strINFO;
//    strINFO+= fol.ToString(false);
//    FileOp::PrintINFORPreAfter(strINFO);//输出到文件.rspre
    //预处理完成
    //20170812
    //将单文字子句集合放入三角形中
    UINT16 loop = 10;
     bool chooseTri = true;//用于选择三角形的构建类型
     //对函数复杂度、共享变元进行预处理
     //第一次针对原始子句集处理的开关
     bool firstSwitch = true;
     bool readStrategySwitch1 = true;
     bool readStrategySwitch2 = true;
     bool readStrategySwitch3 = true;
     bool readStrategySwitch4 = true;
     UINT32 noPairIt = 0;//用于非单元子句归结时的迭代
     vector<Clause*> saveCurrentClaSet;//记录每次选取的最优子句
     saveCurrentClaSet.reserve(6);
     UINT32 startId = 0;
     UINT32 endId  = uNewClaID - 1;
     bool insertNoUseCla = true;
     //Literal::delIndex();
     //20170819 标志是否没有单元子句,没有单元子句需要进入到非单元子句归结
     //int allNoPairCount = 0;//用于监控allNoPair出现的次数，若选取的单元子句都无法进行有效的三角形构建，则此时需要进入非单元子句进行演绎
    while(1) {
        //开始预处理
//        if(uNewClaID == 259){
//            cout<<"cf-debug"<<endl;
//        }
        endId  = uNewClaID - 1;
        saveCurrentClaSet.clear();
        triAlg.vOnlyOutTri.clear();
        triAlg.vOutTri.clear();
        triAlg.vOnlyOutTriCmp.clear();
        //triAlg.saveCopyCla.clear();
        //20171022 将三角形演绎过程中复制的子句删除,注意:删除的子句是没有使用的
        triAlg.delSaveCopyCla(fol);
        triAlg.BackPathClear();
//        if (fol.setHasBindTerm()) {
//            cout << "未清空替换项0" << endl;
//        }
        //记录单文字子句集合
        fol.setSingleCla.clear();
        //fol.resetNoPairClaSet(difficulty);
        //difficulty = false;
        //20170708 策略的变化
        if(FileOp::strategyMode == 1){
            if (((double) (clock() - StrategyParam::start) / (double) CLOCKS_PER_SEC) < 75) {
                StrategyParam::timeLimit = 5;
            } 
            else if (((double) (clock() - StrategyParam::start) / (double) CLOCKS_PER_SEC) < 130) {
                if(readStrategySwitch1){
                    shift = 0;
                    readStrategySwitch1= false;
                    //FileOp::readStrategyN(1);
                    FileOp::readBatchStrategy(FileOp::StrategyfileName[1]);                  
                    StrategyParam::timeLimit = 5;
                    if(StrategyParam::noUnitRes == false){
                        chooseTri = true;
                    }
                    //需要处理的有:1 清除子句集 2 清除文件 3 子句编号重新
                    if(StrategyParam::strategyMode ==0){
                        fol.DelSubSet(fol.uOrigClaSize);
                        FileOp::delRes();
                        uNewClaID = fol.uOrigClaSize + 1;//新产生的归结式R子句编号
                        StrategyParam::timeLimit = 5;
                        firstSwitch = true;
                        fol.noPairSingleCla.clear();
                        fol.setDeductCla.clear();
                        fol.eqnDemod.clear();
                        fol.DelSubSetSuper(fol.uOrigClaSize);
                        triAlg.noCmpCla.clear();                       
                        triAlg.flagT = true;
                        startId = 0;
                        endId  = uNewClaID - 1;
                    }
                }
                //FileOp::readStrategyN(1);
            } else if (((double) (clock() - StrategyParam::start) / (double) CLOCKS_PER_SEC) < 190) {
                 if(readStrategySwitch2){
                    shift = 0;
                    readStrategySwitch2= false;
                    //FileOp::readStrategyN(2);
                    FileOp::readBatchStrategy(FileOp::StrategyfileName[2]);
                    StrategyParam::timeLimit = 5;
                    if(StrategyParam::noUnitRes == false){
                        chooseTri = true;
                    }
                    //需要处理的有:1 清除子句集 2 清除文件 3 子句编号重新
                    if(StrategyParam::strategyMode ==0){
                        fol.DelSubSet(fol.uOrigClaSize);
                        FileOp::delRes();
                        uNewClaID = fol.uOrigClaSize + 1;//新产生的归结式R子句编号
                        StrategyParam::timeLimit = 5;
                        firstSwitch = true;
                        fol.noPairSingleCla.clear();
                        fol.setDeductCla.clear();
                        fol.eqnDemod.clear();
                        fol.DelSubSetSuper(fol.uOrigClaSize);
                        triAlg.noCmpCla.clear();
                        triAlg.flagT = true;
                        startId = 0;
                        endId  = uNewClaID - 1;
                    }
                }
                //FileOp::readStrategyN(2);
            } else if (((double) (clock() - StrategyParam::start) / (double) CLOCKS_PER_SEC) < 250) {
                 if(readStrategySwitch3){
                    shift = 0;
                    readStrategySwitch3= false;
                    //FileOp::readStrategyN(3);
                    FileOp::readBatchStrategy(FileOp::StrategyfileName[3]);
                    StrategyParam::timeLimit = 5;
                    if(StrategyParam::noUnitRes == false){
                        chooseTri = true;
                    }
                    //需要处理的有:1 清除子句集 2 清除文件 3 子句编号重新
                    if(StrategyParam::strategyMode ==0){
                        fol.DelSubSet(fol.uOrigClaSize);
                        FileOp::delRes();
                        uNewClaID = fol.uOrigClaSize + 1;//新产生的归结式R子句编号
                        StrategyParam::timeLimit = 5;
                        firstSwitch = true;
                        fol.noPairSingleCla.clear();
                        fol.setDeductCla.clear();
                        fol.eqnDemod.clear();
                        fol.DelSubSetSuper(fol.uOrigClaSize);
                        triAlg.noCmpCla.clear();                    
                        triAlg.flagT = true;
                        startId = 0;
                        endId  = uNewClaID - 1;
                    }
                }
                //FileOp::readStrategyN(3);
            } else{
                 if(readStrategySwitch4){
                    shift = 0;
                    readStrategySwitch4= false;
                    //FileOp::readStrategyN(4);
                    FileOp::readBatchStrategy(FileOp::StrategyfileName[4]);
                    StrategyParam::timeLimit = 5;
                    if(StrategyParam::noUnitRes == false){
                        chooseTri = true;
                    }
                    //需要处理的有:1 清除子句集 2 清除文件 3 子句编号重新
                    if(StrategyParam::strategyMode ==0){
                        fol.DelSubSet(fol.uOrigClaSize);
                        FileOp::delRes();
                        uNewClaID = fol.uOrigClaSize + 1;//新产生的归结式R子句编号
                        StrategyParam::timeLimit = 5;
                        firstSwitch = true;
                        fol.noPairSingleCla.clear();
                        fol.setDeductCla.clear();
                        fol.eqnDemod.clear();
                        fol.DelSubSetSuper(fol.uOrigClaSize);
                        triAlg.noCmpCla.clear();
                        triAlg.flagT = true;
                        startId = 0;
                        endId  = uNewClaID - 1;
                    }
                }
                //FileOp::readStrategyN(4);
            }
        }
        //20171029 处理新生成的子句,判断是否是冗余的
        if(1){
            set<Clause*>::iterator claP_it = fol.setCla.begin();
            for (; claP_it != fol.setCla.end();) {
                //20171029 判断新生成的子句是否是调解恒真和纯文字子句
                if ((*claP_it)->uClaId >= startId && (*claP_it)->uClaId <= endId) {
                    if (triAlg.claHasPureLit(fol, (*claP_it)) || triAlg.judgeDemodRedundent(fol, (*claP_it), uNewClaID)) {
                        set<Clause*> ::iterator delIt = fol.setOriClas.find(*claP_it);
                        if (delIt != fol.setOriClas.end()) {
                            fol.setOriClas.erase(delIt);
                        }
                        set<Clause*> ::iterator delItNoPair = fol.noPairSingleCla.find(*claP_it);
                        if (delItNoPair != fol.noPairSingleCla.end()) {
                            fol.noPairSingleCla.erase(delItNoPair);
                        }
                        set<Clause*> ::iterator delItEqnDemod = fol.eqnDemod.find(*claP_it);
                        if (delItEqnDemod != fol.eqnDemod.end()) {
                            fol.eqnDemod.erase(delItEqnDemod);
                        }
                        set<Clause*> ::iterator delItGoal = fol.saveGoalClaSet.find(*claP_it);
                        if (delItGoal != fol.saveGoalClaSet.end()) {
                            fol.saveGoalClaSet.erase(delItGoal);
                        }
                        string out = "#子句编号[" + to_string((*claP_it)->uClaId) + "]冗余被删除";
                        FileOp::LogOut(out);
                        (*claP_it)->DelLits();
                        delete((*claP_it));
                        claP_it = fol.setCla.erase(claP_it);
                        continue;
                    }
                }
                ++claP_it;
            }  
        }
        //20170917  每次都初始化演绎子句集合,通过FIFO,项的计数,目标距离来选择集合,该集合不断的叠加
        //操作步骤 1.得到current集合 2.清空setCla集合(passive set) 3.加入到setDeductCla结合(activity set)
        preGenCla.clear();
        if(StrategyParam::useSaturate){
            RESULT res = fol.chooseCurrentCLaSet(&saveCurrentClaSet, 6,triAlg,startId,endId,uNewClaID);
            startId = endId;
            if(res == UNSAT)
                return UNSAT;
            set<Clause*>::iterator claP_it = fol.setCla.begin();
            for (; claP_it != fol.setCla.end();) {
                //20170920 判断是否有互补对的单元子句
                //1.判断是否要过滤,有将该子句删除
                if (find(saveCurrentClaSet.begin(), saveCurrentClaSet.end(), (*claP_it)) != saveCurrentClaSet.end()) {
                    string out = "#子句编号[" + to_string((*claP_it)->uClaId) + "]加入到演绎集合中";
                    FileOp::LogOut(out);
//                    (*claP_it)->DelLits();
//                    delete((*claP_it));
                    claP_it = fol.setCla.erase(claP_it);
                } else {
                    ++claP_it;
                }
            }
            set<Clause*>::iterator claPE_it = fol.setEnq.begin();
            for (; claPE_it != fol.setEnq.end();) {
                //1.判断是否要过滤,有将该子句删除
                if (find(saveCurrentClaSet.begin(), saveCurrentClaSet.end(), (*claPE_it)) != saveCurrentClaSet.end()) {
                    //先删除原始子句集
                    string out = "#子句编号[" + to_string((*claPE_it)->uClaId) + "]加入到演绎集合中";
                    FileOp::LogOut(out);
//                    (*claPE_it)->DelLits();
//                    delete((*claPE_it));
                    claPE_it = fol.setEnq.erase(claPE_it);
                } else {
                    ++claPE_it;
                }
            }
            for(UINT32 i=0; i<saveCurrentClaSet.size(); ++i){
                //fol.InsertCla(saveCurrentClaSet[i]);
                //在加入activity集合中需要做调解
                //1.先做调解 2.再加入集合中,若冗余则不加入
                if (StrategyParam::termRewriting == 2) {
                    fol.judgeInsertSuper(saveCurrentClaSet[i]);
                    fol.setDeductCla.insert(saveCurrentClaSet[i]);
                } else {
                    fol.judgeInsertSuper(saveCurrentClaSet[i]);
                    if (fol.eqnDemod.find(saveCurrentClaSet[i]) != fol.eqnDemod.end()) {//注意不能自己和自己调解
                        continue;
                    }
                    int res = demodulatorClaSaturate(fol, triAlg, saveCurrentClaSet[i], uNewClaID, &preGenCla);
                    if ((res == 1) || (res == 2)) {
                        swap(saveCurrentClaSet[i], saveCurrentClaSet[saveCurrentClaSet.size() - 1]);
                        saveCurrentClaSet.pop_back();
                        --i;
                    } else{
                        fol.setDeductCla.insert(saveCurrentClaSet[i]);
                    }
                }
            }
        }
        //startId = endId;
        //处理预处理新生成的子句,向后约简
        if (preGenCla.size() > 0) {
            for (int i = 0; i < preGenCla.size(); ++i) {
                fol.BackwardSubsumpSuper(*preGenCla[i],saveCurrentClaSet); //向后冗余
            }
        }
        // 
        //20170908进行预处理
        //1.因子归结 生成新子句
        preGenCla.clear();
        if(StrategyParam::factorRes) {
            for (UINT32 i = 0; i < saveCurrentClaSet.size(); ++i) {
                bool delFlag = true;
                factorRes(fol, triAlg, saveCurrentClaSet[i], uNewClaID, &preGenCla, delFlag, false);
                if (delFlag) {//因子归结:两个合一文字1个为常元,一个不含共享变元
                    
                    set<Clause*> ::iterator delItDeduct = fol.setDeductCla.find(saveCurrentClaSet[i]);
                    if (delItDeduct != fol.setDeductCla.end()) {
                        fol.setDeductCla.erase(delItDeduct);
                    }
                    set<Clause*> ::iterator delItNoPair = fol.noPairSingleCla.find(saveCurrentClaSet[i]);
                    if (delItNoPair != fol.noPairSingleCla.end()) {
                        fol.noPairSingleCla.erase(delItNoPair);
                    }
                    set<Clause*> ::iterator delItEqnDemod = fol.eqnDemod.find(saveCurrentClaSet[i]);
                    if (delItEqnDemod != fol.eqnDemod.end()) {
                        fol.eqnDemod.erase(delItEqnDemod);
                    }
                    set<Clause*> ::iterator delItGoal = fol.saveGoalClaSet.find(saveCurrentClaSet[i]);
                    if (delItGoal != fol.saveGoalClaSet.end()) {
                        fol.saveGoalClaSet.erase(delItGoal);
                    }
                    string out = "#子句编号[" + to_string((saveCurrentClaSet[i])->uClaId) + "]被因子归结删除";
                    FileOp::LogOut(out);
                    saveCurrentClaSet[i]->DelLits();
                    delete(saveCurrentClaSet[i]);
                    swap(saveCurrentClaSet[i], saveCurrentClaSet[saveCurrentClaSet.size() - 1]);
                    saveCurrentClaSet.pop_back();
                    --i;
                }
            }
        }
        
        //处理预处理新生成的子句,向后约简
        if (preGenCla.size() > 0) {
            for (int i = 0; i < preGenCla.size(); ++i) {
                fol.BackwardSubsumpSuper(*preGenCla[i],saveCurrentClaSet); //向后冗余
            }
        }
        //清空新生成的子句指针集合
        preGenCla.clear();
        //2.等词归结
        if (StrategyParam::eqnRes) {
            for (UINT32 i = 0; i < saveCurrentClaSet.size(); ++i) {
                if (saveCurrentClaSet[i]->hasPLit()) {
                    negEqnRes(fol, triAlg, saveCurrentClaSet[i], uNewClaID, &preGenCla, false);
                }
                else 
                    continue;
            }
        }
    //处理预处理新生成的子句,向后约简
       if (preGenCla.size() > 0) {
            for (int i = 0; i < preGenCla.size(); ++i) {
                fol.BackwardSubsumpSuper(*preGenCla[i],saveCurrentClaSet); //向后冗余
            }
        }
        //清空新生成的子句指针集合
        preGenCla.clear();       
        if (firstSwitch){
            fol.resetSingleClaNumSaturate();
        }
        //将演绎集合中的单元子句加入集合中
        InsertSingleSetSaturate(fol,triAlg);//maxUnitId变大,则表示生成了新单元子句
        if ((fol.setOriClas.size() < 2) && (fol.setCla.size() < 2) && (fol.setDeductCla.size() < 2)) {
            //简单判断可满足	
            FileOp::LogOut("得出结论:可满足！");
            cout<< "得出结论:可满足"<<endl;
            return SAT;
        }
        if(fol.setSingleCla.size() == 0){
            StrategyParam::noUnitRes = true;
        }
        if (fol.setSingleCla.size() > 0) {
            //先放单文字子句到三角形
            if(!StrategyParam::deductMode)
                InsertOutTri(triAlg, fol, loop, chooseTri); //添加单元子句到对角线
            else{
                InsertOutTriLR(triAlg, fol, loop, chooseTri); //添加单元子句到对角线
            }
            //已第一个单文字子句起步
            givenClaP = triAlg.vOnlyOutTri[0]->claPtr;
            //        string str;
            //        givenClaP->toString(str);
            //        cout << "起步子句:" << str << endl;
            StartId = triAlg.vOnlyOutTri[0]->claPtr->uClaId;
            triAlg.startCluId = StartId;
            //FileOp::CreateRunInfoFile(triAlg.vOnlyOutTri[0]->claPtr->uClaId);
            //判断对角线元素是否存在互补合一子句
            vector<Term*> chgVarT;
            chgVarT.reserve(6);
            UINT32 lens = triAlg.vOnlyOutTri.size();
            
            //cout<<lens<<endl;
            //判断是否有互补对的单元子句
            for (UINT32 i = 0; i < saveCurrentClaSet.size(); ++i) {
                if(saveCurrentClaSet[i]->uLitNum > 1)
                    continue;
                Literal* lit = saveCurrentClaSet[i]->LitPtr[0];
                for (UINT32 j = 0; j < lens; j++) {
                    if(lit == triAlg.vOnlyOutTri[j])
                        continue;
                    if (lit->isPairPred(triAlg.vOnlyOutTri[j]) && triAlg.unify.LitMgu(lit, triAlg.vOnlyOutTri[j], chgVarT)) {
                        //triAlg.unify.vVarBindT.insert(triAlg.unify.vVarBindT.end(),chgVarT.begin(),chgVarT.end());
                        //单文字子句集合中存在互补对，需要将结果写入后台
                        string str;
                        //*FileOp::ofRealInfoOut << "互补对单文字子句" << endl;   
                        //*FileOp::ofRealInfoOut <<"[C" + to_string(triAlg.vOnlyOutTri[i]->Row()) + "]" << triAlg.vOnlyOutTri[i]->subTerm->ToString()<<endl;
                        FileOp::CreateRunInfoFile(FileOp::runFileId);
                        *FileOp::ofRealInfoOut << "从编号为" + to_string(saveCurrentClaSet[i]->uClaId) + "子句开始构建三角形" << endl;
                        triAlg.unify.WriteTriPath(lit);
                        //sleep(1);
                        //"[C" + to_string(lit->Row()) + "_" + to_string(lit->Col()) + "]"
                        //*FileOp::ofRealInfoOut <<"[C" + to_string(triAlg.vOnlyOutTri[j]->Row()) + "]" << triAlg.vOnlyOutTri[j]->subTerm->ToString()<<endl;     
                        triAlg.unify.WriteTriPath(triAlg.vOnlyOutTri[j]);
                        //sleep(1);
                        *FileOp::ofRealInfoOut << "R:空子句" << endl;
                        FileOp::LogOut("# ==子句" + to_string(saveCurrentClaSet[i]->uClaId) + "起步，结论正确(UNSAT)！");
                        if(!StrategyParam::orForCompition && (StrategyParam::problemDiv == 0))
                            cout << "得出结论:不可满足" << endl;
                        triAlg.unify.ClearVarBind(chgVarT);
                        return UNSAT;
                    }
                    triAlg.unify.ClearVarBind(chgVarT);
                }
            }
            triAlg.unify.ClearVarBind(chgVarT);
            
            //20170213 此处增加通过扩展三角形能够得出结论的情况，并可以对原始子句进行约减
            chgVarT.clear();
            //初始化非单元子句列表
            //20170528 逆向做法只左1次，只针对原始子句，初始化原始fol.noPairSingleCla，相对于watchlist
            for (UINT32 ind = 0; ind< saveCurrentClaSet.size(); ++ind)//逆向做法
            {
                Clause* aClap = saveCurrentClaSet[ind];
                if ((aClap->uLitNum == 1)) {
                    continue;
                }
                vector<Term*> varBindT; //变元绑定列表
                varBindT.reserve(6);
                UINT16 pairCount = 0; //用于统计可以找到单元子句互补的文字个数20170213
                vector<Literal*> isOutPut; //存放得出结论时的输出路径
                isOutPut.reserve(6);
                if (StrategyParam::noUnitRes) {
                    for (UINT16 ActLitInd = 0; ActLitInd < aClap->uLitNum; ++ActLitInd) {
                        Literal* QLit = aClap->LitPtr[ActLitInd];
                        for (UINT32 i = 0; i < lens; ++i) {
                            //20170215 需要好好思考判断，单元子句组合问题
                            if (QLit->isPairPred(triAlg.vOnlyOutTri[i]) && triAlg.unify.LitMgu(QLit, triAlg.vOnlyOutTri[i], chgVarT)) {
                                aClap->clast = PiredSingle; //存在单元子句
                                varBindT.insert(varBindT.end(), chgVarT.begin(), chgVarT.end());
                                chgVarT.clear();
                                pairCount++;
                                isOutPut.push_back(triAlg.vOnlyOutTri[i]); //保存演绎路径
                                break;
                            } else
                                triAlg.unify.ClearVarBind(chgVarT);
                        }
                    }
                    if (pairCount == aClap->uLitNum)//得出结论
                    {
                        FileOp::CreateRunInfoFile(FileOp::runFileId);
                        *FileOp::ofRealInfoOut << "从编号为" + to_string(aClap->uClaId) + "子句开始构建三角形" << endl;
                        for (UINT16 ActLitInd = 0; ActLitInd < aClap->uLitNum; ++ActLitInd) {
                            isOutPut.push_back(aClap->LitPtr[ActLitInd]);
                        }
                        for (UINT32 k = 0; k < isOutPut.size(); k++) {
                            triAlg.unify.WriteTriPath(isOutPut[k]);
                        }
                        *FileOp::ofRealInfoOut << "R:空子句" << endl;
                        FileOp::LogOut("# ==子句" + to_string(aClap->uClaId) + "起步，结论正确(UNSAT)！");
                        if(!StrategyParam::orForCompition && (StrategyParam::problemDiv == 0))
                            cout<<"得出结论:不可满足" << endl;
                        return UNSAT;
                    } else if (pairCount == 0) {
                        aClap->clast = noPiredSingle; //此时子句没有互补对的单元子句 noPairSingleCla暂时没有
                        if (fol.noPairSingleCla.find(aClap) == fol.noPairSingleCla.end()) {
                            fol.noPairSingleCla.insert(aClap);
                        }
                    }
                    triAlg.unify.ClearVarBind(varBindT);
                    triAlg.unify.ClearVarBind(chgVarT);
                }
                vector<Term*>().swap(varBindT); //modify 20170705
                vector<Literal*>().swap(isOutPut); //modify 20170705
            }
            triAlg.unify.ClearVarBind(chgVarT);
            chgVarT.clear();
            //统计单元子句在setCla中的个数
            int singleInClaSet = 0;
            //记录可以冗余约简的子句
            vector<Clause*> simplfyCla; //保存约简的归结式R  
            simplfyCla.reserve(6);
            vector<Clause*> simplfyClaDel; //保存将简化的子句
            simplfyClaDel.reserve(6);
            triAlg.unify.ClearVarBind(chgVarT);
            //下面判断是否可以约简
            //simplyIdEnd= uNewClaID -1;
            //if(StrategyParam::noUnitSimplify &&((double) (clock() - triAlg.start) / (double) CLOCKS_PER_SEC)>=30 &&(int)((double) (clock() - triAlg.start) / (double) CLOCKS_PER_SEC)%30) {//20170529 改成不等于零等做出例子
            if (StrategyParam::noUnitSimplify && (triTotalTimes %16 == 0)) {// &&(((int)((double) (clock() - triAlg.start) / (double) CLOCKS_PER_SEC)%10 == 0) || firstSwitch)) {//modify 20170705 
                for (UINT32 ind = 0; ind < saveCurrentClaSet.size(); ++ind)//逆向做法
                {
                    Clause* aClap = saveCurrentClaSet[ind];
                    if ((aClap->uLitNum == 1))
                        continue;
                    vector<Term*> varBindT; //变元绑定列表
                    varBindT.reserve(6);
                    UINT8 pairCount = 0; //用于统计可以找到单元子句互补的文字个数20170213
                    vector<Literal*> isOutPut; //存放得出结论时的输出路径
                    isOutPut.reserve(6);
                    //标记子句是否含有不带共享变元的文字
                    bool noShareVar = false;
                    isOutPut.clear();
                    chgVarT.clear();
                    //对子句进行约减，判断是否存在非共享变元项文字可以互补对
                    if (aClap->hasConLit()) {
                        bool simplyOut = false;
                        vector<Literal*> vSimplyNewR;
                        vSimplyNewR.reserve(6);
                        for (UINT16 ActLitInd = 0; ActLitInd < aClap->uLitNum; ++ActLitInd) {
                            Literal* QLit = aClap->LitPtr[ActLitInd];
                            QLit->isDel = 0;
                            if (QLit->subTerm->IsShareVarLit())
                                continue;
                            else {
                                for (UINT32 i = 0; i < lens; ++i) {
                                    if (QLit->isPairPred(triAlg.vOnlyOutTri[i]) && triAlg.unify.LitMgu(QLit, triAlg.vOnlyOutTri[i], chgVarT)) {
                                        QLit->isDel = 1;
                                        varBindT.insert(varBindT.end(), chgVarT.begin(), chgVarT.end());
                                        chgVarT.clear();
                                        isOutPut.push_back(triAlg.vOnlyOutTri[i]);
                                        simplyOut = true;
                                        break;
                                    } else
                                        triAlg.unify.ClearVarBind(chgVarT);
                                }
                            }
                        }
                        if (simplyOut) {
//                            if (StrategyParam::orForCompition) {
//                                string rStr = "";
//                                triAlg.newCla->toString(rStr);
//                                string outClauses = "";
//                                for (UINT8 k = 0; k < isOutPut.size(); ++k) {
//                                    outClauses += to_string(isOutPut[k]-> claPtr->uClaId) + ",";
//                                    validPathOut[uNewClaID].push_back(isOutPut[k]-> claPtr->uClaId);
//                                }
//                                outClauses += to_string(aClap->uClaId);
//                                validPathOut[uNewClaID].push_back(aClap->uClaId);
//                                //string out = "cnf(" + to_string(uNewClaID) + ",plain,\n" + "   scs_inference(" + outClauses + ")).";
//                                string out = "cnf(" + rStr + ",plain,\n" + "   scs_inference(" + outClauses + ")).";
//                                *FileOp::ofOutput << out << endl;
//                            }
                            //找到可以约减的R保存归结式，得到新子句，定向向后约减
                            for (UINT16 ActLitInd = 0; ActLitInd < aClap->uLitNum; ++ActLitInd) {
                                Literal* QLit = aClap->LitPtr[ActLitInd];
                                isOutPut.push_back(QLit);
                                if (!QLit->isDel)
                                    vSimplyNewR.push_back(QLit);
                            }
                            //输出演绎路径 检查这个的R生成情况，是否有漏文字的情况
                            FileOp::CreateRunInfoFile(FileOp::runFileId);
                            *FileOp::ofRealInfoOut << "从编号为" + to_string(aClap->uClaId) + "子句开始构建三角形" << endl;
                            for (UINT32 k = 0; k < isOutPut.size(); k++) {
                                triAlg.unify.WriteTriPath(isOutPut[k]);
                            }
                            //生成归结式
                            triAlg.newCla = nullptr;
                            triAlg.newCla = new Clause(uNewClaID, 0);
                            triAlg.newCla->isAxtom = true;
                            size_t uRsize = vSimplyNewR.size();
                            //文字排序
                            if (uRsize > 1)
                                stable_sort(vSimplyNewR.begin(), vSimplyNewR.end(), SortRule::LitCmp);
                            triAlg.newCla->LitPtr = new Literal*[uRsize];
                            for (UINT16 i = 0; i < vSimplyNewR.size(); ++i) {
                                Term* litSubT = triAlg.unify.GetNewTerm(vSimplyNewR[i]->subTerm, triAlg.newCla); //参数1：文字谓词项，参数2：新子句指针
                                if (TNegEqn == GetCodeProp(litSubT->iTermCode)
                                        && litSubT->subTermPtr[0] == litSubT->subTermPtr[1]) {
                                    /*
                                    delete(litSubT);*/--uRsize;
                                    //delete(newCla->LitPtr[]);
                                    continue;
                                }
                                if (triAlg.newCla->uFuncDepth < litSubT->uLevel)
                                    triAlg.newCla->uFuncDepth = litSubT->uLevel;
                                triAlg.newCla->uVarCount += litSubT->uVarCount;
                                //添加到文字		
                                triAlg.newCla->LitPtr[triAlg.newCla->uLitNum] = new Literal(litSubT, EncodeLitCode(uNewClaID, triAlg.newCla->uLitNum + 1), triAlg.newCla, nullptr);
                                triAlg.newCla->LitPtr[triAlg.newCla->uLitNum]->parentLitPtr = vSimplyNewR[i]; //母式文字，有R产生
                                //triAlg.newCla->LitPtr[triAlg.newCla->uLitNum]->goalDeepth = vSimplyNewR[i]->goalDeepth;
                                //20171020 计算演绎深度
                                if (triAlg.newCla ->deduceDeepth < (vSimplyNewR[i]->claPtr->deduceDeepth + 1)) {
                                    triAlg.newCla ->deduceDeepth = vSimplyNewR[i]->claPtr->deduceDeepth + 1;
                                }
                                if (vSimplyNewR[i]->claPtr->isAxtom && triAlg.newCla->isAxtom)
                                    triAlg.newCla->isAxtom = true;
                                else
                                    triAlg.newCla->isAxtom = false;
                                 if (triAlg.hasUnifGoalLit(fol, triAlg.newCla->LitPtr[triAlg.newCla->uLitNum])) {
                                    triAlg.newCla->LitPtr[triAlg.newCla->uLitNum]->goalDeepth = 1;
                                    if (triAlg.newCla->goaldeepth > 1)
                                        triAlg.newCla->goaldeepth = 1;
                                } else {
                                    triAlg.newCla->LitPtr[triAlg.newCla->uLitNum]->goalDeepth = vSimplyNewR[i]->goalDeepth;
                                    if (triAlg.newCla->goaldeepth > vSimplyNewR[i]->goalDeepth)
                                        triAlg.newCla->goaldeepth = vSimplyNewR[i]->goalDeepth;
                                }
                                //cout<<to_string(newCla->uClaId)  + "]" <<"[" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitRow()) + "_" + to_string(newCla->LitPtr[newCla->uLitNum]->ParentLitCol()) + "]" << newCla->LitPtr[newCla->uLitNum]->subTerm->ToString()<<endl;  
                                ++(triAlg.newCla->uLitNum);
                            }
                            if (uRsize != 0) {
                                fol.initGenerateClaAttr(triAlg.newCla);
                                uNewClaID++;
                                Clause* newCla = triAlg.newCla;
                                //20171020 对子句的含等词的文字进行项序处理
                                if (StrategyParam::termRewriting != 2) {
                                    newCla->directEqn();
                                }
                                FileOp::WriteR(newCla);
                                if (StrategyParam::orForCompition) {
                                    newCla->addRForCompetiton();

                                    string rStr = "";
                                    newCla->toString(rStr);
                                    string outClauses = "";
                                    for (UINT8 k = 0; k < isOutPut.size(); ++k) {
                                        //outClauses += to_string(isOutPut[k]-> claPtr->uClaId) + ",";
                                        if(find(validPathOut[uNewClaID-1].begin(),validPathOut[uNewClaID-1].end(),isOutPut[k]-> claPtr->uClaId) == validPathOut[uNewClaID-1].end()){
                                            validPathOut[uNewClaID-1].push_back(isOutPut[k]-> claPtr->uClaId);
                                            outClauses += to_string(isOutPut[k]-> claPtr->uClaId) + ",";
                                        }
                                    }
                                    //outClauses += to_string(aClap->uClaId);
                                    if(find(validPathOut[uNewClaID-1].begin(),validPathOut[uNewClaID-1].end(),aClap->uClaId) == validPathOut[uNewClaID-1].end()){
                                        validPathOut[uNewClaID-1].push_back(aClap->uClaId);
                                        outClauses += to_string(aClap->uClaId);
                                    }
                                    if(outClauses[outClauses.size() -1] == ','){
                                        outClauses.erase(outClauses.size() -1, 1);
                                    }
                                    //string out = "cnf(" + to_string(uNewClaID) + ",plain,\n" + "   scs_inference(" + outClauses + ")).";
                                    int begPos = rStr.find_first_of("[") + 1;
                                    int endPos = rStr.find_first_of("]");
                                    string rId = rStr.substr(begPos, endPos - begPos);
                                    string rContext = rStr.substr(rStr.find_first_of("]") + 1);
                                    string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n" + "   inference(scs_inference,[]," + "[" + outClauses +"]"+ ")).";
                                    *FileOp::ofOutput << out << endl;
                                }

                                string vaildInf = "|[Y]";
                                FileOp::RInvaildInfoOut(vaildInf, StartId);
                                ++triTotalTimes; //20170808 此处也应该为构建三角形
                                simplfyCla.push_back(newCla); //归结式入栈
                                simplfyClaDel.push_back(aClap); //约简的子句入栈
                                if (newCla->uLitNum == 1)
                                    if (StrategyParam::R_Weight == -1)
                                        newCla->adeductNum = 0; //权重设置
                                    else
                                        newCla->adeductNum = StrategyParam::R_Weight;
                                else
                                    if (StrategyParam::R_Weight == -1)
                                    newCla->pdeductNum = 0; //20170217 end//权重设置
                                else
                                    newCla->pdeductNum = StrategyParam::R_Weight; //20170217 end//权重设置
                            }
                            else {
                                triAlg.newCla->DelLits(false);
                                delete(triAlg.newCla);
                            }
                        }
                        vSimplyNewR.clear();
                        vector<Literal*>().swap(vSimplyNewR);
                    }
                    triAlg.unify.ClearVarBind(varBindT);
                    vector<Term*>().swap(varBindT);
                    isOutPut.clear();
                    vector<Literal*>().swap(isOutPut);
                    triAlg.unify.ClearVarBind(chgVarT);
                    chgVarT.clear();
                }
                //            if(triTotalTimes == 156){
                //                cout<<"cf_debug"<<endl;
                //            }
                //对约简的simplfyCla中子句进行约简处理
                if (!simplfyCla.empty()) {
                    for (int m = 0; m < simplfyCla.size(); ++m) {
                        //20170531 将此处改成定向冗余
                        fol.BackwardSubsumpDirectSaturate(*(simplfyCla[m]), *(simplfyClaDel[m]),saveCurrentClaSet); //向后冗余
                        fol.InsertCla(simplfyCla[m]);
                        fol.setCla.insert(simplfyCla[m]);
                        if (StrategyParam::termRewriting != 2)
                            fol.judgeInsertSuper(simplfyCla[m]);
                    }
                    simplfyCla.clear();
                    vector<Clause*>().swap(simplfyCla);
                    simplfyClaDel.clear();
                    vector<Clause*>().swap(simplfyClaDel);
                }
            }
            //simplyIdStart= uNewClaID -1;
            triAlg.unify.ClearVarBind(chgVarT);
            //清空chgVarT
            chgVarT.clear();
            vector<Term*>().swap(chgVarT);
        }
        else{
            chooseTri = false;
            givenClaP = nullptr;
            if(fol.setSingleCla.size() == 0){
                //将没有使用的子句加入到noPairSingleCla
                for (auto& aClap : fol.setDeductCla){
                    if(aClap->uLitNum == 1){
                        continue;
                    }
                    if(!aClap->isUse){
//                        if (fol.noPairSingleCla.find(aClap) == fol.noPairSingleCla.end()) {
//                            fol.noPairSingleCla.insert(aClap);
//                        }
                        insertNoPairCla(fol, aClap);
                    }
                }
            }
        }
        chgCla.clear();    
        triAlg.allNoPair = false;//判断三角形是否能正常构建     
        firstSwitch = false;//第一次处理结束 add:20170705
        UINT8 resolutionRes = 0;
        if(chooseTri)//考虑好流程
        {
            if(!StrategyParam::deductMode){//20170915 从右到左构建三角形
                FileOp::CreateRunInfoFile(FileOp::runFileId);
                resolutionRes = triAlg.GenerateTriByRecodePath(fol,&*givenClaP, uNewClaID, backType,chgCla,loop); //参数1：起步子句；参数2：新子句的编号；参数3：不回退
            }
            else{//20170915 从左到右构建三角形
                
                FileOp::CreateRunInfoFile(FileOp::runFileId);
                //将子句集选取放入候选子句集中
                vector<Clause*> candidateClaSet;
                candidateClaSet.reserve(16);
                for (auto& aClap : fol.setDeductCla){
                    if(aClap->uLitNum != 1){
                        candidateClaSet.push_back(aClap);
                    }
                    if(loop == 0){
                        aClap->pdeductNum = 0;
                    }
                }
                //排序
                if (candidateClaSet.size() > 0) {
                    stable_sort(candidateClaSet.begin(), candidateClaSet.end(), SortRule::PoslitCmpProRL);//PoslitCmpLR
                    resolutionRes = triAlg.GenerateTriByRecodePathLR(fol, candidateClaSet, uNewClaID, backType, chgCla, loop); //参数1：起步子句；参数2：新子句的编号；参数3：不回退
                }
                else{
                    FileOp::delCreateRunInfoFile(FileOp::runFileId);
                    continue;
                }
            }
            ++triTotalTimes;
            if(fol.noPairSingleCla.size()>0 &&StrategyParam::noUnitRes &&(triTotalTimes%triAlgTimes == 0))//20170816 增加比例做三角形的比例  &&(triTotalTimes%6 == 0)
                chooseTri = false;
        }
        else if(StrategyParam::noUnitRes && !chooseTri && (fol.noPairSingleCla.size()>0)){
            //set<Clause*>::iterator setClaIt = fol.setOriClas.begin();
            givenClaP = nullptr;
            vector<Clause*> claNoPairVec;
            claNoPairVec.reserve(8);
            if((fol.noPairSingleCla.size()>0)|| insertNoUseCla) {
                clock_t endPair = clock();
                double time_sPair = (double) (endPair - StrategyParam::start) / (double) CLOCKS_PER_SEC;
                if (insertNoUseCla /*&&(time_sPair > (StrategyParam::timeLimit-1) * 60)*/)//200   3  1分钟 15  5分钟   30  15分钟  end:300
                {
                    for(auto& claP :fol.setDeductCla){
                       // if(!claP->isUse) {
//                            if (fol.noPairSingleCla.find(claP) == fol.noPairSingleCla.end()) {
//                                fol.noPairSingleCla.insert(claP);
//                            }
                            insertNoPairCla(fol, claP);
                        //}
                            //fol.noPairSingleCla.insert(claP);
                    }
                    insertNoUseCla = false;
                }
                //选择主动归结次数最少的子句进行归结
                //20170816 对子句进行排序 按文字数
                for (auto& claP : fol.noPairSingleCla) {
//                    if((claP->isUse && !difficulty) ||(claP->LitPtr == nullptr) ){
//                        set<Clause*> ::iterator delItNoPair = fol.noPairSingleCla.find(claP);
//                        if (delItNoPair != fol.noPairSingleCla.end()) {
//                            fol.noPairSingleCla.erase(delItNoPair);
//                        }
//                        continue;
//                    }
                    //20170711 增加过滤fol.noPairSingleCla中含有单元子句的异常清空
                    if(claP->uLitNum == 1){
                        continue;
                    }
                    claNoPairVec.push_back(claP);
                }
                if((fol.noPairSingleCla.size() == 0) ||(claNoPairVec.size() == 0)){
                    chooseTri = true;
                    continue;
                }
                if(claNoPairVec.size() != 0){
                    stable_sort(claNoPairVec.begin(), claNoPairVec.end(), SortRule::noPairClaCmp);
                }    
                if(claNoPairVec.size()>= noPairInd+1){
                    for(UINT32 m=0; m<=noPairInd;++m){
                        if(claNoPairVec[m]->noPairResFiFg == false){//如果在序号的前面存在新未归结完的子句(肯定文字个数要少)
                            //交换 
                            swap(claNoPairVec[m],claNoPairVec[noPairInd]);
                            break;
                        }
                    }
                }
                
                //noPairInd 非单元子句集合中选择的子句下标,按下标查找
                if (noPairInd >= claNoPairVec.size())
                    noPairInd = 0;
                givenClaP = claNoPairVec[noPairInd];
                UINT32 countSize = 0;
                while(givenClaP->uLitNum >= litSize){//设定一个长度,非单元子句起步子句文字数不能大于16
                    ++noPairInd;
                    if (noPairInd >= claNoPairVec.size())
                        noPairInd = 0;
                     givenClaP = claNoPairVec[noPairInd];
                    ++countSize;
                    if(countSize == claNoPairVec.size())
                        break;
                }
                noPairCla = givenClaP;
//                else{
//                    if(noPairIt >= claNoPairVec.size())
//                        noPairIt = 0;
//                    
//                    
//                    //如果下标0到noPairIt间有新子句产生,则需要从新子句开始
//                    int NewClaInd = -1;
//                    for(int ind = 0; ind < noPairIt; ++ind ){
//                        if(claNoPairVec[ind] == 0){//找到第一个下标
//                            NewClaInd = ind;
//                            break;
//                        }
//                    }
//                    if(NewClaInd == -1){
//                        givenClaP = claNoPairVec[noPairIt];
//                    }
//                    else{//此时需要记录上次的下标断点
//                        noPairInd = noPairIt;
//                        noPairIt = NewClaInd;
//                        givenClaP = claNoPairVec[noPairIt];
//                    }
//                }
            }
//            if (givenClaP->uClaId == 1875) {
//                cout << "cf-debug" << endl;
//            }
//            if (givenClaP->uLitNum >= 200) {
//                cout << "cf-debug" << endl;
//            }
            if (givenClaP) {//找到文字最少的子句
                triAlg.vOutTri.clear();
                FileOp::CreateRunInfoFile(FileOp::runFileId);
//                if (givenClaP->uClaId == 322) {
//                    string str;
//                    givenClaP->toString(str);
//                    cout << "起步子句:" << str << endl;
//                }
//                string str;
//                givenClaP->toString(str);
//                cout << "起步子句:" << str << endl;
                resolutionRes = triAlg.GenerateTriByRecodePathNoUnit(fol, &*givenClaP, uNewClaID, backType, chgCla); //参数1：起步子句；参数2：新子句的编号；参数3：不回退
                ++triTotalTimes;
            }
            else{
                FileOp::delCreateRunInfoFile(FileOp::runFileId);
                continue;
            }
            chooseTri = true;
        }
        else if(fol.noPairSingleCla.size() == 0){
            chooseTri = true;
            continue;
        }
        
        //如果没有满足条件的givenClaP非单元子句，即为空
//        if (!givenClaP)
//            continue;
        //20170214 若所有的主对角线文字都没有找到满足条件互补的子句，则不输出R  注意if条件
        if(triAlg.allNoPair)
        {
            //20170220 增加子句冗余次数权重
            //20170824 所有的单元子句都没有互补对,则需要降低归结式的限制
            if(resolutionRes == 33){//二元归结没有互补对,表示起步子句已经用完
                FileOp::delCreateRunInfoFile(FileOp::runFileId);
//                givenClaP->noUnitDeductTimes += 10;
//                if (givenClaP->noUnitDeductTimes == 1000)
//                    givenClaP->noUnitDeductTimes = 0;
                for (auto& claP : fol.noPairSingleCla) {
                    claP->noUnitDeductTimes = 0;
                }
                givenClaP->noPairResFiFg = true;
                ++noPairInd;
            }
            else if(resolutionRes == 22){//单元子句构建三角形全部冗余 
                FileOp::delCreateRunInfoFile(FileOp::runFileId);
                triAlgTimes = 1;
                if(fol.noPairSingleCla.size() == 0){
                    fol.initNoPairCla();
                }
                //chooseTri = false;
                //difficulty = true;
                StrategyParam::noUnitRes = true;
                if(fol.setDeductCla.size() >= fol.setCla.size()) {
                    
                    ++StrategyParam::R_MAX_FUNCLAYER;
                    //必须设置一个限制
                    if (StrategyParam::R_MAX_FUNCLAYER == (StrategyParam::R_INIT_MAX_FUNCLAYER * 2 + 1)) {
                        StrategyParam::R_MAX_FUNCLAYER = StrategyParam::R_MAX_FUNCLAYER_TMP;
                    }
                    ++StrategyParam::R_MAX_NUM;
                    if (StrategyParam::R_MAX_NUM == StrategyParam::R_INIT_MAX_NUM) {
                        StrategyParam::R_MAX_NUM = StrategyParam::R_MAX_NUM_TMP;
                    }
                    loop = 1;
                }
                
            }
            else if(resolutionRes == 211){
                loop = 0;
            }
            //triAlg.vOnlyOutTri[0]->claPtr->reduntTimes++;//(int)((double) (clock() - start) / (double) CLOCKS_PER_SEC)%30
            //ps -aux | sort -k4nr | head -10
            long leftMem = FileOp::getMem();
            if (leftMem < 200000) {
                FileOp::LogOut("内存超出限制,无法判定！剩余内存:" + to_string(leftMem));
                string fileMemOut = FileOp::g_OutputPath + "/"  + "memleft.log";
                string cmdMem = "ps -aux | sort -k4nr | head -10 >> " + fileMemOut;
                int res = system(const_cast<char*> (cmdMem.c_str()));
                if (!StrategyParam::orForCompition)
                    cout << "无法判定,内存超出限制" << endl;
                else
                    cout << "TMO-Non" << endl;
                //cout << "内存不足,无法判定(请查看电脑运行情况)" << endl;
                return UNKNOWN;
            }
            clock_t endNoPair = clock();
            double time_sNoPair = (double) (endNoPair - StrategyParam::start) / (double) CLOCKS_PER_SEC;
//            if(time_sNoPair > StrategyParam::timeLimit *45){
//                cout<<"cf-debug"<<endl;
//            }
            //时间限制 单位:分钟
            double breakTimeA = 0.0;
            if((FileOp::runMode != 0 )&&(FileOp::runMode != 1)){
                breakTimeA = StrategyParam::timeForceLimit - 10;
            }
            else if((FileOp::runMode == 0 )||(FileOp::runMode == 1)){
                breakTimeA = StrategyParam::timeForceLimit - 10;
            }
            StrategyParam::timeLimit = StrategyParam::firstTimeLimit;
            if (time_sNoPair > StrategyParam::timeLimit *60/*breakTimeAStrategyParam::timeForceLimitStrategyParam::timeLimit *60*/)//200   3  1分钟 15  5分钟   30  15分钟  end:300
            {
                //20171022 将三角形演绎过程中复制的子句全部删除
                triAlg.delSaveCopyCla(fol);
                FileOp::outReleaseOf();
                //20170315 输出最后的单元子句 方便程序完善
                string str = "";
//                fol.uOrigClaSingleSize = 0;
//                str += fol.ToSingleStringSaturate();
//                FileOp::PrintINFOEndRSinglePre(str); //输出所有的单元子句到.erspre
                if (!StrategyParam::orForCompition && (FileOp::runMode != 0)&&(FileOp::runMode != 1)){
                    str = "";
                    fol.uOrigClaSingleSize = 0;
                    str += fol.ToSingleString();
                    FileOp::PrintINFOEndRSinglePre(str); //输出所有的单元子句到.erspre
                }
                
                if(!StrategyParam::orForCompition){
                    str = "";
                    str += fol.ToUnUseString();
                    FileOp::PrintINFONoUsePre(str); //输出所有的未使用子句到.nousepre
                    FileOp::LogOut("超出时间" + to_string(StrategyParam::timeLimit) +"分钟限制,无法判定！");
                }
                
                if ((!StrategyParam::orForCompition) && (FileOp::strategyMode != 3))
                    cout << "无法判定" << endl;
                else
                    cout << "TMO-Non" << endl;
                return UNKNOWN;
            }
            if (StrategyParam::genLitClause && (loop != 0) && (triAlg.total_Loop / loop < 2)) {
                --loop;
            }
            else if (((fol.noPairSingleCla.size()>0) &&StrategyParam::noUnitRes &&!chooseTri )||(chooseTri &&(!StrategyParam::noUnitRes || (fol.noPairSingleCla.size() == 0)) )) { //modify 20170705
//                shift++; //说明起步子句不合适做三角形，跳出迭代选取下一个单元子句构建三角形
//                triAlg.flagT = true;
                loop = 0;
            }
            continue;
        }
        Clause* newCla = triAlg.newCla;
        
        //增加当归结式R与中间归结式相同时的过滤处理
        bool rFilter = false;
        if((chgCla.size() == 0) || (triAlg.vNewR.empty() || triAlg.newCla->uLitNum == 0)){
            rFilter = false;
        }
        else{
            UINT32 midLens = chgCla.size();
            if(chgCla[midLens-1]->uLitNum != newCla->uLitNum){
                rFilter = false;
            }
            else{
                UINT32 countRSize = 0;
                for(UINT32 pos=0; pos < newCla->uLitNum; ++pos){
                    Literal* litR = newCla->LitPtr[pos];
                    Literal* midR = chgCla[midLens-1]->LitPtr[pos];
                    if(litR->isEqPred(midR) && triAlg.unify.CheckEqnR(litR->subTerm,midR->subTerm)){
                        ++countRSize;
                        continue;
                    }
                    else
                        rFilter = false;
                }
                if(countRSize == newCla->uLitNum)
                    rFilter = true;
            }
        }
        if(!rFilter) {
            *FileOp::ofRealInfoOut << "从编号为" + to_string(givenClaP->uClaId) + "子句开始构建三角形" << endl;

            //输出演绎路径	
            if (resolutionRes == 44)
                triAlg.PrintTriTwoPath();
            else{
                //difficulty = false;
                triAlgTimes = 16;
                UINT32 realStartId = triAlg.PrintTriPath();
                //当起步子句不是三角形演绎的第一个子句,需要强行更换起步子句
                if(realStartId != givenClaP->uClaId){
                    loop = 1;
                }
            }
            //此处需要做冗余处理

            //        if(newCla->uClaId == 310){
            //            cout<<"cf-debug"<<endl;
            //        }
            /*判定不可满足*/
            if (triAlg.vNewR.empty() || triAlg.newCla->uLitNum == 0) {
                FileOp::WriteR(nullptr);
                FileOp::LogOut("# ==子句" + to_string(givenClaP->uClaId) + "起步，结论正确(UNSAT)！");
                preGenCla.clear();
                vector<Clause*>().swap(preGenCla);
                if (StrategyParam::orForCompition) {
                    string outClauses = triAlg.PrintCompetitionOut(0);
                    string out = "cnf($" + to_string(uNewClaID) + ",plain,\n" + "   ($false),\n" +"   inference(scs_inference,[]," + "[" + outClauses +"]" + "),\n" + "   ['proof']" + ").";
                   
                    *FileOp::ofOutput << out << endl;
                }
                return UNSAT;
            }
            
            //20171020 对子句的含等词的文字进行项序处理
            if (StrategyParam::termRewriting != 2){
                    newCla->directEqn();
            }
            FileOp::WriteR(newCla);
           
            //20170903 增加清空变元替换项,三角形构建完成应该立刻清空,否则影响前后冗余处理
            triAlg.BackPathClear();
            UINT16 rLen = newCla->uLitNum;
            vector<UINT32>invaildLitId; //
            string rundMsg; //冗余信息
            Subsumption subsump; //(MOSTRIGHT)
            //参数1 被测的子句指针 参数2 整形数组 参数3 字符串 记录冗余信息
            bool isRundacyR = subsump.GenCla(fol, newCla, invaildLitId, rundMsg);
            //        if(newCla->uClaId == 310){
            //            cout<<rundMsg<<endl;
            //        }
            bool RFactorFlag = false;
            FileOp::RInvaildInfoOut(rundMsg, StartId);

            if (isRundacyR) {
                newCla->DelLits(false);
                delete(newCla);
            } else {
                if (StrategyParam::orForCompition) {
                    newCla->addRForCompetiton();
                    
                    string rStr = "";
                    newCla->toString(rStr);
                    string outClauses = triAlg.PrintCompetitionOut(uNewClaID - 1);
                    int begPos = rStr.find_first_of("[") + 1;
                    int endPos = rStr.find_first_of("]");
                    string rId = rStr.substr(begPos, endPos - begPos);
                    string rContext = rStr.substr(rStr.find_first_of("]") + 1);
                    string out = "cnf(" + rId + ",plain,\n" + "   ("+ rContext+"),\n";
                    out += "   inference(csc_inference,[],[" + outClauses +"]" + ")).";
                    *FileOp::ofOutput << out << endl;
                }
                
                bool resFlag = true;
//                if (triAlg.claHasPureLit(fol, newCla)) {
//                    newCla->DelLits(false);
//                    delete(newCla);
//                    resFlag = false;
//                }
                if (resFlag) {
                    //fol.BackwardSubsump(*newCla); //向后冗余
                     fol.BackwardSubsumpClaSet(*newCla,chgCla,false); //向后冗余
                    if (newCla->uLitNum == 1)
                        if (StrategyParam::R_Weight == -1)
                            newCla->adeductNum = 0; //权重设置
                        else
                            newCla->adeductNum = StrategyParam::R_Weight;
                    else
                        if (StrategyParam::R_Weight == -1)
                        newCla->pdeductNum = 0; //20170217 end//权重设置
                    else
                        newCla->pdeductNum = StrategyParam::R_Weight; //20170217 end//权重设置
                    fol.InsertCla(newCla);
                    fol.setCla.insert(newCla);
                    if (StrategyParam::termRewriting != 2)
                        fol.judgeInsertSuper(newCla);
                    //20170903 若是正等词单元子句需要加入等词处理中
                    if (1) {//20170903 没有单元子句互补对,需要添加到集合中
//                        if ((newCla->uLitNum > 1) && (newCla->goaldeepth == 0)) {
//                            if (fol.noPairSingleCla.find(newCla) == fol.noPairSingleCla.end()) {
//                                fol.noPairSingleCla.insert(newCla);
//                            }
//                        }
                        insertNoPairCla(fol, newCla);
                    }
                }
            }
        }//需要过滤
        else {
            newCla->DelLits(false);
            delete(newCla);
            --uNewClaID;
        }
        
        
        //20170213 生成的单文字子句已经判断了冗余，所以这个部分只需判断最后1个单文字子句即可
        //20170816 新增了保存2个文字的中间子句
        for(int m=0;m<chgCla.size();m++)
        {
            if(0) {
                vector<UINT32> invaildLitIdChg; //Chg; //
                string rundMsgChg; //冗余信息
                Subsumption subsumpChg; //(MOSTRIGHT)
                //参数1 被测的子句指针 参数2 整形数组 参数3 字符串 记录冗余信息
                bool isRundacyRChg = subsumpChg.GenCla(fol,chgCla[m], invaildLitIdChg, rundMsgChg);
                //FileOp::RInvaildInfoOut(rundMsgChg, StartId);
                if (isRundacyRChg) {
                    chgCla[m]->DelLits(false);
                    delete(chgCla[m]);
                    continue;
                }
            }
            if (1) {
                //20170602 新增小三角形判断输出
                if (!StrategyParam::divideTri) {
                    *FileOp::ofRealInfoOut << "R[" + to_string(chgCla[m]->uClaId) + "]" << "[" + to_string(chgCla[m]->LitPtr[0]->ParentLitRow()) + "_" + to_string(chgCla[m]->LitPtr[0]->ParentLitCol()) + "]" << chgCla[m]->LitPtr[0]->subTerm->ToString();
                    *FileOp::ofRealInfoOut << "|[Y]" << endl;
                }
                bool resFlag = true;
                if(resFlag) 
                {
//                    if(1){
//                        set<Clause*>::iterator claP_it = fol.setCla.find(chgCla[m]);
//                        if (claP_it != fol.setCla.end())
//                            continue;
//                    }
//                     if (triAlg.claHasPureLit(fol, chgCla[m])) {
//                        chgCla[m]->DelLits(false);
//                        delete(chgCla[m]);
//                        resFlag = false;
//                        continue;
//                    }
                    //fol.BackwardSubsump(*chgCla[m]); //向后冗余 参数：子句对象
                    fol.BackwardSubsumpClaSet(*chgCla[m],chgCla,true); //向后冗余 参数：子句对象
                    //20170225 设置权重
                    if (chgCla[m]->uLitNum == 1) {
                        if (StrategyParam::R_Weight == -1)
                            chgCla[m]->adeductNum = 0;
                        else
                            chgCla[m]->adeductNum = StrategyParam::R_Weight;
                    } else {
                        if (StrategyParam::R_Weight == -1)
                            chgCla[m]->pdeductNum = 0;
                        else
                            chgCla[m]->pdeductNum = StrategyParam::R_Weight;
                    }
//                    fol.InsertCla(chgCla[m]);
//                    fol.setCla.insert(chgCla[m]);
                    if (StrategyParam::termRewriting != 2)
                        fol.judgeInsertSuper(chgCla[m]);
                    //20170903 若是正等词单元子句需要加入等词处理中
                    if (1){//20170903 没有单元子句互补对,需要添加到集合中
//                        if ((chgCla[m]->uLitNum > 1) && (chgCla[m]->goaldeepth == 0)) {
//                            if (fol.noPairSingleCla.find(chgCla[m]) == fol.noPairSingleCla.end()) {
//                                fol.noPairSingleCla.insert(chgCla[m]);
//                            }
//                        }
                        insertNoPairCla(fol, chgCla[m]);
                    }
                }
                
                continue;
            }
        }
        long leftMem = FileOp::getMem();
        if(leftMem < 200000)
        {
            FileOp::LogOut("内存超出限制,无法判定！剩余内存:" + to_string(leftMem));
            string fileMemOut = FileOp::g_OutputPath + "/" + "memleft.log";
            string cmdMem = "ps -aux | sort -k4nr | head -10 >> " + fileMemOut;
            int res = system(const_cast<char*> (cmdMem.c_str()));
            if (!StrategyParam::orForCompition)
                cout << "无法判定,内存超出限制" << endl;
            else
                cout << "TMO-Non" << endl;
            //cout<<"内存不足,无法判定(请查看电脑运行情况)"<<endl;
            return UNKNOWN;
        }
        clock_t end = clock();
        double time_s = (double)(end - StrategyParam::start)/(double)CLOCKS_PER_SEC;
        
        double breakTimeB = 0.0;
        if ((FileOp::runMode != 0)&&(FileOp::runMode != 1)) {
            breakTimeB = StrategyParam::timeForceLimit - 10;
        } else if ((FileOp::runMode == 0) || (FileOp::runMode == 1)) {
            breakTimeB = StrategyParam::timeForceLimit - 10;
        }
        StrategyParam::timeLimit = StrategyParam::firstTimeLimit;
        if(time_s  > StrategyParam::timeLimit *60/*breakTimeBStrategyParam::timeForceLimitStrategyParam::timeLimit *60*/)//200   3  1分钟 15  5分钟   30  15分钟  end:300
        {
            //20171022 将三角形演绎过程中复制的子句全部删除
            triAlg.delSaveCopyCla(fol);
            FileOp::outReleaseOf();
            //20170315 输出最后的单元子句 方便程序完善
            string str = "";
//            fol.uOrigClaSingleSize = 0;
//            str += fol.ToSingleStringSaturate();
//            FileOp::PrintINFOEndRSinglePre(str); //输出所有的单元子句到.erspre
            if (!StrategyParam::orForCompition && (FileOp::runMode != 0)&&(FileOp::runMode != 1)){
                str = "";
                fol.uOrigClaSingleSize = 0;
                str += fol.ToSingleString();
                FileOp::PrintINFOEndRSinglePre(str); //输出所有的单元子句到.erspre
            }
            
            if(!StrategyParam::orForCompition){
                str = "";
                str += fol.ToUnUseString();
                FileOp::PrintINFONoUsePre(str); //输出所有的未使用子句到.nousepre
                FileOp::LogOut("超出时间"+ to_string(StrategyParam::timeLimit) +"分钟限制,无法判定！");
            }
            
            if ((!StrategyParam::orForCompition) && (FileOp::strategyMode != 3))
                cout << "无法判定" << endl;
            else
                cout << "TMO-Non" << endl;
            preGenCla.clear();
            vector<Clause*>().swap(preGenCla);
            return UNKNOWN;
        }
    }
    return UNKNOWN;
}