/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   Prover.h
 * Author: sjg
 *
 * Created on 2016年11月29日, 下午2:30
 */

#ifndef PROVER_H
#define PROVER_H
#include "FileOp.h"
#include "Formula.h"
#include "Resolution.h"
#include "dataTypeDef.h"
#include "globalFunc.h"
class Prover {
public:
    Prover();
    Prover(const Prover& orig);
    virtual ~Prover();
    //生成预处理.pre文件
    
    static int PreProcess(bool isOrigalS = true) {
        
        Formula fol;

        fol.ReadFOLFile();
        fol.RedundacyByGen(); //全局去除冗余
        string sPreprocess = fol.GetFormulaInfo();
        string sFol = fol.ToString(false);
        sPreprocess += "\n" + sFol;
        FileOp::WritePreFile(sPreprocess);    
        FileOp::ReleaseOf();
        return int(fol.setCla.size());
    }
    //读取预处理文件进行公式判定
    static RESULT prover(bool isOrigalS = true);
    static RESULT proverTestTptp(int strategyId);
    static void validOutUnsatPath();
    static void validOutRelease();
    //20210602 最后的输出打印
    static void FinalPrint(bool haveSecondE, double& totalTime);
    static void OutputOriginalFormula();
};

#endif /* PROVER_H */

