/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   Prover.cpp
 * Author: caof
 * 
 * Created on 2016年11月29日, 下午2:30
 */

#include "Prover.h"
#include <cmath>
#include "globalFunc.h"
extern map<INT32, vector<INT32>> validPathOut;
extern CseSymbolMapper cseSymbolMapper;

Prover::Prover() {
}

Prover::Prover(const Prover& orig) {
}

Prover::~Prover() {
}

void Prover::OutputOriginalFormula() {
    ifstream fin(FileOp::g_PreFileFullName);
    string strLine = "";
    while (getline(fin, strLine)) {
        if (strLine.find("%") != string::npos || strLine == "")
            continue;
        cout << strLine << endl;
    }
    fin.close();
}

//StrategyParam::orginalClaNum
void Prover::validOutUnsatPath() {
    vector<INT32> validR;
    validR.reserve(8);

    vector<INT32>* usedClauses = nullptr;
    //findEmpty
    usedClauses = &validPathOut[0];
    for(int i=0; i<usedClauses->size(); ++i){
        if(usedClauses->at(i) > StrategyParam::maxOriClauseId/*StrategyParam::orginalClaNum*/){
            validR.push_back(usedClauses->at(i));
        }
    }
    for (int i = 0; i < validR.size(); ++i) {
        usedClauses = &validPathOut[validR[i]];
        for (int j = 0; j < usedClauses->size(); ++j) {
            if (usedClauses->at(j) > StrategyParam::maxOriClauseId/*StrategyParam::orginalClaNum*/) {
                if(find(validR.begin(),validR.end(),usedClauses->at(j)) == validR.end())
                    validR.push_back(usedClauses->at(j));
            }
        }
    } 
    if(validR.empty()==false && StrategyParam::orForCompition == false){
        string strProofComp = FileOp::g_OutputPath  + "/usedCluaseId.txt";
        ofstream* usedId = new ofstream(strProofComp.c_str(), ios::app);
        for (int i = 0; i < validR.size(); ++i) {
            *usedId << validR[i] << endl;
        }
        usedId->close();
    }
    string outFile = FileOp::g_OutputPath + "/" + FileOp::JudgeFileFullNameNoExt + ".out";
    ifstream ifFolFile(outFile);
//    string outFileTptp = FileOp::g_OutputPath + "/" + FileOp::JudgeFileFullNameNoExt + ".valid";
//    ofstream ofInfoStream(outFileTptp, ios::app);
    
    string strLine;
    bool outFlag = false;
    while (getline(ifFolFile, strLine)) {
        if (strLine[0] == '%' || strLine[0] == '#') {
            //空行和%--注释语句 不读取
            cout << strLine << endl;
        }
        else if((strLine.find("cnf",0)!= -1) && (strLine.find("$",0)== -1)){
            int begPos = strLine.find_first_of("(") + 1;
            int endPos = strLine.find_first_of(",");
            INT32 claId = stoi(strLine.substr(begPos, endPos - begPos));
            if(find(validR.begin(),validR.end(),claId) != validR.end()){
                cout << strLine << endl;
                outFlag = true;
            }
            else
                outFlag = false; 
            continue;
        }
        else if((strLine.find("cnf",0)!= -1) && (strLine.find("$",0)!= -1)){
            size_t pos = strLine.find('$');
            strLine = strLine.erase(pos,1);
            cout << strLine << endl;
            outFlag = true;
            continue;
        }
        if(outFlag){
            cout << strLine << endl;
        }
    }
    ifFolFile.close();
    //ofInfoStream.close();
    validR.clear();
    vector<INT32>().swap(validR);
}

void Prover::validOutRelease(){
    map<INT32, vector<INT32>>::iterator it;

    for(it=validPathOut.begin();it!=validPathOut.end();++it){
        it->second.clear();
        vector<INT32>().swap(it->second);
    }
    map<INT32, vector<INT32>>().swap(validPathOut);
}

RESULT Prover::prover(bool isOrigalS) {
    Formula fol;
    
    fol.ReadFOLFile();
    
    if((fol.uOrigClaSize < 20000))
        fol.RedundacyByGen();
    
    //初始化原始子句集的属性值
    fol.initOrgClaSetAttr_Change();
    
    fol.GetFormulaInfo_CseFormat();
    
    //读取策略
    if (FileOp::strategyMode == 0)//人工模式
        FileOp::readStrategy(); //读取策略文件
    else if (FileOp::strategyMode == 1) {
        FileOp::readStrategyN(0);
    }

    //adjust timeLimit CSE运行时间设置
    if (FileOp::runMode == 4) {
        /* 结合E系统时间：
         * 系统总时间 = StrategyParam::parseTime（系统启动E第一段运行前）+ firstRunTime（E第一段运行时间）+ StrategyParam::preTime（E第一段运行结束到读取策略文件结束）+ CSE实际运行时间 + E第二段运行时间
         * 这里StrategyParam::timeLimit为CSE实际运行时间 = StrategyParam::timeForceLimit（CSE运行时间）- StrategyParam::preTime（E第一段运行结束到读取预处理文件结束）
         */
        clock_t end = clock();
        StrategyParam::preTime = (double) (end - StrategyParam::start) / (double) CLOCKS_PER_SEC;
        StrategyParam::timeLimit = (StrategyParam::timeForceLimit - StrategyParam::preTime) / 60;     

    }
    else if (FileOp::runMode == 0) {
        /* CSE系统
         * 系统总时间 = StrategyParam::timeForceLimit = StrategyParam::preTime（系统启动到读取策略文件结束）+ CSE实际运行时间
         * 这里StrategyParam::timeLimit为CSE实际运行时间
         */
        clock_t end = clock();
        StrategyParam::preTime = (double) (end - StrategyParam::start) / (double) CLOCKS_PER_SEC;   
        StrategyParam::timeLimit = (StrategyParam::timeForceLimit - StrategyParam::preTime - 1) / 60;            
    }
    //StrategyParam::firstTimeLimit系统运行时间。
    /*这个参数是针对多策略的，防止多个策略中StrategyParam::timeLimit不同，对后面程序的时间控制产生影响，所以设置该参数来把第一个策略的timeLimit设置成整个系统允许时间*/
    //StrategyParam::timeLimitStrategies参数设置的原因同样如此，保存第一个策略的timeLimit来作为系统运行时间
    /*这个参数同样是针对多策略的，这个参数保证即使后面策略中的timeLimit有变动，StrategyParam::timeLimit都与第一个策略的timeLimit相等*/
    StrategyParam::timeLimitStrategies = StrategyParam::timeLimit;
    StrategyParam::firstTimeLimit = StrategyParam::timeLimit;
    StrategyParam::start = clock();
    
    //若子句集没有子句，则退出本函数
    if (fol.setCla.size() == 0) {
        FileOp::ReleaseOf();
        fol.DelSet();//20170807
        return READERR;
    }
    
    //根据策略是否需要调整项序
    if (StrategyParam::termRewriting != 2) {
        for (auto& cla : fol.setCla) {
            cla->directEqn();
        }
    }
    
    //进行判定
    Resolution res;
    UINT64 triTotalTimes = 0;
    RESULT rst;
    StrategyParam::useSaturate = false;
    if (StrategyParam::useSaturate) {
        rst = res.BaseAlgByRecodePathSaturate(fol,triTotalTimes); //使用记录路径的方式进行路径回退
    }
    else {
        rst = res.BaseAlgByRecodePath(fol,triTotalTimes); //使用记录路径的方式进行路径回退
    }
    
    if((rst == UNSAT) && (StrategyParam::problemDiv == 0)){
        cout << "% 判定结论：不可满足！" << endl;
//        clock_t end = clock();
//        double time_s = (double) (end - StrategyParam::start) / (double) CLOCKS_PER_SEC;
//        if(FileOp::runMode == 4){
//            time_s += StrategyParam::parseTime + StrategyParam::firstRunTime + StrategyParam::preTime;
//        }
//        else if(FileOp::runMode == 0){
//            time_s += StrategyParam::preTime;
//        }
//        time_s = fabs(time_s);
//        if (StrategyParam::orForCompition == false) {
//            *FileOp::ofJudgeAllFileResult << FileOp::JudgeFileName << ":不可满足!"<<endl;
//            string str = "判定结论：不可满足！";
//            FileOp::insertInfo(str,time_s,triTotalTimes);
//        }
//        //打印输出
//        if (FileOp::runMode == 4) {
//            double temp = 0.0;
//            FinalPrint(false, temp);
//            cout << "% Total time : " + to_string(time_s) + " s\n";
//        }
//        else if (FileOp::runMode == 0) {
//            cout << "% Version  : CSE-F---1.0\n";
//            cout << "% Problem  : " + FileOp::judgeOriginalFileName + ".p\n";
//            cout << "% Proof found\n";
//            cout << "% SZS status Theorem for " + FileOp::judgeOriginalFileName + ".p\n";
//            cout << "% SZS output start Proof\n";  
//            OutputOriginalFormula();
//            validOutUnsatPath();
//            //string cmdFileOut3 = "cat " + FileOp::g_OutputPath + "/" + FileOp::JudgeFileFullNameNoExt + ".valid";
//            //int res3 = system(const_cast<char*> (cmdFileOut3.c_str()));
//            validOutRelease(); 
//            cout << "% SZS output end Proof" << endl;
//            cout << "% Total time : " + to_string(time_s) + " s\n";
//        }
//        //输出统计信息
//        if (StrategyParam::orForCompition == false) {
//            string msg = to_string(time_s);
//            FileOp::PrintStatisticsMsg(msg);
//        }        
    }
    else {
        //再次调用E
        if (FileOp::runMode == 4) {
            //将格式转成CNF格式
            FileOp::convertInputOfEprover();
            
            //运行E
            string cnfFile = FileOp::g_OutputPath + "/" + FileOp::JudgeFileFullNameNoExt + ".cnf";
            clock_t endTime = clock();
            double realRunTime = 0.0;
            double timeA = (double)(endTime - StrategyParam::start) / (double) CLOCKS_PER_SEC;
            double secondETime = StrategyParam::TotalRunTime - StrategyParam::parseTime - StrategyParam::firstRunTime - StrategyParam::preTime - timeA - 1;
            //cout << "secondeETime:" << secondETime << endl;
//            if (true) {
//                string str = "/home/swjtu/Desktop/LiuDebug";
//                ofstream fout(str, ios::app);
//                fout << "已经用时：" << StrategyParam::parseTime + StrategyParam::firstRunTime + StrategyParam::preTime + timeA << endl;
//                fout << "剩余时间：" << secondETime << endl;
//                fout.close();
//            }
           
            if (FileOp::SecondRunEprover(secondETime, cnfFile)) {   //E判定成功
                //打印
                FinalPrint(true, realRunTime);
                clock_t endTime = clock();
                double timeB = (double)(endTime - StrategyParam::start) / (double) CLOCKS_PER_SEC;
                double totalRunTime = StrategyParam::parseTime + StrategyParam::firstRunTime + StrategyParam::preTime + timeA + realRunTime + timeB;
                cout << "% Total time : " + to_string(totalRunTime) + " s\n";   
//                if (true) {
//                    string str = "/home/swjtu/Desktop/LiuDebug";
//                    ofstream fout(str, ios::app);
//                    fout << "-------------------------" << endl;
//                    fout << "前面用时：" << StrategyParam::parseTime + StrategyParam::firstRunTime + StrategyParam::preTime + timeA << endl;
//                    fout << "E第二段实际运行时间：" << realRunTime << endl;
//                    fout << "总时间:" << totalRunTime << endl;
//                    fout.close();
//                }
                //打印统计信息
                if (StrategyParam::orForCompition == false) {
                    string msg = to_string(totalRunTime);
                    FileOp::PrintStatisticsMsg(msg);
                } 
            }
            else {
                cout << "CSG_E is exited by timeout" << endl;
                
                if (StrategyParam::orForCompition == false) {
                    string msg = "TMO‑Non";
                    FileOp::PrintStatisticsMsg(msg);
                }   
                FileOp::delAllFilesComplete(FileOp::g_OutputPath);
                rmdir(FileOp::g_OutputPath.c_str());
            }
        }
        else if (FileOp::runMode == 0) {
            string strInfoPath = FileOp::g_OutputPath + "/" + FileOp::JudgeFileFullNameNoExt + ".res";
            string lemma_path = FileOp::g_OutputPath + "/" + FileOp::JudgeFileFullNameNoExt + ".lemma";
            if (convert_cse_to_cnf(strInfoPath, lemma_path, cseSymbolMapper, StrategyParam::goalClaId)) {
                //cout << "cse格式引理转cnf/tptp格式引理成功" << endl;
            } else {
                cerr << "Failed: se格式引理转cnf/tptp格式引理失败 [in FileOp.capp, string CseToCnf()]" << endl;
            }
//            cout << "CSE-F is exited by timeout" << endl;
//            if (StrategyParam::orForCompition == false) {
//                string msg = "TMO‑Non";
//                FileOp::PrintStatisticsMsg(msg);
//                *FileOp::ofJudgeAllFileResult << FileOp::JudgeFileName << "无法判定!"<<endl;
//            }   
//            FileOp::delAllFilesComplete(FileOp::g_OutputPath);
//            rmdir(FileOp::g_OutputPath.c_str());   
        }
    }
      
    //to geoff test
    if(1){
        FileOp::delRunFiles();
    }
    
    
    FileOp::ReleaseOf();
    fol.DelSet();//20170807
    return rst;
}

RESULT Prover::proverTestTptp(int strategyId)
{
    Formula fol;
    clock_t readFile = clock();
    fol.ReadPreFile();
    if(StrategyParam::orForCompition){
        StrategyParam::readPreTime = (double) (clock() - readFile) / (double) CLOCKS_PER_SEC;
    }
    
    //初始化原始子句集的属性值
    fol.initOrgClaSetAttr();
    //读取策略开始判定

    FileOp::readStrategyNTptp(strategyId);
    
    
    //adjust timeLimit
    if (StrategyParam::orForCompition) {
        if ((FileOp::runMode != 0)&&(FileOp::runMode != 1)) {
            clock_t end = clock();
            double time_s = (double) (end - StrategyParam::start) / (double) CLOCKS_PER_SEC;
            StrategyParam::timeLimit = (StrategyParam::timeForceLimit - time_s - 10) / 60;
            
            
            //////////////////20190714 bigModify put the multiple strategies average use
            StrategyParam::timeLimitStrategies = StrategyParam::timeLimit;
        }
        if ((FileOp::runMode == 0) || (FileOp::runMode == 1)) {
            if (StrategyParam::timeLimit * 60 > (StrategyParam::timeForceLimit - 1)) {
                clock_t end = clock();
                double time_s = (double) (end - StrategyParam::start) / (double) CLOCKS_PER_SEC;
                StrategyParam::timeLimit = (StrategyParam::timeForceLimit - time_s - 10) / 60;
                StrategyParam::timeLimitStrategies = StrategyParam::timeLimit;
            }
        }
        
        //////////////////20190714 bigModify put the multiple strategies average use
        StrategyParam::firstTimeLimit = StrategyParam::timeLimit;
    }
    else{
        StrategyParam::timeLimitStrategies = StrategyParam::timeLimit;
        StrategyParam::timeForceLimit = StrategyParam::timeLimit;
        StrategyParam::firstTimeLimit = StrategyParam::timeLimit;
    } 
    
    
    if (fol.setCla.size() == 0)
        return READERR;
     //根据策略是否需要调整项序
    if (StrategyParam::termRewriting != 2) {
        for (auto& cla : fol.setOriClas) {
            cla->directEqn();
        }
    }
    //*FileOp::ofOutput << "%File   :mcs-scs 0.1" << endl;
    //*FileOp::ofOutput << "%Problem:" + FileOp::JudgeFileFullNameNoExt << endl;
    if ((!StrategyParam::orForCompition) && (strategyId == 0) && (FileOp::strategyMode == 3))
        cout<<"开始判定:"<<FileOp::JudgeFileName<<endl;
    else if ((!StrategyParam::orForCompition) && (FileOp::strategyMode == 4))
        cout<<"开始判定:"<<FileOp::JudgeFileName<<endl;
    time_t startTime;
    time(&startTime);
    if (!StrategyParam::orForCompition)
        cout<<"开始时间:"<<ctime(&startTime)<<endl;
    clock_t startA;//用于设定时间
    startA = clock();
    Resolution res;
    UINT64 triTotalTimes = 0;
    RESULT rst;
    //cout<< "scs deduction is in"<<endl;
    //cout<< " total numbers:Debug11"  << endl;
    if(StrategyParam::useSaturate){
        rst = res.BaseAlgByRecodePathSaturate(fol,triTotalTimes); //使用记录路径的方式进行路径回退
    }
    else
    {
        rst = res.BaseAlgByRecodePath(fol,triTotalTimes); //使用记录路径的方式进行路径回退
    }
    //cout<< " total numbers:Debug111"  << endl;
//    if(fol.setHasBindTerm()){
//        cout<<"未清空替换项"<<endl;
//    }
    //cout<< "scs deduction is exit"<<endl;
    if(rst == UNSAT){
        clock_t end = clock();
        double time_s = (double) (end - StrategyParam::start) / (double) CLOCKS_PER_SEC;
        if((FileOp::runMode != 0 )&&(FileOp::runMode != 1)){
            time_s += StrategyParam::firstRunTime;
        }
        time_s = fabs(time_s);
        *FileOp::ofJudgeAllFileResult << FileOp::JudgeFileName << ":不可满足!"<<endl;
        string str = "判定结论：不可满足！";
        FileOp::insertInfo(str,time_s,triTotalTimes);
        if(StrategyParam::orForCompition) {
            cout << "%-------------------------------------------" << endl;

            cout << "% File        :CSE---1.2" << endl;
            cout << "% Problem     :" + FileOp::judgeOriginalFileName << endl;
            cout << "% Transform   :cnf" << endl;
            cout << "% Format      :tptp:raw" << endl;
            cout << "% Command     :java -jar mcs_scs.jar %d %s" << endl;
            cout << endl;
            cout << "% Result      :Theorem " + to_string(time_s) + "s" << endl;
            cout << "% Output      :CNFRefutation " + to_string(time_s) + "s" << endl;
            cout << "%-------------------------------------------" << endl;
            string cmdFileOut1 = "cat " + FileOp::judgeOriginalFileFullName;
            int res1 = system(const_cast<char*> (cmdFileOut1.c_str()));
            cout << "%-------------------------------------------" << endl;
            cout << "% Proof found" << endl;
            cout << "% SZS status Theorem for " + FileOp::judgeOriginalFileName << endl;
            cout << "% SZS output start Proof" << endl;
            string cmdFileOut2 = "cat " + FileOp::g_WorkDir + "/" + FileOp::JudgeFileFullNameNoExt + ".pre";
            int res2 = system(const_cast<char*> (cmdFileOut2.c_str()));
            cout << "%-------------------------------------------" << endl;
            validOutUnsatPath();
            string cmdFileOut3 = "cat " + FileOp::g_OutputPath + "/" + FileOp::JudgeFileFullNameNoExt + ".valid";
            int res3 = system(const_cast<char*> (cmdFileOut3.c_str()));
            validOutRelease();
            cout << "% SZS output end Proof" << endl;
            cout << "% Total time :" + to_string(time_s) + "s" << endl;
        }
        
        string strProofComp = FileOp::appPath + "/proofStatistics.txt";
        FileOp::ofProofComp = new ofstream(strProofComp.c_str(), ios::app);
        if(StrategyParam::orForCompition)
            *FileOp::ofProofComp << FileOp::judgeOriginalFileName + ": " + to_string(time_s) <<endl;
        else
            *FileOp::ofProofComp << FileOp::JudgeFileFullNameNoExt + ": " + to_string(time_s) <<endl;
        FileOp::ofProofComp->close();
        
        
    }
    else if((rst == SAT) && (!StrategyParam::orForCompition)){ 
        *FileOp::ofJudgeAllFileResult << FileOp::JudgeFileName << ":可满足!"<<endl;
    }
    else{//UNKNOWN 根据徐老师建议，若无法判定，则删除判定文件夹，这里加上开关
        if((StrategyParam::orForCompition) && (FileOp::runMode < 2)){// all deleted
            if(FileOp::strategyMode == 3) {
                FileOp::delRunFiles();
                if(strategyId == FileOp::strategyFileSize) {
                    FileOp::delAllFilesComplete(FileOp::g_OutputPath);
                    rmdir(FileOp::g_OutputPath.c_str());

                    remove(FileOp::g_PreFileFullName.c_str()); //需要利用pre文件找到目标子句
                }
            } else {
                FileOp::delAllFilesComplete(FileOp::g_OutputPath);
                rmdir(FileOp::g_OutputPath.c_str());

                remove(FileOp::g_PreFileFullName.c_str()); //需要利用pre文件找到目标子句
            }
        }
        else if(/*(StrategyParam::orForCompition) &&*/ (FileOp::runMode > 1)){
            ;
        }
        else if(StrategyParam::delRecord){//FileOp::JudgeFileFullName
            if(strategyId != FileOp::strategyFileSize-1){
                FileOp::delRunFiles();
            }
            else if(strategyId == FileOp::strategyFileSize-1)
                FileOp::delAllFiles();
            if ((StrategyParam::useCombinedSys == 0) && (FileOp::runMode < 2)) {
                rmdir(FileOp::g_OutputPath.c_str());
                if(strategyId == FileOp::strategyFileSize-1){
                    remove(FileOp::g_PreFileFullName.c_str()); //需要利用pre文件找到目标子句
                    cout << "无法判定" << endl;
                }
            }
        }
        *FileOp::ofJudgeAllFileResult << FileOp::JudgeFileName << "无法判定!"<<endl;
        if((StrategyParam::orForCompition) && ((FileOp::runMode == 0 )||(FileOp::runMode == 1))){
            string strProofComp = FileOp::appPath + "/proofStatistics.txt";
            FileOp::ofProofComp = new ofstream(strProofComp.c_str(), ios::app);
            if(StrategyParam::orForCompition)
                *FileOp::ofProofComp << FileOp::judgeOriginalFileName + " :TMO‑Non" << endl;
            else
                *FileOp::ofProofComp << FileOp::JudgeFileFullNameNoExt + " :TMO‑Non" << endl;
            FileOp::ofProofComp->close();
        }
        
    }
    
    
    //to geoff test
    if(0){
        FileOp::delRunFiles();
    }
    
    
    //FileOp::ReleaseOf();
    fol.DelSet();//20170807
    return rst;
}

    //20210602 最后的输出打印
void Prover::FinalPrint(bool haveSecondE, double& totalTime) {
//    string tempStr = "/home/swjtu/Desktop/" + FileOp::judgeOriginalFileName + ".finalout";
//    ofstream fout(tempStr);
    string strLine = "";
    int index = 0;
    
    cout << "% Version  : CSG_E---1.0\n";
    cout << "% Problem  : " + FileOp::judgeOriginalFileName + ".p\n";
    cout << "% Proof found\n";
    cout << "% SZS status Theorem for " + FileOp::judgeOriginalFileName + ".p\n";
    cout << "% SZS output start Proof\n";
    
//    fout << "% Version  : CSE_E---1.3\n";
//    fout << "% Problem  : " + FileOp::judgeOriginalFileName + ".p\n";
//    fout << "% Proof found\n";
//    fout << "% SZS status Theorem for " + FileOp::judgeOriginalFileName + ".p\n";
//    fout << "% SZS output start Proof\n";
    
    //先打印E第一段的输出
    if (StrategyParam::firstRunTime != 0 && StrategyParam::isInteraction) {
        ifstream ifFirstE(FileOp::eOutputFile);
        while (getline(ifFirstE, strLine)) {
            index++;
            if (index > FileOp::maxIndex)
                break;
            if (strLine != "" && strLine.find("#") == string::npos) {
                cout << strLine << endl;
                //fout << strLine << endl;
            }
        }
        ifFirstE.close();
        cout << "%-------------------------------------------" << endl;
    //fout << "%-------------------------------------------" << endl;
    }
    

    
    //再打印CSE输出
    if (StrategyParam::isInteraction) {
        for (auto& it : FileOp::idMap) {
            string rContext = "";
            it.first->toString(rContext);
            cout << "cnf(" + to_string(it.first->uClaId) + ",plain,\n" + "   ("+ rContext+"),\n" + "   inference(rename_variables,[]," + "[" + it.second +"]" + "))." << endl;
            //fout << "cnf(" + to_string(it.first->uClaId) + ",plain,\n" + "   ("+ rContext+"),\n" + "   inference(rename_variables,[]," + "[" + it.second +"]" + "))." << endl;
        }
    }
    OutputOriginalFormula();
    string cmdFileOut3 = "";
    if (haveSecondE) {  //若结合系统CSE没有判定成功，则直接打印.out文件
        cmdFileOut3 = FileOp::g_OutputPath + "/" + FileOp::JudgeFileFullNameNoExt + ".out";
        ifstream fin(cmdFileOut3);
        string strLine = "";
        while (getline(fin, strLine)) {
            if (strLine != "") {
                cout << strLine << endl;
            }
        }
    }
    else {
        validOutUnsatPath();
    }
//    if (1) {
//        string str = FileOp::g_OutputPath + "/" + FileOp::JudgeFileFullNameNoExt + ".out";
//        string strT;
//        ifstream fin(str);
//        while(getline(fin, strT)) {
//            fout << strT << endl;
//        }
//    }
    int res3 = system(const_cast<char*> (cmdFileOut3.c_str()));
    validOutRelease(); 
    
    //最后打印E最后一次调用的输出
    if (haveSecondE) {
        cout << "%-------------------------------------------" << endl;
        //fout << "%-------------------------------------------" << endl;
        bool flag = false;
        ifstream ifOutputFile(FileOp::eSecondOutputFile);
        while (getline(ifOutputFile, strLine)) {
            if (strLine.find("Proof found!", 0) != string::npos)
                flag = true;
            else if (flag && strLine.find("Total time", 0) != string::npos) {
                int beginPos = strLine.find(":");
                int endPos = strLine.find("s");
                string tempTime = strLine.substr(beginPos + 2, (endPos - 1) - (beginPos + 2));
                totalTime = stod(tempTime); 
                break;
            }
            else if (flag && strLine.find("#", 0) == string::npos) {
                cout << strLine << endl;
                //fout << strLine << endl;
            }
        }
        ifOutputFile.close();        
    }
    cout << "% SZS output end Proof\n";
//    fout << "% SZS output end Proof\n";
//    fout.close();
}