/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   Literal.h
 * Author: sjg
 *
 * Created on 2016年11月18日, 下午4:58
 */

#ifndef LITERAL_H
#define LITERAL_H
#include "Term.h"
#include "globalFunc.h"
//#include "Clause.h"
class Clause;
class Literal {
public:
    //谓词项
    Term* subTerm; //指向子项
    UINT32 uLitCode; //文字编码 32位表示行号+列号[前面24位为行号，后8位为列号]
    //分析字符串，并生成文字
    Clause* claPtr;
    Literal* parentLitPtr; //父子句
    /*double SteadyValue(){return subTerm->uMaxVarId/subTerm->u}*/
    // 自动归结计数 ；被动归结计数
    UINT32 uActive, uPassive;
    UINT8 isDel; //1 del 0-no
    bool isDrop;
    UINT32 sDuct;//用于设置子句对应的归结文字权重
    bool pureLit;
    UINT8 goalDeepth;
    //以下用于刻画文字的属性
    UINT32 countPred;//子句集中相同谓词项的个数
    UINT32 countPairPred;//子句集中互补谓词的项个数
    UINT8 litAttr; //文字项属性,0表示基项,1表示只含独立变元,2表示含有共享变元
    UINT16 termCount12;//子句中的项计数,目前常元记1,函数项记1,变元项记2
    UINT16 termCount11;//子句中的项计数,目前常元记1,函数项记1,变元项记1
    UINT16 termCount21;//子句中的项计数,目前常元记2,函数项记2,变元项记1
    Literal(Term* _subT, UINT32 _uLitCode, Clause* _claPtr, Literal* _parentLitPtr)
    : subTerm(_subT), uLitCode(_uLitCode), claPtr(_claPtr), parentLitPtr(_parentLitPtr), uActive(0), uPassive(0), isDel(0), isDrop(false),sDuct(0),pureLit(false),goalDeepth(10),countPred(0),countPairPred(0)
    ,litAttr(0),termCount12(0),termCount11(0),termCount21(0){
    };

    Literal() : subTerm(nullptr), uLitCode(0), claPtr(nullptr), parentLitPtr(nullptr), uActive(0), uPassive(0), isDel(0) , isDrop(false),sDuct(0),pureLit(false),goalDeepth(10),countPred(0),countPairPred(0)
    ,litAttr(0),termCount12(0),termCount11(0),termCount21(0){
    };

    Literal(UINT32 row, UINT16 col) {
    };
    
    ~Literal(void) {
        claPtr = nullptr;
    };
    Literal(const Literal& orig);
    void exEqnTerm();
    /********************************************/

    /*属性
    /*******************************************/
    inline bool coypLit(Literal* lit){
        Literal* newLit = new Literal();
        newLit->claPtr = lit->claPtr;
        newLit->subTerm = lit->subTerm;
    }
 
    //判断文字是否是基文字
    inline bool isConLit(){
        if(subTerm->uVarCount ==0)
            return true;
        else
            return false;
    }
    //判断文字含有独立变元
    inline bool isSingleVarliteral(){
        return subTerm->IsSingleVarLit();
    }
    //判断文字含有共享变元
    inline bool isShareVarLiteral(){
        return subTerm->IsShareVarLit();
    }
    //判断文字是否不含共享变元
    inline bool noExistShareVar(){
        return !(subTerm->IsShareVarLit());
    }
    //等词有两个恒等项
    inline bool isComEq(){
         if(subTerm->isPosEqnTerm() && subTerm->subTermPtr[0]->isVar() && subTerm->subTermPtr[1]->isVar() && subTerm->subTermPtr[0]->EqualInSameCla(subTerm->subTermPtr[1]))
             return true;
         else
             return false;
    }
    inline float SteadyValue() {
        return subTerm->fSteadyValue;
    }
    //变元的关联度

    inline float RelationValue() {
        return subTerm->RelationValue();
    }

    inline UINT32 Col()const {
        return GetVarId(uLitCode);
    }

    inline UINT32 Row() const {
        return GetClaId(uLitCode);
    }
    //得到母式文字编号

    inline UINT32 ParentLitCode() {
        if (parentLitPtr) return parentLitPtr->uLitCode;
        return uLitCode;
    }
    //得到母式子句编号

    inline UINT32 ParentLitRow() {
        if (parentLitPtr) return parentLitPtr->Row();
        return Row();
    }

    //得到母式文字编号

    inline UINT16 ParentLitCol() {
        if (parentLitPtr) return parentLitPtr->Col();
        return Col();
    }
    //重新给文字 列号 改变文字ID

    inline void ReCol(UINT16 uNewCol) {
        uLitCode = uLitCode&~0xFF | uNewCol;
    }
    //判断文字是否时负文字，是负文字返回0,否则返回1
    inline int IsNeLit(){
        UINT32 uPredProp = GetCodeProp(subTerm->iTermCode);
        if((uPredProp== TNegPred) ||(uPredProp== TNegEqn))
            return 0;
        else
            return 1;
    }
    /********************************************/
    /*方法 函数
    /*******************************************/
    //检查是否文字谓词互补

    inline bool isPairPred(const Literal* lit) {
        INT32 iTermCodeA = subTerm->iTermCode;
        INT32 iTermCodeB = lit->subTerm->iTermCode;
        if (TPairPred == GetCodeProp(iTermCodeA) + GetCodeProp(iTermCodeB)
                && GetCodeId(iTermCodeA) == GetCodeId(iTermCodeB))
            return true;
        return false;
    }

    
    //检查是否文字谓词相同

    inline bool isEqPred(const Literal* lit) {
        INT32 iTermCodeA = subTerm->iTermCode;
        INT32 iTermCodeB = lit->subTerm->iTermCode;
        return iTermCodeA==iTermCodeB;
    }
    //计算文字在子句集中的互补文字个数
    UINT32 pairLitSize();
    //添加谓词符号到全局列表中
    void AddPredLst();
    vector<Literal*>* getPredLst();
    /*得到互补谓词候选文字集合*/
    vector<Literal*>* getPairPredLst();
    //从全局谓词表中删除谓词
    void DelPred();
    static void delIndex();
    bool isOnlyOneAppeared();
private:

};

#endif /* LITERAL_H */

