/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   Literal.cpp
 * Author: sjg
 * 
 * Created on 2016年11月18日, 下午4:58
 */

#include "Literal.h"
#include"dataTypeDef.h"
#include"globalFunc.h"
#include "Clause.h"

map<INT32, vector<Literal*>> g_PostPred;
map<INT32, vector<Literal*>>g_NegPred;
map<INT32, vector<Literal*>> g_PostEqn; 
map<INT32, vector<Literal*>> g_NegEqn;
void Literal::delIndex(){
    g_PostPred.clear();
     g_NegPred.clear();
     g_PostEqn.clear();
     g_NegEqn.clear();
}
void Literal::AddPredLst() {

    UINT32 uPredProp = GetCodeProp(subTerm->iTermCode);
    assert(TFunc != uPredProp || TCon != uPredProp);
    if (TNegPred == uPredProp)
        g_NegPred[GetCodeId(subTerm->iTermCode)].push_back(this);
    if (TNegEqn == uPredProp)
        g_NegEqn[GetCodeId(subTerm->iTermCode)].push_back(this);
    if (TPred == uPredProp)
        g_PostPred[GetCodeId(subTerm->iTermCode)].push_back(this);
    if (TEqn == uPredProp)
        g_PostEqn[GetCodeId(subTerm->iTermCode)].push_back(this);
}

vector<Literal*>* Literal::getPredLst() {
    UINT32 uPredProp = GetCodeProp(subTerm->iTermCode);
    assert(TFunc != uPredProp || TCon != uPredProp);
    if (TNegPred == uPredProp)
        return &g_NegPred[GetCodeId(subTerm->iTermCode)];
    if (TNegEqn == uPredProp)
        return &g_NegEqn[GetCodeId(subTerm->iTermCode)];
    if (TPred == uPredProp)
        return &g_PostPred[GetCodeId(subTerm->iTermCode)];
    if (TEqn == uPredProp)
        return &g_PostEqn[GetCodeId(subTerm->iTermCode)];
    return nullptr;
}

vector<Literal*>* Literal::getPairPredLst() {
    UINT32 uPredProp = GetCodeProp(subTerm->iTermCode);
    assert(TFunc != uPredProp || TCon != uPredProp);
    if (TNegPred == uPredProp)
        return &g_PostPred[GetCodeId(subTerm->iTermCode)];
    if (TPred == uPredProp)
        return &g_NegPred[GetCodeId(subTerm->iTermCode)];
    if (TNegEqn == uPredProp)
        return &g_PostEqn[GetCodeId(subTerm->iTermCode)];
    if (TEqn == uPredProp)
        return &g_NegEqn[GetCodeId(subTerm->iTermCode)];
    return nullptr;
}

void Literal::DelPred() {
    UINT32 uPredProp = GetCodeProp(subTerm->iTermCode);
    vector<Literal*>* vLits = nullptr;
    if (TNegPred == uPredProp)
        vLits = &g_NegPred[GetCodeId(subTerm->iTermCode)];
    else if (TNegEqn == uPredProp)
        vLits = &g_NegEqn[GetCodeId(subTerm->iTermCode)];
    else if (TPred == uPredProp)
        vLits = &g_PostPred[GetCodeId(subTerm->iTermCode)];
    else if (TEqn == uPredProp)
        vLits = &g_PostEqn[GetCodeId(subTerm->iTermCode)];
    for (size_t i = 0; i < vLits->size(); ++i) {
        if (vLits->at(i) == this) {
            swap(vLits->at(i), vLits->back());
            vLits->pop_back();
            break;
        }
    }
}

UINT32 Literal::pairLitSize() {
    vector<Literal*>* vCandLit = getPairPredLst();
    return UINT32(vCandLit->size());
}
//以下用于等词处理
void Literal::exEqnTerm(){
    if((GetCodeProp(subTerm->iTermCode) !=TEqn) && (GetCodeProp(subTerm->iTermCode) !=TNegEqn))
        return;
    else{
        bool change = false;
        UINT32 countLeft = 0;
        UINT32 countRight = 0;
        UINT32 varCountLeft = 0;
         UINT32 varCountRight = 0;
        Term* left = subTerm->subTermPtr[0];
        Term* right = subTerm->subTermPtr[1];
        left->countTerm(countLeft);
        right->countTerm(countRight);//countVarTerm
        
        left->countVarTerm(varCountLeft);
        right->countVarTerm(varCountRight);
//        if(varCountLeft > varCountRight){
//            return;
//        }
//        else if((varCountLeft  == varCountRight)){
//            if (countLeft == countRight) {
//                if (left->isVar() && right->isVar()) {
//                    if ((left->iTermCode & 0xFF) > (right->iTermCode & 0xFF)) {
//                        return;
//                    } else
//                        change = true;
//                } else if (left->isVar()) {
//                    return;
//                } else if (right->isVar()) {
//                    change = true;
//                } else if (left->isConTerm() && right->isConTerm()) {
//                    if ((left->iTermCode & 0xFF) > (right->iTermCode & 0xFF)) {
//                        return;
//                    } else
//                        change = true;
//                } else if (left->isConTerm() && right->isFuncTerm()) {
//                    change = true;
//                } else if (left->isFuncTerm() && right->isConTerm()) {
//                    return;
//                } else if (left->isFuncTerm() && right->isFuncTerm()) {
//                    if ((left->iTermCode & 0xFF) > (right->iTermCode & 0xFF)) {
//                        return;
//                    } else
//                        change = true;
//                }
//            }
//            else
//                change = true;
//        }
//        else{
//            change = true;
//        }
        if (countLeft > countRight) {
            return;
        } 
        else if(countLeft == countRight){
            if(left->uSubTermNum > right->uSubTermNum){
                change = true;
            }
            else if(left->uSubTermNum == right->uSubTermNum){
                if(varCountLeft  > varCountRight){
                    change = true;
                }
                else if(varCountLeft  == varCountRight) {
                    if (left->isVar() && right->isVar()) {
                        return;
                    } else if (left->isVar()) {
                        change = true;
                    } else if (right->isVar()) {
                        return;
                    } else if (left->isConTerm() && right->isConTerm()) {
                        return;
                    } else if (left->isConTerm() && right->isFuncTerm()) {
                        change = true;
                    } else if (left->isFuncTerm() && right->isConTerm()) {
                        return;
                    } else if (left->isFuncTerm() && right->isFuncTerm()) {
                            return;
                    }else
                        return;
                }
                else{
                    return;
                }
            }
            else{
                return;
            }
        }
        else
            change = true;
        if(change)
        {
            Term* tmp = nullptr;
            tmp = subTerm->subTermPtr[0];
            subTerm->subTermPtr[0] = subTerm->subTermPtr[1];
            subTerm->subTermPtr[1] = tmp;
        }
        return;
    }
}

//the predicate term just appeared only one time

bool Literal::isOnlyOneAppeared() {
    Clause* cla = claPtr;
    if (cla->uLitNum == 1)
        return true;
    for (UINT16 m = 0; m < cla->uLitNum; ++m) {
        if (cla->LitPtr[m] == this) {
            continue;
        } else if (cla->LitPtr[m]->subTerm->iTermCode == subTerm->iTermCode) {
            return false;
        }
    }
    return true;
}

Literal::Literal(const Literal& orig) {
}



