/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   HashTree.cpp
 * Author: sjg
 * 
 * Created on 2016年12月1日, 下午9:09
 */

#include "HashTree.h"
 //全局变量 冲突次数
int g_ConflictNum_HashTree = 0;
HashTree::HashTree() {
}

HashTree::HashTree(const HashTree& orig) {
}

HashTree::~HashTree() {
}
long HashTree::BKDRHash(const Term* termPtr)
{
    //UINT32 seed=31;
    long hash = 31 + termPtr->iTermCode;
    for (UINT16 i = 0; i < termPtr->uSubTermNum; ++i) {
        hash = hash * 31 + BKDRHash(termPtr->subTermPtr[i]); // /*& 0x7FFFFFFF*/); //转换为正数;
    }
    return hash /*& 0x7FFFFFFF*/;
}
//插入到hashTree中
Term* HashTree::InsertHashTree(Term* termPtr, set<HashNode*, HashNodeCmpByCode>& hashTree)
{
	//计算termCode的HASHCode
    long uHashCode = BKDRHash(termPtr);
    //new HashNode
    HashNode* hashNode = new HashNode(uHashCode, termPtr);
    if (hashTree.empty()) //列表和hash Tree 均为空
    {
        //插入到 hashtree中
        hashTree.insert(hashNode);
        return termPtr;
    }
    //在hashTree中进行查找
    set<HashNode*>::iterator findIt = hashTree.find(hashNode);
    if (findIt != hashTree.end()) //找到 需要判断 是否有冲突发生
    {
        HashNode* cmpHN = *findIt;
        do {
            if (termPtr->EqualInSameCla(cmpHN->termPtr)) {
                delete(termPtr);
                delete(hashNode);
                ++cmpHN->times;
                return cmpHN->termPtr;
            }
            if (!cmpHN->pNext) break;
            cmpHN = cmpHN->pNext;
        } while (1);
        //在所有冲突列表中没有找到，添加新冲突
        ++g_ConflictNum_HashTree;
        cmpHN->pNext = hashNode;
        return termPtr;
    } else { //插入到 hashtree中
        hashTree.insert(hashNode);
        return termPtr;
    }

}
UINT32 HashTree::findTermCountHashTree(Term* termPtr, set<HashNode*, HashNodeCmpByCode>& hashTree){//未完成
    if (hashTree.empty()) //列表和hash Tree 均为空
    {
        return 0;
    }
    set<HashNode*>::iterator findIt = hashTree.begin();
    for(;findIt != hashTree.end();){
        if(termPtr->EqualInSameCla((*findIt)->termPtr)){//找到项
            return (*findIt)->times;
        }
        ++findIt;
    }
    return 0;
}