/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   HashNode.h
 * Author: sjg
 *
 * Created on 2016年11月18日, 上午11:27
 */

#ifndef HASHNODE_H
#define HASHNODE_H
#include "globalFunc.h"
#include "Term.h"
#include "dataTypeDef.h"
#include "HashNode.h"
//class Term;
class HashNode {
public:
    long uHashCode; //hash code
    Term* termPtr; //对应的项指针
    HashNode* pNext; //若不为空则表示有冲突，冲突时的后续列表	 
    UINT32 times;
    HashNode(long _uHashCode, Term*_term) :uHashCode(_uHashCode), termPtr(_term), pNext(nullptr), times(1){};
    HashNode();
    HashNode(const HashNode& orig);
    virtual ~HashNode();
    inline bool operator<(const HashNode&hashNode) const {
        return uHashCode < hashNode.uHashCode;
    }

    inline bool operator>(const HashNode&hashNode) const {
        return uHashCode > hashNode.uHashCode;
    }

    inline bool operator==(const HashNode&hashNode) const {
        return uHashCode == hashNode.uHashCode;
    }
private:

};
class HashNodeCmpByCode :greater<HashNode*> {
public:
    bool operator()(HashNode* h1, HashNode* h2) const{ return h1->uHashCode<h2->uHashCode; }
};


#endif /* HASHNODE_H */

