/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   Formula.h
 * Author: sjg
 *
 * Created on 2016年11月18日, 下午8:14
 */

#ifndef FORMULA_H
#define FORMULA_H
#include"Clause.h"
#include"dataTypeDef.h"
#include"globalFunc.h"
class TriAlg;
class Formula {
public:
    UINT32 uOrigClaSize; //原始子句集大小	
    UINT32 uOrigClaSingleSize;//原始子句集单元子句大小
    UINT32 maxTermCount12;//子句的最大项权重
    UINT32 maxTermCount11;//子句的最大项权重
    UINT32 maxTermCount21;//子句的最大项权重
    UINT32 maxPredTermCount12;//谓词的最大项权重
    UINT32 maxPredTermCount11;//谓词的最大项权重
    UINT32 maxPredTermCount21;//谓词的最大项权重
    //set<Clause*> setOriClas; //从预处理读入的原始子句集 用于对原始子句的遍历
    set<Clause*, claCmpById> setOriClas; //从预处理读入的原始子句集 用于对原始子句的遍历 = setCla + setEqn
    set<Clause*, claCmpById> setCla; //子句集
    set<Clause*, claCmpById> setEnq; //等词公理集合	
    set<Clause*, claCmpById> setDeductCla; //演绎子句集
    set<Clause*, claCmpById> saveGoalClaSet;//目标子句集
    //set<Clause*, claCmpDeductNum> setSingleCla;//用于记录单文字子句 
    set<Clause*, claCmpById> setSingleCla;//用于记录单文字子句
    vector<Literal*> setSingleEnq;//等词公理含有的单元子句
    
    set<Clause*, claCmpById> noPairSingleCla;//用于记录没有单文字子句互补对的非单元子句  claCmpPDeductNum 由目标子句和原始子句集中没有单元子句互补对的子句构成
    set<Clause*, claCmpById> eqnDemod;//存放重写的单元子句集合（符合重写条件的单元子句）
    //set<Clause*, claCmpById> setSingleCla;//用于记录单文字子句 
    
    //用于结合系统
    UINT32 uOrigClaSizeCom; //	
    set<Clause*, claCmpById> setOriClasCom; //
    
    set<Clause*> combinedClaSet; //融合的子句集包括所选的子句和当前三角形
    
    RESULT ReadFOLFile();
    //读取tptp文件
    RESULT ReadTPTPFile();
    //
    Clause* ReadTPTPClause(string& claStr, UINT32& uOrigClaSize);
    //再一次读取文件,用于结合系统
    RESULT ReadTPTPFileAgain();
    //读取预处理后的文件
    RESULT ReadPreFile();
    RESULT ReadMyDefFile();
    
    RESULT chooseCurrentCLaSet(vector<Clause*>* saveCurrentClaSet,UINT32 incLen,TriAlg& triAlg,UINT32 startId, UINT32 endId,UINT32& uNewClaID);
    bool unitFindUintClaUnify(TriAlg& triAlg,Clause* givenCla);//判断子句是否有单元子句可以合一
    /*****************************************************/
    //构造函数
    /****************************************************/
    Formula(void):uOrigClaSize(0),uOrigClaSingleSize(0),maxTermCount12(0),maxTermCount11(0),maxTermCount21(0),maxPredTermCount12(0),maxPredTermCount11(0),maxPredTermCount21(0),uOrigClaSizeCom(0){
    };
    
    Formula(const Formula& orig);
    virtual ~Formula();
    /*****************************************************/
    /*数据输出
    /****************************************************/
    //得到公式集的相关信息
    string GetFormulaInfo();
    void GetFormulaInfo_CseFormat();
    //返回公式集内容
    string ToString(bool isOutInfo);
    void initOrgClaSetAttr();
    void initOrgClaSetAttr_Change();
    void initGenerateClaAttr(Clause*);
    string ToSingleString();
    string ToCombinedString();
    string CseTOtptp();
    string competInitClauseSet();
    string ToSingleAfterString();
    void resetSingleClaNum();
    void resetSingleClaNumSaturate();
    string ToUnUseString();
    string ToSingleStringSaturate();
    bool setHasBindTerm();
    inline Clause* findClaById(const UINT32& claID) {
        Clause* cla = new Clause(claID, 0);
        set<Clause*>::iterator it = setOriClas.find(cla);
        if (it != setOriClas.end())
            return *it;
        delete(cla);
        //cla = nullptr;
        return nullptr;
    }
    inline void initNoPairCla(){
        noPairSingleCla.clear();
        if (StrategyParam::useSaturate) {
            for (auto&cla : setDeductCla) {
                if (cla->uLitNum == 1)
                    continue;
                else if(cla->uLitNum <= 4)
                    noPairSingleCla.insert(cla);
            }
        } else {
            for (auto&cla : setCla) {
                if (cla->uLitNum == 1)
                    continue;
                else if(cla->uLitNum <= 3)
                    noPairSingleCla.insert(cla);
            }
        }
    }
    inline void judgeInsertSuper(Clause* cla) {
         if(1/*StrategyParam::useSaturate*/){
              if (!(cla->isUintEqn()))
                return;
            if (cla->LitPtr[0]->subTerm->suitSuper()) {
                cla->demodulator = true;
                eqnDemod.insert(cla);
            }
         }
    }
    /*****************************************************/
    //约减规则 -- 归入冗余
    /****************************************************/
    //输入子句，检查包含前归入
    void RedundacyByGen();
    //后归入，simply 子句集
    UINT16 BackwardSubsump(Clause& cla_R);
    UINT16 BackwardSubsumpClaSet(Clause& cla_R, vector<Clause*>& claSet, bool flag);
    UINT16 BackwardSubsumpSuper(Clause& cla_R, vector<Clause*>& chooseCla);//用于调解使用
    void resetNoPairClaSet(bool difficulty);
     //后归入，simply 子句集
    UINT16 BackwardSubsumpDirect(Clause& cla_R, Clause& cla_Del);
    UINT16 BackwardSubsumpDirectSaturate(Clause& cla_R,Clause& cla_Del,vector<Clause*> saveCurrentCla);
    /*****************************************************/
    /*相关方法
    /****************************************************/
    //选择下一个 起步子句
    set<Clause*>::iterator NextStartClause(Clause* newCla);
    //将子句添加到子句集中
    void InsertCla(Clause* newCla);
   


    /*****************************************************/
    /*测试
    /****************************************************/
    void PrintSharedTerm();
    void DelSet();
    void DelSubSet(UINT32 cla_id);//删除指定标号的子句
    void DelSubSetSuper(UINT32 cla_id);
private:

};

#endif /* FORMULA_H */

