/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   Formula.cpp
 * Author: sjg
 * 
 * Created on 2016年11月18日, 下午8:14
 */
#include <bitset>

#include "DataStructure.h"
#include "RedundancyOp.h"
#include "FileOp.h"
#include "Clause.h"
#include "Literal.h"
#include "Term.h"
#include "Formula.h"
#include "StrategyParam.h"
#include "Subsumption.h"
#include "Unify.h"
#include "SortRule.h"
#include "dataTypeDef.h"
#include"globalFunc.h"
#include "TriAlg.h"
extern set<HashNode*, HashNodeCmpByCode> g_HashTree;

Formula::Formula(const Formula& orig) {
}

Formula::~Formula() {
}


RESULT Formula::ReadFOLFile()
{
    switch (FileOp::fileType) {
        case 0:
            return ReadTPTPFile();
        case 1: break;
        case 2:
            return ReadMyDefFile();;
        default: break;
    }
    //PrintSharedTerm();
    return UnknownFile;
}
//读取自定义格式
//读取并解析自定义格式一阶逻辑公式

RESULT Formula::ReadMyDefFile() {
    //保存原始子句集每条子句的函数复杂度
    vector<int> funcFixVect;
    funcFixVect.reserve(6);
    //读取文件
    string strClause;
    int maxOriClaId = 0;
    int axiomsNum = 0;
    uOrigClaSize = 0; //行号
    ifstream ifFolFile(FileOp::JudgeFileFullName);
    bool isEqnAxioms = false;
    while (getline(ifFolFile, strClause)) {
        if (strClause == "")continue;
        if (strClause.find_first_of('-') != string::npos)//不读取备注信息
            break;
        if (strClause.find("%EqnAxiom") != string::npos) {
            isEqnAxioms = true;
            continue;
        }
        
        int claId = 0;
        
        size_t pos = strClause.find_first_of(']');
        if (pos <= 1)
            cerr << "Failed: 读取子句ID错误；[in Formula.cpp: RESULT Formula::ReadMyDefFile()]" << endl;
        claId = stoi(strClause.substr(1, pos - 1));
        
        string lits_str = strClause.substr(pos + 1);
        
        vector<string> vectLits = Split_c(lits_str, P_SPLIT_CAHR); //对子句分割文字
        
        Clause* c = new Clause(vectLits, claId);
        c->orgCla = true;
        ++uOrigClaSize;
        
        if (isEqnAxioms) {
            c->isAxtom = true;
            setEnq.insert(c);
            axiomsNum++;
        } else {
            if (c->judgeGoalCla()) {
                c->isGoal = true;
                c->goaldeepth = 0;
            } else {
                c->isGoal = false;
            }
            setCla.insert(c);
            if (claId > maxOriClaId) {
                maxOriClaId = claId;
            }
        }
        setOriClas.insert(c);
        //计算综合函数复杂度
        int funcDeepth = c->compFuncDeepthCla();
        if(find(funcFixVect.begin(), funcFixVect.end(), funcDeepth) == funcFixVect.end())
            funcFixVect.push_back(funcDeepth);
    }
    sort(funcFixVect.begin(),funcFixVect.end());
    int end1 = funcFixVect[funcFixVect.size()-1];
    StrategyParam::funcOrgFixDeepthMax = end1;
    if(funcFixVect.size()>=2){
        StrategyParam::funcOrgFixDeepthLessMax = funcFixVect[funcFixVect.size()-2];
    }
    else{
        StrategyParam::funcOrgFixDeepthLessMax = end1;
    }
    funcFixVect.clear();
    vector<int>().swap(funcFixVect);
//    string strInfo;
//    strInfo += ToString(false);
//    FileOp::PrintINFO(strInfo);
    StrategyParam::maxOriClauseId = maxOriClaId;
    StrategyParam::axiomsNum = axiomsNum;
    return READOK;

}
//读取TPTP格式
RESULT Formula::ReadTPTPFile()
{
    int claId = 0;  //20210601 这个变量保存子句在E中的id, 这就与E的子句ID保持一致
    int maxclaId = 0;
    bool flag = true;
    //读取文件
    string strClause;
    uOrigClaSize = 1; //行号
    ifstream ifFolFile(FileOp::JudgeFileFullName);
    //在INFO信息表中输出 处理后的子句集信息（排序后）
    string strINFO;
    int iBracketNum = 0;
    bool isAxiom = false;
    //20170822
    bool isGoal = false;
    //end
    while (getline(ifFolFile, strClause)) {
        TrimStr(strClause); //去除头尾空格
        if (strClause.length() == 0 || strClause[0] == '%') continue; //空行和%--注释语句 不读取
        vector<string>vectLit; //保存子句中的文字
        if (strClause[0] == 'c') //进入CNF 子句注释
        {
            int index = strClause.find("clause", 3);
            int indexGoal = strClause.find("negated_conjecture", 3);//20170822
            isAxiom = (index == -1);
            isGoal = (indexGoal != -1);//20170822
            iBracketNum = 1;
            //保存子句ID
            if (!isAxiom) {
                int endPos = strClause.find_first_of(",");
                string tempId = strClause.substr(index + 7, endPos - index - 7);
                claId = stoi(tempId);
                //cout << "plain: " << claId << endl;
                if (claId > maxclaId)
                    maxclaId = claId;
            }
            else {
                if (flag) {
                    StrategyParam::maxOriClauseId = maxclaId;
                    flag = false;
                }
                claId = ++maxclaId;
                //cout << "axiom: " << claId << endl;
            }
            continue;
        }
        if (iBracketNum > 0) {
            bool isEqnLit = false;
            bool isFinish = false;
            string strLit;
            for (size_t i = 0; i < strClause.length(); ++i) {
                if (isFinish) break;
                if (strClause[i] == ' ')continue; //空格不进行计算
                if (strClause[i] == '(') {
                    if (iBracketNum > 1) strLit += '(';
                    ++iBracketNum;
                    while (strClause[++i] == ' ') {
                    }
                    //修改
                    if (strClause[i] >= '0' && strClause[i] <= '9') {
                        strLit += "a" + to_string(200 + strClause[i] - '0' + 1);
                        i++;
                    }
                }
                //修改
                while (strClause[i] == ',') {
                    strLit += strClause[i];
                    while (strClause[++i] == ' ') {
                    }
                    //修改
                    if (strClause[i] >= '0' && strClause[i] <= '9') {
                        strLit += "a" + to_string(200 + strClause[i] - '0' + 1);
                        i++;
                    }
                }
                if (strClause[i] == ')')--iBracketNum;
                //一个文字读取完毕
                if (strClause[i] == '|' || iBracketNum == 1) {
                    if (isEqnLit) {
                        strLit += ')';
                        isEqnLit = false;
                    }
                    //某文字仅用一个谓词符号表示则自动添加（a） 如：P+P2(x1) 变为 P(a)
                    if (strLit.find('(') == -1) {
                        strLit += "(a5000)";//modify 20170708  由a改成a500->a5000
                    }
                    //对文字中含有“$true”，“~true”，“$false”，“~false”
                    int iPosA = strLit.find("$true");
                    int iPosB = strLit.find("~$false");
                    if (iPosA > -1 || iPosB > -1) //删除子句
                    {
                        strLit = "";
                        i = strClause.length();
                        continue;
                    }
                    iPosA = strLit.find("~$true");
                    iPosB = strLit.find("$false");

                    if (!(iPosA > -1) && !(iPosB > -1))//删除文字
                    {
                        vectLit.push_back(strLit);
                    }
                    strLit = "";
                    if (strClause[i] == '|')continue;
                }
                //子句读取完毕 退出读取下一条子句
                if (iBracketNum == 1) {
                    isFinish = true;
                    //20170709 增加对含有超过750个文字的子句过滤，由于对于排序和冗余的处理非常耗时，直接过滤
                    if((vectLit.size()>760) ||(vectLit.size() == 0)){
                        ++uOrigClaSize;
                        break;
                    }
                    //20170709
                    //输入时，判断是否为恒真子句，是则跳过不输入，NOTE：为了保证输出的一致性，这里子句序号还是需要记录
                    if (vectLit.size() > 1 && RedundancyOp::CheckTautology(vectLit)) {
                        ++uOrigClaSize;
                        break;
                    }
                    //Clause* cla = new Clause(vectLit, uOrigClaSize); //参数为字句文字字符串组，子句序号
                    Clause* cla = new Clause(vectLit, claId); //参数为字句文字字符串组，子句序号
                    //Clause* cla = new Clause(uOrigClaSize);
                    //SmartPtr<Clause> cla_P(cla);
                    ++uOrigClaSize;
//                    if(cla->uClaId >= 10000){
//                        cout<<"cf-debug"<<endl;
//                    }
//                    if(cla->uClaId >= 20000){
//                        cout<<"cf-debug"<<endl;
//                    }
                    //对文字进行排序
                    //20170824
                    if(cla->uLitNum< 36)
                        cla->SortLit();
                    if (isAxiom)
                    {
                        cla->isAxtom = true;
                        setEnq.insert(cla);
                    }
                    else{
                        //20170822
                        if(isGoal)
                            cla->isGoal = true;
                        else
                            cla->isGoal = false;
                        //end
                        setCla.insert(cla);
                    }
                    string sCla;
                    cla->toString(sCla);
                    
                    if (StrategyParam::orForCompition == false) 
                        FileOp::PrintINFO(sCla);//子句输出到info文件中
                    continue;
                }
                char ch = strClause[i];
                if (ch >= 'A' && ch <= 'Z' && ch != 'X')
                    strLit += ('x' + to_string(ch - 'A' + 1));
                else {
                    switch (ch) {
                        case 'p':ch = 'P';
                            break;
                        case 'X':ch = 'x';
                            break;
                        case 'c':ch = 'a';
                            break;
                        case '=':ch = ',';
                            strLit = "E(" + strLit;
                            isEqnLit = true;
                            break;
                        case '!':
                            if (strClause[++i] == '=') {
                                ch = ',';
                                strLit = "~E(" + strLit;
                                isEqnLit = true;
                            }
                            break;
                        default:
                            break;
                    }
                    strLit += ch;
                }
                //修改
                if (strClause[i] == '=') {
                    while (strClause[++i] == ' ') {
                    }
                    if (strClause[i] >= '0' && strClause[i] <= '9') {
                        strLit += "a" + to_string(200 + strClause[i] - '0' + 1);
                    } else
                        --i;
                }
            }
        }
    }
    if (StrategyParam::axiomsNum == 0)
        StrategyParam::maxOriClauseId = maxclaId;
    uOrigClaSize--;
    return READOK;
}

//read a clause to parse
Clause* Formula::ReadTPTPClause(string& claStr, UINT32& uOrigClaSize)
{
    string strClause = claStr;
    int iBracketNum = 0;
    bool isAxiom = false;
    bool isGoal = false;
    Clause* cla = nullptr;
    if (1) {
        TrimStr(strClause); //去除头尾空格
        //if (strClause.size() == 0 || strClause[0] == '%') continue; //空行和%--注释语句 不读取
        vector<string>vectLit; //保存子句中的文字
        if (strClause[0] == '(') //进入CNF 子句注释
        {
            int index = strClause.find("clause", 3);
            int indexGoal = strClause.find("negated_conjecture", 3);//20170822
            isAxiom = (index == -1);
            isGoal = (indexGoal != -1);//20170822
            iBracketNum = 1;
        }
        if (iBracketNum > 0) {
            bool isEqnLit = false;
            bool isFinish = false;
            string strLit;
            for (size_t i = 0; i < strClause.length(); ++i) {
                if (isFinish)break;
                if (strClause[i] == ' ')continue; //空格不进行计算
                if (strClause[i] == '(') {
                    if (iBracketNum > 1) strLit += '(';
                    ++iBracketNum;
                    while (strClause[++i] == ' ') {
                    }
                    //修改
                    if (strClause[i] >= '0' && strClause[i] <= '9') {
                        strLit += "a" + to_string(200 + strClause[i] - '0' + 1);
                        i++;
                    }
                }
                //修改
                while (strClause[i] == ',') {
                    strLit += strClause[i];
                    while (strClause[++i] == ' ') {
                    }
                    //修改
                    if (strClause[i] >= '0' && strClause[i] <= '9') {
                        strLit += "a" + to_string(200 + strClause[i] - '0' + 1);
                        i++;
                    }
                }
                if (strClause[i] == ')')--iBracketNum;
                //一个文字读取完毕
                if (strClause[i] == '|' || iBracketNum == 1) {
                    if (isEqnLit) {
                        strLit += ')';
                        isEqnLit = false;
                    }
                    //某文字仅用一个谓词符号表示则自动添加（a） 如：P+P2(x1) 变为 P(a)
                    if (strLit.find('(') == -1) {
                        strLit += "(a5000)";//modify 20170708  由a改成a500->a5000
                    }
                    //对文字中含有“$true”，“~true”，“$false”，“~false”
                    int iPosA = strLit.find("$true");
                    int iPosB = strLit.find("~$false");
                    if (iPosA > -1 || iPosB > -1) //删除子句
                    {
                        strLit = "";
                        i = strClause.length();
                        continue;
                    }
                    iPosA = strLit.find("~$true");
                    iPosB = strLit.find("$false");

                    if (!(iPosA > -1) && !(iPosB > -1))//删除文字
                    {
                        vectLit.push_back(strLit);
                    }
                    strLit = "";
                    if (strClause[i] == '|')continue;
                }
                //子句读取完毕 退出读取下一条子句
                if (iBracketNum == 1) {
                    isFinish = true;
                    //20170709 增加对含有超过750个文字的子句过滤，由于对于排序和冗余的处理非常耗时，直接过滤
                    if((vectLit.size()>760) ||(vectLit.size() == 0)){
                        break;
                    }
                    //20170709
                    //输入时，判断是否为恒真子句，是则跳过不输入，NOTE：为了保证输出的一致性，这里子句序号还是需要记录
                    if (vectLit.size() > 1 && RedundancyOp::CheckTautology(vectLit)) {
                        break;
                    }
                    cla = new Clause(vectLit, uOrigClaSize); //参数为字句文字字符串组，子句序号
                    if (cla->compFuncDeepthCla() > StrategyParam::funcFixDeepth) {
                        cla->DelLits(true);
                        delete(cla);
                        return nullptr;
                    }
                    ++uOrigClaSize;
                    if(cla->uLitNum< 36)
                        cla->SortLit();
                    if (isAxiom)
                    {
                        cla->isAxtom = false;
                        //setEnq.insert(cla);
                    }
                    else{
                        if(isGoal)
                            cla->isGoal = true;
                        else
                            cla->isGoal = false;
                        //end
                        //setCla.insert(cla);
                    }
                    continue;
                }
                char ch = strClause[i];
                if (ch >= 'A' && ch <= 'Z' && ch != 'X')
                    strLit += ('x' + to_string(ch - 'A' + 1));
                else {
                    switch (ch) {
                        case 'p':ch = 'P';
                            break;
                        case 'X':ch = 'x';
                            break;
                        case 'c':ch = 'a';
                            break;
                        case '=':ch = ',';
                            strLit = "E(" + strLit;
                            isEqnLit = true;
                            break;
                        case '!':
                            if (strClause[++i] == '=') {
                                ch = ',';
                                strLit = "~E(" + strLit;
                                isEqnLit = true;
                            }
                            break;
                        default:
                            break;
                    }
                    strLit += ch;
                }
                //修改
                if (strClause[i] == '=') {
                    while (strClause[++i] == ' ') {
                    }
                    if (strClause[i] >= '0' && strClause[i] <= '9') {
                        strLit += "a" + to_string(200 + strClause[i] - '0' + 1);
                    } else
                        --i;
                }
            }
        }
    }
    return cla;
}

//用于结合系统,读取原始问题
RESULT Formula::ReadTPTPFileAgain()
{
    //读取文件
    string strClause;
    uOrigClaSizeCom = 1; //行号
    ifstream ifFolFile(FileOp::JudgeFileFullName);
    //在INFO信息表中输出 处理后的子句集信息（排序后）
    string strINFO;
    int iBracketNum = 0;
    bool isAxiom = false;
    //20170822
    bool isGoal = false;
    //end
    while (getline(ifFolFile, strClause)) {
        TrimStr(strClause); //去除头尾空格
        if (strClause.length() == 0 || strClause[0] == '%') continue; //空行和%--注释语句 不读取
        vector<string>vectLit; //保存子句中的文字
        if (strClause[0] == 'c') //进入CNF 子句注释
        {
            int index = strClause.find("clause", 3);
            int indexGoal = strClause.find("negated_conjecture", 3);//20170822
            isAxiom = (index == -1);
            isGoal = (indexGoal != -1);//20170822
            iBracketNum = 1;
            continue;
        }
        if (iBracketNum > 0) {
            bool isEqnLit = false;
            bool isFinish = false;
            string strLit;
            for (size_t i = 0; i < strClause.length(); ++i) {
                if (isFinish)break;
                if (strClause[i] == ' ')continue; //空格不进行计算
                if (strClause[i] == '(') {
                    if (iBracketNum > 1) strLit += '(';
                    ++iBracketNum;
                    while (strClause[++i] == ' ') {
                    }
                    //修改
                    if (strClause[i] >= '0' && strClause[i] <= '9') {
                        strLit += "a" + to_string(200 + strClause[i] - '0' + 1);
                        i++;
                    }
                }
                //修改
                while (strClause[i] == ',') {
                    strLit += strClause[i];
                    while (strClause[++i] == ' ') {
                    }
                    //修改
                    if (strClause[i] >= '0' && strClause[i] <= '9') {
                        strLit += "a" + to_string(200 + strClause[i] - '0' + 1);
                        i++;
                    }
                }
                if (strClause[i] == ')')--iBracketNum;
                //一个文字读取完毕
                if (strClause[i] == '|' || iBracketNum == 1) {
                    if (isEqnLit) {
                        strLit += ')';
                        isEqnLit = false;
                    }
                    //某文字仅用一个谓词符号表示则自动添加（a） 如：P+P2(x1) 变为 P(a)
                    if (strLit.find('(') == -1) {
                        strLit += "(a5000)";//modify 20170708  由a改成a500
                    }
                    //对文字中含有“$true”，“~true”，“$false”，“~false”
                    int iPosA = strLit.find("$true");
                    int iPosB = strLit.find("~$false");
                    if (iPosA > -1 || iPosB > -1) //删除子句
                    {
                        strLit = "";
                        i = strClause.length();
                        continue;
                    }
                    iPosA = strLit.find("~$true");
                    iPosB = strLit.find("$false");

                    if (!(iPosA > -1) && !(iPosB > -1))//删除文字
                    {
                        vectLit.push_back(strLit);
                    }
                    strLit = "";
                    if (strClause[i] == '|')continue;
                }
                //子句读取完毕 退出读取下一条子句
                if (iBracketNum == 1) {
                    isFinish = true;
                    //20170709 增加对含有超过750个文字的子句过滤，由于对于排序和冗余的处理非常耗时，直接过滤
                    if((vectLit.size()>760) ||(vectLit.size() == 0)){
                        ++uOrigClaSizeCom;
                        break;
                    }
                    //20170709
                    //输入时，判断是否为恒真子句，是则跳过不输入，NOTE：为了保证输出的一致性，这里子句序号还是需要记录
                    if (vectLit.size() > 1 && RedundancyOp::CheckTautology(vectLit)) {
                        ++uOrigClaSizeCom;
                        break;
                    }
                    Clause* cla = new Clause(vectLit, uOrigClaSizeCom); //参数为字句文字字符串组，子句序号
                    //Clause* cla = new Clause(uOrigClaSize);
                    //SmartPtr<Clause> cla_P(cla);
                    ++uOrigClaSizeCom;
                    //对文字进行排序
                    //20170824
                    if(cla->uLitNum< 36)
                        cla->SortLit();
                    if (isAxiom)
                    {
                        cla->isAxtom = true;
                    }
                    else{
                        //20170822
                        if(isGoal)
                            cla->isGoal = true;
                        else
                            cla->isGoal = false;
                        //end
                    }
                    setOriClasCom.insert(cla);
//                    string sCla;
//                    cla->toString(sCla);
//                    FileOp::PrintINFO(sCla);//子句输出到info文件中
                    continue;
                }
                char ch = strClause[i];
                if (ch >= 'A' && ch <= 'Z' && ch != 'X')
                    strLit += ('x' + to_string(ch - 'A' + 1));
                else {
                    switch (ch) {
                        case 'p':ch = 'P';
                            break;
                        case 'X':ch = 'x';
                            break;
                        case 'c':ch = 'a';
                            break;
                        case '=':ch = ',';
                            strLit = "E(" + strLit;
                            isEqnLit = true;
                            break;
                        case '!':
                            if (strClause[++i] == '=') {
                                ch = ',';
                                strLit = "~E(" + strLit;
                                isEqnLit = true;
                            }
                            break;
                        default:
                            break;
                    }
                    strLit += ch;
                }
                //修改
                if (strClause[i] == '=') {
                    while (strClause[++i] == ' ') {
                    }
                    if (strClause[i] >= '0' && strClause[i] <= '9') {
                        strLit += "a" + to_string(200 + strClause[i] - '0' + 1);
                    } else
                        --i;
                }
            }
        }
    }
    uOrigClaSizeCom--;
    return READOK;
}

//读取预处理后的文件
RESULT Formula::ReadPreFile()
{
    //保存原始子句集每条子句的函数复杂度
    vector<int> funcFixVect;
    funcFixVect.reserve(6);
    //保存原始子句集每个文字的函数复杂度
    //读取文件
    string strClause;
    ifstream ifFolFile(FileOp::g_PreFileFullName);
    while (getline(ifFolFile, strClause)) {
        if (strClause == "")continue;
        if (strClause.find_first_of('-') != string::npos)//不读取备注信息
            break;
        //读取预处理后的信息
        if (strClause[0] == '%') {
            if (strClause.find("ClaNum") != string::npos) {
                int begPos = strClause.find_first_of(":") + 1;
                int endPos = strClause.find_first_of("(");
                //原始子句数
                uOrigClaSize = stoi(strClause.substr(begPos, endPos - begPos));
                StrategyParam::orginalClaNum = uOrigClaSize;
                int nextPos = strClause.find("EqnAxiom", endPos);
                if (nextPos != string::npos) {
                    begPos = strClause.find(":", nextPos);
                    endPos = strClause.find(")", begPos) - begPos;
                    StrategyParam::g_AxiomNum = stoi(strClause.substr(begPos + 1, endPos));
                    StrategyParam::g_ClaNumNoAxiom = uOrigClaSize - stoi(strClause.substr(begPos + 1, endPos));
                    if((StrategyParam::orginalClaNum > 9500) && (StrategyParam::g_AxiomNum > 0)){
                        StrategyParam::problemDifficult = false;
                    }
                }
            } else if (strClause.find("MaxLitNum") != string::npos) {
                StrategyParam::R_INIT_MAX_NUM = stoi(strClause.substr(strClause.find_first_of(":") + 1));
                if (StrategyParam::R_MAX_NUM == -1)
                    StrategyParam::R_MAX_NUM = stoi(strClause.substr(strClause.find_first_of(":") + 1));
                else if((StrategyParam::R_MAX_NUM < stoi(strClause.substr(strClause.find_first_of(":") + 1))) && !StrategyParam::Rsmall){
                    StrategyParam::R_MAX_NUM = stoi(strClause.substr(strClause.find_first_of(":") + 1));
                }
            } else if (strClause.find("MaxfuncDepth") != string::npos) {
                StrategyParam::R_INIT_MAX_FUNCLAYER = stoi(strClause.substr(strClause.find_first_of(":") + 1));
                if (StrategyParam::R_MAX_FUNCLAYER == -1)
                    StrategyParam::R_MAX_FUNCLAYER = stoi(strClause.substr(strClause.find_first_of(":") + 1));
                else if((StrategyParam::R_MAX_FUNCLAYER < stoi(strClause.substr(strClause.find_first_of(":") + 1))) && !StrategyParam::RFsmall){
                    StrategyParam::R_MAX_FUNCLAYER = stoi(strClause.substr(strClause.find_first_of(":") + 1));
                }
            }else if(strClause.find("goalClause") != string::npos){
                string goalId = strClause.substr(strClause.find_first_of(":") + 2);
                vector<string>vectGoalID = Split_c(goalId, Id_SPLIT_CAHR);
                for(int m=0;m<vectGoalID.size();++m){
                    StrategyParam::goalClaId.push_back(atoi(vectGoalID[m].c_str()));
                }
            }else if(strClause.find("singleGoalClaCount") != string::npos){
                StrategyParam::singleGoalCount = stoi(strClause.substr(strClause.find_first_of(":") + 1));
            }
            else if (strClause.find("maxClauseID") != string::npos)
                StrategyParam::maxOriClauseId = stoi(strClause.substr(strClause.find_first_of(":") + 1));
            continue;
        }
        //判定第一个字符是否符合要求
        if (!(isalpha(strClause[0]) || strClause[0] == '['))
            return READERR;
        vector<string>vectLit = Split_c(strClause, P_SPLIT_CAHR); //对子句分割文字
        //读取行号 [1]
        int begPos = strClause.find_first_of("[") + 1;
        int endPos = strClause.find_first_of("]");
        UINT32 uClaId = stoi(strClause.substr(begPos, endPos - begPos));
        strClause = strClause.substr(endPos + 1);

        vector<string>vectsLit = Split_c(strClause, P_SPLIT_CAHR);
        Clause *c1 = new Clause(vectsLit, uClaId);
        c1->orgCla = true;//为原始子句
        //20171020 对子句的含等词的文字进行项序处理
//        if (StrategyParam::g_AxiomNum >= uClaId) {
//           c1->isAxtom = true;
//            setEnq.insert(c1);
//        } 
        if (uClaId > (StrategyParam::maxOriClauseId - StrategyParam::axiomsNum)) {  //20210602 修改，等词公理的ID比原始子句ID大（原来是小），为了匹配E读取的子句ID
            c1->isAxtom = true;
            setEnq.insert(c1); 
        }
       else {
           if(c1->judgeGoalCla()){
               c1->isGoal = true;
               c1->goaldeepth = 0;
           }else{
               c1->isGoal = false;
           }
            setCla.insert(c1);
        }
        setOriClas.insert(c1);
        //计算综合函数复杂度
        int funcDeepth = c1->compFuncDeepthCla();
        if(find(funcFixVect.begin(), funcFixVect.end(), funcDeepth) == funcFixVect.end())
            funcFixVect.push_back(funcDeepth);
    }
    sort(funcFixVect.begin(),funcFixVect.end());
    int end1 = funcFixVect[funcFixVect.size()-1];
    StrategyParam::funcOrgFixDeepthMax = end1;
     if(funcFixVect.size()>=2){
         StrategyParam::funcOrgFixDeepthLessMax = funcFixVect[funcFixVect.size()-2];
     }
     else{
         StrategyParam::funcOrgFixDeepthLessMax = end1;
     }
    //在INFO信息表中输出 处理后的子句集信息（排序后）
//    string strINFO;
//    strINFO+= ToString(false);
//    FileOp::PrintINFORPre(strINFO);//输出到文件.rspre
    funcFixVect.clear();
    vector<int>().swap(funcFixVect);
    return READOK;
}

//得到公式集的相关信息
string Formula::GetFormulaInfo()
{
    StrategyParam::g_ClaNumNoAxiom = setCla.size();
    string sInfo = "%ClaNum:" + to_string(uOrigClaSize) + "(EqnAxiom:" + to_string(setEnq.size()) + ")"; // StrategyParam::g_ClaNumNoAxiom == MAXINT32 ? "0" : to_string(uOrigClaSize - StrategyParam::g_ClaNumNoAxiom)) + ")";
    UINT32 uVarNum = 0, uSingletonVarNum = 0, uMaxLitNum = 0, uMaxFuncDepth = 0;
    string goalClaStr;
    int singleGoalCount = 0;
    bool flag = false;
    for (auto&cla : setCla) {
        if (uMaxLitNum < cla->uLitNum) uMaxLitNum = cla->uLitNum;
        if (uMaxFuncDepth < cla->uFuncDepth) uMaxFuncDepth = cla->uFuncDepth;
        uVarNum += cla->uVarCount;
        uSingletonVarNum += cla->MaxVarId();
        if(cla->isGoal){
            flag = true;
            goalClaStr += " " + to_string(cla->uClaId);
            if(cla->uLitNum == 1){
                ++singleGoalCount;
            }
        }
    }
    sInfo += "\n%VarNum:" + to_string(uVarNum) + "(SingletonVarNum:" + to_string(uSingletonVarNum) + ")"; //变元总个数
    sInfo += "\n%MaxLitNum:" + to_string(uMaxLitNum);
    sInfo += "\n%MaxfuncDepth:" + to_string(uMaxFuncDepth);
    sInfo += "\n%SharedTerms:" + to_string(g_HashTree.size());
    if(flag)
        sInfo +="\n%goalClause:"+ goalClaStr;
    if(singleGoalCount>0)
        sInfo +="\n%singleGoalClaCount:"+ to_string(singleGoalCount);
    int maxClauseID = StrategyParam::maxOriClauseId + StrategyParam::axiomsNum;
    sInfo += "\n%maxClauseID:" + to_string(maxClauseID);
    return sInfo;
}

void Formula::GetFormulaInfo_CseFormat(){
    StrategyParam::g_ClaNumNoAxiom = setCla.size();
    StrategyParam::g_AxiomNum = setEnq.size();
    StrategyParam::orginalClaNum = uOrigClaSize;
    if((StrategyParam::orginalClaNum > 9500) && (StrategyParam::g_AxiomNum > 0)){
        StrategyParam::problemDifficult = false;
    }
    INT32 uVarNum = 0, uSingletonVarNum = 0, uMaxLitNum = 0, uMaxFuncDepth = 0;
    string goalClaStr;
    int singleGoalCount = 0;
    bool flag = false;
    for (auto&cla : setCla) {
        if (uMaxLitNum < cla->uLitNum) uMaxLitNum = cla->uLitNum;
        if (uMaxFuncDepth < cla->uFuncDepth) uMaxFuncDepth = cla->uFuncDepth;
        uVarNum += cla->uVarCount;
        uSingletonVarNum += cla->MaxVarId();
        if(cla->isGoal){
            flag = true;
            goalClaStr += " " + to_string(cla->uClaId);
            if(cla->uLitNum == 1){
                ++singleGoalCount;
            }
        }
    }
    StrategyParam::R_INIT_MAX_NUM = uMaxLitNum;
    StrategyParam::R_MAX_NUM = uMaxLitNum;
    StrategyParam::R_INIT_MAX_FUNCLAYER = uMaxFuncDepth;
    StrategyParam::singleGoalCount = singleGoalCount;
}

string Formula::ToString(bool isOutInfo)
{
    string sFol = "";
    string sInfo = "";
    //输出排序信息
    set<Clause*, claCmpByRule> sortCla(setCla.begin(), setCla.end());

    for (auto& cla : sortCla) {
        string sCla;
        cla->toString(sCla);
        sFol += sCla + "\n";
        sInfo += sCla + "\n";
    }

    sFol += "%EqnAxiom\n";
    for (auto& cla : setEnq) {
        string sCla;
        cla->toString(sCla);
        sFol += sCla + "\n";
        sInfo += sCla + "\n";
    }
    if (isOutInfo)
        FileOp::PrintINFO(sInfo);
    return sFol;
}

//给子句集初始化
void Formula::initOrgClaSetAttr()
{
    UINT32 maxSize = 0, minSize = 12000;
    UINT32 maxPairSize = 0, minPairSize = 12000;
     UINT32 count = 0;
    for (auto& cla : setOriClas) {
        vector <UINT8> saveTmp;
        saveTmp.reserve(6);
        for(UINT16 i=0; i<cla->uLitNum; ++i){
            if(cla->LitPtr[i]->isConLit()){
                cla->LitPtr[i]->litAttr = 0;//基文字
                saveTmp.push_back(0);
            }
            else if(cla->LitPtr[i]->isSingleVarliteral() && !(cla->LitPtr[i]->isShareVarLiteral())){
                cla->LitPtr[i]->litAttr = 1;//只含独立变元文字
                 saveTmp.push_back(1);
            }
            else if(cla->LitPtr[i]->isShareVarLiteral()){
                cla->LitPtr[i]->litAttr = 2;//含共享变元文字
                 saveTmp.push_back(2);
            }
            cla->LitPtr[i]->countPred = cla->LitPtr[i]->getPredLst()->size() -1;
            cla->LitPtr[i]->countPairPred = cla->LitPtr[i]->getPairPredLst()->size();
            
            //计算文字的项计数
            count = 0;
            cla->LitPtr[i]->subTerm->countTermE(count,1,2);
            cla->LitPtr[i]->termCount12 = count;
            cla->termCount12 += count;
            
            count = 0;
            cla->LitPtr[i]->subTerm->countTermE(count,1,1);
            cla->LitPtr[i]->termCount11 = count;
            cla->termCount11 += count;
            
            count = 0;
            cla->LitPtr[i]->subTerm->countTermE(count,2,1);
            cla->LitPtr[i]->termCount21 = count;
            cla->termCount21 += count;
            
            if(maxSize < cla->LitPtr[i]->countPred){
                maxSize = cla->LitPtr[i]->countPred;         
            }
            if(minSize > cla->LitPtr[i]->countPred){
                minSize = cla->LitPtr[i]->countPred;
            }
            if(maxPairSize < cla->LitPtr[i]->countPairPred){
                maxPairSize = cla->LitPtr[i]->countPairPred;
            }
            if(minPairSize > cla->LitPtr[i]->countPairPred){
                minPairSize = cla->LitPtr[i]->countPairPred;
            }
            if(maxPredTermCount12 < cla->LitPtr[i]->termCount12)
                maxPredTermCount12 = cla->LitPtr[i]->termCount12;
            if(maxPredTermCount11 < cla->LitPtr[i]->termCount11)
                maxPredTermCount11 = cla->LitPtr[i]->termCount11;
            if(maxPredTermCount21 < cla->LitPtr[i]->termCount21)
                maxPredTermCount21 = cla->LitPtr[i]->termCount21;
        }
        if(find(saveTmp.begin(),saveTmp.end(),2) != saveTmp.end()){//子句含有共享变元
            cla->claAttr = 2;
        }
        else if(find(saveTmp.begin(),saveTmp.end(),1) != saveTmp.end()){//只含独立变元子句
            cla->claAttr = 1;
        }
        else
            cla->claAttr = 0;//基子句
        saveTmp.clear();
        vector <UINT8>().swap(saveTmp);
        cla->maxPred = maxSize;
        cla->minPred = minSize;
        cla->maxPairPred = maxPairSize;
        cla->minPairPred = minPairSize;
        if(maxTermCount12 < cla->termCount12){
            maxTermCount12 = cla->termCount12;
        }
        if(maxTermCount11 < cla->termCount11){
            maxTermCount11 = cla->termCount11;
        }
        if(maxTermCount21 < cla->termCount21){
            maxTermCount21 = cla->termCount21;
        }
    }
     //int x=0;
}

//给子句集初始化
void Formula::initOrgClaSetAttr_Change()
{
    UINT32 maxSize = 0, minSize = 12000;
    UINT32 maxPairSize = 0, minPairSize = 12000;
     UINT32 count = 0;
    for (auto& cla : setCla) {
        vector <UINT8> saveTmp;
        saveTmp.reserve(6);
        for(UINT16 i=0; i<cla->uLitNum; ++i){
            if(cla->LitPtr[i]->isConLit()){
                cla->LitPtr[i]->litAttr = 0;//基文字
                saveTmp.push_back(0);
            }
            else if(cla->LitPtr[i]->isSingleVarliteral() && !(cla->LitPtr[i]->isShareVarLiteral())){
                cla->LitPtr[i]->litAttr = 1;//只含独立变元文字
                 saveTmp.push_back(1);
            }
            else if(cla->LitPtr[i]->isShareVarLiteral()){
                cla->LitPtr[i]->litAttr = 2;//含共享变元文字
                 saveTmp.push_back(2);
            }
            cla->LitPtr[i]->countPred = cla->LitPtr[i]->getPredLst()->size() -1;
            cla->LitPtr[i]->countPairPred = cla->LitPtr[i]->getPairPredLst()->size();
            
            //计算文字的项计数
            count = 0;
            cla->LitPtr[i]->subTerm->countTermE(count,1,2);
            cla->LitPtr[i]->termCount12 = count;
            cla->termCount12 += count;
            
            count = 0;
            cla->LitPtr[i]->subTerm->countTermE(count,1,1);
            cla->LitPtr[i]->termCount11 = count;
            cla->termCount11 += count;
            
            count = 0;
            cla->LitPtr[i]->subTerm->countTermE(count,2,1);
            cla->LitPtr[i]->termCount21 = count;
            cla->termCount21 += count;
            
            if(maxSize < cla->LitPtr[i]->countPred){
                maxSize = cla->LitPtr[i]->countPred;         
            }
            if(minSize > cla->LitPtr[i]->countPred){
                minSize = cla->LitPtr[i]->countPred;
            }
            if(maxPairSize < cla->LitPtr[i]->countPairPred){
                maxPairSize = cla->LitPtr[i]->countPairPred;
            }
            if(minPairSize > cla->LitPtr[i]->countPairPred){
                minPairSize = cla->LitPtr[i]->countPairPred;
            }
            if(maxPredTermCount12 < cla->LitPtr[i]->termCount12)
                maxPredTermCount12 = cla->LitPtr[i]->termCount12;
            if(maxPredTermCount11 < cla->LitPtr[i]->termCount11)
                maxPredTermCount11 = cla->LitPtr[i]->termCount11;
            if(maxPredTermCount21 < cla->LitPtr[i]->termCount21)
                maxPredTermCount21 = cla->LitPtr[i]->termCount21;
        }
        if(find(saveTmp.begin(),saveTmp.end(),2) != saveTmp.end()){//子句含有共享变元
            cla->claAttr = 2;
        }
        else if(find(saveTmp.begin(),saveTmp.end(),1) != saveTmp.end()){//只含独立变元子句
            cla->claAttr = 1;
        }
        else
            cla->claAttr = 0;//基子句
        saveTmp.clear();
        vector <UINT8>().swap(saveTmp);
        cla->maxPred = maxSize;
        cla->minPred = minSize;
        cla->maxPairPred = maxPairSize;
        cla->minPairPred = minPairSize;
        if(maxTermCount12 < cla->termCount12){
            maxTermCount12 = cla->termCount12;
        }
        if(maxTermCount11 < cla->termCount11){
            maxTermCount11 = cla->termCount11;
        }
        if(maxTermCount21 < cla->termCount21){
            maxTermCount21 = cla->termCount21;
        }
    }
     //int x=0;
}

//给子句属性值赋值
void Formula::initGenerateClaAttr(Clause* cla)
{
    UINT32 maxSize = 0, minSize = 12000;
    UINT32 maxPairSize = 0, minPairSize = 12000;
    UINT32 count = 0;

    vector <UINT8> saveTmp;
    saveTmp.reserve(6);
    for (UINT16 i = 0; i < cla->uLitNum; ++i) {
        if (cla->LitPtr[i]->isConLit()) {
            cla->LitPtr[i]->litAttr = 0; //基文字
            saveTmp.push_back(0);
        } else if (cla->LitPtr[i]->isSingleVarliteral() && !(cla->LitPtr[i]->isShareVarLiteral())) {
            cla->LitPtr[i]->litAttr = 1; //只含独立变元文字
            saveTmp.push_back(1);
        } else if (cla->LitPtr[i]->isShareVarLiteral()) {
            cla->LitPtr[i]->litAttr = 2; //含共享变元文字
            saveTmp.push_back(2);
        }
        cla->LitPtr[i]->countPred = cla->LitPtr[i]->getPredLst()->size() - 1;
        cla->LitPtr[i]->countPairPred = cla->LitPtr[i]->getPairPredLst()->size();

        //计算文字的项计数
        count = 0;
        cla->LitPtr[i]->subTerm->countTermE(count, 1, 2);
        cla->LitPtr[i]->termCount12 = count;
        cla->termCount12 += count;

        count = 0;
        cla->LitPtr[i]->subTerm->countTermE(count, 1, 1);
        cla->LitPtr[i]->termCount11 = count;
        cla->termCount11 += count;

        count = 0;
        cla->LitPtr[i]->subTerm->countTermE(count, 2, 1);
        cla->LitPtr[i]->termCount21 = count;
        cla->termCount21 += count;

        if (maxSize < cla->LitPtr[i]->countPred) {
            maxSize = cla->LitPtr[i]->countPred;
        } else if (minSize > cla->LitPtr[i]->countPred) {
            minSize = cla->LitPtr[i]->countPred;
        }
        if (maxPairSize < cla->LitPtr[i]->countPairPred) {
            maxPairSize = cla->LitPtr[i]->countPairPred;
        } else if (minPairSize > cla->LitPtr[i]->countPairPred) {
            minPairSize = cla->LitPtr[i]->countPairPred;
        }
    }
    if (find(saveTmp.begin(), saveTmp.end(), 2) != saveTmp.end()) {//子句含有共享变元
        cla->claAttr = 2;
    } else if (find(saveTmp.begin(), saveTmp.end(), 1) != saveTmp.end()) {//只含独立变元子句
        cla->claAttr = 1;
    } else
        cla->claAttr = 0; //基子句
    saveTmp.clear();
    vector <UINT8>().swap(saveTmp);
    cla->maxPred = maxSize;
    cla->minPred = minSize;
    cla->maxPairPred = maxPairSize;
    cla->minPairPred = minPairSize;
    
}

string Formula::competInitClauseSet(){
    string sFol = "";
    //读取原始文件
    if(FileOp::runMode > 1) {
        for (auto& cla : setCla) {
            if (cla->isAxtom)
                continue;
            if (cla->isGoal == false) {
                string sCla;
                cla->toPureString(sCla);
                sFol += sCla + "\n";
            } else {
                string sCla;
                cla->toPureString(sCla);
                sFol += "GOAL" + sCla + "\n";
            }
        } 
    }
    return sFol;
}

//
string Formula::CseTOtptp() {
    string sFol = "";
    for (auto& cla : setOriClasCom) {
        if (cla->isAxtom == false) {
            if (cla->isGoal == false) {
                string sCla;
                cla->toPureString(sCla);
                sFol += sCla + "\n";
            } else {
                string sCla;
                cla->toPureString(sCla);
                sFol += "GOAL" + sCla + "\n";
            }
        }

    } 
    return sFol;
}
//20201207 修改输出为融合系统输出方式

string Formula::ToCombinedString() {
    string sFol = "";
    for (auto& cla : combinedClaSet) {
        if (1) {
            string sCla;
            cla->toPureString(sCla);
            sFol += sCla + "\n";
        }
    }
    return sFol;
}


//20171207 修改输出为结合系统输出方式
string Formula::ToSingleString()
{
    string sFol = "";
    if(StrategyParam::preprocess){
        if(StrategyParam::g_AxiomNum > 0)
                sFol += "等词公理个数:" + to_string(StrategyParam::g_AxiomNum) + "\n";
        for (auto& cla : setOriClas) {
            if (cla->isAxtom) {
                string sCla;
                cla->toPureString(sCla);
                sFol += sCla + "\n";
            }
        }
        for(auto& cla : setOriClas){
            if (cla->isAxtom == false) {
                if (cla->isGoal == false) {
                    string sCla;
                    cla->toPureString(sCla);
                    sFol += sCla + "\n";
                } else {
                    string sCla;
                    cla->toPureString(sCla);
                    sFol += "GOAL" + sCla + "\n";
                }
            }
        }
        return sFol;
    }
    //set<Clause*, claCmpByRule> sortCla(setSingleCla.begin(), setSingleCla.end());
    //为了进一步避免无法保存判断结果的情况,我们将选择10个最优子句加入到.info文件中
    //选择最优子句的依据:1 优先选择带否定的单元子句 2 优先选择含项个数较少的子句 3 优先选择离目标距离较近的子句
    //1.将最优子句加入到info文件
//    vector<Clause*> saveOptimalCla;
//    saveOptimalCla.reserve(10);
//    vector<Clause*> saveMinCla;
//    saveMinCla.reserve(10);
//    UINT32 minCount11 = 10000;
//    UINT32 minCount12 = 10000;
//    UINT32 minCount21 = 10000;
//    Clause* minCount11Cla = nullptr;
//    Clause* minCount12Cla = nullptr;
//    Clause* minCount21Cla = nullptr;
//    for (auto& cla : setCla){
//        //下面的条件是新增的,需要考虑一下
//        if(cla->uClaId <= uOrigClaSize)
//            continue;
//        if((cla->uLitNum == 1)&&((GetCodeProp(cla->LitPtr[0]->subTerm->iTermCode) ==TNegEqn)||(GetCodeProp(cla->LitPtr[0]->subTerm->iTermCode) ==TNegPred))){
//            saveOptimalCla.push_back(cla);
//        }
//        else {
//            if (minCount11 >cla->termCount11) {
//                minCount11 = cla->termCount11;
//                minCount11Cla = cla;
//            }
//            if(minCount12 > cla->termCount12) {
//                minCount12 = cla->termCount12;
//                minCount12Cla = cla;
//            }
//            if(minCount21 > cla->termCount21) {
//                minCount21 = cla->termCount21;
//                minCount21Cla = cla;
//            }
//        }
//    }
//    if (saveOptimalCla.size() > 0) {
//        if(minCount11Cla){
//             if (find(saveOptimalCla.begin(), saveOptimalCla.end(), minCount11Cla) == saveOptimalCla.end()) {
//                saveOptimalCla.push_back(minCount11Cla);
//            }
//        }
//        if(minCount12Cla) {
//            if (find(saveOptimalCla.begin(), saveOptimalCla.end(), minCount12Cla) == saveOptimalCla.end()) {
//                saveOptimalCla.push_back(minCount12Cla);
//            }
//        }
//        if(minCount21Cla) {
//            if (find(saveOptimalCla.begin(), saveOptimalCla.end(), minCount21Cla) == saveOptimalCla.end()) {
//                saveOptimalCla.push_back(minCount21Cla);
//            }
//        }
//        for (UINT32 i = 0; i < saveOptimalCla.size(); ++i) {
//            string sCla;
//            saveOptimalCla[i]->toString(sCla);
//            FileOp::PrintINFO(sCla);
//        }
//        saveOptimalCla.clear();
//        vector<Clause*>().swap(saveOptimalCla);
//    }
    //读取原始文件
    ReadTPTPFileAgain();
    UINT32 axiomCount = 0;
    for (auto& cla : setOriClasCom) {
        if (cla->isAxtom) {
            ++axiomCount;
        }
    } 
    
    //以下为生成中间结果
    if(StrategyParam::useCombinedSys){//如果为结合系统运行方式,则需要加入原始子句,并根据策略,是否需要加入等词公理
        if((StrategyParam::useCombinedSysMethod == 0) || (StrategyParam::useCombinedSysMethod == 2) || (StrategyParam::useCombinedSysMethod == 4) || (StrategyParam::useCombinedSysMethod == 6)|| 
                (StrategyParam::useCombinedSysMethod == 8) || (StrategyParam::useCombinedSysMethod == 10) || (StrategyParam::useCombinedSysMethod == 12)){//加等词公理
            if(StrategyParam::g_AxiomNum > 0)
                sFol += "等词公理个数:" + to_string(axiomCount) + "\n";
            for (auto& cla : setOriClasCom) {
                if(cla->isAxtom)
                {    
                    string sCla;
                    cla->toPureString(sCla);
                    sFol += sCla + "\n";
                }
            } 
            for (auto& cla : setOriClasCom) {
                if(cla->isAxtom == false)
                {
                    if(cla->isGoal == false ){
                        string sCla;
                        cla->toPureString(sCla);
                        sFol += sCla + "\n";
                    }
                    else{
                        string sCla;
                        cla->toPureString(sCla);
                        sFol += "GOAL" + sCla + "\n";
                    }
                }
                
            } 
        }
        else if((StrategyParam::useCombinedSysMethod == 1) || (StrategyParam::useCombinedSysMethod == 3) || (StrategyParam::useCombinedSysMethod == 5) || (StrategyParam::useCombinedSysMethod == 7)|| 
                (StrategyParam::useCombinedSysMethod == 9) || (StrategyParam::useCombinedSysMethod == 11) || (StrategyParam::useCombinedSysMethod == 13)){//不加等词公理
            for (auto& cla : setOriClasCom) {
                if (cla->isAxtom)
                    continue;
                if (cla->isGoal == false) {
                    string sCla;
                    cla->toPureString(sCla);
                    sFol += sCla + "\n";
                } else {
                    string sCla;
                    cla->toPureString(sCla);
                    sFol += "GOAL" + sCla + "\n";
                }
//                string sCla;
//                cla->toPureString(sCla);
//                sFol += sCla + "\n";
            } 
        }
    }
    else if(FileOp::runMode >1) {
        for (auto& cla : setOriClasCom) {
            if (cla->isAxtom)
                continue;
            if (cla->isGoal == false) {
                string sCla;
                cla->toPureString(sCla);
                sFol += sCla + "\n";
            } else {
                string sCla;
                cla->toPureString(sCla);
                sFol += "GOAL" + sCla + "\n";
            }
        } 
    }
    //以下加入子句集
    for (auto& cla : setCla) {
        if(StrategyParam::useCombinedSysMethod == 0) {//S+公理+R单元子句
            if ((cla ->uLitNum >= 2) || (cla->uClaId <= uOrigClaSize))
                continue;
            if (StrategyParam::combinedRMode == 0) {
                if (maxPredTermCount12 < cla->termCount12)
                    continue;
            } else if (StrategyParam::combinedRMode == 1) {
                if (maxPredTermCount11 < cla->termCount11)
                    continue;
            } else if (StrategyParam::combinedRMode == 2) {
                if (maxPredTermCount21 < cla->termCount21)
                    continue;
            }
        }
        else if(StrategyParam::useCombinedSysMethod == 1){//S+R单元子句
            if ((cla ->uLitNum >= 2) || (cla->uClaId <= uOrigClaSize) || (cla->isAxtom))
                continue;
            if (StrategyParam::combinedRMode == 0) {
                if (maxPredTermCount12 < cla->termCount12)
                    continue;
            } else if (StrategyParam::combinedRMode == 1) {
                if (maxPredTermCount11 < cla->termCount11)
                    continue;
            } else if (StrategyParam::combinedRMode == 2) {
                if (maxPredTermCount21 < cla->termCount21)
                    continue;
            }
        }
        else if(StrategyParam::useCombinedSysMethod == 2){//S+公理+R等词子句
            if ((cla->uClaId <= uOrigClaSize) || ((cla->uLitNum > 1) && (cla->hasEqn() == false)))
                continue;
            if (StrategyParam::combinedRMode == 0) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount12 < cla->termCount12)
                        continue;
                }
                else{
                    if (maxTermCount12 < cla->termCount12)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 1) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount11 < cla->termCount11)
                        continue;
                }
                else{
                    if (maxTermCount11 < cla->termCount11)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 2) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount21 < cla->termCount21)
                        continue;
                }
                else{
                    if (maxTermCount21 < cla->termCount21)
                        continue;
                }
            }
        }
        else if(StrategyParam::useCombinedSysMethod == 3){//S+R等词子句
            if ((cla->uClaId <= uOrigClaSize) || ((cla->uLitNum > 1) && (cla->hasEqn() == false)) || (cla->isAxtom))
                continue;
            if (StrategyParam::combinedRMode == 0) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount12 < cla->termCount12)
                        continue;
                }
                else{
                    if (maxTermCount12 < cla->termCount12)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 1) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount11 < cla->termCount11)
                        continue;
                }
                else{
                    if (maxTermCount11 < cla->termCount11)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 2) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount21 < cla->termCount21)
                        continue;
                }
                else{
                    if (maxTermCount21 < cla->termCount21)
                        continue;
                }
            }
        }
       else if(StrategyParam::useCombinedSysMethod == 4){//S+公理+R文字数<=2
            if ((cla->uClaId <= uOrigClaSize) || ((cla->uLitNum > 2)))
                continue;
            if (StrategyParam::combinedRMode == 0) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount12 < cla->termCount12)
                        continue;
                }
                else{
                    if (maxTermCount12 < cla->termCount12)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 1) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount11 < cla->termCount11)
                        continue;
                }
                else{
                    if (maxTermCount11 < cla->termCount11)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 2) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount21 < cla->termCount21)
                        continue;
                }
                else{
                    if (maxTermCount21 < cla->termCount21)
                        continue;
                }
            }
        }
        else if(StrategyParam::useCombinedSysMethod == 5){//S+R文字数<=2
            if ((cla->uClaId <= uOrigClaSize) || ((cla->uLitNum > 2)) || (cla->isAxtom))
                continue;
            if (StrategyParam::combinedRMode == 0) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount12 < cla->termCount12)
                        continue;
                }
                else{
                    if (maxTermCount12 < cla->termCount12)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 1) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount11 < cla->termCount11)
                        continue;
                }
                else{
                    if (maxTermCount11 < cla->termCount11)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 2) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount21 < cla->termCount21)
                        continue;
                }
                else{
                    if (maxTermCount21 < cla->termCount21)
                        continue;
                }
            }
        }
         else if(StrategyParam::useCombinedSysMethod == 6){//S+公理+R文字数<=3
            if ((cla->uClaId <= uOrigClaSize) || ((cla->uLitNum > 3)))
                continue;
            if (StrategyParam::combinedRMode == 0) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount12 < cla->termCount12)
                        continue;
                }
                else{
                    if (maxTermCount12 < cla->termCount12)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 1) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount11 < cla->termCount11)
                        continue;
                }
                else{
                    if (maxTermCount11 < cla->termCount11)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 2) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount21 < cla->termCount21)
                        continue;
                }
                else{
                    if (maxTermCount21 < cla->termCount21)
                        continue;
                }
            }
        }
        else if(StrategyParam::useCombinedSysMethod == 7){//S+R文字数<=3
            if ((cla->uClaId <= uOrigClaSize) || ((cla->uLitNum > 3)) || (cla->isAxtom))
                continue;
            if (StrategyParam::combinedRMode == 0) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount12 < cla->termCount12)
                        continue;
                }
                else{
                    if (maxTermCount12 < cla->termCount12)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 1) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount11 < cla->termCount11)
                        continue;
                }
                else{
                    if (maxTermCount11 < cla->termCount11)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 2) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount21 < cla->termCount21)
                        continue;
                }
                else{
                    if (maxTermCount21 < cla->termCount21)
                        continue;
                }
            }
        }
        else if(StrategyParam::useCombinedSysMethod == 8){//S+公理+所有R
            if ((cla->uClaId <= uOrigClaSize))
                continue;
            if (StrategyParam::combinedRMode == 0) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount12 < cla->termCount12)
                        continue;
                }
                else{
                    if (maxTermCount12 < cla->termCount12)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 1) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount11 < cla->termCount11)
                        continue;
                }
                else{
                    if (maxTermCount11 < cla->termCount11)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 2) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount21 < cla->termCount21)
                        continue;
                }
                else{
                    if (maxTermCount21 < cla->termCount21)
                        continue;
                }
            }
        }
        else if(StrategyParam::useCombinedSysMethod == 9){//S+所有R
            if ((cla->uClaId <= uOrigClaSize) || (cla->isAxtom))
                continue;
            if (StrategyParam::combinedRMode == 0) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount12 < cla->termCount12)
                        continue;
                }
                else{
                    if (maxTermCount12 < cla->termCount12)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 1) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount11 < cla->termCount11)
                        continue;
                }
                else{
                    if (maxTermCount11 < cla->termCount11)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 2) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount21 < cla->termCount21)
                        continue;
                }
                else{
                    if (maxTermCount21 < cla->termCount21)
                        continue;
                }
            }
        }
        else if(StrategyParam::useCombinedSysMethod == 10){//S+公理+目标子句
            if ((cla->uClaId <= uOrigClaSize) || (cla->goaldeepth > 2))
                continue;
            if (StrategyParam::combinedRMode == 0) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount12 < cla->termCount12)
                        continue;
                }
                else{
                    if (maxTermCount12 < cla->termCount12)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 1) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount11 < cla->termCount11)
                        continue;
                }
                else{
                    if (maxTermCount11 < cla->termCount11)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 2) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount21 < cla->termCount21)
                        continue;
                }
                else{
                    if (maxTermCount21 < cla->termCount21)
                        continue;
                }
            }
        }
        else if(StrategyParam::useCombinedSysMethod == 11){//S+目标子句
            if ((cla->uClaId <= uOrigClaSize) || (cla->isAxtom) || (cla->goaldeepth > 2))
                continue;
            if (StrategyParam::combinedRMode == 0) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount12 < cla->termCount12)
                        continue;
                }
                else{
                    if (maxTermCount12 < cla->termCount12)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 1) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount11 < cla->termCount11)
                        continue;
                }
                else{
                    if (maxTermCount11 < cla->termCount11)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 2) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount21 < cla->termCount21)
                        continue;
                }
                else{
                    if (maxTermCount21 < cla->termCount21)
                        continue;
                }
            }
        }
        else if(StrategyParam::useCombinedSysMethod == 12){//S+公理+非公理子句
            if ((cla->uClaId <= uOrigClaSize) || (cla->isAxtom))
                continue;
            if (StrategyParam::combinedRMode == 0) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount12 < cla->termCount12)
                        continue;
                }
                else{
                    if (maxTermCount12 < cla->termCount12)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 1) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount11 < cla->termCount11)
                        continue;
                }
                else{
                    if (maxTermCount11 < cla->termCount11)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 2) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount21 < cla->termCount21)
                        continue;
                }
                else{
                    if (maxTermCount21 < cla->termCount21)
                        continue;
                }
            }
        }
        else if(StrategyParam::useCombinedSysMethod == 13){//S+非公理子句
            if ((cla->uClaId <= uOrigClaSize) || (cla->isAxtom) )
                continue;
            if (StrategyParam::combinedRMode == 0) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount12 < cla->termCount12)
                        continue;
                }
                else{
                    if (maxTermCount12 < cla->termCount12)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 1) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount11 < cla->termCount11)
                        continue;
                }
                else{
                    if (maxTermCount11 < cla->termCount11)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 2) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount21 < cla->termCount21)
                        continue;
                }
                else{
                    if (maxTermCount21 < cla->termCount21)
                        continue;
                }
            }
        }
        string sCla;
//        if (cla->uLitNum > 1) {
//            stable_sort(cla->LitPtr, cla->LitPtr + cla->uLitNum, SortRule::LitCmp);
//        }
        cla->toPureString(sCla);
        sFol += sCla + "\n";
    }
    for (auto& cla : setDeductCla) {
        if (StrategyParam::useCombinedSysMethod == 0) {//S+公理+R单元子句
            if ((cla ->uLitNum >= 2) || (cla->uClaId <= uOrigClaSize))
                continue;
            if (StrategyParam::combinedRMode == 0) {
                if (maxPredTermCount12 < cla->termCount12)
                    continue;
            } else if (StrategyParam::combinedRMode == 1) {
                if (maxPredTermCount11 < cla->termCount11)
                    continue;
            } else if (StrategyParam::combinedRMode == 2) {
                if (maxPredTermCount21 < cla->termCount21)
                    continue;
            }
        } else if (StrategyParam::useCombinedSysMethod == 1) {//S+R单元子句
            if ((cla ->uLitNum >= 2) || (cla->uClaId <= uOrigClaSize) || (cla->isAxtom))
                continue;
            if (StrategyParam::combinedRMode == 0) {
                if (maxPredTermCount12 < cla->termCount12)
                    continue;
            } else if (StrategyParam::combinedRMode == 1) {
                if (maxPredTermCount11 < cla->termCount11)
                    continue;
            } else if (StrategyParam::combinedRMode == 2) {
                if (maxPredTermCount21 < cla->termCount21)
                    continue;
            }
        } else if (StrategyParam::useCombinedSysMethod == 2) {//S+公理+R等词子句
            if ((cla->uClaId <= uOrigClaSize) || ((cla->uLitNum > 1) && (cla->hasEqn() == false)))
                continue;
            if (StrategyParam::combinedRMode == 0) {
                if (cla->uLitNum == 1) {
                    if (maxPredTermCount12 < cla->termCount12)
                        continue;
                } else {
                    if (maxTermCount12 < cla->termCount12)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 1) {
                if (cla->uLitNum == 1) {
                    if (maxPredTermCount11 < cla->termCount11)
                        continue;
                } else {
                    if (maxTermCount11 < cla->termCount11)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 2) {
                if (cla->uLitNum == 1) {
                    if (maxPredTermCount21 < cla->termCount21)
                        continue;
                } else {
                    if (maxTermCount21 < cla->termCount21)
                        continue;
                }
            }
        } else if (StrategyParam::useCombinedSysMethod == 3) {//S+R等词子句
            if ((cla->uClaId <= uOrigClaSize) || ((cla->uLitNum > 1) && (cla->hasEqn() == false)) || (cla->isAxtom))
                continue;
            if (StrategyParam::combinedRMode == 0) {
                if (cla->uLitNum == 1) {
                    if (maxPredTermCount12 < cla->termCount12)
                        continue;
                } else {
                    if (maxTermCount12 < cla->termCount12)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 1) {
                if (cla->uLitNum == 1) {
                    if (maxPredTermCount11 < cla->termCount11)
                        continue;
                } else {
                    if (maxTermCount11 < cla->termCount11)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 2) {
                if (cla->uLitNum == 1) {
                    if (maxPredTermCount21 < cla->termCount21)
                        continue;
                } else {
                    if (maxTermCount21 < cla->termCount21)
                        continue;
                }
            }
        }
        else if(StrategyParam::useCombinedSysMethod == 4){//S+公理+R文字数<=2
            if ((cla->uClaId <= uOrigClaSize) || ((cla->uLitNum > 2)))
                continue;
            if (StrategyParam::combinedRMode == 0) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount12 < cla->termCount12)
                        continue;
                }
                else{
                    if (maxTermCount12 < cla->termCount12)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 1) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount11 < cla->termCount11)
                        continue;
                }
                else{
                    if (maxTermCount11 < cla->termCount11)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 2) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount21 < cla->termCount21)
                        continue;
                }
                else{
                    if (maxTermCount21 < cla->termCount21)
                        continue;
                }
            }
        }
        else if(StrategyParam::useCombinedSysMethod == 5){//S+R文字数<=2
            if ((cla->uClaId <= uOrigClaSize) || ((cla->uLitNum > 2)) || (cla->isAxtom))
                continue;
            if (StrategyParam::combinedRMode == 0) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount12 < cla->termCount12)
                        continue;
                }
                else{
                    if (maxTermCount12 < cla->termCount12)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 1) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount11 < cla->termCount11)
                        continue;
                }
                else{
                    if (maxTermCount11 < cla->termCount11)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 2) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount21 < cla->termCount21)
                        continue;
                }
                else{
                    if (maxTermCount21 < cla->termCount21)
                        continue;
                }
            }
        }
         else if(StrategyParam::useCombinedSysMethod == 6){//S+公理+R文字数<=3
            if ((cla->uClaId <= uOrigClaSize) || ((cla->uLitNum > 3)))
                continue;
            if (StrategyParam::combinedRMode == 0) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount12 < cla->termCount12)
                        continue;
                }
                else{
                    if (maxTermCount12 < cla->termCount12)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 1) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount11 < cla->termCount11)
                        continue;
                }
                else{
                    if (maxTermCount11 < cla->termCount11)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 2) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount21 < cla->termCount21)
                        continue;
                }
                else{
                    if (maxTermCount21 < cla->termCount21)
                        continue;
                }
            }
        }
        else if(StrategyParam::useCombinedSysMethod == 7){//S+R文字数<=3
            if ((cla->uClaId <= uOrigClaSize) || ((cla->uLitNum > 3)) || (cla->isAxtom))
                continue;
            if (StrategyParam::combinedRMode == 0) {//小于权重方式1
                if(cla->uLitNum == 1){
                    if (maxPredTermCount12 < cla->termCount12)
                        continue;
                }
                else{
                    if (maxTermCount12 < cla->termCount12)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 1) {//小于权重方式2
                if(cla->uLitNum == 1){
                    if (maxPredTermCount11 < cla->termCount11)
                        continue;
                }
                else{
                    if (maxTermCount11 < cla->termCount11)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 2) {//小于权重方式3
                if(cla->uLitNum == 1){
                    if (maxPredTermCount21 < cla->termCount21)
                        continue;
                }
                else{
                    if (maxTermCount21 < cla->termCount21)
                        continue;
                }
            }
        }
        else if(StrategyParam::useCombinedSysMethod == 8){//S+公理+所有R
            if ((cla->uClaId <= uOrigClaSize))
                continue;
            if (StrategyParam::combinedRMode == 0) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount12 < cla->termCount12)
                        continue;
                }
                else{
                    if (maxTermCount12 < cla->termCount12)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 1) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount11 < cla->termCount11)
                        continue;
                }
                else{
                    if (maxTermCount11 < cla->termCount11)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 2) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount21 < cla->termCount21)
                        continue;
                }
                else{
                    if (maxTermCount21 < cla->termCount21)
                        continue;
                }
            }
        }
        else if(StrategyParam::useCombinedSysMethod == 9){//S+所有R
            if ((cla->uClaId <= uOrigClaSize) || (cla->isAxtom))
                continue;
            if (StrategyParam::combinedRMode == 0) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount12 < cla->termCount12)
                        continue;
                }
                else{
                    if (maxTermCount12 < cla->termCount12)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 1) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount11 < cla->termCount11)
                        continue;
                }
                else{
                    if (maxTermCount11 < cla->termCount11)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 2) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount21 < cla->termCount21)
                        continue;
                }
                else{
                    if (maxTermCount21 < cla->termCount21)
                        continue;
                }
            }
        }
        else if(StrategyParam::useCombinedSysMethod == 10){//S+公理+目标子句
            if ((cla->uClaId <= uOrigClaSize) || (cla->goaldeepth > 2))
                continue;
            if (StrategyParam::combinedRMode == 0) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount12 < cla->termCount12)
                        continue;
                }
                else{
                    if (maxTermCount12 < cla->termCount12)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 1) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount11 < cla->termCount11)
                        continue;
                }
                else{
                    if (maxTermCount11 < cla->termCount11)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 2) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount21 < cla->termCount21)
                        continue;
                }
                else{
                    if (maxTermCount21 < cla->termCount21)
                        continue;
                }
            }
        }
        else if(StrategyParam::useCombinedSysMethod == 11){//S+目标子句
            if ((cla->uClaId <= uOrigClaSize) || (cla->isAxtom) || (cla->goaldeepth > 2))
                continue;
            if (StrategyParam::combinedRMode == 0) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount12 < cla->termCount12)
                        continue;
                }
                else{
                    if (maxTermCount12 < cla->termCount12)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 1) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount11 < cla->termCount11)
                        continue;
                }
                else{
                    if (maxTermCount11 < cla->termCount11)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 2) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount21 < cla->termCount21)
                        continue;
                }
                else{
                    if (maxTermCount21 < cla->termCount21)
                        continue;
                }
            }
        }
        else if(StrategyParam::useCombinedSysMethod == 12){//S+公理+非公理子句
            if ((cla->uClaId <= uOrigClaSize) || (cla->isAxtom))
                continue;
            if (StrategyParam::combinedRMode == 0) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount12 < cla->termCount12)
                        continue;
                }
                else{
                    if (maxTermCount12 < cla->termCount12)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 1) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount11 < cla->termCount11)
                        continue;
                }
                else{
                    if (maxTermCount11 < cla->termCount11)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 2) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount21 < cla->termCount21)
                        continue;
                }
                else{
                    if (maxTermCount21 < cla->termCount21)
                        continue;
                }
            }
        }
        else if(StrategyParam::useCombinedSysMethod == 13){//S+非公理子句
            if ((cla->uClaId <= uOrigClaSize) || (cla->isAxtom) )
                continue;
            if (StrategyParam::combinedRMode == 0) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount12 < cla->termCount12)
                        continue;
                }
                else{
                    if (maxTermCount12 < cla->termCount12)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 1) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount11 < cla->termCount11)
                        continue;
                }
                else{
                    if (maxTermCount11 < cla->termCount11)
                        continue;
                }
            } else if (StrategyParam::combinedRMode == 2) {
                if(cla->uLitNum == 1){
                    if (maxPredTermCount21 < cla->termCount21)
                        continue;
                }
                else{
                    if (maxTermCount21 < cla->termCount21)
                        continue;
                }
            }
        }
        string sCla;
//        if (cla->uLitNum > 1) {
//            stable_sort(cla->LitPtr, cla->LitPtr + cla->uLitNum, SortRule::LitCmp);
//        }
        cla->toPureString(sCla);
        sFol += sCla + "\n";
    }
    return sFol;
}
string Formula::ToSingleStringSaturate()
{
    string sFol = "";
    //输出排序信息
    //set<Clause*, claCmpByRule> sortCla(setSingleCla.begin(), setSingleCla.end());

    for (auto& cla : setDeductCla) {
        if((cla ->uLitNum > 2) || (cla->uClaId <= uOrigClaSize) || (cla->goaldeepth > 1))
            continue;
        string sCla;
        cla->toString(sCla);
        sFol += sCla + "\n";
        //uOrigClaSingleSize++;
        //cout<<sCla<<endl;
    }
    return sFol;
}

string Formula::ToSingleAfterString()
{
    string sFol = "";
    //输出排序信息
    //set<Clause*, claCmpByRule> sortCla(setSingleCla.begin(), setSingleCla.end());

    for (auto& cla : setCla) {
        if(cla ->uLitNum != 1)
            continue;
        string sCla;
        cla->toString(sCla);
        sFol += sCla + "\n";
        uOrigClaSingleSize++;
        //cout<<sCla<<endl;
    }
    for (auto& cla : setEnq) {
        if(cla ->uLitNum != 1)
            continue;
        setSingleEnq.push_back(cla->LitPtr[0]);
        string sCla;
        cla->toString(sCla);
        sFol += sCla + "\n";
        //cout<<sCla<<endl;
    }
    return sFol;
}
//初始化子句集的单元子句个数
void Formula::resetSingleClaNum()
{
    uOrigClaSingleSize = 0;
    for (auto& cla : setCla) {
        if(cla ->uLitNum != 1)
            continue;
        uOrigClaSingleSize++;
        //cout<<sCla<<endl;
    }
}
void Formula::resetSingleClaNumSaturate()
{
    uOrigClaSingleSize = 0;
    for (auto& cla : setDeductCla) {
        if(cla ->uLitNum != 1)
            continue;
        uOrigClaSingleSize++;
        //cout<<sCla<<endl;
    }
}
//判断子句集是否有未清除的替换项
bool Formula::setHasBindTerm(){
    for (auto& cla : setCla) {
        if(cla->HasTermBind())
            return true;
    }
    return false;
}
//输出未使用的子句
string Formula::ToUnUseString()
{
    string sFol = "";
    //输出排序信息
    //set<Clause*, claCmpByRule> sortCla(setSingleCla.begin(), setSingleCla.end());

    for (auto& cla : setCla) {
        if(cla ->isUse || cla->uClaId > uOrigClaSize)
            continue;
        string sCla;
        cla->toString(sCla);
        sFol += sCla + "\n";
        //cout<<sCla<<endl;
    }
    for (auto& cla : setEnq) {
        if(cla ->isUse || cla->uClaId > uOrigClaSize)
            continue;
        string sCla;
        cla->toString(sCla);
        sFol += sCla + "\n";
        //cout<<sCla<<endl;
    }
    for (auto& cla : setDeductCla) {
        if(cla ->isUse || cla->uClaId > uOrigClaSize)
            continue;
        string sCla;
        cla->toString(sCla);
        sFol += sCla + "\n";
        //cout<<sCla<<endl;
    }
    return sFol;
}
//向前去冗余forward simplification，去子句本身
void Formula::RedundacyByGen() {
    string out;
    int count = 0;
    set<Clause*>::iterator claP_it = setCla.begin();
    clock_t start = clock();
    for (; claP_it != setCla.end();) {
        //20170824
        if((*claP_it)->uLitNum >36 ||(*claP_it)->uVarCount > 36){
            ++claP_it;
            continue;
        }
//        if((*claP_it)->uClaId == 307){
//            cout<<"cf_debug"<<endl;
//        }    
        UINT32 candRow;
        Subsumption subsump;
        if (subsump.GenCla(*claP_it, candRow)) {
            if (!StrategyParam::orForCompition)
                out += to_string(candRow) + "->" + to_string((*claP_it)->uClaId) + ";";
            (*claP_it)->DelLits();
            delete(*claP_it);
            claP_it = setCla.erase(claP_it);
            ++count;
        } else
            ++claP_it;
    }
    if (!StrategyParam::orForCompition) {
        string time = to_string(double(clock() - start) / CLOCKS_PER_SEC);
        out += "# 冗余子句数:" + to_string(count) + " [用时]：" + time + " s";
        FileOp::LogOut(out);
    }
}
//用cla_R去简化子句集中子句 backward simplification
//向后冗余 参数：子句对象
UINT16 Formula::BackwardSubsump(Clause& cla_R)
{
    clock_t start = clock();
    string out;
    UINT16 uDelNum = 0;
    set<Clause*> vRundacyClas;
    Subsumption subsump;
    //string str;
   // cla_R.toString(str);
    //cout << "标准子句:" <<str << endl;
    //cout<<"0"<<endl;
    subsump.InstCla(cla_R, vRundacyClas);
    //usleep(100);
    set<Clause*>::iterator it;
    set<Clause*>::iterator itE;
    set<Clause*>::iterator itDE;
    if (!vRundacyClas.empty()) {
        if (StrategyParam::orForCompition == false) {
            out += to_string(cla_R.uClaId) + "->";
        }
        for (auto&cla : vRundacyClas) {
            //20171026 拷贝子句这里不做冗余删除,最后统一处理
            if(cla->topCopyCla != nullptr)
                continue;
            //cout<<"1"<<endl;
            //cout<<vRundacyClas.size()<<endl;
            //cout<<"[CC" + to_string(cla->uClaId)  + "]"  << cla->LitPtr[0]->subTerm->ToString()<<endl;  
            //删除该子句
            ++uDelNum;
            if (StrategyParam::orForCompition == false) {
                out += to_string(cla->uClaId) + ',';
            }
            //1. 是否在setCla中
            it = setCla.find(cla);
            itE = setEnq.find(cla);
            itDE = setDeductCla.find(cla);
            //set<Clause*>::iterator itN = noPairSingleCla.find(cla);
            //setCla.erase(it);
            if (it != setCla.end()) {
                (*it)->DelLits();
                delete(*it);
                setCla.erase(it);
                if (cla->uClaId < uOrigClaSize + 1 && setOriClas.size() > 0) {
                    set<Clause*> ::iterator delIt = setOriClas.find(cla);
                    if (delIt != setOriClas.end()) {
                        setOriClas.erase(delIt);
                    }
                }
                set<Clause*> ::iterator delItNoPair = noPairSingleCla.find(cla);
                if (delItNoPair != noPairSingleCla.end()) {
                    noPairSingleCla.erase(delItNoPair);
                }
                
                set<Clause*> ::iterator delItGoal= saveGoalClaSet.find(cla);
                if (delItGoal != saveGoalClaSet.end()) {
                    saveGoalClaSet.erase(delItGoal);
                }
                
                set<Clause*> ::iterator delItSingleCla = setSingleCla.find(cla);
                if (delItSingleCla != setSingleCla.end()) {
                    setSingleCla.erase(delItSingleCla);
                }
                
                set<Clause*> ::iterator delItEqn = eqnDemod.find(cla);
                if (delItEqn != eqnDemod.end()) {
                    eqnDemod.erase(delItEqn);
                }
                continue;
            }
            else if(itE != setEnq.end()){
                (*itE)->DelLits();
                delete(*itE);
                setEnq.erase(itE);
                if (cla->uClaId < uOrigClaSize + 1 && setOriClas.size() > 0) {
                    set<Clause*> ::iterator delIt = setOriClas.find(cla);
                    if (delIt != setOriClas.end()) {
                        setOriClas.erase(delIt);
                    }
                }
                set<Clause*> ::iterator delItNoPair = noPairSingleCla.find(cla);
                if (delItNoPair != noPairSingleCla.end()) {
                    noPairSingleCla.erase(delItNoPair);
                }
                
                set<Clause*> ::iterator delItGoal= saveGoalClaSet.find(cla);
                if (delItGoal != saveGoalClaSet.end()) {
                    saveGoalClaSet.erase(delItGoal);
                }
                set<Clause*> ::iterator delItSingleCla = setSingleCla.find(cla);
                if (delItSingleCla != setSingleCla.end()) {
                    setSingleCla.erase(delItSingleCla);
                }
                
                set<Clause*> ::iterator delItEqn = eqnDemod.find(cla);
                if (delItEqn != eqnDemod.end()) {
                    eqnDemod.erase(delItEqn);
                }
                continue;
            }
            else if(itDE != setDeductCla.end()){
                (*itDE)->DelLits();
                delete(*itDE);
                setDeductCla.erase(itDE);
                if (cla->uClaId < uOrigClaSize + 1 && setOriClas.size() > 0) {
                    set<Clause*> ::iterator delIt = setOriClas.find(cla);
                    if (delIt != setOriClas.end()) {
                        setOriClas.erase(delIt);
                    }
                }
                set<Clause*> ::iterator delItGoal= saveGoalClaSet.find(cla);
                if (delItGoal != saveGoalClaSet.end()) {
                    saveGoalClaSet.erase(delItGoal);
                }
                set<Clause*> ::iterator delItNoPair = noPairSingleCla.find(cla);
                if (delItNoPair != noPairSingleCla.end()) {
                    noPairSingleCla.erase(delItNoPair);
                }
                
                set<Clause*> ::iterator delItSingleCla = setSingleCla.find(cla);
                if (delItSingleCla != setSingleCla.end()) {
                    setSingleCla.erase(delItSingleCla);
                }
                
                set<Clause*> ::iterator delItEqn = eqnDemod.find(cla);
                if (delItEqn != eqnDemod.end()) {
                    eqnDemod.erase(delItEqn);
                }
                continue;
            }
        }
        if (StrategyParam::orForCompition == false) {
            string time = to_string(double(clock() - start) / CLOCKS_PER_SEC);
            out = "# R" + to_string(cla_R.uClaId) + "删除子句" + to_string(uDelNum) + "条:" + out + " [用时]：" + time + " s";
            FileOp::LogOut(out);
        }
    }
    return uDelNum;
}

//当集合中含有了冗余子句的处理
UINT16 Formula::BackwardSubsumpClaSet(Clause& cla_R, vector<Clause*>& claSet, bool flag)
{
    clock_t start = clock();
    string out;
    UINT16 uDelNum = 0;
    set<Clause*> vRundacyClas;
    Subsumption subsump;
    //string str;
   // cla_R.toString(str);
    //cout << "标准子句:" <<str << endl;
    //cout<<"0"<<endl;
    subsump.InstCla(cla_R, vRundacyClas);
    //usleep(100);
    set<Clause*>::iterator it;
    set<Clause*>::iterator itE;
    set<Clause*>::iterator itDE;
    if (!vRundacyClas.empty()) {
        if (!StrategyParam::orForCompition)
            out += to_string(cla_R.uClaId) + "->";
        for (auto&cla : vRundacyClas) {
            //20171026 拷贝子句这里不做冗余删除,最后统一处理
            if(cla->topCopyCla != nullptr)
                continue;
            //cout<<"1"<<endl;
            //cout<<vRundacyClas.size()<<endl;
            //cout<<"[CC" + to_string(cla->uClaId)  + "]"  << cla->LitPtr[0]->subTerm->ToString()<<endl;  
            //删除该子句
            ++uDelNum;
            if (!StrategyParam::orForCompition)
                out += to_string(cla->uClaId) + ',';
            if(flag){
                if (find(claSet.begin(), claSet.end(), cla) != claSet.end()) {
                    int pos = -1;
                    int posPire = -1;
                    for (pos = 0; pos < claSet.size(); ++pos) {
                        if (claSet[pos] == cla) {
                            break;
                        }
                    }
                    for (posPire = 0; posPire < claSet.size(); ++posPire) {
                        if (claSet[posPire] == &cla_R) {
                            break;
                        }
                    }
                    if (posPire < pos) {
                        swap(claSet[pos], claSet[claSet.size() - 1]);
                        claSet.pop_back();
                    }
                }
            }
            else{
                 if (find(claSet.begin(), claSet.end(), cla) != claSet.end()) {
                    for (UINT8 pos = 0; pos < claSet.size(); ++pos) {
                        if (claSet[pos] == cla) {
                            swap(claSet[pos], claSet[claSet.size() - 1]);
                            claSet.pop_back();
                            break;
                        }
                    }
                 }
            }
            //1. 是否在setCla中
            it = setCla.find(cla);
            itE = setEnq.find(cla);
            itDE = setDeductCla.find(cla);
            //set<Clause*>::iterator itN = noPairSingleCla.find(cla);
            //setCla.erase(it);
            if (it != setCla.end()) {
                (*it)->DelLits();
                delete(*it);
                setCla.erase(it);
                if (cla->uClaId < uOrigClaSize + 1 && setOriClas.size() > 0) {
                    set<Clause*> ::iterator delIt = setOriClas.find(cla);
                    if (delIt != setOriClas.end()) {
                        setOriClas.erase(delIt);
                    }
                }
                set<Clause*> ::iterator delItNoPair = noPairSingleCla.find(cla);
                if (delItNoPair != noPairSingleCla.end()) {
                    noPairSingleCla.erase(delItNoPair);
                }
                
                set<Clause*> ::iterator delItGoal= saveGoalClaSet.find(cla);
                if (delItGoal != saveGoalClaSet.end()) {
                    saveGoalClaSet.erase(delItGoal);
                }
                
                set<Clause*> ::iterator delItSingleCla = setSingleCla.find(cla);
                if (delItSingleCla != setSingleCla.end()) {
                    setSingleCla.erase(delItSingleCla);
                }
                
                set<Clause*> ::iterator delItEqn = eqnDemod.find(cla);
                if (delItEqn != eqnDemod.end()) {
                    eqnDemod.erase(delItEqn);
                }
                continue;
            }
            else if(itE != setEnq.end()){
                (*itE)->DelLits();
                delete(*itE);
                setEnq.erase(itE);
                if (cla->uClaId < uOrigClaSize + 1 && setOriClas.size() > 0) {
                    set<Clause*> ::iterator delIt = setOriClas.find(cla);
                    if (delIt != setOriClas.end()) {
                        setOriClas.erase(delIt);
                    }
                }
                set<Clause*> ::iterator delItNoPair = noPairSingleCla.find(cla);
                if (delItNoPair != noPairSingleCla.end()) {
                    noPairSingleCla.erase(delItNoPair);
                }
                
                set<Clause*> ::iterator delItGoal= saveGoalClaSet.find(cla);
                if (delItGoal != saveGoalClaSet.end()) {
                    saveGoalClaSet.erase(delItGoal);
                }
                set<Clause*> ::iterator delItSingleCla = setSingleCla.find(cla);
                if (delItSingleCla != setSingleCla.end()) {
                    setSingleCla.erase(delItSingleCla);
                }
                
                set<Clause*> ::iterator delItEqn = eqnDemod.find(cla);
                if (delItEqn != eqnDemod.end()) {
                    eqnDemod.erase(delItEqn);
                }
                continue;
            }
            else if(itDE != setDeductCla.end()){
                (*itDE)->DelLits();
                delete(*itDE);
                setDeductCla.erase(itDE);
                if (cla->uClaId < uOrigClaSize + 1 && setOriClas.size() > 0) {
                    set<Clause*> ::iterator delIt = setOriClas.find(cla);
                    if (delIt != setOriClas.end()) {
                        setOriClas.erase(delIt);
                    }
                }
                set<Clause*> ::iterator delItGoal= saveGoalClaSet.find(cla);
                if (delItGoal != saveGoalClaSet.end()) {
                    saveGoalClaSet.erase(delItGoal);
                }
                set<Clause*> ::iterator delItNoPair = noPairSingleCla.find(cla);
                if (delItNoPair != noPairSingleCla.end()) {
                    noPairSingleCla.erase(delItNoPair);
                }
                
                set<Clause*> ::iterator delItSingleCla = setSingleCla.find(cla);
                if (delItSingleCla != setSingleCla.end()) {
                    setSingleCla.erase(delItSingleCla);
                }
                
                set<Clause*> ::iterator delItEqn = eqnDemod.find(cla);
                if (delItEqn != eqnDemod.end()) {
                    eqnDemod.erase(delItEqn);
                }
                continue;
            }
            //cla->DelLits();
            //(*it)->DelLits();
            //delete(*it);
            //cout<<"1"<<endl;
            //assert(it != setCla.end());
            
//            if (itN != noPairSingleCla.end())
//                noPairSingleCla.erase(itN);
            //如果存在 排序后集合同样需要删除
           //cout<<"2"<<endl;  
            /*
            if (cla->uClaId < uOrigClaSize + 1 && setOriClas.size() > 0) {
                set<Clause*> ::iterator delIt = setOriClas.find(cla);
                if (delIt != setOriClas.end()) {
                    setOriClas.erase(delIt);
                }
            }
            
           */
            //cla->DelLits();
            //delete(cla);
        }
        //cout<<"3"<<endl;
        if (!StrategyParam::orForCompition) {
            string time = to_string(double(clock() - start) / CLOCKS_PER_SEC);
            out = "# R" + to_string(cla_R.uClaId) + "删除子句" + to_string(uDelNum) + "条:" + out + " [用时]：" + time + " s";
            FileOp::LogOut(out);
        }
    }
    return uDelNum;
}

UINT16 Formula::BackwardSubsumpSuper(Clause& cla_R, vector<Clause*>& chooseCla)
{
    clock_t start = clock();
    string out;
    UINT16 uDelNum = 0;
    set<Clause*> vRundacyClas;
    Subsumption subsump;
    subsump.InstCla(cla_R, vRundacyClas);
    //usleep(100);
    set<Clause*>::iterator it;
    set<Clause*>::iterator itE;
    set<Clause*>::iterator itDE;
    if (!vRundacyClas.empty()) {
        out += to_string(cla_R.uClaId) + "->";
        for (auto&cla : vRundacyClas) {
            ++uDelNum;
            out += to_string(cla->uClaId) + ',';
            //20170921 对选择的集合进行处理
            if (find(chooseCla.begin(), chooseCla.end(), cla) != chooseCla.end()) {
                for(UINT8 pos=0; pos<chooseCla.size(); ++pos) {
                    if (chooseCla[pos] == cla) {
                        swap(chooseCla[pos], chooseCla[chooseCla.size() - 1]);
                        chooseCla.pop_back();
                        break;
                    }
                }
            }
            //1. 是否在setCla中
            it = setCla.find(cla);
            itE = setEnq.find(cla);
            itDE = setDeductCla.find(cla);
            //set<Clause*>::iterator itN = noPairSingleCla.find(cla);
            //setCla.erase(it);
            if (it != setCla.end()) {
                (*it)->DelLits();
                delete(*it);
                setCla.erase(it);
                if (cla->uClaId < uOrigClaSize + 1 && setOriClas.size() > 0) {
                    set<Clause*> ::iterator delIt = setOriClas.find(cla);
                    if (delIt != setOriClas.end()) {
                        setOriClas.erase(delIt);
                    }
                }
                set<Clause*> ::iterator delItNoPair = noPairSingleCla.find(cla);
                if (delItNoPair != noPairSingleCla.end()) {
                    noPairSingleCla.erase(delItNoPair);
                }
                
                set<Clause*> ::iterator delItGoal= saveGoalClaSet.find(cla);
                if (delItGoal != saveGoalClaSet.end()) {
                    saveGoalClaSet.erase(delItGoal);
                }
                
                set<Clause*> ::iterator delItSingleCla = setSingleCla.find(cla);
                if (delItSingleCla != setSingleCla.end()) {
                    setSingleCla.erase(delItSingleCla);
                }
                
                set<Clause*> ::iterator delItEqn = eqnDemod.find(cla);
                if (delItEqn != eqnDemod.end()) {
                    eqnDemod.erase(delItEqn);
                }
                continue;
            }
            else if(itE != setEnq.end()){
                (*itE)->DelLits();
                delete(*itE);
                setEnq.erase(itE);
                if (cla->uClaId < uOrigClaSize + 1 && setOriClas.size() > 0) {
                    set<Clause*> ::iterator delIt = setOriClas.find(cla);
                    if (delIt != setOriClas.end()) {
                        setOriClas.erase(delIt);
                    }
                }
                set<Clause*> ::iterator delItNoPair = noPairSingleCla.find(cla);
                if (delItNoPair != noPairSingleCla.end()) {
                    noPairSingleCla.erase(delItNoPair);
                }
                
                set<Clause*> ::iterator delItGoal= saveGoalClaSet.find(cla);
                if (delItGoal != saveGoalClaSet.end()) {
                    saveGoalClaSet.erase(delItGoal);
                }
                set<Clause*> ::iterator delItSingleCla = setSingleCla.find(cla);
                if (delItSingleCla != setSingleCla.end()) {
                    setSingleCla.erase(delItSingleCla);
                }
                
                set<Clause*> ::iterator delItEqn = eqnDemod.find(cla);
                if (delItEqn != eqnDemod.end()) {
                    eqnDemod.erase(delItEqn);
                }
                continue;
            }
            else if(itDE != setDeductCla.end()){
                (*itDE)->DelLits();
                delete(*itDE);
                setDeductCla.erase(itDE);
                if (cla->uClaId < uOrigClaSize + 1 && setOriClas.size() > 0) {
                    set<Clause*> ::iterator delIt = setOriClas.find(cla);
                    if (delIt != setOriClas.end()) {
                        setOriClas.erase(delIt);
                    }
                }
                set<Clause*> ::iterator delItGoal= saveGoalClaSet.find(cla);
                if (delItGoal != saveGoalClaSet.end()) {
                    saveGoalClaSet.erase(delItGoal);
                }
                set<Clause*> ::iterator delItNoPair = noPairSingleCla.find(cla);
                if (delItNoPair != noPairSingleCla.end()) {
                    noPairSingleCla.erase(delItNoPair);
                }
                
                set<Clause*> ::iterator delItSingleCla = setSingleCla.find(cla);
                if (delItSingleCla != setSingleCla.end()) {
                    setSingleCla.erase(delItSingleCla);
                }
                
                set<Clause*> ::iterator delItEqn = eqnDemod.find(cla);
                if (delItEqn != eqnDemod.end()) {
                    eqnDemod.erase(delItEqn);
                }
                continue;
            }
            //cla->DelLits();
            //delete(cla);
        }
        //cout<<"3"<<endl;
        string time = to_string(double(clock() - start) / CLOCKS_PER_SEC);
        out = "# R" + to_string(cla_R.uClaId) + "删除子句" + to_string(uDelNum) + "条:" + out + " [用时]：" + time + " s";
        FileOp::LogOut(out);
    }
    return uDelNum;
}

//重新整理集合
void Formula::resetNoPairClaSet(bool difficulty){
    set<Clause*>::iterator claP_it = noPairSingleCla.begin();
        for (; claP_it != noPairSingleCla.end();) {
            if((*claP_it)->isUse &&!difficulty){
                claP_it = noPairSingleCla.erase(claP_it);
            }
            else
                ++claP_it;
        }
}
//定向冗余，删除指定的冗余子句
UINT16 Formula::BackwardSubsumpDirect(Clause& cla_R,Clause& cla_Del)
{
    clock_t start = clock();
    string out;
    UINT16 uDelNum = 0;
    set<Clause*> vRundacyClas;
    Subsumption subsump;
    //string str;
   // cla_R.toString(str);
    //cout << "标准子句:" <<str << endl;
    //cout<<"0"<<endl;
    subsump.InstClaDirect(cla_R,cla_Del, vRundacyClas);
    //usleep(100);
    //set<Clause*>::iterator it;
    set<Clause*>::iterator it;
    set<Clause*>::iterator itE;
    set<Clause*>::iterator itDE;
    if (!vRundacyClas.empty()) {
        if (!StrategyParam::orForCompition)
            out += to_string(cla_R.uClaId) + "->";
        for (auto&cla : vRundacyClas) {
            //cout<<"1"<<endl;
            //cout<<vRundacyClas.size()<<endl;
            //cout<<"[CC" + to_string(cla->uClaId)  + "]"  << cla->LitPtr[0]->subTerm->ToString()<<endl;  
            //删除该子句
            ++uDelNum;
            if (!StrategyParam::orForCompition)
                out += to_string(cla->uClaId) + ',';
//            set<Clause*>::iterator it = setCla.find(cla);
//            //set<Clause*>::iterator itN = noPairSingleCla.find(cla);
//            //setCla.erase(it);
//            cla->DelLits();
//            delete(cla);
//            //(*it)->DelLits();
//            //delete(*it);
//            //cout<<"1"<<endl;
//            assert(it != setCla.end());
//            setCla.erase(it);
//            if (itN != noPairSingleCla.end())
//                noPairSingleCla.erase(itN);
            //如果存在 排序后集合同样需要删除
           //cout<<"2"<<endl;  
            /*
            if (cla->uClaId < uOrigClaSize + 1 && setOriClas.size() > 0) {
                set<Clause*> ::iterator delIt = setOriClas.find(cla);
                if (delIt != setOriClas.end()) {
                    setOriClas.erase(delIt);
                }
            }
            
           */
            //cla->DelLits();
            //delete(cla);
            //1. 是否在setCla中
            it = setCla.find(cla);
            itE = setEnq.find(cla);
            itDE = setDeductCla.find(cla);
            //set<Clause*>::iterator itN = noPairSingleCla.find(cla);
            //setCla.erase(it);
            if (it != setCla.end()) {
                (*it)->DelLits();
                delete(*it);
                setCla.erase(it);
                if (cla->uClaId < uOrigClaSize + 1 && setOriClas.size() > 0) {
                    set<Clause*> ::iterator delIt = setOriClas.find(cla);
                    if (delIt != setOriClas.end()) {
                        setOriClas.erase(delIt);
                    }
                }
                
                set<Clause*, claCmpPDeductNum> ::iterator delItNoPair = noPairSingleCla.find(cla);
                if (delItNoPair != noPairSingleCla.end()) {
                    noPairSingleCla.erase(delItNoPair);
                }
                
                set<Clause*> ::iterator delItGoal= saveGoalClaSet.find(cla);
                if (delItGoal != saveGoalClaSet.end()) {
                    saveGoalClaSet.erase(delItGoal);
                }
                
                set<Clause*> ::iterator delItSingleCla = setSingleCla.find(cla);
                if (delItSingleCla != setSingleCla.end()) {
                    setSingleCla.erase(delItSingleCla);
                }
                set<Clause*> ::iterator delItEqn = eqnDemod.find(cla);
                if (delItEqn != eqnDemod.end()) {
                    eqnDemod.erase(delItEqn);
                }
                continue;
            }
            else if(itE != setEnq.end()){
                (*itE)->DelLits();
                delete(*itE);
                setEnq.erase(itE);
                if (cla->uClaId < uOrigClaSize + 1 && setOriClas.size() > 0) {
                    set<Clause*> ::iterator delIt = setOriClas.find(cla);
                    if (delIt != setOriClas.end()) {
                        setOriClas.erase(delIt);
                    }
                }
                set<Clause*> ::iterator delItNoPair = noPairSingleCla.find(cla);
                if (delItNoPair != noPairSingleCla.end()) {
                    noPairSingleCla.erase(delItNoPair);
                }
                 set<Clause*> ::iterator delItGoal= saveGoalClaSet.find(cla);
                if (delItGoal != saveGoalClaSet.end()) {
                    saveGoalClaSet.erase(delItGoal);
                }
                set<Clause*> ::iterator delItSingleCla = setSingleCla.find(cla);
                if (delItSingleCla != setSingleCla.end()) {
                    setSingleCla.erase(delItSingleCla);
                }
                set<Clause*> ::iterator delItEqn = eqnDemod.find(cla);
                if (delItEqn != eqnDemod.end()) {
                    eqnDemod.erase(delItEqn);
                }
                continue;
            }
            else if(itDE != setDeductCla.end()){
                 (*itDE)->DelLits();
                delete(*itDE);
                setDeductCla.erase(itDE);
                if (cla->uClaId < uOrigClaSize + 1 && setOriClas.size() > 0) {
                    set<Clause*> ::iterator delIt = setOriClas.find(cla);
                    if (delIt != setOriClas.end()) {
                        setOriClas.erase(delIt);
                    }
                }
                 set<Clause*> ::iterator delItGoal= saveGoalClaSet.find(cla);
                if (delItGoal != saveGoalClaSet.end()) {
                    saveGoalClaSet.erase(delItGoal);
                }
                set<Clause*> ::iterator delItNoPair = noPairSingleCla.find(cla);
                if (delItNoPair != noPairSingleCla.end()) {
                    noPairSingleCla.erase(delItNoPair);
                }
                set<Clause*> ::iterator delItSingleCla = setSingleCla.find(cla);
                if (delItSingleCla != setSingleCla.end()) {
                    setSingleCla.erase(delItSingleCla);
                }
                set<Clause*> ::iterator delItEqn = eqnDemod.find(cla);
                if (delItEqn != eqnDemod.end()) {
                    eqnDemod.erase(delItEqn);
                }
                continue;
            }
        }
        //cout<<"3"<<endl;
        if (!StrategyParam::orForCompition) {
            string time = to_string(double(clock() - start) / CLOCKS_PER_SEC);
            out = "# R" + to_string(cla_R.uClaId) + "删除子句" + to_string(uDelNum) + "条:" + out + " [用时]：" + time + " s";
            FileOp::LogOut(out);
        }
    }
    return uDelNum;
}

//定向冗余，删除指定的冗余子句
UINT16 Formula::BackwardSubsumpDirectSaturate(Clause& cla_R,Clause& cla_Del,vector<Clause*> saveCurrentCla)
{
    clock_t start = clock();
    string out;
    UINT16 uDelNum = 0;
    set<Clause*> vRundacyClas;
    Subsumption subsump;
    //string str;
   // cla_R.toString(str);
    //cout << "标准子句:" <<str << endl;
    //cout<<"0"<<endl;
    subsump.InstClaDirect(cla_R,cla_Del, vRundacyClas);
    //usleep(100);
    //set<Clause*>::iterator it;
    set<Clause*>::iterator it;
    set<Clause*>::iterator itE;
    set<Clause*>::iterator itDE;
    if (!vRundacyClas.empty()) {
        out += to_string(cla_R.uClaId) + "->";
        for (auto&cla : vRundacyClas) {
            //cout<<"1"<<endl;
            //cout<<vRundacyClas.size()<<endl;
            //cout<<"[CC" + to_string(cla->uClaId)  + "]"  << cla->LitPtr[0]->subTerm->ToString()<<endl;  
            //删除该子句
            if (find(saveCurrentCla.begin(), saveCurrentCla.end(), cla) != saveCurrentCla.end()) {
                for (UINT8 k = 0; k < saveCurrentCla.size(); ++k) {
                    if (cla == saveCurrentCla[k]) {
                        swap(saveCurrentCla[k], saveCurrentCla[saveCurrentCla.size() - 1]);
                        saveCurrentCla.pop_back();
                        break;
                    }
                }
            }
            ++uDelNum;
            out += to_string(cla->uClaId) + ',';
//            set<Clause*>::iterator it = setCla.find(cla);
//            //set<Clause*>::iterator itN = noPairSingleCla.find(cla);
//            //setCla.erase(it);
//            cla->DelLits();
//            delete(cla);
//            //(*it)->DelLits();
//            //delete(*it);
//            //cout<<"1"<<endl;
//            assert(it != setCla.end());
//            setCla.erase(it);
//            if (itN != noPairSingleCla.end())
//                noPairSingleCla.erase(itN);
            //如果存在 排序后集合同样需要删除
           //cout<<"2"<<endl;  
            /*
            if (cla->uClaId < uOrigClaSize + 1 && setOriClas.size() > 0) {
                set<Clause*> ::iterator delIt = setOriClas.find(cla);
                if (delIt != setOriClas.end()) {
                    setOriClas.erase(delIt);
                }
            }
            
           */
            //cla->DelLits();
            //delete(cla);
            //1. 是否在setCla中
            it = setCla.find(cla);
            itE = setEnq.find(cla);
            itDE = setDeductCla.find(cla);
            //set<Clause*>::iterator itN = noPairSingleCla.find(cla);
            //setCla.erase(it);
            if (it != setCla.end()) {
                (*it)->DelLits();
                delete(*it);
                setCla.erase(it);
                if (cla->uClaId < uOrigClaSize + 1 && setOriClas.size() > 0) {
                    set<Clause*> ::iterator delIt = setOriClas.find(cla);
                    if (delIt != setOriClas.end()) {
                        setOriClas.erase(delIt);
                    }
                }
                
                set<Clause*, claCmpPDeductNum> ::iterator delItNoPair = noPairSingleCla.find(cla);
                if (delItNoPair != noPairSingleCla.end()) {
                    noPairSingleCla.erase(delItNoPair);
                }
                
                set<Clause*> ::iterator delItGoal= saveGoalClaSet.find(cla);
                if (delItGoal != saveGoalClaSet.end()) {
                    saveGoalClaSet.erase(delItGoal);
                }
                
                set<Clause*> ::iterator delItSingleCla = setSingleCla.find(cla);
                if (delItSingleCla != setSingleCla.end()) {
                    setSingleCla.erase(delItSingleCla);
                }
                set<Clause*> ::iterator delItEqn = eqnDemod.find(cla);
                if (delItEqn != eqnDemod.end()) {
                    eqnDemod.erase(delItEqn);
                }
                continue;
            }
            else if(itE != setEnq.end()){
                (*itE)->DelLits();
                delete(*itE);
                setEnq.erase(itE);
                if (cla->uClaId < uOrigClaSize + 1 && setOriClas.size() > 0) {
                    set<Clause*> ::iterator delIt = setOriClas.find(cla);
                    if (delIt != setOriClas.end()) {
                        setOriClas.erase(delIt);
                    }
                }
                set<Clause*> ::iterator delItNoPair = noPairSingleCla.find(cla);
                if (delItNoPair != noPairSingleCla.end()) {
                    noPairSingleCla.erase(delItNoPair);
                }
                 set<Clause*> ::iterator delItGoal= saveGoalClaSet.find(cla);
                if (delItGoal != saveGoalClaSet.end()) {
                    saveGoalClaSet.erase(delItGoal);
                }
                set<Clause*> ::iterator delItSingleCla = setSingleCla.find(cla);
                if (delItSingleCla != setSingleCla.end()) {
                    setSingleCla.erase(delItSingleCla);
                }
                set<Clause*> ::iterator delItEqn = eqnDemod.find(cla);
                if (delItEqn != eqnDemod.end()) {
                    eqnDemod.erase(delItEqn);
                }
                continue;
            }
            else if(itDE != setDeductCla.end()){
                 (*itDE)->DelLits();
                delete(*itDE);
                setDeductCla.erase(itDE);
                if (cla->uClaId < uOrigClaSize + 1 && setOriClas.size() > 0) {
                    set<Clause*> ::iterator delIt = setOriClas.find(cla);
                    if (delIt != setOriClas.end()) {
                        setOriClas.erase(delIt);
                    }
                }
                 set<Clause*> ::iterator delItGoal= saveGoalClaSet.find(cla);
                if (delItGoal != saveGoalClaSet.end()) {
                    saveGoalClaSet.erase(delItGoal);
                }
                set<Clause*> ::iterator delItNoPair = noPairSingleCla.find(cla);
                if (delItNoPair != noPairSingleCla.end()) {
                    noPairSingleCla.erase(delItNoPair);
                }
                set<Clause*> ::iterator delItSingleCla = setSingleCla.find(cla);
                if (delItSingleCla != setSingleCla.end()) {
                    setSingleCla.erase(delItSingleCla);
                }
                set<Clause*> ::iterator delItEqn = eqnDemod.find(cla);
                if (delItEqn != eqnDemod.end()) {
                    eqnDemod.erase(delItEqn);
                }
                continue;
            }
        }
        //cout<<"3"<<endl;
        string time = to_string(double(clock() - start) / CLOCKS_PER_SEC);
        out = "# R" + to_string(cla_R.uClaId) + "删除子句" + to_string(uDelNum) + "条:" + out + " [用时]：" + time + " s";
        FileOp::LogOut(out);
    }
    return uDelNum;
}

set<Clause*>::iterator Formula::NextStartClause(Clause* newCla)
{
	/*return setClas.begin();*/
    /*过程△起步策略并排序,获取下轮△起步序号/
     *子句集加入preC并对整个子句集排序 //1、先对子句排序;2、将R插入最后；3、取起步行号
     *(0, "归结式起步");
     *(1, "最优子句起步");
     *(2, "未归结类最优子句起步");
     */
    Clause * claPtr(newCla);
    switch (StrategyParam::START_STRATEGY_OTHERTRI) {
            //0, "最优子句起步");
            //1, "归结式起步");
        case 0://最优子句起步
            //setClas.insert(claPtr);
            InsertCla(claPtr);
            return min_element(setCla.begin(), setCla.end(), SortRule::ClaCmp);
        case 1: //下一次归结从新归结子句开始						
            InsertCla(claPtr);
        default: //每次均从第一个子句起步
            InsertCla(claPtr);
            return setCla.begin();
    }
}

void Formula::InsertCla(Clause* newCla)
{
    for (UINT16 i = 0; i < newCla->uLitNum; ++i) {
        newCla->LitPtr[i]->AddPredLst();
    }
    return ;
}

extern int g_ConflictNum_HashTree;
void Formula::PrintSharedTerm()
{
   for (auto&t : g_HashTree) {
        t->termPtr->Print();
        cout << " :" << to_string(t->times) << endl;
    }
    cout << "总冲突次数：" << to_string(g_ConflictNum_HashTree);
}
void Formula::DelSubSet(UINT32 cla_id)
{
    set<Clause*>::iterator claP_it = setCla.begin();
    for (; claP_it != setCla.end();) {
        if ((*claP_it)->uClaId > cla_id) {
            (*claP_it)->DelLits();
            delete(*claP_it);
            claP_it = setCla.erase(claP_it);
        }
        else
            claP_it++;
    }
}
void Formula::DelSubSetSuper(UINT32 cla_id)
{
    set<Clause*>::iterator claP_it = eqnDemod.begin();
    for (; claP_it != eqnDemod.end();) {
        if ((*claP_it)->uClaId > cla_id) {
            (*claP_it)->DelLits();
            delete(*claP_it);
            claP_it = eqnDemod.erase(claP_it);
        }
        else
            claP_it++;
    }
}
void Formula::DelSet()
{
//    string out;
//    clock_t start = clock();
    set<Clause*>::iterator claP_itCom = setOriClasCom.begin();
    for (; claP_itCom != setOriClasCom.end();) {
        (*claP_itCom)->DelLits();
        delete(*claP_itCom);
        claP_itCom = setOriClasCom.erase(claP_itCom);
    }
    set<Clause*>::iterator claP_it = setCla.begin();
    for (; claP_it != setCla.end();) {
        (*claP_it)->DelLits();
        delete(*claP_it);
        claP_it = setCla.erase(claP_it);
    }
    claP_it = setEnq.begin();
    for (; claP_it != setEnq.end();) {
//        if((*claP_it)->uClaId == 12345){
//            cout<<"cf-debug"<<endl;
//        }
        (*claP_it)->DelLits();
        delete(*claP_it);
        claP_it = setEnq.erase(claP_it);
    }
    claP_it = setOriClas.begin();
    for (; claP_it != setOriClas.end();) {
//        (*claP_it)->DelLits();
//        delete(*claP_it);
        claP_it = setOriClas.erase(claP_it);
    }
//     string time = to_string(double(clock() - start) / CLOCKS_PER_SEC);
//    out += "#清除数据结构完成,[用时]:" + time + " s";
//    FileOp::LogOut(out);
    //cout<<"debug"<<endl;
}
//判断子句是否有单元子句可以合一
bool Formula::unitFindUintClaUnify(TriAlg& triAlg,Clause* givenCla) {
    if(givenCla->uLitNum > 1)
        return false;
    Literal* QLit = givenCla->LitPtr[0];
    vector<Term*> chgVarT;
    chgVarT.reserve(6);
    for (auto& aClap : setCla) {
        if(aClap->uLitNum > 1)
            continue;
        //20170215 需要好好思考判断，单元子句组合问题
        if (QLit->isPairPred(aClap->LitPtr[0]) && triAlg.unify.LitMgu(QLit, aClap->LitPtr[0], chgVarT)) {
            FileOp::CreateRunInfoFile(FileOp::runFileId);
            *FileOp::ofRealInfoOut << "从编号为" + to_string(givenCla->uClaId) + "子句开始构建三角形" << endl;
            triAlg.unify.WriteTriPath(QLit);
            //sleep(1);
            //"[C" + to_string(lit->Row()) + "_" + to_string(lit->Col()) + "]"
            //*FileOp::ofRealInfoOut <<"[C" + to_string(triAlg.vOnlyOutTri[j]->Row()) + "]" << triAlg.vOnlyOutTri[j]->subTerm->ToString()<<endl;     
            triAlg.unify.WriteTriPath(aClap->LitPtr[0]);
            //sleep(1);
            *FileOp::ofRealInfoOut << "R:空子句" << endl;
            FileOp::LogOut("# ==子句" + to_string(givenCla->uClaId) + "起步，结论正确(UNSAT)！");
            if(!StrategyParam::orForCompition && (StrategyParam::problemDiv == 0))
                cout << "得出结论:不可满足" << endl;
            triAlg.unify.ClearVarBind(chgVarT);
            return true;
        } else {
            triAlg.unify.ClearVarBind(chgVarT);
        }
    }
    triAlg.unify.ClearVarBind(chgVarT);
    vector<Term*>().swap(chgVarT);
    return false;
}
//20170917 存放每次选取的corrent集合,根据FIFO,子项的统计个数,目标具体选择incLen个的子句放入演绎集合saveCurrentClaSet中
RESULT Formula::chooseCurrentCLaSet(vector<Clause*>* saveCurrentClaSet,UINT32 incLen,TriAlg& triAlg,UINT32 startId, UINT32 endId,UINT32& uNewClaID){
    UINT32 fifoSize = incLen/3 ;
    UINT32 termCountSize = incLen/3;
    UINT32 goalDeepthSize = incLen - fifoSize-  termCountSize;
    vector<Clause*> fifoSet;
    fifoSet.reserve(6);
    map<UINT32, vector<Clause*>> termCountSet;
    map<UINT32, vector<Clause*>> goalDeepthSet;
    map<UINT32, vector<Clause*>>::iterator iter;
    set<Clause*>::iterator claP_it = setCla.begin();
    for (; claP_it != setCla.end();) {
        //判断互补对的单元子句
        if(((*claP_it)->uClaId >= startId && (*claP_it)->uClaId <= endId) && ((*claP_it)->uLitNum == 1) && unitFindUintClaUnify(triAlg,(*claP_it))){//表示得出结论了
            return UNSAT;
        }
        //20171029 判断新生成的子句是否是调解恒真和纯文字子句
        if((*claP_it)->uClaId >= startId && (*claP_it)->uClaId <= endId){
            if(triAlg.claHasPureLit(*this,(*claP_it)) || triAlg.judgeDemodRedundent(*this,(*claP_it),uNewClaID) ){
                string out = "#子句编号[" + to_string((*claP_it)->uClaId) + "]冗余被删除";
                FileOp::LogOut(out);
                (*claP_it)->DelLits();
                delete((*claP_it));
                claP_it = setCla.erase(claP_it);
                continue;
            }
        }
        //20171020 增加演绎深度限制
//        if((*claP_it)->deduceDeepth > StrategyParam::deduceDepth)
//        {
//            ++claP_it;
//            continue;
//        }
        if((*claP_it)->orgCla &&!(*claP_it)->isUse){
            fifoSet.push_back(*claP_it);
        }
        UINT32 termSum = (*claP_it)->countClaTermE(1,2);
        termCountSet[termSum].push_back(*claP_it);
        goalDeepthSet[(*claP_it)->goaldeepth].push_back(*claP_it);
        ++claP_it;
    }
    set<Clause*>::iterator claP_itE = setEnq.begin();
    for (; claP_itE != setEnq.end();) {
        if((*claP_itE)->isequEqn()){
            ++claP_itE;
            continue;
        }
        if((*claP_itE)->orgCla &&!(*claP_itE)->isUse){
            fifoSet.push_back(*claP_itE);
        }
        UINT32 termSum = (*claP_itE)->countClaTermE(1,2);
        termCountSet[termSum].push_back(*claP_itE);
        goalDeepthSet[(*claP_itE)->goaldeepth].push_back(*claP_itE);
        ++claP_itE;
    }
    //开始筛选
    stable_sort(fifoSet.begin(), fifoSet.end(), SortRule::noPairClaCmp);
    //开始选择子句到saveCurrentClaSet
    for(UINT32 i=0; i< fifoSet.size(); ++i){
        if(i == fifoSize)
            break;
         if (find(saveCurrentClaSet->begin(), saveCurrentClaSet->end(), (fifoSet[i])) == saveCurrentClaSet->end())
            saveCurrentClaSet->push_back(fifoSet[i]);
    }
    UINT32 count = 0;
    bool outFlag = false;
    for(iter = termCountSet.begin(); iter != termCountSet.end(); ++iter){
        for(UINT32 i=0; i< iter->second.size(); ++i){
            if (find(saveCurrentClaSet->begin(), saveCurrentClaSet->end(), (iter->second.at(i))) == saveCurrentClaSet->end()) {
                saveCurrentClaSet->push_back(iter->second.at(i));
                ++count;
            }
            if(count == termCountSize){
                outFlag = true;
                break;
            }
            
        }
        if(outFlag)
            break;
    }
    count = 0;
   outFlag = false;
    for(iter = goalDeepthSet.begin(); iter != goalDeepthSet.end(); ++iter){
        for(UINT32 i=0; i< iter->second.size(); ++i){
            if (find(saveCurrentClaSet->begin(), saveCurrentClaSet->end(), (iter->second.at(i))) == saveCurrentClaSet->end()) {
                saveCurrentClaSet->push_back(iter->second.at(i));
                ++count;
            }
            if(count == goalDeepthSize){
                outFlag = true;
                break;
            }
            
        }
        if(outFlag)
            break;
    }
    return fail;
}