/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   FileOp.h
 * Author: sjg
 *
 * Created on 2016年11月1日, 上午9:08
 */

#ifndef FILEOP_H
#define FILEOP_H
#include "Clause.h"
#include "Literal.h"
#include "Term.h"
#include "globalFunc.h"
#include "dataTypeDef.h"

class FileOp {
public:
    static FILETYPE fileType;//判断文件的文件类型tptp,fof,mydefine
    
    static string homePath;//得到系统的主目录
    static string strategyFile;//策略文件
    static int strategyFileSize;
    static int strategyMode;//得到自动模式
    static int runMode;
    
    static UINT32 runFileId;//run文件编号,保证每个run文件存放40个R  //*一个run文件就是存放演绎路径（一个R产生代表一个（小）三角形输出），至少每个run文件存放100个R
    static UINT32 outPutRCount;//记录输出多少个三角形   //*记录1个run文件输出多少个（小）三角形，runFileId迭代后，outPutRCount归零
    static string judgeOriginalFileFullName;    //原始问题路径（为格式转换前）
    static string judgeOriginalFileName;    //原始问题名称
    static string JudgeFileFullName; //判定文件完整名称（路径+后缀）     //比如 ~/dist/problems/AGT006+1.p 格式处理后变为 ~/dist/output/tptp/AGT006+1+short+eq_rstfp.tptp
    static string JudgeFileName; //判定文件名（有后缀） 格式处理后变为 AGT006+1+short+eq_rstfp.tptp
    static string JudgeFileFullNameNoExt; //无后缀判定文件完整名称  格式处理后变为 AGT006+1+short+eq_rstfp
    static string JudgeFileDir;	  //判定文件所在路径    格式处理后 ~/dist/output/tptp
    static string JudgeFileResult;	  //存放验证文件对应的判断结果
    //static string runPath;
    static ofstream *ofJudgeFileResult;//存放验证文件对应的文件指针
    static ofstream *ofJudgeAllFileResult;//存放所有验证文件对应的文件指针
    
    static ofstream *ofSingleEndUnitCla;
    static ofstream *ofNouseCla;
    static vector<string> StrategyfileName;
    static vector<string> StrategyCorrespondingFilePath;
    static map<Clause*, string> idMap;   //20210602  
    static INT32 runFileNum;
    static int maxIndex;    //20210602
    //static DIR* dir;
    FileOp();
    FileOp(const FileOp& orig);
    virtual ~FileOp();
    static void getTopPath(bool useVersion);//根据判定文件路径得到相关信息
    static RESULT AnalysisFileName(string str);//根据判定文件路径得到相关信息
    static bool isExistDir(string strDir);//判断文件是否存在
    static bool isExistProof(string strDir);
    static void CreateResultFile();//根据判定文件路径生成判定结果输出路径
    static bool CreateTotalOutputFile(bool parseTime);
    static string g_FileDir;	  //判定文件所在路径
    static string g_WorkDir; //后台数据输出路径
    static string g_PreFileFullName; //预处理文件		  //D:\ProverOutPut\RUNINFO\SX4\1.pre
    static string g_OutputPath;//运行日志存放完整路径
    static string appPath;//应用程序路径
    static string workSpace;//工作路径
    static string eOutputFile;  //20210520 E第一段运行后输出的文件
    static string eSecondOutputFile;  //20210526 E最后一段段运行后输出的文件
    static string OnlyRunEOutputFile; //20210530 只执行E，输出文件
    static ofstream *ofRealInfoOut; //实际输出流
    static ofstream *ofLogOut; //日志输出流
    static ofstream *ofPathOut; //输出归结路径
    static ofstream* ofOutput;
    static ofstream* ofProofComp;
    static ofstream* strategyRecord;
    //Liu
    static ofstream* ofDebugOut;    //调试时输出的信息输出流
    static string debugOutFile; //调试时输出的信息文件路径
    bool static CreateDebugOutFile();
    //创建/打开文件
    bool static CreateRunInfoFile(UINT32 StartId);
    bool static   CreateRunInfoFilePre(UINT32 StartId );
    static void PrintINFOEndRSinglePre(string& msg);
    static void PrintInfoCombinedClas(string& msg);
    static void PrintInfoCombinedClasForRun(string& msg);
    static void PrintInfoForEprover(string& msg);
    static void PrintINFONoUsePre(string& msg);
    bool static CreateLogFile();
    static string getFilePath(string &fileFullName);
    static string getFileName(string &fileFullName);
    static string getFileNameNoExt(string fileFullName);
    //释放文件读取流
    static void ReleaseOf();
    static void outReleaseOf();
    //对读取文件的路径和文件属性进行分析
    static RESULT FilePathAnaysis(const string& fileFullName);

    static void PrintINFORSinglePre(string& msg);
    static void PrintINFORSinglePreAfter(string& msg);
    static void PrintINFORPre(string& msg);
    static void PrintINFORPreAfter(string& msg);
    static void LogOut(const string& msg);
    static void PrintINFO(string&msg);
    static void WritePreFile(const string& str);
    static void RInvaildInfoOut(string& rundMsg, INT32 StartId);
    static void RInvaildInfoOutPath(string& rundMsg, INT32 StartId);
    //输出运行时记录-.run
    //strOptTris 用来判定是否路径中存在 基文字 -- 逆向演绎（分解）使用
    static void RunInfoOut(vector<Literal*>&vOptTri, Clause* newCla, INT32 StartId, vector<string>*strOptTris);

    static void WriteTriPath(string& str);
    static void WriteR(Clause*newCla);
    static void OperDir(string src,vector<string>* fileName );
    static bool isFileEmpty(string filePath);
    static void OperStrategy(string src,vector<string>* fileName);
    static void readCorrespondingStrategy(string src,vector<string>* fileName);
    static void packageCorrespondingStrategyAndSaveBinary(string src, vector<string>* fileName);
    static void packageCorrespondingStrategyAndCheck(string src);
    static bool findPackageCorrespondingStrategy(string src, string searchCorrespondingStrategies);
    static void findCorrespondingStrategy(string src, string searchCorrespondingStrategies);
    static void setSingleCorrespondingStrategy(string str);
    static int strategyFileSizeFunc(string src);
    static string findStrategy(string path, int len);//根据下标找到策略的绝对路径
    static string findStrategyTptp(string path, int len);
    static void delRes();//删除判定文件夹下的run和path文件
    static void delRunFiles();
    static void delAllFiles();
    static void delAllFilesComplete(string filePath);
    static long getMem();
    static void getRes(int res[3]);
    static void insertInfo(string str,double time,UINT32 triTotalTimes);
    static void copyAndDelOrgFile(string orgFile, string theoremFormat);
    static void convertCombinedClaFormat();
    static string convertCombinedLitFormat(string& str);
    static void convertInputOfEprover();    //20210521 将.res文件中子句（即为第二次调用E的输入子句）转换成CNF格式
    //20170220 读策略文件静态函数
    static void readStrategy();
    static void readBatchStrategy(string path);
    static void readStrategyN(int n);
    static void readStrategyNTptp(int n);
    static string getStrategyNTptp(int n);
    static void clearRes();
    static bool delCreateRunInfoFile(UINT32 StartId );
    static void PrintINFOEndRSinglePreNoUse(string& msg);
    static void prinfResForE(string& msg);
    static void prinfPreResForE(string& msg);
    static void PrintStatisticsMsg(const string& msg);  //20210530  打印proofStatistics.txt中的信息
    static bool OutputForCompetition(const string& outputFile, double& executeTime, string& outMsg);    //20210601 读取E的输出文件，并打印
    static bool SecondRunEprover(const double runTime, const string& cnfFile); //20210602 第二次调用E
private:

};

#endif /* FILEOP_H */

