/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   FileOp.cpp
 * Author: sjg
 * 该类用于所有的文件操作
 * Created on 2016年11月1日, 上午9:08
 */
#include <sys/types.h>
#include <dirent.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <string.h>
#include "FileOp.h"
#include "dataTypeDef.h"
#include "globalFunc.h"
#include "StrategyParam.h"
#include "SocketOp.h"



FileOp::FileOp() {
}

FileOp::FileOp(const FileOp& orig) {
}

FileOp::~FileOp() {
}
string FileOp::homePath;//得到系统的主目录
string FileOp::strategyFile;//得到自动模式运行的策略文件
int FileOp::strategyFileSize = 0;
int FileOp::strategyMode;//得到自动模式
int FileOp::runMode;//运行模式

UINT32 FileOp::runFileId = 0;//run文件编号,保证每个run文件存放40个R	//*一个run文件就是存放演绎路径（一个R产生代表一个（小）三角形输出），至少每个run文件存放100个R
UINT32 FileOp::outPutRCount = 0;//记录输出多少个三角形	//*记录1个run文件输出多少个（小）三角形，runFileId迭代后，outPutRCount归零
string FileOp::judgeOriginalFileFullName;//original file    //原始问题路径（为格式转换前）
string FileOp::judgeOriginalFileName;//original file name   //原始问题名称
string FileOp::JudgeFileFullName; //判定文件完整名称（路径+后缀）   //比如 ~/dist/problems/AGT006+1.p 格式处理后变为 ~/dist/output/tptp/AGT006+1+short+eq_rstfp.tptp
string FileOp::JudgeFileName; //判定文件名（有后缀） 格式处理后变为 AGT006+1+short+eq_rstfp.tptp
string FileOp::JudgeFileFullNameNoExt; //无后缀判定文件完整名称 格式处理后变为 AGT006+1+short+eq_rstfp
string FileOp::JudgeFileDir;	  //判定文件所在路径    格式处理后 ~/dist/output/tptp
string FileOp::JudgeFileResult;//存放验证文件对应的判断结果
FILETYPE FileOp::fileType = MYDefine;//判断文件初始为MYDefine
ofstream *FileOp::ofJudgeFileResult;//存放验证文件对应的文件指针
ofstream *FileOp::ofJudgeAllFileResult;//存放所有验证文件对应的文件指针

ofstream *FileOp::ofSingleEndUnitCla = NULL;
ofstream *FileOp::ofNouseCla = NULL;
vector<string> FileOp::StrategyfileName;
vector<string> FileOp::StrategyCorrespondingFilePath;
//DIR* FileOp::dir = nullptr;

string FileOp::g_FileDir = "";	  //判定文件所在路径
string FileOp::g_WorkDir = "";	//后台数据输出路径  ~/dist/output
string FileOp::g_PreFileFullName = ""; //预处理文件		  //D:\ProverOutPut\RUNINFO\SX4\1.pre   格式处理后 ~/dist/output/AGT006+1+short+eq_rstfp.pre
string FileOp::g_OutputPath = "";//运行日志存放完整路径  格式处理后 ~/dist/output/AGT006+1+short+eq_rstfp
string FileOp::appPath = "";//应用程序路径
string FileOp::workSpace = "";//工作路径    //* 即output路径
string FileOp::eOutputFile = "";  //20210520 E第一段运行后输出的文件
string FileOp::eSecondOutputFile = "";  //20210526 E最后一段段运行后输出的文件
string FileOp::OnlyRunEOutputFile = ""; //20210530 只执行E，输出文件

ofstream* FileOp::ofRealInfoOut = NULL;	//实际输出流	//*.run文件路径
ofstream* FileOp::ofLogOut = NULL;		//日志输出流 .log文件，记录冗余子句删除的信息
ofstream* FileOp::ofPathOut = NULL;		//* .path文件路径

ofstream* FileOp::ofOutput = nullptr;   //*.out文件，保存产生的子句，用cnf(...,plain,...)形式
ofstream* FileOp::ofProofComp = nullptr;    //输出proofStatistics.txt文件的输出流
ofstream* FileOp::strategyRecord = nullptr;

INT32 FileOp::runFileNum = 0;
int FileOp::maxIndex = 0;    //20210602
map<Clause*, string> FileOp::idMap;   //20210602

//Liu
ofstream* FileOp::ofDebugOut = nullptr;    //调试时输出的信息输出流
bool FileOp::CreateDebugOutFile() {
    string debugOutFile = FileOp::g_WorkDir + "/debugMsg.txt";
    
    try {
        if(ofDebugOut){
            if(ofDebugOut->is_open()) {
                ofDebugOut->close();
                ofDebugOut = nullptr; 
            }
        }
        
        ofDebugOut = new ofstream(debugOutFile, ios::app);
        return true;
    } catch (exception* e) {
        return false;
    }
}

void FileOp::getTopPath(bool useVersion){
    if(useVersion){
        char* path;
        path = getenv("HOME");
        string pathGet(path);
        homePath = pathGet;
        strategyFile= appPath + "/strategy";
    }
    else {
        char* path;
        path = getenv("HOME");
        string pathGet(path);
        homePath = pathGet;
        strategyFile= homePath + "/Desktop/strategy";
    }
}
RESULT FileOp::AnalysisFileName(string FilePath)
{
    size_t pos = FilePath.find_last_of('/');
    if (pos == -1)
        return READERR;
    else {
        JudgeFileFullName = FilePath;//判断文件的绝对路径
        JudgeFileDir = FilePath.substr(0, pos);//判断文件的存放路径
        JudgeFileName = FilePath.substr(pos + 1);//判断文件名
        size_t posEnd = JudgeFileName.find_last_of('.');
        JudgeFileFullNameNoExt = JudgeFileName.substr(0, posEnd); //判断文件（不含格式名）
        string suffix=JudgeFileName.substr(posEnd+1);//判断文件的格式
        //设置文件类型
        if (suffix == "tptp" || suffix == "TPTP") {
            fileType = TPTP;
        } else if (suffix == "fof" || suffix == "FOF") {
            fileType = FOF;
        } else {
            fileType = MYDefine;
        }
        //JudgeFileResult =homePath + "/Desktop/output";//输出文件存放文件夹
        //if(StrategyParam::orForCompition)
        JudgeFileResult = FileOp::workSpace;
        //初始化输出路径
        //g_WorkDir =homePath + "/Desktop/output";//工作路径
        //if(StrategyParam::orForCompition)
        g_WorkDir = FileOp::workSpace;
        g_OutputPath = g_WorkDir + "/" + JudgeFileFullNameNoExt;//判断文件的输出文件夹
        g_PreFileFullName = g_OutputPath + "/" + JudgeFileFullNameNoExt + ".pre";//判断文件的预处理文件名
        //若问题输出文件夹存在，清空文件夹
        DIR* dir;
        if((dir = opendir(g_OutputPath.c_str())) != nullptr)
            delAllFilesComplete(g_OutputPath);
        
        if (!isExistDir(g_OutputPath))
            return ERR_OUTFOLDER;
        if (StrategyParam::orForCompition == false) {
            if (!CreateLogFile())
                return ERR_OUTFOLDER;
        }
        //if(StrategyParam::orForCompition)
        CreateTotalOutputFile(false);
        return READOK;
    }
}
//创建判定文件输出路径
void FileOp::CreateResultFile()
{
    string strLogPath = FileOp::JudgeFileResult+ "/" + FileOp::JudgeFileFullNameNoExt + ".log";
    
    //cout<<strLogPath<<endl;
    try {
        ofJudgeFileResult = new ofstream(strLogPath.c_str(),ios::out);
        
        //*ofJudgeFileResult<<"I am running"<<endl;
        return;
    } catch (exception* e) {
        cout << "运行信息输出错误" << e->what()<< endl;
    }
}
bool FileOp::CreateRunInfoFile(UINT32 StartId )
{
    string runId = to_string(StartId);
    if(runId.length() == 1){
        runId = "000" + runId;
    }
    else if(runId.length() == 2){
        runId = "00" + runId;
    }
    else if(runId.length() == 3){
        runId = "0" + runId;
    }
    string strOutRunPath = g_OutputPath + "/" + JudgeFileFullNameNoExt + "_C" + runId + "_P1.run";
    string strPath = g_OutputPath + "/" + JudgeFileFullNameNoExt + "_C" + runId + "_P1.path";
    
    try {
        if(ofRealInfoOut){
            if(ofRealInfoOut->is_open()) {
                ofRealInfoOut->close();
                ofRealInfoOut = nullptr; 
            }
        }
        if(ofPathOut) {
            if (ofPathOut->is_open()) {
                ofPathOut->close();
                ofPathOut = nullptr;
            }
        }
        
        ofRealInfoOut = new ofstream(strOutRunPath, ios::app);
        //*ofRealInfoOut<<"从编号为"+to_string(StartId)+"子句开始构建三角形"<<endl;
        ofPathOut = new ofstream(strPath, ios::app);
        return true;
    } catch (exception* e) {
        //string errInfo = e->what();
        //printlo(errInfo);
        return false;
    }
}
bool FileOp::delCreateRunInfoFile(UINT32 StartId )
{
    string runId = to_string(StartId);
    if(runId.length() == 1){
        runId = "000" + runId;
    }
    else if(runId.length() == 2){
        runId = "00" + runId;
    }
    else if(runId.length() == 3){
        runId = "0" + runId;
    }
    string strOutRunPath = g_OutputPath + "/" + JudgeFileFullNameNoExt + "_C" + runId + "_P1.run";
    string strPath = g_OutputPath + "/" + JudgeFileFullNameNoExt + "_C" + runId + "_P1.path";
    
    try {
        FILE* fp;
        char ch;
        if((fp = fopen(strOutRunPath.c_str(),"r")) != NULL){
            fseek(fp,0,SEEK_SET);
            ch = fgetc(fp);
            if(ch == EOF){
                fclose(fp);
                remove(strOutRunPath.c_str());
            }
            else
                fclose(fp);
        }
        if((fp = fopen(strPath.c_str(),"r")) != NULL){
            fseek(fp,0,SEEK_SET);
            ch = fgetc(fp);
            if(ch == EOF){
                fclose(fp);
                remove(strPath.c_str());
            }
            else
                fclose(fp);
        }
        return true;
    } catch (exception* e) {
        //string errInfo = e->what();
        //printlo(errInfo);
        return false;
    }
}
//输出预处理的演绎路径
bool FileOp::CreateRunInfoFilePre(UINT32 StartId )
{
    string strOutRunPath = g_OutputPath + "/" + JudgeFileFullNameNoExt + "_C" + to_string(StartId) + "_Pre.run";
    string strPath = g_OutputPath + "/" + JudgeFileFullNameNoExt + "_C" + to_string(StartId) + "_Pre.path";
    
    try {
        ofRealInfoOut = new ofstream(strOutRunPath, ios::app);
        //*ofRealInfoOut<<"从编号为"+to_string(StartId)+"子句开始构建三角形"<<endl;
        ofPathOut = new ofstream(strPath, ios::app);
        return true;
    } catch (exception* e) {
        //string errInfo = e->what();
        //printlo(errInfo);
        return false;
    }
}

//输出归结路径strLogPath 存放日志信息，strLog存放判定结果统计
bool FileOp::CreateLogFile()
{
    string strLogPath = g_OutputPath + "/" + JudgeFileFullNameNoExt + ".log";
    string strLog = "";
    if(StrategyParam::orForCompition == false)
        strLog = FileOp::appPath + "/proofRes.txt";
    try {
        ofLogOut = new ofstream(strLogPath, ios::out);
        ofJudgeAllFileResult = new ofstream(strLog.c_str(),ios::app);
        return true;
    } catch (exception* e) {
        //string errInfo = e->what();
        //PrintErr(errInfo);
        return false;
    }
}

//输出归结路径strLogPath 存放日志信息，strLog存放判定结果统计
bool FileOp::CreateTotalOutputFile(bool parseTime)
{
    if(parseTime){
        JudgeFileResult = FileOp::workSpace;
        g_OutputPath = FileOp::workSpace;
    }
    string strOutput = g_OutputPath + "/" + JudgeFileFullNameNoExt + ".out";
    //string strProofComp = JudgeFileResult + "/proofStatistics.txt";
    try {
        ofOutput = new ofstream(strOutput, ios::out);
        //ofProofComp = new ofstream(strProofComp.c_str(),ios::app);
        return true;
    } catch (exception* e) {
        //string errInfo = e->what();
        //PrintErr(errInfo);
        return false;
    }
}

//输入文件完整路径包括文件名，输出文件路径（不包括文件名）
string FileOp::getFilePath(string &fileFullName)
{
    size_t pos = fileFullName.find_last_of('/');
    if (pos == -1)
        return fileFullName;
    return fileFullName.substr(0, pos);
}
//获取带后缀的文件名
string FileOp::getFileName(string &fileFullName)
{
    size_t pos = fileFullName.find_last_of('/');
    if (pos == -1)
        return fileFullName;
    return fileFullName.substr(pos + 1);
}
//获取不带扩展名的文件名
string FileOp::getFileNameNoExt(string fileFullName)
{
    size_t posBeg = fileFullName.find_last_of('/');
    size_t posEnd = fileFullName.find_last_of('.');
    if (posEnd == -1)
        return fileFullName.substr(posBeg + 1);
    return fileFullName.substr(posBeg + 1, posEnd - posBeg);
}
//释放三角形输出的文件流

void FileOp::outReleaseOf(){
    if (ofRealInfoOut) {
        ofRealInfoOut->close();
        ofRealInfoOut = NULL;
    }
    if (ofPathOut) {
        ofPathOut->close();
        ofPathOut = NULL;
    }
}
//释放文件读取流
void FileOp::ReleaseOf()
{
    if (ofRealInfoOut) {
        ofRealInfoOut->close();
        ofRealInfoOut = NULL;
    }
    if (ofLogOut) {
        ofLogOut->close();
        ofLogOut = NULL;
    }
    if (ofPathOut) {
        ofPathOut->close();
        ofPathOut = NULL;
    }
    if (ofJudgeAllFileResult) {
        ofJudgeAllFileResult->close();
        ofJudgeAllFileResult = NULL;
    }
    if (StrategyParam::orForCompition) {
        if (ofOutput) {
            ofOutput->close();
            ofOutput = NULL;
        }
        if (ofProofComp) {
            ofProofComp->close();
            ofProofComp = NULL;
        }
    }
    FileOp::StrategyfileName.clear();
    vector<string>().swap(FileOp::StrategyfileName);
//    if(dir)
//        closedir(dir);
}
//20170315 输出最后的单元子句
void FileOp::PrintINFOEndRSinglePre(string& msg)
{
    //输出FOL  ofJudgeAllFileResult = new ofstream(strLog.c_str(),ios::app);
    
//    string strInfoPath = g_OutputPath + "/" + JudgeFileFullNameNoExt + ".erspre";
//    ofSingleEndUnitCla = new ofstream(strInfoPath, ios::out);
//    *ofSingleEndUnitCla << msg << endl;
//    ofSingleEndUnitCla->flush();
//    ofSingleEndUnitCla->close();
    
    string strInfoPath = g_OutputPath + "/" + JudgeFileFullNameNoExt + ".res";
//    int fd = open(strInfoPath.c_str(),O_RDWR|O_CREAT,0664);
//    if( fd == -1){
//        printf("message:%s\n",strerror(errno));
//        return;
//    }
//    else{
//        write(fd,msg.c_str(),strlen(msg.c_str()));
//        close(fd);
//    }
    ofstream ofInfoStream(strInfoPath, ios::out);
    //if(ofInfoStream.is_open()){
        ofInfoStream << msg << endl;
        ofInfoStream.close();
   // }
//    else{
//        char* clauseSet = strtok(msg.c_str(),"\n");
//        FILE* fp;
//        fp = fopen(strInfoPath.c_str(),"w+");
//        if(fp != nullptr){
//            fputs(msg.c_str(),fp);
//        }
//        fclose(fp);
//    }
    
}

//输出子句格式,用于结合使用
void FileOp::PrintInfoCombinedClas(string& msg)
{  
    string strInfoPath = g_OutputPath + "/" + JudgeFileFullNameNoExt + ".combinedRes";
    ofstream ofInfoStream(strInfoPath, ios::out);
    ofInfoStream << msg << endl;
    ofInfoStream.close();
}

void FileOp::PrintInfoCombinedClasForRun(string& msg)
{  
    string strInfoPath = g_OutputPath + "/" + JudgeFileFullNameNoExt + ".combinedResForRun";
    ofstream ofInfoStream(strInfoPath, ios::out);
    ofInfoStream << msg << endl;
    ofInfoStream.close();
}

//20210521 Liu 将.res文件中转换好的子句（即为第二次调用E的输入子句）打印到.cnf文件中
void FileOp::PrintInfoForEprover(string& msg) {
    string strInfoPath = g_OutputPath + "/" + JudgeFileFullNameNoExt + ".cnf";
    ofstream ofInfoStream(strInfoPath, ios::out | ios::app);
    ofInfoStream << msg << endl;
    ofInfoStream.close();    
}

//20170315 输出最后的单元子句
void FileOp::prinfResForE(string& msg)
{
    string strInfoPath = g_OutputPath + "/" + JudgeFileFullNameNoExt + ".res";
    ofstream ofInfoStream(strInfoPath, ios::app);
    ofInfoStream << msg << endl;
    ofInfoStream.close(); 
}

void FileOp::prinfPreResForE(string& msg)
{
    string strInfoPath = g_OutputPath + "/" + JudgeFileFullNameNoExt + ".res";
    ofstream ofInfoStream(strInfoPath, ios::app);
    ofInfoStream << msg;
    ofInfoStream.close(); 
}

void FileOp::PrintINFOEndRSinglePreNoUse(string& msg)
{
    //输出FOL  ofJudgeAllFileResult = new ofstream(strLog.c_str(),ios::app);
    
//    string strInfoPath = g_OutputPath + "/" + JudgeFileFullNameNoExt + ".erspre";
//    ofSingleEndUnitCla = new ofstream(strInfoPath, ios::out);
//    *ofSingleEndUnitCla << msg << endl;
//    ofSingleEndUnitCla->flush();
//    ofSingleEndUnitCla->close();
    
    string strInfoPath = g_OutputPath + "/" + JudgeFileFullNameNoExt + ".nouse";
    ofstream ofInfoStream(strInfoPath, ios::out);
    ofInfoStream << msg << endl;
    ofInfoStream.close();
}
void FileOp::PrintINFONoUsePre(string& msg)
{
    //输出FOL
//    string strInfoPath = g_OutputPath + "/" + JudgeFileFullNameNoExt + ".nousepre";
//    ofNouseCla = new ofstream(strInfoPath, ios::out);
//    *ofNouseCla << msg << endl;
//    ofNouseCla->flush();
//    ofNouseCla->close();
    
    string strInfoPath = g_OutputPath + "/" + JudgeFileFullNameNoExt + ".nousepre";
    ofstream ofInfoStream(strInfoPath, ios::out);
    ofInfoStream << msg << endl;
    ofInfoStream.close();
}

RESULT FileOp::FilePathAnaysis(const string& fileFullName)
{
    return Succes;
}

//判定文件\目录是否存在,若创建失败则返回false
bool FileOp::isExistDir(string strDir) {
    DIR *mydir = opendir(strDir.c_str());
    if (mydir) {
        closedir(mydir);
        return true;
    } else {
        int ret = mkdir(strDir.c_str(),0777);
        if (ret != 0) {
            cout<<"mkdir fail: " << strDir << "\n";
            return false;
        } else 
            return true;
    }
}

bool FileOp::isExistProof(string strDir)
{
//    DIR *mydir = NULL;
//    if((mydir = opendir(strDir.c_str()))==NULL)
//    {
//        return false;
//    }
//    else{
//        closedir(mydir);
//        return true;
//    }
    struct dirent* ptr;
    //if(dir == nullptr)
    DIR* dir = opendir(g_OutputPath.c_str());
    if(dir == nullptr){
        return false;
    }
    rewinddir(dir);
    while ((ptr = readdir(dir)) != NULL) {
        string name(ptr->d_name);
        string fileName = g_OutputPath + "/" + name;
        size_t posEnd = name.find_last_of(".");
        string suffix = name.substr(posEnd + 1);
        if (suffix == "path" || suffix == "run") {
            name = "";
            fileName = "";
            closedir(dir);
            return true;
        }        
        name = "";
        fileName = "";
    }
    closedir(dir);
    return false;
}


void FileOp::LogOut(const string& msg)
{
    if (!ofLogOut)
        CreateLogFile();
    try {
        *ofLogOut << msg << endl;
    } catch (exception* e) {
        string errInfo = e->what();
        *ofLogOut << errInfo << endl;
    }
}

void FileOp::PrintINFO(string& msg)
{
    //输出FOL
    string strInfoPath = g_OutputPath + "/" + JudgeFileFullNameNoExt + ".info";
    ofstream ofInfoStream(strInfoPath, ios::app);
    ofInfoStream << msg << endl;
    ofInfoStream.close();
}

void FileOp::PrintINFORPre(string& msg)
{
    //输出FOL
    string strInfoPath = g_OutputPath + "/" + JudgeFileFullNameNoExt + ".rpre";
    ofstream ofInfoStream(strInfoPath, ios::out);
    ofInfoStream << msg << endl;
    ofInfoStream.close();
}

void FileOp::PrintINFORPreAfter(string& msg)
{
    //输出FOL
    string strInfoPath = g_OutputPath + "/" + JudgeFileFullNameNoExt + ".rapre";
    ofstream ofInfoStream(strInfoPath, ios::out);
    ofInfoStream << msg << endl;
    ofInfoStream.close();
}

void FileOp::PrintINFORSinglePre(string& msg)
{
    //输出FOL
    string strInfoPath = g_OutputPath + "/" + JudgeFileFullNameNoExt + ".rspre";
    ofstream ofInfoStream(strInfoPath, ios::out);
    ofInfoStream << msg << endl;
    ofInfoStream.close();
}

void FileOp::PrintINFORSinglePreAfter(string& msg)
{
    //输出FOL
    string strInfoPath = g_OutputPath + "/" + JudgeFileFullNameNoExt + ".raspre";
    ofstream ofInfoStream(strInfoPath, ios::out);
    ofInfoStream << msg << endl;
    ofInfoStream.close();
}
void FileOp::WritePreFile(const string& str)
{
    //输出预处理后文件
    ofstream ofInfoStream(g_PreFileFullName, ios::out);
    ofInfoStream << str << endl;
    ofInfoStream.close();
}

void FileOp::RInvaildInfoOut(string& rundMsg, INT32 StartId)
{
    try {
        if (!ofRealInfoOut)
            CreateRunInfoFile(StartId);
        *ofRealInfoOut << rundMsg << endl;
        *ofPathOut << rundMsg << endl;
        ofRealInfoOut->flush();
    } catch (exception* e) {
        *ofRealInfoOut << "R冗余信息输出错误！" << e->what() << endl;
    }
}
void FileOp::RInvaildInfoOutPath(string& rundMsg, INT32 StartId)
{
    try {
        if (!ofPathOut)
            CreateRunInfoFile(StartId);
        //*ofRealInfoOut << rundMsg << endl;
        *ofPathOut << rundMsg << endl;
        ofPathOut->flush();
    } catch (exception* e) {
        *ofPathOut << "R冗余信息输出错误！" << e->what() << endl;
    }
}
//输出运行时记录-.run
void FileOp::RunInfoOut(vector<Literal*>& vOptTri, Clause* newCla, INT32 StartId, vector<string>* strOptTris)
{
	try {
        if (!ofRealInfoOut)
            CreateRunInfoFile(StartId);
        string strTmpMsg_P;
        vector<Literal*>::iterator vLitIt;
        for (vLitIt = vOptTri.begin(); vLitIt < vOptTri.end(); ++vLitIt) {
            if (strOptTris) {
                strOptTris->push_back("[C" + to_string((*vLitIt)->Row()) + "_" + to_string((*vLitIt)->Col()) + "]" + (*vLitIt)->subTerm->ToString());
                strTmpMsg_P += strOptTris->back() + "\n";
                *ofPathOut << "[C" << (*vLitIt)->Row() << "_" << to_string((*vLitIt)->Col()) << "]-";
                ++vLitIt;
                strOptTris->push_back("[C" + to_string((*vLitIt)->Row()) + "_" + to_string((*vLitIt)->Col()) + "]" + (*vLitIt)->subTerm->ToString());
                strTmpMsg_P += strOptTris->back() + "\n";
                *ofPathOut << "[C" << (*vLitIt)->Row() << "_" << to_string((*vLitIt)->Col()) << "]-";

            } else {
                strTmpMsg_P += "[C" + to_string((*vLitIt)->Row()) + "_" + to_string((*vLitIt)->Col()) + "]" + (*vLitIt)->subTerm->ToString() + "\n";
                *ofPathOut << "[C" << (*vLitIt)->Row() << "_" << to_string((*vLitIt)->Col()) << "]-";

                ++vLitIt;
                strTmpMsg_P += "[C" + to_string((*vLitIt)->Row()) + "_" + to_string((*vLitIt)->Col()) + "]" + (*vLitIt)->subTerm->ToString() + "\n";
                *ofPathOut << "[C" << (*vLitIt)->Row() << "_" << to_string((*vLitIt)->Col()) << "]-";
            }
        }

        //输出R
        if (newCla) {
            strTmpMsg_P += "R[" + to_string(newCla->uClaId) + "]:";
            for (UINT16 i = 0; i < newCla->uLitNum; ++i)/*"("+to_string(r->maxFuncLayer)+")*/ {
                Literal*lit = newCla->LitPtr[i];
                strTmpMsg_P += "[" + to_string(lit->ParentLitRow()) + "_" + to_string(lit->ParentLitCol()) + "]" + lit->subTerm->ToString() + "+";
            }
            string strPrint = strTmpMsg_P.erase(strTmpMsg_P.size() - 1);
            *ofRealInfoOut << strPrint;
        } else {
            strTmpMsg_P += "R:空子句";
            *ofRealInfoOut << strTmpMsg_P << endl;
            ofRealInfoOut->flush();
        }
    } catch (exception* e) {
        *ofRealInfoOut << "运行信息输出错误" << e->what() << endl;
        //ofRealInfoOut.close();
    }
}

void FileOp::WriteTriPath(string& str) {
    if (!ofRealInfoOut) {
        assert(ofRealInfoOut);
        cout << "运行信息输出错误未创建" << endl;
    }
    try {
        *ofRealInfoOut << str << endl;
    } catch (exception* e) {
        cout << "运行信息输出错误" << e->what() << endl;
        //ofRealInfoOut.close();
    }
}

void FileOp::WriteR(Clause* newCla) {    
    //输出R
    ++FileOp::outPutRCount;
    if(FileOp::outPutRCount > 100){
        ++FileOp::runFileId;
        FileOp::outPutRCount = 0;
    }
    if (newCla) {
        string strPrint = "R[" + to_string(newCla->uClaId) + "]:";
        for (UINT16 i = 0; i < newCla->uLitNum; ++i)/*"("+to_string(r->maxFuncLayer)+")*/ {
            Literal*lit = newCla->LitPtr[i];
            strPrint += "[" + to_string(lit->ParentLitRow()) + "_" + to_string(lit->ParentLitCol()) + "]" + lit->subTerm->ToString() + "+"; 
            //strPrint += "[" + to_string(lit->ParentLitRow()) + "_" + to_string(lit->ParentLitCol()) + "]" + lit->subTerm->ToStringBind() + "+"; //LiuDebug
            //strPrint += "[" + to_string(lit->ParentLitRow()) + "_" + to_string(lit->ParentLitCol()) + "]" + lit->subTerm->ToStringBind() + "+";
            //测试
            //if (lit->isDel)strPrint += "%Del%";
        }
        strPrint = strPrint.erase(strPrint.size() - 1);
        *ofRealInfoOut << strPrint;
    } else {
        *ofRealInfoOut << "R:空子句" << endl;
    }
    ofRealInfoOut->flush();
}
//读取目录的所有的文件夹
void FileOp::OperDir(string src,vector<string>* fileName)
{
    DIR* dir;
    struct dirent* ptr;
    UINT16 i=0;
    dir = opendir(src.c_str());
    if(dir == nullptr){
        return;
    }
    while ((ptr = readdir(dir)) != NULL) {
        string name(ptr->d_name);
        size_t posEnd = name.find_last_of(".");
        string suffix = name.substr(posEnd + 1);
        if (suffix == "tptp" || suffix == "TPTP" || suffix == "txt"|| suffix == "p"|| suffix == "P") {
            fileName->push_back(name);
            //cout<<src + name<<endl;
            if (++i >= 30000)
                break;
        }
    }
    closedir(dir);
}
void FileOp::delRes(){
    //g_OutputPath
    //DIR* dir;
    struct dirent* ptr;
    //if(dir == nullptr)
    DIR* dir = opendir(g_OutputPath.c_str());
    if(dir == nullptr){
        return;
    }
    rewinddir(dir);
    while ((ptr = readdir(dir)) != NULL) {
        string name(ptr->d_name);
        
        size_t posEnd = name.find_last_of(".");
        string suffix = name.substr(posEnd + 1);
        
        if (suffix == "path" || suffix == "run") {
            size_t signStart = name.find_last_of("_");
            string preGenStr = name.substr(signStart+1,posEnd);
            if(preGenStr != "Pre"){
                string fileName = g_OutputPath + "/" + name;
                remove(fileName.c_str());
            }
        }
        name = "";
    }
    closedir(dir);
    
}

//delete run files
void FileOp::delRunFiles(){
    //g_OutputPath
    //DIR* dir;
    struct dirent* ptr;
    //if(dir == nullptr)
    DIR* dir = opendir(g_OutputPath.c_str());
    if(dir == nullptr){
        return;
    }
    rewinddir(dir);
    while ((ptr = readdir(dir)) != NULL) {
        string name(ptr->d_name);
        string fileName = g_OutputPath + "/" + name;
        size_t posEnd = name.find_last_of(".");
        string suffix = name.substr(posEnd + 1);
        if (suffix == "path" || suffix == "run") {
            remove(fileName.c_str());
            name = "";
            fileName = "";
            continue;
        }        
        name = "";
        fileName = "";
    }
    closedir(dir);
}

//删除文件夹所有的文件
void FileOp::delAllFiles(){
    //g_OutputPath
    //DIR* dir;
    struct dirent* ptr;
    //if(dir == nullptr)
    DIR* dir = opendir(g_OutputPath.c_str());
    if(dir == nullptr){
        return;
    }
    rewinddir(dir);
    while ((ptr = readdir(dir)) != NULL) {
        string name(ptr->d_name);
        string fileName = g_OutputPath + "/" + name;
        if(StrategyParam::preprocess) {
            size_t posEnd = name.find_last_of(".");
            string suffix = name.substr(posEnd + 1);
            if (suffix == "info" || suffix == "res" || suffix == "log") {
                name = "";
                fileName = "";
                continue;
            }
        }
        else if(StrategyParam::useCombinedSys != 0) {
            size_t posEnd = name.find_last_of(".");
            string suffix = name.substr(posEnd + 1);
             if (suffix == "info" || suffix == "res" || suffix == "run"){
                 name = "";
                fileName = "";
                 continue;
             }
        }
        remove(fileName.c_str());
        name = "";
        fileName = "";
    }
    closedir(dir);
}

//删除文件夹所有的文件
void FileOp::delAllFilesComplete(string filePath){
    //g_OutputPath
    //DIR* dir;
    struct dirent* ptr;
    DIR*  dir = opendir(filePath.c_str());
    if(dir == nullptr){
        return;
    }
    rewinddir(dir);
    while ((ptr = readdir(dir)) != NULL) {
        string name(ptr->d_name);
        string fileName = filePath + "/" + name;

        remove(fileName.c_str());
        name = "";
        fileName = "";
    }
    closedir(dir);
}
//whether file is empty
bool FileOp::isFileEmpty(string filePath){
    FILE* fp;
    fp = fopen(filePath.c_str(),"r");
    if(!fp){
        return false;
    }
    char ch=fgetc(fp);
    if(ch==EOF){
        fclose(fp);
        return true;
    }
    else{
        fclose(fp);
        return false;
    }
}

//读取所有策略的绝对路径20190708
void FileOp::readCorrespondingStrategy(string src,vector<string>* fileName)
{
    DIR* dir;
    struct dirent* ptr;
    dir = opendir(src.c_str());
    if(dir == nullptr){
        return;
    }
    while ((ptr = readdir(dir)) != NULL) {
        string name(ptr->d_name);
        size_t posEnd = name.find_last_of(".");
        string suffix = name.substr(posEnd + 1);
        if ((name.find("strategy") != string::npos) && (suffix == "txt")) {
            fileName->push_back(src + "/" + name);
        }
    }
    closedir(dir);
}

//将所有的策略输出到二进制文件cse.dat 20190708
void FileOp::packageCorrespondingStrategyAndSaveBinary(string src, vector<string>* fileName){
    int len = 0;
    ofstream outFile(src.c_str(),ios::app);
    for(len = 0; len < FileOp::StrategyCorrespondingFilePath.size(); ++len){
        if(1){
            string str;
            ifstream openFile(FileOp::StrategyCorrespondingFilePath[len]);
            if(openFile.fail()){
                cout<< "open file failed"<< endl;
                continue;
            }
            int firstPos = FileOp::StrategyCorrespondingFilePath[len].find_last_of("/")+1;
            string fileName = FileOp::StrategyCorrespondingFilePath[len].substr(firstPos);
            int secondPos = fileName.find_first_of("_")+1;
            fileName = fileName.substr(secondPos);
            stringAddOne(fileName);
            outFile << fileName << endl;  //加密
            while(getline(openFile,str)){
                stringAddOne(str);
                outFile << str << endl; //加密
            }
            openFile.close();
        }
    }
    outFile.close();
    FileOp::StrategyCorrespondingFilePath.clear();
    vector<string>().swap(FileOp::StrategyCorrespondingFilePath);
}

//将二进制文件读取并按文本形式重新生成策略 20190708 justForCheck
void FileOp::packageCorrespondingStrategyAndCheck(string src){
    string lineContent;
    string outputFileName;
    bool flag = false;
    ifstream inFile(src.c_str());
    if(inFile.fail()){
        cout<< "open file failed"<< endl;
        return;
    }
    while(getline(inFile,lineContent)){
        //解密
        stringPlusOne(lineContent);
        if(lineContent.find(".txt") != string::npos){
            //start to output
            outputFileName = "/home/ars01/Desktop/optimaizePathStrategies1/" +lineContent;  
            flag = true;
        }
        if(flag) {
            ofstream outFile(outputFileName, ios::app);
            outFile << lineContent << endl;
            if (lineContent.find("锁子句约简模式") != string::npos) {
                outFile.close();
                flag = false;
            }
        }
        
    }
    inFile.close();
}
//判断策略是否在策略组中
bool FileOp::findPackageCorrespondingStrategy(string src, string searchCorrespondingStrategies){
    
    string lineContent;
    ifstream inFile(src.c_str());
    if(inFile.fail()){
        cout<< "open file failed"<< endl;
        return false;
    }
    while(getline(inFile,lineContent)){
        //解密
        stringPlusOne(lineContent);
        if(lineContent.find(".txt") != string::npos){
            //start to output
            int endPos = lineContent.find_last_of("."); 
            string fileName = lineContent.substr(0, endPos);
            if(fileName == searchCorrespondingStrategies){
                inFile.close();
                return true;
            }
        }
    }
    inFile.close();
    return false;
    
}
//根据对应的策略进行策略设置
void FileOp::findCorrespondingStrategy(string src, string searchCorrespondingStrategies){
    bool flag = false;
    string lineContent;
    ifstream inFile(src.c_str());
    if(inFile.fail()){
        cout<< "open file failed"<< endl;
        return;
    }
    while(getline(inFile,lineContent)){
        //解密
        stringPlusOne(lineContent);
        if(lineContent.find(".txt") != string::npos){
            int endPos = lineContent.find_last_of("."); 
            string fileName = lineContent.substr(0, endPos);
            if(fileName == searchCorrespondingStrategies){
                flag = true;
            } 
        }
        if(flag){
            setSingleCorrespondingStrategy(lineContent);
        }
        if((lineContent.find("锁子句约简模式") != string::npos) && flag){
            break;
        }
    }
    inFile.close();
}

//设置策略对应中的单个策略
void FileOp::setSingleCorrespondingStrategy(string str){
    int i=0;
    for(i=0;i<1;i++)
    {
        //单元子句选取策略
        if (str.find("单元子句选取策略0") != string::npos){
            StrategyParam::unitChoose = 0;
            //cout<<"单元子句选取策略0"<<endl;
            continue;
        }
        else if (str.find("单元子句选取策略1") != string::npos){
            StrategyParam::unitChoose = 1;
            //cout<<"单元子句选取策略1"<<endl;
            continue;
        }
        else if (str.find("单元子句选取策略2") != string::npos){
            StrategyParam::unitChoose = 2;
            //cout<<"单元子句选取策略2"<<endl;
            continue;
        }
        else if (str.find("单元子句选取策略3") != string::npos){
            StrategyParam::unitChoose = 3;
            //cout<<"单元子句选取策略3"<<endl;
            continue;
        }
        else if (str.find("单元子句选取策略4") != string::npos){
            StrategyParam::unitChoose = 4;
            //cout<<"单元子句选取策略4"<<endl;
            continue;
        }
        //单元子句归结次数策略
        if (str.find("单元子句归结次数策略0") != string::npos){
            StrategyParam::unitDeduct = 0;
            //cout<<"单元子句归结次数策略0"<<endl;
            continue;
        }
        else if (str.find("单元子句归结次数策略1") != string::npos){
            StrategyParam::unitDeduct = 1;
            //cout<<"单元子句归结次数策略1"<<endl;
            continue;
        }
        else if (str.find("单元子句归结次数策略2") != string::npos){
            //cout<<"单元子句归结次数策略2"<<endl;
            StrategyParam::unitDeduct = 2;
            continue;
        }
        //单元子句冗余次数策略
        if (str.find("单元子句冗余次数策略0") != string::npos){
            //cout<<"单元子句冗余次数策略0"<<endl;
            StrategyParam::unitRedunt = 0;
            continue;
        }
        else if (str.find("单元子句冗余次数策略1") != string::npos){
            //cout<<"单元子句冗余次数策略1"<<endl;
            StrategyParam::unitRedunt = 1;
            continue;
        }
        else if (str.find("单元子句冗余次数策略2") != string::npos){
            //cout<<"单元子句冗余次数策略2"<<endl;
            StrategyParam::unitRedunt = 2;
            continue;
        }
        //单元子句稳定度策略
        if (str.find("单元子句稳定度策略0") != string::npos){
            //cout<<"单元子句稳定度策略0"<<endl;
            StrategyParam::unitSteady = 0;
            continue;
        }
        else if (str.find("单元子句稳定度策略1") != string::npos){
            //cout<<"单元子句稳定度策略1"<<endl;
            StrategyParam::unitSteady = 1;
            continue;
        }
        else if (str.find("单元子句稳定度策略2") != string::npos){
            //cout<<"单元子句稳定度策略2"<<endl;
            StrategyParam::unitSteady = 2;
            continue;
        }
        //单元子句函数嵌套层策略
        if (str.find("单元子句函数嵌套层策略0") != string::npos){
            //cout<<"单元子句函数嵌套层策略0"<<endl;
            StrategyParam::unitFuncLayer = 0;
            continue;
        }
        else if (str.find("单元子句函数嵌套层策略1") != string::npos){
            //cout<<"单元子句函数嵌套层策略1"<<endl;
            StrategyParam::unitFuncLayer = 1;
            continue;
        }
        else if (str.find("单元子句函数嵌套层策略2") != string::npos){
            //cout<<"单元子句函数嵌套层策略2"<<endl;
            StrategyParam::unitFuncLayer = 2;
            continue;
        }
        //候选子句选取策略
        if (str.find("候选子句选取策略0") != string::npos){
            //cout<<"候选子句选取策略0"<<endl;
            StrategyParam::candChoose = 0;
            continue;
        }
        else if (str.find("候选子句选取策略1") != string::npos){
            //cout<<"候选子句选取策略1"<<endl;
            StrategyParam::candChoose = 1;
            continue;
        }
        else if (str.find("候选子句选取策略2") != string::npos){
            //cout<<"候选子句选取策略2"<<endl;
            StrategyParam::candChoose = 2;
            continue;
        }
        else if (str.find("候选子句选取策略3") != string::npos){
            //cout<<"候选子句选取策略3"<<endl;
            StrategyParam::candChoose = 3;
            continue;
        }
        else if (str.find("候选子句选取策略4") != string::npos){
            //cout<<"候选子句选取策略4"<<endl;
            StrategyParam::candChoose = 4;
            continue;
        }
        //候选子句归结次数策略
        if (str.find("候选子句归结次数策略0") != string::npos){
            //cout<<"候选子句归结次数策略0"<<endl;
            StrategyParam::candDeduct = 0;
            continue;
        }
        else if (str.find("候选子句归结次数策略1") != string::npos){
            //cout<<"候选子句归结次数策略1"<<endl;
            StrategyParam::candDeduct = 1;
            continue;
        }
        else if (str.find("候选子句归结次数策略2") != string::npos){
            //cout<<"候选子句归结次数策略2"<<endl;
            StrategyParam::candDeduct = 2;
            continue;
        }
        //候选子句冗余次数策略
         if (str.find("候选子句冗余次数策略0") != string::npos){
             //cout<<"候选子句冗余次数策略0"<<endl;
            StrategyParam::candRedunt = 0;
            continue;
        }
        else if (str.find("候选子句冗余次数策略1") != string::npos){
            //cout<<"候选子句冗余次数策略1"<<endl;
            StrategyParam::candRedunt = 1;
            continue;
        }
        else if (str.find("候选子句冗余次数策略2") != string::npos){
            //cout<<"候选子句冗余次数策略2"<<endl;
            StrategyParam::candRedunt = 2;
            continue;
        }
        //候选子句文字数策略
         if (str.find("候选子句文字数策略0") != string::npos){
             //cout<<"候选子句文字数策略0"<<endl;
            StrategyParam::candClause = 0;
            continue;
        }
        else if (str.find("候选子句文字数策略1") != string::npos){
            //cout<<"候选子句文字数策略1"<<endl;
            StrategyParam::candClause = 1;
            continue;
        }
        else if (str.find("候选子句文字数策略2") != string::npos){
            //cout<<"候选子句文字数策略2"<<endl;
            StrategyParam::candClause = 2;
            continue;
        }
        //候选子句稳定度策略
       if (str.find("候选子句稳定度策略0") != string::npos){
           //cout<<"候选子句稳定度策略0"<<endl;
            StrategyParam::candSteady = 0;
            continue;
        }
        else if (str.find("候选子句稳定度策略1") != string::npos){
            //cout<<"候选子句稳定度策略1"<<endl;
            StrategyParam::candSteady = 1;
            continue;
        }
        else if (str.find("候选子句稳定度策略2") != string::npos){
            //cout<<"候选子句稳定度策略2"<<endl;
            StrategyParam::candSteady = 2;
            continue;
        }
        //单元子句归结次数最大值策略
         if (str.find("单元子句归结次数最大值策略") != string::npos){
            
            StrategyParam::unitDeductTimes = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"单元子句归结次数最大值策略"<<StrategyParam::unitDeductTimes<<endl;
            continue;
        }
        //单元子句归结次数更新策略
        if (str.find("单元子句归结次数更新策略0") != string::npos){
            //cout<<"单元子句归结次数更新策略0"<<endl;
            StrategyParam::unitDeductTimesUpdate = 0;
            continue;
        }
        else if (str.find("单元子句归结次数更新策略1") != string::npos){
            //cout<<"单元子句归结次数更新策略1"<<endl;
            StrategyParam::unitDeductTimesUpdate = 1;
            continue;
        }
        else if (str.find("单元子句归结次数更新策略2") != string::npos){
            //cout<<"单元子句归结次数更新策略2"<<endl;
            StrategyParam::unitDeductTimesUpdate = 2;
            continue;
        }
        else if (str.find("单元子句归结次数更新策略3") != string::npos){
            //cout<<"单元子句归结次数更新策略3"<<endl;
            StrategyParam::unitDeductTimesUpdate = 3;
            continue;
        }
        else if (str.find("单元子句归结次数更新策略4") != string::npos){
            //cout<<"单元子句归结次数更新策略4"<<endl;
            StrategyParam::unitDeductTimesUpdate = 4;
            continue;
        }
        //单元子句冗余次数最大值策略
        if (str.find("单元子句冗余次数最大值策略") != string::npos){
            StrategyParam::unitReduntTimes = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"单元子句冗余次数最大值策略"<<StrategyParam::unitReduntTimes<<endl;
            continue;
        }
        //单元子句冗余次数更新策略
         if (str.find("单元子句冗余次数更新策略0") != string::npos){
             //cout<<"单元子句冗余次数更新策略0"<<endl;
            StrategyParam::unitReduntTimesUpdate = 0;
            continue;
        }
        else if (str.find("单元子句冗余次数更新策略1") != string::npos){
            //cout<<"单元子句冗余次数更新策略1"<<endl;
            StrategyParam::unitReduntTimesUpdate = 1;
            continue;
        }
        else if (str.find("单元子句冗余次数更新策略2") != string::npos){
            //cout<<"单元子句冗余次数更新策略2"<<endl;
            StrategyParam::unitReduntTimesUpdate = 2;
            continue;
        }
        else if (str.find("单元子句冗余次数更新策略3") != string::npos){
            //cout<<"单元子句冗余次数更新策略3"<<endl;
            StrategyParam::unitReduntTimesUpdate = 3;
            continue;
        }
        else if (str.find("单元子句冗余次数更新策略4") != string::npos){
            //cout<<"单元子句冗余次数更新策略4"<<endl;
            StrategyParam::unitReduntTimesUpdate = 4;
            continue;
        }
        //候选子句归结次数最大值策略
        if (str.find("候选子句归结次数最大值策略") != string::npos){
            StrategyParam::candDeductTimes = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"候选子句归结次数最大值策略"<<StrategyParam::candDeductTimes<<endl;
            continue;
        }
        //候选子句归结次数更新策略
        if (str.find("候选子句归结次数更新策略0") != string::npos){
            //cout<<"候选子句归结次数更新策略0"<<endl;
            StrategyParam::candDeductTimesUpdate = 0;
            continue;
        }
        else if (str.find("候选子句归结次数更新策略1") != string::npos){
            //cout<<"候选子句归结次数更新策略1"<<endl;
            StrategyParam::candDeductTimesUpdate = 1;
            continue;
        }
        else if (str.find("候选子句归结次数更新策略2") != string::npos){
            //cout<<"候选子句归结次数更新策略2"<<endl;
            StrategyParam::candDeductTimesUpdate = 2;
            continue;
        }
        else if (str.find("候选子句归结次数更新策略3") != string::npos){
            //cout<<"候选子句归结次数更新策略3"<<endl;
            StrategyParam::candDeductTimesUpdate = 3;
            continue;
        }
        else if (str.find("候选子句归结次数更新策略4") != string::npos){
            //cout<<"候选子句归结次数更新策略4"<<endl;
            StrategyParam::candDeductTimesUpdate = 4;
            continue;
        }
        //候选子句冗余次数最大值策略
       if (str.find("候选子句冗余次数最大值策略") != string::npos){
            StrategyParam::candReduntTimes = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"候选子句冗余次数最大值策略"<<StrategyParam::candReduntTimes<<endl;
            continue;
        }
        //候选子句冗余次数更新策略
         if (str.find("候选子句冗余次数更新策略0") != string::npos){
             //cout<<"候选子句冗余次数更新策略0"<<endl;
            StrategyParam::candReduntTimesUpdate = 0;
            continue;
        }
        else if (str.find("候选子句冗余次数更新策略1") != string::npos){
            //cout<<"候选子句冗余次数更新策略1"<<endl;
            StrategyParam::candReduntTimesUpdate = 1;
            continue;
        }
        else if (str.find("候选子句冗余次数更新策略2") != string::npos){
            //cout<<"候选子句冗余次数更新策略2"<<endl;
            StrategyParam::candReduntTimesUpdate = 2;
            continue;
        }
        else if (str.find("候选子句冗余次数更新策略3") != string::npos){
            //cout<<"候选子句冗余次数更新策略3"<<endl;
            StrategyParam::candReduntTimesUpdate = 3;
            continue;
        }
        else if (str.find("候选子句冗余次数更新策略") != string::npos){
            //cout<<"候选子句冗余次数更新策略4"<<endl;
            StrategyParam::candReduntTimesUpdate = 4;
            continue;
        }
        //候选子句文字策略
        if (str.find("候选子句文字策略0") != string::npos){
            //cout<<"候选子句文字策略0"<<endl;
            StrategyParam::candLiteral = 0;
            continue;
        }
        else if (str.find("候选子句文字策略1") != string::npos){
            //cout<<"候选子句文字策略1"<<endl;
            StrategyParam::candLiteral = 1;
            continue;
        }
        else if (str.find("候选子句文字策略2") != string::npos){
            //cout<<"候选子句文字策略2"<<endl;
            StrategyParam::candLiteral = 2;
            continue;
        }
        //候选子句归结次数策略
        if (str.find("候选子句文字归结次数策略0") != string::npos){
            //cout<<"候选子句归结次数策略0"<<endl;
            StrategyParam::candLiteralDeductTimes = 0;
            continue;
        }
        else if (str.find("候选子句文字归结次数策略1") != string::npos){
            //cout<<"候选子句归结次数策略1"<<endl;
            StrategyParam::candLiteralDeductTimes = 1;
            continue;
        }
        else if (str.find("候选子句文字归结次数策略2") != string::npos){
            //cout<<"候选子句归结次数策略2"<<endl;
            StrategyParam::candLiteralDeductTimes = 2;
            continue;
        }
        //候选子句稳定度策略
        if (str.find("候选子句文字稳定度策略0") != string::npos){
            StrategyParam::candLiteralSteady = 0;
            continue;
        }
        else if (str.find("候选子句文字稳定度策略1") != string::npos){
            StrategyParam::candLiteralSteady = 1;
            continue;
        }
        else if (str.find("候选子句文字稳定度策略2") != string::npos){
            StrategyParam::candLiteralSteady = 2;
            continue;
        }
        //R随机权重
        if ((str.find("R权重赋值策略0:") != string::npos)){
            StrategyParam::useRandrom = true;
            continue;
        }
        else if(str.find("R权重赋值策略1:") != string::npos)
        {
            StrategyParam::useRandrom = false;
            continue;
        }
        //R文字数大小策略
        if ((str.find("不允许小于原始子句文字最大数:") != string::npos)){
            StrategyParam::Rsmall = false;
            continue;
        }
        else if(str.find("允许小于原始子句文字最大数:") != string::npos)
        {
            StrategyParam::Rsmall = true;
            continue;
        }
         if ((str.find("不允许小于原始子句层数最大数:") != string::npos)){
            StrategyParam::RFsmall = false;
            continue;
        }
        else if(str.find("允许小于原始子句层数最大数:") != string::npos)
        {
            StrategyParam::RFsmall = true;
            continue;
        }
        if ((str.find("不允许R因子归结:") != string::npos)){
            StrategyParam::RRes = false;
            continue;
        }
        else if(str.find("允许R因子归结:") != string::npos)
        {
            StrategyParam::RRes = true;
            continue;
        }
        if (str.find("R文字数大小策略") != string::npos){
            StrategyParam::R_MAX_NUM_TMP = stoi(str.substr(str.find_first_of(":") + 1));
            StrategyParam::R_MAX_NUM = stoi(str.substr(str.find_first_of(":") + 1));
            if ((StrategyParam::R_MAX_NUM < StrategyParam::R_INIT_MAX_NUM) && !StrategyParam::Rsmall) {
                StrategyParam::R_MAX_NUM = StrategyParam::R_INIT_MAX_NUM;
                StrategyParam::R_MAX_NUM_TMP = StrategyParam::R_INIT_MAX_NUM;
            }
            continue;
        }
        //最大函数嵌套层限制
        if (str.find("R函数嵌套层") != string::npos){
            StrategyParam::R_MAX_FUNCLAYER = stoi(str.substr(str.find_first_of(":") + 1));
            StrategyParam::R_MAX_FUNCLAYER_TMP = stoi(str.substr(str.find_first_of(":") + 1));
            if ((StrategyParam::R_MAX_FUNCLAYER < StrategyParam::R_INIT_MAX_FUNCLAYER) && !StrategyParam::RFsmall) {
                StrategyParam::R_MAX_FUNCLAYER = StrategyParam::R_INIT_MAX_FUNCLAYER* 2+1;
                StrategyParam::R_MAX_FUNCLAYER_TMP = StrategyParam::R_INIT_MAX_FUNCLAYER* 2+1;
            }
            continue;
        }
        //R权重大小
        if (str.find("R权重大小") != string::npos){
            StrategyParam::R_Weight = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"R权重大小"<<StrategyParam::R_Weight<<endl;
            continue;
        }
        if (str.find("R2文字数大小策略") != string::npos){
            StrategyParam::R_MAX_NUM_NOPAIR = stoi(str.substr(str.find_first_of(":") + 1));
            continue;
        }
        if (str.find("R文字冗余策略0") != string::npos){
            //cout<<"中间归结式生成"<<endl;
            StrategyParam::litRundent = 1;
            continue;
        }
        else if(str.find("R文字冗余策略1") != string::npos)
        {
            //cout<<"中间归结式不生成"<<endl;
            StrategyParam::litRundent = 0;
            continue;
        }
        
        if (str.find("中间归结式生成策略0") != string::npos){
            //cout<<"中间归结式生成"<<endl;
            StrategyParam::midR = 0;
            continue;
        }
        else if(str.find("中间归结式生成策略1") != string::npos)
        {
            //cout<<"中间归结式不生成"<<endl;
            StrategyParam::midR = 1;
            continue;
        }
        else if(str.find("中间归结式生成策略2") != string::npos)
        {
            //cout<<"中间归结式不生成"<<endl;
            StrategyParam::midR = 2;
            continue;
        }
        else if(str.find("中间归结式生成策略3") != string::npos)
        {
            //cout<<"中间归结式不生成"<<endl;
            StrategyParam::midR = 3;
            continue;
        }
        else if(str.find("中间归结式生成策略4") != string::npos)
        {
            //cout<<"中间归结式不生成"<<endl;
            StrategyParam::midR = 4;
            continue;
        }
        else if(str.find("中间归结式生成策略5") != string::npos)
        {
            //cout<<"中间归结式不生成"<<endl;
            StrategyParam::midR = 5;
            continue;
        }
        else if(str.find("中间归结式生成策略6") != string::npos)
        {
            //cout<<"中间归结式不生成"<<endl;
            StrategyParam::midR = 6;
            continue;
        }
        else if(str.find("中间归结式生成策略7") != string::npos)
        {
            //cout<<"中间归结式不生成"<<endl;
            StrategyParam::midR = 1000;
            continue;
        }
        //项重写策略
         if (str.find("项重写策略0") != string::npos){
             //cout<<"宽深策略0"<<endl;
            StrategyParam::termRewriting = 0;
            continue;
        }
        else if (str.find("项重写策略1") != string::npos){
            //cout<<"宽深策略1"<<endl;
            StrategyParam::termRewriting = 1;
            continue;
        }
        else if (str.find("项重写策略2") != string::npos){
            //cout<<"宽深策略2"<<endl;
            StrategyParam::termRewriting = 2;
            continue;
        }
        //项重写大小策略
         if (str.find("替换项的大小策略0") != string::npos){
             //cout<<"宽深策略0"<<endl;
            StrategyParam::termRewritingSize  = 1;
            continue;
        }
        else if (str.find("替换项的大小策略1") != string::npos){
            //cout<<"宽深策略1"<<endl;
            StrategyParam::termRewritingSize  = 2;
            continue;
        }
        else if (str.find("替换项的大小策略2") != string::npos){
            //cout<<"宽深策略2"<<endl;
            StrategyParam::termRewritingSize  = 3;
            continue;
        }
        //宽深策略
         if (str.find("宽深策略0") != string::npos){
             //cout<<"宽深策略0"<<endl;
            StrategyParam::widthDeep = 0;
            continue;
        }
        else if (str.find("宽深策略1") != string::npos){
            //cout<<"宽深策略1"<<endl;
            StrategyParam::widthDeep = 1;
            continue;
        }
        else if (str.find("宽深策略2") != string::npos){
            //cout<<"宽深策略2"<<endl;
            StrategyParam::widthDeep = 2;
            continue;
        }
        //演绎深度策略
       if (str.find("演绎深度策略") != string::npos){
            StrategyParam::deductDeep = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"演绎深度策略"<<StrategyParam::deductDeep<<endl;
            continue;
        } 
        //演绎宽度策略 StrategyParam::deducWidth
        if (str.find("演绎宽度策略") != string::npos){
            StrategyParam::deducWidth = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"演绎深度策略"<<StrategyParam::deductDeep<<endl;
            continue;
        } 
        //迭代次数
        if (str.find("迭代次数") != string::npos){
            StrategyParam::iterTimes = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"迭代次数"<<StrategyParam::iterTimes<<endl;
            continue;
        } 
        //迭代轮数
         if (str.find("迭代轮数") != string::npos){
            StrategyParam::iterRing = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"迭代轮数"<<StrategyParam::iterRing<<endl;
            continue;
        } 
        //时间限制
         if (str.find("时间限制") != string::npos){
            StrategyParam::timeLimit = stod(str.substr(str.find_first_of(":") + 1))/60;
            //cout<<"时间限制"<<StrategyParam::timeLimit<<endl;
            //cout<<str<<endl;
            continue;
        } 
        //内存限制
        if (str.find("内存限制") != string::npos){
            StrategyParam::memLimit = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"内存限制"<<StrategyParam::memLimit<<endl;
            continue;
        } 
        //中间归结式冗余判断
        if (str.find("中间归结式冗余判断") != string::npos){
            //cout<<"中间归结式冗余判断"<<endl;
            StrategyParam::midRJudge = true;
            continue;
        }
        else if(str.find("中间归结式冗余不判断") != string::npos)
        {
            //cout<<"中间归结式冗余不判断"<<endl;
            StrategyParam::midRJudge = false;
            continue;
        }//StrategyParam::deductMode
        if (str.find("CSE版本0") != string::npos){
            //cout<<"中间归结式冗余判断"<<endl;
            StrategyParam::deductMode = 0;
            continue;
        }
        else if(str.find("CSE版本1") != string::npos)
        {
            //cout<<"中间归结式冗余不判断"<<endl;
            StrategyParam::deductMode = 1;
            StrategyParam::cseRunMode = 0;
            continue;
        }
        else if(str.find("CSE版本2") != string::npos)
        {
            //cout<<"中间归结式冗余不判断"<<endl;
            StrategyParam::deductMode = 1;
            StrategyParam::cseRunMode = 1;
            continue;
        }
        else if(str.find("CSE版本3") != string::npos)
        {
            //cout<<"中间归结式冗余不判断"<<endl;
            StrategyParam::deductMode = 1;
            StrategyParam::cseRunMode = 2;
            continue;
        }
        else if(str.find("CSE版本4") != string::npos)
        {
            //cout<<"中间归结式冗余不判断"<<endl;
            StrategyParam::deductMode = 1;
            StrategyParam::cseRunMode = 3;
            continue;
        }
        else if(str.find("CSE融合版本") != string::npos)
        {
            //cout<<"中间归结式冗余不判断"<<endl;
            StrategyParam::deductMode = 1;
            StrategyParam::cseRunMode = 4;
            continue;
        }
        //StrategyParam::deduceDepth
        if (str.find("演绎最大深度") != string::npos){
            StrategyParam::deduceDepth = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"内存限制"<<StrategyParam::memLimit<<endl;
            continue;
        } 
        //20171024
        if (str.find("重复子句次数") != string::npos){
            StrategyParam::claReUseTimes = stoi(str.substr(str.find_first_of(":") + 1));
            StrategyParam::claReUseTimesTmp = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"内存限制"<<StrategyParam::memLimit<<endl;
            continue;
        } 
        //StrategyParam::singleUseUintCla
        if (str.find("浸透方法0") != string::npos){
            //cout<<"中间归结式冗余判断"<<endl;
            StrategyParam::useSaturate = true;
            continue;
        }
        else if(str.find("浸透方法1") != string::npos)
        {
            //cout<<"中间归结式冗余不判断"<<endl;
            StrategyParam::useSaturate = false;
            continue;
        }
        //重复使用单元子句策略
        if (str.find("重复单元子句策略0") != string::npos){
            StrategyParam::useCpUintCla = true;
            continue;
        }
        else if(str.find("重复单元子句策略1") != string::npos)
        {
            StrategyParam::useCpUintCla = false;
            continue;
        }
        
        //结合系统策略使用
        if (str.find("使用结合系统策略0") != string::npos){
            //cout<<"中间归结式冗余判断"<<endl;
            StrategyParam::useCombinedSys  = 0;
            continue;
        }
        else if(str.find("使用结合系统策略1") != string::npos)
        {
            //cout<<"中间归结式冗余不判断"<<endl;
            StrategyParam::useCombinedSys  = 1;
            continue;
        }
        else if(str.find("使用结合系统策略2") != string::npos)
        {
            //cout<<"中间归结式冗余不判断"<<endl;
            StrategyParam::useCombinedSys  = 2;
            continue;
        }
        else if(str.find("使用结合系统策略3") != string::npos)
        {
            //cout<<"中间归结式冗余不判断"<<endl;
            StrategyParam::useCombinedSys  = 3;
            continue;
        }
        //结合系统结合方式策略
        if (str.find("结合方式策略0") != string::npos){
            StrategyParam::useCombinedSysMethod  = 0;//加等词公理
            continue;
        }
        else if(str.find("结合方式策略1") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 1;//不加等词公理
            continue;
        }
        else if(str.find("结合方式策略2") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 2;//S+公理+R等词子句
            continue;
        }
        else if(str.find("结合方式策略3") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 3;//S+R等词子句
            continue;
        }
        else if(str.find("结合方式策略4") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 4;//S+公理+R文字数<=2
            continue;
        }
        else if(str.find("结合方式策略5") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 5;//S+R文字数<=2
            continue;
        }
        else if(str.find("结合方式策略6") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 6;//S+公理+R文字数<=3
            continue;
        }
        else if(str.find("结合方式策略7") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 7;//S+R文字数<=3
            continue;
        }
        else if(str.find("结合方式策略8") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 8;//S+公理+所有R
            continue;
        }
        else if(str.find("结合方式策略9") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 9;//S+所有R
            continue;
        }
        else if(str.find("结合方式策略10") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 10;//S+所有R
            continue;
        }
        else if(str.find("结合方式策略11") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 11;//S+所有R
            continue;
        }
        else if(str.find("结合方式策略12") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 12;//S+所有R
            continue;
        }
        else if(str.find("结合方式策略13") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 13;//S+所有R
            continue;
        }
        //结合R策略
        if (str.find("结合R策略0") != string::npos){
            StrategyParam::combinedRMode  = 0;//
            continue;
        }
        else if(str.find("结合R策略1") != string::npos)
        {
            StrategyParam::combinedRMode  = 1;//
            continue;
        }
        else if(str.find("结合R策略2") != string::npos)
        {
            StrategyParam::combinedRMode  = 2;//
            continue;
        }
        else if(str.find("结合R策略3") != string::npos)
        {
            StrategyParam::combinedRMode  = 3;//
            continue;
        }
        
        if(str.find("预处理结合策略0") != string::npos){
            StrategyParam::preprocess  = 1;
            continue;
        }
        else if(str.find("预处理结合策略1") != string::npos){
            StrategyParam::preprocess  = 0;
            continue;
        }
        //预处理策略
        if ((str.find("因子归结预处理") != string::npos)&&(str.find("不因子归结预处理") == string::npos)){
            StrategyParam::factorRes = true;
            continue;
        }
        else if(str.find("不因子归结预处理") != string::npos)
        {
            StrategyParam::factorRes = false;
            continue;
        }
         if ((str.find("等词归结预处理") != string::npos)&&(str.find("不等词归结预处理") == string::npos)){
            StrategyParam::eqnRes  = true;
            continue;
        }
        else if(str.find("不等词归结预处理") != string::npos)
        {
            StrategyParam::eqnRes  = false;
            continue;
        }
         if ((str.find("删除纯文字子句") != string::npos)&&(str.find("不删除纯文字子句") == string::npos)){
            StrategyParam::delPureCla  = true;
            continue;
        }
        else if(str.find("不删除纯文字子句") != string::npos)
        {
            StrategyParam::delPureCla  = false;
            continue;
        }
        if ((str.find("目标子句预处理") != string::npos)&&(str.find("不目标子句预处理") == string::npos)){
            StrategyParam::goalCla  = true;
            continue;
        }
        else if(str.find("不目标子句预处理") != string::npos)
        {
            StrategyParam::goalCla  = false;
            continue;
        }
        //后面增加的策略
         if (str.find("单元子句排序规则0") != string::npos){
            StrategyParam::unitSortRule = 0;
            continue;
        }
        else if (str.find("单元子句排序规则1") != string::npos){
            StrategyParam::unitSortRule = 1;
            continue;
        }
        else if (str.find("单元子句排序规则2") != string::npos){
            StrategyParam::unitSortRule = 2;
            continue;
        }
        else if (str.find("单元子句排序规则3") != string::npos){
            StrategyParam::unitSortRule = 3;
            continue;
        }
        else if (str.find("单元子句排序规则4") != string::npos){
            StrategyParam::unitSortRule = 4;
            continue;
        }
        else if (str.find("单元子句排序规则5") != string::npos){
            StrategyParam::unitSortRule = 5;
            continue;
        }
        else if (str.find("单元子句排序规则6") != string::npos){
            StrategyParam::unitSortRule = 6;
            continue;
        }
        else if (str.find("单元子句排序规则7") != string::npos){
            StrategyParam::unitSortRule = 7;
            continue;
        }
        else if (str.find("单元子句排序规则8") != string::npos){
            StrategyParam::unitSortRule = 8;
            continue;
        }
        if (str.find("子句综合函数复杂度-1") != string::npos){
             StrategyParam::claFuncComp = -1;
             StrategyParam::funcFixDeepth = 36;
            continue;
        }
        else if (str.find("子句综合函数复杂度0") != string::npos){
             StrategyParam::claFuncComp = 0;
             StrategyParam::funcFixDeepth = StrategyParam::funcOrgFixDeepthMax + 1;//StrategyParam::funcOrgFixDeepthLessMax
             
            continue;
        }
        else if (str.find("子句综合函数复杂度1") != string::npos){
            StrategyParam::claFuncComp = 1;
            StrategyParam::funcFixDeepth = StrategyParam::funcOrgFixDeepthMax + StrategyParam::funcOrgFixDeepthLessMax;
            continue;
        }
        else if (str.find("子句综合函数复杂度2") != string::npos){
            StrategyParam::claFuncComp = 2;
            StrategyParam::funcFixDeepth = StrategyParam::funcOrgFixDeepthMax*2;
            continue;
        }
        else if (str.find("子句综合函数复杂度3") != string::npos){
            StrategyParam::claFuncComp = 3;
            StrategyParam::funcFixDeepth = StrategyParam::funcOrgFixDeepthMax*3;
            continue;
        }
        else if (str.find("子句综合函数复杂度4") != string::npos){
            StrategyParam::claFuncComp = 4;
            StrategyParam::funcFixDeepth = StrategyParam::funcOrgFixDeepthMax + 10;
            continue;
        }
        //StrategyParam::unitClaUpdate
        if (str.find("单元子句更换方式0") != string::npos){
             StrategyParam::unitClaUpdate = 0;
            continue;
        }
        else if (str.find("单元子句更换方式1") != string::npos){
             StrategyParam::unitClaUpdate = 1;
            continue;
        }else if (str.find("单元子句更换方式2") != string::npos){
             StrategyParam::unitClaUpdate = 2;
            continue;
        }
       if (str.find("非单元子句之间归结") != string::npos){
            StrategyParam::noUnitRes = true;
            continue;
        }
        else if(str.find("非单元子句之间不归结") != string::npos)
        {
            StrategyParam::noUnitRes = false;
            continue;
        }
        if (str.find("非单元子句约简与结论判断") != string::npos){
            StrategyParam::noUnitSimplify = true;
            continue;
        }
        else if(str.find("非单元子句约简与结论不判断") != string::npos)
        {
            StrategyParam::noUnitSimplify = false;
            continue;
        }//divideTri
        if ((str.find("拆分三角形输出") != string::npos)&&(str.find("不拆分三角形输出") == string::npos)){
            StrategyParam::divideTri = true;
            continue;
        }
        else if(str.find("不拆分三角形输出") != string::npos)
        {
            StrategyParam::divideTri = false;
            continue;
        }
        if ((str.find("删除无法判定记录:") != string::npos)&&(str.find("不删除无法判定记录:") == string::npos)){
            StrategyParam::delRecord = true;
            continue;
        }
        else if(str.find("不删除无法判定记录:") != string::npos)
        {
            StrategyParam::delRecord = false;
            continue;
        }//
        if ((str.find("优先生成文字少的子句:") != string::npos)&&(str.find("不优先生成文字少的子句:") == string::npos)){
            StrategyParam::genLitClause = true;
            continue;
        }
        else if(str.find("不优先生成文字少的子句:") != string::npos)
        {
            StrategyParam::genLitClause = false;
            continue;
        }//StrategyParam::strategyMode
        if (str.find("多组合策略模式0") != string::npos){
             StrategyParam::strategyMode = 0;
            continue;
        }
        else if (str.find("多组合策略模式1") != string::npos){
             StrategyParam::strategyMode = 1;
            continue;
        }
        else if (str.find("多组合策略模式2") != string::npos) {
            StrategyParam::strategyMode = 0;
            continue;
        }
        //StrategyParam::noUintCla
        if (str.find("非单元子句限制策略0") != string::npos){
             StrategyParam::noUintCla = 0;
            continue;
        }
        else if (str.find("非单元子句限制策略1") != string::npos){
             StrategyParam::noUintCla = 1;
            continue;
        }
        else if (str.find("非单元子句限制策略2") != string::npos){
             StrategyParam::noUintCla = 2;
            continue;
        }
        else if (str.find("非单元子句限制策略3") != string::npos){
             StrategyParam::noUintCla = 3;
            continue;
        }
        else if (str.find("非单元子句限制策略4") != string::npos){
             StrategyParam::noUintCla = 4;
            continue;
        }
        else if (str.find("非单元子句限制策略5") != string::npos){
             StrategyParam::noUintCla = 5;
            continue;
        }
        else if (str.find("非单元子句限制策略6") != string::npos){
             StrategyParam::noUintCla = 6;
            continue;
        }
        else if (str.find("非单元子句限制策略7") != string::npos){
             StrategyParam::noUintCla = 7;
            continue;
        }
        else if (str.find("非单元子句限制策略8") != string::npos){
             StrategyParam::noUintCla = 8;
            continue;
        }
        
        if (str.find("目标深度模式0") != string::npos){
             StrategyParam::goalDeepth = 2;
            continue;
        }
        else if (str.find("目标深度模式1") != string::npos){
             StrategyParam::goalDeepth = 3;
            continue;
        }
        else if (str.find("目标深度模式2") != string::npos){
             StrategyParam::goalDeepth = 4;
            continue;
        }
        else if (str.find("目标深度模式3") != string::npos){
             StrategyParam::goalDeepth = 5;
            continue;
        }
        else if (str.find("目标深度模式4") != string::npos){
             StrategyParam::goalDeepth = 6;
            continue;
        }
        else if (str.find("目标深度模式5") != string::npos){
             StrategyParam::goalDeepth = 7;
            continue;
        }
        else if (str.find("目标深度模式6") != string::npos){
             StrategyParam::goalDeepth = 8;
            continue;
        }
        else if (str.find("目标深度模式7") != string::npos){
             StrategyParam::goalDeepth = 9;
            continue;
        }
        else if (str.find("目标深度模式8") != string::npos){
             StrategyParam::goalDeepth = 10;
            continue;
        }
        else if (str.find("目标深度模式9") != string::npos){
             StrategyParam::goalDeepth = 200;
            continue;
        }
        //锁子句约简
        if (str.find("锁子句约简模式0") != string::npos){
             StrategyParam::lockType = 1;
            continue;
        }
        else if (str.find("锁子句约简模式1") != string::npos){
             StrategyParam::lockType = 2;
            continue;
        }
        else if (str.find("锁子句约简模式2") != string::npos){
             StrategyParam::lockType = 3;
            continue;
        }
        else if (str.find("锁子句约简模式3") != string::npos){
             StrategyParam::lockType = 4;
            continue;
        }
        else if (str.find("锁子句约简模式4") != string::npos){
             StrategyParam::lockType = 5;
            continue;
        }
        else if (str.find("锁子句约简模式5") != string::npos){
             StrategyParam::lockType = 0;
            continue;
        }
        //项代换检查冗余StrategyParam::termReRedund
        if (str.find("冗余判断策略0") != string::npos){
             StrategyParam::termReRedund = true;
            continue;
        }
        else if (str.find("冗余判断策略1") != string::npos){
             StrategyParam::termReRedund = false;
            continue;
        }
    }
}



//读取策略文件夹的所有策略
void FileOp::OperStrategy(string src,vector<string>* fileName)
{
    DIR* dir;
    struct dirent* ptr;
    //int i=0;
    dir = opendir(src.c_str());
    if(dir == nullptr){
        return;
    }
    while ((ptr = readdir(dir)) != NULL) {
        string name(ptr->d_name);
        size_t posEnd = name.find_last_of(".");
        string suffix = name.substr(posEnd + 1);
        if ((name.find("strategy") != string::npos) && (suffix == "txt")) {
            fileName->push_back(FileOp::strategyFile + "/" + name);
            //cout<<src + name<<endl;
//            if (++i >= 600)
//                break;
        }
    }
    closedir(dir);
}

int FileOp::strategyFileSizeFunc(string src){
    int size = 0;
    DIR* dir;
    struct dirent* ptr;
    dir = opendir(src.c_str());
    if(dir == nullptr){
        return -1;
    }
    while ((ptr = readdir(dir)) != NULL) {
        string name(ptr->d_name);
        size_t posEnd = name.find_last_of(".");
        string suffix = name.substr(posEnd + 1);
        if ((name.find("strategy") != string::npos) && (suffix == "txt")) {
            ++size;
        }
    }
    closedir(dir);
    return size;
}

//根据下标找到策略的绝对路径
string FileOp::findStrategy(string path, int len)
{
    //vector<string> fileName;
    if(len == 0){
        FileOp::StrategyfileName.clear();
        OperStrategy(path, &FileOp::StrategyfileName);
        sort(FileOp::StrategyfileName.begin(),FileOp::StrategyfileName.end());
    }
    if((FileOp::StrategyfileName.size() == 0) || (len < 0) || (len >= FileOp::StrategyfileName.size()))
        return nullptr;
    return FileOp::StrategyfileName[len];
}

string FileOp::findStrategyTptp(string path, int len)
{
    //vector<string> fileName;

    FileOp::StrategyfileName.clear();
    OperStrategy(path, &FileOp::StrategyfileName);
    sort(FileOp::StrategyfileName.begin(), FileOp::StrategyfileName.end());

    if ((FileOp::StrategyfileName.size() == 0) || (len < 0) || (len >= FileOp::StrategyfileName.size()))
        return nullptr;
    return FileOp::StrategyfileName[len];
}

//获取内存信息
//_syscall1(int,sysinfo,struct sysinfo*,info);
long FileOp::getMem()
{
    FILE *fd;
    char buff[256];
    fd = fopen("/proc/meminfo","r");
    if(fd == nullptr){
        return 200000;
    }
    long memFree = 0;
    long cachedFree = 0;
    while((fgets(buff,sizeof(buff),fd)) != NULL)//Cached:
    {
        string strMem(buff);
        if(strMem.find("MemFree") != string::npos)
        {
            int pos = strMem.find("MemFree") + 8;
            strMem = strMem.substr(pos);
            TrimStr(strMem);
            pos = strMem.find(" ");
            strMem = strMem.substr(0,pos);
            memFree = atol(strMem.c_str());
        }
        else if((strMem.find("Cached") != string::npos) && (strMem.find("SwapCached") == string::npos))
        {
            int pos = strMem.find("Cached") + 7;
            strMem = strMem.substr(pos);
            TrimStr(strMem);
            pos = strMem.find(" ");
            strMem = strMem.substr(0,pos);
            cachedFree = atol(strMem.c_str());
            
        }
    }
    fclose(fd);
    return memFree+cachedFree;
}
//获取验证结果信息及删除无法验证的记录
void FileOp::getRes(int res[3])
{
    FILE *fd;
    UINT32 a=0,b=0,c=0;
    char buff[256];
    vector<string> path;
    string resPath = homePath + "/Desktop/proofRes.txt";
    if(StrategyParam::orForCompition)
        resPath = FileOp::workSpace + "/proofRes.txt";
    if(access(resPath.c_str(), F_OK) == 0) {
        ;
    }
    else
        return;
    fd = fopen(resPath.c_str(),"r");//"/home/sjg/Desktop/proofRes.txt"
    while((fgets(buff,sizeof(buff),fd)) != NULL)
    {
        string strMem(buff);
        if(strMem.find("不可满足") != string::npos)
        {
            path.push_back(homePath + "/Desktop/output/" + strMem.substr(0,strMem.find_first_of(":")));
            a++;
        }
        else if(strMem.find("可满足") != string::npos)
        {
            b++;
        }
        else if(strMem.find("无法判定") != string::npos)
        {
            c++;
        }
    }
    res[0]=a;
    res[1]=b;
    res[2]=c;
    fclose(fd);
}
//20170227 清空文件内容
void FileOp::clearRes()
{
    if (StrategyParam::orForCompition == false) {
        FILE *fd;
        string resPath = FileOp::appPath + "/proofRes.txt";
        if(access(resPath.c_str(), F_OK) == 0) {
            fd = fopen(resPath.c_str(), "w+");
            fclose(fd);
        }
    }
}
//20170220  读取策略文件，解析并给策略类成员赋值
void FileOp::readStrategy()
{
    FILE *fd;
    string resPath = FileOp::appPath + "/strategy.txt";
    fd = fopen(resPath.c_str(),"r"); 
    if(fd == NULL)
        return;
    char buff[256];
    while((fgets(buff,sizeof(buff),fd)) != NULL)
    {
        string str(buff);
        //单元子句选取策略
        if (str.find("单元子句选取策略0") != string::npos){
            StrategyParam::unitChoose = 0;
            //cout<<"单元子句选取策略0"<<endl;
            continue;
        }
        else if (str.find("单元子句选取策略1") != string::npos){
            StrategyParam::unitChoose = 1;
            //cout<<"单元子句选取策略1"<<endl;
            continue;
        }
        else if (str.find("单元子句选取策略2") != string::npos){
            StrategyParam::unitChoose = 2;
            //cout<<"单元子句选取策略2"<<endl;
            continue;
        }
        else if (str.find("单元子句选取策略3") != string::npos){
            StrategyParam::unitChoose = 3;
            //cout<<"单元子句选取策略3"<<endl;
            continue;
        }
        else if (str.find("单元子句选取策略4") != string::npos){
            StrategyParam::unitChoose = 4;
            //cout<<"单元子句选取策略4"<<endl;
            continue;
        }
        //单元子句归结次数策略
        if (str.find("单元子句归结次数策略0") != string::npos){
            StrategyParam::unitDeduct = 0;
            //cout<<"单元子句归结次数策略0"<<endl;
            continue;
        }
        else if (str.find("单元子句归结次数策略1") != string::npos){
            StrategyParam::unitDeduct = 1;
            //cout<<"单元子句归结次数策略1"<<endl;
            continue;
        }
        else if (str.find("单元子句归结次数策略2") != string::npos){
            //cout<<"单元子句归结次数策略2"<<endl;
            StrategyParam::unitDeduct = 2;
            continue;
        }
        //单元子句冗余次数策略
        if (str.find("单元子句冗余次数策略0") != string::npos){
            //cout<<"单元子句冗余次数策略0"<<endl;
            StrategyParam::unitRedunt = 0;
            continue;
        }
        else if (str.find("单元子句冗余次数策略1") != string::npos){
            //cout<<"单元子句冗余次数策略1"<<endl;
            StrategyParam::unitRedunt = 1;
            continue;
        }
        else if (str.find("单元子句冗余次数策略2") != string::npos){
            //cout<<"单元子句冗余次数策略2"<<endl;
            StrategyParam::unitRedunt = 2;
            continue;
        }
        //单元子句稳定度策略
        if (str.find("单元子句稳定度策略0") != string::npos){
            //cout<<"单元子句稳定度策略0"<<endl;
            StrategyParam::unitSteady = 0;
            continue;
        }
        else if (str.find("单元子句稳定度策略1") != string::npos){
            //cout<<"单元子句稳定度策略1"<<endl;
            StrategyParam::unitSteady = 1;
            continue;
        }
        else if (str.find("单元子句稳定度策略2") != string::npos){
            //cout<<"单元子句稳定度策略2"<<endl;
            StrategyParam::unitSteady = 2;
            continue;
        }
        //单元子句函数嵌套层策略
        if (str.find("单元子句函数嵌套层策略0") != string::npos){
            //cout<<"单元子句函数嵌套层策略0"<<endl;
            StrategyParam::unitFuncLayer = 0;
            continue;
        }
        else if (str.find("单元子句函数嵌套层策略1") != string::npos){
            //cout<<"单元子句函数嵌套层策略1"<<endl;
            StrategyParam::unitFuncLayer = 1;
            continue;
        }
        else if (str.find("单元子句函数嵌套层策略2") != string::npos){
            //cout<<"单元子句函数嵌套层策略2"<<endl;
            StrategyParam::unitFuncLayer = 2;
            continue;
        }
        //候选子句选取策略
        if (str.find("候选子句选取策略0") != string::npos){
            //cout<<"候选子句选取策略0"<<endl;
            StrategyParam::candChoose = 0;
            continue;
        }
        else if (str.find("候选子句选取策略1") != string::npos){
            //cout<<"候选子句选取策略1"<<endl;
            StrategyParam::candChoose = 1;
            continue;
        }
        else if (str.find("候选子句选取策略2") != string::npos){
            //cout<<"候选子句选取策略2"<<endl;
            StrategyParam::candChoose = 2;
            continue;
        }
        else if (str.find("候选子句选取策略3") != string::npos){
            //cout<<"候选子句选取策略3"<<endl;
            StrategyParam::candChoose = 3;
            continue;
        }
        else if (str.find("候选子句选取策略4") != string::npos){
            //cout<<"候选子句选取策略4"<<endl;
            StrategyParam::candChoose = 4;
            continue;
        }
        //候选子句归结次数策略
        if (str.find("候选子句归结次数策略0") != string::npos){
            //cout<<"候选子句归结次数策略0"<<endl;
            StrategyParam::candDeduct = 0;
            continue;
        }
        else if (str.find("候选子句归结次数策略1") != string::npos){
            //cout<<"候选子句归结次数策略1"<<endl;
            StrategyParam::candDeduct = 1;
            continue;
        }
        else if (str.find("候选子句归结次数策略2") != string::npos){
            //cout<<"候选子句归结次数策略2"<<endl;
            StrategyParam::candDeduct = 2;
            continue;
        }
        //候选子句冗余次数策略
         if (str.find("候选子句冗余次数策略0") != string::npos){
             //cout<<"候选子句冗余次数策略0"<<endl;
            StrategyParam::candRedunt = 0;
            continue;
        }
        else if (str.find("候选子句冗余次数策略1") != string::npos){
            //cout<<"候选子句冗余次数策略1"<<endl;
            StrategyParam::candRedunt = 1;
            continue;
        }
        else if (str.find("候选子句冗余次数策略2") != string::npos){
            //cout<<"候选子句冗余次数策略2"<<endl;
            StrategyParam::candRedunt = 2;
            continue;
        }
        //候选子句文字数策略
         if (str.find("候选子句文字数策略0") != string::npos){
             //cout<<"候选子句文字数策略0"<<endl;
            StrategyParam::candClause = 0;
            continue;
        }
        else if (str.find("候选子句文字数策略1") != string::npos){
            //cout<<"候选子句文字数策略1"<<endl;
            StrategyParam::candClause = 1;
            continue;
        }
        else if (str.find("候选子句文字数策略2") != string::npos){
            //cout<<"候选子句文字数策略2"<<endl;
            StrategyParam::candClause = 2;
            continue;
        }
        //候选子句稳定度策略
       if (str.find("候选子句稳定度策略0") != string::npos){
           //cout<<"候选子句稳定度策略0"<<endl;
            StrategyParam::candSteady = 0;
            continue;
        }
        else if (str.find("候选子句稳定度策略1") != string::npos){
            //cout<<"候选子句稳定度策略1"<<endl;
            StrategyParam::candSteady = 1;
            continue;
        }
        else if (str.find("候选子句稳定度策略2") != string::npos){
            //cout<<"候选子句稳定度策略2"<<endl;
            StrategyParam::candSteady = 2;
            continue;
        }
        //单元子句归结次数最大值策略
         if (str.find("单元子句归结次数最大值策略") != string::npos){
            
            StrategyParam::unitDeductTimes = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"单元子句归结次数最大值策略"<<StrategyParam::unitDeductTimes<<endl;
            continue;
        }
        //单元子句归结次数更新策略
        if (str.find("单元子句归结次数更新策略0") != string::npos){
            //cout<<"单元子句归结次数更新策略0"<<endl;
            StrategyParam::unitDeductTimesUpdate = 0;
            continue;
        }
        else if (str.find("单元子句归结次数更新策略1") != string::npos){
            //cout<<"单元子句归结次数更新策略1"<<endl;
            StrategyParam::unitDeductTimesUpdate = 1;
            continue;
        }
        else if (str.find("单元子句归结次数更新策略2") != string::npos){
            //cout<<"单元子句归结次数更新策略2"<<endl;
            StrategyParam::unitDeductTimesUpdate = 2;
            continue;
        }
        else if (str.find("单元子句归结次数更新策略3") != string::npos){
            //cout<<"单元子句归结次数更新策略3"<<endl;
            StrategyParam::unitDeductTimesUpdate = 3;
            continue;
        }
        else if (str.find("单元子句归结次数更新策略4") != string::npos){
            //cout<<"单元子句归结次数更新策略4"<<endl;
            StrategyParam::unitDeductTimesUpdate = 4;
            continue;
        }
        //单元子句冗余次数最大值策略
        if (str.find("单元子句冗余次数最大值策略") != string::npos){
            StrategyParam::unitReduntTimes = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"单元子句冗余次数最大值策略"<<StrategyParam::unitReduntTimes<<endl;
            continue;
        }
        //单元子句冗余次数更新策略
         if (str.find("单元子句冗余次数更新策略0") != string::npos){
             //cout<<"单元子句冗余次数更新策略0"<<endl;
            StrategyParam::unitReduntTimesUpdate = 0;
            continue;
        }
        else if (str.find("单元子句冗余次数更新策略1") != string::npos){
            //cout<<"单元子句冗余次数更新策略1"<<endl;
            StrategyParam::unitReduntTimesUpdate = 1;
            continue;
        }
        else if (str.find("单元子句冗余次数更新策略2") != string::npos){
            //cout<<"单元子句冗余次数更新策略2"<<endl;
            StrategyParam::unitReduntTimesUpdate = 2;
            continue;
        }
        else if (str.find("单元子句冗余次数更新策略3") != string::npos){
            //cout<<"单元子句冗余次数更新策略3"<<endl;
            StrategyParam::unitReduntTimesUpdate = 3;
            continue;
        }
        else if (str.find("单元子句冗余次数更新策略4") != string::npos){
            //cout<<"单元子句冗余次数更新策略4"<<endl;
            StrategyParam::unitReduntTimesUpdate = 4;
            continue;
        }
        //候选子句归结次数最大值策略
        if (str.find("候选子句归结次数最大值策略") != string::npos){
            StrategyParam::candDeductTimes = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"候选子句归结次数最大值策略"<<StrategyParam::candDeductTimes<<endl;
            continue;
        }
        //候选子句归结次数更新策略
        if (str.find("候选子句归结次数更新策略0") != string::npos){
            //cout<<"候选子句归结次数更新策略0"<<endl;
            StrategyParam::candDeductTimesUpdate = 0;
            continue;
        }
        else if (str.find("候选子句归结次数更新策略1") != string::npos){
            //cout<<"候选子句归结次数更新策略1"<<endl;
            StrategyParam::candDeductTimesUpdate = 1;
            continue;
        }
        else if (str.find("候选子句归结次数更新策略2") != string::npos){
            //cout<<"候选子句归结次数更新策略2"<<endl;
            StrategyParam::candDeductTimesUpdate = 2;
            continue;
        }
        else if (str.find("候选子句归结次数更新策略3") != string::npos){
            //cout<<"候选子句归结次数更新策略3"<<endl;
            StrategyParam::candDeductTimesUpdate = 3;
            continue;
        }
        else if (str.find("候选子句归结次数更新策略4") != string::npos){
            //cout<<"候选子句归结次数更新策略4"<<endl;
            StrategyParam::candDeductTimesUpdate = 4;
            continue;
        }
        //候选子句冗余次数最大值策略
       if (str.find("候选子句冗余次数最大值策略") != string::npos){
            StrategyParam::candReduntTimes = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"候选子句冗余次数最大值策略"<<StrategyParam::candReduntTimes<<endl;
            continue;
        }
        //候选子句冗余次数更新策略
         if (str.find("候选子句冗余次数更新策略0") != string::npos){
             //cout<<"候选子句冗余次数更新策略0"<<endl;
            StrategyParam::candReduntTimesUpdate = 0;
            continue;
        }
        else if (str.find("候选子句冗余次数更新策略1") != string::npos){
            //cout<<"候选子句冗余次数更新策略1"<<endl;
            StrategyParam::candReduntTimesUpdate = 1;
            continue;
        }
        else if (str.find("候选子句冗余次数更新策略2") != string::npos){
            //cout<<"候选子句冗余次数更新策略2"<<endl;
            StrategyParam::candReduntTimesUpdate = 2;
            continue;
        }
        else if (str.find("候选子句冗余次数更新策略3") != string::npos){
            //cout<<"候选子句冗余次数更新策略3"<<endl;
            StrategyParam::candReduntTimesUpdate = 3;
            continue;
        }
        else if (str.find("候选子句冗余次数更新策略") != string::npos){
            //cout<<"候选子句冗余次数更新策略4"<<endl;
            StrategyParam::candReduntTimesUpdate = 4;
            continue;
        }
        //候选子句文字策略
        if (str.find("候选子句文字策略0") != string::npos){
            //cout<<"候选子句文字策略0"<<endl;
            StrategyParam::candLiteral = 0;
            continue;
        }
        else if (str.find("候选子句文字策略1") != string::npos){
            //cout<<"候选子句文字策略1"<<endl;
            StrategyParam::candLiteral = 1;
            continue;
        }
        else if (str.find("候选子句文字策略2") != string::npos){
            //cout<<"候选子句文字策略2"<<endl;
            StrategyParam::candLiteral = 2;
            continue;
        }
        //候选子句归结次数策略
        if (str.find("候选子句文字归结次数策略0") != string::npos){
            //cout<<"候选子句归结次数策略0"<<endl;
            StrategyParam::candLiteralDeductTimes = 0;
            continue;
        }
        else if (str.find("候选子句文字归结次数策略1") != string::npos){
            //cout<<"候选子句归结次数策略1"<<endl;
            StrategyParam::candLiteralDeductTimes = 1;
            continue;
        }
        else if (str.find("候选子句文字归结次数策略2") != string::npos){
            //cout<<"候选子句归结次数策略2"<<endl;
            StrategyParam::candLiteralDeductTimes = 2;
            continue;
        }
        //候选子句稳定度策略
        if (str.find("候选子句文字稳定度策略0") != string::npos){
            //cout<<"候选子句稳定度策略0"<<endl;
            StrategyParam::candLiteralSteady = 0;
            continue;
        }
        else if (str.find("候选子句文字稳定度策略1") != string::npos){
            //cout<<"候选子句稳定度策略1"<<endl;
            StrategyParam::candLiteralSteady = 1;
            continue;
        }
        else if (str.find("候选子句文字稳定度策略2") != string::npos){
            //cout<<"候选子句稳定度策略2"<<endl;
            StrategyParam::candLiteralSteady = 2;
            continue;
        }
        //R随机权重
        if ((str.find("R权重赋值策略0:") != string::npos)){
            StrategyParam::useRandrom = true;
            continue;
        }
        else if(str.find("R权重赋值策略1:") != string::npos)
        {
            StrategyParam::useRandrom = false;
            continue;
        }
        //R文字数大小策略
        if ((str.find("不允许小于原始子句文字最大数:") != string::npos)){
            StrategyParam::Rsmall = false;
            continue;
        }
        else if(str.find("允许小于原始子句文字最大数:") != string::npos)
        {
            StrategyParam::Rsmall = true;
            continue;
        }
         if ((str.find("不允许小于原始子句层数最大数:") != string::npos)){
            StrategyParam::RFsmall = false;
            continue;
        }
        else if(str.find("允许小于原始子句层数最大数:") != string::npos)
        {
            StrategyParam::RFsmall = true;
            continue;
        }
        //StrategyParam::RRes
        if ((str.find("不允许R因子归结:") != string::npos)){
            StrategyParam::RRes = false;
            continue;
        }
        else if(str.find("允许R因子归结:") != string::npos)
        {
            StrategyParam::RRes = true;
            continue;
        }
        if (str.find("R文字数大小策略") != string::npos){
            StrategyParam::R_MAX_NUM_TMP = stoi(str.substr(str.find_first_of(":") + 1));
            StrategyParam::R_MAX_NUM = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"R文字数大小策略"<<StrategyParam::R_MAX_NUM<<endl;
            //20170817
            if ((StrategyParam::R_MAX_NUM < StrategyParam::R_INIT_MAX_NUM) && !StrategyParam::Rsmall) {
                StrategyParam::R_MAX_NUM = StrategyParam::R_INIT_MAX_NUM;
                StrategyParam::R_MAX_NUM_TMP = StrategyParam::R_INIT_MAX_NUM;
            }
            continue;
        }
        //最大函数嵌套层限制
        if (str.find("R函数嵌套层") != string::npos){
            StrategyParam::R_MAX_FUNCLAYER = stoi(str.substr(str.find_first_of(":") + 1));
            StrategyParam::R_MAX_FUNCLAYER_TMP = stoi(str.substr(str.find_first_of(":") + 1));
//            if((StrategyParam::R_MAX_FUNCLAYER > StrategyParam::R_INIT_MAX_FUNCLAYER * 2)){
//                StrategyParam::R_MAX_FUNCLAYER = StrategyParam::R_INIT_MAX_FUNCLAYER * 2 + 1;
//                StrategyParam::R_MAX_FUNCLAYER_TMP = StrategyParam::R_INIT_MAX_FUNCLAYER * 2 + 1;
//            }
//            else
            if ((StrategyParam::R_MAX_FUNCLAYER < StrategyParam::R_INIT_MAX_FUNCLAYER) && !StrategyParam::RFsmall) {
                StrategyParam::R_MAX_FUNCLAYER = StrategyParam::R_INIT_MAX_FUNCLAYER* 2+1;
                StrategyParam::R_MAX_FUNCLAYER_TMP = StrategyParam::R_INIT_MAX_FUNCLAYER* 2+1;
            }
            continue;
        }
        //R权重大小
        if (str.find("R权重大小") != string::npos){
            StrategyParam::R_Weight = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"R权重大小"<<StrategyParam::R_Weight<<endl;
            continue;
        }
        if (str.find("R2文字数大小策略") != string::npos){
            StrategyParam::R_MAX_NUM_NOPAIR = stoi(str.substr(str.find_first_of(":") + 1));
            continue;
        }
        //中间归结式生成
//        if (str.find("中间归结式生成") != string::npos){
//            //cout<<"中间归结式生成"<<endl;
//            StrategyParam::midR = true;
//            continue;
//        }
//        else if(str.find("中间归结式不生成") != string::npos)
//        {
//            //cout<<"中间归结式不生成"<<endl;
//            StrategyParam::midR = false;
//            continue;
//        }
        if (str.find("R文字冗余策略0") != string::npos){
            //cout<<"中间归结式生成"<<endl;
            StrategyParam::litRundent = 1;
            continue;
        }
        else if(str.find("R文字冗余策略1") != string::npos)
        {
            //cout<<"中间归结式不生成"<<endl;
            StrategyParam::litRundent = 0;
            continue;
        }
        
        if (str.find("中间归结式生成策略0") != string::npos){
            //cout<<"中间归结式生成"<<endl;
            StrategyParam::midR = 0;
            continue;
        }
        else if(str.find("中间归结式生成策略1") != string::npos)
        {
            //cout<<"中间归结式不生成"<<endl;
            StrategyParam::midR = 1;
            continue;
        }
        else if(str.find("中间归结式生成策略2") != string::npos)
        {
            //cout<<"中间归结式不生成"<<endl;
            StrategyParam::midR = 2;
            continue;
        }
        else if(str.find("中间归结式生成策略3") != string::npos)
        {
            //cout<<"中间归结式不生成"<<endl;
            StrategyParam::midR = 3;
            continue;
        }
        else if(str.find("中间归结式生成策略4") != string::npos)
        {
            //cout<<"中间归结式不生成"<<endl;
            StrategyParam::midR = 4;
            continue;
        }
        else if(str.find("中间归结式生成策略5") != string::npos)
        {
            //cout<<"中间归结式不生成"<<endl;
            StrategyParam::midR = 5;
            continue;
        }
        else if(str.find("中间归结式生成策略6") != string::npos)
        {
            //cout<<"中间归结式不生成"<<endl;
            StrategyParam::midR = 6;
            continue;
        }
        else if(str.find("中间归结式生成策略7") != string::npos)
        {
            //cout<<"中间归结式不生成"<<endl;
            StrategyParam::midR = 1000;
            continue;
        }
        //项重写策略
         if (str.find("项重写策略0") != string::npos){
             //cout<<"宽深策略0"<<endl;
            StrategyParam::termRewriting = 0;
            continue;
        }
        else if (str.find("项重写策略1") != string::npos){
            //cout<<"宽深策略1"<<endl;
            StrategyParam::termRewriting = 1;
            continue;
        }
        else if (str.find("项重写策略2") != string::npos){
            //cout<<"宽深策略2"<<endl;
            StrategyParam::termRewriting = 2;
            continue;
        }
        //项重写大小策略
         if (str.find("替换项的大小策略0") != string::npos){
             //cout<<"宽深策略0"<<endl;
            StrategyParam::termRewritingSize  = 1;
            continue;
        }
        else if (str.find("替换项的大小策略1") != string::npos){
            //cout<<"宽深策略1"<<endl;
            StrategyParam::termRewritingSize  = 2;
            continue;
        }
        else if (str.find("替换项的大小策略2") != string::npos){
            //cout<<"宽深策略2"<<endl;
            StrategyParam::termRewritingSize  = 3;
            continue;
        }
        //宽深策略
         if (str.find("宽深策略0") != string::npos){
             //cout<<"宽深策略0"<<endl;
            StrategyParam::widthDeep = 0;
            continue;
        }
        else if (str.find("宽深策略1") != string::npos){
            //cout<<"宽深策略1"<<endl;
            StrategyParam::widthDeep = 1;
            continue;
        }
        else if (str.find("宽深策略2") != string::npos){
            //cout<<"宽深策略2"<<endl;
            StrategyParam::widthDeep = 2;
            continue;
        }
        //演绎深度策略
       if (str.find("演绎深度策略") != string::npos){
            StrategyParam::deductDeep = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"演绎深度策略"<<StrategyParam::deductDeep<<endl;
            continue;
        } 
        //演绎宽度策略 StrategyParam::deducWidth
        if (str.find("演绎宽度策略") != string::npos){
            StrategyParam::deducWidth = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"演绎深度策略"<<StrategyParam::deductDeep<<endl;
            continue;
        } 
        //迭代次数
        if (str.find("迭代次数") != string::npos){
            StrategyParam::iterTimes = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"迭代次数"<<StrategyParam::iterTimes<<endl;
            continue;
        } 
        //迭代轮数
         if (str.find("迭代轮数") != string::npos){
            StrategyParam::iterRing = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"迭代轮数"<<StrategyParam::iterRing<<endl;
            continue;
        } 
        //时间限制
         if (str.find("时间限制") != string::npos){
            StrategyParam::timeLimit = stod(str.substr(str.find_first_of(":") + 1))/60;
            //cout<<"时间限制"<<StrategyParam::timeLimit<<endl;
            //cout<<str<<endl;
            continue;
        } 
        //内存限制
        if (str.find("内存限制") != string::npos){
            StrategyParam::memLimit = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"内存限制"<<StrategyParam::memLimit<<endl;
            continue;
        } 
        //中间归结式冗余判断
        if (str.find("中间归结式冗余判断") != string::npos){
            //cout<<"中间归结式冗余判断"<<endl;
            StrategyParam::midRJudge = true;
            continue;
        }
        else if(str.find("中间归结式冗余不判断") != string::npos)
        {
            //cout<<"中间归结式冗余不判断"<<endl;
            StrategyParam::midRJudge = false;
            continue;
        }//StrategyParam::deductMode
        if (str.find("CSE版本0") != string::npos){
            //cout<<"中间归结式冗余判断"<<endl;
            StrategyParam::deductMode = 0;
            continue;
        }
        else if(str.find("CSE版本1") != string::npos)
        {
            //cout<<"中间归结式冗余不判断"<<endl;
            StrategyParam::deductMode = 1;
            StrategyParam::cseRunMode = 0;
            continue;
        }
        else if(str.find("CSE版本2") != string::npos)
        {
            //cout<<"中间归结式冗余不判断"<<endl;
            StrategyParam::deductMode = 1;
            StrategyParam::cseRunMode = 1;
            continue;
        }
        else if(str.find("CSE版本3") != string::npos)
        {
            //cout<<"中间归结式冗余不判断"<<endl;
            StrategyParam::deductMode = 1;
            StrategyParam::cseRunMode = 2;
            continue;
        }
        else if(str.find("CSE版本4") != string::npos)
        {
            //cout<<"中间归结式冗余不判断"<<endl;
            StrategyParam::deductMode = 1;
            StrategyParam::cseRunMode = 3;
            continue;
        }
        else if(str.find("CSE版本5") != string::npos)
        {
            //cout<<"中间归结式冗余不判断"<<endl;
            StrategyParam::deductMode = 1;
            StrategyParam::cseRunMode = 4;
            continue;
        }
        else if(str.find("CSE版本6") != string::npos)
        {
            //cout<<"中间归结式冗余不判断"<<endl;
            StrategyParam::deductMode = 1;
            StrategyParam::cseRunMode = 5;
            continue;
        }
        else if(str.find("CSE版本7") != string::npos)
        {
            //cout<<"中间归结式冗余不判断"<<endl;
            StrategyParam::deductMode = 1;
            StrategyParam::cseRunMode = 6;
            continue;
        }
        //StrategyParam::deduceDepth
        if (str.find("演绎最大深度") != string::npos){
            StrategyParam::deduceDepth = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"内存限制"<<StrategyParam::memLimit<<endl;
            continue;
        } 
        //20171024
        if (str.find("重复子句次数") != string::npos){
            StrategyParam::claReUseTimes = stoi(str.substr(str.find_first_of(":") + 1));
            StrategyParam::claReUseTimesTmp = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"内存限制"<<StrategyParam::memLimit<<endl;
            continue;
        } 
        //StrategyParam::singleUseUintCla
        if (str.find("浸透方法0") != string::npos){
            //cout<<"中间归结式冗余判断"<<endl;
            StrategyParam::useSaturate = true;
            continue;
        }
        else if(str.find("浸透方法1") != string::npos)
        {
            //cout<<"中间归结式冗余不判断"<<endl;
            StrategyParam::useSaturate = false;
            continue;
        }
        //重复使用单元子句策略
        if (str.find("重复单元子句策略0") != string::npos){
            StrategyParam::useCpUintCla = true;
            continue;
        }
        else if(str.find("重复单元子句策略1") != string::npos)
        {
            StrategyParam::useCpUintCla = false;
            continue;
        }
        
        //结合系统策略使用
        if (str.find("使用结合系统策略0") != string::npos){
            //cout<<"中间归结式冗余判断"<<endl;
            StrategyParam::useCombinedSys  = 0;
            continue;
        }
        else if(str.find("使用结合系统策略1") != string::npos)
        {
            //cout<<"中间归结式冗余不判断"<<endl;
            StrategyParam::useCombinedSys  = 1;
            continue;
        }
        else if(str.find("使用结合系统策略2") != string::npos)
        {
            //cout<<"中间归结式冗余不判断"<<endl;
            StrategyParam::useCombinedSys  = 2;
            continue;
        }
        else if(str.find("使用结合系统策略3") != string::npos)
        {
            //cout<<"中间归结式冗余不判断"<<endl;
            StrategyParam::useCombinedSys  = 3;
            continue;
        }
        //结合系统结合方式策略
        if (str.find("结合方式策略0") != string::npos){
            StrategyParam::useCombinedSysMethod  = 0;//加等词公理
            continue;
        }
        else if(str.find("结合方式策略1") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 1;//不加等词公理
            continue;
        }
        else if(str.find("结合方式策略2") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 2;//S+公理+R等词子句
            continue;
        }
        else if(str.find("结合方式策略3") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 3;//S+R等词子句
            continue;
        }
        else if(str.find("结合方式策略4") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 4;//S+公理+R文字数<=2
            continue;
        }
        else if(str.find("结合方式策略5") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 5;//S+R文字数<=2
            continue;
        }
        else if(str.find("结合方式策略6") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 6;//S+公理+R文字数<=3
            continue;
        }
        else if(str.find("结合方式策略7") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 7;//S+R文字数<=3
            continue;
        }
        else if(str.find("结合方式策略8") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 8;//S+公理+所有R
            continue;
        }
        else if(str.find("结合方式策略9") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 9;//S+所有R
            continue;
        }
        else if(str.find("结合方式策略10") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 10;//S+所有R
            continue;
        }
        else if(str.find("结合方式策略11") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 11;//S+所有R
            continue;
        }
        else if(str.find("结合方式策略12") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 12;//S+所有R
            continue;
        }
        else if(str.find("结合方式策略13") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 13;//S+所有R
            continue;
        }
        //结合R策略
        if (str.find("结合R策略0") != string::npos){
            StrategyParam::combinedRMode  = 0;//
            continue;
        }
        else if(str.find("结合R策略1") != string::npos)
        {
            StrategyParam::combinedRMode  = 1;//
            continue;
        }
        else if(str.find("结合R策略2") != string::npos)
        {
            StrategyParam::combinedRMode  = 2;//
            continue;
        }
        else if(str.find("结合R策略3") != string::npos)
        {
            StrategyParam::combinedRMode  = 3;//
            continue;
        }
        
        //等词使用频度策略
        if (str.find("等词使用频度策略0") != string::npos){
            StrategyParam::equalityUsedFrq  = 0;//
            continue;
        }
        else if(str.find("等词使用频度策略1") != string::npos)
        {
            StrategyParam::equalityUsedFrq  = 1;//
            continue;
        }
        else if(str.find("等词使用频度策略2") != string::npos)
        {
            StrategyParam::equalityUsedFrq  = 2;//
            continue;
        }
        
        
        if(str.find("预处理结合策略0") != string::npos){
            StrategyParam::preprocess  = 1;
            continue;
        }
        else if(str.find("预处理结合策略1") != string::npos){
            StrategyParam::preprocess  = 0;
            continue;
        }
        //预处理策略
        if ((str.find("因子归结预处理") != string::npos)&&(str.find("不因子归结预处理") == string::npos)){
            StrategyParam::factorRes = true;
            continue;
        }
        else if(str.find("不因子归结预处理") != string::npos)
        {
            StrategyParam::factorRes = false;
            continue;
        }
         if ((str.find("等词归结预处理") != string::npos)&&(str.find("不等词归结预处理") == string::npos)){
            StrategyParam::eqnRes  = true;
            continue;
        }
        else if(str.find("不等词归结预处理") != string::npos)
        {
            StrategyParam::eqnRes  = false;
            continue;
        }
         if ((str.find("删除纯文字子句") != string::npos)&&(str.find("不删除纯文字子句") == string::npos)){
            StrategyParam::delPureCla  = true;
            continue;
        }
        else if(str.find("不删除纯文字子句") != string::npos)
        {
            StrategyParam::delPureCla  = false;
            continue;
        }
        if ((str.find("目标子句预处理") != string::npos)&&(str.find("不目标子句预处理") == string::npos)){
            StrategyParam::goalCla  = true;
            continue;
        }
        else if(str.find("不目标子句预处理") != string::npos)
        {
            StrategyParam::goalCla  = false;
            continue;
        }
        //后面增加的策略
         if (str.find("单元子句排序规则0") != string::npos){
            StrategyParam::unitSortRule = 0;
            continue;
        }
        else if (str.find("单元子句排序规则1") != string::npos){
            StrategyParam::unitSortRule = 1;
            continue;
        }
        else if (str.find("单元子句排序规则2") != string::npos){
            StrategyParam::unitSortRule = 2;
            continue;
        }
        else if (str.find("单元子句排序规则3") != string::npos){
            StrategyParam::unitSortRule = 3;
            continue;
        }
        else if (str.find("单元子句排序规则4") != string::npos){
            StrategyParam::unitSortRule = 4;
            continue;
        }
        else if (str.find("单元子句排序规则5") != string::npos){
            StrategyParam::unitSortRule = 5;
            continue;
        }
        else if (str.find("单元子句排序规则6") != string::npos){
            StrategyParam::unitSortRule = 6;
            continue;
        }
        else if (str.find("单元子句排序规则7") != string::npos){
            StrategyParam::unitSortRule = 7;
            continue;
        }
        else if (str.find("单元子句排序规则8") != string::npos){
            StrategyParam::unitSortRule = 8;
            continue;
        }
        if (str.find("子句综合函数复杂度-1") != string::npos){
             StrategyParam::claFuncComp = -1;
             StrategyParam::funcFixDeepth = 36;
            continue;
        }
        else if (str.find("子句综合函数复杂度0") != string::npos){
             StrategyParam::claFuncComp = 0;
             StrategyParam::funcFixDeepth = StrategyParam::funcOrgFixDeepthMax + 1;//StrategyParam::funcOrgFixDeepthLessMax
             
            continue;
        }
        else if (str.find("子句综合函数复杂度1") != string::npos){
            StrategyParam::claFuncComp = 1;
            StrategyParam::funcFixDeepth = StrategyParam::funcOrgFixDeepthMax + StrategyParam::funcOrgFixDeepthLessMax;
            continue;
        }
        else if (str.find("子句综合函数复杂度2") != string::npos){
            StrategyParam::claFuncComp = 2;
            StrategyParam::funcFixDeepth = StrategyParam::funcOrgFixDeepthMax*2;
            continue;
        }
        else if (str.find("子句综合函数复杂度3") != string::npos){
            StrategyParam::claFuncComp = 3;
            StrategyParam::funcFixDeepth = StrategyParam::funcOrgFixDeepthMax*3;
            continue;
        }
        else if (str.find("子句综合函数复杂度4") != string::npos){
            StrategyParam::claFuncComp = 4;
            StrategyParam::funcFixDeepth = StrategyParam::funcOrgFixDeepthMax + 10;
            continue;
        }
        //StrategyParam::unitClaUpdate
        if (str.find("单元子句更换方式0") != string::npos){
             StrategyParam::unitClaUpdate = 0;
            continue;
        }
        else if (str.find("单元子句更换方式1") != string::npos){
             StrategyParam::unitClaUpdate = 1;
            continue;
        }else if (str.find("单元子句更换方式2") != string::npos){
             StrategyParam::unitClaUpdate = 2;
            continue;
        }
       if (str.find("非单元子句之间归结") != string::npos){
            StrategyParam::noUnitRes = true;
            continue;
        }
        else if(str.find("非单元子句之间不归结") != string::npos)
        {
            StrategyParam::noUnitRes = false;
            continue;
        }
        if (str.find("非单元子句约简与结论判断") != string::npos){
            StrategyParam::noUnitSimplify = true;
            continue;
        }
        else if(str.find("非单元子句约简与结论不判断") != string::npos)
        {
            StrategyParam::noUnitSimplify = false;
            continue;
        }//divideTri
        if ((str.find("拆分三角形输出") != string::npos)&&(str.find("不拆分三角形输出") == string::npos)){
            StrategyParam::divideTri = true;
            continue;
        }
        else if(str.find("不拆分三角形输出") != string::npos)
        {
            StrategyParam::divideTri = false;
            continue;
        }//divideTri
//         if ((str.find("不允许R小于原始子句最大数:") != string::npos)){
//            StrategyParam::Rsmall = false;
//            continue;
//        }
//        else if(str.find("允许R小于原始子句最大数:") != string::npos)
//        {
//            StrategyParam::Rsmall = true;
//            continue;
//        }
        if ((str.find("删除无法判定记录:") != string::npos)&&(str.find("不删除无法判定记录:") == string::npos)){
            StrategyParam::delRecord = true;
            continue;
        }
        else if(str.find("不删除无法判定记录:") != string::npos)
        {
            StrategyParam::delRecord = false;
            continue;
        }//
        if ((str.find("优先生成文字少的子句:") != string::npos)&&(str.find("不优先生成文字少的子句:") == string::npos)){
            StrategyParam::genLitClause = true;
            continue;
        }
        else if(str.find("不优先生成文字少的子句:") != string::npos)
        {
            StrategyParam::genLitClause = false;
            continue;
        }//StrategyParam::strategyMode
        if (str.find("多组合策略模式0") != string::npos){
             StrategyParam::strategyMode = 0;
            continue;
        }
        else if (str.find("多组合策略模式1") != string::npos){
             StrategyParam::strategyMode = 1;
            continue;
        }
        else if (str.find("多组合策略模式2") != string::npos) {
            StrategyParam::strategyMode = 0;
            continue;
        }
        //StrategyParam::noUintCla
        if (str.find("非单元子句限制策略0") != string::npos){
             StrategyParam::noUintCla = 0;
            continue;
        }
        else if (str.find("非单元子句限制策略1") != string::npos){
             StrategyParam::noUintCla = 1;
            continue;
        }
        else if (str.find("非单元子句限制策略2") != string::npos){
             StrategyParam::noUintCla = 2;
            continue;
        }
        else if (str.find("非单元子句限制策略3") != string::npos){
             StrategyParam::noUintCla = 3;
            continue;
        }
        else if (str.find("非单元子句限制策略4") != string::npos){
             StrategyParam::noUintCla = 4;
            continue;
        }
        else if (str.find("非单元子句限制策略5") != string::npos){
             StrategyParam::noUintCla = 5;
            continue;
        }
        else if (str.find("非单元子句限制策略6") != string::npos){
             StrategyParam::noUintCla = 6;
            continue;
        }
        else if (str.find("非单元子句限制策略7") != string::npos){
             StrategyParam::noUintCla = 7;
            continue;
        }
        else if (str.find("非单元子句限制策略8") != string::npos){
             StrategyParam::noUintCla = 8;
            continue;
        }
        
        if (str.find("目标深度模式0") != string::npos){
             StrategyParam::goalDeepth = 2;
            continue;
        }
        else if (str.find("目标深度模式1") != string::npos){
             StrategyParam::goalDeepth = 3;
            continue;
        }
        else if (str.find("目标深度模式2") != string::npos){
             StrategyParam::goalDeepth = 4;
            continue;
        }
        else if (str.find("目标深度模式3") != string::npos){
             StrategyParam::goalDeepth = 5;
            continue;
        }
        else if (str.find("目标深度模式4") != string::npos){
             StrategyParam::goalDeepth = 6;
            continue;
        }
        else if (str.find("目标深度模式5") != string::npos){
             StrategyParam::goalDeepth = 7;
            continue;
        }
        else if (str.find("目标深度模式6") != string::npos){
             StrategyParam::goalDeepth = 8;
            continue;
        }
        else if (str.find("目标深度模式7") != string::npos){
             StrategyParam::goalDeepth = 9;
            continue;
        }
        else if (str.find("目标深度模式8") != string::npos){
             StrategyParam::goalDeepth = 10;
            continue;
        }
        else if (str.find("目标深度模式9") != string::npos){
             StrategyParam::goalDeepth = 200;
            continue;
        }
        //锁子句约简
        if (str.find("锁子句约简模式0") != string::npos){
             StrategyParam::lockType = 1;
            continue;
        }
        else if (str.find("锁子句约简模式1") != string::npos){
             StrategyParam::lockType = 2;
            continue;
        }
        else if (str.find("锁子句约简模式2") != string::npos){
             StrategyParam::lockType = 3;
            continue;
        }
        else if (str.find("锁子句约简模式3") != string::npos){
             StrategyParam::lockType = 4;
            continue;
        }
        else if (str.find("锁子句约简模式4") != string::npos){
             StrategyParam::lockType = 5;
            continue;
        }
        else if (str.find("锁子句约简模式5") != string::npos){
             StrategyParam::lockType = 0;
            continue;
        }
        //项代换检查冗余StrategyParam::termReRedund
        if (str.find("冗余判断策略0") != string::npos){
             StrategyParam::termReRedund = true;
            continue;
        }
        else if (str.find("冗余判断策略1") != string::npos){
             StrategyParam::termReRedund = false;
            continue;
        }
        if (str.find("等词公理策略0") != string::npos){
             StrategyParam::equality = false;
            continue;
        }
        else if (str.find("等词公理策略1") != string::npos){
             StrategyParam::equality = true;
            continue;
        }
    }
    fclose(fd);
}

//20170708 自动模式更换策略
void FileOp::readStrategyN(int n)
{
    string strFile;
    strFile = FileOp::findStrategy(FileOp::strategyFile, n);
    FileOp::readBatchStrategy(strFile);//读取策略 FileOp::readBatchStrategy(FileOp::StrategyfileName[len]);
}

void FileOp::readStrategyNTptp(int n)
{
    string strFile;
    strFile = FileOp::findStrategyTptp(FileOp::strategyFile, n);
    
    cout<< "the " + to_string(n+1) + "th used strategy: "<< strFile << endl;
    FileOp::readBatchStrategy(strFile);//读取策略 FileOp::readBatchStrategy(FileOp::StrategyfileName[len]);
}

string FileOp::getStrategyNTptp(int n)
{
    string strFile;
    strFile = FileOp::findStrategyTptp(FileOp::strategyFile, n);
    return strFile;
}

//20170708  批量读取策略文件，解析并给策略类成员赋值
void FileOp::readBatchStrategy(string path)
{
    FILE *fd;
    //string resPath = homePath + "/Desktop/strategy.txt";
    fd = fopen(path.c_str(),"r"); 
    if(fd == NULL)
        return;
    char buff[256];
    while((fgets(buff,sizeof(buff),fd)) != NULL)
    {
        string str(buff);
        //单元子句选取策略
        if (str.find("单元子句选取策略0") != string::npos){
            StrategyParam::unitChoose = 0;
            //cout<<"单元子句选取策略0"<<endl;
            continue;
        }
        else if (str.find("单元子句选取策略1") != string::npos){
            StrategyParam::unitChoose = 1;
            //cout<<"单元子句选取策略1"<<endl;
            continue;
        }
        else if (str.find("单元子句选取策略2") != string::npos){
            StrategyParam::unitChoose = 2;
            //cout<<"单元子句选取策略2"<<endl;
            continue;
        }
        else if (str.find("单元子句选取策略3") != string::npos){
            StrategyParam::unitChoose = 3;
            //cout<<"单元子句选取策略3"<<endl;
            continue;
        }
        else if (str.find("单元子句选取策略4") != string::npos){
            StrategyParam::unitChoose = 4;
            //cout<<"单元子句选取策略4"<<endl;
            continue;
        }
        //单元子句归结次数策略
        if (str.find("单元子句归结次数策略0") != string::npos){
            StrategyParam::unitDeduct = 0;
            //cout<<"单元子句归结次数策略0"<<endl;
            continue;
        }
        else if (str.find("单元子句归结次数策略1") != string::npos){
            StrategyParam::unitDeduct = 1;
            //cout<<"单元子句归结次数策略1"<<endl;
            continue;
        }
        else if (str.find("单元子句归结次数策略2") != string::npos){
            //cout<<"单元子句归结次数策略2"<<endl;
            StrategyParam::unitDeduct = 2;
            continue;
        }
        //单元子句冗余次数策略
        if (str.find("单元子句冗余次数策略0") != string::npos){
            //cout<<"单元子句冗余次数策略0"<<endl;
            StrategyParam::unitRedunt = 0;
            continue;
        }
        else if (str.find("单元子句冗余次数策略1") != string::npos){
            //cout<<"单元子句冗余次数策略1"<<endl;
            StrategyParam::unitRedunt = 1;
            continue;
        }
        else if (str.find("单元子句冗余次数策略2") != string::npos){
            //cout<<"单元子句冗余次数策略2"<<endl;
            StrategyParam::unitRedunt = 2;
            continue;
        }
        //单元子句稳定度策略
        if (str.find("单元子句稳定度策略0") != string::npos){
            //cout<<"单元子句稳定度策略0"<<endl;
            StrategyParam::unitSteady = 0;
            continue;
        }
        else if (str.find("单元子句稳定度策略1") != string::npos){
            //cout<<"单元子句稳定度策略1"<<endl;
            StrategyParam::unitSteady = 1;
            continue;
        }
        else if (str.find("单元子句稳定度策略2") != string::npos){
            //cout<<"单元子句稳定度策略2"<<endl;
            StrategyParam::unitSteady = 2;
            continue;
        }
        //单元子句函数嵌套层策略
        if (str.find("单元子句函数嵌套层策略0") != string::npos){
            //cout<<"单元子句函数嵌套层策略0"<<endl;
            StrategyParam::unitFuncLayer = 0;
            continue;
        }
        else if (str.find("单元子句函数嵌套层策略1") != string::npos){
            //cout<<"单元子句函数嵌套层策略1"<<endl;
            StrategyParam::unitFuncLayer = 1;
            continue;
        }
        else if (str.find("单元子句函数嵌套层策略2") != string::npos){
            //cout<<"单元子句函数嵌套层策略2"<<endl;
            StrategyParam::unitFuncLayer = 2;
            continue;
        }
        //候选子句选取策略
        if (str.find("候选子句选取策略0") != string::npos){
            //cout<<"候选子句选取策略0"<<endl;
            StrategyParam::candChoose = 0;
            continue;
        }
        else if (str.find("候选子句选取策略1") != string::npos){
            //cout<<"候选子句选取策略1"<<endl;
            StrategyParam::candChoose = 1;
            continue;
        }
        else if (str.find("候选子句选取策略2") != string::npos){
            //cout<<"候选子句选取策略2"<<endl;
            StrategyParam::candChoose = 2;
            continue;
        }
        else if (str.find("候选子句选取策略3") != string::npos){
            //cout<<"候选子句选取策略3"<<endl;
            StrategyParam::candChoose = 3;
            continue;
        }
        else if (str.find("候选子句选取策略4") != string::npos){
            //cout<<"候选子句选取策略4"<<endl;
            StrategyParam::candChoose = 4;
            continue;
        }
        //候选子句归结次数策略
        if (str.find("候选子句归结次数策略0") != string::npos){
            //cout<<"候选子句归结次数策略0"<<endl;
            StrategyParam::candDeduct = 0;
            continue;
        }
        else if (str.find("候选子句归结次数策略1") != string::npos){
            //cout<<"候选子句归结次数策略1"<<endl;
            StrategyParam::candDeduct = 1;
            continue;
        }
        else if (str.find("候选子句归结次数策略2") != string::npos){
            //cout<<"候选子句归结次数策略2"<<endl;
            StrategyParam::candDeduct = 2;
            continue;
        }
        //候选子句冗余次数策略
         if (str.find("候选子句冗余次数策略0") != string::npos){
             //cout<<"候选子句冗余次数策略0"<<endl;
            StrategyParam::candRedunt = 0;
            continue;
        }
        else if (str.find("候选子句冗余次数策略1") != string::npos){
            //cout<<"候选子句冗余次数策略1"<<endl;
            StrategyParam::candRedunt = 1;
            continue;
        }
        else if (str.find("候选子句冗余次数策略2") != string::npos){
            //cout<<"候选子句冗余次数策略2"<<endl;
            StrategyParam::candRedunt = 2;
            continue;
        }
        //候选子句文字数策略
         if (str.find("候选子句文字数策略0") != string::npos){
             //cout<<"候选子句文字数策略0"<<endl;
            StrategyParam::candClause = 0;
            continue;
        }
        else if (str.find("候选子句文字数策略1") != string::npos){
            //cout<<"候选子句文字数策略1"<<endl;
            StrategyParam::candClause = 1;
            continue;
        }
        else if (str.find("候选子句文字数策略2") != string::npos){
            //cout<<"候选子句文字数策略2"<<endl;
            StrategyParam::candClause = 2;
            continue;
        }
        //候选子句稳定度策略
       if (str.find("候选子句稳定度策略0") != string::npos){
           //cout<<"候选子句稳定度策略0"<<endl;
            StrategyParam::candSteady = 0;
            continue;
        }
        else if (str.find("候选子句稳定度策略1") != string::npos){
            //cout<<"候选子句稳定度策略1"<<endl;
            StrategyParam::candSteady = 1;
            continue;
        }
        else if (str.find("候选子句稳定度策略2") != string::npos){
            //cout<<"候选子句稳定度策略2"<<endl;
            StrategyParam::candSteady = 2;
            continue;
        }
        //单元子句归结次数最大值策略
         if (str.find("单元子句归结次数最大值策略") != string::npos){
            
            StrategyParam::unitDeductTimes = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"单元子句归结次数最大值策略"<<StrategyParam::unitDeductTimes<<endl;
            continue;
        }
        //单元子句归结次数更新策略
        if (str.find("单元子句归结次数更新策略0") != string::npos){
            //cout<<"单元子句归结次数更新策略0"<<endl;
            StrategyParam::unitDeductTimesUpdate = 0;
            continue;
        }
        else if (str.find("单元子句归结次数更新策略1") != string::npos){
            //cout<<"单元子句归结次数更新策略1"<<endl;
            StrategyParam::unitDeductTimesUpdate = 1;
            continue;
        }
        else if (str.find("单元子句归结次数更新策略2") != string::npos){
            //cout<<"单元子句归结次数更新策略2"<<endl;
            StrategyParam::unitDeductTimesUpdate = 2;
            continue;
        }
        else if (str.find("单元子句归结次数更新策略3") != string::npos){
            //cout<<"单元子句归结次数更新策略3"<<endl;
            StrategyParam::unitDeductTimesUpdate = 3;
            continue;
        }
        else if (str.find("单元子句归结次数更新策略4") != string::npos){
            //cout<<"单元子句归结次数更新策略4"<<endl;
            StrategyParam::unitDeductTimesUpdate = 4;
            continue;
        }
        //单元子句冗余次数最大值策略
        if (str.find("单元子句冗余次数最大值策略") != string::npos){
            StrategyParam::unitReduntTimes = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"单元子句冗余次数最大值策略"<<StrategyParam::unitReduntTimes<<endl;
            continue;
        }
        //单元子句冗余次数更新策略
         if (str.find("单元子句冗余次数更新策略0") != string::npos){
             //cout<<"单元子句冗余次数更新策略0"<<endl;
            StrategyParam::unitReduntTimesUpdate = 0;
            continue;
        }
        else if (str.find("单元子句冗余次数更新策略1") != string::npos){
            //cout<<"单元子句冗余次数更新策略1"<<endl;
            StrategyParam::unitReduntTimesUpdate = 1;
            continue;
        }
        else if (str.find("单元子句冗余次数更新策略2") != string::npos){
            //cout<<"单元子句冗余次数更新策略2"<<endl;
            StrategyParam::unitReduntTimesUpdate = 2;
            continue;
        }
        else if (str.find("单元子句冗余次数更新策略3") != string::npos){
            //cout<<"单元子句冗余次数更新策略3"<<endl;
            StrategyParam::unitReduntTimesUpdate = 3;
            continue;
        }
        else if (str.find("单元子句冗余次数更新策略4") != string::npos){
            //cout<<"单元子句冗余次数更新策略4"<<endl;
            StrategyParam::unitReduntTimesUpdate = 4;
            continue;
        }
        //候选子句归结次数最大值策略
        if (str.find("候选子句归结次数最大值策略") != string::npos){
            StrategyParam::candDeductTimes = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"候选子句归结次数最大值策略"<<StrategyParam::candDeductTimes<<endl;
            continue;
        }
        //候选子句归结次数更新策略
        if (str.find("候选子句归结次数更新策略0") != string::npos){
            //cout<<"候选子句归结次数更新策略0"<<endl;
            StrategyParam::candDeductTimesUpdate = 0;
            continue;
        }
        else if (str.find("候选子句归结次数更新策略1") != string::npos){
            //cout<<"候选子句归结次数更新策略1"<<endl;
            StrategyParam::candDeductTimesUpdate = 1;
            continue;
        }
        else if (str.find("候选子句归结次数更新策略2") != string::npos){
            //cout<<"候选子句归结次数更新策略2"<<endl;
            StrategyParam::candDeductTimesUpdate = 2;
            continue;
        }
        else if (str.find("候选子句归结次数更新策略3") != string::npos){
            //cout<<"候选子句归结次数更新策略3"<<endl;
            StrategyParam::candDeductTimesUpdate = 3;
            continue;
        }
        else if (str.find("候选子句归结次数更新策略4") != string::npos){
            //cout<<"候选子句归结次数更新策略4"<<endl;
            StrategyParam::candDeductTimesUpdate = 4;
            continue;
        }
        //候选子句冗余次数最大值策略
       if (str.find("候选子句冗余次数最大值策略") != string::npos){
            StrategyParam::candReduntTimes = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"候选子句冗余次数最大值策略"<<StrategyParam::candReduntTimes<<endl;
            continue;
        }
        //候选子句冗余次数更新策略
         if (str.find("候选子句冗余次数更新策略0") != string::npos){
             //cout<<"候选子句冗余次数更新策略0"<<endl;
            StrategyParam::candReduntTimesUpdate = 0;
            continue;
        }
        else if (str.find("候选子句冗余次数更新策略1") != string::npos){
            //cout<<"候选子句冗余次数更新策略1"<<endl;
            StrategyParam::candReduntTimesUpdate = 1;
            continue;
        }
        else if (str.find("候选子句冗余次数更新策略2") != string::npos){
            //cout<<"候选子句冗余次数更新策略2"<<endl;
            StrategyParam::candReduntTimesUpdate = 2;
            continue;
        }
        else if (str.find("候选子句冗余次数更新策略3") != string::npos){
            //cout<<"候选子句冗余次数更新策略3"<<endl;
            StrategyParam::candReduntTimesUpdate = 3;
            continue;
        }
        else if (str.find("候选子句冗余次数更新策略") != string::npos){
            //cout<<"候选子句冗余次数更新策略4"<<endl;
            StrategyParam::candReduntTimesUpdate = 4;
            continue;
        }
        //候选子句文字策略
        if (str.find("候选子句文字策略0") != string::npos){
            //cout<<"候选子句文字策略0"<<endl;
            StrategyParam::candLiteral = 0;
            continue;
        }
        else if (str.find("候选子句文字策略1") != string::npos){
            //cout<<"候选子句文字策略1"<<endl;
            StrategyParam::candLiteral = 1;
            continue;
        }
        else if (str.find("候选子句文字策略2") != string::npos){
            //cout<<"候选子句文字策略2"<<endl;
            StrategyParam::candLiteral = 2;
            continue;
        }
        //候选子句归结次数策略
        if (str.find("候选子句文字归结次数策略0") != string::npos){
            //cout<<"候选子句归结次数策略0"<<endl;
            StrategyParam::candLiteralDeductTimes = 0;
            continue;
        }
        else if (str.find("候选子句文字归结次数策略1") != string::npos){
            //cout<<"候选子句归结次数策略1"<<endl;
            StrategyParam::candLiteralDeductTimes = 1;
            continue;
        }
        else if (str.find("候选子句文字归结次数策略2") != string::npos){
            //cout<<"候选子句归结次数策略2"<<endl;
            StrategyParam::candLiteralDeductTimes = 2;
            continue;
        }
        /*
         * 候选子句文字归结次数策略0:由低到高
            候选子句文字稳定度策略2:由低到高
         */
        //候选子句稳定度策略
        if (str.find("候选子句文字稳定度策略0") != string::npos){
            //cout<<"候选子句稳定度策略0"<<endl;
            StrategyParam::candLiteralSteady = 0;
            continue;
        }
        else if (str.find("候选子句文字稳定度策略1") != string::npos){
            //cout<<"候选子句稳定度策略1"<<endl;
            StrategyParam::candLiteralSteady = 1;
            continue;
        }
        else if (str.find("候选子句文字稳定度策略2") != string::npos){
            //cout<<"候选子句稳定度策略2"<<endl;
            StrategyParam::candLiteralSteady = 2;
            continue;
        }
        //R随机权重
        if ((str.find("R权重赋值策略0:") != string::npos)){
            StrategyParam::useRandrom = true;
            continue;
        }
        else if(str.find("R权重赋值策略1:") != string::npos)
        {
            StrategyParam::useRandrom = false;
            continue;
        }
        //R文字数大小策略
        if ((str.find("不允许小于原始子句文字最大数:") != string::npos)){
            StrategyParam::Rsmall = false;
            continue;
        }
        else if(str.find("允许小于原始子句文字最大数:") != string::npos)
        {
            StrategyParam::Rsmall = true;
            continue;
        }
         if ((str.find("不允许小于原始子句层数最大数:") != string::npos)){
            StrategyParam::RFsmall = false;
            continue;
        }
        else if(str.find("允许小于原始子句层数最大数:") != string::npos)
        {
            StrategyParam::RFsmall = true;
            continue;
        }
        //StrategyParam::RRes
        if ((str.find("不允许R因子归结:") != string::npos)){
            StrategyParam::RRes = false;
            continue;
        }
        else if(str.find("允许R因子归结:") != string::npos)
        {
            StrategyParam::RRes = true;
            continue;
        }
        if (str.find("R文字数大小策略") != string::npos){
            StrategyParam::R_MAX_NUM_TMP = stoi(str.substr(str.find_first_of(":") + 1));
            StrategyParam::R_MAX_NUM = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"R文字数大小策略"<<StrategyParam::R_MAX_NUM<<endl;
            //20170817
            if ((StrategyParam::R_MAX_NUM < StrategyParam::R_INIT_MAX_NUM) && !StrategyParam::Rsmall) {
                StrategyParam::R_MAX_NUM = StrategyParam::R_INIT_MAX_NUM;
                StrategyParam::R_MAX_NUM_TMP = StrategyParam::R_INIT_MAX_NUM;
            }
            continue;
        }
        //最大函数嵌套层限制
        if (str.find("R函数嵌套层") != string::npos){
            StrategyParam::R_MAX_FUNCLAYER = stoi(str.substr(str.find_first_of(":") + 1));
            StrategyParam::R_MAX_FUNCLAYER_TMP = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"R函数嵌套层"<<StrategyParam::R_MAX_FUNCLAYER<<endl;
            //20170817
//            if((StrategyParam::R_MAX_FUNCLAYER > StrategyParam::R_INIT_MAX_FUNCLAYER * 2) ){
//                StrategyParam::R_MAX_FUNCLAYER = StrategyParam::R_INIT_MAX_FUNCLAYER * 2 + 1;
//                StrategyParam::R_MAX_FUNCLAYER_TMP = StrategyParam::R_INIT_MAX_FUNCLAYER * 2 + 1;
//            }
//            else 
           if ((StrategyParam::R_MAX_FUNCLAYER < StrategyParam::R_INIT_MAX_FUNCLAYER) && !StrategyParam::RFsmall) {
                StrategyParam::R_MAX_FUNCLAYER = StrategyParam::R_INIT_MAX_FUNCLAYER * 2 + 1;
                StrategyParam::R_MAX_FUNCLAYER_TMP = StrategyParam::R_INIT_MAX_FUNCLAYER * 2 + 1;
            }
            continue;
        }
        //R权重大小
        if (str.find("R权重大小") != string::npos){
            StrategyParam::R_Weight = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"R权重大小"<<StrategyParam::R_Weight<<endl;
            continue;
        }
        if (str.find("R2文字数大小策略") != string::npos){
            StrategyParam::R_MAX_NUM_NOPAIR = stoi(str.substr(str.find_first_of(":") + 1));
            continue;
        }
        //中间归结式生成
//        if (str.find("中间归结式生成") != string::npos){
//            //cout<<"中间归结式生成"<<endl;
//            StrategyParam::midR = true;
//            continue;
//        }
//        else if(str.find("中间归结式不生成") != string::npos)
//        {
//            //cout<<"中间归结式不生成"<<endl;
//            StrategyParam::midR = false;
//            continue;
//        }
         if (str.find("R文字冗余策略0") != string::npos){
            //cout<<"中间归结式生成"<<endl;
            StrategyParam::litRundent = 1;
            continue;
        }
        else if(str.find("R文字冗余策略1") != string::npos)
        {
            //cout<<"中间归结式不生成"<<endl;
            StrategyParam::litRundent = 0;
            continue;
        }
        if (str.find("中间归结式生成策略0") != string::npos){
            //cout<<"中间归结式生成"<<endl;
            StrategyParam::midR = 0;
            continue;
        }
        else if(str.find("中间归结式生成策略1") != string::npos)
        {
            //cout<<"中间归结式不生成"<<endl;
            StrategyParam::midR = 1;
            continue;
        }
        else if(str.find("中间归结式生成策略2") != string::npos)
        {
            //cout<<"中间归结式不生成"<<endl;
            StrategyParam::midR = 2;
            continue;
        }
        else if(str.find("中间归结式生成策略3") != string::npos)
        {
            //cout<<"中间归结式不生成"<<endl;
            StrategyParam::midR = 3;
            continue;
        }
        else if(str.find("中间归结式生成策略4") != string::npos)
        {
            //cout<<"中间归结式不生成"<<endl;
            StrategyParam::midR = 4;
            continue;
        }
        else if(str.find("中间归结式生成策略5") != string::npos)
        {
            //cout<<"中间归结式不生成"<<endl;
            StrategyParam::midR = 5;
            continue;
        }
        else if(str.find("中间归结式生成策略6") != string::npos)
        {
            //cout<<"中间归结式不生成"<<endl;
            StrategyParam::midR = 6;
            continue;
        }
        else if(str.find("中间归结式生成策略7") != string::npos)
        {
            //cout<<"中间归结式不生成"<<endl;
            StrategyParam::midR = 1000;
            continue;
        }
        //宽深策略
         if (str.find("宽深策略0") != string::npos){
             //cout<<"宽深策略0"<<endl;
            StrategyParam::widthDeep = 0;
            continue;
        }
        else if (str.find("宽深策略1") != string::npos){
            //cout<<"宽深策略1"<<endl;
            StrategyParam::widthDeep = 1;
            continue;
        }
        else if (str.find("宽深策略2") != string::npos){
            //cout<<"宽深策略2"<<endl;
            StrategyParam::widthDeep = 2;
            continue;
        }
        //项重写策略
         if (str.find("项重写策略0") != string::npos){
             //cout<<"宽深策略0"<<endl;
            StrategyParam::termRewriting = 0;
            continue;
        }
        else if (str.find("项重写策略1") != string::npos){
            //cout<<"宽深策略1"<<endl;
            StrategyParam::termRewriting = 1;
            continue;
        }
        else if (str.find("项重写策略2") != string::npos){
            //cout<<"宽深策略2"<<endl;
            StrategyParam::termRewriting = 2;
            continue;
        }
         //项重写大小策略
         if (str.find("替换项的大小策略0") != string::npos){
             //cout<<"宽深策略0"<<endl;
            StrategyParam::termRewritingSize  = 1;
            continue;
        }
        else if (str.find("替换项的大小策略1") != string::npos){
            //cout<<"宽深策略1"<<endl;
            StrategyParam::termRewritingSize  = 2;
            continue;
        }
        else if (str.find("替换项的大小策略2") != string::npos){
            //cout<<"宽深策略2"<<endl;
            StrategyParam::termRewritingSize  = 3;
            continue;
        }
        //演绎深度策略
       if (str.find("演绎深度策略") != string::npos){
            StrategyParam::deductDeep = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"演绎深度策略"<<StrategyParam::deductDeep<<endl;
            continue;
        } 
        //演绎宽度策略 StrategyParam::deducWidth
        if (str.find("演绎宽度策略") != string::npos){
            StrategyParam::deducWidth = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"演绎深度策略"<<StrategyParam::deductDeep<<endl;
            continue;
        } 
        //迭代次数
        if (str.find("迭代次数") != string::npos){
            StrategyParam::iterTimes = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"迭代次数"<<StrategyParam::iterTimes<<endl;
            continue;
        } 
        //迭代轮数
         if (str.find("迭代轮数") != string::npos){
            StrategyParam::iterRing = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"迭代轮数"<<StrategyParam::iterRing<<endl;
            continue;
        } 
        //时间限制
         if (str.find("时间限制") != string::npos){
            StrategyParam::timeLimit = stod(str.substr(str.find_first_of(":") + 1))/60;
            //cout<<"时间限制"<<StrategyParam::timeLimit<<endl;
            //cout<<str<<endl;
            continue;
        } 
        //内存限制
        if (str.find("内存限制") != string::npos){
            StrategyParam::memLimit = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"内存限制"<<StrategyParam::memLimit<<endl;
            continue;
        } 
        //中间归结式冗余判断
        if (str.find("中间归结式冗余判断") != string::npos){
            //cout<<"中间归结式冗余判断"<<endl;
            StrategyParam::midRJudge = true;
            continue;
        }
        else if(str.find("中间归结式冗余不判断") != string::npos)
        {
            //cout<<"中间归结式冗余不判断"<<endl;
            StrategyParam::midRJudge = false;
            continue;
        }
        if (str.find("CSE版本0") != string::npos){
            //cout<<"中间归结式冗余判断"<<endl;
            StrategyParam::deductMode = 0;
            continue;
        }
        else if(str.find("CSE版本1") != string::npos)
        {
            //cout<<"中间归结式冗余不判断"<<endl;
            StrategyParam::deductMode = 1;
            StrategyParam::cseRunMode = 0;
            continue;
        }
        else if(str.find("CSE版本2") != string::npos)
        {
            //cout<<"中间归结式冗余不判断"<<endl;
            StrategyParam::deductMode = 1;
            StrategyParam::cseRunMode = 1;
            continue;
        }
        else if(str.find("CSE版本3") != string::npos)
        {
            //cout<<"中间归结式冗余不判断"<<endl;
            StrategyParam::deductMode = 1;
            StrategyParam::cseRunMode = 2;
            continue;
        }
        else if(str.find("CSE版本4") != string::npos)
        {
            //cout<<"中间归结式冗余不判断"<<endl;
            StrategyParam::deductMode = 1;
            StrategyParam::cseRunMode = 3;
            continue;
        }
        else if(str.find("CSE版本5") != string::npos)
        {
            //cout<<"中间归结式冗余不判断"<<endl;
            StrategyParam::deductMode = 1;
            StrategyParam::cseRunMode = 4;
            continue;
        }
        else if(str.find("CSE版本6") != string::npos)
        {
            //cout<<"中间归结式冗余不判断"<<endl;
            StrategyParam::deductMode = 1;
            StrategyParam::cseRunMode = 5;
            continue;
        }
        else if(str.find("CSE版本7") != string::npos)
        {
            //cout<<"中间归结式冗余不判断"<<endl;
            StrategyParam::deductMode = 1;
            StrategyParam::cseRunMode = 6;
            continue;
        }
        //StrategyParam::deduceDepth
        if (str.find("演绎最大深度") != string::npos){
            StrategyParam::deduceDepth = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"内存限制"<<StrategyParam::memLimit<<endl;
            continue;
        } 
        //重复使用单元子句策略
        if (str.find("重复单元子句策略0") != string::npos){
            StrategyParam::useCpUintCla = true;
            continue;
        }
        else if(str.find("重复单元子句策略1") != string::npos)
        {
            StrategyParam::useCpUintCla = false;
            continue;
        }
        //20171024
        if (str.find("重复子句次数") != string::npos){
            StrategyParam::claReUseTimes = stoi(str.substr(str.find_first_of(":") + 1));
            StrategyParam::claReUseTimesTmp = stoi(str.substr(str.find_first_of(":") + 1));
            //cout<<"内存限制"<<StrategyParam::memLimit<<endl;
            continue;
        } 
        //prover9使用
        if (str.find("使用结合系统策略0") != string::npos){
            //cout<<"中间归结式冗余判断"<<endl;
            StrategyParam::useCombinedSys  = 0;
            continue;
        }
        else if(str.find("使用结合系统策略1") != string::npos)
        {
            //cout<<"中间归结式冗余不判断"<<endl;
            StrategyParam::useCombinedSys  = 1;
            continue;
        }
        else if(str.find("使用结合系统策略2") != string::npos)
        {
            //cout<<"中间归结式冗余不判断"<<endl;
            StrategyParam::useCombinedSys  = 2;
            continue;
        }
        else if(str.find("使用结合系统策略3") != string::npos)
        {
            //cout<<"中间归结式冗余不判断"<<endl;
            StrategyParam::useCombinedSys  = 3;
            continue;
        }
         //结合系统结合方式策略
        if (str.find("结合方式策略0") != string::npos){
            StrategyParam::useCombinedSysMethod  = 0;//加等词公理
            continue;
        }
        else if(str.find("结合方式策略1") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 1;//不加等词公理
            continue;
        }
        else if(str.find("结合方式策略2") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 2;//S+公理+R等词子句
            continue;
        }
        else if(str.find("结合方式策略3") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 3;//S+R等词子句
            continue;
        }
        else if(str.find("结合方式策略4") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 4;//S+公理+R文字数<=2
            continue;
        }
        else if(str.find("结合方式策略5") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 5;//S+R文字数<=2
            continue;
        }
        else if(str.find("结合方式策略6") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 6;//S+公理+R文字数<=3
            continue;
        }
        else if(str.find("结合方式策略7") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 7;//S+R文字数<=3
            continue;
        }
        else if(str.find("结合方式策略8") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 8;//S+公理+所有R
            continue;
        }
        else if(str.find("结合方式策略9") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 9;//S+所有R
            continue;
        }
        else if(str.find("结合方式策略10") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 10;//S+所有R
            continue;
        }
        else if(str.find("结合方式策略11") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 11;//S+所有R
            continue;
        }
        else if(str.find("结合方式策略12") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 12;//S+所有R
            continue;
        }
        else if(str.find("结合方式策略13") != string::npos)
        {
            StrategyParam::useCombinedSysMethod  = 13;//S+所有R
            continue;
        }
        //结合R策略
        if (str.find("结合R策略0") != string::npos){
            StrategyParam::combinedRMode  = 0;//
            continue;
        }
        else if(str.find("结合R策略1") != string::npos)
        {
            StrategyParam::combinedRMode  = 1;//
            continue;
        }
        else if(str.find("结合R策略2") != string::npos)
        {
            StrategyParam::combinedRMode  = 2;//
            continue;
        }
        else if(str.find("结合R策略3") != string::npos)
        {
            StrategyParam::combinedRMode  = 3;//
            continue;
        }
        
        //等词使用频度策略
        if (str.find("等词使用频度策略0") != string::npos){
            StrategyParam::equalityUsedFrq  = 0;//
            continue;
        }
        else if(str.find("等词使用频度策略1") != string::npos)
        {
            StrategyParam::equalityUsedFrq  = 1;//
            continue;
        }
        else if(str.find("等词使用频度策略2") != string::npos)
        {
            StrategyParam::equalityUsedFrq  = 2;//
            continue;
        }
        
        if(str.find("预处理结合策略0") != string::npos){
            StrategyParam::preprocess  = 1;
            continue;
        }
        else if(str.find("预处理结合策略1") != string::npos){
            StrategyParam::preprocess  = 0;
            continue;
        }
        
        //StrategyParam::singleUseUintCla
        if (str.find("浸透方法0") != string::npos){
            //cout<<"中间归结式冗余判断"<<endl;
            StrategyParam::useSaturate = true;
            continue;
        }
        else if(str.find("浸透方法1") != string::npos)
        {
            //cout<<"中间归结式冗余不判断"<<endl;
            StrategyParam::useSaturate = false;
            continue;
        }
        //预处理策略
        if ((str.find("因子归结预处理") != string::npos)&&(str.find("不因子归结预处理") == string::npos)){
            StrategyParam::factorRes = true;
            continue;
        }
        else if(str.find("不因子归结预处理") != string::npos)
        {
            StrategyParam::factorRes = false;
            continue;
        }
         if ((str.find("等词归结预处理") != string::npos)&&(str.find("不等词归结预处理") == string::npos)){
            StrategyParam::eqnRes  = true;
            continue;
        }
        else if(str.find("不等词归结预处理") != string::npos)
        {
            StrategyParam::eqnRes  = false;
            continue;
        }
         if ((str.find("删除纯文字子句") != string::npos)&&(str.find("不删除纯文字子句") == string::npos)){
            StrategyParam::delPureCla  = true;
            continue;
        }
        else if(str.find("不删除纯文字子句") != string::npos)
        {
            StrategyParam::delPureCla  = false;
            continue;
        }
        if ((str.find("目标子句预处理") != string::npos)&&(str.find("不目标子句预处理") == string::npos)){
            StrategyParam::goalCla  = true;
            continue;
        }
        else if(str.find("不目标子句预处理") != string::npos)
        {
            StrategyParam::goalCla  = false;
            continue;
        }
        //后面增加的策略
         if (str.find("单元子句排序规则0") != string::npos){
            StrategyParam::unitSortRule = 0;
            continue;
        }
        else if (str.find("单元子句排序规则1") != string::npos){
            StrategyParam::unitSortRule = 1;
            continue;
        }
        else if (str.find("单元子句排序规则2") != string::npos){
            StrategyParam::unitSortRule = 2;
            continue;
        }
        else if (str.find("单元子句排序规则3") != string::npos){
            StrategyParam::unitSortRule = 3;
            continue;
        }
        else if (str.find("单元子句排序规则4") != string::npos){
            StrategyParam::unitSortRule = 4;
            continue;
        }
        else if (str.find("单元子句排序规则5") != string::npos){
            StrategyParam::unitSortRule = 5;
            continue;
        }
        else if (str.find("单元子句排序规则6") != string::npos){
            StrategyParam::unitSortRule = 6;
            continue;
        }
        else if (str.find("单元子句排序规则7") != string::npos){
            StrategyParam::unitSortRule = 7;
            continue;
        }
        else if (str.find("单元子句排序规则8") != string::npos){
            StrategyParam::unitSortRule = 8;
            continue;
        }
        if (str.find("子句综合函数复杂度-1") != string::npos){
             StrategyParam::claFuncComp = -1;
             StrategyParam::funcFixDeepth = 36;
            continue;
        }
        else if (str.find("子句综合函数复杂度0") != string::npos){
             StrategyParam::claFuncComp = 0;
             StrategyParam::funcFixDeepth = StrategyParam::funcOrgFixDeepthMax + 1;
            continue;
        }
        else if (str.find("子句综合函数复杂度1") != string::npos){
            StrategyParam::claFuncComp = 1;
            StrategyParam::funcFixDeepth = StrategyParam::funcOrgFixDeepthMax + StrategyParam::funcOrgFixDeepthLessMax;
            continue;
        }
        else if (str.find("子句综合函数复杂度2") != string::npos){
            StrategyParam::claFuncComp = 2;
            StrategyParam::funcFixDeepth = StrategyParam::funcOrgFixDeepthMax*2;
            continue;
        }
        else if (str.find("子句综合函数复杂度3") != string::npos){
            StrategyParam::claFuncComp = 3;
            StrategyParam::funcFixDeepth = StrategyParam::funcOrgFixDeepthMax*3;
            continue;
        }
        else if (str.find("子句综合函数复杂度4") != string::npos){
            StrategyParam::claFuncComp = 4;
            StrategyParam::funcFixDeepth = StrategyParam::funcOrgFixDeepthMax + 10;
            continue;
        }
        //StrategyParam::unitClaUpdate
        if (str.find("单元子句更换方式0") != string::npos){
             StrategyParam::unitClaUpdate = 0;
            continue;
        }
        else if (str.find("单元子句更换方式1") != string::npos){
             StrategyParam::unitClaUpdate = 1;
            continue;
        }else if (str.find("单元子句更换方式2") != string::npos){
             StrategyParam::unitClaUpdate = 2;
            continue;
        }
       if (str.find("非单元子句之间归结") != string::npos){
            StrategyParam::noUnitRes = true;
            continue;
        }
        else if(str.find("非单元子句之间不归结") != string::npos)
        {
            StrategyParam::noUnitRes = false;
            continue;
        }
        if (str.find("非单元子句约简与结论判断") != string::npos){
            StrategyParam::noUnitSimplify = true;
            continue;
        }
        else if(str.find("非单元子句约简与结论不判断") != string::npos)
        {
            StrategyParam::noUnitSimplify = false;
            continue;
        }//divideTri
        if ((str.find("拆分三角形输出") != string::npos)&&(str.find("不拆分三角形输出") == string::npos)){
            StrategyParam::divideTri = true;
            continue;
        }
        else if(str.find("不拆分三角形输出") != string::npos)
        {
            StrategyParam::divideTri = false;
            continue;
        }//divideTri
//         if ((str.find("不允许R小于原始子句最大数:") != string::npos)){
//            StrategyParam::Rsmall = false;
//            continue;
//        }
//        else if(str.find("允许R小于原始子句最大数:") != string::npos)
//        {
//            StrategyParam::Rsmall = true;
//            continue;
//        }
        if ((str.find("删除无法判定记录:") != string::npos)&&(str.find("不删除无法判定记录:") == string::npos)){
            StrategyParam::delRecord = true;
            continue;
        }
        else if(str.find("不删除无法判定记录:") != string::npos)
        {
            StrategyParam::delRecord = false;
            continue;
        }//
        if ((str.find("优先生成文字少的子句:") != string::npos)&&(str.find("不优先生成文字少的子句:") == string::npos)){
            StrategyParam::genLitClause = true;
            continue;
        }
        else if(str.find("不优先生成文字少的子句:") != string::npos)
        {
            StrategyParam::genLitClause = false;
            continue;
        }
        //StrategyParam::strategyMode
        if (str.find("多组合策略模式0") != string::npos){
             StrategyParam::strategyMode = 0;
            continue;
        }
        else if (str.find("多组合策略模式1") != string::npos){
             StrategyParam::strategyMode = 1;
            continue;
        }
        else if (str.find("多组合策略模式2") != string::npos) {
            StrategyParam::strategyMode = 0;
            continue;
        }
        //StrategyParam::noUintCla
        if (str.find("非单元子句限制策略0") != string::npos){
             StrategyParam::noUintCla = 0;
            continue;
        }
        else if (str.find("非单元子句限制策略1") != string::npos){
             StrategyParam::noUintCla = 1;
            continue;
        }
        else if (str.find("非单元子句限制策略2") != string::npos){
             StrategyParam::noUintCla = 2;
            continue;
        }
        else if (str.find("非单元子句限制策略3") != string::npos){
             StrategyParam::noUintCla = 3;
            continue;
        }
        else if (str.find("非单元子句限制策略4") != string::npos){
             StrategyParam::noUintCla = 4;
            continue;
        }
        else if (str.find("非单元子句限制策略5") != string::npos){
             StrategyParam::noUintCla = 5;
            continue;
        }
        else if (str.find("非单元子句限制策略6") != string::npos){
             StrategyParam::noUintCla = 6;
            continue;
        }
        else if (str.find("非单元子句限制策略7") != string::npos){
             StrategyParam::noUintCla = 7;
            continue;
        }
        else if (str.find("非单元子句限制策略8") != string::npos){
             StrategyParam::noUintCla = 8;
            continue;
        }
        
        if (str.find("目标深度模式0") != string::npos){
             StrategyParam::goalDeepth = 2;
            continue;
        }
        else if (str.find("目标深度模式1") != string::npos){
             StrategyParam::goalDeepth = 3;
            continue;
        }
        else if (str.find("目标深度模式2") != string::npos){
             StrategyParam::goalDeepth = 4;
            continue;
        }
        else if (str.find("目标深度模式3") != string::npos){
             StrategyParam::goalDeepth = 5;
            continue;
        }
        else if (str.find("目标深度模式4") != string::npos){
             StrategyParam::goalDeepth = 6;
            continue;
        }
        else if (str.find("目标深度模式5") != string::npos){
             StrategyParam::goalDeepth = 7;
            continue;
        }
        else if (str.find("目标深度模式6") != string::npos){
             StrategyParam::goalDeepth = 8;
            continue;
        }
        else if (str.find("目标深度模式7") != string::npos){
             StrategyParam::goalDeepth = 9;
            continue;
        }
        else if (str.find("目标深度模式8") != string::npos){
             StrategyParam::goalDeepth = 10;
            continue;
        }
        else if (str.find("目标深度模式9") != string::npos){
             StrategyParam::goalDeepth = 200;
            continue;
        }
        //锁子句约简
        if (str.find("锁子句约简模式0") != string::npos){
             StrategyParam::lockType = 1;
            continue;
        }
        else if (str.find("锁子句约简模式1") != string::npos){
             StrategyParam::lockType = 2;
            continue;
        }
        else if (str.find("锁子句约简模式2") != string::npos){
             StrategyParam::lockType = 3;
            continue;
        }
        else if (str.find("锁子句约简模式3") != string::npos){
             StrategyParam::lockType = 4;
            continue;
        }
        else if (str.find("锁子句约简模式4") != string::npos){
             StrategyParam::lockType = 5;
            continue;
        }
        else if (str.find("锁子句约简模式5") != string::npos){
             StrategyParam::lockType = 0;
            continue;
        }
        //项代换检查冗余StrategyParam::termReRedund
        if (str.find("冗余判断策略0") != string::npos){
             StrategyParam::termReRedund = true;
            continue;
        }
        else if (str.find("冗余判断策略1") != string::npos){
             StrategyParam::termReRedund = false;
            continue;
        }
        if (str.find("等词公理策略0") != string::npos){
             StrategyParam::equality = false;
            continue;
        }
        else if (str.find("等词公理策略1") != string::npos){
             StrategyParam::equality = true;
            continue;
        }
    }
    fclose(fd);
}
//插入最后解析结果
void FileOp::insertInfo(string str ,double time_s,UINT32 triTotalTimes)
{
    string strInfoPath = g_OutputPath + "/" + JudgeFileFullNameNoExt + ".info";
    ifstream ifFolFile(strInfoPath);
    vector<string> info;
    string strClause;
    while (getline(ifFolFile, strClause)) {
        info.push_back(strClause);
    }
    ifFolFile.close();
    remove(strInfoPath.c_str());
    PrintINFO(str);
    char saveTime[100];
    sprintf(saveTime,"%f",time_s);
    string strTime = "判定时间："+string(saveTime)+"秒";
    PrintINFO(strTime);
    char saveTimes[100];
    sprintf(saveTimes,"%u",triTotalTimes);
    string triTimes = "矛盾体个数："+ string(saveTimes);
    PrintINFO(triTimes);
    strClause = "****************";
    PrintINFO(strClause);
    for(UINT32 i = 0 ; i<info.size();i++)
        PrintINFO(info[i]);
}
void FileOp::copyAndDelOrgFile(string orgFile, string theoremFormat){
    ifstream fin(orgFile.c_str());
    
    size_t pos = orgFile.find_last_of('/');
    string strategyName = orgFile.substr(pos + 1);
    size_t posEnd = strategyName.find_last_of('.');
    string strategyNameNoExt = strategyName.substr(0, posEnd);

    string distFile = workSpace + "/unsat/" + strategyNameNoExt + "_" + JudgeFileFullNameNoExt + ".txt";
    ofstream fout(distFile.c_str());
    char str;
    while (fin.get(str)) {
        fout << str;
    }
    fin.close();
    fout.close();
    
    string strategyRecordFile = workSpace + "/unsat" + "/strategyRecord.txt";
    strategyRecord = new ofstream(strategyRecordFile.c_str(), ios::app);
    if(theoremFormat == "0")
        *strategyRecord << judgeOriginalFileName + ": " + distFile << endl;
    else
        *strategyRecord << JudgeFileFullNameNoExt + ": " + distFile << endl;
    strategyRecord->close();
}

void FileOp::convertCombinedClaFormat(){
    string sFol = "";
    string strClause;
    string strInfoPath = g_OutputPath + "/" + JudgeFileFullNameNoExt + ".combinedRes";
    ifstream ifFolFile(strInfoPath);
    while (getline(ifFolFile, strClause)) {
        if(strClause.find_first_of("[") == string::npos){
            continue;
        }
        TrimStr(strClause); //去除头尾空格
        string claNo = strClause.substr(strClause.find_first_of("[") + 1,strClause.find_first_of("]")-1);
        string claStr = strClause.substr(strClause.find_first_of("]") + 1);
        
        sFol.append("cnf(clause_");
        sFol.append(claNo);
        sFol.append(",plain,\n ( ");
//        if(claNo == "1069"){
//            cout<<claStr<<endl;
//            
//        }
        vector<string>sLits = Split_c(claStr, P_SPLIT_CAHR);
         for (int i = 0; i < sLits.size(); ++i) {
//            if (claNo == "1069") {
//                cout << sLits[i] << endl;
//
//            } 
            sFol.append(convertCombinedLitFormat(sLits[i]));
            if (i < sLits.size() - 1) {
                sFol.append(" | ");
            }
        }
        sFol.append(")).\n");
    }
    PrintInfoCombinedClasForRun(sFol);
    
    
}

//20210521 Liu 将.res文件中子句（即为第二次调用E的输入子句）转换成CNF格式
void FileOp::convertInputOfEprover() {
    bool isGoal = false;
    string sFol = "";
    string strClause;
    string strInfoPath = g_OutputPath + "/" + JudgeFileFullNameNoExt + ".res";
    ifstream ifFolFile(strInfoPath);
    while (getline(ifFolFile, strClause)) {
        if(strClause.find_first_of("[") == string::npos){
            continue;
        }
        if (strClause.find("GOAL") != string::npos)
            isGoal = true;        
        TrimStr(strClause); //去除头尾空格
        int startPos = strClause.find_first_of("[");
        int endPos = strClause.find_first_of("]");
        string claNo = strClause.substr(startPos + 1, endPos - (startPos + 1));
        string claStr = strClause.substr(strClause.find_first_of("]") + 1);
        cout << strClause << endl;
        sFol.append("cnf(clause_");
        sFol.append(claNo);
        
        if (isGoal) {
            sFol.append(",negated_conjecture,\n ( ");
            isGoal = false;
        }
        else {
            sFol.append(",plain,\n ( ");
        }
        
//        if(claNo == "1069"){
//            cout<<claStr<<endl;
//            
//        }
        vector<string>sLits = Split_c(claStr, P_SPLIT_CAHR);
        for (int i = 0; i < sLits.size(); ++i) {
//            if (claNo == "1069") {
//                cout << sLits[i] << endl;
//
//            } 
            //sFol.append(convertCombinedLitFormat(sLits[i])); //old-version
            //20210514
            string slit = convertCombinedLitFormat(sLits[i]);
            if (slit.find("(c5000)") != string::npos) {
                int endPos = slit.find("(");
                string tempStr = slit.substr(0, endPos);
                sFol.append(tempStr);
            }
            else {
                sFol.append(slit);
            }
            if (i < sLits.size() - 1) {
                sFol.append(" | ");
            }
        }
        sFol.append(")).\n");
    }
    PrintInfoForEprover(sFol);    
}

//读取文件，返回子句 


string FileOp::convertCombinedLitFormat(string& str){
    if (str.empty()) {
            return "";
        }
        string sb = "";
        int iPos = 0;
        
        // 标识是否为负文字
        bool isNav = (str[iPos] == '~');
        if (isNav) {
            ++iPos;
        }
        bool isEqn = false;//标识等词以及找到第一个等词项
        if (str[iPos] == 'E') //等词格式转换
        {
            iPos = str.find_first_of('(', iPos) + 1;
            char ch = str[iPos];
            if (ch == 'f') //函数
            {
                int iBracket = 0;
                while (iPos < str.size()) {

                    switch (ch) {
                        case '(':
                            ++iBracket;
                            sb += ch;
                            break;
                        case ')':
                            --iBracket;
                            sb += ch;
                            if (iBracket < 0) {
                                return "";
                            }
                            if (iBracket == 0) {
                                sb.append(isNav ? " != " : " = ");
                                isEqn = true;
                            }
                            break;
                        case 'P':
                            sb.append("p");
                            break;
                        case 'x':
                            sb.append("X");
                            break;
                        case 'a':
                            sb.append("c");
                            break;
                        default:
                            sb += ch;
                            break;
                    }

                    ++iPos;
                    ch = str[iPos];
                    if (isEqn) {
                        break;
                    }
                }
            } else {
                while (ch != ',') {
                    switch (ch) {
                        case 'x':
                            sb.append("X");
                            break;
                        case 'a':
                            sb.append("c");
                            break;
                        default:
                            sb += ch;
                            break;
                    }

                    ch = str[++iPos];
                }
                sb.append(isNav ? " != " : " = ");
                isEqn = true;
            }
            ++iPos;
        }
        if (!isEqn && isNav) {
            sb.append("~");
        }
        //其他谓词文字格式转换&等词第二个项
        for (; iPos < str.size(); ++iPos) {
            bool isbreak = false;
            char ch = str[iPos];
            switch (ch) {
                case 'P':
                    sb.append("p");
                    break;
                case 'x':
                    sb.append("X");
                    break;
                case 'a':
                    sb.append("c");
                    break;
                case '|':
                    isbreak = true;
                    break;
                default:
                    sb += ch;
                    break;
            }
            if (isbreak) {
                break;
            }
        }
        if (isEqn) //去掉最后一个括号
        {
            return sb.substr(0,sb.size() - 1);
        }
        return sb;

}

//20210530  打印proofStatistics.txt中的信息
void FileOp::PrintStatisticsMsg(const string& msg) {
    string strProofComp = appPath + "/proofStatistics.txt";
    ofProofComp = new ofstream(strProofComp.c_str(), ios::app);
    *ofProofComp << judgeOriginalFileName << ": " << msg << endl;
    ofProofComp->close();
}

//20210601 读取E的输出文件，并打印
bool FileOp::OutputForCompetition(const string& outputFile, double& executeTime, string& outMsg) {
    outMsg = "";
    //string tempStr = "/home/swjtu/Desktop/" + FileOp::judgeOriginalFileName + ".out";
    //ofstream fout(tempStr);
    bool isProof = false;
    //首先打印版本信息
    outMsg += "% Version  : CSG_E---1.0\n";
    outMsg += "% Problem  : " + FileOp::judgeOriginalFileName + ".p\n";
//    cout << "% Version  : CSE_E---1.3" << endl;
//    cout << "% Problem  : " << FileOp::judgeOriginalFileName << ".p" << endl;
    //fout << "% Version  : CSE_E---1.3" << endl;
    //fout << "% Problem  : " << FileOp::judgeOriginalFileName << ".p" << endl;
    //读取输出文件
    ifstream ifOutputFile(outputFile);
    
    string strLine = "";
    while (getline(ifOutputFile, strLine)) {
        if (strLine.find("#", 0) != string::npos) {
            if (strLine.find("Proof found!", 0) != string::npos) {
                //cout << "% Proof found!" << endl;
                outMsg += "% Proof found\n";
                outMsg += "% SZS status Theorem for " + FileOp::judgeOriginalFileName + ".p\n";
                outMsg += "% SZS output start Proof\n";
                //fout << "% Proof found!" << endl;
                isProof = true;
            }
//            else if (isProof && strLine.find("SZS status Theorem", 0) != string::npos) {
//                //cout << "% SZS status Theorem for " << FileOp::judgeOriginalFileName << ".p" << endl; 
//                outMsg += "% SZS status Theorem for " + FileOp::judgeOriginalFileName + ".p\n";
//                //fout << "% SZS status Theorem for " << FileOp::judgeOriginalFileName << ".p" << endl;
//            }
//            else if (isProof && strLine.find("SZS output start CNFRefutation", 0) != string::npos) {
//                //cout << "% SZS output start Proof" << endl;
//                outMsg += "% SZS status Theorem for " + FileOp::judgeOriginalFileName + ".p\n";
//                outMsg += "% SZS output start Proof\n";
//                //fout << "% SZS output start Proof" << endl;
////            }
//            else if (isProof && strLine.find("SZS output end CNFRefutation", 0) != string::npos) {
//                //cout << "% SZS output end Proof" << endl;
//                outMsg += "% SZS output end Proof\n";
//                //fout << "% SZS output end Proof" << endl;
//            }
            else if (isProof && strLine.find("Total time", 0) != string::npos) {
                outMsg += "% SZS output end Proof\n";
                //记录E耗费时间
                int beginPos = strLine.find(":");
                int endPos = strLine.find("s");
                string tempTime = strLine.substr(beginPos + 2, (endPos - 1) - (beginPos + 2));
                executeTime = stod(tempTime);
                //计算系统总时间
                executeTime += StrategyParam::parseTime;
                //打印时间信息
                //cout << "% Total time : " << executeTime << " s" << endl;
                outMsg += "% Total time : " + to_string(executeTime) + " s\n";
                //fout << "% Total time : " << executeTime << " s" << endl;
            }
        }
        else if (isProof && strLine != "") {
            //cout << strLine << endl;
            outMsg += strLine + "\n";
            //fout << strLine << endl;
        }
    }
    ifOutputFile.close();
    //fout.close();
    
    return isProof;    
}

 //20210602 第二次调用E
bool FileOp::SecondRunEprover(const double runTime, const string& cnfFile) {
    bool proofFound = false;
    eSecondOutputFile = g_OutputPath + "/" + judgeOriginalFileName + ".second_out";
    
    //cout << "***" << StrategyParam::ev2 << endl;
    //运行E
    double tmpRunT = 0.0;
    if (StrategyParam::ev2)
        tmpRunT = runTime * 2;
    string cmdRunE;
    if (StrategyParam::ev2 == 6)
        cmdRunE = "timeout " + to_string((int)tmpRunT) + " " + appPath + "/eprover" + " --delete-bad-limit=2000000000 --definitional-cnf=24 -s --print-statistics -R --print-version --proof-object --auto-schedule --cpu-limit="
                    + to_string((int)tmpRunT) + " " + cnfFile + " >> " + eSecondOutputFile;
    else if (StrategyParam::ev2 == 5)
        cmdRunE = "timeout " + to_string((int)runTime) + " " + appPath + "/Other/eprover" + " --delete-bad-limit=2000000000 --definitional-cnf=24 -s --print-statistics -R --print-version --proof-object --auto-schedule --cpu-limit="
                    + to_string((int)runTime) + " " + cnfFile + " >> " + eSecondOutputFile;
    //cout << "secondRunE: cmdRunE" << cmdRunE << endl;
    int resRunE = system(const_cast<char*> (cmdRunE.c_str())); 
    //打印信息
    StrategyParam::start = clock();
    ifstream fin(eSecondOutputFile);
    string strLine = "";
    while (getline(fin, strLine)) {
        if (strLine.find("Proof found!", 0) != string::npos) {
            proofFound = true;
            break;
        }  
    }
    
    return proofFound;    
}  
