/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   DataStructure.cpp
 * Author: sjg
 * 该类用于保存数据、其它中间数据
 * Created on 2016年11月1日, 上午9:08
 */

#include "DataStructure.h"
#include "RedundancyOp.h"
#include "Clause.h"
#include "Literal.h"
#include "Term.h"

DataStructure::DataStructure() {
}

DataStructure::DataStructure(const DataStructure& orig) {
}

DataStructure::~DataStructure() {
}
RESULT DataStructure::GenerateCNF()
{

	switch (FileOp::fileType)
	{
	case TPTP:
		return ReadTPTPFile();		
	case FOF: break;
	case MYDefine:	
	default: break;
	}	
}
RESULT DataStructure::ReadTPTPFile()
{
    //读取文件
    string strClause;
    uOrigClaSize = 1; //行号
    ifstream ifFolFile(FileOp::JudgeFileFullName.c_str(),ifstream::in);
    string strINFO;
    int iBracketNum = 0;
    vector< vector<string> >  vEqn;
    bool isAxiom = false;
    while (getline(ifFolFile, strClause)) {
        strClause = InitFunction::TrimStr(strClause); //去除头尾空格
        if (strClause.length() == 0 || strClause[0] == '%') continue; //空行和%--注释语句 不读取
        vector<string>vectLit; //保存子句中的文字
        if (strClause[0] == 'c') //进入CNF 子句注释
        {
            int index = strClause.find("clause", 3);
            isAxiom = (index == -1);
            iBracketNum = 1;
            continue;
        }
        if (iBracketNum > 0) {
            bool isEqnLit = false;
            bool isFinish = false;
            string strLit;
            for (int i = 0; i < strClause.length(); ++i) {
                if (isFinish)break;
                if (strClause[i] == ' ')continue; //空格不进行计算
                if (strClause[i] == '(') {
                    if (iBracketNum > 1) strLit += '(';
                    ++iBracketNum;
                    while (strClause[++i] == ' ') {
                    }
                    //
                    //修改
                    if (strClause[i] >= '0' && strClause[i] <= '9') {
                        strLit += "a" + InitFunction::to_String(200 + strClause[i] - '0' + 1);
                        i++;
                    }
                }
                //修改
                if (strClause[i] == ',') {
                    strLit += strClause[i];
                    while (strClause[++i] == ' ') {
                    }
                    //修改
                    if (strClause[i] >= '0' && strClause[i] <= '9') {
                        strLit += "a" + InitFunction::to_String(200 + strClause[i] - '0' + 1);
                        i++;
                    }
                }
                if (strClause[i] == ')')--iBracketNum;
                //一个文字读取完毕
                if (strClause[i] == '|' || iBracketNum == 1) {

                    if (isEqnLit) {
                        strLit += ')';
                        isEqnLit = false;
                    }
                    //某文字仅用一个谓词符号表示则自动添加（a） 如：P+P2(x1) 变为 P(a)
                    if (strLit.find('(') == -1) {
                        strLit += "(a)";
                    }

                    //对文字中含有“$true”，“~true”，“$false”，“~false”
                    int iPosA = strLit.find("$true");
                    int iPosB = strLit.find("~$false");

                    if (iPosA>-1 || iPosB>-1) //删除子句
                    {
                        strLit = "";
                        i = strClause.length();
                        continue;
                    }
                    iPosA = strLit.find("~$true");
                    iPosB = strLit.find("$false");
                    if (!(iPosA>-1)&&!(iPosB>-1))//删除文字
                    {
                        vectLit.push_back(strLit);
                    }
                    strLit = "";
                    if (strClause[i] == '|')continue;
                }
                //子句读取完毕 退出读取下一条子句
                if (iBracketNum == 1) {
                    isFinish = true;
                    if (isAxiom) //等词公理 放后面处理
                    {
                        vEqn.push_back(vectLit);
                        break;
                    }
                    //输入时，判断是否为恒真子句，是则跳过不输入，NOTE：为了保证输出的一致性，这里子句序号还是需要记录
                    if (vectLit.size() > 1 && RedundancyOp::CheckTautology(vectLit)) {
                        ++uOrigClaSize;
                        break;
                    }
                   //此时需要将转化后的问题格式存储
                
                    //数据存储完
                    for(size_t uCol=0;uCol<vectLit.size();++uCol)//生成子句
                    {
                        *FileOp::ofJudgeFileResult << vectLit[uCol];
                    }
                    *FileOp::ofJudgeFileResult << endl;
                    continue;
                }
                char ch = strClause[i];
                if (ch >= 'A' && ch <= 'Z' && ch != 'X')
                    strLit += ('x' + InitFunction::to_String(ch - 'A' + 1));
                else {
                    switch (ch) {
                        case 'p':ch = 'P';
                            break;
                        case 'X':ch = 'x';
                            break;
                        case 'c':ch = 'a';
                            break;
                        case '=':
                            if (isEqnLit)//表示有2个==出现 则报错
                                return READERR;
                            ch = ',';
                            strLit = "E(" + strLit;
                            isEqnLit = true;
                            break;
                        case '!':
                            if (strClause[++i] == '=') {
                                ch = ',';
                                strLit = "~E(" + strLit;
                                isEqnLit = true;
                            }
                            break;
                        default:
                            break;
                    }
                    strLit += ch;
                }
                //修改
                if (strClause[i] == '=') {
                    while (strClause[++i] == ' ') {
                    }
                    if (strClause[i] >= '0' && strClause[i] <= '9') {
                        strLit += "a" + InitFunction::to_String(200 + strClause[i] - '0' + 1);
                    } else
                        --i;
                }
            }
        }
    }
    StrategyFunction::O_ClauseNum = uOrigClaSize - 1;
    //最后添加等词公式 
    for (size_t eLitInd = 0; eLitInd < vEqn.size(); ++eLitInd) {
        vector<string>&vectLit = vEqn[eLitInd];
        //此处保存等词到数据库中
        for (size_t uCol = 0; uCol < vectLit.size(); ++uCol)//生成子句
        {
            *FileOp::ofJudgeFileResult << vectLit[uCol];
        }
        *FileOp::ofJudgeFileResult << endl;
    }
    //在INFO信息表中输出 处理后的子句集信息（排序后）
    FileOp::ofJudgeFileResult->close();
    return READOK;
}
