/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   Clause.h
 * Author: sjg
 *
 * Created on 2016年11月18日, 上午11:26
 */

#ifndef CLAUSE_H
#define CLAUSE_H
#include"dataTypeDef.h"
#include"HashNode.h"
#include "Literal.h"
#include "HashTree.h"
#include"globalFunc.h"
#include "StrategyParam.h"
class Clause {
    set<HashNode*, HashNodeCmpByCode> setHashTree; //每个子句存放复合项,此处存放带变元的复合项
public:
    UINT32 uClaId; //子句编号
    Literal** LitPtr; //文字列表
    /*同一子句中相同变元共享同一个内存地址--而且是有序的*/
    //set<Term*, VarTermCmp> setVarS;	
    map<INT32, Term*> mapSharedVars;
    float Priority;
    UINT16 uLitNum; //文字个数  UINT8 改成 UINT16
    UINT16 uVarCount; //变元总个数	
    UINT16 uFuncDepth; //函数嵌套总数
    UINT16 uReuseTimes; //自归结次数
    UINT32 adeductNum;//主动归结次数
    UINT32 pdeductNum;//被动归结次数
    bool isSDeduct;//是否在构建三角形时参与归结
    //20170220
    UINT32 reduntTimes; //冗余次数
    bool isUse;//判断子句是否使用
    bool isAxtom;
    bool isGoal;
    bool isPureCla;
    ClaState clast;//子句的状态
    int noUnitDeductTimes;
    bool demodulator;//针对等词 如果是左项大于右项时为true 如果是左项小于右项为false
    bool orgCla;//为true,原始子句,否则为生成的子句
    UINT8 goaldeepth;
    UINT8 deduceDeepth;
    Literal* copyFrom;//记录拷贝子句归结的主动文字
    Literal* copyTo;//记录拷贝子句归结的被动文字
    Clause* topCopyCla;//记录最顶层的被拷贝子句
    bool noPairResFiFg;
    //以下用于刻画子句在子句集中的信息
    UINT32 maxPred;//子句在子句集中出现的最大次数的文字
    UINT32 minPred;//子句在子句集中出现的最小次数的文字
    UINT32 maxPairPred;//子句在子句集中出现的最大次数的互补对文字
    UINT32 minPairPred;//子句在子句集中出现的最小次数的互补对文字
    UINT8 claAttr;//子句的属性,0表示基子句,1表示只含独立变元子句,2表示含共享变元子句
    UINT16 termCount12;//子句中的项计数,目前常元记1,函数项记1,变元项记2
    UINT16 termCount11;//子句中的项计数,目前常元记1,函数项记1,变元项记1
    UINT16 termCount21;//子句中的项计数,目前常元记2,函数项记2,变元项记1
    //构造/析构函数 ============================================
    Clause(vector<string>&vectsLit, UINT32 _claId);
    UINT32 FstTermCode(char*& ch);
    Term* GenerateTerm(char*& sLit);
    Term* GenerateTerm_PredWithoutSubTerm(const string& pred_str);

    Clause(UINT32 _claId, UINT16 _reUseTimes) : Priority(0), uLitNum(0), uVarCount(0), uFuncDepth(0), uReuseTimes(_reUseTimes),adeductNum(0),pdeductNum(0),isSDeduct(false),reduntTimes(0),
    isUse(false),isAxtom(false),isGoal(false),isPureCla(false),clast(noState),demodulator(false),orgCla(false),goaldeepth(litWeight),deduceDeepth(0),copyFrom(nullptr),copyTo(nullptr),topCopyCla(nullptr),
    noPairResFiFg(false),maxPred(0),minPred(0),maxPairPred(0),minPairPred(0),claAttr(0),termCount12(0),termCount11(0),termCount21(0){
        //设置自归结ID		 
        uClaId = _claId | (_reUseTimes << 28);
        noUnitDeductTimes = 0;
    };
    void DelLits(bool isDelPred = true);
    void DelOneLit(Literal* lit, bool isDelPred = true);
    
    Clause();
    Clause(const Clause& orig);
    virtual ~Clause();
    //======================================================

    //方法函数 ===============================================
    //独立变元总个数（singleton）

    inline UINT32 MaxVarId() const {
        return mapSharedVars.size();
    }
    //对子句中的文字进行排序
    void SortLit();
    void SortLitDuct();
    //返回字符串表示
    void toString(string&str);
    void addRForCompetiton();
    void toPureString(string&sCla);
    string ToStringWithSemantics(const string& clause_str);
    //输出子句
    void Print();
    int compFuncDeepthCla();
    //判断子句是否有替换项
    bool HasTermBind();
    void initOrgClaAttr();//子句初始化属性
    UINT32 countClaTermE(UINT8 funCoff, UINT8 varCoff);//统计项
    //20170901 以下用于等词处理
    void exEqnTerm();
    void directEqn();
    //在子句中插入共享变元 //此处的iVarCode

    Term* VBInsert(INT32 iVarCode, UINT16&uMaxVarId) {
        uMaxVarId = 0;
        if (mapSharedVars.find(iVarCode) == mapSharedVars.end()) {
            uMaxVarId = mapSharedVars.size() + 1;
            Term* newT = new Term(EncodeVar(uClaId, uMaxVarId)); //变元项，uMaxVarId为变元项在map中的位置
            newT->uVarCount = 1;
            newT->uMaxVarId = uMaxVarId;
            newT->termSt = isSingleVar;
            mapSharedVars.insert(make_pair(iVarCode, newT)); //插入到map中，其中iVarCode为键值，相同的变元兼职相同			
        }
        else
            mapSharedVars[iVarCode]->termSt = isShareVar;
        return mapSharedVars[iVarCode];

    }
    //插入变元函数项

    inline Term* InsertVarFuncTerm(Term* newSubT) {
        return HashTree::InsertHashTree(newSubT, setHashTree);
    }
    //20170516 判断子句是否含有非共享项文字
    inline bool hasConLit(){
        for(int m=0;m<uLitNum;m++){
            if(!(LitPtr[m]->isShareVarLiteral()))
                return true;
        }
        return false;
    }
    //20170817 判断子句是否有相同谓词的文字
    inline bool hasSamePredict(){
        if(uLitNum == 1)
            return false;
        for(int m=0;m<uLitNum-1;m++){
            for(int n=m+1;n<uLitNum;n++){
                if(LitPtr[m]->subTerm->iTermCode == LitPtr[n]->subTerm->iTermCode){
                    return true;
                }
            }
        }
        return false;
    }
    //判断子句是否使用
    inline int hasUsed() const{
        if(isUse)
            return 1;
        else 
            return 0;
    }
    //子句是否是正等词单元子句
    inline bool isUintEqn(){
        if(uLitNum != 1)
            return false;
        else if(GetCodeProp(LitPtr[0]->subTerm->iTermCode) == TEqn) 
            return true;
        else
            return false;
    }
    //是否是E(x1,x1)子句
    inline bool isequEqn(){
        if((uLitNum == 1) &&(GetCodeProp(LitPtr[0]->subTerm->iTermCode) ==TEqn) && (LitPtr[0]->subTerm->subTermPtr[0] == LitPtr[0]->subTerm->subTermPtr[1]))
            return true;
        else
            return false;
    }
    //是否是简单项
    inline bool isSimplyEqn(){
        if((uLitNum == 1) &&(GetCodeProp(LitPtr[0]->subTerm->iTermCode) ==TEqn)){
             Term* left = LitPtr[0]->subTerm->subTermPtr[0];
             Term* right = LitPtr[0]->subTerm->subTermPtr[1];
             UINT32 leftTerm = 0;
             UINT32 rightTerm = 0;
             left->countTerm(leftTerm);
             right->countTerm(rightTerm);
             if((leftTerm - rightTerm) >= 3)
                return true;
             else
                 return false;
        }
        else
            return false;
    }
    inline bool hasOnlyNegEqn(){
        int n = 0;
        for(int m=0;m<uLitNum;m++){
            if(LitPtr[m]->subTerm->isNegEqnTerm()){
                ++n;
            }
        }
        if(n==1)
            return true;
        else
            return false;
    }
    inline bool hasNegEqn() {
        for (int m = 0; m < uLitNum; m++) {
            if (LitPtr[m]->subTerm->isNegEqnTerm()) {
                return true;
            }
        }
        return false;
    }
    inline bool hasEqn() {//子句有等词文字
        for (int m = 0; m < uLitNum; m++) {
            if (LitPtr[m]->subTerm->isNegEqnTerm() || LitPtr[m]->subTerm->isPosEqnTerm()) {
                return true;
            }
        }
        return false;
    }
    inline bool hasPLit(){
        for(int m=0;m<uLitNum;m++){
            if(LitPtr[m]->subTerm->isPLitTerm()){
                return true;
            }
        }
        return false;
    }
    inline bool isGoalCla(){
        int countLit=0;
        for(int m=0;m<uLitNum;m++){
            if(LitPtr[m]->subTerm->isNegLit()){
                ++countLit;
            }
        }
        if(countLit == uLitNum)
            return true;
        else
            return false;
    }
    inline bool judgeGoalCla(){
        for(int i=0;i<StrategyParam::goalClaId.size();++i){
            if(uClaId == StrategyParam::goalClaId[i]){
                return true;
            }
        }
        return false;
    }
    //=====================================================
};

class claCmpById : greater<Clause*> {
public:

    bool operator()(Clause* c1, Clause* c2) const {
        return c1->uClaId < c2->uClaId;
    }
};

class claCmpDeductNum : greater<Clause*> {
public:

    bool operator()(Clause* c1, Clause* c2) const {
        //srand(unsigned(time(NULL)));
        if(c1->adeductNum == c2->adeductNum)
        {
             if (c1->MaxVarId() == c2->MaxVarId()) {
                if (c1->uFuncDepth == c2->uFuncDepth)
                    return int(rand())%2 != int(rand())%2;//20170108  100
                    //return c1->uClaId < c2->uClaId;
                return c1->uFuncDepth < c2->uFuncDepth;
            }
            return c1->MaxVarId() < c2->MaxVarId();
        }
        return c1->adeductNum < c2->adeductNum;
    }
}; 

class claCmpByRule : greater<Clause*> {
public:

    bool operator()(Clause* c1, Clause* c2) const {
        if (c1->uLitNum == c2->uLitNum) {
            if (c1->MaxVarId() == c2->MaxVarId()) {
                if (c1->uFuncDepth == c2->uFuncDepth)
                    return c1->uClaId < c2->uClaId;
                return c1->uFuncDepth < c2->uFuncDepth;
            }
            return c1->MaxVarId() < c2->MaxVarId();
        }
        return c1->uLitNum < c2->uLitNum;

    }
};

class claCmpPDeductNum : greater<Clause*> {
public:

    bool operator()(Clause* c1, Clause* c2) const {
        //srand(unsigned(time(NULL)));
        if (c1->pdeductNum == c2->pdeductNum) {
            if (c1->uLitNum == c2->uLitNum) {
                if (c1->MaxVarId() == c2->MaxVarId()) {
                    if (c1->uFuncDepth == c2->uFuncDepth)
                        //return int(rand()) % 2 != int(rand()) % 2; //20170108  100
                        return c1->uClaId < c2->uClaId;
                    return c1->uFuncDepth < c2->uFuncDepth;
                }
                return c1->MaxVarId() < c2->MaxVarId();
            }
            return c1->uLitNum < c2->uLitNum;
        }
        return c1->pdeductNum < c2->pdeductNum;
    }
}; 
#endif /* CLAUSE_H */

