/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   Clause.cpp
 * Author: sjg
 * 
 * Created on 2016年11月18日, 上午11:26
 */

#include "Clause.h"
#include "Term.h"
#include "Literal.h"
#include "SortRule.h"
#include "dataTypeDef.h"
#include "HashTree.h"
#include "globalFunc.h"
#include "FileOp.h"

extern set<HashNode*, HashNodeCmpByCode> g_HashTree;
extern CseSymbolMapper cseSymbolMapper;
Clause::Clause() {
}

Clause::Clause(const Clause& orig) {
}

Clause::~Clause() {
}

Clause::Clause(vector<string>& vectsLit, UINT32 _claId): uClaId(_claId), Priority(0), uLitNum(0), uVarCount(0), uFuncDepth(0), uReuseTimes(0),adeductNum(0),pdeductNum(0),
        isSDeduct(false),reduntTimes(0),isUse(false),isAxtom(false),isGoal(false),isPureCla(false),clast(noState),noUnitDeductTimes(0),demodulator(false),orgCla(false),goaldeepth(litWeight),
        deduceDeepth(0),copyFrom(nullptr),copyTo(nullptr),topCopyCla(nullptr),noPairResFiFg(false),maxPred(0),minPred(0),maxPairPred(0),minPairPred(0),claAttr(0),termCount12(0),termCount11(0),termCount21(0){
    //map<UINT32, UINT8> mapVarId;//用于对变元ID进行规范化
    LitPtr = new Literal*[vectsLit.size()]; //初始化文字列表数组
    for (uLitNum = 0; uLitNum < vectsLit.size(); ++uLitNum) {
        string& _strLit = vectsLit[uLitNum]; //依次取各个文字
        //解析谓词项
        TrimStr(_strLit); //消除文字前后的空格符
        //cout<<_strLit<<endl;
        Term* litSubT = nullptr;
        if (_strLit.find('(') == string::npos) {
            litSubT = GenerateTerm_PredWithoutSubTerm(_strLit);
        } else {
            char* ch = const_cast<char*> (_strLit.c_str()); //c_str返回字符串的常指针，const_cast将常指针改成普通指针
            //解析普通项		  
            litSubT = GenerateTerm(ch);
        }
        
        if (uFuncDepth < litSubT->uLevel) uFuncDepth = litSubT->uLevel; //子句的函数嵌套层数等于谓词的最大嵌套层数 如盘p(f(a1)) 层数计为1
        uVarCount += litSubT->uVarCount; //子句的变元个数等于各个文字的变元个数之和		
        //添加到文字	
        LitPtr[uLitNum] = new Literal(litSubT, EncodeLitCode(uClaId, uLitNum + 1), this, nullptr);
        //添加谓词对应列表
        LitPtr[uLitNum]->AddPredLst();
    }
}
//第一个项解析 P ~P E ~E f，返回这些项的24位项类别和元数
UINT32 Clause::FstTermCode(char* &ch) {
    string sTermCode = "";
    INT32 iPredCode;
    bool isNav = false; //判断是否是负文字
    if (*ch == '~') {
        isNav = true;
        ++ch;
    }
    bool isFunc = false, isEqn = false; //判断是否是函数、等词
    if ('f' == *ch)
        isFunc = true;
    else if ('E' == *ch)
        isEqn = true;
    while (*(++ch) != '(') {
        sTermCode += *ch;
    }
    iPredCode = sTermCode == "" ? 0 : stoi(sTermCode); //得到第一个项的数字编码

    if (isFunc)
        Set1stTProp(iPredCode, TFunc); //TFunc=1
    else if (isEqn) {
        if (isNav)
            Set1stTProp(iPredCode, TNegEqn); //TNeEqn=4
        else
            Set1stTProp(iPredCode, TEqn); //TEqn=3
    } else {
        if (isNav)
            Set1stTProp(iPredCode, TNegPred); //TNegPred=5
        else
            Set1stTProp(iPredCode, TPred); //TPred=2
    }
    return iPredCode;
}
//解析字符串生成文字
//char*  &sLit 需要解析的字符串, Term* term 需要生成的项, map<UINT32, UINT8>&mapVarId 用于子句中规范化变元编号
Term* Clause::GenerateTerm(char* &sLit) {

    string sTermCode;
    /*避免使用 vector 导致效率以及存储空间的问题
    采用临时存储子项元素 vTermCode, 以及临时变元项 vVarTerm*/
    Term** vSubTerms = new Term*[255];
    Term* term = new Term(FstTermCode(sLit)); //slit指针指向第一个(

    ++sLit;
    while (1) {
        sTermCode = "";
        if ('x' == *sLit) {
            ++sLit;
            while (*sLit != ',' && *sLit != ')') {
                sTermCode += *sLit; //得到变元项
                ++sLit;
            }

            UINT32 oldVarCode = stoi(sTermCode); //变元项，此处为变元项的下标，转化成整形
#ifdef  NDEBUG
            if (errno == ERANGE && (oldVarCode == LONG_MAX || oldVarCode == LONG_MIN) || (errno != 0 && oldVarCode == 0))
                assert(true, "输入的变元编号有错，格式为x+编号");
#endif
            UINT16 uTmpMaxVarId;
            vSubTerms[term->uSubTermNum] = VBInsert(oldVarCode, uTmpMaxVarId); //添加到变元项到子句变元共享列表中
            vSubTerms[term->uSubTermNum]->uVarCount = 1;
            term->uSubTermNum++;
            if (uTmpMaxVarId > 0)
                term->uMaxVarId = uTmpMaxVarId;
            ++term->uVarCount;
        } else if ('f' == *sLit) {
            Term *subT = GenerateTerm(sLit);
            if(term->isFuncTerm())//如果是函数项时,子项加1
                term->uLevel = subT->uLevel + 1; //复合层次
            else if(term->isPredTerm()){//如果是谓词项时,取函数项最大的子项
                if(term->uLevel < subT->uLevel + 1) //复合层次
                    term->uLevel = subT->uLevel + 1;
            }
            term->fSteadyValue += subT->fSteadyValue * 0.5f; //稳定度计算
            vSubTerms[term->uSubTermNum++] = subT; //添加到子项中
            term->uVarCount += subT->uVarCount; //变元数
            if (term->uMaxVarId < subT->uMaxVarId)
                term->uMaxVarId = subT->uMaxVarId;
        } else if ('a' == *sLit) {
            ++sLit;
            while (*sLit != ',' && *sLit != ')') {
                sTermCode += *sLit;
                ++sLit;
            }
            UINT32 code = stoi(sTermCode); //取常元项的对应的整形编码
#ifdef  NDEBUG
            if (errno == ERANGE && (code == LONG_MAX || code == LONG_MIN) || (errno != 0 && code == 0))
                assert(true, "输入的常元编号有错，格式为a+编号");
#endif
            code = EncodeCon(code); //code=24位常元属性，后8位为常元编码
            Term* baseT = new Term(code);
            //添加到项列表 	
            vSubTerms[term->uSubTermNum++] = HashTree::InsertHashTree(baseT, g_HashTree); //共享基项 变元项放在每个子句对象中,其中重复的变元共享数据结构
            
            ++(term->fSteadyValue); //稳定度计算
        }
        if (*sLit == ')') {
            //将临时子项列表内存拷贝到Term的子项列表中 
            term->subTermPtr = new Term*[term->uSubTermNum];
            memcpy(term->subTermPtr, vSubTerms, sizeof(Term*) * term->uSubTermNum);

            if (term->uVarCount != 0) //如果是非共享基项，插入&查找子句变元项中的共享非基项
                term = HashTree::InsertHashTree(term, setHashTree);
                //一个函数读取完毕 f1(x1) 若为基项，则查找hashTree，并插入或返回基项表中的索引号
            else{
                term = HashTree::InsertHashTree(term, g_HashTree);//基文字或基函数
                term->groundTermCount = HashTree::findTermCountHashTree(term,g_HashTree);
            }
            if(term->isFuncTerm())
                term->fSteadyValue /= term->uSubTermNum; //计算稳定度			
           else if(term->isPredTerm())
               term->fSteadyValue = (term->fSteadyValue + term->uLevel)/term->uSubTermNum; //计算稳定度	
            ++sLit;
            break;
        }
        ++sLit;
    }
    delete[]vSubTerms;
    return term;
}

//解析 无任何项的谓词符号 如 P6
Term* Clause::GenerateTerm_PredWithoutSubTerm(const string& pred_str) {
    INT32 iPredCode;
    string id_str;
    if (pred_str[0] == '~') {
        id_str = pred_str.substr(2);
        iPredCode = stoi(id_str);
        Set1stTProp(iPredCode, TNegPred);
    } else {
        id_str = pred_str.substr(1);
        iPredCode = stoi(id_str);
        Set1stTProp(iPredCode, TPred); 
    }
    
    Term* term = new Term(iPredCode);
    term->isWithouSubTerm = true;
    term = HashTree::InsertHashTree(term, g_HashTree);//基文字或基函数
    term->groundTermCount = HashTree::findTermCountHashTree(term,g_HashTree);
    term->fSteadyValue = 100;
    
    return term;
}

void Clause::DelLits(bool isDelPred) {
    for (UINT16 i = 0; i < uLitNum; ++i) {
        if (isDelPred)LitPtr[i]->DelPred();
        delete(LitPtr[i]);
    }
    delete[]LitPtr;
    LitPtr = nullptr;
    //清除非基函数项hashtree
    /*for (auto&hashNode : setHashTree)
    {
    delete(hashNode->termPtr);
    delete(hashNode);
    }*/
    set<HashNode*, HashNodeCmpByCode>::iterator it;
    //for(it = setHashTree.begin();it != setHashTree.end();it++)
    //{
      //  delete((*it)->termPtr);
      //  delete((*it));
    //};
    for_each(setHashTree.begin(), setHashTree.end(), [](HashNode * hashNode) {
        delete(hashNode->termPtr);
        delete(hashNode); });
    setHashTree.clear();
    //清除变元项列表
    if (uVarCount > 0) {
        /*for (auto& varT : setVarS)
                delete(varT);*/
        for (auto& varT : mapSharedVars) {
            delete(varT.second);

        }
        mapSharedVars.clear();
        /*Concurrency::parallel_for_each(mapSharedVars.begin(), mapSharedVars.end(), []
                        (pair<int,Term*> t) {delete(t.second); });*/

    }

}
//删除子句中指定文字

void Clause::DelOneLit(Literal* lit, bool isDelPred) {
    for (UINT16 i = 0; i < uLitNum; ++i) {
        if (LitPtr[i] == lit) {
            if (isDelPred)LitPtr[i]->DelPred();
            delete(LitPtr[i]);
        }
    }



}

void Clause::toString(string&sCla) {
    UINT16 i = 0;//20170708  UINT8改成UINT16
    sCla = "[" + to_string(uClaId) + "]";
    while (1) {
        sCla += LitPtr[i]->subTerm->ToString();
        ++i;
        if (i < uLitNum)
            sCla += "+";
        else
            break;

    }
}

//for conpetition 20210614 chang: apply uint and binary clause to E
void Clause::addRForCompetiton(){
    if(uLitNum > 2){
        return;
    }
    string sCla;
    toPureString(sCla);
    FileOp::prinfResForE(sCla);
}

string Clause::ToStringWithSemantics(const string& clause_str) {
    return convert_single_cse_clause_to_cnf(clause_str, cseSymbolMapper, StrategyParam::goalClaId);
}


void Clause::toPureString(string&sCla) {
    UINT16 i = 0;//20170708  UINT8改成UINT16
    sCla = "[" + to_string(uClaId) + "]";
    while (1) {
        sCla += LitPtr[i]->subTerm->ToString();
        ++i;
        if (i < uLitNum)
            sCla += "+";
        else
            break;

    }
}
//输出子句

void Clause::Print() {
    UINT16 i = 0;
    while (1) {
        cout << "[" << (i + 1) << "]";
        LitPtr[i]->subTerm->Print();
        ++i;
        if (i < uLitNum)
            cout << "+";
        else
            break;

    }
    cout << endl;
}
//计算子句的函数复杂度
int Clause::compFuncDeepthCla() {
    UINT16 i = 0;
    int maxLitCount = 0;
    int count;
    while (1) {
        count = 0;
        LitPtr[i]->subTerm->compFuncDeepth(count);
        if(count>maxLitCount)
            maxLitCount = count;
        ++i;
        if (i < uLitNum)
            ;
        else
            break;
    }
    return maxLitCount;
}
//输出子句

bool Clause::HasTermBind() {
    UINT16 i = 0;
    while (1) {
        if(LitPtr[i]->subTerm->IsExistBind()){
            return true;
        }
        ++i;
        if (i < uLitNum)
            continue;
        else
            return false;
    }
}
//对子句中的文字进行排序

void Clause::SortLit() {
    if (1 == uLitNum) return;
    sort(LitPtr, LitPtr + uLitNum, SortRule::LitCmp);
    //SortRule::QuickSort(LitPtr, 0, uLitNum-1);
    for (UINT16 uCol = 0; uCol < uLitNum; ++uCol) //重新编码 新列号
    {
        LitPtr[uCol]->ReCol(uCol + 1);
    }
}
//20170114 用于对归结子句文字重新排序
void Clause::SortLitDuct() {
    if (1 == uLitNum) return;
    sort(LitPtr, LitPtr + uLitNum, SortRule::LitCmpDuct);
    //SortRule::QuickSort(LitPtr, 0, uLitNum-1);
    for (UINT16 uCol = 0; uCol < uLitNum; ++uCol) //重新编码 新列号
    {
        LitPtr[uCol]->ReCol(uCol + 1);
    }
}
//20170916 统计项的个数
UINT32 Clause::countClaTermE(UINT8 funCoff, UINT8 varCoff){
    UINT32 litTermCount;
    UINT32 claTermCount = 0;
    for(int i = 0; i<uLitNum; ++i){
        litTermCount = 0;
        LitPtr[i]->subTerm->countTermE(litTermCount,funCoff,varCoff);
        claTermCount += litTermCount;
    }
    return claTermCount;
}

//子句初始化属性值
//给子句集初始化
void Clause::initOrgClaAttr()
{
    UINT32 maxSize = 0, minSize = 12000;
    UINT32 maxPairSize = 0, minPairSize = 12000;
    UINT32 count = 0;

    vector <UINT8> saveTmp;
    saveTmp.reserve(6);
    for (UINT16 i = 0; i < uLitNum; ++i) {
        if (LitPtr[i]->isConLit()) {
            LitPtr[i]->litAttr = 0; //基文字
            saveTmp.push_back(0);
        } else if (LitPtr[i]->isSingleVarliteral() && !(LitPtr[i]->isShareVarLiteral())) {
            LitPtr[i]->litAttr = 1; //只含独立变元文字
            saveTmp.push_back(1);
        } else if (LitPtr[i]->isShareVarLiteral()) {
            LitPtr[i]->litAttr = 2; //含共享变元文字
            saveTmp.push_back(2);
        }
        LitPtr[i]->countPred = LitPtr[i]->getPredLst()->size() - 1;
        LitPtr[i]->countPairPred = LitPtr[i]->getPairPredLst()->size();

        //计算文字的项计数
        count = 0;
        LitPtr[i]->subTerm->countTermE(count, 1, 2);
        LitPtr[i]->termCount12 = count;
        termCount12 += count;

        count = 0;
        LitPtr[i]->subTerm->countTermE(count, 1, 1);
        LitPtr[i]->termCount11 = count;
        termCount11 += count;

        count = 0;
        LitPtr[i]->subTerm->countTermE(count, 2, 1);
        LitPtr[i]->termCount21 = count;
        termCount21 += count;

        if (maxSize < LitPtr[i]->countPred) {
            maxSize = LitPtr[i]->countPred;
        } else if (minSize > LitPtr[i]->countPred) {
            minSize = LitPtr[i]->countPred;
        }
        if (maxPairSize < LitPtr[i]->countPairPred) {
            maxPairSize = LitPtr[i]->countPairPred;
        } else if (minPairSize > LitPtr[i]->countPairPred) {
            minPairSize = LitPtr[i]->countPairPred;
        }
    }
    if (find(saveTmp.begin(), saveTmp.end(), 2) != saveTmp.end()) {//子句含有共享变元
        claAttr = 2;
    } else if (find(saveTmp.begin(), saveTmp.end(), 1) != saveTmp.end()) {//只含独立变元子句
        claAttr = 1;
    } else
        claAttr = 0; //基子句
    saveTmp.clear();
    vector <UINT8>().swap(saveTmp);
    maxPred = maxSize;
    minPred = minSize;
    maxPairPred = maxPairSize;
    minPairPred = minPairSize;
    
}


//20170901 以下用于等词处理
//1 单元子句正等词项的交换,使得左边的项复杂度大于右边的项复杂度
void Clause::exEqnTerm(){
    if((uLitNum != 1) || ((GetCodeProp(LitPtr[0]->subTerm->iTermCode) !=TEqn) && (uLitNum == 1)))
        return;
    else{
        bool change = false;
        Literal* lit = LitPtr[0];
        UINT32 countLeft = 0;
        UINT32 countRight = 0;
        Term* left = lit->subTerm->subTermPtr[0];
        Term* right = lit->subTerm->subTermPtr[1];
        left->countTerm(countLeft);
        right->countTerm(countRight);
        if (countLeft > countRight) {
            return;
        } 
        else if (countLeft == countRight) {
            if(left->isVar() && right->isVar()){
                if((left->iTermCode & 0xFF) > (right->iTermCode & 0xFF)){
                    return;
                }
                else 
                    change = true;
            }
            else if(left->isVar() && right->isConTerm()){
                return;
            }
            else if(left->isConTerm() && right->isVar()){
                change = true;
            }
            else if(left->isConTerm() && right->isConTerm()){
                if((left->iTermCode & 0xFF) > (right->iTermCode & 0xFF)){
                    return;
                }
                else 
                    change = true;
            }
        } 
        else
            change = true;
        if(change)
        {
            Term* tmp = nullptr;
            tmp = lit->subTerm->subTermPtr[0];
            lit->subTerm->subTermPtr[0] = lit->subTerm->subTermPtr[1];
            lit->subTerm->subTermPtr[1] = tmp;
        }
        return;
    }
}

void Clause::directEqn() {
    if (uLitNum > 1)
        return;
    for (int m = 0; m < uLitNum; m++) {
        if (LitPtr[m]->subTerm->isPosEqnTerm() || LitPtr[m]->subTerm->isNegEqnTerm()) {
            LitPtr[m]->exEqnTerm();
        }
    }
    //demodulator = true;
}