%------------------------------------------------------------------------------
% File     : SEU413+2 : TPTP v9.0.0. Released v3.4.0.
% Domain   : Set Theory
% Problem  : The Operation of Addition of Relational Structures T23
% Version  : [Urb08] axioms : Especial.
% English  :

% Refs     : [RG04]  Romanowicz & Grabowski (2004), The Operation of Additi
%          : [Urb07] Urban (2007), MPTP 0.2: Design, Implementation, and In
%          : [Urb08] Urban (2006), Email to G. Sutcliffe
% Source   : [Urb08]
% Names    : t23_latsum_1 [Urb08]

% Status   : Theorem
% Rating   : 0.85 v9.0.0, 0.86 v8.2.0, 0.92 v8.1.0, 0.89 v7.5.0, 0.94 v7.4.0, 0.93 v7.1.0, 0.91 v7.0.0, 0.93 v6.4.0, 0.92 v6.3.0, 0.88 v6.2.0, 0.92 v6.1.0, 0.93 v6.0.0, 0.91 v5.5.0, 0.93 v5.4.0, 0.96 v5.2.0, 0.90 v5.0.0, 1.00 v3.4.0
% Syntax   : Number of formulae    : 4460 (1060 unt;   0 def)
%            Number of atoms       : 22976 (2607 equ)
%            Maximal formula atoms :   49 (   5 avg)
%            Number of connectives : 20944 (2428   ~; 137   |;9757   &)
%                                         ( 750 <=>;7872  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   35 (   6 avg)
%            Maximal term depth    :    6 (   1 avg)
%            Number of predicates  :  300 ( 298 usr;   1 prp; 0-4 aty)
%            Number of functors    :  568 ( 568 usr; 168 con; 0-8 aty)
%            Number of variables   : 10469 (10041   !; 428   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments : Bushy version: includes all articles that contribute axioms to the
%            Normal version.
%          : Translated by MPTP from the Mizar Mathematical Library 4.48.930.
%          : The problem encoding is based on set theory.
%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(antisymmetry_r2_hidden,axiom,
    ! [A,B] :
      ( r2_hidden(A,B)
     => ~ r2_hidden(B,A) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(t1_tarski,axiom,
    $true ).

fof(t2_tarski,axiom,
    ! [A,B] :
      ( ! [C] :
          ( r2_hidden(C,A)
        <=> r2_hidden(C,B) )
     => A = B ) ).

fof(d1_tarski,axiom,
    ! [A,B] :
      ( B = k1_tarski(A)
    <=> ! [C] :
          ( r2_hidden(C,B)
        <=> C = A ) ) ).

fof(d2_tarski,axiom,
    ! [A,B,C] :
      ( C = k2_tarski(A,B)
    <=> ! [D] :
          ( r2_hidden(D,C)
        <=> ( D = A
            | D = B ) ) ) ).

fof(t3_tarski,axiom,
    $true ).

fof(t4_tarski,axiom,
    $true ).

fof(d3_tarski,axiom,
    ! [A,B] :
      ( r1_tarski(A,B)
    <=> ! [C] :
          ( r2_hidden(C,A)
         => r2_hidden(C,B) ) ) ).

fof(d4_tarski,axiom,
    ! [A,B] :
      ( B = k3_tarski(A)
    <=> ! [C] :
          ( r2_hidden(C,B)
        <=> ? [D] :
              ( r2_hidden(C,D)
              & r2_hidden(D,A) ) ) ) ).

fof(t5_tarski,axiom,
    $true ).

fof(t6_tarski,axiom,
    $true ).

fof(t7_tarski,axiom,
    ! [A,B] :
      ~ ( r2_hidden(A,B)
        & ! [C] :
            ~ ( r2_hidden(C,B)
              & ! [D] :
                  ~ ( r2_hidden(D,B)
                    & r2_hidden(D,C) ) ) ) ).

fof(d5_tarski,axiom,
    ! [A,B] : k4_tarski(A,B) = k2_tarski(k2_tarski(A,B),k1_tarski(A)) ).

fof(t8_tarski,axiom,
    $true ).

fof(d6_tarski,axiom,
    ! [A,B] :
      ( r2_tarski(A,B)
    <=> ? [C] :
          ( ! [D] :
              ~ ( r2_hidden(D,A)
                & ! [E] :
                    ~ ( r2_hidden(E,B)
                      & r2_hidden(k4_tarski(D,E),C) ) )
          & ! [D] :
              ~ ( r2_hidden(D,B)
                & ! [E] :
                    ~ ( r2_hidden(E,A)
                      & r2_hidden(k4_tarski(E,D),C) ) )
          & ! [D,E,F,G] :
              ( ( r2_hidden(k4_tarski(D,E),C)
                & r2_hidden(k4_tarski(F,G),C) )
             => ( D = F
              <=> E = G ) ) ) ) ).

fof(t9_tarski,axiom,
    ! [A] :
    ? [B] :
      ( r2_hidden(A,B)
      & ! [C,D] :
          ( ( r2_hidden(C,B)
            & r1_tarski(D,C) )
         => r2_hidden(D,B) )
      & ! [C] :
          ~ ( r2_hidden(C,B)
            & ! [D] :
                ~ ( r2_hidden(D,B)
                  & ! [E] :
                      ( r1_tarski(E,C)
                     => r2_hidden(E,D) ) ) )
      & ! [C] :
          ~ ( r1_tarski(C,B)
            & ~ r2_tarski(C,B)
            & ~ r2_hidden(C,B) ) ) ).

fof(s1_tarski,axiom,
    ( ! [A,B,C] :
        ( ( p1_s1_tarski(A,B)
          & p1_s1_tarski(A,C) )
       => B = C )
   => ? [A] :
      ! [B] :
        ( r2_hidden(B,A)
      <=> ? [C] :
            ( r2_hidden(C,f1_s1_tarski)
            & p1_s1_tarski(C,B) ) ) ) ).

fof(reflexivity_r1_tarski,axiom,
    ! [A,B] : r1_tarski(A,A) ).

fof(dt_k1_tarski,axiom,
    $true ).

fof(dt_k2_tarski,axiom,
    $true ).

fof(commutativity_k2_tarski,axiom,
    ! [A,B] : k2_tarski(A,B) = k2_tarski(B,A) ).

fof(dt_k3_tarski,axiom,
    $true ).

fof(dt_k4_tarski,axiom,
    $true ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(fc1_xboole_0,axiom,
    v1_xboole_0(k1_xboole_0) ).

fof(rc1_xboole_0,axiom,
    ? [A] : v1_xboole_0(A) ).

fof(rc2_xboole_0,axiom,
    ? [A] : ~ v1_xboole_0(A) ).

fof(fc2_xboole_0,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(A)
     => ~ v1_xboole_0(k2_xboole_0(A,B)) ) ).

fof(fc3_xboole_0,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(A)
     => ~ v1_xboole_0(k2_xboole_0(B,A)) ) ).

fof(d1_xboole_0,axiom,
    ! [A] :
      ( A = k1_xboole_0
    <=> ! [B] : ~ r2_hidden(B,A) ) ).

fof(d2_xboole_0,axiom,
    ! [A,B,C] :
      ( C = k2_xboole_0(A,B)
    <=> ! [D] :
          ( r2_hidden(D,C)
        <=> ( r2_hidden(D,A)
            | r2_hidden(D,B) ) ) ) ).

fof(d3_xboole_0,axiom,
    ! [A,B,C] :
      ( C = k3_xboole_0(A,B)
    <=> ! [D] :
          ( r2_hidden(D,C)
        <=> ( r2_hidden(D,A)
            & r2_hidden(D,B) ) ) ) ).

fof(d4_xboole_0,axiom,
    ! [A,B,C] :
      ( C = k4_xboole_0(A,B)
    <=> ! [D] :
          ( r2_hidden(D,C)
        <=> ( r2_hidden(D,A)
            & ~ r2_hidden(D,B) ) ) ) ).

fof(d5_xboole_0,axiom,
    ! [A] :
      ( v1_xboole_0(A)
    <=> A = k1_xboole_0 ) ).

fof(d6_xboole_0,axiom,
    ! [A,B] : k5_xboole_0(A,B) = k2_xboole_0(k4_xboole_0(A,B),k4_xboole_0(B,A)) ).

fof(d7_xboole_0,axiom,
    ! [A,B] :
      ( r1_xboole_0(A,B)
    <=> k3_xboole_0(A,B) = k1_xboole_0 ) ).

fof(d8_xboole_0,axiom,
    ! [A,B] :
      ( r2_xboole_0(A,B)
    <=> ( r1_tarski(A,B)
        & A != B ) ) ).

fof(d9_xboole_0,axiom,
    ! [A,B] :
      ( r3_xboole_0(A,B)
    <=> ( r1_tarski(A,B)
        | r1_tarski(B,A) ) ) ).

fof(d10_xboole_0,axiom,
    ! [A,B] :
      ( A = B
    <=> ( r1_tarski(A,B)
        & r1_tarski(B,A) ) ) ).

fof(t1_xboole_0,axiom,
    ! [A,B,C] :
      ( r2_hidden(A,k5_xboole_0(B,C))
    <=> ~ ( r2_hidden(A,B)
        <=> r2_hidden(A,C) ) ) ).

fof(t2_xboole_0,axiom,
    ! [A,B,C] :
      ( ! [D] :
          ( ~ r2_hidden(D,A)
        <=> ( r2_hidden(D,B)
          <=> r2_hidden(D,C) ) )
     => A = k5_xboole_0(B,C) ) ).

fof(t3_xboole_0,axiom,
    ! [A,B] :
      ( ~ ( ~ r1_xboole_0(A,B)
          & ! [C] :
              ~ ( r2_hidden(C,A)
                & r2_hidden(C,B) ) )
      & ~ ( ? [C] :
              ( r2_hidden(C,A)
              & r2_hidden(C,B) )
          & r1_xboole_0(A,B) ) ) ).

fof(t4_xboole_0,axiom,
    ! [A,B] :
      ( ~ ( ~ r1_xboole_0(A,B)
          & ! [C] : ~ r2_hidden(C,k3_xboole_0(A,B)) )
      & ~ ( ? [C] : r2_hidden(C,k3_xboole_0(A,B))
          & r1_xboole_0(A,B) ) ) ).

fof(t5_xboole_0,axiom,
    ! [A,B,C] :
      ~ ( r1_xboole_0(A,B)
        & r2_hidden(C,k2_xboole_0(A,B))
        & ~ ( r2_hidden(C,A)
            & ~ r2_hidden(C,B) )
        & ~ ( r2_hidden(C,B)
            & ~ r2_hidden(C,A) ) ) ).

fof(s1_xboole_0,axiom,
    ? [A] :
    ! [B] :
      ( r2_hidden(B,A)
    <=> ( r2_hidden(B,f1_s1_xboole_0)
        & p1_s1_xboole_0(B) ) ) ).

fof(s2_xboole_0,axiom,
    ( ( ! [A] :
          ( r2_hidden(A,f1_s2_xboole_0)
        <=> p1_s2_xboole_0(A) )
      & ! [A] :
          ( r2_hidden(A,f2_s2_xboole_0)
        <=> p1_s2_xboole_0(A) ) )
   => f1_s2_xboole_0 = f2_s2_xboole_0 ) ).

fof(s3_xboole_0,axiom,
    ! [A,B] :
      ( ( ! [C] :
            ( r2_hidden(C,A)
          <=> p1_s3_xboole_0(C) )
        & ! [C] :
            ( r2_hidden(C,B)
          <=> p1_s3_xboole_0(C) ) )
     => A = B ) ).

fof(symmetry_r1_xboole_0,axiom,
    ! [A,B] :
      ( r1_xboole_0(A,B)
     => r1_xboole_0(B,A) ) ).

fof(irreflexivity_r2_xboole_0,axiom,
    ! [A,B] : ~ r2_xboole_0(A,A) ).

fof(antisymmetry_r2_xboole_0,axiom,
    ! [A,B] :
      ( r2_xboole_0(A,B)
     => ~ r2_xboole_0(B,A) ) ).

fof(symmetry_r3_xboole_0,axiom,
    ! [A,B] :
      ( r3_xboole_0(A,B)
     => r3_xboole_0(B,A) ) ).

fof(reflexivity_r3_xboole_0,axiom,
    ! [A,B] : r3_xboole_0(A,A) ).

fof(dt_k1_xboole_0,axiom,
    $true ).

fof(dt_k2_xboole_0,axiom,
    $true ).

fof(commutativity_k2_xboole_0,axiom,
    ! [A,B] : k2_xboole_0(A,B) = k2_xboole_0(B,A) ).

fof(idempotence_k2_xboole_0,axiom,
    ! [A,B] : k2_xboole_0(A,A) = A ).

fof(dt_k3_xboole_0,axiom,
    $true ).

fof(commutativity_k3_xboole_0,axiom,
    ! [A,B] : k3_xboole_0(A,B) = k3_xboole_0(B,A) ).

fof(idempotence_k3_xboole_0,axiom,
    ! [A,B] : k3_xboole_0(A,A) = A ).

fof(dt_k4_xboole_0,axiom,
    $true ).

fof(dt_k5_xboole_0,axiom,
    $true ).

fof(commutativity_k5_xboole_0,axiom,
    ! [A,B] : k5_xboole_0(A,B) = k5_xboole_0(B,A) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(t1_boole,axiom,
    ! [A] : k2_xboole_0(A,k1_xboole_0) = A ).

fof(t2_boole,axiom,
    ! [A] : k3_xboole_0(A,k1_xboole_0) = k1_xboole_0 ).

fof(t3_boole,axiom,
    ! [A] : k4_xboole_0(A,k1_xboole_0) = A ).

fof(t4_boole,axiom,
    ! [A] : k4_xboole_0(k1_xboole_0,A) = k1_xboole_0 ).

fof(t5_boole,axiom,
    ! [A] : k5_xboole_0(A,k1_xboole_0) = A ).

fof(t6_boole,axiom,
    ! [A] :
      ( v1_xboole_0(A)
     => A = k1_xboole_0 ) ).

fof(t7_boole,axiom,
    ! [A,B] :
      ~ ( r2_hidden(A,B)
        & v1_xboole_0(B) ) ).

fof(t8_boole,axiom,
    ! [A,B] :
      ~ ( v1_xboole_0(A)
        & A != B
        & v1_xboole_0(B) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(t1_xboole_1,axiom,
    ! [A,B,C] :
      ( ( r1_tarski(A,B)
        & r1_tarski(B,C) )
     => r1_tarski(A,C) ) ).

fof(t2_xboole_1,axiom,
    ! [A] : r1_tarski(k1_xboole_0,A) ).

fof(t3_xboole_1,axiom,
    ! [A] :
      ( r1_tarski(A,k1_xboole_0)
     => A = k1_xboole_0 ) ).

fof(t4_xboole_1,axiom,
    ! [A,B,C] : k2_xboole_0(k2_xboole_0(A,B),C) = k2_xboole_0(A,k2_xboole_0(B,C)) ).

fof(t5_xboole_1,axiom,
    ! [A,B,C] : k2_xboole_0(k2_xboole_0(A,B),C) = k2_xboole_0(k2_xboole_0(A,C),k2_xboole_0(B,C)) ).

fof(t6_xboole_1,axiom,
    ! [A,B] : k2_xboole_0(A,k2_xboole_0(A,B)) = k2_xboole_0(A,B) ).

fof(t7_xboole_1,axiom,
    ! [A,B] : r1_tarski(A,k2_xboole_0(A,B)) ).

fof(t8_xboole_1,axiom,
    ! [A,B,C] :
      ( ( r1_tarski(A,B)
        & r1_tarski(C,B) )
     => r1_tarski(k2_xboole_0(A,C),B) ) ).

fof(t9_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,B)
     => r1_tarski(k2_xboole_0(A,C),k2_xboole_0(B,C)) ) ).

fof(t10_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,B)
     => r1_tarski(A,k2_xboole_0(C,B)) ) ).

fof(t11_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(k2_xboole_0(A,B),C)
     => r1_tarski(A,C) ) ).

fof(t12_xboole_1,axiom,
    ! [A,B] :
      ( r1_tarski(A,B)
     => k2_xboole_0(A,B) = B ) ).

fof(t13_xboole_1,axiom,
    ! [A,B,C,D] :
      ( ( r1_tarski(A,B)
        & r1_tarski(C,D) )
     => r1_tarski(k2_xboole_0(A,C),k2_xboole_0(B,D)) ) ).

fof(t14_xboole_1,axiom,
    ! [A,B,C] :
      ( ( r1_tarski(A,B)
        & r1_tarski(C,B)
        & ! [D] :
            ( ( r1_tarski(A,D)
              & r1_tarski(C,D) )
           => r1_tarski(B,D) ) )
     => B = k2_xboole_0(A,C) ) ).

fof(t15_xboole_1,axiom,
    ! [A,B] :
      ( k2_xboole_0(A,B) = k1_xboole_0
     => A = k1_xboole_0 ) ).

fof(t16_xboole_1,axiom,
    ! [A,B,C] : k3_xboole_0(k3_xboole_0(A,B),C) = k3_xboole_0(A,k3_xboole_0(B,C)) ).

fof(t17_xboole_1,axiom,
    ! [A,B] : r1_tarski(k3_xboole_0(A,B),A) ).

fof(t18_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,k3_xboole_0(B,C))
     => r1_tarski(A,B) ) ).

fof(t19_xboole_1,axiom,
    ! [A,B,C] :
      ( ( r1_tarski(A,B)
        & r1_tarski(A,C) )
     => r1_tarski(A,k3_xboole_0(B,C)) ) ).

fof(t20_xboole_1,axiom,
    ! [A,B,C] :
      ( ( r1_tarski(A,B)
        & r1_tarski(A,C)
        & ! [D] :
            ( ( r1_tarski(D,B)
              & r1_tarski(D,C) )
           => r1_tarski(D,A) ) )
     => A = k3_xboole_0(B,C) ) ).

fof(t21_xboole_1,axiom,
    ! [A,B] : k3_xboole_0(A,k2_xboole_0(A,B)) = A ).

fof(t22_xboole_1,axiom,
    ! [A,B] : k2_xboole_0(A,k3_xboole_0(A,B)) = A ).

fof(t23_xboole_1,axiom,
    ! [A,B,C] : k3_xboole_0(A,k2_xboole_0(B,C)) = k2_xboole_0(k3_xboole_0(A,B),k3_xboole_0(A,C)) ).

fof(t24_xboole_1,axiom,
    ! [A,B,C] : k2_xboole_0(A,k3_xboole_0(B,C)) = k3_xboole_0(k2_xboole_0(A,B),k2_xboole_0(A,C)) ).

fof(t25_xboole_1,axiom,
    ! [A,B,C] : k2_xboole_0(k2_xboole_0(k3_xboole_0(A,B),k3_xboole_0(B,C)),k3_xboole_0(C,A)) = k3_xboole_0(k3_xboole_0(k2_xboole_0(A,B),k2_xboole_0(B,C)),k2_xboole_0(C,A)) ).

fof(t26_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,B)
     => r1_tarski(k3_xboole_0(A,C),k3_xboole_0(B,C)) ) ).

fof(t27_xboole_1,axiom,
    ! [A,B,C,D] :
      ( ( r1_tarski(A,B)
        & r1_tarski(C,D) )
     => r1_tarski(k3_xboole_0(A,C),k3_xboole_0(B,D)) ) ).

fof(t28_xboole_1,axiom,
    ! [A,B] :
      ( r1_tarski(A,B)
     => k3_xboole_0(A,B) = A ) ).

fof(t29_xboole_1,axiom,
    ! [A,B,C] : r1_tarski(k3_xboole_0(A,B),k2_xboole_0(A,C)) ).

fof(t30_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,B)
     => k2_xboole_0(A,k3_xboole_0(C,B)) = k3_xboole_0(k2_xboole_0(A,C),B) ) ).

fof(t31_xboole_1,axiom,
    ! [A,B,C] : r1_tarski(k2_xboole_0(k3_xboole_0(A,B),k3_xboole_0(A,C)),k2_xboole_0(B,C)) ).

fof(t32_xboole_1,axiom,
    ! [A,B] :
      ( k4_xboole_0(A,B) = k4_xboole_0(B,A)
     => A = B ) ).

fof(t33_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,B)
     => r1_tarski(k4_xboole_0(A,C),k4_xboole_0(B,C)) ) ).

fof(t34_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,B)
     => r1_tarski(k4_xboole_0(C,B),k4_xboole_0(C,A)) ) ).

fof(t35_xboole_1,axiom,
    ! [A,B,C,D] :
      ( ( r1_tarski(A,B)
        & r1_tarski(C,D) )
     => r1_tarski(k4_xboole_0(A,D),k4_xboole_0(B,C)) ) ).

fof(t36_xboole_1,axiom,
    ! [A,B] : r1_tarski(k4_xboole_0(A,B),A) ).

fof(t37_xboole_1,axiom,
    ! [A,B] :
      ( k4_xboole_0(A,B) = k1_xboole_0
    <=> r1_tarski(A,B) ) ).

fof(t38_xboole_1,axiom,
    ! [A,B] :
      ( r1_tarski(A,k4_xboole_0(B,A))
     => A = k1_xboole_0 ) ).

fof(t39_xboole_1,axiom,
    ! [A,B] : k2_xboole_0(A,k4_xboole_0(B,A)) = k2_xboole_0(A,B) ).

fof(t40_xboole_1,axiom,
    ! [A,B] : k4_xboole_0(k2_xboole_0(A,B),B) = k4_xboole_0(A,B) ).

fof(t41_xboole_1,axiom,
    ! [A,B,C] : k4_xboole_0(k4_xboole_0(A,B),C) = k4_xboole_0(A,k2_xboole_0(B,C)) ).

fof(t42_xboole_1,axiom,
    ! [A,B,C] : k4_xboole_0(k2_xboole_0(A,B),C) = k2_xboole_0(k4_xboole_0(A,C),k4_xboole_0(B,C)) ).

fof(t43_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,k2_xboole_0(B,C))
     => r1_tarski(k4_xboole_0(A,B),C) ) ).

fof(t44_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(k4_xboole_0(A,B),C)
     => r1_tarski(A,k2_xboole_0(B,C)) ) ).

fof(t45_xboole_1,axiom,
    ! [A,B] :
      ( r1_tarski(A,B)
     => B = k2_xboole_0(A,k4_xboole_0(B,A)) ) ).

fof(t46_xboole_1,axiom,
    ! [A,B] : k4_xboole_0(A,k2_xboole_0(A,B)) = k1_xboole_0 ).

fof(t47_xboole_1,axiom,
    ! [A,B] : k4_xboole_0(A,k3_xboole_0(A,B)) = k4_xboole_0(A,B) ).

fof(t48_xboole_1,axiom,
    ! [A,B] : k4_xboole_0(A,k4_xboole_0(A,B)) = k3_xboole_0(A,B) ).

fof(t49_xboole_1,axiom,
    ! [A,B,C] : k3_xboole_0(A,k4_xboole_0(B,C)) = k4_xboole_0(k3_xboole_0(A,B),C) ).

fof(t50_xboole_1,axiom,
    ! [A,B,C] : k3_xboole_0(A,k4_xboole_0(B,C)) = k4_xboole_0(k3_xboole_0(A,B),k3_xboole_0(A,C)) ).

fof(t51_xboole_1,axiom,
    ! [A,B] : k2_xboole_0(k3_xboole_0(A,B),k4_xboole_0(A,B)) = A ).

fof(t52_xboole_1,axiom,
    ! [A,B,C] : k4_xboole_0(A,k4_xboole_0(B,C)) = k2_xboole_0(k4_xboole_0(A,B),k3_xboole_0(A,C)) ).

fof(t53_xboole_1,axiom,
    ! [A,B,C] : k4_xboole_0(A,k2_xboole_0(B,C)) = k3_xboole_0(k4_xboole_0(A,B),k4_xboole_0(A,C)) ).

fof(t54_xboole_1,axiom,
    ! [A,B,C] : k4_xboole_0(A,k3_xboole_0(B,C)) = k2_xboole_0(k4_xboole_0(A,B),k4_xboole_0(A,C)) ).

fof(t55_xboole_1,axiom,
    ! [A,B] : k4_xboole_0(k2_xboole_0(A,B),k3_xboole_0(A,B)) = k2_xboole_0(k4_xboole_0(A,B),k4_xboole_0(B,A)) ).

fof(t56_xboole_1,axiom,
    ! [A,B,C] :
      ( ( r2_xboole_0(A,B)
        & r2_xboole_0(B,C) )
     => r2_xboole_0(A,C) ) ).

fof(t57_xboole_1,axiom,
    ! [A,B] :
      ~ ( r2_xboole_0(A,B)
        & r2_xboole_0(B,A) ) ).

fof(t58_xboole_1,axiom,
    ! [A,B,C] :
      ( ( r2_xboole_0(A,B)
        & r1_tarski(B,C) )
     => r2_xboole_0(A,C) ) ).

fof(t59_xboole_1,axiom,
    ! [A,B,C] :
      ( ( r1_tarski(A,B)
        & r2_xboole_0(B,C) )
     => r2_xboole_0(A,C) ) ).

fof(t60_xboole_1,axiom,
    ! [A,B] :
      ~ ( r1_tarski(A,B)
        & r2_xboole_0(B,A) ) ).

fof(t61_xboole_1,axiom,
    ! [A] :
      ( A != k1_xboole_0
     => r2_xboole_0(k1_xboole_0,A) ) ).

fof(t62_xboole_1,axiom,
    ! [A] : ~ r2_xboole_0(A,k1_xboole_0) ).

fof(t63_xboole_1,axiom,
    ! [A,B,C] :
      ( ( r1_tarski(A,B)
        & r1_xboole_0(B,C) )
     => r1_xboole_0(A,C) ) ).

fof(t64_xboole_1,axiom,
    ! [A,B,C,D] :
      ( ( r1_tarski(A,B)
        & r1_tarski(C,D)
        & r1_xboole_0(B,D) )
     => r1_xboole_0(A,C) ) ).

fof(t65_xboole_1,axiom,
    ! [A] : r1_xboole_0(A,k1_xboole_0) ).

fof(t66_xboole_1,axiom,
    ! [A] :
      ( ~ ( ~ r1_xboole_0(A,A)
          & A = k1_xboole_0 )
      & ~ ( A != k1_xboole_0
          & r1_xboole_0(A,A) ) ) ).

fof(t67_xboole_1,axiom,
    ! [A,B,C] :
      ( ( r1_tarski(A,B)
        & r1_tarski(A,C)
        & r1_xboole_0(B,C) )
     => A = k1_xboole_0 ) ).

fof(t68_xboole_1,axiom,
    ! [A,B,C] :
      ( ~ v1_xboole_0(C)
     => ~ ( r1_tarski(C,A)
          & r1_tarski(C,B)
          & r1_xboole_0(A,B) ) ) ).

fof(t69_xboole_1,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ~ ( r1_tarski(B,A)
          & r1_xboole_0(B,A) ) ) ).

fof(t70_xboole_1,axiom,
    ! [A,B,C] :
      ( ~ ( ~ r1_xboole_0(A,k2_xboole_0(B,C))
          & r1_xboole_0(A,B)
          & r1_xboole_0(A,C) )
      & ~ ( ~ ( r1_xboole_0(A,B)
              & r1_xboole_0(A,C) )
          & r1_xboole_0(A,k2_xboole_0(B,C)) ) ) ).

fof(t71_xboole_1,axiom,
    ! [A,B,C] :
      ( ( k2_xboole_0(A,B) = k2_xboole_0(C,B)
        & r1_xboole_0(A,B)
        & r1_xboole_0(C,B) )
     => A = C ) ).

fof(t72_xboole_1,axiom,
    ! [A,B,C,D] :
      ( ( k2_xboole_0(A,B) = k2_xboole_0(C,D)
        & r1_xboole_0(C,A)
        & r1_xboole_0(D,B) )
     => C = B ) ).

fof(t73_xboole_1,axiom,
    ! [A,B,C] :
      ( ( r1_tarski(A,k2_xboole_0(B,C))
        & r1_xboole_0(A,C) )
     => r1_tarski(A,B) ) ).

fof(t74_xboole_1,axiom,
    ! [A,B,C] :
      ~ ( ~ r1_xboole_0(A,k3_xboole_0(B,C))
        & r1_xboole_0(A,B) ) ).

fof(t75_xboole_1,axiom,
    ! [A,B] :
      ~ ( ~ r1_xboole_0(A,B)
        & r1_xboole_0(k3_xboole_0(A,B),B) ) ).

fof(t76_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_xboole_0(A,B)
     => r1_xboole_0(k3_xboole_0(C,A),k3_xboole_0(C,B)) ) ).

fof(t77_xboole_1,axiom,
    ! [A,B,C] :
      ~ ( ~ r1_xboole_0(A,B)
        & r1_tarski(A,C)
        & r1_xboole_0(A,k3_xboole_0(B,C)) ) ).

fof(t78_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_xboole_0(A,B)
     => k3_xboole_0(A,k2_xboole_0(B,C)) = k3_xboole_0(A,C) ) ).

fof(t79_xboole_1,axiom,
    ! [A,B] : r1_xboole_0(k4_xboole_0(A,B),B) ).

fof(t80_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_xboole_0(A,B)
     => r1_xboole_0(A,k4_xboole_0(B,C)) ) ).

fof(t81_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_xboole_0(A,k4_xboole_0(B,C))
     => r1_xboole_0(B,k4_xboole_0(A,C)) ) ).

fof(t82_xboole_1,axiom,
    ! [A,B] : r1_xboole_0(k4_xboole_0(A,B),k4_xboole_0(B,A)) ).

fof(t83_xboole_1,axiom,
    ! [A,B] :
      ( r1_xboole_0(A,B)
    <=> k4_xboole_0(A,B) = A ) ).

fof(t84_xboole_1,axiom,
    ! [A,B,C] :
      ~ ( ~ r1_xboole_0(A,B)
        & r1_xboole_0(A,C)
        & r1_xboole_0(A,k4_xboole_0(B,C)) ) ).

fof(t85_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,B)
     => r1_xboole_0(A,k4_xboole_0(C,B)) ) ).

fof(t86_xboole_1,axiom,
    ! [A,B,C] :
      ( ( r1_tarski(A,B)
        & r1_xboole_0(A,C) )
     => r1_tarski(A,k4_xboole_0(B,C)) ) ).

fof(t87_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_xboole_0(A,B)
     => k2_xboole_0(k4_xboole_0(C,A),B) = k4_xboole_0(k2_xboole_0(C,B),A) ) ).

fof(t88_xboole_1,axiom,
    ! [A,B] :
      ( r1_xboole_0(A,B)
     => k4_xboole_0(k2_xboole_0(A,B),B) = A ) ).

fof(t89_xboole_1,axiom,
    ! [A,B] : r1_xboole_0(k3_xboole_0(A,B),k4_xboole_0(A,B)) ).

fof(t90_xboole_1,axiom,
    ! [A,B] : r1_xboole_0(k4_xboole_0(A,k3_xboole_0(A,B)),B) ).

fof(t91_xboole_1,axiom,
    ! [A,B,C] : k5_xboole_0(k5_xboole_0(A,B),C) = k5_xboole_0(A,k5_xboole_0(B,C)) ).

fof(t92_xboole_1,axiom,
    ! [A] : k5_xboole_0(A,A) = k1_xboole_0 ).

fof(t93_xboole_1,axiom,
    ! [A,B] : k2_xboole_0(A,B) = k2_xboole_0(k5_xboole_0(A,B),k3_xboole_0(A,B)) ).

fof(t94_xboole_1,axiom,
    ! [A,B] : k2_xboole_0(A,B) = k5_xboole_0(k5_xboole_0(A,B),k3_xboole_0(A,B)) ).

fof(t95_xboole_1,axiom,
    ! [A,B] : k3_xboole_0(A,B) = k5_xboole_0(k5_xboole_0(A,B),k2_xboole_0(A,B)) ).

fof(t96_xboole_1,axiom,
    ! [A,B] : r1_tarski(k4_xboole_0(A,B),k5_xboole_0(A,B)) ).

fof(t97_xboole_1,axiom,
    ! [A,B,C] :
      ( ( r1_tarski(k4_xboole_0(A,B),C)
        & r1_tarski(k4_xboole_0(B,A),C) )
     => r1_tarski(k5_xboole_0(A,B),C) ) ).

fof(t98_xboole_1,axiom,
    ! [A,B] : k2_xboole_0(A,B) = k5_xboole_0(A,k4_xboole_0(B,A)) ).

fof(t99_xboole_1,axiom,
    ! [A,B,C] : k4_xboole_0(k5_xboole_0(A,B),C) = k2_xboole_0(k4_xboole_0(A,k2_xboole_0(B,C)),k4_xboole_0(B,k2_xboole_0(A,C))) ).

fof(t100_xboole_1,axiom,
    ! [A,B] : k4_xboole_0(A,B) = k5_xboole_0(A,k3_xboole_0(A,B)) ).

fof(t101_xboole_1,axiom,
    ! [A,B] : k5_xboole_0(A,B) = k4_xboole_0(k2_xboole_0(A,B),k3_xboole_0(A,B)) ).

fof(t102_xboole_1,axiom,
    ! [A,B,C] : k4_xboole_0(A,k5_xboole_0(B,C)) = k2_xboole_0(k4_xboole_0(A,k2_xboole_0(B,C)),k3_xboole_0(k3_xboole_0(A,B),C)) ).

fof(t103_xboole_1,axiom,
    ! [A,B] : r1_xboole_0(k3_xboole_0(A,B),k5_xboole_0(A,B)) ).

fof(t104_xboole_1,axiom,
    ! [A,B] :
      ( ~ ( ~ r2_xboole_0(A,B)
          & A != B
          & ~ r2_xboole_0(B,A) )
    <=> r3_xboole_0(A,B) ) ).

fof(t105_xboole_1,axiom,
    ! [A,B] :
      ~ ( r2_xboole_0(A,B)
        & k4_xboole_0(B,A) = k1_xboole_0 ) ).

fof(t106_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,k4_xboole_0(B,C))
     => ( r1_tarski(A,B)
        & r1_xboole_0(A,C) ) ) ).

fof(t107_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,k5_xboole_0(B,C))
    <=> ( r1_tarski(A,k2_xboole_0(B,C))
        & r1_xboole_0(A,k3_xboole_0(B,C)) ) ) ).

fof(t108_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,B)
     => r1_tarski(k3_xboole_0(A,C),B) ) ).

fof(t109_xboole_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,B)
     => r1_tarski(k4_xboole_0(A,C),B) ) ).

fof(t110_xboole_1,axiom,
    ! [A,B,C] :
      ( ( r1_tarski(A,B)
        & r1_tarski(C,B) )
     => r1_tarski(k5_xboole_0(A,C),B) ) ).

fof(t111_xboole_1,axiom,
    ! [A,B,C] : k4_xboole_0(k3_xboole_0(A,B),k3_xboole_0(C,B)) = k3_xboole_0(k4_xboole_0(A,C),B) ).

fof(t112_xboole_1,axiom,
    ! [A,B,C] : k5_xboole_0(k3_xboole_0(A,B),k3_xboole_0(C,B)) = k3_xboole_0(k5_xboole_0(A,C),B) ).

fof(t113_xboole_1,axiom,
    ! [A,B,C,D] : k2_xboole_0(k2_xboole_0(k2_xboole_0(A,B),C),D) = k2_xboole_0(A,k2_xboole_0(k2_xboole_0(B,C),D)) ).

fof(t114_xboole_1,axiom,
    ! [A,B,C,D] :
      ( ( r1_xboole_0(A,D)
        & r1_xboole_0(B,D)
        & r1_xboole_0(C,D) )
     => r1_xboole_0(k2_xboole_0(k2_xboole_0(A,B),C),D) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(fc1_zfmisc_1,axiom,
    ! [A,B] : ~ v1_xboole_0(k4_tarski(A,B)) ).

fof(d1_zfmisc_1,axiom,
    ! [A,B] :
      ( B = k1_zfmisc_1(A)
    <=> ! [C] :
          ( r2_hidden(C,B)
        <=> r1_tarski(C,A) ) ) ).

fof(d2_zfmisc_1,axiom,
    ! [A,B,C] :
      ( C = k2_zfmisc_1(A,B)
    <=> ! [D] :
          ( r2_hidden(D,C)
        <=> ? [E,F] :
              ( r2_hidden(E,A)
              & r2_hidden(F,B)
              & D = k4_tarski(E,F) ) ) ) ).

fof(d3_zfmisc_1,axiom,
    ! [A,B,C] : k3_zfmisc_1(A,B,C) = k2_zfmisc_1(k2_zfmisc_1(A,B),C) ).

fof(d4_zfmisc_1,axiom,
    ! [A,B,C,D] : k4_zfmisc_1(A,B,C,D) = k2_zfmisc_1(k3_zfmisc_1(A,B,C),D) ).

fof(t1_zfmisc_1,axiom,
    k1_zfmisc_1(k1_xboole_0) = k1_tarski(k1_xboole_0) ).

fof(t2_zfmisc_1,axiom,
    k3_tarski(k1_xboole_0) = k1_xboole_0 ).

fof(t3_zfmisc_1,axiom,
    $true ).

fof(t4_zfmisc_1,axiom,
    $true ).

fof(t5_zfmisc_1,axiom,
    $true ).

fof(t6_zfmisc_1,axiom,
    ! [A,B] :
      ( r1_tarski(k1_tarski(A),k1_tarski(B))
     => A = B ) ).

fof(t7_zfmisc_1,axiom,
    $true ).

fof(t8_zfmisc_1,axiom,
    ! [A,B,C] :
      ( k1_tarski(A) = k2_tarski(B,C)
     => A = B ) ).

fof(t9_zfmisc_1,axiom,
    ! [A,B,C] :
      ( k1_tarski(A) = k2_tarski(B,C)
     => B = C ) ).

fof(t10_zfmisc_1,axiom,
    ! [A,B,C,D] :
      ~ ( k2_tarski(A,B) = k2_tarski(C,D)
        & A != C
        & A != D ) ).

fof(t11_zfmisc_1,axiom,
    $true ).

fof(t12_zfmisc_1,axiom,
    ! [A,B] : r1_tarski(k1_tarski(A),k2_tarski(A,B)) ).

fof(t13_zfmisc_1,axiom,
    ! [A,B] :
      ( k2_xboole_0(k1_tarski(A),k1_tarski(B)) = k1_tarski(A)
     => A = B ) ).

fof(t14_zfmisc_1,axiom,
    ! [A,B] : k2_xboole_0(k1_tarski(A),k2_tarski(A,B)) = k2_tarski(A,B) ).

fof(t15_zfmisc_1,axiom,
    $true ).

fof(t16_zfmisc_1,axiom,
    ! [A,B] :
      ~ ( r1_xboole_0(k1_tarski(A),k1_tarski(B))
        & A = B ) ).

fof(t17_zfmisc_1,axiom,
    ! [A,B] :
      ( A != B
     => r1_xboole_0(k1_tarski(A),k1_tarski(B)) ) ).

fof(t18_zfmisc_1,axiom,
    ! [A,B] :
      ( k3_xboole_0(k1_tarski(A),k1_tarski(B)) = k1_tarski(A)
     => A = B ) ).

fof(t19_zfmisc_1,axiom,
    ! [A,B] : k3_xboole_0(k1_tarski(A),k2_tarski(A,B)) = k1_tarski(A) ).

fof(t20_zfmisc_1,axiom,
    ! [A,B] :
      ( k4_xboole_0(k1_tarski(A),k1_tarski(B)) = k1_tarski(A)
    <=> A != B ) ).

fof(t21_zfmisc_1,axiom,
    ! [A,B] :
      ( k4_xboole_0(k1_tarski(A),k1_tarski(B)) = k1_xboole_0
     => A = B ) ).

fof(t22_zfmisc_1,axiom,
    ! [A,B] : k4_xboole_0(k1_tarski(A),k2_tarski(A,B)) = k1_xboole_0 ).

fof(t23_zfmisc_1,axiom,
    ! [A,B] :
      ( A != B
     => k4_xboole_0(k2_tarski(A,B),k1_tarski(B)) = k1_tarski(A) ) ).

fof(t24_zfmisc_1,axiom,
    ! [A,B] :
      ( r1_tarski(k1_tarski(A),k1_tarski(B))
     => A = B ) ).

fof(t25_zfmisc_1,axiom,
    ! [A,B,C] :
      ~ ( r1_tarski(k1_tarski(A),k2_tarski(B,C))
        & A != B
        & A != C ) ).

fof(t26_zfmisc_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(k2_tarski(A,B),k1_tarski(C))
     => A = C ) ).

fof(t27_zfmisc_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(k2_tarski(A,B),k1_tarski(C))
     => k2_tarski(A,B) = k1_tarski(C) ) ).

fof(t28_zfmisc_1,axiom,
    ! [A,B,C,D] :
      ~ ( r1_tarski(k2_tarski(A,B),k2_tarski(C,D))
        & A != C
        & A != D ) ).

fof(t29_zfmisc_1,axiom,
    ! [A,B] :
      ( A != B
     => k5_xboole_0(k1_tarski(A),k1_tarski(B)) = k2_tarski(A,B) ) ).

fof(t30_zfmisc_1,axiom,
    ! [A] : k1_zfmisc_1(k1_tarski(A)) = k2_tarski(k1_xboole_0,k1_tarski(A)) ).

fof(t31_zfmisc_1,axiom,
    ! [A] : k3_tarski(k1_tarski(A)) = A ).

fof(t32_zfmisc_1,axiom,
    ! [A,B] : k3_tarski(k2_tarski(k1_tarski(A),k1_tarski(B))) = k2_tarski(A,B) ).

fof(t33_zfmisc_1,axiom,
    ! [A,B,C,D] :
      ( k4_tarski(A,B) = k4_tarski(C,D)
     => ( A = C
        & B = D ) ) ).

fof(t34_zfmisc_1,axiom,
    ! [A,B,C,D] :
      ( r2_hidden(k4_tarski(A,B),k2_zfmisc_1(k1_tarski(C),k1_tarski(D)))
    <=> ( A = C
        & B = D ) ) ).

fof(t35_zfmisc_1,axiom,
    ! [A,B] : k2_zfmisc_1(k1_tarski(A),k1_tarski(B)) = k1_tarski(k4_tarski(A,B)) ).

fof(t36_zfmisc_1,axiom,
    ! [A,B,C] :
      ( k2_zfmisc_1(k1_tarski(A),k2_tarski(B,C)) = k2_tarski(k4_tarski(A,B),k4_tarski(A,C))
      & k2_zfmisc_1(k2_tarski(A,B),k1_tarski(C)) = k2_tarski(k4_tarski(A,C),k4_tarski(B,C)) ) ).

fof(t37_zfmisc_1,axiom,
    ! [A,B] :
      ( r1_tarski(k1_tarski(A),B)
    <=> r2_hidden(A,B) ) ).

fof(t38_zfmisc_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(k2_tarski(A,B),C)
    <=> ( r2_hidden(A,C)
        & r2_hidden(B,C) ) ) ).

fof(t39_zfmisc_1,axiom,
    ! [A,B] :
      ( r1_tarski(A,k1_tarski(B))
    <=> ( A = k1_xboole_0
        | A = k1_tarski(B) ) ) ).

fof(t40_zfmisc_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,B)
     => ( r2_hidden(C,A)
        | r1_tarski(A,k4_xboole_0(B,k1_tarski(C))) ) ) ).

fof(t41_zfmisc_1,axiom,
    ! [A,B] :
      ~ ( A != k1_tarski(B)
        & A != k1_xboole_0
        & ! [C] :
            ~ ( r2_hidden(C,A)
              & C != B ) ) ).

fof(t42_zfmisc_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,k2_tarski(B,C))
    <=> ~ ( A != k1_xboole_0
          & A != k1_tarski(B)
          & A != k1_tarski(C)
          & A != k2_tarski(B,C) ) ) ).

fof(t43_zfmisc_1,axiom,
    ! [A,B,C] :
      ~ ( k1_tarski(A) = k2_xboole_0(B,C)
        & ~ ( B = k1_tarski(A)
            & C = k1_tarski(A) )
        & ~ ( B = k1_xboole_0
            & C = k1_tarski(A) )
        & ~ ( B = k1_tarski(A)
            & C = k1_xboole_0 ) ) ).

fof(t44_zfmisc_1,axiom,
    ! [A,B,C] :
      ~ ( k1_tarski(A) = k2_xboole_0(B,C)
        & B != C
        & B != k1_xboole_0
        & C != k1_xboole_0 ) ).

fof(t45_zfmisc_1,axiom,
    ! [A,B] :
      ( r1_tarski(k2_xboole_0(k1_tarski(A),B),B)
     => r2_hidden(A,B) ) ).

fof(t46_zfmisc_1,axiom,
    ! [A,B] :
      ( r2_hidden(A,B)
     => k2_xboole_0(k1_tarski(A),B) = B ) ).

fof(t47_zfmisc_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(k2_xboole_0(k2_tarski(A,B),C),C)
     => r2_hidden(A,C) ) ).

fof(t48_zfmisc_1,axiom,
    ! [A,B,C] :
      ( ( r2_hidden(A,B)
        & r2_hidden(C,B) )
     => k2_xboole_0(k2_tarski(A,C),B) = B ) ).

fof(t49_zfmisc_1,axiom,
    ! [A,B] : k2_xboole_0(k1_tarski(A),B) != k1_xboole_0 ).

fof(t50_zfmisc_1,axiom,
    ! [A,B,C] : k2_xboole_0(k2_tarski(A,B),C) != k1_xboole_0 ).

fof(t51_zfmisc_1,axiom,
    ! [A,B] :
      ( k3_xboole_0(A,k1_tarski(B)) = k1_tarski(B)
     => r2_hidden(B,A) ) ).

fof(t52_zfmisc_1,axiom,
    ! [A,B] :
      ( r2_hidden(A,B)
     => k3_xboole_0(B,k1_tarski(A)) = k1_tarski(A) ) ).

fof(t53_zfmisc_1,axiom,
    ! [A,B,C] :
      ( ( r2_hidden(A,B)
        & r2_hidden(C,B) )
     => k3_xboole_0(k2_tarski(A,C),B) = k2_tarski(A,C) ) ).

fof(t54_zfmisc_1,axiom,
    ! [A,B] :
      ~ ( r1_xboole_0(k1_tarski(A),B)
        & r2_hidden(A,B) ) ).

fof(t55_zfmisc_1,axiom,
    ! [A,B,C] :
      ~ ( r1_xboole_0(k2_tarski(A,B),C)
        & r2_hidden(A,C) ) ).

fof(t56_zfmisc_1,axiom,
    ! [A,B] :
      ( ~ r2_hidden(A,B)
     => r1_xboole_0(k1_tarski(A),B) ) ).

fof(t57_zfmisc_1,axiom,
    ! [A,B,C] :
      ~ ( ~ r2_hidden(A,B)
        & ~ r2_hidden(C,B)
        & ~ r1_xboole_0(k2_tarski(A,C),B) ) ).

fof(t58_zfmisc_1,axiom,
    ! [A,B] :
      ( r1_xboole_0(k1_tarski(A),B)
      | k3_xboole_0(k1_tarski(A),B) = k1_tarski(A) ) ).

fof(t59_zfmisc_1,axiom,
    ! [A,B,C] :
      ~ ( k3_xboole_0(k2_tarski(A,B),C) = k1_tarski(A)
        & r2_hidden(B,C)
        & A != B ) ).

fof(t60_zfmisc_1,axiom,
    ! [A,B,C] :
      ( r2_hidden(A,B)
     => ( ( r2_hidden(C,B)
          & A != C )
        | k3_xboole_0(k2_tarski(A,C),B) = k1_tarski(A) ) ) ).

fof(t61_zfmisc_1,axiom,
    $true ).

fof(t62_zfmisc_1,axiom,
    $true ).

fof(t63_zfmisc_1,axiom,
    ! [A,B,C] :
      ( k3_xboole_0(k2_tarski(A,B),C) = k2_tarski(A,B)
     => r2_hidden(A,C) ) ).

fof(t64_zfmisc_1,axiom,
    ! [A,B,C] :
      ( r2_hidden(A,k4_xboole_0(B,k1_tarski(C)))
    <=> ( r2_hidden(A,B)
        & A != C ) ) ).

fof(t65_zfmisc_1,axiom,
    ! [A,B] :
      ( k4_xboole_0(A,k1_tarski(B)) = A
    <=> ~ r2_hidden(B,A) ) ).

fof(t66_zfmisc_1,axiom,
    ! [A,B] :
      ~ ( k4_xboole_0(A,k1_tarski(B)) = k1_xboole_0
        & A != k1_xboole_0
        & A != k1_tarski(B) ) ).

fof(t67_zfmisc_1,axiom,
    ! [A,B] :
      ( k4_xboole_0(k1_tarski(A),B) = k1_tarski(A)
    <=> ~ r2_hidden(A,B) ) ).

fof(t68_zfmisc_1,axiom,
    ! [A,B] :
      ( k4_xboole_0(k1_tarski(A),B) = k1_xboole_0
    <=> r2_hidden(A,B) ) ).

fof(t69_zfmisc_1,axiom,
    ! [A,B] :
      ( k4_xboole_0(k1_tarski(A),B) = k1_xboole_0
      | k4_xboole_0(k1_tarski(A),B) = k1_tarski(A) ) ).

fof(t70_zfmisc_1,axiom,
    ! [A,B,C] :
      ( k4_xboole_0(k2_tarski(A,B),C) = k1_tarski(A)
    <=> ( ~ r2_hidden(A,C)
        & ( r2_hidden(B,C)
          | A = B ) ) ) ).

fof(t71_zfmisc_1,axiom,
    $true ).

fof(t72_zfmisc_1,axiom,
    ! [A,B,C] :
      ( k4_xboole_0(k2_tarski(A,B),C) = k2_tarski(A,B)
    <=> ( ~ r2_hidden(A,C)
        & ~ r2_hidden(B,C) ) ) ).

fof(t73_zfmisc_1,axiom,
    ! [A,B,C] :
      ( k4_xboole_0(k2_tarski(A,B),C) = k1_xboole_0
    <=> ( r2_hidden(A,C)
        & r2_hidden(B,C) ) ) ).

fof(t74_zfmisc_1,axiom,
    ! [A,B,C] :
      ~ ( k4_xboole_0(k2_tarski(A,B),C) != k1_xboole_0
        & k4_xboole_0(k2_tarski(A,B),C) != k1_tarski(A)
        & k4_xboole_0(k2_tarski(A,B),C) != k1_tarski(B)
        & k4_xboole_0(k2_tarski(A,B),C) != k2_tarski(A,B) ) ).

fof(t75_zfmisc_1,axiom,
    ! [A,B,C] :
      ( k4_xboole_0(A,k2_tarski(B,C)) = k1_xboole_0
    <=> ~ ( A != k1_xboole_0
          & A != k1_tarski(B)
          & A != k1_tarski(C)
          & A != k2_tarski(B,C) ) ) ).

fof(t76_zfmisc_1,axiom,
    $true ).

fof(t77_zfmisc_1,axiom,
    $true ).

fof(t78_zfmisc_1,axiom,
    $true ).

fof(t79_zfmisc_1,axiom,
    ! [A,B] :
      ( r1_tarski(A,B)
     => r1_tarski(k1_zfmisc_1(A),k1_zfmisc_1(B)) ) ).

fof(t80_zfmisc_1,axiom,
    ! [A] : r1_tarski(k1_tarski(A),k1_zfmisc_1(A)) ).

fof(t81_zfmisc_1,axiom,
    ! [A,B] : r1_tarski(k2_xboole_0(k1_zfmisc_1(A),k1_zfmisc_1(B)),k1_zfmisc_1(k2_xboole_0(A,B))) ).

fof(t82_zfmisc_1,axiom,
    ! [A,B] :
      ( k2_xboole_0(k1_zfmisc_1(A),k1_zfmisc_1(B)) = k1_zfmisc_1(k2_xboole_0(A,B))
     => r3_xboole_0(A,B) ) ).

fof(t83_zfmisc_1,axiom,
    ! [A,B] : k1_zfmisc_1(k3_xboole_0(A,B)) = k3_xboole_0(k1_zfmisc_1(A),k1_zfmisc_1(B)) ).

fof(t84_zfmisc_1,axiom,
    ! [A,B] : r1_tarski(k1_zfmisc_1(k4_xboole_0(A,B)),k2_xboole_0(k1_tarski(k1_xboole_0),k4_xboole_0(k1_zfmisc_1(A),k1_zfmisc_1(B)))) ).

fof(t85_zfmisc_1,axiom,
    $true ).

fof(t86_zfmisc_1,axiom,
    ! [A,B] : r1_tarski(k2_xboole_0(k1_zfmisc_1(k4_xboole_0(A,B)),k1_zfmisc_1(k4_xboole_0(B,A))),k1_zfmisc_1(k5_xboole_0(A,B))) ).

fof(t87_zfmisc_1,axiom,
    $true ).

fof(t88_zfmisc_1,axiom,
    $true ).

fof(t89_zfmisc_1,axiom,
    $true ).

fof(t90_zfmisc_1,axiom,
    $true ).

fof(t91_zfmisc_1,axiom,
    $true ).

fof(t92_zfmisc_1,axiom,
    ! [A,B] :
      ( r2_hidden(A,B)
     => r1_tarski(A,k3_tarski(B)) ) ).

fof(t93_zfmisc_1,axiom,
    ! [A,B] : k3_tarski(k2_tarski(A,B)) = k2_xboole_0(A,B) ).

fof(t94_zfmisc_1,axiom,
    ! [A,B] :
      ( ! [C] :
          ( r2_hidden(C,A)
         => r1_tarski(C,B) )
     => r1_tarski(k3_tarski(A),B) ) ).

fof(t95_zfmisc_1,axiom,
    ! [A,B] :
      ( r1_tarski(A,B)
     => r1_tarski(k3_tarski(A),k3_tarski(B)) ) ).

fof(t96_zfmisc_1,axiom,
    ! [A,B] : k3_tarski(k2_xboole_0(A,B)) = k2_xboole_0(k3_tarski(A),k3_tarski(B)) ).

fof(t97_zfmisc_1,axiom,
    ! [A,B] : r1_tarski(k3_tarski(k3_xboole_0(A,B)),k3_xboole_0(k3_tarski(A),k3_tarski(B))) ).

fof(t98_zfmisc_1,axiom,
    ! [A,B] :
      ( ! [C] :
          ( r2_hidden(C,A)
         => r1_xboole_0(C,B) )
     => r1_xboole_0(k3_tarski(A),B) ) ).

fof(t99_zfmisc_1,axiom,
    ! [A] : k3_tarski(k1_zfmisc_1(A)) = A ).

fof(t100_zfmisc_1,axiom,
    ! [A] : r1_tarski(A,k1_zfmisc_1(k3_tarski(A))) ).

fof(t101_zfmisc_1,axiom,
    ! [A,B] :
      ( ! [C,D] :
          ( ( r2_hidden(C,k2_xboole_0(A,B))
            & r2_hidden(D,k2_xboole_0(A,B)) )
         => ( C = D
            | r1_xboole_0(C,D) ) )
     => k3_tarski(k3_xboole_0(A,B)) = k3_xboole_0(k3_tarski(A),k3_tarski(B)) ) ).

fof(t102_zfmisc_1,axiom,
    ! [A,B,C] :
      ~ ( r2_hidden(A,k2_zfmisc_1(B,C))
        & ! [D,E] : k4_tarski(D,E) != A ) ).

fof(t103_zfmisc_1,axiom,
    ! [A,B,C,D] :
      ~ ( r1_tarski(A,k2_zfmisc_1(B,C))
        & r2_hidden(D,A)
        & ! [E,F] :
            ~ ( r2_hidden(E,B)
              & r2_hidden(F,C)
              & D = k4_tarski(E,F) ) ) ).

fof(t104_zfmisc_1,axiom,
    ! [A,B,C,D,E] :
      ~ ( r2_hidden(A,k3_xboole_0(k2_zfmisc_1(B,C),k2_zfmisc_1(D,E)))
        & ! [F,G] :
            ~ ( A = k4_tarski(F,G)
              & r2_hidden(F,k3_xboole_0(B,D))
              & r2_hidden(G,k3_xboole_0(C,E)) ) ) ).

fof(t105_zfmisc_1,axiom,
    ! [A,B] : r1_tarski(k2_zfmisc_1(A,B),k1_zfmisc_1(k1_zfmisc_1(k2_xboole_0(A,B)))) ).

fof(t106_zfmisc_1,axiom,
    ! [A,B,C,D] :
      ( r2_hidden(k4_tarski(A,B),k2_zfmisc_1(C,D))
    <=> ( r2_hidden(A,C)
        & r2_hidden(B,D) ) ) ).

fof(t107_zfmisc_1,axiom,
    ! [A,B,C,D] :
      ( r2_hidden(k4_tarski(A,B),k2_zfmisc_1(C,D))
     => r2_hidden(k4_tarski(B,A),k2_zfmisc_1(D,C)) ) ).

fof(t108_zfmisc_1,axiom,
    ! [A,B,C,D] :
      ( ! [E,F] :
          ( r2_hidden(k4_tarski(E,F),k2_zfmisc_1(A,B))
        <=> r2_hidden(k4_tarski(E,F),k2_zfmisc_1(C,D)) )
     => k2_zfmisc_1(A,B) = k2_zfmisc_1(C,D) ) ).

fof(t109_zfmisc_1,axiom,
    ! [A,B,C,D] :
      ( ( r1_tarski(A,k2_zfmisc_1(B,C))
        & ! [E,F] :
            ( r2_hidden(k4_tarski(E,F),A)
           => r2_hidden(k4_tarski(E,F),D) ) )
     => r1_tarski(A,D) ) ).

fof(t110_zfmisc_1,axiom,
    ! [A,B,C,D,E,F] :
      ( ( r1_tarski(A,k2_zfmisc_1(B,C))
        & r1_tarski(D,k2_zfmisc_1(E,F))
        & ! [G,H] :
            ( r2_hidden(k4_tarski(G,H),A)
          <=> r2_hidden(k4_tarski(G,H),D) ) )
     => A = D ) ).

fof(t111_zfmisc_1,axiom,
    ! [A,B] :
      ( ( ! [C] :
            ~ ( r2_hidden(C,A)
              & ! [D,E] : C != k4_tarski(D,E) )
        & ! [C,D] :
            ( r2_hidden(k4_tarski(C,D),A)
           => r2_hidden(k4_tarski(C,D),B) ) )
     => r1_tarski(A,B) ) ).

fof(t112_zfmisc_1,axiom,
    ! [A,B] :
      ( ( ! [C] :
            ~ ( r2_hidden(C,A)
              & ! [D,E] : C != k4_tarski(D,E) )
        & ! [C] :
            ~ ( r2_hidden(C,B)
              & ! [D,E] : C != k4_tarski(D,E) )
        & ! [C,D] :
            ( r2_hidden(k4_tarski(C,D),A)
          <=> r2_hidden(k4_tarski(C,D),B) ) )
     => A = B ) ).

fof(t113_zfmisc_1,axiom,
    ! [A,B] :
      ( k2_zfmisc_1(A,B) = k1_xboole_0
    <=> ( A = k1_xboole_0
        | B = k1_xboole_0 ) ) ).

fof(t114_zfmisc_1,axiom,
    ! [A,B] :
      ( k2_zfmisc_1(A,B) = k2_zfmisc_1(B,A)
     => ( A = k1_xboole_0
        | B = k1_xboole_0
        | A = B ) ) ).

fof(t115_zfmisc_1,axiom,
    ! [A,B] :
      ( k2_zfmisc_1(A,A) = k2_zfmisc_1(B,B)
     => A = B ) ).

fof(t116_zfmisc_1,axiom,
    ! [A] :
      ( r1_tarski(A,k2_zfmisc_1(A,A))
     => A = k1_xboole_0 ) ).

fof(t117_zfmisc_1,axiom,
    ! [A,B,C] :
      ~ ( A != k1_xboole_0
        & ( r1_tarski(k2_zfmisc_1(B,A),k2_zfmisc_1(C,A))
          | r1_tarski(k2_zfmisc_1(A,B),k2_zfmisc_1(A,C)) )
        & ~ r1_tarski(B,C) ) ).

fof(t118_zfmisc_1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,B)
     => ( r1_tarski(k2_zfmisc_1(A,C),k2_zfmisc_1(B,C))
        & r1_tarski(k2_zfmisc_1(C,A),k2_zfmisc_1(C,B)) ) ) ).

fof(t119_zfmisc_1,axiom,
    ! [A,B,C,D] :
      ( ( r1_tarski(A,B)
        & r1_tarski(C,D) )
     => r1_tarski(k2_zfmisc_1(A,C),k2_zfmisc_1(B,D)) ) ).

fof(t120_zfmisc_1,axiom,
    ! [A,B,C] :
      ( k2_zfmisc_1(k2_xboole_0(A,B),C) = k2_xboole_0(k2_zfmisc_1(A,C),k2_zfmisc_1(B,C))
      & k2_zfmisc_1(C,k2_xboole_0(A,B)) = k2_xboole_0(k2_zfmisc_1(C,A),k2_zfmisc_1(C,B)) ) ).

fof(t121_zfmisc_1,axiom,
    ! [A,B,C,D] : k2_zfmisc_1(k2_xboole_0(A,B),k2_xboole_0(C,D)) = k2_xboole_0(k2_xboole_0(k2_xboole_0(k2_zfmisc_1(A,C),k2_zfmisc_1(A,D)),k2_zfmisc_1(B,C)),k2_zfmisc_1(B,D)) ).

fof(t122_zfmisc_1,axiom,
    ! [A,B,C] :
      ( k2_zfmisc_1(k3_xboole_0(A,B),C) = k3_xboole_0(k2_zfmisc_1(A,C),k2_zfmisc_1(B,C))
      & k2_zfmisc_1(C,k3_xboole_0(A,B)) = k3_xboole_0(k2_zfmisc_1(C,A),k2_zfmisc_1(C,B)) ) ).

fof(t123_zfmisc_1,axiom,
    ! [A,B,C,D] : k2_zfmisc_1(k3_xboole_0(A,B),k3_xboole_0(C,D)) = k3_xboole_0(k2_zfmisc_1(A,C),k2_zfmisc_1(B,D)) ).

fof(t124_zfmisc_1,axiom,
    ! [A,B,C,D] :
      ( ( r1_tarski(A,B)
        & r1_tarski(C,D) )
     => k3_xboole_0(k2_zfmisc_1(A,D),k2_zfmisc_1(B,C)) = k2_zfmisc_1(A,C) ) ).

fof(t125_zfmisc_1,axiom,
    ! [A,B,C] :
      ( k2_zfmisc_1(k4_xboole_0(A,B),C) = k4_xboole_0(k2_zfmisc_1(A,C),k2_zfmisc_1(B,C))
      & k2_zfmisc_1(C,k4_xboole_0(A,B)) = k4_xboole_0(k2_zfmisc_1(C,A),k2_zfmisc_1(C,B)) ) ).

fof(t126_zfmisc_1,axiom,
    ! [A,B,C,D] : k4_xboole_0(k2_zfmisc_1(A,B),k2_zfmisc_1(C,D)) = k2_xboole_0(k2_zfmisc_1(k4_xboole_0(A,C),B),k2_zfmisc_1(A,k4_xboole_0(B,D))) ).

fof(t127_zfmisc_1,axiom,
    ! [A,B,C,D] :
      ( ( r1_xboole_0(A,B)
        | r1_xboole_0(C,D) )
     => r1_xboole_0(k2_zfmisc_1(A,C),k2_zfmisc_1(B,D)) ) ).

fof(t128_zfmisc_1,axiom,
    ! [A,B,C,D] :
      ( r2_hidden(k4_tarski(A,B),k2_zfmisc_1(k1_tarski(C),D))
    <=> ( A = C
        & r2_hidden(B,D) ) ) ).

fof(t129_zfmisc_1,axiom,
    ! [A,B,C,D] :
      ( r2_hidden(k4_tarski(A,B),k2_zfmisc_1(C,k1_tarski(D)))
    <=> ( r2_hidden(A,C)
        & B = D ) ) ).

fof(t130_zfmisc_1,axiom,
    ! [A,B] :
      ( A != k1_xboole_0
     => ( k2_zfmisc_1(k1_tarski(B),A) != k1_xboole_0
        & k2_zfmisc_1(A,k1_tarski(B)) != k1_xboole_0 ) ) ).

fof(t131_zfmisc_1,axiom,
    ! [A,B,C,D] :
      ( A != B
     => ( r1_xboole_0(k2_zfmisc_1(k1_tarski(A),C),k2_zfmisc_1(k1_tarski(B),D))
        & r1_xboole_0(k2_zfmisc_1(C,k1_tarski(A)),k2_zfmisc_1(D,k1_tarski(B))) ) ) ).

fof(t132_zfmisc_1,axiom,
    ! [A,B,C] :
      ( k2_zfmisc_1(k2_tarski(A,B),C) = k2_xboole_0(k2_zfmisc_1(k1_tarski(A),C),k2_zfmisc_1(k1_tarski(B),C))
      & k2_zfmisc_1(C,k2_tarski(A,B)) = k2_xboole_0(k2_zfmisc_1(C,k1_tarski(A)),k2_zfmisc_1(C,k1_tarski(B))) ) ).

fof(t133_zfmisc_1,axiom,
    $true ).

fof(t134_zfmisc_1,axiom,
    ! [A,B,C,D] :
      ( k2_zfmisc_1(A,B) = k2_zfmisc_1(C,D)
     => ( A = k1_xboole_0
        | B = k1_xboole_0
        | ( A = C
          & B = D ) ) ) ).

fof(t135_zfmisc_1,axiom,
    ! [A,B] :
      ( ( r1_tarski(A,k2_zfmisc_1(A,B))
        | r1_tarski(A,k2_zfmisc_1(B,A)) )
     => A = k1_xboole_0 ) ).

fof(t136_zfmisc_1,axiom,
    ! [A] :
    ? [B] :
      ( r2_hidden(A,B)
      & ! [C,D] :
          ( ( r2_hidden(C,B)
            & r1_tarski(D,C) )
         => r2_hidden(D,B) )
      & ! [C] :
          ( r2_hidden(C,B)
         => r2_hidden(k1_zfmisc_1(C),B) )
      & ! [C] :
          ~ ( r1_tarski(C,B)
            & ~ r2_tarski(C,B)
            & ~ r2_hidden(C,B) ) ) ).

fof(t137_zfmisc_1,axiom,
    ! [A,B,C,D,E] :
      ( ( r2_hidden(A,k2_zfmisc_1(B,C))
        & r2_hidden(A,k2_zfmisc_1(D,E)) )
     => r2_hidden(A,k2_zfmisc_1(k3_xboole_0(B,D),k3_xboole_0(C,E))) ) ).

fof(t138_zfmisc_1,axiom,
    ! [A,B,C,D] :
      ( r1_tarski(k2_zfmisc_1(A,B),k2_zfmisc_1(C,D))
     => ( k2_zfmisc_1(A,B) = k1_xboole_0
        | ( r1_tarski(A,C)
          & r1_tarski(B,D) ) ) ) ).

fof(t139_zfmisc_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B,C,D] :
          ( ( r1_tarski(k2_zfmisc_1(A,B),k2_zfmisc_1(C,D))
            | r1_tarski(k2_zfmisc_1(B,A),k2_zfmisc_1(D,C)) )
         => r1_tarski(B,D) ) ) ).

fof(t140_zfmisc_1,axiom,
    ! [A,B] :
      ( r2_hidden(A,B)
     => k2_xboole_0(k4_xboole_0(B,k1_tarski(A)),k1_tarski(A)) = B ) ).

fof(t141_zfmisc_1,axiom,
    ! [A,B] :
      ( ~ r2_hidden(A,B)
     => k4_xboole_0(k2_xboole_0(B,k1_tarski(A)),k1_tarski(A)) = B ) ).

fof(dt_k1_zfmisc_1,axiom,
    $true ).

fof(dt_k2_zfmisc_1,axiom,
    $true ).

fof(dt_k3_zfmisc_1,axiom,
    $true ).

fof(dt_k4_zfmisc_1,axiom,
    $true ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(fc1_subset_1,axiom,
    ! [A] : ~ v1_xboole_0(k1_zfmisc_1(A)) ).

fof(fc2_subset_1,axiom,
    ! [A] : ~ v1_xboole_0(k1_tarski(A)) ).

fof(fc3_subset_1,axiom,
    ! [A,B] : ~ v1_xboole_0(k2_tarski(A,B)) ).

fof(rc1_subset_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ? [B] :
          ( m1_subset_1(B,k1_zfmisc_1(A))
          & ~ v1_xboole_0(B) ) ) ).

fof(fc4_subset_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B) )
     => ~ v1_xboole_0(k2_zfmisc_1(A,B)) ) ).

fof(fc5_subset_1,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C) )
     => ~ v1_xboole_0(k3_zfmisc_1(A,B,C)) ) ).

fof(fc6_subset_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C)
        & ~ v1_xboole_0(D) )
     => ~ v1_xboole_0(k4_zfmisc_1(A,B,C,D)) ) ).

fof(rc2_subset_1,axiom,
    ! [A] :
    ? [B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
      & v1_xboole_0(B) ) ).

fof(d1_subset_1,axiom,
    $true ).

fof(d2_subset_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
       => ( m1_subset_1(B,A)
        <=> r2_hidden(B,A) ) )
      & ( v1_xboole_0(A)
       => ( m1_subset_1(B,A)
        <=> v1_xboole_0(B) ) ) ) ).

fof(d3_subset_1,axiom,
    ! [A] : k1_subset_1(A) = k1_xboole_0 ).

fof(d4_subset_1,axiom,
    ! [A] : k2_subset_1(A) = A ).

fof(t1_subset_1,axiom,
    $true ).

fof(t2_subset_1,axiom,
    $true ).

fof(t3_subset_1,axiom,
    $true ).

fof(t4_subset_1,axiom,
    ! [A] : m1_subset_1(k1_xboole_0,k1_zfmisc_1(A)) ).

fof(t5_subset_1,axiom,
    $true ).

fof(t6_subset_1,axiom,
    $true ).

fof(t7_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ( ! [D] :
                ( m1_subset_1(D,A)
               => ( r2_hidden(D,B)
                 => r2_hidden(D,C) ) )
           => r1_tarski(B,C) ) ) ) ).

fof(t8_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ( ! [D] :
                ( m1_subset_1(D,A)
               => ( r2_hidden(D,B)
                <=> r2_hidden(D,C) ) )
           => B = C ) ) ) ).

fof(t9_subset_1,axiom,
    $true ).

fof(t10_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ~ ( B != k1_xboole_0
          & ! [C] :
              ( m1_subset_1(C,A)
             => ~ r2_hidden(C,B) ) ) ) ).

fof(d5_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => k3_subset_1(A,B) = k4_xboole_0(A,B) ) ).

fof(t11_subset_1,axiom,
    $true ).

fof(t12_subset_1,axiom,
    $true ).

fof(t13_subset_1,axiom,
    $true ).

fof(t14_subset_1,axiom,
    $true ).

fof(t15_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ! [D] :
              ( m1_subset_1(D,k1_zfmisc_1(A))
             => ( ! [E] :
                    ( m1_subset_1(E,A)
                   => ( r2_hidden(E,B)
                    <=> ( r2_hidden(E,C)
                        | r2_hidden(E,D) ) ) )
               => B = k4_subset_1(A,C,D) ) ) ) ) ).

fof(t16_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ! [D] :
              ( m1_subset_1(D,k1_zfmisc_1(A))
             => ( ! [E] :
                    ( m1_subset_1(E,A)
                   => ( r2_hidden(E,B)
                    <=> ( r2_hidden(E,C)
                        & r2_hidden(E,D) ) ) )
               => B = k5_subset_1(A,C,D) ) ) ) ) ).

fof(t17_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ! [D] :
              ( m1_subset_1(D,k1_zfmisc_1(A))
             => ( ! [E] :
                    ( m1_subset_1(E,A)
                   => ( r2_hidden(E,B)
                    <=> ( r2_hidden(E,C)
                        & ~ r2_hidden(E,D) ) ) )
               => B = k6_subset_1(A,C,D) ) ) ) ) ).

fof(t18_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ! [D] :
              ( m1_subset_1(D,k1_zfmisc_1(A))
             => ( ! [E] :
                    ( m1_subset_1(E,A)
                   => ( r2_hidden(E,B)
                    <=> ~ ( r2_hidden(E,C)
                        <=> r2_hidden(E,D) ) ) )
               => B = k7_subset_1(A,C,D) ) ) ) ) ).

fof(t19_subset_1,axiom,
    $true ).

fof(t20_subset_1,axiom,
    $true ).

fof(t21_subset_1,axiom,
    ! [A] : k1_subset_1(A) = k3_subset_1(A,k2_subset_1(A)) ).

fof(t22_subset_1,axiom,
    ! [A] : k2_subset_1(A) = k3_subset_1(A,k1_subset_1(A)) ).

fof(t23_subset_1,axiom,
    $true ).

fof(t24_subset_1,axiom,
    $true ).

fof(t25_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => k4_subset_1(A,B,k3_subset_1(A,B)) = k2_subset_1(A) ) ).

fof(t26_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => r1_xboole_0(B,k3_subset_1(A,B)) ) ).

fof(t27_subset_1,axiom,
    $true ).

fof(t28_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => k4_subset_1(A,B,k2_subset_1(A)) = k2_subset_1(A) ) ).

fof(t29_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => k3_subset_1(A,k4_subset_1(A,B,C)) = k5_subset_1(A,k3_subset_1(A,B),k3_subset_1(A,C)) ) ) ).

fof(t30_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => k3_subset_1(A,k5_subset_1(A,B,C)) = k4_subset_1(A,k3_subset_1(A,B),k3_subset_1(A,C)) ) ) ).

fof(t31_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ( r1_tarski(B,C)
          <=> r1_tarski(k3_subset_1(A,C),k3_subset_1(A,B)) ) ) ) ).

fof(t32_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => k6_subset_1(A,B,C) = k5_subset_1(A,B,k3_subset_1(A,C)) ) ) ).

fof(t33_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => k3_subset_1(A,k6_subset_1(A,B,C)) = k4_subset_1(A,k3_subset_1(A,B),C) ) ) ).

fof(t34_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => k3_subset_1(A,k7_subset_1(A,B,C)) = k4_subset_1(A,k5_subset_1(A,B,C),k5_subset_1(A,k3_subset_1(A,B),k3_subset_1(A,C))) ) ) ).

fof(t35_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ( r1_tarski(B,k3_subset_1(A,C))
           => r1_tarski(C,k3_subset_1(A,B)) ) ) ) ).

fof(t36_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ( r1_tarski(k3_subset_1(A,B),C)
           => r1_tarski(k3_subset_1(A,C),B) ) ) ) ).

fof(t37_subset_1,axiom,
    $true ).

fof(t38_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ( r1_tarski(B,k3_subset_1(A,B))
      <=> B = k1_subset_1(A) ) ) ).

fof(t39_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ( r1_tarski(k3_subset_1(A,B),B)
      <=> B = k2_subset_1(A) ) ) ).

fof(t40_subset_1,axiom,
    ! [A,B,C] :
      ( m1_subset_1(C,k1_zfmisc_1(A))
     => ( ( r1_tarski(B,C)
          & r1_tarski(B,k3_subset_1(A,C)) )
       => B = k1_xboole_0 ) ) ).

fof(t41_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => r1_tarski(k3_subset_1(A,k4_subset_1(A,B,C)),k3_subset_1(A,B)) ) ) ).

fof(t42_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => r1_tarski(k3_subset_1(A,B),k3_subset_1(A,k5_subset_1(A,B,C))) ) ) ).

fof(t43_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ( r1_xboole_0(B,C)
          <=> r1_tarski(B,k3_subset_1(A,C)) ) ) ) ).

fof(t44_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ( r1_xboole_0(B,k3_subset_1(A,C))
          <=> r1_tarski(B,C) ) ) ) ).

fof(t45_subset_1,axiom,
    $true ).

fof(t46_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ( ( r1_xboole_0(B,C)
              & r1_xboole_0(k3_subset_1(A,B),k3_subset_1(A,C)) )
           => B = k3_subset_1(A,C) ) ) ) ).

fof(t47_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ! [D] :
              ( m1_subset_1(D,k1_zfmisc_1(A))
             => ( ( r1_tarski(B,C)
                  & r1_xboole_0(D,C) )
               => r1_tarski(B,k3_subset_1(A,D)) ) ) ) ) ).

fof(t48_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ( ! [D] :
                ( m1_subset_1(D,B)
               => r2_hidden(D,C) )
           => r1_tarski(B,C) ) ) ) ).

fof(t49_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ( ! [C] :
            ( m1_subset_1(C,A)
           => r2_hidden(C,B) )
       => A = B ) ) ).

fof(t50_subset_1,axiom,
    ! [A] :
      ( A != k1_xboole_0
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(A))
         => ! [C] :
              ( m1_subset_1(C,A)
             => ( ~ r2_hidden(C,B)
               => r2_hidden(C,k3_subset_1(A,B)) ) ) ) ) ).

fof(t51_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ( ! [D] :
                ( m1_subset_1(D,A)
               => ( r2_hidden(D,B)
                <=> ~ r2_hidden(D,C) ) )
           => B = k3_subset_1(A,C) ) ) ) ).

fof(t52_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ( ! [D] :
                ( m1_subset_1(D,A)
               => ( ~ r2_hidden(D,B)
                <=> r2_hidden(D,C) ) )
           => B = k3_subset_1(A,C) ) ) ) ).

fof(t53_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(A))
         => ( ! [D] :
                ( m1_subset_1(D,A)
               => ~ ( r2_hidden(D,B)
                  <=> r2_hidden(D,C) ) )
           => B = k3_subset_1(A,C) ) ) ) ).

fof(t54_subset_1,axiom,
    ! [A,B,C] :
      ( m1_subset_1(C,k1_zfmisc_1(A))
     => ~ ( r2_hidden(B,k3_subset_1(A,C))
          & r2_hidden(B,C) ) ) ).

fof(t55_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,A)
     => ( A != k1_xboole_0
       => m1_subset_1(k1_tarski(B),k1_zfmisc_1(A)) ) ) ).

fof(t56_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,A)
     => ! [C] :
          ( m1_subset_1(C,A)
         => ( A != k1_xboole_0
           => m1_subset_1(k2_tarski(B,C),k1_zfmisc_1(A)) ) ) ) ).

fof(t57_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,A)
     => ! [C] :
          ( m1_subset_1(C,A)
         => ! [D] :
              ( m1_subset_1(D,A)
             => ( A != k1_xboole_0
               => m1_subset_1(k1_enumset1(B,C,D),k1_zfmisc_1(A)) ) ) ) ) ).

fof(t58_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,A)
     => ! [C] :
          ( m1_subset_1(C,A)
         => ! [D] :
              ( m1_subset_1(D,A)
             => ! [E] :
                  ( m1_subset_1(E,A)
                 => ( A != k1_xboole_0
                   => m1_subset_1(k2_enumset1(B,C,D,E),k1_zfmisc_1(A)) ) ) ) ) ) ).

fof(t59_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,A)
     => ! [C] :
          ( m1_subset_1(C,A)
         => ! [D] :
              ( m1_subset_1(D,A)
             => ! [E] :
                  ( m1_subset_1(E,A)
                 => ! [F] :
                      ( m1_subset_1(F,A)
                     => ( A != k1_xboole_0
                       => m1_subset_1(k3_enumset1(B,C,D,E,F),k1_zfmisc_1(A)) ) ) ) ) ) ) ).

fof(t60_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,A)
     => ! [C] :
          ( m1_subset_1(C,A)
         => ! [D] :
              ( m1_subset_1(D,A)
             => ! [E] :
                  ( m1_subset_1(E,A)
                 => ! [F] :
                      ( m1_subset_1(F,A)
                     => ! [G] :
                          ( m1_subset_1(G,A)
                         => ( A != k1_xboole_0
                           => m1_subset_1(k4_enumset1(B,C,D,E,F,G),k1_zfmisc_1(A)) ) ) ) ) ) ) ) ).

fof(t61_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,A)
     => ! [C] :
          ( m1_subset_1(C,A)
         => ! [D] :
              ( m1_subset_1(D,A)
             => ! [E] :
                  ( m1_subset_1(E,A)
                 => ! [F] :
                      ( m1_subset_1(F,A)
                     => ! [G] :
                          ( m1_subset_1(G,A)
                         => ! [H] :
                              ( m1_subset_1(H,A)
                             => ( A != k1_xboole_0
                               => m1_subset_1(k5_enumset1(B,C,D,E,F,G,H),k1_zfmisc_1(A)) ) ) ) ) ) ) ) ) ).

fof(t62_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,A)
     => ! [C] :
          ( m1_subset_1(C,A)
         => ! [D] :
              ( m1_subset_1(D,A)
             => ! [E] :
                  ( m1_subset_1(E,A)
                 => ! [F] :
                      ( m1_subset_1(F,A)
                     => ! [G] :
                          ( m1_subset_1(G,A)
                         => ! [H] :
                              ( m1_subset_1(H,A)
                             => ! [I] :
                                  ( m1_subset_1(I,A)
                                 => ( A != k1_xboole_0
                                   => m1_subset_1(k6_enumset1(B,C,D,E,F,G,H,I),k1_zfmisc_1(A)) ) ) ) ) ) ) ) ) ) ).

fof(t63_subset_1,axiom,
    ! [A,B] :
      ( r2_hidden(A,B)
     => m1_subset_1(k1_tarski(A),k1_zfmisc_1(B)) ) ).

fof(d6_subset_1,axiom,
    ! [A] :
      ( ~ $true
     => ! [B] :
          ( m1_subset_1(B,A)
         => B = k8_subset_1(A) ) ) ).

fof(s1_subset_1,axiom,
    ? [A] :
      ( m1_subset_1(A,k1_zfmisc_1(f1_s1_subset_1))
      & ! [B] :
          ( r2_hidden(B,A)
        <=> ( r2_hidden(B,f1_s1_subset_1)
            & p1_s1_subset_1(B) ) ) ) ).

fof(s2_subset_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k1_zfmisc_1(f1_s2_subset_1))
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(f1_s2_subset_1))
         => ( ( ! [C] :
                  ( m1_subset_1(C,f1_s2_subset_1)
                 => ( r2_hidden(C,A)
                  <=> p1_s2_subset_1(C) ) )
              & ! [C] :
                  ( m1_subset_1(C,f1_s2_subset_1)
                 => ( r2_hidden(C,B)
                  <=> p1_s2_subset_1(C) ) ) )
           => A = B ) ) ) ).

fof(s3_subset_1,axiom,
    ? [A] :
      ( m1_subset_1(A,k1_zfmisc_1(f1_s3_subset_1))
      & ! [B] :
          ( m1_subset_1(B,f1_s3_subset_1)
         => ( r2_hidden(B,A)
          <=> p1_s3_subset_1(B) ) ) ) ).

fof(s4_subset_1,axiom,
    ( ( ! [A] :
          ( m1_subset_1(A,f1_s4_subset_1)
         => ( r2_hidden(A,f2_s4_subset_1)
          <=> p1_s4_subset_1(A) ) )
      & ! [A] :
          ( m1_subset_1(A,f1_s4_subset_1)
         => ( r2_hidden(A,f3_s4_subset_1)
          <=> p1_s4_subset_1(A) ) ) )
   => f2_s4_subset_1 = f3_s4_subset_1 ) ).

fof(dt_m1_subset_1,axiom,
    $true ).

fof(existence_m1_subset_1,axiom,
    ! [A] :
    ? [B] : m1_subset_1(B,A) ).

fof(dt_m2_subset_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & m1_subset_1(B,k1_zfmisc_1(A)) )
     => ! [C] :
          ( m2_subset_1(C,A,B)
         => m1_subset_1(C,A) ) ) ).

fof(existence_m2_subset_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & m1_subset_1(B,k1_zfmisc_1(A)) )
     => ? [C] : m2_subset_1(C,A,B) ) ).

fof(redefinition_m2_subset_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & m1_subset_1(B,k1_zfmisc_1(A)) )
     => ! [C] :
          ( m2_subset_1(C,A,B)
        <=> m1_subset_1(C,B) ) ) ).

fof(symmetry_r1_subset_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B) )
     => ( r1_subset_1(A,B)
       => r1_subset_1(B,A) ) ) ).

fof(irreflexivity_r1_subset_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B) )
     => ~ r1_subset_1(A,A) ) ).

fof(redefinition_r1_subset_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B) )
     => ( r1_subset_1(A,B)
      <=> r1_xboole_0(A,B) ) ) ).

fof(symmetry_r2_subset_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B) )
     => ( r2_subset_1(A,B)
       => r2_subset_1(B,A) ) ) ).

fof(irreflexivity_r2_subset_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B) )
     => ~ r2_subset_1(A,A) ) ).

fof(redefinition_r2_subset_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B) )
     => ( r2_subset_1(A,B)
      <=> r1_xboole_0(A,B) ) ) ).

fof(dt_k1_subset_1,axiom,
    ! [A] :
      ( v1_xboole_0(k1_subset_1(A))
      & m1_subset_1(k1_subset_1(A),k1_zfmisc_1(A)) ) ).

fof(dt_k2_subset_1,axiom,
    ! [A] : m1_subset_1(k2_subset_1(A),k1_zfmisc_1(A)) ).

fof(dt_k3_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => m1_subset_1(k3_subset_1(A,B),k1_zfmisc_1(A)) ) ).

fof(involutiveness_k3_subset_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => k3_subset_1(A,k3_subset_1(A,B)) = B ) ).

fof(dt_k4_subset_1,axiom,
    ! [A,B,C] :
      ( ( m1_subset_1(B,k1_zfmisc_1(A))
        & m1_subset_1(C,k1_zfmisc_1(A)) )
     => m1_subset_1(k4_subset_1(A,B,C),k1_zfmisc_1(A)) ) ).

fof(commutativity_k4_subset_1,axiom,
    ! [A,B,C] :
      ( ( m1_subset_1(B,k1_zfmisc_1(A))
        & m1_subset_1(C,k1_zfmisc_1(A)) )
     => k4_subset_1(A,B,C) = k4_subset_1(A,C,B) ) ).

fof(idempotence_k4_subset_1,axiom,
    ! [A,B,C] :
      ( ( m1_subset_1(B,k1_zfmisc_1(A))
        & m1_subset_1(C,k1_zfmisc_1(A)) )
     => k4_subset_1(A,B,B) = B ) ).

fof(redefinition_k4_subset_1,axiom,
    ! [A,B,C] :
      ( ( m1_subset_1(B,k1_zfmisc_1(A))
        & m1_subset_1(C,k1_zfmisc_1(A)) )
     => k4_subset_1(A,B,C) = k2_xboole_0(B,C) ) ).

fof(dt_k5_subset_1,axiom,
    ! [A,B,C] :
      ( ( m1_subset_1(B,k1_zfmisc_1(A))
        & m1_subset_1(C,k1_zfmisc_1(A)) )
     => m1_subset_1(k5_subset_1(A,B,C),k1_zfmisc_1(A)) ) ).

fof(commutativity_k5_subset_1,axiom,
    ! [A,B,C] :
      ( ( m1_subset_1(B,k1_zfmisc_1(A))
        & m1_subset_1(C,k1_zfmisc_1(A)) )
     => k5_subset_1(A,B,C) = k5_subset_1(A,C,B) ) ).

fof(idempotence_k5_subset_1,axiom,
    ! [A,B,C] :
      ( ( m1_subset_1(B,k1_zfmisc_1(A))
        & m1_subset_1(C,k1_zfmisc_1(A)) )
     => k5_subset_1(A,B,B) = B ) ).

fof(redefinition_k5_subset_1,axiom,
    ! [A,B,C] :
      ( ( m1_subset_1(B,k1_zfmisc_1(A))
        & m1_subset_1(C,k1_zfmisc_1(A)) )
     => k5_subset_1(A,B,C) = k3_xboole_0(B,C) ) ).

fof(dt_k6_subset_1,axiom,
    ! [A,B,C] :
      ( ( m1_subset_1(B,k1_zfmisc_1(A))
        & m1_subset_1(C,k1_zfmisc_1(A)) )
     => m1_subset_1(k6_subset_1(A,B,C),k1_zfmisc_1(A)) ) ).

fof(redefinition_k6_subset_1,axiom,
    ! [A,B,C] :
      ( ( m1_subset_1(B,k1_zfmisc_1(A))
        & m1_subset_1(C,k1_zfmisc_1(A)) )
     => k6_subset_1(A,B,C) = k4_xboole_0(B,C) ) ).

fof(dt_k7_subset_1,axiom,
    ! [A,B,C] :
      ( ( m1_subset_1(B,k1_zfmisc_1(A))
        & m1_subset_1(C,k1_zfmisc_1(A)) )
     => m1_subset_1(k7_subset_1(A,B,C),k1_zfmisc_1(A)) ) ).

fof(commutativity_k7_subset_1,axiom,
    ! [A,B,C] :
      ( ( m1_subset_1(B,k1_zfmisc_1(A))
        & m1_subset_1(C,k1_zfmisc_1(A)) )
     => k7_subset_1(A,B,C) = k7_subset_1(A,C,B) ) ).

fof(redefinition_k7_subset_1,axiom,
    ! [A,B,C] :
      ( ( m1_subset_1(B,k1_zfmisc_1(A))
        & m1_subset_1(C,k1_zfmisc_1(A)) )
     => k7_subset_1(A,B,C) = k5_xboole_0(B,C) ) ).

fof(dt_k8_subset_1,axiom,
    ! [A] : m1_subset_1(k8_subset_1(A),A) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(t1_subset,axiom,
    ! [A,B] :
      ( r2_hidden(A,B)
     => m1_subset_1(A,B) ) ).

fof(t2_subset,axiom,
    ! [A,B] :
      ( m1_subset_1(A,B)
     => ( v1_xboole_0(B)
        | r2_hidden(A,B) ) ) ).

fof(t3_subset,axiom,
    ! [A,B] :
      ( m1_subset_1(A,k1_zfmisc_1(B))
    <=> r1_tarski(A,B) ) ).

fof(t4_subset,axiom,
    ! [A,B,C] :
      ( ( r2_hidden(A,B)
        & m1_subset_1(B,k1_zfmisc_1(C)) )
     => m1_subset_1(A,C) ) ).

fof(t5_subset,axiom,
    ! [A,B,C] :
      ~ ( r2_hidden(A,B)
        & m1_subset_1(B,k1_zfmisc_1(C))
        & v1_xboole_0(C) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(rc1_relat_1,axiom,
    ? [A] :
      ( v1_xboole_0(A)
      & v1_relat_1(A) ) ).

fof(fc1_relat_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_relat_1(B) )
     => v1_relat_1(k3_xboole_0(A,B)) ) ).

fof(fc2_relat_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_relat_1(B) )
     => v1_relat_1(k2_xboole_0(A,B)) ) ).

fof(fc3_relat_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_relat_1(B) )
     => v1_relat_1(k4_xboole_0(A,B)) ) ).

fof(cc1_relat_1,axiom,
    ! [A] :
      ( v1_xboole_0(A)
     => v1_relat_1(A) ) ).

fof(fc4_relat_1,axiom,
    ( v1_xboole_0(k1_xboole_0)
    & v1_relat_1(k1_xboole_0) ) ).

fof(rc2_relat_1,axiom,
    ? [A] :
      ( ~ v1_xboole_0(A)
      & v1_relat_1(A) ) ).

fof(fc5_relat_1,axiom,
    ! [A] :
      ( ( ~ v1_xboole_0(A)
        & v1_relat_1(A) )
     => ~ v1_xboole_0(k1_relat_1(A)) ) ).

fof(fc6_relat_1,axiom,
    ! [A] :
      ( ( ~ v1_xboole_0(A)
        & v1_relat_1(A) )
     => ~ v1_xboole_0(k2_relat_1(A)) ) ).

fof(fc7_relat_1,axiom,
    ! [A] :
      ( v1_xboole_0(A)
     => ( v1_xboole_0(k1_relat_1(A))
        & v1_relat_1(k1_relat_1(A)) ) ) ).

fof(fc8_relat_1,axiom,
    ! [A] :
      ( v1_xboole_0(A)
     => ( v1_xboole_0(k2_relat_1(A))
        & v1_relat_1(k2_relat_1(A)) ) ) ).

fof(fc9_relat_1,axiom,
    ! [A,B] :
      ( ( v1_xboole_0(A)
        & v1_relat_1(B) )
     => ( v1_xboole_0(k5_relat_1(A,B))
        & v1_relat_1(k5_relat_1(A,B)) ) ) ).

fof(fc10_relat_1,axiom,
    ! [A,B] :
      ( ( v1_xboole_0(A)
        & v1_relat_1(B) )
     => ( v1_xboole_0(k5_relat_1(B,A))
        & v1_relat_1(k5_relat_1(B,A)) ) ) ).

fof(fc11_relat_1,axiom,
    ! [A] :
      ( v1_xboole_0(A)
     => ( v1_xboole_0(k4_relat_1(A))
        & v1_relat_1(k4_relat_1(A)) ) ) ).

fof(fc12_relat_1,axiom,
    ( v1_xboole_0(k1_xboole_0)
    & v1_relat_1(k1_xboole_0)
    & v3_relat_1(k1_xboole_0) ) ).

fof(rc3_relat_1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v3_relat_1(A) ) ).

fof(fc13_relat_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v3_relat_1(A) )
     => ( v1_relat_1(k7_relat_1(A,B))
        & v3_relat_1(k7_relat_1(A,B)) ) ) ).

fof(d1_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
    <=> ! [B] :
          ~ ( r2_hidden(B,A)
            & ! [C,D] : B != k4_tarski(C,D) ) ) ).

fof(t1_relat_1,axiom,
    $true ).

fof(t2_relat_1,axiom,
    $true ).

fof(t3_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r1_tarski(A,B)
       => v1_relat_1(A) ) ) ).

fof(t4_relat_1,axiom,
    ! [A,B] : v1_relat_1(k1_tarski(k4_tarski(A,B))) ).

fof(t5_relat_1,axiom,
    ! [A,B,C,D] : v1_relat_1(k2_tarski(k4_tarski(A,B),k4_tarski(C,D))) ).

fof(t6_relat_1,axiom,
    ! [A,B] : v1_relat_1(k2_zfmisc_1(A,B)) ).

fof(d2_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( A = B
          <=> ! [C,D] :
                ( r2_hidden(k4_tarski(C,D),A)
              <=> r2_hidden(k4_tarski(C,D),B) ) ) ) ) ).

fof(d3_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( r1_tarski(A,B)
          <=> ! [C,D] :
                ( r2_hidden(k4_tarski(C,D),A)
               => r2_hidden(k4_tarski(C,D),B) ) ) ) ) ).

fof(t7_relat_1,axiom,
    $true ).

fof(t8_relat_1,axiom,
    $true ).

fof(t9_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => v1_relat_1(k3_xboole_0(A,B)) ) ).

fof(t10_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => v1_relat_1(k4_xboole_0(B,A)) ) ).

fof(d4_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( B = k1_relat_1(A)
        <=> ! [C] :
              ( r2_hidden(C,B)
            <=> ? [D] : r2_hidden(k4_tarski(C,D),A) ) ) ) ).

fof(t11_relat_1,axiom,
    $true ).

fof(t12_relat_1,axiom,
    $true ).

fof(t13_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => k1_relat_1(k2_xboole_0(A,B)) = k2_xboole_0(k1_relat_1(A),k1_relat_1(B)) ) ) ).

fof(t14_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => r1_tarski(k1_relat_1(k3_xboole_0(A,B)),k3_xboole_0(k1_relat_1(A),k1_relat_1(B))) ) ) ).

fof(t15_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => r1_tarski(k4_xboole_0(k1_relat_1(A),k1_relat_1(B)),k1_relat_1(k4_xboole_0(A,B))) ) ) ).

fof(d5_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( B = k2_relat_1(A)
        <=> ! [C] :
              ( r2_hidden(C,B)
            <=> ? [D] : r2_hidden(k4_tarski(D,C),A) ) ) ) ).

fof(t16_relat_1,axiom,
    $true ).

fof(t17_relat_1,axiom,
    $true ).

fof(t18_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ~ ( r2_hidden(A,k1_relat_1(B))
          & ! [C] : ~ r2_hidden(C,k2_relat_1(B)) ) ) ).

fof(t19_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ~ ( r2_hidden(A,k2_relat_1(B))
          & ! [C] : ~ r2_hidden(C,k1_relat_1(B)) ) ) ).

fof(t20_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( r2_hidden(k4_tarski(A,B),C)
       => ( r2_hidden(A,k1_relat_1(C))
          & r2_hidden(B,k2_relat_1(C)) ) ) ) ).

fof(t21_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => r1_tarski(A,k2_zfmisc_1(k1_relat_1(A),k2_relat_1(A))) ) ).

fof(t22_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => k3_xboole_0(A,k2_zfmisc_1(k1_relat_1(A),k2_relat_1(A))) = A ) ).

fof(t23_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( C = k1_tarski(k4_tarski(A,B))
       => ( k1_relat_1(C) = k1_tarski(A)
          & k2_relat_1(C) = k1_tarski(B) ) ) ) ).

fof(t24_relat_1,axiom,
    ! [A,B,C,D,E] :
      ( v1_relat_1(E)
     => ( E = k2_tarski(k4_tarski(A,B),k4_tarski(C,D))
       => ( k1_relat_1(E) = k2_tarski(A,C)
          & k2_relat_1(E) = k2_tarski(B,D) ) ) ) ).

fof(t25_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( r1_tarski(A,B)
           => ( r1_tarski(k1_relat_1(A),k1_relat_1(B))
              & r1_tarski(k2_relat_1(A),k2_relat_1(B)) ) ) ) ) ).

fof(t26_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => k2_relat_1(k2_xboole_0(A,B)) = k2_xboole_0(k2_relat_1(A),k2_relat_1(B)) ) ) ).

fof(t27_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => r1_tarski(k2_relat_1(k3_xboole_0(A,B)),k3_xboole_0(k2_relat_1(A),k2_relat_1(B))) ) ) ).

fof(t28_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => r1_tarski(k4_xboole_0(k2_relat_1(A),k2_relat_1(B)),k2_relat_1(k4_xboole_0(A,B))) ) ) ).

fof(d6_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => k3_relat_1(A) = k2_xboole_0(k1_relat_1(A),k2_relat_1(A)) ) ).

fof(t29_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( r1_tarski(k1_relat_1(A),k3_relat_1(A))
        & r1_tarski(k2_relat_1(A),k3_relat_1(A)) ) ) ).

fof(t30_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( r2_hidden(k4_tarski(A,B),C)
       => ( r2_hidden(A,k3_relat_1(C))
          & r2_hidden(B,k3_relat_1(C)) ) ) ) ).

fof(t31_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( r1_tarski(A,B)
           => r1_tarski(k3_relat_1(A),k3_relat_1(B)) ) ) ) ).

fof(t32_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( C = k1_tarski(k4_tarski(A,B))
       => k3_relat_1(C) = k2_tarski(A,B) ) ) ).

fof(t33_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => k3_relat_1(k2_xboole_0(A,B)) = k2_xboole_0(k3_relat_1(A),k3_relat_1(B)) ) ) ).

fof(t34_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => r1_tarski(k3_relat_1(k3_xboole_0(A,B)),k3_xboole_0(k3_relat_1(A),k3_relat_1(B))) ) ) ).

fof(d7_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( B = k4_relat_1(A)
          <=> ! [C,D] :
                ( r2_hidden(k4_tarski(C,D),B)
              <=> r2_hidden(k4_tarski(D,C),A) ) ) ) ) ).

fof(t35_relat_1,axiom,
    $true ).

fof(t36_relat_1,axiom,
    $true ).

fof(t37_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( k2_relat_1(A) = k1_relat_1(k4_relat_1(A))
        & k1_relat_1(A) = k2_relat_1(k4_relat_1(A)) ) ) ).

fof(t38_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => k3_relat_1(A) = k3_relat_1(k4_relat_1(A)) ) ).

fof(t39_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => k4_relat_1(k3_xboole_0(A,B)) = k3_xboole_0(k4_relat_1(A),k4_relat_1(B)) ) ) ).

fof(t40_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => k4_relat_1(k2_xboole_0(A,B)) = k2_xboole_0(k4_relat_1(A),k4_relat_1(B)) ) ) ).

fof(t41_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => k4_relat_1(k4_xboole_0(A,B)) = k4_xboole_0(k4_relat_1(A),k4_relat_1(B)) ) ) ).

fof(d8_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ! [C] :
              ( v1_relat_1(C)
             => ( C = k5_relat_1(A,B)
              <=> ! [D,E] :
                    ( r2_hidden(k4_tarski(D,E),C)
                  <=> ? [F] :
                        ( r2_hidden(k4_tarski(D,F),A)
                        & r2_hidden(k4_tarski(F,E),B) ) ) ) ) ) ) ).

fof(t42_relat_1,axiom,
    $true ).

fof(t43_relat_1,axiom,
    $true ).

fof(t44_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => r1_tarski(k1_relat_1(k5_relat_1(A,B)),k1_relat_1(A)) ) ) ).

fof(t45_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => r1_tarski(k2_relat_1(k5_relat_1(A,B)),k2_relat_1(B)) ) ) ).

fof(t46_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( r1_tarski(k2_relat_1(A),k1_relat_1(B))
           => k1_relat_1(k5_relat_1(A,B)) = k1_relat_1(A) ) ) ) ).

fof(t47_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( r1_tarski(k1_relat_1(A),k2_relat_1(B))
           => k2_relat_1(k5_relat_1(B,A)) = k2_relat_1(A) ) ) ) ).

fof(t48_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ! [C] :
              ( v1_relat_1(C)
             => ( r1_tarski(A,B)
               => r1_tarski(k5_relat_1(C,A),k5_relat_1(C,B)) ) ) ) ) ).

fof(t49_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ! [C] :
              ( v1_relat_1(C)
             => ( r1_tarski(A,B)
               => r1_tarski(k5_relat_1(A,C),k5_relat_1(B,C)) ) ) ) ) ).

fof(t50_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ! [C] :
              ( v1_relat_1(C)
             => ! [D] :
                  ( v1_relat_1(D)
                 => ( ( r1_tarski(A,B)
                      & r1_tarski(C,D) )
                   => r1_tarski(k5_relat_1(A,C),k5_relat_1(B,D)) ) ) ) ) ) ).

fof(t51_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ! [C] :
              ( v1_relat_1(C)
             => k5_relat_1(A,k2_xboole_0(B,C)) = k2_xboole_0(k5_relat_1(A,B),k5_relat_1(A,C)) ) ) ) ).

fof(t52_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ! [C] :
              ( v1_relat_1(C)
             => r1_tarski(k5_relat_1(A,k3_xboole_0(B,C)),k3_xboole_0(k5_relat_1(A,B),k5_relat_1(A,C))) ) ) ) ).

fof(t53_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ! [C] :
              ( v1_relat_1(C)
             => r1_tarski(k4_xboole_0(k5_relat_1(A,B),k5_relat_1(A,C)),k5_relat_1(A,k4_xboole_0(B,C))) ) ) ) ).

fof(t54_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => k4_relat_1(k5_relat_1(A,B)) = k5_relat_1(k4_relat_1(B),k4_relat_1(A)) ) ) ).

fof(t55_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ! [C] :
              ( v1_relat_1(C)
             => k5_relat_1(k5_relat_1(A,B),C) = k5_relat_1(A,k5_relat_1(B,C)) ) ) ) ).

fof(t56_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( ! [B,C] : ~ r2_hidden(k4_tarski(B,C),A)
       => A = k1_xboole_0 ) ) ).

fof(t57_relat_1,axiom,
    $true ).

fof(t58_relat_1,axiom,
    $true ).

fof(t59_relat_1,axiom,
    $true ).

fof(t60_relat_1,axiom,
    ( k1_relat_1(k1_xboole_0) = k1_xboole_0
    & k2_relat_1(k1_xboole_0) = k1_xboole_0 ) ).

fof(t61_relat_1,axiom,
    $true ).

fof(t62_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( k5_relat_1(k1_xboole_0,A) = k1_xboole_0
        & k5_relat_1(A,k1_xboole_0) = k1_xboole_0 ) ) ).

fof(t63_relat_1,axiom,
    $true ).

fof(t64_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( ( k1_relat_1(A) = k1_xboole_0
          | k2_relat_1(A) = k1_xboole_0 )
       => A = k1_xboole_0 ) ) ).

fof(t65_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( k1_relat_1(A) = k1_xboole_0
      <=> k2_relat_1(A) = k1_xboole_0 ) ) ).

fof(t66_relat_1,axiom,
    k4_relat_1(k1_xboole_0) = k1_xboole_0 ).

fof(t67_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( r1_xboole_0(k2_relat_1(A),k1_relat_1(B))
           => k5_relat_1(A,B) = k1_xboole_0 ) ) ) ).

fof(d9_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v2_relat_1(A)
      <=> ~ r2_hidden(k1_xboole_0,k2_relat_1(A)) ) ) ).

fof(d10_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( B = k6_relat_1(A)
      <=> ! [C,D] :
            ( r2_hidden(k4_tarski(C,D),B)
          <=> ( r2_hidden(C,A)
              & C = D ) ) ) ) ).

fof(t68_relat_1,axiom,
    $true ).

fof(t69_relat_1,axiom,
    $true ).

fof(t70_relat_1,axiom,
    $true ).

fof(t71_relat_1,axiom,
    ! [A] :
      ( k1_relat_1(k6_relat_1(A)) = A
      & k2_relat_1(k6_relat_1(A)) = A ) ).

fof(t72_relat_1,axiom,
    ! [A] : k4_relat_1(k6_relat_1(A)) = k6_relat_1(A) ).

fof(t73_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( ! [C] :
            ( r2_hidden(C,A)
           => r2_hidden(k4_tarski(C,C),B) )
       => r1_tarski(k6_relat_1(A),B) ) ) ).

fof(t74_relat_1,axiom,
    ! [A,B,C,D] :
      ( v1_relat_1(D)
     => ( r2_hidden(k4_tarski(A,B),k5_relat_1(k6_relat_1(C),D))
      <=> ( r2_hidden(A,C)
          & r2_hidden(k4_tarski(A,B),D) ) ) ) ).

fof(t75_relat_1,axiom,
    ! [A,B,C,D] :
      ( v1_relat_1(D)
     => ( r2_hidden(k4_tarski(A,B),k5_relat_1(D,k6_relat_1(C)))
      <=> ( r2_hidden(B,C)
          & r2_hidden(k4_tarski(A,B),D) ) ) ) ).

fof(t76_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r1_tarski(k5_relat_1(B,k6_relat_1(A)),B)
        & r1_tarski(k5_relat_1(k6_relat_1(A),B),B) ) ) ).

fof(t77_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r1_tarski(k1_relat_1(B),A)
       => k5_relat_1(k6_relat_1(A),B) = B ) ) ).

fof(t78_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => k5_relat_1(k6_relat_1(k1_relat_1(A)),A) = A ) ).

fof(t79_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r1_tarski(k2_relat_1(B),A)
       => k5_relat_1(B,k6_relat_1(A)) = B ) ) ).

fof(t80_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => k5_relat_1(A,k6_relat_1(k2_relat_1(A))) = A ) ).

fof(t81_relat_1,axiom,
    k6_relat_1(k1_xboole_0) = k1_xboole_0 ).

fof(t82_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ! [C] :
          ( v1_relat_1(C)
         => ! [D] :
              ( v1_relat_1(D)
             => ( ( k1_relat_1(B) = A
                  & r1_tarski(k2_relat_1(C),A)
                  & k5_relat_1(C,B) = k6_relat_1(k1_relat_1(D))
                  & k5_relat_1(B,D) = k6_relat_1(A) )
               => D = C ) ) ) ) ).

fof(d11_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B,C] :
          ( v1_relat_1(C)
         => ( C = k7_relat_1(A,B)
          <=> ! [D,E] :
                ( r2_hidden(k4_tarski(D,E),C)
              <=> ( r2_hidden(D,B)
                  & r2_hidden(k4_tarski(D,E),A) ) ) ) ) ) ).

fof(t83_relat_1,axiom,
    $true ).

fof(t84_relat_1,axiom,
    $true ).

fof(t85_relat_1,axiom,
    $true ).

fof(t86_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( r2_hidden(A,k1_relat_1(k7_relat_1(C,B)))
      <=> ( r2_hidden(A,B)
          & r2_hidden(A,k1_relat_1(C)) ) ) ) ).

fof(t87_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => r1_tarski(k1_relat_1(k7_relat_1(B,A)),A) ) ).

fof(t88_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => r1_tarski(k7_relat_1(B,A),B) ) ).

fof(t89_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => r1_tarski(k1_relat_1(k7_relat_1(B,A)),k1_relat_1(B)) ) ).

fof(t90_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => k1_relat_1(k7_relat_1(B,A)) = k3_xboole_0(k1_relat_1(B),A) ) ).

fof(t91_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r1_tarski(A,k1_relat_1(B))
       => k1_relat_1(k7_relat_1(B,A)) = A ) ) ).

fof(t92_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ! [C] :
          ( v1_relat_1(C)
         => r1_tarski(k5_relat_1(k7_relat_1(B,A),C),k5_relat_1(B,C)) ) ) ).

fof(t93_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ! [C] :
          ( v1_relat_1(C)
         => r1_tarski(k5_relat_1(B,k7_relat_1(C,A)),k5_relat_1(B,C)) ) ) ).

fof(t94_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => k7_relat_1(B,A) = k5_relat_1(k6_relat_1(A),B) ) ).

fof(t95_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( k7_relat_1(B,A) = k1_xboole_0
      <=> r1_xboole_0(k1_relat_1(B),A) ) ) ).

fof(t96_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => k7_relat_1(B,A) = k3_xboole_0(B,k2_zfmisc_1(A,k2_relat_1(B))) ) ).

fof(t97_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r1_tarski(k1_relat_1(B),A)
       => k7_relat_1(B,A) = B ) ) ).

fof(t98_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => k7_relat_1(A,k1_relat_1(A)) = A ) ).

fof(t99_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => r1_tarski(k2_relat_1(k7_relat_1(B,A)),k2_relat_1(B)) ) ).

fof(t100_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => k7_relat_1(k7_relat_1(C,A),B) = k7_relat_1(C,k3_xboole_0(A,B)) ) ).

fof(t101_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => k7_relat_1(k7_relat_1(B,A),A) = k7_relat_1(B,A) ) ).

fof(t102_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( r1_tarski(A,B)
       => k7_relat_1(k7_relat_1(C,A),B) = k7_relat_1(C,A) ) ) ).

fof(t103_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( r1_tarski(A,B)
       => k7_relat_1(k7_relat_1(C,B),A) = k7_relat_1(C,A) ) ) ).

fof(t104_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( r1_tarski(A,B)
       => r1_tarski(k7_relat_1(C,A),k7_relat_1(C,B)) ) ) ).

fof(t105_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ! [C] :
          ( v1_relat_1(C)
         => ( r1_tarski(B,C)
           => r1_tarski(k7_relat_1(B,A),k7_relat_1(C,A)) ) ) ) ).

fof(t106_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ! [D] :
          ( v1_relat_1(D)
         => ( ( r1_tarski(C,D)
              & r1_tarski(A,B) )
           => r1_tarski(k7_relat_1(C,A),k7_relat_1(D,B)) ) ) ) ).

fof(t107_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => k7_relat_1(C,k2_xboole_0(A,B)) = k2_xboole_0(k7_relat_1(C,A),k7_relat_1(C,B)) ) ).

fof(t108_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => k7_relat_1(C,k3_xboole_0(A,B)) = k3_xboole_0(k7_relat_1(C,A),k7_relat_1(C,B)) ) ).

fof(t109_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => k7_relat_1(C,k4_xboole_0(A,B)) = k4_xboole_0(k7_relat_1(C,A),k7_relat_1(C,B)) ) ).

fof(t110_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => k7_relat_1(A,k1_xboole_0) = k1_xboole_0 ) ).

fof(t111_relat_1,axiom,
    ! [A] : k7_relat_1(k1_xboole_0,A) = k1_xboole_0 ).

fof(t112_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ! [C] :
          ( v1_relat_1(C)
         => k7_relat_1(k5_relat_1(B,C),A) = k5_relat_1(k7_relat_1(B,A),C) ) ) ).

fof(d12_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ! [C] :
          ( v1_relat_1(C)
         => ( C = k8_relat_1(A,B)
          <=> ! [D,E] :
                ( r2_hidden(k4_tarski(D,E),C)
              <=> ( r2_hidden(E,A)
                  & r2_hidden(k4_tarski(D,E),B) ) ) ) ) ) ).

fof(t113_relat_1,axiom,
    $true ).

fof(t114_relat_1,axiom,
    $true ).

fof(t115_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( r2_hidden(A,k2_relat_1(k8_relat_1(B,C)))
      <=> ( r2_hidden(A,B)
          & r2_hidden(A,k2_relat_1(C)) ) ) ) ).

fof(t116_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => r1_tarski(k2_relat_1(k8_relat_1(A,B)),A) ) ).

fof(t117_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => r1_tarski(k8_relat_1(A,B),B) ) ).

fof(t118_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => r1_tarski(k2_relat_1(k8_relat_1(A,B)),k2_relat_1(B)) ) ).

fof(t119_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => k2_relat_1(k8_relat_1(A,B)) = k3_xboole_0(k2_relat_1(B),A) ) ).

fof(t120_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r1_tarski(A,k2_relat_1(B))
       => k2_relat_1(k8_relat_1(A,B)) = A ) ) ).

fof(t121_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ! [C] :
          ( v1_relat_1(C)
         => r1_tarski(k5_relat_1(k8_relat_1(A,B),C),k5_relat_1(B,C)) ) ) ).

fof(t122_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ! [C] :
          ( v1_relat_1(C)
         => r1_tarski(k5_relat_1(B,k8_relat_1(A,C)),k5_relat_1(B,C)) ) ) ).

fof(t123_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => k8_relat_1(A,B) = k5_relat_1(B,k6_relat_1(A)) ) ).

fof(t124_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => k8_relat_1(A,B) = k3_xboole_0(B,k2_zfmisc_1(k1_relat_1(B),A)) ) ).

fof(t125_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r1_tarski(k2_relat_1(B),A)
       => k8_relat_1(A,B) = B ) ) ).

fof(t126_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => k8_relat_1(k2_relat_1(A),A) = A ) ).

fof(t127_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => k8_relat_1(A,k8_relat_1(B,C)) = k8_relat_1(k3_xboole_0(A,B),C) ) ).

fof(t128_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => k8_relat_1(A,k8_relat_1(A,B)) = k8_relat_1(A,B) ) ).

fof(t129_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( r1_tarski(A,B)
       => k8_relat_1(B,k8_relat_1(A,C)) = k8_relat_1(A,C) ) ) ).

fof(t130_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( r1_tarski(A,B)
       => k8_relat_1(A,k8_relat_1(B,C)) = k8_relat_1(A,C) ) ) ).

fof(t131_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( r1_tarski(A,B)
       => r1_tarski(k8_relat_1(A,C),k8_relat_1(B,C)) ) ) ).

fof(t132_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ! [C] :
          ( v1_relat_1(C)
         => ( r1_tarski(B,C)
           => r1_tarski(k8_relat_1(A,B),k8_relat_1(A,C)) ) ) ) ).

fof(t133_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ! [D] :
          ( v1_relat_1(D)
         => ( ( r1_tarski(C,D)
              & r1_tarski(A,B) )
           => r1_tarski(k8_relat_1(A,C),k8_relat_1(B,D)) ) ) ) ).

fof(t134_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => k8_relat_1(k2_xboole_0(A,B),C) = k2_xboole_0(k8_relat_1(A,C),k8_relat_1(B,C)) ) ).

fof(t135_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => k8_relat_1(k3_xboole_0(A,B),C) = k3_xboole_0(k8_relat_1(A,C),k8_relat_1(B,C)) ) ).

fof(t136_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => k8_relat_1(k4_xboole_0(A,B),C) = k4_xboole_0(k8_relat_1(A,C),k8_relat_1(B,C)) ) ).

fof(t137_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => k8_relat_1(k1_xboole_0,A) = k1_xboole_0 ) ).

fof(t138_relat_1,axiom,
    ! [A] : k8_relat_1(A,k1_xboole_0) = k1_xboole_0 ).

fof(t139_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ! [C] :
          ( v1_relat_1(C)
         => k8_relat_1(A,k5_relat_1(B,C)) = k5_relat_1(B,k8_relat_1(A,C)) ) ) ).

fof(t140_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => k7_relat_1(k8_relat_1(A,C),B) = k8_relat_1(A,k7_relat_1(C,B)) ) ).

fof(d13_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B,C] :
          ( C = k9_relat_1(A,B)
        <=> ! [D] :
              ( r2_hidden(D,C)
            <=> ? [E] :
                  ( r2_hidden(k4_tarski(E,D),A)
                  & r2_hidden(E,B) ) ) ) ) ).

fof(t141_relat_1,axiom,
    $true ).

fof(t142_relat_1,axiom,
    $true ).

fof(t143_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( r2_hidden(A,k9_relat_1(C,B))
      <=> ? [D] :
            ( r2_hidden(D,k1_relat_1(C))
            & r2_hidden(k4_tarski(D,A),C)
            & r2_hidden(D,B) ) ) ) ).

fof(t144_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => r1_tarski(k9_relat_1(B,A),k2_relat_1(B)) ) ).

fof(t145_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => k9_relat_1(B,A) = k9_relat_1(B,k3_xboole_0(k1_relat_1(B),A)) ) ).

fof(t146_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => k9_relat_1(A,k1_relat_1(A)) = k2_relat_1(A) ) ).

fof(t147_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => r1_tarski(k9_relat_1(B,A),k9_relat_1(B,k1_relat_1(B))) ) ).

fof(t148_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => k2_relat_1(k7_relat_1(B,A)) = k9_relat_1(B,A) ) ).

fof(t149_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => k9_relat_1(A,k1_xboole_0) = k1_xboole_0 ) ).

fof(t150_relat_1,axiom,
    ! [A] : k9_relat_1(k1_xboole_0,A) = k1_xboole_0 ).

fof(t151_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( k9_relat_1(B,A) = k1_xboole_0
      <=> r1_xboole_0(k1_relat_1(B),A) ) ) ).

fof(t152_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ~ ( A != k1_xboole_0
          & r1_tarski(A,k1_relat_1(B))
          & k9_relat_1(B,A) = k1_xboole_0 ) ) ).

fof(t153_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => k9_relat_1(C,k2_xboole_0(A,B)) = k2_xboole_0(k9_relat_1(C,A),k9_relat_1(C,B)) ) ).

fof(t154_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => r1_tarski(k9_relat_1(C,k3_xboole_0(A,B)),k3_xboole_0(k9_relat_1(C,A),k9_relat_1(C,B))) ) ).

fof(t155_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => r1_tarski(k4_xboole_0(k9_relat_1(C,A),k9_relat_1(C,B)),k9_relat_1(C,k4_xboole_0(A,B))) ) ).

fof(t156_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( r1_tarski(A,B)
       => r1_tarski(k9_relat_1(C,A),k9_relat_1(C,B)) ) ) ).

fof(t157_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ! [C] :
          ( v1_relat_1(C)
         => ( r1_tarski(B,C)
           => r1_tarski(k9_relat_1(B,A),k9_relat_1(C,A)) ) ) ) ).

fof(t158_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ! [D] :
          ( v1_relat_1(D)
         => ( ( r1_tarski(C,D)
              & r1_tarski(A,B) )
           => r1_tarski(k9_relat_1(C,A),k9_relat_1(D,B)) ) ) ) ).

fof(t159_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ! [C] :
          ( v1_relat_1(C)
         => k9_relat_1(k5_relat_1(B,C),A) = k9_relat_1(C,k9_relat_1(B,A)) ) ) ).

fof(t160_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => k2_relat_1(k5_relat_1(A,B)) = k9_relat_1(B,k2_relat_1(A)) ) ) ).

fof(t161_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => r1_tarski(k9_relat_1(k7_relat_1(C,A),B),k9_relat_1(C,B)) ) ).

fof(t162_relat_1,axiom,
    $true ).

fof(t163_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => r1_tarski(k3_xboole_0(k1_relat_1(B),A),k9_relat_1(k4_relat_1(B),k9_relat_1(B,A))) ) ).

fof(d14_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B,C] :
          ( C = k10_relat_1(A,B)
        <=> ! [D] :
              ( r2_hidden(D,C)
            <=> ? [E] :
                  ( r2_hidden(k4_tarski(D,E),A)
                  & r2_hidden(E,B) ) ) ) ) ).

fof(t164_relat_1,axiom,
    $true ).

fof(t165_relat_1,axiom,
    $true ).

fof(t166_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( r2_hidden(A,k10_relat_1(C,B))
      <=> ? [D] :
            ( r2_hidden(D,k2_relat_1(C))
            & r2_hidden(k4_tarski(A,D),C)
            & r2_hidden(D,B) ) ) ) ).

fof(t167_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => r1_tarski(k10_relat_1(B,A),k1_relat_1(B)) ) ).

fof(t168_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => k10_relat_1(B,A) = k10_relat_1(B,k3_xboole_0(k2_relat_1(B),A)) ) ).

fof(t169_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => k10_relat_1(A,k2_relat_1(A)) = k1_relat_1(A) ) ).

fof(t170_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => r1_tarski(k10_relat_1(B,A),k10_relat_1(B,k2_relat_1(B))) ) ).

fof(t171_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => k10_relat_1(A,k1_xboole_0) = k1_xboole_0 ) ).

fof(t172_relat_1,axiom,
    ! [A] : k10_relat_1(k1_xboole_0,A) = k1_xboole_0 ).

fof(t173_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( k10_relat_1(B,A) = k1_xboole_0
      <=> r1_xboole_0(k2_relat_1(B),A) ) ) ).

fof(t174_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ~ ( A != k1_xboole_0
          & r1_tarski(A,k2_relat_1(B))
          & k10_relat_1(B,A) = k1_xboole_0 ) ) ).

fof(t175_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => k10_relat_1(C,k2_xboole_0(A,B)) = k2_xboole_0(k10_relat_1(C,A),k10_relat_1(C,B)) ) ).

fof(t176_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => r1_tarski(k10_relat_1(C,k3_xboole_0(A,B)),k3_xboole_0(k10_relat_1(C,A),k10_relat_1(C,B))) ) ).

fof(t177_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => r1_tarski(k4_xboole_0(k10_relat_1(C,A),k10_relat_1(C,B)),k10_relat_1(C,k4_xboole_0(A,B))) ) ).

fof(t178_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( r1_tarski(A,B)
       => r1_tarski(k10_relat_1(C,A),k10_relat_1(C,B)) ) ) ).

fof(t179_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ! [C] :
          ( v1_relat_1(C)
         => ( r1_tarski(B,C)
           => r1_tarski(k10_relat_1(B,A),k10_relat_1(C,A)) ) ) ) ).

fof(t180_relat_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ! [D] :
          ( v1_relat_1(D)
         => ( ( r1_tarski(C,D)
              & r1_tarski(A,B) )
           => r1_tarski(k10_relat_1(C,A),k10_relat_1(D,B)) ) ) ) ).

fof(t181_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ! [C] :
          ( v1_relat_1(C)
         => k10_relat_1(k5_relat_1(B,C),A) = k10_relat_1(B,k10_relat_1(C,A)) ) ) ).

fof(t182_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => k1_relat_1(k5_relat_1(A,B)) = k10_relat_1(A,k1_relat_1(B)) ) ) ).

fof(t183_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => r1_tarski(k3_xboole_0(k2_relat_1(B),A),k10_relat_1(k4_relat_1(B),k10_relat_1(B,A))) ) ).

fof(d15_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v3_relat_1(A)
      <=> r1_tarski(k2_relat_1(A),k1_tarski(k1_xboole_0)) ) ) ).

fof(t184_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v3_relat_1(A)
      <=> ! [B] :
            ( r2_hidden(B,k2_relat_1(A))
           => B = k1_xboole_0 ) ) ) ).

fof(t185_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ! [C,D] :
              ( ( k7_relat_1(A,C) = k7_relat_1(B,C)
                & k7_relat_1(A,D) = k7_relat_1(B,D) )
             => k7_relat_1(A,k2_xboole_0(C,D)) = k7_relat_1(B,k2_xboole_0(C,D)) ) ) ) ).

fof(t186_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ! [C] :
          ( v1_relat_1(C)
         => ( ( r1_tarski(k1_relat_1(C),A)
              & r1_tarski(C,B) )
           => r1_tarski(C,k7_relat_1(B,A)) ) ) ) ).

fof(t187_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r1_xboole_0(B,k1_relat_1(A))
         => k7_relat_1(A,B) = k1_xboole_0 ) ) ).

fof(t188_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ! [C,D] :
              ( ( r1_tarski(C,D)
                & k7_relat_1(A,D) = k7_relat_1(B,D) )
             => k7_relat_1(A,C) = k7_relat_1(B,C) ) ) ) ).

fof(t189_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => k7_relat_1(A,k1_relat_1(B)) = k7_relat_1(A,k1_relat_1(k7_relat_1(B,k1_relat_1(A)))) ) ) ).

fof(t190_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ~ ( ~ v3_relat_1(k7_relat_1(B,A))
          & v3_relat_1(B) ) ) ).

fof(s1_relat_1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & ! [B,C] :
          ( r2_hidden(k4_tarski(B,C),A)
        <=> ( r2_hidden(B,f1_s1_relat_1)
            & r2_hidden(C,f2_s1_relat_1)
            & p1_s1_relat_1(B,C) ) ) ) ).

fof(dt_k1_relat_1,axiom,
    $true ).

fof(dt_k2_relat_1,axiom,
    $true ).

fof(dt_k3_relat_1,axiom,
    $true ).

fof(dt_k4_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => v1_relat_1(k4_relat_1(A)) ) ).

fof(involutiveness_k4_relat_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => k4_relat_1(k4_relat_1(A)) = A ) ).

fof(dt_k5_relat_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_relat_1(B) )
     => v1_relat_1(k5_relat_1(A,B)) ) ).

fof(dt_k6_relat_1,axiom,
    ! [A] : v1_relat_1(k6_relat_1(A)) ).

fof(dt_k7_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(A)
     => v1_relat_1(k7_relat_1(A,B)) ) ).

fof(dt_k8_relat_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => v1_relat_1(k8_relat_1(A,B)) ) ).

fof(dt_k9_relat_1,axiom,
    $true ).

fof(dt_k10_relat_1,axiom,
    $true ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(rc1_funct_1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A) ) ).

fof(cc1_funct_1,axiom,
    ! [A] :
      ( v1_xboole_0(A)
     => v1_funct_1(A) ) ).

fof(fc1_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_relat_1(B)
        & v1_funct_1(B) )
     => ( v1_relat_1(k5_relat_1(A,B))
        & v1_funct_1(k5_relat_1(A,B)) ) ) ).

fof(fc2_funct_1,axiom,
    ! [A] :
      ( v1_relat_1(k6_relat_1(A))
      & v1_funct_1(k6_relat_1(A)) ) ).

fof(rc2_funct_1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_xboole_0(A)
      & v1_funct_1(A) ) ).

fof(cc2_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_xboole_0(A)
        & v1_funct_1(A) )
     => ( v1_relat_1(A)
        & v1_funct_1(A)
        & v2_funct_1(A) ) ) ).

fof(rc3_funct_1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A)
      & v2_funct_1(A) ) ).

fof(fc3_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v2_funct_1(A) )
     => ( v1_relat_1(k4_relat_1(A))
        & v1_funct_1(k4_relat_1(A)) ) ) ).

fof(fc4_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v1_relat_1(k7_relat_1(A,B))
        & v1_funct_1(k7_relat_1(A,B)) ) ) ).

fof(fc5_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( v1_relat_1(k8_relat_1(A,B))
        & v1_funct_1(k8_relat_1(A,B)) ) ) ).

fof(rc4_funct_1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v3_relat_1(A)
      & v1_funct_1(A) ) ).

fof(rc5_funct_1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v2_relat_1(A)
      & v1_funct_1(A) ) ).

fof(fc6_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v2_relat_1(A)
        & v1_funct_1(A) )
     => v1_setfam_1(k2_relat_1(A)) ) ).

fof(d1_funct_1,axiom,
    ! [A] :
      ( v1_funct_1(A)
    <=> ! [B,C,D] :
          ( ( r2_hidden(k4_tarski(B,C),A)
            & r2_hidden(k4_tarski(B,D),A) )
         => C = D ) ) ).

fof(t1_funct_1,axiom,
    $true ).

fof(t2_funct_1,axiom,
    ! [A] :
      ( ( ! [B] :
            ~ ( r2_hidden(B,A)
              & ! [C,D] : k4_tarski(C,D) != B )
        & ! [B,C,D] :
            ( ( r2_hidden(k4_tarski(B,C),A)
              & r2_hidden(k4_tarski(B,D),A) )
           => C = D ) )
     => ( v1_relat_1(A)
        & v1_funct_1(A) ) ) ).

fof(d2_funct_1,axiom,
    $true ).

fof(d3_funct_1,axiom,
    $true ).

fof(d4_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B,C] :
          ( ( r2_hidden(B,k1_relat_1(A))
           => ( C = k1_funct_1(A,B)
            <=> r2_hidden(k4_tarski(B,C),A) ) )
          & ( ~ r2_hidden(B,k1_relat_1(A))
           => ( C = k1_funct_1(A,B)
            <=> C = k1_xboole_0 ) ) ) ) ).

fof(t3_funct_1,axiom,
    $true ).

fof(t4_funct_1,axiom,
    $true ).

fof(t5_funct_1,axiom,
    $true ).

fof(t6_funct_1,axiom,
    $true ).

fof(t7_funct_1,axiom,
    $true ).

fof(t8_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r2_hidden(k4_tarski(A,B),C)
      <=> ( r2_hidden(A,k1_relat_1(C))
          & B = k1_funct_1(C,A) ) ) ) ).

fof(t9_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( ( k1_relat_1(A) = k1_relat_1(B)
              & ! [C] :
                  ( r2_hidden(C,k1_relat_1(A))
                 => k1_funct_1(A,C) = k1_funct_1(B,C) ) )
           => A = B ) ) ) ).

fof(d5_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( B = k2_relat_1(A)
        <=> ! [C] :
              ( r2_hidden(C,B)
            <=> ? [D] :
                  ( r2_hidden(D,k1_relat_1(A))
                  & C = k1_funct_1(A,D) ) ) ) ) ).

fof(t10_funct_1,axiom,
    $true ).

fof(t11_funct_1,axiom,
    $true ).

fof(t12_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( r2_hidden(A,k1_relat_1(B))
       => r2_hidden(k1_funct_1(B,A),k2_relat_1(B)) ) ) ).

fof(t13_funct_1,axiom,
    $true ).

fof(t14_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( k1_relat_1(B) = k1_tarski(A)
       => k2_relat_1(B) = k1_tarski(k1_funct_1(B,A)) ) ) ).

fof(t15_funct_1,axiom,
    ! [A] :
      ( A != k1_xboole_0
     => ! [B] :
        ? [C] :
          ( v1_relat_1(C)
          & v1_funct_1(C)
          & k1_relat_1(C) = A
          & k2_relat_1(C) = k1_tarski(B) ) ) ).

fof(t16_funct_1,axiom,
    ! [A] :
      ( ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( ( k1_relat_1(B) = A
                  & k1_relat_1(C) = A )
               => B = C ) ) )
     => A = k1_xboole_0 ) ).

fof(t17_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( ( k1_relat_1(B) = k1_relat_1(C)
              & k2_relat_1(B) = k1_tarski(A)
              & k2_relat_1(C) = k1_tarski(A) )
           => B = C ) ) ) ).

fof(t18_funct_1,axiom,
    ! [A,B] :
      ~ ( ~ ( A = k1_xboole_0
            & B != k1_xboole_0 )
        & ! [C] :
            ( ( v1_relat_1(C)
              & v1_funct_1(C) )
           => ~ ( B = k1_relat_1(C)
                & r1_tarski(k2_relat_1(C),A) ) ) ) ).

fof(t19_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( ! [C] :
            ~ ( r2_hidden(C,A)
              & ! [D] :
                  ~ ( r2_hidden(D,k1_relat_1(B))
                    & C = k1_funct_1(B,D) ) )
       => r1_tarski(A,k2_relat_1(B)) ) ) ).

fof(t20_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( ( ! [D] :
                      ( r2_hidden(D,k1_relat_1(C))
                    <=> ( r2_hidden(D,k1_relat_1(A))
                        & r2_hidden(k1_funct_1(A,D),k1_relat_1(B)) ) )
                  & ! [D] :
                      ( r2_hidden(D,k1_relat_1(C))
                     => k1_funct_1(C,D) = k1_funct_1(B,k1_funct_1(A,D)) ) )
               => C = k5_relat_1(A,B) ) ) ) ) ).

fof(t21_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( r2_hidden(A,k1_relat_1(k5_relat_1(C,B)))
          <=> ( r2_hidden(A,k1_relat_1(C))
              & r2_hidden(k1_funct_1(C,A),k1_relat_1(B)) ) ) ) ) ).

fof(t22_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( r2_hidden(A,k1_relat_1(k5_relat_1(C,B)))
           => k1_funct_1(k5_relat_1(C,B),A) = k1_funct_1(B,k1_funct_1(C,A)) ) ) ) ).

fof(t23_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( r2_hidden(A,k1_relat_1(B))
           => k1_funct_1(k5_relat_1(B,C),A) = k1_funct_1(C,k1_funct_1(B,A)) ) ) ) ).

fof(t24_funct_1,axiom,
    $true ).

fof(t25_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( r2_hidden(A,k2_relat_1(k5_relat_1(C,B)))
           => r2_hidden(A,k2_relat_1(B)) ) ) ) ).

fof(t26_funct_1,axiom,
    $true ).

fof(t27_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( k1_relat_1(k5_relat_1(B,A)) = k1_relat_1(B)
           => r1_tarski(k2_relat_1(B),k1_relat_1(A)) ) ) ) ).

fof(t28_funct_1,axiom,
    $true ).

fof(t29_funct_1,axiom,
    $true ).

fof(t30_funct_1,axiom,
    $true ).

fof(t31_funct_1,axiom,
    $true ).

fof(t32_funct_1,axiom,
    $true ).

fof(t33_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( ( r1_tarski(k2_relat_1(B),A)
          & ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ! [D] :
                  ( ( v1_relat_1(D)
                    & v1_funct_1(D) )
                 => ( ( k1_relat_1(C) = A
                      & k1_relat_1(D) = A
                      & k5_relat_1(B,C) = k5_relat_1(B,D) )
                   => C = D ) ) ) )
       => A = k2_relat_1(B) ) ) ).

fof(t34_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( B = k6_relat_1(A)
      <=> ( k1_relat_1(B) = A
          & ! [C] :
              ( r2_hidden(C,A)
             => k1_funct_1(B,C) = C ) ) ) ) ).

fof(t35_funct_1,axiom,
    ! [A,B] :
      ( r2_hidden(B,A)
     => k1_funct_1(k6_relat_1(A),B) = B ) ).

fof(t36_funct_1,axiom,
    $true ).

fof(t37_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => k1_relat_1(k5_relat_1(k6_relat_1(A),B)) = k3_xboole_0(k1_relat_1(B),A) ) ).

fof(t38_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r2_hidden(B,k3_xboole_0(k1_relat_1(C),A))
       => k1_funct_1(C,B) = k1_funct_1(k5_relat_1(k6_relat_1(A),C),B) ) ) ).

fof(t39_funct_1,axiom,
    $true ).

fof(t40_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r2_hidden(B,k1_relat_1(k5_relat_1(C,k6_relat_1(A))))
      <=> ( r2_hidden(B,k1_relat_1(C))
          & r2_hidden(k1_funct_1(C,B),A) ) ) ) ).

fof(t41_funct_1,axiom,
    $true ).

fof(t42_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( k5_relat_1(k6_relat_1(k1_relat_1(A)),A) = A
        & k5_relat_1(A,k6_relat_1(k2_relat_1(A))) = A ) ) ).

fof(t43_funct_1,axiom,
    ! [A,B] : k5_relat_1(k6_relat_1(B),k6_relat_1(A)) = k6_relat_1(k3_xboole_0(A,B)) ).

fof(t44_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( ( k2_relat_1(A) = k1_relat_1(B)
              & k5_relat_1(A,B) = A )
           => B = k6_relat_1(k1_relat_1(B)) ) ) ) ).

fof(d6_funct_1,axiom,
    $true ).

fof(d7_funct_1,axiom,
    $true ).

fof(d8_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v2_funct_1(A)
      <=> ! [B,C] :
            ( ( r2_hidden(B,k1_relat_1(A))
              & r2_hidden(C,k1_relat_1(A))
              & k1_funct_1(A,B) = k1_funct_1(A,C) )
           => B = C ) ) ) ).

fof(t45_funct_1,axiom,
    $true ).

fof(t46_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( ( v2_funct_1(A)
              & v2_funct_1(B) )
           => v2_funct_1(k5_relat_1(A,B)) ) ) ) ).

fof(t47_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( ( v2_funct_1(k5_relat_1(B,A))
              & r1_tarski(k2_relat_1(B),k1_relat_1(A)) )
           => v2_funct_1(B) ) ) ) ).

fof(t48_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( ( v2_funct_1(k5_relat_1(B,A))
              & k2_relat_1(B) = k1_relat_1(A) )
           => ( v2_funct_1(B)
              & v2_funct_1(A) ) ) ) ) ).

fof(t49_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v2_funct_1(A)
      <=> ! [B] :
            ( ( v1_relat_1(B)
              & v1_funct_1(B) )
           => ! [C] :
                ( ( v1_relat_1(C)
                  & v1_funct_1(C) )
               => ( ( r1_tarski(k2_relat_1(B),k1_relat_1(A))
                    & r1_tarski(k2_relat_1(C),k1_relat_1(A))
                    & k1_relat_1(B) = k1_relat_1(C)
                    & k5_relat_1(B,A) = k5_relat_1(C,A) )
                 => B = C ) ) ) ) ) ).

fof(t50_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( ( k1_relat_1(B) = A
              & k1_relat_1(C) = A
              & r1_tarski(k2_relat_1(C),A)
              & v2_funct_1(B)
              & k5_relat_1(C,B) = B )
           => C = k6_relat_1(A) ) ) ) ).

fof(t51_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( ( k2_relat_1(k5_relat_1(B,A)) = k2_relat_1(A)
              & v2_funct_1(A) )
           => r1_tarski(k1_relat_1(A),k2_relat_1(B)) ) ) ) ).

fof(t52_funct_1,axiom,
    ! [A] : v2_funct_1(k6_relat_1(A)) ).

fof(t53_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( ? [B] :
            ( v1_relat_1(B)
            & v1_funct_1(B)
            & k5_relat_1(A,B) = k6_relat_1(k1_relat_1(A)) )
       => v2_funct_1(A) ) ) ).

fof(d9_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v2_funct_1(A)
       => k2_funct_1(A) = k4_relat_1(A) ) ) ).

fof(t54_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v2_funct_1(A)
       => ! [B] :
            ( ( v1_relat_1(B)
              & v1_funct_1(B) )
           => ( B = k2_funct_1(A)
            <=> ( k1_relat_1(B) = k2_relat_1(A)
                & ! [C,D] :
                    ( ( ( r2_hidden(C,k2_relat_1(A))
                        & D = k1_funct_1(B,C) )
                     => ( r2_hidden(D,k1_relat_1(A))
                        & C = k1_funct_1(A,D) ) )
                    & ( ( r2_hidden(D,k1_relat_1(A))
                        & C = k1_funct_1(A,D) )
                     => ( r2_hidden(C,k2_relat_1(A))
                        & D = k1_funct_1(B,C) ) ) ) ) ) ) ) ) ).

fof(t55_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v2_funct_1(A)
       => ( k2_relat_1(A) = k1_relat_1(k2_funct_1(A))
          & k1_relat_1(A) = k2_relat_1(k2_funct_1(A)) ) ) ) ).

fof(t56_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( ( v2_funct_1(B)
          & r2_hidden(A,k1_relat_1(B)) )
       => ( A = k1_funct_1(k2_funct_1(B),k1_funct_1(B,A))
          & A = k1_funct_1(k5_relat_1(B,k2_funct_1(B)),A) ) ) ) ).

fof(t57_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( ( v2_funct_1(B)
          & r2_hidden(A,k2_relat_1(B)) )
       => ( A = k1_funct_1(B,k1_funct_1(k2_funct_1(B),A))
          & A = k1_funct_1(k5_relat_1(k2_funct_1(B),B),A) ) ) ) ).

fof(t58_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v2_funct_1(A)
       => ( k1_relat_1(k5_relat_1(A,k2_funct_1(A))) = k1_relat_1(A)
          & k2_relat_1(k5_relat_1(A,k2_funct_1(A))) = k1_relat_1(A) ) ) ) ).

fof(t59_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v2_funct_1(A)
       => ( k1_relat_1(k5_relat_1(k2_funct_1(A),A)) = k2_relat_1(A)
          & k2_relat_1(k5_relat_1(k2_funct_1(A),A)) = k2_relat_1(A) ) ) ) ).

fof(t60_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( ( v2_funct_1(A)
              & k1_relat_1(A) = k2_relat_1(B)
              & k2_relat_1(A) = k1_relat_1(B)
              & ! [C,D] :
                  ( ( r2_hidden(C,k1_relat_1(A))
                    & r2_hidden(D,k1_relat_1(B)) )
                 => ( k1_funct_1(A,C) = D
                  <=> k1_funct_1(B,D) = C ) ) )
           => B = k2_funct_1(A) ) ) ) ).

fof(t61_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v2_funct_1(A)
       => ( k5_relat_1(A,k2_funct_1(A)) = k6_relat_1(k1_relat_1(A))
          & k5_relat_1(k2_funct_1(A),A) = k6_relat_1(k2_relat_1(A)) ) ) ) ).

fof(t62_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v2_funct_1(A)
       => v2_funct_1(k2_funct_1(A)) ) ) ).

fof(t63_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( ( v2_funct_1(A)
              & k2_relat_1(A) = k1_relat_1(B)
              & k5_relat_1(A,B) = k6_relat_1(k1_relat_1(A)) )
           => B = k2_funct_1(A) ) ) ) ).

fof(t64_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( ( v2_funct_1(A)
              & k2_relat_1(B) = k1_relat_1(A)
              & k5_relat_1(B,A) = k6_relat_1(k2_relat_1(A)) )
           => B = k2_funct_1(A) ) ) ) ).

fof(t65_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v2_funct_1(A)
       => k2_funct_1(k2_funct_1(A)) = A ) ) ).

fof(t66_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( ( v2_funct_1(A)
              & v2_funct_1(B) )
           => k2_funct_1(k5_relat_1(A,B)) = k5_relat_1(k2_funct_1(B),k2_funct_1(A)) ) ) ) ).

fof(t67_funct_1,axiom,
    ! [A] : k2_funct_1(k6_relat_1(A)) = k6_relat_1(A) ).

fof(t68_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( B = k7_relat_1(C,A)
          <=> ( k1_relat_1(B) = k3_xboole_0(k1_relat_1(C),A)
              & ! [D] :
                  ( r2_hidden(D,k1_relat_1(B))
                 => k1_funct_1(B,D) = k1_funct_1(C,D) ) ) ) ) ) ).

fof(t69_funct_1,axiom,
    $true ).

fof(t70_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r2_hidden(B,k1_relat_1(k7_relat_1(C,A)))
       => k1_funct_1(k7_relat_1(C,A),B) = k1_funct_1(C,B) ) ) ).

fof(t71_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r2_hidden(B,k3_xboole_0(k1_relat_1(C),A))
       => k1_funct_1(k7_relat_1(C,A),B) = k1_funct_1(C,B) ) ) ).

fof(t72_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r2_hidden(B,A)
       => k1_funct_1(k7_relat_1(C,A),B) = k1_funct_1(C,B) ) ) ).

fof(t73_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( ( r2_hidden(B,k1_relat_1(C))
          & r2_hidden(B,A) )
       => r2_hidden(k1_funct_1(C,B),k2_relat_1(k7_relat_1(C,A))) ) ) ).

fof(t74_funct_1,axiom,
    $true ).

fof(t75_funct_1,axiom,
    $true ).

fof(t76_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( r1_tarski(k1_relat_1(k7_relat_1(B,A)),k1_relat_1(B))
        & r1_tarski(k2_relat_1(k7_relat_1(B,A)),k2_relat_1(B)) ) ) ).

fof(t77_funct_1,axiom,
    $true ).

fof(t78_funct_1,axiom,
    $true ).

fof(t79_funct_1,axiom,
    $true ).

fof(t80_funct_1,axiom,
    $true ).

fof(t81_funct_1,axiom,
    $true ).

fof(t82_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r1_tarski(A,B)
       => ( k7_relat_1(k7_relat_1(C,A),B) = k7_relat_1(C,A)
          & k7_relat_1(k7_relat_1(C,B),A) = k7_relat_1(C,A) ) ) ) ).

fof(t83_funct_1,axiom,
    $true ).

fof(t84_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( v2_funct_1(B)
       => v2_funct_1(k7_relat_1(B,A)) ) ) ).

fof(t85_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( B = k8_relat_1(A,C)
          <=> ( ! [D] :
                  ( r2_hidden(D,k1_relat_1(B))
                <=> ( r2_hidden(D,k1_relat_1(C))
                    & r2_hidden(k1_funct_1(C,D),A) ) )
              & ! [D] :
                  ( r2_hidden(D,k1_relat_1(B))
                 => k1_funct_1(B,D) = k1_funct_1(C,D) ) ) ) ) ) ).

fof(t86_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r2_hidden(B,k1_relat_1(k8_relat_1(A,C)))
      <=> ( r2_hidden(B,k1_relat_1(C))
          & r2_hidden(k1_funct_1(C,B),A) ) ) ) ).

fof(t87_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r2_hidden(B,k1_relat_1(k8_relat_1(A,C)))
       => k1_funct_1(k8_relat_1(A,C),B) = k1_funct_1(C,B) ) ) ).

fof(t88_funct_1,axiom,
    $true ).

fof(t89_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( r1_tarski(k1_relat_1(k8_relat_1(A,B)),k1_relat_1(B))
        & r1_tarski(k2_relat_1(k8_relat_1(A,B)),k2_relat_1(B)) ) ) ).

fof(t90_funct_1,axiom,
    $true ).

fof(t91_funct_1,axiom,
    $true ).

fof(t92_funct_1,axiom,
    $true ).

fof(t93_funct_1,axiom,
    $true ).

fof(t94_funct_1,axiom,
    $true ).

fof(t95_funct_1,axiom,
    $true ).

fof(t96_funct_1,axiom,
    $true ).

fof(t97_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r1_tarski(A,B)
       => ( k8_relat_1(B,k8_relat_1(A,C)) = k8_relat_1(A,C)
          & k8_relat_1(A,k8_relat_1(B,C)) = k8_relat_1(A,C) ) ) ) ).

fof(t98_funct_1,axiom,
    $true ).

fof(t99_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( v2_funct_1(B)
       => v2_funct_1(k8_relat_1(A,B)) ) ) ).

fof(d10_funct_1,axiom,
    $true ).

fof(d11_funct_1,axiom,
    $true ).

fof(d12_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B,C] :
          ( C = k9_relat_1(A,B)
        <=> ! [D] :
              ( r2_hidden(D,C)
            <=> ? [E] :
                  ( r2_hidden(E,k1_relat_1(A))
                  & r2_hidden(E,B)
                  & D = k1_funct_1(A,E) ) ) ) ) ).

fof(t100_funct_1,axiom,
    $true ).

fof(t101_funct_1,axiom,
    $true ).

fof(t102_funct_1,axiom,
    $true ).

fof(t103_funct_1,axiom,
    $true ).

fof(t104_funct_1,axiom,
    $true ).

fof(t105_funct_1,axiom,
    $true ).

fof(t106_funct_1,axiom,
    $true ).

fof(t107_funct_1,axiom,
    $true ).

fof(t108_funct_1,axiom,
    $true ).

fof(t109_funct_1,axiom,
    $true ).

fof(t110_funct_1,axiom,
    $true ).

fof(t111_funct_1,axiom,
    $true ).

fof(t112_funct_1,axiom,
    $true ).

fof(t113_funct_1,axiom,
    $true ).

fof(t114_funct_1,axiom,
    $true ).

fof(t115_funct_1,axiom,
    $true ).

fof(t116_funct_1,axiom,
    $true ).

fof(t117_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( r2_hidden(A,k1_relat_1(B))
       => k9_relat_1(B,k1_tarski(A)) = k1_tarski(k1_funct_1(B,A)) ) ) ).

fof(t118_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( ( r2_hidden(A,k1_relat_1(C))
          & r2_hidden(B,k1_relat_1(C)) )
       => k9_relat_1(C,k2_tarski(A,B)) = k2_tarski(k1_funct_1(C,A),k1_funct_1(C,B)) ) ) ).

fof(t119_funct_1,axiom,
    $true ).

fof(t120_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => r1_tarski(k9_relat_1(k8_relat_1(A,C),B),k9_relat_1(C,B)) ) ).

fof(t121_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( v2_funct_1(C)
       => k9_relat_1(C,k3_xboole_0(A,B)) = k3_xboole_0(k9_relat_1(C,A),k9_relat_1(C,B)) ) ) ).

fof(t122_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( ! [B,C] : k9_relat_1(A,k3_xboole_0(B,C)) = k3_xboole_0(k9_relat_1(A,B),k9_relat_1(A,C))
       => v2_funct_1(A) ) ) ).

fof(t123_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( v2_funct_1(C)
       => k9_relat_1(C,k4_xboole_0(A,B)) = k4_xboole_0(k9_relat_1(C,A),k9_relat_1(C,B)) ) ) ).

fof(t124_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( ! [B,C] : k9_relat_1(A,k4_xboole_0(B,C)) = k4_xboole_0(k9_relat_1(A,B),k9_relat_1(A,C))
       => v2_funct_1(A) ) ) ).

fof(t125_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( ( r1_xboole_0(A,B)
          & v2_funct_1(C) )
       => r1_xboole_0(k9_relat_1(C,A),k9_relat_1(C,B)) ) ) ).

fof(t126_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => k9_relat_1(k8_relat_1(A,C),B) = k3_xboole_0(A,k9_relat_1(C,B)) ) ).

fof(d13_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B,C] :
          ( C = k10_relat_1(A,B)
        <=> ! [D] :
              ( r2_hidden(D,C)
            <=> ( r2_hidden(D,k1_relat_1(A))
                & r2_hidden(k1_funct_1(A,D),B) ) ) ) ) ).

fof(t127_funct_1,axiom,
    $true ).

fof(t128_funct_1,axiom,
    $true ).

fof(t129_funct_1,axiom,
    $true ).

fof(t130_funct_1,axiom,
    $true ).

fof(t131_funct_1,axiom,
    $true ).

fof(t132_funct_1,axiom,
    $true ).

fof(t133_funct_1,axiom,
    $true ).

fof(t134_funct_1,axiom,
    $true ).

fof(t135_funct_1,axiom,
    $true ).

fof(t136_funct_1,axiom,
    $true ).

fof(t137_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => k10_relat_1(C,k3_xboole_0(A,B)) = k3_xboole_0(k10_relat_1(C,A),k10_relat_1(C,B)) ) ).

fof(t138_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => k10_relat_1(C,k4_xboole_0(A,B)) = k4_xboole_0(k10_relat_1(C,A),k10_relat_1(C,B)) ) ).

fof(t139_funct_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => k10_relat_1(k7_relat_1(C,A),B) = k3_xboole_0(A,k10_relat_1(C,B)) ) ).

fof(t140_funct_1,axiom,
    $true ).

fof(t141_funct_1,axiom,
    $true ).

fof(t142_funct_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r2_hidden(A,k2_relat_1(B))
      <=> k10_relat_1(B,k1_tarski(A)) != k1_xboole_0 ) ) ).

fof(t143_funct_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( ! [C] :
            ~ ( r2_hidden(C,A)
              & k10_relat_1(B,k1_tarski(C)) = k1_xboole_0 )
       => r1_tarski(A,k2_relat_1(B)) ) ) ).

fof(t144_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( ! [B] :
            ~ ( r2_hidden(B,k2_relat_1(A))
              & ! [C] : k10_relat_1(A,k1_tarski(B)) != k1_tarski(C) )
      <=> v2_funct_1(A) ) ) ).

fof(t145_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => r1_tarski(k9_relat_1(B,k10_relat_1(B,A)),A) ) ).

fof(t146_funct_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r1_tarski(A,k1_relat_1(B))
       => r1_tarski(A,k10_relat_1(B,k9_relat_1(B,A))) ) ) ).

fof(t147_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( r1_tarski(A,k2_relat_1(B))
       => k9_relat_1(B,k10_relat_1(B,A)) = A ) ) ).

fof(t148_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => k9_relat_1(B,k10_relat_1(B,A)) = k3_xboole_0(A,k9_relat_1(B,k1_relat_1(B))) ) ).

fof(t149_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => r1_tarski(k9_relat_1(C,k3_xboole_0(A,k10_relat_1(C,B))),k3_xboole_0(k9_relat_1(C,A),B)) ) ).

fof(t150_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => k9_relat_1(C,k3_xboole_0(A,k10_relat_1(C,B))) = k3_xboole_0(k9_relat_1(C,A),B) ) ).

fof(t151_funct_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => r1_tarski(k3_xboole_0(A,k10_relat_1(C,B)),k10_relat_1(C,k3_xboole_0(k9_relat_1(C,A),B))) ) ).

fof(t152_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( v2_funct_1(B)
       => r1_tarski(k10_relat_1(B,k9_relat_1(B,A)),A) ) ) ).

fof(t153_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( ! [B] : r1_tarski(k10_relat_1(A,k9_relat_1(A,B)),B)
       => v2_funct_1(A) ) ) ).

fof(t154_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( v2_funct_1(B)
       => k9_relat_1(B,A) = k10_relat_1(k2_funct_1(B),A) ) ) ).

fof(t155_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( v2_funct_1(B)
       => k10_relat_1(B,A) = k9_relat_1(k2_funct_1(B),A) ) ) ).

fof(t156_funct_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ! [D] :
              ( ( v1_relat_1(D)
                & v1_funct_1(D) )
             => ( ( A = k2_relat_1(B)
                  & k1_relat_1(C) = A
                  & k1_relat_1(D) = A
                  & k5_relat_1(B,C) = k5_relat_1(B,D) )
               => C = D ) ) ) ) ).

fof(t157_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( ( r1_tarski(k9_relat_1(C,A),k9_relat_1(C,B))
          & r1_tarski(A,k1_relat_1(C))
          & v2_funct_1(C) )
       => r1_tarski(A,B) ) ) ).

fof(t158_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( ( r1_tarski(k10_relat_1(C,A),k10_relat_1(C,B))
          & r1_tarski(A,k2_relat_1(C)) )
       => r1_tarski(A,B) ) ) ).

fof(t159_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v2_funct_1(A)
      <=> ! [B] :
          ? [C] : r1_tarski(k10_relat_1(A,k1_tarski(B)),k1_tarski(C)) ) ) ).

fof(t160_funct_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ! [C] :
          ( v1_relat_1(C)
         => ( r1_tarski(k2_relat_1(B),k1_relat_1(C))
           => r1_tarski(k10_relat_1(B,A),k10_relat_1(k5_relat_1(B,C),k9_relat_1(C,A))) ) ) ) ).

fof(t161_funct_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( ( k10_relat_1(C,A) = k10_relat_1(C,B)
          & r1_tarski(A,k2_relat_1(C))
          & r1_tarski(B,k2_relat_1(C)) )
       => A = B ) ) ).

fof(t162_funct_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
     => k9_relat_1(k6_relat_1(A),B) = B ) ).

fof(d14_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v3_relat_1(A)
      <=> ! [B] :
            ( r2_hidden(B,k1_relat_1(A))
           => v1_xboole_0(k1_funct_1(A,B)) ) ) ) ).

fof(d15_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v2_relat_1(A)
      <=> ! [B] :
            ~ ( r2_hidden(B,k1_relat_1(A))
              & v1_xboole_0(k1_funct_1(A,B)) ) ) ) ).

fof(s1_funct_1,axiom,
    ( ! [A,B,C] :
        ( ( p1_s1_funct_1(A,B)
          & p1_s1_funct_1(A,C) )
       => B = C )
   => ? [A] :
        ( v1_relat_1(A)
        & v1_funct_1(A)
        & ! [B,C] :
            ( r2_hidden(k4_tarski(B,C),A)
          <=> ( r2_hidden(B,f1_s1_funct_1)
              & p1_s1_funct_1(B,C) ) ) ) ) ).

fof(s2_funct_1,axiom,
    ( ( ! [A,B,C] :
          ( ( r2_hidden(A,f1_s2_funct_1)
            & p1_s2_funct_1(A,B)
            & p1_s2_funct_1(A,C) )
         => B = C )
      & ! [A] :
          ~ ( r2_hidden(A,f1_s2_funct_1)
            & ! [B] : ~ p1_s2_funct_1(A,B) ) )
   => ? [A] :
        ( v1_relat_1(A)
        & v1_funct_1(A)
        & k1_relat_1(A) = f1_s2_funct_1
        & ! [B] :
            ( r2_hidden(B,f1_s2_funct_1)
           => p1_s2_funct_1(B,k1_funct_1(A,B)) ) ) ) ).

fof(s3_funct_1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A)
      & k1_relat_1(A) = f1_s3_funct_1
      & ! [B] :
          ( r2_hidden(B,f1_s3_funct_1)
         => k1_funct_1(A,B) = f2_s3_funct_1(B) ) ) ).

fof(s4_funct_1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A)
      & k1_relat_1(A) = f1_s4_funct_1
      & ! [B] :
          ( m1_subset_1(B,f1_s4_funct_1)
         => k1_funct_1(A,B) = f2_s4_funct_1(B) ) ) ).

fof(dt_k1_funct_1,axiom,
    $true ).

fof(dt_k2_funct_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v1_relat_1(k2_funct_1(A))
        & v1_funct_1(k2_funct_1(A)) ) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(d1_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r1_relat_2(A,B)
        <=> ! [C] :
              ( r2_hidden(C,B)
             => r2_hidden(k4_tarski(C,C),A) ) ) ) ).

fof(d2_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r2_relat_2(A,B)
        <=> ! [C] :
              ~ ( r2_hidden(C,B)
                & r2_hidden(k4_tarski(C,C),A) ) ) ) ).

fof(d3_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r3_relat_2(A,B)
        <=> ! [C,D] :
              ( ( r2_hidden(C,B)
                & r2_hidden(D,B)
                & r2_hidden(k4_tarski(C,D),A) )
             => r2_hidden(k4_tarski(D,C),A) ) ) ) ).

fof(d4_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r4_relat_2(A,B)
        <=> ! [C,D] :
              ( ( r2_hidden(C,B)
                & r2_hidden(D,B)
                & r2_hidden(k4_tarski(C,D),A)
                & r2_hidden(k4_tarski(D,C),A) )
             => C = D ) ) ) ).

fof(d5_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r5_relat_2(A,B)
        <=> ! [C,D] :
              ~ ( r2_hidden(C,B)
                & r2_hidden(D,B)
                & r2_hidden(k4_tarski(C,D),A)
                & r2_hidden(k4_tarski(D,C),A) ) ) ) ).

fof(d6_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r6_relat_2(A,B)
        <=> ! [C,D] :
              ~ ( r2_hidden(C,B)
                & r2_hidden(D,B)
                & C != D
                & ~ r2_hidden(k4_tarski(C,D),A)
                & ~ r2_hidden(k4_tarski(D,C),A) ) ) ) ).

fof(d7_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r7_relat_2(A,B)
        <=> ! [C,D] :
              ~ ( r2_hidden(C,B)
                & r2_hidden(D,B)
                & ~ r2_hidden(k4_tarski(C,D),A)
                & ~ r2_hidden(k4_tarski(D,C),A) ) ) ) ).

fof(d8_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r8_relat_2(A,B)
        <=> ! [C,D,E] :
              ( ( r2_hidden(C,B)
                & r2_hidden(D,B)
                & r2_hidden(E,B)
                & r2_hidden(k4_tarski(C,D),A)
                & r2_hidden(k4_tarski(D,E),A) )
             => r2_hidden(k4_tarski(C,E),A) ) ) ) ).

fof(d9_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v1_relat_2(A)
      <=> r1_relat_2(A,k3_relat_1(A)) ) ) ).

fof(d10_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v2_relat_2(A)
      <=> r2_relat_2(A,k3_relat_1(A)) ) ) ).

fof(d11_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v3_relat_2(A)
      <=> r3_relat_2(A,k3_relat_1(A)) ) ) ).

fof(d12_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v4_relat_2(A)
      <=> r4_relat_2(A,k3_relat_1(A)) ) ) ).

fof(d13_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v5_relat_2(A)
      <=> r5_relat_2(A,k3_relat_1(A)) ) ) ).

fof(d14_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v6_relat_2(A)
      <=> r6_relat_2(A,k3_relat_1(A)) ) ) ).

fof(d15_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v7_relat_2(A)
      <=> r7_relat_2(A,k3_relat_1(A)) ) ) ).

fof(d16_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v8_relat_2(A)
      <=> r8_relat_2(A,k3_relat_1(A)) ) ) ).

fof(t1_relat_2,axiom,
    $true ).

fof(t2_relat_2,axiom,
    $true ).

fof(t3_relat_2,axiom,
    $true ).

fof(t4_relat_2,axiom,
    $true ).

fof(t5_relat_2,axiom,
    $true ).

fof(t6_relat_2,axiom,
    $true ).

fof(t7_relat_2,axiom,
    $true ).

fof(t8_relat_2,axiom,
    $true ).

fof(t9_relat_2,axiom,
    $true ).

fof(t10_relat_2,axiom,
    $true ).

fof(t11_relat_2,axiom,
    $true ).

fof(t12_relat_2,axiom,
    $true ).

fof(t13_relat_2,axiom,
    $true ).

fof(t14_relat_2,axiom,
    $true ).

fof(t15_relat_2,axiom,
    $true ).

fof(t16_relat_2,axiom,
    $true ).

fof(t17_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v1_relat_2(A)
      <=> r1_tarski(k6_relat_1(k3_relat_1(A)),A) ) ) ).

fof(t18_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v2_relat_2(A)
      <=> r1_xboole_0(k6_relat_1(k3_relat_1(A)),A) ) ) ).

fof(t19_relat_2,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r4_relat_2(B,A)
      <=> r5_relat_2(k4_xboole_0(B,k6_relat_1(A)),A) ) ) ).

fof(t20_relat_2,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r5_relat_2(B,A)
       => r4_relat_2(k2_xboole_0(B,k6_relat_1(A)),A) ) ) ).

fof(t21_relat_2,axiom,
    $true ).

fof(t22_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( ( v3_relat_2(A)
          & v8_relat_2(A) )
       => v1_relat_2(A) ) ) ).

fof(t23_relat_2,axiom,
    ! [A] :
      ( v3_relat_2(k6_relat_1(A))
      & v8_relat_2(k6_relat_1(A)) ) ).

fof(t24_relat_2,axiom,
    ! [A] :
      ( v4_relat_2(k6_relat_1(A))
      & v1_relat_2(k6_relat_1(A)) ) ).

fof(t25_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( ( v2_relat_2(A)
          & v8_relat_2(A) )
       => v5_relat_2(A) ) ) ).

fof(t26_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v5_relat_2(A)
       => ( v2_relat_2(A)
          & v4_relat_2(A) ) ) ) ).

fof(t27_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v1_relat_2(A)
       => v1_relat_2(k4_relat_1(A)) ) ) ).

fof(t28_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v2_relat_2(A)
       => v2_relat_2(k4_relat_1(A)) ) ) ).

fof(t29_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v1_relat_2(A)
       => ( k1_relat_1(A) = k1_relat_1(k4_relat_1(A))
          & k2_relat_1(A) = k2_relat_1(k4_relat_1(A)) ) ) ) ).

fof(t30_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v3_relat_2(A)
      <=> A = k4_relat_1(A) ) ) ).

fof(t31_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( ( v1_relat_2(A)
              & v1_relat_2(B) )
           => ( v1_relat_2(k2_xboole_0(A,B))
              & v1_relat_2(k3_xboole_0(A,B)) ) ) ) ) ).

fof(t32_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( ( v2_relat_2(A)
              & v2_relat_2(B) )
           => ( v2_relat_2(k2_xboole_0(A,B))
              & v2_relat_2(k3_xboole_0(A,B)) ) ) ) ) ).

fof(t33_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( v2_relat_2(A)
           => v2_relat_2(k4_xboole_0(A,B)) ) ) ) ).

fof(t34_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v3_relat_2(A)
       => v3_relat_2(k4_relat_1(A)) ) ) ).

fof(t35_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( ( v3_relat_2(A)
              & v3_relat_2(B) )
           => ( v3_relat_2(k2_xboole_0(A,B))
              & v3_relat_2(k3_xboole_0(A,B))
              & v3_relat_2(k4_xboole_0(A,B)) ) ) ) ) ).

fof(t36_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v5_relat_2(A)
       => v5_relat_2(k4_relat_1(A)) ) ) ).

fof(t37_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( ( v5_relat_2(A)
              & v5_relat_2(B) )
           => v5_relat_2(k3_xboole_0(A,B)) ) ) ) ).

fof(t38_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( v5_relat_2(A)
           => v5_relat_2(k4_xboole_0(A,B)) ) ) ) ).

fof(t39_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v4_relat_2(A)
      <=> r1_tarski(k3_xboole_0(A,k4_relat_1(A)),k6_relat_1(k1_relat_1(A))) ) ) ).

fof(t40_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v4_relat_2(A)
       => v4_relat_2(k4_relat_1(A)) ) ) ).

fof(t41_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( v4_relat_2(A)
           => ( v4_relat_2(k3_xboole_0(A,B))
              & v4_relat_2(k4_xboole_0(A,B)) ) ) ) ) ).

fof(t42_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v8_relat_2(A)
       => v8_relat_2(k4_relat_1(A)) ) ) ).

fof(t43_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( ( v8_relat_2(A)
              & v8_relat_2(B) )
           => v8_relat_2(k3_xboole_0(A,B)) ) ) ) ).

fof(t44_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v8_relat_2(A)
      <=> r1_tarski(k5_relat_1(A,A),A) ) ) ).

fof(t45_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v6_relat_2(A)
      <=> r1_tarski(k4_xboole_0(k2_zfmisc_1(k3_relat_1(A),k3_relat_1(A)),k6_relat_1(k3_relat_1(A))),k2_xboole_0(A,k4_relat_1(A))) ) ) ).

fof(t46_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v7_relat_2(A)
       => ( v6_relat_2(A)
          & v1_relat_2(A) ) ) ) ).

fof(t47_relat_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v7_relat_2(A)
      <=> k2_zfmisc_1(k3_relat_1(A),k3_relat_1(A)) = k2_xboole_0(A,k4_relat_1(A)) ) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(fc1_ordinal1,axiom,
    ! [A] : ~ v1_xboole_0(k1_ordinal1(A)) ).

fof(cc1_ordinal1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ( v1_ordinal1(A)
        & v2_ordinal1(A) ) ) ).

fof(cc2_ordinal1,axiom,
    ! [A] :
      ( ( v1_ordinal1(A)
        & v2_ordinal1(A) )
     => v3_ordinal1(A) ) ).

fof(rc1_ordinal1,axiom,
    ? [A] :
      ( v1_ordinal1(A)
      & v2_ordinal1(A)
      & v3_ordinal1(A) ) ).

fof(rc2_ordinal1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A)
      & v2_funct_1(A)
      & v1_xboole_0(A)
      & v1_ordinal1(A)
      & v2_ordinal1(A)
      & v3_ordinal1(A) ) ).

fof(cc3_ordinal1,axiom,
    ! [A] :
      ( v1_xboole_0(A)
     => ( v1_ordinal1(A)
        & v2_ordinal1(A)
        & v3_ordinal1(A) ) ) ).

fof(fc2_ordinal1,axiom,
    ( v1_relat_1(k1_xboole_0)
    & v3_relat_1(k1_xboole_0)
    & v1_funct_1(k1_xboole_0)
    & v2_funct_1(k1_xboole_0)
    & v1_xboole_0(k1_xboole_0)
    & v1_ordinal1(k1_xboole_0)
    & v2_ordinal1(k1_xboole_0)
    & v3_ordinal1(k1_xboole_0) ) ).

fof(rc3_ordinal1,axiom,
    ? [A] :
      ( ~ v1_xboole_0(A)
      & v1_ordinal1(A)
      & v2_ordinal1(A)
      & v3_ordinal1(A) ) ).

fof(fc3_ordinal1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ( ~ v1_xboole_0(k1_ordinal1(A))
        & v1_ordinal1(k1_ordinal1(A))
        & v2_ordinal1(k1_ordinal1(A))
        & v3_ordinal1(k1_ordinal1(A)) ) ) ).

fof(fc4_ordinal1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ( v1_ordinal1(k3_tarski(A))
        & v2_ordinal1(k3_tarski(A))
        & v3_ordinal1(k3_tarski(A)) ) ) ).

fof(rc4_ordinal1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A)
      & v5_ordinal1(A) ) ).

fof(fc5_ordinal1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A) )
     => ( v1_ordinal1(k1_relat_1(A))
        & v2_ordinal1(k1_relat_1(A))
        & v3_ordinal1(k1_relat_1(A)) ) ) ).

fof(t1_ordinal1,axiom,
    $true ).

fof(t2_ordinal1,axiom,
    $true ).

fof(t3_ordinal1,axiom,
    ! [A,B,C] :
      ~ ( r2_hidden(A,B)
        & r2_hidden(B,C)
        & r2_hidden(C,A) ) ).

fof(t4_ordinal1,axiom,
    ! [A,B,C,D] :
      ~ ( r2_hidden(A,B)
        & r2_hidden(B,C)
        & r2_hidden(C,D)
        & r2_hidden(D,A) ) ).

fof(t5_ordinal1,axiom,
    ! [A,B,C,D,E] :
      ~ ( r2_hidden(A,B)
        & r2_hidden(B,C)
        & r2_hidden(C,D)
        & r2_hidden(D,E)
        & r2_hidden(E,A) ) ).

fof(t6_ordinal1,axiom,
    ! [A,B,C,D,E,F] :
      ~ ( r2_hidden(A,B)
        & r2_hidden(B,C)
        & r2_hidden(C,D)
        & r2_hidden(D,E)
        & r2_hidden(E,F)
        & r2_hidden(F,A) ) ).

fof(t7_ordinal1,axiom,
    ! [A,B] :
      ~ ( r2_hidden(A,B)
        & r1_tarski(B,A) ) ).

fof(d1_ordinal1,axiom,
    ! [A] : k1_ordinal1(A) = k2_xboole_0(A,k1_tarski(A)) ).

fof(t8_ordinal1,axiom,
    $true ).

fof(t9_ordinal1,axiom,
    $true ).

fof(t10_ordinal1,axiom,
    ! [A] : r2_hidden(A,k1_ordinal1(A)) ).

fof(t11_ordinal1,axiom,
    $true ).

fof(t12_ordinal1,axiom,
    ! [A,B] :
      ( k1_ordinal1(A) = k1_ordinal1(B)
     => A = B ) ).

fof(t13_ordinal1,axiom,
    ! [A,B] :
      ( r2_hidden(A,k1_ordinal1(B))
    <=> ( r2_hidden(A,B)
        | A = B ) ) ).

fof(t14_ordinal1,axiom,
    ! [A] : A != k1_ordinal1(A) ).

fof(d2_ordinal1,axiom,
    ! [A] :
      ( v1_ordinal1(A)
    <=> ! [B] :
          ( r2_hidden(B,A)
         => r1_tarski(B,A) ) ) ).

fof(d3_ordinal1,axiom,
    ! [A] :
      ( v2_ordinal1(A)
    <=> ! [B,C] :
          ~ ( r2_hidden(B,A)
            & r2_hidden(C,A)
            & ~ r2_hidden(B,C)
            & B != C
            & ~ r2_hidden(C,B) ) ) ).

fof(d4_ordinal1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
    <=> ( v1_ordinal1(A)
        & v2_ordinal1(A) ) ) ).

fof(t15_ordinal1,axiom,
    $true ).

fof(t16_ordinal1,axiom,
    $true ).

fof(t17_ordinal1,axiom,
    $true ).

fof(t18_ordinal1,axiom,
    $true ).

fof(t19_ordinal1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v1_ordinal1(C)
             => ( ( r2_hidden(C,A)
                  & r2_hidden(A,B) )
               => r2_hidden(C,B) ) ) ) ) ).

fof(t20_ordinal1,axiom,
    $true ).

fof(t21_ordinal1,axiom,
    ! [A] :
      ( v1_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( r2_xboole_0(A,B)
           => r2_hidden(A,B) ) ) ) ).

fof(t22_ordinal1,axiom,
    ! [A] :
      ( v1_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( ( r1_tarski(A,B)
                  & r2_hidden(B,C) )
               => r2_hidden(A,C) ) ) ) ) ).

fof(t23_ordinal1,axiom,
    ! [A,B] :
      ( v3_ordinal1(B)
     => ( r2_hidden(A,B)
       => v3_ordinal1(A) ) ) ).

fof(t24_ordinal1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ~ ( ~ r2_hidden(A,B)
              & A != B
              & ~ r2_hidden(B,A) ) ) ) ).

fof(t25_ordinal1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => r3_xboole_0(A,B) ) ) ).

fof(t26_ordinal1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( r1_ordinal1(A,B)
            | r2_hidden(B,A) ) ) ) ).

fof(t27_ordinal1,axiom,
    v3_ordinal1(k1_xboole_0) ).

fof(t28_ordinal1,axiom,
    $true ).

fof(t29_ordinal1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => v3_ordinal1(k1_ordinal1(A)) ) ).

fof(t30_ordinal1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => v3_ordinal1(k3_tarski(A)) ) ).

fof(t31_ordinal1,axiom,
    ! [A] :
      ( ! [B] :
          ( r2_hidden(B,A)
         => ( v3_ordinal1(B)
            & r1_tarski(B,A) ) )
     => v3_ordinal1(A) ) ).

fof(t32_ordinal1,axiom,
    ! [A,B] :
      ( v3_ordinal1(B)
     => ~ ( r1_tarski(A,B)
          & A != k1_xboole_0
          & ! [C] :
              ( v3_ordinal1(C)
             => ~ ( r2_hidden(C,A)
                  & ! [D] :
                      ( v3_ordinal1(D)
                     => ( r2_hidden(D,A)
                       => r1_ordinal1(C,D) ) ) ) ) ) ) ).

fof(t33_ordinal1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( r2_hidden(A,B)
          <=> r1_ordinal1(k1_ordinal1(A),B) ) ) ) ).

fof(t34_ordinal1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( r2_hidden(A,k1_ordinal1(B))
          <=> r1_ordinal1(A,B) ) ) ) ).

fof(t35_ordinal1,axiom,
    ! [A] :
      ( ! [B] :
          ( r2_hidden(B,A)
         => v3_ordinal1(B) )
     => v3_ordinal1(k3_tarski(A)) ) ).

fof(t36_ordinal1,axiom,
    ! [A] :
      ~ ( ! [B] :
            ( r2_hidden(B,A)
           => v3_ordinal1(B) )
        & ! [B] :
            ( v3_ordinal1(B)
           => ~ r1_tarski(A,B) ) ) ).

fof(t37_ordinal1,axiom,
    ! [A] :
      ~ ! [B] :
          ( r2_hidden(B,A)
        <=> v3_ordinal1(B) ) ).

fof(t38_ordinal1,axiom,
    ! [A] :
      ~ ! [B] :
          ( v3_ordinal1(B)
         => r2_hidden(B,A) ) ).

fof(t39_ordinal1,axiom,
    ! [A] :
    ? [B] :
      ( v3_ordinal1(B)
      & ~ r2_hidden(B,A)
      & ! [C] :
          ( v3_ordinal1(C)
         => ( ~ r2_hidden(C,A)
           => r1_ordinal1(B,C) ) ) ) ).

fof(d5_ordinal1,axiom,
    $true ).

fof(d6_ordinal1,axiom,
    ! [A] :
      ( v4_ordinal1(A)
    <=> A = k3_tarski(A) ) ).

fof(t40_ordinal1,axiom,
    $true ).

fof(t41_ordinal1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ( v4_ordinal1(A)
      <=> ! [B] :
            ( v3_ordinal1(B)
           => ( r2_hidden(B,A)
             => r2_hidden(k1_ordinal1(B),A) ) ) ) ) ).

fof(t42_ordinal1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ( ~ ( ~ v4_ordinal1(A)
            & ! [B] :
                ( v3_ordinal1(B)
               => A != k1_ordinal1(B) ) )
        & ~ ( ? [B] :
                ( v3_ordinal1(B)
                & A = k1_ordinal1(B) )
            & v4_ordinal1(A) ) ) ) ).

fof(d7_ordinal1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v5_ordinal1(A)
      <=> v3_ordinal1(k1_relat_1(A)) ) ) ).

fof(d8_ordinal1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B)
        & v5_ordinal1(B) )
     => ( m1_ordinal1(B,A)
      <=> r1_tarski(k2_relat_1(B),A) ) ) ).

fof(t43_ordinal1,axiom,
    $true ).

fof(t44_ordinal1,axiom,
    $true ).

fof(t45_ordinal1,axiom,
    ! [A] : m1_ordinal1(k1_xboole_0,A) ).

fof(t46_ordinal1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v3_ordinal1(k1_relat_1(A))
       => m1_ordinal1(A,k2_relat_1(A)) ) ) ).

fof(t47_ordinal1,axiom,
    ! [A,B] :
      ( r1_tarski(A,B)
     => ! [C] :
          ( m1_ordinal1(C,A)
         => m1_ordinal1(C,B) ) ) ).

fof(t48_ordinal1,axiom,
    ! [A,B] :
      ( m1_ordinal1(B,A)
     => ! [C] :
          ( v3_ordinal1(C)
         => m1_ordinal1(k2_ordinal1(B,C),A) ) ) ).

fof(d9_ordinal1,axiom,
    ! [A] :
      ( v6_ordinal1(A)
    <=> ! [B,C] :
          ( ( r2_hidden(B,A)
            & r2_hidden(C,A) )
         => r3_xboole_0(B,C) ) ) ).

fof(t49_ordinal1,axiom,
    ! [A] :
      ( ( ! [B] :
            ( r2_hidden(B,A)
           => ( v1_relat_1(B)
              & v1_funct_1(B)
              & v5_ordinal1(B) ) )
        & v6_ordinal1(A) )
     => ( v1_relat_1(k3_tarski(A))
        & v1_funct_1(k3_tarski(A))
        & v5_ordinal1(k3_tarski(A)) ) ) ).

fof(t50_ordinal1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ~ ( ~ r2_xboole_0(A,B)
              & A != B
              & ~ r2_xboole_0(B,A) ) ) ) ).

fof(s1_ordinal1,axiom,
    ( ? [A] :
        ( v3_ordinal1(A)
        & p1_s1_ordinal1(A) )
   => ? [A] :
        ( v3_ordinal1(A)
        & p1_s1_ordinal1(A)
        & ! [B] :
            ( v3_ordinal1(B)
           => ( p1_s1_ordinal1(B)
             => r1_ordinal1(A,B) ) ) ) ) ).

fof(s2_ordinal1,axiom,
    ( ! [A] :
        ( v3_ordinal1(A)
       => ( ! [B] :
              ( v3_ordinal1(B)
             => ( r2_hidden(B,A)
               => p1_s2_ordinal1(B) ) )
         => p1_s2_ordinal1(A) ) )
   => ! [A] :
        ( v3_ordinal1(A)
       => p1_s2_ordinal1(A) ) ) ).

fof(s3_ordinal1,axiom,
    ( ( k1_relat_1(f3_s3_ordinal1) = f1_s3_ordinal1
      & ! [A] :
          ( v3_ordinal1(A)
         => ! [B] :
              ( ( v1_relat_1(B)
                & v1_funct_1(B)
                & v5_ordinal1(B) )
             => ( ( r2_hidden(A,f1_s3_ordinal1)
                  & B = k2_ordinal1(f3_s3_ordinal1,A) )
               => k1_funct_1(f3_s3_ordinal1,A) = f2_s3_ordinal1(B) ) ) )
      & k1_relat_1(f4_s3_ordinal1) = f1_s3_ordinal1
      & ! [A] :
          ( v3_ordinal1(A)
         => ! [B] :
              ( ( v1_relat_1(B)
                & v1_funct_1(B)
                & v5_ordinal1(B) )
             => ( ( r2_hidden(A,f1_s3_ordinal1)
                  & B = k2_ordinal1(f4_s3_ordinal1,A) )
               => k1_funct_1(f4_s3_ordinal1,A) = f2_s3_ordinal1(B) ) ) ) )
   => f3_s3_ordinal1 = f4_s3_ordinal1 ) ).

fof(s4_ordinal1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A)
      & v5_ordinal1(A)
      & k1_relat_1(A) = f1_s4_ordinal1
      & ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C)
                & v5_ordinal1(C) )
             => ( ( r2_hidden(B,f1_s4_ordinal1)
                  & C = k2_ordinal1(A,B) )
               => k1_funct_1(A,B) = f2_s4_ordinal1(C) ) ) ) ) ).

fof(s5_ordinal1,axiom,
    ( ( ! [A] :
          ( v3_ordinal1(A)
         => ! [B] :
              ( B = f2_s5_ordinal1(A)
            <=> ? [C] :
                  ( v1_relat_1(C)
                  & v1_funct_1(C)
                  & v5_ordinal1(C)
                  & B = f3_s5_ordinal1(C)
                  & k1_relat_1(C) = A
                  & ! [D] :
                      ( v3_ordinal1(D)
                     => ( r2_hidden(D,A)
                       => k1_funct_1(C,D) = f3_s5_ordinal1(k2_ordinal1(C,D)) ) ) ) ) )
      & ! [A] :
          ( v3_ordinal1(A)
         => ( r2_hidden(A,k1_relat_1(f1_s5_ordinal1))
           => k1_funct_1(f1_s5_ordinal1,A) = f2_s5_ordinal1(A) ) ) )
   => ! [A] :
        ( v3_ordinal1(A)
       => ( r2_hidden(A,k1_relat_1(f1_s5_ordinal1))
         => k1_funct_1(f1_s5_ordinal1,A) = f3_s5_ordinal1(k2_ordinal1(f1_s5_ordinal1,A)) ) ) ) ).

fof(dt_m1_ordinal1,axiom,
    ! [A,B] :
      ( m1_ordinal1(B,A)
     => ( v1_relat_1(B)
        & v1_funct_1(B)
        & v5_ordinal1(B) ) ) ).

fof(existence_m1_ordinal1,axiom,
    ! [A] :
    ? [B] : m1_ordinal1(B,A) ).

fof(reflexivity_r1_ordinal1,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v3_ordinal1(B) )
     => r1_ordinal1(A,A) ) ).

fof(connectedness_r1_ordinal1,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v3_ordinal1(B) )
     => ( r1_ordinal1(A,B)
        | r1_ordinal1(B,A) ) ) ).

fof(redefinition_r1_ordinal1,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v3_ordinal1(B) )
     => ( r1_ordinal1(A,B)
      <=> r1_tarski(A,B) ) ) ).

fof(dt_k1_ordinal1,axiom,
    $true ).

fof(dt_k2_ordinal1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A)
        & v3_ordinal1(B) )
     => m1_ordinal1(k2_ordinal1(A,B),k2_relat_1(A)) ) ).

fof(redefinition_k2_ordinal1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A)
        & v3_ordinal1(B) )
     => k2_ordinal1(A,B) = k7_relat_1(A,B) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(cc1_relset_1,axiom,
    ! [A,B,C] :
      ( m1_subset_1(C,k1_zfmisc_1(k2_zfmisc_1(A,B)))
     => v1_relat_1(C) ) ).

fof(d1_relset_1,axiom,
    ! [A,B,C] :
      ( m1_relset_1(C,A,B)
    <=> r1_tarski(C,k2_zfmisc_1(A,B)) ) ).

fof(t1_relset_1,axiom,
    $true ).

fof(t2_relset_1,axiom,
    $true ).

fof(t3_relset_1,axiom,
    $true ).

fof(t4_relset_1,axiom,
    ! [A,B,C,D] :
      ( m2_relset_1(D,B,C)
     => ( r1_tarski(A,D)
       => m2_relset_1(A,B,C) ) ) ).

fof(t5_relset_1,axiom,
    $true ).

fof(t6_relset_1,axiom,
    ! [A,B,C,D] :
      ( m2_relset_1(D,A,B)
     => ~ ( r2_hidden(C,D)
          & ! [E,F] :
              ~ ( C = k4_tarski(E,F)
                & r2_hidden(E,A)
                & r2_hidden(F,B) ) ) ) ).

fof(t7_relset_1,axiom,
    $true ).

fof(t8_relset_1,axiom,
    ! [A,B,C,D] :
      ( ( r2_hidden(C,A)
        & r2_hidden(D,B) )
     => m2_relset_1(k1_tarski(k4_tarski(C,D)),A,B) ) ).

fof(t9_relset_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r1_tarski(k1_relat_1(B),A)
       => m2_relset_1(B,A,k2_relat_1(B)) ) ) ).

fof(t10_relset_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r1_tarski(k2_relat_1(B),A)
       => m2_relset_1(B,k1_relat_1(B),A) ) ) ).

fof(t11_relset_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( ( r1_tarski(k1_relat_1(C),A)
          & r1_tarski(k2_relat_1(C),B) )
       => m2_relset_1(C,A,B) ) ) ).

fof(t12_relset_1,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,A,B)
     => ( r1_tarski(k1_relat_1(C),A)
        & r1_tarski(k2_relat_1(C),B) ) ) ).

fof(t13_relset_1,axiom,
    ! [A,B,C,D] :
      ( m2_relset_1(D,A,C)
     => ( r1_tarski(k1_relat_1(D),B)
       => m2_relset_1(D,B,C) ) ) ).

fof(t14_relset_1,axiom,
    ! [A,B,C,D] :
      ( m2_relset_1(D,C,A)
     => ( r1_tarski(k2_relat_1(D),B)
       => m2_relset_1(D,C,B) ) ) ).

fof(t15_relset_1,axiom,
    ! [A,B,C,D] :
      ( m2_relset_1(D,A,C)
     => ( r1_tarski(A,B)
       => m2_relset_1(D,B,C) ) ) ).

fof(t16_relset_1,axiom,
    ! [A,B,C,D] :
      ( m2_relset_1(D,C,A)
     => ( r1_tarski(A,B)
       => m2_relset_1(D,C,B) ) ) ).

fof(t17_relset_1,axiom,
    ! [A,B,C,D,E] :
      ( m2_relset_1(E,A,C)
     => ( ( r1_tarski(A,B)
          & r1_tarski(C,D) )
       => m2_relset_1(E,B,D) ) ) ).

fof(t18_relset_1,axiom,
    $true ).

fof(t19_relset_1,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,A,B)
     => r1_tarski(k3_relat_1(C),k2_xboole_0(A,B)) ) ).

fof(t20_relset_1,axiom,
    $true ).

fof(t21_relset_1,axiom,
    $true ).

fof(t22_relset_1,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,B,A)
     => ( ! [D] :
            ~ ( r2_hidden(D,B)
              & ! [E] : ~ r2_hidden(k4_tarski(D,E),C) )
      <=> k4_relset_1(B,A,C) = B ) ) ).

fof(t23_relset_1,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,A,B)
     => ( ! [D] :
            ~ ( r2_hidden(D,B)
              & ! [E] : ~ r2_hidden(k4_tarski(E,D),C) )
      <=> k5_relset_1(A,B,C) = B ) ) ).

fof(t24_relset_1,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,A,B)
     => ( k4_relset_1(B,A,k6_relset_1(A,B,C)) = k5_relset_1(A,B,C)
        & k5_relset_1(B,A,k6_relset_1(A,B,C)) = k4_relset_1(A,B,C) ) ) ).

fof(t25_relset_1,axiom,
    ! [A,B] : m2_relset_1(k1_xboole_0,A,B) ).

fof(t26_relset_1,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,A,B)
     => ( m2_relset_1(C,k1_xboole_0,B)
       => C = k1_xboole_0 ) ) ).

fof(t27_relset_1,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,B,A)
     => ( m2_relset_1(C,B,k1_xboole_0)
       => C = k1_xboole_0 ) ) ).

fof(t28_relset_1,axiom,
    ! [A] : r1_tarski(k6_relat_1(A),k2_zfmisc_1(A,A)) ).

fof(t29_relset_1,axiom,
    ! [A] : m2_relset_1(k6_relat_1(A),A,A) ).

fof(t30_relset_1,axiom,
    ! [A,B,C,D] :
      ( m2_relset_1(D,A,B)
     => ( r1_tarski(k6_relat_1(C),D)
       => ( r1_tarski(C,k4_relset_1(A,B,D))
          & r1_tarski(C,k5_relset_1(A,B,D)) ) ) ) ).

fof(t31_relset_1,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,B,A)
     => ( r1_tarski(k6_relat_1(B),C)
       => ( B = k4_relset_1(B,A,C)
          & r1_tarski(B,k5_relset_1(B,A,C)) ) ) ) ).

fof(t32_relset_1,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,A,B)
     => ( r1_tarski(k6_relat_1(B),C)
       => ( r1_tarski(B,k4_relset_1(A,B,C))
          & B = k5_relset_1(A,B,C) ) ) ) ).

fof(t33_relset_1,axiom,
    ! [A,B,C,D] :
      ( m2_relset_1(D,A,C)
     => m2_relset_1(k8_relset_1(A,C,D,B),B,C) ) ).

fof(t34_relset_1,axiom,
    ! [A,B,C,D] :
      ( m2_relset_1(D,B,A)
     => ( r1_tarski(B,C)
       => k8_relset_1(B,A,D,C) = D ) ) ).

fof(t35_relset_1,axiom,
    ! [A,B,C,D] :
      ( m2_relset_1(D,C,A)
     => m2_relset_1(k9_relset_1(C,A,B,D),C,B) ) ).

fof(t36_relset_1,axiom,
    ! [A,B,C,D] :
      ( m2_relset_1(D,A,B)
     => ( r1_tarski(B,C)
       => k9_relset_1(A,B,C,D) = D ) ) ).

fof(t37_relset_1,axiom,
    $true ).

fof(t38_relset_1,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,A,B)
     => ( k10_relset_1(A,B,C,A) = k5_relset_1(A,B,C)
        & k11_relset_1(A,B,C,B) = k4_relset_1(A,B,C) ) ) ).

fof(t39_relset_1,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,B,A)
     => ( k10_relset_1(B,A,C,k11_relset_1(B,A,C,A)) = k5_relset_1(B,A,C)
        & k11_relset_1(B,A,C,k10_relset_1(B,A,C,B)) = k4_relset_1(B,A,C) ) ) ).

fof(t40_relset_1,axiom,
    $true ).

fof(t41_relset_1,axiom,
    $true ).

fof(t42_relset_1,axiom,
    $true ).

fof(t43_relset_1,axiom,
    $true ).

fof(t44_relset_1,axiom,
    $true ).

fof(t45_relset_1,axiom,
    ! [A,B] :
      ( m2_relset_1(B,A,A)
     => ( k5_relat_1(B,k6_relat_1(A)) = B
        & k5_relat_1(k6_relat_1(A),B) = B ) ) ).

fof(t46_relset_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => k6_relat_1(A) != k1_xboole_0 ) ).

fof(t47_relset_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( m2_relset_1(C,A,B)
             => ! [D] :
                  ( m1_subset_1(D,A)
                 => ( r2_hidden(D,k4_relset_1(A,B,C))
                  <=> ? [E] :
                        ( m1_subset_1(E,B)
                        & r2_hidden(k4_tarski(D,E),C) ) ) ) ) ) ) ).

fof(t48_relset_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( m2_relset_1(C,B,A)
             => ! [D] :
                  ( m1_subset_1(D,A)
                 => ( r2_hidden(D,k5_relset_1(B,A,C))
                  <=> ? [E] :
                        ( m1_subset_1(E,B)
                        & r2_hidden(k4_tarski(E,D),C) ) ) ) ) ) ) ).

fof(t49_relset_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( m2_relset_1(C,A,B)
             => ! [D] :
                  ( m1_subset_1(D,A)
                 => ~ ( r2_hidden(D,k4_relset_1(A,B,C))
                      & ! [E] :
                          ( m1_subset_1(E,B)
                         => ~ r2_hidden(E,k5_relset_1(A,B,C)) ) ) ) ) ) ) ).

fof(t50_relset_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( m2_relset_1(C,B,A)
             => ! [D] :
                  ( m1_subset_1(D,A)
                 => ~ ( r2_hidden(D,k5_relset_1(B,A,C))
                      & ! [E] :
                          ( m1_subset_1(E,B)
                         => ~ r2_hidden(E,k4_relset_1(B,A,C)) ) ) ) ) ) ) ).

fof(t51_relset_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( m2_relset_1(D,A,B)
                 => ! [E] :
                      ( m2_relset_1(E,B,C)
                     => ! [F] :
                          ( m1_subset_1(F,A)
                         => ! [G] :
                              ( m1_subset_1(G,C)
                             => ( r2_hidden(k4_tarski(F,G),k7_relset_1(A,B,B,C,D,E))
                              <=> ? [H] :
                                    ( m1_subset_1(H,B)
                                    & r2_hidden(k4_tarski(F,H),D)
                                    & r2_hidden(k4_tarski(H,G),E) ) ) ) ) ) ) ) ) ) ).

fof(t52_relset_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( m2_relset_1(D,C,A)
                 => ! [E] :
                      ( m1_subset_1(E,A)
                     => ( r2_hidden(E,k10_relset_1(C,A,D,B))
                      <=> ? [F] :
                            ( m1_subset_1(F,C)
                            & r2_hidden(k4_tarski(F,E),D)
                            & r2_hidden(F,B) ) ) ) ) ) ) ) ).

fof(t53_relset_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( m2_relset_1(D,A,C)
                 => ! [E] :
                      ( m1_subset_1(E,A)
                     => ( r2_hidden(E,k11_relset_1(A,C,D,B))
                      <=> ? [F] :
                            ( m1_subset_1(F,C)
                            & r2_hidden(k4_tarski(E,F),D)
                            & r2_hidden(F,B) ) ) ) ) ) ) ) ).

fof(s1_relset_1,axiom,
    ? [A] :
      ( m2_relset_1(A,f1_s1_relset_1,f2_s1_relset_1)
      & ! [B,C] :
          ( r2_hidden(k4_tarski(B,C),A)
        <=> ( r2_hidden(B,f1_s1_relset_1)
            & r2_hidden(C,f2_s1_relset_1)
            & p1_s1_relset_1(B,C) ) ) ) ).

fof(s2_relset_1,axiom,
    ? [A] :
      ( m2_relset_1(A,f1_s2_relset_1,f2_s2_relset_1)
      & ! [B] :
          ( m1_subset_1(B,f1_s2_relset_1)
         => ! [C] :
              ( m1_subset_1(C,f2_s2_relset_1)
             => ( r2_hidden(k4_tarski(B,C),A)
              <=> p1_s2_relset_1(B,C) ) ) ) ) ).

fof(dt_m1_relset_1,axiom,
    $true ).

fof(existence_m1_relset_1,axiom,
    ! [A,B] :
    ? [C] : m1_relset_1(C,A,B) ).

fof(dt_m2_relset_1,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,A,B)
     => m1_subset_1(C,k1_zfmisc_1(k2_zfmisc_1(A,B))) ) ).

fof(existence_m2_relset_1,axiom,
    ! [A,B] :
    ? [C] : m2_relset_1(C,A,B) ).

fof(redefinition_m2_relset_1,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,A,B)
    <=> m1_relset_1(C,A,B) ) ).

fof(dt_k1_relset_1,axiom,
    ! [A,B,C,D] :
      ( ( m1_relset_1(C,A,B)
        & m1_relset_1(D,A,B) )
     => m2_relset_1(k1_relset_1(A,B,C,D),A,B) ) ).

fof(commutativity_k1_relset_1,axiom,
    ! [A,B,C,D] :
      ( ( m1_relset_1(C,A,B)
        & m1_relset_1(D,A,B) )
     => k1_relset_1(A,B,C,D) = k1_relset_1(A,B,D,C) ) ).

fof(idempotence_k1_relset_1,axiom,
    ! [A,B,C,D] :
      ( ( m1_relset_1(C,A,B)
        & m1_relset_1(D,A,B) )
     => k1_relset_1(A,B,C,C) = C ) ).

fof(redefinition_k1_relset_1,axiom,
    ! [A,B,C,D] :
      ( ( m1_relset_1(C,A,B)
        & m1_relset_1(D,A,B) )
     => k1_relset_1(A,B,C,D) = k2_xboole_0(C,D) ) ).

fof(dt_k2_relset_1,axiom,
    ! [A,B,C,D] :
      ( ( m1_relset_1(C,A,B)
        & m1_relset_1(D,A,B) )
     => m2_relset_1(k2_relset_1(A,B,C,D),A,B) ) ).

fof(commutativity_k2_relset_1,axiom,
    ! [A,B,C,D] :
      ( ( m1_relset_1(C,A,B)
        & m1_relset_1(D,A,B) )
     => k2_relset_1(A,B,C,D) = k2_relset_1(A,B,D,C) ) ).

fof(idempotence_k2_relset_1,axiom,
    ! [A,B,C,D] :
      ( ( m1_relset_1(C,A,B)
        & m1_relset_1(D,A,B) )
     => k2_relset_1(A,B,C,C) = C ) ).

fof(redefinition_k2_relset_1,axiom,
    ! [A,B,C,D] :
      ( ( m1_relset_1(C,A,B)
        & m1_relset_1(D,A,B) )
     => k2_relset_1(A,B,C,D) = k3_xboole_0(C,D) ) ).

fof(dt_k3_relset_1,axiom,
    ! [A,B,C,D] :
      ( ( m1_relset_1(C,A,B)
        & m1_relset_1(D,A,B) )
     => m2_relset_1(k3_relset_1(A,B,C,D),A,B) ) ).

fof(redefinition_k3_relset_1,axiom,
    ! [A,B,C,D] :
      ( ( m1_relset_1(C,A,B)
        & m1_relset_1(D,A,B) )
     => k3_relset_1(A,B,C,D) = k4_xboole_0(C,D) ) ).

fof(dt_k4_relset_1,axiom,
    ! [A,B,C] :
      ( m1_relset_1(C,A,B)
     => m1_subset_1(k4_relset_1(A,B,C),k1_zfmisc_1(A)) ) ).

fof(redefinition_k4_relset_1,axiom,
    ! [A,B,C] :
      ( m1_relset_1(C,A,B)
     => k4_relset_1(A,B,C) = k1_relat_1(C) ) ).

fof(dt_k5_relset_1,axiom,
    ! [A,B,C] :
      ( m1_relset_1(C,A,B)
     => m1_subset_1(k5_relset_1(A,B,C),k1_zfmisc_1(B)) ) ).

fof(redefinition_k5_relset_1,axiom,
    ! [A,B,C] :
      ( m1_relset_1(C,A,B)
     => k5_relset_1(A,B,C) = k2_relat_1(C) ) ).

fof(dt_k6_relset_1,axiom,
    ! [A,B,C] :
      ( m1_relset_1(C,A,B)
     => m2_relset_1(k6_relset_1(A,B,C),B,A) ) ).

fof(involutiveness_k6_relset_1,axiom,
    ! [A,B,C] :
      ( m1_relset_1(C,A,B)
     => k6_relset_1(A,B,k6_relset_1(A,B,C)) = C ) ).

fof(redefinition_k6_relset_1,axiom,
    ! [A,B,C] :
      ( m1_relset_1(C,A,B)
     => k6_relset_1(A,B,C) = k4_relat_1(C) ) ).

fof(dt_k7_relset_1,axiom,
    ! [A,B,C,D,E,F] :
      ( ( m1_relset_1(E,A,B)
        & m1_relset_1(F,C,D) )
     => m2_relset_1(k7_relset_1(A,B,C,D,E,F),A,D) ) ).

fof(redefinition_k7_relset_1,axiom,
    ! [A,B,C,D,E,F] :
      ( ( m1_relset_1(E,A,B)
        & m1_relset_1(F,C,D) )
     => k7_relset_1(A,B,C,D,E,F) = k5_relat_1(E,F) ) ).

fof(dt_k8_relset_1,axiom,
    ! [A,B,C,D] :
      ( m1_relset_1(C,A,B)
     => m2_relset_1(k8_relset_1(A,B,C,D),A,B) ) ).

fof(redefinition_k8_relset_1,axiom,
    ! [A,B,C,D] :
      ( m1_relset_1(C,A,B)
     => k8_relset_1(A,B,C,D) = k7_relat_1(C,D) ) ).

fof(dt_k9_relset_1,axiom,
    ! [A,B,C,D] :
      ( m1_relset_1(D,A,B)
     => m2_relset_1(k9_relset_1(A,B,C,D),A,B) ) ).

fof(redefinition_k9_relset_1,axiom,
    ! [A,B,C,D] :
      ( m1_relset_1(D,A,B)
     => k9_relset_1(A,B,C,D) = k8_relat_1(C,D) ) ).

fof(dt_k10_relset_1,axiom,
    ! [A,B,C,D] :
      ( m1_relset_1(C,A,B)
     => m1_subset_1(k10_relset_1(A,B,C,D),k1_zfmisc_1(B)) ) ).

fof(redefinition_k10_relset_1,axiom,
    ! [A,B,C,D] :
      ( m1_relset_1(C,A,B)
     => k10_relset_1(A,B,C,D) = k9_relat_1(C,D) ) ).

fof(dt_k11_relset_1,axiom,
    ! [A,B,C,D] :
      ( m1_relset_1(C,A,B)
     => m1_subset_1(k11_relset_1(A,B,C,D),k1_zfmisc_1(A)) ) ).

fof(redefinition_k11_relset_1,axiom,
    ! [A,B,C,D] :
      ( m1_relset_1(C,A,B)
     => k11_relset_1(A,B,C,D) = k10_relat_1(C,D) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(rc1_partfun1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A)
      & v2_funct_1(A)
      & v1_xboole_0(A) ) ).

fof(rc2_partfun1,axiom,
    ! [A,B] :
    ? [C] :
      ( m1_relset_1(C,A,B)
      & v1_relat_1(C)
      & v1_funct_1(C) ) ).

fof(fc1_partfun1,axiom,
    ! [A,B] : ~ v1_xboole_0(k4_partfun1(A,B)) ).

fof(rc3_partfun1,axiom,
    ! [A] :
    ? [B] :
      ( m1_relset_1(B,A,A)
      & v1_relat_1(B)
      & v1_relat_2(B)
      & v3_relat_2(B)
      & v4_relat_2(B)
      & v8_relat_2(B)
      & v1_partfun1(B,A,A) ) ).

fof(cc1_partfun1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v3_relat_2(A)
        & v8_relat_2(A) )
     => ( v1_relat_1(A)
        & v1_relat_2(A) ) ) ).

fof(fc2_partfun1,axiom,
    ! [A] :
      ( v1_relat_1(k6_relat_1(A))
      & v1_funct_1(k6_relat_1(A))
      & v1_relat_2(k6_relat_1(A))
      & v3_relat_2(k6_relat_1(A))
      & v4_relat_2(k6_relat_1(A))
      & v8_relat_2(k6_relat_1(A)) ) ).

fof(t1_partfun1,axiom,
    ! [A,B,C,D,E,F] :
      ( ( r1_tarski(A,k2_zfmisc_1(B,C))
        & r1_tarski(D,k2_zfmisc_1(E,F)) )
     => r1_tarski(k2_xboole_0(A,D),k2_zfmisc_1(k2_xboole_0(B,E),k2_xboole_0(C,F))) ) ).

fof(t2_partfun1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ~ ( ! [C] :
                  ( r2_hidden(C,k3_xboole_0(k1_relat_1(A),k1_relat_1(B)))
                 => k1_funct_1(A,C) = k1_funct_1(B,C) )
              & ! [C] :
                  ( ( v1_relat_1(C)
                    & v1_funct_1(C) )
                 => k2_xboole_0(A,B) != C ) ) ) ) ).

fof(t3_partfun1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( k2_xboole_0(A,B) = C
               => ! [D] :
                    ( r2_hidden(D,k3_xboole_0(k1_relat_1(A),k1_relat_1(B)))
                   => k1_funct_1(A,D) = k1_funct_1(B,D) ) ) ) ) ) ).

fof(t4_partfun1,axiom,
    $true ).

fof(t5_partfun1,axiom,
    $true ).

fof(t6_partfun1,axiom,
    $true ).

fof(t7_partfun1,axiom,
    $true ).

fof(t8_partfun1,axiom,
    $true ).

fof(t9_partfun1,axiom,
    $true ).

fof(t10_partfun1,axiom,
    k2_relat_1(k1_xboole_0) = k1_xboole_0 ).

fof(t11_partfun1,axiom,
    $true ).

fof(t12_partfun1,axiom,
    $true ).

fof(t13_partfun1,axiom,
    $true ).

fof(t14_partfun1,axiom,
    $true ).

fof(t15_partfun1,axiom,
    $true ).

fof(t16_partfun1,axiom,
    $true ).

fof(t17_partfun1,axiom,
    $true ).

fof(t18_partfun1,axiom,
    $true ).

fof(t19_partfun1,axiom,
    $true ).

fof(t20_partfun1,axiom,
    $true ).

fof(t21_partfun1,axiom,
    $true ).

fof(t22_partfun1,axiom,
    $true ).

fof(t23_partfun1,axiom,
    $true ).

fof(t24_partfun1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v1_funct_1(A)
        & m2_relset_1(A,k1_relat_1(A),k2_relat_1(A)) ) ) ).

fof(t25_partfun1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( r1_tarski(k2_relat_1(B),A)
       => ( v1_funct_1(B)
          & m2_relset_1(B,k1_relat_1(B),A) ) ) ) ).

fof(t26_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & m2_relset_1(D,A,B) )
     => ~ ( r2_hidden(C,k2_relat_1(D))
          & ! [E] :
              ( m1_subset_1(E,A)
             => ~ ( r2_hidden(E,k4_relset_1(A,B,D))
                  & C = k1_funct_1(D,E) ) ) ) ) ).

fof(t27_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & m2_relset_1(D,A,B) )
     => ( r2_hidden(C,k4_relset_1(A,B,D))
       => r2_hidden(k1_funct_1(D,C),B) ) ) ).

fof(t28_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & m2_relset_1(D,A,B) )
     => ( r1_tarski(k4_relset_1(A,B,D),C)
       => ( v1_funct_1(D)
          & m2_relset_1(D,C,B) ) ) ) ).

fof(t29_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & m2_relset_1(D,A,B) )
     => ( r1_tarski(k2_relat_1(D),C)
       => ( v1_funct_1(D)
          & m2_relset_1(D,A,C) ) ) ) ).

fof(t30_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & m2_relset_1(D,A,B) )
     => ( r1_tarski(A,C)
       => ( v1_funct_1(D)
          & m2_relset_1(D,C,B) ) ) ) ).

fof(t31_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & m2_relset_1(D,A,B) )
     => ( r1_tarski(B,C)
       => ( v1_funct_1(D)
          & m2_relset_1(D,A,C) ) ) ) ).

fof(t32_partfun1,axiom,
    ! [A,B,C,D,E] :
      ( ( v1_funct_1(E)
        & m2_relset_1(E,A,B) )
     => ( ( r1_tarski(A,C)
          & r1_tarski(B,D) )
       => ( v1_funct_1(E)
          & m2_relset_1(E,C,D) ) ) ) ).

fof(t33_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,B) )
         => ( r1_tarski(C,D)
           => ( v1_funct_1(C)
              & m2_relset_1(C,A,B) ) ) ) ) ).

fof(t34_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,B) )
         => ( ( k4_relset_1(A,B,C) = k4_relset_1(A,B,D)
              & ! [E] :
                  ( m1_subset_1(E,A)
                 => ( r2_hidden(E,k4_relset_1(A,B,C))
                   => k1_funct_1(C,E) = k1_funct_1(D,E) ) ) )
           => C = D ) ) ) ).

fof(t35_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & m2_relset_1(D,k2_zfmisc_1(A,B),C) )
     => ! [E] :
          ( ( v1_funct_1(E)
            & m2_relset_1(E,k2_zfmisc_1(A,B),C) )
         => ( ( k4_relset_1(k2_zfmisc_1(A,B),C,D) = k4_relset_1(k2_zfmisc_1(A,B),C,E)
              & ! [F,G] :
                  ( r2_hidden(k4_tarski(F,G),k4_relset_1(k2_zfmisc_1(A,B),C,D))
                 => k1_funct_1(D,k4_tarski(F,G)) = k1_funct_1(E,k4_tarski(F,G)) ) )
           => D = E ) ) ) ).

fof(t36_partfun1,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,A,B)
     => k5_relat_1(k6_relat_1(A),C) = C ) ).

fof(t37_partfun1,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,A,B)
     => k5_relat_1(C,k6_relat_1(B)) = C ) ).

fof(t38_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ( ! [D] :
            ( m1_subset_1(D,A)
           => ! [E] :
                ( m1_subset_1(E,A)
               => ( ( r2_hidden(D,k4_relset_1(A,B,C))
                    & r2_hidden(E,k4_relset_1(A,B,C))
                    & k1_funct_1(C,D) = k1_funct_1(C,E) )
                 => D = E ) ) )
       => v2_funct_1(C) ) ) ).

fof(t39_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ( v2_funct_1(C)
       => ( v1_funct_1(k2_funct_1(C))
          & m2_relset_1(k2_funct_1(C),B,A) ) ) ) ).

fof(t40_partfun1,axiom,
    $true ).

fof(t41_partfun1,axiom,
    $true ).

fof(t42_partfun1,axiom,
    $true ).

fof(t43_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & m2_relset_1(D,A,B) )
     => ( v1_funct_1(k8_relset_1(A,B,D,C))
        & m2_relset_1(k8_relset_1(A,B,D,C),C,B) ) ) ).

fof(t44_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & m2_relset_1(D,A,B) )
     => ( v1_funct_1(k8_relset_1(A,B,D,C))
        & m2_relset_1(k8_relset_1(A,B,D,C),A,B) ) ) ).

fof(t45_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & m2_relset_1(D,A,B) )
     => ( v1_funct_1(k9_relset_1(A,B,C,D))
        & m2_relset_1(k9_relset_1(A,B,C,D),A,C) ) ) ).

fof(t46_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & m2_relset_1(D,A,B) )
     => ( v1_funct_1(k9_relset_1(A,B,C,D))
        & m2_relset_1(k9_relset_1(A,B,C,D),A,B) ) ) ).

fof(t47_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( v1_funct_1(k7_relat_1(k8_relat_1(A,C),B))
        & m2_relset_1(k7_relat_1(k8_relat_1(A,C),B),B,A) ) ) ).

fof(t48_partfun1,axiom,
    $true ).

fof(t49_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & m2_relset_1(D,A,B) )
     => ~ ( r2_hidden(C,k9_relat_1(D,A))
          & ! [E] :
              ( m1_subset_1(E,A)
             => ~ ( r2_hidden(E,k4_relset_1(A,B,D))
                  & C = k1_funct_1(D,E) ) ) ) ) ).

fof(t50_partfun1,axiom,
    $true ).

fof(t51_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => k9_relat_1(C,A) = k2_relat_1(C) ) ).

fof(t52_partfun1,axiom,
    $true ).

fof(t53_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => k10_relat_1(C,B) = k4_relset_1(A,B,C) ) ).

fof(t54_partfun1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & m2_relset_1(B,k1_xboole_0,A) )
     => ( k4_relset_1(k1_xboole_0,A,B) = k1_xboole_0
        & k2_relat_1(B) = k1_xboole_0 ) ) ).

fof(t55_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( k1_relat_1(C) = k1_xboole_0
       => ( v1_funct_1(C)
          & m2_relset_1(C,A,B) ) ) ) ).

fof(t56_partfun1,axiom,
    ! [A,B] :
      ( v1_funct_1(k1_xboole_0)
      & m2_relset_1(k1_xboole_0,A,B) ) ).

fof(t57_partfun1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & m2_relset_1(B,k1_xboole_0,A) )
     => B = k1_xboole_0 ) ).

fof(t58_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,k1_xboole_0,A) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,k1_xboole_0,B) )
         => C = D ) ) ).

fof(t59_partfun1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & m2_relset_1(B,k1_xboole_0,A) )
     => v2_funct_1(B) ) ).

fof(t60_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,k1_xboole_0,A) )
     => k9_relat_1(C,B) = k1_xboole_0 ) ).

fof(t61_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,k1_xboole_0,A) )
     => k10_relat_1(C,B) = k1_xboole_0 ) ).

fof(t62_partfun1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & m2_relset_1(B,A,k1_xboole_0) )
     => ( k4_relset_1(A,k1_xboole_0,B) = k1_xboole_0
        & k2_relat_1(B) = k1_xboole_0 ) ) ).

fof(t63_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( k2_relat_1(C) = k1_xboole_0
       => ( v1_funct_1(C)
          & m2_relset_1(C,A,B) ) ) ) ).

fof(t64_partfun1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & m2_relset_1(B,A,k1_xboole_0) )
     => B = k1_xboole_0 ) ).

fof(t65_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,k1_xboole_0) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,B,k1_xboole_0) )
         => C = D ) ) ).

fof(t66_partfun1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & m2_relset_1(B,A,k1_xboole_0) )
     => v2_funct_1(B) ) ).

fof(t67_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,k1_xboole_0) )
     => k9_relat_1(C,B) = k1_xboole_0 ) ).

fof(t68_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,k1_xboole_0) )
     => k10_relat_1(C,B) = k1_xboole_0 ) ).

fof(t69_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,k1_tarski(A),B) )
     => r1_tarski(k2_relat_1(C),k1_tarski(k1_funct_1(C,A))) ) ).

fof(t70_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,k1_tarski(A),B) )
     => v2_funct_1(C) ) ).

fof(t71_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & m2_relset_1(D,k1_tarski(A),B) )
     => r1_tarski(k9_relat_1(D,C),k1_tarski(k1_funct_1(D,A))) ) ).

fof(t72_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_relat_1(D)
        & v1_funct_1(D) )
     => ( ( k1_relat_1(D) = k1_tarski(A)
          & r2_hidden(A,B)
          & r2_hidden(k1_funct_1(D,A),C) )
       => ( v1_funct_1(D)
          & m2_relset_1(D,B,C) ) ) ) ).

fof(t73_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & m2_relset_1(D,A,k1_tarski(B)) )
     => ( r2_hidden(C,k4_relset_1(A,k1_tarski(B),D))
       => k1_funct_1(D,C) = B ) ) ).

fof(t74_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,k1_tarski(B)) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,k1_tarski(B)) )
         => ( k4_relset_1(A,k1_tarski(B),C) = k4_relset_1(A,k1_tarski(B),D)
           => C = D ) ) ) ).

fof(d1_partfun1,axiom,
    $true ).

fof(d2_partfun1,axiom,
    $true ).

fof(d3_partfun1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B,C] : k3_partfun1(A,B,C) = k7_relat_1(k8_relat_1(C,A),B) ) ).

fof(t75_partfun1,axiom,
    $true ).

fof(t76_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => r1_tarski(k3_partfun1(C,A,B),C) ) ).

fof(t77_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r1_tarski(k4_relset_1(A,B,k3_partfun1(C,A,B)),k1_relat_1(C))
        & r1_tarski(k2_relat_1(k3_partfun1(C,A,B)),k2_relat_1(C)) ) ) ).

fof(t78_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_relat_1(D)
        & v1_funct_1(D) )
     => ( r2_hidden(A,k4_relset_1(B,C,k3_partfun1(D,B,C)))
      <=> ( r2_hidden(A,k1_relat_1(D))
          & r2_hidden(A,B)
          & r2_hidden(k1_funct_1(D,A),C) ) ) ) ).

fof(t79_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_relat_1(D)
        & v1_funct_1(D) )
     => ( ( r2_hidden(A,k1_relat_1(D))
          & r2_hidden(A,B)
          & r2_hidden(k1_funct_1(D,A),C) )
       => k1_funct_1(k3_partfun1(D,B,C),A) = k1_funct_1(D,A) ) ) ).

fof(t80_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_relat_1(D)
        & v1_funct_1(D) )
     => ( r2_hidden(A,k4_relset_1(B,C,k3_partfun1(D,B,C)))
       => k1_funct_1(k3_partfun1(D,B,C),A) = k1_funct_1(D,A) ) ) ).

fof(t81_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ! [D] :
          ( ( v1_relat_1(D)
            & v1_funct_1(D) )
         => ( r1_tarski(C,D)
           => r1_tarski(k3_partfun1(C,A,B),k3_partfun1(D,A,B)) ) ) ) ).

fof(t82_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_relat_1(D)
        & v1_funct_1(D) )
     => ( r1_tarski(A,B)
       => r1_tarski(k3_partfun1(D,A,C),k3_partfun1(D,B,C)) ) ) ).

fof(t83_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_relat_1(D)
        & v1_funct_1(D) )
     => ( r1_tarski(A,B)
       => r1_tarski(k3_partfun1(D,C,A),k3_partfun1(D,C,B)) ) ) ).

fof(t84_partfun1,axiom,
    ! [A,B,C,D,E] :
      ( ( v1_relat_1(E)
        & v1_funct_1(E) )
     => ( ( r1_tarski(A,B)
          & r1_tarski(C,D) )
       => r1_tarski(k3_partfun1(E,A,C),k3_partfun1(E,B,D)) ) ) ).

fof(t85_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( ( r1_tarski(k1_relat_1(C),A)
          & r1_tarski(k2_relat_1(C),B) )
       => C = k3_partfun1(C,A,B) ) ) ).

fof(t86_partfun1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => A = k3_partfun1(A,k1_relat_1(A),k2_relat_1(A)) ) ).

fof(t87_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => k3_partfun1(C,A,B) = C ) ).

fof(t88_partfun1,axiom,
    $true ).

fof(t89_partfun1,axiom,
    $true ).

fof(t90_partfun1,axiom,
    $true ).

fof(t91_partfun1,axiom,
    ! [A,B] : k3_partfun1(k1_xboole_0,A,B) = k1_xboole_0 ).

fof(t92_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_relat_1(D)
        & v1_funct_1(D) )
     => ! [E] :
          ( ( v1_relat_1(E)
            & v1_funct_1(E) )
         => r1_tarski(k1_partfun1(C,A,A,B,k3_partfun1(D,C,A),k3_partfun1(E,A,B)),k3_partfun1(k5_relat_1(D,E),C,B)) ) ) ).

fof(t93_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_relat_1(D)
        & v1_funct_1(D) )
     => ! [E] :
          ( ( v1_relat_1(E)
            & v1_funct_1(E) )
         => ( r1_tarski(k3_xboole_0(k2_relat_1(D),k1_relat_1(E)),A)
           => k1_partfun1(C,A,A,B,k3_partfun1(D,C,A),k3_partfun1(E,A,B)) = k3_partfun1(k5_relat_1(D,E),C,B) ) ) ) ).

fof(t94_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( v2_funct_1(C)
       => v2_funct_1(k3_partfun1(C,A,B)) ) ) ).

fof(t95_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( v2_funct_1(C)
       => k2_funct_1(k3_partfun1(C,A,B)) = k3_partfun1(k2_funct_1(C),B,A) ) ) ).

fof(t96_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_relat_1(D)
        & v1_funct_1(D) )
     => k2_partfun1(A,B,k3_partfun1(D,A,B),C) = k3_partfun1(D,k3_xboole_0(A,C),B) ) ).

fof(t97_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_relat_1(D)
        & v1_funct_1(D) )
     => k9_relset_1(B,C,A,k3_partfun1(D,B,C)) = k3_partfun1(D,B,k3_xboole_0(A,C)) ) ).

fof(d4_partfun1,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,A,B)
     => ( v1_partfun1(C,A,B)
      <=> k4_relset_1(A,B,C) = A ) ) ).

fof(t98_partfun1,axiom,
    $true ).

fof(t99_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ( ( v1_partfun1(C,A,B)
          & B = k1_xboole_0 )
       => A = k1_xboole_0 ) ) ).

fof(t100_partfun1,axiom,
    $true ).

fof(t101_partfun1,axiom,
    $true ).

fof(t102_partfun1,axiom,
    $true ).

fof(t103_partfun1,axiom,
    $true ).

fof(t104_partfun1,axiom,
    $true ).

fof(t105_partfun1,axiom,
    $true ).

fof(t106_partfun1,axiom,
    $true ).

fof(t107_partfun1,axiom,
    $true ).

fof(t108_partfun1,axiom,
    $true ).

fof(t109_partfun1,axiom,
    $true ).

fof(t110_partfun1,axiom,
    $true ).

fof(t111_partfun1,axiom,
    $true ).

fof(t112_partfun1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & m2_relset_1(B,k1_xboole_0,A) )
     => v1_partfun1(B,k1_xboole_0,A) ) ).

fof(t113_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( v1_partfun1(k3_partfun1(C,A,B),A,B)
       => r1_tarski(A,k1_relat_1(C)) ) ) ).

fof(t114_partfun1,axiom,
    ! [A,B] :
      ( v1_partfun1(k3_partfun1(k1_xboole_0,A,B),A,B)
     => A = k1_xboole_0 ) ).

fof(t115_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( ( r1_tarski(A,k1_relat_1(C))
          & r1_tarski(k2_relat_1(C),B) )
       => v1_partfun1(k3_partfun1(C,A,B),A,B) ) ) ).

fof(t116_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( v1_partfun1(k3_partfun1(C,A,B),A,B)
       => r1_tarski(k9_relat_1(C,A),B) ) ) ).

fof(t117_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( ( r1_tarski(A,k1_relat_1(C))
          & r1_tarski(k9_relat_1(C,A),B) )
       => v1_partfun1(k3_partfun1(C,A,B),A,B) ) ) ).

fof(d5_partfun1,axiom,
    ! [A,B,C] :
      ( C = k4_partfun1(A,B)
    <=> ! [D] :
          ( r2_hidden(D,C)
        <=> ? [E] :
              ( v1_relat_1(E)
              & v1_funct_1(E)
              & D = E
              & r1_tarski(k1_relat_1(E),A)
              & r1_tarski(k2_relat_1(E),B) ) ) ) ).

fof(t118_partfun1,axiom,
    $true ).

fof(t119_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => r2_hidden(C,k4_partfun1(A,B)) ) ).

fof(t120_partfun1,axiom,
    ! [A,B,C] :
      ( r2_hidden(C,k4_partfun1(A,B))
     => ( v1_funct_1(C)
        & m2_relset_1(C,A,B) ) ) ).

fof(t121_partfun1,axiom,
    ! [A,B,C] :
      ( m1_subset_1(C,k4_partfun1(A,B))
     => ( v1_funct_1(C)
        & m2_relset_1(C,A,B) ) ) ).

fof(t122_partfun1,axiom,
    ! [A] : k4_partfun1(k1_xboole_0,A) = k1_tarski(k1_xboole_0) ).

fof(t123_partfun1,axiom,
    ! [A] : k4_partfun1(A,k1_xboole_0) = k1_tarski(k1_xboole_0) ).

fof(t124_partfun1,axiom,
    $true ).

fof(t125_partfun1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,B)
     => r1_tarski(k4_partfun1(A,C),k4_partfun1(B,C)) ) ).

fof(t126_partfun1,axiom,
    ! [A,B] : r1_tarski(k4_partfun1(k1_xboole_0,A),k4_partfun1(B,A)) ).

fof(t127_partfun1,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,B)
     => r1_tarski(k4_partfun1(C,A),k4_partfun1(C,B)) ) ).

fof(t128_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( r1_tarski(A,B)
        & r1_tarski(C,D) )
     => r1_tarski(k4_partfun1(A,C),k4_partfun1(B,D)) ) ).

fof(d6_partfun1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_partfun1(A,B)
          <=> ! [C] :
                ( r2_hidden(C,k3_xboole_0(k1_relat_1(A),k1_relat_1(B)))
               => k1_funct_1(A,C) = k1_funct_1(B,C) ) ) ) ) ).

fof(t129_partfun1,axiom,
    $true ).

fof(t130_partfun1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_partfun1(A,B)
          <=> ? [C] :
                ( v1_relat_1(C)
                & v1_funct_1(C)
                & k2_xboole_0(A,B) = C ) ) ) ) ).

fof(t131_partfun1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_partfun1(A,B)
          <=> ? [C] :
                ( v1_relat_1(C)
                & v1_funct_1(C)
                & r1_tarski(A,C)
                & r1_tarski(B,C) ) ) ) ) ).

fof(t132_partfun1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_tarski(k1_relat_1(A),k1_relat_1(B))
           => ( r1_partfun1(A,B)
            <=> ! [C] :
                  ( r2_hidden(C,k1_relat_1(A))
                 => k1_funct_1(A,C) = k1_funct_1(B,C) ) ) ) ) ) ).

fof(t133_partfun1,axiom,
    $true ).

fof(t134_partfun1,axiom,
    $true ).

fof(t135_partfun1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_tarski(A,B)
           => r1_partfun1(A,B) ) ) ) ).

fof(t136_partfun1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( ( k1_relat_1(A) = k1_relat_1(B)
              & r1_partfun1(A,B) )
           => A = B ) ) ) ).

fof(t137_partfun1,axiom,
    $true ).

fof(t138_partfun1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_xboole_0(k1_relat_1(A),k1_relat_1(B))
           => r1_partfun1(A,B) ) ) ) ).

fof(t139_partfun1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( ( r1_tarski(A,C)
                  & r1_tarski(B,C) )
               => r1_partfun1(A,B) ) ) ) ) ).

fof(t140_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,B) )
         => ! [E] :
              ( ( v1_relat_1(E)
                & v1_funct_1(E) )
             => ( ( r1_partfun1(C,E)
                  & r1_tarski(D,C) )
               => r1_partfun1(D,E) ) ) ) ) ).

fof(t141_partfun1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => r1_partfun1(k1_xboole_0,A) ) ).

fof(t142_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => r1_partfun1(k3_partfun1(k1_xboole_0,A,B),C) ) ).

fof(t143_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,k1_tarski(B)) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,k1_tarski(B)) )
         => r1_partfun1(C,D) ) ) ).

fof(t144_partfun1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => r1_partfun1(k7_relat_1(B,A),B) ) ).

fof(t145_partfun1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => r1_partfun1(k8_relat_1(A,B),B) ) ).

fof(t146_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => r1_partfun1(k7_relat_1(k8_relat_1(A,C),B),C) ) ).

fof(t147_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => r1_partfun1(k3_partfun1(C,A,B),C) ) ).

fof(t148_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,B) )
         => ( ( v1_partfun1(C,A,B)
              & v1_partfun1(D,A,B)
              & r1_partfun1(C,D) )
           => C = D ) ) ) ).

fof(t149_partfun1,axiom,
    $true ).

fof(t150_partfun1,axiom,
    $true ).

fof(t151_partfun1,axiom,
    $true ).

fof(t152_partfun1,axiom,
    $true ).

fof(t153_partfun1,axiom,
    $true ).

fof(t154_partfun1,axiom,
    $true ).

fof(t155_partfun1,axiom,
    $true ).

fof(t156_partfun1,axiom,
    $true ).

fof(t157_partfun1,axiom,
    $true ).

fof(t158_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,B) )
         => ! [E] :
              ( ( v1_funct_1(E)
                & m2_relset_1(E,A,B) )
             => ( ( r1_partfun1(C,E)
                  & r1_partfun1(D,E)
                  & v1_partfun1(E,A,B) )
               => r1_partfun1(C,D) ) ) ) ) ).

fof(t159_partfun1,axiom,
    $true ).

fof(t160_partfun1,axiom,
    $true ).

fof(t161_partfun1,axiom,
    $true ).

fof(t162_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,B) )
         => ~ ( ( B = k1_xboole_0
               => A = k1_xboole_0 )
              & r1_partfun1(C,D)
              & ! [E] :
                  ( ( v1_funct_1(E)
                    & m2_relset_1(E,A,B) )
                 => ~ ( v1_partfun1(E,A,B)
                      & r1_partfun1(C,E)
                      & r1_partfun1(D,E) ) ) ) ) ) ).

fof(d7_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( D = k5_partfun1(A,B,C)
        <=> ! [E] :
              ( r2_hidden(E,D)
            <=> ? [F] :
                  ( v1_funct_1(F)
                  & m2_relset_1(F,A,B)
                  & F = E
                  & v1_partfun1(F,A,B)
                  & r1_partfun1(C,F) ) ) ) ) ).

fof(t163_partfun1,axiom,
    $true ).

fof(t164_partfun1,axiom,
    $true ).

fof(t165_partfun1,axiom,
    $true ).

fof(t166_partfun1,axiom,
    $true ).

fof(t167_partfun1,axiom,
    $true ).

fof(t168_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( r2_hidden(D,k5_partfun1(A,B,C))
         => ( v1_funct_1(D)
            & m2_relset_1(D,A,B) ) ) ) ).

fof(t169_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,B) )
         => ( r2_hidden(D,k5_partfun1(A,B,C))
           => v1_partfun1(D,A,B) ) ) ) ).

fof(t170_partfun1,axiom,
    $true ).

fof(t171_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_relat_1(D)
            & v1_funct_1(D) )
         => ( r2_hidden(D,k5_partfun1(A,B,C))
           => r1_partfun1(C,D) ) ) ) ).

fof(t172_partfun1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & m2_relset_1(B,A,k1_xboole_0) )
     => ( A != k1_xboole_0
       => k5_partfun1(A,k1_xboole_0,B) = k1_xboole_0 ) ) ).

fof(t173_partfun1,axiom,
    $true ).

fof(t174_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ( v1_partfun1(C,A,B)
      <=> k5_partfun1(A,B,C) = k1_tarski(C) ) ) ).

fof(t175_partfun1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & m2_relset_1(B,k1_xboole_0,A) )
     => k5_partfun1(k1_xboole_0,A,B) = k1_tarski(B) ) ).

fof(t176_partfun1,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & m2_relset_1(B,k1_xboole_0,A) )
     => k5_partfun1(k1_xboole_0,A,B) = k1_tarski(k1_xboole_0) ) ).

fof(t177_partfun1,axiom,
    $true ).

fof(t178_partfun1,axiom,
    $true ).

fof(t179_partfun1,axiom,
    $true ).

fof(t180_partfun1,axiom,
    $true ).

fof(t181_partfun1,axiom,
    $true ).

fof(t182_partfun1,axiom,
    $true ).

fof(t183_partfun1,axiom,
    $true ).

fof(t184_partfun1,axiom,
    $true ).

fof(t185_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,B) )
         => ( ~ r1_xboole_0(k5_partfun1(A,B,C),k5_partfun1(A,B,D))
           => r1_partfun1(C,D) ) ) ) ).

fof(t186_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,B) )
         => ~ ( ( B = k1_xboole_0
               => A = k1_xboole_0 )
              & r1_partfun1(C,D)
              & r1_xboole_0(k5_partfun1(A,B,C),k5_partfun1(A,B,D)) ) ) ) ).

fof(s1_partfun1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A)
      & k1_relat_1(A) = f1_s1_partfun1
      & ! [B] :
          ( r2_hidden(B,f1_s1_partfun1)
         => ( ( p1_s1_partfun1(B)
             => k1_funct_1(A,B) = f2_s1_partfun1(B) )
            & ( ~ p1_s1_partfun1(B)
             => k1_funct_1(A,B) = f3_s1_partfun1(B) ) ) ) ) ).

fof(s2_partfun1,axiom,
    ( ( ! [A,B] :
          ( ( r2_hidden(A,f1_s2_partfun1)
            & p1_s2_partfun1(A,B) )
         => r2_hidden(B,f2_s2_partfun1) )
      & ! [A,B,C] :
          ( ( r2_hidden(A,f1_s2_partfun1)
            & p1_s2_partfun1(A,B)
            & p1_s2_partfun1(A,C) )
         => B = C ) )
   => ? [A] :
        ( v1_funct_1(A)
        & m2_relset_1(A,f1_s2_partfun1,f2_s2_partfun1)
        & ! [B] :
            ( r2_hidden(B,k4_relset_1(f1_s2_partfun1,f2_s2_partfun1,A))
          <=> ( r2_hidden(B,f1_s2_partfun1)
              & ? [C] : p1_s2_partfun1(B,C) ) )
        & ! [B] :
            ( r2_hidden(B,k4_relset_1(f1_s2_partfun1,f2_s2_partfun1,A))
           => p1_s2_partfun1(B,k1_funct_1(A,B)) ) ) ) ).

fof(s3_partfun1,axiom,
    ( ! [A] :
        ( p1_s3_partfun1(A)
       => r2_hidden(f3_s3_partfun1(A),f2_s3_partfun1) )
   => ? [A] :
        ( v1_funct_1(A)
        & m2_relset_1(A,f1_s3_partfun1,f2_s3_partfun1)
        & ! [B] :
            ( r2_hidden(B,k4_relset_1(f1_s3_partfun1,f2_s3_partfun1,A))
          <=> ( r2_hidden(B,f1_s3_partfun1)
              & p1_s3_partfun1(B) ) )
        & ! [B] :
            ( r2_hidden(B,k4_relset_1(f1_s3_partfun1,f2_s3_partfun1,A))
           => k1_funct_1(A,B) = f3_s3_partfun1(B) ) ) ) ).

fof(s4_partfun1,axiom,
    ( ( ! [A,B,C] :
          ( ( r2_hidden(A,f1_s4_partfun1)
            & r2_hidden(B,f2_s4_partfun1)
            & p1_s4_partfun1(A,B,C) )
         => r2_hidden(C,f3_s4_partfun1) )
      & ! [A,B,C,D] :
          ( ( r2_hidden(A,f1_s4_partfun1)
            & r2_hidden(B,f2_s4_partfun1)
            & p1_s4_partfun1(A,B,C)
            & p1_s4_partfun1(A,B,D) )
         => C = D ) )
   => ? [A] :
        ( v1_funct_1(A)
        & m2_relset_1(A,k2_zfmisc_1(f1_s4_partfun1,f2_s4_partfun1),f3_s4_partfun1)
        & ! [B,C] :
            ( r2_hidden(k4_tarski(B,C),k4_relset_1(k2_zfmisc_1(f1_s4_partfun1,f2_s4_partfun1),f3_s4_partfun1,A))
          <=> ( r2_hidden(B,f1_s4_partfun1)
              & r2_hidden(C,f2_s4_partfun1)
              & ? [D] : p1_s4_partfun1(B,C,D) ) )
        & ! [B,C] :
            ( r2_hidden(k4_tarski(B,C),k4_relset_1(k2_zfmisc_1(f1_s4_partfun1,f2_s4_partfun1),f3_s4_partfun1,A))
           => p1_s4_partfun1(B,C,k1_funct_1(A,k4_tarski(B,C))) ) ) ) ).

fof(s5_partfun1,axiom,
    ( ! [A,B] :
        ( p1_s5_partfun1(A,B)
       => r2_hidden(f4_s5_partfun1(A,B),f3_s5_partfun1) )
   => ? [A] :
        ( v1_funct_1(A)
        & m2_relset_1(A,k2_zfmisc_1(f1_s5_partfun1,f2_s5_partfun1),f3_s5_partfun1)
        & ! [B,C] :
            ( r2_hidden(k4_tarski(B,C),k4_relset_1(k2_zfmisc_1(f1_s5_partfun1,f2_s5_partfun1),f3_s5_partfun1,A))
          <=> ( r2_hidden(B,f1_s5_partfun1)
              & r2_hidden(C,f2_s5_partfun1)
              & p1_s5_partfun1(B,C) ) )
        & ! [B,C] :
            ( r2_hidden(k4_tarski(B,C),k4_relset_1(k2_zfmisc_1(f1_s5_partfun1,f2_s5_partfun1),f3_s5_partfun1,A))
           => k1_funct_1(A,k4_tarski(B,C)) = f4_s5_partfun1(B,C) ) ) ) ).

fof(symmetry_r1_partfun1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_relat_1(B)
        & v1_funct_1(B) )
     => ( r1_partfun1(A,B)
       => r1_partfun1(B,A) ) ) ).

fof(reflexivity_r1_partfun1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_relat_1(B)
        & v1_funct_1(B) )
     => r1_partfun1(A,A) ) ).

fof(dt_k1_partfun1,axiom,
    ! [A,B,C,D,E,F] :
      ( ( v1_funct_1(E)
        & m1_relset_1(E,A,B)
        & v1_funct_1(F)
        & m1_relset_1(F,C,D) )
     => ( v1_funct_1(k1_partfun1(A,B,C,D,E,F))
        & m2_relset_1(k1_partfun1(A,B,C,D,E,F),A,D) ) ) ).

fof(redefinition_k1_partfun1,axiom,
    ! [A,B,C,D,E,F] :
      ( ( v1_funct_1(E)
        & m1_relset_1(E,A,B)
        & v1_funct_1(F)
        & m1_relset_1(F,C,D) )
     => k1_partfun1(A,B,C,D,E,F) = k5_relat_1(E,F) ) ).

fof(dt_k2_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(C)
        & m1_relset_1(C,A,B) )
     => ( v1_funct_1(k2_partfun1(A,B,C,D))
        & m2_relset_1(k2_partfun1(A,B,C,D),A,B) ) ) ).

fof(redefinition_k2_partfun1,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(C)
        & m1_relset_1(C,A,B) )
     => k2_partfun1(A,B,C,D) = k7_relat_1(C,D) ) ).

fof(dt_k3_partfun1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v1_funct_1(k3_partfun1(A,B,C))
        & m2_relset_1(k3_partfun1(A,B,C),B,C) ) ) ).

fof(dt_k4_partfun1,axiom,
    $true ).

fof(dt_k5_partfun1,axiom,
    $true ).

fof(dt_k6_partfun1,axiom,
    ! [A] :
      ( v1_partfun1(k6_partfun1(A),A,A)
      & m2_relset_1(k6_partfun1(A),A,A) ) ).

fof(redefinition_k6_partfun1,axiom,
    ! [A] : k6_partfun1(A) = k6_relat_1(A) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(d1_wellord2,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( B = k1_wellord2(A)
      <=> ( k3_relat_1(B) = A
          & ! [C,D] :
              ( ( r2_hidden(C,A)
                & r2_hidden(D,A) )
             => ( r2_hidden(k4_tarski(C,D),B)
              <=> r1_tarski(C,D) ) ) ) ) ) ).

fof(t1_wellord2,axiom,
    $true ).

fof(t2_wellord2,axiom,
    ! [A] : v1_relat_2(k1_wellord2(A)) ).

fof(t3_wellord2,axiom,
    ! [A] : v8_relat_2(k1_wellord2(A)) ).

fof(t4_wellord2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => v6_relat_2(k1_wellord2(A)) ) ).

fof(t5_wellord2,axiom,
    ! [A] : v4_relat_2(k1_wellord2(A)) ).

fof(t6_wellord2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => v1_wellord1(k1_wellord2(A)) ) ).

fof(t7_wellord2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => v2_wellord1(k1_wellord2(A)) ) ).

fof(t8_wellord2,axiom,
    ! [A,B] :
      ( r1_tarski(A,B)
     => k2_wellord1(k1_wellord2(B),A) = k1_wellord2(A) ) ).

fof(t9_wellord2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( r1_tarski(B,A)
         => v2_wellord1(k1_wellord2(B)) ) ) ).

fof(t10_wellord2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( r2_hidden(A,B)
           => A = k1_wellord1(k1_wellord2(B),A) ) ) ) ).

fof(t11_wellord2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( r4_wellord1(k1_wellord2(A),k1_wellord2(B))
           => A = B ) ) ) ).

fof(t12_wellord2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( ( r4_wellord1(A,k1_wellord2(B))
                  & r4_wellord1(A,k1_wellord2(C)) )
               => B = C ) ) ) ) ).

fof(t13_wellord2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ~ ( v2_wellord1(A)
          & ! [B] :
              ~ ( r2_hidden(B,k3_relat_1(A))
                & ! [C] :
                    ( v3_ordinal1(C)
                   => ~ r4_wellord1(k2_wellord1(A,k1_wellord1(A,B)),k1_wellord2(C)) ) )
          & ! [B] :
              ( v3_ordinal1(B)
             => ~ r4_wellord1(A,k1_wellord2(B)) ) ) ) ).

fof(t14_wellord2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ~ ( v2_wellord1(A)
          & ! [B] :
              ( v3_ordinal1(B)
             => ~ r4_wellord1(A,k1_wellord2(B)) ) ) ) ).

fof(d2_wellord2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v2_wellord1(A)
       => ! [B] :
            ( v3_ordinal1(B)
           => ( B = k2_wellord2(A)
            <=> r4_wellord1(A,k1_wellord2(B)) ) ) ) ) ).

fof(d3_wellord2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( r1_wellord2(A,B)
          <=> A = k2_wellord2(B) ) ) ) ).

fof(t15_wellord2,axiom,
    $true ).

fof(t16_wellord2,axiom,
    $true ).

fof(t17_wellord2,axiom,
    ! [A,B] :
      ( v3_ordinal1(B)
     => ( r1_tarski(A,B)
       => r1_ordinal1(k2_wellord2(k1_wellord2(A)),B) ) ) ).

fof(d4_wellord2,axiom,
    ! [A,B] :
      ( r2_wellord2(A,B)
    <=> ? [C] :
          ( v1_relat_1(C)
          & v1_funct_1(C)
          & v2_funct_1(C)
          & k1_relat_1(C) = A
          & k2_relat_1(C) = B ) ) ).

fof(t18_wellord2,axiom,
    $true ).

fof(t19_wellord2,axiom,
    $true ).

fof(t20_wellord2,axiom,
    $true ).

fof(t21_wellord2,axiom,
    $true ).

fof(t22_wellord2,axiom,
    ! [A,B,C] :
      ( ( r2_wellord2(A,B)
        & r2_wellord2(B,C) )
     => r2_wellord2(A,C) ) ).

fof(t23_wellord2,axiom,
    $true ).

fof(t24_wellord2,axiom,
    $true ).

fof(t25_wellord2,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r2_wellord1(B,A)
       => ( k3_relat_1(k2_wellord1(B,A)) = A
          & v2_wellord1(k2_wellord1(B,A)) ) ) ) ).

fof(t26_wellord2,axiom,
    ! [A] :
    ? [B] :
      ( v1_relat_1(B)
      & r2_wellord1(B,A) ) ).

fof(t27_wellord2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ~ ( ! [B] :
              ~ ( r2_hidden(B,A)
                & B = k1_xboole_0 )
          & ! [B,C] :
              ( ( r2_hidden(B,A)
                & r2_hidden(C,A) )
             => ( B = C
                | r1_xboole_0(B,C) ) )
          & ! [B] :
            ? [C] :
              ( r2_hidden(C,A)
              & ! [D] : k3_xboole_0(B,C) != k1_tarski(D) ) ) ) ).

fof(t28_wellord2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ~ ( ! [B] :
              ~ ( r2_hidden(B,A)
                & B = k1_xboole_0 )
          & ! [B] :
              ( ( v1_relat_1(B)
                & v1_funct_1(B) )
             => ~ ( k1_relat_1(B) = A
                  & ! [C] :
                      ( r2_hidden(C,A)
                     => r2_hidden(k1_funct_1(B,C),C) ) ) ) ) ) ).

fof(s1_wellord2,axiom,
    ( ! [A] :
        ~ ( r2_hidden(A,f1_s1_wellord2)
          & ! [B] :
              ~ ( r2_hidden(B,f2_s1_wellord2)
                & p1_s1_wellord2(A,B) ) )
   => ? [A] :
        ( v1_relat_1(A)
        & v1_funct_1(A)
        & k1_relat_1(A) = f1_s1_wellord2
        & r1_tarski(k2_relat_1(A),f2_s1_wellord2)
        & ! [B] :
            ( r2_hidden(B,f1_s1_wellord2)
           => p1_s1_wellord2(B,k1_funct_1(A,B)) ) ) ) ).

fof(s2_wellord2,axiom,
    ( ! [A] :
        ~ ( r2_hidden(A,f1_s2_wellord2)
          & ! [B,C] :
              ~ ( r2_hidden(B,f2_s2_wellord2)
                & r2_hidden(C,f3_s2_wellord2)
                & p1_s2_wellord2(A,B,C) ) )
   => ? [A] :
        ( v1_relat_1(A)
        & v1_funct_1(A)
        & ? [B] :
            ( v1_relat_1(B)
            & v1_funct_1(B)
            & k1_relat_1(A) = f1_s2_wellord2
            & k1_relat_1(B) = f1_s2_wellord2
            & ! [C] :
                ( r2_hidden(C,f1_s2_wellord2)
               => p1_s2_wellord2(C,k1_funct_1(A,C),k1_funct_1(B,C)) ) ) ) ) ).

fof(symmetry_r2_wellord2,axiom,
    ! [A,B] :
      ( r2_wellord2(A,B)
     => r2_wellord2(B,A) ) ).

fof(reflexivity_r2_wellord2,axiom,
    ! [A,B] : r2_wellord2(A,A) ).

fof(redefinition_r2_wellord2,axiom,
    ! [A,B] :
      ( r2_wellord2(A,B)
    <=> r2_tarski(A,B) ) ).

fof(dt_k1_wellord2,axiom,
    ! [A] : v1_relat_1(k1_wellord2(A)) ).

fof(dt_k2_wellord2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => v3_ordinal1(k2_wellord2(A)) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(rc1_funct_2,axiom,
    ! [A,B] :
    ? [C] :
      ( m1_relset_1(C,A,B)
      & v1_relat_1(C)
      & v1_funct_1(C)
      & v1_funct_2(C,A,B) ) ).

fof(cc1_funct_2,axiom,
    ! [A,B,C] :
      ( m1_relset_1(C,A,B)
     => ( ( v1_funct_1(C)
          & v1_partfun1(C,A,B) )
       => ( v1_funct_1(C)
          & v1_funct_2(C,A,B) ) ) ) ).

fof(fc1_funct_2,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ~ v1_xboole_0(k1_funct_2(A,B)) ) ).

fof(fc2_funct_2,axiom,
    ! [A] : ~ v1_xboole_0(k1_funct_2(A,A)) ).

fof(cc2_funct_2,axiom,
    ! [A,B,C] :
      ( m1_relset_1(C,A,B)
     => ( ( v1_funct_1(C)
          & v1_funct_2(C,A,B)
          & v3_funct_2(C,A,B) )
       => ( v1_funct_1(C)
          & v2_funct_1(C)
          & v1_funct_2(C,A,B)
          & v2_funct_2(C,A,B) ) ) ) ).

fof(cc3_funct_2,axiom,
    ! [A,B,C] :
      ( m1_relset_1(C,A,B)
     => ( ( v1_funct_1(C)
          & v2_funct_1(C)
          & v1_funct_2(C,A,B)
          & v2_funct_2(C,A,B) )
       => ( v1_funct_1(C)
          & v1_funct_2(C,A,B)
          & v3_funct_2(C,A,B) ) ) ) ).

fof(rc2_funct_2,axiom,
    ! [A] :
    ? [B] :
      ( m1_relset_1(B,A,A)
      & v1_relat_1(B)
      & v1_funct_1(B)
      & v2_funct_1(B)
      & v1_funct_2(B,A,A)
      & v2_funct_2(B,A,A)
      & v3_funct_2(B,A,A) ) ).

fof(cc4_funct_2,axiom,
    ! [A,B] :
      ( m1_relset_1(B,A,A)
     => ( ( v1_funct_1(B)
          & v1_partfun1(B,A,A)
          & v1_relat_2(B)
          & v1_funct_2(B,A,A) )
       => ( v1_funct_1(B)
          & v2_funct_1(B)
          & v1_funct_2(B,A,A)
          & v2_funct_2(B,A,A)
          & v3_funct_2(B,A,A) ) ) ) ).

fof(cc5_funct_2,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ! [C] :
          ( m1_relset_1(C,A,B)
         => ( ( v1_funct_1(C)
              & v1_funct_2(C,A,B) )
           => ( v1_funct_1(C)
              & v1_partfun1(C,A,B)
              & v1_funct_2(C,A,B) ) ) ) ) ).

fof(cc6_funct_2,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B) )
     => ! [C] :
          ( m1_relset_1(C,A,B)
         => ( ( v1_funct_1(C)
              & v1_funct_2(C,A,B) )
           => ( v1_funct_1(C)
              & ~ v1_xboole_0(C)
              & v1_partfun1(C,A,B)
              & v1_funct_2(C,A,B) ) ) ) ) ).

fof(d1_funct_2,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,A,B)
     => ( ( ( B = k1_xboole_0
           => A = k1_xboole_0 )
         => ( v1_funct_2(C,A,B)
          <=> A = k4_relset_1(A,B,C) ) )
        & ( B = k1_xboole_0
         => ( A = k1_xboole_0
            | ( v1_funct_2(C,A,B)
            <=> C = k1_xboole_0 ) ) ) ) ) ).

fof(t1_funct_2,axiom,
    $true ).

fof(t2_funct_2,axiom,
    $true ).

fof(t3_funct_2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v1_funct_1(A)
        & v1_funct_2(A,k1_relat_1(A),k2_relat_1(A))
        & m2_relset_1(A,k1_relat_1(A),k2_relat_1(A)) ) ) ).

fof(t4_funct_2,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( r1_tarski(k2_relat_1(B),A)
       => ( v1_funct_1(B)
          & v1_funct_2(B,k1_relat_1(B),A)
          & m2_relset_1(B,k1_relat_1(B),A) ) ) ) ).

fof(t5_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( ( k1_relat_1(C) = A
          & ! [D] :
              ( r2_hidden(D,A)
             => r2_hidden(k1_funct_1(C,D),B) ) )
       => ( v1_funct_1(C)
          & v1_funct_2(C,A,B)
          & m2_relset_1(C,A,B) ) ) ) ).

fof(t6_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ( r2_hidden(C,A)
       => ( B = k1_xboole_0
          | r2_hidden(k1_funct_1(D,C),k2_relat_1(D)) ) ) ) ).

fof(t7_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ( r2_hidden(C,A)
       => ( B = k1_xboole_0
          | r2_hidden(k1_funct_1(D,C),B) ) ) ) ).

fof(t8_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ( r1_tarski(k2_relat_1(D),C)
       => ( ( B = k1_xboole_0
            & A != k1_xboole_0 )
          | ( v1_funct_1(D)
            & v1_funct_2(D,A,C)
            & m2_relset_1(D,A,C) ) ) ) ) ).

fof(t9_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ( r1_tarski(B,C)
       => ( ( B = k1_xboole_0
            & A != k1_xboole_0 )
          | ( v1_funct_1(D)
            & v1_funct_2(D,A,C)
            & m2_relset_1(D,A,C) ) ) ) ) ).

fof(d2_funct_2,axiom,
    ! [A,B,C] :
      ( C = k1_funct_2(A,B)
    <=> ! [D] :
          ( r2_hidden(D,C)
        <=> ? [E] :
              ( v1_relat_1(E)
              & v1_funct_1(E)
              & D = E
              & k1_relat_1(E) = A
              & r1_tarski(k2_relat_1(E),B) ) ) ) ).

fof(t10_funct_2,axiom,
    $true ).

fof(t11_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ( ( B = k1_xboole_0
         => A = k1_xboole_0 )
       => r2_hidden(C,k1_funct_2(A,B)) ) ) ).

fof(t12_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => r2_hidden(B,k1_funct_2(A,A)) ) ).

fof(t13_funct_2,axiom,
    $true ).

fof(t14_funct_2,axiom,
    ! [A] :
      ( A != k1_xboole_0
     => k1_funct_2(A,k1_xboole_0) = k1_xboole_0 ) ).

fof(t15_funct_2,axiom,
    $true ).

fof(t16_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ( ! [D] :
            ~ ( r2_hidden(D,B)
              & ! [E] :
                  ~ ( r2_hidden(E,A)
                    & D = k1_funct_1(C,E) ) )
       => ( B = k1_xboole_0
          | k2_relat_1(C) = B ) ) ) ).

fof(t17_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ~ ( r2_hidden(C,B)
          & k2_relat_1(D) = B
          & ! [E] :
              ~ ( r2_hidden(E,A)
                & k1_funct_1(D,E) = C ) ) ) ).

fof(t18_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & v1_funct_2(D,A,B)
            & m2_relset_1(D,A,B) )
         => ( ! [E] :
                ( r2_hidden(E,A)
               => k1_funct_1(C,E) = k1_funct_1(D,E) )
           => C = D ) ) ) ).

fof(t19_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ! [E] :
          ( ( v1_funct_1(E)
            & v1_funct_2(E,B,C)
            & m2_relset_1(E,B,C) )
         => ( ~ ( B = k1_xboole_0
                & C != k1_xboole_0
                & A != k1_xboole_0 )
           => ( v1_funct_1(k1_partfun1(A,B,B,C,D,E))
              & v1_funct_2(k1_partfun1(A,B,B,C,D,E),A,C)
              & m2_relset_1(k1_partfun1(A,B,B,C,D,E),A,C) ) ) ) ) ).

fof(t20_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ! [E] :
          ( ( v1_funct_1(E)
            & v1_funct_2(E,B,C)
            & m2_relset_1(E,B,C) )
         => ( ( k2_relat_1(D) = B
              & k2_relat_1(E) = C )
           => ( B = k1_xboole_0
              | C = k1_xboole_0
              | k2_relat_1(k1_partfun1(A,B,B,C,D,E)) = C ) ) ) ) ).

fof(t21_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ! [E] :
          ( ( v1_relat_1(E)
            & v1_funct_1(E) )
         => ( r2_hidden(C,A)
           => ( B = k1_xboole_0
              | k1_funct_1(k5_relat_1(D,E),C) = k1_funct_1(E,k1_funct_1(D,C)) ) ) ) ) ).

fof(t22_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ( B != k1_xboole_0
       => ( k2_relat_1(C) = B
        <=> ! [D] :
              ( D != k1_xboole_0
             => ! [E] :
                  ( ( v1_funct_1(E)
                    & v1_funct_2(E,B,D)
                    & m2_relset_1(E,B,D) )
                 => ! [F] :
                      ( ( v1_funct_1(F)
                        & v1_funct_2(F,B,D)
                        & m2_relset_1(F,B,D) )
                     => ( k1_partfun1(A,B,B,D,C,E) = k1_partfun1(A,B,B,D,C,F)
                       => E = F ) ) ) ) ) ) ) ).

fof(t23_funct_2,axiom,
    ! [A,B,C] :
      ( m2_relset_1(C,A,B)
     => ( k7_relset_1(A,A,A,B,k6_partfun1(A),C) = C
        & k7_relset_1(A,B,B,B,C,k6_partfun1(B)) = C ) ) ).

fof(t24_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & v1_funct_2(D,B,A)
            & m2_relset_1(D,B,A) )
         => ( k1_partfun1(B,A,A,B,D,C) = k6_partfun1(B)
           => k2_relat_1(C) = B ) ) ) ).

fof(t25_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ( ( B = k1_xboole_0
         => A = k1_xboole_0 )
       => ( v2_funct_1(C)
        <=> ! [D,E] :
              ( ( r2_hidden(D,A)
                & r2_hidden(E,A)
                & k1_funct_1(C,D) = k1_funct_1(C,E) )
             => D = E ) ) ) ) ).

fof(t26_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ! [E] :
          ( ( v1_funct_1(E)
            & v1_funct_2(E,B,C)
            & m2_relset_1(E,B,C) )
         => ( v2_funct_1(k1_partfun1(A,B,B,C,D,E))
           => ( ( C = k1_xboole_0
                & B != k1_xboole_0 )
              | ( B = k1_xboole_0
                & A != k1_xboole_0 )
              | v2_funct_1(D) ) ) ) ) ).

fof(t27_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ~ ( A != k1_xboole_0
          & B != k1_xboole_0
          & ~ ( v2_funct_1(C)
            <=> ! [D,E] :
                  ( ( v1_funct_1(E)
                    & v1_funct_2(E,D,A)
                    & m2_relset_1(E,D,A) )
                 => ! [F] :
                      ( ( v1_funct_1(F)
                        & v1_funct_2(F,D,A)
                        & m2_relset_1(F,D,A) )
                     => ( k1_partfun1(D,A,A,B,E,C) = k1_partfun1(D,A,A,B,F,C)
                       => E = F ) ) ) ) ) ) ).

fof(t28_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ! [E] :
          ( ( v1_funct_1(E)
            & v1_funct_2(E,B,C)
            & m2_relset_1(E,B,C) )
         => ( ( k2_relat_1(k1_partfun1(A,B,B,C,D,E)) = C
              & v2_funct_1(E) )
           => ( C = k1_xboole_0
              | k2_relat_1(D) = B ) ) ) ) ).

fof(t29_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & v1_funct_2(D,B,A)
            & m2_relset_1(D,B,A) )
         => ( k1_partfun1(A,B,B,A,C,D) = k6_partfun1(A)
           => ( B = k1_xboole_0
              | ( v2_funct_1(C)
                & k2_relat_1(D) = A ) ) ) ) ) ).

fof(t30_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ! [E] :
          ( ( v1_funct_1(E)
            & v1_funct_2(E,B,C)
            & m2_relset_1(E,B,C) )
         => ( ( v2_funct_1(k1_partfun1(A,B,B,C,D,E))
              & k2_relat_1(D) = B )
           => ( ( C = k1_xboole_0
                & B != k1_xboole_0 )
              | ( v2_funct_1(D)
                & v2_funct_1(E) ) ) ) ) ) ).

fof(t31_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ( ( v2_funct_1(C)
          & k2_relat_1(C) = B )
       => ( v1_funct_1(k2_funct_1(C))
          & v1_funct_2(k2_funct_1(C),B,A)
          & m2_relset_1(k2_funct_1(C),B,A) ) ) ) ).

fof(t32_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ( ( v2_funct_1(D)
          & r2_hidden(C,A) )
       => ( B = k1_xboole_0
          | k1_funct_1(k2_funct_1(D),k1_funct_1(D,C)) = C ) ) ) ).

fof(t33_funct_2,axiom,
    $true ).

fof(t34_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & v1_funct_2(D,B,A)
            & m2_relset_1(D,B,A) )
         => ( ( k2_relat_1(C) = B
              & v2_funct_1(C)
              & ! [E,F] :
                  ( ( ( r2_hidden(E,B)
                      & k1_funct_1(D,E) = F )
                   => ( r2_hidden(F,A)
                      & k1_funct_1(C,F) = E ) )
                  & ( ( r2_hidden(F,A)
                      & k1_funct_1(C,F) = E )
                   => ( r2_hidden(E,B)
                      & k1_funct_1(D,E) = F ) ) ) )
           => ( A = k1_xboole_0
              | B = k1_xboole_0
              | D = k2_funct_1(C) ) ) ) ) ).

fof(t35_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ( ( k2_relat_1(C) = B
          & v2_funct_1(C) )
       => ( B = k1_xboole_0
          | ( k5_relat_1(C,k2_funct_1(C)) = k6_partfun1(A)
            & k5_relat_1(k2_funct_1(C),C) = k6_partfun1(B) ) ) ) ) ).

fof(t36_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & v1_funct_2(D,B,A)
            & m2_relset_1(D,B,A) )
         => ( ( k2_relat_1(C) = B
              & k1_partfun1(A,B,B,A,C,D) = k6_partfun1(A)
              & v2_funct_1(C) )
           => ( A = k1_xboole_0
              | B = k1_xboole_0
              | D = k2_funct_1(C) ) ) ) ) ).

fof(t37_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ~ ( B != k1_xboole_0
          & ? [D] :
              ( v1_funct_1(D)
              & v1_funct_2(D,B,A)
              & m2_relset_1(D,B,A)
              & k1_partfun1(A,B,B,A,C,D) = k6_partfun1(A) )
          & ~ v2_funct_1(C) ) ) ).

fof(t38_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ( r1_tarski(C,A)
       => ( ( B = k1_xboole_0
            & A != k1_xboole_0 )
          | ( v1_funct_1(k2_partfun1(A,B,D,C))
            & v1_funct_2(k2_partfun1(A,B,D,C),C,B)
            & m2_relset_1(k2_partfun1(A,B,D,C),C,B) ) ) ) ) ).

fof(t39_funct_2,axiom,
    $true ).

fof(t40_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ( r1_tarski(A,C)
       => k2_partfun1(A,B,D,C) = D ) ) ).

fof(t41_funct_2,axiom,
    ! [A,B,C,D,E] :
      ( ( v1_funct_1(E)
        & v1_funct_2(E,A,B)
        & m2_relset_1(E,A,B) )
     => ( ( r2_hidden(C,A)
          & r2_hidden(k1_funct_1(E,C),D) )
       => ( B = k1_xboole_0
          | k1_funct_1(k9_relset_1(A,B,D,E),C) = k1_funct_1(E,C) ) ) ) ).

fof(t42_funct_2,axiom,
    $true ).

fof(t43_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ( B != k1_xboole_0
       => ! [E] :
            ( ? [F] :
                ( r2_hidden(F,A)
                & r2_hidden(F,C)
                & E = k1_funct_1(D,F) )
           => r2_hidden(E,k9_relat_1(D,C)) ) ) ) ).

fof(t44_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => r1_tarski(k9_relat_1(D,C),B) ) ).

fof(t45_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ( ( B = k1_xboole_0
         => A = k1_xboole_0 )
       => k2_funct_2(A,B,C,A) = k2_relat_1(C) ) ) ).

fof(t46_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ( B != k1_xboole_0
       => ! [E] :
            ( r2_hidden(E,k10_relat_1(D,C))
          <=> ( r2_hidden(E,A)
              & r2_hidden(k1_funct_1(D,E),C) ) ) ) ) ).

fof(t47_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & m2_relset_1(D,A,B) )
     => r1_tarski(k10_relat_1(D,C),A) ) ).

fof(t48_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ( ( B = k1_xboole_0
         => A = k1_xboole_0 )
       => k3_funct_2(A,B,C,B) = A ) ) ).

fof(t49_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ( ! [D] :
            ~ ( r2_hidden(D,B)
              & k3_funct_2(A,B,C,k1_tarski(D)) = k1_xboole_0 )
      <=> k2_relat_1(C) = B ) ) ).

fof(t50_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ( r1_tarski(C,A)
       => ( ( B = k1_xboole_0
            & A != k1_xboole_0 )
          | r1_tarski(C,k3_funct_2(A,B,D,k2_funct_2(A,B,D,C))) ) ) ) ).

fof(t51_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ( ( B = k1_xboole_0
         => A = k1_xboole_0 )
       => k3_funct_2(A,B,C,k2_funct_2(A,B,C,A)) = A ) ) ).

fof(t52_funct_2,axiom,
    $true ).

fof(t53_funct_2,axiom,
    ! [A,B,C,D,E] :
      ( ( v1_funct_1(E)
        & v1_funct_2(E,A,B)
        & m2_relset_1(E,A,B) )
     => ! [F] :
          ( ( v1_funct_1(F)
            & v1_funct_2(F,B,C)
            & m2_relset_1(F,B,C) )
         => ~ ( ( C = k1_xboole_0
               => B = k1_xboole_0 )
              & ( B = k1_xboole_0
               => A = k1_xboole_0 )
              & ~ r1_tarski(k3_funct_2(A,B,E,D),k3_funct_2(A,C,k1_partfun1(A,B,B,C,E,F),k2_funct_2(B,C,F,D))) ) ) ) ).

fof(t54_funct_2,axiom,
    $true ).

fof(t55_funct_2,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( k1_relat_1(B) = k1_xboole_0
       => ( v1_funct_1(B)
          & v1_funct_2(B,k1_xboole_0,A)
          & m2_relset_1(B,k1_xboole_0,A) ) ) ) ).

fof(t56_funct_2,axiom,
    $true ).

fof(t57_funct_2,axiom,
    $true ).

fof(t58_funct_2,axiom,
    $true ).

fof(t59_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,k1_xboole_0,A)
        & m2_relset_1(C,k1_xboole_0,A) )
     => k2_funct_2(k1_xboole_0,A,C,B) = k1_xboole_0 ) ).

fof(t60_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,k1_xboole_0,A)
        & m2_relset_1(C,k1_xboole_0,A) )
     => k3_funct_2(k1_xboole_0,A,C,B) = k1_xboole_0 ) ).

fof(t61_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,k1_tarski(A),B)
        & m2_relset_1(C,k1_tarski(A),B) )
     => ( B != k1_xboole_0
       => r2_hidden(k1_funct_1(C,A),B) ) ) ).

fof(t62_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,k1_tarski(A),B)
        & m2_relset_1(C,k1_tarski(A),B) )
     => ( B != k1_xboole_0
       => k2_relat_1(C) = k1_tarski(k1_funct_1(C,A)) ) ) ).

fof(t63_funct_2,axiom,
    $true ).

fof(t64_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,k1_tarski(A),B)
        & m2_relset_1(D,k1_tarski(A),B) )
     => ( B != k1_xboole_0
       => r1_tarski(k2_funct_2(k1_tarski(A),B,D,C),k1_tarski(k1_funct_1(D,A))) ) ) ).

fof(t65_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,k1_tarski(B))
        & m2_relset_1(D,A,k1_tarski(B)) )
     => ( r2_hidden(C,A)
       => k1_funct_1(D,C) = B ) ) ).

fof(t66_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,k1_tarski(B))
        & m2_relset_1(C,A,k1_tarski(B)) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & v1_funct_2(D,A,k1_tarski(B))
            & m2_relset_1(D,A,k1_tarski(B)) )
         => C = D ) ) ).

fof(t67_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => ( k4_relset_1(A,A,B) = A
        & r1_tarski(k2_relat_1(B),A) ) ) ).

fof(t68_funct_2,axiom,
    $true ).

fof(t69_funct_2,axiom,
    $true ).

fof(t70_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,A)
        & m2_relset_1(C,A,A) )
     => ! [D] :
          ( ( v1_relat_1(D)
            & v1_funct_1(D) )
         => ( r2_hidden(B,A)
           => k1_funct_1(k5_relat_1(C,D),B) = k1_funct_1(D,k1_funct_1(C,B)) ) ) ) ).

fof(t71_funct_2,axiom,
    $true ).

fof(t72_funct_2,axiom,
    $true ).

fof(t73_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => ! [C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,A,A)
            & m2_relset_1(C,A,A) )
         => ( ( k2_relat_1(B) = A
              & k2_relat_1(C) = A )
           => k2_relat_1(k4_funct_2(A,B,C)) = A ) ) ) ).

fof(t74_funct_2,axiom,
    ! [A,B] :
      ( m2_relset_1(B,A,A)
     => ( k7_relset_1(A,A,A,A,B,k6_partfun1(A)) = B
        & k7_relset_1(A,A,A,A,k6_partfun1(A),B) = B ) ) ).

fof(t75_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => ! [C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,A,A)
            & m2_relset_1(C,A,A) )
         => ( ( k4_funct_2(A,B,C) = B
              & k2_relat_1(B) = A )
           => C = k6_partfun1(A) ) ) ) ).

fof(t76_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => ! [C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,A,A)
            & m2_relset_1(C,A,A) )
         => ( ( k4_funct_2(A,C,B) = B
              & v2_funct_1(B) )
           => C = k6_partfun1(A) ) ) ) ).

fof(t77_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => ( v2_funct_1(B)
      <=> ! [C,D] :
            ( ( r2_hidden(C,A)
              & r2_hidden(D,A)
              & k1_funct_1(B,C) = k1_funct_1(B,D) )
           => C = D ) ) ) ).

fof(t78_funct_2,axiom,
    $true ).

fof(t79_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => k2_funct_2(A,A,B,A) = k2_relat_1(B) ) ).

fof(t80_funct_2,axiom,
    $true ).

fof(t81_funct_2,axiom,
    $true ).

fof(t82_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => k3_funct_2(A,A,B,k2_funct_2(A,A,B,A)) = A ) ).

fof(d3_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ( v2_funct_2(C,A,B)
      <=> k2_relat_1(C) = B ) ) ).

fof(d4_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ( v3_funct_2(C,A,B)
      <=> ( v2_funct_1(C)
          & v2_funct_2(C,A,B) ) ) ) ).

fof(t83_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => ( ( v2_funct_1(B)
          & k2_relat_1(B) = A )
       => ( v1_funct_1(B)
          & v1_funct_2(B,A,A)
          & v3_funct_2(B,A,A)
          & m2_relset_1(B,A,A) ) ) ) ).

fof(t84_funct_2,axiom,
    $true ).

fof(t85_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => ( v2_funct_1(B)
       => ! [C,D] :
            ( ( r2_hidden(C,A)
              & r2_hidden(D,A)
              & k1_funct_1(B,C) = k1_funct_1(B,D) )
           => C = D ) ) ) ).

fof(t86_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & v3_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => ! [C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,A,A)
            & v3_funct_2(C,A,A)
            & m2_relset_1(C,A,A) )
         => ( k5_funct_2(A,B,C) = C
           => B = k6_partfun1(A) ) ) ) ).

fof(t87_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & v3_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => ! [C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,A,A)
            & v3_funct_2(C,A,A)
            & m2_relset_1(C,A,A) )
         => ( k5_funct_2(A,B,C) = k6_partfun1(A)
           => C = k6_funct_2(A,B) ) ) ) ).

fof(t88_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & v3_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => ( k5_funct_2(A,B,k6_funct_2(A,B)) = k6_partfun1(A)
        & k5_funct_2(A,k6_funct_2(A,B),B) = k6_partfun1(A) ) ) ).

fof(t89_funct_2,axiom,
    $true ).

fof(t90_funct_2,axiom,
    $true ).

fof(t91_funct_2,axiom,
    $true ).

fof(t92_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,A)
        & v3_funct_2(C,A,A)
        & m2_relset_1(C,A,A) )
     => ( r1_tarski(B,A)
       => ( k2_funct_2(A,A,C,k3_funct_2(A,A,C,B)) = B
          & k3_funct_2(A,A,C,k2_funct_2(A,A,C,B)) = B ) ) ) ).

fof(t93_funct_2,axiom,
    $true ).

fof(t94_funct_2,axiom,
    $true ).

fof(t95_funct_2,axiom,
    $true ).

fof(t96_funct_2,axiom,
    $true ).

fof(t97_funct_2,axiom,
    $true ).

fof(t98_funct_2,axiom,
    $true ).

fof(t99_funct_2,axiom,
    $true ).

fof(t100_funct_2,axiom,
    $true ).

fof(t101_funct_2,axiom,
    $true ).

fof(t102_funct_2,axiom,
    $true ).

fof(t103_funct_2,axiom,
    $true ).

fof(t104_funct_2,axiom,
    $true ).

fof(t105_funct_2,axiom,
    $true ).

fof(t106_funct_2,axiom,
    $true ).

fof(t107_funct_2,axiom,
    $true ).

fof(t108_funct_2,axiom,
    $true ).

fof(t109_funct_2,axiom,
    $true ).

fof(t110_funct_2,axiom,
    $true ).

fof(t111_funct_2,axiom,
    $true ).

fof(t112_funct_2,axiom,
    $true ).

fof(t113_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & v1_funct_2(D,A,B)
            & m2_relset_1(D,A,B) )
         => ( ! [E] :
                ( m1_subset_1(E,A)
               => k1_funct_1(C,E) = k1_funct_1(D,E) )
           => C = D ) ) ) ).

fof(t114_funct_2,axiom,
    $true ).

fof(t115_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ! [E] :
          ~ ( r2_hidden(E,k2_funct_2(A,B,D,C))
            & ! [F] :
                ~ ( r2_hidden(F,A)
                  & r2_hidden(F,C)
                  & E = k1_funct_1(D,F) ) ) ) ).

fof(t116_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m2_relset_1(D,A,B) )
     => ! [E] :
          ~ ( r2_hidden(E,k2_funct_2(A,B,D,C))
            & ! [F] :
                ( m1_subset_1(F,A)
               => ~ ( r2_hidden(F,C)
                    & E = k1_funct_1(D,F) ) ) ) ) ).

fof(t117_funct_2,axiom,
    $true ).

fof(t118_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,k2_zfmisc_1(A,B),C)
        & m2_relset_1(D,k2_zfmisc_1(A,B),C) )
     => ! [E] :
          ( ( v1_funct_1(E)
            & v1_funct_2(E,k2_zfmisc_1(A,B),C)
            & m2_relset_1(E,k2_zfmisc_1(A,B),C) )
         => ( ! [F,G] :
                ( ( r2_hidden(F,A)
                  & r2_hidden(G,B) )
               => k1_funct_1(D,k4_tarski(F,G)) = k1_funct_1(E,k4_tarski(F,G)) )
           => D = E ) ) ) ).

fof(t119_funct_2,axiom,
    ! [A,B,C,D,E,F] :
      ( ( v1_funct_1(F)
        & v1_funct_2(F,k2_zfmisc_1(A,B),C)
        & m2_relset_1(F,k2_zfmisc_1(A,B),C) )
     => ( ( r2_hidden(D,A)
          & r2_hidden(E,B) )
       => ( C = k1_xboole_0
          | r2_hidden(k1_funct_1(F,k4_tarski(D,E)),C) ) ) ) ).

fof(t120_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,k2_zfmisc_1(A,B),C)
        & m2_relset_1(D,k2_zfmisc_1(A,B),C) )
     => ! [E] :
          ( ( v1_funct_1(E)
            & v1_funct_2(E,k2_zfmisc_1(A,B),C)
            & m2_relset_1(E,k2_zfmisc_1(A,B),C) )
         => ( ! [F] :
                ( m1_subset_1(F,A)
               => ! [G] :
                    ( m1_subset_1(G,B)
                   => k1_funct_1(D,k4_tarski(F,G)) = k1_funct_1(E,k4_tarski(F,G)) ) )
           => D = E ) ) ) ).

fof(t121_funct_2,axiom,
    ! [A,B,C] :
      ( r2_hidden(C,k1_funct_2(A,B))
     => ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) ) ) ).

fof(t122_funct_2,axiom,
    $true ).

fof(t123_funct_2,axiom,
    $true ).

fof(t124_funct_2,axiom,
    $true ).

fof(t125_funct_2,axiom,
    $true ).

fof(t126_funct_2,axiom,
    $true ).

fof(t127_funct_2,axiom,
    $true ).

fof(t128_funct_2,axiom,
    $true ).

fof(t129_funct_2,axiom,
    $true ).

fof(t130_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ( k4_relset_1(A,B,C) = A
       => ( v1_funct_1(C)
          & v1_funct_2(C,A,B)
          & m2_relset_1(C,A,B) ) ) ) ).

fof(t131_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ( v1_partfun1(C,A,B)
       => ( v1_funct_1(C)
          & v1_funct_2(C,A,B)
          & m2_relset_1(C,A,B) ) ) ) ).

fof(t132_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ( ( v1_funct_1(C)
          & v1_funct_2(C,A,B)
          & m2_relset_1(C,A,B) )
       => ( ( B = k1_xboole_0
            & A != k1_xboole_0 )
          | v1_partfun1(C,A,B) ) ) ) ).

fof(t133_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ( ( B = k1_xboole_0
         => A = k1_xboole_0 )
       => v1_partfun1(k3_partfun1(C,A,B),A,B) ) ) ).

fof(t134_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => v1_partfun1(k3_partfun1(B,A,A),A,A) ) ).

fof(t135_funct_2,axiom,
    $true ).

fof(t136_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ~ ( ( B = k1_xboole_0
           => A = k1_xboole_0 )
          & ! [D] :
              ( ( v1_funct_1(D)
                & v1_funct_2(D,A,B)
                & m2_relset_1(D,A,B) )
             => ? [E] :
                  ( r2_hidden(E,k4_relset_1(A,B,C))
                  & k1_funct_1(D,E) != k1_funct_1(C,E) ) ) ) ) ).

fof(t137_funct_2,axiom,
    $true ).

fof(t138_funct_2,axiom,
    $true ).

fof(t139_funct_2,axiom,
    $true ).

fof(t140_funct_2,axiom,
    $true ).

fof(t141_funct_2,axiom,
    ! [A,B] : r1_tarski(k1_funct_2(A,B),k4_partfun1(A,B)) ).

fof(t142_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & v1_funct_2(D,A,B)
            & m2_relset_1(D,A,B) )
         => ( r1_partfun1(C,D)
           => ( ( B = k1_xboole_0
                & A != k1_xboole_0 )
              | C = D ) ) ) ) ).

fof(t143_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => ! [C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,A,A)
            & m2_relset_1(C,A,A) )
         => ( r1_partfun1(B,C)
           => B = C ) ) ) ).

fof(t144_funct_2,axiom,
    $true ).

fof(t145_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & v1_funct_2(D,A,B)
            & m2_relset_1(D,A,B) )
         => ( ( B = k1_xboole_0
             => A = k1_xboole_0 )
           => ( r1_partfun1(C,D)
            <=> ! [E] :
                  ( r2_hidden(E,k4_relset_1(A,B,C))
                 => k1_funct_1(C,E) = k1_funct_1(D,E) ) ) ) ) ) ).

fof(t146_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & m2_relset_1(B,A,A) )
     => ! [C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,A,A)
            & m2_relset_1(C,A,A) )
         => ( r1_partfun1(B,C)
          <=> ! [D] :
                ( r2_hidden(D,k4_relset_1(A,A,B))
               => k1_funct_1(B,D) = k1_funct_1(C,D) ) ) ) ) ).

fof(t147_funct_2,axiom,
    $true ).

fof(t148_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ~ ( ( B = k1_xboole_0
           => A = k1_xboole_0 )
          & ! [D] :
              ( ( v1_funct_1(D)
                & v1_funct_2(D,A,B)
                & m2_relset_1(D,A,B) )
             => ~ r1_partfun1(C,D) ) ) ) ).

fof(t149_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & m2_relset_1(B,A,A) )
     => ? [C] :
          ( v1_funct_1(C)
          & v1_funct_2(C,A,A)
          & m2_relset_1(C,A,A)
          & r1_partfun1(B,C) ) ) ).

fof(t150_funct_2,axiom,
    $true ).

fof(t151_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,B) )
         => ! [E] :
              ( ( v1_funct_1(E)
                & v1_funct_2(E,A,B)
                & m2_relset_1(E,A,B) )
             => ( ( r1_partfun1(C,E)
                  & r1_partfun1(D,E) )
               => ( ( B = k1_xboole_0
                    & A != k1_xboole_0 )
                  | r1_partfun1(C,D) ) ) ) ) ) ).

fof(t152_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & m2_relset_1(B,A,A) )
     => ! [C] :
          ( ( v1_funct_1(C)
            & m2_relset_1(C,A,A) )
         => ! [D] :
              ( ( v1_funct_1(D)
                & v1_funct_2(D,A,A)
                & m2_relset_1(D,A,A) )
             => ( ( r1_partfun1(B,D)
                  & r1_partfun1(C,D) )
               => r1_partfun1(B,C) ) ) ) ) ).

fof(t153_funct_2,axiom,
    $true ).

fof(t154_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,B) )
         => ~ ( ( B = k1_xboole_0
               => A = k1_xboole_0 )
              & r1_partfun1(C,D)
              & ! [E] :
                  ( ( v1_funct_1(E)
                    & v1_funct_2(E,A,B)
                    & m2_relset_1(E,A,B) )
                 => ~ ( r1_partfun1(C,E)
                      & r1_partfun1(D,E) ) ) ) ) ) ).

fof(t155_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & v1_funct_2(D,A,B)
            & m2_relset_1(D,A,B) )
         => ( r1_partfun1(C,D)
           => ( ( B = k1_xboole_0
                & A != k1_xboole_0 )
              | r2_hidden(D,k5_partfun1(A,B,C)) ) ) ) ) ).

fof(t156_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & m2_relset_1(B,A,A) )
     => ! [C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,A,A)
            & m2_relset_1(C,A,A) )
         => ( r1_partfun1(B,C)
           => r2_hidden(C,k5_partfun1(A,A,B)) ) ) ) ).

fof(t157_funct_2,axiom,
    $true ).

fof(t158_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( r2_hidden(D,k5_partfun1(A,B,C))
         => ( v1_funct_1(D)
            & v1_funct_2(D,A,B)
            & m2_relset_1(D,A,B) ) ) ) ).

fof(t159_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => r1_tarski(k5_partfun1(A,B,C),k1_funct_2(A,B)) ) ).

fof(t160_funct_2,axiom,
    ! [A,B] : k5_partfun1(A,B,k3_partfun1(k1_xboole_0,A,B)) = k1_funct_2(A,B) ).

fof(t161_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ( ( B = k1_xboole_0
         => A = k1_xboole_0 )
       => k5_partfun1(A,B,k3_partfun1(C,A,B)) = k1_tarski(C) ) ) ).

fof(t162_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => k5_partfun1(A,A,k3_partfun1(B,A,A)) = k1_tarski(B) ) ).

fof(t163_funct_2,axiom,
    $true ).

fof(t164_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,k1_tarski(B)) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & v1_funct_2(D,A,k1_tarski(B))
            & m2_relset_1(D,A,k1_tarski(B)) )
         => k5_partfun1(A,k1_tarski(B),C) = k1_tarski(D) ) ) ).

fof(t165_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,B) )
         => ( r1_tarski(D,C)
           => r1_tarski(k5_partfun1(A,B,C),k5_partfun1(A,B,D)) ) ) ) ).

fof(t166_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,B) )
         => ( ( r1_tarski(k4_relset_1(A,B,D),k4_relset_1(A,B,C))
              & r1_tarski(k5_partfun1(A,B,C),k5_partfun1(A,B,D)) )
           => r1_tarski(D,C) ) ) ) ).

fof(t167_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,B) )
         => ( ( r1_tarski(k5_partfun1(A,B,C),k5_partfun1(A,B,D))
              & ! [E] : B != k1_tarski(E) )
           => r1_tarski(D,C) ) ) ) ).

fof(t168_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,B) )
         => ( ( ! [E] : B != k1_tarski(E)
              & k5_partfun1(A,B,C) = k5_partfun1(A,B,D) )
           => C = D ) ) ) ).

fof(d5_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,k2_zfmisc_1(k1_tarski(A),k1_tarski(B)),k1_tarski(C))
        & m2_relset_1(D,k2_zfmisc_1(k1_tarski(A),k1_tarski(B)),k1_tarski(C)) )
     => D = k9_funct_2(A,B,C) ) ).

fof(t169_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r2_hidden(C,k1_funct_2(A,B))
       => ( k1_relat_1(C) = A
          & r1_tarski(k2_relat_1(C),B) ) ) ) ).

fof(s1_funct_2,axiom,
    ( ! [A] :
        ~ ( r2_hidden(A,f1_s1_funct_2)
          & ! [B] :
              ~ ( r2_hidden(B,f2_s1_funct_2)
                & p1_s1_funct_2(A,B) ) )
   => ? [A] :
        ( v1_funct_1(A)
        & v1_funct_2(A,f1_s1_funct_2,f2_s1_funct_2)
        & m2_relset_1(A,f1_s1_funct_2,f2_s1_funct_2)
        & ! [B] :
            ( r2_hidden(B,f1_s1_funct_2)
           => p1_s1_funct_2(B,k1_funct_1(A,B)) ) ) ) ).

fof(s2_funct_2,axiom,
    ( ! [A] :
        ( r2_hidden(A,f1_s2_funct_2)
       => r2_hidden(f3_s2_funct_2(A),f2_s2_funct_2) )
   => ? [A] :
        ( v1_funct_1(A)
        & v1_funct_2(A,f1_s2_funct_2,f2_s2_funct_2)
        & m2_relset_1(A,f1_s2_funct_2,f2_s2_funct_2)
        & ! [B] :
            ( r2_hidden(B,f1_s2_funct_2)
           => k1_funct_1(A,B) = f3_s2_funct_2(B) ) ) ) ).

fof(s3_funct_2,axiom,
    ( ! [A] :
        ( m1_subset_1(A,f1_s3_funct_2)
       => ? [B] :
            ( m1_subset_1(B,f2_s3_funct_2)
            & p1_s3_funct_2(A,B) ) )
   => ? [A] :
        ( v1_funct_1(A)
        & v1_funct_2(A,f1_s3_funct_2,f2_s3_funct_2)
        & m2_relset_1(A,f1_s3_funct_2,f2_s3_funct_2)
        & ! [B] :
            ( m1_subset_1(B,f1_s3_funct_2)
           => p1_s3_funct_2(B,k8_funct_2(f1_s3_funct_2,f2_s3_funct_2,A,B)) ) ) ) ).

fof(s4_funct_2,axiom,
    ? [A] :
      ( v1_funct_1(A)
      & v1_funct_2(A,f1_s4_funct_2,f2_s4_funct_2)
      & m2_relset_1(A,f1_s4_funct_2,f2_s4_funct_2)
      & ! [B] :
          ( m1_subset_1(B,f1_s4_funct_2)
         => k8_funct_2(f1_s4_funct_2,f2_s4_funct_2,A,B) = f3_s4_funct_2(B) ) ) ).

fof(s5_funct_2,axiom,
    ( ! [A,B] :
        ~ ( r2_hidden(A,f1_s5_funct_2)
          & r2_hidden(B,f2_s5_funct_2)
          & ! [C] :
              ~ ( r2_hidden(C,f3_s5_funct_2)
                & p1_s5_funct_2(A,B,C) ) )
   => ? [A] :
        ( v1_funct_1(A)
        & v1_funct_2(A,k2_zfmisc_1(f1_s5_funct_2,f2_s5_funct_2),f3_s5_funct_2)
        & m2_relset_1(A,k2_zfmisc_1(f1_s5_funct_2,f2_s5_funct_2),f3_s5_funct_2)
        & ! [B,C] :
            ( ( r2_hidden(B,f1_s5_funct_2)
              & r2_hidden(C,f2_s5_funct_2) )
           => p1_s5_funct_2(B,C,k1_funct_1(A,k4_tarski(B,C))) ) ) ) ).

fof(s6_funct_2,axiom,
    ( ! [A,B] :
        ( ( r2_hidden(A,f1_s6_funct_2)
          & r2_hidden(B,f2_s6_funct_2) )
       => r2_hidden(f4_s6_funct_2(A,B),f3_s6_funct_2) )
   => ? [A] :
        ( v1_funct_1(A)
        & v1_funct_2(A,k2_zfmisc_1(f1_s6_funct_2,f2_s6_funct_2),f3_s6_funct_2)
        & m2_relset_1(A,k2_zfmisc_1(f1_s6_funct_2,f2_s6_funct_2),f3_s6_funct_2)
        & ! [B,C] :
            ( ( r2_hidden(B,f1_s6_funct_2)
              & r2_hidden(C,f2_s6_funct_2) )
           => k1_funct_1(A,k4_tarski(B,C)) = f4_s6_funct_2(B,C) ) ) ) ).

fof(s7_funct_2,axiom,
    ( ! [A] :
        ( m1_subset_1(A,f1_s7_funct_2)
       => ! [B] :
            ( m1_subset_1(B,f2_s7_funct_2)
           => ? [C] :
                ( m1_subset_1(C,f3_s7_funct_2)
                & p1_s7_funct_2(A,B,C) ) ) )
   => ? [A] :
        ( v1_funct_1(A)
        & v1_funct_2(A,k2_zfmisc_1(f1_s7_funct_2,f2_s7_funct_2),f3_s7_funct_2)
        & m2_relset_1(A,k2_zfmisc_1(f1_s7_funct_2,f2_s7_funct_2),f3_s7_funct_2)
        & ! [B] :
            ( m1_subset_1(B,f1_s7_funct_2)
           => ! [C] :
                ( m1_subset_1(C,f2_s7_funct_2)
               => p1_s7_funct_2(B,C,k1_funct_1(A,k4_tarski(B,C))) ) ) ) ) ).

fof(s8_funct_2,axiom,
    ? [A] :
      ( v1_funct_1(A)
      & v1_funct_2(A,k2_zfmisc_1(f1_s8_funct_2,f2_s8_funct_2),f3_s8_funct_2)
      & m2_relset_1(A,k2_zfmisc_1(f1_s8_funct_2,f2_s8_funct_2),f3_s8_funct_2)
      & ! [B] :
          ( m1_subset_1(B,f1_s8_funct_2)
         => ! [C] :
              ( m1_subset_1(C,f2_s8_funct_2)
             => k1_funct_1(A,k4_tarski(B,C)) = f4_s8_funct_2(B,C) ) ) ) ).

fof(s9_funct_2,axiom,
    ( ! [A] :
        ( r2_hidden(A,f1_s9_funct_2)
       => ( ( p1_s9_funct_2(A)
           => r2_hidden(f3_s9_funct_2(A),f2_s9_funct_2) )
          & ( ~ p1_s9_funct_2(A)
           => r2_hidden(f4_s9_funct_2(A),f2_s9_funct_2) ) ) )
   => ? [A] :
        ( v1_funct_1(A)
        & v1_funct_2(A,f1_s9_funct_2,f2_s9_funct_2)
        & m2_relset_1(A,f1_s9_funct_2,f2_s9_funct_2)
        & ! [B] :
            ( r2_hidden(B,f1_s9_funct_2)
           => ( ( p1_s9_funct_2(B)
               => k1_funct_1(A,B) = f3_s9_funct_2(B) )
              & ( ~ p1_s9_funct_2(B)
               => k1_funct_1(A,B) = f4_s9_funct_2(B) ) ) ) ) ) ).

fof(s10_funct_2,axiom,
    ? [A] :
      ( v1_funct_1(A)
      & v1_funct_2(A,f1_s10_funct_2,f2_s10_funct_2)
      & m2_relset_1(A,f1_s10_funct_2,f2_s10_funct_2)
      & k8_funct_2(f1_s10_funct_2,f2_s10_funct_2,A,f3_s10_funct_2) = f4_s10_funct_2
      & ! [B] :
          ( m1_subset_1(B,f1_s10_funct_2)
         => ( B != f3_s10_funct_2
           => k8_funct_2(f1_s10_funct_2,f2_s10_funct_2,A,B) = f5_s10_funct_2(B) ) ) ) ).

fof(s11_funct_2,axiom,
    ( f3_s11_funct_2 != f4_s11_funct_2
   => ? [A] :
        ( v1_funct_1(A)
        & v1_funct_2(A,f1_s11_funct_2,f2_s11_funct_2)
        & m2_relset_1(A,f1_s11_funct_2,f2_s11_funct_2)
        & k8_funct_2(f1_s11_funct_2,f2_s11_funct_2,A,f3_s11_funct_2) = f5_s11_funct_2
        & k8_funct_2(f1_s11_funct_2,f2_s11_funct_2,A,f4_s11_funct_2) = f6_s11_funct_2
        & ! [B] :
            ( m1_subset_1(B,f1_s11_funct_2)
           => ~ ( B != f3_s11_funct_2
                & B != f4_s11_funct_2
                & k8_funct_2(f1_s11_funct_2,f2_s11_funct_2,A,B) != f7_s11_funct_2(B) ) ) ) ) ).

fof(s12_funct_2,axiom,
    ( ! [A] :
        ( m1_subset_1(A,f1_s12_funct_2)
       => r2_hidden(f3_s12_funct_2(A),f2_s12_funct_2) )
   => ? [A] :
        ( v1_funct_1(A)
        & v1_funct_2(A,f1_s12_funct_2,f2_s12_funct_2)
        & m2_relset_1(A,f1_s12_funct_2,f2_s12_funct_2)
        & ! [B] :
            ( m1_subset_1(B,f1_s12_funct_2)
           => k8_funct_2(f1_s12_funct_2,f2_s12_funct_2,A,B) = f3_s12_funct_2(B) ) ) ) ).

fof(s13_funct_2,axiom,
    ( ! [A] :
        ( m1_subset_1(A,f1_s13_funct_2)
       => m1_subset_1(f3_s13_funct_2(A),f2_s13_funct_2) )
   => ? [A] :
        ( v1_funct_1(A)
        & v1_funct_2(A,f1_s13_funct_2,f2_s13_funct_2)
        & m2_relset_1(A,f1_s13_funct_2,f2_s13_funct_2)
        & ! [B] :
            ( m1_subset_1(B,f1_s13_funct_2)
           => k8_funct_2(f1_s13_funct_2,f2_s13_funct_2,A,B) = f3_s13_funct_2(B) ) ) ) ).

fof(s14_funct_2,axiom,
    ( ! [A] :
        ( m1_subset_1(A,f1_s14_funct_2)
       => ? [B] :
            ( m1_subset_1(B,f2_s14_funct_2)
            & p1_s14_funct_2(A,B) ) )
   => ? [A] :
        ( v1_funct_1(A)
        & v1_funct_2(A,f1_s14_funct_2,f2_s14_funct_2)
        & m2_relset_1(A,f1_s14_funct_2,f2_s14_funct_2)
        & ! [B] :
            ( m1_subset_1(B,f1_s14_funct_2)
           => p1_s14_funct_2(B,k8_funct_2(f1_s14_funct_2,f2_s14_funct_2,A,B)) ) ) ) ).

fof(dt_k1_funct_2,axiom,
    $true ).

fof(dt_k2_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m1_relset_1(C,A,B) )
     => m1_subset_1(k2_funct_2(A,B,C,D),k1_zfmisc_1(B)) ) ).

fof(redefinition_k2_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m1_relset_1(C,A,B) )
     => k2_funct_2(A,B,C,D) = k9_relat_1(C,D) ) ).

fof(dt_k3_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(C)
        & m1_relset_1(C,A,B) )
     => m1_subset_1(k3_funct_2(A,B,C,D),k1_zfmisc_1(A)) ) ).

fof(redefinition_k3_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(C)
        & m1_relset_1(C,A,B) )
     => k3_funct_2(A,B,C,D) = k10_relat_1(C,D) ) ).

fof(dt_k4_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & m1_relset_1(B,A,A)
        & v1_funct_1(C)
        & v1_funct_2(C,A,A)
        & m1_relset_1(C,A,A) )
     => ( v1_funct_1(k4_funct_2(A,B,C))
        & v1_funct_2(k4_funct_2(A,B,C),A,A)
        & m2_relset_1(k4_funct_2(A,B,C),A,A) ) ) ).

fof(redefinition_k4_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & m1_relset_1(B,A,A)
        & v1_funct_1(C)
        & v1_funct_2(C,A,A)
        & m1_relset_1(C,A,A) )
     => k4_funct_2(A,B,C) = k5_relat_1(B,C) ) ).

fof(dt_k5_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & v3_funct_2(B,A,A)
        & m1_relset_1(B,A,A)
        & v1_funct_1(C)
        & v1_funct_2(C,A,A)
        & v3_funct_2(C,A,A)
        & m1_relset_1(C,A,A) )
     => ( v1_funct_1(k5_funct_2(A,B,C))
        & v1_funct_2(k5_funct_2(A,B,C),A,A)
        & v3_funct_2(k5_funct_2(A,B,C),A,A)
        & m2_relset_1(k5_funct_2(A,B,C),A,A) ) ) ).

fof(redefinition_k5_funct_2,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & v3_funct_2(B,A,A)
        & m1_relset_1(B,A,A)
        & v1_funct_1(C)
        & v1_funct_2(C,A,A)
        & v3_funct_2(C,A,A)
        & m1_relset_1(C,A,A) )
     => k5_funct_2(A,B,C) = k5_relat_1(B,C) ) ).

fof(dt_k6_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & v3_funct_2(B,A,A)
        & m1_relset_1(B,A,A) )
     => ( v1_funct_1(k6_funct_2(A,B))
        & v1_funct_2(k6_funct_2(A,B),A,A)
        & v3_funct_2(k6_funct_2(A,B),A,A)
        & m2_relset_1(k6_funct_2(A,B),A,A) ) ) ).

fof(redefinition_k6_funct_2,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & v3_funct_2(B,A,A)
        & m1_relset_1(B,A,A) )
     => k6_funct_2(A,B) = k2_funct_1(B) ) ).

fof(dt_k7_funct_2,axiom,
    ! [A,B,C,D,E] :
      ( ( ~ v1_xboole_0(B)
        & v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m1_relset_1(D,A,B)
        & v1_funct_1(E)
        & v1_funct_2(E,B,C)
        & m1_relset_1(E,B,C) )
     => ( v1_funct_1(k7_funct_2(A,B,C,D,E))
        & v1_funct_2(k7_funct_2(A,B,C,D,E),A,C)
        & m2_relset_1(k7_funct_2(A,B,C,D,E),A,C) ) ) ).

fof(redefinition_k7_funct_2,axiom,
    ! [A,B,C,D,E] :
      ( ( ~ v1_xboole_0(B)
        & v1_funct_1(D)
        & v1_funct_2(D,A,B)
        & m1_relset_1(D,A,B)
        & v1_funct_1(E)
        & v1_funct_2(E,B,C)
        & m1_relset_1(E,B,C) )
     => k7_funct_2(A,B,C,D,E) = k5_relat_1(D,E) ) ).

fof(dt_k8_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m1_relset_1(C,A,B)
        & m1_subset_1(D,A) )
     => m1_subset_1(k8_funct_2(A,B,C,D),B) ) ).

fof(redefinition_k8_funct_2,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m1_relset_1(C,A,B)
        & m1_subset_1(D,A) )
     => k8_funct_2(A,B,C,D) = k1_funct_1(C,D) ) ).

fof(dt_k9_funct_2,axiom,
    ! [A,B,C] :
      ( v1_funct_1(k9_funct_2(A,B,C))
      & v1_funct_2(k9_funct_2(A,B,C),k2_zfmisc_1(k1_tarski(A),k1_tarski(B)),k1_tarski(C))
      & m2_relset_1(k9_funct_2(A,B,C),k2_zfmisc_1(k1_tarski(A),k1_tarski(B)),k1_tarski(C)) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(fc1_funcop_1,axiom,
    ! [A,B] :
      ( v1_relat_1(k2_funcop_1(A,B))
      & v1_funct_1(k2_funcop_1(A,B)) ) ).

fof(fc2_funcop_1,axiom,
    ! [A] :
      ( v1_xboole_0(k2_funcop_1(k1_xboole_0,A))
      & v1_relat_1(k2_funcop_1(k1_xboole_0,A))
      & v1_funct_1(k2_funcop_1(k1_xboole_0,A))
      & v2_funct_1(k2_funcop_1(k1_xboole_0,A)) ) ).

fof(fc3_funcop_1,axiom,
    ! [A,B] :
      ( v1_xboole_0(B)
     => ( v1_xboole_0(k2_funcop_1(B,A))
        & v1_relat_1(k2_funcop_1(B,A))
        & v1_funct_1(k2_funcop_1(B,A))
        & v2_funct_1(k2_funcop_1(B,A)) ) ) ).

fof(fc4_funcop_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_relat_1(B)
        & v1_funct_1(B)
        & v1_relat_1(C)
        & v1_funct_1(C) )
     => ( v1_relat_1(k3_funcop_1(A,B,C))
        & v1_funct_1(k3_funcop_1(A,B,C)) ) ) ).

fof(fc5_funcop_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_relat_1(B)
        & v1_funct_1(B) )
     => ( v1_relat_1(k4_funcop_1(A,B,C))
        & v1_funct_1(k4_funcop_1(A,B,C)) ) ) ).

fof(fc6_funcop_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_relat_1(C)
        & v1_funct_1(C) )
     => ( v1_relat_1(k5_funcop_1(A,B,C))
        & v1_funct_1(k5_funcop_1(A,B,C)) ) ) ).

fof(rc1_funcop_1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A)
      & v1_funcop_1(A) ) ).

fof(fc7_funcop_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_funcop_1(A) )
     => ( v1_relat_1(k1_funct_1(A,B))
        & v1_funct_1(k1_funct_1(A,B)) ) ) ).

fof(fc8_funcop_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_funcop_1(A)
        & v1_relat_1(B)
        & v1_funct_1(B) )
     => ( v1_relat_1(k5_relat_1(B,A))
        & v1_funct_1(k5_relat_1(B,A))
        & v1_funcop_1(k5_relat_1(B,A)) ) ) ).

fof(fc9_funcop_1,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ( v1_relat_1(k2_funcop_1(A,B))
        & v2_relat_1(k2_funcop_1(A,B))
        & v1_funct_1(k2_funcop_1(A,B)) ) ) ).

fof(t1_funcop_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B,C] :
          ( A = k2_zfmisc_1(B,C)
         => ( B = k1_xboole_0
            | C = k1_xboole_0
            | ( k1_relat_1(A) = B
              & k2_relat_1(A) = C ) ) ) ) ).

fof(t2_funcop_1,axiom,
    ! [A] : k12_funct_3(A) = k13_funct_3(k6_partfun1(A),k6_partfun1(A)) ).

fof(t3_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( k1_relat_1(A) = k1_relat_1(B)
               => k1_relat_1(k5_relat_1(C,A)) = k1_relat_1(k5_relat_1(C,B)) ) ) ) ) ).

fof(t4_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( ( k1_relat_1(A) = k1_xboole_0
              & k1_relat_1(B) = k1_xboole_0 )
           => A = B ) ) ) ).

fof(d1_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( B = k1_funcop_1(A)
          <=> ( k1_relat_1(B) = k1_relat_1(A)
              & ! [C] :
                  ( r2_hidden(C,k1_relat_1(A))
                 => ( ! [D,E] :
                        ( k1_funct_1(A,C) = k4_tarski(D,E)
                       => k1_funct_1(B,C) = k4_tarski(E,D) )
                    & ~ ( k1_funct_1(A,C) != k1_funct_1(B,C)
                        & ! [D,E] : k1_funct_1(A,C) != k4_tarski(D,E) ) ) ) ) ) ) ) ).

fof(t5_funcop_1,axiom,
    $true ).

fof(t6_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => k13_funct_3(A,B) = k1_funcop_1(k13_funct_3(B,A)) ) ) ).

fof(t7_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] : k1_funcop_1(k7_relat_1(A,B)) = k7_relat_1(k1_funcop_1(A),B) ) ).

fof(t8_funcop_1,axiom,
    $true ).

fof(t9_funcop_1,axiom,
    ! [A] : k1_funcop_1(k12_funct_3(A)) = k12_funct_3(A) ).

fof(t10_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] : k7_relat_1(k13_funct_3(A,B),C) = k13_funct_3(k7_relat_1(A,C),B) ) ) ).

fof(t11_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] : k7_relat_1(k13_funct_3(A,B),C) = k13_funct_3(A,k7_relat_1(B,C)) ) ) ).

fof(d2_funcop_1,axiom,
    ! [A,B] : k2_funcop_1(A,B) = k2_zfmisc_1(A,k1_tarski(B)) ).

fof(t12_funcop_1,axiom,
    $true ).

fof(t13_funcop_1,axiom,
    ! [A,B,C] :
      ( r2_hidden(B,A)
     => k1_funct_1(k2_funcop_1(A,C),B) = C ) ).

fof(t14_funcop_1,axiom,
    ! [A,B] :
      ( A != k1_xboole_0
     => k2_relat_1(k2_funcop_1(A,B)) = k1_tarski(B) ) ).

fof(t15_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( k2_relat_1(A) = k1_tarski(B)
         => A = k2_funcop_1(k1_relat_1(A),B) ) ) ).

fof(t16_funcop_1,axiom,
    ! [A] :
      ( k1_relat_1(k2_funcop_1(k1_xboole_0,A)) = k1_xboole_0
      & k2_relat_1(k2_funcop_1(k1_xboole_0,A)) = k1_xboole_0 ) ).

fof(t17_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ! [C] :
              ( r2_hidden(C,k1_relat_1(A))
             => k1_funct_1(A,C) = B )
         => A = k2_funcop_1(k1_relat_1(A),B) ) ) ).

fof(t18_funcop_1,axiom,
    ! [A,B,C] : k7_relat_1(k2_funcop_1(A,B),C) = k2_funcop_1(k3_xboole_0(A,C),B) ).

fof(t19_funcop_1,axiom,
    ! [A,B] :
      ( k1_relat_1(k2_funcop_1(A,B)) = A
      & r1_tarski(k2_relat_1(k2_funcop_1(A,B)),k1_tarski(B)) ) ).

fof(t20_funcop_1,axiom,
    ! [A,B,C] :
      ( r2_hidden(B,C)
     => k10_relat_1(k2_funcop_1(A,B),C) = A ) ).

fof(t21_funcop_1,axiom,
    ! [A,B] : k10_relat_1(k2_funcop_1(A,B),k1_tarski(B)) = A ).

fof(t22_funcop_1,axiom,
    ! [A,B,C] :
      ( ~ r2_hidden(B,C)
     => k10_relat_1(k2_funcop_1(A,B),C) = k1_xboole_0 ) ).

fof(t23_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B,C] :
          ( r2_hidden(C,k1_relat_1(A))
         => k5_relat_1(k2_funcop_1(B,C),A) = k2_funcop_1(B,k1_funct_1(A,C)) ) ) ).

fof(t24_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B,C] :
          ~ ( B != k1_xboole_0
            & r2_hidden(C,k1_relat_1(A))
            & k1_relat_1(k5_relat_1(k2_funcop_1(B,C),A)) = k1_xboole_0 ) ) ).

fof(t25_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B,C] : k5_relat_1(A,k2_funcop_1(B,C)) = k2_funcop_1(k10_relat_1(A,B),C) ) ).

fof(t26_funcop_1,axiom,
    ! [A,B,C] : k1_funcop_1(k2_funcop_1(A,k4_tarski(B,C))) = k2_funcop_1(A,k4_tarski(C,B)) ).

fof(d3_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => k3_funcop_1(A,B,C) = k5_relat_1(k13_funct_3(B,C),A) ) ) ) ).

fof(t27_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ! [D] :
                  ( ( v1_relat_1(D)
                    & v1_funct_1(D) )
                 => ( ( k1_relat_1(D) = k1_relat_1(k3_funcop_1(C,A,B))
                      & ! [E] :
                          ( r2_hidden(E,k1_relat_1(k3_funcop_1(C,A,B)))
                         => k1_funct_1(D,E) = k1_binop_1(C,k1_funct_1(A,E),k1_funct_1(B,E)) ) )
                   => D = k3_funcop_1(C,A,B) ) ) ) ) ) ).

fof(t28_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ! [D] :
                  ( r2_hidden(D,k1_relat_1(k3_funcop_1(C,A,B)))
                 => k1_funct_1(k3_funcop_1(C,A,B),D) = k1_binop_1(C,k1_funct_1(A,D),k1_funct_1(B,D)) ) ) ) ) ).

fof(t29_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ! [D,E] :
                  ( ( v1_relat_1(E)
                    & v1_funct_1(E) )
                 => ( k7_relat_1(A,D) = k7_relat_1(B,D)
                   => k7_relat_1(k3_funcop_1(E,A,C),D) = k7_relat_1(k3_funcop_1(E,B,C),D) ) ) ) ) ) ).

fof(t30_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ! [D,E] :
                  ( ( v1_relat_1(E)
                    & v1_funct_1(E) )
                 => ( k7_relat_1(A,D) = k7_relat_1(B,D)
                   => k7_relat_1(k3_funcop_1(E,C,A),D) = k7_relat_1(k3_funcop_1(E,C,B),D) ) ) ) ) ) ).

fof(t31_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ! [D] :
                  ( ( v1_relat_1(D)
                    & v1_funct_1(D) )
                 => k5_relat_1(C,k3_funcop_1(D,A,B)) = k3_funcop_1(D,k5_relat_1(C,A),k5_relat_1(C,B)) ) ) ) ) ).

fof(t32_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ! [D] :
                  ( ( v1_relat_1(D)
                    & v1_funct_1(D) )
                 => k5_relat_1(k3_funcop_1(D,B,C),A) = k3_funcop_1(k5_relat_1(D,A),B,C) ) ) ) ) ).

fof(d4_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] : k4_funcop_1(A,B,C) = k5_relat_1(k13_funct_3(B,k2_funcop_1(k1_relat_1(B),C)),A) ) ) ).

fof(t33_funcop_1,axiom,
    $true ).

fof(t34_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] : k4_funcop_1(B,A,C) = k3_funcop_1(B,A,k2_funcop_1(k1_relat_1(A),C)) ) ) ).

fof(t35_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C,D] :
              ( r2_hidden(C,k1_relat_1(k4_funcop_1(B,A,D)))
             => k1_funct_1(k4_funcop_1(B,A,D),C) = k1_binop_1(B,k1_funct_1(A,C),D) ) ) ) ).

fof(t36_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C,D] :
              ( ( v1_relat_1(D)
                & v1_funct_1(D) )
             => ! [E] :
                  ( k7_relat_1(A,C) = k7_relat_1(B,C)
                 => k7_relat_1(k4_funcop_1(D,A,E),C) = k7_relat_1(k4_funcop_1(D,B,E),C) ) ) ) ) ).

fof(t37_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ! [D] : k5_relat_1(B,k4_funcop_1(C,A,D)) = k4_funcop_1(C,k5_relat_1(B,A),D) ) ) ) ).

fof(t38_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ! [D] : k5_relat_1(k4_funcop_1(C,B,D),A) = k4_funcop_1(k5_relat_1(C,A),B,D) ) ) ) ).

fof(t39_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B,C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ! [D] : k5_relat_1(k6_partfun1(B),k4_funcop_1(C,A,D)) = k4_funcop_1(C,k7_relat_1(A,B),D) ) ) ).

fof(d5_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B,C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => k5_funcop_1(A,B,C) = k5_relat_1(k13_funct_3(k2_funcop_1(k1_relat_1(C),B),C),A) ) ) ).

fof(t40_funcop_1,axiom,
    $true ).

fof(t41_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] : k5_funcop_1(B,C,A) = k3_funcop_1(B,k2_funcop_1(k1_relat_1(A),C),A) ) ) ).

fof(t42_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C,D] :
              ( r2_hidden(C,k1_relat_1(k5_funcop_1(B,D,A)))
             => k1_funct_1(k5_funcop_1(B,D,A),C) = k1_binop_1(B,D,k1_funct_1(A,C)) ) ) ) ).

fof(t43_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C,D] :
              ( ( v1_relat_1(D)
                & v1_funct_1(D) )
             => ! [E] :
                  ( k7_relat_1(A,C) = k7_relat_1(B,C)
                 => k7_relat_1(k5_funcop_1(D,E,A),C) = k7_relat_1(k5_funcop_1(D,E,B),C) ) ) ) ) ).

fof(t44_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ! [D] : k5_relat_1(B,k5_funcop_1(C,D,A)) = k5_funcop_1(C,D,k5_relat_1(B,A)) ) ) ) ).

fof(t45_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ! [D] : k5_relat_1(k5_funcop_1(C,D,B),A) = k5_funcop_1(k5_relat_1(C,A),D,B) ) ) ) ).

fof(t46_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B,C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ! [D] : k5_relat_1(k6_partfun1(B),k5_funcop_1(C,D,A)) = k5_funcop_1(C,D,k7_relat_1(A,B)) ) ) ).

fof(t47_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,A,B)
                        & m2_relset_1(E,A,B) )
                     => ( v1_funct_1(k3_funcop_1(C,D,E))
                        & v1_funct_2(k3_funcop_1(C,D,E),A,B)
                        & m2_relset_1(k3_funcop_1(C,D,E),A,B) ) ) ) ) ) ) ).

fof(t48_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,B,A)
                    & m2_relset_1(D,B,A) )
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,B,A)
                        & m2_relset_1(E,B,A) )
                     => ! [F] :
                          ( m1_subset_1(F,B)
                         => k8_funct_2(B,A,k6_funcop_1(A,B,C,D,E),F) = k2_binop_1(A,A,A,C,k8_funct_2(B,A,D,F),k8_funct_2(B,A,E,F)) ) ) ) ) ) ) ).

fof(t49_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,A,B)
                        & m2_relset_1(E,A,B) )
                     => ! [F] :
                          ( ( v1_funct_1(F)
                            & v1_funct_2(F,A,B)
                            & m2_relset_1(F,A,B) )
                         => ( ! [G] :
                                ( m1_subset_1(G,A)
                               => k8_funct_2(A,B,F,G) = k2_binop_1(B,B,B,C,k8_funct_2(A,B,D,G),k8_funct_2(A,B,E,G)) )
                           => F = k6_funcop_1(B,A,C,D,E) ) ) ) ) ) ) ) ).

fof(t50_funcop_1,axiom,
    $true ).

fof(t51_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,B,B)
                        & m2_relset_1(E,B,B) )
                     => k7_funct_2(A,B,B,D,k6_funcop_1(B,B,C,k6_partfun1(B),E)) = k6_funcop_1(B,A,C,D,k7_funct_2(A,B,B,D,E)) ) ) ) ) ) ).

fof(t52_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,B,B)
                        & m2_relset_1(E,B,B) )
                     => k7_funct_2(A,B,B,D,k6_funcop_1(B,B,C,E,k6_partfun1(B))) = k6_funcop_1(B,A,C,k7_funct_2(A,B,B,D,E),D) ) ) ) ) ) ).

fof(t53_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => k7_funct_2(A,B,B,D,k6_funcop_1(B,B,C,k6_partfun1(B),k6_partfun1(B))) = k6_funcop_1(B,A,C,D,D) ) ) ) ) ).

fof(t54_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,k2_zfmisc_1(A,A),A)
            & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
         => ! [C] :
              ( m1_subset_1(C,A)
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,A)
                    & m2_relset_1(D,A,A) )
                 => k8_funct_2(A,A,k6_funcop_1(A,A,B,k6_partfun1(A),D),C) = k2_binop_1(A,A,A,B,C,k8_funct_2(A,A,D,C)) ) ) ) ) ).

fof(t55_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,k2_zfmisc_1(A,A),A)
            & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
         => ! [C] :
              ( m1_subset_1(C,A)
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,A)
                    & m2_relset_1(D,A,A) )
                 => k8_funct_2(A,A,k6_funcop_1(A,A,B,D,k6_partfun1(A)),C) = k2_binop_1(A,A,A,B,k8_funct_2(A,A,D,C),C) ) ) ) ) ).

fof(t56_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,k2_zfmisc_1(A,A),A)
            & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
         => ! [C] :
              ( m1_subset_1(C,A)
             => k8_funct_2(A,A,k6_funcop_1(A,A,B,k6_partfun1(A),k6_partfun1(A)),C) = k2_binop_1(A,A,A,B,C,C) ) ) ) ).

fof(t57_funcop_1,axiom,
    ! [A,B,C] :
      ( r2_hidden(C,B)
     => ( v1_funct_1(k2_funcop_1(A,C))
        & v1_funct_2(k2_funcop_1(A,C),A,B)
        & m2_relset_1(k2_funcop_1(A,C),A,B) ) ) ).

fof(t58_funcop_1,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ! [C] :
          ( m1_subset_1(C,B)
         => ( v1_funct_1(k2_funcop_1(A,C))
            & v1_funct_2(k2_funcop_1(A,C),A,B)
            & m2_relset_1(k2_funcop_1(A,C),A,B) ) ) ) ).

fof(t59_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => ! [E] :
                      ( m1_subset_1(E,B)
                     => ( v1_funct_1(k4_funcop_1(C,D,E))
                        & v1_funct_2(k4_funcop_1(C,D,E),A,B)
                        & m2_relset_1(k4_funcop_1(C,D,E),A,B) ) ) ) ) ) ) ).

fof(t60_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,B,A)
                    & m2_relset_1(D,B,A) )
                 => ! [E] :
                      ( m1_subset_1(E,A)
                     => ! [F] :
                          ( m1_subset_1(F,B)
                         => k8_funct_2(B,A,k7_funcop_1(A,B,C,D,E),F) = k2_binop_1(A,A,A,C,k8_funct_2(B,A,D,F),E) ) ) ) ) ) ) ).

fof(t61_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,B,A)
                    & m2_relset_1(D,B,A) )
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,B,A)
                        & m2_relset_1(E,B,A) )
                     => ! [F] :
                          ( m1_subset_1(F,A)
                         => ( ! [G] :
                                ( m1_subset_1(G,B)
                               => k8_funct_2(B,A,D,G) = k2_binop_1(A,A,A,C,k8_funct_2(B,A,E,G),F) )
                           => D = k7_funcop_1(A,B,C,E,F) ) ) ) ) ) ) ) ).

fof(t62_funcop_1,axiom,
    $true ).

fof(t63_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => ! [E] :
                      ( m1_subset_1(E,B)
                     => k7_funct_2(A,B,B,D,k7_funcop_1(B,B,C,k6_partfun1(B),E)) = k7_funcop_1(B,A,C,D,E) ) ) ) ) ) ).

fof(t64_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,k2_zfmisc_1(A,A),A)
            & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
         => ! [C] :
              ( m1_subset_1(C,A)
             => k8_funct_2(A,A,k7_funcop_1(A,A,B,k6_partfun1(A),C),C) = k2_binop_1(A,A,A,B,C,C) ) ) ) ).

fof(t65_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => ! [E] :
                      ( m1_subset_1(E,B)
                     => ( v1_funct_1(k5_funcop_1(C,E,D))
                        & v1_funct_2(k5_funcop_1(C,E,D),A,B)
                        & m2_relset_1(k5_funcop_1(C,E,D),A,B) ) ) ) ) ) ) ).

fof(t66_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,B,A)
                    & m2_relset_1(D,B,A) )
                 => ! [E] :
                      ( m1_subset_1(E,A)
                     => ! [F] :
                          ( m1_subset_1(F,B)
                         => k8_funct_2(B,A,k8_funcop_1(A,B,C,E,D),F) = k2_binop_1(A,A,A,C,E,k8_funct_2(B,A,D,F)) ) ) ) ) ) ) ).

fof(t67_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,B,A)
                    & m2_relset_1(D,B,A) )
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,B,A)
                        & m2_relset_1(E,B,A) )
                     => ! [F] :
                          ( m1_subset_1(F,A)
                         => ( ! [G] :
                                ( m1_subset_1(G,B)
                               => k8_funct_2(B,A,D,G) = k2_binop_1(A,A,A,C,F,k8_funct_2(B,A,E,G)) )
                           => D = k8_funcop_1(A,B,C,F,E) ) ) ) ) ) ) ) ).

fof(t68_funcop_1,axiom,
    $true ).

fof(t69_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => ! [E] :
                      ( m1_subset_1(E,B)
                     => k7_funct_2(A,B,B,D,k8_funcop_1(B,B,C,E,k6_partfun1(B))) = k8_funcop_1(B,A,C,E,D) ) ) ) ) ) ).

fof(t70_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,k2_zfmisc_1(A,A),A)
            & m2_relset_1(B,k2_zfmisc_1(A,A),A) )
         => ! [C] :
              ( m1_subset_1(C,A)
             => k8_funct_2(A,A,k8_funcop_1(A,A,B,C,k6_partfun1(A)),C) = k2_binop_1(A,A,A,B,C,C) ) ) ) ).

fof(t71_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,k2_zfmisc_1(B,C))
                    & m2_relset_1(D,A,k2_zfmisc_1(B,C)) )
                 => ! [E] :
                      ( m1_subset_1(E,A)
                     => k1_funct_1(k1_funcop_1(D),E) = k4_tarski(k2_mcart_1(k8_funct_2(A,k2_zfmisc_1(B,C),D,E)),k1_mcart_1(k8_funct_2(A,k2_zfmisc_1(B,C),D,E))) ) ) ) ) ) ).

fof(t72_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,k2_zfmisc_1(B,C))
                    & m2_relset_1(D,A,k2_zfmisc_1(B,C)) )
                 => m2_relset_1(k2_relat_1(D),B,C) ) ) ) ) ).

fof(t73_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,k2_zfmisc_1(B,C))
                    & m2_relset_1(D,A,k2_zfmisc_1(B,C)) )
                 => k9_funcop_1(A,C,B,k10_funcop_1(A,B,C,D)) = k4_relat_1(k9_funcop_1(A,B,C,D)) ) ) ) ) ).

fof(t74_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => ! [E] :
                      ( m1_subset_1(E,B)
                     => ! [F] :
                          ( m1_subset_1(F,B)
                         => ( v2_binop_1(C,B)
                           => k7_funcop_1(B,A,C,k8_funcop_1(B,A,C,E,D),F) = k8_funcop_1(B,A,C,E,k7_funcop_1(B,A,C,D,F)) ) ) ) ) ) ) ) ).

fof(t75_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,A,B)
                        & m2_relset_1(E,A,B) )
                     => ! [F] :
                          ( m1_subset_1(F,B)
                         => ( v2_binop_1(C,B)
                           => k6_funcop_1(B,A,C,k7_funcop_1(B,A,C,D,F),E) = k6_funcop_1(B,A,C,D,k8_funcop_1(B,A,C,F,E)) ) ) ) ) ) ) ) ).

fof(t76_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,A,B)
                        & m2_relset_1(E,A,B) )
                     => ! [F] :
                          ( ( v1_funct_1(F)
                            & v1_funct_2(F,A,B)
                            & m2_relset_1(F,A,B) )
                         => ( v2_binop_1(C,B)
                           => k6_funcop_1(B,A,C,k6_funcop_1(B,A,C,D,E),F) = k6_funcop_1(B,A,C,D,k6_funcop_1(B,A,C,E,F)) ) ) ) ) ) ) ) ).

fof(t77_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => ! [E] :
                      ( m1_subset_1(E,B)
                     => ! [F] :
                          ( m1_subset_1(F,B)
                         => ( v2_binop_1(C,B)
                           => k8_funcop_1(B,A,C,k2_binop_1(B,B,B,C,E,F),D) = k8_funcop_1(B,A,C,E,k8_funcop_1(B,A,C,F,D)) ) ) ) ) ) ) ) ).

fof(t78_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => ! [E] :
                      ( m1_subset_1(E,B)
                     => ! [F] :
                          ( m1_subset_1(F,B)
                         => ( v2_binop_1(C,B)
                           => k7_funcop_1(B,A,C,D,k2_binop_1(B,B,B,C,E,F)) = k7_funcop_1(B,A,C,k7_funcop_1(B,A,C,D,E),F) ) ) ) ) ) ) ) ).

fof(t79_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => ! [E] :
                      ( m1_subset_1(E,B)
                     => ( v1_binop_1(C,B)
                       => k8_funcop_1(B,A,C,E,D) = k7_funcop_1(B,A,C,D,E) ) ) ) ) ) ) ).

fof(t80_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,A,B)
                        & m2_relset_1(E,A,B) )
                     => ( v1_binop_1(C,B)
                       => k6_funcop_1(B,A,C,D,E) = k6_funcop_1(B,A,C,E,D) ) ) ) ) ) ) ).

fof(t81_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(B,B),B)
                & m2_relset_1(C,k2_zfmisc_1(B,B),B) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,A,B)
                    & m2_relset_1(D,A,B) )
                 => ( v3_binop_1(C,B)
                   => k6_funcop_1(B,A,C,D,D) = D ) ) ) ) ) ).

fof(t82_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,B,A)
                    & m2_relset_1(D,B,A) )
                 => ! [E] :
                      ( m1_subset_1(E,B)
                     => ( v3_binop_1(C,A)
                       => k8_funct_2(B,A,k8_funcop_1(A,B,C,k8_funct_2(B,A,D,E),D),E) = k8_funct_2(B,A,D,E) ) ) ) ) ) ) ).

fof(t83_funcop_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,B,A)
                    & m2_relset_1(D,B,A) )
                 => ! [E] :
                      ( m1_subset_1(E,B)
                     => ( v3_binop_1(C,A)
                       => k8_funct_2(B,A,k7_funcop_1(A,B,C,D,k8_funct_2(B,A,D,E)),E) = k8_funct_2(B,A,D,E) ) ) ) ) ) ) ).

fof(t84_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( r1_tarski(k2_zfmisc_1(k2_relat_1(B),k2_relat_1(C)),k1_relat_1(A))
               => k1_relat_1(k3_funcop_1(A,B,C)) = k3_xboole_0(k1_relat_1(B),k1_relat_1(C)) ) ) ) ) ).

fof(d6_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v1_funcop_1(A)
      <=> ! [B] :
            ( r2_hidden(B,k1_relat_1(A))
           => ( v1_relat_1(k1_funct_1(A,B))
              & v1_funct_1(k1_funct_1(A,B)) ) ) ) ) ).

fof(dt_k1_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v1_relat_1(k1_funcop_1(A))
        & v1_funct_1(k1_funcop_1(A)) ) ) ).

fof(involutiveness_k1_funcop_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => k1_funcop_1(k1_funcop_1(A)) = A ) ).

fof(dt_k2_funcop_1,axiom,
    $true ).

fof(dt_k3_funcop_1,axiom,
    $true ).

fof(dt_k4_funcop_1,axiom,
    $true ).

fof(dt_k5_funcop_1,axiom,
    $true ).

fof(dt_k6_funcop_1,axiom,
    ! [A,B,C,D,E] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & v1_funct_1(C)
        & v1_funct_2(C,k2_zfmisc_1(A,A),A)
        & m1_relset_1(C,k2_zfmisc_1(A,A),A)
        & v1_funct_1(D)
        & v1_funct_2(D,B,A)
        & m1_relset_1(D,B,A)
        & v1_funct_1(E)
        & v1_funct_2(E,B,A)
        & m1_relset_1(E,B,A) )
     => ( v1_funct_1(k6_funcop_1(A,B,C,D,E))
        & v1_funct_2(k6_funcop_1(A,B,C,D,E),B,A)
        & m2_relset_1(k6_funcop_1(A,B,C,D,E),B,A) ) ) ).

fof(redefinition_k6_funcop_1,axiom,
    ! [A,B,C,D,E] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & v1_funct_1(C)
        & v1_funct_2(C,k2_zfmisc_1(A,A),A)
        & m1_relset_1(C,k2_zfmisc_1(A,A),A)
        & v1_funct_1(D)
        & v1_funct_2(D,B,A)
        & m1_relset_1(D,B,A)
        & v1_funct_1(E)
        & v1_funct_2(E,B,A)
        & m1_relset_1(E,B,A) )
     => k6_funcop_1(A,B,C,D,E) = k3_funcop_1(C,D,E) ) ).

fof(dt_k7_funcop_1,axiom,
    ! [A,B,C,D,E] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & v1_funct_1(C)
        & v1_funct_2(C,k2_zfmisc_1(A,A),A)
        & m1_relset_1(C,k2_zfmisc_1(A,A),A)
        & v1_funct_1(D)
        & v1_funct_2(D,B,A)
        & m1_relset_1(D,B,A)
        & m1_subset_1(E,A) )
     => ( v1_funct_1(k7_funcop_1(A,B,C,D,E))
        & v1_funct_2(k7_funcop_1(A,B,C,D,E),B,A)
        & m2_relset_1(k7_funcop_1(A,B,C,D,E),B,A) ) ) ).

fof(redefinition_k7_funcop_1,axiom,
    ! [A,B,C,D,E] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & v1_funct_1(C)
        & v1_funct_2(C,k2_zfmisc_1(A,A),A)
        & m1_relset_1(C,k2_zfmisc_1(A,A),A)
        & v1_funct_1(D)
        & v1_funct_2(D,B,A)
        & m1_relset_1(D,B,A)
        & m1_subset_1(E,A) )
     => k7_funcop_1(A,B,C,D,E) = k4_funcop_1(C,D,E) ) ).

fof(dt_k8_funcop_1,axiom,
    ! [A,B,C,D,E] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & v1_funct_1(C)
        & v1_funct_2(C,k2_zfmisc_1(A,A),A)
        & m1_relset_1(C,k2_zfmisc_1(A,A),A)
        & m1_subset_1(D,A)
        & v1_funct_1(E)
        & v1_funct_2(E,B,A)
        & m1_relset_1(E,B,A) )
     => ( v1_funct_1(k8_funcop_1(A,B,C,D,E))
        & v1_funct_2(k8_funcop_1(A,B,C,D,E),B,A)
        & m2_relset_1(k8_funcop_1(A,B,C,D,E),B,A) ) ) ).

fof(redefinition_k8_funcop_1,axiom,
    ! [A,B,C,D,E] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & v1_funct_1(C)
        & v1_funct_2(C,k2_zfmisc_1(A,A),A)
        & m1_relset_1(C,k2_zfmisc_1(A,A),A)
        & m1_subset_1(D,A)
        & v1_funct_1(E)
        & v1_funct_2(E,B,A)
        & m1_relset_1(E,B,A) )
     => k8_funcop_1(A,B,C,D,E) = k5_funcop_1(C,D,E) ) ).

fof(dt_k9_funcop_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C)
        & v1_funct_1(D)
        & v1_funct_2(D,A,k2_zfmisc_1(B,C))
        & m1_relset_1(D,A,k2_zfmisc_1(B,C)) )
     => m2_relset_1(k9_funcop_1(A,B,C,D),B,C) ) ).

fof(redefinition_k9_funcop_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C)
        & v1_funct_1(D)
        & v1_funct_2(D,A,k2_zfmisc_1(B,C))
        & m1_relset_1(D,A,k2_zfmisc_1(B,C)) )
     => k9_funcop_1(A,B,C,D) = k2_relat_1(D) ) ).

fof(dt_k10_funcop_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C)
        & v1_funct_1(D)
        & v1_funct_2(D,A,k2_zfmisc_1(B,C))
        & m1_relset_1(D,A,k2_zfmisc_1(B,C)) )
     => ( v1_funct_1(k10_funcop_1(A,B,C,D))
        & v1_funct_2(k10_funcop_1(A,B,C,D),A,k2_zfmisc_1(C,B))
        & m2_relset_1(k10_funcop_1(A,B,C,D),A,k2_zfmisc_1(C,B)) ) ) ).

fof(involutiveness_k10_funcop_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C)
        & v1_funct_1(D)
        & v1_funct_2(D,A,k2_zfmisc_1(B,C))
        & m1_relset_1(D,A,k2_zfmisc_1(B,C)) )
     => k10_funcop_1(A,B,C,k10_funcop_1(A,B,C,D)) = D ) ).

fof(redefinition_k10_funcop_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & ~ v1_xboole_0(B)
        & ~ v1_xboole_0(C)
        & v1_funct_1(D)
        & v1_funct_2(D,A,k2_zfmisc_1(B,C))
        & m1_relset_1(D,A,k2_zfmisc_1(B,C)) )
     => k10_funcop_1(A,B,C,D) = k1_funcop_1(D) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(fc1_funct_4,axiom,
    ! [A,B,C,D] :
      ( v1_relat_1(k4_funct_4(A,B,C,D))
      & v1_funct_1(k4_funct_4(A,B,C,D)) ) ).

fof(t1_funct_4,axiom,
    ! [A] :
      ~ ( ! [B] :
            ~ ( r2_hidden(B,A)
              & ! [C,D] : B != k4_tarski(C,D) )
        & ! [B,C] : ~ r1_tarski(A,k2_zfmisc_1(B,C)) ) ).

fof(t2_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => k5_relat_1(B,A) = k5_relat_1(B,k7_relat_1(A,k2_relat_1(B))) ) ) ).

fof(t3_funct_4,axiom,
    $true ).

fof(t4_funct_4,axiom,
    ! [A,B] :
      ( r1_tarski(k6_partfun1(A),k6_partfun1(B))
    <=> r1_tarski(A,B) ) ).

fof(t5_funct_4,axiom,
    ! [A,B,C] :
      ( r1_tarski(A,B)
     => r1_tarski(k2_funcop_1(A,C),k2_funcop_1(B,C)) ) ).

fof(t6_funct_4,axiom,
    ! [A,B,C,D] :
      ( r1_tarski(k2_funcop_1(A,B),k2_funcop_1(C,D))
     => r1_tarski(A,C) ) ).

fof(t7_funct_4,axiom,
    ! [A,B,C,D] :
      ( r1_tarski(k2_funcop_1(A,B),k2_funcop_1(C,D))
     => ( A = k1_xboole_0
        | B = D ) ) ).

fof(t8_funct_4,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( r2_hidden(A,k1_relat_1(B))
       => r1_tarski(k2_funcop_1(k1_tarski(A),k1_funct_1(B,A)),B) ) ) ).

fof(t9_funct_4,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => r1_tarski(k7_relat_1(k8_relat_1(A,C),B),C) ) ).

fof(t10_funct_4,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ! [D] :
          ( ( v1_relat_1(D)
            & v1_funct_1(D) )
         => ( r1_tarski(C,D)
           => r1_tarski(k7_relat_1(k8_relat_1(A,C),B),k7_relat_1(k8_relat_1(A,D),B)) ) ) ) ).

fof(d1_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( C = k1_funct_4(A,B)
              <=> ( k1_relat_1(C) = k2_xboole_0(k1_relat_1(A),k1_relat_1(B))
                  & ! [D] :
                      ( r2_hidden(D,k2_xboole_0(k1_relat_1(A),k1_relat_1(B)))
                     => ( ( r2_hidden(D,k1_relat_1(B))
                         => k1_funct_1(C,D) = k1_funct_1(B,D) )
                        & ( ~ r2_hidden(D,k1_relat_1(B))
                         => k1_funct_1(C,D) = k1_funct_1(A,D) ) ) ) ) ) ) ) ) ).

fof(t11_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_tarski(k1_relat_1(A),k1_relat_1(k1_funct_4(A,B)))
            & r1_tarski(k1_relat_1(B),k1_relat_1(k1_funct_4(A,B))) ) ) ) ).

fof(t12_funct_4,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( ~ r2_hidden(A,k1_relat_1(B))
           => k1_funct_1(k1_funct_4(C,B),A) = k1_funct_1(C,A) ) ) ) ).

fof(t13_funct_4,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( r2_hidden(A,k1_relat_1(k1_funct_4(B,C)))
          <=> ( r2_hidden(A,k1_relat_1(B))
              | r2_hidden(A,k1_relat_1(C)) ) ) ) ) ).

fof(t14_funct_4,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( r2_hidden(A,k1_relat_1(B))
           => k1_funct_1(k1_funct_4(C,B),A) = k1_funct_1(B,A) ) ) ) ).

fof(t15_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => k1_funct_4(k1_funct_4(A,B),C) = k1_funct_4(A,k1_funct_4(B,C)) ) ) ) ).

fof(t16_funct_4,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( ( r1_partfun1(B,C)
              & r2_hidden(A,k1_relat_1(B)) )
           => k1_funct_1(k1_funct_4(B,C),A) = k1_funct_1(B,A) ) ) ) ).

fof(t17_funct_4,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( ( r1_xboole_0(k1_relat_1(B),k1_relat_1(C))
              & r2_hidden(A,k1_relat_1(B)) )
           => k1_funct_1(k1_funct_4(B,C),A) = k1_funct_1(B,A) ) ) ) ).

fof(t18_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => r1_tarski(k2_relat_1(k1_funct_4(A,B)),k2_xboole_0(k2_relat_1(A),k2_relat_1(B))) ) ) ).

fof(t19_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => r1_tarski(k2_relat_1(A),k2_relat_1(k1_funct_4(B,A))) ) ) ).

fof(t20_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_tarski(k1_relat_1(A),k1_relat_1(B))
           => k1_funct_4(A,B) = B ) ) ) ).

fof(t21_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => k1_funct_4(k1_xboole_0,A) = A ) ).

fof(t22_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => k1_funct_4(A,k1_xboole_0) = A ) ).

fof(t23_funct_4,axiom,
    ! [A,B] : k1_funct_4(k6_partfun1(A),k6_partfun1(B)) = k6_partfun1(k2_xboole_0(A,B)) ).

fof(t24_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => k7_relat_1(k1_funct_4(A,B),k1_relat_1(B)) = B ) ) ).

fof(t25_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => r1_tarski(k7_relat_1(k1_funct_4(A,B),k4_xboole_0(k1_relat_1(A),k1_relat_1(B))),A) ) ) ).

fof(t26_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => r1_tarski(A,k1_funct_4(B,A)) ) ) ).

fof(t27_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( r1_partfun1(A,k1_funct_4(B,C))
               => r1_partfun1(k7_relat_1(A,k4_xboole_0(k1_relat_1(A),k1_relat_1(C))),B) ) ) ) ) ).

fof(t28_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( r1_partfun1(A,k1_funct_4(B,C))
               => r1_partfun1(A,C) ) ) ) ) ).

fof(t29_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_partfun1(A,B)
          <=> r1_tarski(A,k1_funct_4(A,B)) ) ) ) ).

fof(t30_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => r1_tarski(k1_funct_4(A,B),k2_xboole_0(A,B)) ) ) ).

fof(t31_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_partfun1(A,B)
          <=> k2_xboole_0(A,B) = k1_funct_4(A,B) ) ) ) ).

fof(t32_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_xboole_0(k1_relat_1(A),k1_relat_1(B))
           => k2_xboole_0(A,B) = k1_funct_4(A,B) ) ) ) ).

fof(t33_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_xboole_0(k1_relat_1(A),k1_relat_1(B))
           => r1_tarski(A,k1_funct_4(A,B)) ) ) ) ).

fof(t34_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_xboole_0(k1_relat_1(A),k1_relat_1(B))
           => k7_relat_1(k1_funct_4(A,B),k1_relat_1(A)) = A ) ) ) ).

fof(t35_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_partfun1(A,B)
          <=> k1_funct_4(A,B) = k1_funct_4(B,A) ) ) ) ).

fof(t36_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_xboole_0(k1_relat_1(A),k1_relat_1(B))
           => k1_funct_4(A,B) = k1_funct_4(B,A) ) ) ) ).

fof(t37_funct_4,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,B) )
         => ( v1_partfun1(D,A,B)
           => k1_funct_4(C,D) = D ) ) ) ).

fof(t38_funct_4,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & v1_funct_2(D,A,B)
            & m2_relset_1(D,A,B) )
         => ( ( B = k1_xboole_0
             => A = k1_xboole_0 )
           => k1_funct_4(C,D) = D ) ) ) ).

fof(t39_funct_4,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,A,A)
        & m2_relset_1(B,A,A) )
     => ! [C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,A,A)
            & m2_relset_1(C,A,A) )
         => k1_funct_4(B,C) = C ) ) ).

fof(t40_funct_4,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ! [C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,A,B)
            & m2_relset_1(C,A,B) )
         => ! [D] :
              ( ( v1_funct_1(D)
                & v1_funct_2(D,A,B)
                & m2_relset_1(D,A,B) )
             => k1_funct_4(C,D) = D ) ) ) ).

fof(t41_funct_4,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(C)
        & m2_relset_1(C,A,B) )
     => ! [D] :
          ( ( v1_funct_1(D)
            & m2_relset_1(D,A,B) )
         => ( v1_funct_1(k1_funct_4(C,D))
            & m2_relset_1(k1_funct_4(C,D),A,B) ) ) ) ).

fof(d2_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( B = k2_funct_4(A)
          <=> ( ! [C] :
                  ( r2_hidden(C,k1_relat_1(B))
                <=> ? [D,E] :
                      ( C = k4_tarski(E,D)
                      & r2_hidden(k4_tarski(D,E),k1_relat_1(A)) ) )
              & ! [C,D] :
                  ( r2_hidden(k4_tarski(C,D),k1_relat_1(A))
                 => k1_funct_1(B,k4_tarski(D,C)) = k1_funct_1(A,k4_tarski(C,D)) ) ) ) ) ) ).

fof(t42_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => r1_tarski(k2_relat_1(k2_funct_4(A)),k2_relat_1(A)) ) ).

fof(t43_funct_4,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r2_hidden(k4_tarski(A,B),k1_relat_1(C))
      <=> r2_hidden(k4_tarski(B,A),k1_relat_1(k2_funct_4(C))) ) ) ).

fof(t44_funct_4,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r2_hidden(k4_tarski(A,B),k1_relat_1(k2_funct_4(C)))
       => k1_funct_1(k2_funct_4(C),k4_tarski(A,B)) = k1_funct_1(C,k4_tarski(B,A)) ) ) ).

fof(t45_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ? [B,C] : r1_tarski(k1_relat_1(k2_funct_4(A)),k2_zfmisc_1(B,C)) ) ).

fof(t46_funct_4,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r1_tarski(k1_relat_1(C),k2_zfmisc_1(A,B))
       => r1_tarski(k1_relat_1(k2_funct_4(C)),k2_zfmisc_1(B,A)) ) ) ).

fof(t47_funct_4,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( k1_relat_1(C) = k2_zfmisc_1(A,B)
       => k1_relat_1(k2_funct_4(C)) = k2_zfmisc_1(B,A) ) ) ).

fof(t48_funct_4,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r1_tarski(k1_relat_1(C),k2_zfmisc_1(A,B))
       => k2_relat_1(k2_funct_4(C)) = k2_relat_1(C) ) ) ).

fof(t49_funct_4,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & m2_relset_1(D,k2_zfmisc_1(A,B),C) )
     => ( v1_funct_1(k2_funct_4(D))
        & m2_relset_1(k2_funct_4(D),k2_zfmisc_1(B,A),C) ) ) ).

fof(t50_funct_4,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,k2_zfmisc_1(A,B),C)
        & m2_relset_1(D,k2_zfmisc_1(A,B),C) )
     => ( C != k1_xboole_0
       => ( v1_funct_1(k2_funct_4(D))
          & v1_funct_2(k2_funct_4(D),k2_zfmisc_1(B,A),C)
          & m2_relset_1(k2_funct_4(D),k2_zfmisc_1(B,A),C) ) ) ) ).

fof(t51_funct_4,axiom,
    ! [A,B,C] :
      ( ~ v1_xboole_0(C)
     => ! [D] :
          ( ( v1_funct_1(D)
            & v1_funct_2(D,k2_zfmisc_1(A,B),C)
            & m2_relset_1(D,k2_zfmisc_1(A,B),C) )
         => ( v1_funct_1(k2_funct_4(D))
            & v1_funct_2(k2_funct_4(D),k2_zfmisc_1(B,A),C)
            & m2_relset_1(k2_funct_4(D),k2_zfmisc_1(B,A),C) ) ) ) ).

fof(t52_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => r1_tarski(k2_funct_4(k2_funct_4(A)),A) ) ).

fof(t53_funct_4,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C) )
     => ( r1_tarski(k1_relat_1(C),k2_zfmisc_1(A,B))
       => k2_funct_4(k2_funct_4(C)) = C ) ) ).

fof(t54_funct_4,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & m2_relset_1(D,k2_zfmisc_1(A,B),C) )
     => k2_funct_4(k2_funct_4(D)) = D ) ).

fof(t55_funct_4,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(D)
        & v1_funct_2(D,k2_zfmisc_1(A,B),C)
        & m2_relset_1(D,k2_zfmisc_1(A,B),C) )
     => ( C != k1_xboole_0
       => k2_funct_4(k2_funct_4(D)) = D ) ) ).

fof(t56_funct_4,axiom,
    ! [A,B,C] :
      ( ~ v1_xboole_0(C)
     => ! [D] :
          ( ( v1_funct_1(D)
            & v1_funct_2(D,k2_zfmisc_1(A,B),C)
            & m2_relset_1(D,k2_zfmisc_1(A,B),C) )
         => k2_funct_4(k2_funct_4(D)) = D ) ) ).

fof(d3_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( C = k3_funct_4(A,B)
              <=> ( ! [D] :
                      ( r2_hidden(D,k1_relat_1(C))
                    <=> ? [E,F,G,H] :
                          ( D = k4_tarski(k4_tarski(E,G),k4_tarski(F,H))
                          & r2_hidden(k4_tarski(E,F),k1_relat_1(A))
                          & r2_hidden(k4_tarski(G,H),k1_relat_1(B)) ) )
                  & ! [D,E,F,G] :
                      ( ( r2_hidden(k4_tarski(D,E),k1_relat_1(A))
                        & r2_hidden(k4_tarski(F,G),k1_relat_1(B)) )
                     => k1_funct_1(C,k4_tarski(k4_tarski(D,F),k4_tarski(E,G))) = k4_tarski(k1_funct_1(A,k4_tarski(D,E)),k1_funct_1(B,k4_tarski(F,G))) ) ) ) ) ) ) ).

fof(t57_funct_4,axiom,
    ! [A,B,C,D,E] :
      ( ( v1_relat_1(E)
        & v1_funct_1(E) )
     => ! [F] :
          ( ( v1_relat_1(F)
            & v1_funct_1(F) )
         => ( r2_hidden(k4_tarski(k4_tarski(A,B),k4_tarski(C,D)),k1_relat_1(k3_funct_4(E,F)))
          <=> ( r2_hidden(k4_tarski(A,C),k1_relat_1(E))
              & r2_hidden(k4_tarski(B,D),k1_relat_1(F)) ) ) ) ) ).

fof(t58_funct_4,axiom,
    ! [A,B,C,D,E] :
      ( ( v1_relat_1(E)
        & v1_funct_1(E) )
     => ! [F] :
          ( ( v1_relat_1(F)
            & v1_funct_1(F) )
         => ( r2_hidden(k4_tarski(k4_tarski(A,B),k4_tarski(C,D)),k1_relat_1(k3_funct_4(E,F)))
           => k1_funct_1(k3_funct_4(E,F),k4_tarski(k4_tarski(A,B),k4_tarski(C,D))) = k4_tarski(k1_funct_1(E,k4_tarski(A,C)),k1_funct_1(F,k4_tarski(B,D))) ) ) ) ).

fof(t59_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => r1_tarski(k2_relat_1(k3_funct_4(A,B)),k2_zfmisc_1(k2_relat_1(A),k2_relat_1(B))) ) ) ).

fof(t60_funct_4,axiom,
    ! [A,B,C,D,E] :
      ( ( v1_relat_1(E)
        & v1_funct_1(E) )
     => ! [F] :
          ( ( v1_relat_1(F)
            & v1_funct_1(F) )
         => ( ( r1_tarski(k1_relat_1(E),k2_zfmisc_1(A,B))
              & r1_tarski(k1_relat_1(F),k2_zfmisc_1(C,D)) )
           => r1_tarski(k1_relat_1(k3_funct_4(E,F)),k2_zfmisc_1(k2_zfmisc_1(A,C),k2_zfmisc_1(B,D))) ) ) ) ).

fof(t61_funct_4,axiom,
    ! [A,B,C,D,E] :
      ( ( v1_relat_1(E)
        & v1_funct_1(E) )
     => ! [F] :
          ( ( v1_relat_1(F)
            & v1_funct_1(F) )
         => ( ( k1_relat_1(E) = k2_zfmisc_1(A,B)
              & k1_relat_1(F) = k2_zfmisc_1(C,D) )
           => k1_relat_1(k3_funct_4(E,F)) = k2_zfmisc_1(k2_zfmisc_1(A,C),k2_zfmisc_1(B,D)) ) ) ) ).

fof(t62_funct_4,axiom,
    ! [A,B,C,D,E,F,G] :
      ( ( v1_funct_1(G)
        & m2_relset_1(G,k2_zfmisc_1(A,B),C) )
     => ! [H] :
          ( ( v1_funct_1(H)
            & m2_relset_1(H,k2_zfmisc_1(D,E),F) )
         => ( v1_funct_1(k3_funct_4(G,H))
            & m2_relset_1(k3_funct_4(G,H),k2_zfmisc_1(k2_zfmisc_1(A,D),k2_zfmisc_1(B,E)),k2_zfmisc_1(C,F)) ) ) ) ).

fof(t63_funct_4,axiom,
    ! [A,B,C,D,E,F,G] :
      ( ( v1_funct_1(G)
        & v1_funct_2(G,k2_zfmisc_1(A,B),C)
        & m2_relset_1(G,k2_zfmisc_1(A,B),C) )
     => ! [H] :
          ( ( v1_funct_1(H)
            & v1_funct_2(H,k2_zfmisc_1(D,E),F)
            & m2_relset_1(H,k2_zfmisc_1(D,E),F) )
         => ~ ( C != k1_xboole_0
              & F != k1_xboole_0
              & ~ ( v1_funct_1(k3_funct_4(G,H))
                  & v1_funct_2(k3_funct_4(G,H),k2_zfmisc_1(k2_zfmisc_1(A,D),k2_zfmisc_1(B,E)),k2_zfmisc_1(C,F))
                  & m2_relset_1(k3_funct_4(G,H),k2_zfmisc_1(k2_zfmisc_1(A,D),k2_zfmisc_1(B,E)),k2_zfmisc_1(C,F)) ) ) ) ) ).

fof(t64_funct_4,axiom,
    ! [A,B,C,D,E] :
      ( ~ v1_xboole_0(E)
     => ! [F] :
          ( ~ v1_xboole_0(F)
         => ! [G] :
              ( ( v1_funct_1(G)
                & v1_funct_2(G,k2_zfmisc_1(A,B),E)
                & m2_relset_1(G,k2_zfmisc_1(A,B),E) )
             => ! [H] :
                  ( ( v1_funct_1(H)
                    & v1_funct_2(H,k2_zfmisc_1(C,D),F)
                    & m2_relset_1(H,k2_zfmisc_1(C,D),F) )
                 => ( v1_funct_1(k3_funct_4(G,H))
                    & v1_funct_2(k3_funct_4(G,H),k2_zfmisc_1(k2_zfmisc_1(A,C),k2_zfmisc_1(B,D)),k2_zfmisc_1(E,F))
                    & m2_relset_1(k3_funct_4(G,H),k2_zfmisc_1(k2_zfmisc_1(A,C),k2_zfmisc_1(B,D)),k2_zfmisc_1(E,F)) ) ) ) ) ) ).

fof(d4_funct_4,axiom,
    ! [A,B,C,D] : k4_funct_4(A,B,C,D) = k1_funct_4(k2_funcop_1(k1_tarski(A),C),k2_funcop_1(k1_tarski(B),D)) ).

fof(t65_funct_4,axiom,
    ! [A,B,C,D] :
      ( k1_relat_1(k4_funct_4(A,B,C,D)) = k2_tarski(A,B)
      & r1_tarski(k2_relat_1(k4_funct_4(A,B,C,D)),k2_tarski(C,D)) ) ).

fof(t66_funct_4,axiom,
    ! [A,B,C,D] :
      ( A != B
     => ( k1_funct_1(k4_funct_4(A,B,C,D),A) = C
        & k1_funct_1(k4_funct_4(A,B,C,D),B) = D ) ) ).

fof(t67_funct_4,axiom,
    ! [A,B,C,D] :
      ( A != B
     => k2_relat_1(k4_funct_4(A,B,C,D)) = k2_tarski(C,D) ) ).

fof(t68_funct_4,axiom,
    ! [A,B,C] : k4_funct_4(A,B,C,C) = k2_funcop_1(k2_tarski(A,B),C) ).

fof(t69_funct_4,axiom,
    ! [A,B,C,D,E] :
      ( ( v1_relat_1(E)
        & v1_funct_1(E) )
     => ( ( k1_relat_1(E) = k2_tarski(A,B)
          & k1_funct_1(E,A) = C
          & k1_funct_1(E,B) = D )
       => E = k4_funct_4(A,B,C,D) ) ) ).

fof(t70_funct_4,axiom,
    ! [A,B] : k2_funcop_1(k1_tarski(A),B) = k1_tarski(k4_tarski(A,B)) ).

fof(t71_funct_4,axiom,
    ! [A,B,C,D] :
      ( A != C
     => k4_funct_4(A,C,B,D) = k2_tarski(k4_tarski(A,B),k4_tarski(C,D)) ) ).

fof(t72_funct_4,axiom,
    ! [A,B,C,D,E,F] :
      ( k4_funct_4(A,B,C,D) = k4_funct_4(A,B,E,F)
     => ( A = B
        | ( C = E
          & D = F ) ) ) ).

fof(t73_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ! [D] :
                  ( ( v1_relat_1(D)
                    & v1_funct_1(D) )
                 => ( ( r1_tarski(k2_relat_1(C),k1_relat_1(A))
                      & r1_tarski(k2_relat_1(D),k1_relat_1(B))
                      & r1_partfun1(A,B) )
                   => k5_relat_1(k1_funct_4(C,D),k1_funct_4(A,B)) = k1_funct_4(k5_relat_1(C,A),k5_relat_1(D,B)) ) ) ) ) ) ).

fof(t74_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B,C] :
          ( r1_tarski(k1_relat_1(A),k2_xboole_0(B,C))
         => k1_funct_4(k7_relat_1(A,B),k7_relat_1(A,C)) = A ) ) ).

fof(t75_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] : k7_relat_1(k1_funct_4(A,B),C) = k1_funct_4(k7_relat_1(A,C),k7_relat_1(B,C)) ) ) ).

fof(t76_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( r1_xboole_0(C,k1_relat_1(B))
             => k7_relat_1(k1_funct_4(A,B),C) = k7_relat_1(A,C) ) ) ) ).

fof(t77_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( r1_xboole_0(k1_relat_1(A),C)
             => k7_relat_1(k1_funct_4(A,B),C) = k7_relat_1(B,C) ) ) ) ).

fof(t78_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( k1_relat_1(B) = k1_relat_1(C)
               => k1_funct_4(k1_funct_4(A,B),C) = k1_funct_4(A,C) ) ) ) ) ).

fof(t79_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ( r1_tarski(A,B)
           => ( k1_funct_4(A,B) = B
              & k1_funct_4(B,A) = B ) ) ) ) ).

fof(t80_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] : k1_funct_4(A,k7_relat_1(A,B)) = A ) ).

fof(t81_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C,D] :
              ( ( r1_tarski(k1_relat_1(A),C)
                & r1_tarski(k1_relat_1(B),D)
                & r1_xboole_0(C,D) )
             => ( k7_relat_1(k1_funct_4(A,B),C) = A
                & k7_relat_1(k1_funct_4(A,B),D) = B ) ) ) ) ).

fof(t82_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B) )
         => ! [C] :
              ( ( r1_tarski(k1_relat_1(A),C)
                & r1_xboole_0(k1_relat_1(B),C) )
             => k7_relat_1(k1_funct_4(A,B),C) = A ) ) ) ).

fof(t83_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B,C] : k7_relat_1(A,k2_xboole_0(B,C)) = k1_funct_4(k7_relat_1(A,B),k7_relat_1(A,C)) ) ).

fof(dt_k1_funct_4,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_relat_1(B)
        & v1_funct_1(B) )
     => ( v1_relat_1(k1_funct_4(A,B))
        & v1_funct_1(k1_funct_4(A,B)) ) ) ).

fof(idempotence_k1_funct_4,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_relat_1(B)
        & v1_funct_1(B) )
     => k1_funct_4(A,A) = A ) ).

fof(dt_k2_funct_4,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v1_relat_1(k2_funct_4(A))
        & v1_funct_1(k2_funct_4(A)) ) ) ).

fof(dt_k3_funct_4,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_relat_1(B)
        & v1_funct_1(B) )
     => ( v1_relat_1(k3_funct_4(A,B))
        & v1_funct_1(k3_funct_4(A,B)) ) ) ).

fof(dt_k4_funct_4,axiom,
    $true ).

fof(dt_k5_funct_4,axiom,
    ! [A,B,C,D,E] :
      ( ( ~ v1_xboole_0(A)
        & m1_subset_1(D,A)
        & m1_subset_1(E,A) )
     => ( v1_funct_1(k5_funct_4(A,B,C,D,E))
        & v1_funct_2(k5_funct_4(A,B,C,D,E),k2_tarski(B,C),A)
        & m2_relset_1(k5_funct_4(A,B,C,D,E),k2_tarski(B,C),A) ) ) ).

fof(redefinition_k5_funct_4,axiom,
    ! [A,B,C,D,E] :
      ( ( ~ v1_xboole_0(A)
        & m1_subset_1(D,A)
        & m1_subset_1(E,A) )
     => k5_funct_4(A,B,C,D,E) = k4_funct_4(B,C,D,E) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(fc1_ordinal2,axiom,
    ( v1_ordinal1(k5_ordinal2)
    & v2_ordinal1(k5_ordinal2)
    & v3_ordinal1(k5_ordinal2)
    & ~ v1_xboole_0(k5_ordinal2) ) ).

fof(rc1_ordinal2,axiom,
    ? [A] :
      ( v1_ordinal1(A)
      & v2_ordinal1(A)
      & v3_ordinal1(A)
      & v4_ordinal1(A) ) ).

fof(rc2_ordinal2,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A)
      & v5_ordinal1(A)
      & v1_ordinal2(A) ) ).

fof(cc1_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( m1_ordinal1(B,A)
         => v1_ordinal2(B) ) ) ).

fof(fc2_ordinal2,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A)
        & v1_ordinal2(A)
        & v3_ordinal1(B) )
     => ( v1_relat_1(k7_relat_1(A,B))
        & v1_funct_1(k7_relat_1(A,B))
        & v1_ordinal2(k7_relat_1(A,B)) ) ) ).

fof(fc3_ordinal2,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A)
        & v1_ordinal2(A)
        & v3_ordinal1(B) )
     => ( v1_ordinal1(k1_funct_1(A,B))
        & v2_ordinal1(k1_funct_1(A,B))
        & v3_ordinal1(k1_funct_1(A,B)) ) ) ).

fof(fc4_ordinal2,axiom,
    ! [A,B] :
      ( v3_ordinal1(B)
     => ( v1_relat_1(k2_funcop_1(A,B))
        & v1_funct_1(k2_funcop_1(A,B))
        & v1_ordinal2(k2_funcop_1(A,B)) ) ) ).

fof(t1_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( r1_ordinal1(A,B)
          <=> r1_ordinal1(k1_ordinal1(A),k1_ordinal1(B)) ) ) ) ).

fof(t2_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => k3_tarski(k1_ordinal1(A)) = A ) ).

fof(t3_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => r1_tarski(k1_ordinal1(A),k1_zfmisc_1(A)) ) ).

fof(t4_ordinal2,axiom,
    v4_ordinal1(k1_xboole_0) ).

fof(t5_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => r1_ordinal1(k3_tarski(A),A) ) ).

fof(d1_ordinal2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A) )
     => k1_ordinal2(A) = k1_funct_1(A,k3_tarski(k1_relat_1(A))) ) ).

fof(t6_ordinal2,axiom,
    $true ).

fof(t7_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v5_ordinal1(B) )
         => ( k1_relat_1(B) = k1_ordinal1(A)
           => k1_ordinal2(B) = k1_funct_1(B,A) ) ) ) ).

fof(d2_ordinal2,axiom,
    ! [A,B] :
      ( B = k2_ordinal2(A)
    <=> ! [C] :
          ( r2_hidden(C,B)
        <=> ( r2_hidden(C,A)
            & v3_ordinal1(C) ) ) ) ).

fof(d3_ordinal2,axiom,
    ! [A,B] :
      ( B = k3_ordinal2(A)
    <=> ! [C] :
          ( r2_hidden(C,B)
        <=> ( r2_hidden(C,A)
            & ? [D] :
                ( v3_ordinal1(D)
                & C = D
                & v4_ordinal1(D) ) ) ) ) ).

fof(t8_ordinal2,axiom,
    $true ).

fof(t9_ordinal2,axiom,
    ! [A] : r1_tarski(k2_ordinal2(A),A) ).

fof(t10_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => k2_ordinal2(A) = A ) ).

fof(t11_ordinal2,axiom,
    ! [A,B] :
      ( r1_tarski(A,B)
     => r1_tarski(k2_ordinal2(A),k2_ordinal2(B)) ) ).

fof(t12_ordinal2,axiom,
    $true ).

fof(t13_ordinal2,axiom,
    ! [A] : r1_tarski(k3_ordinal2(A),A) ).

fof(t14_ordinal2,axiom,
    ! [A,B] :
      ( r1_tarski(A,B)
     => r1_tarski(k3_ordinal2(A),k3_ordinal2(B)) ) ).

fof(t15_ordinal2,axiom,
    ! [A] : r1_tarski(k3_ordinal2(A),k2_ordinal2(A)) ).

fof(t16_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ? [B] :
          ( v3_ordinal1(B)
          & r2_hidden(A,B)
          & v4_ordinal1(B) ) ) ).

fof(t17_ordinal2,axiom,
    ! [A] :
      ( ! [B] :
          ( r2_hidden(B,A)
         => v3_ordinal1(B) )
     => v3_ordinal1(k1_setfam_1(A)) ) ).

fof(d4_ordinal2,axiom,
    k4_ordinal2 = k1_ordinal1(k1_xboole_0) ).

fof(d5_ordinal2,axiom,
    ! [A] :
      ( A = k5_ordinal2
    <=> ( r2_hidden(k1_xboole_0,A)
        & v4_ordinal1(A)
        & v3_ordinal1(A)
        & ! [B] :
            ( v3_ordinal1(B)
           => ( ( r2_hidden(k1_xboole_0,B)
                & v4_ordinal1(B) )
             => r1_tarski(A,B) ) ) ) ) ).

fof(d6_ordinal2,axiom,
    ! [A] : k6_ordinal2(A) = k1_setfam_1(k2_ordinal2(A)) ).

fof(d7_ordinal2,axiom,
    ! [A,B] :
      ( v3_ordinal1(B)
     => ( B = k7_ordinal2(A)
      <=> ( r1_tarski(k2_ordinal2(A),B)
          & ! [C] :
              ( v3_ordinal1(C)
             => ( r1_tarski(k2_ordinal2(A),C)
               => r1_ordinal1(B,C) ) ) ) ) ) ).

fof(t18_ordinal2,axiom,
    $true ).

fof(t19_ordinal2,axiom,
    ( r2_hidden(k1_xboole_0,k5_ordinal2)
    & v4_ordinal1(k5_ordinal2)
    & ! [A] :
        ( v3_ordinal1(A)
       => ( ( r2_hidden(k1_xboole_0,A)
            & v4_ordinal1(A) )
         => r1_ordinal1(k5_ordinal2,A) ) ) ) ).

fof(t20_ordinal2,axiom,
    $true ).

fof(t21_ordinal2,axiom,
    $true ).

fof(t22_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( r2_hidden(A,B)
         => r1_ordinal1(k6_ordinal2(B),A) ) ) ).

fof(t23_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( ! [C] :
              ( v3_ordinal1(C)
             => ( r2_hidden(C,B)
               => r1_ordinal1(A,C) ) )
         => ( k2_ordinal2(B) = k1_xboole_0
            | r1_ordinal1(A,k6_ordinal2(B)) ) ) ) ).

fof(t24_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B,C] :
          ( ( r2_hidden(A,B)
            & r1_tarski(B,C) )
         => r1_ordinal1(k6_ordinal2(C),k6_ordinal2(B)) ) ) ).

fof(t25_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( r2_hidden(A,B)
         => r2_hidden(k6_ordinal2(B),B) ) ) ).

fof(t26_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => k7_ordinal2(A) = A ) ).

fof(t27_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( r2_hidden(A,B)
         => r2_hidden(A,k7_ordinal2(B)) ) ) ).

fof(t28_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( ! [C] :
              ( v3_ordinal1(C)
             => ( r2_hidden(C,B)
               => r2_hidden(C,A) ) )
         => r1_ordinal1(k7_ordinal2(B),A) ) ) ).

fof(t29_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ~ ( r2_hidden(A,k7_ordinal2(B))
            & ! [C] :
                ( v3_ordinal1(C)
               => ~ ( r2_hidden(C,B)
                    & r1_ordinal1(A,C) ) ) ) ) ).

fof(t30_ordinal2,axiom,
    ! [A,B] :
      ( r1_tarski(A,B)
     => r1_ordinal1(k7_ordinal2(A),k7_ordinal2(B)) ) ).

fof(t31_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => k7_ordinal2(k1_tarski(A)) = k1_ordinal1(A) ) ).

fof(t32_ordinal2,axiom,
    ! [A] : r1_ordinal1(k6_ordinal2(A),k7_ordinal2(A)) ).

fof(d8_ordinal2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v1_ordinal2(A)
      <=> ? [B] :
            ( v3_ordinal1(B)
            & r1_tarski(k2_relat_1(A),B) ) ) ) ).

fof(t33_ordinal2,axiom,
    $true ).

fof(t34_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v5_ordinal1(B)
            & v1_ordinal2(B) )
         => ( r2_hidden(A,k1_relat_1(B))
           => v3_ordinal1(k1_funct_1(B,A)) ) ) ) ).

fof(d9_ordinal2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A) )
     => k8_ordinal2(A) = k7_ordinal2(k2_relat_1(A)) ) ).

fof(d10_ordinal2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A) )
     => k9_ordinal2(A) = k6_ordinal2(k2_relat_1(A)) ) ).

fof(t35_ordinal2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A) )
     => ( k8_ordinal2(A) = k7_ordinal2(k2_relat_1(A))
        & k9_ordinal2(A) = k6_ordinal2(k2_relat_1(A)) ) ) ).

fof(d11_ordinal2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A) )
     => ! [B] :
          ( v3_ordinal1(B)
         => ( B = k10_ordinal2(A)
          <=> ? [C] :
                ( v1_relat_1(C)
                & v1_funct_1(C)
                & v5_ordinal1(C)
                & v1_ordinal2(C)
                & B = k9_ordinal2(C)
                & k1_relat_1(C) = k1_relat_1(A)
                & ! [D] :
                    ( v3_ordinal1(D)
                   => ( r2_hidden(D,k1_relat_1(A))
                     => k1_funct_1(C,D) = k7_ordinal2(k2_relat_1(k7_relat_1(A,k4_xboole_0(k1_relat_1(A),D)))) ) ) ) ) ) ) ).

fof(d12_ordinal2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A) )
     => ! [B] :
          ( v3_ordinal1(B)
         => ( B = k11_ordinal2(A)
          <=> ? [C] :
                ( v1_relat_1(C)
                & v1_funct_1(C)
                & v5_ordinal1(C)
                & v1_ordinal2(C)
                & B = k8_ordinal2(C)
                & k1_relat_1(C) = k1_relat_1(A)
                & ! [D] :
                    ( v3_ordinal1(D)
                   => ( r2_hidden(D,k1_relat_1(A))
                     => k1_funct_1(C,D) = k6_ordinal2(k2_relat_1(k7_relat_1(A,k4_xboole_0(k1_relat_1(A),D)))) ) ) ) ) ) ) ).

fof(d13_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v5_ordinal1(B)
            & v1_ordinal2(B) )
         => ( ( A = k1_xboole_0
             => ( r1_ordinal2(A,B)
              <=> ? [C] :
                    ( v3_ordinal1(C)
                    & r2_hidden(C,k1_relat_1(B))
                    & ! [D] :
                        ( v3_ordinal1(D)
                       => ( ( r1_ordinal1(C,D)
                            & r2_hidden(D,k1_relat_1(B)) )
                         => k1_funct_1(B,D) = k1_xboole_0 ) ) ) ) )
            & ( A != k1_xboole_0
             => ( r1_ordinal2(A,B)
              <=> ! [C] :
                    ( v3_ordinal1(C)
                   => ! [D] :
                        ( v3_ordinal1(D)
                       => ~ ( r2_hidden(C,A)
                            & r2_hidden(A,D)
                            & ! [E] :
                                ( v3_ordinal1(E)
                               => ~ ( r2_hidden(E,k1_relat_1(B))
                                    & ! [F] :
                                        ( v3_ordinal1(F)
                                       => ( ( r1_ordinal1(E,F)
                                            & r2_hidden(F,k1_relat_1(B)) )
                                         => ( r2_hidden(C,k1_funct_1(B,F))
                                            & r2_hidden(k1_funct_1(B,F),D) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

fof(d14_ordinal2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A)
        & v1_ordinal2(A) )
     => ( ? [B] :
            ( v3_ordinal1(B)
            & r1_ordinal2(B,A) )
       => ! [B] :
            ( v3_ordinal1(B)
           => ( B = k12_ordinal2(A)
            <=> r1_ordinal2(B,A) ) ) ) ) ).

fof(d15_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v5_ordinal1(B)
            & v1_ordinal2(B) )
         => k13_ordinal2(A,B) = k12_ordinal2(k2_ordinal1(B,A)) ) ) ).

fof(d16_ordinal2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A)
        & v1_ordinal2(A) )
     => ( v2_ordinal2(A)
      <=> ! [B] :
            ( v3_ordinal1(B)
           => ! [C] :
                ( v3_ordinal1(C)
               => ( ( r2_hidden(B,C)
                    & r2_hidden(C,k1_relat_1(A)) )
                 => r2_hidden(k1_funct_1(A,B),k1_funct_1(A,C)) ) ) ) ) ) ).

fof(d17_ordinal2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A)
        & v1_ordinal2(A) )
     => ( v3_ordinal2(A)
      <=> ! [B] :
            ( v3_ordinal1(B)
           => ! [C] :
                ( v3_ordinal1(C)
               => ( ( r2_hidden(B,k1_relat_1(A))
                    & v4_ordinal1(B)
                    & C = k1_funct_1(A,B) )
                 => ( B = k1_xboole_0
                    | r1_ordinal2(C,k2_ordinal1(A,B)) ) ) ) ) ) ) ).

fof(d18_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( C = k14_ordinal2(A,B)
              <=> ? [D] :
                    ( v1_relat_1(D)
                    & v1_funct_1(D)
                    & v5_ordinal1(D)
                    & v1_ordinal2(D)
                    & C = k1_ordinal2(D)
                    & k1_relat_1(D) = k1_ordinal1(B)
                    & k1_funct_1(D,k1_xboole_0) = A
                    & ! [E] :
                        ( v3_ordinal1(E)
                       => ( r2_hidden(k1_ordinal1(E),k1_ordinal1(B))
                         => k1_funct_1(D,k1_ordinal1(E)) = k1_ordinal1(k1_funct_1(D,E)) ) )
                    & ! [E] :
                        ( v3_ordinal1(E)
                       => ( ( r2_hidden(E,k1_ordinal1(B))
                            & v4_ordinal1(E) )
                         => ( E = k1_xboole_0
                            | k1_funct_1(D,E) = k8_ordinal2(k2_ordinal1(D,E)) ) ) ) ) ) ) ) ) ).

fof(d19_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( C = k15_ordinal2(A,B)
              <=> ? [D] :
                    ( v1_relat_1(D)
                    & v1_funct_1(D)
                    & v5_ordinal1(D)
                    & v1_ordinal2(D)
                    & C = k1_ordinal2(D)
                    & k1_relat_1(D) = k1_ordinal1(A)
                    & k1_funct_1(D,k1_xboole_0) = k1_xboole_0
                    & ! [E] :
                        ( v3_ordinal1(E)
                       => ( r2_hidden(k1_ordinal1(E),k1_ordinal1(A))
                         => k1_funct_1(D,k1_ordinal1(E)) = k14_ordinal2(k1_funct_1(D,E),B) ) )
                    & ! [E] :
                        ( v3_ordinal1(E)
                       => ( ( r2_hidden(E,k1_ordinal1(A))
                            & v4_ordinal1(E) )
                         => ( E = k1_xboole_0
                            | k1_funct_1(D,E) = k3_tarski(k8_ordinal2(k2_ordinal1(D,E))) ) ) ) ) ) ) ) ) ).

fof(d20_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( C = k16_ordinal2(A,B)
              <=> ? [D] :
                    ( v1_relat_1(D)
                    & v1_funct_1(D)
                    & v5_ordinal1(D)
                    & v1_ordinal2(D)
                    & C = k1_ordinal2(D)
                    & k1_relat_1(D) = k1_ordinal1(B)
                    & k1_funct_1(D,k1_xboole_0) = k4_ordinal2
                    & ! [E] :
                        ( v3_ordinal1(E)
                       => ( r2_hidden(k1_ordinal1(E),k1_ordinal1(B))
                         => k1_funct_1(D,k1_ordinal1(E)) = k15_ordinal2(A,k1_funct_1(D,E)) ) )
                    & ! [E] :
                        ( v3_ordinal1(E)
                       => ( ( r2_hidden(E,k1_ordinal1(B))
                            & v4_ordinal1(E) )
                         => ( E = k1_xboole_0
                            | k1_funct_1(D,E) = k12_ordinal2(k2_ordinal1(D,E)) ) ) ) ) ) ) ) ) ).

fof(t36_ordinal2,axiom,
    $true ).

fof(t37_ordinal2,axiom,
    $true ).

fof(t38_ordinal2,axiom,
    $true ).

fof(t39_ordinal2,axiom,
    $true ).

fof(t40_ordinal2,axiom,
    $true ).

fof(t41_ordinal2,axiom,
    $true ).

fof(t42_ordinal2,axiom,
    $true ).

fof(t43_ordinal2,axiom,
    $true ).

fof(t44_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => k14_ordinal2(A,k1_xboole_0) = A ) ).

fof(t45_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => k14_ordinal2(A,k1_ordinal1(B)) = k1_ordinal1(k14_ordinal2(A,B)) ) ) ).

fof(t46_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( v4_ordinal1(A)
           => ( A = k1_xboole_0
              | ! [C] :
                  ( ( v1_relat_1(C)
                    & v1_funct_1(C)
                    & v5_ordinal1(C)
                    & v1_ordinal2(C) )
                 => ( ( k1_relat_1(C) = A
                      & ! [D] :
                          ( v3_ordinal1(D)
                         => ( r2_hidden(D,A)
                           => k1_funct_1(C,D) = k14_ordinal2(B,D) ) ) )
                   => k14_ordinal2(B,A) = k8_ordinal2(C) ) ) ) ) ) ) ).

fof(t47_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => k14_ordinal2(k1_xboole_0,A) = A ) ).

fof(t48_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => k14_ordinal2(A,k4_ordinal2) = k1_ordinal1(A) ) ).

fof(t49_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( r2_hidden(A,B)
               => r2_hidden(k14_ordinal2(C,A),k14_ordinal2(C,B)) ) ) ) ) ).

fof(t50_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( r1_ordinal1(A,B)
               => r1_ordinal1(k14_ordinal2(C,A),k14_ordinal2(C,B)) ) ) ) ) ).

fof(t51_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( r1_ordinal1(A,B)
               => r1_ordinal1(k14_ordinal2(A,C),k14_ordinal2(B,C)) ) ) ) ) ).

fof(t52_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => k15_ordinal2(k1_xboole_0,A) = k1_xboole_0 ) ).

fof(t53_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => k15_ordinal2(k1_ordinal1(A),B) = k14_ordinal2(k15_ordinal2(A,B),B) ) ) ).

fof(t54_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( v4_ordinal1(A)
           => ( A = k1_xboole_0
              | ! [C] :
                  ( ( v1_relat_1(C)
                    & v1_funct_1(C)
                    & v5_ordinal1(C)
                    & v1_ordinal2(C) )
                 => ( ( k1_relat_1(C) = A
                      & ! [D] :
                          ( v3_ordinal1(D)
                         => ( r2_hidden(D,A)
                           => k1_funct_1(C,D) = k15_ordinal2(D,B) ) ) )
                   => k15_ordinal2(A,B) = k3_tarski(k8_ordinal2(C)) ) ) ) ) ) ) ).

fof(t55_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => k15_ordinal2(A,k1_xboole_0) = k1_xboole_0 ) ).

fof(t56_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ( k15_ordinal2(k4_ordinal2,A) = A
        & k15_ordinal2(A,k4_ordinal2) = A ) ) ).

fof(t57_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( r2_hidden(B,C)
               => ( A = k1_xboole_0
                  | r2_hidden(k15_ordinal2(B,A),k15_ordinal2(C,A)) ) ) ) ) ) ).

fof(t58_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( r1_ordinal1(A,B)
               => r1_ordinal1(k15_ordinal2(A,C),k15_ordinal2(B,C)) ) ) ) ) ).

fof(t59_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ! [C] :
              ( v3_ordinal1(C)
             => ( r1_ordinal1(A,B)
               => r1_ordinal1(k15_ordinal2(C,A),k15_ordinal2(C,B)) ) ) ) ) ).

fof(t60_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => k16_ordinal2(A,k1_xboole_0) = k4_ordinal2 ) ).

fof(t61_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => k16_ordinal2(A,k1_ordinal1(B)) = k15_ordinal2(A,k16_ordinal2(A,B)) ) ) ).

fof(t62_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( v4_ordinal1(A)
           => ( A = k1_xboole_0
              | ! [C] :
                  ( ( v1_relat_1(C)
                    & v1_funct_1(C)
                    & v5_ordinal1(C)
                    & v1_ordinal2(C) )
                 => ( ( k1_relat_1(C) = A
                      & ! [D] :
                          ( v3_ordinal1(D)
                         => ( r2_hidden(D,A)
                           => k1_funct_1(C,D) = k16_ordinal2(B,D) ) ) )
                   => k16_ordinal2(B,A) = k12_ordinal2(C) ) ) ) ) ) ) ).

fof(t63_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ( k16_ordinal2(A,k4_ordinal2) = A
        & k16_ordinal2(k4_ordinal2,A) = k4_ordinal2 ) ) ).

fof(d21_ordinal2,axiom,
    ! [A] :
      ( v4_ordinal2(A)
    <=> r2_hidden(A,k5_ordinal2) ) ).

fof(t64_ordinal2,axiom,
    $true ).

fof(t65_ordinal2,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ? [B] :
          ( v3_ordinal1(B)
          & ? [C] :
              ( v3_ordinal1(C)
              & v4_ordinal1(B)
              & v4_ordinal2(C)
              & A = k14_ordinal2(B,C) ) ) ) ).

fof(s1_ordinal2,axiom,
    ( ( p1_s1_ordinal2(k1_xboole_0)
      & ! [A] :
          ( v3_ordinal1(A)
         => ( p1_s1_ordinal2(A)
           => p1_s1_ordinal2(k1_ordinal1(A)) ) )
      & ! [A] :
          ( v3_ordinal1(A)
         => ( ( v4_ordinal1(A)
              & ! [B] :
                  ( v3_ordinal1(B)
                 => ( r2_hidden(B,A)
                   => p1_s1_ordinal2(B) ) ) )
           => ( A = k1_xboole_0
              | p1_s1_ordinal2(A) ) ) ) )
   => ! [A] :
        ( v3_ordinal1(A)
       => p1_s1_ordinal2(A) ) ) ).

fof(s2_ordinal2,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A)
      & v5_ordinal1(A)
      & k1_relat_1(A) = f1_s2_ordinal2
      & ! [B] :
          ( v3_ordinal1(B)
         => ( r2_hidden(B,f1_s2_ordinal2)
           => k1_funct_1(A,B) = f2_s2_ordinal2(B) ) ) ) ).

fof(s3_ordinal2,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A)
      & v5_ordinal1(A)
      & v1_ordinal2(A)
      & k1_relat_1(A) = f1_s3_ordinal2
      & ! [B] :
          ( v3_ordinal1(B)
         => ( r2_hidden(B,f1_s3_ordinal2)
           => k1_funct_1(A,B) = f2_s3_ordinal2(B) ) ) ) ).

fof(s4_ordinal2,axiom,
    ( ( k1_relat_1(f5_s4_ordinal2) = f1_s4_ordinal2
      & ( r2_hidden(k1_xboole_0,f1_s4_ordinal2)
       => k1_funct_1(f5_s4_ordinal2,k1_xboole_0) = f2_s4_ordinal2 )
      & ! [A] :
          ( v3_ordinal1(A)
         => ( r2_hidden(k1_ordinal1(A),f1_s4_ordinal2)
           => k1_funct_1(f5_s4_ordinal2,k1_ordinal1(A)) = f3_s4_ordinal2(A,k1_funct_1(f5_s4_ordinal2,A)) ) )
      & ! [A] :
          ( v3_ordinal1(A)
         => ( ( r2_hidden(A,f1_s4_ordinal2)
              & v4_ordinal1(A) )
           => ( A = k1_xboole_0
              | k1_funct_1(f5_s4_ordinal2,A) = f4_s4_ordinal2(A,k2_ordinal1(f5_s4_ordinal2,A)) ) ) )
      & k1_relat_1(f6_s4_ordinal2) = f1_s4_ordinal2
      & ( r2_hidden(k1_xboole_0,f1_s4_ordinal2)
       => k1_funct_1(f6_s4_ordinal2,k1_xboole_0) = f2_s4_ordinal2 )
      & ! [A] :
          ( v3_ordinal1(A)
         => ( r2_hidden(k1_ordinal1(A),f1_s4_ordinal2)
           => k1_funct_1(f6_s4_ordinal2,k1_ordinal1(A)) = f3_s4_ordinal2(A,k1_funct_1(f6_s4_ordinal2,A)) ) )
      & ! [A] :
          ( v3_ordinal1(A)
         => ( ( r2_hidden(A,f1_s4_ordinal2)
              & v4_ordinal1(A) )
           => ( A = k1_xboole_0
              | k1_funct_1(f6_s4_ordinal2,A) = f4_s4_ordinal2(A,k2_ordinal1(f6_s4_ordinal2,A)) ) ) ) )
   => f5_s4_ordinal2 = f6_s4_ordinal2 ) ).

fof(s5_ordinal2,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A)
      & v5_ordinal1(A)
      & k1_relat_1(A) = f1_s5_ordinal2
      & ( r2_hidden(k1_xboole_0,f1_s5_ordinal2)
       => k1_funct_1(A,k1_xboole_0) = f2_s5_ordinal2 )
      & ! [B] :
          ( v3_ordinal1(B)
         => ( r2_hidden(k1_ordinal1(B),f1_s5_ordinal2)
           => k1_funct_1(A,k1_ordinal1(B)) = f3_s5_ordinal2(B,k1_funct_1(A,B)) ) )
      & ! [B] :
          ( v3_ordinal1(B)
         => ( ( r2_hidden(B,f1_s5_ordinal2)
              & v4_ordinal1(B) )
           => ( B = k1_xboole_0
              | k1_funct_1(A,B) = f4_s5_ordinal2(B,k2_ordinal1(A,B)) ) ) ) ) ).

fof(s6_ordinal2,axiom,
    ( ( ! [A] :
          ( v3_ordinal1(A)
         => ! [B] :
              ( B = f2_s6_ordinal2(A)
            <=> ? [C] :
                  ( v1_relat_1(C)
                  & v1_funct_1(C)
                  & v5_ordinal1(C)
                  & B = k1_ordinal2(C)
                  & k1_relat_1(C) = k1_ordinal1(A)
                  & k1_funct_1(C,k1_xboole_0) = f4_s6_ordinal2
                  & ! [D] :
                      ( v3_ordinal1(D)
                     => ( r2_hidden(k1_ordinal1(D),k1_ordinal1(A))
                       => k1_funct_1(C,k1_ordinal1(D)) = f5_s6_ordinal2(D,k1_funct_1(C,D)) ) )
                  & ! [D] :
                      ( v3_ordinal1(D)
                     => ( ( r2_hidden(D,k1_ordinal1(A))
                          & v4_ordinal1(D) )
                       => ( D = k1_xboole_0
                          | k1_funct_1(C,D) = f6_s6_ordinal2(D,k2_ordinal1(C,D)) ) ) ) ) ) )
      & k1_relat_1(f1_s6_ordinal2) = f3_s6_ordinal2
      & ( r2_hidden(k1_xboole_0,f3_s6_ordinal2)
       => k1_funct_1(f1_s6_ordinal2,k1_xboole_0) = f4_s6_ordinal2 )
      & ! [A] :
          ( v3_ordinal1(A)
         => ( r2_hidden(k1_ordinal1(A),f3_s6_ordinal2)
           => k1_funct_1(f1_s6_ordinal2,k1_ordinal1(A)) = f5_s6_ordinal2(A,k1_funct_1(f1_s6_ordinal2,A)) ) )
      & ! [A] :
          ( v3_ordinal1(A)
         => ( ( r2_hidden(A,f3_s6_ordinal2)
              & v4_ordinal1(A) )
           => ( A = k1_xboole_0
              | k1_funct_1(f1_s6_ordinal2,A) = f6_s6_ordinal2(A,k2_ordinal1(f1_s6_ordinal2,A)) ) ) ) )
   => ! [A] :
        ( v3_ordinal1(A)
       => ( r2_hidden(A,k1_relat_1(f1_s6_ordinal2))
         => k1_funct_1(f1_s6_ordinal2,A) = f2_s6_ordinal2(A) ) ) ) ).

fof(s7_ordinal2,axiom,
    ( ? [A,B] :
        ( v1_relat_1(B)
        & v1_funct_1(B)
        & v5_ordinal1(B)
        & A = k1_ordinal2(B)
        & k1_relat_1(B) = k1_ordinal1(f1_s7_ordinal2)
        & k1_funct_1(B,k1_xboole_0) = f2_s7_ordinal2
        & ! [C] :
            ( v3_ordinal1(C)
           => ( r2_hidden(k1_ordinal1(C),k1_ordinal1(f1_s7_ordinal2))
             => k1_funct_1(B,k1_ordinal1(C)) = f3_s7_ordinal2(C,k1_funct_1(B,C)) ) )
        & ! [C] :
            ( v3_ordinal1(C)
           => ( ( r2_hidden(C,k1_ordinal1(f1_s7_ordinal2))
                & v4_ordinal1(C) )
             => ( C = k1_xboole_0
                | k1_funct_1(B,C) = f4_s7_ordinal2(C,k2_ordinal1(B,C)) ) ) ) )
    & ! [A,B] :
        ~ ( ? [C] :
              ( v1_relat_1(C)
              & v1_funct_1(C)
              & v5_ordinal1(C)
              & A = k1_ordinal2(C)
              & k1_relat_1(C) = k1_ordinal1(f1_s7_ordinal2)
              & k1_funct_1(C,k1_xboole_0) = f2_s7_ordinal2
              & ! [D] :
                  ( v3_ordinal1(D)
                 => ( r2_hidden(k1_ordinal1(D),k1_ordinal1(f1_s7_ordinal2))
                   => k1_funct_1(C,k1_ordinal1(D)) = f3_s7_ordinal2(D,k1_funct_1(C,D)) ) )
              & ! [D] :
                  ( v3_ordinal1(D)
                 => ( ( r2_hidden(D,k1_ordinal1(f1_s7_ordinal2))
                      & v4_ordinal1(D) )
                   => ( D = k1_xboole_0
                      | k1_funct_1(C,D) = f4_s7_ordinal2(D,k2_ordinal1(C,D)) ) ) ) )
          & ? [C] :
              ( v1_relat_1(C)
              & v1_funct_1(C)
              & v5_ordinal1(C)
              & B = k1_ordinal2(C)
              & k1_relat_1(C) = k1_ordinal1(f1_s7_ordinal2)
              & k1_funct_1(C,k1_xboole_0) = f2_s7_ordinal2
              & ! [D] :
                  ( v3_ordinal1(D)
                 => ( r2_hidden(k1_ordinal1(D),k1_ordinal1(f1_s7_ordinal2))
                   => k1_funct_1(C,k1_ordinal1(D)) = f3_s7_ordinal2(D,k1_funct_1(C,D)) ) )
              & ! [D] :
                  ( v3_ordinal1(D)
                 => ( ( r2_hidden(D,k1_ordinal1(f1_s7_ordinal2))
                      & v4_ordinal1(D) )
                   => ( D = k1_xboole_0
                      | k1_funct_1(C,D) = f4_s7_ordinal2(D,k2_ordinal1(C,D)) ) ) ) )
          & A != B ) ) ).

fof(s8_ordinal2,axiom,
    ( ! [A] :
        ( v3_ordinal1(A)
       => ! [B] :
            ( B = f1_s8_ordinal2(A)
          <=> ? [C] :
                ( v1_relat_1(C)
                & v1_funct_1(C)
                & v5_ordinal1(C)
                & B = k1_ordinal2(C)
                & k1_relat_1(C) = k1_ordinal1(A)
                & k1_funct_1(C,k1_xboole_0) = f2_s8_ordinal2
                & ! [D] :
                    ( v3_ordinal1(D)
                   => ( r2_hidden(k1_ordinal1(D),k1_ordinal1(A))
                     => k1_funct_1(C,k1_ordinal1(D)) = f3_s8_ordinal2(D,k1_funct_1(C,D)) ) )
                & ! [D] :
                    ( v3_ordinal1(D)
                   => ( ( r2_hidden(D,k1_ordinal1(A))
                        & v4_ordinal1(D) )
                     => ( D = k1_xboole_0
                        | k1_funct_1(C,D) = f4_s8_ordinal2(D,k2_ordinal1(C,D)) ) ) ) ) ) )
   => f1_s8_ordinal2(k1_xboole_0) = f2_s8_ordinal2 ) ).

fof(s9_ordinal2,axiom,
    ( ! [A] :
        ( v3_ordinal1(A)
       => ! [B] :
            ( B = f4_s9_ordinal2(A)
          <=> ? [C] :
                ( v1_relat_1(C)
                & v1_funct_1(C)
                & v5_ordinal1(C)
                & B = k1_ordinal2(C)
                & k1_relat_1(C) = k1_ordinal1(A)
                & k1_funct_1(C,k1_xboole_0) = f1_s9_ordinal2
                & ! [D] :
                    ( v3_ordinal1(D)
                   => ( r2_hidden(k1_ordinal1(D),k1_ordinal1(A))
                     => k1_funct_1(C,k1_ordinal1(D)) = f2_s9_ordinal2(D,k1_funct_1(C,D)) ) )
                & ! [D] :
                    ( v3_ordinal1(D)
                   => ( ( r2_hidden(D,k1_ordinal1(A))
                        & v4_ordinal1(D) )
                     => ( D = k1_xboole_0
                        | k1_funct_1(C,D) = f3_s9_ordinal2(D,k2_ordinal1(C,D)) ) ) ) ) ) )
   => ! [A] :
        ( v3_ordinal1(A)
       => f4_s9_ordinal2(k1_ordinal1(A)) = f2_s9_ordinal2(A,f4_s9_ordinal2(A)) ) ) ).

fof(s10_ordinal2,axiom,
    ( ( ! [A] :
          ( v3_ordinal1(A)
         => ! [B] :
              ( B = f3_s10_ordinal2(A)
            <=> ? [C] :
                  ( v1_relat_1(C)
                  & v1_funct_1(C)
                  & v5_ordinal1(C)
                  & B = k1_ordinal2(C)
                  & k1_relat_1(C) = k1_ordinal1(A)
                  & k1_funct_1(C,k1_xboole_0) = f4_s10_ordinal2
                  & ! [D] :
                      ( v3_ordinal1(D)
                     => ( r2_hidden(k1_ordinal1(D),k1_ordinal1(A))
                       => k1_funct_1(C,k1_ordinal1(D)) = f5_s10_ordinal2(D,k1_funct_1(C,D)) ) )
                  & ! [D] :
                      ( v3_ordinal1(D)
                     => ( ( r2_hidden(D,k1_ordinal1(A))
                          & v4_ordinal1(D) )
                       => ( D = k1_xboole_0
                          | k1_funct_1(C,D) = f6_s10_ordinal2(D,k2_ordinal1(C,D)) ) ) ) ) ) )
      & f2_s10_ordinal2 != k1_xboole_0
      & v4_ordinal1(f2_s10_ordinal2)
      & k1_relat_1(f1_s10_ordinal2) = f2_s10_ordinal2
      & ! [A] :
          ( v3_ordinal1(A)
         => ( r2_hidden(A,f2_s10_ordinal2)
           => k1_funct_1(f1_s10_ordinal2,A) = f3_s10_ordinal2(A) ) ) )
   => f3_s10_ordinal2(f2_s10_ordinal2) = f6_s10_ordinal2(f2_s10_ordinal2,f1_s10_ordinal2) ) ).

fof(s11_ordinal2,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A)
      & v5_ordinal1(A)
      & v1_ordinal2(A)
      & k1_relat_1(A) = f1_s11_ordinal2
      & ( r2_hidden(k1_xboole_0,f1_s11_ordinal2)
       => k1_funct_1(A,k1_xboole_0) = f2_s11_ordinal2 )
      & ! [B] :
          ( v3_ordinal1(B)
         => ( r2_hidden(k1_ordinal1(B),f1_s11_ordinal2)
           => k1_funct_1(A,k1_ordinal1(B)) = f3_s11_ordinal2(B,k1_funct_1(A,B)) ) )
      & ! [B] :
          ( v3_ordinal1(B)
         => ( ( r2_hidden(B,f1_s11_ordinal2)
              & v4_ordinal1(B) )
           => ( B = k1_xboole_0
              | k1_funct_1(A,B) = f4_s11_ordinal2(B,k2_ordinal1(A,B)) ) ) ) ) ).

fof(s12_ordinal2,axiom,
    ( ( ! [A] :
          ( v3_ordinal1(A)
         => ! [B] :
              ( v3_ordinal1(B)
             => ( B = f2_s12_ordinal2(A)
              <=> ? [C] :
                    ( v1_relat_1(C)
                    & v1_funct_1(C)
                    & v5_ordinal1(C)
                    & v1_ordinal2(C)
                    & B = k1_ordinal2(C)
                    & k1_relat_1(C) = k1_ordinal1(A)
                    & k1_funct_1(C,k1_xboole_0) = f4_s12_ordinal2
                    & ! [D] :
                        ( v3_ordinal1(D)
                       => ( r2_hidden(k1_ordinal1(D),k1_ordinal1(A))
                         => k1_funct_1(C,k1_ordinal1(D)) = f5_s12_ordinal2(D,k1_funct_1(C,D)) ) )
                    & ! [D] :
                        ( v3_ordinal1(D)
                       => ( ( r2_hidden(D,k1_ordinal1(A))
                            & v4_ordinal1(D) )
                         => ( D = k1_xboole_0
                            | k1_funct_1(C,D) = f6_s12_ordinal2(D,k2_ordinal1(C,D)) ) ) ) ) ) ) )
      & k1_relat_1(f1_s12_ordinal2) = f3_s12_ordinal2
      & ( r2_hidden(k1_xboole_0,f3_s12_ordinal2)
       => k1_funct_1(f1_s12_ordinal2,k1_xboole_0) = f4_s12_ordinal2 )
      & ! [A] :
          ( v3_ordinal1(A)
         => ( r2_hidden(k1_ordinal1(A),f3_s12_ordinal2)
           => k1_funct_1(f1_s12_ordinal2,k1_ordinal1(A)) = f5_s12_ordinal2(A,k1_funct_1(f1_s12_ordinal2,A)) ) )
      & ! [A] :
          ( v3_ordinal1(A)
         => ( ( r2_hidden(A,f3_s12_ordinal2)
              & v4_ordinal1(A) )
           => ( A = k1_xboole_0
              | k1_funct_1(f1_s12_ordinal2,A) = f6_s12_ordinal2(A,k2_ordinal1(f1_s12_ordinal2,A)) ) ) ) )
   => ! [A] :
        ( v3_ordinal1(A)
       => ( r2_hidden(A,k1_relat_1(f1_s12_ordinal2))
         => k1_funct_1(f1_s12_ordinal2,A) = f2_s12_ordinal2(A) ) ) ) ).

fof(s13_ordinal2,axiom,
    ( ? [A] :
        ( v3_ordinal1(A)
        & ? [B] :
            ( v1_relat_1(B)
            & v1_funct_1(B)
            & v5_ordinal1(B)
            & v1_ordinal2(B)
            & A = k1_ordinal2(B)
            & k1_relat_1(B) = k1_ordinal1(f1_s13_ordinal2)
            & k1_funct_1(B,k1_xboole_0) = f2_s13_ordinal2
            & ! [C] :
                ( v3_ordinal1(C)
               => ( r2_hidden(k1_ordinal1(C),k1_ordinal1(f1_s13_ordinal2))
                 => k1_funct_1(B,k1_ordinal1(C)) = f3_s13_ordinal2(C,k1_funct_1(B,C)) ) )
            & ! [C] :
                ( v3_ordinal1(C)
               => ( ( r2_hidden(C,k1_ordinal1(f1_s13_ordinal2))
                    & v4_ordinal1(C) )
                 => ( C = k1_xboole_0
                    | k1_funct_1(B,C) = f4_s13_ordinal2(C,k2_ordinal1(B,C)) ) ) ) ) )
    & ! [A] :
        ( v3_ordinal1(A)
       => ! [B] :
            ( v3_ordinal1(B)
           => ~ ( ? [C] :
                    ( v1_relat_1(C)
                    & v1_funct_1(C)
                    & v5_ordinal1(C)
                    & v1_ordinal2(C)
                    & A = k1_ordinal2(C)
                    & k1_relat_1(C) = k1_ordinal1(f1_s13_ordinal2)
                    & k1_funct_1(C,k1_xboole_0) = f2_s13_ordinal2
                    & ! [D] :
                        ( v3_ordinal1(D)
                       => ( r2_hidden(k1_ordinal1(D),k1_ordinal1(f1_s13_ordinal2))
                         => k1_funct_1(C,k1_ordinal1(D)) = f3_s13_ordinal2(D,k1_funct_1(C,D)) ) )
                    & ! [D] :
                        ( v3_ordinal1(D)
                       => ( ( r2_hidden(D,k1_ordinal1(f1_s13_ordinal2))
                            & v4_ordinal1(D) )
                         => ( D = k1_xboole_0
                            | k1_funct_1(C,D) = f4_s13_ordinal2(D,k2_ordinal1(C,D)) ) ) ) )
                & ? [C] :
                    ( v1_relat_1(C)
                    & v1_funct_1(C)
                    & v5_ordinal1(C)
                    & v1_ordinal2(C)
                    & B = k1_ordinal2(C)
                    & k1_relat_1(C) = k1_ordinal1(f1_s13_ordinal2)
                    & k1_funct_1(C,k1_xboole_0) = f2_s13_ordinal2
                    & ! [D] :
                        ( v3_ordinal1(D)
                       => ( r2_hidden(k1_ordinal1(D),k1_ordinal1(f1_s13_ordinal2))
                         => k1_funct_1(C,k1_ordinal1(D)) = f3_s13_ordinal2(D,k1_funct_1(C,D)) ) )
                    & ! [D] :
                        ( v3_ordinal1(D)
                       => ( ( r2_hidden(D,k1_ordinal1(f1_s13_ordinal2))
                            & v4_ordinal1(D) )
                         => ( D = k1_xboole_0
                            | k1_funct_1(C,D) = f4_s13_ordinal2(D,k2_ordinal1(C,D)) ) ) ) )
                & A != B ) ) ) ) ).

fof(s14_ordinal2,axiom,
    ( ! [A] :
        ( v3_ordinal1(A)
       => ! [B] :
            ( v3_ordinal1(B)
           => ( B = f1_s14_ordinal2(A)
            <=> ? [C] :
                  ( v1_relat_1(C)
                  & v1_funct_1(C)
                  & v5_ordinal1(C)
                  & v1_ordinal2(C)
                  & B = k1_ordinal2(C)
                  & k1_relat_1(C) = k1_ordinal1(A)
                  & k1_funct_1(C,k1_xboole_0) = f2_s14_ordinal2
                  & ! [D] :
                      ( v3_ordinal1(D)
                     => ( r2_hidden(k1_ordinal1(D),k1_ordinal1(A))
                       => k1_funct_1(C,k1_ordinal1(D)) = f3_s14_ordinal2(D,k1_funct_1(C,D)) ) )
                  & ! [D] :
                      ( v3_ordinal1(D)
                     => ( ( r2_hidden(D,k1_ordinal1(A))
                          & v4_ordinal1(D) )
                       => ( D = k1_xboole_0
                          | k1_funct_1(C,D) = f4_s14_ordinal2(D,k2_ordinal1(C,D)) ) ) ) ) ) ) )
   => f1_s14_ordinal2(k1_xboole_0) = f2_s14_ordinal2 ) ).

fof(s15_ordinal2,axiom,
    ( ! [A] :
        ( v3_ordinal1(A)
       => ! [B] :
            ( v3_ordinal1(B)
           => ( B = f4_s15_ordinal2(A)
            <=> ? [C] :
                  ( v1_relat_1(C)
                  & v1_funct_1(C)
                  & v5_ordinal1(C)
                  & v1_ordinal2(C)
                  & B = k1_ordinal2(C)
                  & k1_relat_1(C) = k1_ordinal1(A)
                  & k1_funct_1(C,k1_xboole_0) = f1_s15_ordinal2
                  & ! [D] :
                      ( v3_ordinal1(D)
                     => ( r2_hidden(k1_ordinal1(D),k1_ordinal1(A))
                       => k1_funct_1(C,k1_ordinal1(D)) = f2_s15_ordinal2(D,k1_funct_1(C,D)) ) )
                  & ! [D] :
                      ( v3_ordinal1(D)
                     => ( ( r2_hidden(D,k1_ordinal1(A))
                          & v4_ordinal1(D) )
                       => ( D = k1_xboole_0
                          | k1_funct_1(C,D) = f3_s15_ordinal2(D,k2_ordinal1(C,D)) ) ) ) ) ) ) )
   => ! [A] :
        ( v3_ordinal1(A)
       => f4_s15_ordinal2(k1_ordinal1(A)) = f2_s15_ordinal2(A,f4_s15_ordinal2(A)) ) ) ).

fof(s16_ordinal2,axiom,
    ( ( ! [A] :
          ( v3_ordinal1(A)
         => ! [B] :
              ( v3_ordinal1(B)
             => ( B = f3_s16_ordinal2(A)
              <=> ? [C] :
                    ( v1_relat_1(C)
                    & v1_funct_1(C)
                    & v5_ordinal1(C)
                    & v1_ordinal2(C)
                    & B = k1_ordinal2(C)
                    & k1_relat_1(C) = k1_ordinal1(A)
                    & k1_funct_1(C,k1_xboole_0) = f4_s16_ordinal2
                    & ! [D] :
                        ( v3_ordinal1(D)
                       => ( r2_hidden(k1_ordinal1(D),k1_ordinal1(A))
                         => k1_funct_1(C,k1_ordinal1(D)) = f5_s16_ordinal2(D,k1_funct_1(C,D)) ) )
                    & ! [D] :
                        ( v3_ordinal1(D)
                       => ( ( r2_hidden(D,k1_ordinal1(A))
                            & v4_ordinal1(D) )
                         => ( D = k1_xboole_0
                            | k1_funct_1(C,D) = f6_s16_ordinal2(D,k2_ordinal1(C,D)) ) ) ) ) ) ) )
      & f2_s16_ordinal2 != k1_xboole_0
      & v4_ordinal1(f2_s16_ordinal2)
      & k1_relat_1(f1_s16_ordinal2) = f2_s16_ordinal2
      & ! [A] :
          ( v3_ordinal1(A)
         => ( r2_hidden(A,f2_s16_ordinal2)
           => k1_funct_1(f1_s16_ordinal2,A) = f3_s16_ordinal2(A) ) ) )
   => f3_s16_ordinal2(f2_s16_ordinal2) = f6_s16_ordinal2(f2_s16_ordinal2,f1_s16_ordinal2) ) ).

fof(dt_k1_ordinal2,axiom,
    $true ).

fof(dt_k2_ordinal2,axiom,
    $true ).

fof(dt_k3_ordinal2,axiom,
    $true ).

fof(dt_k4_ordinal2,axiom,
    ( v3_ordinal1(k4_ordinal2)
    & ~ v1_xboole_0(k4_ordinal2) ) ).

fof(dt_k5_ordinal2,axiom,
    $true ).

fof(dt_k6_ordinal2,axiom,
    ! [A] : v3_ordinal1(k6_ordinal2(A)) ).

fof(dt_k7_ordinal2,axiom,
    ! [A] : v3_ordinal1(k7_ordinal2(A)) ).

fof(dt_k8_ordinal2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A) )
     => v3_ordinal1(k8_ordinal2(A)) ) ).

fof(dt_k9_ordinal2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A) )
     => v3_ordinal1(k9_ordinal2(A)) ) ).

fof(dt_k10_ordinal2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A) )
     => v3_ordinal1(k10_ordinal2(A)) ) ).

fof(dt_k11_ordinal2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A) )
     => v3_ordinal1(k11_ordinal2(A)) ) ).

fof(dt_k12_ordinal2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v5_ordinal1(A)
        & v1_ordinal2(A) )
     => v3_ordinal1(k12_ordinal2(A)) ) ).

fof(dt_k13_ordinal2,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v1_relat_1(B)
        & v1_funct_1(B)
        & v5_ordinal1(B)
        & v1_ordinal2(B) )
     => v3_ordinal1(k13_ordinal2(A,B)) ) ).

fof(dt_k14_ordinal2,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v3_ordinal1(B) )
     => v3_ordinal1(k14_ordinal2(A,B)) ) ).

fof(dt_k15_ordinal2,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v3_ordinal1(B) )
     => v3_ordinal1(k15_ordinal2(A,B)) ) ).

fof(dt_k16_ordinal2,axiom,
    ! [A,B] :
      ( ( v3_ordinal1(A)
        & v3_ordinal1(B) )
     => v3_ordinal1(k16_ordinal2(A,B)) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(rc1_finset_1,axiom,
    ? [A] :
      ( ~ v1_xboole_0(A)
      & v1_finset_1(A) ) ).

fof(cc1_finset_1,axiom,
    ! [A] :
      ( v1_xboole_0(A)
     => v1_finset_1(A) ) ).

fof(rc2_finset_1,axiom,
    ! [A] :
    ? [B] :
      ( m1_subset_1(B,k1_zfmisc_1(A))
      & v1_xboole_0(B)
      & v1_relat_1(B)
      & v1_funct_1(B)
      & v2_funct_1(B)
      & v1_ordinal1(B)
      & v2_ordinal1(B)
      & v3_ordinal1(B)
      & v4_ordinal2(B)
      & v1_finset_1(B) ) ).

fof(fc1_finset_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(k1_tarski(A))
      & v1_finset_1(k1_tarski(A)) ) ).

fof(rc3_finset_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ? [B] :
          ( m1_subset_1(B,k1_zfmisc_1(A))
          & ~ v1_xboole_0(B)
          & v1_finset_1(B) ) ) ).

fof(fc2_finset_1,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(k2_tarski(A,B))
      & v1_finset_1(k2_tarski(A,B)) ) ).

fof(fc3_finset_1,axiom,
    ! [A,B,C] : v1_finset_1(k1_enumset1(A,B,C)) ).

fof(fc4_finset_1,axiom,
    ! [A,B,C,D] : v1_finset_1(k2_enumset1(A,B,C,D)) ).

fof(fc5_finset_1,axiom,
    ! [A,B,C,D,E] : v1_finset_1(k3_enumset1(A,B,C,D,E)) ).

fof(fc6_finset_1,axiom,
    ! [A,B,C,D,E,F] : v1_finset_1(k4_enumset1(A,B,C,D,E,F)) ).

fof(fc7_finset_1,axiom,
    ! [A,B,C,D,E,F,G] : v1_finset_1(k5_enumset1(A,B,C,D,E,F,G)) ).

fof(fc8_finset_1,axiom,
    ! [A,B,C,D,E,F,G,H] : v1_finset_1(k6_enumset1(A,B,C,D,E,F,G,H)) ).

fof(cc2_finset_1,axiom,
    ! [A] :
      ( v1_finset_1(A)
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(A))
         => v1_finset_1(B) ) ) ).

fof(fc9_finset_1,axiom,
    ! [A,B] :
      ( ( v1_finset_1(A)
        & v1_finset_1(B) )
     => v1_finset_1(k2_xboole_0(A,B)) ) ).

fof(fc10_finset_1,axiom,
    ! [A,B] :
      ( v1_finset_1(B)
     => v1_finset_1(k3_xboole_0(A,B)) ) ).

fof(fc11_finset_1,axiom,
    ! [A,B] :
      ( v1_finset_1(A)
     => v1_finset_1(k3_xboole_0(A,B)) ) ).

fof(fc12_finset_1,axiom,
    ! [A,B] :
      ( v1_finset_1(A)
     => v1_finset_1(k4_xboole_0(A,B)) ) ).

fof(fc13_finset_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finset_1(B) )
     => v1_finset_1(k9_relat_1(A,B)) ) ).

fof(fc14_finset_1,axiom,
    ! [A,B] :
      ( ( v1_finset_1(A)
        & v1_finset_1(B) )
     => v1_finset_1(k2_zfmisc_1(A,B)) ) ).

fof(fc15_finset_1,axiom,
    ! [A,B,C] :
      ( ( v1_finset_1(A)
        & v1_finset_1(B)
        & v1_finset_1(C) )
     => v1_finset_1(k3_zfmisc_1(A,B,C)) ) ).

fof(fc16_finset_1,axiom,
    ! [A,B,C,D] :
      ( ( v1_finset_1(A)
        & v1_finset_1(B)
        & v1_finset_1(C)
        & v1_finset_1(D) )
     => v1_finset_1(k4_zfmisc_1(A,B,C,D)) ) ).

fof(fc17_finset_1,axiom,
    ! [A,B] :
      ( ( v1_finset_1(A)
        & v1_finset_1(B) )
     => v1_finset_1(k5_xboole_0(A,B)) ) ).

fof(rc4_finset_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ? [B] :
          ( m1_subset_1(B,k1_zfmisc_1(A))
          & ~ v1_xboole_0(B)
          & v1_finset_1(B) ) ) ).

fof(d1_finset_1,axiom,
    ! [A] :
      ( v1_finset_1(A)
    <=> ? [B] :
          ( v1_relat_1(B)
          & v1_funct_1(B)
          & k2_relat_1(B) = A
          & r2_hidden(k1_relat_1(B),k5_ordinal2) ) ) ).

fof(t1_finset_1,axiom,
    $true ).

fof(t2_finset_1,axiom,
    $true ).

fof(t3_finset_1,axiom,
    $true ).

fof(t4_finset_1,axiom,
    $true ).

fof(t5_finset_1,axiom,
    $true ).

fof(t6_finset_1,axiom,
    $true ).

fof(t7_finset_1,axiom,
    $true ).

fof(t8_finset_1,axiom,
    $true ).

fof(t9_finset_1,axiom,
    $true ).

fof(t10_finset_1,axiom,
    $true ).

fof(t11_finset_1,axiom,
    $true ).

fof(t12_finset_1,axiom,
    $true ).

fof(t13_finset_1,axiom,
    ! [A,B] :
      ( ( r1_tarski(A,B)
        & v1_finset_1(B) )
     => v1_finset_1(A) ) ).

fof(t14_finset_1,axiom,
    ! [A,B] :
      ( ( v1_finset_1(A)
        & v1_finset_1(B) )
     => v1_finset_1(k2_xboole_0(A,B)) ) ).

fof(t15_finset_1,axiom,
    ! [A,B] :
      ( v1_finset_1(A)
     => v1_finset_1(k3_xboole_0(A,B)) ) ).

fof(t16_finset_1,axiom,
    ! [A,B] :
      ( v1_finset_1(A)
     => v1_finset_1(k4_xboole_0(A,B)) ) ).

fof(t17_finset_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( v1_finset_1(A)
       => v1_finset_1(k9_relat_1(B,A)) ) ) ).

fof(t18_finset_1,axiom,
    ! [A] :
      ( v1_finset_1(A)
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(A)))
         => ~ ( B != k1_xboole_0
              & ! [C] :
                  ~ ( r2_hidden(C,B)
                    & ! [D] :
                        ( ( r2_hidden(D,B)
                          & r1_tarski(C,D) )
                       => D = C ) ) ) ) ) ).

fof(t19_finset_1,axiom,
    ! [A,B] :
      ( ( v1_finset_1(A)
        & v1_finset_1(B) )
     => v1_finset_1(k2_zfmisc_1(A,B)) ) ).

fof(t20_finset_1,axiom,
    ! [A,B,C] :
      ( ( v1_finset_1(A)
        & v1_finset_1(B)
        & v1_finset_1(C) )
     => v1_finset_1(k3_zfmisc_1(A,B,C)) ) ).

fof(t21_finset_1,axiom,
    ! [A,B,C,D] :
      ( ( v1_finset_1(A)
        & v1_finset_1(B)
        & v1_finset_1(C)
        & v1_finset_1(D) )
     => v1_finset_1(k4_zfmisc_1(A,B,C,D)) ) ).

fof(t22_finset_1,axiom,
    ! [A,B] :
      ( v1_finset_1(k2_zfmisc_1(B,A))
     => ( A = k1_xboole_0
        | v1_finset_1(B) ) ) ).

fof(t23_finset_1,axiom,
    ! [A,B] :
      ( v1_finset_1(k2_zfmisc_1(A,B))
     => ( A = k1_xboole_0
        | v1_finset_1(B) ) ) ).

fof(t24_finset_1,axiom,
    ! [A] :
      ( v1_finset_1(A)
    <=> v1_finset_1(k1_zfmisc_1(A)) ) ).

fof(t25_finset_1,axiom,
    ! [A] :
      ( ( v1_finset_1(A)
        & ! [B] :
            ( r2_hidden(B,A)
           => v1_finset_1(B) ) )
    <=> v1_finset_1(k3_tarski(A)) ) ).

fof(t26_finset_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v1_finset_1(k1_relat_1(A))
       => v1_finset_1(k2_relat_1(A)) ) ) ).

fof(t27_finset_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( ( r1_tarski(A,k2_relat_1(B))
          & v1_finset_1(k10_relat_1(B,A)) )
       => v1_finset_1(A) ) ) ).

fof(t28_finset_1,axiom,
    ! [A,B] :
      ( ( v1_finset_1(A)
        & v1_finset_1(B) )
     => v1_finset_1(k5_xboole_0(A,B)) ) ).

fof(t29_finset_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v1_finset_1(k1_relat_1(A))
      <=> v1_finset_1(A) ) ) ).

fof(t30_finset_1,axiom,
    ! [A] :
      ~ ( v1_finset_1(A)
        & A != k1_xboole_0
        & v6_ordinal1(A)
        & ! [B] :
            ~ ( r2_hidden(B,A)
              & ! [C] :
                  ( r2_hidden(C,A)
                 => r1_tarski(B,C) ) ) ) ).

fof(t31_finset_1,axiom,
    ! [A] :
      ~ ( v1_finset_1(A)
        & A != k1_xboole_0
        & v6_ordinal1(A)
        & ! [B] :
            ~ ( r2_hidden(B,A)
              & ! [C] :
                  ( r2_hidden(C,A)
                 => r1_tarski(C,B) ) ) ) ).

fof(s1_finset_1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A)
      & k1_relat_1(A) = f1_s1_finset_1
      & ! [B] :
          ( v3_ordinal1(B)
         => ( r2_hidden(B,f1_s1_finset_1)
           => ( ( p1_s1_finset_1(B)
               => k1_funct_1(A,B) = f2_s1_finset_1(B) )
              & ( ~ p1_s1_finset_1(B)
               => k1_funct_1(A,B) = f3_s1_finset_1(B) ) ) ) ) ) ).

fof(s2_finset_1,axiom,
    ( ( v1_finset_1(f1_s2_finset_1)
      & p1_s2_finset_1(k1_xboole_0)
      & ! [A,B] :
          ( ( r2_hidden(A,f1_s2_finset_1)
            & r1_tarski(B,f1_s2_finset_1)
            & p1_s2_finset_1(B) )
         => p1_s2_finset_1(k2_xboole_0(B,k1_tarski(A))) ) )
   => p1_s2_finset_1(f1_s2_finset_1) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(fc1_numbers,axiom,
    ~ v1_xboole_0(k1_numbers) ).

fof(fc2_numbers,axiom,
    ~ v1_xboole_0(k2_numbers) ).

fof(fc3_numbers,axiom,
    ~ v1_xboole_0(k3_numbers) ).

fof(fc4_numbers,axiom,
    ~ v1_xboole_0(k4_numbers) ).

fof(d1_numbers,axiom,
    k1_numbers = k4_xboole_0(k2_xboole_0(k2_arytm_2,k2_zfmisc_1(k1_tarski(np__0),k2_arytm_2)),k1_tarski(k4_tarski(np__0,np__0))) ).

fof(d3_numbers,axiom,
    k3_numbers = k4_xboole_0(k2_xboole_0(k6_arytm_3,k2_zfmisc_1(k1_tarski(np__0),k6_arytm_3)),k1_tarski(k4_tarski(np__0,np__0))) ).

fof(d4_numbers,axiom,
    k4_numbers = k4_xboole_0(k2_xboole_0(k5_ordinal2,k2_zfmisc_1(k1_tarski(np__0),k5_ordinal2)),k1_tarski(k4_tarski(np__0,np__0))) ).

fof(t1_numbers,axiom,
    r2_xboole_0(k1_numbers,k2_numbers) ).

fof(t2_numbers,axiom,
    r2_xboole_0(k3_numbers,k1_numbers) ).

fof(t3_numbers,axiom,
    r2_xboole_0(k3_numbers,k2_numbers) ).

fof(t4_numbers,axiom,
    r2_xboole_0(k4_numbers,k3_numbers) ).

fof(t5_numbers,axiom,
    r2_xboole_0(k4_numbers,k1_numbers) ).

fof(t6_numbers,axiom,
    r2_xboole_0(k4_numbers,k2_numbers) ).

fof(t7_numbers,axiom,
    r2_xboole_0(k5_numbers,k4_numbers) ).

fof(t8_numbers,axiom,
    r2_xboole_0(k5_numbers,k3_numbers) ).

fof(t9_numbers,axiom,
    r2_xboole_0(k5_numbers,k1_numbers) ).

fof(t10_numbers,axiom,
    r2_xboole_0(k5_numbers,k2_numbers) ).

fof(t11_numbers,axiom,
    r1_tarski(k1_numbers,k2_numbers) ).

fof(t12_numbers,axiom,
    r1_tarski(k3_numbers,k1_numbers) ).

fof(t13_numbers,axiom,
    r1_tarski(k3_numbers,k2_numbers) ).

fof(t14_numbers,axiom,
    r1_tarski(k4_numbers,k3_numbers) ).

fof(t15_numbers,axiom,
    r1_tarski(k4_numbers,k1_numbers) ).

fof(t16_numbers,axiom,
    r1_tarski(k4_numbers,k2_numbers) ).

fof(t17_numbers,axiom,
    r1_tarski(k5_numbers,k4_numbers) ).

fof(t18_numbers,axiom,
    r1_tarski(k5_numbers,k3_numbers) ).

fof(t19_numbers,axiom,
    r1_tarski(k5_numbers,k1_numbers) ).

fof(t20_numbers,axiom,
    r1_tarski(k5_numbers,k2_numbers) ).

fof(t21_numbers,axiom,
    k1_numbers != k2_numbers ).

fof(t22_numbers,axiom,
    k3_numbers != k1_numbers ).

fof(t23_numbers,axiom,
    k3_numbers != k2_numbers ).

fof(t24_numbers,axiom,
    k4_numbers != k3_numbers ).

fof(t25_numbers,axiom,
    k4_numbers != k1_numbers ).

fof(t26_numbers,axiom,
    k4_numbers != k2_numbers ).

fof(t27_numbers,axiom,
    k5_numbers != k4_numbers ).

fof(t28_numbers,axiom,
    k5_numbers != k3_numbers ).

fof(t29_numbers,axiom,
    k5_numbers != k1_numbers ).

fof(t30_numbers,axiom,
    k5_numbers != k2_numbers ).

fof(dt_k1_numbers,axiom,
    $true ).

fof(dt_k2_numbers,axiom,
    $true ).

fof(dt_k3_numbers,axiom,
    $true ).

fof(dt_k4_numbers,axiom,
    $true ).

fof(dt_k5_numbers,axiom,
    m1_subset_1(k5_numbers,k1_zfmisc_1(k1_numbers)) ).

fof(redefinition_k5_numbers,axiom,
    k5_numbers = k5_ordinal2 ).

fof(d2_numbers,axiom,
    k2_numbers = k2_xboole_0(k4_xboole_0(k1_funct_2(k2_tarski(np__0,k13_arytm_3),k1_numbers),a_0_0_numbers),k1_numbers) ).

fof(fraenkel_a_0_0_numbers,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_0_numbers)
    <=> ? [B] :
          ( m1_subset_1(B,k1_funct_2(k2_tarski(np__0,k13_arytm_3),k1_numbers))
          & A = B
          & k1_funct_1(B,k13_arytm_3) = np__0 ) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(rc1_card_1,axiom,
    ? [A] : v1_card_1(A) ).

fof(cc1_card_1,axiom,
    ! [A] :
      ( v1_card_1(A)
     => ( v1_ordinal1(A)
        & v2_ordinal1(A)
        & v3_ordinal1(A) ) ) ).

fof(fc1_card_1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ( v1_ordinal1(k3_card_1(A))
        & v2_ordinal1(k3_card_1(A))
        & v3_ordinal1(k3_card_1(A))
        & v1_card_1(k3_card_1(A)) ) ) ).

fof(cc2_card_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k5_numbers)
     => ( v1_ordinal1(A)
        & v2_ordinal1(A)
        & v3_ordinal1(A)
        & v4_ordinal2(A)
        & v1_xcmplx_0(A)
        & v1_xreal_0(A)
        & ~ v3_xreal_0(A)
        & v1_card_1(A) ) ) ).

fof(cc3_card_1,axiom,
    ! [A] :
      ( m1_subset_1(A,k5_numbers)
     => ( v1_ordinal1(A)
        & v2_ordinal1(A)
        & v3_ordinal1(A)
        & v4_ordinal2(A)
        & v1_xcmplx_0(A)
        & v1_finset_1(A)
        & v1_xreal_0(A)
        & ~ v3_xreal_0(A)
        & v1_card_1(A) ) ) ).

fof(rc2_card_1,axiom,
    ? [A] :
      ( v1_ordinal1(A)
      & v2_ordinal1(A)
      & v3_ordinal1(A)
      & v1_finset_1(A)
      & v1_card_1(A) ) ).

fof(fc2_card_1,axiom,
    ! [A] :
      ( v1_finset_1(A)
     => ( v1_ordinal1(k1_card_1(A))
        & v2_ordinal1(k1_card_1(A))
        & v3_ordinal1(k1_card_1(A))
        & v1_finset_1(k1_card_1(A))
        & v1_card_1(k1_card_1(A)) ) ) ).

fof(d1_card_1,axiom,
    ! [A] :
      ( v1_card_1(A)
    <=> ? [B] :
          ( v3_ordinal1(B)
          & A = B
          & ! [C] :
              ( v3_ordinal1(C)
             => ( r2_wellord2(C,B)
               => r1_ordinal1(B,C) ) ) ) ) ).

fof(t1_card_1,axiom,
    $true ).

fof(t2_card_1,axiom,
    $true ).

fof(t3_card_1,axiom,
    $true ).

fof(t4_card_1,axiom,
    ! [A] :
    ? [B] :
      ( v3_ordinal1(B)
      & r2_wellord2(A,B) ) ).

fof(t5_card_1,axiom,
    $true ).

fof(t6_card_1,axiom,
    $true ).

fof(t7_card_1,axiom,
    $true ).

fof(t8_card_1,axiom,
    ! [A] :
      ( v1_card_1(A)
     => ! [B] :
          ( v1_card_1(B)
         => ( A = B
          <=> r2_wellord2(A,B) ) ) ) ).

fof(t9_card_1,axiom,
    $true ).

fof(t10_card_1,axiom,
    $true ).

fof(t11_card_1,axiom,
    $true ).

fof(t12_card_1,axiom,
    $true ).

fof(t13_card_1,axiom,
    ! [A] :
      ( v1_card_1(A)
     => ! [B] :
          ( v1_card_1(B)
         => ( r2_hidden(A,B)
          <=> ( r1_tarski(A,B)
              & A != B ) ) ) ) ).

fof(t14_card_1,axiom,
    ! [A] :
      ( v1_card_1(A)
     => ! [B] :
          ( v1_card_1(B)
         => ( r2_hidden(A,B)
          <=> ~ r1_tarski(B,A) ) ) ) ).

fof(d2_card_1,axiom,
    $true ).

fof(d3_card_1,axiom,
    $true ).

fof(d4_card_1,axiom,
    $true ).

fof(d5_card_1,axiom,
    ! [A,B] :
      ( v1_card_1(B)
     => ( B = k1_card_1(A)
      <=> r2_wellord2(A,B) ) ) ).

fof(t15_card_1,axiom,
    $true ).

fof(t16_card_1,axiom,
    $true ).

fof(t17_card_1,axiom,
    $true ).

fof(t18_card_1,axiom,
    $true ).

fof(t19_card_1,axiom,
    $true ).

fof(t20_card_1,axiom,
    $true ).

fof(t21_card_1,axiom,
    ! [A,B] :
      ( r2_wellord2(A,B)
    <=> k1_card_1(A) = k1_card_1(B) ) ).

fof(t22_card_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v2_wellord1(A)
       => r2_wellord2(k3_relat_1(A),k2_wellord2(A)) ) ) ).

fof(t23_card_1,axiom,
    ! [A,B] :
      ( v1_card_1(B)
     => ( r1_tarski(A,B)
       => r1_tarski(k1_card_1(A),B) ) ) ).

fof(t24_card_1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => r1_ordinal1(k1_card_1(A),A) ) ).

fof(t25_card_1,axiom,
    ! [A,B] :
      ( v1_card_1(B)
     => ( r2_hidden(A,B)
       => r2_hidden(k1_card_1(A),B) ) ) ).

fof(t26_card_1,axiom,
    ! [A,B] :
      ( r1_tarski(k1_card_1(A),k1_card_1(B))
    <=> ? [C] :
          ( v1_relat_1(C)
          & v1_funct_1(C)
          & v2_funct_1(C)
          & k1_relat_1(C) = A
          & r1_tarski(k2_relat_1(C),B) ) ) ).

fof(t27_card_1,axiom,
    ! [A,B] :
      ( r1_tarski(A,B)
     => r1_tarski(k1_card_1(A),k1_card_1(B)) ) ).

fof(t28_card_1,axiom,
    ! [A,B] :
      ( r1_tarski(k1_card_1(A),k1_card_1(B))
    <=> ? [C] :
          ( v1_relat_1(C)
          & v1_funct_1(C)
          & k1_relat_1(C) = B
          & r1_tarski(A,k2_relat_1(C)) ) ) ).

fof(t29_card_1,axiom,
    ! [A] : ~ r2_wellord2(A,k1_zfmisc_1(A)) ).

fof(t30_card_1,axiom,
    ! [A] : r2_hidden(k1_card_1(A),k1_card_1(k1_zfmisc_1(A))) ).

fof(d6_card_1,axiom,
    ! [A,B] :
      ( v1_card_1(B)
     => ( B = k2_card_1(A)
      <=> ( r2_hidden(k1_card_1(A),B)
          & ! [C] :
              ( v1_card_1(C)
             => ( r2_hidden(k1_card_1(A),C)
               => r1_tarski(B,C) ) ) ) ) ) ).

fof(t31_card_1,axiom,
    $true ).

fof(t32_card_1,axiom,
    ! [A] :
      ( v1_card_1(A)
     => r2_hidden(A,k2_card_1(A)) ) ).

fof(t33_card_1,axiom,
    ! [A] : r2_hidden(k1_card_1(k1_xboole_0),k2_card_1(A)) ).

fof(t34_card_1,axiom,
    ! [A,B] :
      ( k1_card_1(A) = k1_card_1(B)
     => k2_card_1(A) = k2_card_1(B) ) ).

fof(t35_card_1,axiom,
    ! [A,B] :
      ( r2_wellord2(A,B)
     => k2_card_1(A) = k2_card_1(B) ) ).

fof(t36_card_1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => r2_hidden(A,k2_card_1(A)) ) ).

fof(d7_card_1,axiom,
    ! [A] :
      ( v1_card_1(A)
     => ( v2_card_1(A)
      <=> ! [B] :
            ( v1_card_1(B)
           => A != k2_card_1(B) ) ) ) ).

fof(d8_card_1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( B = k3_card_1(A)
        <=> ? [C] :
              ( v1_relat_1(C)
              & v1_funct_1(C)
              & v5_ordinal1(C)
              & B = k1_ordinal2(C)
              & k1_relat_1(C) = k1_ordinal1(A)
              & k1_funct_1(C,k1_xboole_0) = k1_card_1(k5_numbers)
              & ! [D] :
                  ( v3_ordinal1(D)
                 => ( r2_hidden(k1_ordinal1(D),k1_ordinal1(A))
                   => k1_funct_1(C,k1_ordinal1(D)) = k2_card_1(k3_tarski(k1_tarski(k1_funct_1(C,D)))) ) )
              & ! [D] :
                  ( v3_ordinal1(D)
                 => ( ( r2_hidden(D,k1_ordinal1(A))
                      & v4_ordinal1(D) )
                   => ( D = k1_xboole_0
                      | k1_funct_1(C,D) = k1_card_1(k8_ordinal2(k2_ordinal1(C,D))) ) ) ) ) ) ) ).

fof(t37_card_1,axiom,
    $true ).

fof(t38_card_1,axiom,
    k3_card_1(np__0) = k1_card_1(k5_numbers) ).

fof(t39_card_1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => k3_card_1(k1_ordinal1(A)) = k2_card_1(k3_card_1(A)) ) ).

fof(t40_card_1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ( v4_ordinal1(A)
       => ( A = k1_xboole_0
          | ! [B] :
              ( ( v1_relat_1(B)
                & v1_funct_1(B)
                & v5_ordinal1(B) )
             => ( ( k1_relat_1(B) = A
                  & ! [C] :
                      ( v3_ordinal1(C)
                     => ( r2_hidden(C,A)
                       => k1_funct_1(B,C) = k3_card_1(C) ) ) )
               => k3_card_1(A) = k1_card_1(k8_ordinal2(B)) ) ) ) ) ) ).

fof(t41_card_1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( r2_hidden(A,B)
          <=> r2_hidden(k3_card_1(A),k3_card_1(B)) ) ) ) ).

fof(t42_card_1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( k3_card_1(A) = k3_card_1(B)
           => A = B ) ) ) ).

fof(t43_card_1,axiom,
    ! [A] :
      ( v3_ordinal1(A)
     => ! [B] :
          ( v3_ordinal1(B)
         => ( r1_ordinal1(A,B)
          <=> r1_tarski(k3_card_1(A),k3_card_1(B)) ) ) ) ).

fof(t44_card_1,axiom,
    ! [A,B,C] :
      ( ( r1_tarski(A,B)
        & r1_tarski(B,C)
        & r2_wellord2(A,C) )
     => ( r2_wellord2(A,B)
        & r2_wellord2(B,C) ) ) ).

fof(t45_card_1,axiom,
    ! [A,B] :
      ( r1_tarski(k1_zfmisc_1(A),B)
     => ( r2_hidden(k1_card_1(A),k1_card_1(B))
        & ~ r2_wellord2(A,B) ) ) ).

fof(t46_card_1,axiom,
    ! [A] :
      ( r2_wellord2(A,k1_xboole_0)
    <=> A = k1_xboole_0 ) ).

fof(t47_card_1,axiom,
    k1_card_1(k1_xboole_0) = k1_xboole_0 ).

fof(t48_card_1,axiom,
    ! [A,B] :
      ( r2_wellord2(A,k1_tarski(B))
    <=> ? [C] : A = k1_tarski(C) ) ).

fof(t49_card_1,axiom,
    ! [A,B] :
      ( k1_card_1(A) = k1_card_1(k1_tarski(B))
    <=> ? [C] : A = k1_tarski(C) ) ).

fof(t50_card_1,axiom,
    ! [A] : k1_card_1(k1_tarski(A)) = k4_ordinal2 ).

fof(t51_card_1,axiom,
    np__0 = k1_xboole_0 ).

fof(t52_card_1,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => k1_ordinal1(A) = k1_nat_1(A,np__1) ) ).

fof(t53_card_1,axiom,
    $true ).

fof(t54_card_1,axiom,
    $true ).

fof(t55_card_1,axiom,
    $true ).

fof(t56_card_1,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
         => ( r1_xreal_0(A,B)
          <=> r1_ordinal1(A,B) ) ) ) ).

fof(t57_card_1,axiom,
    $true ).

fof(t58_card_1,axiom,
    ! [A,B,C,D] :
      ( ( r1_xboole_0(A,B)
        & r1_xboole_0(C,D)
        & r2_wellord2(A,C)
        & r2_wellord2(B,D) )
     => r2_wellord2(k2_xboole_0(A,B),k2_xboole_0(C,D)) ) ).

fof(t59_card_1,axiom,
    ! [A,B,C] :
      ( ( r2_hidden(A,B)
        & r2_hidden(C,B) )
     => r2_wellord2(k4_xboole_0(B,k1_tarski(A)),k4_xboole_0(B,k1_tarski(C))) ) ).

fof(t60_card_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( ( r1_tarski(A,k1_relat_1(B))
          & v2_funct_1(B) )
       => r2_wellord2(A,k9_relat_1(B,A)) ) ) ).

fof(t61_card_1,axiom,
    ! [A,B,C,D] :
      ( ( r2_wellord2(A,B)
        & r2_hidden(C,A)
        & r2_hidden(D,B) )
     => r2_wellord2(k4_xboole_0(A,k1_tarski(C)),k4_xboole_0(B,k1_tarski(D))) ) ).

fof(t62_card_1,axiom,
    $true ).

fof(t63_card_1,axiom,
    $true ).

fof(t64_card_1,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
         => ( r2_wellord2(A,B)
           => A = B ) ) ) ).

fof(t65_card_1,axiom,
    ! [A] :
      ( r2_hidden(A,k5_ordinal2)
     => v1_card_1(A) ) ).

fof(t66_card_1,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => A = k1_card_1(A) ) ).

fof(t67_card_1,axiom,
    $true ).

fof(t68_card_1,axiom,
    ! [A,B] :
      ( ( r2_wellord2(A,B)
        & v1_finset_1(A) )
     => v1_finset_1(B) ) ).

fof(t69_card_1,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ( v1_finset_1(A)
        & v1_finset_1(k1_card_1(A)) ) ) ).

fof(t70_card_1,axiom,
    $true ).

fof(t71_card_1,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
         => ( k1_card_1(A) = k1_card_1(B)
           => A = B ) ) ) ).

fof(t72_card_1,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
         => ( r1_tarski(k1_card_1(A),k1_card_1(B))
          <=> r1_xreal_0(A,B) ) ) ) ).

fof(t73_card_1,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
         => ( r2_hidden(k1_card_1(A),k1_card_1(B))
          <=> ~ r1_xreal_0(B,A) ) ) ) ).

fof(t74_card_1,axiom,
    ! [A] :
      ~ ( v1_finset_1(A)
        & ! [B] :
            ( m2_subset_1(B,k1_numbers,k5_numbers)
           => ~ r2_wellord2(A,B) ) ) ).

fof(t75_card_1,axiom,
    $true ).

fof(t76_card_1,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => k2_card_1(k1_card_1(A)) = k1_card_1(k1_nat_1(A,np__1)) ) ).

fof(d9_card_1,axiom,
    $true ).

fof(d10_card_1,axiom,
    $true ).

fof(d11_card_1,axiom,
    ! [A] :
      ( v1_finset_1(A)
     => ! [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
         => ( B = k4_card_1(A)
          <=> k1_card_1(B) = k1_card_1(A) ) ) ) ).

fof(t77_card_1,axiom,
    $true ).

fof(t78_card_1,axiom,
    k4_card_1(k1_xboole_0) = np__0 ).

fof(t79_card_1,axiom,
    ! [A] : k4_card_1(k1_tarski(A)) = np__1 ).

fof(t80_card_1,axiom,
    ! [A] :
      ( v1_finset_1(A)
     => ! [B] :
          ( v1_finset_1(B)
         => ( r1_tarski(A,B)
           => r1_xreal_0(k4_card_1(A),k4_card_1(B)) ) ) ) ).

fof(t81_card_1,axiom,
    ! [A] :
      ( v1_finset_1(A)
     => ! [B] :
          ( v1_finset_1(B)
         => ( r2_wellord2(A,B)
           => k4_card_1(A) = k4_card_1(B) ) ) ) ).

fof(t82_card_1,axiom,
    ! [A] :
      ( v1_finset_1(A)
     => v1_finset_1(k2_card_1(A)) ) ).

fof(t83_card_1,axiom,
    k3_card_1(np__0) = k5_ordinal2 ).

fof(t84_card_1,axiom,
    k1_card_1(k5_ordinal2) = k5_ordinal2 ).

fof(t85_card_1,axiom,
    v2_card_1(k1_card_1(k5_ordinal2)) ).

fof(t86_card_1,axiom,
    ! [A] :
      ( ( v1_finset_1(A)
        & v1_card_1(A) )
     => ? [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
          & A = k1_card_1(B) ) ) ).

fof(s1_card_1,axiom,
    ( ( p1_s1_card_1(k1_xboole_0)
      & ! [A] :
          ( v1_card_1(A)
         => ( p1_s1_card_1(A)
           => p1_s1_card_1(k2_card_1(A)) ) )
      & ! [A] :
          ( v1_card_1(A)
         => ( ( v2_card_1(A)
              & ! [B] :
                  ( v1_card_1(B)
                 => ( r2_hidden(B,A)
                   => p1_s1_card_1(B) ) ) )
           => ( A = k1_xboole_0
              | p1_s1_card_1(A) ) ) ) )
   => ! [A] :
        ( v1_card_1(A)
       => p1_s1_card_1(A) ) ) ).

fof(s2_card_1,axiom,
    ( ! [A] :
        ( v1_card_1(A)
       => ( ! [B] :
              ( v1_card_1(B)
             => ( r2_hidden(B,A)
               => p1_s2_card_1(B) ) )
         => p1_s2_card_1(A) ) )
   => ! [A] :
        ( v1_card_1(A)
       => p1_s2_card_1(A) ) ) ).

fof(dt_k1_card_1,axiom,
    ! [A] : v1_card_1(k1_card_1(A)) ).

fof(dt_k2_card_1,axiom,
    ! [A] : v1_card_1(k2_card_1(A)) ).

fof(dt_k3_card_1,axiom,
    $true ).

fof(dt_k4_card_1,axiom,
    ! [A] :
      ( v1_finset_1(A)
     => m2_subset_1(k4_card_1(A),k1_numbers,k5_numbers) ) ).

fof(redefinition_k4_card_1,axiom,
    ! [A] :
      ( v1_finset_1(A)
     => k4_card_1(A) = k1_card_1(A) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(rc1_finseq_1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A)
      & v1_finseq_1(A) ) ).

fof(fc1_finseq_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => v1_finset_1(k1_finseq_1(A)) ) ).

fof(cc1_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finset_1(A) ) ) ).

fof(fc2_finseq_1,axiom,
    ( v1_xboole_0(k1_xboole_0)
    & v1_relat_1(k1_xboole_0)
    & v3_relat_1(k1_xboole_0)
    & v1_funct_1(k1_xboole_0)
    & v2_funct_1(k1_xboole_0)
    & v1_finset_1(k1_xboole_0)
    & v1_finseq_1(k1_xboole_0) ) ).

fof(rc2_finseq_1,axiom,
    ! [A] :
    ? [B] :
      ( m1_relset_1(B,k5_numbers,A)
      & v1_relat_1(B)
      & v1_funct_1(B)
      & v1_finset_1(B)
      & v1_finseq_1(B) ) ).

fof(rc3_finseq_1,axiom,
    ? [A] :
      ( v1_xboole_0(A)
      & v1_relat_1(A)
      & v1_funct_1(A)
      & v2_funct_1(A)
      & v1_finset_1(A)
      & v1_finseq_1(A) ) ).

fof(rc4_finseq_1,axiom,
    ! [A] :
    ? [B] :
      ( m1_finseq_1(B,A)
      & v1_xboole_0(B)
      & v1_relat_1(B)
      & v1_funct_1(B)
      & v2_funct_1(B)
      & v1_finset_1(B)
      & v1_finseq_1(B) ) ).

fof(fc3_finseq_1,axiom,
    ! [A] :
      ( v1_relat_1(k5_finseq_1(A))
      & v1_funct_1(k5_finseq_1(A)) ) ).

fof(fc4_finseq_1,axiom,
    ! [A] :
      ( v1_relat_1(k5_finseq_1(A))
      & v1_funct_1(k5_finseq_1(A))
      & v1_finset_1(k5_finseq_1(A))
      & v1_finseq_1(k5_finseq_1(A)) ) ).

fof(fc5_finseq_1,axiom,
    ! [A,B] :
      ( v1_relat_1(k10_finseq_1(A,B))
      & v1_funct_1(k10_finseq_1(A,B)) ) ).

fof(fc6_finseq_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(k11_finseq_1(A,B,C))
      & v1_funct_1(k11_finseq_1(A,B,C)) ) ).

fof(fc7_finseq_1,axiom,
    ! [A,B] :
      ( v1_relat_1(k10_finseq_1(A,B))
      & v1_funct_1(k10_finseq_1(A,B))
      & v1_finset_1(k10_finseq_1(A,B))
      & v1_finseq_1(k10_finseq_1(A,B)) ) ).

fof(fc8_finseq_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(k11_finseq_1(A,B,C))
      & v1_funct_1(k11_finseq_1(A,B,C))
      & v1_finset_1(k11_finseq_1(A,B,C))
      & v1_finseq_1(k11_finseq_1(A,B,C)) ) ).

fof(fc9_finseq_1,axiom,
    ! [A] : ~ v1_xboole_0(k13_finseq_1(A)) ).

fof(rc5_finseq_1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A)
      & v2_finseq_1(A) ) ).

fof(fc10_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v2_finseq_1(A) )
     => ( v1_relat_1(k15_finseq_1(A))
        & v1_funct_1(k15_finseq_1(A))
        & v1_finset_1(k15_finseq_1(A))
        & v1_finseq_1(k15_finseq_1(A)) ) ) ).

fof(rc6_finseq_1,axiom,
    ? [A] :
      ( v1_xboole_0(A)
      & v1_relat_1(A)
      & v1_funct_1(A)
      & v2_funct_1(A)
      & v1_finset_1(A) ) ).

fof(rc7_finseq_1,axiom,
    ? [A] :
      ( ~ v1_xboole_0(A)
      & v1_relat_1(A)
      & v1_funct_1(A)
      & v1_finset_1(A) ) ).

fof(fc11_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_finset_1(A) )
     => v1_finset_1(k2_relat_1(A)) ) ).

fof(fc12_finseq_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(k5_finseq_1(A))
      & v1_relat_1(k5_finseq_1(A))
      & v1_funct_1(k5_finseq_1(A))
      & v1_finset_1(k5_finseq_1(A))
      & v1_finseq_1(k5_finseq_1(A)) ) ).

fof(rc8_finseq_1,axiom,
    ? [A] :
      ( ~ v1_xboole_0(A)
      & v1_relat_1(A)
      & v1_funct_1(A)
      & v1_finset_1(A)
      & v1_finseq_1(A) ) ).

fof(fc13_finseq_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A)
        & ~ v1_xboole_0(B)
        & v1_relat_1(B)
        & v1_funct_1(B)
        & v1_finseq_1(B) )
     => ( ~ v1_xboole_0(k7_finseq_1(A,B))
        & v1_relat_1(k7_finseq_1(A,B))
        & v1_funct_1(k7_finseq_1(A,B))
        & v1_finset_1(k7_finseq_1(A,B))
        & v1_finseq_1(k7_finseq_1(A,B)) ) ) ).

fof(fc14_finseq_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A)
        & ~ v1_xboole_0(B)
        & v1_relat_1(B)
        & v1_funct_1(B)
        & v1_finseq_1(B) )
     => ( ~ v1_xboole_0(k7_finseq_1(B,A))
        & v1_relat_1(k7_finseq_1(B,A))
        & v1_funct_1(k7_finseq_1(B,A))
        & v1_finset_1(k7_finseq_1(B,A))
        & v1_finseq_1(k7_finseq_1(B,A)) ) ) ).

fof(fc15_finseq_1,axiom,
    ! [A,B] :
      ( m1_finseq_1(B,A)
     => ( v1_xboole_0(k16_finseq_1(A,B,np__0))
        & v1_relat_1(k16_finseq_1(A,B,np__0))
        & v1_funct_1(k16_finseq_1(A,B,np__0))
        & v2_funct_1(k16_finseq_1(A,B,np__0))
        & v1_finset_1(k16_finseq_1(A,B,np__0))
        & v1_finseq_1(k16_finseq_1(A,B,np__0)) ) ) ).

fof(fc16_finseq_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(k13_finseq_1(A))
      & v1_fraenkel(k13_finseq_1(A)) ) ).

fof(fc17_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finset_1(A) )
     => v1_finset_1(k1_relat_1(A)) ) ).

fof(fc18_finseq_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finset_1(A) )
     => v1_finset_1(k10_relat_1(A,B)) ) ).

fof(t1_finseq_1,axiom,
    $true ).

fof(t2_finseq_1,axiom,
    $true ).

fof(t3_finseq_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ( r2_hidden(A,k2_finseq_1(B))
          <=> ( r1_xreal_0(np__1,A)
              & r1_xreal_0(A,B) ) ) ) ) ).

fof(t4_finseq_1,axiom,
    ( k2_finseq_1(np__0) = k1_xboole_0
    & k2_finseq_1(np__1) = k1_tarski(np__1)
    & k2_finseq_1(np__2) = k2_tarski(np__1,np__2) ) ).

fof(t5_finseq_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ( A = np__0
        | r2_hidden(A,k2_finseq_1(A)) ) ) ).

fof(t6_finseq_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => r2_hidden(k2_xcmplx_0(A,np__1),k2_finseq_1(k2_xcmplx_0(A,np__1))) ) ).

fof(t7_finseq_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ( r1_xreal_0(A,B)
          <=> r1_tarski(k2_finseq_1(A),k2_finseq_1(B)) ) ) ) ).

fof(t8_finseq_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ( k2_finseq_1(A) = k2_finseq_1(B)
           => A = B ) ) ) ).

fof(t9_finseq_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ( r1_xreal_0(A,B)
           => k2_finseq_1(A) = k5_subset_1(k5_numbers,k2_finseq_1(B),k2_finseq_1(A)) ) ) ) ).

fof(t10_finseq_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v4_ordinal2(B)
         => ( k2_finseq_1(A) = k5_subset_1(k5_numbers,k2_finseq_1(A),k2_finseq_1(B))
           => r1_xreal_0(A,B) ) ) ) ).

fof(t11_finseq_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => k2_xboole_0(k2_finseq_1(A),k1_tarski(k2_xcmplx_0(A,np__1))) = k2_finseq_1(k2_xcmplx_0(A,np__1)) ) ).

fof(t12_finseq_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => k2_finseq_1(A) = k4_xboole_0(k2_finseq_1(k2_xcmplx_0(A,np__1)),k1_tarski(k2_xcmplx_0(A,np__1))) ) ).

fof(d2_finseq_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v1_finseq_1(A)
      <=> ? [B] :
            ( m2_subset_1(B,k1_numbers,k5_numbers)
            & k1_relat_1(A) = k2_finseq_1(B) ) ) ) ).

fof(d3_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ! [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
         => ( B = k3_finseq_1(A)
          <=> k2_finseq_1(B) = k1_relat_1(A) ) ) ) ).

fof(t13_finseq_1,axiom,
    $true ).

fof(t14_finseq_1,axiom,
    ( v1_relat_1(k1_xboole_0)
    & v1_funct_1(k1_xboole_0)
    & v1_finseq_1(k1_xboole_0) ) ).

fof(t15_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ~ ( ? [B] :
              ( m2_subset_1(B,k1_numbers,k5_numbers)
              & r1_tarski(k1_relat_1(A),k2_finseq_1(B)) )
          & ! [B] :
              ( ( v1_relat_1(B)
                & v1_funct_1(B)
                & v1_finseq_1(B) )
             => ~ r1_tarski(A,B) ) ) ) ).

fof(t16_finseq_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B)
        & v1_finseq_1(B) )
     => ~ ( r2_hidden(A,B)
          & ! [C] :
              ( m2_subset_1(C,k1_numbers,k5_numbers)
             => ~ ( r2_hidden(C,k4_finseq_1(B))
                  & A = k4_tarski(C,k1_funct_1(B,C)) ) ) ) ) ).

fof(t17_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => ( ( k4_finseq_1(A) = k4_finseq_1(B)
              & ! [C] :
                  ( m2_subset_1(C,k1_numbers,k5_numbers)
                 => ( r2_hidden(C,k4_finseq_1(A))
                   => k1_funct_1(A,C) = k1_funct_1(B,C) ) ) )
           => A = B ) ) ) ).

fof(t18_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => ( ( k3_finseq_1(A) = k3_finseq_1(B)
              & ! [C] :
                  ( m2_subset_1(C,k1_numbers,k5_numbers)
                 => ( ( r1_xreal_0(np__1,C)
                      & r1_xreal_0(C,k3_finseq_1(A)) )
                   => k1_funct_1(A,C) = k1_funct_1(B,C) ) ) )
           => A = B ) ) ) ).

fof(t19_finseq_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => ( v1_relat_1(k7_relat_1(B,k2_finseq_1(A)))
            & v1_funct_1(k7_relat_1(B,k2_finseq_1(A)))
            & v1_finseq_1(k7_relat_1(B,k2_finseq_1(A))) ) ) ) ).

fof(t20_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => ( r1_tarski(k2_relat_1(B),k1_relat_1(A))
           => ( v1_relat_1(k5_relat_1(B,A))
              & v1_funct_1(k5_relat_1(B,A))
              & v1_finseq_1(k5_relat_1(B,A)) ) ) ) ) ).

fof(t21_finseq_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C)
                & v1_finseq_1(C) )
             => ( ( r1_xreal_0(A,k3_finseq_1(B))
                  & C = k7_relat_1(B,k2_finseq_1(A)) )
               => ( k3_finseq_1(C) = A
                  & k4_finseq_1(C) = k2_finseq_1(A) ) ) ) ) ) ).

fof(d4_finseq_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B)
        & v1_finseq_1(B) )
     => ( m1_finseq_1(B,A)
      <=> r1_tarski(k2_relat_1(B),A) ) ) ).

fof(t22_finseq_1,axiom,
    $true ).

fof(t23_finseq_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B,C] :
          ( m2_finseq_1(C,B)
         => m2_finseq_1(k7_relat_1(C,k2_finseq_1(A)),B) ) ) ).

fof(t24_finseq_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ? [C] :
              ( m2_finseq_1(C,B)
              & k3_finseq_1(C) = A ) ) ) ).

fof(t25_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ( k3_finseq_1(A) = np__0
      <=> A = k1_xboole_0 ) ) ).

fof(t26_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ( A = k1_xboole_0
      <=> k4_finseq_1(A) = k1_xboole_0 ) ) ).

fof(t27_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ( A = k1_xboole_0
      <=> k2_relat_1(A) = k1_xboole_0 ) ) ).

fof(t28_finseq_1,axiom,
    $true ).

fof(t29_finseq_1,axiom,
    ! [A] : m2_finseq_1(k1_xboole_0,A) ).

fof(d5_finseq_1,axiom,
    ! [A] : k5_finseq_1(A) = k1_tarski(k4_tarski(np__1,A)) ).

fof(d6_finseq_1,axiom,
    ! [A] : k6_finseq_1(A) = k1_xboole_0 ).

fof(t30_finseq_1,axiom,
    $true ).

fof(t31_finseq_1,axiom,
    $true ).

fof(t32_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ! [B] :
          ( A = k6_finseq_1(B)
        <=> k3_finseq_1(A) = np__0 ) ) ).

fof(d7_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C)
                & v1_finseq_1(C) )
             => ( C = k7_finseq_1(A,B)
              <=> ( k4_finseq_1(C) = k2_finseq_1(k1_nat_1(k3_finseq_1(A),k3_finseq_1(B)))
                  & ! [D] :
                      ( m2_subset_1(D,k1_numbers,k5_numbers)
                     => ( r2_hidden(D,k4_finseq_1(A))
                       => k1_funct_1(C,D) = k1_funct_1(A,D) ) )
                  & ! [D] :
                      ( m2_subset_1(D,k1_numbers,k5_numbers)
                     => ( r2_hidden(D,k4_finseq_1(B))
                       => k1_funct_1(C,k1_nat_1(k3_finseq_1(A),D)) = k1_funct_1(B,D) ) ) ) ) ) ) ) ).

fof(t33_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => A = k7_relat_1(k7_finseq_1(A,B),k4_finseq_1(A)) ) ) ).

fof(t34_finseq_1,axiom,
    $true ).

fof(t35_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => k3_finseq_1(k7_finseq_1(A,B)) = k1_nat_1(k3_finseq_1(A),k3_finseq_1(B)) ) ) ).

fof(t36_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => ! [C] :
              ( v4_ordinal2(C)
             => ( ( r1_xreal_0(k1_nat_1(k3_finseq_1(A),np__1),C)
                  & r1_xreal_0(C,k1_nat_1(k3_finseq_1(A),k3_finseq_1(B))) )
               => k1_funct_1(k7_finseq_1(A,B),C) = k1_funct_1(B,k6_xcmplx_0(C,k3_finseq_1(A))) ) ) ) ) ).

fof(t37_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => ! [C] :
              ( v4_ordinal2(C)
             => ( r1_xreal_0(C,k3_finseq_1(k7_finseq_1(A,B)))
               => ( r1_xreal_0(C,k3_finseq_1(A))
                  | k1_funct_1(k7_finseq_1(A,B),C) = k1_funct_1(B,k6_xcmplx_0(C,k3_finseq_1(A))) ) ) ) ) ) ).

fof(t38_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => ! [C] :
              ( m2_subset_1(C,k1_numbers,k5_numbers)
             => ~ ( r2_hidden(C,k4_finseq_1(k7_finseq_1(A,B)))
                  & ~ r2_hidden(C,k4_finseq_1(A))
                  & ! [D] :
                      ( m2_subset_1(D,k1_numbers,k5_numbers)
                     => ~ ( r2_hidden(D,k4_finseq_1(B))
                          & C = k1_nat_1(k3_finseq_1(A),D) ) ) ) ) ) ) ).

fof(t39_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => r1_tarski(k4_finseq_1(A),k4_finseq_1(k7_finseq_1(A,B))) ) ) ).

fof(t40_finseq_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B)
        & v1_finseq_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C)
            & v1_finseq_1(C) )
         => ~ ( r2_hidden(A,k4_finseq_1(B))
              & ! [D] :
                  ( m2_subset_1(D,k1_numbers,k5_numbers)
                 => ~ ( D = A
                      & r2_hidden(k1_nat_1(k3_finseq_1(C),D),k4_finseq_1(k7_finseq_1(C,B))) ) ) ) ) ) ).

fof(t41_finseq_1,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C)
                & v1_finseq_1(C) )
             => ( r2_hidden(A,k4_finseq_1(B))
               => r2_hidden(k1_nat_1(k3_finseq_1(C),A),k4_finseq_1(k7_finseq_1(C,B))) ) ) ) ) ).

fof(t42_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => r1_tarski(k2_relat_1(A),k2_relat_1(k7_finseq_1(A,B))) ) ) ).

fof(t43_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => r1_tarski(k2_relat_1(A),k2_relat_1(k7_finseq_1(B,A))) ) ) ).

fof(t44_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => k2_relat_1(k7_finseq_1(A,B)) = k2_xboole_0(k2_relat_1(A),k2_relat_1(B)) ) ) ).

fof(t45_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C)
                & v1_finseq_1(C) )
             => k7_finseq_1(k7_finseq_1(A,B),C) = k7_finseq_1(A,k7_finseq_1(B,C)) ) ) ) ).

fof(t46_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C)
                & v1_finseq_1(C) )
             => ( ( k7_finseq_1(A,B) = k7_finseq_1(C,B)
                  | k7_finseq_1(B,A) = k7_finseq_1(B,C) )
               => A = C ) ) ) ) ).

fof(t47_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ( k7_finseq_1(A,k1_xboole_0) = A
        & k7_finseq_1(k1_xboole_0,A) = A ) ) ).

fof(t48_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => ( k7_finseq_1(A,B) = k1_xboole_0
           => ( A = k1_xboole_0
              & B = k1_xboole_0 ) ) ) ) ).

fof(d8_finseq_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( B = k9_finseq_1(A)
      <=> ( k1_relat_1(B) = k2_finseq_1(np__1)
          & k1_funct_1(B,np__1) = A ) ) ) ).

fof(t49_finseq_1,axiom,
    $true ).

fof(t50_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => ! [C] :
              ( m2_finseq_1(k7_finseq_1(A,B),C)
             => ( m2_finseq_1(A,C)
                & m2_finseq_1(B,C) ) ) ) ) ).

fof(d9_finseq_1,axiom,
    ! [A,B] : k10_finseq_1(A,B) = k7_finseq_1(k9_finseq_1(A),k9_finseq_1(B)) ).

fof(d10_finseq_1,axiom,
    ! [A,B,C] : k11_finseq_1(A,B,C) = k7_finseq_1(k7_finseq_1(k9_finseq_1(A),k9_finseq_1(B)),k9_finseq_1(C)) ).

fof(t51_finseq_1,axiom,
    $true ).

fof(t52_finseq_1,axiom,
    ! [A] : k9_finseq_1(A) = k1_tarski(k4_tarski(np__1,A)) ).

fof(t53_finseq_1,axiom,
    $true ).

fof(t54_finseq_1,axiom,
    $true ).

fof(t55_finseq_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B)
        & v1_finseq_1(B) )
     => ( B = k9_finseq_1(A)
      <=> ( k4_finseq_1(B) = k2_finseq_1(np__1)
          & k2_relat_1(B) = k1_tarski(A) ) ) ) ).

fof(t56_finseq_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B)
        & v1_finseq_1(B) )
     => ( B = k9_finseq_1(A)
      <=> ( k3_finseq_1(B) = np__1
          & k2_relat_1(B) = k1_tarski(A) ) ) ) ).

fof(t57_finseq_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B)
        & v1_finseq_1(B) )
     => ( B = k9_finseq_1(A)
      <=> ( k3_finseq_1(B) = np__1
          & k1_funct_1(B,np__1) = A ) ) ) ).

fof(t58_finseq_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B)
        & v1_finseq_1(B) )
     => k1_funct_1(k7_finseq_1(k9_finseq_1(A),B),np__1) = A ) ).

fof(t59_finseq_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B)
        & v1_finseq_1(B) )
     => k1_funct_1(k7_finseq_1(B,k9_finseq_1(A)),k1_nat_1(k3_finseq_1(B),np__1)) = A ) ).

fof(t60_finseq_1,axiom,
    ! [A,B,C] :
      ( k11_finseq_1(A,B,C) = k7_finseq_1(k9_finseq_1(A),k10_finseq_1(B,C))
      & k11_finseq_1(A,B,C) = k7_finseq_1(k10_finseq_1(A,B),k9_finseq_1(C)) ) ).

fof(t61_finseq_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C)
        & v1_finseq_1(C) )
     => ( C = k10_finseq_1(A,B)
      <=> ( k3_finseq_1(C) = np__2
          & k1_funct_1(C,np__1) = A
          & k1_funct_1(C,np__2) = B ) ) ) ).

fof(t62_finseq_1,axiom,
    ! [A,B,C,D] :
      ( ( v1_relat_1(D)
        & v1_funct_1(D)
        & v1_finseq_1(D) )
     => ( D = k11_finseq_1(A,B,C)
      <=> ( k3_finseq_1(D) = np__3
          & k1_funct_1(D,np__1) = A
          & k1_funct_1(D,np__2) = B
          & k1_funct_1(D,np__3) = C ) ) ) ).

fof(t63_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ~ ( A != k1_xboole_0
          & ! [B] :
              ( ( v1_relat_1(B)
                & v1_funct_1(B)
                & v1_finseq_1(B) )
             => ! [C] : A != k7_finseq_1(B,k9_finseq_1(C)) ) ) ) ).

fof(t64_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C)
                & v1_finseq_1(C) )
             => ! [D] :
                  ( ( v1_relat_1(D)
                    & v1_funct_1(D)
                    & v1_finseq_1(D) )
                 => ~ ( k7_finseq_1(A,B) = k7_finseq_1(C,D)
                      & r1_xreal_0(k3_finseq_1(A),k3_finseq_1(C))
                      & ! [E] :
                          ( ( v1_relat_1(E)
                            & v1_funct_1(E)
                            & v1_finseq_1(E) )
                         => k7_finseq_1(A,E) != C ) ) ) ) ) ) ).

fof(d11_finseq_1,axiom,
    ! [A,B] :
      ( B = k13_finseq_1(A)
    <=> ! [C] :
          ( r2_hidden(C,B)
        <=> m2_finseq_1(C,A) ) ) ).

fof(t65_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => ( ( k2_relat_1(A) = k2_relat_1(B)
              & v2_funct_1(A)
              & v2_funct_1(B) )
           => k3_finseq_1(A) = k3_finseq_1(B) ) ) ) ).

fof(t66_finseq_1,axiom,
    ! [A] : r2_hidden(k1_xboole_0,k13_finseq_1(A)) ).

fof(d12_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v2_finseq_1(A)
      <=> ? [B] :
            ( m2_subset_1(B,k1_numbers,k5_numbers)
            & r1_tarski(k1_relat_1(A),k2_finseq_1(B)) ) ) ) ).

fof(t67_finseq_1,axiom,
    $true ).

fof(t68_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ( v1_relat_1(A)
        & v1_funct_1(A)
        & v2_finseq_1(A) ) ) ).

fof(t69_finseq_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B)
        & v1_finseq_1(B) )
     => ( v1_relat_1(k7_relat_1(B,A))
        & v1_funct_1(k7_relat_1(B,A))
        & v2_finseq_1(k7_relat_1(B,A))
        & v1_relat_1(k8_relat_1(A,B))
        & v1_funct_1(k8_relat_1(A,B))
        & v2_finseq_1(k8_relat_1(A,B)) ) ) ).

fof(d13_finseq_1,axiom,
    ! [A] :
      ( ? [B] :
          ( v4_ordinal2(B)
          & r1_tarski(A,k2_finseq_1(B)) )
     => ! [B] :
          ( m2_finseq_1(B,k5_numbers)
         => ( B = k14_finseq_1(A)
          <=> ( k2_relat_1(B) = A
              & ! [C] :
                  ( v4_ordinal2(C)
                 => ! [D] :
                      ( v4_ordinal2(D)
                     => ! [E] :
                          ( v4_ordinal2(E)
                         => ! [F] :
                              ( v4_ordinal2(F)
                             => ~ ( r1_xreal_0(np__1,C)
                                  & ~ r1_xreal_0(D,C)
                                  & r1_xreal_0(D,k3_finseq_1(B))
                                  & E = k1_funct_1(B,C)
                                  & F = k1_funct_1(B,D)
                                  & r1_xreal_0(F,E) ) ) ) ) ) ) ) ) ) ).

fof(t70_finseq_1,axiom,
    $true ).

fof(t71_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v2_finseq_1(A) )
     => k2_relat_1(k14_finseq_1(k1_relat_1(A))) = k1_relat_1(A) ) ).

fof(d14_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v2_finseq_1(A) )
     => k15_finseq_1(A) = k5_relat_1(k14_finseq_1(k1_relat_1(A)),A) ) ).

fof(t72_finseq_1,axiom,
    ! [A] :
      ( ? [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
          & r1_tarski(A,k2_finseq_1(B)) )
     => ( k14_finseq_1(A) = k1_xboole_0
      <=> A = k1_xboole_0 ) ) ).

fof(t73_finseq_1,axiom,
    ! [A] :
      ( v1_finset_1(A)
    <=> ? [B] :
          ( v1_relat_1(B)
          & v1_funct_1(B)
          & v1_finseq_1(B)
          & A = k2_relat_1(B) ) ) ).

fof(t74_finseq_1,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
         => ( r2_wellord2(k2_finseq_1(A),k2_finseq_1(B))
           => A = B ) ) ) ).

fof(t75_finseq_1,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => r2_wellord2(k2_finseq_1(A),A) ) ).

fof(t76_finseq_1,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => k1_card_1(k2_finseq_1(A)) = k1_card_1(A) ) ).

fof(t77_finseq_1,axiom,
    ! [A] :
      ~ ( v1_finset_1(A)
        & ! [B] :
            ( m2_subset_1(B,k1_numbers,k5_numbers)
           => ~ r2_wellord2(A,k2_finseq_1(B)) ) ) ).

fof(t78_finseq_1,axiom,
    ( ! [A] :
        ( v4_ordinal2(A)
       => k4_card_1(k2_finseq_1(A)) = A )
    & ! [A] :
        ( m2_subset_1(A,k1_numbers,k5_numbers)
       => ( k4_card_1(A) = A
          & k4_card_1(k1_card_1(A)) = A ) ) ) ).

fof(d15_finseq_1,axiom,
    ! [A,B] :
      ( m2_finseq_1(B,A)
     => ! [C] :
          ( v4_ordinal2(C)
         => k16_finseq_1(A,B,C) = k7_relat_1(B,k2_finseq_1(C)) ) ) ).

fof(t79_finseq_1,axiom,
    ! [A,B] :
      ( m2_finseq_1(B,A)
     => ! [C] :
          ( v4_ordinal2(C)
         => ( r1_xreal_0(k3_finseq_1(B),C)
           => k16_finseq_1(A,B,C) = B ) ) ) ).

fof(t80_finseq_1,axiom,
    ! [A,B] :
      ( m2_finseq_1(B,A)
     => ! [C] :
          ( v4_ordinal2(C)
         => ( r1_xreal_0(C,k3_finseq_1(B))
           => k3_finseq_1(k16_finseq_1(A,B,C)) = C ) ) ) ).

fof(t81_finseq_1,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( v4_ordinal2(B)
         => ! [C] :
              ( v4_ordinal2(C)
             => ( r2_hidden(B,k2_finseq_1(A))
               => r2_hidden(k2_xcmplx_0(B,C),k2_finseq_1(k2_xcmplx_0(A,C))) ) ) ) ) ).

fof(t82_finseq_1,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( v4_ordinal2(B)
         => ! [C] :
              ( v4_ordinal2(C)
             => ( r2_hidden(k2_xcmplx_0(B,C),k2_finseq_1(k2_xcmplx_0(A,C)))
               => ( r1_xreal_0(B,np__0)
                  | ( r2_hidden(B,k2_finseq_1(A))
                    & r2_hidden(B,k2_finseq_1(k2_xcmplx_0(A,C))) ) ) ) ) ) ) ).

fof(d16_finseq_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ( B = k17_finseq_1(A)
          <=> ! [C,D] :
                ( r2_hidden(k4_tarski(C,D),B)
              <=> ( r2_hidden(C,k3_relat_1(A))
                  & r2_hidden(D,k3_relat_1(A))
                  & ? [E] :
                      ( v1_relat_1(E)
                      & v1_funct_1(E)
                      & v1_finseq_1(E)
                      & r1_xreal_0(np__1,k3_finseq_1(E))
                      & k1_funct_1(E,np__1) = C
                      & k1_funct_1(E,k3_finseq_1(E)) = D
                      & ! [F] :
                          ( m2_subset_1(F,k1_numbers,k5_numbers)
                         => ( r1_xreal_0(np__1,F)
                           => ( r1_xreal_0(k3_finseq_1(E),F)
                              | r2_hidden(k4_tarski(k1_funct_1(E,F),k1_funct_1(E,k1_nat_1(F,np__1))),A) ) ) ) ) ) ) ) ) ) ).

fof(t83_finseq_1,axiom,
    ! [A,B] :
      ( r1_tarski(A,B)
     => r1_tarski(k13_finseq_1(A),k13_finseq_1(B)) ) ).

fof(t84_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => ( r1_tarski(A,B)
           => r1_xreal_0(k3_finseq_1(A),k3_finseq_1(B)) ) ) ) ).

fof(t85_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => ! [C] :
              ( m2_subset_1(C,k1_numbers,k5_numbers)
             => ( ( r1_xreal_0(np__1,C)
                  & r1_xreal_0(C,k3_finseq_1(A)) )
               => k1_funct_1(k7_finseq_1(A,B),C) = k1_funct_1(A,C) ) ) ) ) ).

fof(t86_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => ! [C] :
              ( m2_subset_1(C,k1_numbers,k5_numbers)
             => ( ( r1_xreal_0(np__1,C)
                  & r1_xreal_0(C,k3_finseq_1(B)) )
               => k1_funct_1(k7_finseq_1(A,B),k1_nat_1(k3_finseq_1(A),C)) = k1_funct_1(B,C) ) ) ) ) ).

fof(s1_finseq_1,axiom,
    ( ( ! [A] :
          ( m2_subset_1(A,k1_numbers,k5_numbers)
         => ! [B,C] :
              ( ( r2_hidden(A,k2_finseq_1(f1_s1_finseq_1))
                & p1_s1_finseq_1(A,B)
                & p1_s1_finseq_1(A,C) )
             => B = C ) )
      & ! [A] :
          ( m2_subset_1(A,k1_numbers,k5_numbers)
         => ~ ( r2_hidden(A,k2_finseq_1(f1_s1_finseq_1))
              & ! [B] : ~ p1_s1_finseq_1(A,B) ) ) )
   => ? [A] :
        ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A)
        & k4_finseq_1(A) = k2_finseq_1(f1_s1_finseq_1)
        & ! [B] :
            ( m2_subset_1(B,k1_numbers,k5_numbers)
           => ( r2_hidden(B,k2_finseq_1(f1_s1_finseq_1))
             => p1_s1_finseq_1(B,k1_funct_1(A,B)) ) ) ) ) ).

fof(s2_finseq_1,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v1_funct_1(A)
      & v1_finseq_1(A)
      & k3_finseq_1(A) = f1_s2_finseq_1
      & ! [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
         => ( r2_hidden(B,k2_finseq_1(f1_s2_finseq_1))
           => k1_funct_1(A,B) = f2_s2_finseq_1(B) ) ) ) ).

fof(s3_finseq_1,axiom,
    ( ( p1_s3_finseq_1(k1_xboole_0)
      & ! [A] :
          ( ( v1_relat_1(A)
            & v1_funct_1(A)
            & v1_finseq_1(A) )
         => ! [B] :
              ( p1_s3_finseq_1(A)
             => p1_s3_finseq_1(k7_finseq_1(A,k9_finseq_1(B))) ) ) )
   => ! [A] :
        ( ( v1_relat_1(A)
          & v1_funct_1(A)
          & v1_finseq_1(A) )
       => p1_s3_finseq_1(A) ) ) ).

fof(s4_finseq_1,axiom,
    ? [A] :
    ! [B] :
      ( r2_hidden(B,A)
    <=> ? [C] :
          ( v1_relat_1(C)
          & v1_funct_1(C)
          & v1_finseq_1(C)
          & r2_hidden(C,k13_finseq_1(f1_s4_finseq_1))
          & p1_s4_finseq_1(C)
          & B = C ) ) ).

fof(s5_finseq_1,axiom,
    ( ! [A] :
        ( m2_subset_1(A,k1_numbers,k5_numbers)
       => ~ ( r2_hidden(A,k2_finseq_1(f2_s5_finseq_1))
            & ! [B] :
                ( m1_subset_1(B,f1_s5_finseq_1)
               => ~ p1_s5_finseq_1(A,B) ) ) )
   => ? [A] :
        ( m2_finseq_1(A,f1_s5_finseq_1)
        & k4_finseq_1(A) = k2_finseq_1(f2_s5_finseq_1)
        & ! [B] :
            ( m2_subset_1(B,k1_numbers,k5_numbers)
           => ( r2_hidden(B,k2_finseq_1(f2_s5_finseq_1))
             => p1_s5_finseq_1(B,k1_funct_1(A,B)) ) ) ) ) ).

fof(dt_m1_finseq_1,axiom,
    ! [A,B] :
      ( m1_finseq_1(B,A)
     => ( v1_relat_1(B)
        & v1_funct_1(B)
        & v1_finseq_1(B) ) ) ).

fof(existence_m1_finseq_1,axiom,
    ! [A] :
    ? [B] : m1_finseq_1(B,A) ).

fof(dt_m2_finseq_1,axiom,
    ! [A,B] :
      ( m2_finseq_1(B,A)
     => ( v1_funct_1(B)
        & v1_finseq_1(B)
        & m2_relset_1(B,k5_numbers,A) ) ) ).

fof(existence_m2_finseq_1,axiom,
    ! [A] :
    ? [B] : m2_finseq_1(B,A) ).

fof(redefinition_m2_finseq_1,axiom,
    ! [A,B] :
      ( m2_finseq_1(B,A)
    <=> m1_finseq_1(B,A) ) ).

fof(dt_k1_finseq_1,axiom,
    $true ).

fof(dt_k2_finseq_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => m1_subset_1(k2_finseq_1(A),k1_zfmisc_1(k5_numbers)) ) ).

fof(redefinition_k2_finseq_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => k2_finseq_1(A) = k1_finseq_1(A) ) ).

fof(dt_k3_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => m2_subset_1(k3_finseq_1(A),k1_numbers,k5_numbers) ) ).

fof(redefinition_k3_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => k3_finseq_1(A) = k1_card_1(A) ) ).

fof(dt_k4_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => m1_subset_1(k4_finseq_1(A),k1_zfmisc_1(k5_numbers)) ) ).

fof(redefinition_k4_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => k4_finseq_1(A) = k1_relat_1(A) ) ).

fof(dt_k5_finseq_1,axiom,
    $true ).

fof(dt_k6_finseq_1,axiom,
    ! [A] :
      ( v1_xboole_0(k6_finseq_1(A))
      & m2_finseq_1(k6_finseq_1(A),A) ) ).

fof(dt_k7_finseq_1,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A)
        & v1_relat_1(B)
        & v1_funct_1(B)
        & v1_finseq_1(B) )
     => ( v1_relat_1(k7_finseq_1(A,B))
        & v1_funct_1(k7_finseq_1(A,B))
        & v1_finseq_1(k7_finseq_1(A,B)) ) ) ).

fof(dt_k8_finseq_1,axiom,
    ! [A,B,C] :
      ( ( m1_finseq_1(B,A)
        & m1_finseq_1(C,A) )
     => m2_finseq_1(k8_finseq_1(A,B,C),A) ) ).

fof(redefinition_k8_finseq_1,axiom,
    ! [A,B,C] :
      ( ( m1_finseq_1(B,A)
        & m1_finseq_1(C,A) )
     => k8_finseq_1(A,B,C) = k7_finseq_1(B,C) ) ).

fof(dt_k9_finseq_1,axiom,
    ! [A] :
      ( v1_relat_1(k9_finseq_1(A))
      & v1_funct_1(k9_finseq_1(A)) ) ).

fof(redefinition_k9_finseq_1,axiom,
    ! [A] : k9_finseq_1(A) = k5_finseq_1(A) ).

fof(dt_k10_finseq_1,axiom,
    $true ).

fof(dt_k11_finseq_1,axiom,
    $true ).

fof(dt_k12_finseq_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & m1_subset_1(B,A) )
     => m2_finseq_1(k12_finseq_1(A,B),A) ) ).

fof(redefinition_k12_finseq_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & m1_subset_1(B,A) )
     => k12_finseq_1(A,B) = k5_finseq_1(B) ) ).

fof(dt_k13_finseq_1,axiom,
    $true ).

fof(dt_k14_finseq_1,axiom,
    ! [A] : m2_finseq_1(k14_finseq_1(A),k5_numbers) ).

fof(dt_k15_finseq_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v2_finseq_1(A) )
     => ( v1_relat_1(k15_finseq_1(A))
        & v1_funct_1(k15_finseq_1(A)) ) ) ).

fof(dt_k16_finseq_1,axiom,
    ! [A,B,C] :
      ( ( m1_finseq_1(B,A)
        & v4_ordinal2(C) )
     => m2_finseq_1(k16_finseq_1(A,B,C),A) ) ).

fof(dt_k17_finseq_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => v1_relat_1(k17_finseq_1(A)) ) ).

fof(d1_finseq_1,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => k1_finseq_1(A) = a_1_0_finseq_1(A) ) ).

fof(fraenkel_a_1_0_finseq_1,axiom,
    ! [A,B] :
      ( v4_ordinal2(B)
     => ( r2_hidden(A,a_1_0_finseq_1(B))
      <=> ? [C] :
            ( m2_subset_1(C,k1_numbers,k5_numbers)
            & A = C
            & r1_xreal_0(np__1,C)
            & r1_xreal_0(C,B) ) ) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(fc1_orders_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ~ v1_xboole_0(k1_orders_1(A)) ) ).

fof(d1_orders_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ( ~ r2_hidden(k1_xboole_0,A)
       => ! [B] :
            ( ( v1_funct_1(B)
              & v1_funct_2(B,A,k3_tarski(A))
              & m2_relset_1(B,A,k3_tarski(A)) )
           => ( m1_orders_1(B,A)
            <=> ! [C] :
                  ( r2_hidden(C,A)
                 => r2_hidden(k1_funct_1(B,C),C) ) ) ) ) ) ).

fof(d2_orders_1,axiom,
    ! [A] : k1_orders_1(A) = k4_xboole_0(k1_zfmisc_1(A),k1_tarski(k1_xboole_0)) ).

fof(t1_orders_1,axiom,
    $true ).

fof(t2_orders_1,axiom,
    $true ).

fof(t3_orders_1,axiom,
    $true ).

fof(t4_orders_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ~ r2_hidden(k1_xboole_0,k1_orders_1(A)) ) ).

fof(t5_orders_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ( r1_tarski(A,B)
          <=> r2_hidden(A,k1_orders_1(B)) ) ) ) ).

fof(t6_orders_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ( m1_subset_1(A,k1_zfmisc_1(B))
          <=> r2_hidden(A,k1_orders_1(B)) ) ) ) ).

fof(t7_orders_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => r2_hidden(A,k1_orders_1(A)) ) ).

fof(t8_orders_1,axiom,
    $true ).

fof(t9_orders_1,axiom,
    $true ).

fof(t10_orders_1,axiom,
    $true ).

fof(t11_orders_1,axiom,
    $true ).

fof(t12_orders_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_2(C)
        & v4_relat_2(C)
        & v8_relat_2(C)
        & v1_partfun1(C,A,A)
        & m2_relset_1(C,A,A) )
     => ( r2_hidden(B,A)
       => r2_hidden(k4_tarski(B,B),C) ) ) ).

fof(t13_orders_1,axiom,
    ! [A,B,C,D] :
      ( ( v1_relat_2(D)
        & v4_relat_2(D)
        & v8_relat_2(D)
        & v1_partfun1(D,A,A)
        & m2_relset_1(D,A,A) )
     => ( ( r2_hidden(B,A)
          & r2_hidden(C,A)
          & r2_hidden(k4_tarski(B,C),D)
          & r2_hidden(k4_tarski(C,B),D) )
       => B = C ) ) ).

fof(t14_orders_1,axiom,
    ! [A,B,C,D,E] :
      ( ( v1_relat_2(E)
        & v4_relat_2(E)
        & v8_relat_2(E)
        & v1_partfun1(E,A,A)
        & m2_relset_1(E,A,A) )
     => ( ( r2_hidden(B,A)
          & r2_hidden(C,A)
          & r2_hidden(D,A)
          & r2_hidden(k4_tarski(B,C),E)
          & r2_hidden(k4_tarski(C,D),E) )
       => r2_hidden(k4_tarski(B,D),E) ) ) ).

fof(t15_orders_1,axiom,
    $true ).

fof(t16_orders_1,axiom,
    $true ).

fof(t17_orders_1,axiom,
    $true ).

fof(t18_orders_1,axiom,
    $true ).

fof(t19_orders_1,axiom,
    $true ).

fof(t20_orders_1,axiom,
    $true ).

fof(t21_orders_1,axiom,
    $true ).

fof(t22_orders_1,axiom,
    $true ).

fof(t23_orders_1,axiom,
    $true ).

fof(t24_orders_1,axiom,
    $true ).

fof(t25_orders_1,axiom,
    $true ).

fof(t26_orders_1,axiom,
    $true ).

fof(t27_orders_1,axiom,
    $true ).

fof(t28_orders_1,axiom,
    $true ).

fof(t29_orders_1,axiom,
    $true ).

fof(t30_orders_1,axiom,
    $true ).

fof(t31_orders_1,axiom,
    $true ).

fof(t32_orders_1,axiom,
    $true ).

fof(t33_orders_1,axiom,
    $true ).

fof(t34_orders_1,axiom,
    $true ).

fof(t35_orders_1,axiom,
    $true ).

fof(t36_orders_1,axiom,
    $true ).

fof(t37_orders_1,axiom,
    $true ).

fof(t38_orders_1,axiom,
    $true ).

fof(t39_orders_1,axiom,
    $true ).

fof(t40_orders_1,axiom,
    $true ).

fof(t41_orders_1,axiom,
    $true ).

fof(t42_orders_1,axiom,
    $true ).

fof(t43_orders_1,axiom,
    $true ).

fof(t44_orders_1,axiom,
    $true ).

fof(t45_orders_1,axiom,
    $true ).

fof(t46_orders_1,axiom,
    $true ).

fof(t47_orders_1,axiom,
    $true ).

fof(t48_orders_1,axiom,
    $true ).

fof(t49_orders_1,axiom,
    $true ).

fof(t50_orders_1,axiom,
    $true ).

fof(t51_orders_1,axiom,
    $true ).

fof(t52_orders_1,axiom,
    $true ).

fof(t53_orders_1,axiom,
    $true ).

fof(t54_orders_1,axiom,
    $true ).

fof(t55_orders_1,axiom,
    $true ).

fof(t56_orders_1,axiom,
    $true ).

fof(t57_orders_1,axiom,
    $true ).

fof(t58_orders_1,axiom,
    $true ).

fof(t59_orders_1,axiom,
    $true ).

fof(t60_orders_1,axiom,
    $true ).

fof(t61_orders_1,axiom,
    $true ).

fof(t62_orders_1,axiom,
    $true ).

fof(t63_orders_1,axiom,
    $true ).

fof(t64_orders_1,axiom,
    $true ).

fof(t65_orders_1,axiom,
    $true ).

fof(t66_orders_1,axiom,
    $true ).

fof(t67_orders_1,axiom,
    $true ).

fof(t68_orders_1,axiom,
    $true ).

fof(t69_orders_1,axiom,
    $true ).

fof(t70_orders_1,axiom,
    $true ).

fof(t71_orders_1,axiom,
    $true ).

fof(t72_orders_1,axiom,
    $true ).

fof(t73_orders_1,axiom,
    $true ).

fof(t74_orders_1,axiom,
    $true ).

fof(t75_orders_1,axiom,
    $true ).

fof(t76_orders_1,axiom,
    $true ).

fof(t77_orders_1,axiom,
    $true ).

fof(t78_orders_1,axiom,
    $true ).

fof(t79_orders_1,axiom,
    $true ).

fof(t80_orders_1,axiom,
    $true ).

fof(t81_orders_1,axiom,
    $true ).

fof(t82_orders_1,axiom,
    $true ).

fof(t83_orders_1,axiom,
    $true ).

fof(t84_orders_1,axiom,
    $true ).

fof(t85_orders_1,axiom,
    $true ).

fof(t86_orders_1,axiom,
    $true ).

fof(t87_orders_1,axiom,
    $true ).

fof(t88_orders_1,axiom,
    $true ).

fof(t89_orders_1,axiom,
    $true ).

fof(t90_orders_1,axiom,
    $true ).

fof(t91_orders_1,axiom,
    ! [A] :
      ( ~ ( ? [B] :
              ( B != k1_xboole_0
              & r2_hidden(B,A) )
          & k3_tarski(A) = k1_xboole_0 )
      & ~ ( k3_tarski(A) != k1_xboole_0
          & ! [B] :
              ~ ( B != k1_xboole_0
                & r2_hidden(B,A) ) ) ) ).

fof(t92_orders_1,axiom,
    ! [A,B] :
      ( v1_relat_1(B)
     => ( r7_relat_2(B,A)
      <=> ( r1_relat_2(B,A)
          & r6_relat_2(B,A) ) ) ) ).

fof(t93_orders_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( ( r1_relat_2(C,A)
          & r1_tarski(B,A) )
       => r1_relat_2(C,B) ) ) ).

fof(t94_orders_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( ( r4_relat_2(C,A)
          & r1_tarski(B,A) )
       => r4_relat_2(C,B) ) ) ).

fof(t95_orders_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( ( r8_relat_2(C,A)
          & r1_tarski(B,A) )
       => r8_relat_2(C,B) ) ) ).

fof(t96_orders_1,axiom,
    ! [A,B,C] :
      ( v1_relat_1(C)
     => ( ( r7_relat_2(C,A)
          & r1_tarski(B,A) )
       => r7_relat_2(C,B) ) ) ).

fof(t97_orders_1,axiom,
    ! [A,B] :
      ( ( v1_partfun1(B,A,A)
        & m2_relset_1(B,A,A) )
     => k3_relat_1(B) = A ) ).

fof(t98_orders_1,axiom,
    ! [A,B] :
      ( m2_relset_1(B,A,A)
     => ( r1_relat_2(B,A)
       => ( k4_relset_1(A,A,B) = A
          & k3_relat_1(B) = A ) ) ) ).

fof(t99_orders_1,axiom,
    ! [A,B] :
      ( ( v1_relat_2(B)
        & v4_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m2_relset_1(B,A,A) )
     => ( k4_relset_1(A,A,B) = A
        & k5_relset_1(A,A,B) = A ) ) ).

fof(t100_orders_1,axiom,
    ! [A,B] :
      ( ( v1_relat_2(B)
        & v4_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m2_relset_1(B,A,A) )
     => k3_relat_1(B) = A ) ).

fof(d3_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v1_orders_1(A)
      <=> ( v1_relat_2(A)
          & v8_relat_2(A) ) ) ) ).

fof(d4_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v2_orders_1(A)
      <=> ( v1_relat_2(A)
          & v8_relat_2(A)
          & v4_relat_2(A) ) ) ) ).

fof(d5_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v3_orders_1(A)
      <=> ( v1_relat_2(A)
          & v8_relat_2(A)
          & v4_relat_2(A)
          & v6_relat_2(A) ) ) ) ).

fof(t101_orders_1,axiom,
    $true ).

fof(t102_orders_1,axiom,
    $true ).

fof(t103_orders_1,axiom,
    $true ).

fof(t104_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v1_orders_1(A)
       => v1_orders_1(k4_relat_1(A)) ) ) ).

fof(t105_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v2_orders_1(A)
       => v2_orders_1(k4_relat_1(A)) ) ) ).

fof(t106_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v3_orders_1(A)
       => v3_orders_1(k4_relat_1(A)) ) ) ).

fof(t107_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v2_wellord1(A)
       => ( v1_orders_1(A)
          & v2_orders_1(A)
          & v3_orders_1(A) ) ) ) ).

fof(t108_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v3_orders_1(A)
       => ( v1_orders_1(A)
          & v2_orders_1(A) ) ) ) ).

fof(t109_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v2_orders_1(A)
       => v1_orders_1(A) ) ) ).

fof(t110_orders_1,axiom,
    ! [A,B] :
      ( ( v1_relat_2(B)
        & v4_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m2_relset_1(B,A,A) )
     => v2_orders_1(B) ) ).

fof(t111_orders_1,axiom,
    ! [A,B] :
      ( ( v1_relat_2(B)
        & v4_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m2_relset_1(B,A,A) )
     => v1_orders_1(B) ) ).

fof(t112_orders_1,axiom,
    ! [A,B] :
      ( ( v1_relat_2(B)
        & v4_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m2_relset_1(B,A,A) )
     => ( v6_relat_2(B)
       => v3_orders_1(B) ) ) ).

fof(t113_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v1_orders_1(A)
         => v1_orders_1(k2_wellord1(A,B)) ) ) ).

fof(t114_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v2_orders_1(A)
         => v2_orders_1(k2_wellord1(A,B)) ) ) ).

fof(t115_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( v3_orders_1(A)
         => v3_orders_1(k2_wellord1(A,B)) ) ) ).

fof(t116_orders_1,axiom,
    $true ).

fof(t117_orders_1,axiom,
    $true ).

fof(t118_orders_1,axiom,
    $true ).

fof(t119_orders_1,axiom,
    ( v1_orders_1(k1_xboole_0)
    & v2_orders_1(k1_xboole_0)
    & v3_orders_1(k1_xboole_0)
    & v2_wellord1(k1_xboole_0) ) ).

fof(t120_orders_1,axiom,
    ! [A] :
      ( v1_orders_1(k6_partfun1(A))
      & v2_orders_1(k6_partfun1(A)) ) ).

fof(d6_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r1_orders_1(A,B)
        <=> ( r1_relat_2(A,B)
            & r8_relat_2(A,B) ) ) ) ).

fof(d7_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r2_orders_1(A,B)
        <=> ( r1_relat_2(A,B)
            & r8_relat_2(A,B)
            & r4_relat_2(A,B) ) ) ) ).

fof(d8_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r3_orders_1(A,B)
        <=> ( r1_relat_2(A,B)
            & r8_relat_2(A,B)
            & r4_relat_2(A,B)
            & r6_relat_2(A,B) ) ) ) ).

fof(t121_orders_1,axiom,
    $true ).

fof(t122_orders_1,axiom,
    $true ).

fof(t123_orders_1,axiom,
    $true ).

fof(t124_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r2_wellord1(A,B)
         => ( r1_orders_1(A,B)
            & r2_orders_1(A,B)
            & r3_orders_1(A,B) ) ) ) ).

fof(t125_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r3_orders_1(A,B)
         => ( r1_orders_1(A,B)
            & r2_orders_1(A,B) ) ) ) ).

fof(t126_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r2_orders_1(A,B)
         => r1_orders_1(A,B) ) ) ).

fof(t127_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v1_orders_1(A)
       => r1_orders_1(A,k3_relat_1(A)) ) ) ).

fof(t128_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B,C] :
          ( ( r1_orders_1(A,B)
            & r1_tarski(C,B) )
         => r1_orders_1(A,C) ) ) ).

fof(t129_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r1_orders_1(A,B)
         => v1_orders_1(k2_wellord1(A,B)) ) ) ).

fof(t130_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v2_orders_1(A)
       => r2_orders_1(A,k3_relat_1(A)) ) ) ).

fof(t131_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B,C] :
          ( ( r2_orders_1(A,B)
            & r1_tarski(C,B) )
         => r2_orders_1(A,C) ) ) ).

fof(t132_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r2_orders_1(A,B)
         => v2_orders_1(k2_wellord1(A,B)) ) ) ).

fof(t133_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v3_orders_1(A)
       => r3_orders_1(A,k3_relat_1(A)) ) ) ).

fof(t134_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B,C] :
          ( ( r3_orders_1(A,B)
            & r1_tarski(C,B) )
         => r3_orders_1(A,C) ) ) ).

fof(t135_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r3_orders_1(A,B)
         => v3_orders_1(k2_wellord1(A,B)) ) ) ).

fof(t136_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r1_orders_1(A,B)
         => r1_orders_1(k4_relat_1(A),B) ) ) ).

fof(t137_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r2_orders_1(A,B)
         => r2_orders_1(k4_relat_1(A),B) ) ) ).

fof(t138_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r3_orders_1(A,B)
         => r3_orders_1(k4_relat_1(A),B) ) ) ).

fof(t139_orders_1,axiom,
    ! [A,B] :
      ( ( v1_relat_2(B)
        & v4_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m2_relset_1(B,A,A) )
     => r1_orders_1(B,A) ) ).

fof(t140_orders_1,axiom,
    ! [A,B] :
      ( ( v1_relat_2(B)
        & v4_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m2_relset_1(B,A,A) )
     => r2_orders_1(B,A) ) ).

fof(t141_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r2_orders_1(A,B)
         => ( v1_relat_2(k2_wellord1(A,B))
            & v4_relat_2(k2_wellord1(A,B))
            & v8_relat_2(k2_wellord1(A,B))
            & v1_partfun1(k2_wellord1(A,B),B,B)
            & m2_relset_1(k2_wellord1(A,B),B,B) ) ) ) ).

fof(t142_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r3_orders_1(A,B)
         => ( v1_relat_2(k2_wellord1(A,B))
            & v4_relat_2(k2_wellord1(A,B))
            & v8_relat_2(k2_wellord1(A,B))
            & v1_partfun1(k2_wellord1(A,B),B,B)
            & m2_relset_1(k2_wellord1(A,B),B,B) ) ) ) ).

fof(t143_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r2_wellord1(A,B)
         => ( v1_relat_2(k2_wellord1(A,B))
            & v4_relat_2(k2_wellord1(A,B))
            & v8_relat_2(k2_wellord1(A,B))
            & v1_partfun1(k2_wellord1(A,B),B,B)
            & m2_relset_1(k2_wellord1(A,B),B,B) ) ) ) ).

fof(t144_orders_1,axiom,
    $true ).

fof(t145_orders_1,axiom,
    $true ).

fof(t146_orders_1,axiom,
    ! [A] :
      ( r1_orders_1(k6_partfun1(A),A)
      & r2_orders_1(k6_partfun1(A),A) ) ).

fof(d9_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r4_orders_1(A,B)
        <=> ! [C] :
              ~ ( r1_tarski(C,B)
                & v3_orders_1(k2_wellord1(A,C))
                & ! [D] :
                    ~ ( r2_hidden(D,B)
                      & ! [E] :
                          ( r2_hidden(E,C)
                         => r2_hidden(k4_tarski(E,D),A) ) ) ) ) ) ).

fof(d10_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r5_orders_1(A,B)
        <=> ! [C] :
              ~ ( r1_tarski(C,B)
                & v3_orders_1(k2_wellord1(A,C))
                & ! [D] :
                    ~ ( r2_hidden(D,B)
                      & ! [E] :
                          ( r2_hidden(E,C)
                         => r2_hidden(k4_tarski(D,E),A) ) ) ) ) ) ).

fof(t147_orders_1,axiom,
    $true ).

fof(t148_orders_1,axiom,
    $true ).

fof(t149_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ~ ( r4_orders_1(A,B)
            & B = k1_xboole_0 ) ) ).

fof(t150_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ~ ( r5_orders_1(A,B)
            & B = k1_xboole_0 ) ) ).

fof(t151_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r4_orders_1(A,B)
        <=> r5_orders_1(k4_relat_1(A),B) ) ) ).

fof(t152_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r4_orders_1(k4_relat_1(A),B)
        <=> r5_orders_1(A,B) ) ) ).

fof(d11_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r6_orders_1(A,B)
        <=> ( r2_hidden(B,k3_relat_1(A))
            & ! [C] :
                ~ ( r2_hidden(C,k3_relat_1(A))
                  & C != B
                  & r2_hidden(k4_tarski(B,C),A) ) ) ) ) ).

fof(d12_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r7_orders_1(A,B)
        <=> ( r2_hidden(B,k3_relat_1(A))
            & ! [C] :
                ~ ( r2_hidden(C,k3_relat_1(A))
                  & C != B
                  & r2_hidden(k4_tarski(C,B),A) ) ) ) ) ).

fof(d13_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r8_orders_1(A,B)
        <=> ( r2_hidden(B,k3_relat_1(A))
            & ! [C] :
                ( r2_hidden(C,k3_relat_1(A))
               => ( C = B
                  | r2_hidden(k4_tarski(C,B),A) ) ) ) ) ) ).

fof(d14_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r9_orders_1(A,B)
        <=> ( r2_hidden(B,k3_relat_1(A))
            & ! [C] :
                ( r2_hidden(C,k3_relat_1(A))
               => ( C = B
                  | r2_hidden(k4_tarski(B,C),A) ) ) ) ) ) ).

fof(t153_orders_1,axiom,
    $true ).

fof(t154_orders_1,axiom,
    $true ).

fof(t155_orders_1,axiom,
    $true ).

fof(t156_orders_1,axiom,
    $true ).

fof(t157_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( ( r9_orders_1(A,B)
            & v4_relat_2(A) )
         => r7_orders_1(A,B) ) ) ).

fof(t158_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( ( r8_orders_1(A,B)
            & v4_relat_2(A) )
         => r6_orders_1(A,B) ) ) ).

fof(t159_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( ( r7_orders_1(A,B)
            & v6_relat_2(A) )
         => r9_orders_1(A,B) ) ) ).

fof(t160_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( ( r6_orders_1(A,B)
            & v6_relat_2(A) )
         => r8_orders_1(A,B) ) ) ).

fof(t161_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B,C] :
          ( ( r2_hidden(B,C)
            & r8_orders_1(A,B)
            & r1_tarski(C,k3_relat_1(A))
            & v1_relat_2(A) )
         => r4_orders_1(A,C) ) ) ).

fof(t162_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B,C] :
          ( ( r2_hidden(B,C)
            & r9_orders_1(A,B)
            & r1_tarski(C,k3_relat_1(A))
            & v1_relat_2(A) )
         => r5_orders_1(A,C) ) ) ).

fof(t163_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r7_orders_1(A,B)
        <=> r6_orders_1(k4_relat_1(A),B) ) ) ).

fof(t164_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r7_orders_1(k4_relat_1(A),B)
        <=> r6_orders_1(A,B) ) ) ).

fof(t165_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r9_orders_1(A,B)
        <=> r8_orders_1(k4_relat_1(A),B) ) ) ).

fof(t166_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r9_orders_1(k4_relat_1(A),B)
        <=> r8_orders_1(A,B) ) ) ).

fof(t167_orders_1,axiom,
    $true ).

fof(t168_orders_1,axiom,
    $true ).

fof(t169_orders_1,axiom,
    $true ).

fof(t170_orders_1,axiom,
    $true ).

fof(t171_orders_1,axiom,
    $true ).

fof(t172_orders_1,axiom,
    $true ).

fof(t173_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ~ ( r2_orders_1(A,B)
            & k3_relat_1(A) = B
            & r4_orders_1(A,B)
            & ! [C] : ~ r6_orders_1(A,C) ) ) ).

fof(t174_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ~ ( r2_orders_1(A,B)
            & k3_relat_1(A) = B
            & r5_orders_1(A,B)
            & ! [C] : ~ r7_orders_1(A,C) ) ) ).

fof(t175_orders_1,axiom,
    ! [A] :
      ~ ( A != k1_xboole_0
        & ! [B] :
            ~ ( r1_tarski(B,A)
              & v6_ordinal1(B)
              & ! [C] :
                  ~ ( r2_hidden(C,A)
                    & ! [D] :
                        ( r2_hidden(D,B)
                       => r1_tarski(D,C) ) ) )
        & ! [B] :
            ~ ( r2_hidden(B,A)
              & ! [C] :
                  ~ ( r2_hidden(C,A)
                    & C != B
                    & r1_tarski(B,C) ) ) ) ).

fof(t176_orders_1,axiom,
    ! [A] :
      ~ ( A != k1_xboole_0
        & ! [B] :
            ~ ( r1_tarski(B,A)
              & v6_ordinal1(B)
              & ! [C] :
                  ~ ( r2_hidden(C,A)
                    & ! [D] :
                        ( r2_hidden(D,B)
                       => r1_tarski(C,D) ) ) )
        & ! [B] :
            ~ ( r2_hidden(B,A)
              & ! [C] :
                  ~ ( r2_hidden(C,A)
                    & C != B
                    & r1_tarski(C,B) ) ) ) ).

fof(t177_orders_1,axiom,
    ! [A] :
      ~ ( A != k1_xboole_0
        & ! [B] :
            ( ( r1_tarski(B,A)
              & v6_ordinal1(B) )
           => ( B = k1_xboole_0
              | r2_hidden(k3_tarski(B),A) ) )
        & ! [B] :
            ~ ( r2_hidden(B,A)
              & ! [C] :
                  ~ ( r2_hidden(C,A)
                    & C != B
                    & r1_tarski(B,C) ) ) ) ).

fof(t178_orders_1,axiom,
    ! [A] :
      ~ ( A != k1_xboole_0
        & ! [B] :
            ( ( r1_tarski(B,A)
              & v6_ordinal1(B) )
           => ( B = k1_xboole_0
              | r2_hidden(k1_setfam_1(B),A) ) )
        & ! [B] :
            ~ ( r2_hidden(B,A)
              & ! [C] :
                  ~ ( r2_hidden(C,A)
                    & C != B
                    & r1_tarski(C,B) ) ) ) ).

fof(t179_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ~ ( r2_orders_1(A,B)
            & k3_relat_1(A) = B
            & ! [C] :
                ( v1_relat_1(C)
               => ~ ( r1_tarski(A,C)
                    & r3_orders_1(C,B)
                    & k3_relat_1(C) = B ) ) ) ) ).

fof(t180_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => r1_tarski(A,k2_zfmisc_1(k3_relat_1(A),k3_relat_1(A))) ) ).

fof(t181_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( ( v1_relat_2(A)
            & r1_tarski(B,k3_relat_1(A)) )
         => k3_relat_1(k2_wellord1(A,B)) = B ) ) ).

fof(t182_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r1_relat_2(A,B)
         => v1_relat_2(k2_wellord1(A,B)) ) ) ).

fof(t183_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r8_relat_2(A,B)
         => v8_relat_2(k2_wellord1(A,B)) ) ) ).

fof(t184_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r4_relat_2(A,B)
         => v4_relat_2(k2_wellord1(A,B)) ) ) ).

fof(t185_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r6_relat_2(A,B)
         => v6_relat_2(k2_wellord1(A,B)) ) ) ).

fof(t186_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B,C] :
          ( ( r6_relat_2(A,B)
            & r1_tarski(C,B) )
         => r6_relat_2(A,C) ) ) ).

fof(t187_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B,C] :
          ( ( r2_wellord1(A,B)
            & r1_tarski(C,B) )
         => r2_wellord1(A,C) ) ) ).

fof(t188_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v6_relat_2(A)
       => v6_relat_2(k4_relat_1(A)) ) ) ).

fof(t189_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r1_relat_2(A,B)
         => r1_relat_2(k4_relat_1(A),B) ) ) ).

fof(t190_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r8_relat_2(A,B)
         => r8_relat_2(k4_relat_1(A),B) ) ) ).

fof(t191_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r4_relat_2(A,B)
         => r4_relat_2(k4_relat_1(A),B) ) ) ).

fof(t192_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] :
          ( r6_relat_2(A,B)
         => r6_relat_2(k4_relat_1(A),B) ) ) ).

fof(t193_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B] : k4_relat_1(k2_wellord1(A,B)) = k2_wellord1(k4_relat_1(A),B) ) ).

fof(t194_orders_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => k2_wellord1(A,k1_xboole_0) = k1_xboole_0 ) ).

fof(t195_orders_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B] :
          ~ ( v1_finset_1(B)
            & r1_tarski(B,k2_relat_1(A))
            & ! [C] :
                ~ ( r1_tarski(C,k1_relat_1(A))
                  & v1_finset_1(C)
                  & k9_relat_1(A,C) = B ) ) ) ).

fof(s1_orders_1,axiom,
    ( ( ! [A] :
          ( m1_subset_1(A,f1_s1_orders_1)
         => p1_s1_orders_1(A,A) )
      & ! [A] :
          ( m1_subset_1(A,f1_s1_orders_1)
         => ! [B] :
              ( m1_subset_1(B,f1_s1_orders_1)
             => ( ( p1_s1_orders_1(A,B)
                  & p1_s1_orders_1(B,A) )
               => A = B ) ) )
      & ! [A] :
          ( m1_subset_1(A,f1_s1_orders_1)
         => ! [B] :
              ( m1_subset_1(B,f1_s1_orders_1)
             => ! [C] :
                  ( m1_subset_1(C,f1_s1_orders_1)
                 => ( ( p1_s1_orders_1(A,B)
                      & p1_s1_orders_1(B,C) )
                   => p1_s1_orders_1(A,C) ) ) ) )
      & ! [A] :
          ~ ( r1_tarski(A,f1_s1_orders_1)
            & ! [B] :
                ( m1_subset_1(B,f1_s1_orders_1)
               => ! [C] :
                    ( m1_subset_1(C,f1_s1_orders_1)
                   => ~ ( r2_hidden(B,A)
                        & r2_hidden(C,A)
                        & ~ p1_s1_orders_1(B,C)
                        & ~ p1_s1_orders_1(C,B) ) ) )
            & ! [B] :
                ( m1_subset_1(B,f1_s1_orders_1)
               => ? [C] :
                    ( m1_subset_1(C,f1_s1_orders_1)
                    & r2_hidden(C,A)
                    & ~ p1_s1_orders_1(C,B) ) ) ) )
   => ? [A] :
        ( m1_subset_1(A,f1_s1_orders_1)
        & ! [B] :
            ( m1_subset_1(B,f1_s1_orders_1)
           => ~ ( A != B
                & p1_s1_orders_1(A,B) ) ) ) ) ).

fof(s2_orders_1,axiom,
    ( ( ! [A] :
          ( m1_subset_1(A,f1_s2_orders_1)
         => p1_s2_orders_1(A,A) )
      & ! [A] :
          ( m1_subset_1(A,f1_s2_orders_1)
         => ! [B] :
              ( m1_subset_1(B,f1_s2_orders_1)
             => ( ( p1_s2_orders_1(A,B)
                  & p1_s2_orders_1(B,A) )
               => A = B ) ) )
      & ! [A] :
          ( m1_subset_1(A,f1_s2_orders_1)
         => ! [B] :
              ( m1_subset_1(B,f1_s2_orders_1)
             => ! [C] :
                  ( m1_subset_1(C,f1_s2_orders_1)
                 => ( ( p1_s2_orders_1(A,B)
                      & p1_s2_orders_1(B,C) )
                   => p1_s2_orders_1(A,C) ) ) ) )
      & ! [A] :
          ~ ( r1_tarski(A,f1_s2_orders_1)
            & ! [B] :
                ( m1_subset_1(B,f1_s2_orders_1)
               => ! [C] :
                    ( m1_subset_1(C,f1_s2_orders_1)
                   => ~ ( r2_hidden(B,A)
                        & r2_hidden(C,A)
                        & ~ p1_s2_orders_1(B,C)
                        & ~ p1_s2_orders_1(C,B) ) ) )
            & ! [B] :
                ( m1_subset_1(B,f1_s2_orders_1)
               => ? [C] :
                    ( m1_subset_1(C,f1_s2_orders_1)
                    & r2_hidden(C,A)
                    & ~ p1_s2_orders_1(B,C) ) ) ) )
   => ? [A] :
        ( m1_subset_1(A,f1_s2_orders_1)
        & ! [B] :
            ( m1_subset_1(B,f1_s2_orders_1)
           => ~ ( A != B
                & p1_s2_orders_1(B,A) ) ) ) ) ).

fof(dt_m1_orders_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m1_orders_1(B,A)
         => ( v1_funct_1(B)
            & v1_funct_2(B,A,k3_tarski(A))
            & m2_relset_1(B,A,k3_tarski(A)) ) ) ) ).

fof(existence_m1_orders_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ? [B] : m1_orders_1(B,A) ) ).

fof(dt_k1_orders_1,axiom,
    $true ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(fc1_eqrel_1,axiom,
    ! [A] :
      ( v1_relat_1(k1_eqrel_1(A))
      & v1_relat_2(k1_eqrel_1(A))
      & v1_partfun1(k1_eqrel_1(A),A,A) ) ).

fof(fc2_eqrel_1,axiom,
    ! [A] :
      ( v1_relat_1(k1_eqrel_1(A))
      & v1_relat_2(k1_eqrel_1(A))
      & v3_relat_2(k1_eqrel_1(A))
      & v8_relat_2(k1_eqrel_1(A))
      & v1_partfun1(k1_eqrel_1(A),A,A) ) ).

fof(cc1_eqrel_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m1_eqrel_1(B,A)
         => ~ v1_xboole_0(B) ) ) ).

fof(cc2_eqrel_1,axiom,
    ! [A,B] :
      ( m1_eqrel_1(B,A)
     => v1_setfam_1(B) ) ).

fof(fc3_eqrel_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & v3_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m1_relset_1(B,A,A) )
     => ~ v1_xboole_0(k7_eqrel_1(A,B)) ) ).

fof(fc4_eqrel_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & v3_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m1_relset_1(B,A,A) )
     => ( ~ v1_xboole_0(k7_eqrel_1(A,B))
        & v1_setfam_1(k7_eqrel_1(A,B)) ) ) ).

fof(d1_eqrel_1,axiom,
    ! [A] : k1_eqrel_1(A) = k2_zfmisc_1(A,A) ).

fof(t1_eqrel_1,axiom,
    $true ).

fof(t2_eqrel_1,axiom,
    $true ).

fof(t3_eqrel_1,axiom,
    $true ).

fof(t4_eqrel_1,axiom,
    ! [A] :
      ( r1_relat_2(k6_partfun1(A),A)
      & r3_relat_2(k6_partfun1(A),A)
      & r8_relat_2(k6_partfun1(A),A) ) ).

fof(t5_eqrel_1,axiom,
    $true ).

fof(t6_eqrel_1,axiom,
    ! [A] :
      ( v3_relat_2(k6_partfun1(A))
      & v8_relat_2(k6_partfun1(A))
      & v1_partfun1(k6_partfun1(A),A,A)
      & m2_relset_1(k6_partfun1(A),A,A) ) ).

fof(t7_eqrel_1,axiom,
    ! [A] :
      ( v3_relat_2(k1_eqrel_1(A))
      & v8_relat_2(k1_eqrel_1(A))
      & v1_partfun1(k1_eqrel_1(A),A,A)
      & m2_relset_1(k1_eqrel_1(A),A,A) ) ).

fof(t8_eqrel_1,axiom,
    $true ).

fof(t9_eqrel_1,axiom,
    $true ).

fof(t10_eqrel_1,axiom,
    $true ).

fof(t11_eqrel_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_2(C)
        & v1_partfun1(C,A,A)
        & m2_relset_1(C,A,A) )
     => ( r2_hidden(B,A)
       => r2_hidden(k4_tarski(B,B),C) ) ) ).

fof(t12_eqrel_1,axiom,
    ! [A,B,C,D] :
      ( ( v3_relat_2(D)
        & v1_partfun1(D,A,A)
        & m2_relset_1(D,A,A) )
     => ( r2_hidden(k4_tarski(B,C),D)
       => r2_hidden(k4_tarski(C,B),D) ) ) ).

fof(t13_eqrel_1,axiom,
    ! [A,B,C,D,E] :
      ( ( v8_relat_2(E)
        & v1_partfun1(E,A,A)
        & m2_relset_1(E,A,A) )
     => ( ( r2_hidden(k4_tarski(B,C),E)
          & r2_hidden(k4_tarski(C,D),E) )
       => r2_hidden(k4_tarski(B,D),E) ) ) ).

fof(t14_eqrel_1,axiom,
    ! [A,B] :
      ( ( v1_relat_2(B)
        & v1_partfun1(B,A,A)
        & m2_relset_1(B,A,A) )
     => ~ ( ? [C] : r2_hidden(C,A)
          & B = k1_xboole_0 ) ) ).

fof(t15_eqrel_1,axiom,
    $true ).

fof(t16_eqrel_1,axiom,
    ! [A,B] :
      ( m2_relset_1(B,A,A)
     => ( ( v3_relat_2(B)
          & v8_relat_2(B)
          & v1_partfun1(B,A,A)
          & m2_relset_1(B,A,A) )
      <=> ( v1_relat_2(B)
          & v3_relat_2(B)
          & v8_relat_2(B)
          & k3_relat_1(B) = A ) ) ) ).

fof(t17_eqrel_1,axiom,
    ! [A,B] :
      ( ( v3_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m2_relset_1(B,A,A) )
     => k4_eqrel_1(A,k6_partfun1(A),B) = k6_partfun1(A) ) ).

fof(t18_eqrel_1,axiom,
    ! [A,B] :
      ( m2_relset_1(B,A,A)
     => k2_eqrel_1(A,k1_eqrel_1(A),B) = B ) ).

fof(t19_eqrel_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(k2_zfmisc_1(A,A))))
     => ( ! [C] :
            ( r2_hidden(C,B)
           => ( v3_relat_2(C)
              & v8_relat_2(C)
              & v1_partfun1(C,A,A)
              & m2_relset_1(C,A,A) ) )
       => ( B = k1_xboole_0
          | ( v3_relat_2(k6_setfam_1(k2_zfmisc_1(A,A),B))
            & v8_relat_2(k6_setfam_1(k2_zfmisc_1(A,A),B))
            & v1_partfun1(k6_setfam_1(k2_zfmisc_1(A,A),B),A,A)
            & m2_relset_1(k6_setfam_1(k2_zfmisc_1(A,A),B),A,A) ) ) ) ) ).

fof(t20_eqrel_1,axiom,
    ! [A,B] :
      ( m2_relset_1(B,A,A)
     => ? [C] :
          ( v3_relat_2(C)
          & v8_relat_2(C)
          & v1_partfun1(C,A,A)
          & m2_relset_1(C,A,A)
          & r1_tarski(B,C)
          & ! [D] :
              ( ( v3_relat_2(D)
                & v8_relat_2(D)
                & v1_partfun1(D,A,A)
                & m2_relset_1(D,A,A) )
             => ( r1_tarski(B,D)
               => r1_tarski(C,D) ) ) ) ) ).

fof(d2_eqrel_1,axiom,
    $true ).

fof(d3_eqrel_1,axiom,
    ! [A,B] :
      ( ( v3_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m2_relset_1(B,A,A) )
     => ! [C] :
          ( ( v3_relat_2(C)
            & v8_relat_2(C)
            & v1_partfun1(C,A,A)
            & m2_relset_1(C,A,A) )
         => ! [D] :
              ( ( v3_relat_2(D)
                & v8_relat_2(D)
                & v1_partfun1(D,A,A)
                & m2_relset_1(D,A,A) )
             => ( D = k5_eqrel_1(A,B,C)
              <=> ( r1_tarski(k3_eqrel_1(A,B,C),D)
                  & ! [E] :
                      ( ( v3_relat_2(E)
                        & v8_relat_2(E)
                        & v1_partfun1(E,A,A)
                        & m2_relset_1(E,A,A) )
                     => ( r1_tarski(k3_eqrel_1(A,B,C),E)
                       => r1_tarski(D,E) ) ) ) ) ) ) ) ).

fof(t21_eqrel_1,axiom,
    $true ).

fof(t22_eqrel_1,axiom,
    ! [A,B] :
      ( ( v3_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m2_relset_1(B,A,A) )
     => k5_eqrel_1(A,B,B) = B ) ).

fof(t23_eqrel_1,axiom,
    ! [A,B] :
      ( ( v3_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m2_relset_1(B,A,A) )
     => ! [C] :
          ( ( v3_relat_2(C)
            & v8_relat_2(C)
            & v1_partfun1(C,A,A)
            & m2_relset_1(C,A,A) )
         => k5_eqrel_1(A,B,C) = k5_eqrel_1(A,C,B) ) ) ).

fof(t24_eqrel_1,axiom,
    ! [A,B] :
      ( ( v3_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m2_relset_1(B,A,A) )
     => ! [C] :
          ( ( v3_relat_2(C)
            & v8_relat_2(C)
            & v1_partfun1(C,A,A)
            & m2_relset_1(C,A,A) )
         => k4_eqrel_1(A,B,k5_eqrel_1(A,B,C)) = B ) ) ).

fof(t25_eqrel_1,axiom,
    ! [A,B] :
      ( ( v3_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m2_relset_1(B,A,A) )
     => ! [C] :
          ( ( v3_relat_2(C)
            & v8_relat_2(C)
            & v1_partfun1(C,A,A)
            & m2_relset_1(C,A,A) )
         => k5_eqrel_1(A,B,k4_eqrel_1(A,B,C)) = B ) ) ).

fof(d4_eqrel_1,axiom,
    ! [A,B] :
      ( ( v1_relat_2(B)
        & v3_relat_2(B)
        & v1_partfun1(B,A,A)
        & m2_relset_1(B,A,A) )
     => ! [C] : k6_eqrel_1(A,B,C) = k10_relset_1(A,A,B,k1_tarski(C)) ) ).

fof(t26_eqrel_1,axiom,
    $true ).

fof(t27_eqrel_1,axiom,
    ! [A,B,C,D] :
      ( ( v1_relat_2(D)
        & v3_relat_2(D)
        & v1_partfun1(D,A,A)
        & m2_relset_1(D,A,A) )
     => ( r2_hidden(B,k6_eqrel_1(A,D,C))
      <=> r2_hidden(k4_tarski(B,C),D) ) ) ).

fof(t28_eqrel_1,axiom,
    ! [A,B] :
      ( ( v1_relat_2(B)
        & v3_relat_2(B)
        & v1_partfun1(B,A,A)
        & m2_relset_1(B,A,A) )
     => ! [C] :
          ( r2_hidden(C,A)
         => r2_hidden(C,k6_eqrel_1(A,B,C)) ) ) ).

fof(t29_eqrel_1,axiom,
    ! [A,B] :
      ( ( v1_relat_2(B)
        & v3_relat_2(B)
        & v1_partfun1(B,A,A)
        & m2_relset_1(B,A,A) )
     => ! [C] :
          ~ ( r2_hidden(C,A)
            & ! [D] : ~ r2_hidden(C,k6_eqrel_1(A,B,D)) ) ) ).

fof(t30_eqrel_1,axiom,
    ! [A,B,C,D,E] :
      ( ( v1_relat_2(E)
        & v3_relat_2(E)
        & v8_relat_2(E)
        & v1_partfun1(E,A,A)
        & m2_relset_1(E,A,A) )
     => ( ( r2_hidden(B,k6_eqrel_1(A,E,C))
          & r2_hidden(D,k6_eqrel_1(A,E,C)) )
       => r2_hidden(k4_tarski(B,D),E) ) ) ).

fof(t31_eqrel_1,axiom,
    ! [A,B,C] :
      ( ( v3_relat_2(C)
        & v8_relat_2(C)
        & v1_partfun1(C,A,A)
        & m2_relset_1(C,A,A) )
     => ! [D] :
          ( r2_hidden(D,A)
         => ( r2_hidden(B,k6_eqrel_1(A,C,D))
          <=> k6_eqrel_1(A,C,D) = k6_eqrel_1(A,C,B) ) ) ) ).

fof(t32_eqrel_1,axiom,
    ! [A,B] :
      ( ( v3_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m2_relset_1(B,A,A) )
     => ! [C,D] :
          ~ ( r2_hidden(C,A)
            & r2_hidden(D,A)
            & k6_eqrel_1(A,B,C) != k6_eqrel_1(A,B,D)
            & ~ r1_xboole_0(k6_eqrel_1(A,B,C),k6_eqrel_1(A,B,D)) ) ) ).

fof(t33_eqrel_1,axiom,
    ! [A,B] :
      ( r2_hidden(B,A)
     => k6_eqrel_1(A,k6_partfun1(A),B) = k1_tarski(B) ) ).

fof(t34_eqrel_1,axiom,
    ! [A,B] :
      ( r2_hidden(B,A)
     => k6_eqrel_1(A,k1_eqrel_1(A),B) = A ) ).

fof(t35_eqrel_1,axiom,
    ! [A,B] :
      ( ( v3_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m2_relset_1(B,A,A) )
     => ( ? [C] : k6_eqrel_1(A,B,C) = A
       => B = k1_eqrel_1(A) ) ) ).

fof(t36_eqrel_1,axiom,
    ! [A,B,C,D] :
      ( ( v3_relat_2(D)
        & v8_relat_2(D)
        & v1_partfun1(D,B,B)
        & m2_relset_1(D,B,B) )
     => ! [E] :
          ( ( v3_relat_2(E)
            & v8_relat_2(E)
            & v1_partfun1(E,B,B)
            & m2_relset_1(E,B,B) )
         => ( r2_hidden(A,B)
           => ( r2_hidden(k4_tarski(A,C),k5_eqrel_1(B,D,E))
            <=> ? [F] :
                  ( v1_relat_1(F)
                  & v1_funct_1(F)
                  & v1_finseq_1(F)
                  & r1_xreal_0(np__1,k3_finseq_1(F))
                  & A = k1_funct_1(F,np__1)
                  & C = k1_funct_1(F,k3_finseq_1(F))
                  & ! [G] :
                      ( m2_subset_1(G,k1_numbers,k5_numbers)
                     => ( r1_xreal_0(np__1,G)
                       => ( r1_xreal_0(k3_finseq_1(F),G)
                          | r2_hidden(k4_tarski(k1_funct_1(F,G),k1_funct_1(F,k1_nat_1(G,np__1))),k3_eqrel_1(B,D,E)) ) ) ) ) ) ) ) ) ).

fof(t37_eqrel_1,axiom,
    ! [A,B] :
      ( ( v3_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m2_relset_1(B,A,A) )
     => ! [C] :
          ( ( v3_relat_2(C)
            & v8_relat_2(C)
            & v1_partfun1(C,A,A)
            & m2_relset_1(C,A,A) )
         => ! [D] :
              ( ( v3_relat_2(D)
                & v8_relat_2(D)
                & v1_partfun1(D,A,A)
                & m2_relset_1(D,A,A) )
             => ( D = k3_eqrel_1(A,B,C)
               => ! [E] :
                    ~ ( r2_hidden(E,A)
                      & k6_eqrel_1(A,D,E) != k6_eqrel_1(A,B,E)
                      & k6_eqrel_1(A,D,E) != k6_eqrel_1(A,C,E) ) ) ) ) ) ).

fof(t38_eqrel_1,axiom,
    ! [A,B] :
      ( ( v3_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m2_relset_1(B,A,A) )
     => ! [C] :
          ( ( v3_relat_2(C)
            & v8_relat_2(C)
            & v1_partfun1(C,A,A)
            & m2_relset_1(C,A,A) )
         => ~ ( k3_eqrel_1(A,B,C) = k1_eqrel_1(A)
              & B != k1_eqrel_1(A)
              & C != k1_eqrel_1(A) ) ) ) ).

fof(d5_eqrel_1,axiom,
    ! [A,B] :
      ( ( v3_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m2_relset_1(B,A,A) )
     => ! [C] :
          ( m1_subset_1(C,k1_zfmisc_1(k1_zfmisc_1(A)))
         => ( C = k7_eqrel_1(A,B)
          <=> ! [D] :
                ( m1_subset_1(D,k1_zfmisc_1(A))
               => ( r2_hidden(D,C)
                <=> ? [E] :
                      ( r2_hidden(E,A)
                      & D = k6_eqrel_1(A,B,E) ) ) ) ) ) ) ).

fof(t39_eqrel_1,axiom,
    $true ).

fof(t40_eqrel_1,axiom,
    ! [A,B] :
      ( ( v3_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m2_relset_1(B,A,A) )
     => ( A = k1_xboole_0
       => k7_eqrel_1(A,B) = k1_xboole_0 ) ) ).

fof(d6_eqrel_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(A)))
     => ( ( A != k1_xboole_0
         => ( m1_eqrel_1(B,A)
          <=> ( k5_setfam_1(A,B) = A
              & ! [C] :
                  ( m1_subset_1(C,k1_zfmisc_1(A))
                 => ( r2_hidden(C,B)
                   => ( C != k1_xboole_0
                      & ! [D] :
                          ( m1_subset_1(D,k1_zfmisc_1(A))
                         => ~ ( r2_hidden(D,B)
                              & C != D
                              & ~ r1_xboole_0(C,D) ) ) ) ) ) ) ) )
        & ( A = k1_xboole_0
         => ( m1_eqrel_1(B,A)
          <=> B = k1_xboole_0 ) ) ) ) ).

fof(t41_eqrel_1,axiom,
    $true ).

fof(t42_eqrel_1,axiom,
    ! [A,B] :
      ( ( v3_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m2_relset_1(B,A,A) )
     => m1_eqrel_1(k7_eqrel_1(A,B),A) ) ).

fof(t43_eqrel_1,axiom,
    ! [A,B] :
      ( m1_eqrel_1(B,A)
     => ? [C] :
          ( v3_relat_2(C)
          & v8_relat_2(C)
          & v1_partfun1(C,A,A)
          & m2_relset_1(C,A,A)
          & B = k7_eqrel_1(A,C) ) ) ).

fof(t44_eqrel_1,axiom,
    ! [A,B,C] :
      ( ( v3_relat_2(C)
        & v8_relat_2(C)
        & v1_partfun1(C,A,A)
        & m2_relset_1(C,A,A) )
     => ! [D] :
          ( r2_hidden(D,A)
         => ( r2_hidden(k4_tarski(D,B),C)
          <=> k6_eqrel_1(A,C,D) = k6_eqrel_1(A,C,B) ) ) ) ).

fof(t45_eqrel_1,axiom,
    ! [A,B,C] :
      ( ( v3_relat_2(C)
        & v8_relat_2(C)
        & v1_partfun1(C,B,B)
        & m2_relset_1(C,B,B) )
     => ~ ( r2_hidden(A,k7_eqrel_1(B,C))
          & ! [D] :
              ( m1_subset_1(D,B)
             => A != k6_eqrel_1(B,C,D) ) ) ) ).

fof(s1_eqrel_1,axiom,
    ( ( ! [A] :
          ( r2_hidden(A,f1_s1_eqrel_1)
         => p1_s1_eqrel_1(A,A) )
      & ! [A,B] :
          ( p1_s1_eqrel_1(A,B)
         => p1_s1_eqrel_1(B,A) )
      & ! [A,B,C] :
          ( ( p1_s1_eqrel_1(A,B)
            & p1_s1_eqrel_1(B,C) )
         => p1_s1_eqrel_1(A,C) ) )
   => ? [A] :
        ( v3_relat_2(A)
        & v8_relat_2(A)
        & v1_partfun1(A,f1_s1_eqrel_1,f1_s1_eqrel_1)
        & m2_relset_1(A,f1_s1_eqrel_1,f1_s1_eqrel_1)
        & ! [B,C] :
            ( r2_hidden(k4_tarski(B,C),A)
          <=> ( r2_hidden(B,f1_s1_eqrel_1)
              & r2_hidden(C,f1_s1_eqrel_1)
              & p1_s1_eqrel_1(B,C) ) ) ) ) ).

fof(dt_m1_eqrel_1,axiom,
    ! [A,B] :
      ( m1_eqrel_1(B,A)
     => m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(A))) ) ).

fof(existence_m1_eqrel_1,axiom,
    ! [A] :
    ? [B] : m1_eqrel_1(B,A) ).

fof(dt_k1_eqrel_1,axiom,
    ! [A] : m2_relset_1(k1_eqrel_1(A),A,A) ).

fof(dt_k2_eqrel_1,axiom,
    ! [A,B,C] :
      ( ( m1_relset_1(B,A,A)
        & m1_relset_1(C,A,A) )
     => m2_relset_1(k2_eqrel_1(A,B,C),A,A) ) ).

fof(commutativity_k2_eqrel_1,axiom,
    ! [A,B,C] :
      ( ( m1_relset_1(B,A,A)
        & m1_relset_1(C,A,A) )
     => k2_eqrel_1(A,B,C) = k2_eqrel_1(A,C,B) ) ).

fof(idempotence_k2_eqrel_1,axiom,
    ! [A,B,C] :
      ( ( m1_relset_1(B,A,A)
        & m1_relset_1(C,A,A) )
     => k2_eqrel_1(A,B,B) = B ) ).

fof(redefinition_k2_eqrel_1,axiom,
    ! [A,B,C] :
      ( ( m1_relset_1(B,A,A)
        & m1_relset_1(C,A,A) )
     => k2_eqrel_1(A,B,C) = k3_xboole_0(B,C) ) ).

fof(dt_k3_eqrel_1,axiom,
    ! [A,B,C] :
      ( ( m1_relset_1(B,A,A)
        & m1_relset_1(C,A,A) )
     => m2_relset_1(k3_eqrel_1(A,B,C),A,A) ) ).

fof(commutativity_k3_eqrel_1,axiom,
    ! [A,B,C] :
      ( ( m1_relset_1(B,A,A)
        & m1_relset_1(C,A,A) )
     => k3_eqrel_1(A,B,C) = k3_eqrel_1(A,C,B) ) ).

fof(idempotence_k3_eqrel_1,axiom,
    ! [A,B,C] :
      ( ( m1_relset_1(B,A,A)
        & m1_relset_1(C,A,A) )
     => k3_eqrel_1(A,B,B) = B ) ).

fof(redefinition_k3_eqrel_1,axiom,
    ! [A,B,C] :
      ( ( m1_relset_1(B,A,A)
        & m1_relset_1(C,A,A) )
     => k3_eqrel_1(A,B,C) = k2_xboole_0(B,C) ) ).

fof(dt_k4_eqrel_1,axiom,
    ! [A,B,C] :
      ( ( v3_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m1_relset_1(B,A,A)
        & v3_relat_2(C)
        & v8_relat_2(C)
        & v1_partfun1(C,A,A)
        & m1_relset_1(C,A,A) )
     => ( v3_relat_2(k4_eqrel_1(A,B,C))
        & v8_relat_2(k4_eqrel_1(A,B,C))
        & v1_partfun1(k4_eqrel_1(A,B,C),A,A)
        & m2_relset_1(k4_eqrel_1(A,B,C),A,A) ) ) ).

fof(commutativity_k4_eqrel_1,axiom,
    ! [A,B,C] :
      ( ( v3_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m1_relset_1(B,A,A)
        & v3_relat_2(C)
        & v8_relat_2(C)
        & v1_partfun1(C,A,A)
        & m1_relset_1(C,A,A) )
     => k4_eqrel_1(A,B,C) = k4_eqrel_1(A,C,B) ) ).

fof(idempotence_k4_eqrel_1,axiom,
    ! [A,B,C] :
      ( ( v3_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m1_relset_1(B,A,A)
        & v3_relat_2(C)
        & v8_relat_2(C)
        & v1_partfun1(C,A,A)
        & m1_relset_1(C,A,A) )
     => k4_eqrel_1(A,B,B) = B ) ).

fof(redefinition_k4_eqrel_1,axiom,
    ! [A,B,C] :
      ( ( v3_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m1_relset_1(B,A,A)
        & v3_relat_2(C)
        & v8_relat_2(C)
        & v1_partfun1(C,A,A)
        & m1_relset_1(C,A,A) )
     => k4_eqrel_1(A,B,C) = k3_xboole_0(B,C) ) ).

fof(dt_k5_eqrel_1,axiom,
    ! [A,B,C] :
      ( ( v3_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m1_relset_1(B,A,A)
        & v3_relat_2(C)
        & v8_relat_2(C)
        & v1_partfun1(C,A,A)
        & m1_relset_1(C,A,A) )
     => ( v3_relat_2(k5_eqrel_1(A,B,C))
        & v8_relat_2(k5_eqrel_1(A,B,C))
        & v1_partfun1(k5_eqrel_1(A,B,C),A,A)
        & m2_relset_1(k5_eqrel_1(A,B,C),A,A) ) ) ).

fof(commutativity_k5_eqrel_1,axiom,
    ! [A,B,C] :
      ( ( v3_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m1_relset_1(B,A,A)
        & v3_relat_2(C)
        & v8_relat_2(C)
        & v1_partfun1(C,A,A)
        & m1_relset_1(C,A,A) )
     => k5_eqrel_1(A,B,C) = k5_eqrel_1(A,C,B) ) ).

fof(idempotence_k5_eqrel_1,axiom,
    ! [A,B,C] :
      ( ( v3_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m1_relset_1(B,A,A)
        & v3_relat_2(C)
        & v8_relat_2(C)
        & v1_partfun1(C,A,A)
        & m1_relset_1(C,A,A) )
     => k5_eqrel_1(A,B,B) = B ) ).

fof(dt_k6_eqrel_1,axiom,
    ! [A,B,C] :
      ( ( v1_relat_2(B)
        & v3_relat_2(B)
        & v1_partfun1(B,A,A)
        & m1_relset_1(B,A,A) )
     => m1_subset_1(k6_eqrel_1(A,B,C),k1_zfmisc_1(A)) ) ).

fof(dt_k7_eqrel_1,axiom,
    ! [A,B] :
      ( ( v3_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m1_relset_1(B,A,A) )
     => m1_subset_1(k7_eqrel_1(A,B),k1_zfmisc_1(k1_zfmisc_1(A))) ) ).

fof(dt_k8_eqrel_1,axiom,
    ! [A,B] :
      ( ( v3_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m1_relset_1(B,A,A) )
     => m1_eqrel_1(k8_eqrel_1(A,B),A) ) ).

fof(redefinition_k8_eqrel_1,axiom,
    ! [A,B] :
      ( ( v3_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m1_relset_1(B,A,A) )
     => k8_eqrel_1(A,B) = k7_eqrel_1(A,B) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(rc1_finseq_2,axiom,
    ! [A] :
    ? [B] :
      ( m1_finseq_2(B,A)
      & ~ v1_xboole_0(B) ) ).

fof(fc1_finseq_2,axiom,
    ! [A,B] :
      ( ( v4_ordinal2(A)
        & ~ v1_xboole_0(B) )
     => ~ v1_xboole_0(k4_finseq_2(A,B)) ) ).

fof(t1_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
         => ( m2_subset_1(k3_square_1(A,B),k1_numbers,k5_numbers)
            & m2_subset_1(k4_square_1(A,B),k1_numbers,k5_numbers) ) ) ) ).

fof(t2_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
         => ! [C] :
              ( m2_subset_1(C,k1_numbers,k5_numbers)
             => ( A = k3_square_1(B,C)
               => k5_subset_1(k5_numbers,k2_finseq_1(B),k2_finseq_1(C)) = k2_finseq_1(A) ) ) ) ) ).

fof(t3_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
         => ( r1_xreal_0(A,B)
           => k2_square_1(np__0,k6_xcmplx_0(A,B)) = np__0 ) ) ) ).

fof(t4_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
         => ( r1_xreal_0(A,B)
           => k2_square_1(np__0,k6_xcmplx_0(B,A)) = k6_xcmplx_0(B,A) ) ) ) ).

fof(t5_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
         => m2_subset_1(k2_square_1(np__0,k6_xcmplx_0(A,B)),k1_numbers,k5_numbers) ) ) ).

fof(t6_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ( k3_square_1(np__0,A) = np__0
        & k3_square_1(A,np__0) = np__0
        & k4_square_1(np__0,A) = A
        & k4_square_1(A,np__0) = A ) ) ).

fof(t7_finseq_2,axiom,
    $true ).

fof(t8_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
         => ~ ( r2_hidden(A,k2_finseq_1(k1_nat_1(B,np__1)))
              & ~ r2_hidden(A,k2_finseq_1(B))
              & A != k1_nat_1(B,np__1) ) ) ) ).

fof(t9_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
         => ! [C] :
              ( m2_subset_1(C,k1_numbers,k5_numbers)
             => ( r2_hidden(A,k2_finseq_1(B))
               => r2_hidden(A,k2_finseq_1(k1_nat_1(B,C))) ) ) ) ) ).

fof(t10_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C)
                & v1_finseq_1(C) )
             => ( ( k3_finseq_1(B) = A
                  & k3_finseq_1(C) = A
                  & ! [D] :
                      ( m2_subset_1(D,k1_numbers,k5_numbers)
                     => ( r2_hidden(D,k2_finseq_1(A))
                       => k1_funct_1(B,D) = k1_funct_1(C,D) ) ) )
               => B = C ) ) ) ) ).

fof(t11_finseq_2,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B)
        & v1_finseq_1(B) )
     => ~ ( r2_hidden(A,k2_relat_1(B))
          & ! [C] :
              ( m2_subset_1(C,k1_numbers,k5_numbers)
             => ~ ( r2_hidden(C,k4_finseq_1(B))
                  & k1_funct_1(B,C) = A ) ) ) ) ).

fof(t12_finseq_2,axiom,
    $true ).

fof(t13_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B,C] :
          ( m2_finseq_1(C,B)
         => ( r2_hidden(A,k4_finseq_1(C))
           => r2_hidden(k1_funct_1(C,A),B) ) ) ) ).

fof(t14_finseq_2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ! [B] :
          ( ! [C] :
              ( m2_subset_1(C,k1_numbers,k5_numbers)
             => ( r2_hidden(C,k4_finseq_1(A))
               => r2_hidden(k1_funct_1(A,C),B) ) )
         => m2_finseq_1(A,B) ) ) ).

fof(t15_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m1_subset_1(B,A)
         => ! [C] :
              ( m1_subset_1(C,A)
             => m2_finseq_1(k10_finseq_1(B,C),A) ) ) ) ).

fof(t16_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m1_subset_1(B,A)
         => ! [C] :
              ( m1_subset_1(C,A)
             => ! [D] :
                  ( m1_subset_1(D,A)
                 => m2_finseq_1(k11_finseq_1(B,C,D),A) ) ) ) ) ).

fof(t17_finseq_2,axiom,
    $true ).

fof(t18_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C)
                & v1_finseq_1(C) )
             => ( r2_hidden(A,k4_finseq_1(B))
               => r2_hidden(A,k4_finseq_1(k7_finseq_1(B,C))) ) ) ) ) ).

fof(t19_finseq_2,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B)
        & v1_finseq_1(B) )
     => k3_finseq_1(k7_finseq_1(B,k9_finseq_1(A))) = k1_nat_1(k3_finseq_1(B),np__1) ) ).

fof(t20_finseq_2,axiom,
    ! [A,B,C] :
      ( ( v1_relat_1(C)
        & v1_funct_1(C)
        & v1_finseq_1(C) )
     => ! [D] :
          ( ( v1_relat_1(D)
            & v1_funct_1(D)
            & v1_finseq_1(D) )
         => ( k7_finseq_1(C,k9_finseq_1(A)) = k7_finseq_1(D,k9_finseq_1(B))
           => ( C = D
              & A = B ) ) ) ) ).

fof(t21_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => ~ ( k3_finseq_1(B) = k1_nat_1(A,np__1)
              & ! [C] :
                  ( ( v1_relat_1(C)
                    & v1_funct_1(C)
                    & v1_finseq_1(C) )
                 => ! [D] : B != k7_finseq_1(C,k9_finseq_1(D)) ) ) ) ) ).

fof(t22_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m2_finseq_1(B,A)
         => ~ ( k3_finseq_1(B) != np__0
              & ! [C] :
                  ( m2_finseq_1(C,A)
                 => ! [D] :
                      ( m1_subset_1(D,A)
                     => B != k8_finseq_1(A,C,k12_finseq_1(A,D)) ) ) ) ) ) ).

fof(t23_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C)
                & v1_finseq_1(C) )
             => ( ( B = k7_relat_1(C,k2_finseq_1(A))
                  & r1_xreal_0(k3_finseq_1(C),A) )
               => C = B ) ) ) ) ).

fof(t24_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C)
                & v1_finseq_1(C) )
             => ( B = k7_relat_1(C,k2_finseq_1(A))
               => k3_finseq_1(B) = k3_square_1(A,k3_finseq_1(C)) ) ) ) ) ).

fof(t25_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C)
                & v1_finseq_1(C) )
             => ~ ( k3_finseq_1(C) = k1_nat_1(A,B)
                  & ! [D] :
                      ( ( v1_relat_1(D)
                        & v1_funct_1(D)
                        & v1_finseq_1(D) )
                     => ! [E] :
                          ( ( v1_relat_1(E)
                            & v1_funct_1(E)
                            & v1_finseq_1(E) )
                         => ~ ( k3_finseq_1(D) = A
                              & k3_finseq_1(E) = B
                              & C = k7_finseq_1(D,E) ) ) ) ) ) ) ) ).

fof(t26_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( m2_finseq_1(D,C)
                 => ~ ( k3_finseq_1(D) = k1_nat_1(A,B)
                      & ! [E] :
                          ( m2_finseq_1(E,C)
                         => ! [F] :
                              ( m2_finseq_1(F,C)
                             => ~ ( k3_finseq_1(E) = A
                                  & k3_finseq_1(F) = B
                                  & D = k8_finseq_1(C,E,F) ) ) ) ) ) ) ) ) ).

fof(t27_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( ~ v1_xboole_0(B)
            & m1_subset_1(B,k1_zfmisc_1(A)) )
         => ! [C] :
              ( m2_finseq_1(C,B)
             => m2_finseq_1(C,A) ) ) ) ).

fof(t28_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_finseq_1(A),B)
                & m2_relset_1(C,k2_finseq_1(A),B) )
             => m2_finseq_1(C,B) ) ) ) ).

fof(t29_finseq_2,axiom,
    $true ).

fof(t30_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m2_finseq_1(B,A)
         => ( v1_funct_1(B)
            & v1_funct_2(B,k4_finseq_1(B),A)
            & m2_relset_1(B,k4_finseq_1(B),A) ) ) ) ).

fof(t31_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k5_numbers,B)
                & m2_relset_1(C,k5_numbers,B) )
             => m2_finseq_1(k2_partfun1(k5_numbers,B,C,k2_finseq_1(A)),B) ) ) ) ).

fof(t32_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C)
                & v1_finseq_1(C) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,k5_numbers,B)
                    & m2_relset_1(D,k5_numbers,B) )
                 => ( C = k2_partfun1(k5_numbers,B,D,k2_finseq_1(A))
                   => k3_finseq_1(C) = A ) ) ) ) ) ).

fof(t33_finseq_2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( ( r1_tarski(k2_relat_1(A),k1_relat_1(C))
                  & B = k5_relat_1(A,C) )
               => k3_finseq_1(B) = k3_finseq_1(A) ) ) ) ) ).

fof(t34_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ( B = k2_finseq_1(A)
           => ! [C] :
                ( ( v1_relat_1(C)
                  & v1_funct_1(C)
                  & v1_finseq_1(C) )
               => ! [D] :
                    ( m2_finseq_1(D,B)
                   => ( r1_xreal_0(A,k3_finseq_1(C))
                     => ( v1_relat_1(k5_relat_1(D,C))
                        & v1_funct_1(k5_relat_1(D,C))
                        & v1_finseq_1(k5_relat_1(D,C)) ) ) ) ) ) ) ) ).

fof(t35_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ( B = k2_finseq_1(A)
               => ! [D] :
                    ( m2_finseq_1(D,C)
                   => ! [E] :
                        ( m2_finseq_1(E,B)
                       => ( r1_xreal_0(A,k3_finseq_1(D))
                         => m2_finseq_1(k1_partfun1(k5_numbers,B,k5_numbers,C,E,D),C) ) ) ) ) ) ) ) ).

fof(t36_finseq_2,axiom,
    ! [A,B,C] :
      ( m2_finseq_1(C,A)
     => ! [D] :
          ( ( v1_funct_1(D)
            & v1_funct_2(D,A,B)
            & m2_relset_1(D,A,B) )
         => m2_finseq_1(k1_partfun1(k5_numbers,A,A,B,C,D),B) ) ) ).

fof(t37_finseq_2,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C)
            & v1_finseq_1(C) )
         => ! [D] :
              ( m2_finseq_1(D,A)
             => ! [E] :
                  ( ( v1_funct_1(E)
                    & v1_funct_2(E,A,B)
                    & m2_relset_1(E,A,B) )
                 => ( C = k1_partfun1(k5_numbers,A,A,B,D,E)
                   => k3_finseq_1(C) = k3_finseq_1(D) ) ) ) ) ) ).

fof(t38_finseq_2,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ! [C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,A,B)
            & m2_relset_1(C,A,B) )
         => k1_partfun1(k5_numbers,A,A,B,k6_finseq_1(A),C) = k6_finseq_1(B) ) ) ).

fof(t39_finseq_2,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ! [C] :
          ( ~ v1_xboole_0(C)
         => ! [D] :
              ( m2_finseq_1(D,B)
             => ! [E] :
                  ( ( v1_funct_1(E)
                    & v1_funct_2(E,B,C)
                    & m2_relset_1(E,B,C) )
                 => ( D = k9_finseq_1(A)
                   => k1_partfun1(k5_numbers,B,B,C,D,E) = k9_finseq_1(k1_funct_1(E,A)) ) ) ) ) ) ).

fof(t40_finseq_2,axiom,
    ! [A,B,C] :
      ( ~ v1_xboole_0(C)
     => ! [D] :
          ( ~ v1_xboole_0(D)
         => ! [E] :
              ( m2_finseq_1(E,C)
             => ! [F] :
                  ( ( v1_funct_1(F)
                    & v1_funct_2(F,C,D)
                    & m2_relset_1(F,C,D) )
                 => ( E = k10_finseq_1(A,B)
                   => k1_partfun1(k5_numbers,C,C,D,E,F) = k10_finseq_1(k1_funct_1(F,A),k1_funct_1(F,B)) ) ) ) ) ) ).

fof(t41_finseq_2,axiom,
    ! [A,B,C,D] :
      ( ~ v1_xboole_0(D)
     => ! [E] :
          ( ~ v1_xboole_0(E)
         => ! [F] :
              ( m2_finseq_1(F,D)
             => ! [G] :
                  ( ( v1_funct_1(G)
                    & v1_funct_2(G,D,E)
                    & m2_relset_1(G,D,E) )
                 => ( F = k11_finseq_1(A,B,C)
                   => k1_partfun1(k5_numbers,D,D,E,F,G) = k11_finseq_1(k1_funct_1(G,A),k1_funct_1(G,B),k1_funct_1(G,C)) ) ) ) ) ) ).

fof(t42_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C)
                & v1_finseq_1(C) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,k2_finseq_1(A),k2_finseq_1(B))
                    & m2_relset_1(D,k2_finseq_1(A),k2_finseq_1(B)) )
                 => ( r1_xreal_0(B,k3_finseq_1(C))
                   => ( ( B = np__0
                        & A != np__0 )
                      | ( v1_relat_1(k5_relat_1(D,C))
                        & v1_funct_1(k5_relat_1(D,C))
                        & v1_finseq_1(k5_relat_1(D,C)) ) ) ) ) ) ) ) ).

fof(t43_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_finseq_1(A),k2_finseq_1(A))
                & m2_relset_1(C,k2_finseq_1(A),k2_finseq_1(A)) )
             => ( r1_xreal_0(A,k3_finseq_1(B))
               => ( v1_relat_1(k5_relat_1(C,B))
                  & v1_funct_1(k5_relat_1(C,B))
                  & v1_finseq_1(k5_relat_1(C,B)) ) ) ) ) ) ).

fof(t44_finseq_2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,k4_finseq_1(A),k4_finseq_1(A))
            & m2_relset_1(B,k4_finseq_1(A),k4_finseq_1(A)) )
         => ( v1_relat_1(k5_relat_1(B,A))
            & v1_funct_1(k5_relat_1(B,A))
            & v1_finseq_1(k5_relat_1(B,A)) ) ) ) ).

fof(t45_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C)
                & v1_finseq_1(C) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,k2_finseq_1(A),k2_finseq_1(A))
                    & m2_relset_1(D,k2_finseq_1(A),k2_finseq_1(A)) )
                 => ( ( k2_relat_1(D) = k2_finseq_1(A)
                      & r1_xreal_0(A,k3_finseq_1(B))
                      & C = k5_relat_1(D,B) )
                   => k3_finseq_1(C) = A ) ) ) ) ) ).

fof(t46_finseq_2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k4_finseq_1(A),k4_finseq_1(A))
                & m2_relset_1(C,k4_finseq_1(A),k4_finseq_1(A)) )
             => ( ( k2_relat_1(C) = k4_finseq_1(A)
                  & B = k5_relat_1(C,A) )
               => k3_finseq_1(B) = k3_finseq_1(A) ) ) ) ) ).

fof(t47_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C)
                & v1_finseq_1(C) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,k2_finseq_1(A),k2_finseq_1(A))
                    & v3_funct_2(D,k2_finseq_1(A),k2_finseq_1(A))
                    & m2_relset_1(D,k2_finseq_1(A),k2_finseq_1(A)) )
                 => ( ( r1_xreal_0(A,k3_finseq_1(B))
                      & C = k5_relat_1(D,B) )
                   => k3_finseq_1(C) = A ) ) ) ) ) ).

fof(t48_finseq_2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k4_finseq_1(A),k4_finseq_1(A))
                & v3_funct_2(C,k4_finseq_1(A),k4_finseq_1(A))
                & m2_relset_1(C,k4_finseq_1(A),k4_finseq_1(A)) )
             => ( B = k5_relat_1(C,A)
               => k3_finseq_1(B) = k3_finseq_1(A) ) ) ) ) ).

fof(t49_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( m2_finseq_1(D,C)
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,k2_finseq_1(A),k2_finseq_1(B))
                        & m2_relset_1(E,k2_finseq_1(A),k2_finseq_1(B)) )
                     => ( r1_xreal_0(B,k3_finseq_1(D))
                       => ( ( B = np__0
                            & A != np__0 )
                          | m2_finseq_1(k1_partfun1(k2_finseq_1(A),k2_finseq_1(B),k5_numbers,C,E,D),C) ) ) ) ) ) ) ) ).

fof(t50_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( m2_finseq_1(C,B)
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,k2_finseq_1(A),k2_finseq_1(A))
                    & m2_relset_1(D,k2_finseq_1(A),k2_finseq_1(A)) )
                 => ( r1_xreal_0(A,k3_finseq_1(C))
                   => m2_finseq_1(k1_partfun1(k2_finseq_1(A),k2_finseq_1(A),k5_numbers,B,D,C),B) ) ) ) ) ) ).

fof(t51_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m2_finseq_1(B,A)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k4_finseq_1(B),k4_finseq_1(B))
                & m2_relset_1(C,k4_finseq_1(B),k4_finseq_1(B)) )
             => m2_finseq_1(k1_partfun1(k4_finseq_1(B),k4_finseq_1(B),k5_numbers,A,C,B),A) ) ) ) ).

fof(t52_finseq_2,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => m2_finseq_1(k6_partfun1(k2_finseq_1(A)),k5_numbers) ) ).

fof(d1_finseq_2,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => k1_finseq_2(A) = k6_partfun1(k2_finseq_1(A)) ) ).

fof(t53_finseq_2,axiom,
    $true ).

fof(t54_finseq_2,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => k4_finseq_1(k1_finseq_2(A)) = k2_finseq_1(A) ) ).

fof(t55_finseq_2,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => k3_finseq_1(k1_finseq_2(A)) = A ) ).

fof(t56_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
         => ( r2_hidden(A,k2_finseq_1(B))
           => k1_funct_1(k1_finseq_2(B),A) = A ) ) ) ).

fof(t57_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ( A != np__0
       => ! [B] :
            ( m1_subset_1(B,k2_finseq_1(A))
           => k1_funct_1(k1_finseq_2(A),B) = B ) ) ) ).

fof(t58_finseq_2,axiom,
    k1_finseq_2(np__0) = k1_xboole_0 ).

fof(t59_finseq_2,axiom,
    k1_finseq_2(np__1) = k12_finseq_1(k5_numbers,np__1) ).

fof(t60_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => k1_finseq_2(k1_nat_1(A,np__1)) = k7_finseq_1(k1_finseq_2(A),k12_finseq_1(k5_numbers,k1_nat_1(A,np__1))) ) ).

fof(t61_finseq_2,axiom,
    k1_finseq_2(np__2) = k10_finseq_1(np__1,np__2) ).

fof(t62_finseq_2,axiom,
    k1_finseq_2(np__3) = k11_finseq_1(np__1,np__2,np__3) ).

fof(t63_finseq_2,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => k5_relat_1(k1_finseq_2(A),B) = k7_relat_1(B,k2_finseq_1(A)) ) ) ).

fof(t64_finseq_2,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => ( r1_xreal_0(k3_finseq_1(B),A)
           => k5_relat_1(k1_finseq_2(A),B) = B ) ) ) ).

fof(t65_finseq_2,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ( v1_funct_1(k1_finseq_2(A))
        & v1_funct_2(k1_finseq_2(A),k2_finseq_1(A),k2_finseq_1(A))
        & v3_funct_2(k1_finseq_2(A),k2_finseq_1(A),k2_finseq_1(A))
        & m2_relset_1(k1_finseq_2(A),k2_finseq_1(A),k2_finseq_1(A)) ) ) ).

fof(t66_finseq_2,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( v1_relat_1(k2_funcop_1(k2_finseq_1(A),B))
          & v1_funct_1(k2_funcop_1(k2_finseq_1(A),B))
          & v1_finseq_1(k2_funcop_1(k2_finseq_1(A),B)) ) ) ).

fof(d2_finseq_2,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] : k2_finseq_2(A,B) = k2_funcop_1(k2_finseq_1(A),B) ) ).

fof(t67_finseq_2,axiom,
    $true ).

fof(t68_finseq_2,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] : k4_finseq_1(k2_finseq_2(A,B)) = k2_finseq_1(A) ) ).

fof(t69_finseq_2,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] : k3_finseq_1(k2_finseq_2(A,B)) = A ) ).

fof(t70_finseq_2,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B,C] :
          ( r2_hidden(B,k2_finseq_1(A))
         => k1_funct_1(k2_finseq_2(A,C),B) = C ) ) ).

fof(t71_finseq_2,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( m1_subset_1(C,B)
             => ( A != np__0
               => ! [D] :
                    ( m1_subset_1(D,k2_finseq_1(A))
                   => k1_funct_1(k2_finseq_2(A,C),D) = C ) ) ) ) ) ).

fof(t72_finseq_2,axiom,
    ! [A] : k2_finseq_2(np__0,A) = k1_xboole_0 ).

fof(t73_finseq_2,axiom,
    ! [A] : k2_finseq_2(np__1,A) = k9_finseq_1(A) ).

fof(t74_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] : k2_finseq_2(k1_nat_1(A,np__1),B) = k7_finseq_1(k2_finseq_2(A,B),k9_finseq_1(B)) ) ).

fof(t75_finseq_2,axiom,
    ! [A] : k2_finseq_2(np__2,A) = k10_finseq_1(A,A) ).

fof(t76_finseq_2,axiom,
    ! [A] : k2_finseq_2(np__3,A) = k11_finseq_1(A,A,A) ).

fof(t77_finseq_2,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( m1_subset_1(C,B)
             => m2_finseq_1(k2_finseq_2(A,C),B) ) ) ) ).

fof(t78_finseq_2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C) )
             => ( r1_tarski(k2_zfmisc_1(k2_relat_1(A),k2_relat_1(B)),k1_relat_1(C))
               => ( v1_relat_1(k3_funcop_1(C,A,B))
                  & v1_funct_1(k3_funcop_1(C,A,B))
                  & v1_finseq_1(k3_funcop_1(C,A,B)) ) ) ) ) ) ).

fof(t79_finseq_2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C)
                & v1_finseq_1(C) )
             => ! [D] :
                  ( ( v1_relat_1(D)
                    & v1_funct_1(D) )
                 => ( ( r1_tarski(k2_zfmisc_1(k2_relat_1(A),k2_relat_1(B)),k1_relat_1(D))
                      & C = k3_funcop_1(D,A,B) )
                   => k3_finseq_1(C) = k3_square_1(k3_finseq_1(A),k3_finseq_1(B)) ) ) ) ) ) ).

fof(t80_finseq_2,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B)
        & v1_finseq_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( r1_tarski(k2_zfmisc_1(k1_tarski(A),k2_relat_1(B)),k1_relat_1(C))
           => ( v1_relat_1(k5_funcop_1(C,A,B))
              & v1_funct_1(k5_funcop_1(C,A,B))
              & v1_finseq_1(k5_funcop_1(C,A,B)) ) ) ) ) ).

fof(t81_finseq_2,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B)
        & v1_finseq_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C)
            & v1_finseq_1(C) )
         => ! [D] :
              ( ( v1_relat_1(D)
                & v1_funct_1(D) )
             => ( ( r1_tarski(k2_zfmisc_1(k1_tarski(A),k2_relat_1(B)),k1_relat_1(D))
                  & C = k5_funcop_1(D,A,B) )
               => k3_finseq_1(C) = k3_finseq_1(B) ) ) ) ) ).

fof(t82_finseq_2,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B)
        & v1_finseq_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C) )
         => ( r1_tarski(k2_zfmisc_1(k2_relat_1(B),k1_tarski(A)),k1_relat_1(C))
           => ( v1_relat_1(k4_funcop_1(C,B,A))
              & v1_funct_1(k4_funcop_1(C,B,A))
              & v1_finseq_1(k4_funcop_1(C,B,A)) ) ) ) ) ).

fof(t83_finseq_2,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B)
        & v1_finseq_1(B) )
     => ! [C] :
          ( ( v1_relat_1(C)
            & v1_funct_1(C)
            & v1_finseq_1(C) )
         => ! [D] :
              ( ( v1_relat_1(D)
                & v1_funct_1(D) )
             => ( ( r1_tarski(k2_zfmisc_1(k2_relat_1(B),k1_tarski(A)),k1_relat_1(D))
                  & C = k4_funcop_1(D,B,A) )
               => k3_finseq_1(C) = k3_finseq_1(B) ) ) ) ) ).

fof(t84_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,k2_zfmisc_1(A,B),C)
                    & m2_relset_1(D,k2_zfmisc_1(A,B),C) )
                 => ! [E] :
                      ( m2_finseq_1(E,A)
                     => ! [F] :
                          ( m2_finseq_1(F,B)
                         => m2_finseq_1(k3_funcop_1(D,E,F),C) ) ) ) ) ) ) ).

fof(t85_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( ( v1_relat_1(D)
                    & v1_funct_1(D)
                    & v1_finseq_1(D) )
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,k2_zfmisc_1(A,B),C)
                        & m2_relset_1(E,k2_zfmisc_1(A,B),C) )
                     => ! [F] :
                          ( m2_finseq_1(F,A)
                         => ! [G] :
                              ( m2_finseq_1(G,B)
                             => ( D = k3_funcop_1(E,F,G)
                               => k3_finseq_1(D) = k3_square_1(k3_finseq_1(F),k3_finseq_1(G)) ) ) ) ) ) ) ) ) ).

fof(t86_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( ( v1_relat_1(D)
                    & v1_funct_1(D)
                    & v1_finseq_1(D) )
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,k2_zfmisc_1(A,B),C)
                        & m2_relset_1(E,k2_zfmisc_1(A,B),C) )
                     => ! [F] :
                          ( m2_finseq_1(F,A)
                         => ! [G] :
                              ( m2_finseq_1(G,B)
                             => ( ( k3_finseq_1(F) = k3_finseq_1(G)
                                  & D = k3_funcop_1(E,F,G) )
                               => ( k3_finseq_1(D) = k3_finseq_1(F)
                                  & k3_finseq_1(D) = k3_finseq_1(G) ) ) ) ) ) ) ) ) ) ).

fof(t87_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,k2_zfmisc_1(A,B),C)
                    & m2_relset_1(D,k2_zfmisc_1(A,B),C) )
                 => ! [E] :
                      ( m2_finseq_1(E,A)
                     => ! [F] :
                          ( m2_finseq_1(F,B)
                         => ( k3_funcop_1(D,k6_finseq_1(A),F) = k6_finseq_1(C)
                            & k3_funcop_1(D,E,k6_finseq_1(B)) = k6_finseq_1(C) ) ) ) ) ) ) ) ).

fof(t88_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( m1_subset_1(D,A)
                 => ! [E] :
                      ( m1_subset_1(E,B)
                     => ! [F] :
                          ( ( v1_funct_1(F)
                            & v1_funct_2(F,k2_zfmisc_1(A,B),C)
                            & m2_relset_1(F,k2_zfmisc_1(A,B),C) )
                         => ! [G] :
                              ( m2_finseq_1(G,A)
                             => ! [H] :
                                  ( m2_finseq_1(H,B)
                                 => ( ( G = k12_finseq_1(A,D)
                                      & H = k12_finseq_1(B,E) )
                                   => k3_funcop_1(F,G,H) = k12_finseq_1(C,k2_binop_1(A,B,C,F,D,E)) ) ) ) ) ) ) ) ) ) ).

fof(t89_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( m1_subset_1(D,A)
                 => ! [E] :
                      ( m1_subset_1(E,A)
                     => ! [F] :
                          ( m1_subset_1(F,B)
                         => ! [G] :
                              ( m1_subset_1(G,B)
                             => ! [H] :
                                  ( ( v1_funct_1(H)
                                    & v1_funct_2(H,k2_zfmisc_1(A,B),C)
                                    & m2_relset_1(H,k2_zfmisc_1(A,B),C) )
                                 => ! [I] :
                                      ( m2_finseq_1(I,A)
                                     => ! [J] :
                                          ( m2_finseq_1(J,B)
                                         => ( ( I = k10_finseq_1(D,E)
                                              & J = k10_finseq_1(F,G) )
                                           => k3_funcop_1(H,I,J) = k10_finseq_1(k2_binop_1(A,B,C,H,D,F),k2_binop_1(A,B,C,H,E,G)) ) ) ) ) ) ) ) ) ) ) ) ).

fof(t90_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( m1_subset_1(D,A)
                 => ! [E] :
                      ( m1_subset_1(E,A)
                     => ! [F] :
                          ( m1_subset_1(F,A)
                         => ! [G] :
                              ( m1_subset_1(G,B)
                             => ! [H] :
                                  ( m1_subset_1(H,B)
                                 => ! [I] :
                                      ( m1_subset_1(I,B)
                                     => ! [J] :
                                          ( ( v1_funct_1(J)
                                            & v1_funct_2(J,k2_zfmisc_1(A,B),C)
                                            & m2_relset_1(J,k2_zfmisc_1(A,B),C) )
                                         => ! [K] :
                                              ( m2_finseq_1(K,A)
                                             => ! [L] :
                                                  ( m2_finseq_1(L,B)
                                                 => ( ( K = k11_finseq_1(D,E,F)
                                                      & L = k11_finseq_1(G,H,I) )
                                                   => k3_funcop_1(J,K,L) = k11_finseq_1(k2_binop_1(A,B,C,J,D,G),k2_binop_1(A,B,C,J,E,H),k2_binop_1(A,B,C,J,F,I)) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

fof(t91_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( m1_subset_1(D,A)
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,k2_zfmisc_1(A,B),C)
                        & m2_relset_1(E,k2_zfmisc_1(A,B),C) )
                     => ! [F] :
                          ( m2_finseq_1(F,B)
                         => m2_finseq_1(k5_funcop_1(E,D,F),C) ) ) ) ) ) ) ).

fof(t92_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( m1_subset_1(D,A)
                 => ! [E] :
                      ( ( v1_relat_1(E)
                        & v1_funct_1(E)
                        & v1_finseq_1(E) )
                     => ! [F] :
                          ( ( v1_funct_1(F)
                            & v1_funct_2(F,k2_zfmisc_1(A,B),C)
                            & m2_relset_1(F,k2_zfmisc_1(A,B),C) )
                         => ! [G] :
                              ( m2_finseq_1(G,B)
                             => ( E = k5_funcop_1(F,D,G)
                               => k3_finseq_1(E) = k3_finseq_1(G) ) ) ) ) ) ) ) ) ).

fof(t93_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( m1_subset_1(D,A)
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,k2_zfmisc_1(A,B),C)
                        & m2_relset_1(E,k2_zfmisc_1(A,B),C) )
                     => k5_funcop_1(E,D,k6_finseq_1(B)) = k6_finseq_1(C) ) ) ) ) ) ).

fof(t94_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( m1_subset_1(D,A)
                 => ! [E] :
                      ( m1_subset_1(E,B)
                     => ! [F] :
                          ( ( v1_funct_1(F)
                            & v1_funct_2(F,k2_zfmisc_1(A,B),C)
                            & m2_relset_1(F,k2_zfmisc_1(A,B),C) )
                         => ! [G] :
                              ( m2_finseq_1(G,B)
                             => ( G = k12_finseq_1(B,E)
                               => k5_funcop_1(F,D,G) = k12_finseq_1(C,k2_binop_1(A,B,C,F,D,E)) ) ) ) ) ) ) ) ) ).

fof(t95_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( m1_subset_1(D,A)
                 => ! [E] :
                      ( m1_subset_1(E,B)
                     => ! [F] :
                          ( m1_subset_1(F,B)
                         => ! [G] :
                              ( ( v1_funct_1(G)
                                & v1_funct_2(G,k2_zfmisc_1(A,B),C)
                                & m2_relset_1(G,k2_zfmisc_1(A,B),C) )
                             => ! [H] :
                                  ( m2_finseq_1(H,B)
                                 => ( H = k10_finseq_1(E,F)
                                   => k5_funcop_1(G,D,H) = k10_finseq_1(k2_binop_1(A,B,C,G,D,E),k2_binop_1(A,B,C,G,D,F)) ) ) ) ) ) ) ) ) ) ).

fof(t96_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( m1_subset_1(D,A)
                 => ! [E] :
                      ( m1_subset_1(E,B)
                     => ! [F] :
                          ( m1_subset_1(F,B)
                         => ! [G] :
                              ( m1_subset_1(G,B)
                             => ! [H] :
                                  ( ( v1_funct_1(H)
                                    & v1_funct_2(H,k2_zfmisc_1(A,B),C)
                                    & m2_relset_1(H,k2_zfmisc_1(A,B),C) )
                                 => ! [I] :
                                      ( m2_finseq_1(I,B)
                                     => ( I = k11_finseq_1(E,F,G)
                                       => k5_funcop_1(H,D,I) = k11_finseq_1(k2_binop_1(A,B,C,H,D,E),k2_binop_1(A,B,C,H,D,F),k2_binop_1(A,B,C,H,D,G)) ) ) ) ) ) ) ) ) ) ) ).

fof(t97_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( m1_subset_1(D,B)
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,k2_zfmisc_1(A,B),C)
                        & m2_relset_1(E,k2_zfmisc_1(A,B),C) )
                     => ! [F] :
                          ( m2_finseq_1(F,A)
                         => m2_finseq_1(k4_funcop_1(E,F,D),C) ) ) ) ) ) ) ).

fof(t98_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( m1_subset_1(D,B)
                 => ! [E] :
                      ( ( v1_relat_1(E)
                        & v1_funct_1(E)
                        & v1_finseq_1(E) )
                     => ! [F] :
                          ( ( v1_funct_1(F)
                            & v1_funct_2(F,k2_zfmisc_1(A,B),C)
                            & m2_relset_1(F,k2_zfmisc_1(A,B),C) )
                         => ! [G] :
                              ( m2_finseq_1(G,A)
                             => ( E = k4_funcop_1(F,G,D)
                               => k3_finseq_1(E) = k3_finseq_1(G) ) ) ) ) ) ) ) ) ).

fof(t99_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( m1_subset_1(D,B)
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,k2_zfmisc_1(A,B),C)
                        & m2_relset_1(E,k2_zfmisc_1(A,B),C) )
                     => k4_funcop_1(E,k6_finseq_1(A),D) = k6_finseq_1(C) ) ) ) ) ) ).

fof(t100_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( m1_subset_1(D,A)
                 => ! [E] :
                      ( m1_subset_1(E,B)
                     => ! [F] :
                          ( ( v1_funct_1(F)
                            & v1_funct_2(F,k2_zfmisc_1(A,B),C)
                            & m2_relset_1(F,k2_zfmisc_1(A,B),C) )
                         => ! [G] :
                              ( m2_finseq_1(G,A)
                             => ( G = k12_finseq_1(A,D)
                               => k4_funcop_1(F,G,E) = k12_finseq_1(C,k2_binop_1(A,B,C,F,D,E)) ) ) ) ) ) ) ) ) ).

fof(t101_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( m1_subset_1(D,A)
                 => ! [E] :
                      ( m1_subset_1(E,A)
                     => ! [F] :
                          ( m1_subset_1(F,B)
                         => ! [G] :
                              ( ( v1_funct_1(G)
                                & v1_funct_2(G,k2_zfmisc_1(A,B),C)
                                & m2_relset_1(G,k2_zfmisc_1(A,B),C) )
                             => ! [H] :
                                  ( m2_finseq_1(H,A)
                                 => ( H = k10_finseq_1(D,E)
                                   => k4_funcop_1(G,H,F) = k10_finseq_1(k2_binop_1(A,B,C,G,D,F),k2_binop_1(A,B,C,G,E,F)) ) ) ) ) ) ) ) ) ) ).

fof(t102_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( m1_subset_1(D,A)
                 => ! [E] :
                      ( m1_subset_1(E,A)
                     => ! [F] :
                          ( m1_subset_1(F,A)
                         => ! [G] :
                              ( m1_subset_1(G,B)
                             => ! [H] :
                                  ( ( v1_funct_1(H)
                                    & v1_funct_2(H,k2_zfmisc_1(A,B),C)
                                    & m2_relset_1(H,k2_zfmisc_1(A,B),C) )
                                 => ! [I] :
                                      ( m2_finseq_1(I,A)
                                     => ( I = k11_finseq_1(D,E,F)
                                       => k4_funcop_1(H,I,G) = k11_finseq_1(k2_binop_1(A,B,C,H,D,G),k2_binop_1(A,B,C,H,E,G),k2_binop_1(A,B,C,H,F,G)) ) ) ) ) ) ) ) ) ) ) ).

fof(d3_finseq_2,axiom,
    ! [A,B] :
      ( m1_finseq_2(B,A)
    <=> ! [C] :
          ( r2_hidden(C,B)
         => m2_finseq_1(C,A) ) ) ).

fof(t103_finseq_2,axiom,
    $true ).

fof(t104_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(k13_finseq_1(A))
      & m1_finseq_2(k13_finseq_1(A),A) ) ).

fof(t105_finseq_2,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(B)
        & m1_finseq_2(B,A) )
     => r1_tarski(B,k3_finseq_2(A)) ) ).

fof(t106_finseq_2,axiom,
    $true ).

fof(t107_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( ~ v1_xboole_0(B)
            & m1_subset_1(B,k1_zfmisc_1(A)) )
         => ! [C] :
              ( ( ~ v1_xboole_0(C)
                & m1_finseq_2(C,B) )
             => ( ~ v1_xboole_0(C)
                & m1_finseq_2(C,A) ) ) ) ) ).

fof(t108_finseq_2,axiom,
    $true ).

fof(t109_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( m2_finseq_2(C,B,k4_finseq_2(A,B))
             => k3_finseq_1(C) = A ) ) ) ).

fof(t110_finseq_2,axiom,
    ! [A,B] :
      ( m2_finseq_1(B,A)
     => m1_subset_1(B,k4_finseq_2(k3_finseq_1(B),A)) ) ).

fof(t111_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => k4_finseq_2(A,B) = k1_funct_2(k2_finseq_1(A),B) ) ) ).

fof(t112_finseq_2,axiom,
    ! [A] : k4_finseq_2(np__0,A) = k6_domain_1(k1_zfmisc_1(k2_zfmisc_1(k5_numbers,A)),k6_finseq_1(A)) ).

fof(t113_finseq_2,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k4_finseq_2(np__0,A))
     => B = k6_finseq_1(A) ) ).

fof(t114_finseq_2,axiom,
    ! [A] : m1_subset_1(k6_finseq_1(A),k4_finseq_2(np__0,A)) ).

fof(t115_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( m2_finseq_2(C,B,k4_finseq_2(np__0,B))
             => ! [D] :
                  ( m2_finseq_2(D,B,k4_finseq_2(A,B))
                 => ( k8_finseq_1(B,C,D) = D
                    & k8_finseq_1(B,D,C) = D ) ) ) ) ) ).

fof(t117_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m2_finseq_2(B,A,k4_finseq_2(np__1,A))
         => ? [C] :
              ( m1_subset_1(C,A)
              & B = k12_finseq_1(A,C) ) ) ) ).

fof(t118_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m1_subset_1(B,A)
         => m2_finseq_2(k12_finseq_1(A,B),A,k4_finseq_2(np__1,A)) ) ) ).

fof(t120_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m2_finseq_2(B,A,k4_finseq_2(np__2,A))
         => ? [C] :
              ( m1_subset_1(C,A)
              & ? [D] :
                  ( m1_subset_1(D,A)
                  & B = k10_finseq_1(C,D) ) ) ) ) ).

fof(t121_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m1_subset_1(B,A)
         => ! [C] :
              ( m1_subset_1(C,A)
             => m2_finseq_2(k10_finseq_1(B,C),A,k4_finseq_2(np__2,A)) ) ) ) ).

fof(t123_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m2_finseq_2(B,A,k4_finseq_2(np__3,A))
         => ? [C] :
              ( m1_subset_1(C,A)
              & ? [D] :
                  ( m1_subset_1(D,A)
                  & ? [E] :
                      ( m1_subset_1(E,A)
                      & B = k11_finseq_1(C,D,E) ) ) ) ) ) ).

fof(t124_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m1_subset_1(B,A)
         => ! [C] :
              ( m1_subset_1(C,A)
             => ! [D] :
                  ( m1_subset_1(D,A)
                 => m2_finseq_2(k11_finseq_1(B,C,D),A,k4_finseq_2(np__3,A)) ) ) ) ) ).

fof(t126_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( m2_finseq_2(D,C,k4_finseq_2(k1_nat_1(A,B),C))
                 => ? [E] :
                      ( m2_finseq_2(E,C,k4_finseq_2(A,C))
                      & ? [F] :
                          ( m2_finseq_2(F,C,k4_finseq_2(B,C))
                          & D = k8_finseq_1(C,E,F) ) ) ) ) ) ) ).

fof(t127_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( m2_finseq_2(D,C,k4_finseq_2(A,C))
                 => ! [E] :
                      ( m2_finseq_2(E,C,k4_finseq_2(B,C))
                     => m2_finseq_2(k8_finseq_1(C,D,E),C,k4_finseq_2(k1_nat_1(A,B),C)) ) ) ) ) ) ).

fof(t129_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( ~ v1_xboole_0(C)
                & m1_subset_1(C,k1_zfmisc_1(B)) )
             => ! [D] :
                  ( m2_finseq_2(D,C,k4_finseq_2(A,C))
                 => m2_finseq_2(D,B,k4_finseq_2(A,B)) ) ) ) ) ).

fof(t130_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ( k4_finseq_2(A,C) = k4_finseq_2(B,C)
               => A = B ) ) ) ) ).

fof(t131_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => m2_finseq_2(k1_finseq_2(A),k5_numbers,k4_finseq_2(A,k5_numbers)) ) ).

fof(t132_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( m1_subset_1(C,B)
             => m2_finseq_2(k2_finseq_2(A,C),B,k4_finseq_2(A,B)) ) ) ) ).

fof(t133_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( m2_finseq_2(D,B,k4_finseq_2(A,B))
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,B,C)
                        & m2_relset_1(E,B,C) )
                     => m2_finseq_2(k1_partfun1(k5_numbers,B,B,C,D,E),C,k4_finseq_2(A,C)) ) ) ) ) ) ).

fof(t134_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( m2_finseq_2(C,B,k4_finseq_2(A,B))
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,k2_finseq_1(A),k2_finseq_1(A))
                    & m2_relset_1(D,k2_finseq_1(A),k2_finseq_1(A)) )
                 => ( k2_relat_1(D) = k2_finseq_1(A)
                   => m2_finseq_2(k1_partfun1(k2_finseq_1(A),k2_finseq_1(A),k5_numbers,B,D,C),B,k4_finseq_2(A,B)) ) ) ) ) ) ).

fof(t135_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( m2_finseq_2(C,B,k4_finseq_2(A,B))
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,k2_finseq_1(A),k2_finseq_1(A))
                    & v3_funct_2(D,k2_finseq_1(A),k2_finseq_1(A))
                    & m2_relset_1(D,k2_finseq_1(A),k2_finseq_1(A)) )
                 => m2_finseq_2(k1_partfun1(k2_finseq_1(A),k2_finseq_1(A),k5_numbers,B,D,C),B,k4_finseq_2(A,B)) ) ) ) ) ).

fof(t136_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( m2_finseq_2(C,B,k4_finseq_2(A,B))
             => ! [D] :
                  ( m1_subset_1(D,B)
                 => k1_funct_1(k8_finseq_1(B,C,k12_finseq_1(B,D)),k1_nat_1(A,np__1)) = D ) ) ) ) ).

fof(t137_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( m2_finseq_2(C,B,k4_finseq_2(k1_nat_1(A,np__1),B))
             => ? [D] :
                  ( m2_finseq_2(D,B,k4_finseq_2(A,B))
                  & ? [E] :
                      ( m1_subset_1(E,B)
                      & C = k8_finseq_1(B,D,k12_finseq_1(B,E)) ) ) ) ) ) ).

fof(t138_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( m2_finseq_2(C,B,k4_finseq_2(A,B))
             => k5_relat_1(k1_finseq_2(A),C) = C ) ) ) ).

fof(t139_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( m2_finseq_2(C,B,k4_finseq_2(A,B))
             => ! [D] :
                  ( m2_finseq_2(D,B,k4_finseq_2(A,B))
                 => ( ! [E] :
                        ( m2_subset_1(E,k1_numbers,k5_numbers)
                       => ( r2_hidden(E,k2_finseq_1(A))
                         => k1_funct_1(C,E) = k1_funct_1(D,E) ) )
                   => C = D ) ) ) ) ) ).

fof(t140_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( ~ v1_xboole_0(D)
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,k2_zfmisc_1(B,C),D)
                        & m2_relset_1(E,k2_zfmisc_1(B,C),D) )
                     => ! [F] :
                          ( m2_finseq_2(F,B,k4_finseq_2(A,B))
                         => ! [G] :
                              ( m2_finseq_2(G,C,k4_finseq_2(A,C))
                             => m2_finseq_2(k3_funcop_1(E,F,G),D,k4_finseq_2(A,D)) ) ) ) ) ) ) ) ).

fof(t141_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( ~ v1_xboole_0(D)
                 => ! [E] :
                      ( m1_subset_1(E,B)
                     => ! [F] :
                          ( ( v1_funct_1(F)
                            & v1_funct_2(F,k2_zfmisc_1(B,C),D)
                            & m2_relset_1(F,k2_zfmisc_1(B,C),D) )
                         => ! [G] :
                              ( m2_finseq_2(G,C,k4_finseq_2(A,C))
                             => m2_finseq_2(k5_funcop_1(F,E,G),D,k4_finseq_2(A,D)) ) ) ) ) ) ) ) ).

fof(t142_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( ~ v1_xboole_0(D)
                 => ! [E] :
                      ( m1_subset_1(E,C)
                     => ! [F] :
                          ( ( v1_funct_1(F)
                            & v1_funct_2(F,k2_zfmisc_1(B,C),D)
                            & m2_relset_1(F,k2_zfmisc_1(B,C),D) )
                         => ! [G] :
                              ( m2_finseq_2(G,B,k4_finseq_2(A,B))
                             => m2_finseq_2(k4_funcop_1(F,G,E),D,k4_finseq_2(A,D)) ) ) ) ) ) ) ) ).

fof(t143_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
         => ! [C] : k2_finseq_2(k1_nat_1(A,B),C) = k7_finseq_1(k2_finseq_2(A,C),k2_finseq_2(B,C)) ) ) ).

fof(t144_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( m2_finseq_2(C,B,k4_finseq_2(A,B))
             => k4_finseq_1(C) = k2_finseq_1(A) ) ) ) ).

fof(t145_finseq_2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B,C] :
          ( ( r2_hidden(B,k1_relat_1(A))
            & r2_hidden(C,k1_relat_1(A)) )
         => k5_relat_1(k10_finseq_1(B,C),A) = k10_finseq_1(k1_funct_1(A,B),k1_funct_1(A,C)) ) ) ).

fof(t146_finseq_2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ! [B,C,D] :
          ( ( r2_hidden(B,k1_relat_1(A))
            & r2_hidden(C,k1_relat_1(A))
            & r2_hidden(D,k1_relat_1(A)) )
         => k5_relat_1(k11_finseq_1(B,C,D),A) = k11_finseq_1(k1_funct_1(A,B),k1_funct_1(A,C),k1_funct_1(A,D)) ) ) ).

fof(t147_finseq_2,axiom,
    ! [A,B] : k2_relat_1(k10_finseq_1(A,B)) = k2_tarski(A,B) ).

fof(t148_finseq_2,axiom,
    ! [A,B,C] : k2_relat_1(k11_finseq_1(A,B,C)) = k1_enumset1(A,B,C) ).

fof(t149_finseq_2,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_finseq_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_finseq_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C)
                & v1_finseq_1(C) )
             => ( ( r1_tarski(A,C)
                  & r1_tarski(B,C)
                  & k3_finseq_1(A) = k3_finseq_1(B) )
               => A = B ) ) ) ) ).

fof(s1_finseq_2,axiom,
    ? [A] :
      ( m2_finseq_1(A,f2_s1_finseq_2)
      & k3_finseq_1(A) = f1_s1_finseq_2
      & ! [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
         => ( r2_hidden(B,k2_finseq_1(f1_s1_finseq_2))
           => k1_funct_1(A,B) = f3_s1_finseq_2(B) ) ) ) ).

fof(s2_finseq_2,axiom,
    ( ( p1_s2_finseq_2(k6_finseq_1(f1_s2_finseq_2))
      & ! [A] :
          ( m2_finseq_1(A,f1_s2_finseq_2)
         => ! [B] :
              ( m1_subset_1(B,f1_s2_finseq_2)
             => ( p1_s2_finseq_2(A)
               => p1_s2_finseq_2(k8_finseq_1(f1_s2_finseq_2,A,k12_finseq_1(f1_s2_finseq_2,B))) ) ) ) )
   => ! [A] :
        ( m2_finseq_1(A,f1_s2_finseq_2)
       => p1_s2_finseq_2(A) ) ) ).

fof(dt_m1_finseq_2,axiom,
    $true ).

fof(existence_m1_finseq_2,axiom,
    ! [A] :
    ? [B] : m1_finseq_2(B,A) ).

fof(dt_m2_finseq_2,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(B)
        & m1_finseq_2(B,A) )
     => ! [C] :
          ( m2_finseq_2(C,A,B)
         => m2_finseq_1(C,A) ) ) ).

fof(existence_m2_finseq_2,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(B)
        & m1_finseq_2(B,A) )
     => ? [C] : m2_finseq_2(C,A,B) ) ).

fof(redefinition_m2_finseq_2,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(B)
        & m1_finseq_2(B,A) )
     => ! [C] :
          ( m2_finseq_2(C,A,B)
        <=> m1_subset_1(C,B) ) ) ).

fof(dt_k1_finseq_2,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ( v1_relat_1(k1_finseq_2(A))
        & v1_funct_1(k1_finseq_2(A))
        & v1_finseq_1(k1_finseq_2(A)) ) ) ).

fof(dt_k2_finseq_2,axiom,
    ! [A,B] :
      ( v4_ordinal2(A)
     => ( v1_relat_1(k2_finseq_2(A,B))
        & v1_funct_1(k2_finseq_2(A,B))
        & v1_finseq_1(k2_finseq_2(A,B)) ) ) ).

fof(dt_k3_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(k3_finseq_2(A))
      & m1_finseq_2(k3_finseq_2(A),A) ) ).

fof(redefinition_k3_finseq_2,axiom,
    ! [A] : k3_finseq_2(A) = k13_finseq_1(A) ).

fof(dt_k4_finseq_2,axiom,
    ! [A,B] :
      ( v4_ordinal2(A)
     => m1_finseq_2(k4_finseq_2(A,B),B) ) ).

fof(d4_finseq_2,axiom,
    ! [A] :
      ( v4_ordinal2(A)
     => ! [B] : k4_finseq_2(A,B) = a_2_0_finseq_2(A,B) ) ).

fof(t116_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => k4_finseq_2(np__1,A) = a_1_0_finseq_2(A) ) ).

fof(t119_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => k4_finseq_2(np__2,A) = a_1_1_finseq_2(A) ) ).

fof(t122_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => k4_finseq_2(np__3,A) = a_1_2_finseq_2(A) ) ).

fof(t125_finseq_2,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => k4_finseq_2(k1_nat_1(A,B),C) = a_3_0_finseq_2(A,B,C) ) ) ) ).

fof(t128_finseq_2,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => k3_finseq_2(A) = k3_tarski(a_1_3_finseq_2(A)) ) ).

fof(fraenkel_a_2_0_finseq_2,axiom,
    ! [A,B,C] :
      ( v4_ordinal2(B)
     => ( r2_hidden(A,a_2_0_finseq_2(B,C))
      <=> ? [D] :
            ( m2_finseq_2(D,C,k3_finseq_2(C))
            & A = D
            & k3_finseq_1(D) = B ) ) ) ).

fof(fraenkel_a_1_0_finseq_2,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ( r2_hidden(A,a_1_0_finseq_2(B))
      <=> ? [C] :
            ( m1_subset_1(C,B)
            & A = k12_finseq_1(B,C) ) ) ) ).

fof(fraenkel_a_1_1_finseq_2,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ( r2_hidden(A,a_1_1_finseq_2(B))
      <=> ? [C,D] :
            ( m1_subset_1(C,B)
            & m1_subset_1(D,B)
            & A = k10_finseq_1(C,D) ) ) ) ).

fof(fraenkel_a_1_2_finseq_2,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ( r2_hidden(A,a_1_2_finseq_2(B))
      <=> ? [C,D,E] :
            ( m1_subset_1(C,B)
            & m1_subset_1(D,B)
            & m1_subset_1(E,B)
            & A = k11_finseq_1(C,D,E) ) ) ) ).

fof(fraenkel_a_3_0_finseq_2,axiom,
    ! [A,B,C,D] :
      ( ( m2_subset_1(B,k1_numbers,k5_numbers)
        & m2_subset_1(C,k1_numbers,k5_numbers)
        & ~ v1_xboole_0(D) )
     => ( r2_hidden(A,a_3_0_finseq_2(B,C,D))
      <=> ? [E,F] :
            ( m2_finseq_2(E,D,k4_finseq_2(B,D))
            & m2_finseq_2(F,D,k4_finseq_2(C,D))
            & A = k8_finseq_1(D,E,F) ) ) ) ).

fof(fraenkel_a_1_3_finseq_2,axiom,
    ! [A,B] :
      ( ~ v1_xboole_0(B)
     => ( r2_hidden(A,a_1_3_finseq_2(B))
      <=> ? [C] :
            ( m2_subset_1(C,k1_numbers,k5_numbers)
            & A = k4_finseq_2(C,B) ) ) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(rc1_pboole,axiom,
    ? [A] :
      ( v1_relat_1(A)
      & v3_relat_1(A)
      & v1_funct_1(A) ) ).

fof(rc2_pboole,axiom,
    ! [A] :
    ? [B] :
      ( m1_pboole(B,A)
      & v1_relat_1(B)
      & v3_relat_1(B)
      & v1_funct_1(B) ) ).

fof(rc3_pboole,axiom,
    ! [A] :
    ? [B] :
      ( m1_pboole(B,A)
      & v1_relat_1(B)
      & v2_relat_1(B)
      & v1_funct_1(B) ) ).

fof(cc1_pboole,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m1_pboole(B,A)
         => ( v2_relat_1(B)
           => ~ v3_relat_1(B) ) ) ) ).

fof(cc2_pboole,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m1_pboole(B,A)
         => ( v3_relat_1(B)
           => ~ v2_relat_1(B) ) ) ) ).

fof(rc4_pboole,axiom,
    ! [A] :
    ? [B] :
      ( m1_pboole(B,A)
      & v1_relat_1(B)
      & v1_funct_1(B)
      & v1_funcop_1(B) ) ).

fof(cc3_pboole,axiom,
    ! [A,B,C] :
      ( ( m1_pboole(B,A)
        & m1_pboole(C,A) )
     => ! [D] :
          ( m3_pboole(D,A,B,C)
         => v1_funcop_1(D) ) ) ).

fof(fc1_pboole,axiom,
    ! [A,B] :
      ( ( v2_relat_1(B)
        & m1_pboole(B,A) )
     => ( v1_relat_1(k6_pboole(A,B))
        & v2_relat_1(k6_pboole(A,B))
        & ~ v3_relat_1(k6_pboole(A,B))
        & v1_funct_1(k6_pboole(A,B)) ) ) ).

fof(fc2_pboole,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & v2_relat_1(B)
        & m1_pboole(B,A)
        & m1_subset_1(C,A) )
     => ~ v1_xboole_0(k1_funct_1(B,C)) ) ).

fof(rc5_pboole,axiom,
    ! [A,B] :
      ( ( v2_relat_1(B)
        & m1_pboole(B,A) )
     => ? [C] :
          ( m4_pboole(C,A,B)
          & v1_relat_1(C)
          & v2_relat_1(C)
          & v1_funct_1(C) ) ) ).

fof(fc3_pboole,axiom,
    ! [A] :
      ( v1_relat_1(k1_pboole(A))
      & v3_relat_1(k1_pboole(A))
      & v1_funct_1(k1_pboole(A)) ) ).

fof(t1_pboole,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v2_relat_1(A)
       => v1_setfam_1(k2_relat_1(A)) ) ) ).

fof(t2_pboole,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A) )
     => ( v3_relat_1(A)
      <=> ( A = k1_xboole_0
          | k2_relat_1(A) = k1_tarski(k1_xboole_0) ) ) ) ).

fof(d1_pboole,axiom,
    $true ).

fof(d2_pboole,axiom,
    $true ).

fof(d3_pboole,axiom,
    ! [A,B] :
      ( ( v1_relat_1(B)
        & v1_funct_1(B) )
     => ( m1_pboole(B,A)
      <=> k1_relat_1(B) = A ) ) ).

fof(d4_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( r1_pboole(A,B,C)
          <=> ! [D] :
                ( r2_hidden(D,A)
               => r2_hidden(k1_funct_1(B,D),k1_funct_1(C,D)) ) ) ) ) ).

fof(d5_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( r2_pboole(A,B,C)
          <=> ! [D] :
                ( r2_hidden(D,A)
               => r1_tarski(k1_funct_1(B,D),k1_funct_1(C,D)) ) ) ) ) ).

fof(t3_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( ! [D] :
                ( r2_hidden(D,A)
               => k1_funct_1(B,D) = k1_funct_1(C,D) )
           => B = C ) ) ) ).

fof(d6_pboole,axiom,
    ! [A] : k1_pboole(A) = k2_funcop_1(A,k1_xboole_0) ).

fof(d7_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( D = k2_pboole(A,B,C)
              <=> ! [E] :
                    ( r2_hidden(E,A)
                   => k1_funct_1(D,E) = k2_xboole_0(k1_funct_1(B,E),k1_funct_1(C,E)) ) ) ) ) ) ).

fof(d8_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( D = k3_pboole(A,B,C)
              <=> ! [E] :
                    ( r2_hidden(E,A)
                   => k1_funct_1(D,E) = k3_xboole_0(k1_funct_1(B,E),k1_funct_1(C,E)) ) ) ) ) ) ).

fof(d9_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( D = k4_pboole(A,B,C)
              <=> ! [E] :
                    ( r2_hidden(E,A)
                   => k1_funct_1(D,E) = k4_xboole_0(k1_funct_1(B,E),k1_funct_1(C,E)) ) ) ) ) ) ).

fof(d10_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( r4_pboole(A,B,C)
          <=> ! [D] :
                ~ ( r2_hidden(D,A)
                  & r1_xboole_0(k1_funct_1(B,D),k1_funct_1(C,D)) ) ) ) ) ).

fof(d11_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( r5_pboole(A,B,C)
          <=> ! [D] :
                ( r2_hidden(D,A)
               => r1_xboole_0(k1_funct_1(B,D),k1_funct_1(C,D)) ) ) ) ) ).

fof(d12_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => k5_pboole(A,B,C) = k2_pboole(A,k4_pboole(A,B,C),k4_pboole(A,C,B)) ) ) ).

fof(t4_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( r2_hidden(D,A)
             => k1_funct_1(k5_pboole(A,B,C),D) = k5_xboole_0(k1_funct_1(B,D),k1_funct_1(C,D)) ) ) ) ).

fof(t5_pboole,axiom,
    ! [A,B] : k1_funct_1(k1_pboole(B),A) = k1_xboole_0 ).

fof(t6_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ( ! [C] :
            ( r2_hidden(C,A)
           => k1_funct_1(B,C) = k1_xboole_0 )
       => B = k1_pboole(A) ) ) ).

fof(t7_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( ( r1_pboole(A,B,C)
                  | r1_pboole(A,B,D) )
               => r1_pboole(A,B,k2_pboole(A,C,D)) ) ) ) ) ).

fof(t8_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( r1_pboole(A,B,k3_pboole(A,C,D))
              <=> ( r1_pboole(A,B,C)
                  & r1_pboole(A,B,D) ) ) ) ) ) ).

fof(t9_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( ( r1_pboole(A,B,C)
                  & r2_pboole(A,C,D) )
               => r1_pboole(A,B,D) ) ) ) ) ).

fof(t10_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( ( r1_pboole(A,B,C)
                  & r1_pboole(A,B,D) )
               => r4_pboole(A,C,D) ) ) ) ) ).

fof(t11_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ~ ( r4_pboole(A,B,C)
              & ! [D] :
                  ( m1_pboole(D,A)
                 => ~ ( r1_pboole(A,D,B)
                      & r1_pboole(A,D,C) ) ) ) ) ) ).

fof(t12_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( r1_pboole(A,B,k4_pboole(A,C,D))
               => r1_pboole(A,B,C) ) ) ) ) ).

fof(d13_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( r6_pboole(A,B,C)
          <=> ( r2_pboole(A,B,C)
              & r2_pboole(A,C,B) ) ) ) ) ).

fof(t13_pboole,axiom,
    $true ).

fof(t14_pboole,axiom,
    $true ).

fof(t15_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( ( r2_pboole(A,B,C)
                  & r2_pboole(A,C,D) )
               => r2_pboole(A,B,D) ) ) ) ) ).

fof(t16_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( r2_pboole(A,B,k2_pboole(A,B,C))
            & r2_pboole(A,C,k2_pboole(A,B,C)) ) ) ) ).

fof(t17_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( r2_pboole(A,k3_pboole(A,B,C),B)
            & r2_pboole(A,k3_pboole(A,B,C),C) ) ) ) ).

fof(t18_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( ( r2_pboole(A,B,C)
                  & r2_pboole(A,D,C) )
               => r2_pboole(A,k2_pboole(A,B,D),C) ) ) ) ) ).

fof(t19_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( ( r2_pboole(A,B,C)
                  & r2_pboole(A,B,D) )
               => r2_pboole(A,B,k3_pboole(A,C,D)) ) ) ) ) ).

fof(t20_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( r2_pboole(A,B,C)
               => ( r2_pboole(A,k2_pboole(A,B,D),k2_pboole(A,C,D))
                  & r2_pboole(A,k2_pboole(A,D,B),k2_pboole(A,D,C)) ) ) ) ) ) ).

fof(t21_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( r2_pboole(A,B,C)
               => ( r2_pboole(A,k3_pboole(A,B,D),k3_pboole(A,C,D))
                  & r2_pboole(A,k3_pboole(A,D,B),k3_pboole(A,D,C)) ) ) ) ) ) ).

fof(t22_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ! [E] :
                  ( m1_pboole(E,A)
                 => ( ( r2_pboole(A,B,C)
                      & r2_pboole(A,D,E) )
                   => r2_pboole(A,k2_pboole(A,B,D),k2_pboole(A,C,E)) ) ) ) ) ) ).

fof(t23_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ! [E] :
                  ( m1_pboole(E,A)
                 => ( ( r2_pboole(A,B,C)
                      & r2_pboole(A,D,E) )
                   => r2_pboole(A,k3_pboole(A,B,D),k3_pboole(A,C,E)) ) ) ) ) ) ).

fof(t24_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( r2_pboole(A,B,C)
           => ( r6_pboole(A,k2_pboole(A,B,C),C)
              & r6_pboole(A,k2_pboole(A,C,B),C) ) ) ) ) ).

fof(t25_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( r2_pboole(A,B,C)
           => ( r6_pboole(A,k3_pboole(A,B,C),B)
              & r6_pboole(A,k3_pboole(A,C,B),B) ) ) ) ) ).

fof(t26_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => r2_pboole(A,k3_pboole(A,B,C),k2_pboole(A,B,D)) ) ) ) ).

fof(t27_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( r2_pboole(A,B,C)
               => r6_pboole(A,k2_pboole(A,B,k3_pboole(A,D,C)),k3_pboole(A,k2_pboole(A,B,D),C)) ) ) ) ) ).

fof(t28_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( r6_pboole(A,B,k2_pboole(A,C,D))
              <=> ( r2_pboole(A,C,B)
                  & r2_pboole(A,D,B)
                  & ! [E] :
                      ( m1_pboole(E,A)
                     => ( ( r2_pboole(A,C,E)
                          & r2_pboole(A,D,E) )
                       => r2_pboole(A,B,E) ) ) ) ) ) ) ) ).

fof(t29_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( r6_pboole(A,B,k3_pboole(A,C,D))
              <=> ( r2_pboole(A,B,C)
                  & r2_pboole(A,B,D)
                  & ! [E] :
                      ( m1_pboole(E,A)
                     => ( ( r2_pboole(A,E,C)
                          & r2_pboole(A,E,D) )
                       => r2_pboole(A,E,B) ) ) ) ) ) ) ) ).

fof(t30_pboole,axiom,
    $true ).

fof(t31_pboole,axiom,
    $true ).

fof(t32_pboole,axiom,
    $true ).

fof(t33_pboole,axiom,
    $true ).

fof(t34_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => r6_pboole(A,k2_pboole(A,k2_pboole(A,B,C),D),k2_pboole(A,B,k2_pboole(A,C,D))) ) ) ) ).

fof(t35_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => r6_pboole(A,k3_pboole(A,k3_pboole(A,B,C),D),k3_pboole(A,B,k3_pboole(A,C,D))) ) ) ) ).

fof(t36_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( r6_pboole(A,k3_pboole(A,B,k2_pboole(A,B,C)),B)
            & r6_pboole(A,k3_pboole(A,k2_pboole(A,B,C),B),B)
            & r6_pboole(A,k3_pboole(A,B,k2_pboole(A,C,B)),B)
            & r6_pboole(A,k3_pboole(A,k2_pboole(A,C,B),B),B) ) ) ) ).

fof(t37_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( r6_pboole(A,k2_pboole(A,B,k3_pboole(A,B,C)),B)
            & r6_pboole(A,k2_pboole(A,k3_pboole(A,B,C),B),B)
            & r6_pboole(A,k2_pboole(A,B,k3_pboole(A,C,B)),B)
            & r6_pboole(A,k2_pboole(A,k3_pboole(A,C,B),B),B) ) ) ) ).

fof(t38_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => r6_pboole(A,k3_pboole(A,B,k2_pboole(A,C,D)),k2_pboole(A,k3_pboole(A,B,C),k3_pboole(A,B,D))) ) ) ) ).

fof(t39_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( r6_pboole(A,k2_pboole(A,B,k3_pboole(A,C,D)),k3_pboole(A,k2_pboole(A,B,C),k2_pboole(A,B,D)))
                & r6_pboole(A,k2_pboole(A,k3_pboole(A,C,D),B),k3_pboole(A,k2_pboole(A,C,B),k2_pboole(A,D,B))) ) ) ) ) ).

fof(t40_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( r6_pboole(A,k2_pboole(A,k3_pboole(A,B,C),k3_pboole(A,B,D)),B)
               => r2_pboole(A,B,k2_pboole(A,C,D)) ) ) ) ) ).

fof(t41_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( r6_pboole(A,k3_pboole(A,k2_pboole(A,B,C),k2_pboole(A,B,D)),B)
               => r2_pboole(A,k3_pboole(A,C,D),B) ) ) ) ) ).

fof(t42_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => r6_pboole(A,k2_pboole(A,k2_pboole(A,k3_pboole(A,B,C),k3_pboole(A,C,D)),k3_pboole(A,D,B)),k3_pboole(A,k3_pboole(A,k2_pboole(A,B,C),k2_pboole(A,C,D)),k2_pboole(A,D,B))) ) ) ) ).

fof(t43_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( r2_pboole(A,k2_pboole(A,B,C),D)
               => ( r2_pboole(A,B,D)
                  & r2_pboole(A,C,D) ) ) ) ) ) ).

fof(t44_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( r2_pboole(A,B,k3_pboole(A,C,D))
               => ( r2_pboole(A,B,C)
                  & r2_pboole(A,B,D) ) ) ) ) ) ).

fof(t45_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( r6_pboole(A,k2_pboole(A,k2_pboole(A,B,C),D),k2_pboole(A,k2_pboole(A,B,D),k2_pboole(A,C,D)))
                & r6_pboole(A,k2_pboole(A,B,k2_pboole(A,C,D)),k2_pboole(A,k2_pboole(A,B,C),k2_pboole(A,B,D))) ) ) ) ) ).

fof(t46_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( r6_pboole(A,k3_pboole(A,k3_pboole(A,B,C),D),k3_pboole(A,k3_pboole(A,B,D),k3_pboole(A,C,D)))
                & r6_pboole(A,k3_pboole(A,B,k3_pboole(A,C,D)),k3_pboole(A,k3_pboole(A,B,C),k3_pboole(A,B,D))) ) ) ) ) ).

fof(t47_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( r6_pboole(A,k2_pboole(A,B,k2_pboole(A,B,C)),k2_pboole(A,B,C))
            & r6_pboole(A,k2_pboole(A,k2_pboole(A,B,C),C),k2_pboole(A,B,C)) ) ) ) ).

fof(t48_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( r6_pboole(A,k3_pboole(A,B,k3_pboole(A,B,C)),k3_pboole(A,B,C))
            & r6_pboole(A,k3_pboole(A,k3_pboole(A,B,C),C),k3_pboole(A,B,C)) ) ) ) ).

fof(t49_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => r2_pboole(A,k1_pboole(A),B) ) ).

fof(t50_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ( r2_pboole(A,B,k1_pboole(A))
       => r6_pboole(A,B,k1_pboole(A)) ) ) ).

fof(t51_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( ( r2_pboole(A,B,C)
                  & r2_pboole(A,B,D)
                  & r6_pboole(A,k3_pboole(A,C,D),k1_pboole(A)) )
               => r6_pboole(A,B,k1_pboole(A)) ) ) ) ) ).

fof(t52_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( ( r2_pboole(A,B,C)
                  & r6_pboole(A,k3_pboole(A,C,D),k1_pboole(A)) )
               => r6_pboole(A,k3_pboole(A,B,D),k1_pboole(A)) ) ) ) ) ).

fof(t53_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ( r6_pboole(A,k2_pboole(A,B,k1_pboole(A)),B)
        & r6_pboole(A,k2_pboole(A,k1_pboole(A),B),B) ) ) ).

fof(t54_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( r6_pboole(A,k2_pboole(A,B,C),k1_pboole(A))
           => ( r6_pboole(A,B,k1_pboole(A))
              & r6_pboole(A,C,k1_pboole(A)) ) ) ) ) ).

fof(t55_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ( r6_pboole(A,k3_pboole(A,B,k1_pboole(A)),k1_pboole(A))
        & r6_pboole(A,k3_pboole(A,k1_pboole(A),B),k1_pboole(A)) ) ) ).

fof(t56_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( ( r2_pboole(A,B,k2_pboole(A,C,D))
                  & r6_pboole(A,k3_pboole(A,B,D),k1_pboole(A)) )
               => r2_pboole(A,B,C) ) ) ) ) ).

fof(t57_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( ( r2_pboole(A,B,C)
              & r6_pboole(A,k3_pboole(A,C,B),k1_pboole(A)) )
           => r6_pboole(A,B,k1_pboole(A)) ) ) ) ).

fof(t58_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( r6_pboole(A,k4_pboole(A,B,C),k1_pboole(A))
          <=> r2_pboole(A,B,C) ) ) ) ).

fof(t59_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( r2_pboole(A,B,C)
               => r2_pboole(A,k4_pboole(A,B,D),k4_pboole(A,C,D)) ) ) ) ) ).

fof(t60_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( r2_pboole(A,B,C)
               => r2_pboole(A,k4_pboole(A,D,C),k4_pboole(A,D,B)) ) ) ) ) ).

fof(t61_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ! [E] :
                  ( m1_pboole(E,A)
                 => ( ( r2_pboole(A,B,C)
                      & r2_pboole(A,D,E) )
                   => r2_pboole(A,k4_pboole(A,B,E),k4_pboole(A,C,D)) ) ) ) ) ) ).

fof(t62_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => r2_pboole(A,k4_pboole(A,B,C),B) ) ) ).

fof(t63_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( r2_pboole(A,B,k4_pboole(A,C,B))
           => r6_pboole(A,B,k1_pboole(A)) ) ) ) ).

fof(t64_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => r6_pboole(A,k4_pboole(A,B,B),k1_pboole(A)) ) ).

fof(t65_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => r6_pboole(A,k4_pboole(A,B,k1_pboole(A)),B) ) ).

fof(t66_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => r6_pboole(A,k4_pboole(A,k1_pboole(A),B),k1_pboole(A)) ) ).

fof(t67_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( r6_pboole(A,k4_pboole(A,B,k2_pboole(A,B,C)),k1_pboole(A))
            & r6_pboole(A,k4_pboole(A,B,k2_pboole(A,C,B)),k1_pboole(A)) ) ) ) ).

fof(t68_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => r6_pboole(A,k3_pboole(A,B,k4_pboole(A,C,D)),k4_pboole(A,k3_pboole(A,B,C),D)) ) ) ) ).

fof(t69_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( r6_pboole(A,k3_pboole(A,k4_pboole(A,B,C),C),k1_pboole(A))
            & r6_pboole(A,k3_pboole(A,C,k4_pboole(A,B,C)),k1_pboole(A)) ) ) ) ).

fof(t70_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => r6_pboole(A,k4_pboole(A,B,k4_pboole(A,C,D)),k2_pboole(A,k4_pboole(A,B,C),k3_pboole(A,B,D))) ) ) ) ).

fof(t71_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( r6_pboole(A,k2_pboole(A,k4_pboole(A,B,C),k3_pboole(A,B,C)),B)
            & r6_pboole(A,k2_pboole(A,k3_pboole(A,B,C),k4_pboole(A,B,C)),B) ) ) ) ).

fof(t72_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( r2_pboole(A,B,C)
           => ( r6_pboole(A,C,k2_pboole(A,B,k4_pboole(A,C,B)))
              & r6_pboole(A,C,k2_pboole(A,k4_pboole(A,C,B),B)) ) ) ) ) ).

fof(t73_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( r6_pboole(A,k2_pboole(A,B,k4_pboole(A,C,B)),k2_pboole(A,B,C))
            & r6_pboole(A,k2_pboole(A,k4_pboole(A,C,B),B),k2_pboole(A,C,B)) ) ) ) ).

fof(t74_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => r6_pboole(A,k4_pboole(A,B,k4_pboole(A,B,C)),k3_pboole(A,B,C)) ) ) ).

fof(t75_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => r6_pboole(A,k4_pboole(A,B,k3_pboole(A,C,D)),k2_pboole(A,k4_pboole(A,B,C),k4_pboole(A,B,D))) ) ) ) ).

fof(t76_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( r6_pboole(A,k4_pboole(A,B,k3_pboole(A,B,C)),k4_pboole(A,B,C))
            & r6_pboole(A,k4_pboole(A,B,k3_pboole(A,C,B)),k4_pboole(A,B,C)) ) ) ) ).

fof(t77_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( r6_pboole(A,k3_pboole(A,B,C),k1_pboole(A))
          <=> r6_pboole(A,k4_pboole(A,B,C),B) ) ) ) ).

fof(t78_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => r6_pboole(A,k4_pboole(A,k2_pboole(A,B,C),D),k2_pboole(A,k4_pboole(A,B,D),k4_pboole(A,C,D))) ) ) ) ).

fof(t79_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => r6_pboole(A,k4_pboole(A,k4_pboole(A,B,C),D),k4_pboole(A,B,k2_pboole(A,C,D))) ) ) ) ).

fof(t80_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => r6_pboole(A,k4_pboole(A,k3_pboole(A,B,C),D),k3_pboole(A,k4_pboole(A,B,D),k4_pboole(A,C,D))) ) ) ) ).

fof(t81_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => r6_pboole(A,k4_pboole(A,k2_pboole(A,B,C),C),k4_pboole(A,B,C)) ) ) ).

fof(t82_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( r2_pboole(A,B,k2_pboole(A,C,D))
               => ( r2_pboole(A,k4_pboole(A,B,C),D)
                  & r2_pboole(A,k4_pboole(A,B,D),C) ) ) ) ) ) ).

fof(t83_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => r6_pboole(A,k4_pboole(A,k2_pboole(A,B,C),k3_pboole(A,B,C)),k2_pboole(A,k4_pboole(A,B,C),k4_pboole(A,C,B))) ) ) ).

fof(t84_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => r6_pboole(A,k4_pboole(A,k4_pboole(A,B,C),C),k4_pboole(A,B,C)) ) ) ).

fof(t85_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => r6_pboole(A,k4_pboole(A,B,k2_pboole(A,C,D)),k3_pboole(A,k4_pboole(A,B,C),k4_pboole(A,B,D))) ) ) ) ).

fof(t86_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( r6_pboole(A,k4_pboole(A,B,C),k4_pboole(A,C,B))
           => r6_pboole(A,B,C) ) ) ) ).

fof(t87_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => r6_pboole(A,k3_pboole(A,B,k4_pboole(A,C,D)),k4_pboole(A,k3_pboole(A,B,C),k3_pboole(A,B,D))) ) ) ) ).

fof(t88_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( r2_pboole(A,k4_pboole(A,B,C),D)
               => r2_pboole(A,B,k2_pboole(A,C,D)) ) ) ) ) ).

fof(t89_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => r2_pboole(A,k4_pboole(A,B,C),k5_pboole(A,B,C)) ) ) ).

fof(t90_pboole,axiom,
    $true ).

fof(t91_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ( r6_pboole(A,k5_pboole(A,B,k1_pboole(A)),B)
        & r6_pboole(A,k5_pboole(A,k1_pboole(A),B),B) ) ) ).

fof(t92_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => r6_pboole(A,k5_pboole(A,B,B),k1_pboole(A)) ) ).

fof(t93_pboole,axiom,
    $true ).

fof(t94_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => r6_pboole(A,k2_pboole(A,B,C),k2_pboole(A,k5_pboole(A,B,C),k3_pboole(A,B,C))) ) ) ).

fof(t95_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => r6_pboole(A,k5_pboole(A,B,C),k4_pboole(A,k2_pboole(A,B,C),k3_pboole(A,B,C))) ) ) ).

fof(t96_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => r6_pboole(A,k4_pboole(A,k5_pboole(A,B,C),D),k2_pboole(A,k4_pboole(A,B,k2_pboole(A,C,D)),k4_pboole(A,C,k2_pboole(A,B,D)))) ) ) ) ).

fof(t97_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => r6_pboole(A,k4_pboole(A,B,k5_pboole(A,C,D)),k2_pboole(A,k4_pboole(A,B,k2_pboole(A,C,D)),k3_pboole(A,k3_pboole(A,B,C),D))) ) ) ) ).

fof(t98_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => r6_pboole(A,k5_pboole(A,k5_pboole(A,B,C),D),k5_pboole(A,B,k5_pboole(A,C,D))) ) ) ) ).

fof(t99_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( ( r2_pboole(A,k4_pboole(A,B,C),D)
                  & r2_pboole(A,k4_pboole(A,C,B),D) )
               => r2_pboole(A,k5_pboole(A,B,C),D) ) ) ) ) ).

fof(t100_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => r6_pboole(A,k2_pboole(A,B,C),k5_pboole(A,B,k4_pboole(A,C,B))) ) ) ).

fof(t101_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => r6_pboole(A,k3_pboole(A,B,C),k5_pboole(A,B,k4_pboole(A,B,C))) ) ) ).

fof(t102_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => r6_pboole(A,k4_pboole(A,B,C),k5_pboole(A,B,k3_pboole(A,B,C))) ) ) ).

fof(t103_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => r6_pboole(A,k4_pboole(A,B,C),k5_pboole(A,C,k2_pboole(A,C,B))) ) ) ).

fof(t104_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => r6_pboole(A,k2_pboole(A,B,C),k5_pboole(A,k5_pboole(A,B,C),k3_pboole(A,B,C))) ) ) ).

fof(t105_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => r6_pboole(A,k3_pboole(A,B,C),k5_pboole(A,k5_pboole(A,B,C),k2_pboole(A,B,C))) ) ) ).

fof(t106_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( ( r4_pboole(A,B,C)
                  | r4_pboole(A,B,D) )
               => r4_pboole(A,B,k2_pboole(A,C,D)) ) ) ) ) ).

fof(t107_pboole,axiom,
    $true ).

fof(t108_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( ( r4_pboole(A,B,C)
                  & r2_pboole(A,C,D) )
               => r4_pboole(A,B,D) ) ) ) ) ).

fof(t109_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( ( r4_pboole(A,B,C)
                  & r2_pboole(A,B,D) )
               => r4_pboole(A,D,C) ) ) ) ) ).

fof(t110_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ! [E] :
                  ( m1_pboole(E,A)
                 => ( ( r2_pboole(A,B,C)
                      & r2_pboole(A,D,E)
                      & r4_pboole(A,B,D) )
                   => r4_pboole(A,C,E) ) ) ) ) ) ).

fof(t111_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( r4_pboole(A,B,k3_pboole(A,C,D))
               => ( r4_pboole(A,B,C)
                  & r4_pboole(A,B,D) ) ) ) ) ) ).

fof(t112_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( ( r4_pboole(A,B,C)
                  & r2_pboole(A,B,D) )
               => r4_pboole(A,B,k3_pboole(A,C,D)) ) ) ) ) ).

fof(t113_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( r4_pboole(A,B,k4_pboole(A,C,D))
               => r4_pboole(A,B,C) ) ) ) ) ).

fof(t114_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ~ ( ~ r4_pboole(A,B,C)
                  & r4_pboole(A,k3_pboole(A,D,B),k3_pboole(A,D,C)) ) ) ) ) ).

fof(t115_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( r4_pboole(A,B,k4_pboole(A,C,D))
               => r4_pboole(A,C,k4_pboole(A,B,D)) ) ) ) ) ).

fof(t116_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ~ ( ~ r5_pboole(A,B,C)
                  & r2_pboole(A,C,D)
                  & r5_pboole(A,B,D) ) ) ) ) ).

fof(t117_pboole,axiom,
    $true ).

fof(t118_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => r5_pboole(A,B,k4_pboole(A,C,B)) ) ) ).

fof(t119_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => r5_pboole(A,k3_pboole(A,B,C),k4_pboole(A,B,C)) ) ) ).

fof(t120_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => r5_pboole(A,k3_pboole(A,B,C),k5_pboole(A,B,C)) ) ) ).

fof(t121_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( r5_pboole(A,B,C)
           => r6_pboole(A,k3_pboole(A,B,C),k1_pboole(A)) ) ) ) ).

fof(t122_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ~ ( B != k1_pboole(A)
          & r5_pboole(A,B,B) ) ) ).

fof(t123_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( ( r2_pboole(A,B,C)
                  & r2_pboole(A,B,D)
                  & r5_pboole(A,C,D) )
               => r6_pboole(A,B,k1_pboole(A)) ) ) ) ) ).

fof(t124_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ! [E] :
                  ( m1_pboole(E,A)
                 => ( ( r6_pboole(A,k2_pboole(A,B,C),k2_pboole(A,D,E))
                      & r5_pboole(A,D,B)
                      & r5_pboole(A,E,C) )
                   => ( r6_pboole(A,D,C)
                      & r6_pboole(A,E,B) ) ) ) ) ) ) ).

fof(t125_pboole,axiom,
    $true ).

fof(t126_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( r5_pboole(A,B,C)
           => r6_pboole(A,k4_pboole(A,B,C),B) ) ) ) ).

fof(t127_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( r5_pboole(A,B,C)
           => r6_pboole(A,k4_pboole(A,k2_pboole(A,B,C),C),B) ) ) ) ).

fof(t128_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( r6_pboole(A,k4_pboole(A,B,C),B)
           => r5_pboole(A,B,C) ) ) ) ).

fof(t129_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => r5_pboole(A,k4_pboole(A,B,C),k4_pboole(A,C,B)) ) ) ).

fof(d14_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( r7_pboole(A,B,C)
          <=> ! [D] :
                ( m1_pboole(D,A)
               => ( r1_pboole(A,D,B)
                 => r1_pboole(A,D,C) ) ) ) ) ) ).

fof(t130_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( r2_pboole(A,B,C)
           => r7_pboole(A,B,C) ) ) ) ).

fof(t131_pboole,axiom,
    $true ).

fof(t132_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( ( r7_pboole(A,B,C)
                  & r7_pboole(A,C,D) )
               => r7_pboole(A,B,D) ) ) ) ) ).

fof(t133_pboole,axiom,
    r1_pboole(k1_xboole_0,k1_pboole(k1_xboole_0),k1_pboole(k1_xboole_0)) ).

fof(t134_pboole,axiom,
    ! [A] :
      ( m1_pboole(A,k1_xboole_0)
     => A = k1_xboole_0 ) ).

fof(t135_pboole,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m1_pboole(B,A)
         => ! [C] :
              ( m1_pboole(C,A)
             => ~ ( r4_pboole(A,B,C)
                  & r5_pboole(A,B,C) ) ) ) ) ).

fof(t136_pboole,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m1_pboole(B,A)
         => ~ r3_pboole(A,B,k1_pboole(A)) ) ) ).

fof(t137_pboole,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m1_pboole(B,A)
         => ! [C] :
              ( m1_pboole(C,A)
             => ! [D] :
                  ( m1_pboole(D,A)
                 => ~ ( r3_pboole(A,B,C)
                      & r3_pboole(A,B,D)
                      & k3_pboole(A,C,D) = k1_pboole(A) ) ) ) ) ) ).

fof(t138_pboole,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m1_pboole(B,A)
         => ( ~ r4_pboole(A,B,k1_pboole(A))
            & ~ r4_pboole(A,k1_pboole(A),B) ) ) ) ).

fof(t139_pboole,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m1_pboole(B,A)
         => ! [C] :
              ( m1_pboole(C,A)
             => ~ ( r6_pboole(A,k3_pboole(A,B,C),k1_pboole(A))
                  & r4_pboole(A,B,C) ) ) ) ) ).

fof(t140_pboole,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m1_pboole(B,A)
         => ~ ( r4_pboole(A,B,B)
              & B = k1_pboole(A) ) ) ) ).

fof(d15_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ( v3_relat_1(B)
      <=> ! [C] :
            ( r2_hidden(C,A)
           => v1_xboole_0(k1_funct_1(B,C)) ) ) ) ).

fof(d16_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ( v2_relat_1(B)
      <=> ! [C] :
            ~ ( r2_hidden(C,A)
              & v1_xboole_0(k1_funct_1(B,C)) ) ) ) ).

fof(t141_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ( v3_relat_1(B)
      <=> r6_pboole(A,B,k1_pboole(A)) ) ) ).

fof(t142_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( ( v3_relat_1(B)
              & r2_pboole(A,C,B) )
           => v3_relat_1(C) ) ) ) ).

fof(t143_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( ( v2_relat_1(B)
              & r2_pboole(A,B,C) )
           => v2_relat_1(C) ) ) ) ).

fof(t144_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( ( v2_relat_1(B)
              & r7_pboole(A,B,C) )
           => r2_pboole(A,B,C) ) ) ) ).

fof(t145_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( ( v2_relat_1(B)
              & r7_pboole(A,B,C) )
           => v2_relat_1(C) ) ) ) ).

fof(t146_pboole,axiom,
    ! [A,B] :
      ( ( v2_relat_1(B)
        & m1_pboole(B,A) )
     => ? [C] :
          ( m1_pboole(C,A)
          & r1_pboole(A,C,B) ) ) ).

fof(t147_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( ( v2_relat_1(C)
            & m1_pboole(C,A) )
         => ( ! [D] :
                ( m1_pboole(D,A)
               => ( r1_pboole(A,D,C)
                <=> r1_pboole(A,D,B) ) )
           => r6_pboole(A,C,B) ) ) ) ).

fof(t148_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( ( v2_relat_1(D)
                & m1_pboole(D,A) )
             => ( ! [E] :
                    ( m1_pboole(E,A)
                   => ( r1_pboole(A,E,D)
                    <=> ( r1_pboole(A,E,B)
                        & r1_pboole(A,E,C) ) ) )
               => r6_pboole(A,D,k3_pboole(A,B,C)) ) ) ) ) ).

fof(t149_pboole,axiom,
    ! [A,B] :
      ( ( v2_relat_1(B)
        & m1_pboole(B,A) )
     => ~ r2_hidden(k1_xboole_0,k2_relat_1(B)) ) ).

fof(t150_pboole,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m1_pboole(B,A)
         => ! [C] :
              ( m1_subset_1(C,k2_relat_1(B))
             => ? [D] :
                  ( r2_hidden(D,A)
                  & C = k1_funct_1(B,D) ) ) ) ) ).

fof(t151_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( r2_hidden(C,A)
         => m1_subset_1(k1_funct_1(B,C),k2_relat_1(B)) ) ) ).

fof(d17_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( m2_pboole(C,A,B)
          <=> ! [D] :
                ( r2_hidden(D,A)
               => m1_subset_1(k1_funct_1(C,D),k1_funct_1(B,D)) ) ) ) ) ).

fof(d18_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( m3_pboole(D,A,B,C)
              <=> ! [E] :
                    ( r2_hidden(E,A)
                   => ( v1_funct_1(k1_funct_1(D,E))
                      & v1_funct_2(k1_funct_1(D,E),k1_funct_1(B,E),k1_funct_1(C,E))
                      & m2_relset_1(k1_funct_1(D,E),k1_funct_1(B,E),k1_funct_1(C,E)) ) ) ) ) ) ) ).

fof(d19_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,k3_finseq_2(A))
         => ( C = k6_pboole(A,B)
          <=> ! [D] :
                ( m2_finseq_2(D,A,k3_finseq_2(A))
               => k1_funct_1(C,D) = k4_card_3(k5_relat_1(D,B)) ) ) ) ) ).

fof(d20_pboole,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,k5_numbers,k3_finseq_2(k1_tarski(A)))
        & m2_relset_1(B,k5_numbers,k3_finseq_2(k1_tarski(A))) )
     => ( B = k9_pboole(A)
      <=> ! [C] :
            ( m2_subset_1(C,k1_numbers,k5_numbers)
           => k8_funct_2(k5_numbers,k3_finseq_2(k1_tarski(A)),B,C) = k2_finseq_2(C,A) ) ) ) ).

fof(t152_pboole,axiom,
    ! [A] :
      ( m2_subset_1(A,k1_numbers,k5_numbers)
     => ! [B,C] : k5_relat_1(k2_finseq_2(A,B),k2_funcop_1(k1_tarski(B),C)) = k2_finseq_2(A,C) ) ).

fof(t153_pboole,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m2_subset_1(B,k1_numbers,k5_numbers)
         => ! [C,D] :
              ( m1_pboole(D,k1_tarski(C))
             => ( D = k2_funcop_1(k1_tarski(C),A)
               => k1_funct_1(k7_pboole(k5_numbers,k3_finseq_2(k1_tarski(C)),k9_pboole(C),k6_pboole(k1_tarski(C),D)),B) = k1_funct_2(k2_finseq_1(B),A) ) ) ) ) ).

fof(d21_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( D = k11_pboole(A,B,C)
              <=> ! [E] :
                    ( r2_hidden(E,A)
                   => k1_funct_1(D,E) = k2_zfmisc_1(k1_funct_1(B,E),k1_funct_1(C,E)) ) ) ) ) ) ).

fof(d22_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ! [D] :
              ( m1_pboole(D,A)
             => ( D = k12_pboole(A,B,C)
              <=> ! [E] :
                    ( r2_hidden(E,A)
                   => k1_funct_1(D,E) = k1_funct_2(k1_funct_1(B,E),k1_funct_1(C,E)) ) ) ) ) ) ).

fof(d23_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m1_pboole(C,A)
         => ( m4_pboole(C,A,B)
          <=> r2_pboole(A,C,B) ) ) ) ).

fof(d24_pboole,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_funcop_1(A) )
     => ! [B] :
          ( ( v1_relat_1(B)
            & v1_funct_1(B)
            & v1_funcop_1(B) )
         => ! [C] :
              ( ( v1_relat_1(C)
                & v1_funct_1(C)
                & v1_funcop_1(C) )
             => ( C = k13_pboole(A,B)
              <=> ( k1_relat_1(C) = k3_xboole_0(k1_relat_1(A),k1_relat_1(B))
                  & ! [D] :
                      ( r2_hidden(D,k1_relat_1(C))
                     => k1_funct_1(C,D) = k5_relat_1(k1_funct_1(A,D),k1_funct_1(B,D)) ) ) ) ) ) ) ).

fof(d25_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( ( v1_funcop_1(C)
            & m1_pboole(C,A) )
         => ! [D] :
              ( m1_pboole(D,A)
             => ( D = k14_pboole(A,B,C)
              <=> ! [E] :
                    ( r2_hidden(E,A)
                   => k1_funct_1(D,E) = k9_relat_1(k1_funct_1(C,E),k1_funct_1(B,E)) ) ) ) ) ) ).

fof(s1_pboole,axiom,
    ( ! [A] :
        ~ ( r2_hidden(A,f1_s1_pboole)
          & f2_s1_pboole(A) = k1_xboole_0 )
   => ? [A] :
        ( m1_pboole(A,f1_s1_pboole)
        & ! [B] :
            ( r2_hidden(B,f1_s1_pboole)
           => r2_hidden(k1_funct_1(A,B),f2_s1_pboole(B)) ) ) ) ).

fof(s2_pboole,axiom,
    ? [A] :
      ( m1_pboole(A,f1_s2_pboole)
      & ! [B] :
          ( r2_hidden(B,f1_s2_pboole)
         => ! [C] :
              ( r2_hidden(C,k1_funct_1(A,B))
            <=> ( r2_hidden(C,k1_funct_1(f2_s2_pboole,B))
                & p1_s2_pboole(B,C) ) ) ) ) ).

fof(s3_pboole,axiom,
    ( ! [A] :
        ~ ( r2_hidden(A,f1_s3_pboole)
          & ! [B] : ~ p1_s3_pboole(A,B) )
   => ? [A] :
        ( m1_pboole(A,f1_s3_pboole)
        & ! [B] :
            ( r2_hidden(B,f1_s3_pboole)
           => p1_s3_pboole(B,k1_funct_1(A,B)) ) ) ) ).

fof(s4_pboole,axiom,
    ? [A] :
      ( m1_pboole(A,f1_s4_pboole)
      & ! [B] :
          ( r2_hidden(B,f1_s4_pboole)
         => k1_funct_1(A,B) = f2_s4_pboole(B) ) ) ).

fof(s5_pboole,axiom,
    ? [A] :
      ( m1_pboole(A,f1_s5_pboole)
      & ! [B] :
          ( m1_subset_1(B,f1_s5_pboole)
         => k1_funct_1(A,B) = f2_s5_pboole(B) ) ) ).

fof(dt_m1_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ( v1_relat_1(B)
        & v1_funct_1(B) ) ) ).

fof(existence_m1_pboole,axiom,
    ! [A] :
    ? [B] : m1_pboole(B,A) ).

fof(dt_m2_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m2_pboole(C,A,B)
         => m1_pboole(C,A) ) ) ).

fof(existence_m2_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ? [C] : m2_pboole(C,A,B) ) ).

fof(dt_m3_pboole,axiom,
    ! [A,B,C] :
      ( ( m1_pboole(B,A)
        & m1_pboole(C,A) )
     => ! [D] :
          ( m3_pboole(D,A,B,C)
         => m1_pboole(D,A) ) ) ).

fof(existence_m3_pboole,axiom,
    ! [A,B,C] :
      ( ( m1_pboole(B,A)
        & m1_pboole(C,A) )
     => ? [D] : m3_pboole(D,A,B,C) ) ).

fof(dt_m4_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ! [C] :
          ( m4_pboole(C,A,B)
         => m1_pboole(C,A) ) ) ).

fof(existence_m4_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ? [C] : m4_pboole(C,A,B) ) ).

fof(redefinition_v1_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ( v1_pboole(B,A)
      <=> v3_relat_1(B) ) ) ).

fof(redefinition_v2_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => ( v2_pboole(B,A)
      <=> v2_relat_1(B) ) ) ).

fof(reflexivity_r2_pboole,axiom,
    ! [A,B,C] :
      ( ( m1_pboole(B,A)
        & m1_pboole(C,A) )
     => r2_pboole(A,B,B) ) ).

fof(antisymmetry_r3_pboole,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & m1_pboole(B,A)
        & m1_pboole(C,A) )
     => ( r3_pboole(A,B,C)
       => ~ r3_pboole(A,C,B) ) ) ).

fof(redefinition_r3_pboole,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & m1_pboole(B,A)
        & m1_pboole(C,A) )
     => ( r3_pboole(A,B,C)
      <=> r1_pboole(A,B,C) ) ) ).

fof(symmetry_r4_pboole,axiom,
    ! [A,B,C] :
      ( ( m1_pboole(B,A)
        & m1_pboole(C,A) )
     => ( r4_pboole(A,B,C)
       => r4_pboole(A,C,B) ) ) ).

fof(symmetry_r5_pboole,axiom,
    ! [A,B,C] :
      ( ( m1_pboole(B,A)
        & m1_pboole(C,A) )
     => ( r5_pboole(A,B,C)
       => r5_pboole(A,C,B) ) ) ).

fof(symmetry_r6_pboole,axiom,
    ! [A,B,C] :
      ( ( m1_pboole(B,A)
        & m1_pboole(C,A) )
     => ( r6_pboole(A,B,C)
       => r6_pboole(A,C,B) ) ) ).

fof(reflexivity_r6_pboole,axiom,
    ! [A,B,C] :
      ( ( m1_pboole(B,A)
        & m1_pboole(C,A) )
     => r6_pboole(A,B,B) ) ).

fof(redefinition_r6_pboole,axiom,
    ! [A,B,C] :
      ( ( m1_pboole(B,A)
        & m1_pboole(C,A) )
     => ( r6_pboole(A,B,C)
      <=> B = C ) ) ).

fof(reflexivity_r7_pboole,axiom,
    ! [A,B,C] :
      ( ( m1_pboole(B,A)
        & m1_pboole(C,A) )
     => r7_pboole(A,B,B) ) ).

fof(dt_k1_pboole,axiom,
    ! [A] : m1_pboole(k1_pboole(A),A) ).

fof(dt_k2_pboole,axiom,
    ! [A,B,C] :
      ( ( m1_pboole(B,A)
        & m1_pboole(C,A) )
     => m1_pboole(k2_pboole(A,B,C),A) ) ).

fof(commutativity_k2_pboole,axiom,
    ! [A,B,C] :
      ( ( m1_pboole(B,A)
        & m1_pboole(C,A) )
     => k2_pboole(A,B,C) = k2_pboole(A,C,B) ) ).

fof(idempotence_k2_pboole,axiom,
    ! [A,B,C] :
      ( ( m1_pboole(B,A)
        & m1_pboole(C,A) )
     => k2_pboole(A,B,B) = B ) ).

fof(dt_k3_pboole,axiom,
    ! [A,B,C] :
      ( ( m1_pboole(B,A)
        & m1_pboole(C,A) )
     => m1_pboole(k3_pboole(A,B,C),A) ) ).

fof(commutativity_k3_pboole,axiom,
    ! [A,B,C] :
      ( ( m1_pboole(B,A)
        & m1_pboole(C,A) )
     => k3_pboole(A,B,C) = k3_pboole(A,C,B) ) ).

fof(idempotence_k3_pboole,axiom,
    ! [A,B,C] :
      ( ( m1_pboole(B,A)
        & m1_pboole(C,A) )
     => k3_pboole(A,B,B) = B ) ).

fof(dt_k4_pboole,axiom,
    ! [A,B,C] :
      ( ( m1_pboole(B,A)
        & m1_pboole(C,A) )
     => m1_pboole(k4_pboole(A,B,C),A) ) ).

fof(dt_k5_pboole,axiom,
    ! [A,B,C] :
      ( ( m1_pboole(B,A)
        & m1_pboole(C,A) )
     => m1_pboole(k5_pboole(A,B,C),A) ) ).

fof(commutativity_k5_pboole,axiom,
    ! [A,B,C] :
      ( ( m1_pboole(B,A)
        & m1_pboole(C,A) )
     => k5_pboole(A,B,C) = k5_pboole(A,C,B) ) ).

fof(dt_k6_pboole,axiom,
    ! [A,B] :
      ( m1_pboole(B,A)
     => m1_pboole(k6_pboole(A,B),k3_finseq_2(A)) ) ).

fof(dt_k7_pboole,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(B)
        & v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m1_relset_1(C,A,B)
        & m1_pboole(D,B) )
     => m1_pboole(k7_pboole(A,B,C,D),A) ) ).

fof(redefinition_k7_pboole,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(B)
        & v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m1_relset_1(C,A,B)
        & m1_pboole(D,B) )
     => k7_pboole(A,B,C,D) = k5_relat_1(C,D) ) ).

fof(dt_k8_pboole,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(B)
        & v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m1_relset_1(C,A,B)
        & v2_relat_1(D)
        & m1_pboole(D,B) )
     => ( v2_relat_1(k8_pboole(A,B,C,D))
        & m1_pboole(k8_pboole(A,B,C,D),A) ) ) ).

fof(redefinition_k8_pboole,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(B)
        & v1_funct_1(C)
        & v1_funct_2(C,A,B)
        & m1_relset_1(C,A,B)
        & v2_relat_1(D)
        & m1_pboole(D,B) )
     => k8_pboole(A,B,C,D) = k5_relat_1(C,D) ) ).

fof(dt_k9_pboole,axiom,
    ! [A] :
      ( v1_funct_1(k9_pboole(A))
      & v1_funct_2(k9_pboole(A),k5_numbers,k3_finseq_2(k1_tarski(A)))
      & m2_relset_1(k9_pboole(A),k5_numbers,k3_finseq_2(k1_tarski(A))) ) ).

fof(dt_k10_pboole,axiom,
    ! [A,B] :
      ( v1_funct_1(k10_pboole(A,B))
      & v1_funct_2(k10_pboole(A,B),A,k1_tarski(B))
      & m2_relset_1(k10_pboole(A,B),A,k1_tarski(B)) ) ).

fof(redefinition_k10_pboole,axiom,
    ! [A,B] : k10_pboole(A,B) = k2_funcop_1(A,B) ).

fof(dt_k11_pboole,axiom,
    ! [A,B,C] :
      ( ( m1_pboole(B,A)
        & m1_pboole(C,A) )
     => m1_pboole(k11_pboole(A,B,C),A) ) ).

fof(dt_k12_pboole,axiom,
    ! [A,B,C] :
      ( ( m1_pboole(B,A)
        & m1_pboole(C,A) )
     => m1_pboole(k12_pboole(A,B,C),A) ) ).

fof(dt_k13_pboole,axiom,
    ! [A,B] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_funcop_1(A)
        & v1_relat_1(B)
        & v1_funct_1(B)
        & v1_funcop_1(B) )
     => ( v1_relat_1(k13_pboole(A,B))
        & v1_funct_1(k13_pboole(A,B))
        & v1_funcop_1(k13_pboole(A,B)) ) ) ).

fof(dt_k14_pboole,axiom,
    ! [A,B,C] :
      ( ( m1_pboole(B,A)
        & v1_funcop_1(C)
        & m1_pboole(C,A) )
     => m1_pboole(k14_pboole(A,B,C),A) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(rc1_struct_0,axiom,
    ? [A] :
      ( l1_struct_0(A)
      & v1_struct_0(A) ) ).

fof(rc2_struct_0,axiom,
    ? [A] :
      ( l2_struct_0(A)
      & v2_struct_0(A) ) ).

fof(rc3_struct_0,axiom,
    ? [A] :
      ( l1_struct_0(A)
      & ~ v3_struct_0(A) ) ).

fof(rc4_struct_0,axiom,
    ? [A] :
      ( l2_struct_0(A)
      & ~ v3_struct_0(A) ) ).

fof(fc1_struct_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_struct_0(A) )
     => ~ v1_xboole_0(u1_struct_0(A)) ) ).

fof(rc5_struct_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_struct_0(A) )
     => ? [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
          & ~ v1_xboole_0(B) ) ) ).

fof(d1_struct_0,axiom,
    ! [A] :
      ( l1_struct_0(A)
     => ( v3_struct_0(A)
      <=> v1_xboole_0(u1_struct_0(A)) ) ) ).

fof(dt_m1_struct_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & l1_struct_0(A)
        & ~ v1_xboole_0(B)
        & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
     => ! [C] :
          ( m1_struct_0(C,A,B)
         => m1_subset_1(C,u1_struct_0(A)) ) ) ).

fof(existence_m1_struct_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & l1_struct_0(A)
        & ~ v1_xboole_0(B)
        & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
     => ? [C] : m1_struct_0(C,A,B) ) ).

fof(redefinition_m1_struct_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & l1_struct_0(A)
        & ~ v1_xboole_0(B)
        & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
     => ! [C] :
          ( m1_struct_0(C,A,B)
        <=> m1_subset_1(C,B) ) ) ).

fof(dt_l1_struct_0,axiom,
    $true ).

fof(existence_l1_struct_0,axiom,
    ? [A] : l1_struct_0(A) ).

fof(dt_l2_struct_0,axiom,
    ! [A] :
      ( l2_struct_0(A)
     => l1_struct_0(A) ) ).

fof(existence_l2_struct_0,axiom,
    ? [A] : l2_struct_0(A) ).

fof(abstractness_v1_struct_0,axiom,
    ! [A] :
      ( l1_struct_0(A)
     => ( v1_struct_0(A)
       => A = g1_struct_0(u1_struct_0(A)) ) ) ).

fof(abstractness_v2_struct_0,axiom,
    ! [A] :
      ( l2_struct_0(A)
     => ( v2_struct_0(A)
       => A = g2_struct_0(u1_struct_0(A),u2_struct_0(A)) ) ) ).

fof(dt_k1_struct_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & l1_struct_0(A)
        & m1_subset_1(B,u1_struct_0(A)) )
     => m1_subset_1(k1_struct_0(A,B),k1_zfmisc_1(u1_struct_0(A))) ) ).

fof(redefinition_k1_struct_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & l1_struct_0(A)
        & m1_subset_1(B,u1_struct_0(A)) )
     => k1_struct_0(A,B) = k1_tarski(B) ) ).

fof(dt_k2_struct_0,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(A)
        & l1_struct_0(A)
        & m1_subset_1(B,u1_struct_0(A))
        & m1_subset_1(C,u1_struct_0(A)) )
     => m1_subset_1(k2_struct_0(A,B,C),k1_zfmisc_1(u1_struct_0(A))) ) ).

fof(commutativity_k2_struct_0,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(A)
        & l1_struct_0(A)
        & m1_subset_1(B,u1_struct_0(A))
        & m1_subset_1(C,u1_struct_0(A)) )
     => k2_struct_0(A,B,C) = k2_struct_0(A,C,B) ) ).

fof(redefinition_k2_struct_0,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(A)
        & l1_struct_0(A)
        & m1_subset_1(B,u1_struct_0(A))
        & m1_subset_1(C,u1_struct_0(A)) )
     => k2_struct_0(A,B,C) = k2_tarski(B,C) ) ).

fof(dt_u1_struct_0,axiom,
    $true ).

fof(dt_u2_struct_0,axiom,
    ! [A] :
      ( l2_struct_0(A)
     => m1_subset_1(u2_struct_0(A),u1_struct_0(A)) ) ).

fof(dt_g1_struct_0,axiom,
    ! [A] :
      ( v1_struct_0(g1_struct_0(A))
      & l1_struct_0(g1_struct_0(A)) ) ).

fof(free_g1_struct_0,axiom,
    ! [A,B] :
      ( g1_struct_0(A) = g1_struct_0(B)
     => A = B ) ).

fof(dt_g2_struct_0,axiom,
    ! [A,B] :
      ( m1_subset_1(B,A)
     => ( v2_struct_0(g2_struct_0(A,B))
        & l2_struct_0(g2_struct_0(A,B)) ) ) ).

fof(free_g2_struct_0,axiom,
    ! [A,B] :
      ( m1_subset_1(B,A)
     => ! [C,D] :
          ( g2_struct_0(A,B) = g2_struct_0(C,D)
         => ( A = C
            & B = D ) ) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(rc1_lattices,axiom,
    ? [A] :
      ( l1_lattices(A)
      & v1_lattices(A) ) ).

fof(rc2_lattices,axiom,
    ? [A] :
      ( l2_lattices(A)
      & v2_lattices(A) ) ).

fof(rc3_lattices,axiom,
    ? [A] :
      ( l3_lattices(A)
      & v3_lattices(A) ) ).

fof(fc1_lattices,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & v1_funct_1(B)
        & v1_funct_2(B,k2_zfmisc_1(A,A),A)
        & m1_relset_1(B,k2_zfmisc_1(A,A),A) )
     => ( ~ v3_struct_0(g2_lattices(A,B))
        & v2_lattices(g2_lattices(A,B)) ) ) ).

fof(fc2_lattices,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & v1_funct_1(B)
        & v1_funct_2(B,k2_zfmisc_1(A,A),A)
        & m1_relset_1(B,k2_zfmisc_1(A,A),A) )
     => ( ~ v3_struct_0(g1_lattices(A,B))
        & v1_lattices(g1_lattices(A,B)) ) ) ).

fof(fc3_lattices,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & v1_funct_1(B)
        & v1_funct_2(B,k2_zfmisc_1(A,A),A)
        & m1_relset_1(B,k2_zfmisc_1(A,A),A)
        & v1_funct_1(C)
        & v1_funct_2(C,k2_zfmisc_1(A,A),A)
        & m1_relset_1(C,k2_zfmisc_1(A,A),A) )
     => ( ~ v3_struct_0(g3_lattices(A,B,C))
        & v3_lattices(g3_lattices(A,B,C)) ) ) ).

fof(rc4_lattices,axiom,
    ? [A] :
      ( l2_lattices(A)
      & ~ v3_struct_0(A)
      & v2_lattices(A) ) ).

fof(rc5_lattices,axiom,
    ? [A] :
      ( l1_lattices(A)
      & ~ v3_struct_0(A)
      & v1_lattices(A) ) ).

fof(rc6_lattices,axiom,
    ? [A] :
      ( l3_lattices(A)
      & ~ v3_struct_0(A)
      & v3_lattices(A) ) ).

fof(cc1_lattices,axiom,
    ! [A] :
      ( l3_lattices(A)
     => ( ( ~ v3_struct_0(A)
          & v10_lattices(A) )
       => ( ~ v3_struct_0(A)
          & v4_lattices(A)
          & v5_lattices(A)
          & v6_lattices(A)
          & v7_lattices(A)
          & v8_lattices(A)
          & v9_lattices(A) ) ) ) ).

fof(cc2_lattices,axiom,
    ! [A] :
      ( l3_lattices(A)
     => ( ( ~ v3_struct_0(A)
          & v4_lattices(A)
          & v5_lattices(A)
          & v6_lattices(A)
          & v7_lattices(A)
          & v8_lattices(A)
          & v9_lattices(A) )
       => ( ~ v3_struct_0(A)
          & v10_lattices(A) ) ) ) ).

fof(rc7_lattices,axiom,
    ? [A] :
      ( l2_lattices(A)
      & ~ v3_struct_0(A)
      & v2_lattices(A)
      & v4_lattices(A)
      & v5_lattices(A) ) ).

fof(rc8_lattices,axiom,
    ? [A] :
      ( l1_lattices(A)
      & ~ v3_struct_0(A)
      & v1_lattices(A)
      & v6_lattices(A)
      & v7_lattices(A) ) ).

fof(rc9_lattices,axiom,
    ? [A] :
      ( l3_lattices(A)
      & ~ v3_struct_0(A)
      & v3_lattices(A)
      & v4_lattices(A)
      & v5_lattices(A)
      & v6_lattices(A)
      & v7_lattices(A)
      & v8_lattices(A)
      & v9_lattices(A)
      & v10_lattices(A) ) ).

fof(rc10_lattices,axiom,
    ? [A] :
      ( l3_lattices(A)
      & ~ v3_struct_0(A)
      & v3_lattices(A)
      & v4_lattices(A)
      & v5_lattices(A)
      & v6_lattices(A)
      & v7_lattices(A)
      & v8_lattices(A)
      & v9_lattices(A)
      & v10_lattices(A)
      & v11_lattices(A)
      & v12_lattices(A)
      & v13_lattices(A)
      & v14_lattices(A) ) ).

fof(cc3_lattices,axiom,
    ! [A] :
      ( l3_lattices(A)
     => ( ( ~ v3_struct_0(A)
          & v13_lattices(A)
          & v14_lattices(A) )
       => ( ~ v3_struct_0(A)
          & v15_lattices(A) ) ) ) ).

fof(cc4_lattices,axiom,
    ! [A] :
      ( l3_lattices(A)
     => ( ( ~ v3_struct_0(A)
          & v15_lattices(A) )
       => ( ~ v3_struct_0(A)
          & v13_lattices(A)
          & v14_lattices(A) ) ) ) ).

fof(rc11_lattices,axiom,
    ? [A] :
      ( l3_lattices(A)
      & ~ v3_struct_0(A)
      & v3_lattices(A)
      & v4_lattices(A)
      & v5_lattices(A)
      & v6_lattices(A)
      & v7_lattices(A)
      & v8_lattices(A)
      & v9_lattices(A)
      & v10_lattices(A)
      & v13_lattices(A)
      & v14_lattices(A)
      & v15_lattices(A) ) ).

fof(rc12_lattices,axiom,
    ? [A] :
      ( l3_lattices(A)
      & ~ v3_struct_0(A)
      & v3_lattices(A)
      & v4_lattices(A)
      & v5_lattices(A)
      & v6_lattices(A)
      & v7_lattices(A)
      & v8_lattices(A)
      & v9_lattices(A)
      & v10_lattices(A)
      & v13_lattices(A)
      & v14_lattices(A)
      & v15_lattices(A)
      & v16_lattices(A) ) ).

fof(cc5_lattices,axiom,
    ! [A] :
      ( l3_lattices(A)
     => ( ( ~ v3_struct_0(A)
          & v17_lattices(A) )
       => ( ~ v3_struct_0(A)
          & v11_lattices(A)
          & v13_lattices(A)
          & v14_lattices(A)
          & v15_lattices(A)
          & v16_lattices(A) ) ) ) ).

fof(cc6_lattices,axiom,
    ! [A] :
      ( l3_lattices(A)
     => ( ( ~ v3_struct_0(A)
          & v11_lattices(A)
          & v15_lattices(A)
          & v16_lattices(A) )
       => ( ~ v3_struct_0(A)
          & v17_lattices(A) ) ) ) ).

fof(rc13_lattices,axiom,
    ? [A] :
      ( l3_lattices(A)
      & ~ v3_struct_0(A)
      & v3_lattices(A)
      & v4_lattices(A)
      & v5_lattices(A)
      & v6_lattices(A)
      & v7_lattices(A)
      & v8_lattices(A)
      & v9_lattices(A)
      & v10_lattices(A)
      & v11_lattices(A)
      & v13_lattices(A)
      & v14_lattices(A)
      & v15_lattices(A)
      & v16_lattices(A)
      & v17_lattices(A) ) ).

fof(cc7_lattices,axiom,
    ! [A] :
      ( l3_lattices(A)
     => ( ( ~ v3_struct_0(A)
          & v10_lattices(A)
          & v11_lattices(A) )
       => ( ~ v3_struct_0(A)
          & v4_lattices(A)
          & v5_lattices(A)
          & v6_lattices(A)
          & v7_lattices(A)
          & v8_lattices(A)
          & v9_lattices(A)
          & v10_lattices(A)
          & v12_lattices(A) ) ) ) ).

fof(d1_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l2_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => k1_lattices(A,B,C) = k2_binop_1(u1_struct_0(A),u1_struct_0(A),u1_struct_0(A),u2_lattices(A),B,C) ) ) ) ).

fof(d2_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => k2_lattices(A,B,C) = k2_binop_1(u1_struct_0(A),u1_struct_0(A),u1_struct_0(A),u1_lattices(A),B,C) ) ) ) ).

fof(d3_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l2_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( r1_lattices(A,B,C)
              <=> k1_lattices(A,B,C) = C ) ) ) ) ).

fof(d4_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l2_lattices(A) )
     => ( v4_lattices(A)
      <=> ! [B] :
            ( m1_subset_1(B,u1_struct_0(A))
           => ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => k1_lattices(A,B,C) = k1_lattices(A,C,B) ) ) ) ) ).

fof(d5_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l2_lattices(A) )
     => ( v5_lattices(A)
      <=> ! [B] :
            ( m1_subset_1(B,u1_struct_0(A))
           => ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => k1_lattices(A,B,k1_lattices(A,C,D)) = k1_lattices(A,k1_lattices(A,B,C),D) ) ) ) ) ) ).

fof(d6_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_lattices(A) )
     => ( v6_lattices(A)
      <=> ! [B] :
            ( m1_subset_1(B,u1_struct_0(A))
           => ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => k2_lattices(A,B,C) = k2_lattices(A,C,B) ) ) ) ) ).

fof(d7_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_lattices(A) )
     => ( v7_lattices(A)
      <=> ! [B] :
            ( m1_subset_1(B,u1_struct_0(A))
           => ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => k2_lattices(A,B,k2_lattices(A,C,D)) = k2_lattices(A,k2_lattices(A,B,C),D) ) ) ) ) ) ).

fof(d8_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l3_lattices(A) )
     => ( v8_lattices(A)
      <=> ! [B] :
            ( m1_subset_1(B,u1_struct_0(A))
           => ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => k1_lattices(A,k2_lattices(A,B,C),C) = C ) ) ) ) ).

fof(d9_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l3_lattices(A) )
     => ( v9_lattices(A)
      <=> ! [B] :
            ( m1_subset_1(B,u1_struct_0(A))
           => ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => k2_lattices(A,B,k1_lattices(A,B,C)) = B ) ) ) ) ).

fof(d10_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l3_lattices(A) )
     => ( v10_lattices(A)
      <=> ( v4_lattices(A)
          & v5_lattices(A)
          & v8_lattices(A)
          & v6_lattices(A)
          & v7_lattices(A)
          & v9_lattices(A) ) ) ) ).

fof(d11_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l3_lattices(A) )
     => ( v11_lattices(A)
      <=> ! [B] :
            ( m1_subset_1(B,u1_struct_0(A))
           => ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => k2_lattices(A,B,k1_lattices(A,C,D)) = k1_lattices(A,k2_lattices(A,B,C),k2_lattices(A,B,D)) ) ) ) ) ) ).

fof(d12_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l3_lattices(A) )
     => ( v12_lattices(A)
      <=> ! [B] :
            ( m1_subset_1(B,u1_struct_0(A))
           => ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => ( r1_lattices(A,B,D)
                     => k1_lattices(A,B,k2_lattices(A,C,D)) = k2_lattices(A,k1_lattices(A,B,C),D) ) ) ) ) ) ) ).

fof(d13_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_lattices(A) )
     => ( v13_lattices(A)
      <=> ? [B] :
            ( m1_subset_1(B,u1_struct_0(A))
            & ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ( k2_lattices(A,B,C) = B
                  & k2_lattices(A,C,B) = B ) ) ) ) ) ).

fof(d14_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l2_lattices(A) )
     => ( v14_lattices(A)
      <=> ? [B] :
            ( m1_subset_1(B,u1_struct_0(A))
            & ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ( k1_lattices(A,B,C) = B
                  & k1_lattices(A,C,B) = B ) ) ) ) ) ).

fof(d15_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l3_lattices(A) )
     => ( v15_lattices(A)
      <=> ( v13_lattices(A)
          & v14_lattices(A) ) ) ) ).

fof(d16_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_lattices(A) )
     => ( v13_lattices(A)
       => ! [B] :
            ( m1_subset_1(B,u1_struct_0(A))
           => ( B = k5_lattices(A)
            <=> ! [C] :
                  ( m1_subset_1(C,u1_struct_0(A))
                 => ( k2_lattices(A,B,C) = B
                    & k2_lattices(A,C,B) = B ) ) ) ) ) ) ).

fof(d17_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l2_lattices(A) )
     => ( v14_lattices(A)
       => ! [B] :
            ( m1_subset_1(B,u1_struct_0(A))
           => ( B = k6_lattices(A)
            <=> ! [C] :
                  ( m1_subset_1(C,u1_struct_0(A))
                 => ( k1_lattices(A,B,C) = B
                    & k1_lattices(A,C,B) = B ) ) ) ) ) ) ).

fof(d18_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( r2_lattices(A,B,C)
              <=> ( k1_lattices(A,B,C) = k6_lattices(A)
                  & k1_lattices(A,C,B) = k6_lattices(A)
                  & k2_lattices(A,B,C) = k5_lattices(A)
                  & k2_lattices(A,C,B) = k5_lattices(A) ) ) ) ) ) ).

fof(d19_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l3_lattices(A) )
     => ( v16_lattices(A)
      <=> ! [B] :
            ( m1_subset_1(B,u1_struct_0(A))
           => ? [C] :
                ( m1_subset_1(C,u1_struct_0(A))
                & r2_lattices(A,C,B) ) ) ) ) ).

fof(d20_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l3_lattices(A) )
     => ( v17_lattices(A)
      <=> ( v15_lattices(A)
          & v16_lattices(A)
          & v11_lattices(A) ) ) ) ).

fof(t1_lattices,axiom,
    $true ).

fof(t2_lattices,axiom,
    $true ).

fof(t3_lattices,axiom,
    $true ).

fof(t4_lattices,axiom,
    $true ).

fof(t5_lattices,axiom,
    $true ).

fof(t6_lattices,axiom,
    $true ).

fof(t7_lattices,axiom,
    $true ).

fof(t8_lattices,axiom,
    $true ).

fof(t9_lattices,axiom,
    $true ).

fof(t10_lattices,axiom,
    $true ).

fof(t11_lattices,axiom,
    $true ).

fof(t12_lattices,axiom,
    $true ).

fof(t13_lattices,axiom,
    $true ).

fof(t14_lattices,axiom,
    $true ).

fof(t15_lattices,axiom,
    $true ).

fof(t16_lattices,axiom,
    $true ).

fof(t17_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v6_lattices(A)
        & v8_lattices(A)
        & v9_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => k1_lattices(A,B,B) = B ) ) ).

fof(t18_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v6_lattices(A)
        & v8_lattices(A)
        & v9_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => k4_lattices(A,B,B) = B ) ) ).

fof(t19_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ( ! [B] :
            ( m1_subset_1(B,u1_struct_0(A))
           => ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => k4_lattices(A,B,k3_lattices(A,C,D)) = k3_lattices(A,k4_lattices(A,B,C),k4_lattices(A,B,D)) ) ) )
      <=> ! [B] :
            ( m1_subset_1(B,u1_struct_0(A))
           => ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => k3_lattices(A,B,k4_lattices(A,C,D)) = k4_lattices(A,k3_lattices(A,B,C),k3_lattices(A,B,D)) ) ) ) ) ) ).

fof(t20_lattices,axiom,
    $true ).

fof(t21_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v8_lattices(A)
        & v9_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( r1_lattices(A,B,C)
              <=> k2_lattices(A,B,C) = B ) ) ) ) ).

fof(t22_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v5_lattices(A)
        & v6_lattices(A)
        & v8_lattices(A)
        & v9_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => r1_lattices(A,B,k1_lattices(A,B,C)) ) ) ) ).

fof(t23_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v6_lattices(A)
        & v8_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => r1_lattices(A,k4_lattices(A,B,C),B) ) ) ) ).

fof(t24_lattices,axiom,
    $true ).

fof(t25_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v5_lattices(A)
        & l2_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ( ( r1_lattices(A,B,C)
                      & r1_lattices(A,C,D) )
                   => r1_lattices(A,B,D) ) ) ) ) ) ).

fof(t26_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v4_lattices(A)
        & l2_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( ( r1_lattices(A,B,C)
                  & r1_lattices(A,C,B) )
               => B = C ) ) ) ) ).

fof(t27_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v7_lattices(A)
        & v8_lattices(A)
        & v9_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ( r1_lattices(A,B,C)
                   => r1_lattices(A,k2_lattices(A,B,D),k2_lattices(A,C,D)) ) ) ) ) ) ).

fof(t28_lattices,axiom,
    $true ).

fof(t29_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ( ! [B] :
            ( m1_subset_1(B,u1_struct_0(A))
           => ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => k3_lattices(A,k3_lattices(A,k4_lattices(A,B,C),k4_lattices(A,C,D)),k4_lattices(A,D,B)) = k4_lattices(A,k4_lattices(A,k3_lattices(A,B,C),k3_lattices(A,C,D)),k3_lattices(A,D,B)) ) ) )
       => v11_lattices(A) ) ) ).

fof(t30_lattices,axiom,
    $true ).

fof(t31_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v11_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => k3_lattices(A,B,k4_lattices(A,C,D)) = k4_lattices(A,k3_lattices(A,B,C),k3_lattices(A,B,D)) ) ) ) ) ).

fof(t32_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v11_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ( ( k4_lattices(A,B,C) = k4_lattices(A,B,D)
                      & k3_lattices(A,B,C) = k3_lattices(A,B,D) )
                   => C = D ) ) ) ) ) ).

fof(t33_lattices,axiom,
    $true ).

fof(t34_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v11_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => k4_lattices(A,k4_lattices(A,k3_lattices(A,B,C),k3_lattices(A,C,D)),k3_lattices(A,D,B)) = k3_lattices(A,k3_lattices(A,k4_lattices(A,B,C),k4_lattices(A,C,D)),k4_lattices(A,D,B)) ) ) ) ) ).

fof(t35_lattices,axiom,
    $true ).

fof(t36_lattices,axiom,
    $true ).

fof(t37_lattices,axiom,
    $true ).

fof(t38_lattices,axiom,
    $true ).

fof(t39_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v13_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => k3_lattices(A,k5_lattices(A),B) = B ) ) ).

fof(t40_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v13_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => k4_lattices(A,k5_lattices(A),B) = k5_lattices(A) ) ) ).

fof(t41_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v13_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => r3_lattices(A,k5_lattices(A),B) ) ) ).

fof(t42_lattices,axiom,
    $true ).

fof(t43_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v14_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => k4_lattices(A,k6_lattices(A),B) = B ) ) ).

fof(t44_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v14_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => k3_lattices(A,k6_lattices(A),B) = k6_lattices(A) ) ) ).

fof(t45_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v14_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => r3_lattices(A,B,k6_lattices(A)) ) ) ).

fof(d21_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ( ( ~ v3_struct_0(A)
              & v10_lattices(A)
              & v11_lattices(A)
              & v16_lattices(A)
              & l3_lattices(A) )
           => ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ( C = k7_lattices(A,B)
                <=> r2_lattices(A,C,B) ) ) ) ) ) ).

fof(t46_lattices,axiom,
    $true ).

fof(t47_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v17_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => k4_lattices(A,k7_lattices(A,B),B) = k5_lattices(A) ) ) ).

fof(t48_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v17_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => k3_lattices(A,k7_lattices(A,B),B) = k6_lattices(A) ) ) ).

fof(t49_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v17_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => k7_lattices(A,k7_lattices(A,B)) = B ) ) ).

fof(t50_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v17_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => k7_lattices(A,k4_lattices(A,B,C)) = k3_lattices(A,k7_lattices(A,B),k7_lattices(A,C)) ) ) ) ).

fof(t51_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v17_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => k7_lattices(A,k3_lattices(A,B,C)) = k4_lattices(A,k7_lattices(A,B),k7_lattices(A,C)) ) ) ) ).

fof(t52_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v17_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( k4_lattices(A,B,C) = k5_lattices(A)
              <=> r3_lattices(A,B,k7_lattices(A,C)) ) ) ) ) ).

fof(t53_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v17_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( r3_lattices(A,B,C)
               => r3_lattices(A,k7_lattices(A,C),k7_lattices(A,B)) ) ) ) ) ).

fof(dt_l1_lattices,axiom,
    ! [A] :
      ( l1_lattices(A)
     => l1_struct_0(A) ) ).

fof(existence_l1_lattices,axiom,
    ? [A] : l1_lattices(A) ).

fof(dt_l2_lattices,axiom,
    ! [A] :
      ( l2_lattices(A)
     => l1_struct_0(A) ) ).

fof(existence_l2_lattices,axiom,
    ? [A] : l2_lattices(A) ).

fof(dt_l3_lattices,axiom,
    ! [A] :
      ( l3_lattices(A)
     => ( l1_lattices(A)
        & l2_lattices(A) ) ) ).

fof(existence_l3_lattices,axiom,
    ? [A] : l3_lattices(A) ).

fof(abstractness_v1_lattices,axiom,
    ! [A] :
      ( l1_lattices(A)
     => ( v1_lattices(A)
       => A = g1_lattices(u1_struct_0(A),u1_lattices(A)) ) ) ).

fof(abstractness_v2_lattices,axiom,
    ! [A] :
      ( l2_lattices(A)
     => ( v2_lattices(A)
       => A = g2_lattices(u1_struct_0(A),u2_lattices(A)) ) ) ).

fof(abstractness_v3_lattices,axiom,
    ! [A] :
      ( l3_lattices(A)
     => ( v3_lattices(A)
       => A = g3_lattices(u1_struct_0(A),u2_lattices(A),u1_lattices(A)) ) ) ).

fof(reflexivity_r3_lattices,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(A)
        & v6_lattices(A)
        & v8_lattices(A)
        & v9_lattices(A)
        & l3_lattices(A)
        & m1_subset_1(B,u1_struct_0(A))
        & m1_subset_1(C,u1_struct_0(A)) )
     => r3_lattices(A,B,B) ) ).

fof(redefinition_r3_lattices,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(A)
        & v6_lattices(A)
        & v8_lattices(A)
        & v9_lattices(A)
        & l3_lattices(A)
        & m1_subset_1(B,u1_struct_0(A))
        & m1_subset_1(C,u1_struct_0(A)) )
     => ( r3_lattices(A,B,C)
      <=> r1_lattices(A,B,C) ) ) ).

fof(dt_k1_lattices,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(A)
        & l2_lattices(A)
        & m1_subset_1(B,u1_struct_0(A))
        & m1_subset_1(C,u1_struct_0(A)) )
     => m1_subset_1(k1_lattices(A,B,C),u1_struct_0(A)) ) ).

fof(dt_k2_lattices,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(A)
        & l1_lattices(A)
        & m1_subset_1(B,u1_struct_0(A))
        & m1_subset_1(C,u1_struct_0(A)) )
     => m1_subset_1(k2_lattices(A,B,C),u1_struct_0(A)) ) ).

fof(dt_k3_lattices,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(A)
        & v4_lattices(A)
        & l2_lattices(A)
        & m1_subset_1(B,u1_struct_0(A))
        & m1_subset_1(C,u1_struct_0(A)) )
     => m1_subset_1(k3_lattices(A,B,C),u1_struct_0(A)) ) ).

fof(commutativity_k3_lattices,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(A)
        & v4_lattices(A)
        & l2_lattices(A)
        & m1_subset_1(B,u1_struct_0(A))
        & m1_subset_1(C,u1_struct_0(A)) )
     => k3_lattices(A,B,C) = k3_lattices(A,C,B) ) ).

fof(redefinition_k3_lattices,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(A)
        & v4_lattices(A)
        & l2_lattices(A)
        & m1_subset_1(B,u1_struct_0(A))
        & m1_subset_1(C,u1_struct_0(A)) )
     => k3_lattices(A,B,C) = k1_lattices(A,B,C) ) ).

fof(dt_k4_lattices,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(A)
        & v6_lattices(A)
        & l1_lattices(A)
        & m1_subset_1(B,u1_struct_0(A))
        & m1_subset_1(C,u1_struct_0(A)) )
     => m1_subset_1(k4_lattices(A,B,C),u1_struct_0(A)) ) ).

fof(commutativity_k4_lattices,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(A)
        & v6_lattices(A)
        & l1_lattices(A)
        & m1_subset_1(B,u1_struct_0(A))
        & m1_subset_1(C,u1_struct_0(A)) )
     => k4_lattices(A,B,C) = k4_lattices(A,C,B) ) ).

fof(redefinition_k4_lattices,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(A)
        & v6_lattices(A)
        & l1_lattices(A)
        & m1_subset_1(B,u1_struct_0(A))
        & m1_subset_1(C,u1_struct_0(A)) )
     => k4_lattices(A,B,C) = k2_lattices(A,B,C) ) ).

fof(dt_k5_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_lattices(A) )
     => m1_subset_1(k5_lattices(A),u1_struct_0(A)) ) ).

fof(dt_k6_lattices,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l2_lattices(A) )
     => m1_subset_1(k6_lattices(A),u1_struct_0(A)) ) ).

fof(dt_k7_lattices,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & l3_lattices(A)
        & m1_subset_1(B,u1_struct_0(A)) )
     => m1_subset_1(k7_lattices(A,B),u1_struct_0(A)) ) ).

fof(dt_u1_lattices,axiom,
    ! [A] :
      ( l1_lattices(A)
     => ( v1_funct_1(u1_lattices(A))
        & v1_funct_2(u1_lattices(A),k2_zfmisc_1(u1_struct_0(A),u1_struct_0(A)),u1_struct_0(A))
        & m2_relset_1(u1_lattices(A),k2_zfmisc_1(u1_struct_0(A),u1_struct_0(A)),u1_struct_0(A)) ) ) ).

fof(dt_u2_lattices,axiom,
    ! [A] :
      ( l2_lattices(A)
     => ( v1_funct_1(u2_lattices(A))
        & v1_funct_2(u2_lattices(A),k2_zfmisc_1(u1_struct_0(A),u1_struct_0(A)),u1_struct_0(A))
        & m2_relset_1(u2_lattices(A),k2_zfmisc_1(u1_struct_0(A),u1_struct_0(A)),u1_struct_0(A)) ) ) ).

fof(dt_g1_lattices,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,k2_zfmisc_1(A,A),A)
        & m1_relset_1(B,k2_zfmisc_1(A,A),A) )
     => ( v1_lattices(g1_lattices(A,B))
        & l1_lattices(g1_lattices(A,B)) ) ) ).

fof(free_g1_lattices,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,k2_zfmisc_1(A,A),A)
        & m1_relset_1(B,k2_zfmisc_1(A,A),A) )
     => ! [C,D] :
          ( g1_lattices(A,B) = g1_lattices(C,D)
         => ( A = C
            & B = D ) ) ) ).

fof(dt_g2_lattices,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,k2_zfmisc_1(A,A),A)
        & m1_relset_1(B,k2_zfmisc_1(A,A),A) )
     => ( v2_lattices(g2_lattices(A,B))
        & l2_lattices(g2_lattices(A,B)) ) ) ).

fof(free_g2_lattices,axiom,
    ! [A,B] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,k2_zfmisc_1(A,A),A)
        & m1_relset_1(B,k2_zfmisc_1(A,A),A) )
     => ! [C,D] :
          ( g2_lattices(A,B) = g2_lattices(C,D)
         => ( A = C
            & B = D ) ) ) ).

fof(dt_g3_lattices,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,k2_zfmisc_1(A,A),A)
        & m1_relset_1(B,k2_zfmisc_1(A,A),A)
        & v1_funct_1(C)
        & v1_funct_2(C,k2_zfmisc_1(A,A),A)
        & m1_relset_1(C,k2_zfmisc_1(A,A),A) )
     => ( v3_lattices(g3_lattices(A,B,C))
        & l3_lattices(g3_lattices(A,B,C)) ) ) ).

fof(free_g3_lattices,axiom,
    ! [A,B,C] :
      ( ( v1_funct_1(B)
        & v1_funct_2(B,k2_zfmisc_1(A,A),A)
        & m1_relset_1(B,k2_zfmisc_1(A,A),A)
        & v1_funct_1(C)
        & v1_funct_2(C,k2_zfmisc_1(A,A),A)
        & m1_relset_1(C,k2_zfmisc_1(A,A),A) )
     => ! [D,E,F] :
          ( g3_lattices(A,B,C) = g3_lattices(D,E,F)
         => ( A = D
            & B = E
            & C = F ) ) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(rc1_orders_2,axiom,
    ? [A] :
      ( l1_orders_2(A)
      & v1_orders_2(A) ) ).

fof(fc1_orders_2,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & m1_relset_1(B,A,A) )
     => ( ~ v3_struct_0(g1_orders_2(A,B))
        & v1_orders_2(g1_orders_2(A,B)) ) ) ).

fof(rc2_orders_2,axiom,
    ? [A] :
      ( l1_orders_2(A)
      & ~ v3_struct_0(A)
      & v1_orders_2(A)
      & v2_orders_2(A)
      & v3_orders_2(A)
      & v4_orders_2(A) ) ).

fof(fc2_orders_2,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ( v1_relat_1(u1_orders_2(A))
        & v1_relat_2(u1_orders_2(A))
        & v4_relat_2(u1_orders_2(A))
        & v8_relat_2(u1_orders_2(A))
        & v1_partfun1(u1_orders_2(A),u1_struct_0(A),u1_struct_0(A)) ) ) ).

fof(fc3_orders_2,axiom,
    ! [A,B] :
      ( ( v1_relat_2(B)
        & v4_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m1_relset_1(B,A,A) )
     => ( v1_orders_2(g1_orders_2(A,B))
        & v2_orders_2(g1_orders_2(A,B))
        & v3_orders_2(g1_orders_2(A,B))
        & v4_orders_2(g1_orders_2(A,B)) ) ) ).

fof(fc4_orders_2,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( v1_xboole_0(k1_pre_topc(A))
        & v1_membered(k1_pre_topc(A))
        & v2_membered(k1_pre_topc(A))
        & v3_membered(k1_pre_topc(A))
        & v4_membered(k1_pre_topc(A))
        & v5_membered(k1_pre_topc(A))
        & v5_orders_2(k1_pre_topc(A),A) ) ) ).

fof(rc3_orders_2,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ? [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
          & v5_orders_2(B,A) ) ) ).

fof(fc5_orders_2,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A)
        & m1_orders_1(B,k1_orders_1(u1_struct_0(A))) )
     => ~ v1_xboole_0(k4_orders_2(A,B)) ) ).

fof(d1_orders_2,axiom,
    $true ).

fof(d2_orders_2,axiom,
    $true ).

fof(d3_orders_2,axiom,
    $true ).

fof(d4_orders_2,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( v2_orders_2(A)
      <=> r1_relat_2(u1_orders_2(A),u1_struct_0(A)) ) ) ).

fof(d5_orders_2,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( v3_orders_2(A)
      <=> r8_relat_2(u1_orders_2(A),u1_struct_0(A)) ) ) ).

fof(d6_orders_2,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( v4_orders_2(A)
      <=> r4_relat_2(u1_orders_2(A),u1_struct_0(A)) ) ) ).

fof(d7_orders_2,axiom,
    $true ).

fof(d8_orders_2,axiom,
    $true ).

fof(d9_orders_2,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( r1_orders_2(A,B,C)
              <=> r2_hidden(k4_tarski(B,C),u1_orders_2(A)) ) ) ) ) ).

fof(d10_orders_2,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( r2_orders_2(A,B,C)
              <=> ( r1_orders_2(A,B,C)
                  & B != C ) ) ) ) ) ).

fof(t1_orders_2,axiom,
    $true ).

fof(t2_orders_2,axiom,
    $true ).

fof(t3_orders_2,axiom,
    $true ).

fof(t4_orders_2,axiom,
    $true ).

fof(t5_orders_2,axiom,
    $true ).

fof(t6_orders_2,axiom,
    $true ).

fof(t7_orders_2,axiom,
    $true ).

fof(t8_orders_2,axiom,
    $true ).

fof(t9_orders_2,axiom,
    $true ).

fof(t10_orders_2,axiom,
    $true ).

fof(t11_orders_2,axiom,
    $true ).

fof(t12_orders_2,axiom,
    $true ).

fof(t13_orders_2,axiom,
    $true ).

fof(t14_orders_2,axiom,
    $true ).

fof(t15_orders_2,axiom,
    $true ).

fof(t16_orders_2,axiom,
    $true ).

fof(t17_orders_2,axiom,
    $true ).

fof(t18_orders_2,axiom,
    $true ).

fof(t19_orders_2,axiom,
    $true ).

fof(t20_orders_2,axiom,
    $true ).

fof(t21_orders_2,axiom,
    $true ).

fof(t22_orders_2,axiom,
    $true ).

fof(t23_orders_2,axiom,
    $true ).

fof(t24_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => r1_orders_2(A,B,B) ) ) ).

fof(t25_orders_2,axiom,
    ! [A] :
      ( ( v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( ( r1_orders_2(A,B,C)
                  & r1_orders_2(A,C,B) )
               => B = C ) ) ) ) ).

fof(t26_orders_2,axiom,
    ! [A] :
      ( ( v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ( ( r1_orders_2(A,B,C)
                      & r1_orders_2(A,C,D) )
                   => r1_orders_2(A,B,D) ) ) ) ) ) ).

fof(t27_orders_2,axiom,
    $true ).

fof(t28_orders_2,axiom,
    ! [A] :
      ( ( v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ~ ( r2_orders_2(A,B,C)
                  & r2_orders_2(A,C,B) ) ) ) ) ).

fof(t29_orders_2,axiom,
    ! [A] :
      ( ( v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ( ( r2_orders_2(A,B,C)
                      & r2_orders_2(A,C,D) )
                   => r2_orders_2(A,B,D) ) ) ) ) ) ).

fof(t30_orders_2,axiom,
    ! [A] :
      ( ( v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ~ ( r1_orders_2(A,B,C)
                  & r2_orders_2(A,C,B) ) ) ) ) ).

fof(t31_orders_2,axiom,
    $true ).

fof(t32_orders_2,axiom,
    ! [A] :
      ( ( v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ( ( ( r2_orders_2(A,B,C)
                        & r1_orders_2(A,C,D) )
                      | ( r1_orders_2(A,B,C)
                        & r2_orders_2(A,C,D) ) )
                   => r2_orders_2(A,B,D) ) ) ) ) ) ).

fof(d11_orders_2,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ( v5_orders_2(B,A)
          <=> r7_relat_2(u1_orders_2(A),B) ) ) ) ).

fof(t33_orders_2,axiom,
    $true ).

fof(t34_orders_2,axiom,
    $true ).

fof(t35_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ( v5_orders_2(k1_struct_0(A,B),A)
            & m1_subset_1(k1_struct_0(A,B),k1_zfmisc_1(u1_struct_0(A))) ) ) ) ).

fof(t36_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( ( v5_orders_2(k2_struct_0(A,B,C),A)
                  & m1_subset_1(k2_struct_0(A,B,C),k1_zfmisc_1(u1_struct_0(A))) )
              <=> ( r3_orders_2(A,B,C)
                  | r3_orders_2(A,C,B) ) ) ) ) ) ).

fof(t37_orders_2,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( ( v5_orders_2(B,A)
            & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
             => ( r1_tarski(C,B)
               => ( v5_orders_2(C,A)
                  & m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A))) ) ) ) ) ) ).

fof(t38_orders_2,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( ~ ( ? [D] :
                        ( v5_orders_2(D,A)
                        & m1_subset_1(D,k1_zfmisc_1(u1_struct_0(A)))
                        & r2_hidden(B,D)
                        & r2_hidden(C,D) )
                    & ~ r1_orders_2(A,B,C)
                    & ~ r1_orders_2(A,C,B) )
                & ~ ( ( r1_orders_2(A,B,C)
                      | r1_orders_2(A,C,B) )
                    & ! [D] :
                        ( ( v5_orders_2(D,A)
                          & m1_subset_1(D,k1_zfmisc_1(u1_struct_0(A))) )
                       => ~ ( r2_hidden(B,D)
                            & r2_hidden(C,D) ) ) ) ) ) ) ) ).

fof(t39_orders_2,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( ? [D] :
                    ( v5_orders_2(D,A)
                    & m1_subset_1(D,k1_zfmisc_1(u1_struct_0(A)))
                    & r2_hidden(B,D)
                    & r2_hidden(C,D) )
              <=> ( r2_orders_2(A,B,C)
                <=> ~ r1_orders_2(A,C,B) ) ) ) ) ) ).

fof(t40_orders_2,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ( r2_wellord1(u1_orders_2(A),B)
           => ( v5_orders_2(B,A)
              & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) ) ) ) ) ).

fof(t41_orders_2,axiom,
    $true ).

fof(t42_orders_2,axiom,
    $true ).

fof(t43_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => k1_orders_2(A,k1_pre_topc(A)) = u1_struct_0(A) ) ).

fof(t44_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => k1_orders_2(A,k2_pre_topc(A)) = k1_xboole_0 ) ).

fof(t45_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => k2_orders_2(A,k1_pre_topc(A)) = u1_struct_0(A) ) ).

fof(t46_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => k2_orders_2(A,k2_pre_topc(A)) = k1_xboole_0 ) ).

fof(t47_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
             => ~ ( r2_hidden(B,C)
                  & r2_hidden(B,k1_orders_2(A,C)) ) ) ) ) ).

fof(t48_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ~ r2_hidden(B,k1_orders_2(A,k1_struct_0(A,B))) ) ) ).

fof(t49_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
             => ~ ( r2_hidden(B,C)
                  & r2_hidden(B,k2_orders_2(A,C)) ) ) ) ) ).

fof(t50_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ~ r2_hidden(B,k2_orders_2(A,k1_struct_0(A,B))) ) ) ).

fof(t51_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( r2_orders_2(A,B,C)
              <=> r2_hidden(C,k1_orders_2(A,k1_struct_0(A,B))) ) ) ) ) ).

fof(t52_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( r2_orders_2(A,B,C)
              <=> r2_hidden(B,k2_orders_2(A,k1_struct_0(A,C))) ) ) ) ) ).

fof(d14_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => k3_orders_2(A,B,C) = k5_subset_1(u1_struct_0(A),k2_orders_2(A,k1_struct_0(A,C)),B) ) ) ) ).

fof(d15_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
             => ( ( B != k1_xboole_0
                 => ( m1_orders_2(C,A,B)
                  <=> ? [D] :
                        ( m1_subset_1(D,u1_struct_0(A))
                        & r2_hidden(D,B)
                        & C = k3_orders_2(A,B,D) ) ) )
                & ( B = k1_xboole_0
                 => ( m1_orders_2(C,A,B)
                  <=> C = k1_xboole_0 ) ) ) ) ) ) ).

fof(t53_orders_2,axiom,
    $true ).

fof(t54_orders_2,axiom,
    $true ).

fof(t55_orders_2,axiom,
    $true ).

fof(t56_orders_2,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(B)
        & v2_orders_2(B)
        & v3_orders_2(B)
        & v4_orders_2(B)
        & l1_orders_2(B) )
     => ! [C] :
          ( m1_subset_1(C,u1_struct_0(B))
         => ! [D] :
              ( m1_subset_1(D,k1_zfmisc_1(u1_struct_0(B)))
             => ( r2_hidden(A,k3_orders_2(B,D,C))
              <=> ( r2_hidden(A,k2_orders_2(B,k1_struct_0(B,C)))
                  & r2_hidden(A,D) ) ) ) ) ) ).

fof(t57_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,k1_zfmisc_1(u1_struct_0(A)))
                 => ( r2_hidden(B,k3_orders_2(A,D,C))
                  <=> ( r2_orders_2(A,B,C)
                      & r2_hidden(B,D) ) ) ) ) ) ) ).

fof(t58_orders_2,axiom,
    $true ).

fof(t59_orders_2,axiom,
    $true ).

fof(t60_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => k3_orders_2(A,k1_pre_topc(A),B) = k1_xboole_0 ) ) ).

fof(t61_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
             => r1_tarski(k3_orders_2(A,C,B),C) ) ) ) ).

fof(t62_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
             => ~ r2_hidden(B,k3_orders_2(A,C,B)) ) ) ) ).

fof(t63_orders_2,axiom,
    $true ).

fof(t64_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,k1_zfmisc_1(u1_struct_0(A)))
                 => ( r2_orders_2(A,B,C)
                   => r1_tarski(k3_orders_2(A,D,B),k3_orders_2(A,D,C)) ) ) ) ) ) ).

fof(t65_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
             => ! [D] :
                  ( m1_subset_1(D,k1_zfmisc_1(u1_struct_0(A)))
                 => ( r1_tarski(C,D)
                   => r1_tarski(k3_orders_2(A,C,B),k3_orders_2(A,D,B)) ) ) ) ) ) ).

fof(t66_orders_2,axiom,
    $true ).

fof(t67_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ! [C] :
              ( m1_orders_2(C,A,B)
             => r1_tarski(C,B) ) ) ) ).

fof(t68_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ( ~ ( B != k1_xboole_0
                & m1_orders_2(B,A,B) )
            & ~ ( ~ m1_orders_2(B,A,B)
                & B = k1_xboole_0 ) ) ) ) ).

fof(t69_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
             => ~ ( ~ ( B = k1_xboole_0
                      & C = k1_xboole_0 )
                  & m1_orders_2(B,A,C)
                  & m1_orders_2(C,A,B) ) ) ) ) ).

fof(t70_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,k1_zfmisc_1(u1_struct_0(A)))
                 => ! [E] :
                      ( m1_subset_1(E,k1_zfmisc_1(u1_struct_0(A)))
                     => ( ( r2_orders_2(A,B,C)
                          & r2_hidden(B,D)
                          & r2_hidden(C,E)
                          & m1_orders_2(E,A,D) )
                       => r2_hidden(B,E) ) ) ) ) ) ) ).

fof(t71_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
             => ! [D] :
                  ( m1_subset_1(D,k1_zfmisc_1(u1_struct_0(A)))
                 => ( ( r2_hidden(B,C)
                      & m1_orders_2(C,A,D) )
                   => k3_orders_2(A,C,B) = k3_orders_2(A,D,B) ) ) ) ) ) ).

fof(t72_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
             => ~ ( r1_tarski(B,C)
                  & r2_wellord1(u1_orders_2(A),C)
                  & ! [D] :
                      ( m1_subset_1(D,u1_struct_0(A))
                     => ! [E] :
                          ( m1_subset_1(E,u1_struct_0(A))
                         => ( ( r2_hidden(E,B)
                              & r2_orders_2(A,D,E) )
                           => r2_hidden(D,B) ) ) )
                  & B != C
                  & ~ m1_orders_2(B,A,C) ) ) ) ) ).

fof(t73_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
             => ~ ( r1_tarski(B,C)
                  & r2_wellord1(u1_orders_2(A),C)
                  & ! [D] :
                      ( m1_subset_1(D,u1_struct_0(A))
                     => ! [E] :
                          ( m1_subset_1(E,u1_struct_0(A))
                         => ( ( r2_hidden(E,B)
                              & r2_hidden(D,C)
                              & r2_orders_2(A,D,E) )
                           => r2_hidden(D,B) ) ) )
                  & B != C
                  & ~ m1_orders_2(B,A,C) ) ) ) ) ).

fof(d16_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_orders_1(B,k1_orders_1(u1_struct_0(A)))
         => ! [C] :
              ( ( v5_orders_2(C,A)
                & m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A))) )
             => ( m2_orders_2(C,A,B)
              <=> ( C != k1_xboole_0
                  & r2_wellord1(u1_orders_2(A),C)
                  & ! [D] :
                      ( m1_subset_1(D,u1_struct_0(A))
                     => ( r2_hidden(D,C)
                       => k1_funct_1(B,k1_orders_2(A,k3_orders_2(A,C,D))) = D ) ) ) ) ) ) ) ).

fof(t74_orders_2,axiom,
    $true ).

fof(t75_orders_2,axiom,
    $true ).

fof(t76_orders_2,axiom,
    $true ).

fof(t77_orders_2,axiom,
    $true ).

fof(t78_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_orders_1(B,k1_orders_1(u1_struct_0(A)))
         => m2_orders_2(k1_tarski(k1_funct_1(B,u1_struct_0(A))),A,B) ) ) ).

fof(t79_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_orders_1(B,k1_orders_1(u1_struct_0(A)))
         => ! [C] :
              ( m2_orders_2(C,A,B)
             => r2_hidden(k1_funct_1(B,u1_struct_0(A)),C) ) ) ) ).

fof(t80_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_orders_1(D,k1_orders_1(u1_struct_0(A)))
                 => ! [E] :
                      ( m2_orders_2(E,A,D)
                     => ( ( r2_hidden(B,E)
                          & C = k1_funct_1(D,u1_struct_0(A)) )
                       => r3_orders_2(A,C,B) ) ) ) ) ) ) ).

fof(t81_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_orders_1(C,k1_orders_1(u1_struct_0(A)))
             => ! [D] :
                  ( m2_orders_2(D,A,C)
                 => ( B = k1_funct_1(C,u1_struct_0(A))
                   => k3_orders_2(A,D,B) = k1_xboole_0 ) ) ) ) ) ).

fof(t82_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_orders_1(B,k1_orders_1(u1_struct_0(A)))
         => ! [C] :
              ( m2_orders_2(C,A,B)
             => ! [D] :
                  ( m2_orders_2(D,A,B)
                 => ~ r1_xboole_0(C,D) ) ) ) ) ).

fof(t83_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_orders_1(B,k1_orders_1(u1_struct_0(A)))
         => ! [C] :
              ( m2_orders_2(C,A,B)
             => ! [D] :
                  ( m2_orders_2(D,A,B)
                 => ( C != D
                   => ( m1_orders_2(C,A,D)
                    <=> ~ m1_orders_2(D,A,C) ) ) ) ) ) ) ).

fof(t84_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_orders_1(B,k1_orders_1(u1_struct_0(A)))
         => ! [C] :
              ( m2_orders_2(C,A,B)
             => ! [D] :
                  ( m2_orders_2(D,A,B)
                 => ( r2_xboole_0(C,D)
                  <=> m1_orders_2(C,A,D) ) ) ) ) ) ).

fof(d17_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_orders_1(B,k1_orders_1(u1_struct_0(A)))
         => ! [C] :
              ( C = k4_orders_2(A,B)
            <=> ! [D] :
                  ( r2_hidden(D,C)
                <=> m2_orders_2(D,A,B) ) ) ) ) ).

fof(t85_orders_2,axiom,
    $true ).

fof(t86_orders_2,axiom,
    $true ).

fof(t87_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_orders_1(B,k1_orders_1(u1_struct_0(A)))
         => k3_tarski(k4_orders_2(A,B)) != k1_xboole_0 ) ) ).

fof(t88_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ! [C] :
              ( m1_orders_1(C,k1_orders_1(u1_struct_0(A)))
             => ! [D] :
                  ( m2_orders_2(D,A,C)
                 => ( B = k3_tarski(k4_orders_2(A,C))
                   => ( D = k3_tarski(k4_orders_2(A,C))
                      | m1_orders_2(D,A,B) ) ) ) ) ) ) ).

fof(t89_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_orders_1(B,k1_orders_1(u1_struct_0(A)))
         => m2_orders_2(k3_tarski(k4_orders_2(A,B)),A,B) ) ) ).

fof(t90_orders_2,axiom,
    $true ).

fof(t91_orders_2,axiom,
    $true ).

fof(t92_orders_2,axiom,
    $true ).

fof(t93_orders_2,axiom,
    $true ).

fof(t94_orders_2,axiom,
    $true ).

fof(t95_orders_2,axiom,
    $true ).

fof(t96_orders_2,axiom,
    $true ).

fof(t97_orders_2,axiom,
    $true ).

fof(t98_orders_2,axiom,
    $true ).

fof(t99_orders_2,axiom,
    $true ).

fof(t100_orders_2,axiom,
    $true ).

fof(t101_orders_2,axiom,
    $true ).

fof(t102_orders_2,axiom,
    $true ).

fof(t103_orders_2,axiom,
    $true ).

fof(t104_orders_2,axiom,
    $true ).

fof(t105_orders_2,axiom,
    $true ).

fof(t106_orders_2,axiom,
    $true ).

fof(t107_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => k3_relat_1(k2_wellord1(u1_orders_2(A),B)) = B ) ) ).

fof(t108_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ( v3_orders_1(k2_wellord1(u1_orders_2(A),B))
           => ( v5_orders_2(B,A)
              & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) ) ) ) ) ).

fof(t109_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( v5_orders_2(B,A)
            & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
         => v3_orders_1(k2_wellord1(u1_orders_2(A),B)) ) ) ).

fof(t110_orders_2,axiom,
    $true ).

fof(t111_orders_2,axiom,
    $true ).

fof(t112_orders_2,axiom,
    $true ).

fof(t113_orders_2,axiom,
    $true ).

fof(t114_orders_2,axiom,
    $true ).

fof(t115_orders_2,axiom,
    $true ).

fof(t116_orders_2,axiom,
    $true ).

fof(t117_orders_2,axiom,
    $true ).

fof(t118_orders_2,axiom,
    $true ).

fof(t119_orders_2,axiom,
    $true ).

fof(t120_orders_2,axiom,
    $true ).

fof(t121_orders_2,axiom,
    $true ).

fof(t122_orders_2,axiom,
    $true ).

fof(t123_orders_2,axiom,
    $true ).

fof(t124_orders_2,axiom,
    $true ).

fof(t125_orders_2,axiom,
    $true ).

fof(t126_orders_2,axiom,
    $true ).

fof(t127_orders_2,axiom,
    $true ).

fof(t128_orders_2,axiom,
    $true ).

fof(t129_orders_2,axiom,
    $true ).

fof(t130_orders_2,axiom,
    $true ).

fof(t131_orders_2,axiom,
    $true ).

fof(t132_orders_2,axiom,
    $true ).

fof(t133_orders_2,axiom,
    $true ).

fof(t134_orders_2,axiom,
    $true ).

fof(t135_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ( r3_orders_1(u1_orders_2(A),B)
           => ( v5_orders_2(B,A)
              & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) ) ) ) ) ).

fof(t136_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( v5_orders_2(B,A)
            & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
         => r3_orders_1(u1_orders_2(A),B) ) ) ).

fof(t137_orders_2,axiom,
    $true ).

fof(t138_orders_2,axiom,
    $true ).

fof(t139_orders_2,axiom,
    $true ).

fof(t140_orders_2,axiom,
    $true ).

fof(t141_orders_2,axiom,
    $true ).

fof(t142_orders_2,axiom,
    $true ).

fof(t143_orders_2,axiom,
    $true ).

fof(t144_orders_2,axiom,
    $true ).

fof(t145_orders_2,axiom,
    $true ).

fof(t146_orders_2,axiom,
    $true ).

fof(t147_orders_2,axiom,
    $true ).

fof(t148_orders_2,axiom,
    $true ).

fof(t149_orders_2,axiom,
    $true ).

fof(t150_orders_2,axiom,
    $true ).

fof(t151_orders_2,axiom,
    $true ).

fof(t152_orders_2,axiom,
    $true ).

fof(t153_orders_2,axiom,
    $true ).

fof(t154_orders_2,axiom,
    $true ).

fof(t155_orders_2,axiom,
    $true ).

fof(t156_orders_2,axiom,
    $true ).

fof(t157_orders_2,axiom,
    $true ).

fof(t158_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ( r7_orders_1(u1_orders_2(A),B)
          <=> ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ~ r2_orders_2(A,C,B) ) ) ) ) ).

fof(t159_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ( r6_orders_1(u1_orders_2(A),B)
          <=> ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ~ r2_orders_2(A,B,C) ) ) ) ) ).

fof(t160_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ( r8_orders_1(u1_orders_2(A),B)
          <=> ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ( B != C
                 => r2_orders_2(A,C,B) ) ) ) ) ) ).

fof(t161_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ( r9_orders_1(u1_orders_2(A),B)
          <=> ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ( B != C
                 => r2_orders_2(A,B,C) ) ) ) ) ) ).

fof(t162_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ~ ( ! [B] :
              ( ( v5_orders_2(B,A)
                & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
             => ? [C] :
                  ( m1_subset_1(C,u1_struct_0(A))
                  & ! [D] :
                      ( m1_subset_1(D,u1_struct_0(A))
                     => ( r2_hidden(D,B)
                       => r3_orders_2(A,D,C) ) ) ) )
          & ! [B] :
              ( m1_subset_1(B,u1_struct_0(A))
             => ? [C] :
                  ( m1_subset_1(C,u1_struct_0(A))
                  & r2_orders_2(A,B,C) ) ) ) ) ).

fof(t163_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ~ ( ! [B] :
              ( ( v5_orders_2(B,A)
                & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
             => ? [C] :
                  ( m1_subset_1(C,u1_struct_0(A))
                  & ! [D] :
                      ( m1_subset_1(D,u1_struct_0(A))
                     => ( r2_hidden(D,B)
                       => r3_orders_2(A,C,D) ) ) ) )
          & ! [B] :
              ( m1_subset_1(B,u1_struct_0(A))
             => ? [C] :
                  ( m1_subset_1(C,u1_struct_0(A))
                  & r2_orders_2(A,C,B) ) ) ) ) ).

fof(dt_m1_orders_2,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A)
        & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
     => ! [C] :
          ( m1_orders_2(C,A,B)
         => m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A))) ) ) ).

fof(existence_m1_orders_2,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A)
        & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
     => ? [C] : m1_orders_2(C,A,B) ) ).

fof(dt_m2_orders_2,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A)
        & m1_orders_1(B,k1_orders_1(u1_struct_0(A))) )
     => ! [C] :
          ( m2_orders_2(C,A,B)
         => ( v5_orders_2(C,A)
            & m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A))) ) ) ) ).

fof(existence_m2_orders_2,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A)
        & m1_orders_1(B,k1_orders_1(u1_struct_0(A))) )
     => ? [C] : m2_orders_2(C,A,B) ) ).

fof(dt_l1_orders_2,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => l1_struct_0(A) ) ).

fof(existence_l1_orders_2,axiom,
    ? [A] : l1_orders_2(A) ).

fof(abstractness_v1_orders_2,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( v1_orders_2(A)
       => A = g1_orders_2(u1_struct_0(A),u1_orders_2(A)) ) ) ).

fof(irreflexivity_r2_orders_2,axiom,
    ! [A,B,C] :
      ( ( l1_orders_2(A)
        & m1_subset_1(B,u1_struct_0(A))
        & m1_subset_1(C,u1_struct_0(A)) )
     => ~ r2_orders_2(A,B,B) ) ).

fof(reflexivity_r3_orders_2,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & l1_orders_2(A)
        & m1_subset_1(B,u1_struct_0(A))
        & m1_subset_1(C,u1_struct_0(A)) )
     => r3_orders_2(A,B,B) ) ).

fof(redefinition_r3_orders_2,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & l1_orders_2(A)
        & m1_subset_1(B,u1_struct_0(A))
        & m1_subset_1(C,u1_struct_0(A)) )
     => ( r3_orders_2(A,B,C)
      <=> r1_orders_2(A,B,C) ) ) ).

fof(dt_k1_orders_2,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A)
        & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
     => m1_subset_1(k1_orders_2(A,B),k1_zfmisc_1(u1_struct_0(A))) ) ).

fof(dt_k2_orders_2,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A)
        & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
     => m1_subset_1(k2_orders_2(A,B),k1_zfmisc_1(u1_struct_0(A))) ) ).

fof(dt_k3_orders_2,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A)
        & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
        & m1_subset_1(C,u1_struct_0(A)) )
     => m1_subset_1(k3_orders_2(A,B,C),k1_zfmisc_1(u1_struct_0(A))) ) ).

fof(dt_k4_orders_2,axiom,
    $true ).

fof(dt_u1_orders_2,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => m2_relset_1(u1_orders_2(A),u1_struct_0(A),u1_struct_0(A)) ) ).

fof(dt_g1_orders_2,axiom,
    ! [A,B] :
      ( m1_relset_1(B,A,A)
     => ( v1_orders_2(g1_orders_2(A,B))
        & l1_orders_2(g1_orders_2(A,B)) ) ) ).

fof(free_g1_orders_2,axiom,
    ! [A,B] :
      ( m1_relset_1(B,A,A)
     => ! [C,D] :
          ( g1_orders_2(A,B) = g1_orders_2(C,D)
         => ( A = C
            & B = D ) ) ) ).

fof(d12_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => k1_orders_2(A,B) = a_2_0_orders_2(A,B) ) ) ).

fof(d13_orders_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => k2_orders_2(A,B) = a_2_1_orders_2(A,B) ) ) ).

fof(fraenkel_a_2_0_orders_2,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(B)
        & v2_orders_2(B)
        & v3_orders_2(B)
        & v4_orders_2(B)
        & l1_orders_2(B)
        & m1_subset_1(C,k1_zfmisc_1(u1_struct_0(B))) )
     => ( r2_hidden(A,a_2_0_orders_2(B,C))
      <=> ? [D] :
            ( m1_subset_1(D,u1_struct_0(B))
            & A = D
            & ! [E] :
                ( m1_subset_1(E,u1_struct_0(B))
               => ( r2_hidden(E,C)
                 => r2_orders_2(B,E,D) ) ) ) ) ) ).

fof(fraenkel_a_2_1_orders_2,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(B)
        & v2_orders_2(B)
        & v3_orders_2(B)
        & v4_orders_2(B)
        & l1_orders_2(B)
        & m1_subset_1(C,k1_zfmisc_1(u1_struct_0(B))) )
     => ( r2_hidden(A,a_2_1_orders_2(B,C))
      <=> ? [D] :
            ( m1_subset_1(D,u1_struct_0(B))
            & A = D
            & ! [E] :
                ( m1_subset_1(E,u1_struct_0(B))
               => ( r2_hidden(E,C)
                 => r2_orders_2(B,D,E) ) ) ) ) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(rc1_filter_0,axiom,
    ? [A] :
      ( l3_lattices(A)
      & ~ v3_struct_0(A)
      & v3_lattices(A)
      & v4_lattices(A)
      & v5_lattices(A)
      & v6_lattices(A)
      & v7_lattices(A)
      & v8_lattices(A)
      & v9_lattices(A)
      & v10_lattices(A)
      & v3_filter_0(A) ) ).

fof(cc1_filter_0,axiom,
    ! [A] :
      ( l3_lattices(A)
     => ( ( ~ v3_struct_0(A)
          & v10_lattices(A)
          & v3_filter_0(A) )
       => ( ~ v3_struct_0(A)
          & v4_lattices(A)
          & v5_lattices(A)
          & v6_lattices(A)
          & v7_lattices(A)
          & v8_lattices(A)
          & v9_lattices(A)
          & v10_lattices(A)
          & v11_lattices(A)
          & v12_lattices(A) ) ) ) ).

fof(fc1_filter_0,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A)
        & ~ v1_xboole_0(B)
        & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
        & ~ v1_xboole_0(C)
        & m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A))) )
     => ~ v1_xboole_0(k5_filter_0(A,B,C)) ) ).

fof(fc2_filter_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A)
        & m1_filter_0(B,A) )
     => ( ~ v3_struct_0(k8_filter_0(A,B))
        & v3_lattices(k8_filter_0(A,B))
        & v4_lattices(k8_filter_0(A,B))
        & v5_lattices(k8_filter_0(A,B))
        & v6_lattices(k8_filter_0(A,B))
        & v7_lattices(k8_filter_0(A,B))
        & v8_lattices(k8_filter_0(A,B))
        & v9_lattices(k8_filter_0(A,B))
        & v10_lattices(k8_filter_0(A,B)) ) ) ).

fof(t1_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ( r3_lattices(A,B,C)
                   => ( r3_lattices(A,k3_lattices(A,D,B),k3_lattices(A,D,C))
                      & r3_lattices(A,k3_lattices(A,B,D),k3_lattices(A,C,D))
                      & r3_lattices(A,k3_lattices(A,B,D),k3_lattices(A,D,C))
                      & r3_lattices(A,k3_lattices(A,D,B),k3_lattices(A,C,D)) ) ) ) ) ) ) ).

fof(t2_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ( r3_lattices(A,B,C)
                   => ( r3_lattices(A,k4_lattices(A,B,D),C)
                      & r3_lattices(A,k4_lattices(A,D,B),C) ) ) ) ) ) ) ).

fof(t3_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ( r3_lattices(A,B,C)
                   => ( r3_lattices(A,B,k3_lattices(A,D,C))
                      & r3_lattices(A,B,k3_lattices(A,C,D)) ) ) ) ) ) ) ).

fof(t4_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ! [E] :
                      ( m1_subset_1(E,u1_struct_0(A))
                     => ( ( r3_lattices(A,B,C)
                          & r3_lattices(A,D,E) )
                       => ( r3_lattices(A,k3_lattices(A,B,D),k3_lattices(A,C,E))
                          & r3_lattices(A,k3_lattices(A,B,D),k3_lattices(A,E,C)) ) ) ) ) ) ) ) ).

fof(t5_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ! [E] :
                      ( m1_subset_1(E,u1_struct_0(A))
                     => ( ( r3_lattices(A,B,C)
                          & r3_lattices(A,D,E) )
                       => ( r3_lattices(A,k4_lattices(A,B,D),k4_lattices(A,C,E))
                          & r3_lattices(A,k4_lattices(A,B,D),k4_lattices(A,E,C)) ) ) ) ) ) ) ) ).

fof(t6_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ( ( r3_lattices(A,B,C)
                      & r3_lattices(A,D,C) )
                   => r3_lattices(A,k3_lattices(A,B,D),C) ) ) ) ) ) ).

fof(t7_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ( ( r3_lattices(A,B,C)
                      & r3_lattices(A,B,D) )
                   => r3_lattices(A,B,k4_lattices(A,C,D)) ) ) ) ) ) ).

fof(d1_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( ( ~ v1_xboole_0(B)
            & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
         => ( m1_filter_0(B,A)
          <=> ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => ( ( r2_hidden(C,B)
                        & r2_hidden(D,B) )
                    <=> r2_hidden(k4_lattices(A,C,D),B) ) ) ) ) ) ) ).

fof(t8_filter_0,axiom,
    $true ).

fof(t9_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( ( ~ v1_xboole_0(B)
            & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
         => ( m1_filter_0(B,A)
          <=> ( ! [C] :
                  ( m1_subset_1(C,u1_struct_0(A))
                 => ! [D] :
                      ( m1_subset_1(D,u1_struct_0(A))
                     => ( ( r2_hidden(C,B)
                          & r2_hidden(D,B) )
                       => r2_hidden(k4_lattices(A,C,D),B) ) ) )
              & ! [C] :
                  ( m1_subset_1(C,u1_struct_0(A))
                 => ! [D] :
                      ( m1_subset_1(D,u1_struct_0(A))
                     => ( ( r2_hidden(C,B)
                          & r3_lattices(A,C,D) )
                       => r2_hidden(D,B) ) ) ) ) ) ) ) ).

fof(t10_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_filter_0(D,A)
                 => ( r2_hidden(B,D)
                   => ( r2_hidden(k3_lattices(A,B,C),D)
                      & r2_hidden(k3_lattices(A,C,B),D) ) ) ) ) ) ) ).

fof(t11_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ? [C] :
              ( m1_subset_1(C,u1_struct_0(A))
              & r2_hidden(C,B) ) ) ) ).

fof(t12_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ( ( ~ v3_struct_0(A)
              & v10_lattices(A)
              & v14_lattices(A)
              & l3_lattices(A) )
           => r2_hidden(k6_lattices(A),B) ) ) ) ).

fof(t13_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ( ( ~ v3_struct_0(A)
          & v10_lattices(A)
          & v14_lattices(A)
          & l3_lattices(A) )
       => m1_filter_0(k6_domain_1(u1_struct_0(A),k6_lattices(A)),A) ) ) ).

fof(t14_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ( m1_filter_0(k6_domain_1(u1_struct_0(A),B),A)
           => v14_lattices(A) ) ) ) ).

fof(t15_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => m1_filter_0(u1_struct_0(A),A) ) ).

fof(d2_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => k1_filter_0(A) = u1_struct_0(A) ) ).

fof(t16_filter_0,axiom,
    $true ).

fof(t17_filter_0,axiom,
    $true ).

fof(t18_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( r2_hidden(B,k2_filter_0(A,C))
              <=> r3_lattices(A,C,B) ) ) ) ) ).

fof(t19_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( r2_hidden(B,k2_filter_0(A,B))
                & r2_hidden(k3_lattices(A,B,C),k2_filter_0(A,B))
                & r2_hidden(k3_lattices(A,C,B),k2_filter_0(A,B)) ) ) ) ) ).

fof(t20_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ( ( ~ v3_struct_0(A)
          & v10_lattices(A)
          & v13_lattices(A)
          & l3_lattices(A) )
       => k1_filter_0(A) = k2_filter_0(A,k5_lattices(A)) ) ) ).

fof(d4_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ( v1_filter_0(B,A)
          <=> ( B != u1_struct_0(A)
              & ! [C] :
                  ( m1_filter_0(C,A)
                 => ( r1_tarski(B,C)
                   => ( C = u1_struct_0(A)
                      | B = C ) ) ) ) ) ) ) ).

fof(t21_filter_0,axiom,
    $true ).

fof(t22_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ( v13_lattices(A)
       => ! [B] :
            ( m1_filter_0(B,A)
           => ~ ( B != u1_struct_0(A)
                & ! [C] :
                    ( m1_filter_0(C,A)
                   => ~ ( r1_tarski(B,C)
                        & v1_filter_0(C,A) ) ) ) ) ) ) ).

fof(t23_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ~ ( ~ ! [C] :
                    ( m1_subset_1(C,u1_struct_0(A))
                   => k4_lattices(A,B,C) = B )
              & k2_filter_0(A,B) = u1_struct_0(A) ) ) ) ).

fof(t24_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ~ ( ~ v3_struct_0(A)
              & v10_lattices(A)
              & v13_lattices(A)
              & l3_lattices(A)
              & B != k5_lattices(A)
              & ! [C] :
                  ( m1_filter_0(C,A)
                 => ~ ( r2_hidden(B,C)
                      & v1_filter_0(C,A) ) ) ) ) ) ).

fof(d5_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( ( ~ v1_xboole_0(B)
            & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
         => ! [C] :
              ( m1_filter_0(C,A)
             => ( C = k3_filter_0(A,B)
              <=> ( r1_tarski(B,C)
                  & ! [D] :
                      ( m1_filter_0(D,A)
                     => ( r1_tarski(B,D)
                       => r1_tarski(C,D) ) ) ) ) ) ) ) ).

fof(t25_filter_0,axiom,
    $true ).

fof(t26_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => k3_filter_0(A,B) = B ) ) ).

fof(t27_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( ( ~ v1_xboole_0(B)
            & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
         => ! [C] :
              ( ( ~ v1_xboole_0(C)
                & m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A))) )
             => ( r1_tarski(B,C)
               => r1_tarski(k3_filter_0(A,B),k3_filter_0(A,C)) ) ) ) ) ).

fof(t28_filter_0,axiom,
    $true ).

fof(t29_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( ( ~ v1_xboole_0(C)
                & m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A))) )
             => ( r2_hidden(B,C)
               => r1_tarski(k2_filter_0(A,B),k3_filter_0(A,C)) ) ) ) ) ).

fof(t30_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( ( ~ v1_xboole_0(C)
                & m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A))) )
             => ( C = k6_domain_1(u1_struct_0(A),B)
               => k3_filter_0(A,C) = k2_filter_0(A,B) ) ) ) ) ).

fof(t31_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( ( ~ v1_xboole_0(B)
            & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
         => ( ( ~ v3_struct_0(A)
              & v10_lattices(A)
              & v13_lattices(A)
              & l3_lattices(A)
              & r2_hidden(k5_lattices(A),B) )
           => ( k3_filter_0(A,B) = k1_filter_0(A)
              & k3_filter_0(A,B) = u1_struct_0(A) ) ) ) ) ).

fof(t32_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ( ( ~ v3_struct_0(A)
              & v10_lattices(A)
              & v13_lattices(A)
              & l3_lattices(A)
              & r2_hidden(k5_lattices(A),B) )
           => ( B = k1_filter_0(A)
              & B = u1_struct_0(A) ) ) ) ) ).

fof(d6_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ( v2_filter_0(B,A)
          <=> ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => ( r2_hidden(k3_lattices(A,C,D),B)
                    <=> ( r2_hidden(C,B)
                        | r2_hidden(D,B) ) ) ) ) ) ) ) ).

fof(t33_filter_0,axiom,
    $true ).

fof(t34_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ( ( ~ v3_struct_0(A)
          & v10_lattices(A)
          & v17_lattices(A)
          & l3_lattices(A) )
       => ! [B] :
            ( m1_subset_1(B,u1_struct_0(A))
           => ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ( r3_lattices(A,k4_lattices(A,B,k3_lattices(A,k7_lattices(A,B),C)),C)
                  & ! [D] :
                      ( m1_subset_1(D,u1_struct_0(A))
                     => ( r3_lattices(A,k4_lattices(A,B,D),C)
                       => r3_lattices(A,D,k3_lattices(A,k7_lattices(A,B),C)) ) ) ) ) ) ) ) ).

fof(d7_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l3_lattices(A) )
     => ( v3_filter_0(A)
      <=> ! [B] :
            ( m1_subset_1(B,u1_struct_0(A))
           => ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ? [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                    & r1_lattices(A,k2_lattices(A,B,D),C)
                    & ! [E] :
                        ( m1_subset_1(E,u1_struct_0(A))
                       => ( r1_lattices(A,k2_lattices(A,B,E),C)
                         => r1_lattices(A,E,D) ) ) ) ) ) ) ) ).

fof(d8_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( ( ~ v3_struct_0(A)
                  & v10_lattices(A)
                  & v3_filter_0(A)
                  & l3_lattices(A) )
               => ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => ( D = k4_filter_0(A,B,C)
                    <=> ( r3_lattices(A,k4_lattices(A,B,D),C)
                        & ! [E] :
                            ( m1_subset_1(E,u1_struct_0(A))
                           => ( r3_lattices(A,k4_lattices(A,B,E),C)
                             => r3_lattices(A,E,D) ) ) ) ) ) ) ) ) ) ).

fof(t35_filter_0,axiom,
    $true ).

fof(t36_filter_0,axiom,
    $true ).

fof(t37_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v3_filter_0(A)
        & l3_lattices(A) )
     => v14_lattices(A) ) ).

fof(t38_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v3_filter_0(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => k4_filter_0(A,B,B) = k6_lattices(A) ) ) ).

fof(t39_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v3_filter_0(A)
        & l3_lattices(A) )
     => v11_lattices(A) ) ).

fof(t40_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v17_lattices(A)
        & l3_lattices(A) )
     => v3_filter_0(A) ) ).

fof(t41_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v3_filter_0(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_filter_0(D,A)
                 => ( ( r2_hidden(B,D)
                      & r2_hidden(k4_filter_0(A,B,C),D) )
                   => r2_hidden(C,D) ) ) ) ) ) ).

fof(t42_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v3_filter_0(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_filter_0(D,A)
                 => ( r2_hidden(B,D)
                   => r2_hidden(k4_filter_0(A,C,B),D) ) ) ) ) ) ).

fof(t43_filter_0,axiom,
    $true ).

fof(t44_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( ( ~ v1_xboole_0(D)
                    & m1_subset_1(D,k1_zfmisc_1(u1_struct_0(A))) )
                 => ! [E] :
                      ( ( ~ v1_xboole_0(E)
                        & m1_subset_1(E,k1_zfmisc_1(u1_struct_0(A))) )
                     => ( ( r2_hidden(B,D)
                          & r2_hidden(C,E) )
                       => ( r2_hidden(k4_lattices(A,B,C),k5_filter_0(A,D,E))
                          & r2_hidden(k4_lattices(A,C,B),k5_filter_0(A,D,E)) ) ) ) ) ) ) ) ).

fof(t45_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B,C] :
          ( ( ~ v1_xboole_0(C)
            & m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A))) )
         => ! [D] :
              ( ( ~ v1_xboole_0(D)
                & m1_subset_1(D,k1_zfmisc_1(u1_struct_0(A))) )
             => ~ ( r2_hidden(B,k5_filter_0(A,C,D))
                  & ! [E] :
                      ( m1_subset_1(E,u1_struct_0(A))
                     => ! [F] :
                          ( m1_subset_1(F,u1_struct_0(A))
                         => ~ ( B = k4_lattices(A,E,F)
                              & r2_hidden(E,C)
                              & r2_hidden(F,D) ) ) ) ) ) ) ) ).

fof(t46_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( ( ~ v1_xboole_0(B)
            & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
         => ! [C] :
              ( ( ~ v1_xboole_0(C)
                & m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A))) )
             => k5_filter_0(A,B,C) = k5_filter_0(A,C,B) ) ) ) ).

fof(t47_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( ( ~ v1_xboole_0(B)
            & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
         => ! [C] :
              ( ( ~ v1_xboole_0(C)
                & m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A))) )
             => ( k3_filter_0(A,k4_subset_1(u1_struct_0(A),B,C)) = k3_filter_0(A,k4_subset_1(u1_struct_0(A),k3_filter_0(A,B),C))
                & k3_filter_0(A,k4_subset_1(u1_struct_0(A),B,C)) = k3_filter_0(A,k4_subset_1(u1_struct_0(A),B,k3_filter_0(A,C))) ) ) ) ) ).

fof(t49_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ! [C] :
              ( m1_filter_0(C,A)
             => ( r1_tarski(B,k5_filter_0(A,B,C))
                & r1_tarski(C,k5_filter_0(A,B,C)) ) ) ) ) ).

fof(t50_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ! [C] :
              ( m1_filter_0(C,A)
             => k3_filter_0(A,k4_subset_1(u1_struct_0(A),B,C)) = k3_filter_0(A,k5_filter_0(A,B,C)) ) ) ) ).

fof(t51_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v3_filter_0(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ! [C] :
              ( m1_filter_0(C,A)
             => k3_filter_0(A,k4_subset_1(u1_struct_0(A),B,C)) = k6_filter_0(A,B,C) ) ) ) ).

fof(t52_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v17_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ! [C] :
              ( m1_filter_0(C,A)
             => k3_filter_0(A,k4_subset_1(u1_struct_0(A),B,C)) = k7_filter_0(A,B,C) ) ) ) ).

fof(t53_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v3_filter_0(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( ( ~ v1_xboole_0(D)
                    & m1_subset_1(D,k1_zfmisc_1(u1_struct_0(A))) )
                 => ( r2_hidden(B,k3_filter_0(A,k4_subset_1(u1_struct_0(A),D,k6_domain_1(u1_struct_0(A),C))))
                   => r2_hidden(k4_filter_0(A,C,B),k3_filter_0(A,D)) ) ) ) ) ) ).

fof(t54_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v3_filter_0(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ! [E] :
                      ( m1_filter_0(E,A)
                     => ( ( r2_hidden(k4_filter_0(A,B,C),E)
                          & r2_hidden(k4_filter_0(A,C,D),E) )
                       => r2_hidden(k4_filter_0(A,B,D),E) ) ) ) ) ) ) ).

fof(t55_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v17_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => k4_filter_0(A,B,C) = k3_lattices(A,k7_lattices(A,B),C) ) ) ) ).

fof(t56_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v17_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( r3_lattices(A,B,C)
              <=> k4_lattices(A,B,k7_lattices(A,C)) = k5_lattices(A) ) ) ) ) ).

fof(t57_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v17_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ( v1_filter_0(B,A)
          <=> ( B != u1_struct_0(A)
              & ! [C] :
                  ( m1_subset_1(C,u1_struct_0(A))
                 => ( r2_hidden(C,B)
                    | r2_hidden(k7_lattices(A,C),B) ) ) ) ) ) ) ).

fof(t58_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v17_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ( ( B != k1_filter_0(A)
              & v2_filter_0(B,A) )
          <=> v1_filter_0(B,A) ) ) ) ).

fof(t59_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v17_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ( v1_filter_0(B,A)
           => ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ( r2_hidden(C,B)
                <=> ~ r2_hidden(k7_lattices(A,C),B) ) ) ) ) ) ).

fof(t60_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v17_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ~ ( B != C
                  & ! [D] :
                      ( m1_filter_0(D,A)
                     => ~ ( v1_filter_0(D,A)
                          & ( ( r2_hidden(B,D)
                              & ~ r2_hidden(C,D) )
                            | ( ~ r2_hidden(B,D)
                              & r2_hidden(C,D) ) ) ) ) ) ) ) ) ).

fof(d10_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ! [C] :
              ( ( ~ v3_struct_0(C)
                & v10_lattices(C)
                & l3_lattices(C) )
             => ( C = k8_filter_0(A,B)
              <=> ? [D] :
                    ( v1_funct_1(D)
                    & v1_funct_2(D,k2_zfmisc_1(B,B),B)
                    & m2_relset_1(D,k2_zfmisc_1(B,B),B)
                    & ? [E] :
                        ( v1_funct_1(E)
                        & v1_funct_2(E,k2_zfmisc_1(B,B),B)
                        & m2_relset_1(E,k2_zfmisc_1(B,B),B)
                        & D = k1_realset1(u2_lattices(A),B)
                        & E = k1_realset1(u1_lattices(A),B)
                        & C = g3_lattices(B,D,E) ) ) ) ) ) ) ).

fof(t61_filter_0,axiom,
    $true ).

fof(t62_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v3_lattices(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => k8_filter_0(A,k1_filter_0(A)) = A ) ).

fof(t63_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ( u1_struct_0(k8_filter_0(A,B)) = B
            & u2_lattices(k8_filter_0(A,B)) = k1_realset1(u2_lattices(A),B)
            & u1_lattices(k8_filter_0(A,B)) = k1_realset1(u1_lattices(A),B) ) ) ) ).

fof(t64_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_filter_0(D,A)
                 => ! [E] :
                      ( m1_subset_1(E,u1_struct_0(k8_filter_0(A,D)))
                     => ! [F] :
                          ( m1_subset_1(F,u1_struct_0(k8_filter_0(A,D)))
                         => ( ( B = E
                              & C = F )
                           => ( k3_lattices(A,B,C) = k3_lattices(k8_filter_0(A,D),E,F)
                              & k4_lattices(A,B,C) = k4_lattices(k8_filter_0(A,D),E,F) ) ) ) ) ) ) ) ) ).

fof(t65_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_filter_0(D,A)
                 => ! [E] :
                      ( m1_subset_1(E,u1_struct_0(k8_filter_0(A,D)))
                     => ! [F] :
                          ( m1_subset_1(F,u1_struct_0(k8_filter_0(A,D)))
                         => ( ( B = E
                              & C = F )
                           => ( r3_lattices(A,B,C)
                            <=> r3_lattices(k8_filter_0(A,D),E,F) ) ) ) ) ) ) ) ) ).

fof(t66_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ( v14_lattices(A)
           => v14_lattices(k8_filter_0(A,B)) ) ) ) ).

fof(t67_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ( v12_lattices(A)
           => v12_lattices(k8_filter_0(A,B)) ) ) ) ).

fof(t68_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ( v11_lattices(A)
           => v11_lattices(k8_filter_0(A,B)) ) ) ) ).

fof(t69_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ( ( ~ v3_struct_0(A)
              & v10_lattices(A)
              & v3_filter_0(A)
              & l3_lattices(A) )
           => v3_filter_0(k8_filter_0(A,B)) ) ) ) ).

fof(t70_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => v13_lattices(k8_filter_0(A,k2_filter_0(A,B))) ) ) ).

fof(t71_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => k5_lattices(k8_filter_0(A,k2_filter_0(A,B))) = B ) ) ).

fof(t72_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ( v14_lattices(A)
           => k6_lattices(k8_filter_0(A,k2_filter_0(A,B))) = k6_lattices(A) ) ) ) ).

fof(t73_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ( ( ~ v3_struct_0(A)
              & v10_lattices(A)
              & v14_lattices(A)
              & l3_lattices(A) )
           => v15_lattices(k8_filter_0(A,k2_filter_0(A,B))) ) ) ) ).

fof(t74_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ( ( ~ v3_struct_0(A)
              & v10_lattices(A)
              & v15_lattices(A)
              & v16_lattices(A)
              & l3_lattices(A)
              & ~ v3_struct_0(A)
              & v10_lattices(A)
              & v12_lattices(A)
              & l3_lattices(A) )
           => ( ~ v3_struct_0(k8_filter_0(A,k2_filter_0(A,B)))
              & v10_lattices(k8_filter_0(A,k2_filter_0(A,B)))
              & v15_lattices(k8_filter_0(A,k2_filter_0(A,B)))
              & v16_lattices(k8_filter_0(A,k2_filter_0(A,B)))
              & l3_lattices(k8_filter_0(A,k2_filter_0(A,B))) ) ) ) ) ).

fof(t75_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ( ( ~ v3_struct_0(A)
              & v10_lattices(A)
              & v17_lattices(A)
              & l3_lattices(A) )
           => ( ~ v3_struct_0(k8_filter_0(A,k2_filter_0(A,B)))
              & v10_lattices(k8_filter_0(A,k2_filter_0(A,B)))
              & v17_lattices(k8_filter_0(A,k2_filter_0(A,B)))
              & l3_lattices(k8_filter_0(A,k2_filter_0(A,B))) ) ) ) ) ).

fof(d11_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => k9_filter_0(A,B,C) = k4_lattices(A,k4_filter_0(A,B,C),k4_filter_0(A,C,B)) ) ) ) ).

fof(t76_filter_0,axiom,
    $true ).

fof(t77_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => k9_filter_0(A,B,C) = k9_filter_0(A,C,B) ) ) ) ).

fof(t78_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v3_filter_0(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ! [E] :
                      ( m1_filter_0(E,A)
                     => ( ( r2_hidden(k9_filter_0(A,B,C),E)
                          & r2_hidden(k9_filter_0(A,C,D),E) )
                       => r2_hidden(k9_filter_0(A,B,D),E) ) ) ) ) ) ) ).

fof(d12_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ! [C] :
              ( v1_relat_1(C)
             => ( C = k10_filter_0(A,B)
              <=> ( r1_tarski(k3_relat_1(C),u1_struct_0(A))
                  & ! [D] :
                      ( m1_subset_1(D,u1_struct_0(A))
                     => ! [E] :
                          ( m1_subset_1(E,u1_struct_0(A))
                         => ( r2_hidden(k1_domain_1(u1_struct_0(A),u1_struct_0(A),D,E),C)
                          <=> r2_hidden(k9_filter_0(A,D,E),B) ) ) ) ) ) ) ) ) ).

fof(t79_filter_0,axiom,
    $true ).

fof(t80_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => m2_relset_1(k10_filter_0(A,B),u1_struct_0(A),u1_struct_0(A)) ) ) ).

fof(t81_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ( ( ~ v3_struct_0(A)
              & v10_lattices(A)
              & v3_filter_0(A)
              & l3_lattices(A) )
           => r1_relat_2(k10_filter_0(A,B),u1_struct_0(A)) ) ) ) ).

fof(t82_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => r3_relat_2(k10_filter_0(A,B),u1_struct_0(A)) ) ) ).

fof(t83_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ( ( ~ v3_struct_0(A)
              & v10_lattices(A)
              & v3_filter_0(A)
              & l3_lattices(A) )
           => r8_relat_2(k10_filter_0(A,B),u1_struct_0(A)) ) ) ) ).

fof(t84_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ( ( ~ v3_struct_0(A)
              & v10_lattices(A)
              & v3_filter_0(A)
              & l3_lattices(A) )
           => ( v3_relat_2(k10_filter_0(A,B))
              & v8_relat_2(k10_filter_0(A,B))
              & v1_partfun1(k10_filter_0(A,B),u1_struct_0(A),u1_struct_0(A))
              & m2_relset_1(k10_filter_0(A,B),u1_struct_0(A),u1_struct_0(A)) ) ) ) ) ).

fof(t85_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ( ( ~ v3_struct_0(A)
              & v10_lattices(A)
              & v3_filter_0(A)
              & l3_lattices(A) )
           => k3_relat_1(k10_filter_0(A,B)) = u1_struct_0(A) ) ) ) ).

fof(d13_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ( r1_filter_0(A,B,C,D)
                  <=> r2_hidden(k9_filter_0(A,C,D),B) ) ) ) ) ) ).

fof(t86_filter_0,axiom,
    $true ).

fof(t87_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_filter_0(D,A)
                 => ( r1_filter_0(A,D,B,C)
                  <=> r2_hidden(k1_domain_1(u1_struct_0(A),u1_struct_0(A),B,C),k10_filter_0(A,D)) ) ) ) ) ) ).

fof(t88_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v17_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ! [C] :
              ( ( ~ v3_struct_0(C)
                & v10_lattices(C)
                & v3_filter_0(C)
                & l3_lattices(C) )
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(C))
                 => ! [E] :
                      ( m1_filter_0(E,C)
                     => ! [F] :
                          ( m1_subset_1(F,u1_struct_0(A))
                         => ( r1_filter_0(C,E,D,D)
                            & r1_filter_0(A,B,F,F) ) ) ) ) ) ) ) ).

fof(t89_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_filter_0(D,A)
                 => ( r1_filter_0(A,D,B,C)
                   => r1_filter_0(A,D,C,B) ) ) ) ) ) ).

fof(t90_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v17_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ! [C] :
              ( ( ~ v3_struct_0(C)
                & v10_lattices(C)
                & v3_filter_0(C)
                & l3_lattices(C) )
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(C))
                 => ! [E] :
                      ( m1_subset_1(E,u1_struct_0(C))
                     => ! [F] :
                          ( m1_subset_1(F,u1_struct_0(C))
                         => ! [G] :
                              ( m1_filter_0(G,C)
                             => ! [H] :
                                  ( m1_subset_1(H,u1_struct_0(A))
                                 => ! [I] :
                                      ( m1_subset_1(I,u1_struct_0(A))
                                     => ! [J] :
                                          ( m1_subset_1(J,u1_struct_0(A))
                                         => ( ( ( r1_filter_0(C,G,D,E)
                                                & r1_filter_0(C,G,E,F) )
                                             => r1_filter_0(C,G,D,F) )
                                            & ( ( r1_filter_0(A,B,H,I)
                                                & r1_filter_0(A,B,I,J) )
                                             => r1_filter_0(A,B,H,J) ) ) ) ) ) ) ) ) ) ) ) ) ).

fof(dt_m1_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ( ~ v1_xboole_0(B)
            & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) ) ) ) ).

fof(existence_m1_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ? [B] : m1_filter_0(B,A) ) ).

fof(dt_k1_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => m1_filter_0(k1_filter_0(A),A) ) ).

fof(dt_k2_filter_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A)
        & m1_subset_1(B,u1_struct_0(A)) )
     => m1_filter_0(k2_filter_0(A,B),A) ) ).

fof(dt_k3_filter_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A)
        & ~ v1_xboole_0(B)
        & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
     => m1_filter_0(k3_filter_0(A,B),A) ) ).

fof(dt_k4_filter_0,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A)
        & m1_subset_1(B,u1_struct_0(A))
        & m1_subset_1(C,u1_struct_0(A)) )
     => m1_subset_1(k4_filter_0(A,B,C),u1_struct_0(A)) ) ).

fof(dt_k5_filter_0,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A)
        & ~ v1_xboole_0(B)
        & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
        & ~ v1_xboole_0(C)
        & m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A))) )
     => m1_subset_1(k5_filter_0(A,B,C),k1_zfmisc_1(u1_struct_0(A))) ) ).

fof(dt_k6_filter_0,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v11_lattices(A)
        & l3_lattices(A)
        & m1_filter_0(B,A)
        & m1_filter_0(C,A) )
     => m1_filter_0(k6_filter_0(A,B,C),A) ) ).

fof(redefinition_k6_filter_0,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v11_lattices(A)
        & l3_lattices(A)
        & m1_filter_0(B,A)
        & m1_filter_0(C,A) )
     => k6_filter_0(A,B,C) = k5_filter_0(A,B,C) ) ).

fof(dt_k7_filter_0,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v17_lattices(A)
        & l3_lattices(A)
        & m1_filter_0(B,A)
        & m1_filter_0(C,A) )
     => m1_filter_0(k7_filter_0(A,B,C),A) ) ).

fof(redefinition_k7_filter_0,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v17_lattices(A)
        & l3_lattices(A)
        & m1_filter_0(B,A)
        & m1_filter_0(C,A) )
     => k7_filter_0(A,B,C) = k5_filter_0(A,B,C) ) ).

fof(dt_k8_filter_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A)
        & m1_filter_0(B,A) )
     => ( ~ v3_struct_0(k8_filter_0(A,B))
        & v10_lattices(k8_filter_0(A,B))
        & l3_lattices(k8_filter_0(A,B)) ) ) ).

fof(dt_k9_filter_0,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A)
        & m1_subset_1(B,u1_struct_0(A))
        & m1_subset_1(C,u1_struct_0(A)) )
     => m1_subset_1(k9_filter_0(A,B,C),u1_struct_0(A)) ) ).

fof(dt_k10_filter_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A)
        & m1_filter_0(B,A) )
     => v1_relat_1(k10_filter_0(A,B)) ) ).

fof(dt_k11_filter_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v3_filter_0(A)
        & l3_lattices(A)
        & m1_filter_0(B,A) )
     => ( v3_relat_2(k11_filter_0(A,B))
        & v8_relat_2(k11_filter_0(A,B))
        & v1_partfun1(k11_filter_0(A,B),u1_struct_0(A),u1_struct_0(A))
        & m2_relset_1(k11_filter_0(A,B),u1_struct_0(A),u1_struct_0(A)) ) ) ).

fof(redefinition_k11_filter_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v3_filter_0(A)
        & l3_lattices(A)
        & m1_filter_0(B,A) )
     => k11_filter_0(A,B) = k10_filter_0(A,B) ) ).

fof(dt_k12_filter_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v17_lattices(A)
        & l3_lattices(A)
        & m1_filter_0(B,A) )
     => ( v3_relat_2(k12_filter_0(A,B))
        & v8_relat_2(k12_filter_0(A,B))
        & v1_partfun1(k12_filter_0(A,B),u1_struct_0(A),u1_struct_0(A))
        & m2_relset_1(k12_filter_0(A,B),u1_struct_0(A),u1_struct_0(A)) ) ) ).

fof(redefinition_k12_filter_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v17_lattices(A)
        & l3_lattices(A)
        & m1_filter_0(B,A) )
     => k12_filter_0(A,B) = k10_filter_0(A,B) ) ).

fof(d3_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => k2_filter_0(A,B) = a_2_0_filter_0(A,B) ) ) ).

fof(d9_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( ( ~ v1_xboole_0(B)
            & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
         => ! [C] :
              ( ( ~ v1_xboole_0(C)
                & m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A))) )
             => k5_filter_0(A,B,C) = a_3_0_filter_0(A,B,C) ) ) ) ).

fof(t48_filter_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ! [C] :
              ( m1_filter_0(C,A)
             => k3_filter_0(A,k4_subset_1(u1_struct_0(A),B,C)) = a_3_1_filter_0(A,B,C) ) ) ) ).

fof(fraenkel_a_2_0_filter_0,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(B)
        & v10_lattices(B)
        & l3_lattices(B)
        & m1_subset_1(C,u1_struct_0(B)) )
     => ( r2_hidden(A,a_2_0_filter_0(B,C))
      <=> ? [D] :
            ( m1_subset_1(D,u1_struct_0(B))
            & A = D
            & r3_lattices(B,C,D) ) ) ) ).

fof(fraenkel_a_3_0_filter_0,axiom,
    ! [A,B,C,D] :
      ( ( ~ v3_struct_0(B)
        & v10_lattices(B)
        & l3_lattices(B)
        & ~ v1_xboole_0(C)
        & m1_subset_1(C,k1_zfmisc_1(u1_struct_0(B)))
        & ~ v1_xboole_0(D)
        & m1_subset_1(D,k1_zfmisc_1(u1_struct_0(B))) )
     => ( r2_hidden(A,a_3_0_filter_0(B,C,D))
      <=> ? [E,F] :
            ( m1_subset_1(E,u1_struct_0(B))
            & m1_subset_1(F,u1_struct_0(B))
            & A = k4_lattices(B,E,F)
            & r2_hidden(E,C)
            & r2_hidden(F,D) ) ) ) ).

fof(fraenkel_a_3_1_filter_0,axiom,
    ! [A,B,C,D] :
      ( ( ~ v3_struct_0(B)
        & v10_lattices(B)
        & l3_lattices(B)
        & m1_filter_0(C,B)
        & m1_filter_0(D,B) )
     => ( r2_hidden(A,a_3_1_filter_0(B,C,D))
      <=> ? [E] :
            ( m1_subset_1(E,u1_struct_0(B))
            & A = E
            & ? [F] :
                ( m1_subset_1(F,u1_struct_0(B))
                & ? [G] :
                    ( m1_subset_1(G,u1_struct_0(B))
                    & r3_lattices(B,k4_lattices(B,F,G),E)
                    & r2_hidden(F,C)
                    & r2_hidden(G,D) ) ) ) ) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(fc1_filter_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & v3_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m1_relset_1(B,A,A) )
     => ~ v1_xboole_0(k7_eqrel_1(A,B)) ) ).

fof(fc2_filter_1,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & l3_lattices(A)
        & ~ v3_struct_0(B)
        & l3_lattices(B) )
     => ( ~ v3_struct_0(k8_filter_1(A,B))
        & v3_lattices(k8_filter_1(A,B)) ) ) ).

fof(fc3_filter_1,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A)
        & ~ v3_struct_0(B)
        & v10_lattices(B)
        & l3_lattices(B) )
     => ( ~ v3_struct_0(k8_filter_1(A,B))
        & v3_lattices(k8_filter_1(A,B))
        & v4_lattices(k8_filter_1(A,B))
        & v5_lattices(k8_filter_1(A,B))
        & v6_lattices(k8_filter_1(A,B))
        & v7_lattices(k8_filter_1(A,B))
        & v8_lattices(k8_filter_1(A,B))
        & v9_lattices(k8_filter_1(A,B))
        & v10_lattices(k8_filter_1(A,B)) ) ) ).

fof(t1_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ! [C] :
              ( m1_filter_0(C,A)
             => m1_filter_0(k5_subset_1(u1_struct_0(A),B,C),A) ) ) ) ).

fof(t2_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( k2_filter_0(A,B) = k2_filter_0(A,C)
               => B = C ) ) ) ) ).

fof(d1_filter_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,A,A)
                & m2_relset_1(C,A,A) )
             => ( m1_filter_1(C,A,B)
              <=> ! [D] :
                    ( m1_subset_1(D,A)
                   => ! [E] :
                        ( m1_subset_1(E,A)
                       => ( r2_hidden(k1_domain_1(A,A,D,E),B)
                         => r2_hidden(k1_domain_1(A,A,k8_funct_2(A,A,C,D),k8_funct_2(A,A,C,E)),B) ) ) ) ) ) ) ) ).

fof(d2_filter_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( v1_relat_1(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ( m2_filter_1(C,A,B)
              <=> ! [D] :
                    ( m1_subset_1(D,A)
                   => ! [E] :
                        ( m1_subset_1(E,A)
                       => ! [F] :
                            ( m1_subset_1(F,A)
                           => ! [G] :
                                ( m1_subset_1(G,A)
                               => ( ( r2_hidden(k1_domain_1(A,A,D,E),B)
                                    & r2_hidden(k1_domain_1(A,A,F,G),B) )
                                 => r2_hidden(k1_domain_1(A,A,k2_binop_1(A,A,A,C,D,F),k2_binop_1(A,A,A,C,E,G)),B) ) ) ) ) ) ) ) ) ) ).

fof(d3_filter_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v3_relat_2(B)
            & v8_relat_2(B)
            & v1_partfun1(B,A,A)
            & m2_relset_1(B,A,A) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,A,A)
                & m2_relset_1(C,A,A) )
             => ( m1_filter_1(C,A,B)
               => ! [D] :
                    ( ( v1_funct_1(D)
                      & v1_funct_2(D,k8_eqrel_1(A,B),k8_eqrel_1(A,B))
                      & m2_relset_1(D,k8_eqrel_1(A,B),k8_eqrel_1(A,B)) )
                   => ( D = k3_filter_1(A,B,C)
                    <=> ! [E,F] :
                          ( ( r2_hidden(E,k8_eqrel_1(A,B))
                            & r2_hidden(F,E) )
                         => k1_funct_1(D,E) = k6_eqrel_1(A,B,k1_funct_1(C,F)) ) ) ) ) ) ) ) ).

fof(d4_filter_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v3_relat_2(B)
            & v8_relat_2(B)
            & v1_partfun1(B,A,A)
            & m2_relset_1(B,A,A) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ( m2_filter_1(C,A,B)
               => ! [D] :
                    ( ( v1_funct_1(D)
                      & v1_funct_2(D,k2_zfmisc_1(k8_eqrel_1(A,B),k8_eqrel_1(A,B)),k8_eqrel_1(A,B))
                      & m2_relset_1(D,k2_zfmisc_1(k8_eqrel_1(A,B),k8_eqrel_1(A,B)),k8_eqrel_1(A,B)) )
                   => ( D = k4_filter_1(A,B,C)
                    <=> ! [E,F,G,H] :
                          ( ( r2_hidden(E,k8_eqrel_1(A,B))
                            & r2_hidden(F,k8_eqrel_1(A,B))
                            & r2_hidden(G,E)
                            & r2_hidden(H,F) )
                         => k1_binop_1(D,E,F) = k6_eqrel_1(A,B,k1_binop_1(C,G,H)) ) ) ) ) ) ) ) ).

fof(t3_filter_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v3_relat_2(B)
            & v8_relat_2(B)
            & v1_partfun1(B,A,A)
            & m2_relset_1(B,A,A) )
         => ! [C] :
              ( m1_subset_1(C,A)
             => ! [D] :
                  ( m1_subset_1(D,A)
                 => ! [E] :
                      ( m2_filter_1(E,A,B)
                     => k2_binop_1(k8_eqrel_1(A,B),k8_eqrel_1(A,B),k8_eqrel_1(A,B),k4_filter_1(A,B,E),k2_filter_1(A,B,C),k2_filter_1(A,B,D)) = k2_filter_1(A,B,k2_binop_1(A,A,A,E,C,D)) ) ) ) ) ) ).

fof(t4_filter_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v3_relat_2(B)
            & v8_relat_2(B)
            & v1_partfun1(B,A,A)
            & m2_relset_1(B,A,A) )
         => ! [C] :
              ( m2_filter_1(C,A,B)
             => ( v1_binop_1(C,A)
               => v1_binop_1(k4_filter_1(A,B,C),k8_eqrel_1(A,B)) ) ) ) ) ).

fof(t5_filter_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v3_relat_2(B)
            & v8_relat_2(B)
            & v1_partfun1(B,A,A)
            & m2_relset_1(B,A,A) )
         => ! [C] :
              ( m2_filter_1(C,A,B)
             => ( v2_binop_1(C,A)
               => v2_binop_1(k4_filter_1(A,B,C),k8_eqrel_1(A,B)) ) ) ) ) ).

fof(t6_filter_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v3_relat_2(B)
            & v8_relat_2(B)
            & v1_partfun1(B,A,A)
            & m2_relset_1(B,A,A) )
         => ! [C] :
              ( m1_subset_1(C,A)
             => ! [D] :
                  ( m2_filter_1(D,A,B)
                 => ( r1_binop_1(A,C,D)
                   => r1_binop_1(k8_eqrel_1(A,B),k2_filter_1(A,B,C),k4_filter_1(A,B,D)) ) ) ) ) ) ).

fof(t7_filter_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v3_relat_2(B)
            & v8_relat_2(B)
            & v1_partfun1(B,A,A)
            & m2_relset_1(B,A,A) )
         => ! [C] :
              ( m1_subset_1(C,A)
             => ! [D] :
                  ( m2_filter_1(D,A,B)
                 => ( r2_binop_1(A,C,D)
                   => r2_binop_1(k8_eqrel_1(A,B),k2_filter_1(A,B,C),k4_filter_1(A,B,D)) ) ) ) ) ) ).

fof(t8_filter_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v3_relat_2(B)
            & v8_relat_2(B)
            & v1_partfun1(B,A,A)
            & m2_relset_1(B,A,A) )
         => ! [C] :
              ( m1_subset_1(C,A)
             => ! [D] :
                  ( m2_filter_1(D,A,B)
                 => ( r3_binop_1(A,C,D)
                   => r3_binop_1(k8_eqrel_1(A,B),k2_filter_1(A,B,C),k4_filter_1(A,B,D)) ) ) ) ) ) ).

fof(t9_filter_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v3_relat_2(B)
            & v8_relat_2(B)
            & v1_partfun1(B,A,A)
            & m2_relset_1(B,A,A) )
         => ! [C] :
              ( m2_filter_1(C,A,B)
             => ! [D] :
                  ( m2_filter_1(D,A,B)
                 => ( r4_binop_1(A,C,D)
                   => r4_binop_1(k8_eqrel_1(A,B),k4_filter_1(A,B,C),k4_filter_1(A,B,D)) ) ) ) ) ) ).

fof(t10_filter_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v3_relat_2(B)
            & v8_relat_2(B)
            & v1_partfun1(B,A,A)
            & m2_relset_1(B,A,A) )
         => ! [C] :
              ( m2_filter_1(C,A,B)
             => ! [D] :
                  ( m2_filter_1(D,A,B)
                 => ( r5_binop_1(A,C,D)
                   => r5_binop_1(k8_eqrel_1(A,B),k4_filter_1(A,B,C),k4_filter_1(A,B,D)) ) ) ) ) ) ).

fof(t11_filter_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v3_relat_2(B)
            & v8_relat_2(B)
            & v1_partfun1(B,A,A)
            & m2_relset_1(B,A,A) )
         => ! [C] :
              ( m2_filter_1(C,A,B)
             => ! [D] :
                  ( m2_filter_1(D,A,B)
                 => ( r6_binop_1(A,C,D)
                   => r6_binop_1(k8_eqrel_1(A,B),k4_filter_1(A,B,C),k4_filter_1(A,B,D)) ) ) ) ) ) ).

fof(t12_filter_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v3_relat_2(B)
            & v8_relat_2(B)
            & v1_partfun1(B,A,A)
            & m2_relset_1(B,A,A) )
         => ! [C] :
              ( m2_filter_1(C,A,B)
             => ! [D] :
                  ( m2_filter_1(D,A,B)
                 => ( r1_lattice2(A,C,D)
                   => r1_lattice2(k8_eqrel_1(A,B),k4_filter_1(A,B,C),k4_filter_1(A,B,D)) ) ) ) ) ) ).

fof(t13_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v3_filter_0(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => m2_filter_1(u2_lattices(A),u1_struct_0(A),k11_filter_0(A,B)) ) ) ).

fof(t14_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v3_filter_0(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => m2_filter_1(u1_lattices(A),u1_struct_0(A),k11_filter_0(A,B)) ) ) ).

fof(d5_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ( ( ~ v3_struct_0(A)
              & v10_lattices(A)
              & v3_filter_0(A)
              & l3_lattices(A) )
           => ! [C] :
                ( ( ~ v3_struct_0(C)
                  & v3_lattices(C)
                  & v10_lattices(C)
                  & l3_lattices(C) )
               => ( C = k5_filter_1(A,B)
                <=> ! [D] :
                      ( ( v3_relat_2(D)
                        & v8_relat_2(D)
                        & v1_partfun1(D,u1_struct_0(A),u1_struct_0(A))
                        & m2_relset_1(D,u1_struct_0(A),u1_struct_0(A)) )
                     => ( D = k10_filter_0(A,B)
                       => C = g3_lattices(k8_eqrel_1(u1_struct_0(A),D),k4_filter_1(u1_struct_0(A),D,u2_lattices(A)),k4_filter_1(u1_struct_0(A),D,u1_lattices(A))) ) ) ) ) ) ) ) ).

fof(d6_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( ( ~ v3_struct_0(A)
                  & v10_lattices(A)
                  & v3_filter_0(A)
                  & l3_lattices(A) )
               => ! [D] :
                    ( m1_subset_1(D,u1_struct_0(k5_filter_1(A,B)))
                   => ( D = k6_filter_1(A,B,C)
                    <=> ! [E] :
                          ( ( v3_relat_2(E)
                            & v8_relat_2(E)
                            & v1_partfun1(E,u1_struct_0(A),u1_struct_0(A))
                            & m2_relset_1(E,u1_struct_0(A),u1_struct_0(A)) )
                         => ( E = k10_filter_0(A,B)
                           => D = k2_filter_1(u1_struct_0(A),E,C) ) ) ) ) ) ) ) ) ).

fof(t15_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v3_filter_0(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ( k3_lattices(k5_filter_1(A,B),k6_filter_1(A,B,C),k6_filter_1(A,B,D)) = k6_filter_1(A,B,k3_lattices(A,C,D))
                    & k4_lattices(k5_filter_1(A,B),k6_filter_1(A,B,C),k6_filter_1(A,B,D)) = k6_filter_1(A,B,k4_lattices(A,C,D)) ) ) ) ) ) ).

fof(t16_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v3_filter_0(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ( r3_lattices(k5_filter_1(A,B),k6_filter_1(A,B,C),k6_filter_1(A,B,D))
                  <=> r2_hidden(k4_filter_0(A,C,D),B) ) ) ) ) ) ).

fof(t17_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v3_filter_0(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => k4_filter_0(A,k4_lattices(A,B,C),D) = k4_filter_0(A,B,k4_filter_0(A,C,D)) ) ) ) ) ).

fof(t18_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v3_filter_0(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ( v13_lattices(A)
           => ( ~ v3_struct_0(k5_filter_1(A,B))
              & v10_lattices(k5_filter_1(A,B))
              & v13_lattices(k5_filter_1(A,B))
              & l3_lattices(k5_filter_1(A,B))
              & k5_lattices(k5_filter_1(A,B)) = k6_filter_1(A,B,k5_lattices(A)) ) ) ) ) ).

fof(t19_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v3_filter_0(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ( ~ v3_struct_0(k5_filter_1(A,B))
            & v10_lattices(k5_filter_1(A,B))
            & v14_lattices(k5_filter_1(A,B))
            & l3_lattices(k5_filter_1(A,B))
            & k6_lattices(k5_filter_1(A,B)) = k6_filter_1(A,B,k6_lattices(A)) ) ) ) ).

fof(t20_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v3_filter_0(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => v3_filter_0(k5_filter_1(A,B)) ) ) ).

fof(t21_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v17_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ( ~ v3_struct_0(k5_filter_1(A,B))
            & v10_lattices(k5_filter_1(A,B))
            & v17_lattices(k5_filter_1(A,B))
            & l3_lattices(k5_filter_1(A,B)) ) ) ) ).

fof(t22_filter_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( m1_subset_1(C,A)
             => ! [D] :
                  ( m1_subset_1(D,A)
                 => ! [E] :
                      ( m1_subset_1(E,B)
                     => ! [F] :
                          ( m1_subset_1(F,B)
                         => ! [G] :
                              ( ( v1_funct_1(G)
                                & v1_funct_2(G,k2_zfmisc_1(A,A),A)
                                & m2_relset_1(G,k2_zfmisc_1(A,A),A) )
                             => ! [H] :
                                  ( ( v1_funct_1(H)
                                    & v1_funct_2(H,k2_zfmisc_1(B,B),B)
                                    & m2_relset_1(H,k2_zfmisc_1(B,B),B) )
                                 => k2_binop_1(k2_zfmisc_1(A,B),k2_zfmisc_1(A,B),k2_zfmisc_1(A,B),k7_filter_1(A,B,G,H),k1_domain_1(A,B,C,E),k1_domain_1(A,B,D,F)) = k1_domain_1(A,B,k2_binop_1(A,A,A,G,C,D),k2_binop_1(B,B,B,H,E,F)) ) ) ) ) ) ) ) ) ).

fof(t23_filter_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,k2_zfmisc_1(B,B),B)
                    & m2_relset_1(D,k2_zfmisc_1(B,B),B) )
                 => ( ( v1_binop_1(C,A)
                      & v1_binop_1(D,B) )
                  <=> v1_binop_1(k7_filter_1(A,B,C,D),k2_zfmisc_1(A,B)) ) ) ) ) ) ).

fof(t24_filter_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,k2_zfmisc_1(B,B),B)
                    & m2_relset_1(D,k2_zfmisc_1(B,B),B) )
                 => ( ( v2_binop_1(C,A)
                      & v2_binop_1(D,B) )
                  <=> v2_binop_1(k7_filter_1(A,B,C,D),k2_zfmisc_1(A,B)) ) ) ) ) ) ).

fof(t25_filter_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( m1_subset_1(C,A)
             => ! [D] :
                  ( m1_subset_1(D,B)
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,k2_zfmisc_1(A,A),A)
                        & m2_relset_1(E,k2_zfmisc_1(A,A),A) )
                     => ! [F] :
                          ( ( v1_funct_1(F)
                            & v1_funct_2(F,k2_zfmisc_1(B,B),B)
                            & m2_relset_1(F,k2_zfmisc_1(B,B),B) )
                         => ( ( r1_binop_1(A,C,E)
                              & r1_binop_1(B,D,F) )
                          <=> r1_binop_1(k2_zfmisc_1(A,B),k1_domain_1(A,B,C,D),k7_filter_1(A,B,E,F)) ) ) ) ) ) ) ) ).

fof(t26_filter_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( m1_subset_1(C,A)
             => ! [D] :
                  ( m1_subset_1(D,B)
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,k2_zfmisc_1(A,A),A)
                        & m2_relset_1(E,k2_zfmisc_1(A,A),A) )
                     => ! [F] :
                          ( ( v1_funct_1(F)
                            & v1_funct_2(F,k2_zfmisc_1(B,B),B)
                            & m2_relset_1(F,k2_zfmisc_1(B,B),B) )
                         => ( ( r2_binop_1(A,C,E)
                              & r2_binop_1(B,D,F) )
                          <=> r2_binop_1(k2_zfmisc_1(A,B),k1_domain_1(A,B,C,D),k7_filter_1(A,B,E,F)) ) ) ) ) ) ) ) ).

fof(t27_filter_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( m1_subset_1(C,A)
             => ! [D] :
                  ( m1_subset_1(D,B)
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,k2_zfmisc_1(A,A),A)
                        & m2_relset_1(E,k2_zfmisc_1(A,A),A) )
                     => ! [F] :
                          ( ( v1_funct_1(F)
                            & v1_funct_2(F,k2_zfmisc_1(B,B),B)
                            & m2_relset_1(F,k2_zfmisc_1(B,B),B) )
                         => ( ( r3_binop_1(A,C,E)
                              & r3_binop_1(B,D,F) )
                          <=> r3_binop_1(k2_zfmisc_1(A,B),k1_domain_1(A,B,C,D),k7_filter_1(A,B,E,F)) ) ) ) ) ) ) ) ).

fof(t28_filter_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,k2_zfmisc_1(A,A),A)
                    & m2_relset_1(D,k2_zfmisc_1(A,A),A) )
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,k2_zfmisc_1(B,B),B)
                        & m2_relset_1(E,k2_zfmisc_1(B,B),B) )
                     => ! [F] :
                          ( ( v1_funct_1(F)
                            & v1_funct_2(F,k2_zfmisc_1(B,B),B)
                            & m2_relset_1(F,k2_zfmisc_1(B,B),B) )
                         => ( ( r4_binop_1(A,C,D)
                              & r4_binop_1(B,E,F) )
                          <=> r4_binop_1(k2_zfmisc_1(A,B),k7_filter_1(A,B,C,E),k7_filter_1(A,B,D,F)) ) ) ) ) ) ) ) ).

fof(t29_filter_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,k2_zfmisc_1(A,A),A)
                    & m2_relset_1(D,k2_zfmisc_1(A,A),A) )
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,k2_zfmisc_1(B,B),B)
                        & m2_relset_1(E,k2_zfmisc_1(B,B),B) )
                     => ! [F] :
                          ( ( v1_funct_1(F)
                            & v1_funct_2(F,k2_zfmisc_1(B,B),B)
                            & m2_relset_1(F,k2_zfmisc_1(B,B),B) )
                         => ( ( r5_binop_1(A,C,D)
                              & r5_binop_1(B,E,F) )
                          <=> r5_binop_1(k2_zfmisc_1(A,B),k7_filter_1(A,B,C,E),k7_filter_1(A,B,D,F)) ) ) ) ) ) ) ) ).

fof(t30_filter_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,k2_zfmisc_1(A,A),A)
                    & m2_relset_1(D,k2_zfmisc_1(A,A),A) )
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,k2_zfmisc_1(B,B),B)
                        & m2_relset_1(E,k2_zfmisc_1(B,B),B) )
                     => ! [F] :
                          ( ( v1_funct_1(F)
                            & v1_funct_2(F,k2_zfmisc_1(B,B),B)
                            & m2_relset_1(F,k2_zfmisc_1(B,B),B) )
                         => ( ( r6_binop_1(A,C,D)
                              & r6_binop_1(B,E,F) )
                          <=> r6_binop_1(k2_zfmisc_1(A,B),k7_filter_1(A,B,C,E),k7_filter_1(A,B,D,F)) ) ) ) ) ) ) ) ).

fof(t31_filter_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,k2_zfmisc_1(A,A),A)
                & m2_relset_1(C,k2_zfmisc_1(A,A),A) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,k2_zfmisc_1(A,A),A)
                    & m2_relset_1(D,k2_zfmisc_1(A,A),A) )
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,k2_zfmisc_1(B,B),B)
                        & m2_relset_1(E,k2_zfmisc_1(B,B),B) )
                     => ! [F] :
                          ( ( v1_funct_1(F)
                            & v1_funct_2(F,k2_zfmisc_1(B,B),B)
                            & m2_relset_1(F,k2_zfmisc_1(B,B),B) )
                         => ( ( r1_lattice2(A,C,D)
                              & r1_lattice2(B,E,F) )
                          <=> r1_lattice2(k2_zfmisc_1(A,B),k7_filter_1(A,B,C,E),k7_filter_1(A,B,D,F)) ) ) ) ) ) ) ) ).

fof(d7_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l3_lattices(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l3_lattices(B) )
         => k8_filter_1(A,B) = g3_lattices(k2_zfmisc_1(u1_struct_0(A),u1_struct_0(B)),k7_filter_1(u1_struct_0(A),u1_struct_0(B),u2_lattices(A),u2_lattices(B)),k7_filter_1(u1_struct_0(A),u1_struct_0(B),u1_lattices(A),u1_lattices(B))) ) ) ).

fof(t32_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( r2_hidden(k1_domain_1(u1_struct_0(A),u1_struct_0(A),B,C),k9_filter_1(A))
              <=> r3_lattices(A,B,C) ) ) ) ) ).

fof(t33_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ( k1_relat_1(k9_filter_1(A)) = u1_struct_0(A)
        & k2_relat_1(k9_filter_1(A)) = u1_struct_0(A)
        & k3_relat_1(k9_filter_1(A)) = u1_struct_0(A) ) ) ).

fof(d9_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v10_lattices(B)
            & l3_lattices(B) )
         => ( r1_filter_1(A,B)
          <=> r4_wellord1(k9_filter_1(A),k9_filter_1(B)) ) ) ) ).

fof(t34_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v10_lattices(B)
            & l3_lattices(B) )
         => ! [C] :
              ( ( ~ v3_struct_0(C)
                & v10_lattices(C)
                & l3_lattices(C) )
             => ( ( r1_filter_1(A,B)
                  & r1_filter_1(B,C) )
               => r1_filter_1(A,C) ) ) ) ) ).

fof(t35_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l3_lattices(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l3_lattices(B) )
         => ( ( ~ v3_struct_0(k8_filter_1(A,B))
              & v10_lattices(k8_filter_1(A,B))
              & l3_lattices(k8_filter_1(A,B)) )
           => ( ~ v3_struct_0(A)
              & v10_lattices(A)
              & l3_lattices(A)
              & ~ v3_struct_0(B)
              & v10_lattices(B)
              & l3_lattices(B) ) ) ) ) ).

fof(t36_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v10_lattices(B)
            & l3_lattices(B) )
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ! [E] :
                      ( m1_subset_1(E,u1_struct_0(B))
                     => ! [F] :
                          ( m1_subset_1(F,u1_struct_0(B))
                         => ( k3_lattices(k8_filter_1(A,B),k10_filter_1(A,B,C,E),k10_filter_1(A,B,D,F)) = k10_filter_1(A,B,k3_lattices(A,C,D),k3_lattices(B,E,F))
                            & k4_lattices(k8_filter_1(A,B),k10_filter_1(A,B,C,E),k10_filter_1(A,B,D,F)) = k10_filter_1(A,B,k4_lattices(A,C,D),k4_lattices(B,E,F)) ) ) ) ) ) ) ) ).

fof(t37_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v10_lattices(B)
            & l3_lattices(B) )
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ! [E] :
                      ( m1_subset_1(E,u1_struct_0(B))
                     => ! [F] :
                          ( m1_subset_1(F,u1_struct_0(B))
                         => ( r3_lattices(k8_filter_1(A,B),k10_filter_1(A,B,C,E),k10_filter_1(A,B,D,F))
                          <=> ( r3_lattices(A,C,D)
                              & r3_lattices(B,E,F) ) ) ) ) ) ) ) ) ).

fof(t38_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v10_lattices(B)
            & l3_lattices(B) )
         => ( ( v12_lattices(A)
              & v12_lattices(B) )
          <=> v12_lattices(k8_filter_1(A,B)) ) ) ) ).

fof(t39_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v10_lattices(B)
            & l3_lattices(B) )
         => ( ( ~ v3_struct_0(A)
              & v10_lattices(A)
              & v11_lattices(A)
              & l3_lattices(A)
              & ~ v3_struct_0(B)
              & v10_lattices(B)
              & v11_lattices(B)
              & l3_lattices(B) )
          <=> ( ~ v3_struct_0(k8_filter_1(A,B))
              & v10_lattices(k8_filter_1(A,B))
              & v11_lattices(k8_filter_1(A,B))
              & l3_lattices(k8_filter_1(A,B)) ) ) ) ) ).

fof(t40_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v10_lattices(B)
            & l3_lattices(B) )
         => ( ( v13_lattices(A)
              & v13_lattices(B) )
          <=> v13_lattices(k8_filter_1(A,B)) ) ) ) ).

fof(t41_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v10_lattices(B)
            & l3_lattices(B) )
         => ( ( v14_lattices(A)
              & v14_lattices(B) )
          <=> v14_lattices(k8_filter_1(A,B)) ) ) ) ).

fof(t42_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v10_lattices(B)
            & l3_lattices(B) )
         => ( ( v15_lattices(A)
              & v15_lattices(B) )
          <=> v15_lattices(k8_filter_1(A,B)) ) ) ) ).

fof(t43_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v10_lattices(B)
            & l3_lattices(B) )
         => ( ( ~ v3_struct_0(A)
              & v10_lattices(A)
              & v13_lattices(A)
              & l3_lattices(A)
              & ~ v3_struct_0(B)
              & v10_lattices(B)
              & v13_lattices(B)
              & l3_lattices(B) )
           => k5_lattices(k8_filter_1(A,B)) = k10_filter_1(A,B,k5_lattices(A),k5_lattices(B)) ) ) ) ).

fof(t44_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v10_lattices(B)
            & l3_lattices(B) )
         => ( ( ~ v3_struct_0(A)
              & v10_lattices(A)
              & v14_lattices(A)
              & l3_lattices(A)
              & ~ v3_struct_0(B)
              & v10_lattices(B)
              & v14_lattices(B)
              & l3_lattices(B) )
           => k6_lattices(k8_filter_1(A,B)) = k10_filter_1(A,B,k6_lattices(A),k6_lattices(B)) ) ) ) ).

fof(t45_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v10_lattices(B)
            & l3_lattices(B) )
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ! [E] :
                      ( m1_subset_1(E,u1_struct_0(B))
                     => ! [F] :
                          ( m1_subset_1(F,u1_struct_0(B))
                         => ( ( ~ v3_struct_0(A)
                              & v10_lattices(A)
                              & v15_lattices(A)
                              & l3_lattices(A)
                              & ~ v3_struct_0(B)
                              & v10_lattices(B)
                              & v15_lattices(B)
                              & l3_lattices(B) )
                           => ( ( r2_lattices(A,C,D)
                                & r2_lattices(B,E,F) )
                            <=> r2_lattices(k8_filter_1(A,B),k10_filter_1(A,B,C,E),k10_filter_1(A,B,D,F)) ) ) ) ) ) ) ) ) ).

fof(t46_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v10_lattices(B)
            & l3_lattices(B) )
         => ( ( ~ v3_struct_0(A)
              & v10_lattices(A)
              & v15_lattices(A)
              & v16_lattices(A)
              & l3_lattices(A)
              & ~ v3_struct_0(B)
              & v10_lattices(B)
              & v15_lattices(B)
              & v16_lattices(B)
              & l3_lattices(B) )
          <=> ( ~ v3_struct_0(k8_filter_1(A,B))
              & v10_lattices(k8_filter_1(A,B))
              & v15_lattices(k8_filter_1(A,B))
              & v16_lattices(k8_filter_1(A,B))
              & l3_lattices(k8_filter_1(A,B)) ) ) ) ) ).

fof(t47_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v10_lattices(B)
            & l3_lattices(B) )
         => ( ( ~ v3_struct_0(A)
              & v10_lattices(A)
              & v17_lattices(A)
              & l3_lattices(A)
              & ~ v3_struct_0(B)
              & v10_lattices(B)
              & v17_lattices(B)
              & l3_lattices(B) )
          <=> ( ~ v3_struct_0(k8_filter_1(A,B))
              & v10_lattices(k8_filter_1(A,B))
              & v17_lattices(k8_filter_1(A,B))
              & l3_lattices(k8_filter_1(A,B)) ) ) ) ) ).

fof(t48_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v10_lattices(B)
            & l3_lattices(B) )
         => ( ( v3_filter_0(A)
              & v3_filter_0(B) )
          <=> v3_filter_0(k8_filter_1(A,B)) ) ) ) ).

fof(t49_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v10_lattices(B)
            & l3_lattices(B) )
         => k1_lattice2(k8_filter_1(A,B)) = k8_filter_1(k1_lattice2(A),k1_lattice2(B)) ) ) ).

fof(t50_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v10_lattices(B)
            & l3_lattices(B) )
         => r1_filter_1(k8_filter_1(A,B),k8_filter_1(B,A)) ) ) ).

fof(t51_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v17_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => k9_filter_0(A,B,C) = k3_lattices(A,k4_lattices(A,B,C),k4_lattices(A,k7_lattices(A,B),k7_lattices(A,C))) ) ) ) ).

fof(t52_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v17_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( k7_lattices(A,k4_filter_0(A,B,C)) = k4_lattices(A,B,k7_lattices(A,C))
                & k7_lattices(A,k9_filter_0(A,B,C)) = k3_lattices(A,k4_lattices(A,B,k7_lattices(A,C)),k4_lattices(A,k7_lattices(A,B),C))
                & k7_lattices(A,k9_filter_0(A,B,C)) = k9_filter_0(A,B,k7_lattices(A,C))
                & k7_lattices(A,k9_filter_0(A,B,C)) = k9_filter_0(A,k7_lattices(A,B),C) ) ) ) ) ).

fof(t53_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v17_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ( k9_filter_0(A,B,C) = k9_filter_0(A,B,D)
                   => C = D ) ) ) ) ) ).

fof(t54_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v17_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => k9_filter_0(A,B,k9_filter_0(A,B,C)) = C ) ) ) ).

fof(t55_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v3_filter_0(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( k4_filter_0(A,k3_lattices(A,B,C),B) = k4_filter_0(A,C,B)
                & k4_filter_0(A,B,k4_lattices(A,B,C)) = k4_filter_0(A,B,C) ) ) ) ) ).

fof(t56_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v3_filter_0(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ( r3_lattices(A,k4_filter_0(A,B,C),k4_filter_0(A,B,k3_lattices(A,C,D)))
                    & r3_lattices(A,k4_filter_0(A,B,C),k4_filter_0(A,k4_lattices(A,B,D),C))
                    & r3_lattices(A,k4_filter_0(A,B,C),k4_filter_0(A,B,k3_lattices(A,D,C)))
                    & r3_lattices(A,k4_filter_0(A,B,C),k4_filter_0(A,k4_lattices(A,D,B),C)) ) ) ) ) ) ).

fof(t57_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v3_filter_0(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => r3_lattices(A,k4_lattices(A,k4_filter_0(A,B,C),k4_filter_0(A,D,C)),k4_filter_0(A,k3_lattices(A,B,D),C)) ) ) ) ) ).

fof(t58_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v3_filter_0(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => r3_lattices(A,k4_lattices(A,k4_filter_0(A,B,C),k4_filter_0(A,B,D)),k4_filter_0(A,B,k4_lattices(A,C,D))) ) ) ) ) ).

fof(t59_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v3_filter_0(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ! [E] :
                      ( m1_subset_1(E,u1_struct_0(A))
                     => ! [F] :
                          ( m1_subset_1(F,u1_struct_0(A))
                         => ( ( r2_hidden(k9_filter_0(A,C,D),B)
                              & r2_hidden(k9_filter_0(A,E,F),B) )
                           => ( r2_hidden(k9_filter_0(A,k3_lattices(A,C,E),k3_lattices(A,D,F)),B)
                              & r2_hidden(k9_filter_0(A,k4_lattices(A,C,E),k4_lattices(A,D,F)),B) ) ) ) ) ) ) ) ) ).

fof(t60_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v3_filter_0(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_filter_0(B,A)
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ! [E] :
                      ( m1_subset_1(E,u1_struct_0(A))
                     => ( ( r2_hidden(C,k2_filter_1(u1_struct_0(A),k11_filter_0(A,B),D))
                          & r2_hidden(E,k2_filter_1(u1_struct_0(A),k11_filter_0(A,B),D)) )
                       => ( r2_hidden(k3_lattices(A,C,E),k2_filter_1(u1_struct_0(A),k11_filter_0(A,B),D))
                          & r2_hidden(k4_lattices(A,C,E),k2_filter_1(u1_struct_0(A),k11_filter_0(A,B),D)) ) ) ) ) ) ) ) ).

fof(t61_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v17_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( r2_hidden(k3_lattices(A,B,k9_filter_0(A,B,C)),k2_filter_1(u1_struct_0(A),k12_filter_0(A,k2_filter_0(A,C)),B))
                & ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => ( r2_hidden(D,k2_filter_1(u1_struct_0(A),k12_filter_0(A,k2_filter_0(A,C)),B))
                     => r3_lattices(A,D,k3_lattices(A,B,k9_filter_0(A,B,C))) ) ) ) ) ) ) ).

fof(t62_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v17_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => r1_filter_1(A,k8_filter_1(k5_filter_1(A,k2_filter_0(A,B)),k8_filter_0(A,k2_filter_0(A,B)))) ) ) ).

fof(s1_filter_1,axiom,
    ( ! [A] :
        ( m1_subset_1(A,f1_s1_filter_1)
       => p1_s1_filter_1(k2_filter_1(f1_s1_filter_1,f2_s1_filter_1,A)) )
   => ! [A] :
        ( m2_subset_1(A,k1_zfmisc_1(f1_s1_filter_1),k8_eqrel_1(f1_s1_filter_1,f2_s1_filter_1))
       => p1_s1_filter_1(A) ) ) ).

fof(s2_filter_1,axiom,
    ( ! [A] :
        ( m1_subset_1(A,f1_s2_filter_1)
       => ! [B] :
            ( m1_subset_1(B,f1_s2_filter_1)
           => p1_s2_filter_1(k2_filter_1(f1_s2_filter_1,f2_s2_filter_1,A),k2_filter_1(f1_s2_filter_1,f2_s2_filter_1,B)) ) )
   => ! [A] :
        ( m2_subset_1(A,k1_zfmisc_1(f1_s2_filter_1),k8_eqrel_1(f1_s2_filter_1,f2_s2_filter_1))
       => ! [B] :
            ( m2_subset_1(B,k1_zfmisc_1(f1_s2_filter_1),k8_eqrel_1(f1_s2_filter_1,f2_s2_filter_1))
           => p1_s2_filter_1(A,B) ) ) ) ).

fof(s3_filter_1,axiom,
    ( ! [A] :
        ( m1_subset_1(A,f1_s3_filter_1)
       => ! [B] :
            ( m1_subset_1(B,f1_s3_filter_1)
           => ! [C] :
                ( m1_subset_1(C,f1_s3_filter_1)
               => p1_s3_filter_1(k2_filter_1(f1_s3_filter_1,f2_s3_filter_1,A),k2_filter_1(f1_s3_filter_1,f2_s3_filter_1,B),k2_filter_1(f1_s3_filter_1,f2_s3_filter_1,C)) ) ) )
   => ! [A] :
        ( m2_subset_1(A,k1_zfmisc_1(f1_s3_filter_1),k8_eqrel_1(f1_s3_filter_1,f2_s3_filter_1))
       => ! [B] :
            ( m2_subset_1(B,k1_zfmisc_1(f1_s3_filter_1),k8_eqrel_1(f1_s3_filter_1,f2_s3_filter_1))
           => ! [C] :
                ( m2_subset_1(C,k1_zfmisc_1(f1_s3_filter_1),k8_eqrel_1(f1_s3_filter_1,f2_s3_filter_1))
               => p1_s3_filter_1(A,B,C) ) ) ) ) ).

fof(s4_filter_1,axiom,
    ( ! [A] :
        ( m1_subset_1(A,f1_s4_filter_1)
       => ! [B] :
            ( m1_subset_1(B,f2_s4_filter_1)
           => p1_s4_filter_1(k1_domain_1(f1_s4_filter_1,f2_s4_filter_1,A,B)) ) )
   => ! [A] :
        ( m1_subset_1(A,k2_zfmisc_1(f1_s4_filter_1,f2_s4_filter_1))
       => p1_s4_filter_1(A) ) ) ).

fof(s5_filter_1,axiom,
    ( ! [A] :
        ( m1_subset_1(A,f1_s5_filter_1)
       => ! [B] :
            ( m1_subset_1(B,f1_s5_filter_1)
           => ! [C] :
                ( m1_subset_1(C,f2_s5_filter_1)
               => ! [D] :
                    ( m1_subset_1(D,f2_s5_filter_1)
                   => p1_s5_filter_1(k1_domain_1(f1_s5_filter_1,f2_s5_filter_1,A,C),k1_domain_1(f1_s5_filter_1,f2_s5_filter_1,B,D)) ) ) ) )
   => ! [A] :
        ( m1_subset_1(A,k2_zfmisc_1(f1_s5_filter_1,f2_s5_filter_1))
       => ! [B] :
            ( m1_subset_1(B,k2_zfmisc_1(f1_s5_filter_1,f2_s5_filter_1))
           => p1_s5_filter_1(A,B) ) ) ) ).

fof(s6_filter_1,axiom,
    ( ! [A] :
        ( m1_subset_1(A,f1_s6_filter_1)
       => ! [B] :
            ( m1_subset_1(B,f1_s6_filter_1)
           => ! [C] :
                ( m1_subset_1(C,f1_s6_filter_1)
               => ! [D] :
                    ( m1_subset_1(D,f2_s6_filter_1)
                   => ! [E] :
                        ( m1_subset_1(E,f2_s6_filter_1)
                       => ! [F] :
                            ( m1_subset_1(F,f2_s6_filter_1)
                           => p1_s6_filter_1(k1_domain_1(f1_s6_filter_1,f2_s6_filter_1,A,D),k1_domain_1(f1_s6_filter_1,f2_s6_filter_1,B,E),k1_domain_1(f1_s6_filter_1,f2_s6_filter_1,C,F)) ) ) ) ) ) )
   => ! [A] :
        ( m1_subset_1(A,k2_zfmisc_1(f1_s6_filter_1,f2_s6_filter_1))
       => ! [B] :
            ( m1_subset_1(B,k2_zfmisc_1(f1_s6_filter_1,f2_s6_filter_1))
           => ! [C] :
                ( m1_subset_1(C,k2_zfmisc_1(f1_s6_filter_1,f2_s6_filter_1))
               => p1_s6_filter_1(A,B,C) ) ) ) ) ).

fof(dt_m1_filter_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & v1_relat_1(B) )
     => ! [C] :
          ( m1_filter_1(C,A,B)
         => ( v1_funct_1(C)
            & v1_funct_2(C,A,A)
            & m2_relset_1(C,A,A) ) ) ) ).

fof(existence_m1_filter_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & v1_relat_1(B) )
     => ? [C] : m1_filter_1(C,A,B) ) ).

fof(dt_m2_filter_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & v1_relat_1(B) )
     => ! [C] :
          ( m2_filter_1(C,A,B)
         => ( v1_funct_1(C)
            & v1_funct_2(C,k2_zfmisc_1(A,A),A)
            & m2_relset_1(C,k2_zfmisc_1(A,A),A) ) ) ) ).

fof(existence_m2_filter_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & v1_relat_1(B) )
     => ? [C] : m2_filter_1(C,A,B) ) ).

fof(symmetry_r1_filter_1,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A)
        & ~ v3_struct_0(B)
        & v10_lattices(B)
        & l3_lattices(B) )
     => ( r1_filter_1(A,B)
       => r1_filter_1(B,A) ) ) ).

fof(reflexivity_r1_filter_1,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A)
        & ~ v3_struct_0(B)
        & v10_lattices(B)
        & l3_lattices(B) )
     => r1_filter_1(A,A) ) ).

fof(dt_k1_filter_1,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A)
        & m1_filter_0(B,A)
        & m1_filter_0(C,A) )
     => m1_filter_0(k1_filter_1(A,B,C),A) ) ).

fof(commutativity_k1_filter_1,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A)
        & m1_filter_0(B,A)
        & m1_filter_0(C,A) )
     => k1_filter_1(A,B,C) = k1_filter_1(A,C,B) ) ).

fof(idempotence_k1_filter_1,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A)
        & m1_filter_0(B,A)
        & m1_filter_0(C,A) )
     => k1_filter_1(A,B,B) = B ) ).

fof(redefinition_k1_filter_1,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A)
        & m1_filter_0(B,A)
        & m1_filter_0(C,A) )
     => k1_filter_1(A,B,C) = k3_xboole_0(B,C) ) ).

fof(dt_k2_filter_1,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & v3_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m1_relset_1(B,A,A)
        & m1_subset_1(C,A) )
     => m2_subset_1(k2_filter_1(A,B,C),k1_zfmisc_1(A),k8_eqrel_1(A,B)) ) ).

fof(redefinition_k2_filter_1,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & v3_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m1_relset_1(B,A,A)
        & m1_subset_1(C,A) )
     => k2_filter_1(A,B,C) = k6_eqrel_1(A,B,C) ) ).

fof(dt_k3_filter_1,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & v3_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m1_relset_1(B,A,A)
        & v1_funct_1(C)
        & v1_funct_2(C,A,A)
        & m1_relset_1(C,A,A) )
     => ( v1_funct_1(k3_filter_1(A,B,C))
        & v1_funct_2(k3_filter_1(A,B,C),k8_eqrel_1(A,B),k8_eqrel_1(A,B))
        & m2_relset_1(k3_filter_1(A,B,C),k8_eqrel_1(A,B),k8_eqrel_1(A,B)) ) ) ).

fof(dt_k4_filter_1,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & v3_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m1_relset_1(B,A,A)
        & v1_funct_1(C)
        & v1_funct_2(C,k2_zfmisc_1(A,A),A)
        & m1_relset_1(C,k2_zfmisc_1(A,A),A) )
     => ( v1_funct_1(k4_filter_1(A,B,C))
        & v1_funct_2(k4_filter_1(A,B,C),k2_zfmisc_1(k8_eqrel_1(A,B),k8_eqrel_1(A,B)),k8_eqrel_1(A,B))
        & m2_relset_1(k4_filter_1(A,B,C),k2_zfmisc_1(k8_eqrel_1(A,B),k8_eqrel_1(A,B)),k8_eqrel_1(A,B)) ) ) ).

fof(dt_k5_filter_1,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A)
        & m1_filter_0(B,A) )
     => ( ~ v3_struct_0(k5_filter_1(A,B))
        & v3_lattices(k5_filter_1(A,B))
        & v10_lattices(k5_filter_1(A,B))
        & l3_lattices(k5_filter_1(A,B)) ) ) ).

fof(dt_k6_filter_1,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A)
        & m1_filter_0(B,A)
        & m1_subset_1(C,u1_struct_0(A)) )
     => m1_subset_1(k6_filter_1(A,B,C),u1_struct_0(k5_filter_1(A,B))) ) ).

fof(dt_k7_filter_1,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,k2_zfmisc_1(A,A),A)
        & m1_relset_1(C,k2_zfmisc_1(A,A),A)
        & v1_funct_1(D)
        & v1_funct_2(D,k2_zfmisc_1(B,B),B)
        & m1_relset_1(D,k2_zfmisc_1(B,B),B) )
     => ( v1_funct_1(k7_filter_1(A,B,C,D))
        & v1_funct_2(k7_filter_1(A,B,C,D),k2_zfmisc_1(k2_zfmisc_1(A,B),k2_zfmisc_1(A,B)),k2_zfmisc_1(A,B))
        & m2_relset_1(k7_filter_1(A,B,C,D),k2_zfmisc_1(k2_zfmisc_1(A,B),k2_zfmisc_1(A,B)),k2_zfmisc_1(A,B)) ) ) ).

fof(redefinition_k7_filter_1,axiom,
    ! [A,B,C,D] :
      ( ( v1_funct_1(C)
        & v1_funct_2(C,k2_zfmisc_1(A,A),A)
        & m1_relset_1(C,k2_zfmisc_1(A,A),A)
        & v1_funct_1(D)
        & v1_funct_2(D,k2_zfmisc_1(B,B),B)
        & m1_relset_1(D,k2_zfmisc_1(B,B),B) )
     => k7_filter_1(A,B,C,D) = k3_funct_4(C,D) ) ).

fof(dt_k8_filter_1,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & l3_lattices(A)
        & ~ v3_struct_0(B)
        & l3_lattices(B) )
     => ( v3_lattices(k8_filter_1(A,B))
        & l3_lattices(k8_filter_1(A,B)) ) ) ).

fof(dt_k9_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => v1_relat_1(k9_filter_1(A)) ) ).

fof(dt_k10_filter_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A)
        & ~ v3_struct_0(B)
        & v10_lattices(B)
        & l3_lattices(B)
        & m1_subset_1(C,u1_struct_0(A))
        & m1_subset_1(D,u1_struct_0(B)) )
     => m1_subset_1(k10_filter_1(A,B,C,D),u1_struct_0(k8_filter_1(A,B))) ) ).

fof(redefinition_k10_filter_1,axiom,
    ! [A,B,C,D] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A)
        & ~ v3_struct_0(B)
        & v10_lattices(B)
        & l3_lattices(B)
        & m1_subset_1(C,u1_struct_0(A))
        & m1_subset_1(D,u1_struct_0(B)) )
     => k10_filter_1(A,B,C,D) = k4_tarski(C,D) ) ).

fof(d8_filter_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => k9_filter_1(A) = a_1_0_filter_1(A) ) ).

fof(fraenkel_a_1_0_filter_1,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(B)
        & v10_lattices(B)
        & l3_lattices(B) )
     => ( r2_hidden(A,a_1_0_filter_1(B))
      <=> ? [C,D] :
            ( m1_subset_1(C,u1_struct_0(B))
            & m1_subset_1(D,u1_struct_0(B))
            & A = k1_domain_1(u1_struct_0(B),u1_struct_0(B),C,D)
            & r3_lattices(B,C,D) ) ) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(fc1_lattice3,axiom,
    ! [A] :
      ( ~ v3_struct_0(k1_lattice3(A))
      & v3_lattices(k1_lattice3(A)) ) ).

fof(fc2_lattice3,axiom,
    ! [A] :
      ( ~ v3_struct_0(k1_lattice3(A))
      & v3_lattices(k1_lattice3(A))
      & v4_lattices(k1_lattice3(A))
      & v5_lattices(k1_lattice3(A))
      & v6_lattices(k1_lattice3(A))
      & v7_lattices(k1_lattice3(A))
      & v8_lattices(k1_lattice3(A))
      & v9_lattices(k1_lattice3(A))
      & v10_lattices(k1_lattice3(A)) ) ).

fof(fc3_lattice3,axiom,
    ! [A] :
      ( ~ v3_struct_0(k1_lattice3(A))
      & v3_lattices(k1_lattice3(A))
      & v4_lattices(k1_lattice3(A))
      & v5_lattices(k1_lattice3(A))
      & v6_lattices(k1_lattice3(A))
      & v7_lattices(k1_lattice3(A))
      & v8_lattices(k1_lattice3(A))
      & v9_lattices(k1_lattice3(A))
      & v10_lattices(k1_lattice3(A))
      & v11_lattices(k1_lattice3(A))
      & v12_lattices(k1_lattice3(A))
      & v13_lattices(k1_lattice3(A))
      & v14_lattices(k1_lattice3(A))
      & v15_lattices(k1_lattice3(A))
      & v16_lattices(k1_lattice3(A))
      & v17_lattices(k1_lattice3(A)) ) ).

fof(fc4_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ( ~ v3_struct_0(k3_lattice3(A))
        & v1_orders_2(k3_lattice3(A))
        & v2_orders_2(k3_lattice3(A))
        & v3_orders_2(k3_lattice3(A))
        & v4_orders_2(k3_lattice3(A)) ) ) ).

fof(fc5_lattice3,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ( v1_orders_2(k7_lattice3(A))
        & v2_orders_2(k7_lattice3(A))
        & v3_orders_2(k7_lattice3(A))
        & v4_orders_2(k7_lattice3(A)) ) ) ).

fof(fc6_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ( ~ v3_struct_0(k7_lattice3(A))
        & v1_orders_2(k7_lattice3(A)) ) ) ).

fof(cc1_lattice3,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( v1_lattice3(A)
       => ~ v3_struct_0(A) ) ) ).

fof(cc2_lattice3,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( v2_lattice3(A)
       => ~ v3_struct_0(A) ) ) ).

fof(rc1_lattice3,axiom,
    ? [A] :
      ( l1_orders_2(A)
      & ~ v3_struct_0(A)
      & v1_orders_2(A)
      & v2_orders_2(A)
      & v3_orders_2(A)
      & v4_orders_2(A)
      & v3_lattice3(A) ) ).

fof(rc2_lattice3,axiom,
    ? [A] :
      ( l1_orders_2(A)
      & ~ v3_struct_0(A)
      & v1_orders_2(A)
      & v2_orders_2(A)
      & v3_orders_2(A)
      & v4_orders_2(A)
      & v1_lattice3(A)
      & v2_lattice3(A)
      & v3_lattice3(A) ) ).

fof(rc3_lattice3,axiom,
    ? [A] :
      ( l3_lattices(A)
      & ~ v3_struct_0(A)
      & v3_lattices(A)
      & v4_lattices(A)
      & v5_lattices(A)
      & v6_lattices(A)
      & v7_lattices(A)
      & v8_lattices(A)
      & v9_lattices(A)
      & v10_lattices(A)
      & v4_lattice3(A)
      & v5_lattice3(A)
      & v6_lattice3(A) ) ).

fof(fc7_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v3_lattice3(A)
        & l1_orders_2(A) )
     => ( ~ v3_struct_0(k14_lattice3(A))
        & v3_lattices(k14_lattice3(A))
        & v4_lattices(k14_lattice3(A))
        & v5_lattices(k14_lattice3(A))
        & v6_lattices(k14_lattice3(A))
        & v7_lattices(k14_lattice3(A))
        & v8_lattices(k14_lattice3(A))
        & v9_lattices(k14_lattice3(A))
        & v10_lattices(k14_lattice3(A))
        & v4_lattice3(k14_lattice3(A)) ) ) ).

fof(d1_lattice3,axiom,
    ! [A,B] :
      ( ( v3_lattices(B)
        & l3_lattices(B) )
     => ( B = k1_lattice3(A)
      <=> ( u1_struct_0(B) = k1_zfmisc_1(A)
          & ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(A))
             => ! [D] :
                  ( m1_subset_1(D,k1_zfmisc_1(A))
                 => ( k1_binop_1(u2_lattices(B),C,D) = k4_subset_1(A,C,D)
                    & k1_binop_1(u1_lattices(B),C,D) = k5_subset_1(A,C,D) ) ) ) ) ) ) ).

fof(t1_lattice3,axiom,
    ! [A,B] :
      ( m1_subset_1(B,u1_struct_0(k1_lattice3(A)))
     => ! [C] :
          ( m1_subset_1(C,u1_struct_0(k1_lattice3(A)))
         => ( k1_lattices(k1_lattice3(A),B,C) = k2_xboole_0(B,C)
            & k2_lattices(k1_lattice3(A),B,C) = k3_xboole_0(B,C) ) ) ) ).

fof(t2_lattice3,axiom,
    ! [A,B] :
      ( m1_subset_1(B,u1_struct_0(k1_lattice3(A)))
     => ! [C] :
          ( m1_subset_1(C,u1_struct_0(k1_lattice3(A)))
         => ( r1_lattices(k1_lattice3(A),B,C)
          <=> r1_tarski(B,C) ) ) ) ).

fof(t3_lattice3,axiom,
    ! [A] :
      ( v13_lattices(k1_lattice3(A))
      & k5_lattices(k1_lattice3(A)) = k1_xboole_0 ) ).

fof(t4_lattice3,axiom,
    ! [A] :
      ( v14_lattices(k1_lattice3(A))
      & k6_lattices(k1_lattice3(A)) = A ) ).

fof(t5_lattice3,axiom,
    ! [A,B] :
      ( m1_subset_1(B,u1_struct_0(k1_lattice3(A)))
     => k7_lattices(k1_lattice3(A),B) = k4_xboole_0(A,B) ) ).

fof(d2_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => k3_lattice3(A) = g1_orders_2(u1_struct_0(A),k2_lattice3(A)) ) ).

fof(t6_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v10_lattices(B)
            & l3_lattices(B) )
         => ( k3_lattice3(A) = k3_lattice3(B)
           => g3_lattices(u1_struct_0(A),u2_lattices(A),u1_lattices(A)) = g3_lattices(u1_struct_0(B),u2_lattices(B),u1_lattices(B)) ) ) ) ).

fof(d3_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => k4_lattice3(A,B) = B ) ) ).

fof(d4_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(k3_lattice3(A)))
         => k5_lattice3(A,B) = B ) ) ).

fof(t7_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( r3_lattices(A,B,C)
              <=> r3_orders_2(k3_lattice3(A),k4_lattice3(A,B),k4_lattice3(A,C)) ) ) ) ) ).

fof(d5_lattice3,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => k7_lattice3(A) = g1_orders_2(u1_struct_0(A),k6_relset_1(u1_struct_0(A),u1_struct_0(A),u1_orders_2(A))) ) ).

fof(t8_lattice3,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => k7_lattice3(k7_lattice3(A)) = g1_orders_2(u1_struct_0(A),u1_orders_2(A)) ) ).

fof(d6_lattice3,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => k8_lattice3(A,B) = B ) ) ).

fof(d7_lattice3,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(k7_lattice3(A)))
         => k9_lattice3(A,B) = B ) ) ).

fof(t9_lattice3,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( r1_orders_2(A,B,C)
              <=> r1_orders_2(k7_lattice3(A),k8_lattice3(A,C),k8_lattice3(A,B)) ) ) ) ) ).

fof(d8_lattice3,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B,C] :
          ( m1_subset_1(C,u1_struct_0(A))
         => ( r1_lattice3(A,B,C)
          <=> ! [D] :
                ( m1_subset_1(D,u1_struct_0(A))
               => ( r2_hidden(D,B)
                 => r1_orders_2(A,C,D) ) ) ) ) ) ).

fof(d9_lattice3,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B,C] :
          ( m1_subset_1(C,u1_struct_0(A))
         => ( r2_lattice3(A,B,C)
          <=> ! [D] :
                ( m1_subset_1(D,u1_struct_0(A))
               => ( r2_hidden(D,B)
                 => r1_orders_2(A,D,C) ) ) ) ) ) ).

fof(d10_lattice3,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( v1_lattice3(A)
      <=> ! [B] :
            ( m1_subset_1(B,u1_struct_0(A))
           => ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ? [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                    & r1_orders_2(A,B,D)
                    & r1_orders_2(A,C,D)
                    & ! [E] :
                        ( m1_subset_1(E,u1_struct_0(A))
                       => ( ( r1_orders_2(A,B,E)
                            & r1_orders_2(A,C,E) )
                         => r1_orders_2(A,D,E) ) ) ) ) ) ) ) ).

fof(d11_lattice3,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( v2_lattice3(A)
      <=> ! [B] :
            ( m1_subset_1(B,u1_struct_0(A))
           => ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ? [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                    & r1_orders_2(A,D,B)
                    & r1_orders_2(A,D,C)
                    & ! [E] :
                        ( m1_subset_1(E,u1_struct_0(A))
                       => ( ( r1_orders_2(A,E,B)
                            & r1_orders_2(A,E,C) )
                         => r1_orders_2(A,E,D) ) ) ) ) ) ) ) ).

fof(t10_lattice3,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( v1_lattice3(A)
      <=> v2_lattice3(k7_lattice3(A)) ) ) ).

fof(t11_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ( v1_lattice3(k3_lattice3(A))
        & v2_lattice3(k3_lattice3(A)) ) ) ).

fof(d12_lattice3,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( v3_lattice3(A)
      <=> ! [B] :
          ? [C] :
            ( m1_subset_1(C,u1_struct_0(A))
            & r2_lattice3(A,B,C)
            & ! [D] :
                ( m1_subset_1(D,u1_struct_0(A))
               => ( r2_lattice3(A,B,D)
                 => r1_orders_2(A,C,D) ) ) ) ) ) ).

fof(t12_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ( v3_lattice3(A)
       => ( v1_lattice3(A)
          & v2_lattice3(A) ) ) ) ).

fof(d13_lattice3,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( v4_orders_2(A)
       => ! [B] :
            ( m1_subset_1(B,u1_struct_0(A))
           => ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ( ? [D] :
                      ( m1_subset_1(D,u1_struct_0(A))
                      & r1_orders_2(A,B,D)
                      & r1_orders_2(A,C,D)
                      & ! [E] :
                          ( m1_subset_1(E,u1_struct_0(A))
                         => ( ( r1_orders_2(A,B,E)
                              & r1_orders_2(A,C,E) )
                           => r1_orders_2(A,D,E) ) ) )
                 => ! [D] :
                      ( m1_subset_1(D,u1_struct_0(A))
                     => ( D = k10_lattice3(A,B,C)
                      <=> ( r1_orders_2(A,B,D)
                          & r1_orders_2(A,C,D)
                          & ! [E] :
                              ( m1_subset_1(E,u1_struct_0(A))
                             => ( ( r1_orders_2(A,B,E)
                                  & r1_orders_2(A,C,E) )
                               => r1_orders_2(A,D,E) ) ) ) ) ) ) ) ) ) ) ).

fof(d14_lattice3,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( v4_orders_2(A)
       => ! [B] :
            ( m1_subset_1(B,u1_struct_0(A))
           => ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ( ? [D] :
                      ( m1_subset_1(D,u1_struct_0(A))
                      & r1_orders_2(A,D,B)
                      & r1_orders_2(A,D,C)
                      & ! [E] :
                          ( m1_subset_1(E,u1_struct_0(A))
                         => ( ( r1_orders_2(A,E,B)
                              & r1_orders_2(A,E,C) )
                           => r1_orders_2(A,E,D) ) ) )
                 => ! [D] :
                      ( m1_subset_1(D,u1_struct_0(A))
                     => ( D = k11_lattice3(A,B,C)
                      <=> ( r1_orders_2(A,D,B)
                          & r1_orders_2(A,D,C)
                          & ! [E] :
                              ( m1_subset_1(E,u1_struct_0(A))
                             => ( ( r1_orders_2(A,E,B)
                                  & r1_orders_2(A,E,C) )
                               => r1_orders_2(A,E,D) ) ) ) ) ) ) ) ) ) ) ).

fof(t13_lattice3,axiom,
    ! [A] :
      ( ( v4_orders_2(A)
        & v1_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => k10_lattice3(A,B,C) = k10_lattice3(A,C,B) ) ) ) ).

fof(t14_lattice3,axiom,
    ! [A] :
      ( ( v4_orders_2(A)
        & v1_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ( v3_orders_2(A)
                   => k10_lattice3(A,k10_lattice3(A,B,C),D) = k10_lattice3(A,B,k10_lattice3(A,C,D)) ) ) ) ) ) ).

fof(t15_lattice3,axiom,
    ! [A] :
      ( ( v4_orders_2(A)
        & v2_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => k11_lattice3(A,B,C) = k11_lattice3(A,C,B) ) ) ) ).

fof(t16_lattice3,axiom,
    ! [A] :
      ( ( v4_orders_2(A)
        & v2_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ( v3_orders_2(A)
                   => k11_lattice3(A,k11_lattice3(A,B,C),D) = k11_lattice3(A,B,k11_lattice3(A,C,D)) ) ) ) ) ) ).

fof(t17_lattice3,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v4_orders_2(A)
        & v1_lattice3(A)
        & v2_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => k13_lattice3(A,k12_lattice3(A,B,C),C) = C ) ) ) ).

fof(t18_lattice3,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v4_orders_2(A)
        & v1_lattice3(A)
        & v2_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => k12_lattice3(A,B,k13_lattice3(A,B,C)) = B ) ) ) ).

fof(t19_lattice3,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v1_lattice3(A)
        & v2_lattice3(A)
        & l1_orders_2(A) )
     => ? [B] :
          ( ~ v3_struct_0(B)
          & v3_lattices(B)
          & v10_lattices(B)
          & l3_lattices(B)
          & g1_orders_2(u1_struct_0(A),u1_orders_2(A)) = k3_lattice3(B) ) ) ).

fof(d15_lattice3,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( ( v2_orders_2(A)
          & v3_orders_2(A)
          & v4_orders_2(A)
          & v1_lattice3(A)
          & v2_lattice3(A)
          & l1_orders_2(A) )
       => ! [B] :
            ( ( ~ v3_struct_0(B)
              & v3_lattices(B)
              & v10_lattices(B)
              & l3_lattices(B) )
           => ( B = k14_lattice3(A)
            <=> g1_orders_2(u1_struct_0(A),u1_orders_2(A)) = k3_lattice3(B) ) ) ) ) ).

fof(t20_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ( k6_lattice3(u1_struct_0(A),k2_lattice3(A)) = k2_lattice3(k1_lattice2(A))
        & k7_lattice3(k3_lattice3(A)) = k3_lattice3(k1_lattice2(A)) ) ) ).

fof(d16_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( r3_lattice3(A,B,C)
            <=> ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ( r2_hidden(D,C)
                   => r1_lattices(A,B,D) ) ) ) ) ) ).

fof(d17_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( r4_lattice3(A,B,C)
            <=> ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ( r2_hidden(D,C)
                   => r1_lattices(A,D,B) ) ) ) ) ) ).

fof(t21_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ( r3_lattice3(A,B,k2_struct_0(A,C,D))
                  <=> r3_lattices(A,B,k4_lattices(A,C,D)) ) ) ) ) ) ).

fof(t22_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ( r4_lattice3(A,B,k2_struct_0(A,C,D))
                  <=> r3_lattices(A,k3_lattices(A,C,D),B) ) ) ) ) ) ).

fof(d18_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l3_lattices(A) )
     => ( v4_lattice3(A)
      <=> ! [B] :
          ? [C] :
            ( m1_subset_1(C,u1_struct_0(A))
            & r4_lattice3(A,C,B)
            & ! [D] :
                ( m1_subset_1(D,u1_struct_0(A))
               => ( r4_lattice3(A,D,B)
                 => r1_lattices(A,C,D) ) ) ) ) ) ).

fof(t25_lattice3,axiom,
    ! [A] : v4_lattice3(k1_lattice3(A)) ).

fof(t26_lattice3,axiom,
    ! [A] : v5_lattice3(k1_lattice3(A)) ).

fof(t27_lattice3,axiom,
    ! [A] : v6_lattice3(k1_lattice3(A)) ).

fof(t28_lattice3,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(B)
        & v10_lattices(B)
        & l3_lattices(B) )
     => ! [C] :
          ( m1_subset_1(C,u1_struct_0(B))
         => ( r3_lattice3(B,C,A)
          <=> r1_lattice3(k3_lattice3(B),A,k4_lattice3(B,C)) ) ) ) ).

fof(t29_lattice3,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(B)
        & v10_lattices(B)
        & l3_lattices(B) )
     => ! [C] :
          ( m1_subset_1(C,u1_struct_0(k3_lattice3(B)))
         => ( r1_lattice3(k3_lattice3(B),A,C)
          <=> r3_lattice3(B,k5_lattice3(B,C),A) ) ) ) ).

fof(t30_lattice3,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(B)
        & v10_lattices(B)
        & l3_lattices(B) )
     => ! [C] :
          ( m1_subset_1(C,u1_struct_0(B))
         => ( r4_lattice3(B,C,A)
          <=> r2_lattice3(k3_lattice3(B),A,k4_lattice3(B,C)) ) ) ) ).

fof(t31_lattice3,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(B)
        & v10_lattices(B)
        & l3_lattices(B) )
     => ! [C] :
          ( m1_subset_1(C,u1_struct_0(k3_lattice3(B)))
         => ( r2_lattice3(k3_lattice3(B),A,C)
          <=> r4_lattice3(B,k5_lattice3(B,C),A) ) ) ) ).

fof(d21_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l3_lattices(A) )
     => ( ( ~ v3_struct_0(A)
          & v10_lattices(A)
          & v4_lattice3(A)
          & l3_lattices(A) )
       => ! [B,C] :
            ( m1_subset_1(C,u1_struct_0(A))
           => ( C = k15_lattice3(A,B)
            <=> ( r4_lattice3(A,C,B)
                & ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => ( r4_lattice3(A,D,B)
                     => r1_lattices(A,C,D) ) ) ) ) ) ) ) ).

fof(t34_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v4_lattice3(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( B = k16_lattice3(A,C)
            <=> ( r3_lattice3(A,B,C)
                & ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => ( r3_lattice3(A,D,C)
                     => r3_lattices(A,D,B) ) ) ) ) ) ) ).

fof(t38_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v4_lattice3(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( r2_hidden(B,C)
             => ( r3_lattices(A,B,k15_lattice3(A,C))
                & r3_lattices(A,k16_lattice3(A,C),B) ) ) ) ) ).

fof(t39_lattice3,axiom,
    $true ).

fof(t40_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v4_lattice3(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( r3_lattice3(A,B,C)
             => r3_lattices(A,B,k16_lattice3(A,C)) ) ) ) ).

fof(t41_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v4_lattice3(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( ( r2_hidden(B,C)
                & r4_lattice3(A,B,C) )
             => k15_lattice3(A,C) = B ) ) ) ).

fof(t42_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v4_lattice3(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( ( r2_hidden(B,C)
                & r3_lattice3(A,B,C) )
             => k16_lattice3(A,C) = B ) ) ) ).

fof(t43_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v4_lattice3(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ( k15_lattice3(A,k1_struct_0(A,B)) = B
            & k16_lattice3(A,k1_struct_0(A,B)) = B ) ) ) ).

fof(t44_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v4_lattice3(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( k3_lattices(A,B,C) = k15_lattice3(A,k2_struct_0(A,B,C))
                & k4_lattices(A,B,C) = k16_lattice3(A,k2_struct_0(A,B,C)) ) ) ) ) ).

fof(t46_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v4_lattice3(A)
        & l3_lattices(A) )
     => ! [B,C] :
          ( r1_tarski(B,C)
         => ( r3_lattices(A,k15_lattice3(A,B),k15_lattice3(A,C))
            & r3_lattices(A,k16_lattice3(A,C),k16_lattice3(A,B)) ) ) ) ).

fof(t48_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v4_lattice3(A)
        & l3_lattices(A) )
     => ! [B,C] :
          ( ! [D] :
              ( m1_subset_1(D,u1_struct_0(A))
             => ~ ( r2_hidden(D,B)
                  & ! [E] :
                      ( m1_subset_1(E,u1_struct_0(A))
                     => ~ ( r3_lattices(A,D,E)
                          & r2_hidden(E,C) ) ) ) )
         => r3_lattices(A,k15_lattice3(A,B),k15_lattice3(A,C)) ) ) ).

fof(t50_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v4_lattice3(A)
        & l3_lattices(A) )
     => ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v13_lattices(A)
        & l3_lattices(A)
        & k5_lattices(A) = k15_lattice3(A,k1_xboole_0) ) ) ).

fof(t51_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v4_lattice3(A)
        & l3_lattices(A) )
     => ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v14_lattices(A)
        & l3_lattices(A)
        & k6_lattices(A) = k15_lattice3(A,u1_struct_0(A)) ) ) ).

fof(t53_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v4_lattice3(A)
        & l3_lattices(A) )
     => ( ( ~ v3_struct_0(A)
          & v10_lattices(A)
          & v3_filter_0(A)
          & l3_lattices(A) )
       => v5_lattice3(A) ) ) ).

fof(t56_lattice3,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,k1_zfmisc_1(A),A)
            & m2_relset_1(B,k1_zfmisc_1(A),A) )
         => ~ ( ! [C] :
                  ( m1_subset_1(C,A)
                 => k8_funct_2(k1_zfmisc_1(A),A,B,k6_domain_1(A,C)) = C )
              & ! [C] :
                  ( m1_subset_1(C,k1_zfmisc_1(k1_zfmisc_1(A)))
                 => k8_funct_2(k1_zfmisc_1(A),A,B,k10_relset_1(k1_zfmisc_1(A),A,B,C)) = k1_funct_1(B,k3_tarski(C)) )
              & ! [C] :
                  ( ( ~ v3_struct_0(C)
                    & v3_lattices(C)
                    & v10_lattices(C)
                    & v4_lattice3(C)
                    & l3_lattices(C) )
                 => ~ ( u1_struct_0(C) = A
                      & ! [D] :
                          ( m1_subset_1(D,k1_zfmisc_1(u1_struct_0(C)))
                         => k15_lattice3(C,D) = k1_funct_1(B,D) ) ) ) ) ) ) ).

fof(dt_k1_lattice3,axiom,
    ! [A] :
      ( v3_lattices(k1_lattice3(A))
      & l3_lattices(k1_lattice3(A)) ) ).

fof(dt_k2_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ( v1_relat_2(k2_lattice3(A))
        & v4_relat_2(k2_lattice3(A))
        & v8_relat_2(k2_lattice3(A))
        & v1_partfun1(k2_lattice3(A),u1_struct_0(A),u1_struct_0(A))
        & m2_relset_1(k2_lattice3(A),u1_struct_0(A),u1_struct_0(A)) ) ) ).

fof(redefinition_k2_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => k2_lattice3(A) = k9_filter_1(A) ) ).

fof(dt_k3_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ( v1_orders_2(k3_lattice3(A))
        & v2_orders_2(k3_lattice3(A))
        & v3_orders_2(k3_lattice3(A))
        & v4_orders_2(k3_lattice3(A))
        & l1_orders_2(k3_lattice3(A)) ) ) ).

fof(dt_k4_lattice3,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A)
        & m1_subset_1(B,u1_struct_0(A)) )
     => m1_subset_1(k4_lattice3(A,B),u1_struct_0(k3_lattice3(A))) ) ).

fof(dt_k5_lattice3,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A)
        & m1_subset_1(B,u1_struct_0(k3_lattice3(A))) )
     => m1_subset_1(k5_lattice3(A,B),u1_struct_0(A)) ) ).

fof(dt_k6_lattice3,axiom,
    ! [A,B] :
      ( ( v1_relat_2(B)
        & v4_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m1_relset_1(B,A,A) )
     => ( v1_relat_2(k6_lattice3(A,B))
        & v4_relat_2(k6_lattice3(A,B))
        & v8_relat_2(k6_lattice3(A,B))
        & v1_partfun1(k6_lattice3(A,B),A,A)
        & m2_relset_1(k6_lattice3(A,B),A,A) ) ) ).

fof(involutiveness_k6_lattice3,axiom,
    ! [A,B] :
      ( ( v1_relat_2(B)
        & v4_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m1_relset_1(B,A,A) )
     => k6_lattice3(A,k6_lattice3(A,B)) = B ) ).

fof(redefinition_k6_lattice3,axiom,
    ! [A,B] :
      ( ( v1_relat_2(B)
        & v4_relat_2(B)
        & v8_relat_2(B)
        & v1_partfun1(B,A,A)
        & m1_relset_1(B,A,A) )
     => k6_lattice3(A,B) = k4_relat_1(B) ) ).

fof(dt_k7_lattice3,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( v1_orders_2(k7_lattice3(A))
        & l1_orders_2(k7_lattice3(A)) ) ) ).

fof(dt_k8_lattice3,axiom,
    ! [A,B] :
      ( ( l1_orders_2(A)
        & m1_subset_1(B,u1_struct_0(A)) )
     => m1_subset_1(k8_lattice3(A,B),u1_struct_0(k7_lattice3(A))) ) ).

fof(dt_k9_lattice3,axiom,
    ! [A,B] :
      ( ( l1_orders_2(A)
        & m1_subset_1(B,u1_struct_0(k7_lattice3(A))) )
     => m1_subset_1(k9_lattice3(A,B),u1_struct_0(A)) ) ).

fof(dt_k10_lattice3,axiom,
    ! [A,B,C] :
      ( ( l1_orders_2(A)
        & m1_subset_1(B,u1_struct_0(A))
        & m1_subset_1(C,u1_struct_0(A)) )
     => m1_subset_1(k10_lattice3(A,B,C),u1_struct_0(A)) ) ).

fof(dt_k11_lattice3,axiom,
    ! [A,B,C] :
      ( ( l1_orders_2(A)
        & m1_subset_1(B,u1_struct_0(A))
        & m1_subset_1(C,u1_struct_0(A)) )
     => m1_subset_1(k11_lattice3(A,B,C),u1_struct_0(A)) ) ).

fof(dt_k12_lattice3,axiom,
    ! [A,B,C] :
      ( ( v4_orders_2(A)
        & v2_lattice3(A)
        & l1_orders_2(A)
        & m1_subset_1(B,u1_struct_0(A))
        & m1_subset_1(C,u1_struct_0(A)) )
     => m1_subset_1(k12_lattice3(A,B,C),u1_struct_0(A)) ) ).

fof(commutativity_k12_lattice3,axiom,
    ! [A,B,C] :
      ( ( v4_orders_2(A)
        & v2_lattice3(A)
        & l1_orders_2(A)
        & m1_subset_1(B,u1_struct_0(A))
        & m1_subset_1(C,u1_struct_0(A)) )
     => k12_lattice3(A,B,C) = k12_lattice3(A,C,B) ) ).

fof(redefinition_k12_lattice3,axiom,
    ! [A,B,C] :
      ( ( v4_orders_2(A)
        & v2_lattice3(A)
        & l1_orders_2(A)
        & m1_subset_1(B,u1_struct_0(A))
        & m1_subset_1(C,u1_struct_0(A)) )
     => k12_lattice3(A,B,C) = k11_lattice3(A,B,C) ) ).

fof(dt_k13_lattice3,axiom,
    ! [A,B,C] :
      ( ( v4_orders_2(A)
        & v1_lattice3(A)
        & l1_orders_2(A)
        & m1_subset_1(B,u1_struct_0(A))
        & m1_subset_1(C,u1_struct_0(A)) )
     => m1_subset_1(k13_lattice3(A,B,C),u1_struct_0(A)) ) ).

fof(commutativity_k13_lattice3,axiom,
    ! [A,B,C] :
      ( ( v4_orders_2(A)
        & v1_lattice3(A)
        & l1_orders_2(A)
        & m1_subset_1(B,u1_struct_0(A))
        & m1_subset_1(C,u1_struct_0(A)) )
     => k13_lattice3(A,B,C) = k13_lattice3(A,C,B) ) ).

fof(redefinition_k13_lattice3,axiom,
    ! [A,B,C] :
      ( ( v4_orders_2(A)
        & v1_lattice3(A)
        & l1_orders_2(A)
        & m1_subset_1(B,u1_struct_0(A))
        & m1_subset_1(C,u1_struct_0(A)) )
     => k13_lattice3(A,B,C) = k10_lattice3(A,B,C) ) ).

fof(dt_k14_lattice3,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( ~ v3_struct_0(k14_lattice3(A))
        & v3_lattices(k14_lattice3(A))
        & v10_lattices(k14_lattice3(A))
        & l3_lattices(k14_lattice3(A)) ) ) ).

fof(dt_k15_lattice3,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & l3_lattices(A) )
     => m1_subset_1(k15_lattice3(A,B),u1_struct_0(A)) ) ).

fof(dt_k16_lattice3,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & l3_lattices(A) )
     => m1_subset_1(k16_lattice3(A,B),u1_struct_0(A)) ) ).

fof(d19_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l3_lattices(A) )
     => ( v5_lattice3(A)
      <=> ! [B,C] :
            ( m1_subset_1(C,u1_struct_0(A))
           => ! [D] :
                ( m1_subset_1(D,u1_struct_0(A))
               => ! [E] :
                    ( m1_subset_1(E,u1_struct_0(A))
                   => ( ( r4_lattice3(A,C,B)
                        & ! [F] :
                            ( m1_subset_1(F,u1_struct_0(A))
                           => ( r4_lattice3(A,F,B)
                             => r1_lattices(A,C,F) ) )
                        & r4_lattice3(A,E,a_3_0_lattice3(A,B,D))
                        & ! [F] :
                            ( m1_subset_1(F,u1_struct_0(A))
                           => ( r4_lattice3(A,F,a_3_0_lattice3(A,B,D))
                             => r1_lattices(A,E,F) ) ) )
                     => r1_lattices(A,k2_lattices(A,D,C),E) ) ) ) ) ) ) ).

fof(d20_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l3_lattices(A) )
     => ( v6_lattice3(A)
      <=> ! [B,C] :
            ( m1_subset_1(C,u1_struct_0(A))
           => ! [D] :
                ( m1_subset_1(D,u1_struct_0(A))
               => ! [E] :
                    ( m1_subset_1(E,u1_struct_0(A))
                   => ( ( r3_lattice3(A,C,B)
                        & ! [F] :
                            ( m1_subset_1(F,u1_struct_0(A))
                           => ( r3_lattice3(A,F,B)
                             => r1_lattices(A,F,C) ) )
                        & r3_lattice3(A,E,a_3_1_lattice3(A,B,D))
                        & ! [F] :
                            ( m1_subset_1(F,u1_struct_0(A))
                           => ( r3_lattice3(A,F,a_3_1_lattice3(A,B,D))
                             => r1_lattices(A,F,E) ) ) )
                     => r1_lattices(A,E,k1_lattices(A,D,C)) ) ) ) ) ) ) ).

fof(t23_lattice3,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(B)
        & v10_lattices(B)
        & v17_lattices(B)
        & l3_lattices(B) )
     => ! [C] :
          ( m1_subset_1(C,u1_struct_0(B))
         => ( r4_lattice3(B,C,A)
          <=> r3_lattice3(B,k7_lattices(B,C),a_2_0_lattice3(A,B)) ) ) ) ).

fof(t24_lattice3,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(B)
        & v10_lattices(B)
        & v17_lattices(B)
        & l3_lattices(B) )
     => ! [C] :
          ( m1_subset_1(C,u1_struct_0(B))
         => ( r3_lattice3(B,C,A)
          <=> r4_lattice3(B,k7_lattices(B,C),a_2_0_lattice3(A,B)) ) ) ) ).

fof(d22_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l3_lattices(A) )
     => ! [B] : k16_lattice3(A,B) = k15_lattice3(A,a_2_1_lattice3(A,B)) ) ).

fof(t32_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v4_lattice3(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] : r3_lattices(A,k15_lattice3(A,a_3_2_lattice3(A,B,C)),k4_lattices(A,B,k15_lattice3(A,C))) ) ) ).

fof(t33_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v4_lattice3(A)
        & l3_lattices(A) )
     => ( v5_lattice3(A)
      <=> ! [B,C] :
            ( m1_subset_1(C,u1_struct_0(A))
           => r3_lattices(A,k4_lattices(A,C,k15_lattice3(A,B)),k15_lattice3(A,a_3_3_lattice3(A,B,C))) ) ) ) ).

fof(t35_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v4_lattice3(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] : r3_lattices(A,k3_lattices(A,B,k16_lattice3(A,C)),k16_lattice3(A,a_3_4_lattice3(A,B,C))) ) ) ).

fof(t36_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v4_lattice3(A)
        & l3_lattices(A) )
     => ( v6_lattice3(A)
      <=> ! [B,C] :
            ( m1_subset_1(C,u1_struct_0(A))
           => r3_lattices(A,k16_lattice3(A,a_3_5_lattice3(A,B,C)),k3_lattices(A,C,k16_lattice3(A,B))) ) ) ) ).

fof(t37_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v4_lattice3(A)
        & l3_lattices(A) )
     => ! [B] : k15_lattice3(A,B) = k16_lattice3(A,a_2_2_lattice3(A,B)) ) ).

fof(t45_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v4_lattice3(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ( B = k15_lattice3(A,a_2_3_lattice3(A,B))
            & B = k16_lattice3(A,a_2_4_lattice3(A,B)) ) ) ) ).

fof(t47_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v4_lattice3(A)
        & l3_lattices(A) )
     => ! [B] :
          ( k15_lattice3(A,B) = k15_lattice3(A,a_2_5_lattice3(A,B))
          & k16_lattice3(A,B) = k16_lattice3(A,a_2_6_lattice3(A,B)) ) ) ).

fof(t49_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v4_lattice3(A)
        & l3_lattices(A) )
     => ! [B] :
          ( r1_tarski(B,k1_zfmisc_1(u1_struct_0(A)))
         => k15_lattice3(A,k3_tarski(B)) = k15_lattice3(A,a_2_7_lattice3(A,B)) ) ) ).

fof(t52_lattice3,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v4_lattice3(A)
        & l3_lattices(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( ( ~ v3_struct_0(A)
                  & v10_lattices(A)
                  & v3_filter_0(A)
                  & l3_lattices(A) )
               => k4_filter_0(A,B,C) = k15_lattice3(A,a_3_6_lattice3(A,B,C)) ) ) ) ) ).

fof(t54_lattice3,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(B)
        & v10_lattices(B)
        & v4_lattice3(B)
        & v5_lattice3(B)
        & l3_lattices(B) )
     => ! [C] :
          ( m1_subset_1(C,u1_struct_0(B))
         => ( k4_lattices(B,C,k15_lattice3(B,A)) = k15_lattice3(B,a_3_7_lattice3(A,B,C))
            & k4_lattices(B,k15_lattice3(B,A),C) = k15_lattice3(B,a_3_8_lattice3(A,B,C)) ) ) ) ).

fof(t55_lattice3,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(B)
        & v10_lattices(B)
        & v4_lattice3(B)
        & v6_lattice3(B)
        & l3_lattices(B) )
     => ! [C] :
          ( m1_subset_1(C,u1_struct_0(B))
         => ( k3_lattices(B,C,k16_lattice3(B,A)) = k16_lattice3(B,a_3_9_lattice3(A,B,C))
            & k3_lattices(B,k16_lattice3(B,A),C) = k16_lattice3(B,a_3_10_lattice3(A,B,C)) ) ) ) ).

fof(s1_lattice3,axiom,
    ( ? [A] :
        ( m1_subset_1(A,f2_s1_lattice3)
        & p1_s1_lattice3(A) )
   => a_0_0_lattice3 = k1_tarski(f1_s1_lattice3) ) ).

fof(s2_lattice3,axiom,
    ( r1_tarski(f2_s2_lattice3,k1_relat_1(f4_s2_lattice3))
   => k9_relat_1(f4_s2_lattice3,a_0_1_lattice3) = a_0_2_lattice3 ) ).

fof(fraenkel_a_3_0_lattice3,axiom,
    ! [A,B,C,D] :
      ( ( ~ v3_struct_0(B)
        & l3_lattices(B)
        & m1_subset_1(D,u1_struct_0(B)) )
     => ( r2_hidden(A,a_3_0_lattice3(B,C,D))
      <=> ? [E] :
            ( m1_subset_1(E,u1_struct_0(B))
            & A = k2_lattices(B,D,E)
            & r2_hidden(E,C) ) ) ) ).

fof(fraenkel_a_3_1_lattice3,axiom,
    ! [A,B,C,D] :
      ( ( ~ v3_struct_0(B)
        & l3_lattices(B)
        & m1_subset_1(D,u1_struct_0(B)) )
     => ( r2_hidden(A,a_3_1_lattice3(B,C,D))
      <=> ? [E] :
            ( m1_subset_1(E,u1_struct_0(B))
            & A = k1_lattices(B,D,E)
            & r2_hidden(E,C) ) ) ) ).

fof(fraenkel_a_2_0_lattice3,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(C)
        & v10_lattices(C)
        & v17_lattices(C)
        & l3_lattices(C) )
     => ( r2_hidden(A,a_2_0_lattice3(B,C))
      <=> ? [D] :
            ( m1_subset_1(D,u1_struct_0(C))
            & A = k7_lattices(C,D)
            & r2_hidden(D,B) ) ) ) ).

fof(fraenkel_a_2_1_lattice3,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(B)
        & l3_lattices(B) )
     => ( r2_hidden(A,a_2_1_lattice3(B,C))
      <=> ? [D] :
            ( m1_subset_1(D,u1_struct_0(B))
            & A = D
            & r3_lattice3(B,D,C) ) ) ) ).

fof(fraenkel_a_3_2_lattice3,axiom,
    ! [A,B,C,D] :
      ( ( ~ v3_struct_0(B)
        & v10_lattices(B)
        & v4_lattice3(B)
        & l3_lattices(B)
        & m1_subset_1(C,u1_struct_0(B)) )
     => ( r2_hidden(A,a_3_2_lattice3(B,C,D))
      <=> ? [E] :
            ( m1_subset_1(E,u1_struct_0(B))
            & A = k4_lattices(B,C,E)
            & r2_hidden(E,D) ) ) ) ).

fof(fraenkel_a_3_3_lattice3,axiom,
    ! [A,B,C,D] :
      ( ( ~ v3_struct_0(B)
        & v10_lattices(B)
        & v4_lattice3(B)
        & l3_lattices(B)
        & m1_subset_1(D,u1_struct_0(B)) )
     => ( r2_hidden(A,a_3_3_lattice3(B,C,D))
      <=> ? [E] :
            ( m1_subset_1(E,u1_struct_0(B))
            & A = k4_lattices(B,D,E)
            & r2_hidden(E,C) ) ) ) ).

fof(fraenkel_a_3_4_lattice3,axiom,
    ! [A,B,C,D] :
      ( ( ~ v3_struct_0(B)
        & v10_lattices(B)
        & v4_lattice3(B)
        & l3_lattices(B)
        & m1_subset_1(C,u1_struct_0(B)) )
     => ( r2_hidden(A,a_3_4_lattice3(B,C,D))
      <=> ? [E] :
            ( m1_subset_1(E,u1_struct_0(B))
            & A = k3_lattices(B,C,E)
            & r2_hidden(E,D) ) ) ) ).

fof(fraenkel_a_3_5_lattice3,axiom,
    ! [A,B,C,D] :
      ( ( ~ v3_struct_0(B)
        & v10_lattices(B)
        & v4_lattice3(B)
        & l3_lattices(B)
        & m1_subset_1(D,u1_struct_0(B)) )
     => ( r2_hidden(A,a_3_5_lattice3(B,C,D))
      <=> ? [E] :
            ( m1_subset_1(E,u1_struct_0(B))
            & A = k3_lattices(B,D,E)
            & r2_hidden(E,C) ) ) ) ).

fof(fraenkel_a_2_2_lattice3,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(B)
        & v10_lattices(B)
        & v4_lattice3(B)
        & l3_lattices(B) )
     => ( r2_hidden(A,a_2_2_lattice3(B,C))
      <=> ? [D] :
            ( m1_subset_1(D,u1_struct_0(B))
            & A = D
            & r4_lattice3(B,D,C) ) ) ) ).

fof(fraenkel_a_2_3_lattice3,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(B)
        & v10_lattices(B)
        & v4_lattice3(B)
        & l3_lattices(B)
        & m1_subset_1(C,u1_struct_0(B)) )
     => ( r2_hidden(A,a_2_3_lattice3(B,C))
      <=> ? [D] :
            ( m1_subset_1(D,u1_struct_0(B))
            & A = D
            & r3_lattices(B,D,C) ) ) ) ).

fof(fraenkel_a_2_4_lattice3,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(B)
        & v10_lattices(B)
        & v4_lattice3(B)
        & l3_lattices(B)
        & m1_subset_1(C,u1_struct_0(B)) )
     => ( r2_hidden(A,a_2_4_lattice3(B,C))
      <=> ? [D] :
            ( m1_subset_1(D,u1_struct_0(B))
            & A = D
            & r3_lattices(B,C,D) ) ) ) ).

fof(fraenkel_a_2_5_lattice3,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(B)
        & v10_lattices(B)
        & v4_lattice3(B)
        & l3_lattices(B) )
     => ( r2_hidden(A,a_2_5_lattice3(B,C))
      <=> ? [D] :
            ( m1_subset_1(D,u1_struct_0(B))
            & A = D
            & ? [E] :
                ( m1_subset_1(E,u1_struct_0(B))
                & r3_lattices(B,D,E)
                & r2_hidden(E,C) ) ) ) ) ).

fof(fraenkel_a_2_6_lattice3,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(B)
        & v10_lattices(B)
        & v4_lattice3(B)
        & l3_lattices(B) )
     => ( r2_hidden(A,a_2_6_lattice3(B,C))
      <=> ? [D] :
            ( m1_subset_1(D,u1_struct_0(B))
            & A = D
            & ? [E] :
                ( m1_subset_1(E,u1_struct_0(B))
                & r3_lattices(B,E,D)
                & r2_hidden(E,C) ) ) ) ) ).

fof(fraenkel_a_2_7_lattice3,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(B)
        & v10_lattices(B)
        & v4_lattice3(B)
        & l3_lattices(B) )
     => ( r2_hidden(A,a_2_7_lattice3(B,C))
      <=> ? [D] :
            ( m1_subset_1(D,k1_zfmisc_1(u1_struct_0(B)))
            & A = k15_lattice3(B,D)
            & r2_hidden(D,C) ) ) ) ).

fof(fraenkel_a_3_6_lattice3,axiom,
    ! [A,B,C,D] :
      ( ( ~ v3_struct_0(B)
        & v10_lattices(B)
        & v4_lattice3(B)
        & l3_lattices(B)
        & m1_subset_1(C,u1_struct_0(B))
        & m1_subset_1(D,u1_struct_0(B)) )
     => ( r2_hidden(A,a_3_6_lattice3(B,C,D))
      <=> ? [E] :
            ( m1_subset_1(E,u1_struct_0(B))
            & A = E
            & r3_lattices(B,k4_lattices(B,C,E),D) ) ) ) ).

fof(fraenkel_a_3_7_lattice3,axiom,
    ! [A,B,C,D] :
      ( ( ~ v3_struct_0(C)
        & v10_lattices(C)
        & v4_lattice3(C)
        & v5_lattice3(C)
        & l3_lattices(C)
        & m1_subset_1(D,u1_struct_0(C)) )
     => ( r2_hidden(A,a_3_7_lattice3(B,C,D))
      <=> ? [E] :
            ( m1_subset_1(E,u1_struct_0(C))
            & A = k4_lattices(C,D,E)
            & r2_hidden(E,B) ) ) ) ).

fof(fraenkel_a_3_8_lattice3,axiom,
    ! [A,B,C,D] :
      ( ( ~ v3_struct_0(C)
        & v10_lattices(C)
        & v4_lattice3(C)
        & v5_lattice3(C)
        & l3_lattices(C)
        & m1_subset_1(D,u1_struct_0(C)) )
     => ( r2_hidden(A,a_3_8_lattice3(B,C,D))
      <=> ? [E] :
            ( m1_subset_1(E,u1_struct_0(C))
            & A = k4_lattices(C,E,D)
            & r2_hidden(E,B) ) ) ) ).

fof(fraenkel_a_3_9_lattice3,axiom,
    ! [A,B,C,D] :
      ( ( ~ v3_struct_0(C)
        & v10_lattices(C)
        & v4_lattice3(C)
        & v6_lattice3(C)
        & l3_lattices(C)
        & m1_subset_1(D,u1_struct_0(C)) )
     => ( r2_hidden(A,a_3_9_lattice3(B,C,D))
      <=> ? [E] :
            ( m1_subset_1(E,u1_struct_0(C))
            & A = k3_lattices(C,D,E)
            & r2_hidden(E,B) ) ) ) ).

fof(fraenkel_a_3_10_lattice3,axiom,
    ! [A,B,C,D] :
      ( ( ~ v3_struct_0(C)
        & v10_lattices(C)
        & v4_lattice3(C)
        & v6_lattice3(C)
        & l3_lattices(C)
        & m1_subset_1(D,u1_struct_0(C)) )
     => ( r2_hidden(A,a_3_10_lattice3(B,C,D))
      <=> ? [E] :
            ( m1_subset_1(E,u1_struct_0(C))
            & A = k3_lattices(C,E,D)
            & r2_hidden(E,B) ) ) ) ).

fof(fraenkel_a_0_0_lattice3,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_0_lattice3)
    <=> ? [B] :
          ( m1_subset_1(B,f2_s1_lattice3)
          & A = f1_s1_lattice3
          & p1_s1_lattice3(B) ) ) ).

fof(fraenkel_a_0_1_lattice3,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_1_lattice3)
    <=> ? [B] :
          ( m1_subset_1(B,f1_s2_lattice3)
          & A = f3_s2_lattice3(B)
          & p1_s2_lattice3(B) ) ) ).

fof(fraenkel_a_0_2_lattice3,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_2_lattice3)
    <=> ? [B] :
          ( m1_subset_1(B,f1_s2_lattice3)
          & A = k1_funct_1(f4_s2_lattice3,f3_s2_lattice3(B))
          & p1_s2_lattice3(B) ) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(cc1_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( ( ~ v3_struct_0(A)
          & v3_lattice3(A) )
       => ( ~ v3_struct_0(A)
          & v1_lattice3(A)
          & v2_lattice3(A) ) ) ) ).

fof(cc2_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( ( ~ v3_struct_0(A)
          & v2_orders_2(A)
          & v3_realset2(A) )
       => ( ~ v3_struct_0(A)
          & v2_orders_2(A)
          & v3_orders_2(A)
          & v4_orders_2(A)
          & v3_lattice3(A) ) ) ) ).

fof(fc1_yellow_0,axiom,
    ! [A,B] :
      ( m1_relset_1(B,k1_tarski(A),k1_tarski(A))
     => ( ~ v3_struct_0(g1_orders_2(k1_tarski(A),B))
        & v1_orders_2(g1_orders_2(k1_tarski(A),B))
        & v3_realset2(g1_orders_2(k1_tarski(A),B)) ) ) ).

fof(rc1_yellow_0,axiom,
    ? [A] :
      ( l1_orders_2(A)
      & ~ v3_struct_0(A)
      & v1_orders_2(A)
      & v2_orders_2(A)
      & v3_orders_2(A)
      & v4_orders_2(A)
      & v1_lattice3(A)
      & v2_lattice3(A)
      & v3_lattice3(A)
      & v3_realset2(A) ) ).

fof(fc2_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ~ v1_xboole_0(k2_pre_topc(A)) ) ).

fof(cc3_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( ( ~ v3_struct_0(A)
          & v3_lattice3(A) )
       => ( ~ v3_struct_0(A)
          & v3_yellow_0(A) ) ) ) ).

fof(cc4_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( v3_yellow_0(A)
       => ( v1_yellow_0(A)
          & v2_yellow_0(A) ) ) ) ).

fof(cc5_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( ( v1_yellow_0(A)
          & v2_yellow_0(A) )
       => v3_yellow_0(A) ) ) ).

fof(rc2_yellow_0,axiom,
    ? [A] :
      ( l1_orders_2(A)
      & ~ v3_struct_0(A)
      & v2_orders_2(A)
      & v3_orders_2(A)
      & v4_orders_2(A)
      & v1_lattice3(A)
      & v2_lattice3(A)
      & v3_lattice3(A)
      & v1_yellow_0(A)
      & v2_yellow_0(A)
      & v3_yellow_0(A) ) ).

fof(rc3_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ? [B] :
          ( m1_yellow_0(B,A)
          & v1_orders_2(B)
          & v4_yellow_0(B,A) ) ) ).

fof(rc4_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ? [B] :
          ( m1_yellow_0(B,A)
          & ~ v3_struct_0(B)
          & v1_orders_2(B)
          & v4_yellow_0(B,A) ) ) ).

fof(cc6_yellow_0,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_yellow_0(B,A)
         => ( v4_yellow_0(B,A)
           => ( v2_orders_2(B)
              & v4_yellow_0(B,A) ) ) ) ) ).

fof(cc7_yellow_0,axiom,
    ! [A] :
      ( ( v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_yellow_0(B,A)
         => ( v4_yellow_0(B,A)
           => ( v3_orders_2(B)
              & v4_yellow_0(B,A) ) ) ) ) ).

fof(cc8_yellow_0,axiom,
    ! [A] :
      ( ( v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_yellow_0(B,A)
         => ( v4_yellow_0(B,A)
           => ( v4_orders_2(B)
              & v4_yellow_0(B,A) ) ) ) ) ).

fof(cc9_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_yellow_0(B,A)
         => ( v7_yellow_0(B,A)
           => v5_yellow_0(B,A) ) ) ) ).

fof(cc10_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_yellow_0(B,A)
         => ( v8_yellow_0(B,A)
           => v6_yellow_0(B,A) ) ) ) ).

fof(rc5_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ? [B] :
          ( m1_yellow_0(B,A)
          & ~ v3_struct_0(B)
          & v1_orders_2(B)
          & v4_yellow_0(B,A)
          & v5_yellow_0(B,A)
          & v6_yellow_0(B,A)
          & v7_yellow_0(B,A)
          & v8_yellow_0(B,A) ) ) ).

fof(cc11_yellow_0,axiom,
    ! [A] :
      ( ( v3_orders_2(A)
        & v4_orders_2(A)
        & v2_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_yellow_0(B,A)
         => ( ( ~ v3_struct_0(B)
              & v4_yellow_0(B,A)
              & v5_yellow_0(B,A) )
           => ( ~ v3_struct_0(B)
              & v3_orders_2(B)
              & v4_orders_2(B)
              & v2_lattice3(B)
              & v4_yellow_0(B,A)
              & v5_yellow_0(B,A) ) ) ) ) ).

fof(cc12_yellow_0,axiom,
    ! [A] :
      ( ( v3_orders_2(A)
        & v4_orders_2(A)
        & v1_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_yellow_0(B,A)
         => ( ( ~ v3_struct_0(B)
              & v4_yellow_0(B,A)
              & v6_yellow_0(B,A) )
           => ( ~ v3_struct_0(B)
              & v3_orders_2(B)
              & v4_orders_2(B)
              & v1_lattice3(B)
              & v4_yellow_0(B,A)
              & v6_yellow_0(B,A) ) ) ) ) ).

fof(d1_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ( v2_orders_2(A)
      <=> ! [B] :
            ( m1_subset_1(B,u1_struct_0(A))
           => r1_orders_2(A,B,B) ) ) ) ).

fof(d2_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( v3_orders_2(A)
      <=> ! [B] :
            ( m1_subset_1(B,u1_struct_0(A))
           => ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => ( ( r1_orders_2(A,B,C)
                        & r1_orders_2(A,C,D) )
                     => r1_orders_2(A,B,D) ) ) ) ) ) ) ).

fof(d3_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( v4_orders_2(A)
      <=> ! [B] :
            ( m1_subset_1(B,u1_struct_0(A))
           => ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ( ( r1_orders_2(A,B,C)
                    & r1_orders_2(A,C,B) )
                 => B = C ) ) ) ) ) ).

fof(t1_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( l1_orders_2(B)
         => ( g1_orders_2(u1_struct_0(A),u1_orders_2(A)) = g1_orders_2(u1_struct_0(B),u1_orders_2(B))
           => ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => ! [E] :
                        ( m1_subset_1(E,u1_struct_0(B))
                       => ! [F] :
                            ( m1_subset_1(F,u1_struct_0(B))
                           => ( ( C = E
                                & D = F )
                             => ( ( r1_orders_2(A,C,D)
                                 => r1_orders_2(B,E,F) )
                                & ( r2_orders_2(A,C,D)
                                 => r2_orders_2(B,E,F) ) ) ) ) ) ) ) ) ) ) ).

fof(t2_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( l1_orders_2(B)
         => ( g1_orders_2(u1_struct_0(A),u1_orders_2(A)) = g1_orders_2(u1_struct_0(B),u1_orders_2(B))
           => ! [C,D] :
                ( m1_subset_1(D,u1_struct_0(A))
               => ! [E] :
                    ( m1_subset_1(E,u1_struct_0(B))
                   => ( D = E
                     => ( ( r2_lattice3(A,C,D)
                         => r2_lattice3(B,C,E) )
                        & ( r1_lattice3(A,C,D)
                         => r1_lattice3(B,C,E) ) ) ) ) ) ) ) ) ).

fof(t3_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( l1_orders_2(B)
         => ( ( g1_orders_2(u1_struct_0(A),u1_orders_2(A)) = g1_orders_2(u1_struct_0(B),u1_orders_2(B))
              & v3_lattice3(A) )
           => v3_lattice3(B) ) ) ) ).

fof(t4_yellow_0,axiom,
    ! [A] :
      ( ( v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( r1_orders_2(A,B,C)
               => ! [D] :
                    ( ( r1_lattice3(A,D,C)
                     => r1_lattice3(A,D,B) )
                    & ( r2_lattice3(A,D,B)
                     => r2_lattice3(A,D,C) ) ) ) ) ) ) ).

fof(t5_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B,C] :
          ( m1_subset_1(C,u1_struct_0(A))
         => ( ( r2_lattice3(A,B,C)
             => r2_lattice3(A,k3_xboole_0(B,u1_struct_0(A)),C) )
            & ( r2_lattice3(A,k3_xboole_0(B,u1_struct_0(A)),C)
             => r2_lattice3(A,B,C) )
            & ( r1_lattice3(A,B,C)
             => r1_lattice3(A,k3_xboole_0(B,u1_struct_0(A)),C) )
            & ( r1_lattice3(A,k3_xboole_0(B,u1_struct_0(A)),C)
             => r1_lattice3(A,B,C) ) ) ) ) ).

fof(t6_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ( r2_lattice3(A,k1_xboole_0,B)
            & r1_lattice3(A,k1_xboole_0,B) ) ) ) ).

fof(t7_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( ( r1_lattice3(A,k1_tarski(C),B)
                 => r1_orders_2(A,B,C) )
                & ( r1_orders_2(A,B,C)
                 => r1_lattice3(A,k1_tarski(C),B) )
                & ( r2_lattice3(A,k1_tarski(C),B)
                 => r1_orders_2(A,C,B) )
                & ( r1_orders_2(A,C,B)
                 => r2_lattice3(A,k1_tarski(C),B) ) ) ) ) ) ).

fof(t8_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ( ( r1_lattice3(A,k2_tarski(C,D),B)
                     => ( r1_orders_2(A,B,C)
                        & r1_orders_2(A,B,D) ) )
                    & ( ( r1_orders_2(A,B,C)
                        & r1_orders_2(A,B,D) )
                     => r1_lattice3(A,k2_tarski(C,D),B) )
                    & ( r2_lattice3(A,k2_tarski(C,D),B)
                     => ( r1_orders_2(A,C,B)
                        & r1_orders_2(A,D,B) ) )
                    & ( ( r1_orders_2(A,C,B)
                        & r1_orders_2(A,D,B) )
                     => r2_lattice3(A,k2_tarski(C,D),B) ) ) ) ) ) ) ).

fof(t9_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B,C] :
          ( r1_tarski(B,C)
         => ! [D] :
              ( m1_subset_1(D,u1_struct_0(A))
             => ( ( r1_lattice3(A,C,D)
                 => r1_lattice3(A,B,D) )
                & ( r2_lattice3(A,C,D)
                 => r2_lattice3(A,B,D) ) ) ) ) ) ).

fof(t10_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B,C,D] :
          ( m1_subset_1(D,u1_struct_0(A))
         => ( ( ( r1_lattice3(A,B,D)
                & r1_lattice3(A,C,D) )
             => r1_lattice3(A,k2_xboole_0(B,C),D) )
            & ( ( r2_lattice3(A,B,D)
                & r2_lattice3(A,C,D) )
             => r2_lattice3(A,k2_xboole_0(B,C),D) ) ) ) ) ).

fof(t11_yellow_0,axiom,
    ! [A] :
      ( ( v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B,C] :
          ( m1_subset_1(C,u1_struct_0(A))
         => ! [D] :
              ( m1_subset_1(D,u1_struct_0(A))
             => ( ( r2_lattice3(A,B,C)
                  & r1_orders_2(A,C,D) )
               => r2_lattice3(A,B,D) ) ) ) ) ).

fof(t12_yellow_0,axiom,
    ! [A] :
      ( ( v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B,C] :
          ( m1_subset_1(C,u1_struct_0(A))
         => ! [D] :
              ( m1_subset_1(D,u1_struct_0(A))
             => ( ( r1_lattice3(A,B,C)
                  & r1_orders_2(A,D,C) )
               => r1_lattice3(A,B,D) ) ) ) ) ).

fof(d4_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( v1_yellow_0(A)
      <=> ? [B] :
            ( m1_subset_1(B,u1_struct_0(A))
            & r1_lattice3(A,u1_struct_0(A),B) ) ) ) ).

fof(d5_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( v2_yellow_0(A)
      <=> ? [B] :
            ( m1_subset_1(B,u1_struct_0(A))
            & r2_lattice3(A,u1_struct_0(A),B) ) ) ) ).

fof(d6_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( v3_yellow_0(A)
      <=> ( v1_yellow_0(A)
          & v2_yellow_0(A) ) ) ) ).

fof(t13_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( l1_orders_2(B)
         => ( g1_orders_2(u1_struct_0(A),u1_orders_2(A)) = g1_orders_2(u1_struct_0(B),u1_orders_2(B))
           => ( ( v1_yellow_0(A)
               => v1_yellow_0(B) )
              & ( v2_yellow_0(A)
               => v2_yellow_0(B) ) ) ) ) ) ).

fof(d7_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( r1_yellow_0(A,B)
        <=> ? [C] :
              ( m1_subset_1(C,u1_struct_0(A))
              & r2_lattice3(A,B,C)
              & ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ( r2_lattice3(A,B,D)
                   => r1_orders_2(A,C,D) ) )
              & ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ( ( r2_lattice3(A,B,D)
                      & ! [E] :
                          ( m1_subset_1(E,u1_struct_0(A))
                         => ( r2_lattice3(A,B,E)
                           => r1_orders_2(A,D,E) ) ) )
                   => D = C ) ) ) ) ) ).

fof(d8_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( r2_yellow_0(A,B)
        <=> ? [C] :
              ( m1_subset_1(C,u1_struct_0(A))
              & r1_lattice3(A,B,C)
              & ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ( r1_lattice3(A,B,D)
                   => r1_orders_2(A,D,C) ) )
              & ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ( ( r1_lattice3(A,B,D)
                      & ! [E] :
                          ( m1_subset_1(E,u1_struct_0(A))
                         => ( r1_lattice3(A,B,E)
                           => r1_orders_2(A,E,D) ) ) )
                   => D = C ) ) ) ) ) ).

fof(t14_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( l1_orders_2(B)
         => ( g1_orders_2(u1_struct_0(A),u1_orders_2(A)) = g1_orders_2(u1_struct_0(B),u1_orders_2(B))
           => ! [C] :
                ( ( r1_yellow_0(A,C)
                 => r1_yellow_0(B,C) )
                & ( r2_yellow_0(A,C)
                 => r2_yellow_0(B,C) ) ) ) ) ) ).

fof(t15_yellow_0,axiom,
    ! [A] :
      ( ( v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( r1_yellow_0(A,B)
        <=> ? [C] :
              ( m1_subset_1(C,u1_struct_0(A))
              & r2_lattice3(A,B,C)
              & ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ( r2_lattice3(A,B,D)
                   => r1_orders_2(A,C,D) ) ) ) ) ) ).

fof(t16_yellow_0,axiom,
    ! [A] :
      ( ( v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( r2_yellow_0(A,B)
        <=> ? [C] :
              ( m1_subset_1(C,u1_struct_0(A))
              & r1_lattice3(A,B,C)
              & ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ( r1_lattice3(A,B,D)
                   => r1_orders_2(A,D,C) ) ) ) ) ) ).

fof(t17_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v4_orders_2(A)
        & v3_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( r1_yellow_0(A,B)
          & r2_yellow_0(A,B) ) ) ).

fof(t18_yellow_0,axiom,
    ! [A] :
      ( ( v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ( ( ( D = k10_lattice3(A,B,C)
                        & r1_yellow_0(A,k2_tarski(B,C)) )
                     => ( r1_orders_2(A,B,D)
                        & r1_orders_2(A,C,D)
                        & ! [E] :
                            ( m1_subset_1(E,u1_struct_0(A))
                           => ( ( r1_orders_2(A,B,E)
                                & r1_orders_2(A,C,E) )
                             => r1_orders_2(A,D,E) ) ) ) )
                    & ( ( r1_orders_2(A,B,D)
                        & r1_orders_2(A,C,D)
                        & ! [E] :
                            ( m1_subset_1(E,u1_struct_0(A))
                           => ( ( r1_orders_2(A,B,E)
                                & r1_orders_2(A,C,E) )
                             => r1_orders_2(A,D,E) ) ) )
                     => ( D = k10_lattice3(A,B,C)
                        & r1_yellow_0(A,k2_tarski(B,C)) ) ) ) ) ) ) ) ).

fof(t19_yellow_0,axiom,
    ! [A] :
      ( ( v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ( ( ( D = k11_lattice3(A,B,C)
                        & r2_yellow_0(A,k2_tarski(B,C)) )
                     => ( r1_orders_2(A,D,B)
                        & r1_orders_2(A,D,C)
                        & ! [E] :
                            ( m1_subset_1(E,u1_struct_0(A))
                           => ( ( r1_orders_2(A,E,B)
                                & r1_orders_2(A,E,C) )
                             => r1_orders_2(A,E,D) ) ) ) )
                    & ( ( r1_orders_2(A,D,B)
                        & r1_orders_2(A,D,C)
                        & ! [E] :
                            ( m1_subset_1(E,u1_struct_0(A))
                           => ( ( r1_orders_2(A,E,B)
                                & r1_orders_2(A,E,C) )
                             => r1_orders_2(A,E,D) ) ) )
                     => ( D = k11_lattice3(A,B,C)
                        & r2_yellow_0(A,k2_tarski(B,C)) ) ) ) ) ) ) ) ).

fof(t20_yellow_0,axiom,
    ! [A] :
      ( ( v4_orders_2(A)
        & l1_orders_2(A) )
     => ( v1_lattice3(A)
      <=> ! [B] :
            ( m1_subset_1(B,u1_struct_0(A))
           => ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => r1_yellow_0(A,k2_tarski(B,C)) ) ) ) ) ).

fof(t21_yellow_0,axiom,
    ! [A] :
      ( ( v4_orders_2(A)
        & l1_orders_2(A) )
     => ( v2_lattice3(A)
      <=> ! [B] :
            ( m1_subset_1(B,u1_struct_0(A))
           => ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => r2_yellow_0(A,k2_tarski(B,C)) ) ) ) ) ).

fof(t22_yellow_0,axiom,
    ! [A] :
      ( ( v4_orders_2(A)
        & v1_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ( D = k13_lattice3(A,B,C)
                  <=> ( r1_orders_2(A,B,D)
                      & r1_orders_2(A,C,D)
                      & ! [E] :
                          ( m1_subset_1(E,u1_struct_0(A))
                         => ( ( r1_orders_2(A,B,E)
                              & r1_orders_2(A,C,E) )
                           => r1_orders_2(A,D,E) ) ) ) ) ) ) ) ) ).

fof(t23_yellow_0,axiom,
    ! [A] :
      ( ( v4_orders_2(A)
        & v2_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ( D = k12_lattice3(A,B,C)
                  <=> ( r1_orders_2(A,D,B)
                      & r1_orders_2(A,D,C)
                      & ! [E] :
                          ( m1_subset_1(E,u1_struct_0(A))
                         => ( ( r1_orders_2(A,E,B)
                              & r1_orders_2(A,E,C) )
                           => r1_orders_2(A,E,D) ) ) ) ) ) ) ) ) ).

fof(t24_yellow_0,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v4_orders_2(A)
        & v1_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( B = k13_lattice3(A,B,C)
              <=> r1_orders_2(A,C,B) ) ) ) ) ).

fof(t25_yellow_0,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v4_orders_2(A)
        & v2_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( B = k12_lattice3(A,B,C)
              <=> r3_orders_2(A,B,C) ) ) ) ) ).

fof(d9_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B,C] :
          ( m1_subset_1(C,u1_struct_0(A))
         => ( r1_yellow_0(A,B)
           => ( C = k1_yellow_0(A,B)
            <=> ( r2_lattice3(A,B,C)
                & ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => ( r2_lattice3(A,B,D)
                     => r1_orders_2(A,C,D) ) ) ) ) ) ) ) ).

fof(d10_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B,C] :
          ( m1_subset_1(C,u1_struct_0(A))
         => ( r2_yellow_0(A,B)
           => ( C = k2_yellow_0(A,B)
            <=> ( r1_lattice3(A,B,C)
                & ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => ( r1_lattice3(A,B,D)
                     => r1_orders_2(A,D,C) ) ) ) ) ) ) ) ).

fof(t26_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( l1_orders_2(B)
         => ( g1_orders_2(u1_struct_0(A),u1_orders_2(A)) = g1_orders_2(u1_struct_0(B),u1_orders_2(B))
           => ! [C] :
                ( r1_yellow_0(A,C)
               => k1_yellow_0(A,C) = k1_yellow_0(B,C) ) ) ) ) ).

fof(t27_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( l1_orders_2(B)
         => ( g1_orders_2(u1_struct_0(A),u1_orders_2(A)) = g1_orders_2(u1_struct_0(B),u1_orders_2(B))
           => ! [C] :
                ( r2_yellow_0(A,C)
               => k2_yellow_0(A,C) = k2_yellow_0(B,C) ) ) ) ) ).

fof(t28_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v3_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( k1_yellow_0(A,B) = k15_lattice3(k14_lattice3(A),B)
          & k2_yellow_0(A,B) = k16_lattice3(k14_lattice3(A),B) ) ) ).

fof(t29_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v4_lattice3(A)
        & l3_lattices(A) )
     => ! [B] :
          ( k15_lattice3(A,B) = k1_yellow_0(k3_lattice3(A),B)
          & k16_lattice3(A,B) = k2_yellow_0(k3_lattice3(A),B) ) ) ).

fof(t30_yellow_0,axiom,
    ! [A] :
      ( ( v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( ( ( B = k1_yellow_0(A,C)
                  & r1_yellow_0(A,C) )
               => ( r2_lattice3(A,C,B)
                  & ! [D] :
                      ( m1_subset_1(D,u1_struct_0(A))
                     => ( r2_lattice3(A,C,D)
                       => r1_orders_2(A,B,D) ) ) ) )
              & ( ( r2_lattice3(A,C,B)
                  & ! [D] :
                      ( m1_subset_1(D,u1_struct_0(A))
                     => ( r2_lattice3(A,C,D)
                       => r1_orders_2(A,B,D) ) ) )
               => ( B = k1_yellow_0(A,C)
                  & r1_yellow_0(A,C) ) ) ) ) ) ).

fof(t31_yellow_0,axiom,
    ! [A] :
      ( ( v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( ( ( B = k2_yellow_0(A,C)
                  & r2_yellow_0(A,C) )
               => ( r1_lattice3(A,C,B)
                  & ! [D] :
                      ( m1_subset_1(D,u1_struct_0(A))
                     => ( r1_lattice3(A,C,D)
                       => r1_orders_2(A,D,B) ) ) ) )
              & ( ( r1_lattice3(A,C,B)
                  & ! [D] :
                      ( m1_subset_1(D,u1_struct_0(A))
                     => ( r1_lattice3(A,C,D)
                       => r1_orders_2(A,D,B) ) ) )
               => ( B = k2_yellow_0(A,C)
                  & r2_yellow_0(A,C) ) ) ) ) ) ).

fof(t32_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v4_orders_2(A)
        & v3_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( B = k1_yellow_0(A,C)
            <=> ( r2_lattice3(A,C,B)
                & ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => ( r2_lattice3(A,C,D)
                     => r1_orders_2(A,B,D) ) ) ) ) ) ) ).

fof(t33_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v4_orders_2(A)
        & v3_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( B = k2_yellow_0(A,C)
            <=> ( r1_lattice3(A,C,B)
                & ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => ( r1_lattice3(A,C,D)
                     => r1_orders_2(A,D,B) ) ) ) ) ) ) ).

fof(t34_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B,C] :
          ( ( r1_tarski(B,C)
            & r1_yellow_0(A,B)
            & r1_yellow_0(A,C) )
         => r1_orders_2(A,k1_yellow_0(A,B),k1_yellow_0(A,C)) ) ) ).

fof(t35_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B,C] :
          ( ( r1_tarski(B,C)
            & r2_yellow_0(A,B)
            & r2_yellow_0(A,C) )
         => r1_orders_2(A,k2_yellow_0(A,C),k2_yellow_0(A,B)) ) ) ).

fof(t36_yellow_0,axiom,
    ! [A] :
      ( ( v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B,C] :
          ( ( r1_yellow_0(A,B)
            & r1_yellow_0(A,C)
            & r1_yellow_0(A,k2_xboole_0(B,C)) )
         => k1_yellow_0(A,k2_xboole_0(B,C)) = k10_lattice3(A,k1_yellow_0(A,B),k1_yellow_0(A,C)) ) ) ).

fof(t37_yellow_0,axiom,
    ! [A] :
      ( ( v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B,C] :
          ( ( r2_yellow_0(A,B)
            & r2_yellow_0(A,C)
            & r2_yellow_0(A,k2_xboole_0(B,C)) )
         => k2_yellow_0(A,k2_xboole_0(B,C)) = k11_lattice3(A,k2_yellow_0(A,B),k2_yellow_0(A,C)) ) ) ).

fof(t38_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ( r1_yellow_0(A,k1_struct_0(A,B))
            & r2_yellow_0(A,k1_struct_0(A,B)) ) ) ) ).

fof(t39_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ( k1_yellow_0(A,k1_struct_0(A,B)) = B
            & k2_yellow_0(A,k1_struct_0(A,B)) = B ) ) ) ).

fof(t40_yellow_0,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v2_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => k2_yellow_0(A,k2_struct_0(A,B,C)) = k12_lattice3(A,B,C) ) ) ) ).

fof(t41_yellow_0,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v1_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => k1_yellow_0(A,k2_struct_0(A,B,C)) = k13_lattice3(A,B,C) ) ) ) ).

fof(t42_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v4_orders_2(A)
        & v1_yellow_0(A)
        & l1_orders_2(A) )
     => ( r1_yellow_0(A,k1_xboole_0)
        & r2_yellow_0(A,u1_struct_0(A)) ) ) ).

fof(t43_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v4_orders_2(A)
        & v2_yellow_0(A)
        & l1_orders_2(A) )
     => ( r2_yellow_0(A,k1_xboole_0)
        & r1_yellow_0(A,u1_struct_0(A)) ) ) ).

fof(d11_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => k3_yellow_0(A) = k1_yellow_0(A,k1_xboole_0) ) ).

fof(d12_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => k4_yellow_0(A) = k2_yellow_0(A,k1_xboole_0) ) ).

fof(t44_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v4_orders_2(A)
        & v1_yellow_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => r1_orders_2(A,k3_yellow_0(A),B) ) ) ).

fof(t45_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v4_orders_2(A)
        & v2_yellow_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => r1_orders_2(A,B,k4_yellow_0(A)) ) ) ).

fof(t46_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B,C] :
          ( ( ! [D] :
                ( m1_subset_1(D,u1_struct_0(A))
               => ( r2_lattice3(A,B,D)
                <=> r2_lattice3(A,C,D) ) )
            & r1_yellow_0(A,B) )
         => r1_yellow_0(A,C) ) ) ).

fof(t47_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B,C] :
          ( ( r1_yellow_0(A,B)
            & ! [D] :
                ( m1_subset_1(D,u1_struct_0(A))
               => ( r2_lattice3(A,B,D)
                <=> r2_lattice3(A,C,D) ) ) )
         => k1_yellow_0(A,B) = k1_yellow_0(A,C) ) ) ).

fof(t48_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B,C] :
          ( ( ! [D] :
                ( m1_subset_1(D,u1_struct_0(A))
               => ( r1_lattice3(A,B,D)
                <=> r1_lattice3(A,C,D) ) )
            & r2_yellow_0(A,B) )
         => r2_yellow_0(A,C) ) ) ).

fof(t49_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B,C] :
          ( ( r2_yellow_0(A,B)
            & ! [D] :
                ( m1_subset_1(D,u1_struct_0(A))
               => ( r1_lattice3(A,B,D)
                <=> r1_lattice3(A,C,D) ) ) )
         => k2_yellow_0(A,B) = k2_yellow_0(A,C) ) ) ).

fof(t50_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( r1_yellow_0(A,B)
           => r1_yellow_0(A,k3_xboole_0(B,u1_struct_0(A))) )
          & ( r1_yellow_0(A,k3_xboole_0(B,u1_struct_0(A)))
           => r1_yellow_0(A,B) )
          & ( r2_yellow_0(A,B)
           => r2_yellow_0(A,k3_xboole_0(B,u1_struct_0(A))) )
          & ( r2_yellow_0(A,k3_xboole_0(B,u1_struct_0(A)))
           => r2_yellow_0(A,B) ) ) ) ).

fof(t51_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( r1_yellow_0(A,B)
            | r1_yellow_0(A,k3_xboole_0(B,u1_struct_0(A))) )
         => k1_yellow_0(A,B) = k1_yellow_0(A,k3_xboole_0(B,u1_struct_0(A))) ) ) ).

fof(t52_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( r2_yellow_0(A,B)
            | r2_yellow_0(A,k3_xboole_0(B,u1_struct_0(A))) )
         => k2_yellow_0(A,B) = k2_yellow_0(A,k3_xboole_0(B,u1_struct_0(A))) ) ) ).

fof(t53_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ( ! [B] :
            ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
           => r1_yellow_0(A,B) )
       => v3_lattice3(A) ) ) ).

fof(t54_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ( v1_lattice3(A)
      <=> ! [B] :
            ( ( ~ v1_xboole_0(B)
              & v1_finset_1(B)
              & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
           => r1_yellow_0(A,B) ) ) ) ).

fof(t55_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ( v2_lattice3(A)
      <=> ! [B] :
            ( ( ~ v1_xboole_0(B)
              & v1_finset_1(B)
              & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
           => r2_yellow_0(A,B) ) ) ) ).

fof(t56_yellow_0,axiom,
    ! [A,B] :
      ( m2_relset_1(B,A,A)
     => B = k1_toler_1(B,A) ) ).

fof(d13_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( l1_orders_2(B)
         => ( m1_yellow_0(B,A)
          <=> ( r1_tarski(u1_struct_0(B),u1_struct_0(A))
              & r1_tarski(u1_orders_2(B),u1_orders_2(A)) ) ) ) ) ).

fof(d14_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( m1_yellow_0(B,A)
         => ( v4_yellow_0(B,A)
          <=> u1_orders_2(B) = k1_toler_1(u1_orders_2(A),u1_struct_0(B)) ) ) ) ).

fof(t57_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ( v4_yellow_0(g1_orders_2(B,k1_toler_1(u1_orders_2(A),B)),A)
            & m1_yellow_0(g1_orders_2(B,k1_toler_1(u1_orders_2(A),B)),A) ) ) ) ).

fof(t58_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( ( v4_yellow_0(B,A)
            & m1_yellow_0(B,A) )
         => ! [C] :
              ( ( v4_yellow_0(C,A)
                & m1_yellow_0(C,A) )
             => ( u1_struct_0(B) = u1_struct_0(C)
               => g1_orders_2(u1_struct_0(B),u1_orders_2(B)) = g1_orders_2(u1_struct_0(C),u1_orders_2(C)) ) ) ) ) ).

fof(d15_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ! [C] :
              ( ( v1_orders_2(C)
                & v4_yellow_0(C,A)
                & m1_yellow_0(C,A) )
             => ( C = k5_yellow_0(A,B)
              <=> u1_struct_0(C) = B ) ) ) ) ).

fof(t59_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & m1_yellow_0(B,A) )
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(B))
             => m1_subset_1(C,u1_struct_0(A)) ) ) ) ).

fof(t60_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( m1_yellow_0(B,A)
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ! [E] :
                      ( m1_subset_1(E,u1_struct_0(B))
                     => ! [F] :
                          ( m1_subset_1(F,u1_struct_0(B))
                         => ( ( E = C
                              & F = D
                              & r1_orders_2(B,E,F) )
                           => r1_orders_2(A,C,D) ) ) ) ) ) ) ) ).

fof(t61_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( ( v4_yellow_0(B,A)
            & m1_yellow_0(B,A) )
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ! [E] :
                      ( m1_subset_1(E,u1_struct_0(B))
                     => ! [F] :
                          ( m1_subset_1(F,u1_struct_0(B))
                         => ( ( E = C
                              & F = D
                              & r1_orders_2(A,C,D)
                              & r2_hidden(E,u1_struct_0(B))
                              & r2_hidden(F,u1_struct_0(B)) )
                           => r1_orders_2(B,E,F) ) ) ) ) ) ) ) ).

fof(t62_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v4_yellow_0(B,A)
            & m1_yellow_0(B,A) )
         => ! [C,D] :
              ( m1_subset_1(D,u1_struct_0(A))
             => ! [E] :
                  ( m1_subset_1(E,u1_struct_0(B))
                 => ( E = D
                   => ( ( r1_lattice3(A,C,D)
                       => r1_lattice3(B,C,E) )
                      & ( r2_lattice3(A,C,D)
                       => r2_lattice3(B,C,E) ) ) ) ) ) ) ) ).

fof(t63_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & m1_yellow_0(B,A) )
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(B)))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(A))
                 => ! [E] :
                      ( m1_subset_1(E,u1_struct_0(B))
                     => ( E = D
                       => ( ( r1_lattice3(B,C,E)
                           => r1_lattice3(A,C,D) )
                          & ( r2_lattice3(B,C,E)
                           => r2_lattice3(A,C,D) ) ) ) ) ) ) ) ) ).

fof(d16_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_yellow_0(B,A)
         => ( v5_yellow_0(B,A)
          <=> ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => ( ( r2_hidden(C,u1_struct_0(B))
                        & r2_hidden(D,u1_struct_0(B))
                        & r2_yellow_0(A,k2_struct_0(A,C,D)) )
                     => r2_hidden(k2_yellow_0(A,k2_struct_0(A,C,D)),u1_struct_0(B)) ) ) ) ) ) ) ).

fof(d17_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_yellow_0(B,A)
         => ( v6_yellow_0(B,A)
          <=> ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => ( ( r2_hidden(C,u1_struct_0(B))
                        & r2_hidden(D,u1_struct_0(B))
                        & r1_yellow_0(A,k2_struct_0(A,C,D)) )
                     => r2_hidden(k1_yellow_0(A,k2_struct_0(A,C,D)),u1_struct_0(B)) ) ) ) ) ) ) ).

fof(d18_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_yellow_0(B,A)
         => ( v7_yellow_0(B,A)
          <=> ! [C] :
                ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(B)))
               => ( r2_yellow_0(A,C)
                 => r2_hidden(k2_yellow_0(A,C),u1_struct_0(B)) ) ) ) ) ) ).

fof(d19_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_yellow_0(B,A)
         => ( v8_yellow_0(B,A)
          <=> ! [C] :
                ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(B)))
               => ( r1_yellow_0(A,C)
                 => r2_hidden(k1_yellow_0(A,C),u1_struct_0(B)) ) ) ) ) ) ).

fof(t64_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v4_yellow_0(B,A)
            & m1_yellow_0(B,A) )
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(B)))
             => ( ( r2_yellow_0(A,C)
                  & r2_hidden(k2_yellow_0(A,C),u1_struct_0(B)) )
               => ( r2_yellow_0(B,C)
                  & k2_yellow_0(B,C) = k2_yellow_0(A,C) ) ) ) ) ) ).

fof(t65_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v4_yellow_0(B,A)
            & m1_yellow_0(B,A) )
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(B)))
             => ( ( r1_yellow_0(A,C)
                  & r2_hidden(k1_yellow_0(A,C),u1_struct_0(B)) )
               => ( r1_yellow_0(B,C)
                  & k1_yellow_0(B,C) = k1_yellow_0(A,C) ) ) ) ) ) ).

fof(t66_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v4_yellow_0(B,A)
            & m1_yellow_0(B,A) )
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(B))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(B))
                 => ( ( r2_yellow_0(A,k2_struct_0(B,C,D))
                      & r2_hidden(k2_yellow_0(A,k2_struct_0(B,C,D)),u1_struct_0(B)) )
                   => ( r2_yellow_0(B,k2_struct_0(B,C,D))
                      & k2_yellow_0(B,k2_struct_0(B,C,D)) = k2_yellow_0(A,k2_struct_0(B,C,D)) ) ) ) ) ) ) ).

fof(t67_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v4_yellow_0(B,A)
            & m1_yellow_0(B,A) )
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(B))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(B))
                 => ( ( r1_yellow_0(A,k2_struct_0(B,C,D))
                      & r2_hidden(k1_yellow_0(A,k2_struct_0(B,C,D)),u1_struct_0(B)) )
                   => ( r1_yellow_0(B,k2_struct_0(B,C,D))
                      & k1_yellow_0(B,k2_struct_0(B,C,D)) = k1_yellow_0(A,k2_struct_0(B,C,D)) ) ) ) ) ) ) ).

fof(t68_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v3_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v4_yellow_0(B,A)
            & m1_yellow_0(B,A) )
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(B)))
             => ( r2_hidden(k2_yellow_0(A,C),u1_struct_0(B))
               => k2_yellow_0(B,C) = k2_yellow_0(A,C) ) ) ) ) ).

fof(t69_yellow_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v3_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v4_yellow_0(B,A)
            & m1_yellow_0(B,A) )
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(B)))
             => ( r2_hidden(k1_yellow_0(A,C),u1_struct_0(B))
               => k1_yellow_0(B,C) = k1_yellow_0(A,C) ) ) ) ) ).

fof(t70_yellow_0,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v2_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v4_yellow_0(B,A)
            & v5_yellow_0(B,A)
            & m1_yellow_0(B,A) )
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(B))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(B))
                 => ! [E] :
                      ( m1_subset_1(E,u1_struct_0(A))
                     => ! [F] :
                          ( m1_subset_1(F,u1_struct_0(A))
                         => ( ( E = C
                              & F = D )
                           => k12_lattice3(B,C,D) = k12_lattice3(A,E,F) ) ) ) ) ) ) ) ).

fof(t71_yellow_0,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v1_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v4_yellow_0(B,A)
            & v6_yellow_0(B,A)
            & m1_yellow_0(B,A) )
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(B))
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(B))
                 => ! [E] :
                      ( m1_subset_1(E,u1_struct_0(A))
                     => ! [F] :
                          ( m1_subset_1(F,u1_struct_0(A))
                         => ( ( E = C
                              & F = D )
                           => k13_lattice3(B,C,D) = k13_lattice3(A,E,F) ) ) ) ) ) ) ) ).

fof(s1_yellow_0,axiom,
    ? [A] :
      ( ~ v3_struct_0(A)
      & v1_orders_2(A)
      & l1_orders_2(A)
      & u1_struct_0(A) = f1_s1_yellow_0
      & ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( r1_orders_2(A,B,C)
              <=> p1_s1_yellow_0(B,C) ) ) ) ) ).

fof(dt_m1_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( m1_yellow_0(B,A)
         => l1_orders_2(B) ) ) ).

fof(existence_m1_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ? [B] : m1_yellow_0(B,A) ) ).

fof(dt_k1_yellow_0,axiom,
    ! [A,B] :
      ( l1_orders_2(A)
     => m1_subset_1(k1_yellow_0(A,B),u1_struct_0(A)) ) ).

fof(dt_k2_yellow_0,axiom,
    ! [A,B] :
      ( l1_orders_2(A)
     => m1_subset_1(k2_yellow_0(A,B),u1_struct_0(A)) ) ).

fof(dt_k3_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => m1_subset_1(k3_yellow_0(A),u1_struct_0(A)) ) ).

fof(dt_k4_yellow_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => m1_subset_1(k4_yellow_0(A),u1_struct_0(A)) ) ).

fof(dt_k5_yellow_0,axiom,
    ! [A,B] :
      ( ( l1_orders_2(A)
        & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
     => ( v1_orders_2(k5_yellow_0(A,B))
        & v4_yellow_0(k5_yellow_0(A,B),A)
        & m1_yellow_0(k5_yellow_0(A,B),A) ) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(fc1_waybel_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( v1_xboole_0(k1_pre_topc(A))
        & v5_orders_2(k1_pre_topc(A),A)
        & v1_finset_1(k1_pre_topc(A))
        & v1_membered(k1_pre_topc(A))
        & v2_membered(k1_pre_topc(A))
        & v3_membered(k1_pre_topc(A))
        & v4_membered(k1_pre_topc(A))
        & v5_membered(k1_pre_topc(A))
        & v1_waybel_0(k1_pre_topc(A),A)
        & v2_waybel_0(k1_pre_topc(A),A) ) ) ).

fof(rc1_waybel_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ? [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
          & v1_waybel_0(B,A)
          & v2_waybel_0(B,A) ) ) ).

fof(rc2_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & l1_orders_2(A) )
     => ? [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
          & ~ v1_xboole_0(B)
          & v1_finset_1(B)
          & v1_waybel_0(B,A)
          & v2_waybel_0(B,A) ) ) ).

fof(fc2_waybel_0,axiom,
    ! [A] :
      ( ( v1_lattice3(A)
        & l1_orders_2(A) )
     => ( ~ v1_xboole_0(k2_pre_topc(A))
        & v1_waybel_0(k2_pre_topc(A),A) ) ) ).

fof(fc3_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_yellow_0(A)
        & l1_orders_2(A) )
     => ( ~ v1_xboole_0(k2_pre_topc(A))
        & v1_waybel_0(k2_pre_topc(A),A) ) ) ).

fof(fc4_waybel_0,axiom,
    ! [A] :
      ( ( v2_lattice3(A)
        & l1_orders_2(A) )
     => ( ~ v1_xboole_0(k2_pre_topc(A))
        & v2_waybel_0(k2_pre_topc(A),A) ) ) ).

fof(fc5_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v1_yellow_0(A)
        & l1_orders_2(A) )
     => ( ~ v1_xboole_0(k2_pre_topc(A))
        & v2_waybel_0(k2_pre_topc(A),A) ) ) ).

fof(cc1_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_yellow_0(B,A)
         => ( v7_yellow_0(B,A)
           => v3_waybel_0(B,A) ) ) ) ).

fof(cc2_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_yellow_0(B,A)
         => ( v8_yellow_0(B,A)
           => v4_waybel_0(B,A) ) ) ) ).

fof(rc3_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ? [B] :
          ( m1_yellow_0(B,A)
          & ~ v3_struct_0(B)
          & v1_orders_2(B)
          & v4_yellow_0(B,A)
          & v5_yellow_0(B,A)
          & v6_yellow_0(B,A)
          & v7_yellow_0(B,A)
          & v8_yellow_0(B,A)
          & v3_waybel_0(B,A)
          & v4_waybel_0(B,A) ) ) ).

fof(rc4_waybel_0,axiom,
    ! [A] :
      ( l1_struct_0(A)
     => ? [B] :
          ( l1_waybel_0(B,A)
          & v6_waybel_0(B,A) ) ) ).

fof(fc6_waybel_0,axiom,
    ! [A,B,C,D] :
      ( ( l1_struct_0(A)
        & ~ v1_xboole_0(B)
        & m1_relset_1(C,B,B)
        & v1_funct_1(D)
        & v1_funct_2(D,B,u1_struct_0(A))
        & m1_relset_1(D,B,u1_struct_0(A)) )
     => ( ~ v3_struct_0(g1_waybel_0(A,B,C,D))
        & v6_waybel_0(g1_waybel_0(A,B,C,D),A) ) ) ).

fof(rc5_waybel_0,axiom,
    ! [A] :
      ( l1_struct_0(A)
     => ? [B] :
          ( l1_waybel_0(B,A)
          & ~ v3_struct_0(B)
          & v2_orders_2(B)
          & v3_orders_2(B)
          & v4_orders_2(B)
          & v6_waybel_0(B,A)
          & v7_waybel_0(B) ) ) ).

fof(cc3_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( l1_waybel_0(B,A)
         => ( ( ~ v3_struct_0(B)
              & v7_waybel_0(B)
              & v8_waybel_0(B,A) )
           => ( ~ v3_struct_0(B)
              & v7_waybel_0(B)
              & v10_waybel_0(B,A) ) ) ) ) ).

fof(cc4_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( l1_waybel_0(B,A)
         => ( ( ~ v3_struct_0(B)
              & v7_waybel_0(B)
              & v9_waybel_0(B,A) )
           => ( ~ v3_struct_0(B)
              & v7_waybel_0(B)
              & v11_waybel_0(B,A) ) ) ) ) ).

fof(rc6_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & l1_orders_2(A) )
     => ? [B] :
          ( l1_waybel_0(B,A)
          & ~ v3_struct_0(B)
          & v6_waybel_0(B,A)
          & v7_waybel_0(B)
          & v8_waybel_0(B,A)
          & v9_waybel_0(B,A)
          & v10_waybel_0(B,A)
          & v11_waybel_0(B,A) ) ) ).

fof(fc7_waybel_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & l1_orders_2(A)
        & ~ v1_xboole_0(B)
        & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
     => ~ v1_xboole_0(k4_waybel_0(A,B)) ) ).

fof(fc8_waybel_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & l1_orders_2(A)
        & ~ v1_xboole_0(B)
        & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
     => ~ v1_xboole_0(k5_waybel_0(A,B)) ) ).

fof(fc9_waybel_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & l1_orders_2(A)
        & m1_subset_1(B,u1_struct_0(A)) )
     => ( ~ v1_xboole_0(k6_waybel_0(A,B))
        & v1_waybel_0(k6_waybel_0(A,B),A) ) ) ).

fof(fc10_waybel_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & l1_orders_2(A)
        & m1_subset_1(B,u1_struct_0(A)) )
     => ( ~ v1_xboole_0(k7_waybel_0(A,B))
        & v2_waybel_0(k7_waybel_0(A,B),A) ) ) ).

fof(rc7_waybel_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ? [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
          & v12_waybel_0(B,A)
          & v13_waybel_0(B,A) ) ) ).

fof(fc11_waybel_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v3_orders_2(A)
        & l1_orders_2(A)
        & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
     => v12_waybel_0(k4_waybel_0(A,B),A) ) ).

fof(fc12_waybel_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v3_orders_2(A)
        & l1_orders_2(A)
        & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
     => v13_waybel_0(k5_waybel_0(A,B),A) ) ).

fof(fc13_waybel_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v3_orders_2(A)
        & l1_orders_2(A)
        & m1_subset_1(B,u1_struct_0(A)) )
     => v12_waybel_0(k6_waybel_0(A,B),A) ) ).

fof(fc14_waybel_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v3_orders_2(A)
        & l1_orders_2(A)
        & m1_subset_1(B,u1_struct_0(A)) )
     => v13_waybel_0(k7_waybel_0(A,B),A) ) ).

fof(fc15_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ( ~ v1_xboole_0(k2_pre_topc(A))
        & v12_waybel_0(k2_pre_topc(A),A)
        & v13_waybel_0(k2_pre_topc(A),A) ) ) ).

fof(rc8_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ? [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
          & ~ v1_xboole_0(B)
          & v12_waybel_0(B,A)
          & v13_waybel_0(B,A) ) ) ).

fof(rc9_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => ? [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
          & ~ v1_xboole_0(B)
          & v1_waybel_0(B,A)
          & v12_waybel_0(B,A) ) ) ).

fof(rc10_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => ? [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
          & ~ v1_xboole_0(B)
          & v2_waybel_0(B,A)
          & v13_waybel_0(B,A) ) ) ).

fof(rc11_waybel_0,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v1_lattice3(A)
        & v2_lattice3(A)
        & l1_orders_2(A) )
     => ? [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
          & ~ v1_xboole_0(B)
          & v1_waybel_0(B,A)
          & v2_waybel_0(B,A)
          & v12_waybel_0(B,A)
          & v13_waybel_0(B,A) ) ) ).

fof(fc16_waybel_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & l1_orders_2(A)
        & v1_waybel_0(B,A)
        & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
     => ( v1_waybel_0(k4_waybel_0(A,B),A)
        & v12_waybel_0(k4_waybel_0(A,B),A) ) ) ).

fof(fc17_waybel_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & l1_orders_2(A)
        & v2_waybel_0(B,A)
        & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
     => ( v2_waybel_0(k5_waybel_0(A,B),A)
        & v13_waybel_0(k5_waybel_0(A,B),A) ) ) ).

fof(fc18_waybel_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v4_orders_2(A)
        & v1_yellow_0(A)
        & l1_orders_2(A)
        & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
     => ~ v1_xboole_0(k12_waybel_0(A,B)) ) ).

fof(fc19_waybel_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v4_orders_2(A)
        & v2_yellow_0(A)
        & l1_orders_2(A)
        & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
     => ~ v1_xboole_0(k13_waybel_0(A,B)) ) ).

fof(fc20_waybel_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A)
        & ~ v1_xboole_0(B)
        & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
     => ~ v1_xboole_0(k12_waybel_0(A,B)) ) ).

fof(fc21_waybel_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A)
        & ~ v1_xboole_0(B)
        & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
     => ~ v1_xboole_0(k13_waybel_0(A,B)) ) ).

fof(fc22_waybel_0,axiom,
    ! [A,B] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v1_lattice3(A)
        & l1_orders_2(A)
        & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
     => v1_waybel_0(k12_waybel_0(A,B),A) ) ).

fof(fc23_waybel_0,axiom,
    ! [A,B] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v2_lattice3(A)
        & l1_orders_2(A)
        & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
     => v2_waybel_0(k13_waybel_0(A,B),A) ) ).

fof(cc5_waybel_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( ( ~ v3_struct_0(A)
          & v2_orders_2(A)
          & v3_realset2(A) )
       => ( ~ v3_struct_0(A)
          & v2_orders_2(A)
          & v16_waybel_0(A) ) ) ) ).

fof(rc12_waybel_0,axiom,
    ? [A] :
      ( l1_orders_2(A)
      & ~ v3_struct_0(A)
      & v2_orders_2(A)
      & v3_orders_2(A)
      & v4_orders_2(A)
      & v16_waybel_0(A) ) ).

fof(fc24_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v16_waybel_0(A)
        & l1_orders_2(A) )
     => ( ~ v3_struct_0(k7_lattice3(A))
        & v1_orders_2(k7_lattice3(A))
        & v2_orders_2(k7_lattice3(A))
        & v3_orders_2(k7_lattice3(A))
        & v4_orders_2(k7_lattice3(A))
        & v16_waybel_0(k7_lattice3(A)) ) ) ).

fof(cc6_waybel_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A)
        & ~ v3_struct_0(B)
        & l1_orders_2(B) )
     => ! [C] :
          ( m1_relset_1(C,u1_struct_0(A),u1_struct_0(B))
         => ( ( v1_funct_1(C)
              & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
              & v17_waybel_0(C,A,B) )
           => ( v1_funct_1(C)
              & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
              & v19_waybel_0(C,A,B)
              & v21_waybel_0(C,A,B) ) ) ) ) ).

fof(cc7_waybel_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A)
        & ~ v3_struct_0(B)
        & l1_orders_2(B) )
     => ! [C] :
          ( m1_relset_1(C,u1_struct_0(A),u1_struct_0(B))
         => ( ( v1_funct_1(C)
              & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
              & v18_waybel_0(C,A,B) )
           => ( v1_funct_1(C)
              & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
              & v20_waybel_0(C,A,B)
              & v22_waybel_0(C,A,B) ) ) ) ) ).

fof(cc8_waybel_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A)
        & ~ v3_struct_0(B)
        & l1_orders_2(B) )
     => ! [C] :
          ( m1_relset_1(C,u1_struct_0(A),u1_struct_0(B))
         => ( ( v1_funct_1(C)
              & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
              & v23_waybel_0(C,A,B) )
           => ( v1_funct_1(C)
              & v2_funct_1(C)
              & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
              & v5_orders_3(C,A,B) ) ) ) ) ).

fof(cc9_waybel_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( ( v2_orders_2(A)
          & v1_lattice3(A)
          & v24_waybel_0(A) )
       => ( ~ v3_struct_0(A)
          & v2_orders_2(A)
          & v1_lattice3(A)
          & v2_yellow_0(A) ) ) ) ).

fof(cc10_waybel_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( ( ~ v3_struct_0(A)
          & v2_orders_2(A)
          & v3_lattice3(A) )
       => ( ~ v3_struct_0(A)
          & v2_orders_2(A)
          & v24_waybel_0(A)
          & v25_waybel_0(A) ) ) ) ).

fof(cc11_waybel_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( ( ~ v3_struct_0(A)
          & v2_orders_2(A)
          & v25_waybel_0(A) )
       => ( ~ v3_struct_0(A)
          & v2_orders_2(A)
          & v1_yellow_0(A) ) ) ) ).

fof(cc12_waybel_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( ( ~ v3_struct_0(A)
          & v2_orders_2(A)
          & v3_orders_2(A)
          & v4_orders_2(A)
          & v1_lattice3(A)
          & v1_yellow_0(A)
          & v24_waybel_0(A) )
       => ( ~ v3_struct_0(A)
          & v2_orders_2(A)
          & v3_orders_2(A)
          & v4_orders_2(A)
          & v1_lattice3(A)
          & v2_lattice3(A)
          & v3_lattice3(A)
          & v1_yellow_0(A)
          & v2_yellow_0(A)
          & v3_yellow_0(A) ) ) ) ).

fof(cc13_waybel_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( ( ~ v3_struct_0(A)
          & v2_orders_2(A)
          & v4_orders_2(A)
          & v25_waybel_0(A) )
       => ( ~ v3_struct_0(A)
          & v2_orders_2(A)
          & v4_orders_2(A)
          & v2_lattice3(A) ) ) ) ).

fof(cc14_waybel_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( ( ~ v3_struct_0(A)
          & v2_orders_2(A)
          & v4_orders_2(A)
          & v2_yellow_0(A)
          & v25_waybel_0(A) )
       => ( ~ v3_struct_0(A)
          & v2_orders_2(A)
          & v4_orders_2(A)
          & v1_lattice3(A)
          & v2_yellow_0(A) ) ) ) ).

fof(rc13_waybel_0,axiom,
    ? [A] :
      ( l1_orders_2(A)
      & ~ v3_struct_0(A)
      & v1_orders_2(A)
      & v2_orders_2(A)
      & v3_orders_2(A)
      & v4_orders_2(A)
      & v1_lattice3(A)
      & v2_lattice3(A)
      & v3_lattice3(A)
      & v1_yellow_0(A)
      & v2_yellow_0(A)
      & v3_yellow_0(A)
      & v24_waybel_0(A)
      & v25_waybel_0(A) ) ).

fof(d1_waybel_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ( v1_waybel_0(B,A)
          <=> ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => ~ ( r2_hidden(C,B)
                        & r2_hidden(D,B)
                        & ! [E] :
                            ( m1_subset_1(E,u1_struct_0(A))
                           => ~ ( r2_hidden(E,B)
                                & r1_orders_2(A,C,E)
                                & r1_orders_2(A,D,E) ) ) ) ) ) ) ) ) ).

fof(d2_waybel_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ( v2_waybel_0(B,A)
          <=> ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => ~ ( r2_hidden(C,B)
                        & r2_hidden(D,B)
                        & ! [E] :
                            ( m1_subset_1(E,u1_struct_0(A))
                           => ~ ( r2_hidden(E,B)
                                & r1_orders_2(A,E,C)
                                & r1_orders_2(A,E,D) ) ) ) ) ) ) ) ) ).

fof(t1_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ( ( ~ v1_xboole_0(B)
              & v1_waybel_0(B,A) )
          <=> ! [C] :
                ( ( v1_finset_1(C)
                  & m1_subset_1(C,k1_zfmisc_1(B)) )
               => ? [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                    & r2_hidden(D,B)
                    & r2_lattice3(A,C,D) ) ) ) ) ) ).

fof(t2_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ( ( ~ v1_xboole_0(B)
              & v2_waybel_0(B,A) )
          <=> ! [C] :
                ( ( v1_finset_1(C)
                  & m1_subset_1(C,k1_zfmisc_1(B)) )
               => ? [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                    & r2_hidden(D,B)
                    & r1_lattice3(A,C,D) ) ) ) ) ) ).

fof(t3_waybel_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( l1_orders_2(B)
         => ( g1_orders_2(u1_struct_0(A),u1_orders_2(A)) = g1_orders_2(u1_struct_0(B),u1_orders_2(B))
           => ! [C] :
                ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
               => ! [D] :
                    ( m1_subset_1(D,k1_zfmisc_1(u1_struct_0(B)))
                   => ( ( C = D
                        & v1_waybel_0(C,A) )
                     => v1_waybel_0(D,B) ) ) ) ) ) ) ).

fof(t4_waybel_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( l1_orders_2(B)
         => ( g1_orders_2(u1_struct_0(A),u1_orders_2(A)) = g1_orders_2(u1_struct_0(B),u1_orders_2(B))
           => ! [C] :
                ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
               => ! [D] :
                    ( m1_subset_1(D,k1_zfmisc_1(u1_struct_0(B)))
                   => ( ( C = D
                        & v2_waybel_0(C,A) )
                     => v2_waybel_0(D,B) ) ) ) ) ) ) ).

fof(t5_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ( v1_waybel_0(k1_struct_0(A,B),A)
            & v2_waybel_0(k1_struct_0(A,B),A) ) ) ) ).

fof(d3_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_yellow_0(B,A)
         => ( v3_waybel_0(B,A)
          <=> ! [C] :
                ( ( v2_waybel_0(C,B)
                  & m1_subset_1(C,k1_zfmisc_1(u1_struct_0(B))) )
               => ( r2_yellow_0(A,C)
                 => ( C = k1_xboole_0
                    | r2_hidden(k2_yellow_0(A,C),u1_struct_0(B)) ) ) ) ) ) ) ).

fof(d4_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_yellow_0(B,A)
         => ( v4_waybel_0(B,A)
          <=> ! [C] :
                ( ( v1_waybel_0(C,B)
                  & m1_subset_1(C,k1_zfmisc_1(u1_struct_0(B))) )
               => ( r1_yellow_0(A,C)
                 => ( C = k1_xboole_0
                    | r2_hidden(k1_yellow_0(A,C),u1_struct_0(B)) ) ) ) ) ) ) ).

fof(t6_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v4_yellow_0(B,A)
            & v3_waybel_0(B,A)
            & m1_yellow_0(B,A) )
         => ! [C] :
              ( ( v2_waybel_0(C,B)
                & m1_subset_1(C,k1_zfmisc_1(u1_struct_0(B))) )
             => ( r2_yellow_0(A,C)
               => ( C = k1_xboole_0
                  | ( r2_yellow_0(B,C)
                    & k2_yellow_0(B,C) = k2_yellow_0(A,C) ) ) ) ) ) ) ).

fof(t7_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v4_yellow_0(B,A)
            & v4_waybel_0(B,A)
            & m1_yellow_0(B,A) )
         => ! [C] :
              ( ( v1_waybel_0(C,B)
                & m1_subset_1(C,k1_zfmisc_1(u1_struct_0(B))) )
             => ( r1_yellow_0(A,C)
               => ( C = k1_xboole_0
                  | ( r1_yellow_0(B,C)
                    & k1_yellow_0(B,C) = k1_yellow_0(A,C) ) ) ) ) ) ) ).

fof(d5_waybel_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( l1_orders_2(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
                & m2_relset_1(C,u1_struct_0(A),u1_struct_0(B)) )
             => ( v5_waybel_0(C,A,B)
              <=> ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => ! [E] :
                        ( m1_subset_1(E,u1_struct_0(A))
                       => ( r1_orders_2(A,D,E)
                         => ! [F] :
                              ( m1_subset_1(F,u1_struct_0(B))
                             => ! [G] :
                                  ( m1_subset_1(G,u1_struct_0(B))
                                 => ( ( F = k1_funct_1(C,D)
                                      & G = k1_funct_1(C,E) )
                                   => r1_orders_2(B,G,F) ) ) ) ) ) ) ) ) ) ) ).

fof(d6_waybel_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( v7_waybel_0(A)
      <=> v1_waybel_0(k2_pre_topc(A),A) ) ) ).

fof(d7_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_struct_0(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_waybel_0(B,A) )
         => k2_waybel_0(A,B) = u1_waybel_0(A,B) ) ) ).

fof(d8_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_struct_0(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_waybel_0(B,A) )
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(B))
             => k3_waybel_0(A,B,C) = k1_waybel_0(B,A,u1_waybel_0(A,B),C) ) ) ) ).

fof(d9_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_waybel_0(B,A) )
         => ( v8_waybel_0(B,A)
          <=> v5_orders_3(k2_waybel_0(A,B),B,A) ) ) ) ).

fof(d10_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_waybel_0(B,A) )
         => ( v9_waybel_0(B,A)
          <=> v5_waybel_0(k2_waybel_0(A,B),B,A) ) ) ) ).

fof(d11_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_struct_0(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_waybel_0(B,A) )
         => ! [C] :
              ( r1_waybel_0(A,B,C)
            <=> ? [D] :
                  ( m1_subset_1(D,u1_struct_0(B))
                  & ! [E] :
                      ( m1_subset_1(E,u1_struct_0(B))
                     => ( r1_orders_2(B,D,E)
                       => r2_hidden(k3_waybel_0(A,B,E),C) ) ) ) ) ) ) ).

fof(d12_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_struct_0(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_waybel_0(B,A) )
         => ! [C] :
              ( r2_waybel_0(A,B,C)
            <=> ! [D] :
                  ( m1_subset_1(D,u1_struct_0(B))
                 => ? [E] :
                      ( m1_subset_1(E,u1_struct_0(B))
                      & r1_orders_2(B,D,E)
                      & r2_hidden(k3_waybel_0(A,B,E),C) ) ) ) ) ) ).

fof(t8_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_struct_0(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_waybel_0(B,A) )
         => ! [C,D] :
              ( r1_tarski(C,D)
             => ( ( r1_waybel_0(A,B,C)
                 => r1_waybel_0(A,B,D) )
                & ( r2_waybel_0(A,B,C)
                 => r2_waybel_0(A,B,D) ) ) ) ) ) ).

fof(t9_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_struct_0(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_waybel_0(B,A) )
         => ! [C] :
              ( r1_waybel_0(A,B,C)
            <=> ~ r2_waybel_0(A,B,k4_xboole_0(u1_struct_0(A),C)) ) ) ) ).

fof(t10_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_struct_0(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_waybel_0(B,A) )
         => ! [C] :
              ( r2_waybel_0(A,B,C)
            <=> ~ r1_waybel_0(A,B,k4_xboole_0(u1_struct_0(A),C)) ) ) ) ).

fof(t11_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_waybel_0(B,A) )
         => ( v10_waybel_0(B,A)
          <=> ! [C] :
                ( m1_subset_1(C,u1_struct_0(B))
               => ? [D] :
                    ( m1_subset_1(D,u1_struct_0(B))
                    & ! [E] :
                        ( m1_subset_1(E,u1_struct_0(B))
                       => ( r1_orders_2(B,D,E)
                         => r1_orders_2(A,k3_waybel_0(A,B,C),k3_waybel_0(A,B,E)) ) ) ) ) ) ) ) ).

fof(t12_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_waybel_0(B,A) )
         => ( v11_waybel_0(B,A)
          <=> ! [C] :
                ( m1_subset_1(C,u1_struct_0(B))
               => ? [D] :
                    ( m1_subset_1(D,u1_struct_0(B))
                    & ! [E] :
                        ( m1_subset_1(E,u1_struct_0(B))
                       => ( r1_orders_2(B,D,E)
                         => r1_orders_2(A,k3_waybel_0(A,B,E),k3_waybel_0(A,B,C)) ) ) ) ) ) ) ) ).

fof(d15_waybel_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
             => ( C = k4_waybel_0(A,B)
              <=> ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => ( r2_hidden(D,C)
                    <=> ? [E] :
                          ( m1_subset_1(E,u1_struct_0(A))
                          & r1_orders_2(A,D,E)
                          & r2_hidden(E,B) ) ) ) ) ) ) ) ).

fof(d16_waybel_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
             => ( C = k5_waybel_0(A,B)
              <=> ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => ( r2_hidden(D,C)
                    <=> ? [E] :
                          ( m1_subset_1(E,u1_struct_0(A))
                          & r1_orders_2(A,E,D)
                          & r2_hidden(E,B) ) ) ) ) ) ) ) ).

fof(t13_waybel_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( l1_orders_2(B)
         => ( g1_orders_2(u1_struct_0(A),u1_orders_2(A)) = g1_orders_2(u1_struct_0(B),u1_orders_2(B))
           => ! [C] :
                ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
               => ! [D] :
                    ( m1_subset_1(D,k1_zfmisc_1(u1_struct_0(B)))
                   => ( C = D
                     => ( k4_waybel_0(A,C) = k4_waybel_0(B,D)
                        & k5_waybel_0(A,C) = k5_waybel_0(B,D) ) ) ) ) ) ) ) ).

fof(t16_waybel_0,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ( r1_tarski(B,k4_waybel_0(A,B))
            & r1_tarski(B,k5_waybel_0(A,B)) ) ) ) ).

fof(d17_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => k6_waybel_0(A,B) = k4_waybel_0(A,k1_struct_0(A,B)) ) ) ).

fof(d18_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => k7_waybel_0(A,B) = k5_waybel_0(A,k1_struct_0(A,B)) ) ) ).

fof(t17_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( r2_hidden(C,k6_waybel_0(A,B))
              <=> r1_orders_2(A,C,B) ) ) ) ) ).

fof(t18_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( r2_hidden(C,k7_waybel_0(A,B))
              <=> r1_orders_2(A,B,C) ) ) ) ) ).

fof(t19_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( k6_waybel_0(A,B) = k6_waybel_0(A,C)
               => B = C ) ) ) ) ).

fof(t20_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( k7_waybel_0(A,B) = k7_waybel_0(A,C)
               => B = C ) ) ) ) ).

fof(t21_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( r1_orders_2(A,B,C)
               => r1_tarski(k6_waybel_0(A,B),k6_waybel_0(A,C)) ) ) ) ) ).

fof(t22_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( r1_orders_2(A,B,C)
               => r1_tarski(k7_waybel_0(A,C),k7_waybel_0(A,B)) ) ) ) ) ).

fof(d19_waybel_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ( v12_waybel_0(B,A)
          <=> ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => ( ( r2_hidden(C,B)
                        & r1_orders_2(A,D,C) )
                     => r2_hidden(D,B) ) ) ) ) ) ) ).

fof(d20_waybel_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ( v13_waybel_0(B,A)
          <=> ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => ( ( r2_hidden(C,B)
                        & r1_orders_2(A,C,D) )
                     => r2_hidden(D,B) ) ) ) ) ) ) ).

fof(t23_waybel_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ( v12_waybel_0(B,A)
          <=> r1_tarski(k4_waybel_0(A,B),B) ) ) ) ).

fof(t24_waybel_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ( v13_waybel_0(B,A)
          <=> r1_tarski(k5_waybel_0(A,B),B) ) ) ) ).

fof(t25_waybel_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( l1_orders_2(B)
         => ( g1_orders_2(u1_struct_0(A),u1_orders_2(A)) = g1_orders_2(u1_struct_0(B),u1_orders_2(B))
           => ! [C] :
                ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
               => ! [D] :
                    ( m1_subset_1(D,k1_zfmisc_1(u1_struct_0(B)))
                   => ( C = D
                     => ( ( v12_waybel_0(C,A)
                         => v12_waybel_0(D,B) )
                        & ( v13_waybel_0(C,A)
                         => v13_waybel_0(D,B) ) ) ) ) ) ) ) ) ).

fof(t26_waybel_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(u1_struct_0(A))))
         => ( ! [C] :
                ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
               => ( r2_hidden(C,B)
                 => v12_waybel_0(C,A) ) )
           => ( v12_waybel_0(k5_setfam_1(u1_struct_0(A),B),A)
              & m1_subset_1(k5_setfam_1(u1_struct_0(A),B),k1_zfmisc_1(u1_struct_0(A))) ) ) ) ) ).

fof(t27_waybel_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
             => ( ( v12_waybel_0(B,A)
                  & v12_waybel_0(C,A) )
               => ( v12_waybel_0(k5_subset_1(u1_struct_0(A),B,C),A)
                  & v12_waybel_0(k4_subset_1(u1_struct_0(A),B,C),A) ) ) ) ) ) ).

fof(t28_waybel_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(u1_struct_0(A))))
         => ( ! [C] :
                ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
               => ( r2_hidden(C,B)
                 => v13_waybel_0(C,A) ) )
           => ( v13_waybel_0(k5_setfam_1(u1_struct_0(A),B),A)
              & m1_subset_1(k5_setfam_1(u1_struct_0(A),B),k1_zfmisc_1(u1_struct_0(A))) ) ) ) ) ).

fof(t29_waybel_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
             => ( ( v13_waybel_0(B,A)
                  & v13_waybel_0(C,A) )
               => ( v13_waybel_0(k5_subset_1(u1_struct_0(A),B,C),A)
                  & v13_waybel_0(k4_subset_1(u1_struct_0(A),B,C),A) ) ) ) ) ) ).

fof(t30_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ( v1_waybel_0(B,A)
          <=> v1_waybel_0(k4_waybel_0(A,B),A) ) ) ) ).

fof(t31_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( r2_lattice3(A,B,C)
              <=> r2_lattice3(A,k4_waybel_0(A,B),C) ) ) ) ) ).

fof(t32_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ( r1_yellow_0(A,B)
          <=> r1_yellow_0(A,k4_waybel_0(A,B)) ) ) ) ).

fof(t33_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ( r1_yellow_0(A,B)
           => k1_yellow_0(A,B) = k1_yellow_0(A,k4_waybel_0(A,B)) ) ) ) ).

fof(t34_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ( r1_yellow_0(A,k6_waybel_0(A,B))
            & k1_yellow_0(A,k6_waybel_0(A,B)) = B ) ) ) ).

fof(t35_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ( v2_waybel_0(B,A)
          <=> v2_waybel_0(k5_waybel_0(A,B),A) ) ) ) ).

fof(t36_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(A))
             => ( r1_lattice3(A,B,C)
              <=> r1_lattice3(A,k5_waybel_0(A,B),C) ) ) ) ) ).

fof(t37_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ( r2_yellow_0(A,B)
          <=> r2_yellow_0(A,k5_waybel_0(A,B)) ) ) ) ).

fof(t38_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ( r2_yellow_0(A,B)
           => k2_yellow_0(A,B) = k2_yellow_0(A,k5_waybel_0(A,B)) ) ) ) ).

fof(t39_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ( r2_yellow_0(A,k7_waybel_0(A,B))
            & k2_yellow_0(A,k7_waybel_0(A,B)) = B ) ) ) ).

fof(t40_waybel_0,axiom,
    ! [A] :
      ( ( v4_orders_2(A)
        & v1_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( v12_waybel_0(B,A)
            & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
         => ( v1_waybel_0(B,A)
          <=> ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => ( ( r2_hidden(C,B)
                        & r2_hidden(D,B) )
                     => r2_hidden(k13_lattice3(A,C,D),B) ) ) ) ) ) ) ).

fof(t41_waybel_0,axiom,
    ! [A] :
      ( ( v4_orders_2(A)
        & v2_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( v13_waybel_0(B,A)
            & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
         => ( v2_waybel_0(B,A)
          <=> ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => ( ( r2_hidden(C,B)
                        & r2_hidden(D,B) )
                     => r2_hidden(k12_lattice3(A,C,D),B) ) ) ) ) ) ) ).

fof(t42_waybel_0,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v1_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v1_xboole_0(B)
            & v12_waybel_0(B,A)
            & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
         => ( v1_waybel_0(B,A)
          <=> ! [C] :
                ( ( v1_finset_1(C)
                  & m1_subset_1(C,k1_zfmisc_1(B)) )
               => ( C != k1_xboole_0
                 => r2_hidden(k1_yellow_0(A,C),B) ) ) ) ) ) ).

fof(t43_waybel_0,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v2_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v1_xboole_0(B)
            & v13_waybel_0(B,A)
            & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
         => ( v2_waybel_0(B,A)
          <=> ! [C] :
                ( ( v1_finset_1(C)
                  & m1_subset_1(C,k1_zfmisc_1(B)) )
               => ( C != k1_xboole_0
                 => r2_hidden(k2_yellow_0(A,C),B) ) ) ) ) ) ).

fof(t44_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ( ( v1_lattice3(A)
          | v2_lattice3(A) )
       => ! [B] :
            ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
           => ! [C] :
                ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
               => ( ( v12_waybel_0(B,A)
                    & v1_waybel_0(B,A)
                    & v12_waybel_0(C,A)
                    & v1_waybel_0(C,A) )
                 => v1_waybel_0(k5_subset_1(u1_struct_0(A),B,C),A) ) ) ) ) ) ).

fof(t45_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ( ( v1_lattice3(A)
          | v2_lattice3(A) )
       => ! [B] :
            ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
           => ! [C] :
                ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
               => ( ( v13_waybel_0(B,A)
                    & v2_waybel_0(B,A)
                    & v13_waybel_0(C,A)
                    & v2_waybel_0(C,A) )
                 => v2_waybel_0(k5_subset_1(u1_struct_0(A),B,C),A) ) ) ) ) ) ).

fof(t46_waybel_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(u1_struct_0(A))))
         => ( ( ! [C] :
                  ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
                 => ( r2_hidden(C,B)
                   => v1_waybel_0(C,A) ) )
              & ! [C] :
                  ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
                 => ! [D] :
                      ( m1_subset_1(D,k1_zfmisc_1(u1_struct_0(A)))
                     => ~ ( r2_hidden(C,B)
                          & r2_hidden(D,B)
                          & ! [E] :
                              ( m1_subset_1(E,k1_zfmisc_1(u1_struct_0(A)))
                             => ~ ( r2_hidden(E,B)
                                  & r1_tarski(k4_subset_1(u1_struct_0(A),C,D),E) ) ) ) ) ) )
           => ! [C] :
                ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
               => ( C = k5_setfam_1(u1_struct_0(A),B)
                 => v1_waybel_0(C,A) ) ) ) ) ) ).

fof(t47_waybel_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(u1_struct_0(A))))
         => ( ( ! [C] :
                  ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
                 => ( r2_hidden(C,B)
                   => v2_waybel_0(C,A) ) )
              & ! [C] :
                  ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
                 => ! [D] :
                      ( m1_subset_1(D,k1_zfmisc_1(u1_struct_0(A)))
                     => ~ ( r2_hidden(C,B)
                          & r2_hidden(D,B)
                          & ! [E] :
                              ( m1_subset_1(E,k1_zfmisc_1(u1_struct_0(A)))
                             => ~ ( r2_hidden(E,B)
                                  & r1_tarski(k4_subset_1(u1_struct_0(A),C,D),E) ) ) ) ) ) )
           => ! [C] :
                ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
               => ( C = k5_setfam_1(u1_struct_0(A),B)
                 => v2_waybel_0(C,A) ) ) ) ) ) ).

fof(d21_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v1_xboole_0(B)
            & v1_waybel_0(B,A)
            & v12_waybel_0(B,A)
            & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
         => ( v14_waybel_0(B,A)
          <=> ? [C] :
                ( m1_subset_1(C,u1_struct_0(A))
                & r2_hidden(C,B)
                & r2_lattice3(A,B,C) ) ) ) ) ).

fof(d22_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v1_xboole_0(B)
            & v2_waybel_0(B,A)
            & v13_waybel_0(B,A)
            & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
         => ( v15_waybel_0(B,A)
          <=> ? [C] :
                ( m1_subset_1(C,u1_struct_0(A))
                & r2_hidden(C,B)
                & r1_lattice3(A,B,C) ) ) ) ) ).

fof(t48_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v1_xboole_0(B)
            & v1_waybel_0(B,A)
            & v12_waybel_0(B,A)
            & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
         => ( v14_waybel_0(B,A)
          <=> ? [C] :
                ( m1_subset_1(C,u1_struct_0(A))
                & B = k6_waybel_0(A,C) ) ) ) ) ).

fof(t49_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v1_xboole_0(B)
            & v2_waybel_0(B,A)
            & v13_waybel_0(B,A)
            & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
         => ( v15_waybel_0(B,A)
          <=> ? [C] :
                ( m1_subset_1(C,u1_struct_0(A))
                & B = k7_waybel_0(A,C) ) ) ) ) ).

fof(d25_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => k10_waybel_0(A) = k2_xboole_0(k8_waybel_0(A),k1_tarski(k1_xboole_0)) ) ).

fof(d26_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => k11_waybel_0(A) = k2_xboole_0(k9_waybel_0(A),k1_tarski(k1_xboole_0)) ) ).

fof(t50_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ( r1_tarski(B,k12_waybel_0(A,B))
            & r1_tarski(B,k13_waybel_0(A,B)) ) ) ) ).

fof(t51_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
             => ( ( ! [D] :
                      ( ( v1_finset_1(D)
                        & m1_subset_1(D,k1_zfmisc_1(B)) )
                     => ( D != k1_xboole_0
                       => r1_yellow_0(A,D) ) )
                  & ! [D] :
                      ( m1_subset_1(D,u1_struct_0(A))
                     => ~ ( r2_hidden(D,C)
                          & ! [E] :
                              ( ( v1_finset_1(E)
                                & m1_subset_1(E,k1_zfmisc_1(B)) )
                             => ~ ( r1_yellow_0(A,E)
                                  & D = k1_yellow_0(A,E) ) ) ) )
                  & ! [D] :
                      ( ( v1_finset_1(D)
                        & m1_subset_1(D,k1_zfmisc_1(B)) )
                     => ( D != k1_xboole_0
                       => r2_hidden(k1_yellow_0(A,D),C) ) ) )
               => v1_waybel_0(C,A) ) ) ) ) ).

fof(t52_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
             => ( ( ! [D] :
                      ( ( v1_finset_1(D)
                        & m1_subset_1(D,k1_zfmisc_1(B)) )
                     => ( D != k1_xboole_0
                       => r1_yellow_0(A,D) ) )
                  & ! [D] :
                      ( m1_subset_1(D,u1_struct_0(A))
                     => ~ ( r2_hidden(D,C)
                          & ! [E] :
                              ( ( v1_finset_1(E)
                                & m1_subset_1(E,k1_zfmisc_1(B)) )
                             => ~ ( r1_yellow_0(A,E)
                                  & D = k1_yellow_0(A,E) ) ) ) )
                  & ! [D] :
                      ( ( v1_finset_1(D)
                        & m1_subset_1(D,k1_zfmisc_1(B)) )
                     => ( D != k1_xboole_0
                       => r2_hidden(k1_yellow_0(A,D),C) ) ) )
               => ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => ( r2_lattice3(A,B,D)
                    <=> r2_lattice3(A,C,D) ) ) ) ) ) ) ).

fof(t53_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
             => ( ( ! [D] :
                      ( ( v1_finset_1(D)
                        & m1_subset_1(D,k1_zfmisc_1(B)) )
                     => ( D != k1_xboole_0
                       => r1_yellow_0(A,D) ) )
                  & ! [D] :
                      ( m1_subset_1(D,u1_struct_0(A))
                     => ~ ( r2_hidden(D,C)
                          & ! [E] :
                              ( ( v1_finset_1(E)
                                & m1_subset_1(E,k1_zfmisc_1(B)) )
                             => ~ ( r1_yellow_0(A,E)
                                  & D = k1_yellow_0(A,E) ) ) ) )
                  & ! [D] :
                      ( ( v1_finset_1(D)
                        & m1_subset_1(D,k1_zfmisc_1(B)) )
                     => ( D != k1_xboole_0
                       => r2_hidden(k1_yellow_0(A,D),C) ) ) )
               => ( r1_yellow_0(A,B)
                <=> r1_yellow_0(A,C) ) ) ) ) ) ).

fof(t54_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
             => ( ( ! [D] :
                      ( ( v1_finset_1(D)
                        & m1_subset_1(D,k1_zfmisc_1(B)) )
                     => ( D != k1_xboole_0
                       => r1_yellow_0(A,D) ) )
                  & ! [D] :
                      ( m1_subset_1(D,u1_struct_0(A))
                     => ~ ( r2_hidden(D,C)
                          & ! [E] :
                              ( ( v1_finset_1(E)
                                & m1_subset_1(E,k1_zfmisc_1(B)) )
                             => ~ ( r1_yellow_0(A,E)
                                  & D = k1_yellow_0(A,E) ) ) ) )
                  & ! [D] :
                      ( ( v1_finset_1(D)
                        & m1_subset_1(D,k1_zfmisc_1(B)) )
                     => ( D != k1_xboole_0
                       => r2_hidden(k1_yellow_0(A,D),C) ) )
                  & r1_yellow_0(A,B) )
               => k1_yellow_0(A,C) = k1_yellow_0(A,B) ) ) ) ) ).

fof(t55_waybel_0,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v1_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ( ( r1_yellow_0(A,B)
              | v3_lattice3(A) )
           => k1_yellow_0(A,B) = k1_yellow_0(A,k12_waybel_0(A,B)) ) ) ) ).

fof(t56_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
             => ( ( ! [D] :
                      ( ( v1_finset_1(D)
                        & m1_subset_1(D,k1_zfmisc_1(B)) )
                     => ( D != k1_xboole_0
                       => r2_yellow_0(A,D) ) )
                  & ! [D] :
                      ( m1_subset_1(D,u1_struct_0(A))
                     => ~ ( r2_hidden(D,C)
                          & ! [E] :
                              ( ( v1_finset_1(E)
                                & m1_subset_1(E,k1_zfmisc_1(B)) )
                             => ~ ( r2_yellow_0(A,E)
                                  & D = k2_yellow_0(A,E) ) ) ) )
                  & ! [D] :
                      ( ( v1_finset_1(D)
                        & m1_subset_1(D,k1_zfmisc_1(B)) )
                     => ( D != k1_xboole_0
                       => r2_hidden(k2_yellow_0(A,D),C) ) ) )
               => v2_waybel_0(C,A) ) ) ) ) ).

fof(t57_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
             => ( ( ! [D] :
                      ( ( v1_finset_1(D)
                        & m1_subset_1(D,k1_zfmisc_1(B)) )
                     => ( D != k1_xboole_0
                       => r2_yellow_0(A,D) ) )
                  & ! [D] :
                      ( m1_subset_1(D,u1_struct_0(A))
                     => ~ ( r2_hidden(D,C)
                          & ! [E] :
                              ( ( v1_finset_1(E)
                                & m1_subset_1(E,k1_zfmisc_1(B)) )
                             => ~ ( r2_yellow_0(A,E)
                                  & D = k2_yellow_0(A,E) ) ) ) )
                  & ! [D] :
                      ( ( v1_finset_1(D)
                        & m1_subset_1(D,k1_zfmisc_1(B)) )
                     => ( D != k1_xboole_0
                       => r2_hidden(k2_yellow_0(A,D),C) ) ) )
               => ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => ( r1_lattice3(A,B,D)
                    <=> r1_lattice3(A,C,D) ) ) ) ) ) ) ).

fof(t58_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
             => ( ( ! [D] :
                      ( ( v1_finset_1(D)
                        & m1_subset_1(D,k1_zfmisc_1(B)) )
                     => ( D != k1_xboole_0
                       => r2_yellow_0(A,D) ) )
                  & ! [D] :
                      ( m1_subset_1(D,u1_struct_0(A))
                     => ~ ( r2_hidden(D,C)
                          & ! [E] :
                              ( ( v1_finset_1(E)
                                & m1_subset_1(E,k1_zfmisc_1(B)) )
                             => ~ ( r2_yellow_0(A,E)
                                  & D = k2_yellow_0(A,E) ) ) ) )
                  & ! [D] :
                      ( ( v1_finset_1(D)
                        & m1_subset_1(D,k1_zfmisc_1(B)) )
                     => ( D != k1_xboole_0
                       => r2_hidden(k2_yellow_0(A,D),C) ) ) )
               => ( r2_yellow_0(A,B)
                <=> r2_yellow_0(A,C) ) ) ) ) ) ).

fof(t59_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
             => ( ( ! [D] :
                      ( ( v1_finset_1(D)
                        & m1_subset_1(D,k1_zfmisc_1(B)) )
                     => ( D != k1_xboole_0
                       => r2_yellow_0(A,D) ) )
                  & ! [D] :
                      ( m1_subset_1(D,u1_struct_0(A))
                     => ~ ( r2_hidden(D,C)
                          & ! [E] :
                              ( ( v1_finset_1(E)
                                & m1_subset_1(E,k1_zfmisc_1(B)) )
                             => ~ ( r2_yellow_0(A,E)
                                  & D = k2_yellow_0(A,E) ) ) ) )
                  & ! [D] :
                      ( ( v1_finset_1(D)
                        & m1_subset_1(D,k1_zfmisc_1(B)) )
                     => ( D != k1_xboole_0
                       => r2_hidden(k2_yellow_0(A,D),C) ) )
                  & r2_yellow_0(A,B) )
               => k2_yellow_0(A,C) = k2_yellow_0(A,B) ) ) ) ) ).

fof(t60_waybel_0,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v2_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ( ( r2_yellow_0(A,B)
              | v3_lattice3(A) )
           => k2_yellow_0(A,B) = k2_yellow_0(A,k13_waybel_0(A,B)) ) ) ) ).

fof(t61_waybel_0,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v1_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ( r1_tarski(B,k4_waybel_0(A,k12_waybel_0(A,B)))
            & ! [C] :
                ( ( ~ v1_xboole_0(C)
                  & v1_waybel_0(C,A)
                  & v12_waybel_0(C,A)
                  & m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A))) )
               => ( r1_tarski(B,C)
                 => r1_tarski(k4_waybel_0(A,k12_waybel_0(A,B)),C) ) ) ) ) ) ).

fof(t62_waybel_0,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v2_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => ( r1_tarski(B,k5_waybel_0(A,k13_waybel_0(A,B)))
            & ! [C] :
                ( ( ~ v1_xboole_0(C)
                  & v2_waybel_0(C,A)
                  & v13_waybel_0(C,A)
                  & m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A))) )
               => ( r1_tarski(B,C)
                 => r1_tarski(k5_waybel_0(A,k13_waybel_0(A,B)),C) ) ) ) ) ) ).

fof(d29_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ( v16_waybel_0(A)
      <=> ! [B] :
            ( m1_subset_1(B,u1_struct_0(A))
           => ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ( r1_orders_2(A,B,C)
                  | r1_orders_2(A,C,B) ) ) ) ) ) ).

fof(t63_waybel_0,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v2_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v1_xboole_0(B)
            & v13_waybel_0(B,A)
            & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
         => ( ( ~ v1_xboole_0(B)
              & v2_waybel_0(B,A)
              & v13_waybel_0(B,A)
              & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
          <=> v5_yellow_0(k5_yellow_0(A,B),A) ) ) ) ).

fof(t64_waybel_0,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v1_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v1_xboole_0(B)
            & v12_waybel_0(B,A)
            & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
         => ( ( ~ v1_xboole_0(B)
              & v1_waybel_0(B,A)
              & v12_waybel_0(B,A)
              & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
          <=> v6_yellow_0(k5_yellow_0(A,B),A) ) ) ) ).

fof(d30_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_orders_2(B) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
                & m2_relset_1(C,u1_struct_0(A),u1_struct_0(B)) )
             => ! [D] :
                  ( m1_subset_1(D,k1_zfmisc_1(u1_struct_0(A)))
                 => ( r3_waybel_0(A,B,C,D)
                  <=> ( r2_yellow_0(A,D)
                     => ( r2_yellow_0(B,k4_pre_topc(A,B,C,D))
                        & k2_yellow_0(B,k4_pre_topc(A,B,C,D)) = k1_waybel_0(A,B,C,k2_yellow_0(A,D)) ) ) ) ) ) ) ) ).

fof(d31_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_orders_2(B) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
                & m2_relset_1(C,u1_struct_0(A),u1_struct_0(B)) )
             => ! [D] :
                  ( m1_subset_1(D,k1_zfmisc_1(u1_struct_0(A)))
                 => ( r4_waybel_0(A,B,C,D)
                  <=> ( r1_yellow_0(A,D)
                     => ( r1_yellow_0(B,k4_pre_topc(A,B,C,D))
                        & k1_yellow_0(B,k4_pre_topc(A,B,C,D)) = k1_waybel_0(A,B,C,k1_yellow_0(A,D)) ) ) ) ) ) ) ) ).

fof(t65_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_orders_2(B) )
         => ! [C] :
              ( ( ~ v3_struct_0(C)
                & l1_orders_2(C) )
             => ! [D] :
                  ( ( ~ v3_struct_0(D)
                    & l1_orders_2(D) )
                 => ( ( g1_orders_2(u1_struct_0(A),u1_orders_2(A)) = g1_orders_2(u1_struct_0(C),u1_orders_2(C))
                      & g1_orders_2(u1_struct_0(B),u1_orders_2(B)) = g1_orders_2(u1_struct_0(D),u1_orders_2(D)) )
                   => ! [E] :
                        ( ( v1_funct_1(E)
                          & v1_funct_2(E,u1_struct_0(A),u1_struct_0(B))
                          & m2_relset_1(E,u1_struct_0(A),u1_struct_0(B)) )
                       => ! [F] :
                            ( ( v1_funct_1(F)
                              & v1_funct_2(F,u1_struct_0(C),u1_struct_0(D))
                              & m2_relset_1(F,u1_struct_0(C),u1_struct_0(D)) )
                           => ( E = F
                             => ! [G] :
                                  ( m1_subset_1(G,k1_zfmisc_1(u1_struct_0(A)))
                                 => ! [H] :
                                      ( m1_subset_1(H,k1_zfmisc_1(u1_struct_0(C)))
                                     => ( G = H
                                       => ( ( r4_waybel_0(A,B,E,G)
                                           => r4_waybel_0(C,D,F,H) )
                                          & ( r3_waybel_0(A,B,E,G)
                                           => r3_waybel_0(C,D,F,H) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

fof(d32_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_orders_2(B) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
                & m2_relset_1(C,u1_struct_0(A),u1_struct_0(B)) )
             => ( v17_waybel_0(C,A,B)
              <=> ! [D] :
                    ( m1_subset_1(D,k1_zfmisc_1(u1_struct_0(A)))
                   => r3_waybel_0(A,B,C,D) ) ) ) ) ) ).

fof(d33_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_orders_2(B) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
                & m2_relset_1(C,u1_struct_0(A),u1_struct_0(B)) )
             => ( v18_waybel_0(C,A,B)
              <=> ! [D] :
                    ( m1_subset_1(D,k1_zfmisc_1(u1_struct_0(A)))
                   => r4_waybel_0(A,B,C,D) ) ) ) ) ) ).

fof(d34_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_orders_2(B) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
                & m2_relset_1(C,u1_struct_0(A),u1_struct_0(B)) )
             => ( v19_waybel_0(C,A,B)
              <=> ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => ! [E] :
                        ( m1_subset_1(E,u1_struct_0(A))
                       => r3_waybel_0(A,B,C,k2_struct_0(A,D,E)) ) ) ) ) ) ) ).

fof(d35_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_orders_2(B) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
                & m2_relset_1(C,u1_struct_0(A),u1_struct_0(B)) )
             => ( v20_waybel_0(C,A,B)
              <=> ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => ! [E] :
                        ( m1_subset_1(E,u1_struct_0(A))
                       => r4_waybel_0(A,B,C,k2_struct_0(A,D,E)) ) ) ) ) ) ) ).

fof(d36_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_orders_2(B) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
                & m2_relset_1(C,u1_struct_0(A),u1_struct_0(B)) )
             => ( v21_waybel_0(C,A,B)
              <=> ! [D] :
                    ( m1_subset_1(D,k1_zfmisc_1(u1_struct_0(A)))
                   => ( v2_waybel_0(D,A)
                     => ( v1_xboole_0(D)
                        | r3_waybel_0(A,B,C,D) ) ) ) ) ) ) ) ).

fof(d37_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_orders_2(B) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
                & m2_relset_1(C,u1_struct_0(A),u1_struct_0(B)) )
             => ( v22_waybel_0(C,A,B)
              <=> ! [D] :
                    ( m1_subset_1(D,k1_zfmisc_1(u1_struct_0(A)))
                   => ( v1_waybel_0(D,A)
                     => ( v1_xboole_0(D)
                        | r4_waybel_0(A,B,C,D) ) ) ) ) ) ) ) ).

fof(d38_waybel_0,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( l1_orders_2(B)
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
                & m2_relset_1(C,u1_struct_0(A),u1_struct_0(B)) )
             => ( ~ ( ~ v3_struct_0(A)
                    & ~ v3_struct_0(B)
                    & ~ ( v23_waybel_0(C,A,B)
                      <=> ( v2_funct_1(C)
                          & v5_orders_3(C,A,B)
                          & ? [D] :
                              ( v1_funct_1(D)
                              & v1_funct_2(D,u1_struct_0(B),u1_struct_0(A))
                              & m2_relset_1(D,u1_struct_0(B),u1_struct_0(A))
                              & D = k2_funct_1(C)
                              & v5_orders_3(D,B,A) ) ) ) )
                & ( ~ ( ~ v3_struct_0(A)
                      & ~ v3_struct_0(B) )
                 => ( v23_waybel_0(C,A,B)
                  <=> ( v3_struct_0(A)
                      & v3_struct_0(B) ) ) ) ) ) ) ) ).

fof(t66_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_orders_2(B) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
                & m2_relset_1(C,u1_struct_0(A),u1_struct_0(B)) )
             => ( v23_waybel_0(C,A,B)
              <=> ( v2_funct_1(C)
                  & k2_relat_1(C) = u1_struct_0(B)
                  & ! [D] :
                      ( m1_subset_1(D,u1_struct_0(A))
                     => ! [E] :
                          ( m1_subset_1(E,u1_struct_0(A))
                         => ( r1_orders_2(A,D,E)
                          <=> r1_orders_2(B,k1_waybel_0(A,B,C,D),k1_waybel_0(A,B,C,E)) ) ) ) ) ) ) ) ) ).

fof(t67_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_orders_2(B) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
                & m2_relset_1(C,u1_struct_0(A),u1_struct_0(B)) )
             => ( v23_waybel_0(C,A,B)
               => ( v1_funct_1(k2_funct_1(C))
                  & v1_funct_2(k2_funct_1(C),u1_struct_0(B),u1_struct_0(A))
                  & m2_relset_1(k2_funct_1(C),u1_struct_0(B),u1_struct_0(A))
                  & k2_relat_1(k2_funct_1(C)) = u1_struct_0(A) ) ) ) ) ) ).

fof(t68_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_orders_2(B) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
                & m2_relset_1(C,u1_struct_0(A),u1_struct_0(B)) )
             => ( v23_waybel_0(C,A,B)
               => ! [D] :
                    ( ( v1_funct_1(D)
                      & v1_funct_2(D,u1_struct_0(B),u1_struct_0(A))
                      & m2_relset_1(D,u1_struct_0(B),u1_struct_0(A)) )
                   => ( D = k2_funct_1(C)
                     => v23_waybel_0(D,B,A) ) ) ) ) ) ) ).

fof(t69_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v2_orders_2(B)
            & v3_orders_2(B)
            & v4_orders_2(B)
            & l1_orders_2(B) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
                & m2_relset_1(C,u1_struct_0(A),u1_struct_0(B)) )
             => ( ! [D] :
                    ( ( ~ v1_xboole_0(D)
                      & v2_waybel_0(D,A)
                      & v13_waybel_0(D,A)
                      & m1_subset_1(D,k1_zfmisc_1(u1_struct_0(A))) )
                   => r3_waybel_0(A,B,C,D) )
               => v5_orders_3(C,A,B) ) ) ) ) ).

fof(t70_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v2_orders_2(B)
            & v3_orders_2(B)
            & v4_orders_2(B)
            & l1_orders_2(B) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
                & m2_relset_1(C,u1_struct_0(A),u1_struct_0(B)) )
             => ( ! [D] :
                    ( ( ~ v1_xboole_0(D)
                      & v2_waybel_0(D,A)
                      & v13_waybel_0(D,A)
                      & m1_subset_1(D,k1_zfmisc_1(u1_struct_0(A))) )
                   => r3_waybel_0(A,B,C,D) )
               => v21_waybel_0(C,A,B) ) ) ) ) ).

fof(t71_waybel_0,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v2_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v2_orders_2(B)
            & v3_orders_2(B)
            & v4_orders_2(B)
            & l1_orders_2(B) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
                & m2_relset_1(C,u1_struct_0(A),u1_struct_0(B)) )
             => ( ( ! [D] :
                      ( ( v1_finset_1(D)
                        & m1_subset_1(D,k1_zfmisc_1(u1_struct_0(A))) )
                     => r3_waybel_0(A,B,C,D) )
                  & ! [D] :
                      ( ( ~ v1_xboole_0(D)
                        & v2_waybel_0(D,A)
                        & m1_subset_1(D,k1_zfmisc_1(u1_struct_0(A))) )
                     => r3_waybel_0(A,B,C,D) ) )
               => v17_waybel_0(C,A,B) ) ) ) ) ).

fof(t72_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v2_orders_2(B)
            & v3_orders_2(B)
            & v4_orders_2(B)
            & l1_orders_2(B) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
                & m2_relset_1(C,u1_struct_0(A),u1_struct_0(B)) )
             => ( ! [D] :
                    ( ( ~ v1_xboole_0(D)
                      & v1_waybel_0(D,A)
                      & v12_waybel_0(D,A)
                      & m1_subset_1(D,k1_zfmisc_1(u1_struct_0(A))) )
                   => r4_waybel_0(A,B,C,D) )
               => v5_orders_3(C,A,B) ) ) ) ) ).

fof(t73_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v2_orders_2(B)
            & v3_orders_2(B)
            & v4_orders_2(B)
            & l1_orders_2(B) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
                & m2_relset_1(C,u1_struct_0(A),u1_struct_0(B)) )
             => ( ! [D] :
                    ( ( ~ v1_xboole_0(D)
                      & v1_waybel_0(D,A)
                      & v12_waybel_0(D,A)
                      & m1_subset_1(D,k1_zfmisc_1(u1_struct_0(A))) )
                   => r4_waybel_0(A,B,C,D) )
               => v22_waybel_0(C,A,B) ) ) ) ) ).

fof(t74_waybel_0,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v1_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v2_orders_2(B)
            & v3_orders_2(B)
            & v4_orders_2(B)
            & l1_orders_2(B) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
                & m2_relset_1(C,u1_struct_0(A),u1_struct_0(B)) )
             => ( ( ! [D] :
                      ( ( v1_finset_1(D)
                        & m1_subset_1(D,k1_zfmisc_1(u1_struct_0(A))) )
                     => r4_waybel_0(A,B,C,D) )
                  & ! [D] :
                      ( ( ~ v1_xboole_0(D)
                        & v1_waybel_0(D,A)
                        & m1_subset_1(D,k1_zfmisc_1(u1_struct_0(A))) )
                     => r4_waybel_0(A,B,C,D) ) )
               => v18_waybel_0(C,A,B) ) ) ) ) ).

fof(d39_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & l1_orders_2(A) )
     => ( v24_waybel_0(A)
      <=> ! [B] :
            ( ( ~ v1_xboole_0(B)
              & v1_waybel_0(B,A)
              & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
           => ? [C] :
                ( m1_subset_1(C,u1_struct_0(A))
                & r2_lattice3(A,B,C)
                & ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => ( r2_lattice3(A,B,D)
                     => r3_orders_2(A,C,D) ) ) ) ) ) ) ).

fof(t75_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ( v24_waybel_0(A)
      <=> ! [B] :
            ( ( ~ v1_xboole_0(B)
              & v1_waybel_0(B,A)
              & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
           => r1_yellow_0(A,B) ) ) ) ).

fof(d40_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & l1_orders_2(A) )
     => ( v25_waybel_0(A)
      <=> ! [B] :
            ( ( ~ v1_xboole_0(B)
              & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
           => ? [C] :
                ( m1_subset_1(C,u1_struct_0(A))
                & r1_lattice3(A,B,C)
                & ! [D] :
                    ( m1_subset_1(D,u1_struct_0(A))
                   => ( r1_lattice3(A,B,D)
                     => r1_orders_2(A,D,C) ) ) ) ) ) ) ).

fof(t76_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ( v25_waybel_0(A)
      <=> ! [B] :
            ( ( ~ v1_xboole_0(B)
              & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
           => r2_yellow_0(A,B) ) ) ) ).

fof(dt_l1_waybel_0,axiom,
    ! [A] :
      ( l1_struct_0(A)
     => ! [B] :
          ( l1_waybel_0(B,A)
         => l1_orders_2(B) ) ) ).

fof(existence_l1_waybel_0,axiom,
    ! [A] :
      ( l1_struct_0(A)
     => ? [B] : l1_waybel_0(B,A) ) ).

fof(abstractness_v6_waybel_0,axiom,
    ! [A,B] :
      ( ( l1_struct_0(A)
        & l1_waybel_0(B,A) )
     => ( v6_waybel_0(B,A)
       => B = g1_waybel_0(A,u1_struct_0(B),u1_orders_2(B),u1_waybel_0(A,B)) ) ) ).

fof(dt_k1_waybel_0,axiom,
    ! [A,B,C,D] :
      ( ( ~ v3_struct_0(A)
        & l1_struct_0(A)
        & ~ v3_struct_0(B)
        & l1_struct_0(B)
        & v1_funct_1(C)
        & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
        & m1_relset_1(C,u1_struct_0(A),u1_struct_0(B))
        & m1_subset_1(D,u1_struct_0(A)) )
     => m1_subset_1(k1_waybel_0(A,B,C,D),u1_struct_0(B)) ) ).

fof(redefinition_k1_waybel_0,axiom,
    ! [A,B,C,D] :
      ( ( ~ v3_struct_0(A)
        & l1_struct_0(A)
        & ~ v3_struct_0(B)
        & l1_struct_0(B)
        & v1_funct_1(C)
        & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
        & m1_relset_1(C,u1_struct_0(A),u1_struct_0(B))
        & m1_subset_1(D,u1_struct_0(A)) )
     => k1_waybel_0(A,B,C,D) = k1_funct_1(C,D) ) ).

fof(dt_k2_waybel_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & l1_struct_0(A)
        & ~ v3_struct_0(B)
        & l1_waybel_0(B,A) )
     => ( v1_funct_1(k2_waybel_0(A,B))
        & v1_funct_2(k2_waybel_0(A,B),u1_struct_0(B),u1_struct_0(A))
        & m2_relset_1(k2_waybel_0(A,B),u1_struct_0(B),u1_struct_0(A)) ) ) ).

fof(dt_k3_waybel_0,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(A)
        & l1_struct_0(A)
        & ~ v3_struct_0(B)
        & l1_waybel_0(B,A)
        & m1_subset_1(C,u1_struct_0(B)) )
     => m1_subset_1(k3_waybel_0(A,B,C),u1_struct_0(A)) ) ).

fof(dt_k4_waybel_0,axiom,
    ! [A,B] :
      ( ( l1_orders_2(A)
        & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
     => m1_subset_1(k4_waybel_0(A,B),k1_zfmisc_1(u1_struct_0(A))) ) ).

fof(dt_k5_waybel_0,axiom,
    ! [A,B] :
      ( ( l1_orders_2(A)
        & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
     => m1_subset_1(k5_waybel_0(A,B),k1_zfmisc_1(u1_struct_0(A))) ) ).

fof(dt_k6_waybel_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A)
        & m1_subset_1(B,u1_struct_0(A)) )
     => m1_subset_1(k6_waybel_0(A,B),k1_zfmisc_1(u1_struct_0(A))) ) ).

fof(dt_k7_waybel_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A)
        & m1_subset_1(B,u1_struct_0(A)) )
     => m1_subset_1(k7_waybel_0(A,B),k1_zfmisc_1(u1_struct_0(A))) ) ).

fof(dt_k8_waybel_0,axiom,
    $true ).

fof(dt_k9_waybel_0,axiom,
    $true ).

fof(dt_k10_waybel_0,axiom,
    $true ).

fof(dt_k11_waybel_0,axiom,
    $true ).

fof(dt_k12_waybel_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A)
        & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
     => m1_subset_1(k12_waybel_0(A,B),k1_zfmisc_1(u1_struct_0(A))) ) ).

fof(dt_k13_waybel_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A)
        & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
     => m1_subset_1(k13_waybel_0(A,B),k1_zfmisc_1(u1_struct_0(A))) ) ).

fof(dt_u1_waybel_0,axiom,
    ! [A,B] :
      ( ( l1_struct_0(A)
        & l1_waybel_0(B,A) )
     => ( v1_funct_1(u1_waybel_0(A,B))
        & v1_funct_2(u1_waybel_0(A,B),u1_struct_0(B),u1_struct_0(A))
        & m2_relset_1(u1_waybel_0(A,B),u1_struct_0(B),u1_struct_0(A)) ) ) ).

fof(dt_g1_waybel_0,axiom,
    ! [A,B,C,D] :
      ( ( l1_struct_0(A)
        & m1_relset_1(C,B,B)
        & v1_funct_1(D)
        & v1_funct_2(D,B,u1_struct_0(A))
        & m1_relset_1(D,B,u1_struct_0(A)) )
     => ( v6_waybel_0(g1_waybel_0(A,B,C,D),A)
        & l1_waybel_0(g1_waybel_0(A,B,C,D),A) ) ) ).

fof(free_g1_waybel_0,axiom,
    ! [A,B,C,D] :
      ( ( l1_struct_0(A)
        & m1_relset_1(C,B,B)
        & v1_funct_1(D)
        & v1_funct_2(D,B,u1_struct_0(A))
        & m1_relset_1(D,B,u1_struct_0(A)) )
     => ! [E,F,G,H] :
          ( g1_waybel_0(A,B,C,D) = g1_waybel_0(E,F,G,H)
         => ( A = E
            & B = F
            & C = G
            & D = H ) ) ) ).

fof(d13_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_waybel_0(B,A) )
         => ( v10_waybel_0(B,A)
          <=> ! [C] :
                ( m1_subset_1(C,u1_struct_0(B))
               => r1_waybel_0(A,B,a_3_0_waybel_0(A,B,C)) ) ) ) ) ).

fof(d14_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_waybel_0(B,A) )
         => ( v11_waybel_0(B,A)
          <=> ! [C] :
                ( m1_subset_1(C,u1_struct_0(B))
               => r1_waybel_0(A,B,a_3_1_waybel_0(A,B,C)) ) ) ) ) ).

fof(t14_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => k4_waybel_0(A,B) = a_2_0_waybel_0(A,B) ) ) ).

fof(t15_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => k5_waybel_0(A,B) = a_2_1_waybel_0(A,B) ) ) ).

fof(d23_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => k8_waybel_0(A) = a_1_0_waybel_0(A) ) ).

fof(d24_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => k9_waybel_0(A) = a_1_1_waybel_0(A) ) ).

fof(d27_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => k12_waybel_0(A,B) = a_2_2_waybel_0(A,B) ) ) ).

fof(d28_waybel_0,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
         => k13_waybel_0(A,B) = a_2_3_waybel_0(A,B) ) ) ).

fof(s1_waybel_0,axiom,
    ( r1_waybel_0(f1_s1_waybel_0,f2_s1_waybel_0,a_0_0_waybel_0)
  <=> ? [A] :
        ( m1_subset_1(A,u1_struct_0(f2_s1_waybel_0))
        & ! [B] :
            ( m1_subset_1(B,u1_struct_0(f2_s1_waybel_0))
           => ( r1_orders_2(f2_s1_waybel_0,A,B)
             => p1_s1_waybel_0(k3_waybel_0(f1_s1_waybel_0,f2_s1_waybel_0,B)) ) ) ) ) ).

fof(fraenkel_a_3_0_waybel_0,axiom,
    ! [A,B,C,D] :
      ( ( ~ v3_struct_0(B)
        & l1_orders_2(B)
        & ~ v3_struct_0(C)
        & l1_waybel_0(C,B)
        & m1_subset_1(D,u1_struct_0(C)) )
     => ( r2_hidden(A,a_3_0_waybel_0(B,C,D))
      <=> ? [E] :
            ( m1_subset_1(E,u1_struct_0(C))
            & A = k3_waybel_0(B,C,E)
            & r1_orders_2(B,k3_waybel_0(B,C,D),k3_waybel_0(B,C,E)) ) ) ) ).

fof(fraenkel_a_3_1_waybel_0,axiom,
    ! [A,B,C,D] :
      ( ( ~ v3_struct_0(B)
        & l1_orders_2(B)
        & ~ v3_struct_0(C)
        & l1_waybel_0(C,B)
        & m1_subset_1(D,u1_struct_0(C)) )
     => ( r2_hidden(A,a_3_1_waybel_0(B,C,D))
      <=> ? [E] :
            ( m1_subset_1(E,u1_struct_0(C))
            & A = k3_waybel_0(B,C,E)
            & r1_orders_2(B,k3_waybel_0(B,C,E),k3_waybel_0(B,C,D)) ) ) ) ).

fof(fraenkel_a_2_0_waybel_0,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(B)
        & l1_orders_2(B)
        & m1_subset_1(C,k1_zfmisc_1(u1_struct_0(B))) )
     => ( r2_hidden(A,a_2_0_waybel_0(B,C))
      <=> ? [D] :
            ( m1_subset_1(D,u1_struct_0(B))
            & A = D
            & ? [E] :
                ( m1_subset_1(E,u1_struct_0(B))
                & r1_orders_2(B,D,E)
                & r2_hidden(E,C) ) ) ) ) ).

fof(fraenkel_a_2_1_waybel_0,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(B)
        & l1_orders_2(B)
        & m1_subset_1(C,k1_zfmisc_1(u1_struct_0(B))) )
     => ( r2_hidden(A,a_2_1_waybel_0(B,C))
      <=> ? [D] :
            ( m1_subset_1(D,u1_struct_0(B))
            & A = D
            & ? [E] :
                ( m1_subset_1(E,u1_struct_0(B))
                & r1_orders_2(B,E,D)
                & r2_hidden(E,C) ) ) ) ) ).

fof(fraenkel_a_1_0_waybel_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(B)
        & v2_orders_2(B)
        & v3_orders_2(B)
        & l1_orders_2(B) )
     => ( r2_hidden(A,a_1_0_waybel_0(B))
      <=> ? [C] :
            ( ~ v1_xboole_0(C)
            & v1_waybel_0(C,B)
            & v12_waybel_0(C,B)
            & m1_subset_1(C,k1_zfmisc_1(u1_struct_0(B)))
            & A = C ) ) ) ).

fof(fraenkel_a_1_1_waybel_0,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(B)
        & v2_orders_2(B)
        & v3_orders_2(B)
        & l1_orders_2(B) )
     => ( r2_hidden(A,a_1_1_waybel_0(B))
      <=> ? [C] :
            ( ~ v1_xboole_0(C)
            & v2_waybel_0(C,B)
            & v13_waybel_0(C,B)
            & m1_subset_1(C,k1_zfmisc_1(u1_struct_0(B)))
            & A = C ) ) ) ).

fof(fraenkel_a_2_2_waybel_0,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(B)
        & l1_orders_2(B)
        & m1_subset_1(C,k1_zfmisc_1(u1_struct_0(B))) )
     => ( r2_hidden(A,a_2_2_waybel_0(B,C))
      <=> ? [D] :
            ( v1_finset_1(D)
            & m1_subset_1(D,k1_zfmisc_1(C))
            & A = k1_yellow_0(B,D)
            & r1_yellow_0(B,D) ) ) ) ).

fof(fraenkel_a_2_3_waybel_0,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(B)
        & l1_orders_2(B)
        & m1_subset_1(C,k1_zfmisc_1(u1_struct_0(B))) )
     => ( r2_hidden(A,a_2_3_waybel_0(B,C))
      <=> ? [D] :
            ( v1_finset_1(D)
            & m1_subset_1(D,k1_zfmisc_1(C))
            & A = k2_yellow_0(B,D)
            & r2_yellow_0(B,D) ) ) ) ).

fof(fraenkel_a_0_0_waybel_0,axiom,
    ! [A] :
      ( r2_hidden(A,a_0_0_waybel_0)
    <=> ? [B] :
          ( m1_subset_1(B,u1_struct_0(f2_s1_waybel_0))
          & A = k3_waybel_0(f1_s1_waybel_0,f2_s1_waybel_0,B)
          & p1_s1_waybel_0(k3_waybel_0(f1_s1_waybel_0,f2_s1_waybel_0,B)) ) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(fc1_yellow_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & l3_lattices(A) )
     => ( ~ v3_struct_0(k3_lattice3(A))
        & v1_orders_2(k3_lattice3(A))
        & v2_orders_2(k3_lattice3(A))
        & v3_orders_2(k3_lattice3(A))
        & v4_orders_2(k3_lattice3(A))
        & v1_lattice3(k3_lattice3(A))
        & v2_lattice3(k3_lattice3(A)) ) ) ).

fof(fc2_yellow_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v14_lattices(A)
        & l3_lattices(A) )
     => ( ~ v3_struct_0(k3_lattice3(A))
        & v1_orders_2(k3_lattice3(A))
        & v2_orders_2(k3_lattice3(A))
        & v3_orders_2(k3_lattice3(A))
        & v4_orders_2(k3_lattice3(A))
        & v2_yellow_0(k3_lattice3(A))
        & v1_lattice3(k3_lattice3(A))
        & v2_lattice3(k3_lattice3(A)) ) ) ).

fof(fc3_yellow_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v13_lattices(A)
        & l3_lattices(A) )
     => ( ~ v3_struct_0(k3_lattice3(A))
        & v1_orders_2(k3_lattice3(A))
        & v2_orders_2(k3_lattice3(A))
        & v3_orders_2(k3_lattice3(A))
        & v4_orders_2(k3_lattice3(A))
        & v1_yellow_0(k3_lattice3(A))
        & v1_lattice3(k3_lattice3(A))
        & v2_lattice3(k3_lattice3(A)) ) ) ).

fof(fc4_yellow_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v10_lattices(A)
        & v4_lattice3(A)
        & l3_lattices(A) )
     => ( ~ v3_struct_0(k3_lattice3(A))
        & v1_orders_2(k3_lattice3(A))
        & v2_orders_2(k3_lattice3(A))
        & v3_orders_2(k3_lattice3(A))
        & v4_orders_2(k3_lattice3(A))
        & v1_yellow_0(k3_lattice3(A))
        & v2_yellow_0(k3_lattice3(A))
        & v3_yellow_0(k3_lattice3(A))
        & v1_lattice3(k3_lattice3(A))
        & v2_lattice3(k3_lattice3(A))
        & v3_lattice3(k3_lattice3(A)) ) ) ).

fof(fc5_yellow_1,axiom,
    ! [A] :
      ( v1_orders_2(k2_yellow_1(A))
      & v2_orders_2(k2_yellow_1(A))
      & v3_orders_2(k2_yellow_1(A))
      & v4_orders_2(k2_yellow_1(A)) ) ).

fof(fc6_yellow_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ( ~ v3_struct_0(k2_yellow_1(A))
        & v1_orders_2(k2_yellow_1(A))
        & v2_orders_2(k2_yellow_1(A))
        & v3_orders_2(k2_yellow_1(A))
        & v4_orders_2(k2_yellow_1(A)) ) ) ).

fof(fc7_yellow_1,axiom,
    ! [A] :
      ( ~ v3_struct_0(k3_yellow_1(A))
      & v1_orders_2(k3_yellow_1(A))
      & v2_orders_2(k3_yellow_1(A))
      & v3_orders_2(k3_yellow_1(A))
      & v4_orders_2(k3_yellow_1(A)) ) ).

fof(fc8_yellow_1,axiom,
    ! [A] :
      ( ~ v3_struct_0(k3_yellow_1(A))
      & v1_orders_2(k3_yellow_1(A))
      & v2_orders_2(k3_yellow_1(A))
      & v3_orders_2(k3_yellow_1(A))
      & v4_orders_2(k3_yellow_1(A))
      & v1_yellow_0(k3_yellow_1(A))
      & v2_yellow_0(k3_yellow_1(A))
      & v3_yellow_0(k3_yellow_1(A))
      & v1_lattice3(k3_yellow_1(A))
      & v2_lattice3(k3_yellow_1(A))
      & v3_lattice3(k3_yellow_1(A)) ) ).

fof(fc9_yellow_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_pre_topc(A)
        & l1_pre_topc(A) )
     => ( ~ v3_struct_0(k2_yellow_1(u1_pre_topc(A)))
        & v1_orders_2(k2_yellow_1(u1_pre_topc(A)))
        & v2_orders_2(k2_yellow_1(u1_pre_topc(A)))
        & v3_orders_2(k2_yellow_1(u1_pre_topc(A)))
        & v4_orders_2(k2_yellow_1(u1_pre_topc(A)))
        & v1_yellow_0(k2_yellow_1(u1_pre_topc(A)))
        & v2_yellow_0(k2_yellow_1(u1_pre_topc(A)))
        & v3_yellow_0(k2_yellow_1(u1_pre_topc(A)))
        & v1_lattice3(k2_yellow_1(u1_pre_topc(A)))
        & v2_lattice3(k2_yellow_1(u1_pre_topc(A)))
        & v3_lattice3(k2_yellow_1(u1_pre_topc(A)))
        & ~ v3_realset2(k2_yellow_1(u1_pre_topc(A))) ) ) ).

fof(cc1_yellow_1,axiom,
    ! [A] :
      ( ( v1_relat_1(A)
        & v1_funct_1(A)
        & v1_yellow_1(A) )
     => ( v1_relat_1(A)
        & v1_funct_1(A)
        & v2_pralg_1(A) ) ) ).

fof(rc1_yellow_1,axiom,
    ! [A] :
    ? [B] :
      ( m1_pboole(B,A)
      & v1_relat_1(B)
      & v1_funct_1(B)
      & v2_pralg_1(B)
      & v1_yellow_1(B) ) ).

fof(fc10_yellow_1,axiom,
    ! [A,B] :
      ( l1_orders_2(B)
     => ( v1_relat_1(k2_funcop_1(A,B))
        & v1_funct_1(k2_funcop_1(A,B))
        & v2_pralg_1(k2_funcop_1(A,B))
        & v1_yellow_1(k2_funcop_1(A,B)) ) ) ).

fof(fc11_yellow_1,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(B)
        & l1_orders_2(B) )
     => ( ~ v3_struct_0(k6_yellow_1(A,B))
        & v1_orders_2(k6_yellow_1(A,B)) ) ) ).

fof(fc12_yellow_1,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(B)
        & v2_orders_2(B)
        & l1_orders_2(B) )
     => ( ~ v3_struct_0(k6_yellow_1(A,B))
        & v1_orders_2(k6_yellow_1(A,B))
        & v2_orders_2(k6_yellow_1(A,B)) ) ) ).

fof(fc13_yellow_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ( ~ v3_struct_0(k6_yellow_1(k1_xboole_0,A))
        & v1_orders_2(k6_yellow_1(k1_xboole_0,A))
        & v3_realset2(k6_yellow_1(k1_xboole_0,A)) ) ) ).

fof(fc14_yellow_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & l1_orders_2(A) )
     => ( ~ v3_struct_0(k6_yellow_1(k1_xboole_0,A))
        & v1_orders_2(k6_yellow_1(k1_xboole_0,A))
        & v2_orders_2(k6_yellow_1(k1_xboole_0,A))
        & v3_orders_2(k6_yellow_1(k1_xboole_0,A))
        & v4_orders_2(k6_yellow_1(k1_xboole_0,A))
        & v1_yellow_0(k6_yellow_1(k1_xboole_0,A))
        & v2_yellow_0(k6_yellow_1(k1_xboole_0,A))
        & v3_yellow_0(k6_yellow_1(k1_xboole_0,A))
        & v1_lattice3(k6_yellow_1(k1_xboole_0,A))
        & v2_lattice3(k6_yellow_1(k1_xboole_0,A))
        & v3_lattice3(k6_yellow_1(k1_xboole_0,A))
        & v3_realset2(k6_yellow_1(k1_xboole_0,A)) ) ) ).

fof(fc15_yellow_1,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(B)
        & v3_orders_2(B)
        & l1_orders_2(B) )
     => ( ~ v3_struct_0(k6_yellow_1(A,B))
        & v1_orders_2(k6_yellow_1(A,B))
        & v3_orders_2(k6_yellow_1(A,B)) ) ) ).

fof(fc16_yellow_1,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(B)
        & v4_orders_2(B)
        & l1_orders_2(B) )
     => ( ~ v3_struct_0(k6_yellow_1(A,B))
        & v1_orders_2(k6_yellow_1(A,B))
        & v4_orders_2(k6_yellow_1(A,B)) ) ) ).

fof(fc17_yellow_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & ~ v3_struct_0(B)
        & v4_orders_2(B)
        & v2_lattice3(B)
        & l1_orders_2(B) )
     => ( ~ v3_struct_0(k6_yellow_1(A,B))
        & v1_orders_2(k6_yellow_1(A,B))
        & v4_orders_2(k6_yellow_1(A,B))
        & v2_lattice3(k6_yellow_1(A,B)) ) ) ).

fof(fc18_yellow_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(A)
        & ~ v3_struct_0(B)
        & v4_orders_2(B)
        & v1_lattice3(B)
        & l1_orders_2(B) )
     => ( ~ v3_struct_0(k6_yellow_1(A,B))
        & v1_orders_2(k6_yellow_1(A,B))
        & v4_orders_2(k6_yellow_1(A,B))
        & v1_lattice3(k6_yellow_1(A,B)) ) ) ).

fof(d1_yellow_1,axiom,
    ! [A] : k2_yellow_1(A) = g1_orders_2(A,k1_yellow_1(A)) ).

fof(t1_yellow_1,axiom,
    ! [A] :
      ( u1_struct_0(k2_yellow_1(A)) = A
      & u1_orders_2(k2_yellow_1(A)) = k1_yellow_1(A) ) ).

fof(d2_yellow_1,axiom,
    ! [A] : k3_yellow_1(A) = k3_lattice3(k1_lattice3(A)) ).

fof(t2_yellow_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,u1_struct_0(k3_yellow_1(A)))
     => ! [C] :
          ( m1_subset_1(C,u1_struct_0(k3_yellow_1(A)))
         => ( r3_orders_2(k3_yellow_1(A),B,C)
          <=> r1_tarski(B,C) ) ) ) ).

fof(t3_yellow_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(k2_yellow_1(A)))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(k2_yellow_1(A)))
             => ( r3_orders_2(k2_yellow_1(A),B,C)
              <=> r1_tarski(B,C) ) ) ) ) ).

fof(t4_yellow_1,axiom,
    ! [A] : k3_yellow_1(A) = k2_yellow_1(k1_zfmisc_1(A)) ).

fof(t5_yellow_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(A)))
     => ( v4_yellow_0(k2_yellow_1(B),k3_yellow_1(A))
        & m1_yellow_0(k2_yellow_1(B),k3_yellow_1(A)) ) ) ).

fof(t6_yellow_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ( v1_lattice3(k2_yellow_1(A))
       => ! [B] :
            ( m1_subset_1(B,u1_struct_0(k2_yellow_1(A)))
           => ! [C] :
                ( m1_subset_1(C,u1_struct_0(k2_yellow_1(A)))
               => r1_tarski(k2_xboole_0(B,C),k10_lattice3(k2_yellow_1(A),B,C)) ) ) ) ) ).

fof(t7_yellow_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ( v2_lattice3(k2_yellow_1(A))
       => ! [B] :
            ( m1_subset_1(B,u1_struct_0(k2_yellow_1(A)))
           => ! [C] :
                ( m1_subset_1(C,u1_struct_0(k2_yellow_1(A)))
               => r1_tarski(k11_lattice3(k2_yellow_1(A),B,C),k3_xboole_0(B,C)) ) ) ) ) ).

fof(t8_yellow_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(k2_yellow_1(A)))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(k2_yellow_1(A)))
             => ( r2_hidden(k2_xboole_0(B,C),A)
               => k10_lattice3(k2_yellow_1(A),B,C) = k2_xboole_0(B,C) ) ) ) ) ).

fof(t9_yellow_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(k2_yellow_1(A)))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(k2_yellow_1(A)))
             => ( r2_hidden(k3_xboole_0(B,C),A)
               => k11_lattice3(k2_yellow_1(A),B,C) = k3_xboole_0(B,C) ) ) ) ) ).

fof(t10_yellow_1,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( ! [B] :
            ( m1_subset_1(B,u1_struct_0(A))
           => ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => ( r1_orders_2(A,B,C)
                <=> r1_tarski(B,C) ) ) )
       => u1_orders_2(A) = k1_yellow_1(u1_struct_0(A)) ) ) ).

fof(t11_yellow_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ( ! [B,C] :
            ( ( r2_hidden(B,A)
              & r2_hidden(C,A) )
           => r2_hidden(k2_xboole_0(B,C),A) )
       => v1_lattice3(k2_yellow_1(A)) ) ) ).

fof(t12_yellow_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ( ! [B,C] :
            ( ( r2_hidden(B,A)
              & r2_hidden(C,A) )
           => r2_hidden(k3_xboole_0(B,C),A) )
       => v2_lattice3(k2_yellow_1(A)) ) ) ).

fof(t13_yellow_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ( r2_hidden(k1_xboole_0,A)
       => k3_yellow_0(k2_yellow_1(A)) = k1_xboole_0 ) ) ).

fof(t14_yellow_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ( r2_hidden(k3_tarski(A),A)
       => k4_yellow_0(k2_yellow_1(A)) = k3_tarski(A) ) ) ).

fof(t15_yellow_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ( v2_yellow_0(k2_yellow_1(A))
       => r2_hidden(k3_tarski(A),A) ) ) ).

fof(t16_yellow_1,axiom,
    ! [A] :
      ( ~ v1_xboole_0(A)
     => ( v1_yellow_0(k2_yellow_1(A))
       => r2_hidden(k1_setfam_1(A),A) ) ) ).

fof(t17_yellow_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,u1_struct_0(k3_yellow_1(A)))
     => ! [C] :
          ( m1_subset_1(C,u1_struct_0(k3_yellow_1(A)))
         => ( k13_lattice3(k3_yellow_1(A),B,C) = k2_xboole_0(B,C)
            & k12_lattice3(k3_yellow_1(A),B,C) = k3_xboole_0(B,C) ) ) ) ).

fof(t18_yellow_1,axiom,
    ! [A] : k3_yellow_0(k3_yellow_1(A)) = k1_xboole_0 ).

fof(t19_yellow_1,axiom,
    ! [A] : k4_yellow_0(k3_yellow_1(A)) = A ).

fof(t20_yellow_1,axiom,
    ! [A,B] :
      ( ( ~ v1_xboole_0(B)
        & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(k3_yellow_1(A)))) )
     => k2_yellow_0(k3_yellow_1(A),B) = k1_setfam_1(B) ) ).

fof(t21_yellow_1,axiom,
    ! [A,B] :
      ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(k3_yellow_1(A))))
     => k1_yellow_0(k3_yellow_1(A),B) = k3_tarski(B) ) ).

fof(t22_yellow_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_pre_topc(A)
        & l1_pre_topc(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(k2_yellow_1(u1_pre_topc(A)))))
         => k1_yellow_0(k2_yellow_1(u1_pre_topc(A)),B) = k3_tarski(B) ) ) ).

fof(t23_yellow_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_pre_topc(A)
        & l1_pre_topc(A) )
     => k3_yellow_0(k2_yellow_1(u1_pre_topc(A))) = k1_xboole_0 ) ).

fof(t24_yellow_1,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_pre_topc(A)
        & l1_pre_topc(A) )
     => k4_yellow_0(k2_yellow_1(u1_pre_topc(A))) = u1_struct_0(A) ) ).

fof(t25_yellow_1,axiom,
    ! [A] :
      ( ( v2_pre_topc(A)
        & l1_pre_topc(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(u1_struct_0(A))))
         => ( v1_tops_2(B,A)
          <=> m1_subset_1(B,k1_zfmisc_1(u1_struct_0(k2_yellow_1(u1_pre_topc(A))))) ) ) ) ).

fof(d3_yellow_1,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ( v1_yellow_1(A)
      <=> ! [B] :
            ( r2_hidden(B,k2_relat_1(A))
           => l1_orders_2(B) ) ) ) ).

fof(d4_yellow_1,axiom,
    ! [A,B] :
      ( ( v1_yellow_1(B)
        & m1_pboole(B,A) )
     => ! [C] :
          ( ( v1_orders_2(C)
            & l1_orders_2(C) )
         => ( C = k5_yellow_1(A,B)
          <=> ( u1_struct_0(C) = k4_card_3(k12_pralg_1(A,B))
              & ! [D] :
                  ( m1_subset_1(D,u1_struct_0(C))
                 => ! [E] :
                      ( m1_subset_1(E,u1_struct_0(C))
                     => ( r2_hidden(D,k4_card_3(k12_pralg_1(A,B)))
                       => ( r1_orders_2(C,D,E)
                        <=> ? [F] :
                              ( v1_relat_1(F)
                              & v1_funct_1(F)
                              & ? [G] :
                                  ( v1_relat_1(G)
                                  & v1_funct_1(G)
                                  & F = D
                                  & G = E
                                  & ! [H] :
                                      ~ ( r2_hidden(H,A)
                                        & ! [I] :
                                            ( l1_orders_2(I)
                                           => ! [J] :
                                                ( m1_subset_1(J,u1_struct_0(I))
                                               => ! [K] :
                                                    ( m1_subset_1(K,u1_struct_0(I))
                                                   => ~ ( I = k1_funct_1(B,H)
                                                        & J = k1_funct_1(F,H)
                                                        & K = k1_funct_1(G,H)
                                                        & r1_orders_2(I,J,K) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

fof(d5_yellow_1,axiom,
    ! [A,B] :
      ( l1_orders_2(B)
     => k6_yellow_1(A,B) = k5_yellow_1(A,k2_pre_circ(A,B)) ) ).

fof(t26_yellow_1,axiom,
    ! [A] :
      ( ( v1_yellow_1(A)
        & m1_pboole(A,k1_xboole_0) )
     => k5_yellow_1(k1_xboole_0,A) = g1_orders_2(k1_tarski(k1_xboole_0),k6_partfun1(k1_tarski(k1_xboole_0))) ) ).

fof(t27_yellow_1,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => k6_yellow_1(k1_xboole_0,A) = g1_orders_2(k1_tarski(k1_xboole_0),k6_partfun1(k1_tarski(k1_xboole_0))) ) ).

fof(t28_yellow_1,axiom,
    ! [A,B] :
      ( l1_orders_2(B)
     => k1_funct_2(A,u1_struct_0(B)) = u1_struct_0(k6_yellow_1(A,B)) ) ).

fof(d6_yellow_1,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( l1_orders_2(B)
         => ! [C] :
              ( ( v1_orders_2(C)
                & v4_yellow_0(C,k6_yellow_1(u1_struct_0(A),B))
                & m1_yellow_0(C,k6_yellow_1(u1_struct_0(A),B)) )
             => ( C = k7_yellow_1(A,B)
              <=> ! [D] :
                    ( ( v1_funct_1(D)
                      & v1_funct_2(D,u1_struct_0(A),u1_struct_0(B))
                      & m2_relset_1(D,u1_struct_0(A),u1_struct_0(B)) )
                   => ( r2_hidden(D,u1_struct_0(C))
                    <=> ( r2_hidden(D,k1_funct_2(u1_struct_0(A),u1_struct_0(B)))
                        & v5_orders_3(D,A,B) ) ) ) ) ) ) ) ).

fof(dt_k1_yellow_1,axiom,
    ! [A] :
      ( v1_relat_2(k1_yellow_1(A))
      & v4_relat_2(k1_yellow_1(A))
      & v8_relat_2(k1_yellow_1(A))
      & v1_partfun1(k1_yellow_1(A),A,A)
      & m2_relset_1(k1_yellow_1(A),A,A) ) ).

fof(redefinition_k1_yellow_1,axiom,
    ! [A] : k1_yellow_1(A) = k1_wellord2(A) ).

fof(dt_k2_yellow_1,axiom,
    ! [A] :
      ( v1_orders_2(k2_yellow_1(A))
      & l1_orders_2(k2_yellow_1(A)) ) ).

fof(dt_k3_yellow_1,axiom,
    ! [A] :
      ( v1_orders_2(k3_yellow_1(A))
      & l1_orders_2(k3_yellow_1(A)) ) ).

fof(dt_k4_yellow_1,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & v1_yellow_1(B)
        & m1_pboole(B,A)
        & m1_subset_1(C,A) )
     => l1_orders_2(k4_yellow_1(A,B,C)) ) ).

fof(redefinition_k4_yellow_1,axiom,
    ! [A,B,C] :
      ( ( ~ v1_xboole_0(A)
        & v1_yellow_1(B)
        & m1_pboole(B,A)
        & m1_subset_1(C,A) )
     => k4_yellow_1(A,B,C) = k1_funct_1(B,C) ) ).

fof(dt_k5_yellow_1,axiom,
    ! [A,B] :
      ( ( v1_yellow_1(B)
        & m1_pboole(B,A) )
     => ( v1_orders_2(k5_yellow_1(A,B))
        & l1_orders_2(k5_yellow_1(A,B)) ) ) ).

fof(dt_k6_yellow_1,axiom,
    ! [A,B] :
      ( l1_orders_2(B)
     => ( v1_orders_2(k6_yellow_1(A,B))
        & l1_orders_2(k6_yellow_1(A,B)) ) ) ).

fof(dt_k7_yellow_1,axiom,
    ! [A,B] :
      ( ( l1_orders_2(A)
        & l1_orders_2(B) )
     => ( v1_orders_2(k7_yellow_1(A,B))
        & v4_yellow_0(k7_yellow_1(A,B),k6_yellow_1(u1_struct_0(A),B))
        & m1_yellow_0(k7_yellow_1(A,B),k6_yellow_1(u1_struct_0(A),B)) ) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(fc1_yellow_2,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A)
        & ~ v1_xboole_0(B)
        & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
     => ( ~ v3_struct_0(k5_yellow_0(A,B))
        & v1_orders_2(k5_yellow_0(A,B))
        & v4_yellow_0(k5_yellow_0(A,B),A) ) ) ).

fof(fc2_yellow_2,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A)
        & ~ v3_struct_0(B)
        & l1_orders_2(B)
        & v1_funct_1(C)
        & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
        & m1_relset_1(C,u1_struct_0(A),u1_struct_0(B)) )
     => ( ~ v3_struct_0(k2_yellow_2(A,B,C))
        & v1_orders_2(k2_yellow_2(A,B,C))
        & v4_yellow_0(k2_yellow_2(A,B,C),B) ) ) ).

fof(cc1_yellow_2,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( ( ~ v3_struct_0(A)
          & v2_orders_2(A)
          & v3_orders_2(A)
          & v4_orders_2(A)
          & v2_yellow_0(A)
          & v24_waybel_0(A)
          & v25_waybel_0(A) )
       => ( ~ v3_struct_0(A)
          & v2_orders_2(A)
          & v3_orders_2(A)
          & v4_orders_2(A)
          & v1_yellow_0(A)
          & v2_yellow_0(A)
          & v3_yellow_0(A)
          & v24_waybel_0(A)
          & v25_waybel_0(A)
          & v1_lattice3(A)
          & v2_lattice3(A)
          & v3_lattice3(A) ) ) ) ).

fof(fc3_yellow_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & l1_orders_2(A) )
     => ~ v1_xboole_0(k8_waybel_0(A)) ) ).

fof(fc4_yellow_2,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v2_lattice3(A)
        & l1_orders_2(A) )
     => ( ~ v3_struct_0(k2_yellow_1(k8_waybel_0(A)))
        & v1_orders_2(k2_yellow_1(k8_waybel_0(A)))
        & v2_orders_2(k2_yellow_1(k8_waybel_0(A)))
        & v3_orders_2(k2_yellow_1(k8_waybel_0(A)))
        & v4_orders_2(k2_yellow_1(k8_waybel_0(A)))
        & v2_lattice3(k2_yellow_1(k8_waybel_0(A))) ) ) ).

fof(fc5_yellow_2,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v1_lattice3(A)
        & l1_orders_2(A) )
     => ( ~ v3_struct_0(k2_yellow_1(k8_waybel_0(A)))
        & v1_orders_2(k2_yellow_1(k8_waybel_0(A)))
        & v2_orders_2(k2_yellow_1(k8_waybel_0(A)))
        & v3_orders_2(k2_yellow_1(k8_waybel_0(A)))
        & v4_orders_2(k2_yellow_1(k8_waybel_0(A)))
        & v1_lattice3(k2_yellow_1(k8_waybel_0(A))) ) ) ).

fof(fc6_yellow_2,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v1_yellow_0(A)
        & v1_lattice3(A)
        & l1_orders_2(A) )
     => ( ~ v3_struct_0(k2_yellow_1(k8_waybel_0(A)))
        & v1_orders_2(k2_yellow_1(k8_waybel_0(A)))
        & v2_orders_2(k2_yellow_1(k8_waybel_0(A)))
        & v3_orders_2(k2_yellow_1(k8_waybel_0(A)))
        & v4_orders_2(k2_yellow_1(k8_waybel_0(A)))
        & v1_yellow_0(k2_yellow_1(k8_waybel_0(A)))
        & v2_yellow_0(k2_yellow_1(k8_waybel_0(A)))
        & v3_yellow_0(k2_yellow_1(k8_waybel_0(A)))
        & v24_waybel_0(k2_yellow_1(k8_waybel_0(A)))
        & v25_waybel_0(k2_yellow_1(k8_waybel_0(A)))
        & v1_lattice3(k2_yellow_1(k8_waybel_0(A)))
        & v2_lattice3(k2_yellow_1(k8_waybel_0(A)))
        & v3_lattice3(k2_yellow_1(k8_waybel_0(A))) ) ) ).

fof(fc7_yellow_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v24_waybel_0(A)
        & l1_orders_2(A) )
     => ( v1_relat_1(k3_yellow_2(A))
        & v1_funct_1(k3_yellow_2(A))
        & v1_funct_2(k3_yellow_2(A),u1_struct_0(k2_yellow_1(k8_waybel_0(A))),u1_struct_0(A))
        & v5_orders_3(k3_yellow_2(A),k2_yellow_1(k8_waybel_0(A)),A) ) ) ).

fof(fc8_yellow_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ( v1_relat_1(k4_yellow_2(A))
        & v1_funct_1(k4_yellow_2(A))
        & v1_funct_2(k4_yellow_2(A),u1_struct_0(A),u1_struct_0(k2_yellow_1(k8_waybel_0(A))))
        & v5_orders_3(k4_yellow_2(A),A,k2_yellow_1(k8_waybel_0(A))) ) ) ).

fof(t1_yellow_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
             => ( r1_tarski(C,k6_waybel_0(A,B))
              <=> r2_lattice3(A,C,B) ) ) ) ) ).

fof(t2_yellow_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
             => ( r1_tarski(C,k7_waybel_0(A,B))
              <=> r1_lattice3(A,C,B) ) ) ) ) ).

fof(t3_yellow_2,axiom,
    ! [A] :
      ( ( v3_orders_2(A)
        & v4_orders_2(A)
        & v1_lattice3(A)
        & l1_orders_2(A) )
     => ! [B,C] :
          ( ( r1_yellow_0(A,B)
            & r1_yellow_0(A,C) )
         => ( r1_yellow_0(A,k2_xboole_0(B,C))
            & k1_yellow_0(A,k2_xboole_0(B,C)) = k13_lattice3(A,k1_yellow_0(A,B),k1_yellow_0(A,C)) ) ) ) ).

fof(t4_yellow_2,axiom,
    ! [A] :
      ( ( v3_orders_2(A)
        & v4_orders_2(A)
        & v2_lattice3(A)
        & l1_orders_2(A) )
     => ! [B,C] :
          ( ( r2_yellow_0(A,B)
            & r2_yellow_0(A,C) )
         => ( r2_yellow_0(A,k2_xboole_0(B,C))
            & k2_yellow_0(A,k2_xboole_0(B,C)) = k12_lattice3(A,k2_yellow_0(A,B),k2_yellow_0(A,C)) ) ) ) ).

fof(t5_yellow_2,axiom,
    ! [A] :
      ( v1_relat_1(A)
     => ! [B,C] :
          ( r1_tarski(B,C)
         => r1_tarski(k2_wellord1(A,B),k2_wellord1(A,C)) ) ) ).

fof(t6_yellow_2,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( ( v4_yellow_0(B,A)
            & m1_yellow_0(B,A) )
         => ! [C] :
              ( ( v4_yellow_0(C,A)
                & m1_yellow_0(C,A) )
             => ( r1_tarski(u1_struct_0(B),u1_struct_0(C))
               => r1_tarski(u1_orders_2(B),u1_orders_2(C)) ) ) ) ) ).

fof(t7_yellow_2,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(B)
        & l1_orders_2(B) )
     => ! [C] :
          ( ( ~ v3_struct_0(C)
            & m1_yellow_0(C,B) )
         => ( ( ( v1_waybel_0(A,C)
                & m1_subset_1(A,k1_zfmisc_1(u1_struct_0(C))) )
             => ( v1_waybel_0(A,B)
                & m1_subset_1(A,k1_zfmisc_1(u1_struct_0(B))) ) )
            & ( ( v2_waybel_0(A,C)
                & m1_subset_1(A,k1_zfmisc_1(u1_struct_0(C))) )
             => ( v2_waybel_0(A,B)
                & m1_subset_1(A,k1_zfmisc_1(u1_struct_0(B))) ) ) ) ) ) ).

fof(t8_yellow_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v4_yellow_0(B,A)
            & m1_yellow_0(B,A) )
         => ! [C] :
              ( ( ~ v3_struct_0(C)
                & v4_yellow_0(C,A)
                & m1_yellow_0(C,A) )
             => ( r1_tarski(u1_struct_0(B),u1_struct_0(C))
               => ! [D] :
                    ( m1_subset_1(D,k1_zfmisc_1(u1_struct_0(B)))
                   => ( m1_subset_1(D,k1_zfmisc_1(u1_struct_0(C)))
                      & ! [E] :
                          ( m1_subset_1(E,k1_zfmisc_1(u1_struct_0(C)))
                         => ( D = E
                           => ( ( v2_waybel_0(D,B)
                               => v2_waybel_0(E,C) )
                              & ( v1_waybel_0(D,B)
                               => v1_waybel_0(E,C) ) ) ) ) ) ) ) ) ) ) ).

fof(d1_yellow_2,axiom,
    ! [A,B] :
      ( l1_orders_2(B)
     => ! [C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,A,u1_struct_0(B))
            & m2_relset_1(C,A,u1_struct_0(B)) )
         => ! [D] :
              ( ( v1_funct_1(D)
                & v1_funct_2(D,A,u1_struct_0(B))
                & m2_relset_1(D,A,u1_struct_0(B)) )
             => ( r1_yellow_2(A,B,C,D)
              <=> ! [E] :
                    ~ ( r2_hidden(E,A)
                      & ! [F] :
                          ( m1_subset_1(F,u1_struct_0(B))
                         => ! [G] :
                              ( m1_subset_1(G,u1_struct_0(B))
                             => ~ ( F = k1_funct_1(C,E)
                                  & G = k1_funct_1(D,E)
                                  & r1_orders_2(B,F,G) ) ) ) ) ) ) ) ) ).

fof(t9_yellow_2,axiom,
    $true ).

fof(t10_yellow_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_orders_2(B) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
                & m2_relset_1(C,u1_struct_0(A),u1_struct_0(B)) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,u1_struct_0(A),u1_struct_0(B))
                    & m2_relset_1(D,u1_struct_0(A),u1_struct_0(B)) )
                 => ( r1_yellow_2(u1_struct_0(A),B,C,D)
                  <=> ! [E] :
                        ( m1_subset_1(E,u1_struct_0(A))
                       => r1_orders_2(B,k1_waybel_0(A,B,C,E),k1_waybel_0(A,B,D,E)) ) ) ) ) ) ) ).

fof(d2_yellow_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_orders_2(B) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
                & m2_relset_1(C,u1_struct_0(A),u1_struct_0(B)) )
             => k2_yellow_2(A,B,C) = k5_yellow_0(B,k1_yellow_2(A,B,C)) ) ) ) ).

fof(t11_yellow_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_orders_2(B) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
                & m2_relset_1(C,u1_struct_0(A),u1_struct_0(B)) )
             => k1_yellow_2(A,B,C) = u1_struct_0(k2_yellow_2(A,B,C)) ) ) ) ).

fof(t12_yellow_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_orders_2(B) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
                & m2_relset_1(C,u1_struct_0(A),u1_struct_0(B)) )
             => ! [D] :
                  ( m1_subset_1(D,u1_struct_0(k2_yellow_2(A,B,C)))
                 => ? [E] :
                      ( m1_subset_1(E,u1_struct_0(A))
                      & k1_waybel_0(A,B,C,E) = D ) ) ) ) ) ).

fof(t13_yellow_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => v5_orders_3(k7_grcat_1(A),A,A) ) ).

fof(t14_yellow_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_orders_2(B) )
         => ! [C] :
              ( ( ~ v3_struct_0(C)
                & l1_orders_2(C) )
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,u1_struct_0(A),u1_struct_0(B))
                    & m2_relset_1(D,u1_struct_0(A),u1_struct_0(B)) )
                 => ! [E] :
                      ( ( v1_funct_1(E)
                        & v1_funct_2(E,u1_struct_0(B),u1_struct_0(C))
                        & m2_relset_1(E,u1_struct_0(B),u1_struct_0(C)) )
                     => ( ( v5_orders_3(D,A,B)
                          & v5_orders_3(E,B,C) )
                       => v5_orders_3(k7_funct_2(u1_struct_0(A),u1_struct_0(B),u1_struct_0(C),D,E),A,C) ) ) ) ) ) ) ).

fof(t15_yellow_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_orders_2(B) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
                & m2_relset_1(C,u1_struct_0(A),u1_struct_0(B)) )
             => ! [D] :
                  ( m1_subset_1(D,k1_zfmisc_1(u1_struct_0(A)))
                 => ! [E] :
                      ( m1_subset_1(E,u1_struct_0(A))
                     => ( ( v5_orders_3(C,A,B)
                          & r1_lattice3(A,D,E) )
                       => r1_lattice3(B,k4_pre_topc(A,B,C,D),k1_waybel_0(A,B,C,E)) ) ) ) ) ) ) ).

fof(t16_yellow_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_orders_2(B) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
                & m2_relset_1(C,u1_struct_0(A),u1_struct_0(B)) )
             => ! [D] :
                  ( m1_subset_1(D,k1_zfmisc_1(u1_struct_0(A)))
                 => ! [E] :
                      ( m1_subset_1(E,u1_struct_0(A))
                     => ( ( v5_orders_3(C,A,B)
                          & r2_lattice3(A,D,E) )
                       => r2_lattice3(B,k4_pre_topc(A,B,C,D),k1_waybel_0(A,B,C,E)) ) ) ) ) ) ) ).

fof(t17_yellow_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_orders_2(B) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
                & m2_relset_1(C,u1_struct_0(A),u1_struct_0(B)) )
             => ! [D] :
                  ( ( v1_waybel_0(D,A)
                    & m1_subset_1(D,k1_zfmisc_1(u1_struct_0(A))) )
                 => ( v5_orders_3(C,A,B)
                   => v1_waybel_0(k4_pre_topc(A,B,C,D),B) ) ) ) ) ) ).

fof(t18_yellow_2,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v1_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,u1_struct_0(A),u1_struct_0(A))
            & m2_relset_1(B,u1_struct_0(A),u1_struct_0(A)) )
         => ( v22_waybel_0(B,A,A)
           => v5_orders_3(B,A,A) ) ) ) ).

fof(t19_yellow_2,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v2_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,u1_struct_0(A),u1_struct_0(A))
            & m2_relset_1(B,u1_struct_0(A),u1_struct_0(A)) )
         => ( v21_waybel_0(B,A,A)
           => v5_orders_3(B,A,A) ) ) ) ).

fof(t20_yellow_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_struct_0(A) )
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,u1_struct_0(A),u1_struct_0(A))
            & m2_relset_1(B,u1_struct_0(A),u1_struct_0(A)) )
         => ( v11_quantal1(B)
           => ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => k1_waybel_0(A,A,B,k1_waybel_0(A,A,B,C)) = k1_waybel_0(A,A,B,C) ) ) ) ) ).

fof(t22_yellow_2,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(B)
        & l1_struct_0(B) )
     => ! [C] :
          ( ( v1_funct_1(C)
            & v1_funct_2(C,u1_struct_0(B),u1_struct_0(B))
            & m2_relset_1(C,u1_struct_0(B),u1_struct_0(B)) )
         => ( ( v11_quantal1(C)
              & r1_tarski(A,k1_yellow_2(B,B,C)) )
           => k4_pre_topc(B,B,C,A) = A ) ) ) ).

fof(t23_yellow_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => v11_quantal1(k7_grcat_1(A)) ) ).

fof(t24_yellow_2,axiom,
    ! [A,B] :
      ( ( v2_orders_2(B)
        & v3_orders_2(B)
        & v4_orders_2(B)
        & v1_lattice3(B)
        & v2_lattice3(B)
        & v3_lattice3(B)
        & l1_orders_2(B) )
     => ! [C] :
          ( m1_subset_1(C,u1_struct_0(B))
         => ( r2_hidden(C,A)
           => ( r3_orders_2(B,C,k1_yellow_0(B,A))
              & r3_orders_2(B,k2_yellow_0(B,A),C) ) ) ) ) ).

fof(t25_yellow_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ( ! [B] : r1_yellow_0(A,B)
      <=> ! [B] : r2_yellow_0(A,B) ) ) ).

fof(t26_yellow_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ( ! [B] : r1_yellow_0(A,B)
       => v3_lattice3(A) ) ) ).

fof(t27_yellow_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ( ! [B] : r2_yellow_0(A,B)
       => v3_lattice3(A) ) ) ).

fof(t28_yellow_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ( ! [B] :
            ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
           => r2_yellow_0(A,B) )
       => ! [B] :
            ( r2_yellow_0(A,B)
            & k2_yellow_0(A,B) = k2_yellow_0(A,k3_xboole_0(B,u1_struct_0(A))) ) ) ) ).

fof(t29_yellow_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ( ! [B] :
            ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
           => r1_yellow_0(A,B) )
       => ! [B] :
            ( r1_yellow_0(A,B)
            & k1_yellow_0(A,B) = k1_yellow_0(A,k3_xboole_0(B,u1_struct_0(A))) ) ) ) ).

fof(t30_yellow_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ( ! [B] :
            ( m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A)))
           => r2_yellow_0(A,B) )
       => v3_lattice3(A) ) ) ).

fof(t32_yellow_2,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v1_lattice3(A)
        & v2_lattice3(A)
        & v3_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v4_yellow_0(B,A)
            & v7_yellow_0(B,A)
            & m1_yellow_0(B,A) )
         => ( v2_orders_2(B)
            & v3_orders_2(B)
            & v4_orders_2(B)
            & v1_lattice3(B)
            & v2_lattice3(B)
            & v3_lattice3(B)
            & l1_orders_2(B) ) ) ) ).

fof(t33_yellow_2,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v1_lattice3(A)
        & v2_lattice3(A)
        & v3_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & v4_yellow_0(B,A)
            & v8_yellow_0(B,A)
            & m1_yellow_0(B,A) )
         => ( v2_orders_2(B)
            & v3_orders_2(B)
            & v4_orders_2(B)
            & v1_lattice3(B)
            & v2_lattice3(B)
            & v3_lattice3(B)
            & l1_orders_2(B) ) ) ) ).

fof(t34_yellow_2,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v1_lattice3(A)
        & v2_lattice3(A)
        & v3_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_orders_2(B) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
                & m2_relset_1(C,u1_struct_0(A),u1_struct_0(B)) )
             => ( v18_waybel_0(C,A,B)
               => v8_yellow_0(k2_yellow_2(A,B,C),B) ) ) ) ) ).

fof(t35_yellow_2,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v1_lattice3(A)
        & v2_lattice3(A)
        & v3_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v3_struct_0(B)
            & l1_orders_2(B) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
                & m2_relset_1(C,u1_struct_0(A),u1_struct_0(B)) )
             => ( v17_waybel_0(C,A,B)
               => v7_yellow_0(k2_yellow_2(A,B,C),B) ) ) ) ) ).

fof(t36_yellow_2,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v1_lattice3(A)
        & v2_lattice3(A)
        & v3_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( v2_orders_2(B)
            & v3_orders_2(B)
            & v4_orders_2(B)
            & v1_lattice3(B)
            & v2_lattice3(B)
            & v3_lattice3(B)
            & l1_orders_2(B) )
         => ! [C] :
              ( ( v1_funct_1(C)
                & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
                & m2_relset_1(C,u1_struct_0(A),u1_struct_0(B)) )
             => ( ( v18_waybel_0(C,A,B)
                  | v17_waybel_0(C,A,B) )
               => ( v2_orders_2(k2_yellow_2(A,B,C))
                  & v3_orders_2(k2_yellow_2(A,B,C))
                  & v4_orders_2(k2_yellow_2(A,B,C))
                  & v1_lattice3(k2_yellow_2(A,B,C))
                  & v2_lattice3(k2_yellow_2(A,B,C))
                  & v3_lattice3(k2_yellow_2(A,B,C))
                  & l1_orders_2(k2_yellow_2(A,B,C)) ) ) ) ) ) ).

fof(t37_yellow_2,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v1_lattice3(A)
        & v2_lattice3(A)
        & v3_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,u1_struct_0(A),u1_struct_0(A))
            & m2_relset_1(B,u1_struct_0(A),u1_struct_0(A)) )
         => ( ( v11_quantal1(B)
              & v22_waybel_0(B,A,A) )
           => ( v4_waybel_0(k2_yellow_2(A,A,B),A)
              & v2_orders_2(k2_yellow_2(A,A,B))
              & v3_orders_2(k2_yellow_2(A,A,B))
              & v4_orders_2(k2_yellow_2(A,A,B))
              & v1_lattice3(k2_yellow_2(A,A,B))
              & v2_lattice3(k2_yellow_2(A,A,B))
              & v3_lattice3(k2_yellow_2(A,A,B))
              & l1_orders_2(k2_yellow_2(A,A,B)) ) ) ) ) ).

fof(t38_yellow_2,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(u1_struct_0(A))))
         => ( ! [C] :
                ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
               => ( r2_hidden(C,B)
                 => v12_waybel_0(C,A) ) )
           => ( v12_waybel_0(k6_setfam_1(u1_struct_0(A),B),A)
              & m1_subset_1(k6_setfam_1(u1_struct_0(A),B),k1_zfmisc_1(u1_struct_0(A))) ) ) ) ) ).

fof(t39_yellow_2,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(u1_struct_0(A))))
         => ( ! [C] :
                ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
               => ( r2_hidden(C,B)
                 => v13_waybel_0(C,A) ) )
           => ( v13_waybel_0(k6_setfam_1(u1_struct_0(A),B),A)
              & m1_subset_1(k6_setfam_1(u1_struct_0(A),B),k1_zfmisc_1(u1_struct_0(A))) ) ) ) ) ).

fof(t40_yellow_2,axiom,
    ! [A] :
      ( ( v4_orders_2(A)
        & v1_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(u1_struct_0(A))))
         => ( ! [C] :
                ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
               => ( r2_hidden(C,B)
                 => ( v12_waybel_0(C,A)
                    & v1_waybel_0(C,A) ) ) )
           => ( v1_waybel_0(k6_setfam_1(u1_struct_0(A),B),A)
              & m1_subset_1(k6_setfam_1(u1_struct_0(A),B),k1_zfmisc_1(u1_struct_0(A))) ) ) ) ) ).

fof(t41_yellow_2,axiom,
    ! [A] :
      ( ( v4_orders_2(A)
        & v2_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,k1_zfmisc_1(k1_zfmisc_1(u1_struct_0(A))))
         => ( ! [C] :
                ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
               => ( r2_hidden(C,B)
                 => ( v13_waybel_0(C,A)
                    & v2_waybel_0(C,A) ) ) )
           => ( v2_waybel_0(k6_setfam_1(u1_struct_0(A),B),A)
              & m1_subset_1(k6_setfam_1(u1_struct_0(A),B),k1_zfmisc_1(u1_struct_0(A))) ) ) ) ) ).

fof(t42_yellow_2,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v2_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v1_xboole_0(B)
            & v1_waybel_0(B,A)
            & v12_waybel_0(B,A)
            & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(A))) )
         => ! [C] :
              ( ( ~ v1_xboole_0(C)
                & v1_waybel_0(C,A)
                & v12_waybel_0(C,A)
                & m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A))) )
             => ( ~ v1_xboole_0(k5_subset_1(u1_struct_0(A),B,C))
                & v1_waybel_0(k5_subset_1(u1_struct_0(A),B,C),A)
                & v12_waybel_0(k5_subset_1(u1_struct_0(A),B,C),A)
                & m1_subset_1(k5_subset_1(u1_struct_0(A),B,C),k1_zfmisc_1(u1_struct_0(A))) ) ) ) ) ).

fof(t43_yellow_2,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(B)
        & v2_orders_2(B)
        & v3_orders_2(B)
        & l1_orders_2(B) )
     => ( m1_subset_1(A,u1_struct_0(k2_yellow_1(k8_waybel_0(B))))
      <=> ( ~ v1_xboole_0(A)
          & v1_waybel_0(A,B)
          & v12_waybel_0(A,B)
          & m1_subset_1(A,k1_zfmisc_1(u1_struct_0(B))) ) ) ) ).

fof(t44_yellow_2,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(B)
        & v2_orders_2(B)
        & v3_orders_2(B)
        & l1_orders_2(B) )
     => ! [C] :
          ( m1_subset_1(C,u1_struct_0(k2_yellow_1(k8_waybel_0(B))))
         => ( r2_hidden(A,C)
           => m1_subset_1(A,u1_struct_0(B)) ) ) ) ).

fof(t45_yellow_2,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v2_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(k2_yellow_1(k8_waybel_0(A))))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(k2_yellow_1(k8_waybel_0(A))))
             => k11_lattice3(k2_yellow_1(k8_waybel_0(A)),B,C) = k3_xboole_0(B,C) ) ) ) ).

fof(t47_yellow_2,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v1_yellow_0(A)
        & v1_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v1_xboole_0(B)
            & m1_subset_1(B,k1_zfmisc_1(k8_waybel_0(A))) )
         => ( ~ v1_xboole_0(k1_setfam_1(B))
            & v1_waybel_0(k1_setfam_1(B),A)
            & v12_waybel_0(k1_setfam_1(B),A)
            & m1_subset_1(k1_setfam_1(B),k1_zfmisc_1(u1_struct_0(A))) ) ) ) ).

fof(t48_yellow_2,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v1_yellow_0(A)
        & v1_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( ~ v1_xboole_0(B)
            & m1_subset_1(B,k1_zfmisc_1(u1_struct_0(k2_yellow_1(k8_waybel_0(A))))) )
         => ( r2_yellow_0(k2_yellow_1(k8_waybel_0(A)),B)
            & k2_yellow_0(k2_yellow_1(k8_waybel_0(A)),B) = k1_setfam_1(B) ) ) ) ).

fof(t49_yellow_2,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v1_lattice3(A)
        & l1_orders_2(A) )
     => ( r2_yellow_0(k2_yellow_1(k8_waybel_0(A)),k1_xboole_0)
        & k2_yellow_0(k2_yellow_1(k8_waybel_0(A)),k1_xboole_0) = k2_pre_topc(A) ) ) ).

fof(t50_yellow_2,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v1_yellow_0(A)
        & v1_lattice3(A)
        & l1_orders_2(A) )
     => v3_lattice3(k2_yellow_1(k8_waybel_0(A))) ) ).

fof(d3_yellow_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,u1_struct_0(k2_yellow_1(k8_waybel_0(A))),u1_struct_0(A))
            & m2_relset_1(B,u1_struct_0(k2_yellow_1(k8_waybel_0(A))),u1_struct_0(A)) )
         => ( B = k3_yellow_2(A)
          <=> ! [C] :
                ( ( ~ v1_xboole_0(C)
                  & v1_waybel_0(C,A)
                  & v12_waybel_0(C,A)
                  & m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A))) )
               => k1_funct_1(B,C) = k1_yellow_0(A,C) ) ) ) ) ).

fof(t51_yellow_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ( k1_relat_1(k3_yellow_2(A)) = k8_waybel_0(A)
        & m1_subset_1(k1_yellow_2(k2_yellow_1(k8_waybel_0(A)),A,k3_yellow_2(A)),k1_zfmisc_1(u1_struct_0(A))) ) ) ).

fof(t52_yellow_2,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(B)
        & v2_orders_2(B)
        & v3_orders_2(B)
        & v4_orders_2(B)
        & l1_orders_2(B) )
     => ( r2_hidden(A,k1_relat_1(k3_yellow_2(B)))
      <=> ( ~ v1_xboole_0(A)
          & v1_waybel_0(A,B)
          & v12_waybel_0(A,B)
          & m1_subset_1(A,k1_zfmisc_1(u1_struct_0(B))) ) ) ) ).

fof(t53_yellow_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v24_waybel_0(A)
        & l1_orders_2(A) )
     => v5_orders_3(k3_yellow_2(A),k2_yellow_1(k8_waybel_0(A)),A) ) ).

fof(d4_yellow_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,u1_struct_0(A),u1_struct_0(k2_yellow_1(k8_waybel_0(A))))
            & m2_relset_1(B,u1_struct_0(A),u1_struct_0(k2_yellow_1(k8_waybel_0(A)))) )
         => ( B = k4_yellow_2(A)
          <=> ! [C] :
                ( m1_subset_1(C,u1_struct_0(A))
               => k1_waybel_0(A,k2_yellow_1(k8_waybel_0(A)),B,C) = k6_waybel_0(A,C) ) ) ) ) ).

fof(t54_yellow_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => v5_orders_3(k4_yellow_2(A),A,k2_yellow_1(k8_waybel_0(A))) ) ).

fof(d5_yellow_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( v1_relat_1(B)
         => k5_yellow_2(A,B) = k1_yellow_0(A,k2_relat_1(B)) ) ) ).

fof(d6_yellow_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( v1_relat_1(B)
         => k6_yellow_2(A,B) = k2_yellow_0(A,k2_relat_1(B)) ) ) ).

fof(t55_yellow_2,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v1_lattice3(A)
        & v2_lattice3(A)
        & v3_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ~ v1_xboole_0(B)
         => ! [C] :
              ( m1_subset_1(C,B)
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,B,u1_struct_0(A))
                    & m2_relset_1(D,B,u1_struct_0(A)) )
                 => ( r3_orders_2(A,k7_yellow_2(B,A,D,C),k5_yellow_2(A,D))
                    & r3_orders_2(A,k6_yellow_2(A,D),k7_yellow_2(B,A,D,C)) ) ) ) ) ) ).

fof(t56_yellow_2,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v1_lattice3(A)
        & v2_lattice3(A)
        & v3_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,C,u1_struct_0(A))
                    & m2_relset_1(D,C,u1_struct_0(A)) )
                 => ( ! [E] :
                        ( m1_subset_1(E,C)
                       => r3_orders_2(A,k7_yellow_2(C,A,D,E),B) )
                   => r3_orders_2(A,k5_yellow_2(A,D),B) ) ) ) ) ) ).

fof(t57_yellow_2,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v1_lattice3(A)
        & v2_lattice3(A)
        & v3_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(A))
         => ! [C] :
              ( ~ v1_xboole_0(C)
             => ! [D] :
                  ( ( v1_funct_1(D)
                    & v1_funct_2(D,C,u1_struct_0(A))
                    & m2_relset_1(D,C,u1_struct_0(A)) )
                 => ( ! [E] :
                        ( m1_subset_1(E,C)
                       => r3_orders_2(A,B,k7_yellow_2(C,A,D,E)) )
                   => r3_orders_2(A,B,k6_yellow_2(A,D)) ) ) ) ) ) ).

fof(dt_k1_yellow_2,axiom,
    ! [A,B,C] :
      ( ( l1_struct_0(A)
        & l1_struct_0(B)
        & v1_funct_1(C)
        & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
        & m1_relset_1(C,u1_struct_0(A),u1_struct_0(B)) )
     => m1_subset_1(k1_yellow_2(A,B,C),k1_zfmisc_1(u1_struct_0(B))) ) ).

fof(redefinition_k1_yellow_2,axiom,
    ! [A,B,C] :
      ( ( l1_struct_0(A)
        & l1_struct_0(B)
        & v1_funct_1(C)
        & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
        & m1_relset_1(C,u1_struct_0(A),u1_struct_0(B)) )
     => k1_yellow_2(A,B,C) = k2_relat_1(C) ) ).

fof(dt_k2_yellow_2,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A)
        & ~ v3_struct_0(B)
        & l1_orders_2(B)
        & v1_funct_1(C)
        & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
        & m1_relset_1(C,u1_struct_0(A),u1_struct_0(B)) )
     => ( v1_orders_2(k2_yellow_2(A,B,C))
        & v4_yellow_0(k2_yellow_2(A,B,C),B)
        & m1_yellow_0(k2_yellow_2(A,B,C),B) ) ) ).

fof(dt_k3_yellow_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ( v1_funct_1(k3_yellow_2(A))
        & v1_funct_2(k3_yellow_2(A),u1_struct_0(k2_yellow_1(k8_waybel_0(A))),u1_struct_0(A))
        & m2_relset_1(k3_yellow_2(A),u1_struct_0(k2_yellow_1(k8_waybel_0(A))),u1_struct_0(A)) ) ) ).

fof(dt_k4_yellow_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A) )
     => ( v1_funct_1(k4_yellow_2(A))
        & v1_funct_2(k4_yellow_2(A),u1_struct_0(A),u1_struct_0(k2_yellow_1(k8_waybel_0(A))))
        & m2_relset_1(k4_yellow_2(A),u1_struct_0(A),u1_struct_0(k2_yellow_1(k8_waybel_0(A)))) ) ) ).

fof(dt_k5_yellow_2,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A)
        & v1_relat_1(B) )
     => m1_subset_1(k5_yellow_2(A,B),u1_struct_0(A)) ) ).

fof(dt_k6_yellow_2,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & l1_orders_2(A)
        & v1_relat_1(B) )
     => m1_subset_1(k6_yellow_2(A,B),u1_struct_0(A)) ) ).

fof(dt_k7_yellow_2,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & ~ v3_struct_0(B)
        & l1_struct_0(B)
        & v1_funct_1(C)
        & v1_funct_2(C,A,u1_struct_0(B))
        & m1_relset_1(C,A,u1_struct_0(B))
        & m1_subset_1(D,A) )
     => m1_subset_1(k7_yellow_2(A,B,C,D),u1_struct_0(B)) ) ).

fof(redefinition_k7_yellow_2,axiom,
    ! [A,B,C,D] :
      ( ( ~ v1_xboole_0(A)
        & ~ v3_struct_0(B)
        & l1_struct_0(B)
        & v1_funct_1(C)
        & v1_funct_2(C,A,u1_struct_0(B))
        & m1_relset_1(C,A,u1_struct_0(B))
        & m1_subset_1(D,A) )
     => k7_yellow_2(A,B,C,D) = k1_funct_1(C,D) ) ).

fof(dt_k8_yellow_2,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(B)
        & l1_struct_0(B)
        & v1_funct_1(C)
        & v1_funct_2(C,A,u1_struct_0(B))
        & m1_relset_1(C,A,u1_struct_0(B)) )
     => m1_subset_1(k8_yellow_2(A,B,C),k1_zfmisc_1(u1_struct_0(B))) ) ).

fof(redefinition_k8_yellow_2,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(B)
        & l1_struct_0(B)
        & v1_funct_1(C)
        & v1_funct_2(C,A,u1_struct_0(B))
        & m1_relset_1(C,A,u1_struct_0(B)) )
     => k8_yellow_2(A,B,C) = k2_relat_1(C) ) ).

fof(t21_yellow_2,axiom,
    ! [A] :
      ( ( ~ v3_struct_0(A)
        & l1_struct_0(A) )
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,u1_struct_0(A),u1_struct_0(A))
            & m2_relset_1(B,u1_struct_0(A),u1_struct_0(A)) )
         => ( v11_quantal1(B)
           => k1_yellow_2(A,A,B) = a_2_0_yellow_2(A,B) ) ) ) ).

fof(t31_yellow_2,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v1_lattice3(A)
        & v2_lattice3(A)
        & v3_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( ( v1_funct_1(B)
            & v1_funct_2(B,u1_struct_0(A),u1_struct_0(A))
            & m2_relset_1(B,u1_struct_0(A),u1_struct_0(A)) )
         => ( v5_orders_3(B,A,A)
           => ! [C] :
                ( m1_subset_1(C,k1_zfmisc_1(u1_struct_0(A)))
               => ( C = a_2_1_yellow_2(A,B)
                 => ( v2_orders_2(k5_yellow_0(A,C))
                    & v3_orders_2(k5_yellow_0(A,C))
                    & v4_orders_2(k5_yellow_0(A,C))
                    & v1_lattice3(k5_yellow_0(A,C))
                    & v2_lattice3(k5_yellow_0(A,C))
                    & v3_lattice3(k5_yellow_0(A,C))
                    & l1_orders_2(k5_yellow_0(A,C)) ) ) ) ) ) ) ).

fof(t46_yellow_2,axiom,
    ! [A] :
      ( ( v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & v1_lattice3(A)
        & l1_orders_2(A) )
     => ! [B] :
          ( m1_subset_1(B,u1_struct_0(k2_yellow_1(k8_waybel_0(A))))
         => ! [C] :
              ( m1_subset_1(C,u1_struct_0(k2_yellow_1(k8_waybel_0(A))))
             => ? [D] :
                  ( m1_subset_1(D,k1_zfmisc_1(u1_struct_0(A)))
                  & D = a_3_0_yellow_2(A,B,C)
                  & r1_yellow_0(k2_yellow_1(k8_waybel_0(A)),k2_struct_0(k2_yellow_1(k8_waybel_0(A)),B,C))
                  & k10_lattice3(k2_yellow_1(k8_waybel_0(A)),B,C) = k4_waybel_0(A,D) ) ) ) ) ).

fof(fraenkel_a_2_0_yellow_2,axiom,
    ! [A,B,C] :
      ( ( ~ v3_struct_0(B)
        & l1_struct_0(B)
        & v1_funct_1(C)
        & v1_funct_2(C,u1_struct_0(B),u1_struct_0(B))
        & m2_relset_1(C,u1_struct_0(B),u1_struct_0(B)) )
     => ( r2_hidden(A,a_2_0_yellow_2(B,C))
      <=> ? [D] :
            ( m1_subset_1(D,u1_struct_0(B))
            & A = D
            & D = k1_waybel_0(B,B,C,D) ) ) ) ).

fof(fraenkel_a_2_1_yellow_2,axiom,
    ! [A,B,C] :
      ( ( v2_orders_2(B)
        & v3_orders_2(B)
        & v4_orders_2(B)
        & v1_lattice3(B)
        & v2_lattice3(B)
        & v3_lattice3(B)
        & l1_orders_2(B)
        & v1_funct_1(C)
        & v1_funct_2(C,u1_struct_0(B),u1_struct_0(B))
        & m2_relset_1(C,u1_struct_0(B),u1_struct_0(B)) )
     => ( r2_hidden(A,a_2_1_yellow_2(B,C))
      <=> ? [D] :
            ( m1_subset_1(D,u1_struct_0(B))
            & A = D
            & D = k1_waybel_0(B,B,C,D) ) ) ) ).

fof(fraenkel_a_3_0_yellow_2,axiom,
    ! [A,B,C,D] :
      ( ( v2_orders_2(B)
        & v3_orders_2(B)
        & v4_orders_2(B)
        & v1_lattice3(B)
        & l1_orders_2(B)
        & m1_subset_1(C,u1_struct_0(k2_yellow_1(k8_waybel_0(B))))
        & m1_subset_1(D,u1_struct_0(k2_yellow_1(k8_waybel_0(B)))) )
     => ( r2_hidden(A,a_3_0_yellow_2(B,C,D))
      <=> ? [E] :
            ( m1_subset_1(E,u1_struct_0(B))
            & A = E
            & ~ ( ~ r2_hidden(E,C)
                & ~ r2_hidden(E,D)
                & ! [F] :
                    ( m1_subset_1(F,u1_struct_0(B))
                   => ! [G] :
                        ( m1_subset_1(G,u1_struct_0(B))
                       => ~ ( r2_hidden(F,C)
                            & r2_hidden(G,D)
                            & E = k13_lattice3(B,F,G) ) ) ) ) ) ) ) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(fc1_waybel_1,axiom,
    ! [A] :
      ( ~ v3_struct_0(k3_yellow_1(A))
      & v1_orders_2(k3_yellow_1(A))
      & v2_orders_2(k3_yellow_1(A))
      & v3_orders_2(k3_yellow_1(A))
      & v4_orders_2(k3_yellow_1(A))
      & v1_lattice3(k3_yellow_1(A))
      & v2_lattice3(k3_yellow_1(A))
      & v3_lattice3(k3_yellow_1(A))
      & v1_yellow_0(k3_yellow_1(A))
      & v2_yellow_0(k3_yellow_1(A))
      & v3_yellow_0(k3_yellow_1(A))
      & v24_waybel_0(k3_yellow_1(A))
      & v25_waybel_0(k3_yellow_1(A))
      & v2_waybel_1(k3_yellow_1(A)) ) ).

fof(fc2_waybel_1,axiom,
    ! [A] :
      ( l1_orders_2(A)
     => ( v1_relat_1(k7_grcat_1(A))
        & v1_funct_1(k7_grcat_1(A))
        & v1_funct_2(k7_grcat_1(A),u1_struct_0(A),u1_struct_0(A))
        & v23_waybel_0(k7_grcat_1(A),A,A) ) ) ).

fof(cc1_waybel_1,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & v4_orders_2(A)
        & l1_orders_2(A)
        & ~ v3_struct_0(B)
        & v2_orders_2(B)
        & v3_orders_2(B)
        & v4_orders_2(B)
        & l1_orders_2(B) )
     => ! [C] :
          ( m1_relset_1(C,u1_struct_0(A),u1_struct_0(B))
         => ( ( v1_funct_1(C)
              & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
              & v4_waybel_1(C,A,B) )
           => ( v1_funct_1(C)
              & ~ v1_xboole_0(C)
              & v1_funct_2(C,u1_struct_0(A),u1_struct_0(B))
              & v1_partfun1(C,u1_struct_0(A),u1_struct_0(B))
              & v17_waybel_0(C,A,B)
              & v19_waybel_0(C,A,B)
              & v21_waybel_0(C,A,B) ) ) ) ) ).

fof(cc2_waybel_1,axiom,
    ! [A,B] :
      ( ( ~ v3_struct_0(A)
        & v2_orders_2(A)
        & v3_orders_2(A)
        & 